# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTransportCellularControllerFeatureResult',
    'AwaitableGetTransportCellularControllerFeatureResult',
    'get_transport_cellular_controller_feature',
    'get_transport_cellular_controller_feature_output',
]

@pulumi.output_type
class GetTransportCellularControllerFeatureResult:
    """
    A collection of values returned by getTransportCellularControllerFeature.
    """
    def __init__(__self__, cellular_id=None, cellular_id_variable=None, description=None, feature_profile_id=None, firmware_auto_sim=None, firmware_auto_sim_variable=None, id=None, name=None, primary_sim_slot=None, primary_sim_slot_variable=None, sim_failover_retries=None, sim_failover_retries_variable=None, sim_failover_timeout=None, sim_failover_timeout_variable=None, version=None):
        if cellular_id and not isinstance(cellular_id, str):
            raise TypeError("Expected argument 'cellular_id' to be a str")
        pulumi.set(__self__, "cellular_id", cellular_id)
        if cellular_id_variable and not isinstance(cellular_id_variable, str):
            raise TypeError("Expected argument 'cellular_id_variable' to be a str")
        pulumi.set(__self__, "cellular_id_variable", cellular_id_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if firmware_auto_sim and not isinstance(firmware_auto_sim, bool):
            raise TypeError("Expected argument 'firmware_auto_sim' to be a bool")
        pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable and not isinstance(firmware_auto_sim_variable, str):
            raise TypeError("Expected argument 'firmware_auto_sim_variable' to be a str")
        pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_sim_slot and not isinstance(primary_sim_slot, int):
            raise TypeError("Expected argument 'primary_sim_slot' to be a int")
        pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable and not isinstance(primary_sim_slot_variable, str):
            raise TypeError("Expected argument 'primary_sim_slot_variable' to be a str")
        pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries and not isinstance(sim_failover_retries, int):
            raise TypeError("Expected argument 'sim_failover_retries' to be a int")
        pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable and not isinstance(sim_failover_retries_variable, str):
            raise TypeError("Expected argument 'sim_failover_retries_variable' to be a str")
        pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout and not isinstance(sim_failover_timeout, int):
            raise TypeError("Expected argument 'sim_failover_timeout' to be a int")
        pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable and not isinstance(sim_failover_timeout_variable, str):
            raise TypeError("Expected argument 'sim_failover_timeout_variable' to be a str")
        pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cellularId")
    def cellular_id(self) -> builtins.str:
        """
        Cellular ID
        """
        return pulumi.get(self, "cellular_id")

    @property
    @pulumi.getter(name="cellularIdVariable")
    def cellular_id_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_id_variable")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> builtins.bool:
        """
        Enable/Disable Firmware Auto Sim
        """
        return pulumi.get(self, "firmware_auto_sim")

    @property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> builtins.int:
        """
        Set primary SIM slot
        """
        return pulumi.get(self, "primary_sim_slot")

    @property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> builtins.int:
        """
        Set SIM failover retries
        """
        return pulumi.get(self, "sim_failover_retries")

    @property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> builtins.int:
        """
        Set SIM failover timeout in minutes
        """
        return pulumi.get(self, "sim_failover_timeout")

    @property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetTransportCellularControllerFeatureResult(GetTransportCellularControllerFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransportCellularControllerFeatureResult(
            cellular_id=self.cellular_id,
            cellular_id_variable=self.cellular_id_variable,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            firmware_auto_sim=self.firmware_auto_sim,
            firmware_auto_sim_variable=self.firmware_auto_sim_variable,
            id=self.id,
            name=self.name,
            primary_sim_slot=self.primary_sim_slot,
            primary_sim_slot_variable=self.primary_sim_slot_variable,
            sim_failover_retries=self.sim_failover_retries,
            sim_failover_retries_variable=self.sim_failover_retries_variable,
            sim_failover_timeout=self.sim_failover_timeout,
            sim_failover_timeout_variable=self.sim_failover_timeout_variable,
            version=self.version)


def get_transport_cellular_controller_feature(feature_profile_id: Optional[builtins.str] = None,
                                              id: Optional[builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransportCellularControllerFeatureResult:
    """
    This data source can read the Transport Cellular Controller Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_cellular_controller_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getTransportCellularControllerFeature:getTransportCellularControllerFeature', __args__, opts=opts, typ=GetTransportCellularControllerFeatureResult).value

    return AwaitableGetTransportCellularControllerFeatureResult(
        cellular_id=pulumi.get(__ret__, 'cellular_id'),
        cellular_id_variable=pulumi.get(__ret__, 'cellular_id_variable'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        firmware_auto_sim=pulumi.get(__ret__, 'firmware_auto_sim'),
        firmware_auto_sim_variable=pulumi.get(__ret__, 'firmware_auto_sim_variable'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        primary_sim_slot=pulumi.get(__ret__, 'primary_sim_slot'),
        primary_sim_slot_variable=pulumi.get(__ret__, 'primary_sim_slot_variable'),
        sim_failover_retries=pulumi.get(__ret__, 'sim_failover_retries'),
        sim_failover_retries_variable=pulumi.get(__ret__, 'sim_failover_retries_variable'),
        sim_failover_timeout=pulumi.get(__ret__, 'sim_failover_timeout'),
        sim_failover_timeout_variable=pulumi.get(__ret__, 'sim_failover_timeout_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_transport_cellular_controller_feature_output(feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     id: Optional[pulumi.Input[builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransportCellularControllerFeatureResult]:
    """
    This data source can read the Transport Cellular Controller Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_cellular_controller_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getTransportCellularControllerFeature:getTransportCellularControllerFeature', __args__, opts=opts, typ=GetTransportCellularControllerFeatureResult)
    return __ret__.apply(lambda __response__: GetTransportCellularControllerFeatureResult(
        cellular_id=pulumi.get(__response__, 'cellular_id'),
        cellular_id_variable=pulumi.get(__response__, 'cellular_id_variable'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        firmware_auto_sim=pulumi.get(__response__, 'firmware_auto_sim'),
        firmware_auto_sim_variable=pulumi.get(__response__, 'firmware_auto_sim_variable'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        primary_sim_slot=pulumi.get(__response__, 'primary_sim_slot'),
        primary_sim_slot_variable=pulumi.get(__response__, 'primary_sim_slot_variable'),
        sim_failover_retries=pulumi.get(__response__, 'sim_failover_retries'),
        sim_failover_retries_variable=pulumi.get(__response__, 'sim_failover_retries_variable'),
        sim_failover_timeout=pulumi.get(__response__, 'sim_failover_timeout'),
        sim_failover_timeout_variable=pulumi.get(__response__, 'sim_failover_timeout_variable'),
        version=pulumi.get(__response__, 'version')))
