# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceObjectTrackerFeatureArgs', 'ServiceObjectTrackerFeature']

@pulumi.input_type
class ServiceObjectTrackerFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 object_tracker_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 vpn_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceObjectTrackerFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] object_tracker_type: objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] interface: interface name
        :param pulumi.Input[builtins.str] interface_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object tracker ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] route_ip: IP address
        :param pulumi.Input[builtins.str] route_ip_variable: Variable name
        :param pulumi.Input[builtins.str] route_mask: IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        :param pulumi.Input[builtins.str] route_mask_variable: Variable name
        :param pulumi.Input[builtins.int] vpn: VPN - Range: `0`-`65530`
        :param pulumi.Input[builtins.str] vpn_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "object_tracker_type", object_tracker_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if interface_variable is not None:
            pulumi.set(__self__, "interface_variable", interface_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_tracker_id is not None:
            pulumi.set(__self__, "object_tracker_id", object_tracker_id)
        if object_tracker_id_variable is not None:
            pulumi.set(__self__, "object_tracker_id_variable", object_tracker_id_variable)
        if route_ip is not None:
            pulumi.set(__self__, "route_ip", route_ip)
        if route_ip_variable is not None:
            pulumi.set(__self__, "route_ip_variable", route_ip_variable)
        if route_mask is not None:
            pulumi.set(__self__, "route_mask", route_mask)
        if route_mask_variable is not None:
            pulumi.set(__self__, "route_mask_variable", route_mask_variable)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)
        if vpn_variable is not None:
            pulumi.set(__self__, "vpn_variable", vpn_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="objectTrackerType")
    def object_tracker_type(self) -> pulumi.Input[builtins.str]:
        """
        objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        """
        return pulumi.get(self, "object_tracker_type")

    @object_tracker_type.setter
    def object_tracker_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_tracker_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        interface name
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="interfaceVariable")
    def interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_variable")

    @interface_variable.setter
    def interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Object tracker ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @object_tracker_id.setter
    def object_tracker_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_tracker_id", value)

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @object_tracker_id_variable.setter
    def object_tracker_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tracker_id_variable", value)

    @property
    @pulumi.getter(name="routeIp")
    def route_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address
        """
        return pulumi.get(self, "route_ip")

    @route_ip.setter
    def route_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_ip", value)

    @property
    @pulumi.getter(name="routeIpVariable")
    def route_ip_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_ip_variable")

    @route_ip_variable.setter
    def route_ip_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_ip_variable", value)

    @property
    @pulumi.getter(name="routeMask")
    def route_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "route_mask")

    @route_mask.setter
    def route_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_mask", value)

    @property
    @pulumi.getter(name="routeMaskVariable")
    def route_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_mask_variable")

    @route_mask_variable.setter
    def route_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_mask_variable", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VPN - Range: `0`-`65530`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vpn", value)

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

    @vpn_variable.setter
    def vpn_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_variable", value)


@pulumi.input_type
class _ServiceObjectTrackerFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 vpn_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceObjectTrackerFeature resources.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface: interface name
        :param pulumi.Input[builtins.str] interface_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object tracker ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] object_tracker_type: objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        :param pulumi.Input[builtins.str] route_ip: IP address
        :param pulumi.Input[builtins.str] route_ip_variable: Variable name
        :param pulumi.Input[builtins.str] route_mask: IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        :param pulumi.Input[builtins.str] route_mask_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[builtins.int] vpn: VPN - Range: `0`-`65530`
        :param pulumi.Input[builtins.str] vpn_variable: Variable name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if interface_variable is not None:
            pulumi.set(__self__, "interface_variable", interface_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_tracker_id is not None:
            pulumi.set(__self__, "object_tracker_id", object_tracker_id)
        if object_tracker_id_variable is not None:
            pulumi.set(__self__, "object_tracker_id_variable", object_tracker_id_variable)
        if object_tracker_type is not None:
            pulumi.set(__self__, "object_tracker_type", object_tracker_type)
        if route_ip is not None:
            pulumi.set(__self__, "route_ip", route_ip)
        if route_ip_variable is not None:
            pulumi.set(__self__, "route_ip_variable", route_ip_variable)
        if route_mask is not None:
            pulumi.set(__self__, "route_mask", route_mask)
        if route_mask_variable is not None:
            pulumi.set(__self__, "route_mask_variable", route_mask_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)
        if vpn_variable is not None:
            pulumi.set(__self__, "vpn_variable", vpn_variable)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        interface name
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="interfaceVariable")
    def interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_variable")

    @interface_variable.setter
    def interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Object tracker ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @object_tracker_id.setter
    def object_tracker_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_tracker_id", value)

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @object_tracker_id_variable.setter
    def object_tracker_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tracker_id_variable", value)

    @property
    @pulumi.getter(name="objectTrackerType")
    def object_tracker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        """
        return pulumi.get(self, "object_tracker_type")

    @object_tracker_type.setter
    def object_tracker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tracker_type", value)

    @property
    @pulumi.getter(name="routeIp")
    def route_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address
        """
        return pulumi.get(self, "route_ip")

    @route_ip.setter
    def route_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_ip", value)

    @property
    @pulumi.getter(name="routeIpVariable")
    def route_ip_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_ip_variable")

    @route_ip_variable.setter
    def route_ip_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_ip_variable", value)

    @property
    @pulumi.getter(name="routeMask")
    def route_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "route_mask")

    @route_mask.setter
    def route_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_mask", value)

    @property
    @pulumi.getter(name="routeMaskVariable")
    def route_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_mask_variable")

    @route_mask_variable.setter
    def route_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_mask_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VPN - Range: `0`-`65530`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vpn", value)

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

    @vpn_variable.setter
    def vpn_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_variable", value)


@pulumi.type_token("sdwan:index/serviceObjectTrackerFeature:ServiceObjectTrackerFeature")
class ServiceObjectTrackerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 vpn_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service Object Tracker Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ServiceObjectTrackerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            object_tracker_id=10,
            object_tracker_type="Interface",
            interface="GigabitEthernet1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_object_tracker_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceObjectTrackerFeature:ServiceObjectTrackerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface: interface name
        :param pulumi.Input[builtins.str] interface_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object tracker ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] object_tracker_type: objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        :param pulumi.Input[builtins.str] route_ip: IP address
        :param pulumi.Input[builtins.str] route_ip_variable: Variable name
        :param pulumi.Input[builtins.str] route_mask: IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        :param pulumi.Input[builtins.str] route_mask_variable: Variable name
        :param pulumi.Input[builtins.int] vpn: VPN - Range: `0`-`65530`
        :param pulumi.Input[builtins.str] vpn_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceObjectTrackerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Object Tracker Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ServiceObjectTrackerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            object_tracker_id=10,
            object_tracker_type="Interface",
            interface="GigabitEthernet1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_object_tracker_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceObjectTrackerFeature:ServiceObjectTrackerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceObjectTrackerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceObjectTrackerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface: Optional[pulumi.Input[builtins.str]] = None,
                 interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip: Optional[pulumi.Input[builtins.str]] = None,
                 route_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask: Optional[pulumi.Input[builtins.str]] = None,
                 route_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 vpn: Optional[pulumi.Input[builtins.int]] = None,
                 vpn_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceObjectTrackerFeatureArgs.__new__(ServiceObjectTrackerFeatureArgs)

            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interface"] = interface
            __props__.__dict__["interface_variable"] = interface_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["object_tracker_id"] = object_tracker_id
            __props__.__dict__["object_tracker_id_variable"] = object_tracker_id_variable
            if object_tracker_type is None and not opts.urn:
                raise TypeError("Missing required property 'object_tracker_type'")
            __props__.__dict__["object_tracker_type"] = object_tracker_type
            __props__.__dict__["route_ip"] = route_ip
            __props__.__dict__["route_ip_variable"] = route_ip_variable
            __props__.__dict__["route_mask"] = route_mask
            __props__.__dict__["route_mask_variable"] = route_mask_variable
            __props__.__dict__["vpn"] = vpn
            __props__.__dict__["vpn_variable"] = vpn_variable
            __props__.__dict__["version"] = None
        super(ServiceObjectTrackerFeature, __self__).__init__(
            'sdwan:index/serviceObjectTrackerFeature:ServiceObjectTrackerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            interface: Optional[pulumi.Input[builtins.str]] = None,
            interface_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
            object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            object_tracker_type: Optional[pulumi.Input[builtins.str]] = None,
            route_ip: Optional[pulumi.Input[builtins.str]] = None,
            route_ip_variable: Optional[pulumi.Input[builtins.str]] = None,
            route_mask: Optional[pulumi.Input[builtins.str]] = None,
            route_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            vpn: Optional[pulumi.Input[builtins.int]] = None,
            vpn_variable: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceObjectTrackerFeature':
        """
        Get an existing ServiceObjectTrackerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface: interface name
        :param pulumi.Input[builtins.str] interface_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object tracker ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] object_tracker_type: objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        :param pulumi.Input[builtins.str] route_ip: IP address
        :param pulumi.Input[builtins.str] route_ip_variable: Variable name
        :param pulumi.Input[builtins.str] route_mask: IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        :param pulumi.Input[builtins.str] route_mask_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[builtins.int] vpn: VPN - Range: `0`-`65530`
        :param pulumi.Input[builtins.str] vpn_variable: Variable name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceObjectTrackerFeatureState.__new__(_ServiceObjectTrackerFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interface"] = interface
        __props__.__dict__["interface_variable"] = interface_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["object_tracker_id"] = object_tracker_id
        __props__.__dict__["object_tracker_id_variable"] = object_tracker_id_variable
        __props__.__dict__["object_tracker_type"] = object_tracker_type
        __props__.__dict__["route_ip"] = route_ip
        __props__.__dict__["route_ip_variable"] = route_ip_variable
        __props__.__dict__["route_mask"] = route_mask
        __props__.__dict__["route_mask_variable"] = route_mask_variable
        __props__.__dict__["version"] = version
        __props__.__dict__["vpn"] = vpn
        __props__.__dict__["vpn_variable"] = vpn_variable
        return ServiceObjectTrackerFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        interface name
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="interfaceVariable")
    def interface_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Object tracker ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @property
    @pulumi.getter(name="objectTrackerType")
    def object_tracker_type(self) -> pulumi.Output[builtins.str]:
        """
        objectTrackerType:Interface SIG Route - Choices: `Interface`, `SIG`, `Route`
        """
        return pulumi.get(self, "object_tracker_type")

    @property
    @pulumi.getter(name="routeIp")
    def route_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP address
        """
        return pulumi.get(self, "route_ip")

    @property
    @pulumi.getter(name="routeIpVariable")
    def route_ip_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_ip_variable")

    @property
    @pulumi.getter(name="routeMask")
    def route_mask(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0` - Default value: `0.0.0.0`
        """
        return pulumi.get(self, "route_mask")

    @property
    @pulumi.getter(name="routeMaskVariable")
    def route_mask_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "route_mask_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vpn(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        VPN - Range: `0`-`65530`
        """
        return pulumi.get(self, "vpn")

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

