# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceObjectTrackerGroupFeatureArgs', 'ServiceObjectTrackerGroupFeature']

@pulumi.input_type
class ServiceObjectTrackerGroupFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_elements: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceObjectTrackerGroupFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] reachable: tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        :param pulumi.Input[builtins.str] reachable_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]] tracker_elements: Group Tracks ID Refs
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_tracker_id is not None:
            pulumi.set(__self__, "object_tracker_id", object_tracker_id)
        if object_tracker_id_variable is not None:
            pulumi.set(__self__, "object_tracker_id_variable", object_tracker_id_variable)
        if reachable is not None:
            pulumi.set(__self__, "reachable", reachable)
        if reachable_variable is not None:
            pulumi.set(__self__, "reachable_variable", reachable_variable)
        if tracker_elements is not None:
            pulumi.set(__self__, "tracker_elements", tracker_elements)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Object ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @object_tracker_id.setter
    def object_tracker_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_tracker_id", value)

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @object_tracker_id_variable.setter
    def object_tracker_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tracker_id_variable", value)

    @property
    @pulumi.getter
    def reachable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        """
        return pulumi.get(self, "reachable")

    @reachable.setter
    def reachable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reachable", value)

    @property
    @pulumi.getter(name="reachableVariable")
    def reachable_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "reachable_variable")

    @reachable_variable.setter
    def reachable_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reachable_variable", value)

    @property
    @pulumi.getter(name="trackerElements")
    def tracker_elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]]:
        """
        Group Tracks ID Refs
        """
        return pulumi.get(self, "tracker_elements")

    @tracker_elements.setter
    def tracker_elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]]):
        pulumi.set(self, "tracker_elements", value)


@pulumi.input_type
class _ServiceObjectTrackerGroupFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_elements: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceObjectTrackerGroupFeature resources.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] reachable: tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        :param pulumi.Input[builtins.str] reachable_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]] tracker_elements: Group Tracks ID Refs
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_tracker_id is not None:
            pulumi.set(__self__, "object_tracker_id", object_tracker_id)
        if object_tracker_id_variable is not None:
            pulumi.set(__self__, "object_tracker_id_variable", object_tracker_id_variable)
        if reachable is not None:
            pulumi.set(__self__, "reachable", reachable)
        if reachable_variable is not None:
            pulumi.set(__self__, "reachable_variable", reachable_variable)
        if tracker_elements is not None:
            pulumi.set(__self__, "tracker_elements", tracker_elements)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Object ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @object_tracker_id.setter
    def object_tracker_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_tracker_id", value)

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @object_tracker_id_variable.setter
    def object_tracker_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tracker_id_variable", value)

    @property
    @pulumi.getter
    def reachable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        """
        return pulumi.get(self, "reachable")

    @reachable.setter
    def reachable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reachable", value)

    @property
    @pulumi.getter(name="reachableVariable")
    def reachable_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "reachable_variable")

    @reachable_variable.setter
    def reachable_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reachable_variable", value)

    @property
    @pulumi.getter(name="trackerElements")
    def tracker_elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]]:
        """
        Group Tracks ID Refs
        """
        return pulumi.get(self, "tracker_elements")

    @tracker_elements.setter
    def tracker_elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceObjectTrackerGroupFeatureTrackerElementArgs']]]]):
        pulumi.set(self, "tracker_elements", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/serviceObjectTrackerGroupFeature:ServiceObjectTrackerGroupFeature")
class ServiceObjectTrackerGroupFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceObjectTrackerGroupFeatureTrackerElementArgs', 'ServiceObjectTrackerGroupFeatureTrackerElementArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Service Object Tracker Group Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_object_tracker_group_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceObjectTrackerGroupFeature:ServiceObjectTrackerGroupFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] reachable: tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        :param pulumi.Input[builtins.str] reachable_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceObjectTrackerGroupFeatureTrackerElementArgs', 'ServiceObjectTrackerGroupFeatureTrackerElementArgsDict']]]] tracker_elements: Group Tracks ID Refs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceObjectTrackerGroupFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Object Tracker Group Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_object_tracker_group_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceObjectTrackerGroupFeature:ServiceObjectTrackerGroupFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceObjectTrackerGroupFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceObjectTrackerGroupFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
                 object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable: Optional[pulumi.Input[builtins.str]] = None,
                 reachable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceObjectTrackerGroupFeatureTrackerElementArgs', 'ServiceObjectTrackerGroupFeatureTrackerElementArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceObjectTrackerGroupFeatureArgs.__new__(ServiceObjectTrackerGroupFeatureArgs)

            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["object_tracker_id"] = object_tracker_id
            __props__.__dict__["object_tracker_id_variable"] = object_tracker_id_variable
            __props__.__dict__["reachable"] = reachable
            __props__.__dict__["reachable_variable"] = reachable_variable
            __props__.__dict__["tracker_elements"] = tracker_elements
            __props__.__dict__["version"] = None
        super(ServiceObjectTrackerGroupFeature, __self__).__init__(
            'sdwan:index/serviceObjectTrackerGroupFeature:ServiceObjectTrackerGroupFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            object_tracker_id: Optional[pulumi.Input[builtins.int]] = None,
            object_tracker_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            reachable: Optional[pulumi.Input[builtins.str]] = None,
            reachable_variable: Optional[pulumi.Input[builtins.str]] = None,
            tracker_elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceObjectTrackerGroupFeatureTrackerElementArgs', 'ServiceObjectTrackerGroupFeatureTrackerElementArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceObjectTrackerGroupFeature':
        """
        Get an existing ServiceObjectTrackerGroupFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] object_tracker_id: Object ID - Range: `1`-`1000`
        :param pulumi.Input[builtins.str] object_tracker_id_variable: Variable name
        :param pulumi.Input[builtins.str] reachable: tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        :param pulumi.Input[builtins.str] reachable_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceObjectTrackerGroupFeatureTrackerElementArgs', 'ServiceObjectTrackerGroupFeatureTrackerElementArgsDict']]]] tracker_elements: Group Tracks ID Refs
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceObjectTrackerGroupFeatureState.__new__(_ServiceObjectTrackerGroupFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["object_tracker_id"] = object_tracker_id
        __props__.__dict__["object_tracker_id_variable"] = object_tracker_id_variable
        __props__.__dict__["reachable"] = reachable
        __props__.__dict__["reachable_variable"] = reachable_variable
        __props__.__dict__["tracker_elements"] = tracker_elements
        __props__.__dict__["version"] = version
        return ServiceObjectTrackerGroupFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTrackerId")
    def object_tracker_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Object ID - Range: `1`-`1000`
        """
        return pulumi.get(self, "object_tracker_id")

    @property
    @pulumi.getter(name="objectTrackerIdVariable")
    def object_tracker_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "object_tracker_id_variable")

    @property
    @pulumi.getter
    def reachable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        tracker ref list criteria boolean and or - Choices: `and`, `or` - Default value: `or`
        """
        return pulumi.get(self, "reachable")

    @property
    @pulumi.getter(name="reachableVariable")
    def reachable_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "reachable_variable")

    @property
    @pulumi.getter(name="trackerElements")
    def tracker_elements(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceObjectTrackerGroupFeatureTrackerElement']]]:
        """
        Group Tracks ID Refs
        """
        return pulumi.get(self, "tracker_elements")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

