# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemSnmpFeatureArgs', 'SystemSnmpFeature']

@pulumi.input_type
class SystemSnmpFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]] = None,
                 contact_person: Optional[pulumi.Input[builtins.str]] = None,
                 contact_person_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]] = None,
                 location_of_device: Optional[pulumi.Input[builtins.str]] = None,
                 location_of_device_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_target_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]] = None):
        """
        The set of arguments for constructing a SystemSnmpFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact_person: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_person_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location_of_device: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_of_device_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]] trap_target_servers: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]] users: Configure an SNMP user
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]] views: Configure a view record
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if communities is not None:
            pulumi.set(__self__, "communities", communities)
        if contact_person is not None:
            pulumi.set(__self__, "contact_person", contact_person)
        if contact_person_variable is not None:
            pulumi.set(__self__, "contact_person_variable", contact_person_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if location_of_device is not None:
            pulumi.set(__self__, "location_of_device", location_of_device)
        if location_of_device_variable is not None:
            pulumi.set(__self__, "location_of_device_variable", location_of_device_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if trap_target_servers is not None:
            pulumi.set(__self__, "trap_target_servers", trap_target_servers)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if views is not None:
            pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def communities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter(name="contactPerson")
    def contact_person(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact_person")

    @contact_person.setter
    def contact_person(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_person", value)

    @property
    @pulumi.getter(name="contactPersonVariable")
    def contact_person_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_person_variable")

    @contact_person_variable.setter
    def contact_person_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_person_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="locationOfDevice")
    def location_of_device(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location_of_device")

    @location_of_device.setter
    def location_of_device(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_of_device", value)

    @property
    @pulumi.getter(name="locationOfDeviceVariable")
    def location_of_device_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_of_device_variable")

    @location_of_device_variable.setter
    def location_of_device_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_of_device_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="trapTargetServers")
    def trap_target_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_target_servers")

    @trap_target_servers.setter
    def trap_target_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]]):
        pulumi.set(self, "trap_target_servers", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]]):
        pulumi.set(self, "views", value)


@pulumi.input_type
class _SystemSnmpFeatureState:
    def __init__(__self__, *,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]] = None,
                 contact_person: Optional[pulumi.Input[builtins.str]] = None,
                 contact_person_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]] = None,
                 location_of_device: Optional[pulumi.Input[builtins.str]] = None,
                 location_of_device_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_target_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]] = None):
        """
        Input properties used for looking up and filtering SystemSnmpFeature resources.
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact_person: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_person_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location_of_device: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_of_device_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]] trap_target_servers: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]] users: Configure an SNMP user
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]] views: Configure a view record
        """
        if communities is not None:
            pulumi.set(__self__, "communities", communities)
        if contact_person is not None:
            pulumi.set(__self__, "contact_person", contact_person)
        if contact_person_variable is not None:
            pulumi.set(__self__, "contact_person_variable", contact_person_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if location_of_device is not None:
            pulumi.set(__self__, "location_of_device", location_of_device)
        if location_of_device_variable is not None:
            pulumi.set(__self__, "location_of_device_variable", location_of_device_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if trap_target_servers is not None:
            pulumi.set(__self__, "trap_target_servers", trap_target_servers)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if views is not None:
            pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def communities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureCommunityArgs']]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter(name="contactPerson")
    def contact_person(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact_person")

    @contact_person.setter
    def contact_person(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_person", value)

    @property
    @pulumi.getter(name="contactPersonVariable")
    def contact_person_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_person_variable")

    @contact_person_variable.setter
    def contact_person_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_person_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="locationOfDevice")
    def location_of_device(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location_of_device")

    @location_of_device.setter
    def location_of_device(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_of_device", value)

    @property
    @pulumi.getter(name="locationOfDeviceVariable")
    def location_of_device_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_of_device_variable")

    @location_of_device_variable.setter
    def location_of_device_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_of_device_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="trapTargetServers")
    def trap_target_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_target_servers")

    @trap_target_servers.setter
    def trap_target_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureTrapTargetServerArgs']]]]):
        pulumi.set(self, "trap_target_servers", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSnmpFeatureViewArgs']]]]):
        pulumi.set(self, "views", value)


@pulumi.type_token("sdwan:index/systemSnmpFeature:SystemSnmpFeature")
class SystemSnmpFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureCommunityArgs', 'SystemSnmpFeatureCommunityArgsDict']]]]] = None,
                 contact_person: Optional[pulumi.Input[builtins.str]] = None,
                 contact_person_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureGroupArgs', 'SystemSnmpFeatureGroupArgsDict']]]]] = None,
                 location_of_device: Optional[pulumi.Input[builtins.str]] = None,
                 location_of_device_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_target_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureTrapTargetServerArgs', 'SystemSnmpFeatureTrapTargetServerArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureUserArgs', 'SystemSnmpFeatureUserArgsDict']]]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureViewArgs', 'SystemSnmpFeatureViewArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a System SNMP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "system_snmp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemSnmpFeature:SystemSnmpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureCommunityArgs', 'SystemSnmpFeatureCommunityArgsDict']]]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact_person: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_person_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureGroupArgs', 'SystemSnmpFeatureGroupArgsDict']]]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location_of_device: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_of_device_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureTrapTargetServerArgs', 'SystemSnmpFeatureTrapTargetServerArgsDict']]]] trap_target_servers: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureUserArgs', 'SystemSnmpFeatureUserArgsDict']]]] users: Configure an SNMP user
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureViewArgs', 'SystemSnmpFeatureViewArgsDict']]]] views: Configure a view record
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemSnmpFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System SNMP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "system_snmp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemSnmpFeature:SystemSnmpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemSnmpFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemSnmpFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureCommunityArgs', 'SystemSnmpFeatureCommunityArgsDict']]]]] = None,
                 contact_person: Optional[pulumi.Input[builtins.str]] = None,
                 contact_person_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureGroupArgs', 'SystemSnmpFeatureGroupArgsDict']]]]] = None,
                 location_of_device: Optional[pulumi.Input[builtins.str]] = None,
                 location_of_device_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 trap_target_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureTrapTargetServerArgs', 'SystemSnmpFeatureTrapTargetServerArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureUserArgs', 'SystemSnmpFeatureUserArgsDict']]]]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureViewArgs', 'SystemSnmpFeatureViewArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemSnmpFeatureArgs.__new__(SystemSnmpFeatureArgs)

            __props__.__dict__["communities"] = communities
            __props__.__dict__["contact_person"] = contact_person
            __props__.__dict__["contact_person_variable"] = contact_person_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["groups"] = groups
            __props__.__dict__["location_of_device"] = location_of_device
            __props__.__dict__["location_of_device_variable"] = location_of_device_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["trap_target_servers"] = trap_target_servers
            __props__.__dict__["users"] = users
            __props__.__dict__["views"] = views
            __props__.__dict__["version"] = None
        super(SystemSnmpFeature, __self__).__init__(
            'sdwan:index/systemSnmpFeature:SystemSnmpFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            communities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureCommunityArgs', 'SystemSnmpFeatureCommunityArgsDict']]]]] = None,
            contact_person: Optional[pulumi.Input[builtins.str]] = None,
            contact_person_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureGroupArgs', 'SystemSnmpFeatureGroupArgsDict']]]]] = None,
            location_of_device: Optional[pulumi.Input[builtins.str]] = None,
            location_of_device_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            trap_target_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureTrapTargetServerArgs', 'SystemSnmpFeatureTrapTargetServerArgsDict']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureUserArgs', 'SystemSnmpFeatureUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureViewArgs', 'SystemSnmpFeatureViewArgsDict']]]]] = None) -> 'SystemSnmpFeature':
        """
        Get an existing SystemSnmpFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureCommunityArgs', 'SystemSnmpFeatureCommunityArgsDict']]]] communities: Configure SNMP community
        :param pulumi.Input[builtins.str] contact_person: Set the contact for this managed node
        :param pulumi.Input[builtins.str] contact_person_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureGroupArgs', 'SystemSnmpFeatureGroupArgsDict']]]] groups: Configure an SNMP group
        :param pulumi.Input[builtins.str] location_of_device: Set the physical location of this managed node
        :param pulumi.Input[builtins.str] location_of_device_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable SNMP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureTrapTargetServerArgs', 'SystemSnmpFeatureTrapTargetServerArgsDict']]]] trap_target_servers: Configure SNMP server to receive SNMP traps
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureUserArgs', 'SystemSnmpFeatureUserArgsDict']]]] users: Configure an SNMP user
        :param pulumi.Input[builtins.int] version: The version of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSnmpFeatureViewArgs', 'SystemSnmpFeatureViewArgsDict']]]] views: Configure a view record
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemSnmpFeatureState.__new__(_SystemSnmpFeatureState)

        __props__.__dict__["communities"] = communities
        __props__.__dict__["contact_person"] = contact_person
        __props__.__dict__["contact_person_variable"] = contact_person_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["groups"] = groups
        __props__.__dict__["location_of_device"] = location_of_device
        __props__.__dict__["location_of_device_variable"] = location_of_device_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["trap_target_servers"] = trap_target_servers
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        __props__.__dict__["views"] = views
        return SystemSnmpFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def communities(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSnmpFeatureCommunity']]]:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter(name="contactPerson")
    def contact_person(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact_person")

    @property
    @pulumi.getter(name="contactPersonVariable")
    def contact_person_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "contact_person_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSnmpFeatureGroup']]]:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="locationOfDevice")
    def location_of_device(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location_of_device")

    @property
    @pulumi.getter(name="locationOfDeviceVariable")
    def location_of_device_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_of_device_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable SNMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="trapTargetServers")
    def trap_target_servers(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSnmpFeatureTrapTargetServer']]]:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_target_servers")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSnmpFeatureUser']]]:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def views(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSnmpFeatureView']]]:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")

