import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { DefaultStackSynthesizer } from './default-synthesizer';
/**
 * Construction properties of {@link BootstraplessSynthesizer}.
 */
export interface BootstraplessSynthesizerProps {
    /**
     * The deploy Role ARN to use.
     *
     * @default - No deploy role (use CLI credentials)
     *
     */
    readonly deployRoleArn?: string;
    /**
     * The CFN execution Role ARN to use.
     *
     * @default - No CloudFormation role (use CLI credentials)
     */
    readonly cloudFormationExecutionRoleArn?: string;
}
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
export declare class BootstraplessSynthesizer extends DefaultStackSynthesizer {
    constructor(props: BootstraplessSynthesizerProps);
    addFileAsset(_asset: FileAssetSource): FileAssetLocation;
    addDockerImageAsset(_asset: DockerImageAssetSource): DockerImageAssetLocation;
    synthesizeStackArtifacts(session: ISynthesisSession): void;
}
