# coding: utf-8

"""
    Planetary Data System API

    Federated PDS API which provides actionable end points standardized between the different nodes.   # noqa: E501

    The version of the OpenAPI document: 0.3.dev
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Product(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'title': 'str',
        'description': 'str',
        'start_date_time': 'str',
        'stop_date_time': 'str',
        'investigations': 'list[Reference]',
        'observing_system_components': 'list[Reference]',
        'targets': 'list[Reference]',
        'metadata': 'Metadata',
        'properties': 'dict(str, list)'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'title': 'title',
        'description': 'description',
        'start_date_time': 'start_date_time',
        'stop_date_time': 'stop_date_time',
        'investigations': 'investigations',
        'observing_system_components': 'observing_system_components',
        'targets': 'targets',
        'metadata': 'metadata',
        'properties': 'properties'
    }

    def __init__(self, id=None, type=None, title=None, description=None, start_date_time=None, stop_date_time=None, investigations=None, observing_system_components=None, targets=None, metadata=None, properties=None, local_vars_configuration=None):  # noqa: E501
        """Product - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._type = None
        self._title = None
        self._description = None
        self._start_date_time = None
        self._stop_date_time = None
        self._investigations = None
        self._observing_system_components = None
        self._targets = None
        self._metadata = None
        self._properties = None
        self.discriminator = None

        self.id = id
        if type is not None:
            self.type = type
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        if start_date_time is not None:
            self.start_date_time = start_date_time
        if stop_date_time is not None:
            self.stop_date_time = stop_date_time
        if investigations is not None:
            self.investigations = investigations
        if observing_system_components is not None:
            self.observing_system_components = observing_system_components
        if targets is not None:
            self.targets = targets
        self.metadata = metadata
        if properties is not None:
            self.properties = properties

    @property
    def id(self):
        """Gets the id of this Product.  # noqa: E501

        identifier lidvid of the collection  # noqa: E501

        :return: The id of this Product.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Product.

        identifier lidvid of the collection  # noqa: E501

        :param id: The id of this Product.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def type(self):
        """Gets the type of this Product.  # noqa: E501


        :return: The type of this Product.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Product.


        :param type: The type of this Product.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def title(self):
        """Gets the title of this Product.  # noqa: E501


        :return: The title of this Product.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Product.


        :param title: The title of this Product.  # noqa: E501
        :type title: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this Product.  # noqa: E501


        :return: The description of this Product.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Product.


        :param description: The description of this Product.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def start_date_time(self):
        """Gets the start_date_time of this Product.  # noqa: E501

        start date time of the observations in ISO8601  # noqa: E501

        :return: The start_date_time of this Product.  # noqa: E501
        :rtype: str
        """
        return self._start_date_time

    @start_date_time.setter
    def start_date_time(self, start_date_time):
        """Sets the start_date_time of this Product.

        start date time of the observations in ISO8601  # noqa: E501

        :param start_date_time: The start_date_time of this Product.  # noqa: E501
        :type start_date_time: str
        """

        self._start_date_time = start_date_time

    @property
    def stop_date_time(self):
        """Gets the stop_date_time of this Product.  # noqa: E501

        stop date time of the observations in ISO8601  # noqa: E501

        :return: The stop_date_time of this Product.  # noqa: E501
        :rtype: str
        """
        return self._stop_date_time

    @stop_date_time.setter
    def stop_date_time(self, stop_date_time):
        """Sets the stop_date_time of this Product.

        stop date time of the observations in ISO8601  # noqa: E501

        :param stop_date_time: The stop_date_time of this Product.  # noqa: E501
        :type stop_date_time: str
        """

        self._stop_date_time = stop_date_time

    @property
    def investigations(self):
        """Gets the investigations of this Product.  # noqa: E501

        list of missions or observing campaigns which produced the data  # noqa: E501

        :return: The investigations of this Product.  # noqa: E501
        :rtype: list[Reference]
        """
        return self._investigations

    @investigations.setter
    def investigations(self, investigations):
        """Sets the investigations of this Product.

        list of missions or observing campaigns which produced the data  # noqa: E501

        :param investigations: The investigations of this Product.  # noqa: E501
        :type investigations: list[Reference]
        """

        self._investigations = investigations

    @property
    def observing_system_components(self):
        """Gets the observing_system_components of this Product.  # noqa: E501

        list of instruments or platforms generating the data  # noqa: E501

        :return: The observing_system_components of this Product.  # noqa: E501
        :rtype: list[Reference]
        """
        return self._observing_system_components

    @observing_system_components.setter
    def observing_system_components(self, observing_system_components):
        """Sets the observing_system_components of this Product.

        list of instruments or platforms generating the data  # noqa: E501

        :param observing_system_components: The observing_system_components of this Product.  # noqa: E501
        :type observing_system_components: list[Reference]
        """

        self._observing_system_components = observing_system_components

    @property
    def targets(self):
        """Gets the targets of this Product.  # noqa: E501

        list of targets or feature of interest the observation.  # noqa: E501

        :return: The targets of this Product.  # noqa: E501
        :rtype: list[Reference]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """Sets the targets of this Product.

        list of targets or feature of interest the observation.  # noqa: E501

        :param targets: The targets of this Product.  # noqa: E501
        :type targets: list[Reference]
        """

        self._targets = targets

    @property
    def metadata(self):
        """Gets the metadata of this Product.  # noqa: E501


        :return: The metadata of this Product.  # noqa: E501
        :rtype: Metadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Product.


        :param metadata: The metadata of this Product.  # noqa: E501
        :type metadata: Metadata
        """
        if self.local_vars_configuration.client_side_validation and metadata is None:  # noqa: E501
            raise ValueError("Invalid value for `metadata`, must not be `None`")  # noqa: E501

        self._metadata = metadata

    @property
    def properties(self):
        """Gets the properties of this Product.  # noqa: E501

        properties extracted from pds4 model, syntax for property name is <namespace>:<property>[/<namespace>:<property>]*  # noqa: E501

        :return: The properties of this Product.  # noqa: E501
        :rtype: dict(str, list)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this Product.

        properties extracted from pds4 model, syntax for property name is <namespace>:<property>[/<namespace>:<property>]*  # noqa: E501

        :param properties: The properties of this Product.  # noqa: E501
        :type properties: dict(str, list)
        """

        self._properties = properties

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Product):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Product):
            return True

        return self.to_dict() != other.to_dict()
