# coding: utf-8

"""
    Planetary Data System API

    Federated PDS API which provides actionable end points standardized between the different nodes.   # noqa: E501

    The version of the OpenAPI document: 0.3.dev
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Summary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'q': 'str',
        'start': 'int',
        'limit': 'int',
        'sort': 'list[str]',
        'properties': 'list[str]'
    }

    attribute_map = {
        'q': 'q',
        'start': 'start',
        'limit': 'limit',
        'sort': 'sort',
        'properties': 'properties'
    }

    def __init__(self, q=None, start=None, limit=None, sort=None, properties=None, local_vars_configuration=None):  # noqa: E501
        """Summary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._q = None
        self._start = None
        self._limit = None
        self._sort = None
        self._properties = None
        self.discriminator = None

        if q is not None:
            self.q = q
        if start is not None:
            self.start = start
        if limit is not None:
            self.limit = limit
        if sort is not None:
            self.sort = sort
        if properties is not None:
            self.properties = properties

    @property
    def q(self):
        """Gets the q of this Summary.  # noqa: E501


        :return: The q of this Summary.  # noqa: E501
        :rtype: str
        """
        return self._q

    @q.setter
    def q(self, q):
        """Sets the q of this Summary.


        :param q: The q of this Summary.  # noqa: E501
        :type q: str
        """

        self._q = q

    @property
    def start(self):
        """Gets the start of this Summary.  # noqa: E501


        :return: The start of this Summary.  # noqa: E501
        :rtype: int
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this Summary.


        :param start: The start of this Summary.  # noqa: E501
        :type start: int
        """

        self._start = start

    @property
    def limit(self):
        """Gets the limit of this Summary.  # noqa: E501


        :return: The limit of this Summary.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this Summary.


        :param limit: The limit of this Summary.  # noqa: E501
        :type limit: int
        """

        self._limit = limit

    @property
    def sort(self):
        """Gets the sort of this Summary.  # noqa: E501


        :return: The sort of this Summary.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this Summary.


        :param sort: The sort of this Summary.  # noqa: E501
        :type sort: list[str]
        """

        self._sort = sort

    @property
    def properties(self):
        """Gets the properties of this Summary.  # noqa: E501


        :return: The properties of this Summary.  # noqa: E501
        :rtype: list[str]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this Summary.


        :param properties: The properties of this Summary.  # noqa: E501
        :type properties: list[str]
        """

        self._properties = properties

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Summary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Summary):
            return True

        return self.to_dict() != other.to_dict()
