import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotChannelFacebookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#bot_name BotChannelFacebook#bot_name}.
     *
     * @stability stable
     */
    readonly botName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#facebook_application_id BotChannelFacebook#facebook_application_id}.
     *
     * @stability stable
     */
    readonly facebookApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#facebook_application_secret BotChannelFacebook#facebook_application_secret}.
     *
     * @stability stable
     */
    readonly facebookApplicationSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#location BotChannelFacebook#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#resource_group_name BotChannelFacebook#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * page block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#page BotChannelFacebook#page}
     *
     * @stability stable
     */
    readonly page: BotChannelFacebookPage[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#timeouts BotChannelFacebook#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotChannelFacebookTimeouts;
}
/**
 * @stability stable
 */
export interface BotChannelFacebookPage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#access_token BotChannelFacebook#access_token}.
     *
     * @stability stable
     */
    readonly accessToken: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#id BotChannelFacebook#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function botChannelFacebookPageToTerraform(struct?: BotChannelFacebookPage): any;
/**
 * @stability stable
 */
export interface BotChannelFacebookTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#create BotChannelFacebook#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#delete BotChannelFacebook#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#read BotChannelFacebook#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html#update BotChannelFacebook#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botChannelFacebookTimeoutsToTerraform(struct?: BotChannelFacebookTimeoutsOutputReference | BotChannelFacebookTimeouts): any;
/**
 * @stability stable
 */
export declare class BotChannelFacebookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotChannelFacebookTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotChannelFacebookTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html azurerm_bot_channel_facebook}.
 *
 * @stability stable
 */
export declare class BotChannelFacebook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook.html azurerm_bot_channel_facebook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotChannelFacebookConfig);
    private _botName?;
    /**
     * @stability stable
     */
    get botName(): string;
    /**
     * @stability stable
     */
    set botName(value: string);
    /**
     * @stability stable
     */
    get botNameInput(): string | undefined;
    private _facebookApplicationId?;
    /**
     * @stability stable
     */
    get facebookApplicationId(): string;
    /**
     * @stability stable
     */
    set facebookApplicationId(value: string);
    /**
     * @stability stable
     */
    get facebookApplicationIdInput(): string | undefined;
    private _facebookApplicationSecret?;
    /**
     * @stability stable
     */
    get facebookApplicationSecret(): string;
    /**
     * @stability stable
     */
    set facebookApplicationSecret(value: string);
    /**
     * @stability stable
     */
    get facebookApplicationSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _page?;
    /**
     * @stability stable
     */
    get page(): BotChannelFacebookPage[];
    /**
     * @stability stable
     */
    set page(value: BotChannelFacebookPage[]);
    /**
     * @stability stable
     */
    get pageInput(): BotChannelFacebookPage[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotChannelFacebookTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotChannelFacebookTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotChannelFacebookTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
