"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * Accessor for pseudo parameters
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
_a = JSII_RTTI_SYMBOL_1;
Aws[_a] = { fqn: "@aws-cdk/core.Aws", version: "1.172.0" };
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
Aws.PARTITION = pseudoString(AWS_PARTITION);
Aws.REGION = pseudoString(AWS_REGION);
Aws.STACK_ID = pseudoString(AWS_STACKID);
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * Accessor for scoped pseudo parameters
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 */
class ScopedAws {
    constructor(scope) {
        this.scope = scope;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScopedAws);
            }
            throw error;
        }
    }
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    get region() {
        return this.asString(AWS_REGION);
    }
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
_b = JSII_RTTI_SYMBOL_1;
ScopedAws[_b] = { fqn: "@aws-cdk/core.ScopedAws", version: "1.172.0" };
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,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