"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultTokenResolver = exports.StringConcat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const encoding_1 = require("./private/encoding");
const token_map_1 = require("./private/token-map");
/**
 * Converts all fragments to strings and concats those
 *
 * Drops 'undefined's.
 */
class StringConcat {
    join(left, right) {
        if (left === undefined) {
            return right !== undefined ? `${right}` : undefined;
        }
        if (right === undefined) {
            return `${left}`;
        }
        return `${left}${right}`;
    }
}
exports.StringConcat = StringConcat;
_a = JSII_RTTI_SYMBOL_1;
StringConcat[_a] = { fqn: "@aws-cdk/core.StringConcat", version: "1.172.0" };
/**
 * Default resolver implementation
 *
 */
class DefaultTokenResolver {
    constructor(concat) {
        this.concat = concat;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IFragmentConcatenator(concat);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DefaultTokenResolver);
            }
            throw error;
        }
    }
    /**
     * Default Token resolution
     *
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     */
    resolveToken(t, context, postProcessor) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolvable(t);
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(context);
            jsiiDeprecationWarnings._aws_cdk_core_IPostProcessor(postProcessor);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolveToken);
            }
            throw error;
        }
        try {
            let resolved = t.resolve(context);
            // The token might have returned more values that need resolving, recurse
            resolved = context.resolve(resolved);
            resolved = postProcessor.postProcess(resolved, context);
            return resolved;
        }
        catch (e) {
            let message = `Resolution error: ${e.message}.`;
            if (t.creationStack && t.creationStack.length > 0) {
                message += `\nObject creation stack:\n  at ${t.creationStack.join('\n  at ')}`;
            }
            e.message = message;
            throw e;
        }
    }
    /**
     * Resolve string fragments to Tokens
     */
    resolveString(fragments, context) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_TokenizedStringFragments(fragments);
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(context);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolveString);
            }
            throw error;
        }
        return fragments.mapTokens({ mapToken: context.resolve }).join(this.concat);
    }
    resolveList(xs, context) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(context);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolveList);
            }
            throw error;
        }
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw new Error(`Cannot add elements to list token, got: ${xs}`);
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw new Error(`Cannot concatenate strings in a tokenized string array, got: ${xs[0]}`);
        }
        return fragments.mapTokens({ mapToken: context.resolve }).firstValue;
    }
}
exports.DefaultTokenResolver = DefaultTokenResolver;
_b = JSII_RTTI_SYMBOL_1;
DefaultTokenResolver[_b] = { fqn: "@aws-cdk/core.DefaultTokenResolver", version: "1.172.0" };
//# sourceMappingURL=data:application/json;base64,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