# This file was auto-generated by Fern from our API Definition.

import json
import typing
import urllib.parse
from json.decoder import JSONDecodeError

import typing_extensions

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.context_filter import ContextFilter
from ...types.http_validation_error import HttpValidationError
from ...types.open_ai_completion import OpenAiCompletion
from ...types.open_ai_message import OpenAiMessage

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContextualCompletionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def prompt_completion_stream(
        self,
        *,
        prompt: str,
        system_prompt: typing.Optional[str] = OMIT,
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[True] = True,
    ) -> typing.Iterator[OpenAiCompletion]:
        """
        We recommend most users use our Chat completions API.

        Given a prompt, the model will return one predicted completion.

        Optionally include a `system_prompt` to influence the way the LLM answers.

        If `use_context`
        is set to `true`, the model will use context coming from the ingested documents
        to create the response. The documents being used can be filtered using the
        `context_filter` and passing the document IDs to be used. Ingested documents IDs
        can be found using `/ingest/list` endpoint. If you want all ingested documents to
        be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - prompt: str.

            - system_prompt: typing.Optional[str].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[True].
        """
        _request: typing.Dict[str, typing.Any] = {"prompt": prompt, "stream": stream}
        if system_prompt is not OMIT:
            _request["system_prompt"] = system_prompt
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        with self._client_wrapper.httpx_client.stream(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        ) as _response:
            if 200 <= _response.status_code < 300:
                for _text in _response.iter_lines():
                    if len(_text) == 0:
                        continue
                    # if text contains "[DONE]" at any point, finish
                    if "[DONE]" in _text:
                        return
                    # Remove the 'data:' prefix
                    _text = _text[5:]
                    yield pydantic.parse_obj_as(OpenAiCompletion, json.loads(_text))  # type: ignore
                return
            _response.read()
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    pydantic.parse_obj_as(HttpValidationError, _response.json())  # type: ignore
                )
            try:
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def prompt_completion(
        self,
        *,
        prompt: str,
        system_prompt: typing.Optional[str] = OMIT,
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[False] = False,
    ) -> OpenAiCompletion:
        """
        We recommend most users use our Chat completions API.

        Given a prompt, the model will return one predicted completion.

        Optionally include a `system_prompt` to influence the way the LLM answers.

        If `use_context`
        is set to `true`, the model will use context coming from the ingested documents
        to create the response. The documents being used can be filtered using the
        `context_filter` and passing the document IDs to be used. Ingested documents IDs
        can be found using `/ingest/list` endpoint. If you want all ingested documents to
        be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - prompt: str.

            - system_prompt: typing.Optional[str].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[False].
        """
        _request: typing.Dict[str, typing.Any] = {"prompt": prompt, "stream": stream}
        if system_prompt is not OMIT:
            _request["system_prompt"] = system_prompt
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OpenAiCompletion, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def chat_completion_stream(
        self,
        *,
        messages: typing.List[OpenAiMessage],
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[True] = True,
    ) -> typing.Iterator[OpenAiCompletion]:
        """
        Given a list of messages comprising a conversation, return a response.

        Optionally include an initial `role: system` message to influence the way
        the LLM answers.

        If `use_context` is set to `true`, the model will use context coming
        from the ingested documents to create the response. The documents being used can
        be filtered using the `context_filter` and passing the document IDs to be used.
        Ingested documents IDs can be found using `/ingest/list` endpoint. If you want
        all ingested documents to be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - messages: typing.List[OpenAiMessage].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[True].
        """
        _request: typing.Dict[str, typing.Any] = {"messages": messages, "stream": stream}
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        with self._client_wrapper.httpx_client.stream(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        ) as _response:
            if 200 <= _response.status_code < 300:
                for _text in _response.iter_lines():
                    if len(_text) == 0:
                        continue
                    # if text contains "[DONE]" at any point, finish
                    if "[DONE]" in _text:
                        return
                    # Remove the 'data:' prefix
                    _text = _text[5:]
                    yield pydantic.parse_obj_as(OpenAiCompletion, json.loads(_text))  # type: ignore
                return
            _response.read()
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    pydantic.parse_obj_as(HttpValidationError, _response.json())  # type: ignore
                )
            try:
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def chat_completion(
        self,
        *,
        messages: typing.List[OpenAiMessage],
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[False] = False,
    ) -> OpenAiCompletion:
        """
        Given a list of messages comprising a conversation, return a response.

        Optionally include an initial `role: system` message to influence the way
        the LLM answers.

        If `use_context` is set to `true`, the model will use context coming
        from the ingested documents to create the response. The documents being used can
        be filtered using the `context_filter` and passing the document IDs to be used.
        Ingested documents IDs can be found using `/ingest/list` endpoint. If you want
        all ingested documents to be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - messages: typing.List[OpenAiMessage].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[False].
        """
        _request: typing.Dict[str, typing.Any] = {"messages": messages, "stream": stream}
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OpenAiCompletion, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncContextualCompletionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def prompt_completion_stream(
        self,
        *,
        prompt: str,
        system_prompt: typing.Optional[str] = OMIT,
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[True] = True,
    ) -> typing.AsyncIterator[OpenAiCompletion]:
        """
        We recommend most users use our Chat completions API.

        Given a prompt, the model will return one predicted completion.

        Optionally include a `system_prompt` to influence the way the LLM answers.

        If `use_context`
        is set to `true`, the model will use context coming from the ingested documents
        to create the response. The documents being used can be filtered using the
        `context_filter` and passing the document IDs to be used. Ingested documents IDs
        can be found using `/ingest/list` endpoint. If you want all ingested documents to
        be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - prompt: str.

            - system_prompt: typing.Optional[str].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[True].
        """
        _request: typing.Dict[str, typing.Any] = {"prompt": prompt, "stream": stream}
        if system_prompt is not OMIT:
            _request["system_prompt"] = system_prompt
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        async with self._client_wrapper.httpx_client.stream(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        ) as _response:
            if 200 <= _response.status_code < 300:
                async for _text in _response.aiter_lines():
                    if len(_text) == 0:
                        continue
                    # if text contains "[DONE]" at any point, finish
                    if "[DONE]" in _text:
                        return
                    # Remove the 'data:' prefix
                    _text = _text[5:]
                    yield pydantic.parse_obj_as(OpenAiCompletion, json.loads(_text))  # type: ignore
                return
            await _response.aread()
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    pydantic.parse_obj_as(HttpValidationError, _response.json())  # type: ignore
                )
            try:
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def prompt_completion(
        self,
        *,
        prompt: str,
        system_prompt: typing.Optional[str] = OMIT,
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[False] = False,
    ) -> OpenAiCompletion:
        """
        We recommend most users use our Chat completions API.

        Given a prompt, the model will return one predicted completion.

        Optionally include a `system_prompt` to influence the way the LLM answers.

        If `use_context`
        is set to `true`, the model will use context coming from the ingested documents
        to create the response. The documents being used can be filtered using the
        `context_filter` and passing the document IDs to be used. Ingested documents IDs
        can be found using `/ingest/list` endpoint. If you want all ingested documents to
        be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - prompt: str.

            - system_prompt: typing.Optional[str].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[False].
        """
        _request: typing.Dict[str, typing.Any] = {"prompt": prompt, "stream": stream}
        if system_prompt is not OMIT:
            _request["system_prompt"] = system_prompt
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OpenAiCompletion, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def chat_completion_stream(
        self,
        *,
        messages: typing.List[OpenAiMessage],
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[True] = True,
    ) -> typing.AsyncIterator[OpenAiCompletion]:
        """
        Given a list of messages comprising a conversation, return a response.

        Optionally include an initial `role: system` message to influence the way
        the LLM answers.

        If `use_context` is set to `true`, the model will use context coming
        from the ingested documents to create the response. The documents being used can
        be filtered using the `context_filter` and passing the document IDs to be used.
        Ingested documents IDs can be found using `/ingest/list` endpoint. If you want
        all ingested documents to be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - messages: typing.List[OpenAiMessage].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[True].
        """
        _request: typing.Dict[str, typing.Any] = {"messages": messages, "stream": stream}
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        async with self._client_wrapper.httpx_client.stream(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        ) as _response:
            if 200 <= _response.status_code < 300:
                async for _text in _response.aiter_lines():
                    if len(_text) == 0:
                        continue
                    # if text contains "[DONE]" at any point, finish
                    if "[DONE]" in _text:
                        return
                    # Remove the 'data:' prefix
                    _text = _text[5:]
                    yield pydantic.parse_obj_as(OpenAiCompletion, json.loads(_text))  # type: ignore
                return
            await _response.aread()
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    pydantic.parse_obj_as(HttpValidationError, _response.json())  # type: ignore
                )
            try:
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def chat_completion(
        self,
        *,
        messages: typing.List[OpenAiMessage],
        use_context: typing.Optional[bool] = OMIT,
        context_filter: typing.Optional[ContextFilter] = OMIT,
        include_sources: typing.Optional[bool] = OMIT,
        stream: typing_extensions.Literal[False] = False,
    ) -> OpenAiCompletion:
        """
        Given a list of messages comprising a conversation, return a response.

        Optionally include an initial `role: system` message to influence the way
        the LLM answers.

        If `use_context` is set to `true`, the model will use context coming
        from the ingested documents to create the response. The documents being used can
        be filtered using the `context_filter` and passing the document IDs to be used.
        Ingested documents IDs can be found using `/ingest/list` endpoint. If you want
        all ingested documents to be used, remove `context_filter` altogether.

        When using `'include_sources': true`, the API will return the source Chunks used
        to create the response, which come from the context provided.

        When using `'stream': true`, the API will return data chunks following [OpenAI's
        streaming model](https://platform.openai.com/docs/api-reference/chat/streaming):
        ```
        {"id":"12345","object":"completion.chunk","created":1694268190,
        "model":"private-gpt","choices":[{"index":0,"delta":{"content":"Hello"},
        "finish_reason":null}]}
        ```

        Parameters:
            - messages: typing.List[OpenAiMessage].

            - use_context: typing.Optional[bool].

            - context_filter: typing.Optional[ContextFilter].

            - include_sources: typing.Optional[bool].

            - stream: typing_extensions.Literal[False].
        """
        _request: typing.Dict[str, typing.Any] = {"messages": messages, "stream": stream}
        if use_context is not OMIT:
            _request["use_context"] = use_context
        if context_filter is not OMIT:
            _request["context_filter"] = context_filter
        if include_sources is not OMIT:
            _request["include_sources"] = include_sources
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OpenAiCompletion, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
