# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.http_validation_error import HttpValidationError
from ...types.ingest_response import IngestResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class IngestionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def ingest(self, *, file: typing.IO) -> IngestResponse:
        """
        Ingests and processes a file.

        Deprecated. Use ingest/file instead.

        Parameters:
            - file: typing.IO.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def ingest_file(self, *, file: typing.IO) -> IngestResponse:
        """
        Ingests and processes a file, storing its chunks to be used as context.

        The context obtained from files is later used in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Most common document
        formats are supported, but you may be prompted to install an extra dependency to
        manage a specific file type.

        A file can generate different Documents (for example a PDF generates one Document
        per page). All Documents IDs are returned in the response, together with the
        extracted Metadata (which is later used to improve context retrieval). Those IDs
        can be used to filter the context used to create responses in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Parameters:
            - file: typing.IO.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/file"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def ingest_text(self, *, file_name: str, text: str) -> IngestResponse:
        """
        Ingests and processes a text, storing its chunks to be used as context.

        The context obtained from files is later used in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        A Document will be generated with the given text. The Document
        ID is returned in the response, together with the
        extracted Metadata (which is later used to improve context retrieval). That ID
        can be used to filter the context used to create responses in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Parameters:
            - file_name: str.

            - text: str.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/text"),
            json=jsonable_encoder({"file_name": file_name, "text": text}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_ingested(self) -> IngestResponse:
        """
        Lists already ingested Documents including their Document ID and metadata.

        Those IDs can be used to filter the context used to create responses
        in `/chat/completions`, `/completions`, and `/chunks` APIs.
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/list"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_ingested(self, doc_id: str) -> typing.Any:
        """
        Delete the specified ingested Document.

        The `doc_id` can be obtained from the `GET /ingest/list` endpoint.
        The document will be effectively deleted from your storage context.

        Parameters:
            - doc_id: str.
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/ingest/{doc_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncIngestionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def ingest(self, *, file: typing.IO) -> IngestResponse:
        """
        Ingests and processes a file.

        Deprecated. Use ingest/file instead.

        Parameters:
            - file: typing.IO.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def ingest_file(self, *, file: typing.IO) -> IngestResponse:
        """
        Ingests and processes a file, storing its chunks to be used as context.

        The context obtained from files is later used in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Most common document
        formats are supported, but you may be prompted to install an extra dependency to
        manage a specific file type.

        A file can generate different Documents (for example a PDF generates one Document
        per page). All Documents IDs are returned in the response, together with the
        extracted Metadata (which is later used to improve context retrieval). Those IDs
        can be used to filter the context used to create responses in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Parameters:
            - file: typing.IO.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/file"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def ingest_text(self, *, file_name: str, text: str) -> IngestResponse:
        """
        Ingests and processes a text, storing its chunks to be used as context.

        The context obtained from files is later used in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        A Document will be generated with the given text. The Document
        ID is returned in the response, together with the
        extracted Metadata (which is later used to improve context retrieval). That ID
        can be used to filter the context used to create responses in
        `/chat/completions`, `/completions`, and `/chunks` APIs.

        Parameters:
            - file_name: str.

            - text: str.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/text"),
            json=jsonable_encoder({"file_name": file_name, "text": text}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_ingested(self) -> IngestResponse:
        """
        Lists already ingested Documents including their Document ID and metadata.

        Those IDs can be used to filter the context used to create responses
        in `/chat/completions`, `/completions`, and `/chunks` APIs.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/ingest/list"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(IngestResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_ingested(self, doc_id: str) -> typing.Any:
        """
        Delete the specified ingested Document.

        The `doc_id` can be obtained from the `GET /ingest/list` endpoint.
        The document will be effectively deleted from your storage context.

        Parameters:
            - doc_id: str.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/ingest/{doc_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
