#!/usr/bin/env python3
# This file is a part of marzer/soagen and is subject to the the terms of the MIT license.
# Copyright (c) Mark Gillard <mark.gillard@outlook.com.au>
# See https://github.com/marzer/soagen/blob/master/LICENSE for the full license text.
# SPDX-License-Identifier: MIT

"""
Constants for various key paths.
"""

import tempfile
from pathlib import Path

PACKAGE = Path(Path(__file__).resolve().parent)
"""The root directory of the package installation."""

SRC = Path(PACKAGE, r'..').resolve()
"""The root directory of repository's package sources."""

REPOSITORY = Path(SRC, r'..').resolve()
"""The root directory of the repository."""

TESTS = Path(REPOSITORY, r'tests')
"""The root directory of the repository's tests."""

HPP = Path(PACKAGE, r'hpp')
"""The PACKAGE containing soagen's (non-autogenerated) hpp files."""

HPP_TEMPLATES = Path(HPP, r'templates')
"""The directory containing soagen's .hpp template files"""

HPP_GENERATED = Path(HPP, r'generated')
"""The directory containing soagen's procedurally-generated .hpp files"""

HPP_SINGLE = Path(HPP, r'single')
"""The directory containing soagen's pre-processed 'single' soagen.hpp"""

DOCS = Path(REPOSITORY, r'docs')
"""The root directory of the repository's documentation."""

EXAMPLES = Path(REPOSITORY, r'examples')
"""The root directory of the repository's examples."""

TEMP = Path(tempfile.gettempdir(), r'soagen')
"""A global temp directory shared by all instances of soagen."""

BUG_REPORT_DIR = (TEMP / r'bug_report').resolve()
"""Directory used for assembling bug reports."""

BUG_REPORT_INPUTS = BUG_REPORT_DIR / r'inputs'
"""Directory used for storing the inputs when assembling bug reports."""

BUG_REPORT_OUTPUTS = BUG_REPORT_DIR / r'outputs'
"""Directory used for storing the outputs when assembling bug reports."""

VERSION_TXT = PACKAGE / r'version.txt'
"""The version file, version.txt."""


MAKE_SINGLE = Path(REPOSITORY, r'..', r'muu', r'tools', r'make_single.py')
