/**
This file was auto-generated by mupdfwrap.py.
*/

#ifndef MUPDF_CLASSES_H
#define MUPDF_CLASSES_H


#include "mupdf/fitz.h"
#include "mupdf/functions.h"
#include "mupdf/pdf.h"

#include <map>
#include <string>
#include <vector>


namespace mupdf
{

/* Forward declarations of all classes that we define. */
struct FzAaContext;
struct FzActivityContext;
struct FzAes;
struct FzAllocContext;
struct FzArc4;
struct FzArchive;
struct FzArchiveHandler;
struct FzArchiveHandlerContext;
struct FzBandWriter;
struct FzBitmap;
struct FzBuffer;
struct FzColorParams;
struct FzColorspace;
struct FzColorspaceContext;
struct FzCompressedBuffer;
struct FzCompressedImage;
struct FzCompressionParams;
struct FzContext;
struct FzCookie;
struct FzDefaultColorspaces;
struct FzDevice;
struct FzDeviceContainerStack;
struct FzDisplayList;
struct FzDocument;
struct FzDocumentHandler;
struct FzDocumentHandlerContext;
struct FzDocumentWriter;
struct FzDrawOptions;
struct FzErrorContext;
struct FzErrorStackSlot;
struct FzFont;
struct FzFontContext;
struct FzFontFlagsT;
struct FzFunction;
struct FzGetoptLongOptions;
struct FzGlyph;
struct FzGlyphCache;
struct FzHalftone;
struct FzHashTable;
struct FzIccProfile;
struct FzImage;
struct FzInstallLoadSystemFontFuncsArgs;
struct FzInt2;
struct FzInt2Heap;
struct FzIntHeap;
struct FzIntptr;
struct FzIntptrHeap;
struct FzIrect;
struct FzJbig2Globals;
struct FzJson;
struct FzJsonArray;
struct FzJsonObject;
struct FzKeyStorable;
struct FzLayoutBlock;
struct FzLayoutChar;
struct FzLayoutLine;
struct FzLink;
struct FzLinkDest;
struct FzLocation;
struct FzLocksContext;
struct FzMatrix;
struct FzMd5;
struct FzOutline;
struct FzOutlineItem;
struct FzOutlineIterator;
struct FzOutput;
struct FzOverprint;
struct FzPage;
struct FzPath;
struct FzPathWalker;
struct FzPclOptions;
struct FzPclmOptions;
struct FzPdfocrOptions;
struct FzPixmap;
struct FzPixmapImage;
struct FzPoint;
struct FzPool;
struct FzPtrHeap;
struct FzPwgOptions;
struct FzQuad;
struct FzRange;
struct FzRect;
struct FzSeparations;
struct FzSha256;
struct FzSha384;
struct FzSha512;
struct FzShade;
struct FzShadeColorCache;
struct FzShaperDataT;
struct FzStextBlock;
struct FzStextChar;
struct FzStextGridPositions;
struct FzStextLine;
struct FzStextOptions;
struct FzStextPage;
struct FzStextStruct;
struct FzStorable;
struct FzStore;
struct FzStoreHash;
struct FzStoreType;
struct FzStory;
struct FzStoryElementPosition;
struct FzStream;
struct FzString;
struct FzStrokeState;
struct FzStyleContext;
struct FzText;
struct FzTextDecoder;
struct FzTextItem;
struct FzTextSpan;
struct FzTransition;
struct FzTree;
struct FzTuningContext;
struct FzVertex;
struct FzWarnContext;
struct FzWriteStoryPosition;
struct FzWriteStoryPositions;
struct FzXml;
struct FzXmlDoc;
struct FzZipWriter;
struct PdfAlertEvent;
struct PdfAnnot;
struct PdfCleanOptions;
struct PdfCmap;
struct PdfColorFilterOptions;
struct PdfColorspaceResourceKey;
struct PdfCrypt;
struct PdfCsi;
struct PdfCycleList;
struct PdfDocEvent;
struct PdfDocument;
struct PdfFilespecParams;
struct PdfFilterFactory;
struct PdfFilterOptions;
struct PdfFontDesc;
struct PdfFontResourceKey;
struct PdfFunction;
struct PdfGraftMap;
struct PdfGstate;
struct PdfHintPage;
struct PdfHintShared;
struct PdfHmtx;
struct PdfImageRewriterOptions;
struct PdfJournal;
struct PdfJs;
struct PdfJsConsole;
struct PdfKeystrokeEvent;
struct PdfLaunchUrlEvent;
struct PdfLayerConfig;
struct PdfLayerConfigUi;
struct PdfLexbuf;
struct PdfLexbufLarge;
struct PdfLockedFields;
struct PdfMailDocEvent;
struct PdfMarkBits;
struct PdfMarkList;
struct PdfMrange;
struct PdfObj;
struct PdfObjectLabels;
struct PdfOcgDescriptor;
struct PdfPage;
struct PdfPattern;
struct PdfPkcs7DistinguishedName;
struct PdfPkcs7Signer;
struct PdfPkcs7Verifier;
struct PdfProcessor;
struct PdfRange;
struct PdfRecolorOptions;
struct PdfRedactOptions;
struct PdfRevPageMap;
struct PdfSanitizeFilterOptions;
struct PdfTextObjectState;
struct PdfTextState;
struct PdfUnsavedSig;
struct PdfVmtx;
struct PdfWriteOptions;
struct PdfXrange;
struct PdfXref;
struct PdfXrefEntry;
struct PdfXrefSubsec;


/** Wrapper class for struct `fz_aa_context`. */
struct FzAaContext
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzAaContext();

	/** Constructor using raw copy of pre-existing `::fz_aa_context`. */
	FZ_FUNCTION FzAaContext(const ::fz_aa_context* internal);

	/** Constructor using raw copy of pre-existing `::fz_aa_context`. */
	FZ_FUNCTION FzAaContext(const ::fz_aa_context internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_aa_context* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_aa_context* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzAaContext();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_aa_context. */
	int hscale;
	int vscale;
	int scale;
	int bits;
	int text_bits;
	float min_line_width;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzAaContext& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzAaContext& rhs);
};

/** Wrapper class for struct `fz_activity_context`. Not copyable or assignable. */
struct FzActivityContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzActivityContext();

	/** Constructor using raw copy of pre-existing `::fz_activity_context`. */
	FZ_FUNCTION FzActivityContext(::fz_activity_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzActivityContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_activity_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzActivityContext(const FzActivityContext& rhs);
	FzActivityContext& operator=(const FzActivityContext& rhs);
};

/** Wrapper class for struct `fz_aes`. Not copyable or assignable. */
/**
	Structure definitions are public to enable stack
	based allocation. Do not access the members directly.
*/
struct FzAes
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzAes();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_aes_crypt_cbc()`.  */
	/**
		AES block processing. Encrypts or Decrypts (according to mode,
		which must match what was initially set up) length bytes (which
		must be a multiple of 16), using (and modifying) the insertion
		vector iv, reading from input, and writing to output.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_aes_crypt_cbc(int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output) const;

	/** Class-aware wrapper for `::fz_aes_setkey_dec()`.  */
	/**
		AES decryption initialization. Fills in the supplied context
		and prepares for decryption using the given key.
	
		Returns non-zero for error (key size other than 128/192/256).
	
		Never throws an exception.
	*/
	FZ_FUNCTION int fz_aes_setkey_dec(const unsigned char *key, int keysize) const;

	/** Class-aware wrapper for `::fz_aes_setkey_enc()`.  */
	/**
		AES encryption initialization. Fills in the supplied context
		and prepares for encryption using the given key.
	
		Returns non-zero for error (key size other than 128/192/256).
	
		Never throws an exception.
	*/
	FZ_FUNCTION int fz_aes_setkey_enc(const unsigned char *key, int keysize) const;

	/** Constructor using raw copy of pre-existing `::fz_aes`. */
	FZ_FUNCTION FzAes(::fz_aes* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzAes();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_aes* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzAes(const FzAes& rhs);
	FzAes& operator=(const FzAes& rhs);
};

/** Wrapper class for struct `fz_alloc_context`. Not copyable or assignable. */
/**
	Allocator structure; holds callbacks and private data pointer.
*/
struct FzAllocContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzAllocContext();

	/** Constructor using raw copy of pre-existing `::fz_alloc_context`. */
	FZ_FUNCTION FzAllocContext(::fz_alloc_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzAllocContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_alloc_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzAllocContext(const FzAllocContext& rhs);
	FzAllocContext& operator=(const FzAllocContext& rhs);
};

/** Wrapper class for struct `fz_arc4`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct FzArc4
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzArc4();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_arc4_encrypt()`.  */
	/**
		RC4 block encrypt operation; encrypt src into dst (both of
		length len) updating the RC4 state as we go.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_arc4_encrypt(unsigned char *dest, const unsigned char *src, size_t len) const;

	/** Class-aware wrapper for `::fz_arc4_final()`.  */
	/**
		RC4 finalization. Zero the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_arc4_final() const;

	/** Class-aware wrapper for `::fz_arc4_init()`.  */
	/**
		RC4 initialization. Begins an RC4 operation, writing a new
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_arc4_init(const unsigned char *key, size_t len) const;

	/** Constructor using raw copy of pre-existing `::fz_arc4`. */
	FZ_FUNCTION FzArc4(::fz_arc4* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzArc4();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_arc4* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzArc4(const FzArc4& rhs);
	FzArc4& operator=(const FzArc4& rhs);
};

/** Wrapper class for struct `fz_archive`. */
/**
	fz_archive:

	fz_archive provides methods for accessing "archive" files.
	An archive file is a conceptual entity that contains multiple
	files, which can be counted, enumerated, and read.

	Implementations of fz_archive based upon directories, zip
	and tar files are included.
*/
struct FzArchive
{
	/** == Constructors. */

	/** Constructor using `fz_new_archive_of_size()`. */
	FZ_FUNCTION FzArchive(const FzStream& file, int size);

	/** Constructor using `fz_new_multi_archive()`. */
	/**
		Create a new multi archive (initially empty).
	*/
	FZ_FUNCTION FzArchive();

	/** Constructor using `fz_new_tree_archive()`. */
	/**
		Create an archive that holds named buffers.
	
		tree can either be a preformed tree with fz_buffers as values,
		or it can be NULL for an empty tree.
	*/
	FZ_FUNCTION FzArchive(const FzTree& tree);

	/** Copy constructor using `fz_keep_archive()`. */
	FZ_FUNCTION FzArchive(const FzArchive& rhs);

	/** operator= using `fz_keep_archive()` and `fz_drop_archive()`. */
	FZ_FUNCTION FzArchive& operator=(const FzArchive& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_archive_format()`.  */
	/**
		Return a pointer to a string describing the format of the
		archive.
	
		The lifetime of the string is unspecified (in current
		implementations the string will persist until the archive
		is closed, but this is not guaranteed).
	*/
	FZ_FUNCTION const char *fz_archive_format() const;

	/** Class-aware wrapper for `::fz_count_archive_entries()`.  */
	/**
		Number of entries in archive.
	
		Will always return a value >= 0.
	
		May throw an exception if this type of archive cannot count the
		entries (such as a directory).
	*/
	FZ_FUNCTION int fz_count_archive_entries() const;

	/** Class-aware wrapper for `::fz_has_archive_entry()`.  */
	/**
		Check if entry by given name exists.
	
		If named entry does not exist 0 will be returned, if it does
		exist 1 is returned.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	*/
	FZ_FUNCTION int fz_has_archive_entry(const char *name) const;

	/** Class-aware wrapper for `::fz_list_archive_entry()`.  */
	/**
		Get listed name of entry position idx.
	
		idx: Must be a value >= 0 < return value from
		fz_count_archive_entries. If not in range NULL will be
		returned.
	
		May throw an exception if this type of archive cannot list the
		entries (such as a directory).
	*/
	FZ_FUNCTION const char *fz_list_archive_entry(int idx) const;

	/** Class-aware wrapper for `::fz_mount_multi_archive()`.  */
	/**
		Add an archive to the set of archives handled by a multi
		archive.
	
		If path is NULL, then the archive contents will appear at the
		top level, otherwise, the archives contents will appear prefixed
		by path.
	*/
	FZ_FUNCTION void fz_mount_multi_archive(const FzArchive& sub, const char *path) const;

	/** Class-aware wrapper for `::fz_open_archive_entry()`.  */
	/**
		Opens an archive entry as a stream.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	
		Throws an exception if a matching entry cannot be found.
	*/
	FZ_FUNCTION FzStream fz_open_archive_entry(const char *name) const;

	/** Class-aware wrapper for `::fz_parse_xml_archive_entry()`.  */
	/**
		Parse the contents of an archive entry into a tree of xml nodes.
	
		preserve_white: whether to keep or delete all-whitespace nodes.
	*/
	FZ_FUNCTION FzXml fz_parse_xml_archive_entry(const char *filename, int preserve_white) const;

	/** Class-aware wrapper for `::fz_read_archive_entry()`.  */
	/**
		Reads all bytes in an archive entry
		into a buffer.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	
		Throws an exception if a matching entry cannot be found.
	*/
	FZ_FUNCTION FzBuffer fz_read_archive_entry(const char *name) const;

	/** Class-aware wrapper for `::fz_tree_archive_add_buffer()`.  */
	/**
		Add a named buffer to an existing tree archive.
	
		The tree will take a new reference to the buffer. Ownership
		is not transferred.
	*/
	FZ_FUNCTION void fz_tree_archive_add_buffer(const char *name, const FzBuffer& buf) const;

	/** Class-aware wrapper for `::fz_tree_archive_add_data()`.  */
	/**
		Add a named block of data to an existing tree archive.
	
		The data will be copied into a buffer, and so the caller
		may free it as soon as this returns.
	*/
	FZ_FUNCTION void fz_tree_archive_add_data(const char *name, const void *data, size_t size) const;

	/** Class-aware wrapper for `::fz_try_open_archive_entry()`.  */
	/**
		Opens an archive entry as a stream.
	
		Returns NULL if a matching entry cannot be found, otherwise
		behaves exactly as fz_open_archive_entry.
	*/
	FZ_FUNCTION FzStream fz_try_open_archive_entry(const char *name) const;

	/** Class-aware wrapper for `::fz_try_parse_xml_archive_entry()`.  */
	/**
		Try and parse the contents of an archive entry into a tree of xml nodes.
	
		preserve_white: whether to keep or delete all-whitespace nodes.
	
		Will return NULL if the archive entry can't be found. Otherwise behaves
		the same as fz_parse_xml_archive_entry. May throw exceptions.
	*/
	FZ_FUNCTION FzXml fz_try_parse_xml_archive_entry(const char *filename, int preserve_white) const;

	/** Class-aware wrapper for `::fz_try_read_archive_entry()`.  */
	/**
		Reads all bytes in an archive entry
		into a buffer.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	
		Returns NULL if a matching entry cannot be found. Otherwise behaves
		the same as fz_read_archive_entry. Exceptions may be thrown.
	*/
	FZ_FUNCTION FzBuffer fz_try_read_archive_entry(const char *name) const;

	/** Constructor using raw copy of pre-existing `::fz_archive`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_archive* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzArchive(::fz_archive* internal);

	/** Destructor using fz_drop_archive(). */
	FZ_FUNCTION ~FzArchive();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_archive* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_archive_handler`. Not copyable or assignable. */
struct FzArchiveHandler
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzArchiveHandler();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_register_archive_handler()`.  */
	FZ_FUNCTION void fz_register_archive_handler() const;

	/** Constructor using raw copy of pre-existing `::fz_archive_handler`. */
	FZ_FUNCTION FzArchiveHandler(::fz_archive_handler* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzArchiveHandler();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_archive_handler* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzArchiveHandler(const FzArchiveHandler& rhs);
	FzArchiveHandler& operator=(const FzArchiveHandler& rhs);
};

/** Wrapper class for struct `fz_archive_handler_context`. Not copyable or assignable. */
struct FzArchiveHandlerContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzArchiveHandlerContext();

	/** Constructor using raw copy of pre-existing `::fz_archive_handler_context`. */
	FZ_FUNCTION FzArchiveHandlerContext(::fz_archive_handler_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzArchiveHandlerContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_archive_handler_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzArchiveHandlerContext(const FzArchiveHandlerContext& rhs);
	FzArchiveHandlerContext& operator=(const FzArchiveHandlerContext& rhs);
};

/** Wrapper class for struct `fz_band_writer`. Not copyable or assignable. */
/**
	fz_band_writer
*/
struct FzBandWriter
{
	/* We use these enums to support construction via all the relevant MuPDF functions. */

	enum Cm
	{
		MONO,
		COLOR,
	};
	enum P
	{
		PNG,
		PNM,
		PAM,
		PBM,
		PKM,
		PS,
		PSD,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_band_writer_of_size()`. */
	FZ_FUNCTION FzBandWriter(size_t size, const FzOutput& out);

	/** Constructor using `fz_new_color_pcl_band_writer()`. */
	/**
		Create a new band writer, outputting color pcl.
	*/
	/* Disabled because same args as fz_new_mono_pcl_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out, const FzPclOptions& options);
	*/

	/** Constructor using `fz_new_mono_pcl_band_writer()`. */
	/**
		Create a new band writer, outputting monochrome pcl.
	*/
	FZ_FUNCTION FzBandWriter(const FzOutput& out, const FzPclOptions& options);

	/** Constructor using `fz_new_mono_pwg_band_writer()`. */
	/**
		Create a new monochrome pwg band writer.
	*/
	FZ_FUNCTION FzBandWriter(const FzOutput& out, FzPwgOptions& pwg);

	/** Constructor using `fz_new_pam_band_writer()`. */
	/**
		Create a band writer targeting pnm (greyscale, rgb or cmyk,
		with or without alpha).
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_pbm_band_writer()`. */
	/**
		Create a new band writer, targeting pbm.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_pclm_band_writer()`. */
	/**
		Create a new band writer, outputting pclm
	*/
	FZ_FUNCTION FzBandWriter(const FzOutput& out, const FzPclmOptions& options);

	/** Constructor using `fz_new_pdfocr_band_writer()`. */
	/**
		Create a new band writer, outputting pdfocr.
	
		Ownership of output stays with the caller, the band writer
		borrows the reference. The caller must keep the output around
		for the duration of the band writer, and then close/drop as
		appropriate.
	*/
	FZ_FUNCTION FzBandWriter(const FzOutput& out, FzPdfocrOptions& options);

	/** Constructor using `fz_new_pkm_band_writer()`. */
	/**
		Create a new pkm band writer for CMYK pixmaps.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_png_band_writer()`. */
	/**
		Create a new png band writer (greyscale or RGB, with or without
		alpha).
	*/
	FZ_FUNCTION FzBandWriter(const FzOutput& out);

	/** Constructor using `fz_new_pnm_band_writer()`. */
	/**
		Create a band writer targeting pnm (greyscale or rgb, no
		alpha).
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_ps_band_writer()`. */
	/**
		Create a postscript band writer for gray, rgb, or cmyk, no
		alpha.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_psd_band_writer()`. */
	/**
		Open a PSD band writer.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out);
	*/

	/** Constructor using `fz_new_pwg_band_writer()`. */
	/**
		Create a new color pwg band writer.
	*/
	/* Disabled because same args as fz_new_mono_pwg_band_writer.
	FZ_FUNCTION FzBandWriter(const FzOutput& out, FzPwgOptions& pwg);
	*/

	/** Constructor using fz_new_mono_pcl_band_writer() or fz_new_color_pcl_band_writer(). */
	FZ_FUNCTION FzBandWriter(FzOutput& out, Cm cm, const FzPclOptions& options);

	/** Constructor using fz_new_p*_band_writer(). */
	FZ_FUNCTION FzBandWriter(FzOutput& out, P p);

	/** Constructor using fz_new_mono_pwg_band_writer() or fz_new_pwg_band_writer(). */
	FZ_FUNCTION FzBandWriter(FzOutput& out, Cm cm, const FzPwgOptions& options);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzBandWriter();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_close_band_writer()`.  */
	/**
		Finishes up the output and closes the band writer. After this
		call no more headers or bands may be written.
	*/
	FZ_FUNCTION void fz_close_band_writer() const;

	/** Class-aware wrapper for `::fz_pdfocr_band_writer_set_progress()`.  */
	/**
		Set the progress callback for a pdfocr bandwriter.
	*/
	FZ_FUNCTION void fz_pdfocr_band_writer_set_progress(::fz_pdfocr_progress_fn *progress_fn, void *progress_arg) const;

	/** Class-aware wrapper for `::fz_write_band()`.  */
	/**
		Cause a band writer to write the next band
		of data for an image.
	
		stride: The byte offset from the first byte of the data
		for a pixel to the first byte of the data for the same pixel
		on the row below.
	
		band_height: The number of lines in this band.
	
		samples: Pointer to first byte of the data.
	*/
	FZ_FUNCTION void fz_write_band(int stride, int band_height, const unsigned char *samples) const;

	/** Class-aware wrapper for `::fz_write_header()`.  */
	/**
		Cause a band writer to write the header for
		a banded image with the given properties/dimensions etc. This
		also configures the bandwriter for the format of the data to be
		passed in future calls.
	
		w, h: Width and Height of the entire page.
	
		n: Number of components (including spots and alphas).
	
		alpha: Number of alpha components.
	
		xres, yres: X and Y resolutions in dpi.
	
		cs: Colorspace (NULL for bitmaps)
	
		seps: Separation details (or NULL).
	*/
	FZ_FUNCTION void fz_write_header(int w, int h, int n, int alpha, int xres, int yres, int pagenum, const FzColorspace& cs, const FzSeparations& seps) const;

	/** Constructor using raw copy of pre-existing `::fz_band_writer`. */
	FZ_FUNCTION FzBandWriter(::fz_band_writer* internal);

	/** Destructor using fz_drop_band_writer(). */
	FZ_FUNCTION ~FzBandWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_band_writer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzBandWriter(const FzBandWriter& rhs);
	FzBandWriter& operator=(const FzBandWriter& rhs);
};

/** Wrapper class for struct `fz_bitmap`. */
/**
	Bitmaps have 1 bit per component. Only used for creating
	halftoned versions of contone buffers, and saving out. Samples
	are stored msb first, akin to pbms.

	The internals of this struct are considered implementation
	details and subject to change. Where possible, accessor
	functions should be used in preference.
*/
struct FzBitmap
{
	/** == Constructors. */

	/** Constructor using `fz_new_bitmap()`. */
	/**
		Create a new bitmap.
	
		w, h: Width and Height for the bitmap
	
		n: Number of color components (assumed to be a divisor of 8)
	
		xres, yres: X and Y resolutions (in pixels per inch).
	
		Returns pointer to created bitmap structure. The bitmap
		data is uninitialised.
	*/
	FZ_FUNCTION FzBitmap(int w, int h, int n, int xres, int yres);

	/** Constructor using `fz_new_bitmap_from_image()`. */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		img: The image to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap(const FzImage& img, const FzHalftone& ht);

	/** Constructor using `fz_new_bitmap_from_pixmap()`. */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap(const FzPixmap& pix, const FzHalftone& ht);

	/** Constructor using `fz_new_bitmap_from_pixmap_band()`. */
	/**
		Make a bitmap from a pixmap and a
		halftone, allowing for the position of the pixmap within an
		overall banded rendering.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		band_start: Vertical offset within the overall banded rendering
		(in pixels)
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap(const FzPixmap& pix, const FzHalftone& ht, int band_start);

	/** Copy constructor using `fz_keep_bitmap()`. */
	FZ_FUNCTION FzBitmap(const FzBitmap& rhs);

	/** operator= using `fz_keep_bitmap()` and `fz_drop_bitmap()`. */
	FZ_FUNCTION FzBitmap& operator=(const FzBitmap& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzBitmap();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bitmap_details()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_bitmap_details()` => `(int w, int h, int n, int stride)`
	 */
	/**
		Retrieve details of a given bitmap.
	
		bitmap: The bitmap to query.
	
		w: Pointer to storage to retrieve width (or NULL).
	
		h: Pointer to storage to retrieve height (or NULL).
	
		n: Pointer to storage to retrieve number of color components (or
		NULL).
	
		stride: Pointer to storage to retrieve bitmap stride (or NULL).
	*/
	FZ_FUNCTION void fz_bitmap_details(int *w, int *h, int *n, int *stride) const;

	/** Class-aware wrapper for `::fz_clear_bitmap()`.  */
	/**
		Set the entire bitmap to 0.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void fz_clear_bitmap() const;

	/** Class-aware wrapper for `::fz_invert_bitmap()`.  */
	/**
		Invert bitmap.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void fz_invert_bitmap() const;

	/** Class-aware wrapper for `::fz_save_bitmap_as_pbm()`.  */
	/**
		Save a bitmap as a pbm.
	*/
	FZ_FUNCTION void fz_save_bitmap_as_pbm(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_bitmap_as_pcl()`.  */
	/**
		Save a bitmap as mono PCL.
	*/
	FZ_FUNCTION void fz_save_bitmap_as_pcl(char *filename, int append, const FzPclOptions& pcl) const;

	/** Class-aware wrapper for `::fz_save_bitmap_as_pkm()`.  */
	/**
		Save a CMYK bitmap as a pkm.
	*/
	FZ_FUNCTION void fz_save_bitmap_as_pkm(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_bitmap_as_pwg()`.  */
	/**
		Save a bitmap as a PWG.
	*/
	FZ_FUNCTION void fz_save_bitmap_as_pwg(char *filename, int append, FzPwgOptions& pwg) const;

	/** Constructor using raw copy of pre-existing `::fz_bitmap`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_bitmap* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzBitmap(::fz_bitmap* internal);

	/* == Accessors to members of ::fz_bitmap m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION int stride();
	FZ_FUNCTION int n();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION const unsigned char *samples();

	/** Destructor using fz_drop_bitmap(). */
	FZ_FUNCTION ~FzBitmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_bitmap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_buffer`. */
/**
	fz_buffer is a wrapper around a dynamically allocated array of
	bytes.

	Buffers have a capacity (the number of bytes storage immediately
	available) and a current size.

	The contents of the structure are considered implementation
	details and are subject to change. Users should use the accessor
	functions in preference.
*/
struct FzBuffer
{
	/** == Constructors. */

	/** Constructor using `fz_new_buffer()`. */
	FZ_FUNCTION FzBuffer(size_t capacity);

	/** Constructor using `fz_new_buffer_from_base64()`. */
	/**
		Create a new buffer with data decoded from a base64 input string.
	*/
	FZ_FUNCTION FzBuffer(const char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_data()`. */
	/**
		Create a new buffer with existing data.
	
		data: Pointer to existing data.
		size: Size of existing data.
	
		Takes ownership of data. Does not make a copy. Calls fz_free on
		the data when the buffer is deallocated. Do not use 'data' after
		passing to this function.
	
		Returns pointer to new buffer. Throws exception on allocation
		failure.
	*/
	FZ_FUNCTION FzBuffer(unsigned char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_display_list()`. */
	FZ_FUNCTION FzBuffer(const FzDisplayList& list, FzStextOptions& options);

	/** Constructor using `fz_new_buffer_from_image_as_jpeg()`. */
	FZ_FUNCTION FzBuffer(const FzImage& image, const FzColorParams& color_params, int quality, int invert_cmyk);

	/** Constructor using `fz_new_buffer_from_image_as_jpx()`. */
	FZ_FUNCTION FzBuffer(const FzImage& image, const FzColorParams& color_params, int quality);

	/** Constructor using `fz_new_buffer_from_image_as_png()`. */
	/**
		Re-encode a given image as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION FzBuffer(const FzImage& image, const FzColorParams& color_params);

	/** Constructor using `fz_new_buffer_from_page()`. */
	FZ_FUNCTION FzBuffer(const FzPage& page, FzStextOptions& options);

	/** Constructor using `fz_new_buffer_from_page_number()`. */
	FZ_FUNCTION FzBuffer(const FzDocument& doc, int number, FzStextOptions& options);

	/** Constructor using `fz_new_buffer_from_page_with_format()`. */
	/**
		Returns an fz_buffer containing a page after conversion to specified format.
	
		page: The page to convert.
		format, options: Passed to fz_new_document_writer_with_output() internally.
		transform, cookie: Passed to fz_run_page() internally.
	*/
	FZ_FUNCTION FzBuffer(const FzPage& page, const char *format, const char *options, const FzMatrix& transform, FzCookie& cookie);

	/** Constructor using `fz_new_buffer_from_pixmap_as_jpeg()`. */
	FZ_FUNCTION FzBuffer(const FzPixmap& pixmap, const FzColorParams& color_params, int quality, int invert_cmyk);

	/** Constructor using `fz_new_buffer_from_pixmap_as_jpx()`. */
	FZ_FUNCTION FzBuffer(const FzPixmap& pix, const FzColorParams& color_params, int quality);

	/** Constructor using `fz_new_buffer_from_pixmap_as_png()`. */
	/**
		Re-encode a given pixmap as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION FzBuffer(const FzPixmap& pixmap, const FzColorParams& color_params);

	/** Constructor using `fz_new_buffer_from_shared_data()`. */
	/**
		Like fz_new_buffer, but does not take ownership.
	*/
	FZ_FUNCTION FzBuffer(const unsigned char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_stext_page()`. */
	/**
		Convert structured text into plain text.
	*/
	FZ_FUNCTION FzBuffer(const FzStextPage& text);

	/** Constructor using `fz_read_file()`. */
	/**
		Read all the contents of a file into a buffer.
	*/
	FZ_FUNCTION FzBuffer(const char *filename);

	/** Copy constructor using `fz_keep_buffer()`. */
	FZ_FUNCTION FzBuffer(const FzBuffer& rhs);

	/** operator= using `fz_keep_buffer()` and `fz_drop_buffer()`. */
	FZ_FUNCTION FzBuffer& operator=(const FzBuffer& rhs);

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_new_buffer_from_copied_data()`.  */
	/**
		Create a new buffer containing a copy of the passed data.
	*/
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_copied_data(const unsigned char *data, size_t size);

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pbm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_image_as_pbm(const FzImage& image, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pkm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_image_as_pkm(const FzImage& image, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pnm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_image_as_pnm(const FzImage& image, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pam()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_image_as_pam(const FzImage& image, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_psd()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_image_as_psd(const FzImage& image, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pbm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_pixmap_as_pbm(const FzPixmap& pixmap, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pkm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_pixmap_as_pkm(const FzPixmap& pixmap, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pnm()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_pixmap_as_pnm(const FzPixmap& pixmap, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pam()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_pixmap_as_pam(const FzPixmap& pixmap, const FzColorParams& color_params);

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_psd()`.  */
	FZ_FUNCTION static FzBuffer fz_new_buffer_from_pixmap_as_psd(const FzPixmap& pix, const FzColorParams& color_params);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_append_base64()`.  */
	/**
		Write a base64 encoded data block, optionally with periodic newlines.
	*/
	FZ_FUNCTION void fz_append_base64(const unsigned char *data, size_t size, int newline) const;

	/** Class-aware wrapper for `::fz_append_base64_buffer()`.  */
	/**
		Append a base64 encoded fz_buffer, optionally with periodic newlines.
	*/
	FZ_FUNCTION void fz_append_base64_buffer(const FzBuffer& data, int newline) const;

	/** Class-aware wrapper for `::fz_append_bits()`.  */
	FZ_FUNCTION void fz_append_bits(int value, int count) const;

	/** Class-aware wrapper for `::fz_append_bits_pad()`.  */
	FZ_FUNCTION void fz_append_bits_pad() const;

	/** Class-aware wrapper for `::fz_append_buffer()`.  */
	/**
		Append the contents of the source buffer onto the end of the
		destination buffer, extending automatically as required.
	
		Ownership of buffers does not change.
	*/
	FZ_FUNCTION void fz_append_buffer(const FzBuffer& source) const;

	/** Class-aware wrapper for `::fz_append_byte()`.  */
	FZ_FUNCTION void fz_append_byte(int c) const;

	/** Class-aware wrapper for `::fz_append_data()`.  */
	/**
		fz_append_*: Append data to a buffer.
	
		The buffer will automatically grow as required.
	*/
	FZ_FUNCTION void fz_append_data(const void *data, size_t len) const;

	/** Class-aware wrapper for `::fz_append_image_as_data_uri()`.  */
	FZ_FUNCTION void fz_append_image_as_data_uri(const FzImage& image) const;

	/** Class-aware wrapper for `::fz_append_int16_be()`.  */
	FZ_FUNCTION void fz_append_int16_be(int x) const;

	/** Class-aware wrapper for `::fz_append_int16_le()`.  */
	FZ_FUNCTION void fz_append_int16_le(int x) const;

	/** Class-aware wrapper for `::fz_append_int32_be()`.  */
	FZ_FUNCTION void fz_append_int32_be(int x) const;

	/** Class-aware wrapper for `::fz_append_int32_le()`.  */
	FZ_FUNCTION void fz_append_int32_le(int x) const;

	/** Class-aware wrapper for `::fz_append_json()`.  */
	FZ_FUNCTION void fz_append_json(const FzJson& value) const;

	/** Class-aware wrapper for `::fz_append_pdf_string()`.  */
	/**
		fz_append_pdf_string: Append a string with PDF syntax quotes and
		escapes.
	
		The buffer will automatically grow as required.
	*/
	FZ_FUNCTION void fz_append_pdf_string(const char *text) const;

	/** Class-aware wrapper for `::fz_append_pixmap_as_data_uri()`.  */
	FZ_FUNCTION void fz_append_pixmap_as_data_uri(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_append_rune()`.  */
	FZ_FUNCTION void fz_append_rune(int c) const;

	/** Class-aware wrapper for `::fz_append_string()`.  */
	FZ_FUNCTION void fz_append_string(const char *data) const;

	/** Class-aware wrapper for `::fz_append_vprintf()`.  */
	/**
		fz_append_vprintf: Format and append data to buffer using
		printf-like formatting with varargs (see fz_vsnprintf).
	*/
	FZ_FUNCTION void fz_append_vprintf(const char *fmt, va_list args) const;

	/** Class-aware wrapper for `::fz_buffer_extract()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_buffer_extract()` => `(size_t, unsigned char *data)`
	 */
	/**
		Take ownership of buffer contents.
	
		Performs the same task as fz_buffer_storage, but ownership of
		the data buffer returns with this call. The buffer is left
		empty.
	
		Note: Bad things may happen if this is called on a buffer with
		multiple references that is being used from multiple threads.
	
		data: Pointer to place to retrieve data pointer.
	
		Returns length of stream.
	*/
	FZ_FUNCTION size_t fz_buffer_extract(unsigned char **data) const;

	/** Class-aware wrapper for `::fz_buffer_storage()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_buffer_storage()` => `(size_t, unsigned char *datap)`
	 */
	/**
		Retrieve internal memory of buffer.
	
		datap: Output parameter that will be pointed to the data.
	
		Returns the current size of the data in bytes.
	*/
	FZ_FUNCTION size_t fz_buffer_storage(unsigned char **datap) const;

	/** Class-aware wrapper for `::fz_clear_buffer()`.  */
	/**
		Empties the buffer. Storage is not freed, but is held ready
		to be reused as the buffer is refilled.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void fz_clear_buffer() const;

	/** Class-aware wrapper for `::fz_clone_buffer()`.  */
	/**
		Make a new buffer, containing a copy of the data used in
		the original.
	*/
	FZ_FUNCTION FzBuffer fz_clone_buffer() const;

	/** Class-aware wrapper for `::fz_grow_buffer()`.  */
	/**
		Make some space within a buffer (i.e. ensure that
		capacity > size).
	*/
	FZ_FUNCTION void fz_grow_buffer() const;

	/** Class-aware wrapper for `::fz_load_jbig2_globals()`.  */
	/**
		Create a jbig2 globals record from a buffer.
	
		Immutable once created.
	*/
	FZ_FUNCTION FzJbig2Globals fz_load_jbig2_globals() const;

	/** Class-aware wrapper for `::fz_md5_buffer()`.  */
	/**
		Create an MD5 digest from buffer contents.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void fz_md5_buffer(unsigned char digest[16]) const;

	/** Class-aware wrapper for `::fz_new_display_list_from_svg()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_new_display_list_from_svg(const char *base_uri, ::fz_archive *dir)` => `(fz_display_list *, float w, float h)`
	 */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION FzDisplayList fz_new_display_list_from_svg(const char *base_uri, const FzArchive& dir, float *w, float *h) const;

	/** Class-aware wrapper for `::fz_new_image_from_buffer()`.  */
	/**
		Create a new image from a
		buffer of data, inferring its type from the format
		of the data.
	*/
	FZ_FUNCTION FzImage fz_new_image_from_buffer() const;

	/** Class-aware wrapper for `::fz_new_image_from_svg()`.  */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION FzImage fz_new_image_from_svg(const char *base_uri, const FzArchive& dir) const;

	/** Class-aware wrapper for `::fz_open_buffer()`.  */
	/**
		Open a buffer as a stream.
	
		buf: The buffer to open. Ownership of the buffer is NOT passed
		in (this function takes its own reference).
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION FzStream fz_open_buffer() const;

	/** Class-aware wrapper for `::fz_parse_xml()`.  */
	/**
		Parse the contents of buffer into a tree of xml nodes.
	
		preserve_white: whether to keep or delete all-whitespace nodes.
	*/
	FZ_FUNCTION FzXml fz_parse_xml(int preserve_white) const;

	/** Class-aware wrapper for `::fz_parse_xml_from_html5()`.  */
	/**
		Parse the contents of a buffer into a tree of XML nodes,
		using the HTML5 parsing algorithm.
	*/
	FZ_FUNCTION FzXml fz_parse_xml_from_html5() const;

	/** Class-aware wrapper for `::fz_resize_buffer()`.  */
	/**
		Ensure that a buffer has a given capacity,
		truncating data if required.
	
		capacity: The desired capacity for the buffer. If the current
		size of the buffer contents is smaller than capacity, it is
		truncated.
	*/
	FZ_FUNCTION void fz_resize_buffer(size_t capacity) const;

	/** Class-aware wrapper for `::fz_save_buffer()`.  */
	/**
		Save the contents of a buffer to a file.
	*/
	FZ_FUNCTION void fz_save_buffer(const char *filename) const;

	/** Class-aware wrapper for `::fz_slice_buffer()`.  */
	/**
		Create a new buffer with a (subset of) the data from the buffer.
	
		start: if >= 0, offset from start of buffer, if < 0 offset from end of buffer.
	
		end: if >= 0, offset from start of buffer, if < 0 offset from end of buffer.
	
	*/
	FZ_FUNCTION FzBuffer fz_slice_buffer(int64_t start, int64_t end) const;

	/** Class-aware wrapper for `::fz_string_from_buffer()`.  */
	/**
		Ensure that a buffer's data ends in a
		0 byte, and return a pointer to it.
	*/
	FZ_FUNCTION const char *fz_string_from_buffer() const;

	/** Class-aware wrapper for `::fz_subset_cff_for_gids()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_subset_cff_for_gids(int num_gids, int symbolic, int cidfont)` => `(fz_buffer *, int gids)`
	 */
	FZ_FUNCTION FzBuffer fz_subset_cff_for_gids(int *gids, int num_gids, int symbolic, int cidfont) const;

	/** Class-aware wrapper for `::fz_subset_ttf_for_gids()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_subset_ttf_for_gids(int num_gids, int symbolic, int cidfont)` => `(fz_buffer *, int gids)`
	 */
	FZ_FUNCTION FzBuffer fz_subset_ttf_for_gids(int *gids, int num_gids, int symbolic, int cidfont) const;

	/** Class-aware wrapper for `::fz_terminate_buffer()`.  */
	/**
		Zero-terminate buffer in order to use as a C string.
	
		This byte is invisible and does not affect the length of the
		buffer as returned by fz_buffer_storage. The zero byte is
		written *after* the data, and subsequent writes will overwrite
		the terminating byte.
	
		Subsequent changes to the size of the buffer (such as by
		fz_buffer_trim, fz_buffer_grow, fz_resize_buffer, etc) may
		invalidate this.
	*/
	FZ_FUNCTION void fz_terminate_buffer() const;

	/** Class-aware wrapper for `::fz_trim_buffer()`.  */
	/**
		Trim wasted capacity from a buffer by resizing internal memory.
	*/
	FZ_FUNCTION void fz_trim_buffer() const;

	/** Class-aware wrapper for `::pdf_append_token()`.  */
	FZ_FUNCTION void pdf_append_token(int tok, const PdfLexbuf& lex) const;

	/** Class-aware wrapper for `::pdf_new_buffer_processor()`.  */
	FZ_FUNCTION PdfProcessor pdf_new_buffer_processor(int ahxencode, int newlines) const;

	/** Constructor using raw copy of pre-existing `::fz_buffer`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_buffer* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzBuffer(::fz_buffer* internal=NULL);

	/** Destructor using fz_drop_buffer(). */
	FZ_FUNCTION ~FzBuffer();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_buffer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_color_params`. */
struct FzColorParams
{
	/** Equivalent to fz_default_color_params. */
	FZ_FUNCTION FzColorParams();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `::fz_color_params`. */
	FZ_FUNCTION FzColorParams(const ::fz_color_params* internal);

	/** Constructor using raw copy of pre-existing `::fz_color_params`. */
	FZ_FUNCTION FzColorParams(const ::fz_color_params internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_color_params* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_color_params* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzColorParams();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_color_params. */
	uint8_t ri;
	uint8_t bp;
	uint8_t op;
	uint8_t opm;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzColorParams& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzColorParams& rhs);
};

/** Wrapper class for struct `fz_colorspace`. */
/**
	Describes a given colorspace.
*/
struct FzColorspace
{
	/* We use this enums to support construction via all the relevant MuPDF functions. */
	enum Fixed
	{
		Fixed_GRAY,
		Fixed_RGB,
		Fixed_BGR,
		Fixed_CMYK,
		Fixed_LAB,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_cal_gray_colorspace()`. */
	/**
		Create a calibrated gray colorspace.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION FzColorspace(float wp[3], float bp[3], float gamma);

	/** Constructor using `fz_new_cal_rgb_colorspace()`. */
	/**
		Create a calibrated rgb colorspace.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION FzColorspace(float wp[3], float bp[3], float gamma[3], float matrix[9]);

	/** Constructor using `fz_new_colorspace()`. */
	/**
		Creates a new colorspace instance and returns a reference.
	
		No internal checking is done that the colorspace type (e.g.
		CMYK) matches with the flags (e.g. FZ_COLORSPACE_HAS_CMYK) or
		colorant count (n) or name.
	
		The reference should be dropped when it is finished with.
	
		Colorspaces are immutable once created (with the exception of
		setting up colorant names for separation spaces).
	*/
	FZ_FUNCTION FzColorspace(enum fz_colorspace_type type, int flags, int n, const char *name);

	/** Constructor using `fz_new_icc_colorspace()`. */
	/**
		Create a colorspace from an ICC profile supplied in buf.
	
		Limited checking is done to ensure that the colorspace type is
		appropriate for the supplied ICC profile.
	
		An additional reference is taken to buf, which will be dropped
		on destruction. Ownership is NOT passed in.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION FzColorspace(enum fz_colorspace_type type, int flags, const char *name, const FzBuffer& buf);

	/** Constructor using `fz_new_indexed_colorspace()`. */
	/**
		Create an indexed colorspace.
	
		The supplied lookup table is high palette entries long. Each
		entry is n bytes long, where n is given by the number of
		colorants in the base colorspace, one byte per colorant.
	
		Ownership of lookup is passed it; it will be freed on
		destruction, so must be heap allocated.
	
		The colorspace will keep an additional reference to the base
		colorspace that will be dropped on destruction.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION FzColorspace(const FzColorspace& base, int high, unsigned char *lookup);

	/** Construct using one of: fz_device_gray(), fz_device_rgb(), fz_device_bgr(), fz_device_cmyk(), fz_device_lab(). */
	FZ_FUNCTION FzColorspace(Fixed fixed);

	/** Copy constructor using `fz_keep_colorspace()`. */
	FZ_FUNCTION FzColorspace(const FzColorspace& rhs);

	/** operator= using `fz_keep_colorspace()` and `fz_drop_colorspace()`. */
	FZ_FUNCTION FzColorspace& operator=(const FzColorspace& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzColorspace();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_base_colorspace()`.  */
	/**
		Get the 'base' colorspace for a colorspace.
	
		For indexed colorspaces, this is the colorspace the index
		decodes into. For all other colorspaces, it is the colorspace
		itself.
	
		The returned colorspace is 'borrowed' (i.e. no additional
		references are taken or dropped).
	*/
	FZ_FUNCTION FzColorspace fz_base_colorspace() const;

	/** Class-aware wrapper for `::fz_clamp_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_clamp_color(const float *in)` => float out
	 */
	/**
		Clamp the samples in a color to the correct ranges for a
		given colorspace.
	*/
	FZ_FUNCTION void fz_clamp_color(const float *in, float *out) const;

	/** Class-aware wrapper for `::fz_colorspace_colorant()`.  */
	/**
		Retrieve a the name for a colorant.
	
		Returns a pointer with the same lifespan as the colorspace.
	*/
	FZ_FUNCTION const char *fz_colorspace_colorant(int n) const;

	/** Class-aware wrapper for `::fz_colorspace_device_n_has_cmyk()`.  */
	/**
		True if DeviceN color space has cyan magenta yellow or black as
		one of its colorants.
	*/
	FZ_FUNCTION int fz_colorspace_device_n_has_cmyk() const;

	/** Class-aware wrapper for `::fz_colorspace_device_n_has_only_cmyk()`.  */
	/**
		True if DeviceN color space has only colorants from the CMYK set.
	*/
	FZ_FUNCTION int fz_colorspace_device_n_has_only_cmyk() const;

	/** Class-aware wrapper for `::fz_colorspace_digest()`.  */
	/**
		Get checksum of underlying ICC profile.
	*/
	FZ_FUNCTION void fz_colorspace_digest(unsigned char digest[16]) const;

	/** Class-aware wrapper for `::fz_colorspace_is_cmyk()`.  */
	FZ_FUNCTION int fz_colorspace_is_cmyk() const;

	/** Class-aware wrapper for `::fz_colorspace_is_device()`.  */
	FZ_FUNCTION int fz_colorspace_is_device() const;

	/** Class-aware wrapper for `::fz_colorspace_is_device_cmyk()`.  */
	FZ_FUNCTION int fz_colorspace_is_device_cmyk() const;

	/** Class-aware wrapper for `::fz_colorspace_is_device_gray()`.  */
	FZ_FUNCTION int fz_colorspace_is_device_gray() const;

	/** Class-aware wrapper for `::fz_colorspace_is_device_n()`.  */
	FZ_FUNCTION int fz_colorspace_is_device_n() const;

	/** Class-aware wrapper for `::fz_colorspace_is_gray()`.  */
	/**
		Tests for particular types of colorspaces
	*/
	FZ_FUNCTION int fz_colorspace_is_gray() const;

	/** Class-aware wrapper for `::fz_colorspace_is_icc()`.  */
	FZ_FUNCTION int fz_colorspace_is_icc() const;

	/** Class-aware wrapper for `::fz_colorspace_is_indexed()`.  */
	FZ_FUNCTION int fz_colorspace_is_indexed() const;

	/** Class-aware wrapper for `::fz_colorspace_is_lab()`.  */
	FZ_FUNCTION int fz_colorspace_is_lab() const;

	/** Class-aware wrapper for `::fz_colorspace_is_lab_icc()`.  */
	FZ_FUNCTION int fz_colorspace_is_lab_icc() const;

	/** Class-aware wrapper for `::fz_colorspace_is_rgb()`.  */
	FZ_FUNCTION int fz_colorspace_is_rgb() const;

	/** Class-aware wrapper for `::fz_colorspace_is_subtractive()`.  */
	/**
		True for CMYK, Separation and DeviceN colorspaces.
	*/
	FZ_FUNCTION int fz_colorspace_is_subtractive() const;

	/** Class-aware wrapper for `::fz_colorspace_n()`.  */
	/**
		Query the number of colorants in a colorspace.
	*/
	FZ_FUNCTION int fz_colorspace_n() const;

	/** Class-aware wrapper for `::fz_colorspace_name()`.  */
	/**
		Query the name of a colorspace.
	
		The returned string has the same lifespan as the colorspace
		does. Caller should not free it.
	*/
	FZ_FUNCTION const char *fz_colorspace_name() const;

	/** Class-aware wrapper for `::fz_colorspace_name_colorant()`.  */
	/**
		Assign a name for a given colorant in a colorspace.
	
		Used while initially setting up a colorspace. The string is
		copied into local storage, so need not be retained by the
		caller.
	*/
	FZ_FUNCTION void fz_colorspace_name_colorant(int n, const char *name) const;

	/** Class-aware wrapper for `::fz_colorspace_type()`.  */
	/**
		Query the type of colorspace.
	*/
	FZ_FUNCTION enum fz_colorspace_type fz_colorspace_type() const;

	/** Class-aware wrapper for `::fz_convert_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_convert_color(const float *sv, ::fz_colorspace *ds, ::fz_colorspace *is, ::fz_color_params params)` => float dv
	 */
	/**
		Convert color values sv from colorspace ss into colorvalues dv
		for colorspace ds, via an optional intervening space is,
		respecting the given color_params.
	*/
	FZ_FUNCTION void fz_convert_color(const float *sv, const FzColorspace& ds, float *dv, const FzColorspace& is, const FzColorParams& params) const;

	/** Class-aware wrapper for `::fz_convert_separation_colors()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_convert_separation_colors(const float *src_color, ::fz_separations *dst_seps, ::fz_colorspace *dst_cs, ::fz_color_params color_params)` => float dst_color
	 */
	/**
		Convert a color given in terms of one colorspace,
		to a color in terms of another colorspace/separations.
	*/
	FZ_FUNCTION void fz_convert_separation_colors(const float *src_color, const FzSeparations& dst_seps, const FzColorspace& dst_cs, float *dst_color, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_is_valid_blend_colorspace()`.  */
	/**
		Check to see that a colorspace is appropriate to be used as
		a blending space (i.e. only grey, rgb or cmyk).
	*/
	FZ_FUNCTION int fz_is_valid_blend_colorspace() const;

	/** Class-aware wrapper for `::fz_new_indexed_colorspace()`.  */
	/**
		Create an indexed colorspace.
	
		The supplied lookup table is high palette entries long. Each
		entry is n bytes long, where n is given by the number of
		colorants in the base colorspace, one byte per colorant.
	
		Ownership of lookup is passed it; it will be freed on
		destruction, so must be heap allocated.
	
		The colorspace will keep an additional reference to the base
		colorspace that will be dropped on destruction.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION FzColorspace fz_new_indexed_colorspace(int high, unsigned char *lookup) const;

	/** Class-aware wrapper for `::fz_new_pixmap()`.  */
	/**
		Create a new pixmap, with its origin at (0,0)
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap(int w, int h, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_with_bbox()`.  */
	/**
		Create a pixmap of a given size, location and pixel format.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		bbox: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_with_bbox(const FzIrect& bbox, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_with_bbox_and_data()`.  */
	/**
		Create a pixmap of a given size, location and pixel format,
		using the supplied data block.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		rect: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: Number of alpha planes (0 or 1).
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_with_bbox_and_data(const FzIrect& rect, const FzSeparations& seps, int alpha, unsigned char *samples) const;

	/** Class-aware wrapper for `::fz_new_pixmap_with_data()`.  */
	/**
		Create a new pixmap, with its origin at
		(0,0) using the supplied data block.
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		stride: The byte offset from the pixel data in a row to the
		pixel data in the next row.
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure to
		allocate.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_with_data(int w, int h, const FzSeparations& seps, int alpha, int stride, unsigned char *samples) const;

	/** Class-aware wrapper for `::pdf_is_tint_colorspace()`.  */
	FZ_FUNCTION int pdf_is_tint_colorspace() const;

	/** Constructor using raw copy of pre-existing `::fz_colorspace`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_colorspace* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzColorspace(::fz_colorspace* internal);

	/** Destructor using fz_drop_colorspace(). */
	FZ_FUNCTION ~FzColorspace();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_colorspace* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_colorspace_context`. Not copyable or assignable. */
struct FzColorspaceContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzColorspaceContext();

	/** Constructor using raw copy of pre-existing `::fz_colorspace_context`. */
	FZ_FUNCTION FzColorspaceContext(::fz_colorspace_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzColorspaceContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_colorspace_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzColorspaceContext(const FzColorspaceContext& rhs);
	FzColorspaceContext& operator=(const FzColorspaceContext& rhs);
};

/** Wrapper class for struct `fz_compressed_buffer`. */
/**
	Buffers of compressed data; typically for the source data
	for images.
*/
struct FzCompressedBuffer
{
	/** == Constructors. */

	/** Constructor using `fz_new_compressed_buffer()`. */
	/**
		Create a new, UNKNOWN format, compressed_buffer.
	*/
	FZ_FUNCTION FzCompressedBuffer();

	/** Copy constructor using `fz_keep_compressed_buffer()`. */
	FZ_FUNCTION FzCompressedBuffer(const FzCompressedBuffer& rhs);

	/** operator= using `fz_keep_compressed_buffer()` and `fz_drop_compressed_buffer()`. */
	FZ_FUNCTION FzCompressedBuffer& operator=(const FzCompressedBuffer& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_compressed_buffer_size()`.  */
	/**
		Return the storage size used for a buffer and its data.
		Used in implementing store handling.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION size_t fz_compressed_buffer_size() const;

	/** Class-aware wrapper for `::fz_open_compressed_buffer()`.  */
	/**
		Open a stream to read the decompressed version of a buffer.
	*/
	FZ_FUNCTION FzStream fz_open_compressed_buffer() const;

	/** Class-aware wrapper for `::fz_open_image_decomp_stream_from_buffer()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_open_image_decomp_stream_from_buffer()` => `(fz_stream *, int l2factor)`
	 */
	/**
		Open a stream to read the decompressed version of a buffer,
		with optional log2 subsampling.
	
		l2factor = NULL for no subsampling, or a pointer to an integer
		containing the maximum log2 subsample factor acceptable (0 =
		none, 1 = halve dimensions, 2 = quarter dimensions etc). If
		non-NULL, then *l2factor will be updated on exit with the actual
		log2 subsample factor achieved.
	*/
	FZ_FUNCTION FzStream fz_open_image_decomp_stream_from_buffer(int *l2factor) const;

	/** Returns wrapper class for fz_buffer *m_internal.buffer. */
	FZ_FUNCTION FzBuffer get_buffer();

	/** Constructor using raw copy of pre-existing `::fz_compressed_buffer`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_compressed_buffer* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzCompressedBuffer(::fz_compressed_buffer* internal);

	/** Destructor using fz_drop_compressed_buffer(). */
	FZ_FUNCTION ~FzCompressedBuffer();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_compressed_buffer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_compressed_image`. Not copyable or assignable. */
struct FzCompressedImage
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzCompressedImage();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_set_compressed_image_buffer()`.  */
	FZ_FUNCTION void fz_set_compressed_image_buffer(const FzCompressedBuffer& buf) const;

	/** Constructor using raw copy of pre-existing `::fz_compressed_image`. */
	FZ_FUNCTION FzCompressedImage(::fz_compressed_image* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzCompressedImage();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_compressed_image* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzCompressedImage(const FzCompressedImage& rhs);
	FzCompressedImage& operator=(const FzCompressedImage& rhs);
};

/** Wrapper class for struct `fz_compression_params`. Not copyable or assignable. */
/**
	Compression parameters used for buffers of compressed data;
	typically for the source data for images.
*/
struct FzCompressionParams
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzCompressionParams();

	/** Constructor using raw copy of pre-existing `::fz_compression_params`. */
	FZ_FUNCTION FzCompressionParams(::fz_compression_params* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzCompressionParams();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_compression_params* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzCompressionParams(const FzCompressionParams& rhs);
	FzCompressionParams& operator=(const FzCompressionParams& rhs);
};

/** Wrapper class for struct `fz_context`. Not copyable or assignable. */
struct FzContext
{
	/** == Constructors. */

	/** Constructor using `fz_new_context_imp()`. */
	FZ_FUNCTION FzContext(const FzAllocContext& alloc, const FzLocksContext& locks, size_t max_store, const char *version);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzContext();

	/** Constructor using raw copy of pre-existing `::fz_context`. */
	FZ_FUNCTION FzContext(::fz_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzContext(const FzContext& rhs);
	FzContext& operator=(const FzContext& rhs);
};

/** Wrapper class for struct `fz_cookie`. Not copyable or assignable. */
/**
	Provide two-way communication between application and library.
	Intended for multi-threaded applications where one thread is
	rendering pages and another thread wants to read progress
	feedback or abort a job that takes a long time to finish. The
	communication is unsynchronized without locking.

	abort: The application should set this field to 0 before
	calling fz_run_page to render a page. At any point when the
	page is being rendered the application my set this field to 1
	which will cause the rendering to finish soon. This field is
	checked periodically when the page is rendered, but exactly
	when is not known, therefore there is no upper bound on
	exactly when the rendering will abort. If the application
	did not provide a set of locks to fz_new_context, it must also
	await the completion of fz_run_page before issuing another
	call to fz_run_page. Note that once the application has set
	this field to 1 after it called fz_run_page it may not change
	the value again.

	progress: Communicates rendering progress back to the
	application and is read only. Increments as a page is being
	rendered. The value starts out at 0 and is limited to less
	than or equal to progress_max, unless progress_max is -1.

	progress_max: Communicates the known upper bound of rendering
	back to the application and is read only. The maximum value
	that the progress field may take. If there is no known upper
	bound on how long the rendering may take this value is -1 and
	progress is not limited. Note that the value of progress_max
	may change from -1 to a positive value once an upper bound is
	known, so take this into consideration when comparing the
	value of progress to that of progress_max.

	errors: count of errors during current rendering.

	incomplete: Initially should be set to 0. Will be set to
	non-zero if a TRYLATER error is thrown during rendering.
*/
struct FzCookie
{
	/** Default constructor sets all fields to default values. */
	FZ_FUNCTION FzCookie();

	/* == Methods. */

	/** Sets m_internal.abort to 1. */
	FZ_FUNCTION void set_abort();

	/** Increments m_internal.errors by <delta>. */
	FZ_FUNCTION void increment_errors(int delta);

	/* == Accessors to members of ::fz_cookie m_internal. */

	FZ_FUNCTION int abort();
	FZ_FUNCTION int progress();
	FZ_FUNCTION size_t progress_max();
	FZ_FUNCTION int errors();
	FZ_FUNCTION int incomplete();

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzCookie();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	::fz_cookie  m_internal; /** Wrapped data is held by value. */

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzCookie& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzCookie& rhs);

	private:

	/** This class is not copyable or assignable. */
	FzCookie(const FzCookie& rhs);
	FzCookie& operator=(const FzCookie& rhs);
};

/** Wrapper class for struct `fz_default_colorspaces`. */
/**
	Structure to hold default colorspaces.
*/
struct FzDefaultColorspaces
{
	/** == Constructors. */

	/** Constructor using `fz_new_default_colorspaces()`. */
	/**
		Create a new default colorspace structure with values inherited
		from the context, and return a reference to it.
	
		These can be overridden using fz_set_default_xxxx.
	
		These should not be overridden while more than one caller has
		the reference for fear of race conditions.
	
		The caller should drop this reference once finished with it.
	*/
	FZ_FUNCTION FzDefaultColorspaces();

	/** Copy constructor using `fz_keep_default_colorspaces()`. */
	FZ_FUNCTION FzDefaultColorspaces(const FzDefaultColorspaces& rhs);

	/** operator= using `fz_keep_default_colorspaces()` and `fz_drop_default_colorspaces()`. */
	FZ_FUNCTION FzDefaultColorspaces& operator=(const FzDefaultColorspaces& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_clone_default_colorspaces()`.  */
	/**
		Returns a reference to a newly cloned default colorspaces
		structure.
	
		The new clone may safely be altered without fear of race
		conditions as the caller is the only reference holder.
	*/
	FZ_FUNCTION FzDefaultColorspaces fz_clone_default_colorspaces() const;

	/** Class-aware wrapper for `::fz_default_cmyk()`.  */
	FZ_FUNCTION FzColorspace fz_default_cmyk() const;

	/** Class-aware wrapper for `::fz_default_gray()`.  */
	/**
		Retrieve default colorspaces (typically page local).
	
		If default_cs is non NULL, the default is retrieved from there,
		otherwise the global default is retrieved.
	
		These return borrowed references that should not be dropped,
		unless they are kept first.
	*/
	FZ_FUNCTION FzColorspace fz_default_gray() const;

	/** Class-aware wrapper for `::fz_default_output_intent()`.  */
	FZ_FUNCTION FzColorspace fz_default_output_intent() const;

	/** Class-aware wrapper for `::fz_default_rgb()`.  */
	FZ_FUNCTION FzColorspace fz_default_rgb() const;

	/** Class-aware wrapper for `::fz_set_default_cmyk()`.  */
	FZ_FUNCTION void fz_set_default_cmyk(const FzColorspace& cs) const;

	/** Class-aware wrapper for `::fz_set_default_gray()`.  */
	/**
		Set new defaults within the default colorspace structure.
	
		New references are taken to the new default, and references to
		the old defaults dropped.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void fz_set_default_gray(const FzColorspace& cs) const;

	/** Class-aware wrapper for `::fz_set_default_output_intent()`.  */
	FZ_FUNCTION void fz_set_default_output_intent(const FzColorspace& cs) const;

	/** Class-aware wrapper for `::fz_set_default_rgb()`.  */
	FZ_FUNCTION void fz_set_default_rgb(const FzColorspace& cs) const;

	/** Class-aware wrapper for `::pdf_update_default_colorspaces()`.  */
	FZ_FUNCTION FzDefaultColorspaces pdf_update_default_colorspaces(const PdfObj& res) const;

	/** Constructor using raw copy of pre-existing `::fz_default_colorspaces`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_default_colorspaces* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzDefaultColorspaces(::fz_default_colorspaces* internal);

	/** Destructor using fz_drop_default_colorspaces(). */
	FZ_FUNCTION ~FzDefaultColorspaces();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_default_colorspaces* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_device`. */
/**
	The different format handlers (pdf, xps etc) interpret pages to
	a device. These devices can then process the stream of calls
	they receive in various ways:
		The trace device outputs debugging information for the calls.
		The draw device will render them.
		The list device stores them in a list to play back later.
		The text device performs text extraction and searching.
		The bbox device calculates the bounding box for the page.
	Other devices can (and will) be written in the future.
*/
struct FzDevice
{
	/** == Constructors. */

	/** Constructor using `fz_new_bbox_device()`. */
	/**
		Create a device to compute the bounding
		box of all marks on a page.
	
		The returned bounding box will be the union of all bounding
		boxes of all objects on a page.
	*/
	FZ_FUNCTION FzDevice(FzRect& rectp);

	/** Constructor using `fz_new_device_of_size()`. */
	/**
		Devices are created by calls to device implementations, for
		instance: foo_new_device(). These will be implemented by calling
		fz_new_derived_device(ctx, foo_device) where foo_device is a
		structure "derived from" fz_device, for instance
		typedef struct { fz_device base;  ...extras...} foo_device;
	*/
	FZ_FUNCTION FzDevice(int size);

	/** Constructor using `fz_new_draw_device()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	*/
	FZ_FUNCTION FzDevice(const FzMatrix& transform, const FzPixmap& dest);

	/** Constructor using `fz_new_draw_device_with_bbox()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		clip: Bounding box to restrict any marking operations of the
		draw device.
	*/
	FZ_FUNCTION FzDevice(const FzMatrix& transform, const FzPixmap& dest, FzIrect& clip);

	/** Constructor using `fz_new_draw_device_with_bbox_proof()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		clip: Bounding box to restrict any marking operations of the
		draw device.
	
		proof_cs: Color space to render to prior to mapping to color
		space defined by pixmap.
	*/
	FZ_FUNCTION FzDevice(const FzMatrix& transform, const FzPixmap& dest, FzIrect& clip, const FzColorspace& cs);

	/** Constructor using `fz_new_draw_device_with_options()`. */
	/**
		Create a new pixmap and draw device, using the specified options.
	
		options: Options to configure the draw device, and choose the
		resolution and colorspace.
	
		mediabox: The bounds of the page in points.
	
		pixmap: An out parameter containing the newly created pixmap.
	*/
	FZ_FUNCTION FzDevice(FzDrawOptions& options, const FzRect& mediabox, FzPixmap& pixmap);

	/** Constructor using `fz_new_draw_device_with_proof()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		proof_cs: Intermediate color space to map though when mapping to
		color space defined by pixmap.
	*/
	FZ_FUNCTION FzDevice(const FzMatrix& transform, const FzPixmap& dest, const FzColorspace& proof_cs);

	/** Constructor using `fz_new_list_device()`. */
	/**
		Create a rendering device for a display list.
	
		When the device is rendering a page it will populate the
		display list with drawing commands (text, images, etc.). The
		display list can later be reused to render a page many times
		without having to re-interpret the page from the document file
		for each rendering. Once the device is no longer needed, free
		it with fz_drop_device.
	
		list: A display list that the list device takes a reference to.
	*/
	FZ_FUNCTION FzDevice(const FzDisplayList& list);

	/** Constructor using `fz_new_ocr_device()`. */
	/**
		Create a device to OCR the text on the page.
	
		Renders the page internally to a bitmap that is then OCRd. Text
		is then forwarded onto the target device.
	
		target: The target device to receive the OCRd text.
	
		ctm: The transform to apply to the mediabox to get the size for
		the rendered page image. Also used to calculate the resolution
		for the page image. In general, this will be the same as the CTM
		that you pass to fz_run_page (or fz_run_display_list) to feed
		this device.
	
		mediabox: The mediabox (in points). Combined with the CTM to get
		the bounds of the pixmap used internally for the rendered page
		image.
	
		with_list: If with_list is false, then all non-text operations
		are forwarded instantly to the target device. This results in
		the target device seeing all NON-text operations, followed by
		all the text operations (derived from OCR).
	
		If with_list is true, then all the marking operations are
		collated into a display list which is then replayed to the
		target device at the end.
	
		language: NULL (for "eng"), or a pointer to a string to describe
		the languages/scripts that should be used for OCR (e.g.
		"eng,ara").
	
		datadir: NULL (for ""), or a pointer to a path string otherwise
		provided to Tesseract in the TESSDATA_PREFIX environment variable.
	
		progress: NULL, or function to be called periodically to indicate
		progress. Return 0 to continue, or 1 to cancel. progress_arg is
		returned as the void *. The int is a value between 0 and 100 to
		indicate progress.
	
		progress_arg: A void * value to be parrotted back to the progress
		function.
	*/
	FZ_FUNCTION FzDevice(const FzDevice& target, const FzMatrix& ctm, const FzRect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(::fz_context *, void *, int ), void *progress_arg);

	/** Constructor using `fz_new_stext_device()`. */
	/**
		Create a device to extract the text on a page.
	
		Gather the text on a page into blocks and lines.
	
		The reading order is taken from the order the text is drawn in
		the source file, so may not be accurate.
	
		page: The text page to which content should be added. This will
		usually be a newly created (empty) text page, but it can be one
		containing data already (for example when merging multiple
		pages, or watermarking).
	
		options: Options to configure the stext device.
	*/
	FZ_FUNCTION FzDevice(const FzStextPage& page, FzStextOptions& options);

	/** Constructor using `fz_new_svg_device()`. */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		Equivalent to fz_new_svg_device_with_id passing id = NULL.
	*/
	FZ_FUNCTION FzDevice(const FzOutput& out, float page_width, float page_height, int text_format, int reuse_images);

	/** Constructor using `fz_new_svg_device_with_id()`. */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		output: The output stream to send the constructed SVG page to.
	
		page_width, page_height: The page dimensions to use (in points).
	
		text_format: How to emit text. One of the following values:
			FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
			layout errors and mismatching fonts.
			FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
			visual appearance.
	
		reuse_images: Share image resources using <symbol> definitions.
	
		id: ID parameter to keep generated IDs unique across SVG files.
	*/
	FZ_FUNCTION FzDevice(const FzOutput& out, float page_width, float page_height, int text_format, int reuse_images, int *id);

	/** Constructor using `fz_new_test_device()`. */
	/**
		Create a device to test for features.
	
		Currently only tests for the presence of non-grayscale colors.
	
		is_color: Possible values returned:
			0: Definitely greyscale
			1: Probably color (all colors were grey, but there
			were images or shadings in a non grey colorspace).
			2: Definitely color
	
		threshold: The difference from grayscale that will be tolerated.
		Typical values to use are either 0 (be exact) and 0.02 (allow an
		imperceptible amount of slop).
	
		options: A set of bitfield options, from the FZ_TEST_OPT set.
	
		passthrough: A device to pass all calls through to, or NULL.
		If set, then the test device can both test and pass through to
		an underlying device (like, say, the display list device). This
		means that a display list can be created and at the end we'll
		know if it's colored or not.
	
		In the absence of a passthrough device, the device will throw
		an exception to stop page interpretation when color is found.
	*/
	FZ_FUNCTION FzDevice(int *is_color, float threshold, int options, const FzDevice& passthrough);

	/** Constructor using `fz_new_trace_device()`. */
	/**
		Create a device to print a debug trace of all device calls.
	*/
	FZ_FUNCTION FzDevice(const FzOutput& out);

	/** Constructor using `pdf_new_pdf_device()`. */
	FZ_FUNCTION FzDevice(const PdfDocument& doc, const FzMatrix& topctm, const PdfObj& resources, const FzBuffer& contents);

	/** Copy constructor using `fz_keep_device()`. */
	FZ_FUNCTION FzDevice(const FzDevice& rhs);

	/** operator= using `fz_keep_device()` and `fz_drop_device()`. */
	FZ_FUNCTION FzDevice& operator=(const FzDevice& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDevice();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_new_xmltext_device()`.  */
	/**
		Create a device to output raw information.
	*/
	FZ_FUNCTION static FzDevice fz_new_xmltext_device(const FzOutput& out);

	/** Class-aware wrapper for `::fz_new_draw_device_type3()`.  */
	FZ_FUNCTION static FzDevice fz_new_draw_device_type3(const FzMatrix& transform, const FzPixmap& dest);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_begin_group()`.  */
	FZ_FUNCTION void fz_begin_group(const FzRect& area, const FzColorspace& cs, int isolated, int knockout, int blendmode, float alpha) const;

	/** Class-aware wrapper for `::fz_begin_layer()`.  */
	FZ_FUNCTION void fz_begin_layer(const char *layer_name) const;

	/** Class-aware wrapper for `::fz_begin_mask()`.  */
	FZ_FUNCTION void fz_begin_mask(const FzRect& area, int luminosity, const FzColorspace& colorspace, const float *bc, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_begin_metatext()`.  */
	FZ_FUNCTION void fz_begin_metatext(::fz_metatext meta, const char *text) const;

	/** Class-aware wrapper for `::fz_begin_structure()`.  */
	FZ_FUNCTION void fz_begin_structure(::fz_structure standard, const char *raw, int idx) const;

	/** Class-aware wrapper for `::fz_begin_tile()`.  */
	FZ_FUNCTION void fz_begin_tile(const FzRect& area, const FzRect& view, float xstep, float ystep, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_begin_tile_id()`.  */
	FZ_FUNCTION int fz_begin_tile_id(const FzRect& area, const FzRect& view, float xstep, float ystep, const FzMatrix& ctm, int id) const;

	/** Class-aware wrapper for `::fz_clip_image_mask()`.  */
	FZ_FUNCTION void fz_clip_image_mask(const FzImage& image, const FzMatrix& ctm, const FzRect& scissor) const;

	/** Class-aware wrapper for `::fz_clip_path()`.  */
	FZ_FUNCTION void fz_clip_path(const FzPath& path, int even_odd, const FzMatrix& ctm, const FzRect& scissor) const;

	/** Class-aware wrapper for `::fz_clip_stroke_path()`.  */
	FZ_FUNCTION void fz_clip_stroke_path(const FzPath& path, const FzStrokeState& stroke, const FzMatrix& ctm, const FzRect& scissor) const;

	/** Class-aware wrapper for `::fz_clip_stroke_text()`.  */
	FZ_FUNCTION void fz_clip_stroke_text(const FzText& text, const FzStrokeState& stroke, const FzMatrix& ctm, const FzRect& scissor) const;

	/** Class-aware wrapper for `::fz_clip_text()`.  */
	FZ_FUNCTION void fz_clip_text(const FzText& text, const FzMatrix& ctm, const FzRect& scissor) const;

	/** Class-aware wrapper for `::fz_close_device()`.  */
	/**
		Signal the end of input, and flush any buffered output.
		This is NOT called implicitly on fz_drop_device. This
		may throw exceptions.
	*/
	FZ_FUNCTION void fz_close_device() const;

	/** Class-aware wrapper for `::fz_device_current_scissor()`.  */
	/**
		Find current scissor region as tracked by the device.
	*/
	FZ_FUNCTION FzRect fz_device_current_scissor() const;

	/** Class-aware wrapper for `::fz_disable_device_hints()`.  */
	/**
		Disable (clear) hint bits within the hint bitfield for a device.
	*/
	FZ_FUNCTION void fz_disable_device_hints(int hints) const;

	/** Class-aware wrapper for `::fz_enable_device_hints()`.  */
	/**
		Enable (set) hint bits within the hint bitfield for a device.
	*/
	FZ_FUNCTION void fz_enable_device_hints(int hints) const;

	/** Class-aware wrapper for `::fz_end_group()`.  */
	FZ_FUNCTION void fz_end_group() const;

	/** Class-aware wrapper for `::fz_end_layer()`.  */
	FZ_FUNCTION void fz_end_layer() const;

	/** Class-aware wrapper for `::fz_end_mask()`.  */
	FZ_FUNCTION void fz_end_mask() const;

	/** Class-aware wrapper for `::fz_end_mask_tr()`.  */
	FZ_FUNCTION void fz_end_mask_tr(const FzFunction& fn) const;

	/** Class-aware wrapper for `::fz_end_metatext()`.  */
	FZ_FUNCTION void fz_end_metatext() const;

	/** Class-aware wrapper for `::fz_end_structure()`.  */
	FZ_FUNCTION void fz_end_structure() const;

	/** Class-aware wrapper for `::fz_end_tile()`.  */
	FZ_FUNCTION void fz_end_tile() const;

	/** Class-aware wrapper for `::fz_fill_image()`.  */
	FZ_FUNCTION void fz_fill_image(const FzImage& image, const FzMatrix& ctm, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_fill_image_mask()`.  */
	FZ_FUNCTION void fz_fill_image_mask(const FzImage& image, const FzMatrix& ctm, const FzColorspace& colorspace, const float *color, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_fill_path()`.  */
	/**
		Device calls; graphics primitives and containers.
	*/
	FZ_FUNCTION void fz_fill_path(const FzPath& path, int even_odd, const FzMatrix& ctm, const FzColorspace& colorspace, const float *color, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_fill_shade()`.  */
	FZ_FUNCTION void fz_fill_shade(const FzShade& shade, const FzMatrix& ctm, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_fill_text()`.  */
	FZ_FUNCTION void fz_fill_text(const FzText& text, const FzMatrix& ctm, const FzColorspace& colorspace, const float *color, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_ignore_text()`.  */
	FZ_FUNCTION void fz_ignore_text(const FzText& text, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_new_ocr_device()`.  */
	/**
		Create a device to OCR the text on the page.
	
		Renders the page internally to a bitmap that is then OCRd. Text
		is then forwarded onto the target device.
	
		target: The target device to receive the OCRd text.
	
		ctm: The transform to apply to the mediabox to get the size for
		the rendered page image. Also used to calculate the resolution
		for the page image. In general, this will be the same as the CTM
		that you pass to fz_run_page (or fz_run_display_list) to feed
		this device.
	
		mediabox: The mediabox (in points). Combined with the CTM to get
		the bounds of the pixmap used internally for the rendered page
		image.
	
		with_list: If with_list is false, then all non-text operations
		are forwarded instantly to the target device. This results in
		the target device seeing all NON-text operations, followed by
		all the text operations (derived from OCR).
	
		If with_list is true, then all the marking operations are
		collated into a display list which is then replayed to the
		target device at the end.
	
		language: NULL (for "eng"), or a pointer to a string to describe
		the languages/scripts that should be used for OCR (e.g.
		"eng,ara").
	
		datadir: NULL (for ""), or a pointer to a path string otherwise
		provided to Tesseract in the TESSDATA_PREFIX environment variable.
	
		progress: NULL, or function to be called periodically to indicate
		progress. Return 0 to continue, or 1 to cancel. progress_arg is
		returned as the void *. The int is a value between 0 and 100 to
		indicate progress.
	
		progress_arg: A void * value to be parrotted back to the progress
		function.
	*/
	FZ_FUNCTION FzDevice fz_new_ocr_device(const FzMatrix& ctm, const FzRect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(::fz_context *, void *, int ), void *progress_arg) const;

	/** Class-aware wrapper for `::fz_pop_clip()`.  */
	FZ_FUNCTION void fz_pop_clip() const;

	/** Class-aware wrapper for `::fz_render_flags()`.  */
	FZ_FUNCTION void fz_render_flags(int set, int clear) const;

	/** Class-aware wrapper for `::fz_render_t3_glyph_direct()`.  */
	/**
		Nasty PDF interpreter specific hernia, required to allow the
		interpreter to replay glyphs from a type3 font directly into
		the target device.
	
		This is only used in exceptional circumstances (such as type3
		glyphs that inherit current graphics state, or nested type3
		glyphs).
	*/
	FZ_FUNCTION void fz_render_t3_glyph_direct(const FzFont& font, int gid, const FzMatrix& trm, void *gstate, const FzDefaultColorspaces& def_cs, void *fill_gstate, void *stroke_gstate) const;

	/** Class-aware wrapper for `::fz_set_default_colorspaces()`.  */
	FZ_FUNCTION void fz_set_default_colorspaces(const FzDefaultColorspaces& default_cs) const;

	/** Class-aware wrapper for `::fz_stroke_path()`.  */
	FZ_FUNCTION void fz_stroke_path(const FzPath& path, const FzStrokeState& stroke, const FzMatrix& ctm, const FzColorspace& colorspace, const float *color, float alpha, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_stroke_text()`.  */
	FZ_FUNCTION void fz_stroke_text(const FzText& text, const FzStrokeState& stroke, const FzMatrix& ctm, const FzColorspace& colorspace, const float *color, float alpha, const FzColorParams& color_params) const;

	/** Constructor using raw copy of pre-existing `::fz_device`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_device* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzDevice(::fz_device* internal);

	/** Destructor using fz_drop_device(). */
	FZ_FUNCTION ~FzDevice();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_device* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct fz_device with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct FzDevice2 : FzDevice
{

	/** == Constructor. */
	FZ_FUNCTION FzDevice2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~FzDevice2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_close_device( bool use=true);
	FZ_FUNCTION void use_virtual_drop_device( bool use=true);
	FZ_FUNCTION void use_virtual_fill_path( bool use=true);
	FZ_FUNCTION void use_virtual_stroke_path( bool use=true);
	FZ_FUNCTION void use_virtual_clip_path( bool use=true);
	FZ_FUNCTION void use_virtual_clip_stroke_path( bool use=true);
	FZ_FUNCTION void use_virtual_fill_text( bool use=true);
	FZ_FUNCTION void use_virtual_stroke_text( bool use=true);
	FZ_FUNCTION void use_virtual_clip_text( bool use=true);
	FZ_FUNCTION void use_virtual_clip_stroke_text( bool use=true);
	FZ_FUNCTION void use_virtual_ignore_text( bool use=true);
	FZ_FUNCTION void use_virtual_fill_shade( bool use=true);
	FZ_FUNCTION void use_virtual_fill_image( bool use=true);
	FZ_FUNCTION void use_virtual_fill_image_mask( bool use=true);
	FZ_FUNCTION void use_virtual_clip_image_mask( bool use=true);
	FZ_FUNCTION void use_virtual_pop_clip( bool use=true);
	FZ_FUNCTION void use_virtual_begin_mask( bool use=true);
	FZ_FUNCTION void use_virtual_end_mask( bool use=true);
	FZ_FUNCTION void use_virtual_begin_group( bool use=true);
	FZ_FUNCTION void use_virtual_end_group( bool use=true);
	FZ_FUNCTION void use_virtual_begin_tile( bool use=true);
	FZ_FUNCTION void use_virtual_end_tile( bool use=true);
	FZ_FUNCTION void use_virtual_render_flags( bool use=true);
	FZ_FUNCTION void use_virtual_set_default_colorspaces( bool use=true);
	FZ_FUNCTION void use_virtual_begin_layer( bool use=true);
	FZ_FUNCTION void use_virtual_end_layer( bool use=true);
	FZ_FUNCTION void use_virtual_begin_structure( bool use=true);
	FZ_FUNCTION void use_virtual_end_structure( bool use=true);
	FZ_FUNCTION void use_virtual_begin_metatext( bool use=true);
	FZ_FUNCTION void use_virtual_end_metatext( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void close_device(::fz_context *arg_0);
	FZ_FUNCTION virtual void drop_device(::fz_context *arg_0);
	FZ_FUNCTION virtual void fill_path(::fz_context *arg_0, const ::fz_path *arg_2, int arg_3, ::fz_matrix arg_4, ::fz_colorspace *arg_5, const float *arg_6, float arg_7, ::fz_color_params arg_8);
	FZ_FUNCTION virtual void stroke_path(::fz_context *arg_0, const ::fz_path *arg_2, const ::fz_stroke_state *arg_3, ::fz_matrix arg_4, ::fz_colorspace *arg_5, const float *arg_6, float arg_7, ::fz_color_params arg_8);
	FZ_FUNCTION virtual void clip_path(::fz_context *arg_0, const ::fz_path *arg_2, int arg_3, ::fz_matrix arg_4, ::fz_rect arg_5);
	FZ_FUNCTION virtual void clip_stroke_path(::fz_context *arg_0, const ::fz_path *arg_2, const ::fz_stroke_state *arg_3, ::fz_matrix arg_4, ::fz_rect arg_5);
	FZ_FUNCTION virtual void fill_text(::fz_context *arg_0, const ::fz_text *arg_2, ::fz_matrix arg_3, ::fz_colorspace *arg_4, const float *arg_5, float arg_6, ::fz_color_params arg_7);
	FZ_FUNCTION virtual void stroke_text(::fz_context *arg_0, const ::fz_text *arg_2, const ::fz_stroke_state *arg_3, ::fz_matrix arg_4, ::fz_colorspace *arg_5, const float *arg_6, float arg_7, ::fz_color_params arg_8);
	FZ_FUNCTION virtual void clip_text(::fz_context *arg_0, const ::fz_text *arg_2, ::fz_matrix arg_3, ::fz_rect arg_4);
	FZ_FUNCTION virtual void clip_stroke_text(::fz_context *arg_0, const ::fz_text *arg_2, const ::fz_stroke_state *arg_3, ::fz_matrix arg_4, ::fz_rect arg_5);
	FZ_FUNCTION virtual void ignore_text(::fz_context *arg_0, const ::fz_text *arg_2, ::fz_matrix arg_3);
	FZ_FUNCTION virtual void fill_shade(::fz_context *arg_0, ::fz_shade *arg_2, ::fz_matrix arg_3, float arg_4, ::fz_color_params arg_5);
	FZ_FUNCTION virtual void fill_image(::fz_context *arg_0, ::fz_image *arg_2, ::fz_matrix arg_3, float arg_4, ::fz_color_params arg_5);
	FZ_FUNCTION virtual void fill_image_mask(::fz_context *arg_0, ::fz_image *arg_2, ::fz_matrix arg_3, ::fz_colorspace *arg_4, const float *arg_5, float arg_6, ::fz_color_params arg_7);
	FZ_FUNCTION virtual void clip_image_mask(::fz_context *arg_0, ::fz_image *arg_2, ::fz_matrix arg_3, ::fz_rect arg_4);
	FZ_FUNCTION virtual void pop_clip(::fz_context *arg_0);
	FZ_FUNCTION virtual void begin_mask(::fz_context *arg_0, ::fz_rect arg_2, int arg_3, ::fz_colorspace *arg_4, const float *arg_5, ::fz_color_params arg_6);
	FZ_FUNCTION virtual void end_mask(::fz_context *arg_0, ::fz_function *arg_2);
	FZ_FUNCTION virtual void begin_group(::fz_context *arg_0, ::fz_rect arg_2, ::fz_colorspace *arg_3, int arg_4, int arg_5, int arg_6, float arg_7);
	FZ_FUNCTION virtual void end_group(::fz_context *arg_0);
	FZ_FUNCTION virtual int begin_tile(::fz_context *arg_0, ::fz_rect arg_2, ::fz_rect arg_3, float arg_4, float arg_5, ::fz_matrix arg_6, int arg_7);
	FZ_FUNCTION virtual void end_tile(::fz_context *arg_0);
	FZ_FUNCTION virtual void render_flags(::fz_context *arg_0, int arg_2, int arg_3);
	FZ_FUNCTION virtual void set_default_colorspaces(::fz_context *arg_0, ::fz_default_colorspaces *arg_2);
	FZ_FUNCTION virtual void begin_layer(::fz_context *arg_0, const char *arg_2);
	FZ_FUNCTION virtual void end_layer(::fz_context *arg_0);
	FZ_FUNCTION virtual void begin_structure(::fz_context *arg_0, ::fz_structure arg_2, const char *arg_3, int arg_4);
	FZ_FUNCTION virtual void end_structure(::fz_context *arg_0);
	FZ_FUNCTION virtual void begin_metatext(::fz_context *arg_0, ::fz_metatext arg_2, const char *arg_3);
	FZ_FUNCTION virtual void end_metatext(::fz_context *arg_0);
};

/** Wrapper class for struct `fz_device_container_stack`. Not copyable or assignable. */
/**
	Devices can keep track of containers (clips/masks/groups/tiles)
	as they go to save callers having to do it.
*/
struct FzDeviceContainerStack
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDeviceContainerStack();

	/** Constructor using raw copy of pre-existing `::fz_device_container_stack`. */
	FZ_FUNCTION FzDeviceContainerStack(::fz_device_container_stack* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzDeviceContainerStack();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_device_container_stack* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzDeviceContainerStack(const FzDeviceContainerStack& rhs);
	FzDeviceContainerStack& operator=(const FzDeviceContainerStack& rhs);
};

/** Wrapper class for struct `fz_display_list`. */
/**
	fz_display_list is a list containing drawing commands (text,
	images, etc.). The intent is two-fold: as a caching-mechanism
	to reduce parsing of a page, and to be used as a data
	structure in multi-threading where one thread parses the page
	and another renders pages.

	Create a display list with fz_new_display_list, hand it over to
	fz_new_list_device to have it populated, and later replay the
	list (once or many times) by calling fz_run_display_list. When
	the list is no longer needed drop it with fz_drop_display_list.
*/
struct FzDisplayList
{
	/** == Constructors. */

	/** Constructor using `fz_new_display_list()`. */
	/**
		Create an empty display list.
	
		A display list contains drawing commands (text, images, etc.).
		Use fz_new_list_device for populating the list.
	
		mediabox: Bounds of the page (in points) represented by the
		display list.
	*/
	FZ_FUNCTION FzDisplayList(const FzRect& mediabox);

	/** Constructor using `fz_new_display_list_from_page()`. */
	/**
		Create a display list.
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION FzDisplayList(const FzPage& page);

	/** Constructor using `fz_new_display_list_from_page_number()`. */
	FZ_FUNCTION FzDisplayList(const FzDocument& doc, int number);

	/** Constructor using `fz_new_display_list_from_svg()`. */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION FzDisplayList(const FzBuffer& buf, const char *base_uri, const FzArchive& dir, float *w, float *h);

	/** Constructor using `fz_new_display_list_from_svg_xml()`. */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION FzDisplayList(const FzXml& xmldoc, const FzXml& xml, const char *base_uri, const FzArchive& dir, float *w, float *h);

	/** Constructor using `pdf_new_display_list_from_annot()`. */
	FZ_FUNCTION FzDisplayList(const PdfAnnot& annot);

	/** Copy constructor using `fz_keep_display_list()`. */
	FZ_FUNCTION FzDisplayList(const FzDisplayList& rhs);

	/** operator= using `fz_keep_display_list()` and `fz_drop_display_list()`. */
	FZ_FUNCTION FzDisplayList& operator=(const FzDisplayList& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDisplayList();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_new_display_list_from_page_contents()`.  */
	/**
		Create a display list from page contents (no annotations).
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION static FzDisplayList fz_new_display_list_from_page_contents(const FzPage& page);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bound_display_list()`.  */
	/**
		Return the bounding box of the page recorded in a display list.
	*/
	FZ_FUNCTION FzRect fz_bound_display_list() const;

	/** Class-aware wrapper for `::fz_display_list_is_empty()`.  */
	/**
		Check for a display list being empty
	
		list: The list to check.
	
		Returns true if empty, false otherwise.
	*/
	FZ_FUNCTION int fz_display_list_is_empty() const;

	/** Class-aware wrapper for `::fz_fill_pixmap_from_display_list()`.  */
	FZ_FUNCTION FzPixmap fz_fill_pixmap_from_display_list(const FzMatrix& ctm, const FzPixmap& pix) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_display_list()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_display_list(FzStextOptions& options) const;

	/** Class-aware wrapper for `::fz_new_list_device()`.  */
	/**
		Create a rendering device for a display list.
	
		When the device is rendering a page it will populate the
		display list with drawing commands (text, images, etc.). The
		display list can later be reused to render a page many times
		without having to re-interpret the page from the document file
		for each rendering. Once the device is no longer needed, free
		it with fz_drop_device.
	
		list: A display list that the list device takes a reference to.
	*/
	FZ_FUNCTION FzDevice fz_new_list_device() const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_display_list()`.  */
	/**
		Render the page to a pixmap using the transform and colorspace.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_display_list(const FzMatrix& ctm, const FzColorspace& cs, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_display_list_with_separations()`.  */
	/**
		Render the page contents with control over spot colors.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_display_list_with_separations(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_run_display_list()`.  */
	/**
		(Re)-run a display list through a device.
	
		list: A display list, created by fz_new_display_list and
		populated with objects from a page by running fz_run_page on a
		device obtained from fz_new_list_device.
	
		ctm: Transform to apply to display list contents. May include
		for example scaling and rotation, see fz_scale, fz_rotate and
		fz_concat. Set to fz_identity if no transformation is desired.
	
		scissor: Only the part of the contents of the display list
		visible within this area will be considered when the list is
		run through the device. This does not imply for tile objects
		contained in the display list.
	
		cookie: Communication mechanism between caller and library
		running the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing page run. Cookie also communicates
		progress information back to the caller. The fields inside
		cookie are continually updated while the page is being run.
	*/
	FZ_FUNCTION void fz_run_display_list(const FzDevice& dev, const FzMatrix& ctm, const FzRect& scissor, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_search_display_list()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_search_display_list(const char *needle, ::fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int fz_search_display_list(const char *needle, int *hit_mark, FzQuad& hit_bbox, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_display_list_cb()`.  */
	FZ_FUNCTION int fz_search_display_list_cb(const char *needle, ::fz_search_callback_fn *cb, void *opaque) const;

	/** Constructor using raw copy of pre-existing `::fz_display_list`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_display_list* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzDisplayList(::fz_display_list* internal);

	/** Destructor using fz_drop_display_list(). */
	FZ_FUNCTION ~FzDisplayList();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_display_list* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_document`. */
struct FzDocument
{
	/** == Constructors. */

	/** Constructor using `fz_open_accelerated_document()`. */
	/**
		Open a document file and read its basic structure so pages and
		objects can be located. MuPDF will try to repair broken
		documents (without actually changing the file contents).
	
		The returned fz_document is used when calling most other
		document related functions.
	
		filename: a path to a file as it would be given to open(2).
	*/
	FZ_FUNCTION FzDocument(const char *filename, const char *accel);

	/** Constructor using `fz_open_accelerated_document_with_stream()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	
		stream: a stream of the document contents.
	
		accel: NULL, or a stream of the 'accelerator' contents for this document.
	
		NOTE: The caller retains ownership of 'stream' and 'accel' - the document will
		take its own references if required.
	*/
	FZ_FUNCTION FzDocument(const char *magic, const FzStream& stream, const FzStream& accel);

	/** Constructor using `fz_open_accelerated_document_with_stream_and_dir()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	
		stream: a stream of the document contents.
	
		accel: NULL, or a stream of the 'accelerator' contents for this document.
	
		dir: NULL, or the 'directory context' for the stream contents.
	
		NOTE: The caller retains ownership of 'stream', 'accel' and 'dir' - the document will
		take its own references if required.
	*/
	FZ_FUNCTION FzDocument(const char *magic, const FzStream& stream, const FzStream& accel, const FzArchive& dir);

	/** Constructor using `fz_open_document()`. */
	/**
		Open a document file and read its basic structure so pages and
		objects can be located. MuPDF will try to repair broken
		documents (without actually changing the file contents).
	
		The returned fz_document is used when calling most other
		document related functions.
	
		filename: a path to a file as it would be given to open(2).
	*/
	FZ_FUNCTION FzDocument(const char *filename);

	/** Constructor using `fz_open_document_with_buffer()`. */
	/**
		Open a document using a buffer rather than opening a file on disk.
	*/
	FZ_FUNCTION FzDocument(const char *magic, const FzBuffer& buffer);

	/** Constructor using `fz_open_document_with_stream()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	
		stream: a stream representing the contents of the document file.
	
		NOTE: The caller retains ownership of 'stream' - the document will take its
		own reference if required.
	*/
	FZ_FUNCTION FzDocument(const char *magic, const FzStream& stream);

	/** Constructor using `fz_open_document_with_stream_and_dir()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	
		stream: a stream representing the contents of the document file.
	
		dir: a 'directory context' for those filetypes that need it.
	
		NOTE: The caller retains ownership of 'stream' and 'dir' - the document will
		take its own references if required.
	*/
	FZ_FUNCTION FzDocument(const char *magic, const FzStream& stream, const FzArchive& dir);

	/** Returns a FzDocument for pdfdocument.m_internal.super. */
	FZ_FUNCTION FzDocument(PdfDocument& pdfdocument);

	/** Copy constructor using `fz_keep_document()`. */
	FZ_FUNCTION FzDocument(const FzDocument& rhs);

	/** operator= using `fz_keep_document()` and `fz_drop_document()`. */
	FZ_FUNCTION FzDocument& operator=(const FzDocument& rhs);

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_new_xhtml_document_from_document()`.  */
	/**
		Use text extraction to convert the input document into XHTML,
		then open the result as a new document that can be reflowed.
	*/
	FZ_FUNCTION static FzDocument fz_new_xhtml_document_from_document(const FzDocument& old_doc, FzStextOptions& opts);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_authenticate_password()`.  */
	/**
		Test if the given password can decrypt the document.
	
		password: The password string to be checked. Some document
		specifications do not specify any particular text encoding, so
		neither do we.
	
		Returns 0 for failure to authenticate, non-zero for success.
	
		For PDF documents, further information can be given by examining
		the bits in the return code.
	
			Bit 0 => No password required
			Bit 1 => User password authenticated
			Bit 2 => Owner password authenticated
	*/
	FZ_FUNCTION int fz_authenticate_password(const char *password) const;

	/** Class-aware wrapper for `::fz_clamp_location()`.  */
	/**
		Clamps a location into valid chapter/page range. (First clamps
		the chapter into range, then the page into range).
	*/
	FZ_FUNCTION FzLocation fz_clamp_location(const FzLocation& loc) const;

	/** Class-aware wrapper for `::fz_count_chapter_pages()`.  */
	/**
		Return the number of pages in a chapter.
		May return 0.
	*/
	FZ_FUNCTION int fz_count_chapter_pages(int chapter) const;

	/** Class-aware wrapper for `::fz_count_chapters()`.  */
	/**
		Return the number of chapters in the document.
		At least 1.
	*/
	FZ_FUNCTION int fz_count_chapters() const;

	/** Class-aware wrapper for `::fz_count_pages()`.  */
	/**
		Return the number of pages in document
	
		May return 0 for documents with no pages.
	*/
	FZ_FUNCTION int fz_count_pages() const;

	/** Class-aware wrapper for `::fz_document_output_intent()`.  */
	/**
		Find the output intent colorspace if the document has defined
		one.
	
		Returns a borrowed reference that should not be dropped, unless
		it is kept first.
	*/
	FZ_FUNCTION FzColorspace fz_document_output_intent() const;

	/** Class-aware wrapper for `::fz_document_supports_accelerator()`.  */
	/**
		Query if the document supports the saving of accelerator data.
	*/
	FZ_FUNCTION int fz_document_supports_accelerator() const;

	/** Class-aware wrapper for `::fz_format_link_uri()`.  */
	/**
		Format an internal link to a page number, location, and possible viewing parameters,
		suitable for use with fz_create_link.
	
		Returns a newly allocated string that the caller must free.
	*/
	FZ_FUNCTION char *fz_format_link_uri(const FzLinkDest& dest) const;

	/** Class-aware wrapper for `::fz_has_permission()`.  */
	/**
		Check permission flags on document.
	*/
	FZ_FUNCTION int fz_has_permission(::fz_permission p) const;

	/** Class-aware wrapper for `::fz_is_document_reflowable()`.  */
	/**
		Is the document reflowable.
	
		Returns 1 to indicate reflowable documents, otherwise 0.
	*/
	FZ_FUNCTION int fz_is_document_reflowable() const;

	/** Class-aware wrapper for `::fz_last_page()`.  */
	/**
		Function to get the location for the last page in the document.
		Using this can be far more efficient in some cases than calling
		fz_count_pages and using the page number.
	*/
	FZ_FUNCTION FzLocation fz_last_page() const;

	/** Class-aware wrapper for `::fz_layout_document()`.  */
	/**
		Layout reflowable document types.
	
		w, h: Page size in points.
		em: Default font size in points.
	*/
	FZ_FUNCTION void fz_layout_document(float w, float h, float em) const;

	/** Class-aware wrapper for `::fz_load_chapter_page()`.  */
	/**
		Load a page.
	
		After fz_load_page is it possible to retrieve the size of the
		page using fz_bound_page, or to render the page using
		fz_run_page_*. Free the page by calling fz_drop_page.
	
		chapter: chapter number, 0 is the first chapter of the document.
		number: page number, 0 is the first page of the chapter.
	*/
	FZ_FUNCTION FzPage fz_load_chapter_page(int chapter, int page) const;

	/** Class-aware wrapper for `::fz_load_outline()`.  */
	/**
		Load the hierarchical document outline.
	
		Should be freed by fz_drop_outline.
	*/
	FZ_FUNCTION FzOutline fz_load_outline() const;

	/** Class-aware wrapper for `::fz_load_page()`.  */
	/**
		Load a given page number from a document. This may be much less
		efficient than loading by location (chapter+page) for some
		document types.
	*/
	FZ_FUNCTION FzPage fz_load_page(int number) const;

	/** Class-aware wrapper for `::fz_location_from_page_number()`.  */
	/**
		Converts from page number to chapter+page. This may cause many
		chapters to be laid out in order to calculate the number of
		pages within those chapters.
	*/
	FZ_FUNCTION FzLocation fz_location_from_page_number(int number) const;

	/** Class-aware wrapper for `::fz_lookup_bookmark()`.  */
	/**
		Find a bookmark and return its page number.
	*/
	FZ_FUNCTION FzLocation fz_lookup_bookmark(::fz_bookmark mark) const;

	/** Class-aware wrapper for `::fz_lookup_metadata()`.  */
	/**
		Retrieve document meta data strings.
	
		doc: The document to query.
	
		key: Which meta data key to retrieve...
	
		Basic information:
			'format'	-- Document format and version.
			'encryption'	-- Description of the encryption used.
	
		From the document information dictionary:
			'info:Title'
			'info:Author'
			'info:Subject'
			'info:Keywords'
			'info:Creator'
			'info:Producer'
			'info:CreationDate'
			'info:ModDate'
	
		buf: The buffer to hold the results (a nul-terminated UTF-8
		string).
	
		size: Size of 'buf'.
	
		Returns the number of bytes need to store the string plus terminator
		(will be larger than 'size' if the output was truncated), or -1 if the
		key is not recognized or found.
	*/
	FZ_FUNCTION int fz_lookup_metadata(const char *key, char *buf, size_t size) const;

	/** Class-aware wrapper for `::fz_lookup_metadata2()`.  */
	/**
	C++ alternative to `fz_lookup_metadata()` that returns a `std::string`
	or calls `fz_throw()` if not found.
	*/
	FZ_FUNCTION std::string fz_lookup_metadata2(const char *key) const;

	/** Class-aware wrapper for `::fz_needs_password()`.  */
	/**
		Check if a document is encrypted with a
		non-blank password.
	*/
	FZ_FUNCTION int fz_needs_password() const;

	/** Class-aware wrapper for `::fz_new_buffer_from_page_number()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_page_number(int number, FzStextOptions& options) const;

	/** Class-aware wrapper for `::fz_new_display_list_from_page_number()`.  */
	FZ_FUNCTION FzDisplayList fz_new_display_list_from_page_number(int number) const;

	/** Class-aware wrapper for `::fz_new_pdf_document_from_fz_document()`.  */
	FZ_FUNCTION PdfDocument fz_new_pdf_document_from_fz_document() const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_number()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page_number(int number, const FzMatrix& ctm, const FzColorspace& cs, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_number_with_separations()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page_number_with_separations(int number, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_new_xhtml_document_from_document()`.  */
	/**
		Use text extraction to convert the input document into XHTML,
		then open the result as a new document that can be reflowed.
	*/
	FZ_FUNCTION FzDocument fz_new_xhtml_document_from_document(FzStextOptions& opts) const;

	/** Class-aware wrapper for `::fz_next_page()`.  */
	/**
		Function to get the location of the next page (allowing for the
		end of chapters etc). If at the end of the document, returns the
		current location.
	*/
	FZ_FUNCTION FzLocation fz_next_page(const FzLocation& loc) const;

	/** Class-aware wrapper for `::fz_open_reflowed_document()`.  */
	FZ_FUNCTION FzDocument fz_open_reflowed_document(FzStextOptions& opts) const;

	/** Class-aware wrapper for `::fz_output_accelerator()`.  */
	/**
		Output accelerator data for the document to a given output
		stream.
	*/
	FZ_FUNCTION void fz_output_accelerator(const FzOutput& accel) const;

	/** Class-aware wrapper for `::fz_page_number_from_location()`.  */
	/**
		Converts from chapter+page to page number. This may cause many
		chapters to be laid out in order to calculate the number of
		pages within those chapters.
	*/
	FZ_FUNCTION int fz_page_number_from_location(const FzLocation& loc) const;

	/** Class-aware wrapper for `::fz_previous_page()`.  */
	/**
		Function to get the location of the previous page (allowing for
		the end of chapters etc). If already at the start of the
		document, returns the current page.
	*/
	FZ_FUNCTION FzLocation fz_previous_page(const FzLocation& loc) const;

	/** Class-aware wrapper for `::fz_process_opened_pages()`.  */
	/**
		Iterates over all opened pages of the document, calling the
		provided callback for each page for processing. If the callback
		returns non-NULL then the iteration stops and that value is returned
		to the called of fz_process_opened_pages().
	
		The state pointer provided to fz_process_opened_pages() is
		passed on to the callback but is owned by the caller.
	
		Returns the first non-NULL value returned by the callback,
		or NULL if the callback returned NULL for all opened pages.
	*/
	FZ_FUNCTION void *fz_process_opened_pages(::fz_process_opened_page_fn *process_openend_page, void *state) const;

	/** Class-aware wrapper for `::fz_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_resolve_link(const char *uri)` => `(fz_location, float xp, float yp)`
	 */
	/**
		Resolve an internal link to a page number.
	
		xp, yp: Pointer to store coordinate of destination on the page.
	
		Returns (-1,-1) if the URI cannot be resolved.
	*/
	FZ_FUNCTION FzLocation fz_resolve_link(const char *uri, float *xp, float *yp) const;

	/** Class-aware wrapper for `::fz_run_document_structure()`.  */
	/**
		Run the document structure through a device.
	
		doc: Document in question.
	
		dev: Device obtained from fz_new_*_device.
	
		cookie: Communication mechanism between caller and library.
		Intended for multi-threaded applications, while
		single-threaded applications set cookie to NULL. The
		caller may abort an ongoing rendering of a page. Cookie also
		communicates progress information back to the caller. The
		fields inside cookie are continually updated while the page is
		rendering.
	*/
	FZ_FUNCTION void fz_run_document_structure(const FzDevice& dev, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_save_accelerator()`.  */
	/**
		Save accelerator data for the document to a given file.
	*/
	FZ_FUNCTION void fz_save_accelerator(const char *accel) const;

	/** Class-aware wrapper for `::fz_search_chapter_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_search_chapter_page_number(int chapter, int page, const char *needle, ::fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int fz_search_chapter_page_number(int chapter, int page, const char *needle, int *hit_mark, FzQuad& hit_bbox, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_chapter_page_number_cb()`.  */
	FZ_FUNCTION int fz_search_chapter_page_number_cb(int chapter, int page, const char *needle, ::fz_search_callback_fn *cb, void *opaque) const;

	/** Class-aware wrapper for `::fz_search_page2()`.  */
	/**
	C++ alternative to fz_search_page() that returns information in a std::vector.
	*/
	FZ_FUNCTION std::vector<fz_search_page2_hit> fz_search_page2(int number, const char *needle, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_search_page_number(int number, const char *needle, ::fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int fz_search_page_number(int number, const char *needle, int *hit_mark, FzQuad& hit_bbox, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_page_number_cb()`.  */
	FZ_FUNCTION int fz_search_page_number_cb(int number, const char *needle, ::fz_search_callback_fn *cb, void *opaque) const;

	/** Class-aware wrapper for `::fz_set_metadata()`.  */
	FZ_FUNCTION void fz_set_metadata(const char *key, const char *value) const;

	/** Class-aware wrapper for `::pdf_count_pages_imp()`.  */
	FZ_FUNCTION int pdf_count_pages_imp(int chapter) const;

	/** Class-aware wrapper for `::pdf_document_from_fz_document()`.  */
	FZ_FUNCTION PdfDocument pdf_document_from_fz_document() const;

	/** Class-aware wrapper for `::pdf_load_page_imp()`.  */
	FZ_FUNCTION FzPage pdf_load_page_imp(int chapter, int number) const;

	/** Class-aware wrapper for `::pdf_page_label_imp()`.  */
	FZ_FUNCTION void pdf_page_label_imp(int chapter, int page, char *buf, size_t size) const;

	/** Class-aware wrapper for `::pdf_specifics()`.  */
	FZ_FUNCTION PdfDocument pdf_specifics() const;

	/** Constructor using raw copy of pre-existing `::fz_document`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_document* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzDocument(::fz_document* internal=NULL);

	/** Destructor using fz_drop_document(). */
	FZ_FUNCTION ~FzDocument();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_document* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_document_handler`. Not copyable or assignable. */
struct FzDocumentHandler
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDocumentHandler();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_document_handler_open()`.  */
	/** Helper for calling `fz_document_handler::open` function pointer via
	Swig from Python/C#. */
	FZ_FUNCTION FzDocument fz_document_handler_open(const FzStream& stream, const FzStream& accel, const FzArchive& dir, void *recognize_state) const;

	/** Class-aware wrapper for `::fz_document_handler_recognize()`.  */
	/** Helper for calling a `fz_document_handler::recognize` function
	pointer via Swig from Python/C#. */
	FZ_FUNCTION int fz_document_handler_recognize(const char *magic) const;

	/** Class-aware wrapper for `::fz_register_document_handler()`.  */
	/**
		Register a handler for a document type.
	
		handler: The handler to register. This must live on for the duration of the
		use of this handler. It will be passed back to the handler for calls so
		the caller can use it to retrieve state.
	*/
	FZ_FUNCTION void fz_register_document_handler() const;

	/** Constructor using raw copy of pre-existing `::fz_document_handler`. */
	FZ_FUNCTION FzDocumentHandler(::fz_document_handler* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzDocumentHandler();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_document_handler* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzDocumentHandler(const FzDocumentHandler& rhs);
	FzDocumentHandler& operator=(const FzDocumentHandler& rhs);
};

/** Wrapper class for struct `fz_document_handler_context`. Not copyable or assignable. */
struct FzDocumentHandlerContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDocumentHandlerContext();

	/** Constructor using raw copy of pre-existing `::fz_document_handler_context`. */
	FZ_FUNCTION FzDocumentHandlerContext(::fz_document_handler_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzDocumentHandlerContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_document_handler_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzDocumentHandlerContext(const FzDocumentHandlerContext& rhs);
	FzDocumentHandlerContext& operator=(const FzDocumentHandlerContext& rhs);
};

/** Wrapper class for struct `fz_document_writer`. Not copyable or assignable. */
struct FzDocumentWriter
{
	/* Used for constructor that wraps fz_ functions taking (const char *path, const char *options). */
	enum PathType
	{
		PathType_CBZ,
		PathType_DOCX,
		PathType_ODT,
		PathType_PAM_PIXMAP,
		PathType_PBM_PIXMAP,
		PathType_PCL,
		PathType_PCLM,
		PathType_PDF,
		PathType_PDFOCR,
		PathType_PGM_PIXMAP,
		PathType_PKM_PIXMAP,
		PathType_PNG_PIXMAP,
		PathType_PNM_PIXMAP,
		PathType_PPM_PIXMAP,
		PathType_PS,
		PathType_PWG,
		PathType_SVG,
	};

	/* Used for constructor that wraps fz_ functions taking (Output& out, const char *options). */
	enum OutputType
	{
		OutputType_CBZ,
		OutputType_DOCX,
		OutputType_ODT,
		OutputType_PCL,
		OutputType_PCLM,
		OutputType_PDF,
		OutputType_PDFOCR,
		OutputType_PS,
		OutputType_PWG,
	};

	/* Used for constructor that wraps fz_ functions taking (const char *format, const char *path, const char *options). */
	enum FormatPathType
	{
		FormatPathType_DOCUMENT,
		FormatPathType_TEXT,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_csv_writer()`. */
	FZ_FUNCTION FzDocumentWriter(const char *path, const char *options);

	/** Constructor using `fz_new_csv_writer_with_output()`. */
	/* Disabled because same args as fz_new_svg_writer_with_output.
	FZ_FUNCTION FzDocumentWriter(const FzOutput& out, const char *options);
	*/

	/** Constructor using `fz_new_document_writer_of_size()`. */
	/**
		Internal function to allocate a
		block for a derived document_writer structure, with the base
		structure's function pointers populated correctly, and the extra
		space zero initialised.
	*/
	FZ_FUNCTION FzDocumentWriter(size_t size, ::fz_document_writer_begin_page_fn *begin_page, ::fz_document_writer_end_page_fn *end_page, ::fz_document_writer_close_writer_fn *close, ::fz_document_writer_drop_writer_fn *drop);

	/** Constructor using `fz_new_document_writer_with_buffer()`. */
	FZ_FUNCTION FzDocumentWriter(const FzBuffer& buf, const char *format, const char *options);

	/** Constructor using `fz_new_jpeg_pixmap_writer()`. */
	/* Disabled because same args as fz_new_csv_writer.
	FZ_FUNCTION FzDocumentWriter(const char *path, const char *options);
	*/

	/** Constructor using `fz_new_pixmap_writer()`. */
	FZ_FUNCTION FzDocumentWriter(const char *path, const char *options, const char *default_path, int n, void (*save)(::fz_context *, ::fz_pixmap *, const char *));

	/** Constructor using `fz_new_svg_writer_with_output()`. */
	FZ_FUNCTION FzDocumentWriter(const FzOutput& out, const char *options);

	/** Constructor using one of:
		fz_new_cbz_writer()
		fz_new_docx_writer()
		fz_new_odt_writer()
		fz_new_pam_pixmap_writer()
		fz_new_pbm_pixmap_writer()
		fz_new_pcl_writer()
		fz_new_pclm_writer()
		fz_new_pdf_writer()
		fz_new_pdfocr_writer()
		fz_new_pgm_pixmap_writer()
		fz_new_pkm_pixmap_writer()
		fz_new_png_pixmap_writer()
		fz_new_pnm_pixmap_writer()
		fz_new_ppm_pixmap_writer()
		fz_new_ps_writer()
		fz_new_pwg_writer()
		fz_new_svg_writer()
	*/
	FZ_FUNCTION FzDocumentWriter(const char *path, const char *options, PathType path_type);

	/** Constructor using one of:
		fz_new_cbz_writer_with_output()
		fz_new_docx_writer_with_output()
		fz_new_odt_writer_with_output()
		fz_new_pcl_writer_with_output()
		fz_new_pclm_writer_with_output()
		fz_new_pdf_writer_with_output()
		fz_new_pdfocr_writer_with_output()
		fz_new_ps_writer_with_output()
		fz_new_pwg_writer_with_output()
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION FzDocumentWriter(FzOutput& out, const char *options, OutputType output_type);

	/** Constructor using one of:
		fz_new_document_writer()
		fz_new_text_writer()
	*/
	FZ_FUNCTION FzDocumentWriter(const char *format, const char *path, const char *options, FormatPathType format_path_type);

	/** Constructor using fz_new_document_writer_with_output().
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION FzDocumentWriter(FzOutput& out, const char *format, const char *options);

	/** Constructor using fz_new_text_writer_with_output().
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION FzDocumentWriter(const char *format, FzOutput& out, const char *options);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzDocumentWriter();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_begin_page()`.  */
	/**
		Called to start the process of writing a page to
		a document.
	
		mediabox: page size rectangle in points.
	
		Returns a borrowed fz_device to write page contents to. This
		should be kept if required, and only dropped if it was kept.
	*/
	FZ_FUNCTION FzDevice fz_begin_page(const FzRect& mediabox) const;

	/** Class-aware wrapper for `::fz_close_document_writer()`.  */
	/**
		Called to end the process of writing
		pages to a document.
	
		This writes any file level trailers required. After this
		completes successfully the file is up to date and complete.
	*/
	FZ_FUNCTION void fz_close_document_writer() const;

	/** Class-aware wrapper for `::fz_end_page()`.  */
	/**
		Called to end the process of writing a page to a
		document.
	*/
	FZ_FUNCTION void fz_end_page() const;

	/** Class-aware wrapper for `::fz_pdfocr_writer_set_progress()`.  */
	FZ_FUNCTION void fz_pdfocr_writer_set_progress(::fz_pdfocr_progress_fn *progress, void *arg_2) const;

	/** Class-aware wrapper for `::fz_write_document()`.  */
	/**
		Convenience function to feed all the pages of a document to
		fz_begin_page/fz_run_page/fz_end_page.
	*/
	FZ_FUNCTION void fz_write_document(const FzDocument& doc) const;

	/** Class-aware wrapper for `::fz_write_stabilized_story()`.  */
	FZ_FUNCTION void fz_write_stabilized_story(const char *user_css, float em, ::fz_write_story_contentfn contentfn, void *contentfn_ref, ::fz_write_story_rectfn rectfn, void *rectfn_ref, ::fz_write_story_pagefn pagefn, void *pagefn_ref, const FzArchive& dir) const;

	/** Class-aware wrapper for `::fz_write_story()`.  */
	FZ_FUNCTION void fz_write_story(const FzStory& story, ::fz_write_story_rectfn rectfn, void *rectfn_ref, ::fz_write_story_positionfn positionfn, void *positionfn_ref, ::fz_write_story_pagefn pagefn, void *pagefn_ref) const;

	/** Constructor using raw copy of pre-existing `::fz_document_writer`. */
	FZ_FUNCTION FzDocumentWriter(::fz_document_writer* internal);

	/** Destructor using fz_drop_document_writer(). */
	FZ_FUNCTION ~FzDocumentWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_document_writer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzDocumentWriter(const FzDocumentWriter& rhs);
	FzDocumentWriter& operator=(const FzDocumentWriter& rhs);
};

/** Wrapper class for struct `fz_draw_options`. Not copyable or assignable. */
/**
	struct fz_draw_options: Options for creating a pixmap and draw
	device.
*/
struct FzDrawOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_draw_options()`. */
	/**
		Parse draw device options from a comma separated key-value string.
	*/
	FZ_FUNCTION FzDrawOptions(FzDrawOptions& options, const char *string);

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzDrawOptions();

	/** Constructor using raw copy of pre-existing `::fz_draw_options`. */
	FZ_FUNCTION FzDrawOptions(const ::fz_draw_options* internal);

	/** Constructor using raw copy of pre-existing `::fz_draw_options`. */
	FZ_FUNCTION FzDrawOptions(const ::fz_draw_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_draw_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_draw_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzDrawOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_draw_options. */
	int rotate;
	int x_resolution;
	int y_resolution;
	int width;
	int height;
	::fz_colorspace *colorspace;
	int alpha;
	int graphics;
	int text;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzDrawOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzDrawOptions& rhs);

	private:

	/** This class is not copyable or assignable. */
	FzDrawOptions(const FzDrawOptions& rhs);
	FzDrawOptions& operator=(const FzDrawOptions& rhs);
};

/** Wrapper class for struct `fz_error_context`. Not copyable or assignable. */
struct FzErrorContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzErrorContext();

	/** Constructor using raw copy of pre-existing `::fz_error_context`. */
	FZ_FUNCTION FzErrorContext(::fz_error_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzErrorContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_error_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzErrorContext(const FzErrorContext& rhs);
	FzErrorContext& operator=(const FzErrorContext& rhs);
};

/** Wrapper class for struct `fz_error_stack_slot`. Not copyable or assignable. */
struct FzErrorStackSlot
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzErrorStackSlot();

	/** Constructor using raw copy of pre-existing `::fz_error_stack_slot`. */
	FZ_FUNCTION FzErrorStackSlot(::fz_error_stack_slot* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzErrorStackSlot();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_error_stack_slot* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzErrorStackSlot(const FzErrorStackSlot& rhs);
	FzErrorStackSlot& operator=(const FzErrorStackSlot& rhs);
};

/** Wrapper class for struct `fz_font`. */
/**
	An abstract font handle.
*/
struct FzFont
{
	/** == Constructors. */

	/** Constructor using `fz_new_base14_font()`. */
	/**
		Create a new font from one of the built-in fonts.
	*/
	FZ_FUNCTION FzFont(const char *name);

	/** Constructor using `fz_new_builtin_font()`. */
	FZ_FUNCTION FzFont(const char *name, int is_bold, int is_italic);

	/** Constructor using `fz_new_cjk_font()`. */
	FZ_FUNCTION FzFont(int ordering);

	/** Constructor using `fz_new_font_from_buffer()`. */
	/**
		Create a new font from a font file in a fz_buffer.
	
		Fonts created in this way, will be eligible for embedding by default.
	
		name: Name of font (leave NULL to use name from font).
	
		buffer: Buffer to load from.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION FzFont(const char *name, const FzBuffer& buffer, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_font_from_file()`. */
	/**
		Create a new font from a font file.
	
		Fonts created in this way, will be eligible for embedding by default.
	
		name: Name of font (leave NULL to use name from font).
	
		path: File path to load from.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION FzFont(const char *name, const char *path, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_font_from_memory()`. */
	/**
		Create a new font from a font file in memory.
	
		Fonts created in this way, will be eligible for embedding by default.
	
		name: Name of font (leave NULL to use name from font).
	
		data: Pointer to the font file data.
	
		len: Length of the font file data.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION FzFont(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_type3_font()`. */
	/**
		Create a new (empty) type3 font.
	
		name: Name of font (or NULL).
	
		matrix: Font matrix.
	
		Returns a new font handle, or throws exception on
		allocation failure.
	*/
	FZ_FUNCTION FzFont(const char *name, const FzMatrix& matrix);

	/** Copy constructor using `fz_keep_font()`. */
	FZ_FUNCTION FzFont(const FzFont& rhs);

	/** operator= using `fz_keep_font()` and `fz_drop_font()`. */
	FZ_FUNCTION FzFont& operator=(const FzFont& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzFont();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_advance_glyph()`.  */
	/**
		Return the advance for a given glyph.
	
		font: The font to look for the glyph in.
	
		glyph: The glyph to find the advance for.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		Returns the advance for the glyph.
	*/
	FZ_FUNCTION float fz_advance_glyph(int glyph, int wmode) const;

	/** Class-aware wrapper for `::fz_bound_glyph()`.  */
	/**
		Return a bbox for a given glyph in a font.
	
		font: The font to look for the glyph in.
	
		gid: The glyph to bound.
	
		trm: The matrix to apply to the glyph before bounding.
	
		Returns rectangle by value containing the bounds of the given
		glyph.
	*/
	FZ_FUNCTION FzRect fz_bound_glyph(int gid, const FzMatrix& trm) const;

	/** Class-aware wrapper for `::fz_calculate_font_ascender_descender()`.  */
	/**
		Ensure that a font has its ascender/descender values calculated
		from the actual bbox of the glyphs.
	
		Note, that we combine the declared values from the font (or the
		default values if those are not present) with the actual bbox to
		get the final result. So this can only cause ascender/descender
		to move further apart!
	*/
	FZ_FUNCTION void fz_calculate_font_ascender_descender() const;

	/** Class-aware wrapper for `::fz_decouple_type3_font()`.  */
	FZ_FUNCTION void fz_decouple_type3_font(void *t3doc) const;

	/** Class-aware wrapper for `::fz_encode_character()`.  */
	/**
		Find the glyph id for a given unicode
		character within a font.
	
		font: The font to look for the unicode character in.
	
		unicode: The unicode character to encode.
	
		Returns the glyph id for the given unicode value, or 0 if
		unknown.
	*/
	FZ_FUNCTION int fz_encode_character(int unicode) const;

	/** Class-aware wrapper for `::fz_encode_character_by_glyph_name()`.  */
	/**
		Encode character.
	
		Either by direct lookup of glyphname within a font, or, failing
		that, by mapping glyphname to unicode and thence to the glyph
		index within the given font.
	
		Returns zero for type3 fonts.
	*/
	FZ_FUNCTION int fz_encode_character_by_glyph_name(const char *glyphname) const;

	/** Class-aware wrapper for `::fz_encode_character_sc()`.  */
	/**
		Encode character, preferring small-caps variant if available.
	
		font: The font to look for the unicode character in.
	
		unicode: The unicode character to encode.
	
		Returns the glyph id for the given unicode value, or 0 if
		unknown.
	*/
	FZ_FUNCTION int fz_encode_character_sc(int unicode) const;

	/** Class-aware wrapper for `::fz_encode_character_with_fallback()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_encode_character_with_fallback(int unicode, int script, int language, ::fz_font **out_font)` => `(int)`
	 */
	/**
		Find the glyph id for
		a given unicode character within a font, falling back to
		an alternative if not found.
	
		font: The font to look for the unicode character in.
	
		unicode: The unicode character to encode.
	
		script: The script in use.
	
		language: The language in use.
	
		out_font: The font handle in which the given glyph represents
		the requested unicode character. The caller does not own the
		reference it is passed, so should call fz_keep_font if it is
		not simply to be used immediately.
	
		Returns the glyph id for the given unicode value in the supplied
		font (and sets *out_font to font) if it is present. Otherwise
		an alternative fallback font (based on script/language) is
		searched for. If the glyph is found therein, *out_font is set
		to this reference, and the glyph reference is returned. If it
		cannot be found anywhere, the function returns 0.
	*/
	FZ_FUNCTION int fz_encode_character_with_fallback(int unicode, int script, int language, FzFont& out_font) const;

	/** Class-aware wrapper for `::fz_enumerate_font_cmap()`.  */
	/**
		Enumerate a cmap using a callback.
	*/
	FZ_FUNCTION void fz_enumerate_font_cmap(::fz_cmap_callback *cb, void *opaque) const;

	/** Class-aware wrapper for `::fz_enumerate_font_cmap2()`.  */
	/** SWIG-friendly wrapper for fz_enumerate_font_cmap(). */
	FZ_FUNCTION std::vector<fz_font_ucs_gid> fz_enumerate_font_cmap2() const;

	/** Class-aware wrapper for `::fz_extract_ttf_from_ttc()`.  */
	FZ_FUNCTION FzBuffer fz_extract_ttf_from_ttc() const;

	/** Class-aware wrapper for `::fz_font_ascender()`.  */
	/**
		Retrieve font ascender in ems.
	*/
	FZ_FUNCTION float fz_font_ascender() const;

	/** Class-aware wrapper for `::fz_font_bbox()`.  */
	/**
		Retrieve the font bbox.
	
		font: The font to query.
	
		Returns the font bbox by value; it is valid only if
		fz_font_flags(font)->invalid_bbox is zero.
	*/
	FZ_FUNCTION FzRect fz_font_bbox() const;

	/** Class-aware wrapper for `::fz_font_descender()`.  */
	/**
		Retrieve font descender in ems.
	*/
	FZ_FUNCTION float fz_font_descender() const;

	/** Class-aware wrapper for `::fz_font_digest()`.  */
	/**
		Retrieve the MD5 digest for the font's data.
	*/
	FZ_FUNCTION void fz_font_digest(unsigned char digest[16]) const;

	/** Class-aware wrapper for `::fz_font_ft_face()`.  */
	/**
		Retrieve the FT_Face handle
		for the font.
	
		font: The font to query
	
		Returns the FT_Face handle for the font, or NULL
		if not a freetype handled font. (Cast to void *
		to avoid nasty header exposure).
	*/
	FZ_FUNCTION void *fz_font_ft_face() const;

	/** Class-aware wrapper for `::fz_font_is_bold()`.  */
	/**
		Query whether the font flags say that this font is bold.
	*/
	FZ_FUNCTION int fz_font_is_bold() const;

	/** Class-aware wrapper for `::fz_font_is_italic()`.  */
	/**
		Query whether the font flags say that this font is italic.
	*/
	FZ_FUNCTION int fz_font_is_italic() const;

	/** Class-aware wrapper for `::fz_font_is_monospaced()`.  */
	/**
		Query whether the font flags say that this font is monospaced.
	*/
	FZ_FUNCTION int fz_font_is_monospaced() const;

	/** Class-aware wrapper for `::fz_font_is_serif()`.  */
	/**
		Query whether the font flags say that this font is serif.
	*/
	FZ_FUNCTION int fz_font_is_serif() const;

	/** Class-aware wrapper for `::fz_font_name()`.  */
	/**
		Retrieve a pointer to the name of the font.
	
		font: The font to query.
	
		Returns a pointer to an internal copy of the font name.
		Will never be NULL, but may be the empty string.
	*/
	FZ_FUNCTION const char *fz_font_name() const;

	/** Class-aware wrapper for `::fz_font_t3_procs()`.  */
	/**
		Retrieve the Type3 procs
		for a font.
	
		font: The font to query
	
		Returns the t3_procs pointer. Will be NULL for a
		non type-3 font.
	*/
	FZ_FUNCTION ::fz_buffer **fz_font_t3_procs() const;

	/** Class-aware wrapper for `::fz_get_glyph_name()`.  */
	/**
		Find the name of a glyph
	
		font: The font to look for the glyph in.
	
		glyph: The glyph id to look for.
	
		buf: Pointer to a buffer for the name to be inserted into.
	
		size: The size of the buffer.
	
		If a font contains a name table, then the name of the glyph
		will be returned in the supplied buffer. Otherwise a name
		is synthesised. The name will be truncated to fit in
		the buffer.
	*/
	FZ_FUNCTION void fz_get_glyph_name(int glyph, char *buf, int size) const;

	/** Class-aware wrapper for `::fz_get_glyph_name2()`.  */
	/**
	C++ alternative to fz_get_glyph_name() that returns information in a std::string.
	*/
	FZ_FUNCTION std::string fz_get_glyph_name2(int glyph) const;

	/** Class-aware wrapper for `::fz_glyph_cacheable()`.  */
	/**
		Determine if a given glyph in a font
		is cacheable. Certain glyphs in a type 3 font cannot safely
		be cached, as their appearance depends on the enclosing
		graphic state.
	
		font: The font to look for the glyph in.
	
		gif: The glyph to query.
	
		Returns non-zero if cacheable, 0 if not.
	*/
	FZ_FUNCTION int fz_glyph_cacheable(int gid) const;

	/** Class-aware wrapper for `::fz_measure_string()`.  */
	/**
		Measure the advance width of a UTF8 string should it be added to a text object.
	
		This uses the same layout algorithms as fz_show_string, and can be used
		to calculate text alignment adjustments.
	*/
	FZ_FUNCTION FzMatrix fz_measure_string(const FzMatrix& trm, const char *s, int wmode, int bidi_level, ::fz_bidi_direction markup_dir, ::fz_text_language language) const;

	/** Class-aware wrapper for `::fz_outline_glyph()`.  */
	/**
		Look a glyph up from a font, and return the outline of the
		glyph using the given transform.
	
		The caller owns the returned path, and so is responsible for
		ensuring that it eventually gets dropped.
	*/
	FZ_FUNCTION FzPath fz_outline_glyph(int gid, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_prepare_t3_glyph()`.  */
	/**
		Force a type3 font to cache the displaylist for a given glyph
		id.
	
		This caching can involve reading the underlying file, so must
		happen ahead of time, so we aren't suddenly forced to read the
		file while playing a displaylist back.
	*/
	FZ_FUNCTION void fz_prepare_t3_glyph(int gid) const;

	/** Class-aware wrapper for `::fz_render_glyph_pixmap()`.  */
	/**
		Create a pixmap containing a rendered glyph.
	
		Lookup gid from font, clip it with scissor, and rendering it
		with aa bits of antialiasing into a new pixmap.
	
		The caller takes ownership of the pixmap and so must free it.
	
		Note: This function is no longer used for normal rendering
		operations, and is kept around just because we use it in the
		app. It should be considered "at risk" of removal from the API.
	*/
	FZ_FUNCTION FzPixmap fz_render_glyph_pixmap(int gid, FzMatrix& ctm, FzIrect& scissor, int aa) const;

	/** Class-aware wrapper for `::fz_run_t3_glyph()`.  */
	/**
		Run a glyph from a Type3 font to
		a given device.
	
		font: The font to find the glyph in.
	
		gid: The glyph to run.
	
		trm: The transform to apply.
	
		dev: The device to render onto.
	*/
	FZ_FUNCTION void fz_run_t3_glyph(int gid, const FzMatrix& trm, const FzDevice& dev) const;

	/** Class-aware wrapper for `::fz_set_font_bbox()`.  */
	/**
		Set the font bbox.
	
		font: The font to set the bbox for.
	
		xmin, ymin, xmax, ymax: The bounding box.
	*/
	FZ_FUNCTION void fz_set_font_bbox(float xmin, float ymin, float xmax, float ymax) const;

	/** Class-aware wrapper for `::fz_set_font_embedding()`.  */
	/**
		Control whether a given font should be embedded or not when writing.
	*/
	FZ_FUNCTION void fz_set_font_embedding(int embed) const;

	/** Class-aware wrapper for `::pdf_font_writing_supported()`.  */
	FZ_FUNCTION int pdf_font_writing_supported() const;

	/** Class-aware wrapper for `::pdf_layout_fit_text()`.  */
	FZ_FUNCTION FzText pdf_layout_fit_text(::fz_text_language lang, const char *str, const FzRect& bounds) const;

	/** Constructor using raw copy of pre-existing `::fz_font`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_font* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzFont(::fz_font* internal);

	/** Destructor using fz_drop_font(). */
	FZ_FUNCTION ~FzFont();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_font* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_font_context`. Not copyable or assignable. */
struct FzFontContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzFontContext();

	/** Constructor using raw copy of pre-existing `::fz_font_context`. */
	FZ_FUNCTION FzFontContext(::fz_font_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzFontContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_font_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzFontContext(const FzFontContext& rhs);
	FzFontContext& operator=(const FzFontContext& rhs);
};

/** Wrapper class for struct `fz_font_flags_t`. Not copyable or assignable. */
/**
	Every fz_font carries a set of flags
	within it, in a fz_font_flags_t structure.
*/
struct FzFontFlagsT
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzFontFlagsT();

	/** Constructor using raw copy of pre-existing `::fz_font_flags_t`. */
	FZ_FUNCTION FzFontFlagsT(::fz_font_flags_t* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzFontFlagsT();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_font_flags_t* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzFontFlagsT(const FzFontFlagsT& rhs);
	FzFontFlagsT& operator=(const FzFontFlagsT& rhs);
};

/** Wrapper class for struct `fz_function`. */
struct FzFunction
{
	/** == Constructors. */

	/** Constructor using `fz_new_function_of_size()`. */
	FZ_FUNCTION FzFunction(int size, size_t size2, int m, int n, ::fz_function_eval_fn *eval, ::fz_store_drop_fn *drop);

	/** Copy constructor using `fz_keep_function()`. */
	FZ_FUNCTION FzFunction(const FzFunction& rhs);

	/** operator= using `fz_keep_function()` and `fz_drop_function()`. */
	FZ_FUNCTION FzFunction& operator=(const FzFunction& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzFunction();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_eval_function()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_eval_function(const float *in, int inlen, int outlen)` => float out
	 */
	FZ_FUNCTION void fz_eval_function(const float *in, int inlen, float *out, int outlen) const;

	/** Class-aware wrapper for `::fz_function_size()`.  */
	FZ_FUNCTION size_t fz_function_size() const;

	/** Constructor using raw copy of pre-existing `::fz_function`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_function* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzFunction(::fz_function* internal);

	/** Destructor using fz_drop_function(). */
	FZ_FUNCTION ~FzFunction();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_function* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_getopt_long_options`. Not copyable or assignable. */
struct FzGetoptLongOptions
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzGetoptLongOptions();

	/** Constructor using raw copy of pre-existing `::fz_getopt_long_options`. */
	FZ_FUNCTION FzGetoptLongOptions(::fz_getopt_long_options* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzGetoptLongOptions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_getopt_long_options* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzGetoptLongOptions(const FzGetoptLongOptions& rhs);
	FzGetoptLongOptions& operator=(const FzGetoptLongOptions& rhs);
};

/** Wrapper class for struct `fz_glyph`. */
/**
	Glyphs represent a run length encoded set of pixels for a 2
	dimensional region of a plane.
*/
struct FzGlyph
{
	/** Copy constructor using `fz_keep_glyph()`. */
	FZ_FUNCTION FzGlyph(const FzGlyph& rhs);

	/** operator= using `fz_keep_glyph()` and `fz_drop_glyph()`. */
	FZ_FUNCTION FzGlyph& operator=(const FzGlyph& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzGlyph();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_glyph_bbox()`.  */
	/**
		Return the bounding box of the glyph in pixels.
	*/
	FZ_FUNCTION FzIrect fz_glyph_bbox() const;

	/** Class-aware wrapper for `::fz_glyph_bbox_no_ctx()`.  */
	FZ_FUNCTION FzIrect fz_glyph_bbox_no_ctx() const;

	/** Class-aware wrapper for `::fz_glyph_height()`.  */
	/**
		Return the height of the glyph in pixels.
	*/
	FZ_FUNCTION int fz_glyph_height() const;

	/** Class-aware wrapper for `::fz_glyph_width()`.  */
	/**
		Return the width of the glyph in pixels.
	*/
	FZ_FUNCTION int fz_glyph_width() const;

	/** Constructor using raw copy of pre-existing `::fz_glyph`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_glyph* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzGlyph(::fz_glyph* internal);

	/** Destructor using fz_drop_glyph(). */
	FZ_FUNCTION ~FzGlyph();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_glyph* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_glyph_cache`. Not copyable or assignable. */
struct FzGlyphCache
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzGlyphCache();

	/** Constructor using raw copy of pre-existing `::fz_glyph_cache`. */
	FZ_FUNCTION FzGlyphCache(::fz_glyph_cache* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzGlyphCache();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_glyph_cache* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzGlyphCache(const FzGlyphCache& rhs);
	FzGlyphCache& operator=(const FzGlyphCache& rhs);
};

/** Wrapper class for struct `fz_halftone`. */
/**
	A halftone is a set of threshold tiles, one per component. Each
	threshold tile is a pixmap, possibly of varying sizes and
	phases. Currently, we only provide one 'default' halftone tile
	for operating on 1 component plus alpha pixmaps (where the alpha
	is ignored). This is signified by a fz_halftone pointer to NULL.
*/
struct FzHalftone
{
	/** Copy constructor using `fz_keep_halftone()`. */
	FZ_FUNCTION FzHalftone(const FzHalftone& rhs);

	/** operator= using `fz_keep_halftone()` and `fz_drop_halftone()`. */
	FZ_FUNCTION FzHalftone& operator=(const FzHalftone& rhs);

	/** Constructor using raw copy of pre-existing `::fz_halftone`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_halftone* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzHalftone(::fz_halftone* internal=NULL);

	/** Destructor using fz_drop_halftone(). */
	FZ_FUNCTION ~FzHalftone();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_halftone* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_hash_table`. Not copyable or assignable. */
/**
	Generic hash-table with fixed-length keys.

	The keys and values are NOT reference counted by the hash table.
	Callers are responsible for taking care the reference counts are
	correct. Inserting a duplicate entry will NOT overwrite the old
	value, and will return the old value.

	The drop_val callback function is only used to release values
	when the hash table is destroyed.
*/
struct FzHashTable
{
	/** == Constructors. */

	/** Constructor using `fz_new_hash_table()`. */
	/**
		Create a new hash table.
	
		initialsize: The initial size of the hashtable. The hashtable
		may grow (double in size) if it starts to get crowded (80%
		full).
	
		keylen: byte length for each key.
	
		lock: -1 for no lock, otherwise the FZ_LOCK to use to protect
		this table.
	
		drop_val: Function to use to destroy values on table drop.
	*/
	FZ_FUNCTION FzHashTable(int initialsize, int keylen, int lock, ::fz_hash_table_drop_fn *drop_val);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzHashTable();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_hash_filter()`.  */
	/**
		Iterate over the entries in a hash table, removing all the ones where callback returns true.
		Does NOT free the value of the entry, so the caller is expected to take care of this.
	*/
	FZ_FUNCTION void fz_hash_filter(void *state, ::fz_hash_table_filter_fn *callback) const;

	/** Class-aware wrapper for `::fz_hash_find()`.  */
	/**
		Search for a matching hash within the table, and return the
		associated value.
	*/
	FZ_FUNCTION void *fz_hash_find(const void *key) const;

	/** Class-aware wrapper for `::fz_hash_for_each()`.  */
	/**
		Iterate over the entries in a hash table.
	*/
	FZ_FUNCTION void fz_hash_for_each(void *state, ::fz_hash_table_for_each_fn *callback) const;

	/** Class-aware wrapper for `::fz_hash_insert()`.  */
	/**
		Insert a new key/value pair into the hash table.
	
		If an existing entry with the same key is found, no change is
		made to the hash table, and a pointer to the existing value is
		returned.
	
		If no existing entry with the same key is found, ownership of
		val passes in, key is copied, and NULL is returned.
	*/
	FZ_FUNCTION void *fz_hash_insert(const void *key, void *val) const;

	/** Class-aware wrapper for `::fz_hash_remove()`.  */
	/**
		Remove the entry for a given key.
	
		The value is NOT freed, so the caller is expected to take care
		of this.
	*/
	FZ_FUNCTION void fz_hash_remove(const void *key) const;

	/** Constructor using raw copy of pre-existing `::fz_hash_table`. */
	FZ_FUNCTION FzHashTable(::fz_hash_table* internal);

	/** Destructor using fz_drop_hash_table(). */
	FZ_FUNCTION ~FzHashTable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_hash_table* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzHashTable(const FzHashTable& rhs);
	FzHashTable& operator=(const FzHashTable& rhs);
};

/** Wrapper class for struct `fz_icc_profile`. Not copyable or assignable. */
/**
	Opaque type for an ICC Profile.
*/
struct FzIccProfile
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzIccProfile();

	/** Constructor using raw copy of pre-existing `::fz_icc_profile`. */
	FZ_FUNCTION FzIccProfile(::fz_icc_profile* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzIccProfile();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_icc_profile* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzIccProfile(const FzIccProfile& rhs);
	FzIccProfile& operator=(const FzIccProfile& rhs);
};

/** Wrapper class for struct `fz_image`. */
/**
	Images are storable objects from which we can obtain fz_pixmaps.
	These may be implemented as simple wrappers around a pixmap, or
	as more complex things that decode at different subsample
	settings on demand.
*/
struct FzImage
{
	/** == Constructors. */

	/** Constructor using `fz_new_barcode_image()`. */
	/**
		Create an fz_image from a barcode definition.
	
		type: The type of barcode to create.
		value: The value of the barcode.
		size: The size of the barcode.
		ec_level: error correction level 0-8.
		quiet: whether to include quiet zones (0 or 1).
		hrt: whether to include human readable text below the barcode (0 or 1).
	
		returns a created fz_image.
	*/
	FZ_FUNCTION FzImage(::fz_barcode_type type, const char *value, int size, int ec_level, int quiet, int hrt);

	/** Constructor using `fz_new_image_from_buffer()`. */
	/**
		Create a new image from a
		buffer of data, inferring its type from the format
		of the data.
	*/
	FZ_FUNCTION FzImage(const FzBuffer& buffer);

	/** Constructor using `fz_new_image_from_compressed_buffer()`. */
	/**
		Create an image based on
		the data in the supplied compressed buffer.
	
		w,h: Width and height of the created image.
	
		bpc: Bits per component.
	
		colorspace: The colorspace (determines the number of components,
		and any color conversions required while decoding).
	
		xres, yres: The X and Y resolutions respectively.
	
		interpolate: 1 if interpolation should be used when decoding
		this image, 0 otherwise.
	
		imagemask: 1 if this is an imagemask (i.e. transparency bitmap
		mask), 0 otherwise.
	
		decode: NULL, or a pointer to to a decode array. The default
		decode array is [0 1] (repeated n times, for n color components).
	
		colorkey: NULL, or a pointer to a colorkey array. The default
		colorkey array is [0 255] (repeated n times, for n color
		components).
	
		buffer: Buffer of compressed data and compression parameters.
		Ownership of this reference is passed in.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION FzImage(int w, int h, int bpc, const FzColorspace& colorspace, int xres, int yres, int interpolate, int imagemask, const float *decode, const int *colorkey, const FzCompressedBuffer& buffer, const FzImage& mask);

	/** Constructor using `fz_new_image_from_compressed_buffer2()`. */
	/** Swig-friendly wrapper for fz_new_image_from_compressed_buffer(),
	uses specified `decode` and `colorkey` if they are not null (in which
	case we assert that they have size `2*fz_colorspace_n(colorspace)`). */
	FZ_FUNCTION FzImage(int w, int h, int bpc, const FzColorspace& colorspace, int xres, int yres, int interpolate, int imagemask, const std::vector<float> &decode, const std::vector<int> &colorkey, const FzCompressedBuffer& buffer, const FzImage& mask);

	/** Constructor using `fz_new_image_from_display_list()`. */
	/**
		Create a new image from a display list.
	
		w, h: The conceptual width/height of the image.
	
		transform: The matrix that needs to be applied to the given
		list to make it render to the unit square.
	
		list: The display list.
	*/
	FZ_FUNCTION FzImage(float w, float h, const FzDisplayList& list);

	/** Constructor using `fz_new_image_from_file()`. */
	/**
		Create a new image from the contents
		of a file, inferring its type from the format of the
		data.
	*/
	FZ_FUNCTION FzImage(const char *path);

	/** Constructor using `fz_new_image_from_pixmap()`. */
	/**
		Create an image from the given
		pixmap.
	
		pixmap: The pixmap to base the image upon. A new reference
		to this is taken.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION FzImage(const FzPixmap& pixmap, const FzImage& mask);

	/** Constructor using `fz_new_image_from_svg()`. */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION FzImage(const FzBuffer& buf, const char *base_uri, const FzArchive& dir);

	/** Constructor using `fz_new_image_from_svg_xml()`. */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION FzImage(const FzXml& xmldoc, const FzXml& xml, const char *base_uri, const FzArchive& dir);

	/** Constructor using `fz_new_image_of_size()`. */
	/**
		Internal function to make a new fz_image structure
		for a derived class.
	
		w,h: Width and height of the created image.
	
		bpc: Bits per component.
	
		colorspace: The colorspace (determines the number of components,
		and any color conversions required while decoding).
	
		xres, yres: The X and Y resolutions respectively.
	
		interpolate: 1 if interpolation should be used when decoding
		this image, 0 otherwise.
	
		imagemask: 1 if this is an imagemask (i.e. transparent), 0
		otherwise.
	
		decode: NULL, or a pointer to to a decode array. The default
		decode array is [0 1] (repeated n times, for n color components).
	
		colorkey: NULL, or a pointer to a colorkey array. The default
		colorkey array is [0 255] (repeated n times, for n color
		components).
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	
		size: The size of the required allocated structure (the size of
		the derived structure).
	
		get: The function to be called to obtain a decoded pixmap.
	
		get_size: The function to be called to return the storage size
		used by this image.
	
		drop: The function to be called to dispose of this image once
		the last reference is dropped.
	
		Returns a pointer to an allocated structure of the required size,
		with the first sizeof(fz_image) bytes initialised as appropriate
		given the supplied parameters, and the other bytes set to zero.
	*/
	FZ_FUNCTION FzImage(int w, int h, int bpc, const FzColorspace& colorspace, int xres, int yres, int interpolate, int imagemask, const float *decode, const int *colorkey, const FzImage& mask, size_t size, ::fz_image_get_pixmap_fn *get_pixmap, ::fz_image_get_size_fn *get_size, ::fz_drop_image_fn *drop);

	/** Copy constructor using `fz_keep_image()`. */
	FZ_FUNCTION FzImage(const FzImage& rhs);

	/** operator= using `fz_keep_image()` and `fz_drop_image()`. */
	FZ_FUNCTION FzImage& operator=(const FzImage& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzImage();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_compressed_image_buffer()`.  */
	/**
		Retrieve the underlying compressed data for an image.
	
		Returns a pointer to the underlying data buffer for an image,
		or NULL if this image is not based upon a compressed data
		buffer.
	
		This is not a reference counted structure, so no reference is
		returned. Lifespan is limited to that of the image itself.
	*/
	FZ_FUNCTION FzCompressedBuffer fz_compressed_image_buffer() const;

	/** Class-aware wrapper for `::fz_compressed_image_type()`.  */
	/**
		Return the type of a compressed image.
	
		Any non-compressed image will have the type returned as UNKNOWN.
	*/
	FZ_FUNCTION int fz_compressed_image_type() const;

	/** Class-aware wrapper for `::fz_get_pixmap_from_image()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_get_pixmap_from_image(const ::fz_irect *subarea, ::fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
	 */
	/**
		Called to get a handle to a pixmap from an image.
	
		image: The image to retrieve a pixmap from.
	
		subarea: The subarea of the image that we actually care about
		(or NULL to indicate the whole image).
	
		ctm: Optional, unless subarea is given. If given, then on
		entry this is the transform that will be applied to the complete
		image. It should be updated on exit to the transform to apply to
		the given subarea of the image. This is used to calculate the
		desired width/height for subsampling.
	
		w: If non-NULL, a pointer to an int to be updated on exit to the
		width (in pixels) that the scaled output will cover.
	
		h: If non-NULL, a pointer to an int to be updated on exit to the
		height (in pixels) that the scaled output will cover.
	
		Returns a non NULL kept pixmap pointer. May throw exceptions.
	*/
	FZ_FUNCTION FzPixmap fz_get_pixmap_from_image(FzIrect& subarea, FzMatrix& ctm, int *w, int *h) const;

	/** Class-aware wrapper for `::fz_get_unscaled_pixmap_from_image()`.  */
	/**
		Calls fz_get_pixmap_from_image() with ctm, subarea, w and h all set to NULL.
	*/
	FZ_FUNCTION FzPixmap fz_get_unscaled_pixmap_from_image() const;

	/** Class-aware wrapper for `::fz_image_orientation()`.  */
	/**
		Request the natural orientation of an image.
	
		This is for images (such as JPEG) that can contain internal
		specifications of rotation/flips. This is ignored by all the
		internal decode/rendering routines, but can be used by callers
		(such as the image document handler) to respect such
		specifications.
	
		The values used by MuPDF are as follows, with the equivalent
		Exif specifications given for information:
	
		0: Undefined
		1: 0 degree ccw rotation. (Exif = 1)
		2: 90 degree ccw rotation. (Exif = 8)
		3: 180 degree ccw rotation. (Exif = 3)
		4: 270 degree ccw rotation. (Exif = 6)
		5: flip on X. (Exif = 2)
		6: flip on X, then rotate ccw by 90 degrees. (Exif = 5)
		7: flip on X, then rotate ccw by 180 degrees. (Exif = 4)
		8: flip on X, then rotate ccw by 270 degrees. (Exif = 7)
	*/
	FZ_FUNCTION uint8_t fz_image_orientation() const;

	/** Class-aware wrapper for `::fz_image_orientation_matrix()`.  */
	FZ_FUNCTION FzMatrix fz_image_orientation_matrix() const;

	/** Class-aware wrapper for `::fz_image_resolution()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_image_resolution()` => `(int xres, int yres)`
	 */
	/**
		Request the natural resolution
		of an image.
	
		xres, yres: Pointers to ints to be updated with the
		natural resolution of an image (or a sensible default
		if not encoded).
	*/
	FZ_FUNCTION void fz_image_resolution(int *xres, int *yres) const;

	/** Class-aware wrapper for `::fz_image_size()`.  */
	/**
		Return the size of the storage used by an image.
	*/
	FZ_FUNCTION size_t fz_image_size() const;

	/** Class-aware wrapper for `::fz_is_lossy_image()`.  */
	FZ_FUNCTION int fz_is_lossy_image() const;

	/** Class-aware wrapper for `::fz_new_bitmap_from_image()`.  */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		img: The image to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap fz_new_bitmap_from_image(const FzHalftone& ht) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_jpeg()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_jpeg(const FzColorParams& color_params, int quality, int invert_cmyk) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_jpx()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_jpx(const FzColorParams& color_params, int quality) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pam()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_pam(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pbm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_pbm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pkm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_pkm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_png()`.  */
	/**
		Re-encode a given image as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_png(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_pnm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_pnm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_image_as_psd()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_image_as_psd(const FzColorParams& color_params) const;

	/** Constructor using raw copy of pre-existing `::fz_image`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_image* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzImage(::fz_image* internal);

	/* == Accessors to members of ::fz_image m_internal. */

	FZ_FUNCTION ::fz_key_storable key_storable();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION uint8_t n();
	FZ_FUNCTION uint8_t bpc();
	FZ_FUNCTION unsigned int imagemask();
	FZ_FUNCTION unsigned int interpolate();
	FZ_FUNCTION unsigned int use_colorkey();
	FZ_FUNCTION unsigned int use_decode();
	FZ_FUNCTION unsigned int decoded();
	FZ_FUNCTION unsigned int scalable();
	FZ_FUNCTION unsigned int intent();
	FZ_FUNCTION unsigned int has_intent();
	FZ_FUNCTION uint8_t orientation();
	FZ_FUNCTION FzImage mask();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION FzColorspace colorspace();
	FZ_FUNCTION int * colorkey();
	FZ_FUNCTION float * decode();

	/** Destructor using fz_drop_image(). */
	FZ_FUNCTION ~FzImage();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_image* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_install_load_system_font_funcs_args`. */
/**
Extra struct containing fz_install_load_system_font_funcs()'s args,
which we wrap with virtual_fnptrs set to allow use from Python/C# via
Swig Directors.
*/
struct FzInstallLoadSystemFontFuncsArgs
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzInstallLoadSystemFontFuncsArgs();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_install_load_system_font_funcs2()`.  */
	/**
	Alternative to fz_install_load_system_font_funcs() that takes args in a
	struct, to allow use from Python/C# via Swig Directors.
	*/
	FZ_FUNCTION void fz_install_load_system_font_funcs2();

	/** Constructor using raw copy of pre-existing `::fz_install_load_system_font_funcs_args`. */
	FZ_FUNCTION FzInstallLoadSystemFontFuncsArgs(const ::fz_install_load_system_font_funcs_args* internal);

	/* == Accessors to members of ::fz_install_load_system_font_funcs_args m_internal. */


	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzInstallLoadSystemFontFuncsArgs();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	::fz_install_load_system_font_funcs_args  m_internal; /** Wrapped data is held by value. */

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzInstallLoadSystemFontFuncsArgs& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzInstallLoadSystemFontFuncsArgs& rhs);
};

/** Wrapper class for struct fz_install_load_system_font_funcs_args with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct FzInstallLoadSystemFontFuncsArgs2 : FzInstallLoadSystemFontFuncsArgs
{

	/** == Constructor. */
	FZ_FUNCTION FzInstallLoadSystemFontFuncsArgs2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~FzInstallLoadSystemFontFuncsArgs2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_f( bool use=true);
	FZ_FUNCTION void use_virtual_f_cjk( bool use=true);
	FZ_FUNCTION void use_virtual_f_fallback( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual ::fz_font * f(::fz_context *arg_0, const char *arg_1, int arg_2, int arg_3, int arg_4);
	FZ_FUNCTION virtual ::fz_font * f_cjk(::fz_context *arg_0, const char *arg_1, int arg_2, int arg_3);
	FZ_FUNCTION virtual ::fz_font * f_fallback(::fz_context *arg_0, int arg_1, int arg_2, int arg_3, int arg_4, int arg_5);
};

/** Wrapper class for struct `fz_int2`. Not copyable or assignable. */
struct FzInt2
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzInt2();

	/** Constructor using raw copy of pre-existing `::fz_int2`. */
	FZ_FUNCTION FzInt2(::fz_int2* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzInt2();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_int2* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzInt2(const FzInt2& rhs);
	FzInt2& operator=(const FzInt2& rhs);
};

/** Wrapper class for struct `fz_int2_heap`. Not copyable or assignable. */
struct FzInt2Heap
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzInt2Heap();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_int2_heap_debug()`.  */
	FZ_FUNCTION void fz_int2_heap_debug() const;

	/** Class-aware wrapper for `::fz_int2_heap_insert()`.  */
	FZ_FUNCTION void fz_int2_heap_insert(const FzInt2& v) const;

	/** Class-aware wrapper for `::fz_int2_heap_sort()`.  */
	FZ_FUNCTION void fz_int2_heap_sort() const;

	/** Class-aware wrapper for `::fz_int2_heap_uniq()`.  */
	FZ_FUNCTION void fz_int2_heap_uniq() const;

	/** Constructor using raw copy of pre-existing `::fz_int2_heap`. */
	FZ_FUNCTION FzInt2Heap(::fz_int2_heap* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzInt2Heap();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_int2_heap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzInt2Heap(const FzInt2Heap& rhs);
	FzInt2Heap& operator=(const FzInt2Heap& rhs);
};

/** Wrapper class for struct `fz_int_heap`. Not copyable or assignable. */
struct FzIntHeap
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzIntHeap();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_int_heap_debug()`.  */
	FZ_FUNCTION void fz_int_heap_debug() const;

	/** Class-aware wrapper for `::fz_int_heap_insert()`.  */
	FZ_FUNCTION void fz_int_heap_insert(int v) const;

	/** Class-aware wrapper for `::fz_int_heap_sort()`.  */
	FZ_FUNCTION void fz_int_heap_sort() const;

	/** Class-aware wrapper for `::fz_int_heap_uniq()`.  */
	FZ_FUNCTION void fz_int_heap_uniq() const;

	/** Constructor using raw copy of pre-existing `::fz_int_heap`. */
	FZ_FUNCTION FzIntHeap(::fz_int_heap* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzIntHeap();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_int_heap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzIntHeap(const FzIntHeap& rhs);
	FzIntHeap& operator=(const FzIntHeap& rhs);
};

/** Wrapper class for struct `fz_intptr`. Not copyable or assignable. */
struct FzIntptr
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzIntptr();

	/** Constructor using raw copy of pre-existing `::fz_intptr`. */
	FZ_FUNCTION FzIntptr(::fz_intptr* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzIntptr();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_intptr* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzIntptr(const FzIntptr& rhs);
	FzIntptr& operator=(const FzIntptr& rhs);
};

/** Wrapper class for struct `fz_intptr_heap`. Not copyable or assignable. */
struct FzIntptrHeap
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzIntptrHeap();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_intptr_heap_debug()`.  */
	FZ_FUNCTION void fz_intptr_heap_debug() const;

	/** Class-aware wrapper for `::fz_intptr_heap_insert()`.  */
	FZ_FUNCTION void fz_intptr_heap_insert(const FzIntptr& v) const;

	/** Class-aware wrapper for `::fz_intptr_heap_sort()`.  */
	FZ_FUNCTION void fz_intptr_heap_sort() const;

	/** Class-aware wrapper for `::fz_intptr_heap_uniq()`.  */
	FZ_FUNCTION void fz_intptr_heap_uniq() const;

	/** Constructor using raw copy of pre-existing `::fz_intptr_heap`. */
	FZ_FUNCTION FzIntptrHeap(::fz_intptr_heap* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzIntptrHeap();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_intptr_heap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzIntptrHeap(const FzIntptrHeap& rhs);
	FzIntptrHeap& operator=(const FzIntptrHeap& rhs);
};

/** Wrapper class for struct `fz_irect`. */
/**
	fz_irect is a rectangle using integers instead of floats.

	It's used in the draw device and for pixmap dimensions.
*/
struct FzIrect
{
	/** == Constructors. */

	/** Constructor using `fz_irect_from_rect()`. */
	/**
		Convert a rect into the minimal bounding box
		that covers the rectangle.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	*/
	FZ_FUNCTION FzIrect(const FzRect& rect);

	/** Constructor using `fz_make_irect()`. */
	FZ_FUNCTION FzIrect(int x0, int y0, int x1, int y1);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzIrect();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_expand_irect()`.  */
	FZ_FUNCTION FzIrect fz_expand_irect(int expand);

	/** Class-aware wrapper for `::fz_intersect_irect()`.  */
	/**
		Compute intersection of two bounding boxes.
	
		Similar to fz_intersect_rect but operates on two bounding
		boxes instead of two rectangles.
	*/
	FZ_FUNCTION FzIrect fz_intersect_irect(const FzIrect& b);

	/** Class-aware wrapper for `::fz_irect_height()`.  */
	/**
		Return the height of an irect. Invalid irects return 0.
	*/
	FZ_FUNCTION int fz_irect_height();

	/** Class-aware wrapper for `::fz_irect_width()`.  */
	/**
		Return the width of an irect. Invalid irects return 0.
	*/
	FZ_FUNCTION unsigned int fz_irect_width();

	/** Class-aware wrapper for `::fz_is_empty_irect()`.  */
	FZ_FUNCTION int fz_is_empty_irect();

	/** Class-aware wrapper for `::fz_is_infinite_irect()`.  */
	/**
		Check if an integer rectangle
		is infinite.
	*/
	FZ_FUNCTION int fz_is_infinite_irect();

	/** Class-aware wrapper for `::fz_is_irect_inside_irect()`.  */
	/**
		Inclusion test for irects.
	
		rects are assumed to be both open or both closed.
	
		No invalid rect can include any other rect.
		No invalid rect can be included by any rect.
		Empty (point) rects can include themselves.
		Empty (line) rects can include many (subline) rects.
	*/
	FZ_FUNCTION int fz_is_irect_inside_irect(const FzIrect& outer);

	/** Class-aware wrapper for `::fz_is_valid_irect()`.  */
	/**
		Check if an integer rectangle is valid.
	*/
	FZ_FUNCTION int fz_is_valid_irect();

	/** Class-aware wrapper for `::fz_rect_from_irect()`.  */
	/**
		Convert a bbox into a rect.
	
		For our purposes, a rect can represent all the values we meet in
		a bbox, so nothing can go wrong.
	
		rect: A place to store the generated rectangle.
	
		bbox: The bbox to convert.
	
		Returns rect (updated).
	*/
	FZ_FUNCTION FzRect fz_rect_from_irect();

	/** Class-aware wrapper for `::fz_translate_irect()`.  */
	FZ_FUNCTION FzIrect fz_translate_irect(int xoff, int yoff);

	/** Constructor using raw copy of pre-existing `::fz_irect`. */
	FZ_FUNCTION FzIrect(const ::fz_irect* internal);

	/** Constructor using raw copy of pre-existing `::fz_irect`. */
	FZ_FUNCTION FzIrect(const ::fz_irect internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_irect* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_irect* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzIrect();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_irect. */
	int x0;
	int y0;
	int x1;
	int y1;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzIrect& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzIrect& rhs);
};

/** Wrapper class for struct `fz_jbig2_globals`. */
struct FzJbig2Globals
{
	/** Copy constructor using `fz_keep_jbig2_globals()`. */
	FZ_FUNCTION FzJbig2Globals(const FzJbig2Globals& rhs);

	/** operator= using `fz_keep_jbig2_globals()` and `fz_drop_jbig2_globals()`. */
	FZ_FUNCTION FzJbig2Globals& operator=(const FzJbig2Globals& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzJbig2Globals();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_jbig2_globals_data()`.  */
	/**
		Return buffer containing jbig2 globals data stream.
	*/
	FZ_FUNCTION FzBuffer fz_jbig2_globals_data() const;

	/** Constructor using raw copy of pre-existing `::fz_jbig2_globals`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_jbig2_globals* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzJbig2Globals(::fz_jbig2_globals* internal);

	/** Destructor using fz_drop_jbig2_globals(). */
	FZ_FUNCTION ~FzJbig2Globals();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_jbig2_globals* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_json`. Not copyable or assignable. */
struct FzJson
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzJson();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_json_array_length()`.  */
	FZ_FUNCTION int fz_json_array_length() const;

	/** Class-aware wrapper for `::fz_json_is_array()`.  */
	FZ_FUNCTION int fz_json_is_array() const;

	/** Class-aware wrapper for `::fz_json_is_boolean()`.  */
	FZ_FUNCTION int fz_json_is_boolean() const;

	/** Class-aware wrapper for `::fz_json_is_null()`.  */
	FZ_FUNCTION int fz_json_is_null() const;

	/** Class-aware wrapper for `::fz_json_is_number()`.  */
	FZ_FUNCTION int fz_json_is_number() const;

	/** Class-aware wrapper for `::fz_json_is_object()`.  */
	FZ_FUNCTION int fz_json_is_object() const;

	/** Class-aware wrapper for `::fz_json_is_string()`.  */
	FZ_FUNCTION int fz_json_is_string() const;

	/** Class-aware wrapper for `::fz_json_to_boolean()`.  */
	FZ_FUNCTION int fz_json_to_boolean() const;

	/** Class-aware wrapper for `::fz_json_to_number()`.  */
	FZ_FUNCTION double fz_json_to_number() const;

	/** Class-aware wrapper for `::fz_json_to_string()`.  */
	FZ_FUNCTION const char *fz_json_to_string() const;

	/** Constructor using raw copy of pre-existing `::fz_json`. */
	FZ_FUNCTION FzJson(::fz_json* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzJson();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_json* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzJson(const FzJson& rhs);
	FzJson& operator=(const FzJson& rhs);
};

/** Wrapper class for struct `fz_json_array`. Not copyable or assignable. */
struct FzJsonArray
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzJsonArray();

	/** Constructor using raw copy of pre-existing `::fz_json_array`. */
	FZ_FUNCTION FzJsonArray(::fz_json_array* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzJsonArray();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_json_array* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzJsonArray(const FzJsonArray& rhs);
	FzJsonArray& operator=(const FzJsonArray& rhs);
};

/** Wrapper class for struct `fz_json_object`. Not copyable or assignable. */
struct FzJsonObject
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzJsonObject();

	/** Constructor using raw copy of pre-existing `::fz_json_object`. */
	FZ_FUNCTION FzJsonObject(::fz_json_object* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzJsonObject();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_json_object* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzJsonObject(const FzJsonObject& rhs);
	FzJsonObject& operator=(const FzJsonObject& rhs);
};

/** Wrapper class for struct `fz_key_storable`. */
/**
	Any storable object that can appear in the key of another
	storable object should include an fz_key_storable structure
	at the start (by convention at least) of their structure.
*/
struct FzKeyStorable
{
	/** Copy constructor using `fz_keep_key_storable()`. */
	FZ_FUNCTION FzKeyStorable(const FzKeyStorable& rhs);

	/** operator= using `fz_keep_key_storable()` and `fz_drop_key_storable()`. */
	FZ_FUNCTION FzKeyStorable& operator=(const FzKeyStorable& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzKeyStorable();

	/** Constructor using raw copy of pre-existing `::fz_key_storable`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_key_storable* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzKeyStorable(::fz_key_storable* internal);

	/** Destructor using fz_drop_key_storable(). */
	FZ_FUNCTION ~FzKeyStorable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_key_storable* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_layout_block`. Not copyable or assignable. */
struct FzLayoutBlock
{
	/** == Constructors. */

	/** Constructor using `fz_new_layout()`. */
	/**
		Create a new layout block, with new allocation pool, zero
		matrices, and initialise linked pointers.
	*/
	FZ_FUNCTION FzLayoutBlock();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_add_layout_char()`.  */
	/**
		Add a new char to the line at the end of the layout block.
	*/
	FZ_FUNCTION void fz_add_layout_char(float x, float w, const char *p) const;

	/** Class-aware wrapper for `::fz_add_layout_line()`.  */
	/**
		Add a new line to the end of the layout block.
	*/
	FZ_FUNCTION void fz_add_layout_line(float x, float y, float h, const char *p) const;

	/** Constructor using raw copy of pre-existing `::fz_layout_block`. */
	FZ_FUNCTION FzLayoutBlock(::fz_layout_block* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLayoutBlock();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_layout_block* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzLayoutBlock(const FzLayoutBlock& rhs);
	FzLayoutBlock& operator=(const FzLayoutBlock& rhs);
};

/** Wrapper class for struct `fz_layout_char`. Not copyable or assignable. */
/**
	Simple text layout (for use with annotation editing primarily).
*/
struct FzLayoutChar
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzLayoutChar();

	/** Constructor using raw copy of pre-existing `::fz_layout_char`. */
	FZ_FUNCTION FzLayoutChar(::fz_layout_char* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLayoutChar();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_layout_char* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzLayoutChar(const FzLayoutChar& rhs);
	FzLayoutChar& operator=(const FzLayoutChar& rhs);
};

/** Wrapper class for struct `fz_layout_line`. Not copyable or assignable. */
struct FzLayoutLine
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzLayoutLine();

	/** Constructor using raw copy of pre-existing `::fz_layout_line`. */
	FZ_FUNCTION FzLayoutLine(::fz_layout_line* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLayoutLine();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_layout_line* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzLayoutLine(const FzLayoutLine& rhs);
	FzLayoutLine& operator=(const FzLayoutLine& rhs);
};

struct FzLinkIterator;

/** Wrapper class for struct `fz_link`. */
/**
	fz_link is a list of interactive links on a page.

	There is no relation between the order of the links in the
	list and the order they appear on the page. The list of links
	for a given page can be obtained from fz_load_links.

	A link is reference counted. Dropping a reference to a link is
	done by calling fz_drop_link.

	rect: The hot zone. The area that can be clicked in
	untransformed coordinates.

	uri: Link destinations come in two forms: internal and external.
	Internal links refer to other pages in the same document.
	External links are URLs to other documents.

	next: A pointer to the next link on the same page.
*/
struct FzLink
{
	/** == Constructors. */

	/** Constructor using `fz_new_link_of_size()`. */
	/**
		Create a new link record.
	
		next is set to NULL with the expectation that the caller will
		handle the linked list setup. Internal function.
	
		Different document types will be implemented by deriving from
		fz_link. This macro allocates such derived structures, and
		initialises the base sections.
	*/
	FZ_FUNCTION FzLink(int size, const FzRect& rect, const char *uri);

	/** Constructor using `pdf_new_link()`. */
	FZ_FUNCTION FzLink(const PdfPage& page, const FzRect& rect, const char *uri, const PdfObj& obj);

	/** Construct by calling fz_new_link_of_size() with size=sizeof(fz_link). */
	FZ_FUNCTION FzLink(FzRect& rect, const char *uri);

	/** Copy constructor using `fz_keep_link()`. */
	FZ_FUNCTION FzLink(const FzLink& rhs);

	/** operator= using `fz_keep_link()` and `fz_drop_link()`. */
	FZ_FUNCTION FzLink& operator=(const FzLink& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_set_link_rect()`.  */
	FZ_FUNCTION void fz_set_link_rect(const FzRect& rect) const;

	/** Class-aware wrapper for `::fz_set_link_uri()`.  */
	FZ_FUNCTION void fz_set_link_uri(const char *uri) const;

	/** Used for iteration over linked list of FzLink items starting at fz_link::. */
	FZ_FUNCTION FzLinkIterator begin();

	/** Used for iteration over linked list of FzLink items starting at fz_link::. */
	FZ_FUNCTION FzLinkIterator end();

	/** Constructor using raw copy of pre-existing `::fz_link`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_link* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzLink(::fz_link* internal=NULL);

	/* == Accessors to members of ::fz_link m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION FzLink next();
	FZ_FUNCTION ::fz_rect rect();
	FZ_FUNCTION const char *uri();

	/** Destructor using fz_drop_link(). */
	FZ_FUNCTION ~FzLink();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_link* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	typedef FzLinkIterator iterator;
};

/** Wrapper class for struct `fz_link_dest`. Not copyable or assignable. */
struct FzLinkDest
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzLinkDest();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_new_uri_from_explicit_dest()`.  */
	FZ_FUNCTION char *pdf_new_uri_from_explicit_dest() const;

	/** Constructor using raw copy of pre-existing `::fz_link_dest`. */
	FZ_FUNCTION FzLinkDest(::fz_link_dest* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLinkDest();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_link_dest* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzLinkDest(const FzLinkDest& rhs);
	FzLinkDest& operator=(const FzLinkDest& rhs);
};

/** Wrapper class for struct `fz_location`. */
/**
	Locations within the document are referred to in terms of
	chapter and page, rather than just a page number. For some
	documents (such as epub documents with large numbers of pages
	broken into many chapters) this can make navigation much faster
	as only the required chapter needs to be decoded at a time.
*/
struct FzLocation
{
	/** == Constructors. */

	/** Constructor using `fz_make_location()`. */
	/**
		Simple constructor for fz_locations.
	*/
	FZ_FUNCTION FzLocation(int chapter, int page);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzLocation();

	/** Constructor using raw copy of pre-existing `::fz_location`. */
	FZ_FUNCTION FzLocation(const ::fz_location* internal);

	/** Constructor using raw copy of pre-existing `::fz_location`. */
	FZ_FUNCTION FzLocation(const ::fz_location internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_location* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_location* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLocation();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_location. */
	int chapter;
	int page;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzLocation& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzLocation& rhs);
};

/** Wrapper class for struct `fz_locks_context`. Not copyable or assignable. */
/**
	Locking functions

	MuPDF is kept deliberately free of any knowledge of particular
	threading systems. As such, in order for safe multi-threaded
	operation, we rely on callbacks to client provided functions.

	A client is expected to provide FZ_LOCK_MAX number of mutexes,
	and a function to lock/unlock each of them. These may be
	recursive mutexes, but do not have to be.

	If a client does not intend to use multiple threads, then it
	may pass NULL instead of a lock structure.

	In order to avoid deadlocks, we have one simple rule
	internally as to how we use locks: We can never take lock n
	when we already hold any lock i, where 0 <= i <= n. In order
	to verify this, we have some debugging code, that can be
	enabled by defining FITZ_DEBUG_LOCKING.
*/
struct FzLocksContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzLocksContext();

	/** Constructor using raw copy of pre-existing `::fz_locks_context`. */
	FZ_FUNCTION FzLocksContext(::fz_locks_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzLocksContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_locks_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzLocksContext(const FzLocksContext& rhs);
	FzLocksContext& operator=(const FzLocksContext& rhs);
};

/** Wrapper class for struct `fz_matrix`. */
/**
	fz_matrix is a row-major 3x3 matrix used for representing
	transformations of coordinates throughout MuPDF.

	Since all points reside in a two-dimensional space, one vector
	is always a constant unit vector; hence only some elements may
	vary in a matrix. Below is how the elements map between
	different representations.

	/ a b 0 \
	| c d 0 | normally represented as [ a b c d e f ].
	\ e f 1 /
*/
struct FzMatrix
{
	/** == Constructors. */

	/** Constructor using `fz_make_matrix()`. */
	FZ_FUNCTION FzMatrix(float a, float b, float c, float d, float e, float f);

	/** Constructs identity matrix (like fz_identity). */
	FZ_FUNCTION FzMatrix();

	/** We use default copy constructor and operator=. */

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_concat()`.  */
	/**
		Multiply two matrices.
	
		The order of the two matrices are important since matrix
		multiplication is not commutative.
	
		Returns result.
	*/
	FZ_FUNCTION static FzMatrix fz_concat(const FzMatrix& left, const FzMatrix& right);

	/** Class-aware wrapper for `::fz_scale()`.  */
	/**
		Create a scaling matrix.
	
		The returned matrix is of the form [ sx 0 0 sy 0 0 ].
	
		m: Pointer to the matrix to populate
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m.
	*/
	FZ_FUNCTION static FzMatrix fz_scale(float sx, float sy);

	/** Class-aware wrapper for `::fz_shear()`.  */
	/**
		Create a shearing matrix.
	
		The returned matrix is of the form [ 1 sy sx 1 0 0 ].
	
		m: pointer to place to store returned matrix
	
		sx, sy: Shearing factors. A shearing factor of 0.0 will not
		cause any shearing along the relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION static FzMatrix fz_shear(float sx, float sy);

	/** Class-aware wrapper for `::fz_rotate()`.  */
	/**
		Create a rotation matrix.
	
		The returned matrix is of the form
		[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].
	
		m: Pointer to place to store matrix
	
		degrees: Degrees of counter clockwise rotation. Values less
		than zero and greater than 360 are handled as expected.
	
		Returns m.
	*/
	FZ_FUNCTION static FzMatrix fz_rotate(float degrees);

	/** Class-aware wrapper for `::fz_translate()`.  */
	/**
		Create a translation matrix.
	
		The returned matrix is of the form [ 1 0 0 1 tx ty ].
	
		m: A place to store the created matrix.
	
		tx, ty: Translation distances along the X- and Y-axes. A
		translation of 0 will not cause any translation along the
		relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION static FzMatrix fz_translate(float tx, float ty);

	/** Class-aware wrapper for `::fz_transform_page()`.  */
	/**
		Create transform matrix to draw page
		at a given resolution and rotation. Adjusts the scaling
		factors so that the page covers whole number of
		pixels and adjust the page origin to be at 0,0.
	*/
	FZ_FUNCTION static FzMatrix fz_transform_page(const FzRect& mediabox, float resolution, float rotate);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_concat()`.  */
	/**
		Multiply two matrices.
	
		The order of the two matrices are important since matrix
		multiplication is not commutative.
	
		Returns result.
	*/
	FZ_FUNCTION FzMatrix fz_concat(const FzMatrix& right);

	/** Class-aware wrapper for `::fz_invert_matrix()`.  */
	/**
		Create an inverse matrix.
	
		matrix: Matrix to invert. A degenerate matrix, where the
		determinant is equal to zero, can not be inverted and the
		original matrix is returned instead.
	
		Returns inverse.
	*/
	FZ_FUNCTION FzMatrix fz_invert_matrix();

	/** Class-aware wrapper for `::fz_is_identity()`.  */
	FZ_FUNCTION int fz_is_identity();

	/** Class-aware wrapper for `::fz_is_rectilinear()`.  */
	/**
		Check if a transformation is rectilinear.
	
		Rectilinear means that no shearing is present and that any
		rotations present are a multiple of 90 degrees. Usually this
		is used to make sure that axis-aligned rectangles before the
		transformation are still axis-aligned rectangles afterwards.
	*/
	FZ_FUNCTION int fz_is_rectilinear();

	/** Class-aware wrapper for `::fz_matrix_expansion()`.  */
	/**
		Calculate average scaling factor of matrix.
	*/
	FZ_FUNCTION float fz_matrix_expansion();

	/** Class-aware wrapper for `::fz_matrix_max_expansion()`.  */
	/**
		Find the largest expansion performed by this matrix.
		(i.e. max(abs(m.a),abs(m.b),abs(m.c),abs(m.d))
	*/
	FZ_FUNCTION float fz_matrix_max_expansion();

	/** Class-aware wrapper for `::fz_post_scale()`.  */
	/**
		Scale a matrix by postmultiplication.
	
		m: Pointer to the matrix to scale
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION FzMatrix fz_post_scale(float sx, float sy);

	/** Class-aware wrapper for `::fz_pre_rotate()`.  */
	/**
		Rotate a transformation by premultiplying.
	
		The premultiplied matrix is of the form
		[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].
	
		m: Pointer to matrix to premultiply.
	
		degrees: Degrees of counter clockwise rotation. Values less
		than zero and greater than 360 are handled as expected.
	
		Returns m (updated).
	*/
	FZ_FUNCTION FzMatrix fz_pre_rotate(float degrees);

	/** Class-aware wrapper for `::fz_pre_scale()`.  */
	/**
		Scale a matrix by premultiplication.
	
		m: Pointer to the matrix to scale
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION FzMatrix fz_pre_scale(float sx, float sy);

	/** Class-aware wrapper for `::fz_pre_shear()`.  */
	/**
		Premultiply a matrix with a shearing matrix.
	
		The shearing matrix is of the form [ 1 sy sx 1 0 0 ].
	
		m: pointer to matrix to premultiply
	
		sx, sy: Shearing factors. A shearing factor of 0.0 will not
		cause any shearing along the relevant axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION FzMatrix fz_pre_shear(float sx, float sy);

	/** Class-aware wrapper for `::fz_pre_translate()`.  */
	/**
		Translate a matrix by premultiplication.
	
		m: The matrix to translate
	
		tx, ty: Translation distances along the X- and Y-axes. A
		translation of 0 will not cause any translation along the
		relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION FzMatrix fz_pre_translate(float tx, float ty);

	/** Class-aware wrapper for `::fz_subpixel_adjust()`.  */
	/**
		Perform subpixel quantisation and adjustment on a glyph matrix.
	
		ctm: On entry, the desired 'ideal' transformation for a glyph.
		On exit, adjusted to a (very similar) transformation quantised
		for subpixel caching.
	
		subpix_ctm: Initialised by the routine to the transform that
		should be used to render the glyph.
	
		qe, qf: which subpixel position we quantised to.
	
		Returns: the size of the glyph.
	
		Note: This is currently only exposed for use in our app. It
		should be considered "at risk" of removal from the API.
	*/
	FZ_FUNCTION float fz_subpixel_adjust(FzMatrix& subpix_ctm, unsigned char *qe, unsigned char *qf);

	/** Class-aware wrapper for `::fz_try_invert_matrix()`.  */
	/**
		Attempt to create an inverse matrix.
	
		inv: Place to store inverse matrix.
	
		src: Matrix to invert. A degenerate matrix, where the
		determinant is equal to zero, can not be inverted.
	
		Returns 1 if matrix is degenerate (singular), or 0 otherwise.
	*/
	FZ_FUNCTION int fz_try_invert_matrix(const FzMatrix& src);

	/** Constructor using raw copy of pre-existing `::fz_matrix`. */
	FZ_FUNCTION FzMatrix(const ::fz_matrix* internal);

	/** Constructor using raw copy of pre-existing `::fz_matrix`. */
	FZ_FUNCTION FzMatrix(const ::fz_matrix internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_matrix* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_matrix* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzMatrix();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_matrix. */
	float a;
	float b;
	float c;
	float d;
	float e;
	float f;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzMatrix& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzMatrix& rhs);
};

/** Wrapper class for struct `fz_md5`. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct FzMd5
{
	/** Default constructor calls md5_init(). */
	FZ_FUNCTION FzMd5();

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Class-aware wrapper for `::fz_md5_final()`.  */
	/**
		MD5 finalization. Ends an MD5 message-digest operation, writing
		the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_md5_final(unsigned char digest[16]);

	/** Class-aware wrapper for `::fz_md5_final2()`.  */
	/**
	C++ alternative to fz_md5_final() that returns the digest by value.
	*/
	FZ_FUNCTION std::vector<unsigned char> fz_md5_final2();

	/** Class-aware wrapper for `::fz_md5_init()`.  */
	/**
		MD5 initialization. Begins an MD5 operation, writing a new
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_md5_init();

	/** Class-aware wrapper for `::fz_md5_update()`.  */
	/**
		MD5 block update operation. Continues an MD5 message-digest
		operation, processing another message block, and updating the
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_md5_update(const unsigned char *input, size_t inlen);

	/** Class-aware wrapper for `::fz_md5_update_int64()`.  */
	/**
		MD5 block update operation. Continues an MD5 message-digest
		operation, processing an int64, and updating the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_md5_update_int64(int64_t i);

	/** Constructor using raw copy of pre-existing `::fz_md5`. */
	FZ_FUNCTION FzMd5(const ::fz_md5* internal);

	/* == Accessors to members of ::fz_md5 m_internal. */

	FZ_FUNCTION uint32_t lo();
	FZ_FUNCTION uint32_t hi();
	FZ_FUNCTION uint32_t a();
	FZ_FUNCTION uint32_t b();
	FZ_FUNCTION uint32_t c();
	FZ_FUNCTION uint32_t d();
	FZ_FUNCTION unsigned char * buffer();

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzMd5();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	::fz_md5  m_internal; /** Wrapped data is held by value. */

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzMd5& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzMd5& rhs);
};

/** Wrapper class for struct `fz_outline`. */
/**
	fz_outline is a tree of the outline of a document (also known
	as table of contents).

	title: Title of outline item using UTF-8 encoding. May be NULL
	if the outline item has no text string.

	uri: Destination in the document to be displayed when this
	outline item is activated. May be an internal or external
	link, or NULL if the outline item does not have a destination.

	page: The page number of an internal link, or -1 for external
	links or links with no destination.

	next: The next outline item at the same level as this outline
	item. May be NULL if no more outline items exist at this level.

	down: The outline items immediate children in the hierarchy.
	May be NULL if no children exist.

	is_open: If zero, the outline element is closed in the UI. If
	1, it should be open, showing any child elements.

	flags: Bit 0 set -> Bold, Bit 1 set -> Italic. All other bits
	reserved.

	r, g, b: The RGB components of the color of this entry.
*/
struct FzOutline
{
	/** == Constructors. */

	/** Constructor using `fz_load_outline()`. */
	/**
		Load the hierarchical document outline.
	
		Should be freed by fz_drop_outline.
	*/
	FZ_FUNCTION FzOutline(const FzDocument& doc);

	/** Constructor using `fz_load_outline_from_iterator()`. */
	/**
		Routine to implement the old Structure based API from an iterator.
	*/
	FZ_FUNCTION FzOutline(const FzOutlineIterator& iter);

	/** Constructor using `fz_new_outline()`. */
	/**
		Create a new outline entry with zeroed fields for the caller
		to fill in.
	*/
	FZ_FUNCTION FzOutline();

	/** Copy constructor using `fz_keep_outline()`. */
	FZ_FUNCTION FzOutline(const FzOutline& rhs);

	/** operator= using `fz_keep_outline()` and `fz_drop_outline()`. */
	FZ_FUNCTION FzOutline& operator=(const FzOutline& rhs);

	/** Constructor using raw copy of pre-existing `::fz_outline`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_outline* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzOutline(::fz_outline* internal);

	/* == Accessors to members of ::fz_outline m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION const char *title();
	FZ_FUNCTION const char *uri();
	FZ_FUNCTION ::fz_location page();
	FZ_FUNCTION float x();
	FZ_FUNCTION float y();
	FZ_FUNCTION FzOutline next();
	FZ_FUNCTION FzOutline down();
	FZ_FUNCTION unsigned int is_open();
	FZ_FUNCTION unsigned int flags();
	FZ_FUNCTION unsigned int r();
	FZ_FUNCTION unsigned int g();
	FZ_FUNCTION unsigned int b();

	/** Destructor using fz_drop_outline(). */
	FZ_FUNCTION ~FzOutline();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_outline* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_outline_item`. */
struct FzOutlineItem
{
	FZ_FUNCTION bool valid() const;
	FZ_FUNCTION const std::string& title() const;   /* Will throw if valid() is not true. */
	FZ_FUNCTION const std::string& uri() const;     /* Will throw if valid() is not true. */
	FZ_FUNCTION int is_open() const;                /* Will throw if valid() is not true. */

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzOutlineItem();

	/** Constructor using raw copy of pre-existing `::fz_outline_item`. */
	FZ_FUNCTION FzOutlineItem(const ::fz_outline_item* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzOutlineItem();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */


	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:
	bool        m_valid;
	std::string m_title;
	std::string m_uri;
	int         m_is_open;
};

/** Wrapper class for struct `fz_outline_iterator`. Not copyable or assignable. */
struct FzOutlineIterator
{
	/** == Constructors. */

	/** Constructor using `fz_new_outline_iterator()`. */
	/**
		Get an iterator for the document outline.
	
		Should be freed by fz_drop_outline_iterator.
	*/
	FZ_FUNCTION FzOutlineIterator(const FzDocument& doc);

	/** Constructor using `fz_new_outline_iterator_of_size()`. */
	FZ_FUNCTION FzOutlineIterator(size_t size, const FzDocument& doc);

	/** Constructor using `pdf_new_outline_iterator()`. */
	FZ_FUNCTION FzOutlineIterator(const PdfDocument& doc);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzOutlineIterator();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_load_outline_from_iterator()`.  */
	/**
		Routine to implement the old Structure based API from an iterator.
	*/
	FZ_FUNCTION FzOutline fz_load_outline_from_iterator() const;

	/** Class-aware wrapper for `::fz_outline_iterator_delete()`.  */
	/**
		Delete the current item.
	
		This implicitly moves us to the 'next' item, and the return code is as for fz_outline_iterator_next.
	*/
	FZ_FUNCTION int fz_outline_iterator_delete() const;

	/** Class-aware wrapper for `::fz_outline_iterator_down()`.  */
	FZ_FUNCTION int fz_outline_iterator_down() const;

	/** Class-aware wrapper for `::fz_outline_iterator_item()`.  */
	/**
		Call to get the current outline item.
	
		Can return NULL. The item is only valid until the next call.
	*/
	FZ_FUNCTION FzOutlineItem fz_outline_iterator_item() const;

	/** Class-aware wrapper for `::fz_outline_iterator_next()`.  */
	/**
		Calls to move the iterator position.
	
		A negative return value means we could not move as requested. Otherwise:
		0 = the final position has a valid item.
		1 = not a valid item, but we can insert an item here.
	*/
	FZ_FUNCTION int fz_outline_iterator_next() const;

	/** Class-aware wrapper for `::fz_outline_iterator_prev()`.  */
	FZ_FUNCTION int fz_outline_iterator_prev() const;

	/** Class-aware wrapper for `::fz_outline_iterator_up()`.  */
	FZ_FUNCTION int fz_outline_iterator_up() const;

	/** Custom wrapper for fz_outline_iterator_insert(). */
	FZ_FUNCTION int fz_outline_iterator_insert(FzOutlineItem& item);

	/** Custom wrapper for fz_outline_iterator_update(). */
	FZ_FUNCTION void fz_outline_iterator_update(FzOutlineItem& item);

	/** Constructor using raw copy of pre-existing `::fz_outline_iterator`. */
	FZ_FUNCTION FzOutlineIterator(::fz_outline_iterator* internal);

	/** Destructor using fz_drop_outline_iterator(). */
	FZ_FUNCTION ~FzOutlineIterator();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_outline_iterator* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzOutlineIterator(const FzOutlineIterator& rhs);
	FzOutlineIterator& operator=(const FzOutlineIterator& rhs);
};

/** Wrapper class for struct `fz_output`. Not copyable or assignable. */
struct FzOutput
{
	enum Fixed
	{
		Fixed_STDOUT=1,
		Fixed_STDERR=2,
	};
	enum Filter
	{
		Filter_HEX,
		Filter_85,
		Filter_RLE,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_arc4_output()`. */
	FZ_FUNCTION FzOutput(const FzOutput& chain, unsigned char *key, size_t keylen);

	/** Constructor using `fz_new_deflate_output()`. */
	FZ_FUNCTION FzOutput(const FzOutput& chain, int effort, int raw);

	/** Constructor using `fz_new_log_for_module()`. */
	/**
		Internal function to actually do the opening of the logfile.
	
		Caller should close/drop the output when finished with it.
	*/
	FZ_FUNCTION FzOutput(const char *module);

	/** Constructor using `fz_new_output()`. */
	/**
		Create a new output object with the given
		internal state and function pointers.
	
		state: Internal state (opaque to everything but implementation).
	
		write: Function to output a given buffer.
	
		close: Cleanup function to destroy state when output closed.
		May permissibly be null.
	*/
	FZ_FUNCTION FzOutput(int bufsiz, void *state, ::fz_output_write_fn *write, ::fz_output_close_fn *close, ::fz_output_drop_fn *drop);

	/** Constructor using `fz_new_output_with_buffer()`. */
	/**
		Open an output stream that appends
		to a buffer.
	
		buf: The buffer to append to.
	*/
	FZ_FUNCTION FzOutput(const FzBuffer& buf);

	/** Constructor using `fz_new_output_with_file_ptr()`. */
	/**
		Open an output stream that writes to a
		given FILE *.
	
		file: The file pointers to write to. NULL is interpreted as effectively
		meaning /dev/null or similar.
	*/
	FZ_FUNCTION FzOutput(FILE *file);

	/** Constructor using `fz_new_output_with_path()`. */
	/**
		Open an output stream that writes to a
		given path.
	
		filename: The filename to write to (specified in UTF-8).
	
		append: non-zero if we should append to the file, rather than
		overwriting it.
	*/
	FZ_FUNCTION FzOutput(const char *filename, int append);

	/** Uses fz_stdout() or fz_stderr(). */
	FZ_FUNCTION FzOutput(Fixed out);

	/** Calls one of: fz_new_asciihex_output(), fz_new_ascii85_output(), fz_new_rle_output(). */
	FZ_FUNCTION FzOutput(const FzOutput& chain, Filter filter);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_close_output()`.  */
	/**
		Flush pending output and close an output stream.
	*/
	FZ_FUNCTION void fz_close_output() const;

	/** Class-aware wrapper for `::fz_debug_store()`.  */
	/**
		Output debugging information for the current state of the store
		to the given output channel.
	*/
	FZ_FUNCTION void fz_debug_store() const;

	/** Class-aware wrapper for `::fz_dump_glyph_cache_stats()`.  */
	/**
		Dump debug statistics for the glyph cache.
	*/
	FZ_FUNCTION void fz_dump_glyph_cache_stats() const;

	/** Class-aware wrapper for `::fz_flush_output()`.  */
	/**
		Flush unwritten data.
	*/
	FZ_FUNCTION void fz_flush_output() const;

	/** Class-aware wrapper for `::fz_int2_heap_dump()`.  */
	FZ_FUNCTION void fz_int2_heap_dump(const FzInt2Heap& heap) const;

	/** Class-aware wrapper for `::fz_int_heap_dump()`.  */
	FZ_FUNCTION void fz_int_heap_dump(const FzIntHeap& heap) const;

	/** Class-aware wrapper for `::fz_intptr_heap_dump()`.  */
	FZ_FUNCTION void fz_intptr_heap_dump(const FzIntptrHeap& heap) const;

	/** Class-aware wrapper for `::fz_new_svg_device()`.  */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		Equivalent to fz_new_svg_device_with_id passing id = NULL.
	*/
	FZ_FUNCTION FzDevice fz_new_svg_device(float page_width, float page_height, int text_format, int reuse_images) const;

	/** Class-aware wrapper for `::fz_new_svg_device_with_id()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
	 */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		output: The output stream to send the constructed SVG page to.
	
		page_width, page_height: The page dimensions to use (in points).
	
		text_format: How to emit text. One of the following values:
			FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
			layout errors and mismatching fonts.
			FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
			visual appearance.
	
		reuse_images: Share image resources using <symbol> definitions.
	
		id: ID parameter to keep generated IDs unique across SVG files.
	*/
	FZ_FUNCTION FzDevice fz_new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images, int *id) const;

	/** Class-aware wrapper for `::fz_new_trace_device()`.  */
	/**
		Create a device to print a debug trace of all device calls.
	*/
	FZ_FUNCTION FzDevice fz_new_trace_device() const;

	/** Class-aware wrapper for `::fz_new_xmltext_device()`.  */
	/**
		Create a device to output raw information.
	*/
	FZ_FUNCTION FzDevice fz_new_xmltext_device() const;

	/** Class-aware wrapper for `::fz_output_supports_stream()`.  */
	/**
		Query whether a given fz_output supports fz_stream_from_output.
	*/
	FZ_FUNCTION int fz_output_supports_stream() const;

	/** Class-aware wrapper for `::fz_output_xml()`.  */
	/**
		Pretty-print an XML tree to given output.
	*/
	FZ_FUNCTION void fz_output_xml(const FzXml& item, int level) const;

	/** Class-aware wrapper for `::fz_print_stext_header_as_html()`.  */
	FZ_FUNCTION void fz_print_stext_header_as_html() const;

	/** Class-aware wrapper for `::fz_print_stext_header_as_xhtml()`.  */
	FZ_FUNCTION void fz_print_stext_header_as_xhtml() const;

	/** Class-aware wrapper for `::fz_print_stext_page_as_html()`.  */
	/**
		Output structured text to a file in HTML (visual) format.
	*/
	FZ_FUNCTION void fz_print_stext_page_as_html(const FzStextPage& page, int id) const;

	/** Class-aware wrapper for `::fz_print_stext_page_as_json()`.  */
	/**
		Output structured text to a file in JSON format.
	*/
	FZ_FUNCTION void fz_print_stext_page_as_json(const FzStextPage& page, float scale) const;

	/** Class-aware wrapper for `::fz_print_stext_page_as_text()`.  */
	/**
		Output structured text to a file in plain-text UTF-8 format.
	*/
	FZ_FUNCTION void fz_print_stext_page_as_text(const FzStextPage& page) const;

	/** Class-aware wrapper for `::fz_print_stext_page_as_xhtml()`.  */
	/**
		Output structured text to a file in XHTML (semantic) format.
	*/
	FZ_FUNCTION void fz_print_stext_page_as_xhtml(const FzStextPage& page, int id) const;

	/** Class-aware wrapper for `::fz_print_stext_page_as_xml()`.  */
	/**
		Output structured text to a file in XML format.
	*/
	FZ_FUNCTION void fz_print_stext_page_as_xml(const FzStextPage& page, int id) const;

	/** Class-aware wrapper for `::fz_print_stext_trailer_as_html()`.  */
	FZ_FUNCTION void fz_print_stext_trailer_as_html() const;

	/** Class-aware wrapper for `::fz_print_stext_trailer_as_xhtml()`.  */
	FZ_FUNCTION void fz_print_stext_trailer_as_xhtml() const;

	/** Class-aware wrapper for `::fz_reset_output()`.  */
	/**
		Reset a closed output stream. Returns state to
		(broadly) that which it was in when opened. Not
		all outputs can be reset, so this may throw an
		exception.
	*/
	FZ_FUNCTION void fz_reset_output() const;

	/** Class-aware wrapper for `::fz_seek_output()`.  */
	/**
		Seek to the specified file position.
		See fseek for arguments.
	
		Throw an error on unseekable outputs.
	*/
	FZ_FUNCTION void fz_seek_output(int64_t off, int whence) const;

	/** Class-aware wrapper for `::fz_set_stddbg()`.  */
	/**
		Set the output stream to be used for fz_stddbg. Set to NULL to
		reset to default (stderr).
	*/
	FZ_FUNCTION void fz_set_stddbg() const;

	/** Class-aware wrapper for `::fz_stream_from_output()`.  */
	/**
		Obtain the fz_output in the form of a fz_stream.
	
		This allows data to be read back from some forms of fz_output
		object. When finished reading, the fz_stream should be released
		by calling fz_drop_stream. Until the fz_stream is dropped, no
		further operations should be performed on the fz_output object.
	*/
	FZ_FUNCTION FzStream fz_stream_from_output() const;

	/** Class-aware wrapper for `::fz_tell_output()`.  */
	/**
		Return the current file position.
	
		Throw an error on untellable outputs.
	*/
	FZ_FUNCTION int64_t fz_tell_output() const;

	/** Class-aware wrapper for `::fz_truncate_output()`.  */
	/**
		Truncate the output at the current position.
	
		This allows output streams which have seeked back from the end
		of their storage to be truncated at the current point.
	*/
	FZ_FUNCTION void fz_truncate_output() const;

	/** Class-aware wrapper for `::fz_write_base64()`.  */
	/**
		Write a base64 encoded data block, optionally with periodic
		newlines.
	*/
	FZ_FUNCTION void fz_write_base64(const unsigned char *data, size_t size, int newline) const;

	/** Class-aware wrapper for `::fz_write_base64_buffer()`.  */
	/**
		Write a base64 encoded fz_buffer, optionally with periodic
		newlines.
	*/
	FZ_FUNCTION void fz_write_base64_buffer(const FzBuffer& data, int newline) const;

	/** Class-aware wrapper for `::fz_write_bitmap_as_pbm()`.  */
	/**
		Write a bitmap as a pbm.
	*/
	FZ_FUNCTION void fz_write_bitmap_as_pbm(const FzBitmap& bitmap) const;

	/** Class-aware wrapper for `::fz_write_bitmap_as_pcl()`.  */
	/**
		Write a bitmap as mono PCL.
	*/
	FZ_FUNCTION void fz_write_bitmap_as_pcl(const FzBitmap& bitmap, const FzPclOptions& pcl) const;

	/** Class-aware wrapper for `::fz_write_bitmap_as_pkm()`.  */
	/**
		Write a CMYK bitmap as a pkm.
	*/
	FZ_FUNCTION void fz_write_bitmap_as_pkm(const FzBitmap& bitmap) const;

	/** Class-aware wrapper for `::fz_write_bitmap_as_pwg()`.  */
	/**
		Write a bitmap as a PWG.
	*/
	FZ_FUNCTION void fz_write_bitmap_as_pwg(const FzBitmap& bitmap, FzPwgOptions& pwg) const;

	/** Class-aware wrapper for `::fz_write_bitmap_as_pwg_page()`.  */
	/**
		Write a bitmap as a PWG page.
	
		Caller should provide a file header by calling
		fz_write_pwg_file_header, but can then write several pages to
		the same file.
	*/
	FZ_FUNCTION void fz_write_bitmap_as_pwg_page(const FzBitmap& bitmap, FzPwgOptions& pwg) const;

	/** Class-aware wrapper for `::fz_write_bits()`.  */
	/**
		Write num_bits of data to the end of the output stream, assumed to be packed
		most significant bits first.
	*/
	FZ_FUNCTION void fz_write_bits(unsigned int data, int num_bits) const;

	/** Class-aware wrapper for `::fz_write_bits_sync()`.  */
	/**
		Sync to byte boundary after writing bits.
	*/
	FZ_FUNCTION void fz_write_bits_sync() const;

	/** Class-aware wrapper for `::fz_write_buffer()`.  */
	FZ_FUNCTION void fz_write_buffer(const FzBuffer& data) const;

	/** Class-aware wrapper for `::fz_write_byte()`.  */
	FZ_FUNCTION void fz_write_byte(unsigned char x) const;

	/** Class-aware wrapper for `::fz_write_char()`.  */
	FZ_FUNCTION void fz_write_char(char x) const;

	/** Class-aware wrapper for `::fz_write_data()`.  */
	/**
		Write data to output.
	
		data: Pointer to data to write.
		size: Size of data to write in bytes.
	*/
	FZ_FUNCTION void fz_write_data(const void *data, size_t size) const;

	/** Class-aware wrapper for `::fz_write_float_be()`.  */
	FZ_FUNCTION void fz_write_float_be(float f) const;

	/** Class-aware wrapper for `::fz_write_float_le()`.  */
	FZ_FUNCTION void fz_write_float_le(float f) const;

	/** Class-aware wrapper for `::fz_write_image_as_data_uri()`.  */
	/**
		Write image as a data URI (for HTML and SVG output).
	*/
	FZ_FUNCTION void fz_write_image_as_data_uri(const FzImage& image) const;

	/** Class-aware wrapper for `::fz_write_int16_be()`.  */
	FZ_FUNCTION void fz_write_int16_be(int x) const;

	/** Class-aware wrapper for `::fz_write_int16_le()`.  */
	FZ_FUNCTION void fz_write_int16_le(int x) const;

	/** Class-aware wrapper for `::fz_write_int32_be()`.  */
	/**
		Write different sized data to an output stream.
	*/
	FZ_FUNCTION void fz_write_int32_be(int x) const;

	/** Class-aware wrapper for `::fz_write_int32_le()`.  */
	FZ_FUNCTION void fz_write_int32_le(int x) const;

	/** Class-aware wrapper for `::fz_write_json()`.  */
	FZ_FUNCTION void fz_write_json(const FzJson& value) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_data_uri()`.  */
	FZ_FUNCTION void fz_write_pixmap_as_data_uri(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_jpeg()`.  */
	/**
		Write a pixmap as a JPEG.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_jpeg(const FzPixmap& pix, int quality, int invert_cmyk) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_jpx()`.  */
	/**
		Pixmap data as JP2K with no subsampling.
	
		quality = 100 = lossless
		otherwise for a factor of x compression use 100-x. (so 80 is 1:20 compression)
	*/
	FZ_FUNCTION void fz_write_pixmap_as_jpx(const FzPixmap& pix, int quality) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pam()`.  */
	/**
		Write a pixmap as a pnm (greyscale, rgb or cmyk, with or without
		alpha).
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pam(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pcl()`.  */
	/**
		Write an (RGB) pixmap as color PCL.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pcl(const FzPixmap& pixmap, const FzPclOptions& pcl) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pclm()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as pclm.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pclm(const FzPixmap& pixmap, const FzPclmOptions& options) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pdfocr()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as pdfocr.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pdfocr(const FzPixmap& pixmap, FzPdfocrOptions& options) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_png()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as a png.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_png(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pnm()`.  */
	/**
		Write a pixmap as a pnm (greyscale or rgb, no alpha).
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pnm(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_ps()`.  */
	/**
		Write a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_ps(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_psd()`.  */
	/**
		Write a pixmap as a PSD file.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_psd(const FzPixmap& pixmap) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pwg()`.  */
	/**
		Write a pixmap as a PWG.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pwg(const FzPixmap& pixmap, FzPwgOptions& pwg) const;

	/** Class-aware wrapper for `::fz_write_pixmap_as_pwg_page()`.  */
	/**
		Write a pixmap as a PWG page.
	
		Caller should provide a file header by calling
		fz_write_pwg_file_header, but can then write several pages to
		the same file.
	*/
	FZ_FUNCTION void fz_write_pixmap_as_pwg_page(const FzPixmap& pixmap, FzPwgOptions& pwg) const;

	/** Class-aware wrapper for `::fz_write_ps_file_header()`.  */
	/**
		Write the file level header for ps band writer output.
	*/
	FZ_FUNCTION void fz_write_ps_file_header() const;

	/** Class-aware wrapper for `::fz_write_ps_file_trailer()`.  */
	/**
		Write the file level trailer for ps band writer output.
	*/
	FZ_FUNCTION void fz_write_ps_file_trailer(int pages) const;

	/** Class-aware wrapper for `::fz_write_pwg_file_header()`.  */
	/**
		Output the file header to a pwg stream, ready for pages to follow it.
	*/
	FZ_FUNCTION void fz_write_pwg_file_header() const;

	/** Class-aware wrapper for `::fz_write_rune()`.  */
	/**
		Write a UTF-8 encoded unicode character.
	*/
	FZ_FUNCTION void fz_write_rune(int rune) const;

	/** Class-aware wrapper for `::fz_write_stream()`.  */
	/**
		Copy the stream contents to the output.
	*/
	FZ_FUNCTION void fz_write_stream(const FzStream& in) const;

	/** Class-aware wrapper for `::fz_write_string()`.  */
	/**
		Write a string. Does not write zero terminator.
	*/
	FZ_FUNCTION void fz_write_string(const char *s) const;

	/** Class-aware wrapper for `::fz_write_uint16_be()`.  */
	FZ_FUNCTION void fz_write_uint16_be(unsigned int x) const;

	/** Class-aware wrapper for `::fz_write_uint16_le()`.  */
	FZ_FUNCTION void fz_write_uint16_le(unsigned int x) const;

	/** Class-aware wrapper for `::fz_write_uint32_be()`.  */
	FZ_FUNCTION void fz_write_uint32_be(unsigned int x) const;

	/** Class-aware wrapper for `::fz_write_uint32_le()`.  */
	FZ_FUNCTION void fz_write_uint32_le(unsigned int x) const;

	/** Class-aware wrapper for `::fz_write_vprintf()`.  */
	/**
		va_list version of fz_write_printf.
	*/
	FZ_FUNCTION void fz_write_vprintf(const char *fmt, va_list ap) const;

	/** Class-aware wrapper for `::pdf_new_output_processor()`.  */
	FZ_FUNCTION PdfProcessor pdf_new_output_processor(int ahxencode, int newlines) const;

	/** Class-aware wrapper for `::pdf_print_crypt()`.  */
	FZ_FUNCTION void pdf_print_crypt(const PdfCrypt& crypt) const;

	/** Class-aware wrapper for `::pdf_print_encrypted_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_print_encrypted_obj(::pdf_obj *obj, int tight, int ascii, ::pdf_crypt *crypt, int num, int gen)` => int sep
	 */
	FZ_FUNCTION void pdf_print_encrypted_obj(const PdfObj& obj, int tight, int ascii, const PdfCrypt& crypt, int num, int gen, int *sep) const;

	/** Class-aware wrapper for `::pdf_print_font()`.  */
	FZ_FUNCTION void pdf_print_font(const PdfFontDesc& fontdesc) const;

	/** Class-aware wrapper for `::pdf_print_obj()`.  */
	FZ_FUNCTION void pdf_print_obj(const PdfObj& obj, int tight, int ascii) const;

	/** Class-aware wrapper for `::pdf_write_digest()`.  */
	FZ_FUNCTION void pdf_write_digest(const PdfObj& byte_range, const PdfObj& field, size_t digest_offset, size_t digest_length, const PdfPkcs7Signer& signer) const;

	/** Constructor using raw copy of pre-existing `::fz_output`. */
	FZ_FUNCTION FzOutput(::fz_output* internal=NULL);

	/** Destructor using fz_drop_output(). */
	FZ_FUNCTION ~FzOutput();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_output* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzOutput(const FzOutput& rhs);
	FzOutput& operator=(const FzOutput& rhs);
};

/** Wrapper class for struct fz_output with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct FzOutput2 : FzOutput
{

	/** == Constructor. */
	FZ_FUNCTION FzOutput2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~FzOutput2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_write( bool use=true);
	FZ_FUNCTION void use_virtual_seek( bool use=true);
	FZ_FUNCTION void use_virtual_tell( bool use=true);
	FZ_FUNCTION void use_virtual_close( bool use=true);
	FZ_FUNCTION void use_virtual_drop( bool use=true);
	FZ_FUNCTION void use_virtual_reset( bool use=true);
	FZ_FUNCTION void use_virtual_as_stream( bool use=true);
	FZ_FUNCTION void use_virtual_truncate( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void write(::fz_context *arg_0, const void *arg_2, unsigned long long arg_3);
	FZ_FUNCTION virtual void seek(::fz_context *arg_0, long long arg_2, int arg_3);
	FZ_FUNCTION virtual long long tell(::fz_context *arg_0);
	FZ_FUNCTION virtual void close(::fz_context *arg_0);
	FZ_FUNCTION virtual void drop(::fz_context *arg_0);
	FZ_FUNCTION virtual void reset(::fz_context *arg_0);
	FZ_FUNCTION virtual ::fz_stream * as_stream(::fz_context *arg_0);
	FZ_FUNCTION virtual void truncate(::fz_context *arg_0);
};

/** Wrapper class for struct `fz_overprint`. Not copyable or assignable. */
/**
	Pixmaps represent a set of pixels for a 2 dimensional region of
	a plane. Each pixel has n components per pixel. The components
	are in the order process-components, spot-colors, alpha, where
	there can be 0 of any of those types. The data is in
	premultiplied alpha when rendering, but non-premultiplied for
	colorspace conversions and rescaling.
*/
struct FzOverprint
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzOverprint();

	/** Constructor using raw copy of pre-existing `::fz_overprint`. */
	FZ_FUNCTION FzOverprint(::fz_overprint* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzOverprint();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_overprint* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzOverprint(const FzOverprint& rhs);
	FzOverprint& operator=(const FzOverprint& rhs);
};

/** Wrapper class for struct `fz_page`. */
struct FzPage
{
	/** == Constructors. */

	/** Constructor using `fz_load_chapter_page()`. */
	/**
		Load a page.
	
		After fz_load_page is it possible to retrieve the size of the
		page using fz_bound_page, or to render the page using
		fz_run_page_*. Free the page by calling fz_drop_page.
	
		chapter: chapter number, 0 is the first chapter of the document.
		number: page number, 0 is the first page of the chapter.
	*/
	FZ_FUNCTION FzPage(const FzDocument& doc, int chapter, int page);

	/** Constructor using `fz_load_page()`. */
	/**
		Load a given page number from a document. This may be much less
		efficient than loading by location (chapter+page) for some
		document types.
	*/
	FZ_FUNCTION FzPage(const FzDocument& doc, int number);

	/** Constructor using `fz_new_page_of_size()`. */
	/**
		Different document types will be implemented by deriving from
		fz_page. This macro allocates such derived structures, and
		initialises the base sections.
	*/
	FZ_FUNCTION FzPage(int size, const FzDocument& doc);

	/** Return FzPage for pdfpage.m_internal.super. */
	FZ_FUNCTION FzPage(PdfPage& pdfpage);

	/** Copy constructor using `fz_keep_page()`. */
	FZ_FUNCTION FzPage(const FzPage& rhs);

	/** operator= using `fz_keep_page()` and `fz_drop_page()`. */
	FZ_FUNCTION FzPage& operator=(const FzPage& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPage();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bound_page()`.  */
	/**
		Determine the size of a page at 72 dpi.
	*/
	FZ_FUNCTION FzRect fz_bound_page() const;

	/** Class-aware wrapper for `::fz_bound_page_box()`.  */
	FZ_FUNCTION FzRect fz_bound_page_box(::fz_box_type box) const;

	/** Class-aware wrapper for `::fz_create_link()`.  */
	/**
		Create a new link on a page.
	*/
	FZ_FUNCTION FzLink fz_create_link(const FzRect& bbox, const char *uri) const;

	/** Class-aware wrapper for `::fz_delete_link()`.  */
	/**
		Delete an existing link on a page.
	*/
	FZ_FUNCTION void fz_delete_link(const FzLink& link) const;

	/** Class-aware wrapper for `::fz_load_links()`.  */
	/**
		Load the list of links for a page.
	
		Returns a linked list of all the links on the page, each with
		its clickable region and link destination. Each link is
		reference counted so drop and free the list of links by
		calling fz_drop_link on the pointer return from fz_load_links.
	
		page: Page obtained from fz_load_page.
	*/
	FZ_FUNCTION FzLink fz_load_links() const;

	/** Class-aware wrapper for `::fz_new_buffer_from_page()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_page(FzStextOptions& options) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_page_with_format()`.  */
	/**
		Returns an fz_buffer containing a page after conversion to specified format.
	
		page: The page to convert.
		format, options: Passed to fz_new_document_writer_with_output() internally.
		transform, cookie: Passed to fz_run_page() internally.
	*/
	FZ_FUNCTION FzBuffer fz_new_buffer_from_page_with_format(const char *format, const char *options, const FzMatrix& transform, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_new_display_list_from_page()`.  */
	/**
		Create a display list.
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION FzDisplayList fz_new_display_list_from_page() const;

	/** Class-aware wrapper for `::fz_new_display_list_from_page_contents()`.  */
	/**
		Create a display list from page contents (no annotations).
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION FzDisplayList fz_new_display_list_from_page_contents() const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page(const FzMatrix& ctm, const FzColorspace& cs, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_contents()`.  */
	/**
		Render the page contents without annotations.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page_contents(const FzMatrix& ctm, const FzColorspace& cs, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_contents_with_separations()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page_contents_with_separations(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_with_separations()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_page_with_separations(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::fz_page_label()`.  */
	/**
		Get page label for a given page.
	*/
	FZ_FUNCTION const char *fz_page_label(char *buf, int size) const;

	/** Class-aware wrapper for `::fz_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_page_presentation(::fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
	/**
		Get the presentation details for a given page.
	
		transition: A pointer to a transition struct to fill out.
	
		duration: A pointer to a place to set the page duration in
		seconds. Will be set to 0 if no transition is specified for the
		page.
	
		Returns: a pointer to the transition structure, or NULL if there
		is no transition specified for the page.
	*/
	FZ_FUNCTION FzTransition fz_page_presentation(FzTransition& transition, float *duration) const;

	/** Class-aware wrapper for `::fz_page_separations()`.  */
	/**
		Get the separations details for a page.
		This will be NULL, unless the format specifically supports
		separations (such as PDF files). May be NULL even
		so, if there are no separations on a page.
	
		Returns a reference that must be dropped.
	*/
	FZ_FUNCTION FzSeparations fz_page_separations() const;

	/** Class-aware wrapper for `::fz_page_uses_overprint()`.  */
	/**
		Query if a given page requires overprint.
	*/
	FZ_FUNCTION int fz_page_uses_overprint() const;

	/** Class-aware wrapper for `::fz_run_page()`.  */
	/**
		Run a page through a device.
	
		page: Page obtained from fz_load_page.
	
		dev: Device obtained from fz_new_*_device.
	
		transform: Transform to apply to page. May include for example
		scaling and rotation, see fz_scale, fz_rotate and fz_concat.
		Set to fz_identity if no transformation is desired.
	
		cookie: Communication mechanism between caller and library
		rendering the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing rendering of a page. Cookie also
		communicates progress information back to the caller. The
		fields inside cookie are continually updated while the page is
		rendering.
	*/
	FZ_FUNCTION void fz_run_page(const FzDevice& dev, const FzMatrix& transform, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_run_page_annots()`.  */
	/**
		Run the annotations on a page through a device.
	*/
	FZ_FUNCTION void fz_run_page_annots(const FzDevice& dev, const FzMatrix& transform, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_run_page_contents()`.  */
	/**
		Run a page through a device. Just the main
		page content, without the annotations, if any.
	
		page: Page obtained from fz_load_page.
	
		dev: Device obtained from fz_new_*_device.
	
		transform: Transform to apply to page. May include for example
		scaling and rotation, see fz_scale, fz_rotate and fz_concat.
		Set to fz_identity if no transformation is desired.
	
		cookie: Communication mechanism between caller and library
		rendering the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing rendering of a page. Cookie also
		communicates progress information back to the caller. The
		fields inside cookie are continually updated while the page is
		rendering.
	*/
	FZ_FUNCTION void fz_run_page_contents(const FzDevice& dev, const FzMatrix& transform, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_run_page_widgets()`.  */
	/**
		Run the widgets on a page through a device.
	*/
	FZ_FUNCTION void fz_run_page_widgets(const FzDevice& dev, const FzMatrix& transform, FzCookie& cookie) const;

	/** Class-aware wrapper for `::fz_search_page()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_search_page(const char *needle, ::fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	/**
		Search for the 'needle' text on the page.
		Record the hits in the hit_bbox array and return the number of
		hits. Will stop looking once it has filled hit_max rectangles.
	*/
	FZ_FUNCTION int fz_search_page(const char *needle, int *hit_mark, FzQuad& hit_bbox, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_page_cb()`.  */
	/**
		Search for the 'needle' text on the page.
	*/
	FZ_FUNCTION int fz_search_page_cb(const char *needle, ::fz_search_callback_fn *cb, void *opaque) const;

	/** Class-aware wrapper for `::pdf_page_from_fz_page()`.  */
	FZ_FUNCTION PdfPage pdf_page_from_fz_page() const;

	/** Returns wrapper for .doc member. */
	FZ_FUNCTION FzDocument doc();

	/** Constructor using raw copy of pre-existing `::fz_page`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_page* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzPage(::fz_page* internal);

	/** Destructor using fz_drop_page(). */
	FZ_FUNCTION ~FzPage();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_page* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_path`. */
/**
 * Vector path buffer.
 * It can be stroked and dashed, or be filled.
 * It has a fill rule (nonzero or even_odd).
 *
 * When rendering, they are flattened, stroked and dashed straight
 * into the Global Edge List.
 */
struct FzPath
{
	/** == Constructors. */

	/** Constructor using `fz_new_path()`. */
	/**
		Create a new (empty) path structure.
	*/
	FZ_FUNCTION FzPath();

	/** Copy constructor using `fz_keep_path()`. */
	FZ_FUNCTION FzPath(const FzPath& rhs);

	/** operator= using `fz_keep_path()` and `fz_drop_path()`. */
	FZ_FUNCTION FzPath& operator=(const FzPath& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bound_path()`.  */
	/**
		Return a bounding rectangle for a path.
	
		path: The path to bound.
	
		stroke: If NULL, the bounding rectangle given is for
		the filled path. If non-NULL the bounding rectangle
		given is for the path stroked with the given attributes.
	
		ctm: The matrix to apply to the path during stroking.
	
		r: Pointer to a fz_rect which will be used to hold
		the result.
	
		Returns r, updated to contain the bounding rectangle.
	*/
	FZ_FUNCTION FzRect fz_bound_path(const FzStrokeState& stroke, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_clone_path()`.  */
	/**
		Clone the data for a path.
	
		This is used in preference to fz_keep_path when a whole
		new copy of a path is required, rather than just a shared
		pointer. This probably indicates that the path is about to
		be modified.
	
		path: path to clone.
	
		Throws exceptions on failure to allocate.
	*/
	FZ_FUNCTION FzPath fz_clone_path() const;

	/** Class-aware wrapper for `::fz_closepath()`.  */
	/**
		Close the current subpath.
	
		path: The path to modify.
	
		Throws exceptions on failure to allocate, attempting to modify
		a packed path, and illegal path closes (i.e. closing a non open
		path).
	*/
	FZ_FUNCTION void fz_closepath() const;

	/** Class-aware wrapper for `::fz_currentpoint()`.  */
	/**
		Return the current point that a path has
		reached or (0,0) if empty.
	
		path: path to return the current point of.
	*/
	FZ_FUNCTION FzPoint fz_currentpoint() const;

	/** Class-aware wrapper for `::fz_curveto()`.  */
	/**
		Append a 'curveto' command to an open path. (For a
		cubic bezier).
	
		path: The path to modify.
	
		x0, y0: The coordinates of the first control point for the
		curve.
	
		x1, y1: The coordinates of the second control point for the
		curve.
	
		x2, y2: The end coordinates for the curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_curveto(float x0, float y0, float x1, float y1, float x2, float y2) const;

	/** Class-aware wrapper for `::fz_curvetov()`.  */
	/**
		Append a 'curvetov' command to an open path. (For a
		cubic bezier with the first control coordinate equal to
		the start point).
	
		path: The path to modify.
	
		x1, y1: The coordinates of the second control point for the
		curve.
	
		x2, y2: The end coordinates for the curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_curvetov(float x1, float y1, float x2, float y2) const;

	/** Class-aware wrapper for `::fz_curvetoy()`.  */
	/**
		Append a 'curvetoy' command to an open path. (For a
		cubic bezier with the second control coordinate equal to
		the end point).
	
		path: The path to modify.
	
		x0, y0: The coordinates of the first control point for the
		curve.
	
		x2, y2: The end coordinates for the curve (and the second
		control coordinate).
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_curvetoy(float x0, float y0, float x2, float y2) const;

	/** Class-aware wrapper for `::fz_lineto()`.  */
	/**
		Append a 'lineto' command to an open path.
	
		path: The path to modify.
	
		x, y: The coordinate to line to.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_lineto(float x, float y) const;

	/** Class-aware wrapper for `::fz_moveto()`.  */
	/**
		Append a 'moveto' command to a path.
		This 'opens' a path.
	
		path: The path to modify.
	
		x, y: The coordinate to move to.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_moveto(float x, float y) const;

	/** Class-aware wrapper for `::fz_packed_path_size()`.  */
	/**
		Return the number of bytes required to pack a path.
	*/
	FZ_FUNCTION int fz_packed_path_size() const;

	/** Class-aware wrapper for `::fz_path_is_rect()`.  */
	/**
		Check whether a given path, under the given transform
		is an axis-aligned rectangle.
	
		We accept zero width or height rectangles, so
		"move 100, 100; line 200, 100" would count as
		a rectangle too.
	*/
	FZ_FUNCTION int fz_path_is_rect(const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_path_is_rect_with_bounds()`.  */
	/**
		Check whether a given path, under the given transform
		is an axis-aligned rectangle.
	
		We accept zero width or height rectangles, so
		"move 100, 100; line 200, 100" would count as
		a rectangle too.
	
		bounds = NULL, or place to return the rectangle
		bounds if the path is a rectangle.
	*/
	FZ_FUNCTION int fz_path_is_rect_with_bounds(const FzMatrix& ctm, FzRect& bounds) const;

	/** Class-aware wrapper for `::fz_quadto()`.  */
	/**
		Append a 'quadto' command to an open path. (For a
		quadratic bezier).
	
		path: The path to modify.
	
		x0, y0: The control coordinates for the quadratic curve.
	
		x1, y1: The end coordinates for the quadratic curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_quadto(float x0, float y0, float x1, float y1) const;

	/** Class-aware wrapper for `::fz_rectto()`.  */
	/**
		Append a 'rectto' command to an open path.
	
		The rectangle is equivalent to:
			moveto x0 y0
			lineto x1 y0
			lineto x1 y1
			lineto x0 y1
			closepath
	
		path: The path to modify.
	
		x0, y0: First corner of the rectangle.
	
		x1, y1: Second corner of the rectangle.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void fz_rectto(float x0, float y0, float x1, float y1) const;

	/** Class-aware wrapper for `::fz_transform_path()`.  */
	/**
		Transform a path by a given
		matrix.
	
		path: The path to modify (must not be a packed path).
	
		transform: The transform to apply.
	
		Throws exceptions if the path is packed, or on failure
		to allocate.
	*/
	FZ_FUNCTION void fz_transform_path(const FzMatrix& transform) const;

	/** Class-aware wrapper for `::fz_trim_path()`.  */
	/**
		Minimise the internal storage used by a path.
	
		As paths are constructed, the internal buffers
		grow. To avoid repeated reallocations they
		grow with some spare space. Once a path has
		been fully constructed, this call allows the
		excess space to be trimmed.
	*/
	FZ_FUNCTION void fz_trim_path() const;

	/** Class-aware wrapper for `::fz_walk_path()`.  */
	/**
		Walk the segments of a path, calling the
		appropriate callback function from a given set for each
		segment of the path.
	
		path: The path to walk.
	
		walker: The set of callback functions to use. The first
		4 callback pointers in the set must be non-NULL. The
		subsequent ones can either be supplied, or can be left
		as NULL, in which case the top 4 functions will be
		called as appropriate to simulate them.
	
		arg: An opaque argument passed in to each callback.
	
		Exceptions will only be thrown if the underlying callback
		functions throw them.
	*/
	FZ_FUNCTION void fz_walk_path(const FzPathWalker& walker, void *arg) const;

	/** Constructor using raw copy of pre-existing `::fz_path`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_path* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzPath(::fz_path* internal);

	/** Destructor using fz_drop_path(). */
	FZ_FUNCTION ~FzPath();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_path* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_path_walker`. Not copyable or assignable. */
struct FzPathWalker
{
	/** Constructor using raw copy of pre-existing `::fz_path_walker`. */
	FZ_FUNCTION FzPathWalker(::fz_path_walker* internal=NULL);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPathWalker();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_path_walker* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPathWalker(const FzPathWalker& rhs);
	FzPathWalker& operator=(const FzPathWalker& rhs);
};

/** Wrapper class for struct fz_path_walker with virtual fns for each fnptr; this is for use as a SWIG Director class. */

/*
We require that the `void* arg` passed to callbacks
is the original `fz_path_walker*`. So, for example,
class-aware wrapper mupdf::fz_walk_path() should be
called like:

	mupdf.FzPath path = ...;
	struct Walker : mupdf.FzPathWalker2 Ellipsis;
	Walker walker(...);
	mupdf::fz_walk_path(path, walker, walker.m_internal);
*/
struct FzPathWalker2 : FzPathWalker
{

	/** == Constructor. */
	FZ_FUNCTION FzPathWalker2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~FzPathWalker2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_moveto( bool use=true);
	FZ_FUNCTION void use_virtual_lineto( bool use=true);
	FZ_FUNCTION void use_virtual_curveto( bool use=true);
	FZ_FUNCTION void use_virtual_closepath( bool use=true);
	FZ_FUNCTION void use_virtual_quadto( bool use=true);
	FZ_FUNCTION void use_virtual_curvetov( bool use=true);
	FZ_FUNCTION void use_virtual_curvetoy( bool use=true);
	FZ_FUNCTION void use_virtual_rectto( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void moveto(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void lineto(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void curveto(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void closepath(::fz_context *arg_0);
	FZ_FUNCTION virtual void quadto(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void curvetov(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void curvetoy(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void rectto(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
};

/** Wrapper class for struct `fz_pcl_options`. Not copyable or assignable. */
/**
	PCL output
*/
struct FzPclOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_pcl_options()`. */
	/**
		Parse PCL options.
	
		Currently defined options and values are as follows:
	
			preset=X	Either "generic" or one of the presets as for fz_pcl_preset.
			spacing=0	No vertical spacing capability
			spacing=1	PCL 3 spacing (<ESC>*p+<n>Y)
			spacing=2	PCL 4 spacing (<ESC>*b<n>Y)
			spacing=3	PCL 5 spacing (<ESC>*b<n>Y and clear seed row)
			mode2		Disable/Enable mode 2 graphics compression
			mode3		Disable/Enable mode 3 graphics compression
			eog_reset	End of graphics (<ESC>*rB) resets all parameters
			has_duplex	Duplex supported (<ESC>&l<duplex>S)
			has_papersize	Papersize setting supported (<ESC>&l<sizecode>A)
			has_copies	Number of copies supported (<ESC>&l<copies>X)
			is_ljet4pjl	Disable/Enable HP 4PJL model-specific output
			is_oce9050	Disable/Enable Oce 9050 model-specific output
	*/
	FZ_FUNCTION FzPclOptions(const FzPclOptions& opts, const char *args);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPclOptions();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_pcl_preset()`.  */
	/**
		Initialize PCL option struct for a given preset.
	
		Currently defined presets include:
	
			generic	Generic PCL printer
			ljet4	HP DeskJet
			dj500	HP DeskJet 500
			fs600	Kyocera FS-600
			lj	HP LaserJet, HP LaserJet Plus
			lj2	HP LaserJet IIp, HP LaserJet IId
			lj3	HP LaserJet III
			lj3d	HP LaserJet IIId
			lj4	HP LaserJet 4
			lj4pl	HP LaserJet 4 PL
			lj4d	HP LaserJet 4d
			lp2563b	HP 2563B line printer
			oce9050	Oce 9050 Line printer
	*/
	FZ_FUNCTION void fz_pcl_preset(const char *preset) const;

	/** Constructor using raw copy of pre-existing `::fz_pcl_options`. */
	FZ_FUNCTION FzPclOptions(::fz_pcl_options* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPclOptions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_pcl_options* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPclOptions(const FzPclOptions& rhs);
	FzPclOptions& operator=(const FzPclOptions& rhs);
};

/** Wrapper class for struct `fz_pclm_options`. Not copyable or assignable. */
/**
	PCLm output
*/
struct FzPclmOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_pclm_options()`. */
	/**
		Parse PCLm options.
	
		Currently defined options and values are as follows:
	
			compression=none: No compression
			compression=flate: Flate compression
			strip-height=n: Strip height (default 16)
	*/
	FZ_FUNCTION FzPclmOptions(const FzPclmOptions& opts, const char *args);

	/** Construct using fz_parse_pclm_options(). */
	FZ_FUNCTION FzPclmOptions(const char *args);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPclmOptions();

	/** Constructor using raw copy of pre-existing `::fz_pclm_options`. */
	FZ_FUNCTION FzPclmOptions(::fz_pclm_options* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPclmOptions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_pclm_options* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPclmOptions(const FzPclmOptions& rhs);
	FzPclmOptions& operator=(const FzPclmOptions& rhs);
};

/** Wrapper class for struct `fz_pdfocr_options`. */
/**
	PDFOCR output
*/
struct FzPdfocrOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzPdfocrOptions();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_parse_pdfocr_options()`.  */
	/**
		Parse PDFOCR options.
	
		Currently defined options and values are as follows:
	
			compression=none: No compression
			compression=flate: Flate compression
			strip-height=n: Strip height (default 16)
			ocr-language=<lang>: OCR Language (default eng)
			ocr-datadir=<datadir>: OCR data path (default rely on TESSDATA_PREFIX)
	*/
	FZ_FUNCTION FzPdfocrOptions fz_parse_pdfocr_options(const char *args);

	/** Copies <language> into this->language, truncating if necessary. */
	FZ_FUNCTION void language_set2(const char* language);

	/** Copies <datadir> into this->datadir, truncating if necessary. */
	FZ_FUNCTION void datadir_set2(const char* datadir);

	/** Constructor using raw copy of pre-existing `::fz_pdfocr_options`. */
	FZ_FUNCTION FzPdfocrOptions(const ::fz_pdfocr_options* internal);

	/** Constructor using raw copy of pre-existing `::fz_pdfocr_options`. */
	FZ_FUNCTION FzPdfocrOptions(const ::fz_pdfocr_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_pdfocr_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_pdfocr_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPdfocrOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_pdfocr_options. */
	int compress;
	int strip_height;
	char language[256];
	char datadir[1024];
	int skew_correct;
	float skew_angle;
	int skew_border;
	int page_count;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzPdfocrOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzPdfocrOptions& rhs);
};

/** Wrapper class for struct `fz_pixmap`. */
/**
	Pixmaps represent a set of pixels for a 2 dimensional region of
	a plane. Each pixel has n components per pixel. The components
	are in the order process-components, spot-colors, alpha, where
	there can be 0 of any of those types. The data is in
	premultiplied alpha when rendering, but non-premultiplied for
	colorspace conversions and rescaling.
*/
struct FzPixmap
{
	/** == Constructors. */

	/** Constructor using `fz_new_barcode_pixmap()`. */
	/**
		Create an fz_pixmap from a barcode definition.
	
		type: The type of barcode to create.
		value: The value of the barcode.
		size: The size of the barcode.
		ec_level: error correction level 0-8.
		quiet: whether to include quiet zones (0 or 1).
		hrt: whether to include human readable text below the barcode (0 or 1).
	
		returns a created fz_pixmap.
	*/
	FZ_FUNCTION FzPixmap(::fz_barcode_type type, const char *value, int size, int ec_level, int quiet, int hrt);

	/** Constructor using `fz_new_pixmap()`. */
	/**
		Create a new pixmap, with its origin at (0,0)
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap(const FzColorspace& cs, int w, int h, const FzSeparations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_color_and_mask()`. */
	FZ_FUNCTION FzPixmap(const FzPixmap& color, const FzPixmap& mask);

	/** Constructor using `fz_new_pixmap_from_display_list()`. */
	/**
		Render the page to a pixmap using the transform and colorspace.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION FzPixmap(const FzDisplayList& list, const FzMatrix& ctm, const FzColorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_display_list_with_separations()`. */
	/**
		Render the page contents with control over spot colors.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION FzPixmap(const FzDisplayList& list, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_page()`. */
	FZ_FUNCTION FzPixmap(const FzPage& page, const FzMatrix& ctm, const FzColorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_number()`. */
	FZ_FUNCTION FzPixmap(const FzDocument& doc, int number, const FzMatrix& ctm, const FzColorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_number_with_separations()`. */
	FZ_FUNCTION FzPixmap(const FzDocument& doc, int number, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_with_separations()`. */
	FZ_FUNCTION FzPixmap(const FzPage& page, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_pixmap()`. */
	/**
		Create a new pixmap that represents a subarea of the specified
		pixmap. A reference is taken to this pixmap that will be dropped
		on destruction.
	
		The supplied rectangle must be wholly contained within the
		original pixmap.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap(const FzPixmap& pixmap, FzIrect& rect);

	/** Constructor using `fz_new_pixmap_with_bbox()`. */
	/**
		Create a pixmap of a given size, location and pixel format.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		bbox: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap(const FzColorspace& colorspace, const FzIrect& bbox, const FzSeparations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_with_bbox_and_data()`. */
	/**
		Create a pixmap of a given size, location and pixel format,
		using the supplied data block.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		rect: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: Number of alpha planes (0 or 1).
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap(const FzColorspace& colorspace, const FzIrect& rect, const FzSeparations& seps, int alpha, unsigned char *samples);

	/** Constructor using `fz_new_pixmap_with_data()`. */
	/**
		Create a new pixmap, with its origin at
		(0,0) using the supplied data block.
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		stride: The byte offset from the pixel data in a row to the
		pixel data in the next row.
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure to
		allocate.
	*/
	FZ_FUNCTION FzPixmap(const FzColorspace& colorspace, int w, int h, const FzSeparations& seps, int alpha, int stride, unsigned char *samples);

	/** Constructor using `pdf_new_pixmap_from_annot()`. */
	FZ_FUNCTION FzPixmap(const PdfAnnot& annot, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha);

	/** Constructor using `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`. */
	FZ_FUNCTION FzPixmap(const PdfPage& page, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha, const char *usage, ::fz_box_type box);

	/** Constructor using `pdf_new_pixmap_from_page_contents_with_usage()`. */
	FZ_FUNCTION FzPixmap(const PdfPage& page, const FzMatrix& ctm, const FzColorspace& cs, int alpha, const char *usage, ::fz_box_type box);

	/** Copy constructor using `fz_keep_pixmap()`. */
	FZ_FUNCTION FzPixmap(const FzPixmap& rhs);

	/** operator= using `fz_keep_pixmap()` and `fz_drop_pixmap()`. */
	FZ_FUNCTION FzPixmap& operator=(const FzPixmap& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPixmap();

	/* == Static methods. */

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_with_usage()`.  */
	FZ_FUNCTION static FzPixmap pdf_new_pixmap_from_page_with_usage(const PdfPage& page, const FzMatrix& ctm, const FzColorspace& cs, int alpha, const char *usage, ::fz_box_type box);

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_with_separations_and_usage()`.  */
	FZ_FUNCTION static FzPixmap pdf_new_pixmap_from_page_with_separations_and_usage(const PdfPage& page, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha, const char *usage, ::fz_box_type box);

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_contents()`.  */
	/**
		Render the page contents without annotations.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION static FzPixmap fz_new_pixmap_from_page_contents(const FzPage& page, const FzMatrix& ctm, const FzColorspace& cs, int alpha);

	/** Class-aware wrapper for `::fz_new_pixmap_from_page_contents_with_separations()`.  */
	FZ_FUNCTION static FzPixmap fz_new_pixmap_from_page_contents_with_separations(const FzPage& page, const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_alpha_from_gray()`.  */
	FZ_FUNCTION FzPixmap fz_alpha_from_gray() const;

	/** Class-aware wrapper for `::fz_autowarp_pixmap()`.  */
	FZ_FUNCTION FzPixmap fz_autowarp_pixmap(const FzQuad& points) const;

	/** Class-aware wrapper for `::fz_clear_pixmap()`.  */
	/**
		Sets all components (including alpha) of
		all pixels in a pixmap to 0.
	
		pix: The pixmap to clear.
	*/
	FZ_FUNCTION void fz_clear_pixmap() const;

	/** Class-aware wrapper for `::fz_clear_pixmap_rect_with_value()`.  */
	/**
		Clears a subrect of a pixmap with the given value.
	
		pix: The pixmap to clear.
	
		value: Values in the range 0 to 255 are valid. Each component
		sample for each pixel in the pixmap will be set to this value,
		while alpha will always be set to 255 (non-transparent).
	
		r: the rectangle.
	*/
	FZ_FUNCTION void fz_clear_pixmap_rect_with_value(int value, const FzIrect& r) const;

	/** Class-aware wrapper for `::fz_clear_pixmap_with_value()`.  */
	/**
		Clears a pixmap with the given value.
	
		pix: The pixmap to clear.
	
		value: Values in the range 0 to 255 are valid. Each component
		sample for each pixel in the pixmap will be set to this value,
		while alpha will always be set to 255 (non-transparent).
	
		This function is horrible, and should be removed from the
		API and replaced with a less magic one.
	*/
	FZ_FUNCTION void fz_clear_pixmap_with_value(int value) const;

	/** Class-aware wrapper for `::fz_clone_pixmap()`.  */
	/**
		Clone a pixmap, copying the pixels and associated data to new
		storage.
	
		The reference count of 'old' is unchanged.
	*/
	FZ_FUNCTION FzPixmap fz_clone_pixmap() const;

	/** Class-aware wrapper for `::fz_clone_pixmap_area_with_different_seps()`.  */
	FZ_FUNCTION FzPixmap fz_clone_pixmap_area_with_different_seps(FzIrect& bbox, const FzColorspace& dcs, const FzSeparations& seps, const FzColorParams& color_params, const FzDefaultColorspaces& default_cs) const;

	/** Class-aware wrapper for `::fz_convert_indexed_pixmap_to_base()`.  */
	/**
		Convert pixmap from indexed to base colorspace.
	
		This creates a new bitmap containing the converted pixmap data.
	 */
	FZ_FUNCTION FzPixmap fz_convert_indexed_pixmap_to_base() const;

	/** Class-aware wrapper for `::fz_convert_pixmap()`.  */
	/**
		Convert an existing pixmap to a desired
		colorspace. Other properties of the pixmap, such as resolution
		and position are copied to the converted pixmap.
	
		pix: The pixmap to convert.
	
		default_cs: If NULL pix->colorspace is used. It is possible that
		the data may need to be interpreted as one of the color spaces
		in default_cs.
	
		cs_des: Desired colorspace, may be NULL to denote alpha-only.
	
		prf: Proofing color space through which we need to convert.
	
		color_params: Parameters that may be used in conversion (e.g.
		ri).
	
		keep_alpha: If 0 any alpha component is removed, otherwise
		alpha is kept if present in the pixmap.
	*/
	FZ_FUNCTION FzPixmap fz_convert_pixmap(const FzColorspace& cs_des, const FzColorspace& prf, const FzDefaultColorspaces& default_cs, const FzColorParams& color_params, int keep_alpha) const;

	/** Class-aware wrapper for `::fz_convert_separation_pixmap_to_base()`.  */
	/**
		Convert pixmap from DeviceN/Separation to base colorspace.
	
		This creates a new bitmap containing the converted pixmap data.
	*/
	FZ_FUNCTION FzPixmap fz_convert_separation_pixmap_to_base() const;

	/** Class-aware wrapper for `::fz_copy_pixmap_rect()`.  */
	FZ_FUNCTION void fz_copy_pixmap_rect(const FzPixmap& src, const FzIrect& r, const FzDefaultColorspaces& default_cs) const;

	/** Class-aware wrapper for `::fz_decode_tile()`.  */
	FZ_FUNCTION void fz_decode_tile(const float *decode) const;

	/** Class-aware wrapper for `::fz_deskew_pixmap()`.  */
	FZ_FUNCTION FzPixmap fz_deskew_pixmap(double degrees, int border) const;

	/** Class-aware wrapper for `::fz_detect_skew()`.  */
	FZ_FUNCTION double fz_detect_skew() const;

	/** Class-aware wrapper for `::fz_fill_pixmap_with_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_fill_pixmap_with_color(::fz_colorspace *colorspace, ::fz_color_params color_params)` => float color
	 */
	/**
		Fill pixmap with solid color.
	*/
	FZ_FUNCTION void fz_fill_pixmap_with_color(const FzColorspace& colorspace, float *color, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_gamma_pixmap()`.  */
	/**
		Apply gamma correction to a pixmap. All components
		of all pixels are modified (except alpha, which is unchanged).
	
		gamma: The gamma value to apply; 1.0 for no change.
	*/
	FZ_FUNCTION void fz_gamma_pixmap(float gamma) const;

	/** Class-aware wrapper for `::fz_generate_transition()`.  */
	/**
		Generate a frame of a transition.
	
		tpix: Target pixmap
		opix: Old pixmap
		npix: New pixmap
		time: Position within the transition (0 to 256)
		trans: Transition details
	
		Returns 1 if successfully generated a frame.
	
		Note: Pixmaps must include alpha.
	*/
	FZ_FUNCTION int fz_generate_transition(const FzPixmap& opix, const FzPixmap& npix, int time, FzTransition& trans) const;

	/** Class-aware wrapper for `::fz_invert_pixmap()`.  */
	/**
		Invert all the pixels in a pixmap. All components (process and
		spots) of all pixels are inverted (except alpha, which is
		unchanged).
	*/
	FZ_FUNCTION void fz_invert_pixmap() const;

	/** Class-aware wrapper for `::fz_invert_pixmap_alpha()`.  */
	/**
		Invert the alpha of all the pixels in a pixmap.
	*/
	FZ_FUNCTION void fz_invert_pixmap_alpha() const;

	/** Class-aware wrapper for `::fz_invert_pixmap_luminance()`.  */
	/**
		Transform the pixels in a pixmap so that luminance of each
		pixel is inverted, and the chrominance remains unchanged (as
		much as accuracy allows).
	
		All components of all pixels are inverted (except alpha, which
		is unchanged). Only supports Grey and RGB bitmaps.
	*/
	FZ_FUNCTION void fz_invert_pixmap_luminance() const;

	/** Class-aware wrapper for `::fz_invert_pixmap_raw()`.  */
	/**
		Invert all the pixels in a non-premultiplied pixmap in a
		very naive manner.
	*/
	FZ_FUNCTION void fz_invert_pixmap_raw() const;

	/** Class-aware wrapper for `::fz_invert_pixmap_rect()`.  */
	/**
		Invert all the pixels in a given rectangle of a (premultiplied)
		pixmap. All components of all pixels in the rectangle are
		inverted (except alpha, which is unchanged).
	*/
	FZ_FUNCTION void fz_invert_pixmap_rect(const FzIrect& rect) const;

	/** Class-aware wrapper for `::fz_is_pixmap_monochrome()`.  */
	/**
		Check if the pixmap is a 1-channel image containing samples with
		only values 0 and 255
	*/
	FZ_FUNCTION int fz_is_pixmap_monochrome() const;

	/** Class-aware wrapper for `::fz_md5_pixmap()`.  */
	FZ_FUNCTION void fz_md5_pixmap(unsigned char digest[16]) const;

	/** Class-aware wrapper for `::fz_md5_pixmap2()`.  */
	/**
	C++ alternative to `fz_md5_pixmap()` that returns the digest by value.
	*/
	FZ_FUNCTION std::vector<unsigned char> fz_md5_pixmap2() const;

	/** Class-aware wrapper for `::fz_new_bitmap_from_pixmap()`.  */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap fz_new_bitmap_from_pixmap(const FzHalftone& ht) const;

	/** Class-aware wrapper for `::fz_new_bitmap_from_pixmap_band()`.  */
	/**
		Make a bitmap from a pixmap and a
		halftone, allowing for the position of the pixmap within an
		overall banded rendering.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		band_start: Vertical offset within the overall banded rendering
		(in pixels)
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION FzBitmap fz_new_bitmap_from_pixmap_band(const FzHalftone& ht, int band_start) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_jpeg()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_jpeg(const FzColorParams& color_params, int quality, int invert_cmyk) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_jpx()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_jpx(const FzColorParams& color_params, int quality) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pam()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_pam(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pbm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_pbm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pkm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_pkm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_png()`.  */
	/**
		Re-encode a given pixmap as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_png(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_pnm()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_pnm(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_pixmap_as_psd()`.  */
	FZ_FUNCTION FzBuffer fz_new_buffer_from_pixmap_as_psd(const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_new_image_from_pixmap()`.  */
	/**
		Create an image from the given
		pixmap.
	
		pixmap: The pixmap to base the image upon. A new reference
		to this is taken.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION FzImage fz_new_image_from_pixmap(const FzImage& mask) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_alpha_channel()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_alpha_channel() const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_color_and_mask()`.  */
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_color_and_mask(const FzPixmap& mask) const;

	/** Class-aware wrapper for `::fz_new_pixmap_from_pixmap()`.  */
	/**
		Create a new pixmap that represents a subarea of the specified
		pixmap. A reference is taken to this pixmap that will be dropped
		on destruction.
	
		The supplied rectangle must be wholly contained within the
		original pixmap.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION FzPixmap fz_new_pixmap_from_pixmap(FzIrect& rect) const;

	/** Class-aware wrapper for `::fz_pixmap_alpha()`.  */
	/**
		Return the number of alpha planes in a pixmap.
	
		Returns the number of alphas. Does not throw exceptions.
	*/
	FZ_FUNCTION int fz_pixmap_alpha() const;

	/** Class-aware wrapper for `::fz_pixmap_bbox()`.  */
	/**
		Return the bounding box for a pixmap.
	*/
	FZ_FUNCTION FzIrect fz_pixmap_bbox() const;

	/** Class-aware wrapper for `::fz_pixmap_colorants()`.  */
	/**
		Return the number of colorants in a pixmap.
	
		Returns the number of colorants (components, less any spots and
		alpha).
	*/
	FZ_FUNCTION int fz_pixmap_colorants() const;

	/** Class-aware wrapper for `::fz_pixmap_colorspace()`.  */
	/**
		Return the colorspace of a pixmap
	
		Returns colorspace.
	*/
	FZ_FUNCTION FzColorspace fz_pixmap_colorspace() const;

	/** Class-aware wrapper for `::fz_pixmap_components()`.  */
	/**
		Return the number of components in a pixmap.
	
		Returns the number of components (including spots and alpha).
	*/
	FZ_FUNCTION int fz_pixmap_components() const;

	/** Class-aware wrapper for `::fz_pixmap_height()`.  */
	/**
		Return the height of the pixmap in pixels.
	*/
	FZ_FUNCTION int fz_pixmap_height() const;

	/** Class-aware wrapper for `::fz_pixmap_samples()`.  */
	/**
		Returns a pointer to the pixel data of a pixmap.
	
		Returns the pointer.
	*/
	FZ_FUNCTION unsigned char *fz_pixmap_samples() const;

	/** Class-aware wrapper for `::fz_pixmap_samples_int()`.  */
	/** */
	FZ_FUNCTION long long fz_pixmap_samples_int() const;

	/** Class-aware wrapper for `::fz_pixmap_size()`.  */
	/**
		Return sizeof fz_pixmap plus size of data, in bytes.
	*/
	FZ_FUNCTION size_t fz_pixmap_size() const;

	/** Class-aware wrapper for `::fz_pixmap_spots()`.  */
	/**
		Return the number of spots in a pixmap.
	
		Returns the number of spots (components, less colorants and
		alpha). Does not throw exceptions.
	*/
	FZ_FUNCTION int fz_pixmap_spots() const;

	/** Class-aware wrapper for `::fz_pixmap_stride()`.  */
	/**
		Return the number of bytes in a row in the pixmap.
	*/
	FZ_FUNCTION int fz_pixmap_stride() const;

	/** Class-aware wrapper for `::fz_pixmap_width()`.  */
	/**
		Return the width of the pixmap in pixels.
	*/
	FZ_FUNCTION int fz_pixmap_width() const;

	/** Class-aware wrapper for `::fz_pixmap_x()`.  */
	/**
		Return the x value of the pixmap in pixels.
	*/
	FZ_FUNCTION int fz_pixmap_x() const;

	/** Class-aware wrapper for `::fz_pixmap_y()`.  */
	/**
		Return the y value of the pixmap in pixels.
	*/
	FZ_FUNCTION int fz_pixmap_y() const;

	/** Class-aware wrapper for `::fz_samples_get()`.  */
	/**
	Provides simple (but slow) access to pixmap data from Python and C#.
	*/
	FZ_FUNCTION int fz_samples_get(int offset) const;

	/** Class-aware wrapper for `::fz_samples_set()`.  */
	/**
	Provides simple (but slow) write access to pixmap data from Python and
	C#.
	*/
	FZ_FUNCTION void fz_samples_set(int offset, int value) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_jpeg()`.  */
	/**
		Save a pixmap as a JPEG.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_jpeg(const char *filename, int quality) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_jpx()`.  */
	/**
		Save pixmap data as JP2K with no subsampling.
	
		quality = 100 = lossless
		otherwise for a factor of x compression use 100-x. (so 80 is 1:20 compression)
	*/
	FZ_FUNCTION void fz_save_pixmap_as_jpx(const char *filename, int q) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pam()`.  */
	/**
		Save a pixmap as a pnm (greyscale, rgb or cmyk, with or without
		alpha).
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pam(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pbm()`.  */
	/**
		Save a pixmap as a pbm. (Performing halftoning).
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pbm(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pcl()`.  */
	/**
		Save an (RGB) pixmap as color PCL.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pcl(char *filename, int append, const FzPclOptions& pcl) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pclm()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as pclm.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pclm(const char *filename, int append, const FzPclmOptions& options) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pdfocr()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as pdfocr.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pdfocr(char *filename, int append, FzPdfocrOptions& options) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pkm()`.  */
	/**
		Save a CMYK pixmap as a pkm. (Performing halftoning).
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pkm(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_png()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as a png.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_png(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pnm()`.  */
	/**
		Save a pixmap as a pnm (greyscale or rgb, no alpha).
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pnm(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_ps()`.  */
	/**
		Save a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_ps(char *filename, int append) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_psd()`.  */
	/**
		Save a pixmap as a PSD file.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_psd(const char *filename) const;

	/** Class-aware wrapper for `::fz_save_pixmap_as_pwg()`.  */
	/**
		Save a pixmap as a PWG.
	*/
	FZ_FUNCTION void fz_save_pixmap_as_pwg(char *filename, int append, FzPwgOptions& pwg) const;

	/** Class-aware wrapper for `::fz_scale_pixmap()`.  */
	FZ_FUNCTION FzPixmap fz_scale_pixmap(float x, float y, float w, float h, FzIrect& clip) const;

	/** Class-aware wrapper for `::fz_set_pixmap_resolution()`.  */
	/**
		Set the pixels per inch resolution of the pixmap.
	*/
	FZ_FUNCTION void fz_set_pixmap_resolution(int xres, int yres) const;

	/** Class-aware wrapper for `::fz_subsample_pixmap()`.  */
	FZ_FUNCTION void fz_subsample_pixmap(int factor) const;

	/** Class-aware wrapper for `::fz_tint_pixmap()`.  */
	/**
		Tint all the pixels in an RGB, BGR, or Gray pixmap.
	
		black: Map black to this hexadecimal RGB color.
	
		white: Map white to this hexadecimal RGB color.
	*/
	FZ_FUNCTION void fz_tint_pixmap(int black, int white) const;

	/** Class-aware wrapper for `::fz_warp_pixmap()`.  */
	FZ_FUNCTION FzPixmap fz_warp_pixmap(const FzQuad& points, int width, int height) const;

	/** Constructor using raw copy of pre-existing `::fz_pixmap`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_pixmap* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzPixmap(::fz_pixmap* internal);

	/* == Accessors to members of ::fz_pixmap m_internal. */

	FZ_FUNCTION ::fz_storable storable();
	FZ_FUNCTION int x();
	FZ_FUNCTION int y();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION unsigned char n();
	FZ_FUNCTION unsigned char s();
	FZ_FUNCTION unsigned char alpha();
	FZ_FUNCTION unsigned char flags();
	FZ_FUNCTION ptrdiff_t stride();
	FZ_FUNCTION FzSeparations seps();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION FzColorspace colorspace();
	FZ_FUNCTION const unsigned char *samples();
	FZ_FUNCTION FzPixmap underlying();

	/** Destructor using fz_drop_pixmap(). */
	FZ_FUNCTION ~FzPixmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_pixmap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_pixmap_image`. Not copyable or assignable. */
struct FzPixmapImage
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPixmapImage();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_pixmap_image_tile()`.  */
	/**
		Retrieve the underlying fz_pixmap for an image.
	
		Returns a pointer to the underlying fz_pixmap for an image,
		or NULL if this image is not based upon an fz_pixmap.
	
		No reference is returned. Lifespan is limited to that of
		the image itself. If required, use fz_keep_pixmap to take
		a reference to keep it longer.
	*/
	FZ_FUNCTION FzPixmap fz_pixmap_image_tile() const;

	/** Class-aware wrapper for `::fz_set_pixmap_image_tile()`.  */
	FZ_FUNCTION void fz_set_pixmap_image_tile(const FzPixmap& pix) const;

	/** Constructor using raw copy of pre-existing `::fz_pixmap_image`. */
	FZ_FUNCTION FzPixmapImage(::fz_pixmap_image* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPixmapImage();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_pixmap_image* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPixmapImage(const FzPixmapImage& rhs);
	FzPixmapImage& operator=(const FzPixmapImage& rhs);
};

/** Wrapper class for struct `fz_point`. */
/**
	fz_point is a point in a two-dimensional space.
*/
struct FzPoint
{
	/** Construct using specified values. */
	FZ_FUNCTION FzPoint(float x, float y);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzPoint();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_transform_point()`.  */
	/**
		Apply a transformation to a point.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale, fz_rotate and fz_translate for how to create a
		matrix.
	
		point: Pointer to point to update.
	
		Returns transform (unchanged).
	*/
	FZ_FUNCTION static FzPoint fz_transform_point(const FzPoint& point, const FzMatrix& m);

	/** Class-aware wrapper for `::fz_transform_point_xy()`.  */
	FZ_FUNCTION static FzPoint fz_transform_point_xy(float x, float y, const FzMatrix& m);

	/** Class-aware wrapper for `::fz_transform_vector()`.  */
	/**
		Apply a transformation to a vector.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix. Any
		translation will be ignored.
	
		vector: Pointer to vector to update.
	*/
	FZ_FUNCTION static FzPoint fz_transform_vector(const FzPoint& vector, const FzMatrix& m);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_is_point_inside_quad()`.  */
	/**
		Inclusion test for quads.
	*/
	FZ_FUNCTION int fz_is_point_inside_quad(const FzQuad& q);

	/** Class-aware wrapper for `::fz_is_point_inside_rect()`.  */
	/**
		Inclusion test for rects. (Rect is assumed to be open, i.e.
		top right corner is not included).
	*/
	FZ_FUNCTION int fz_is_point_inside_rect(const FzRect& r);

	/** Class-aware wrapper for `::fz_normalize_vector()`.  */
	/**
		Normalize a vector to length one.
	*/
	FZ_FUNCTION FzPoint fz_normalize_vector();

	/** Class-aware wrapper for `::fz_transform_point()`.  */
	/**
		Apply a transformation to a point.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale, fz_rotate and fz_translate for how to create a
		matrix.
	
		point: Pointer to point to update.
	
		Returns transform (unchanged).
	*/
	FZ_FUNCTION FzPoint fz_transform_point(const FzMatrix& m);

	/** Class-aware wrapper for `::fz_transform_vector()`.  */
	/**
		Apply a transformation to a vector.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix. Any
		translation will be ignored.
	
		vector: Pointer to vector to update.
	*/
	FZ_FUNCTION FzPoint fz_transform_vector(const FzMatrix& m);

	/** Post-multiply *this by <m> and return *this. */
	FZ_FUNCTION FzPoint& transform(const FzMatrix& m);

	/** Constructor using raw copy of pre-existing `::fz_point`. */
	FZ_FUNCTION FzPoint(const ::fz_point* internal);

	/** Constructor using raw copy of pre-existing `::fz_point`. */
	FZ_FUNCTION FzPoint(const ::fz_point internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_point* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_point* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPoint();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_point. */
	float x;
	float y;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzPoint& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzPoint& rhs);
};

/** Wrapper class for struct `fz_pool`. Not copyable or assignable. */
/**
	Simple pool allocators.

	Allocate from the pool, which can then be freed at once.
*/
struct FzPool
{
	/** == Constructors. */

	/** Constructor using `fz_new_pool()`. */
	/**
		Create a new pool to allocate from.
	*/
	FZ_FUNCTION FzPool();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_json_array_push()`.  */
	FZ_FUNCTION void fz_json_array_push(const FzJson& array, const FzJson& item) const;

	/** Class-aware wrapper for `::fz_json_object_set()`.  */
	FZ_FUNCTION void fz_json_object_set(const FzJson& object, const char *key, const FzJson& item) const;

	/** Class-aware wrapper for `::fz_pool_alloc()`.  */
	/**
		Allocate a block of size bytes from the pool.
	*/
	FZ_FUNCTION void *fz_pool_alloc(size_t size) const;

	/** Class-aware wrapper for `::fz_pool_size()`.  */
	/**
		The current size of the pool.
	
		The number of bytes of storage currently allocated to the pool.
		This is the total of the storage used for the blocks making
		up the pool, rather then total of the allocated blocks so far,
		so it will increase in 'lumps'.
		from the pool, then the pool size may still be X
	*/
	FZ_FUNCTION size_t fz_pool_size() const;

	/** Class-aware wrapper for `::fz_pool_strdup()`.  */
	/**
		strdup equivalent allocating from the pool.
	*/
	FZ_FUNCTION char *fz_pool_strdup(const char *s) const;

	/** Class-aware wrapper for `::fz_xml_add_att()`.  */
	/**
		Add an attribute to an XML node.
	*/
	FZ_FUNCTION void fz_xml_add_att(const FzXml& node, const char *key, const char *val) const;

	/** Constructor using raw copy of pre-existing `::fz_pool`. */
	FZ_FUNCTION FzPool(::fz_pool* internal);

	/** Destructor using fz_drop_pool(). */
	FZ_FUNCTION ~FzPool();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_pool* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPool(const FzPool& rhs);
	FzPool& operator=(const FzPool& rhs);
};

/** Wrapper class for struct `fz_ptr_heap`. Not copyable or assignable. */
struct FzPtrHeap
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzPtrHeap();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_ptr_heap_insert()`.  */
	FZ_FUNCTION void fz_ptr_heap_insert(void *v, int (*HEAP_CMP)(void **, void **)) const;

	/** Class-aware wrapper for `::fz_ptr_heap_sort()`.  */
	FZ_FUNCTION void fz_ptr_heap_sort(int (*HEAP_CMP)(void **, void **)) const;

	/** Class-aware wrapper for `::fz_ptr_heap_uniq()`.  */
	FZ_FUNCTION void fz_ptr_heap_uniq(int (*HEAP_CMP)(void **, void **)) const;

	/** Constructor using raw copy of pre-existing `::fz_ptr_heap`. */
	FZ_FUNCTION FzPtrHeap(::fz_ptr_heap* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPtrHeap();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_ptr_heap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzPtrHeap(const FzPtrHeap& rhs);
	FzPtrHeap& operator=(const FzPtrHeap& rhs);
};

/** Wrapper class for struct `fz_pwg_options`. */
struct FzPwgOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzPwgOptions();

	/** Constructor using raw copy of pre-existing `::fz_pwg_options`. */
	FZ_FUNCTION FzPwgOptions(const ::fz_pwg_options* internal);

	/* == Accessors to members of ::fz_pwg_options m_internal. */

	FZ_FUNCTION char * media_class();
	FZ_FUNCTION char * media_color();
	FZ_FUNCTION char * media_type();
	FZ_FUNCTION char * output_type();
	FZ_FUNCTION unsigned int advance_distance();
	FZ_FUNCTION int advance_media();
	FZ_FUNCTION int collate();
	FZ_FUNCTION int cut_media();
	FZ_FUNCTION int duplex();
	FZ_FUNCTION int insert_sheet();
	FZ_FUNCTION int jog();
	FZ_FUNCTION int leading_edge();
	FZ_FUNCTION int manual_feed();
	FZ_FUNCTION unsigned int media_position();
	FZ_FUNCTION unsigned int media_weight();
	FZ_FUNCTION int mirror_print();
	FZ_FUNCTION int negative_print();
	FZ_FUNCTION unsigned int num_copies();
	FZ_FUNCTION int orientation();
	FZ_FUNCTION int output_face_up();
	FZ_FUNCTION unsigned int * PageSize();
	FZ_FUNCTION int separations();
	FZ_FUNCTION int tray_switch();
	FZ_FUNCTION int tumble();
	FZ_FUNCTION int media_type_num();
	FZ_FUNCTION int compression();
	FZ_FUNCTION unsigned int row_count();
	FZ_FUNCTION unsigned int row_feed();
	FZ_FUNCTION unsigned int row_step();
	FZ_FUNCTION char * rendering_intent();
	FZ_FUNCTION char * page_size_name();

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzPwgOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	::fz_pwg_options  m_internal; /** Wrapped data is held by value. */

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzPwgOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzPwgOptions& rhs);
};

/** Wrapper class for struct `fz_quad`. */
/**
	A representation for a region defined by 4 points.

	The significant difference between quads and rects is that
	the edges of quads are not axis aligned.
*/
struct FzQuad
{
	/** == Constructors. */

	/** Constructor using `fz_quad_from_rect()`. */
	/**
		Convert a rect to a quad (losslessly).
	*/
	FZ_FUNCTION FzQuad(const FzRect& r);

	/** Constructor using `fz_transform_quad()`. */
	/**
		Transform a quad by a matrix.
	*/
	FZ_FUNCTION FzQuad(const FzQuad& q, const FzMatrix& m);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzQuad();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_detect_document()`.  */
	FZ_FUNCTION int fz_detect_document(const FzPixmap& src);

	/** Class-aware wrapper for `::fz_is_empty_quad()`.  */
	/**
		Is a quad empty?
	*/
	FZ_FUNCTION int fz_is_empty_quad();

	/** Class-aware wrapper for `::fz_is_infinite_quad()`.  */
	/**
		Is a quad infinite?
	*/
	FZ_FUNCTION int fz_is_infinite_quad();

	/** Class-aware wrapper for `::fz_is_quad_inside_quad()`.  */
	/**
		Inclusion test for quad in quad.
	
		This may break down if quads are not 'well formed'.
	*/
	FZ_FUNCTION int fz_is_quad_inside_quad(const FzQuad& haystack);

	/** Class-aware wrapper for `::fz_is_quad_intersecting_quad()`.  */
	/**
		Intersection test for quads.
	
		This may break down if quads are not 'well formed'.
	*/
	FZ_FUNCTION int fz_is_quad_intersecting_quad(const FzQuad& b);

	/** Class-aware wrapper for `::fz_is_valid_quad()`.  */
	/**
		Is a quad valid?
	*/
	FZ_FUNCTION int fz_is_valid_quad();

	/** Class-aware wrapper for `::fz_rect_from_quad()`.  */
	/**
		Convert a quad to the smallest rect that covers it.
	*/
	FZ_FUNCTION FzRect fz_rect_from_quad();

	/** Class-aware wrapper for `::fz_transform_quad()`.  */
	/**
		Transform a quad by a matrix.
	*/
	FZ_FUNCTION FzQuad fz_transform_quad(const FzMatrix& m);

	/** Constructor using raw copy of pre-existing `::fz_quad`. */
	FZ_FUNCTION FzQuad(const ::fz_quad* internal);

	/** Constructor using raw copy of pre-existing `::fz_quad`. */
	FZ_FUNCTION FzQuad(const ::fz_quad internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_quad* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_quad* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzQuad();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_quad. */
	::fz_point ul;
	::fz_point ur;
	::fz_point ll;
	::fz_point lr;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzQuad& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzQuad& rhs);
};

/** Wrapper class for struct `fz_range`. Not copyable or assignable. */
struct FzRange
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzRange();

	/** Constructor using raw copy of pre-existing `::fz_range`. */
	FZ_FUNCTION FzRange(::fz_range* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzRange();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_range* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzRange(const FzRange& rhs);
	FzRange& operator=(const FzRange& rhs);
};

/** Wrapper class for struct `fz_rect`. */
struct FzRect
{
	enum Fixed
	{
		Fixed_UNIT,
		Fixed_EMPTY,
		Fixed_INFINITE,
	};

	/** == Constructors. */

	/** Constructor using `fz_bound_display_list()`. */
	/**
		Return the bounding box of the page recorded in a display list.
	*/
	FZ_FUNCTION FzRect(const FzDisplayList& list);

	/** Constructor using `fz_rect_from_irect()`. */
	/**
		Convert a bbox into a rect.
	
		For our purposes, a rect can represent all the values we meet in
		a bbox, so nothing can go wrong.
	
		rect: A place to store the generated rectangle.
	
		bbox: The bbox to convert.
	
		Returns rect (updated).
	*/
	FZ_FUNCTION FzRect(const FzIrect& bbox);

	/** Constructor using `fz_rect_from_quad()`. */
	/**
		Convert a quad to the smallest rect that covers it.
	*/
	FZ_FUNCTION FzRect(const FzQuad& q);

	/** Constructor using `fz_transform_rect()`. */
	/**
		Apply a transform to a rectangle.
	
		After the four corner points of the axis-aligned rectangle
		have been transformed it may not longer be axis-aligned. So a
		new axis-aligned rectangle is created covering at least the
		area of the transformed rectangle.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix.
	
		rect: Rectangle to be transformed. The two special cases
		fz_empty_rect and fz_infinite_rect, may be used but are
		returned unchanged as expected.
	*/
	FZ_FUNCTION FzRect(const FzRect& rect, const FzMatrix& m);

	/** Construct from specified values. */
	FZ_FUNCTION FzRect(double x0, double y0, double x1, double y1);

	/** Copy constructor using plain copy. */
	FZ_FUNCTION FzRect(const FzRect& rhs);

	/** Construct from fz_unit_rect, fz_empty_rect or fz_infinite_rect. */
	FZ_FUNCTION FzRect(Fixed fixed);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzRect();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_intersect_rect()`.  */
	/**
		Compute intersection of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that covers the area covered by both
		given rectangles. If either rectangle is empty then the
		intersection is also empty. If either rectangle is infinite
		then the intersection is simply the non-infinite rectangle.
		Should both rectangles be infinite, then the intersection is
		also infinite.
	*/
	FZ_FUNCTION static FzRect fz_intersect_rect(const FzRect& a, const FzRect& b);

	/** Class-aware wrapper for `::fz_union_rect()`.  */
	/**
		Compute union of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that encompasses both given rectangles.
		If either rectangle is infinite then the union is also infinite.
		If either rectangle is empty then the union is simply the
		non-empty rectangle. Should both rectangles be empty, then the
		union is also empty.
	*/
	FZ_FUNCTION static FzRect fz_union_rect(const FzRect& a, const FzRect& b);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_adjust_rect_for_stroke()`.  */
	/**
		Given a rectangle (assumed to be the bounding box for a path),
		expand it to allow for the expansion of the bbox that would be
		seen by stroking the path with the given stroke state and
		transform.
	*/
	FZ_FUNCTION FzRect fz_adjust_rect_for_stroke(const FzStrokeState& stroke, const FzMatrix& ctm);

	/** Class-aware wrapper for `::fz_contains_rect()`.  */
	/**
		Test rectangle inclusion.
	
		Return true if a entirely contains b.
	*/
	FZ_FUNCTION int fz_contains_rect(const FzRect& b);

	/** Class-aware wrapper for `::fz_expand_rect()`.  */
	/**
		Expand a bbox by a given amount in all directions.
	*/
	FZ_FUNCTION FzRect fz_expand_rect(float expand);

	/** Class-aware wrapper for `::fz_include_point_in_rect()`.  */
	/**
		Expand a bbox to include a given point.
		To create a rectangle that encompasses a sequence of points, the
		rectangle must first be set to be the empty rectangle at one of
		the points before including the others.
	*/
	FZ_FUNCTION FzRect fz_include_point_in_rect(const FzPoint& p);

	/** Class-aware wrapper for `::fz_intersect_rect()`.  */
	/**
		Compute intersection of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that covers the area covered by both
		given rectangles. If either rectangle is empty then the
		intersection is also empty. If either rectangle is infinite
		then the intersection is simply the non-infinite rectangle.
		Should both rectangles be infinite, then the intersection is
		also infinite.
	*/
	FZ_FUNCTION FzRect fz_intersect_rect(const FzRect& b);

	/** Class-aware wrapper for `::fz_irect_from_rect()`.  */
	/**
		Convert a rect into the minimal bounding box
		that covers the rectangle.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	*/
	FZ_FUNCTION FzIrect fz_irect_from_rect();

	/** Class-aware wrapper for `::fz_is_empty_rect()`.  */
	/**
		Check if rectangle is empty.
	
		An empty rectangle is defined as one whose area is zero.
		All invalid rectangles are empty.
	*/
	FZ_FUNCTION int fz_is_empty_rect();

	/** Class-aware wrapper for `::fz_is_infinite_rect()`.  */
	/**
		Check if rectangle is infinite.
	*/
	FZ_FUNCTION int fz_is_infinite_rect();

	/** Class-aware wrapper for `::fz_is_rect_inside_rect()`.  */
	/**
		Inclusion test for rects.
	
		rects are assumed to be both open or both closed.
	
		No invalid rect can include any other rect.
		No invalid rect can be included by any rect.
		Empty (point) rects can include themselves.
		Empty (line) rects can include many (subline) rects.
	*/
	FZ_FUNCTION int fz_is_rect_inside_rect(const FzRect& outer);

	/** Class-aware wrapper for `::fz_is_valid_rect()`.  */
	/**
		Check if rectangle is valid.
	*/
	FZ_FUNCTION int fz_is_valid_rect();

	/** Class-aware wrapper for `::fz_new_bbox_device()`.  */
	/**
		Create a device to compute the bounding
		box of all marks on a page.
	
		The returned bounding box will be the union of all bounding
		boxes of all objects on a page.
	*/
	FZ_FUNCTION FzDevice fz_new_bbox_device();

	/** Class-aware wrapper for `::fz_new_display_list()`.  */
	/**
		Create an empty display list.
	
		A display list contains drawing commands (text, images, etc.).
		Use fz_new_list_device for populating the list.
	
		mediabox: Bounds of the page (in points) represented by the
		display list.
	*/
	FZ_FUNCTION FzDisplayList fz_new_display_list();

	/** Class-aware wrapper for `::fz_quad_from_rect()`.  */
	/**
		Convert a rect to a quad (losslessly).
	*/
	FZ_FUNCTION FzQuad fz_quad_from_rect();

	/** Class-aware wrapper for `::fz_round_rect()`.  */
	/**
		Round rectangle coordinates.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	
		This differs from fz_irect_from_rect, in that fz_irect_from_rect
		slavishly follows the numbers (i.e any slight over/under
		calculations can cause whole extra pixels to be added).
		fz_round_rect allows for a small amount of rounding error when
		calculating the bbox.
	*/
	FZ_FUNCTION FzIrect fz_round_rect();

	/** Class-aware wrapper for `::fz_transform_page()`.  */
	/**
		Create transform matrix to draw page
		at a given resolution and rotation. Adjusts the scaling
		factors so that the page covers whole number of
		pixels and adjust the page origin to be at 0,0.
	*/
	FZ_FUNCTION FzMatrix fz_transform_page(float resolution, float rotate);

	/** Class-aware wrapper for `::fz_transform_rect()`.  */
	/**
		Apply a transform to a rectangle.
	
		After the four corner points of the axis-aligned rectangle
		have been transformed it may not longer be axis-aligned. So a
		new axis-aligned rectangle is created covering at least the
		area of the transformed rectangle.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix.
	
		rect: Rectangle to be transformed. The two special cases
		fz_empty_rect and fz_infinite_rect, may be used but are
		returned unchanged as expected.
	*/
	FZ_FUNCTION FzRect fz_transform_rect(const FzMatrix& m);

	/** Class-aware wrapper for `::fz_translate_rect()`.  */
	/**
		Translate bounding box.
	
		Translate a bbox by a given x and y offset. Allows for overflow.
	*/
	FZ_FUNCTION FzRect fz_translate_rect(float xoff, float yoff);

	/** Class-aware wrapper for `::fz_union_rect()`.  */
	/**
		Compute union of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that encompasses both given rectangles.
		If either rectangle is infinite then the union is also infinite.
		If either rectangle is empty then the union is simply the
		non-empty rectangle. Should both rectangles be empty, then the
		union is also empty.
	*/
	FZ_FUNCTION FzRect fz_union_rect(const FzRect& b);

	/** Class-aware wrapper for `::pdf_signature_appearance_signed()`.  */
	FZ_FUNCTION FzDisplayList pdf_signature_appearance_signed(::fz_text_language lang, const FzImage& img, const char *left_text, const char *right_text, int include_logo);

	/** Class-aware wrapper for `::pdf_signature_appearance_unsigned()`.  */
	FZ_FUNCTION FzDisplayList pdf_signature_appearance_unsigned(::fz_text_language lang);

	/** Transforms *this using fz_transform_rect() with <m>. */
	FZ_FUNCTION void transform(const FzMatrix& m);

	/** Convenience method using fz_contains_rect(). */
	FZ_FUNCTION bool contains(double x, double y);

	/** Uses fz_contains_rect(*this, rhs). */
	FZ_FUNCTION bool contains(FzRect& rhs);

	/** Uses fz_is_empty_rect(). */
	FZ_FUNCTION bool is_empty();

	/** Updates *this using fz_union_rect(). */
	FZ_FUNCTION void union_(FzRect& rhs);

	/** Constructor using raw copy of pre-existing `::fz_rect`. */
	FZ_FUNCTION FzRect(const ::fz_rect* internal);

	/** Constructor using raw copy of pre-existing `::fz_rect`. */
	FZ_FUNCTION FzRect(const ::fz_rect internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_rect* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_rect* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzRect();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_rect. */
	float x0;
	float y0;
	float x1;
	float y1;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzRect& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzRect& rhs);
};

/** Wrapper class for struct `fz_separations`. */
struct FzSeparations
{
	/** == Constructors. */

	/** Constructor using `fz_new_separations()`. */
	/**
		Create a new separations structure (initially empty)
	*/
	FZ_FUNCTION FzSeparations(int controllable);

	/** Copy constructor using `fz_keep_separations()`. */
	FZ_FUNCTION FzSeparations(const FzSeparations& rhs);

	/** operator= using `fz_keep_separations()` and `fz_drop_separations()`. */
	FZ_FUNCTION FzSeparations& operator=(const FzSeparations& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_add_separation()`.  */
	/**
		Add a separation (null terminated name, colorspace)
	*/
	FZ_FUNCTION void fz_add_separation(const char *name, const FzColorspace& cs, int cs_channel) const;

	/** Class-aware wrapper for `::fz_add_separation_equivalents()`.  */
	/**
		Add a separation with equivalents (null terminated name,
		colorspace)
	
		(old, deprecated)
	*/
	FZ_FUNCTION void fz_add_separation_equivalents(uint32_t rgba, uint32_t cmyk, const char *name) const;

	/** Class-aware wrapper for `::fz_clone_separations_for_overprint()`.  */
	/**
		Return a separations object with all the spots in the input
		separations object that are set to composite, reset to be
		enabled. If there ARE no spots in the object, this returns
		NULL. If the object already has all its spots enabled, then
		just returns another handle on the same object.
	*/
	FZ_FUNCTION FzSeparations fz_clone_separations_for_overprint() const;

	/** Class-aware wrapper for `::fz_compare_separations()`.  */
	/**
		Compare 2 separations structures (or NULLs).
	
		Return 0 if identical, non-zero if not identical.
	*/
	FZ_FUNCTION int fz_compare_separations(const FzSeparations& sep2) const;

	/** Class-aware wrapper for `::fz_count_active_separations()`.  */
	/**
		Return the number of active separations.
	*/
	FZ_FUNCTION int fz_count_active_separations() const;

	/** Class-aware wrapper for `::fz_count_separations()`.  */
	FZ_FUNCTION int fz_count_separations() const;

	/** Class-aware wrapper for `::fz_separation_equivalent()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_separation_equivalent(int idx, ::fz_colorspace *dst_cs, ::fz_colorspace *prf, ::fz_color_params color_params)` => float dst_color
	 */
	/**
		Get the equivalent separation color in a given colorspace.
	*/
	FZ_FUNCTION void fz_separation_equivalent(int idx, const FzColorspace& dst_cs, float *dst_color, const FzColorspace& prf, const FzColorParams& color_params) const;

	/** Class-aware wrapper for `::fz_separation_name()`.  */
	FZ_FUNCTION const char *fz_separation_name(int separation) const;

	/** Class-aware wrapper for `::fz_set_separation_behavior()`.  */
	/**
		Control the rendering of a given separation.
	*/
	FZ_FUNCTION void fz_set_separation_behavior(int separation, ::fz_separation_behavior behavior) const;

	/** Constructor using raw copy of pre-existing `::fz_separations`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_separations* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzSeparations(::fz_separations* internal=NULL);

	/** Destructor using fz_drop_separations(). */
	FZ_FUNCTION ~FzSeparations();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_separations* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_sha256`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct FzSha256
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzSha256();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_sha256_final()`.  */
	/**
		MD5 finalization. Ends an MD5 message-digest operation, writing
		the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha256_final(unsigned char digest[32]) const;

	/** Class-aware wrapper for `::fz_sha256_init()`.  */
	/**
		SHA256 initialization. Begins an SHA256 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha256_init() const;

	/** Class-aware wrapper for `::fz_sha256_update()`.  */
	/**
		SHA256 block update operation. Continues an SHA256 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha256_update(const unsigned char *input, size_t inlen) const;

	/** Constructor using raw copy of pre-existing `::fz_sha256`. */
	FZ_FUNCTION FzSha256(::fz_sha256* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzSha256();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_sha256* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzSha256(const FzSha256& rhs);
	FzSha256& operator=(const FzSha256& rhs);
};

/** Wrapper class for struct `fz_sha384`. Not copyable or assignable. */
struct FzSha384
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzSha384();

	/** Constructor using raw copy of pre-existing `::fz_sha384`. */
	FZ_FUNCTION FzSha384(::fz_sha384* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzSha384();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_sha384* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzSha384(const FzSha384& rhs);
	FzSha384& operator=(const FzSha384& rhs);
};

/** Wrapper class for struct `fz_sha512`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct FzSha512
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzSha512();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_sha384_final()`.  */
	/**
		SHA384 finalization. Ends an SHA384 message-digest operation,
		writing the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha384_final(unsigned char digest[64]) const;

	/** Class-aware wrapper for `::fz_sha384_init()`.  */
	/**
		SHA384 initialization. Begins an SHA384 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha384_init() const;

	/** Class-aware wrapper for `::fz_sha384_update()`.  */
	/**
		SHA384 block update operation. Continues an SHA384 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha384_update(const unsigned char *input, size_t inlen) const;

	/** Class-aware wrapper for `::fz_sha512_final()`.  */
	/**
		SHA512 finalization. Ends an SHA512 message-digest operation,
		writing the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha512_final(unsigned char digest[64]) const;

	/** Class-aware wrapper for `::fz_sha512_init()`.  */
	/**
		SHA512 initialization. Begins an SHA512 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha512_init() const;

	/** Class-aware wrapper for `::fz_sha512_update()`.  */
	/**
		SHA512 block update operation. Continues an SHA512 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void fz_sha512_update(const unsigned char *input, size_t inlen) const;

	/** Constructor using raw copy of pre-existing `::fz_sha512`. */
	FZ_FUNCTION FzSha512(::fz_sha512* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzSha512();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_sha512* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzSha512(const FzSha512& rhs);
	FzSha512& operator=(const FzSha512& rhs);
};

/** Wrapper class for struct `fz_shade`. */
/**
	Structure is public to allow derived classes. Do not
	access the members directly.
*/
struct FzShade
{
	/** Copy constructor using `fz_keep_shade()`. */
	FZ_FUNCTION FzShade(const FzShade& rhs);

	/** operator= using `fz_keep_shade()` and `fz_drop_shade()`. */
	FZ_FUNCTION FzShade& operator=(const FzShade& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzShade();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bound_shade()`.  */
	/**
		Bound a given shading.
	
		shade: The shade to bound.
	
		ctm: The transform to apply to the shade before bounding.
	
		r: Pointer to storage to put the bounds in.
	
		Returns r, updated to contain the bounds for the shading.
	*/
	FZ_FUNCTION FzRect fz_bound_shade(const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_paint_shade()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_paint_shade(::fz_colorspace *override_cs, ::fz_matrix ctm, ::fz_pixmap *dest, ::fz_color_params color_params, ::fz_irect bbox, const ::fz_overprint *eop, ::fz_shade_color_cache **cache)` => 
	 */
	/**
		Render a shade to a given pixmap.
	
		shade: The shade to paint.
	
		override_cs: NULL, or colorspace to override the shades
		inbuilt colorspace.
	
		ctm: The transform to apply.
	
		dest: The pixmap to render into.
	
		color_params: The color rendering settings
	
		bbox: Pointer to a bounding box to limit the rendering
		of the shade.
	
		eop: NULL, or pointer to overprint bitmap.
	
		cache: *cache is used to cache color information. If *cache is NULL it
		is set to point to a new fz_shade_color_cache. If cache is NULL it is
		ignored.
	*/
	FZ_FUNCTION void fz_paint_shade(const FzColorspace& override_cs, const FzMatrix& ctm, const FzPixmap& dest, const FzColorParams& color_params, const FzIrect& bbox, const FzOverprint& eop, FzShadeColorCache& cache) const;

	/** Class-aware wrapper for `::fz_process_shade()`.  */
	/**
		Process a shade, using supplied callback functions. This
		decomposes the shading to a mesh (even ones that are not
		natively meshes, such as linear or radial shadings), and
		processes triangles from those meshes.
	
		shade: The shade to process.
	
		ctm: The transform to use
	
		prepare: Callback function to 'prepare' each vertex.
		This function is passed an array of floats, and populates
		a fz_vertex structure.
	
		process: This function is passed 3 pointers to vertex
		structures, and actually performs the processing (typically
		filling the area between the vertices).
	
		process_arg: An opaque argument passed through from caller
		to callback functions.
	*/
	FZ_FUNCTION void fz_process_shade(const FzMatrix& ctm, const FzRect& scissor, ::fz_shade_prepare_fn *prepare, ::fz_shade_process_fn *process, void *process_arg) const;

	/** Extra wrapper for fz_paint_shade(), passing cache=NULL. */
	FZ_FUNCTION void fz_paint_shade_no_cache( const FzColorspace& override_cs, FzMatrix& ctm, const FzPixmap& dest, FzColorParams& color_params, FzIrect& bbox, const FzOverprint& eop);

	/** Constructor using raw copy of pre-existing `::fz_shade`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_shade* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzShade(::fz_shade* internal);

	/** Destructor using fz_drop_shade(). */
	FZ_FUNCTION ~FzShade();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_shade* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_shade_color_cache`. Not copyable or assignable. */
struct FzShadeColorCache
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzShadeColorCache();

	/** Constructor using raw copy of pre-existing `::fz_shade_color_cache`. */
	FZ_FUNCTION FzShadeColorCache(::fz_shade_color_cache* internal);

	/** Destructor using fz_drop_shade_color_cache(). */
	FZ_FUNCTION ~FzShadeColorCache();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_shade_color_cache* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzShadeColorCache(const FzShadeColorCache& rhs);
	FzShadeColorCache& operator=(const FzShadeColorCache& rhs);
};

/** Wrapper class for struct `fz_shaper_data_t`. Not copyable or assignable. */
/**
	In order to shape a given font, we need to
	declare it to a shaper library (harfbuzz, by default, but others
	are possible). To avoid redeclaring it every time we need to
	shape, we hold a shaper handle and the destructor for it within
	the font itself. The handle is initialised by the caller when
	first required and the destructor is called when the fz_font is
	destroyed.
*/
struct FzShaperDataT
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzShaperDataT();

	/** Constructor using raw copy of pre-existing `::fz_shaper_data_t`. */
	FZ_FUNCTION FzShaperDataT(::fz_shaper_data_t* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzShaperDataT();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_shaper_data_t* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzShaperDataT(const FzShaperDataT& rhs);
	FzShaperDataT& operator=(const FzShaperDataT& rhs);
};

struct FzStextBlockIterator;

/** Wrapper class for struct `fz_stext_block`. */
struct FzStextBlock
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextBlock();

	/* == Methods. */

	/** Returns m_internal.u.i.transform if m_internal->type is FZ_STEXT_BLOCK_IMAGE, else throws. */
	FZ_FUNCTION FzMatrix i_transform();

	/** Returns m_internal.u.i.image if m_internal->type is FZ_STEXT_BLOCK_IMAGE, else throws. */
	FZ_FUNCTION FzImage i_image();

	/** Used for iteration over linked list of FzStextLine items starting at fz_stext_line::u.t.first_line. */
	FZ_FUNCTION FzStextBlockIterator begin();

	/** Used for iteration over linked list of FzStextLine items starting at fz_stext_line::u.t.first_line. */
	FZ_FUNCTION FzStextBlockIterator end();

	/** Constructor using raw copy of pre-existing `::fz_stext_block`. */
	FZ_FUNCTION FzStextBlock(::fz_stext_block* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextBlock();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_block* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	typedef FzStextBlockIterator iterator;
};

/** Wrapper class for struct `fz_stext_char`. */
/**
	Text extraction device: Used for searching, format conversion etc.

	(In development - Subject to change in future versions)
*/
struct FzStextChar
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextChar();

	/** Constructor using raw copy of pre-existing `::fz_stext_char`. */
	FZ_FUNCTION FzStextChar(::fz_stext_char* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextChar();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_char* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_stext_grid_positions`. Not copyable or assignable. */
struct FzStextGridPositions
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextGridPositions();

	/** Constructor using raw copy of pre-existing `::fz_stext_grid_positions`. */
	FZ_FUNCTION FzStextGridPositions(::fz_stext_grid_positions* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextGridPositions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_grid_positions* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStextGridPositions(const FzStextGridPositions& rhs);
	FzStextGridPositions& operator=(const FzStextGridPositions& rhs);
};

struct FzStextLineIterator;

/** Wrapper class for struct `fz_stext_line`. */
struct FzStextLine
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextLine();

	/* == Methods. */

	/** Used for iteration over linked list of FzStextChar items starting at fz_stext_char::first_char. */
	FZ_FUNCTION FzStextLineIterator begin();

	/** Used for iteration over linked list of FzStextChar items starting at fz_stext_char::first_char. */
	FZ_FUNCTION FzStextLineIterator end();

	/** Constructor using raw copy of pre-existing `::fz_stext_line`. */
	FZ_FUNCTION FzStextLine(::fz_stext_line* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextLine();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_line* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	typedef FzStextLineIterator iterator;
};

/** Wrapper class for struct `fz_stext_options`. */
/**
	Options for creating structured text.
*/
struct FzStextOptions
{
	/** Construct with .flags, .scale but no clip. */
	FZ_FUNCTION FzStextOptions(int flags, float scale=1.0);

	/** Construct with .flags, .scale and .clip; FZ_STEXT_CLIP_RECT
	is automatically set in .flags. */
	FZ_FUNCTION FzStextOptions(int flags, fz_rect clip, float scale=1.0);

	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzStextOptions();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_parse_stext_options()`.  */
	/**
		Parse stext device options from a comma separated key-value
		string.
	*/
	FZ_FUNCTION FzStextOptions fz_parse_stext_options(const char *string);

	/** Constructor using raw copy of pre-existing `::fz_stext_options`. */
	FZ_FUNCTION FzStextOptions(const ::fz_stext_options* internal);

	/** Constructor using raw copy of pre-existing `::fz_stext_options`. */
	FZ_FUNCTION FzStextOptions(const ::fz_stext_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_stext_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_stext_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_stext_options. */
	int flags;
	float scale;
	::fz_rect clip;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzStextOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzStextOptions& rhs);
};

struct FzStextPageIterator;

/** Wrapper class for struct `fz_stext_page`. Not copyable or assignable. */
/**
	A text page is a list of blocks, together with an overall
	bounding box.
*/
struct FzStextPage
{
	/** == Constructors. */

	/** Constructor using `fz_new_stext_page()`. */
	/**
		Create an empty text page.
	
		The text page is filled out by the text device to contain the
		blocks and lines of text on the page.
	
		mediabox: optional mediabox information.
	*/
	FZ_FUNCTION FzStextPage(const FzRect& mediabox);

	/** Constructor using `fz_new_stext_page_from_chapter_page_number()`. */
	FZ_FUNCTION FzStextPage(const FzDocument& doc, int chapter, int number, FzStextOptions& options);

	/** Constructor using `fz_new_stext_page_from_display_list()`. */
	FZ_FUNCTION FzStextPage(const FzDisplayList& list, FzStextOptions& options);

	/** Constructor using `fz_new_stext_page_from_page()`. */
	/**
		Extract text from page.
	
		Ownership of the fz_stext_page is returned to the caller.
	*/
	FZ_FUNCTION FzStextPage(const FzPage& page, FzStextOptions& options);

	/** Constructor using `fz_new_stext_page_from_page_number()`. */
	FZ_FUNCTION FzStextPage(const FzDocument& doc, int number, FzStextOptions& options);

	/** Constructor using `pdf_new_stext_page_from_annot()`. */
	FZ_FUNCTION FzStextPage(const PdfAnnot& annot, FzStextOptions& options);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextPage();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_find_table_within_bounds()`.  */
	/**
		Interpret the bounded contents of a given stext page as
		a table.
	
		The page contents will be rewritten to contain a Table
		structure with the identified content in it.
	
		This uses the same logic as for fz_table_hunt, without the
		actual hunting. fz_table_hunt hunts to find possible bounds
		for multiple tables on the page; this routine just finds a
		single table contained within the given rectangle.
	
		Returns the stext_block list that contains the content of
		the table.
	*/
	FZ_FUNCTION FzStextBlock fz_find_table_within_bounds(const FzRect& bounds) const;

	/** Class-aware wrapper for `::fz_highlight_selection()`.  */
	/**
		Return a list of quads to highlight lines inside the selection
		points.
	*/
	FZ_FUNCTION int fz_highlight_selection(const FzPoint& a, const FzPoint& b, FzQuad& quads, int max_quads) const;

	/** Class-aware wrapper for `::fz_highlight_selection2()`.  */
	/**
	C++ alternative to fz_highlight_selection() that returns quads in a
	std::vector.
	*/
	FZ_FUNCTION std::vector<fz_quad> fz_highlight_selection2(const FzPoint& a, const FzPoint& b, int max_quads) const;

	/** Class-aware wrapper for `::fz_new_buffer_from_stext_page()`.  */
	/**
		Convert structured text into plain text.
	*/
	FZ_FUNCTION FzBuffer fz_new_buffer_from_stext_page() const;

	/** Class-aware wrapper for `::fz_new_stext_device()`.  */
	/**
		Create a device to extract the text on a page.
	
		Gather the text on a page into blocks and lines.
	
		The reading order is taken from the order the text is drawn in
		the source file, so may not be accurate.
	
		page: The text page to which content should be added. This will
		usually be a newly created (empty) text page, but it can be one
		containing data already (for example when merging multiple
		pages, or watermarking).
	
		options: Options to configure the stext device.
	*/
	FZ_FUNCTION FzDevice fz_new_stext_device(FzStextOptions& options) const;

	/** Class-aware wrapper for `::fz_paragraph_break()`.  */
	/**
		Attempt to break paragraphs at plausible places.
	*/
	FZ_FUNCTION void fz_paragraph_break() const;

	/** Class-aware wrapper for `::fz_search_stext_page()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_search_stext_page(const char *needle, ::fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	/**
		Search for occurrence of 'needle' in text page.
	
		Return the number of quads and store hit quads in the passed in
		array.
	
		NOTE: This is an experimental interface and subject to change
		without notice.
	*/
	FZ_FUNCTION int fz_search_stext_page(const char *needle, int *hit_mark, FzQuad& hit_bbox, int hit_max) const;

	/** Class-aware wrapper for `::fz_search_stext_page_cb()`.  */
	/**
		Search for occurrence of 'needle' in text page.
	
		Call callback once for each hit. This callback will receive
		(potentially) multiple quads for each hit.
	
		Returns the number of hits - note that this is potentially
		different from (i.e. is not greater than) the number of quads
		as returned by the non callback API.
	
		NOTE: This is an experimental interface and subject to change
		without notice.
	*/
	FZ_FUNCTION int fz_search_stext_page_cb(const char *needle, ::fz_search_callback_fn *cb, void *opaque) const;

	/** Class-aware wrapper for `::fz_segment_stext_page()`.  */
	/**
		Perform segmentation analysis on an (unstructured) page to look for
		recursive subdivisions.
	
		Essentially this code attempts to split the page horizontally and/or
		vertically repeatedly into smaller and smaller "segments" (divisions).
	
		Returns 0 if no changes were made to the document.
	
		This is experimental code, and may change (or be removed) in future
		versions!
	*/
	FZ_FUNCTION int fz_segment_stext_page() const;

	/** Class-aware wrapper for `::fz_snap_selection()`.  */
	FZ_FUNCTION FzQuad fz_snap_selection(FzPoint& ap, FzPoint& bp, int mode) const;

	/** Class-aware wrapper for `::fz_table_hunt()`.  */
	/**
		Hunt for possible tables on a page, and update the stext with
		information.
	*/
	FZ_FUNCTION void fz_table_hunt() const;

	/** Wrapper for fz_copy_selection() that returns std::string. */
	FZ_FUNCTION std::string fz_copy_selection(FzPoint& a, FzPoint& b, int crlf);

	/** Wrapper for fz_copy_rectangle() that returns a std::string. */
	FZ_FUNCTION std::string fz_copy_rectangle(FzRect& area, int crlf);

	/** Wrapper for fz_search_stext_page() that returns std::vector of Quads. */
	FZ_FUNCTION std::vector<FzQuad> search_stext_page(const char* needle, int *hit_mark, int max_quads);

	/** Used for iteration over linked list of FzStextBlock items starting at fz_stext_block::first_block. */
	FZ_FUNCTION FzStextPageIterator begin();

	/** Used for iteration over linked list of FzStextBlock items starting at fz_stext_block::first_block. */
	FZ_FUNCTION FzStextPageIterator end();

	/** Constructor using raw copy of pre-existing `::fz_stext_page`. */
	FZ_FUNCTION FzStextPage(::fz_stext_page* internal);

	/** Destructor using fz_drop_stext_page(). */
	FZ_FUNCTION ~FzStextPage();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_page* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	typedef FzStextPageIterator iterator;

	private:

	/** This class is not copyable or assignable. */
	FzStextPage(const FzStextPage& rhs);
	FzStextPage& operator=(const FzStextPage& rhs);
};

/** Wrapper class for struct `fz_stext_struct`. Not copyable or assignable. */
struct FzStextStruct
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStextStruct();

	/** Constructor using raw copy of pre-existing `::fz_stext_struct`. */
	FZ_FUNCTION FzStextStruct(::fz_stext_struct* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStextStruct();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stext_struct* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStextStruct(const FzStextStruct& rhs);
	FzStextStruct& operator=(const FzStextStruct& rhs);
};

/** Wrapper class for struct `fz_storable`. */
/**
	Resource store

	MuPDF stores decoded "objects" into a store for potential reuse.
	If the size of the store gets too big, objects stored within it
	can be evicted and freed to recover space. When MuPDF comes to
	decode such an object, it will check to see if a version of this
	object is already in the store - if it is, it will simply reuse
	it. If not, it will decode it and place it into the store.

	All objects that can be placed into the store are derived from
	the fz_storable type (i.e. this should be the first component of
	the objects structure). This allows for consistent (thread safe)
	reference counting, and includes a function that will be called
	to free the object as soon as the reference count reaches zero.

	Most objects offer fz_keep_XXXX/fz_drop_XXXX functions derived
	from fz_keep_storable/fz_drop_storable. Creation of such objects
	includes a call to FZ_INIT_STORABLE to set up the fz_storable
	header.
 */
struct FzStorable
{
	/** Copy constructor using `fz_keep_storable()`. */
	FZ_FUNCTION FzStorable(const FzStorable& rhs);

	/** operator= using `fz_keep_storable()` and `fz_drop_storable()`. */
	FZ_FUNCTION FzStorable& operator=(const FzStorable& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStorable();

	/** Constructor using raw copy of pre-existing `::fz_storable`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_storable* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzStorable(::fz_storable* internal);

	/** Destructor using fz_drop_storable(). */
	FZ_FUNCTION ~FzStorable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_storable* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_store`. Not copyable or assignable. */
struct FzStore
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStore();

	/** Constructor using raw copy of pre-existing `::fz_store`. */
	FZ_FUNCTION FzStore(::fz_store* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStore();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_store* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStore(const FzStore& rhs);
	FzStore& operator=(const FzStore& rhs);
};

/** Wrapper class for struct `fz_store_hash`. Not copyable or assignable. */
/**
	The store can be seen as a dictionary that maps keys to
	fz_storable values. In order to allow keys of different types to
	be stored, we have a structure full of functions for each key
	'type'; this fz_store_type pointer is stored with each key, and
	tells the store how to perform certain operations (like taking/
	dropping a reference, comparing two keys, outputting details for
	debugging etc).

	The store uses a hash table internally for speed where possible.
	In order for this to work, we need a mechanism for turning a
	generic 'key' into 'a hashable string'. For this purpose the
	type structure contains a make_hash_key function pointer that
	maps from a void * to a fz_store_hash structure. If
	make_hash_key function returns 0, then the key is determined not
	to be hashable, and the value is not stored in the hash table.

	Some objects can be used both as values within the store, and as
	a component of keys within the store. We refer to these objects
	as "key storable" objects. In this case, we need to take
	additional care to ensure that we do not end up keeping an item
	within the store, purely because its value is referred to by
	another key in the store.

	An example of this are fz_images in PDF files. Each fz_image is
	placed into the	store to enable it to be easily reused. When the
	image is rendered, a pixmap is generated from the image, and the
	pixmap is placed into the store so it can be reused on
	subsequent renders. The image forms part of the key for the
	pixmap.

	When we close the pdf document (and any associated pages/display
	lists etc), we drop the images from the store. This may leave us
	in the position of the images having non-zero reference counts
	purely because they are used as part of the keys for the
	pixmaps.

	We therefore use special reference counting functions to keep
	track of these "key storable" items, and hence store the number
	of references to these items that are used in keys.

	When the number of references to an object == the number of
	references to an object from keys in the store, we know that we
	can remove all the items which have that object as part of the
	key. This is done by running a pass over the store, 'reaping'
	those items.

	Reap passes are slower than we would like as they touch every
	item in the store. We therefore provide a way to 'batch' such
	reap passes together, using fz_defer_reap_start/
	fz_defer_reap_end to bracket a region in which many may be
	triggered.
*/
struct FzStoreHash
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStoreHash();

	/** Constructor using raw copy of pre-existing `::fz_store_hash`. */
	FZ_FUNCTION FzStoreHash(::fz_store_hash* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStoreHash();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_store_hash* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStoreHash(const FzStoreHash& rhs);
	FzStoreHash& operator=(const FzStoreHash& rhs);
};

/** Wrapper class for struct `fz_store_type`. Not copyable or assignable. */
/**
	Every type of object to be placed into the store defines an
	fz_store_type. This contains the pointers to functions to
	make hashes, manipulate keys, and check for needing reaping.
*/
struct FzStoreType
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStoreType();

	/** Constructor using raw copy of pre-existing `::fz_store_type`. */
	FZ_FUNCTION FzStoreType(::fz_store_type* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStoreType();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_store_type* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStoreType(const FzStoreType& rhs);
	FzStoreType& operator=(const FzStoreType& rhs);
};

/** Wrapper class for struct `fz_story`. Not copyable or assignable. */
struct FzStory
{
	/** == Constructors. */

	/** Constructor using `fz_new_story()`. */
	FZ_FUNCTION FzStory(const FzBuffer& buf, const char *user_css, float em, const FzArchive& dir);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStory();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_draw_story()`.  */
	FZ_FUNCTION void fz_draw_story(const FzDevice& dev, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_place_story()`.  */
	FZ_FUNCTION int fz_place_story(const FzRect& where, FzRect& filled) const;

	/** Class-aware wrapper for `::fz_place_story_flags()`.  */
	FZ_FUNCTION int fz_place_story_flags(const FzRect& where, FzRect& filled, int flags) const;

	/** Class-aware wrapper for `::fz_reset_story()`.  */
	FZ_FUNCTION void fz_reset_story() const;

	/** Class-aware wrapper for `::fz_story_document()`.  */
	FZ_FUNCTION FzXml fz_story_document() const;

	/** Class-aware wrapper for `::fz_story_positions()`.  */
	FZ_FUNCTION void fz_story_positions(::fz_story_position_callback *cb, void *arg) const;

	/** Class-aware wrapper for `::fz_story_warnings()`.  */
	FZ_FUNCTION const char *fz_story_warnings() const;

	/** Constructor using raw copy of pre-existing `::fz_story`. */
	FZ_FUNCTION FzStory(::fz_story* internal);

	/** Destructor using fz_drop_story(). */
	FZ_FUNCTION ~FzStory();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_story* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStory(const FzStory& rhs);
	FzStory& operator=(const FzStory& rhs);
};

/** Wrapper class for struct `fz_story_element_position`. */
struct FzStoryElementPosition
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzStoryElementPosition();

	/** Constructor using raw copy of pre-existing `::fz_story_element_position`. */
	FZ_FUNCTION FzStoryElementPosition(const ::fz_story_element_position* internal);

	/** Constructor using raw copy of pre-existing `::fz_story_element_position`. */
	FZ_FUNCTION FzStoryElementPosition(const ::fz_story_element_position internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_story_element_position* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_story_element_position* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStoryElementPosition();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_story_element_position. */
	int depth;
	int heading;
	const char *id;
	const char *href;
	::fz_rect rect;
	const char *text;
	int open_close;
	int rectangle_num;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzStoryElementPosition& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzStoryElementPosition& rhs);
};

/** Wrapper class for struct `fz_stream`. */
/**
	fz_stream is a buffered reader capable of seeking in both
	directions.

	Streams are reference counted, so references must be dropped
	by a call to fz_drop_stream.

	Only the data between rp and wp is valid.
*/
struct FzStream
{
	/** == Constructors. */

	/** Constructor using `fz_new_stream()`. */
	/**
		Create a new stream object with the given
		internal state and function pointers.
	
		state: Internal state (opaque to everything but implementation).
	
		next: Should provide the next set of bytes (up to max) of stream
		data. Return the number of bytes read, or EOF when there is no
		more data.
	
		drop: Should clean up and free the internal state. May not
		throw exceptions.
	*/
	FZ_FUNCTION FzStream(void *state, ::fz_stream_next_fn *next, ::fz_stream_drop_fn *drop);

	/** Constructor using `fz_open_file()`. */
	/**
		Open the named file and wrap it in a stream.
	
		filename: Path to a file. On non-Windows machines the filename
		should be exactly as it would be passed to fopen(2). On Windows
		machines, the path should be UTF-8 encoded so that non-ASCII
		characters can be represented. Other platforms do the encoding
		as standard anyway (and in most cases, particularly for MacOS
		and Linux, the encoding they use is UTF-8 anyway).
	*/
	FZ_FUNCTION FzStream(const char *filename);

	/** Constructor using `fz_open_file_ptr_no_close()`. */
	/**
		Create a stream from a FILE * that will not be closed
		when the stream is dropped.
	*/
	FZ_FUNCTION FzStream(FILE *file);

	/** Constructor using `fz_open_memory()`. */
	/**
		Open a block of memory as a stream.
	
		data: Pointer to start of data block. Ownership of the data
		block is NOT passed in.
	
		len: Number of bytes in data block.
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION FzStream(const unsigned char *data, size_t len);

	/** Construct using fz_open_file(). */
	FZ_FUNCTION FzStream(const std::string& filename);

	/** Copy constructor using `fz_keep_stream()`. */
	FZ_FUNCTION FzStream(const FzStream& rhs);

	/** operator= using `fz_keep_stream()` and `fz_drop_stream()`. */
	FZ_FUNCTION FzStream& operator=(const FzStream& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStream();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_open_file_autodelete()`.  */
	/**
		Do the same as fz_open_file, but delete the file upon close.
	*/
	FZ_FUNCTION static FzStream fz_open_file_autodelete(const char *filename);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_available()`.  */
	/**
		Ask how many bytes are available immediately from
		a given stream.
	
		stm: The stream to read from.
	
		max: A hint for the underlying stream; the maximum number of
		bytes that we are sure we will want to read. If you do not know
		this number, give 1.
	
		Returns the number of bytes immediately available between the
		read and write pointers. This number is guaranteed only to be 0
		if we have hit EOF. The number of bytes returned here need have
		no relation to max (could be larger, could be smaller).
	*/
	FZ_FUNCTION size_t fz_available(size_t max) const;

	/** Class-aware wrapper for `::fz_decomp_image_from_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_decomp_image_from_stream(::fz_compressed_image *image, ::fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
	 */
	/**
		Decode a subarea of a compressed image. l2factor is the amount
		of subsampling inbuilt to the stream (i.e. performed by the
		decoder). If non NULL, l2extra is the extra amount of
		subsampling that should be performed by this routine. This will
		be updated on exit to the amount of subsampling that is still
		required to be done.
	
		Returns a kept reference.
	*/
	FZ_FUNCTION FzPixmap fz_decomp_image_from_stream(const FzCompressedImage& image, FzIrect& subarea, int indexed, int l2factor, int *l2extra) const;

	/** Class-aware wrapper for `::fz_is_cfb_archive()`.  */
	/**
		Detect if stream object is a cfb archive.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int fz_is_cfb_archive() const;

	/** Class-aware wrapper for `::fz_is_eof()`.  */
	/**
		Query if the stream has reached EOF (during normal bytewise
		reading).
	
		See fz_is_eof_bits for the equivalent function for bitwise
		reading.
	*/
	FZ_FUNCTION int fz_is_eof() const;

	/** Class-aware wrapper for `::fz_is_eof_bits()`.  */
	/**
		Query if the stream has reached EOF (during bitwise
		reading).
	
		See fz_is_eof for the equivalent function for bytewise
		reading.
	*/
	FZ_FUNCTION int fz_is_eof_bits() const;

	/** Class-aware wrapper for `::fz_is_libarchive_archive()`.  */
	/**
		Detect if stream object is an archive supported by libarchive.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int fz_is_libarchive_archive() const;

	/** Class-aware wrapper for `::fz_is_tar_archive()`.  */
	/**
		Detect if stream object is a tar archive.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int fz_is_tar_archive() const;

	/** Class-aware wrapper for `::fz_is_zip_archive()`.  */
	/**
		Detect if stream object is a zip archive.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int fz_is_zip_archive() const;

	/** Class-aware wrapper for `::fz_new_archive_of_size()`.  */
	FZ_FUNCTION FzArchive fz_new_archive_of_size(int size) const;

	/** Class-aware wrapper for `::fz_open_a85d()`.  */
	/**
		a85d filter performs ASCII 85 Decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION FzStream fz_open_a85d() const;

	/** Class-aware wrapper for `::fz_open_aesd()`.  */
	/**
		aesd filter performs AES decoding of data read from the chained
		filter using the supplied key.
	*/
	FZ_FUNCTION FzStream fz_open_aesd(unsigned char *key, unsigned int keylen) const;

	/** Class-aware wrapper for `::fz_open_ahxd()`.  */
	/**
		ahxd filter performs ASCII Hex decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION FzStream fz_open_ahxd() const;

	/** Class-aware wrapper for `::fz_open_arc4()`.  */
	/**
		arc4 filter performs RC4 decoding of data read from the chained
		filter using the supplied key.
	*/
	FZ_FUNCTION FzStream fz_open_arc4(unsigned char *key, unsigned int keylen) const;

	/** Class-aware wrapper for `::fz_open_archive_with_stream()`.  */
	/**
		Open zip or tar archive stream.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	*/
	FZ_FUNCTION FzArchive fz_open_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_open_brotlid()`.  */
	/**
		brotlid filter performs Brotli decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION FzStream fz_open_brotlid() const;

	/** Class-aware wrapper for `::fz_open_cfb_archive_with_stream()`.  */
	/**
		Open a cfb file as an archive.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	
		An exception is thrown if the file is not recognised as a chm.
	*/
	FZ_FUNCTION FzArchive fz_open_cfb_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_open_dctd()`.  */
	/**
		dctd filter performs DCT (JPEG) decoding of data read
		from the chained filter.
	
		color_transform implements the PDF color_transform option
			use -1 for default behavior
			use 0 to disable YUV-RGB / YCCK-CMYK transforms
			use 1 to enable YUV-RGB / YCCK-CMYK transforms
	
		invert_cmyk implements the necessary inversion for Photoshop CMYK images
			use 0 if embedded in PDF
			use 1 if not embedded in PDF
	
		For subsampling on decode, set l2factor to the log2 of the
		reduction required (therefore 0 = full size decode).
	
		jpegtables is an optional stream from which the JPEG tables
		can be read. Use NULL if not required.
	*/
	FZ_FUNCTION FzStream fz_open_dctd(int color_transform, int invert_cmyk, int l2factor, const FzStream& jpegtables) const;

	/** Class-aware wrapper for `::fz_open_endstream_filter()`.  */
	/**
		The endstream filter reads a PDF substream, and starts to look
		for an 'endstream' token after the specified length.
	*/
	FZ_FUNCTION FzStream fz_open_endstream_filter(uint64_t len, int64_t offset) const;

	/** Class-aware wrapper for `::fz_open_faxd()`.  */
	/**
		faxd filter performs FAX decoding of data read from
		the chained filter.
	
		k: see fax specification (fax default is 0).
	
		end_of_line: whether we expect end of line markers (fax default
		is 0).
	
		encoded_byte_align: whether we align to bytes after each line
		(fax default is 0).
	
		columns: how many columns in the image (fax default is 1728).
	
		rows: 0 for unspecified or the number of rows of data to expect.
	
		end_of_block: whether we expect end of block markers (fax
		default is 1).
	
		black_is_1: determines the polarity of the image (fax default is
		0).
	*/
	FZ_FUNCTION FzStream fz_open_faxd(int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1) const;

	/** Class-aware wrapper for `::fz_open_flated()`.  */
	/**
		flated filter performs LZ77 decoding (inflating) of data read
		from the chained filter.
	
		window_bits: How large a decompression window to use. Typically
		15. A negative number, -n, means to use n bits, but to expect
		raw data with no header.
	*/
	FZ_FUNCTION FzStream fz_open_flated(int window_bits) const;

	/** Class-aware wrapper for `::fz_open_image_decomp_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_open_image_decomp_stream(::fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
	 */
	/**
		Open a stream to read the decompressed version of another stream
		with optional log2 subsampling.
	*/
	FZ_FUNCTION FzStream fz_open_image_decomp_stream(const FzCompressionParams& arg_1, int *l2factor) const;

	/** Class-aware wrapper for `::fz_open_jbig2d()`.  */
	/**
		Open a filter that performs jbig2 decompression on the chained
		stream, using the optional globals record.
	*/
	FZ_FUNCTION FzStream fz_open_jbig2d(const FzJbig2Globals& globals, int embedded) const;

	/** Class-aware wrapper for `::fz_open_leecher()`.  */
	/**
		Attach a filter to a stream that will store any
		characters read from the stream into the supplied buffer.
	
		chain: The underlying stream to leech from.
	
		buf: The buffer into which the read data should be appended.
		The buffer will be resized as required.
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION FzStream fz_open_leecher(const FzBuffer& buf) const;

	/** Class-aware wrapper for `::fz_open_libarchive_archive_with_stream()`.  */
	/**
		Open an archive using libarchive.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	
		An exception is thrown if the stream is not supported by libarchive.
	*/
	FZ_FUNCTION FzArchive fz_open_libarchive_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_open_libarchived()`.  */
	/**
		libarchived filter performs generic compressed decoding of data
		in any format understood by libarchive from the chained filter.
	
		This will throw an exception if libarchive is not built in, or
		if the compression format is not recognised.
	*/
	FZ_FUNCTION FzStream fz_open_libarchived() const;

	/** Class-aware wrapper for `::fz_open_lzwd()`.  */
	/**
		lzwd filter performs LZW decoding of data read from the chained
		filter.
	
		early_change: (Default 1) specifies whether to change codes 1
		bit early.
	
		min_bits: (Default 9) specifies the minimum number of bits to
		use.
	
		reverse_bits: (Default 0) allows for compatibility with gif and
		old style tiffs (1).
	
		old_tiff: (Default 0) allows for different handling of the clear
		code, as found in old style tiffs.
	*/
	FZ_FUNCTION FzStream fz_open_lzwd(int early_change, int min_bits, int reverse_bits, int old_tiff) const;

	/** Class-aware wrapper for `::fz_open_null_filter()`.  */
	/**
		The null filter reads a specified amount of data from the
		substream.
	*/
	FZ_FUNCTION FzStream fz_open_null_filter(uint64_t len, int64_t offset) const;

	/** Class-aware wrapper for `::fz_open_predict()`.  */
	/**
		predict filter performs pixel prediction on data read from
		the chained filter.
	
		predictor: 1 = copy, 2 = tiff, other = inline PNG predictor
	
		columns: width of image in pixels
	
		colors: number of components.
	
		bpc: bits per component (typically 8)
	*/
	FZ_FUNCTION FzStream fz_open_predict(int predictor, int columns, int colors, int bpc) const;

	/** Class-aware wrapper for `::fz_open_range_filter()`.  */
	/**
		The range filter copies data from specified ranges of the
		chained stream.
	*/
	FZ_FUNCTION FzStream fz_open_range_filter(const FzRange& ranges, int nranges) const;

	/** Class-aware wrapper for `::fz_open_rld()`.  */
	/**
		rld filter performs Run Length Decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION FzStream fz_open_rld() const;

	/** Class-aware wrapper for `::fz_open_sgilog16()`.  */
	/**
		SGI Log 16bit (greyscale) decode from the chained filter.
		Decodes lines of w pixels to 8bpp greyscale.
	*/
	FZ_FUNCTION FzStream fz_open_sgilog16(int w) const;

	/** Class-aware wrapper for `::fz_open_sgilog24()`.  */
	/**
		SGI Log 24bit (LUV) decode from the chained filter.
		Decodes lines of w pixels to 8bpc rgb.
	*/
	FZ_FUNCTION FzStream fz_open_sgilog24(int w) const;

	/** Class-aware wrapper for `::fz_open_sgilog32()`.  */
	/**
		SGI Log 32bit (LUV) decode from the chained filter.
		Decodes lines of w pixels to 8bpc rgb.
	*/
	FZ_FUNCTION FzStream fz_open_sgilog32(int w) const;

	/** Class-aware wrapper for `::fz_open_tar_archive_with_stream()`.  */
	/**
		Open a tar archive stream.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	
		An exception is thrown if the stream is not a tar archive as
		indicated by the presence of a tar signature.
	
	*/
	FZ_FUNCTION FzArchive fz_open_tar_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_open_thunder()`.  */
	/**
		4bit greyscale Thunderscan decoding from the chained filter.
		Decodes lines of w pixels to 8bpp greyscale.
	*/
	FZ_FUNCTION FzStream fz_open_thunder(int w) const;

	/** Class-aware wrapper for `::fz_open_zip_archive_with_stream()`.  */
	/**
		Open a zip archive stream.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	
		An exception is thrown if the stream is not a zip archive as
		indicated by the presence of a zip signature.
	
	*/
	FZ_FUNCTION FzArchive fz_open_zip_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_parse_xml_stream()`.  */
	/**
		Parse the contents of buffer into a tree of xml nodes.
	
		preserve_white: whether to keep or delete all-whitespace nodes.
	*/
	FZ_FUNCTION FzXml fz_parse_xml_stream(int preserve_white) const;

	/** Class-aware wrapper for `::fz_peek_byte()`.  */
	/**
		Peek at the next byte in a stream.
	
		stm: The stream to peek at.
	
		Returns -1 for EOF, or the next byte that will be read.
	*/
	FZ_FUNCTION int fz_peek_byte() const;

	/** Class-aware wrapper for `::fz_read()`.  */
	/**
		Read from a stream into a given data block.
	
		stm: The stream to read from.
	
		data: The data block to read into.
	
		len: The length of the data block (in bytes).
	
		Returns the number of bytes read. May throw exceptions.
	*/
	FZ_FUNCTION size_t fz_read(unsigned char *data, size_t len) const;

	/** Class-aware wrapper for `::fz_read_all()`.  */
	/**
		Read all of a stream into a buffer.
	
		stm: The stream to read from
	
		initial: Suggested initial size for the buffer.
	
		Returns a buffer created from reading from the stream. May throw
		exceptions on failure to allocate.
	*/
	FZ_FUNCTION FzBuffer fz_read_all(size_t initial) const;

	/** Class-aware wrapper for `::fz_read_best()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_read_best(size_t initial, size_t worst_case)` => `(fz_buffer *, int truncated)`
	 */
	/**
		Attempt to read a stream into a buffer. If truncated
		is NULL behaves as fz_read_all, sets a truncated flag in case of
		error.
	
		stm: The stream to read from.
	
		initial: Suggested initial size for the buffer.
	
		truncated: Flag to store success/failure indication in.
	
		worst_case: 0 for unknown, otherwise an upper bound for the
		size of the stream.
	
		Returns a buffer created from reading from the stream.
	*/
	FZ_FUNCTION FzBuffer fz_read_best(size_t initial, int *truncated, size_t worst_case) const;

	/** Class-aware wrapper for `::fz_read_bits()`.  */
	/**
		Read the next n bits from a stream (assumed to
		be packed most significant bit first).
	
		stm: The stream to read from.
	
		n: The number of bits to read, between 1 and 8*sizeof(int)
		inclusive.
	
		Returns -1 for EOF, or the required number of bits.
	*/
	FZ_FUNCTION unsigned int fz_read_bits(int n) const;

	/** Class-aware wrapper for `::fz_read_byte()`.  */
	/**
		Read the next byte from a stream.
	
		stm: The stream t read from.
	
		Returns -1 for end of stream, or the next byte. May
		throw exceptions.
	*/
	FZ_FUNCTION int fz_read_byte() const;

	/** Class-aware wrapper for `::fz_read_float()`.  */
	FZ_FUNCTION float fz_read_float() const;

	/** Class-aware wrapper for `::fz_read_float_le()`.  */
	FZ_FUNCTION float fz_read_float_le() const;

	/** Class-aware wrapper for `::fz_read_int16()`.  */
	FZ_FUNCTION int16_t fz_read_int16() const;

	/** Class-aware wrapper for `::fz_read_int16_le()`.  */
	FZ_FUNCTION int16_t fz_read_int16_le() const;

	/** Class-aware wrapper for `::fz_read_int32()`.  */
	FZ_FUNCTION int32_t fz_read_int32() const;

	/** Class-aware wrapper for `::fz_read_int32_le()`.  */
	FZ_FUNCTION int32_t fz_read_int32_le() const;

	/** Class-aware wrapper for `::fz_read_int64()`.  */
	FZ_FUNCTION int64_t fz_read_int64() const;

	/** Class-aware wrapper for `::fz_read_int64_le()`.  */
	FZ_FUNCTION int64_t fz_read_int64_le() const;

	/** Class-aware wrapper for `::fz_read_line()`.  */
	/**
		Read a line from stream into the buffer until either a
		terminating newline or EOF, which it replaces with a null byte
		('\0').
	
		Returns buf on success, and NULL when end of file occurs while
		no characters have been read.
	*/
	FZ_FUNCTION char *fz_read_line(char *buf, size_t max) const;

	/** Class-aware wrapper for `::fz_read_rbits()`.  */
	/**
		Read the next n bits from a stream (assumed to
		be packed least significant bit first).
	
		stm: The stream to read from.
	
		n: The number of bits to read, between 1 and 8*sizeof(int)
		inclusive.
	
		Returns (unsigned int)-1 for EOF, or the required number of bits.
	*/
	FZ_FUNCTION unsigned int fz_read_rbits(int n) const;

	/** Class-aware wrapper for `::fz_read_rune()`.  */
	/**
		Read a utf-8 rune from a stream.
	
		In the event of encountering badly formatted utf-8 codes
		(such as a leading code with an unexpected number of following
		codes) no error/exception is given, but undefined values may be
		returned.
	*/
	FZ_FUNCTION int fz_read_rune() const;

	/** Class-aware wrapper for `::fz_read_string()`.  */
	/**
		Read a null terminated string from the stream into
		a buffer of a given length. The buffer will be null terminated.
		Throws on failure (including the failure to fit the entire
		string including the terminator into the buffer).
	*/
	FZ_FUNCTION void fz_read_string(char *buffer, int len) const;

	/** Class-aware wrapper for `::fz_read_uint16()`.  */
	/**
		fz_read_[u]int(16|24|32|64)(_le)?
	
		Read a 16/32/64 bit signed/unsigned integer from stream,
		in big or little-endian byte orders.
	
		Throws an exception if EOF is encountered.
	*/
	FZ_FUNCTION uint16_t fz_read_uint16() const;

	/** Class-aware wrapper for `::fz_read_uint16_le()`.  */
	FZ_FUNCTION uint16_t fz_read_uint16_le() const;

	/** Class-aware wrapper for `::fz_read_uint24()`.  */
	FZ_FUNCTION uint32_t fz_read_uint24() const;

	/** Class-aware wrapper for `::fz_read_uint24_le()`.  */
	FZ_FUNCTION uint32_t fz_read_uint24_le() const;

	/** Class-aware wrapper for `::fz_read_uint32()`.  */
	FZ_FUNCTION uint32_t fz_read_uint32() const;

	/** Class-aware wrapper for `::fz_read_uint32_le()`.  */
	FZ_FUNCTION uint32_t fz_read_uint32_le() const;

	/** Class-aware wrapper for `::fz_read_uint64()`.  */
	FZ_FUNCTION uint64_t fz_read_uint64() const;

	/** Class-aware wrapper for `::fz_read_uint64_le()`.  */
	FZ_FUNCTION uint64_t fz_read_uint64_le() const;

	/** Class-aware wrapper for `::fz_read_utf16_be()`.  */
	FZ_FUNCTION int fz_read_utf16_be() const;

	/** Class-aware wrapper for `::fz_read_utf16_le()`.  */
	/**
		Read a utf-16 rune from a stream. (little endian and
		big endian respectively).
	
		In the event of encountering badly formatted utf-16 codes
		(mismatched surrogates) no error/exception is given, but
		undefined values may be returned.
	*/
	FZ_FUNCTION int fz_read_utf16_le() const;

	/* Class-aware wrapper for `fz_recognize_document_stream_and_dir_content()`
	is not available because returned wrapper class for `fz_document_handler`
	is non-copyable. */

	/* Class-aware wrapper for `fz_recognize_document_stream_content()`
	is not available because returned wrapper class for `fz_document_handler`
	is non-copyable. */

	/** Class-aware wrapper for `::fz_seek()`.  */
	/**
		Seek within a stream.
	
		stm: The stream to seek within.
	
		offset: The offset to seek to.
	
		whence: From where the offset is measured (see fseek).
		SEEK_SET - start of stream.
		SEEK_CUR - current position.
		SEEK_END - end of stream.
	
	*/
	FZ_FUNCTION void fz_seek(int64_t offset, int whence) const;

	/** Class-aware wrapper for `::fz_skip()`.  */
	/**
		Read from a stream discarding data.
	
		stm: The stream to read from.
	
		len: The number of bytes to read.
	
		Returns the number of bytes read. May throw exceptions.
	*/
	FZ_FUNCTION size_t fz_skip(size_t len) const;

	/** Class-aware wrapper for `::fz_skip_space()`.  */
	/**
		Skip over whitespace (bytes <= 32) in a stream.
	*/
	FZ_FUNCTION void fz_skip_space() const;

	/** Class-aware wrapper for `::fz_skip_string()`.  */
	/**
		Skip over a given string in a stream. Return 0 if successfully
		skipped, non-zero otherwise. As many characters will be skipped
		over as matched in the string.
	*/
	FZ_FUNCTION int fz_skip_string(const char *str) const;

	/** Class-aware wrapper for `::fz_stream_filename()`.  */
	/**
		Return the filename (UTF-8 encoded) from which a stream was opened.
	
		Returns NULL if the filename is not available (or the stream was
		opened from a source other than a file).
	*/
	FZ_FUNCTION const char *fz_stream_filename() const;

	/** Class-aware wrapper for `::fz_sync_bits()`.  */
	/**
		Called after reading bits to tell the stream
		that we are about to return to reading bytewise. Resyncs
		the stream to whole byte boundaries.
	*/
	FZ_FUNCTION void fz_sync_bits() const;

	/** Class-aware wrapper for `::fz_tell()`.  */
	/**
		return the current reading position within a stream
	*/
	FZ_FUNCTION int64_t fz_tell() const;

	/** Class-aware wrapper for `::fz_try_open_archive_with_stream()`.  */
	/**
		Open zip or tar archive stream.
	
		Does the same as fz_open_archive_with_stream, but will not throw
		an error in the event of failing to recognise the format. Will
		still throw errors in other cases though!
	*/
	FZ_FUNCTION FzArchive fz_try_open_archive_with_stream() const;

	/** Class-aware wrapper for `::fz_unpack_stream()`.  */
	FZ_FUNCTION FzStream fz_unpack_stream(int depth, int w, int h, int n, int indexed, int pad, int skip) const;

	/** Class-aware wrapper for `::fz_unread_byte()`.  */
	/**
		Unread the single last byte successfully
		read from a stream. Do not call this without having
		successfully read a byte.
	
		stm: The stream to operate upon.
	*/
	FZ_FUNCTION void fz_unread_byte() const;

	/** Class-aware wrapper for `::pdf_load_cmap()`.  */
	FZ_FUNCTION PdfCmap pdf_load_cmap() const;

	/** Class-aware wrapper for `::pdf_open_crypt()`.  */
	FZ_FUNCTION FzStream pdf_open_crypt(const PdfCrypt& crypt, int num, int gen) const;

	/** Class-aware wrapper for `::pdf_open_crypt_with_filter()`.  */
	FZ_FUNCTION FzStream pdf_open_crypt_with_filter(const PdfCrypt& crypt, const PdfObj& name, int num, int gen) const;

	/** Class-aware wrapper for `::pdf_open_document_with_stream()`.  */
	FZ_FUNCTION PdfDocument pdf_open_document_with_stream() const;

	/** Constructor using raw copy of pre-existing `::fz_stream`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_stream* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzStream(::fz_stream* internal);

	/** Destructor using fz_drop_stream(). */
	FZ_FUNCTION ~FzStream();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stream* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_string`. */
struct FzString
{
	/** == Constructors. */

	/** Constructor using `fz_new_string()`. */
	FZ_FUNCTION FzString(const char *str);

	/** Copy constructor using `fz_keep_string()`. */
	FZ_FUNCTION FzString(const FzString& rhs);

	/** operator= using `fz_keep_string()` and `fz_drop_string()`. */
	FZ_FUNCTION FzString& operator=(const FzString& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzString();

	/** Constructor using raw copy of pre-existing `::fz_string`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_string* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzString(::fz_string* internal);

	/** Destructor using fz_drop_string(). */
	FZ_FUNCTION ~FzString();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_string* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_stroke_state`. */
struct FzStrokeState
{
	/** == Constructors. */

	/** Constructor using `fz_new_stroke_state()`. */
	/**
		Create a new (empty) stroke state structure (with no dash
		data) and return a reference to it.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION FzStrokeState();

	/** Constructor using `fz_new_stroke_state_with_dash_len()`. */
	/**
		Create a new (empty) stroke state structure, with room for
		dash data of the given length, and return a reference to it.
	
		len: The number of dash elements to allow room for.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION FzStrokeState(int len);

	/** Copy constructor using `fz_keep_stroke_state()`. */
	FZ_FUNCTION FzStrokeState(const FzStrokeState& rhs);

	/** operator= using `fz_keep_stroke_state()` and `fz_drop_stroke_state()`. */
	FZ_FUNCTION FzStrokeState& operator=(const FzStrokeState& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_clone_stroke_state()`.  */
	/**
		Create an identical stroke_state structure and return a
		reference to it.
	
		stroke: The stroke state reference to clone.
	
		Exceptions may be thrown in the event of a failure to
		allocate.
	*/
	FZ_FUNCTION FzStrokeState fz_clone_stroke_state() const;

	/** Class-aware wrapper for `::fz_stroke_state_eq()`.  */
	FZ_FUNCTION int fz_stroke_state_eq(const FzStrokeState& b) const;

	/** Class-aware wrapper for `::fz_unshare_stroke_state()`.  */
	/**
		Given a reference to a (possibly) shared stroke_state structure,
		return a reference to an equivalent stroke_state structure
		that is guaranteed to be unshared (i.e. one that can
		safely be modified).
	
		shared: The reference to a (possibly) shared structure
		to unshare. Ownership of this reference is passed in
		to this function, even in the case of exceptions being
		thrown.
	
		Exceptions may be thrown in the event of failure to
		allocate if required.
	*/
	FZ_FUNCTION FzStrokeState fz_unshare_stroke_state() const;

	/** Class-aware wrapper for `::fz_unshare_stroke_state_with_dash_len()`.  */
	/**
		Given a reference to a (possibly) shared stroke_state structure,
		return a reference to a stroke_state structure (with room for a
		given amount of dash data) that is guaranteed to be unshared
		(i.e. one that can safely be modified).
	
		shared: The reference to a (possibly) shared structure
		to unshare. Ownership of this reference is passed in
		to this function, even in the case of exceptions being
		thrown.
	
		Exceptions may be thrown in the event of failure to
		allocate if required.
	*/
	FZ_FUNCTION FzStrokeState fz_unshare_stroke_state_with_dash_len(int len) const;

	/** Constructor using raw copy of pre-existing `::fz_stroke_state`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_stroke_state* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzStrokeState(::fz_stroke_state* internal);

	/** Destructor using fz_drop_stroke_state(). */
	FZ_FUNCTION ~FzStrokeState();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_stroke_state* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_style_context`. Not copyable or assignable. */
struct FzStyleContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzStyleContext();

	/** Constructor using raw copy of pre-existing `::fz_style_context`. */
	FZ_FUNCTION FzStyleContext(::fz_style_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzStyleContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_style_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzStyleContext(const FzStyleContext& rhs);
	FzStyleContext& operator=(const FzStyleContext& rhs);
};

/** Wrapper class for struct `fz_text`. */
struct FzText
{
	/** == Constructors. */

	/** Constructor using `fz_new_text()`. */
	/**
		Create a new empty fz_text object.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION FzText();

	/** Copy constructor using `fz_keep_text()`. */
	FZ_FUNCTION FzText(const FzText& rhs);

	/** operator= using `fz_keep_text()` and `fz_drop_text()`. */
	FZ_FUNCTION FzText& operator=(const FzText& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_bound_text()`.  */
	/**
		Find the bounds of a given text object.
	
		text: The text object to find the bounds of.
	
		stroke: Pointer to the stroke attributes (for stroked
		text), or NULL (for filled text).
	
		ctm: The matrix in use.
	
		r: pointer to storage for the bounds.
	
		Returns a pointer to r, which is updated to contain the
		bounding box for the text object.
	*/
	FZ_FUNCTION FzRect fz_bound_text(const FzStrokeState& stroke, const FzMatrix& ctm) const;

	/** Class-aware wrapper for `::fz_show_glyph()`.  */
	/**
		Add a glyph/unicode value to a text object.
	
		text: Text object to add to.
	
		font: The font the glyph should be added in.
	
		trm: The transform to use for the glyph.
	
		glyph: The glyph id to add.
	
		unicode: The unicode character for the glyph.
	
		cid: The CJK CID value or raw character code.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		bidi_level: The bidirectional level for this glyph.
	
		markup_dir: The direction of the text as specified in the
		markup.
	
		language: The language in use (if known, 0 otherwise)
		(e.g. FZ_LANG_zh_Hans).
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION void fz_show_glyph(const FzFont& font, const FzMatrix& trm, int glyph, int unicode, int wmode, int bidi_level, ::fz_bidi_direction markup_dir, ::fz_text_language language) const;

	/** Class-aware wrapper for `::fz_show_glyph_aux()`.  */
	FZ_FUNCTION void fz_show_glyph_aux(const FzFont& font, const FzMatrix& trm, float adv, int glyph, int unicode, int cid, int wmode, int bidi_level, ::fz_bidi_direction markup_dir, ::fz_text_language lang) const;

	/** Class-aware wrapper for `::fz_show_string()`.  */
	/**
		Add a UTF8 string to a text object.
	
		text: Text object to add to.
	
		font: The font the string should be added in.
	
		trm: The transform to use.
	
		s: The utf-8 string to add.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		bidi_level: The bidirectional level for this glyph.
	
		markup_dir: The direction of the text as specified in the markup.
	
		language: The language in use (if known, 0 otherwise)
			(e.g. FZ_LANG_zh_Hans).
	
		Returns the transform updated with the advance width of the
		string.
	*/
	FZ_FUNCTION FzMatrix fz_show_string(const FzFont& font, const FzMatrix& trm, const char *s, int wmode, int bidi_level, ::fz_bidi_direction markup_dir, ::fz_text_language language) const;

	/** Constructor using raw copy of pre-existing `::fz_text`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_text* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzText(::fz_text* internal);

	/** Destructor using fz_drop_text(). */
	FZ_FUNCTION ~FzText();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_text* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_text_decoder`. Not copyable or assignable. */
/**
 * A text decoder (to read arbitrary encodings and convert to unicode).
 */
struct FzTextDecoder
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzTextDecoder();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_init_text_decoder()`.  */
	FZ_FUNCTION void fz_init_text_decoder(const char *encoding) const;

	/** Constructor using raw copy of pre-existing `::fz_text_decoder`. */
	FZ_FUNCTION FzTextDecoder(::fz_text_decoder* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTextDecoder();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_text_decoder* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzTextDecoder(const FzTextDecoder& rhs);
	FzTextDecoder& operator=(const FzTextDecoder& rhs);
};

/** Wrapper class for struct `fz_text_item`. Not copyable or assignable. */
/**
	Text buffer.

	The trm field contains the a, b, c and d coefficients.
	The e and f coefficients come from the individual elements,
	together they form the transform matrix for the glyph.

	Glyphs are referenced by glyph ID.
	The Unicode text equivalent is kept in a separate array
	with indexes into the glyph array.
*/
struct FzTextItem
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzTextItem();

	/** Constructor using raw copy of pre-existing `::fz_text_item`. */
	FZ_FUNCTION FzTextItem(::fz_text_item* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTextItem();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_text_item* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzTextItem(const FzTextItem& rhs);
	FzTextItem& operator=(const FzTextItem& rhs);
};

/** Wrapper class for struct `fz_text_span`. Not copyable or assignable. */
struct FzTextSpan
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzTextSpan();

	/* == Methods. */

	/** Gives class-aware access to m_internal->font. */
	FZ_FUNCTION FzFont font();

	/** Gives class-aware access to m_internal->trm. */
	FZ_FUNCTION FzMatrix trm();

	/** Gives access to m_internal->items[i].
							Returned reference is only valid as long as `this`.
							Provided mainly for use by SWIG bindings.
							*/
	FZ_FUNCTION fz_text_item& items( int i);

	/** Constructor using raw copy of pre-existing `::fz_text_span`. */
	FZ_FUNCTION FzTextSpan(::fz_text_span* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTextSpan();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_text_span* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzTextSpan(const FzTextSpan& rhs);
	FzTextSpan& operator=(const FzTextSpan& rhs);
};

/** Wrapper class for struct `fz_transition`. */
struct FzTransition
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION FzTransition();

	/** Constructor using raw copy of pre-existing `::fz_transition`. */
	FZ_FUNCTION FzTransition(const ::fz_transition* internal);

	/** Constructor using raw copy of pre-existing `::fz_transition`. */
	FZ_FUNCTION FzTransition(const ::fz_transition internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::fz_transition* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::fz_transition* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTransition();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::fz_transition. */
	int type;
	float duration;
	int vertical;
	int outwards;
	int direction;
	int state0;
	int state1;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const FzTransition& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const FzTransition& rhs);
};

/** Wrapper class for struct `fz_tree`. Not copyable or assignable. */
/**
	AA-tree to look up things by strings.
*/
struct FzTree
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzTree();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_new_tree_archive()`.  */
	/**
		Create an archive that holds named buffers.
	
		tree can either be a preformed tree with fz_buffers as values,
		or it can be NULL for an empty tree.
	*/
	FZ_FUNCTION FzArchive fz_new_tree_archive() const;

	/** Class-aware wrapper for `::fz_tree_lookup()`.  */
	/**
		Look for the value of a node in the tree with the given key.
	
		Simple pointer equivalence is used for key.
	
		Returns NULL for no match.
	*/
	FZ_FUNCTION void *fz_tree_lookup(const char *key) const;

	/** Constructor using raw copy of pre-existing `::fz_tree`. */
	FZ_FUNCTION FzTree(::fz_tree* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTree();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_tree* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzTree(const FzTree& rhs);
	FzTree& operator=(const FzTree& rhs);
};

/** Wrapper class for struct `fz_tuning_context`. Not copyable or assignable. */
struct FzTuningContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzTuningContext();

	/** Constructor using raw copy of pre-existing `::fz_tuning_context`. */
	FZ_FUNCTION FzTuningContext(::fz_tuning_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzTuningContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_tuning_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzTuningContext(const FzTuningContext& rhs);
	FzTuningContext& operator=(const FzTuningContext& rhs);
};

/** Wrapper class for struct `fz_vertex`. Not copyable or assignable. */
/**
 *	Handy routine for processing mesh based shades
 */
struct FzVertex
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzVertex();

	/** Constructor using raw copy of pre-existing `::fz_vertex`. */
	FZ_FUNCTION FzVertex(::fz_vertex* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzVertex();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_vertex* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzVertex(const FzVertex& rhs);
	FzVertex& operator=(const FzVertex& rhs);
};

/** Wrapper class for struct `fz_warn_context`. Not copyable or assignable. */
struct FzWarnContext
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzWarnContext();

	/** Constructor using raw copy of pre-existing `::fz_warn_context`. */
	FZ_FUNCTION FzWarnContext(::fz_warn_context* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzWarnContext();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_warn_context* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzWarnContext(const FzWarnContext& rhs);
	FzWarnContext& operator=(const FzWarnContext& rhs);
};

/** Wrapper class for struct `fz_write_story_position`. Not copyable or assignable. */
struct FzWriteStoryPosition
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzWriteStoryPosition();

	/** Constructor using raw copy of pre-existing `::fz_write_story_position`. */
	FZ_FUNCTION FzWriteStoryPosition(::fz_write_story_position* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzWriteStoryPosition();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_write_story_position* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzWriteStoryPosition(const FzWriteStoryPosition& rhs);
	FzWriteStoryPosition& operator=(const FzWriteStoryPosition& rhs);
};

/** Wrapper class for struct `fz_write_story_positions`. Not copyable or assignable. */
struct FzWriteStoryPositions
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzWriteStoryPositions();

	/** Constructor using raw copy of pre-existing `::fz_write_story_positions`. */
	FZ_FUNCTION FzWriteStoryPositions(::fz_write_story_positions* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzWriteStoryPositions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_write_story_positions* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzWriteStoryPositions(const FzWriteStoryPositions& rhs);
	FzWriteStoryPositions& operator=(const FzWriteStoryPositions& rhs);
};

/** Wrapper class for struct `fz_xml`. */
/**
	XML document model
*/
struct FzXml
{
	/** == Constructors. */

	/** Constructor using `fz_new_dom()`. */
	/**
		Make new xml dom root element.
	*/
	FZ_FUNCTION FzXml(const char *tag);

	/** Constructor using `fz_new_dom_node()`. */
	/**
		Create a new dom node.
	
		This will NOT be linked in yet.
	*/
	FZ_FUNCTION FzXml(const FzXml& dom, const char *tag);

	/** Copy constructor using `fz_keep_xml()`. */
	FZ_FUNCTION FzXml(const FzXml& rhs);

	/** operator= using `fz_keep_xml()` and `fz_drop_xml()`. */
	FZ_FUNCTION FzXml& operator=(const FzXml& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzXml();

	/* == Static methods. */

	/** Class-aware wrapper for `::fz_new_dom_text_node()`.  */
	/**
		Create a new dom text node.
	
		This will NOT be linked in yet.
	*/
	FZ_FUNCTION static FzXml fz_new_dom_text_node(const FzXml& dom, const char *text);

	/* == Methods. */

	/** Class-aware wrapper for `::fz_debug_xml()`.  */
	/**
		Pretty-print an XML tree to stdout. (Deprecated, use
		fz_output_xml in preference).
	*/
	FZ_FUNCTION void fz_debug_xml(int level) const;

	/** Class-aware wrapper for `::fz_detach_xml()`.  */
	/**
		Detach a node from the tree, unlinking it from its parent,
		and setting the document root to the node.
	*/
	FZ_FUNCTION void fz_detach_xml() const;

	/** Class-aware wrapper for `::fz_dom_add_attribute()`.  */
	/**
		Add an attribute to an element.
	
		Ownership of att and value remain with the caller.
	*/
	FZ_FUNCTION void fz_dom_add_attribute(const char *att, const char *value) const;

	/** Class-aware wrapper for `::fz_dom_append_child()`.  */
	/**
		Insert an element as the last child of a parent, unlinking the
		child from its current position if required.
	*/
	FZ_FUNCTION void fz_dom_append_child(const FzXml& child) const;

	/** Class-aware wrapper for `::fz_dom_attribute()`.  */
	/**
		Retrieve the value of a given attribute from a given element.
	
		Returns a borrowed pointer to the value or NULL if not found.
	*/
	FZ_FUNCTION const char *fz_dom_attribute(const char *att) const;

	/** Class-aware wrapper for `::fz_dom_body()`.  */
	/**
		Return a borrowed reference for the 'body' element of
		the given DOM.
	*/
	FZ_FUNCTION FzXml fz_dom_body() const;

	/** Class-aware wrapper for `::fz_dom_clone()`.  */
	/**
		Clone an element (and its children).
	
		A borrowed reference to the clone is returned. The clone is not
		yet linked into the DOM.
	*/
	FZ_FUNCTION FzXml fz_dom_clone() const;

	/** Class-aware wrapper for `::fz_dom_create_element()`.  */
	/**
		Create an element of a given tag type for the given DOM.
	
		The element is not linked into the DOM yet.
	*/
	FZ_FUNCTION FzXml fz_dom_create_element(const char *tag) const;

	/** Class-aware wrapper for `::fz_dom_create_text_node()`.  */
	/**
		Create a text node for the given DOM.
	
		The element is not linked into the DOM yet.
	*/
	FZ_FUNCTION FzXml fz_dom_create_text_node(const char *text) const;

	/** Class-aware wrapper for `::fz_dom_document_element()`.  */
	/**
		Return a borrowed reference for the document (the top
		level element) of the DOM.
	*/
	FZ_FUNCTION FzXml fz_dom_document_element() const;

	/** Class-aware wrapper for `::fz_dom_find()`.  */
	/**
		Find the first element matching the requirements in a depth first traversal from elt.
	
		The tagname must match tag, unless tag is NULL, when all tag names are considered to match.
	
		If att is NULL, then all tags match.
		Otherwise:
			If match is NULL, then only nodes that have an att attribute match.
			If match is non-NULL, then only nodes that have an att attribute that matches match match.
	
		Returns NULL (if no match found), or a borrowed reference to the first matching element.
	*/
	FZ_FUNCTION FzXml fz_dom_find(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_dom_find_next()`.  */
	/**
		Find the next element matching the requirements.
	*/
	FZ_FUNCTION FzXml fz_dom_find_next(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_dom_first_child()`.  */
	/**
		Return a borrowed reference to the first child of a node,
		or NULL if there isn't one.
	*/
	FZ_FUNCTION FzXml fz_dom_first_child() const;

	/** Class-aware wrapper for `::fz_dom_get_attribute()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_dom_get_attribute(int i)` => `(const char *, const char *att)`
	 */
	/**
		Enumerate through the attributes of an element.
	
		Call with i=0,1,2,3... to enumerate attributes.
	
		On return *att and the return value will be NULL if there are not
		that many attributes to read. Otherwise, *att will be filled in
		with a borrowed pointer to the attribute name, and the return
		value will be a borrowed pointer to the value.
	*/
	FZ_FUNCTION const char *fz_dom_get_attribute(int i, const char **att) const;

	/** Class-aware wrapper for `::fz_dom_insert_after()`.  */
	/**
		Insert an element (new_elt), after another element (node),
		unlinking the new_elt from its current position if required.
	*/
	FZ_FUNCTION void fz_dom_insert_after(const FzXml& new_elt) const;

	/** Class-aware wrapper for `::fz_dom_insert_before()`.  */
	/**
		Insert an element (new_elt), before another element (node),
		unlinking the new_elt from its current position if required.
	*/
	FZ_FUNCTION void fz_dom_insert_before(const FzXml& new_elt) const;

	/** Class-aware wrapper for `::fz_dom_next()`.  */
	/**
		Return a borrowed reference to the next sibling of a node,
		or NULL if there isn't one.
	*/
	FZ_FUNCTION FzXml fz_dom_next() const;

	/** Class-aware wrapper for `::fz_dom_parent()`.  */
	/**
		Return a borrowed reference to the parent of a node,
		or NULL if there isn't one.
	*/
	FZ_FUNCTION FzXml fz_dom_parent() const;

	/** Class-aware wrapper for `::fz_dom_previous()`.  */
	/**
		Return a borrowed reference to the previous sibling of a node,
		or NULL if there isn't one.
	*/
	FZ_FUNCTION FzXml fz_dom_previous() const;

	/** Class-aware wrapper for `::fz_dom_remove()`.  */
	/**
		Remove an element from the DOM. The element can be added back elsewhere
		if required.
	
		No reference counting changes for the element.
	*/
	FZ_FUNCTION void fz_dom_remove() const;

	/** Class-aware wrapper for `::fz_dom_remove_attribute()`.  */
	/**
		Remove an attribute from an element.
	*/
	FZ_FUNCTION void fz_dom_remove_attribute(const char *att) const;

	/** Class-aware wrapper for `::fz_new_display_list_from_svg_xml()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fz_new_display_list_from_svg_xml(::fz_xml *xml, const char *base_uri, ::fz_archive *dir)` => `(fz_display_list *, float w, float h)`
	 */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION FzDisplayList fz_new_display_list_from_svg_xml(const FzXml& xml, const char *base_uri, const FzArchive& dir, float *w, float *h) const;

	/** Class-aware wrapper for `::fz_new_dom_node()`.  */
	/**
		Create a new dom node.
	
		This will NOT be linked in yet.
	*/
	FZ_FUNCTION FzXml fz_new_dom_node(const char *tag) const;

	/** Class-aware wrapper for `::fz_new_dom_text_node()`.  */
	/**
		Create a new dom text node.
	
		This will NOT be linked in yet.
	*/
	FZ_FUNCTION FzXml fz_new_dom_text_node(const char *text) const;

	/** Class-aware wrapper for `::fz_new_image_from_svg_xml()`.  */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION FzImage fz_new_image_from_svg_xml(const FzXml& xml, const char *base_uri, const FzArchive& dir) const;

	/** Class-aware wrapper for `::fz_save_xml()`.  */
	/**
		As for fz_write_xml, but direct to a file.
	*/
	FZ_FUNCTION void fz_save_xml(const char *path, int indented) const;

	/** Class-aware wrapper for `::fz_write_xml()`.  */
	/**
		Write our xml structure out to an xml stream.
	
		Properly formatted XML is only allowed to have a single top-level node
		under which everything must sit. Our structures allow for multiple
		top level nodes. If required, we will output an extra 'ROOT' node
		at the top so that the xml is well-formed.
	
		If 'indented' is non-zero then additional whitespace will be added to
		make the XML easier to read in a text editor. It will NOT be properly
		compliant.
	*/
	FZ_FUNCTION void fz_write_xml(const FzOutput& out, int indented) const;

	/** Class-aware wrapper for `::fz_xml_att()`.  */
	/**
		Return the value of an attribute of an XML node.
		NULL if the attribute doesn't exist.
	*/
	FZ_FUNCTION char *fz_xml_att(const char *att) const;

	/** Class-aware wrapper for `::fz_xml_att_alt()`.  */
	/**
		Return the value of an attribute of an XML node.
		If the first attribute doesn't exist, try the second.
		NULL if neither attribute exists.
	*/
	FZ_FUNCTION char *fz_xml_att_alt(const char *one, const char *two) const;

	/** Class-aware wrapper for `::fz_xml_att_eq()`.  */
	/**
		Check for a matching attribute on an XML node.
	
		If the node has the requested attribute (name), and the value
		matches (match) then return 1. Otherwise, 0.
	*/
	FZ_FUNCTION int fz_xml_att_eq(const char *name, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_down()`.  */
	/**
		Return first child of XML node.
	*/
	FZ_FUNCTION FzXml fz_xml_down() const;

	/** Class-aware wrapper for `::fz_xml_find()`.  */
	/**
		Search the siblings of XML nodes starting with item looking for
		the first with the given tag.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find(const char *tag) const;

	/** Class-aware wrapper for `::fz_xml_find_dfs()`.  */
	/**
		Perform a depth first search from item, returning the first
		child that matches the given tag (or any tag if tag is NULL),
		with the given attribute (if att is non NULL), that matches
		match (if match is non NULL).
	*/
	FZ_FUNCTION FzXml fz_xml_find_dfs(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_find_dfs_top()`.  */
	/**
		Perform a depth first search from item, returning the first
		child that matches the given tag (or any tag if tag is NULL),
		with the given attribute (if att is non NULL), that matches
		match (if match is non NULL). The search stops if it ever
		reaches the top of the tree, or the declared 'top' item.
	*/
	FZ_FUNCTION FzXml fz_xml_find_dfs_top(const char *tag, const char *att, const char *match, const FzXml& top) const;

	/** Class-aware wrapper for `::fz_xml_find_down()`.  */
	/**
		Search the siblings of XML nodes starting with the first child
		of item looking for the first with the given tag.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find_down(const char *tag) const;

	/** Class-aware wrapper for `::fz_xml_find_down_match()`.  */
	/**
		Search the siblings of XML nodes starting with the first child
		of item looking for the first with the given tag (or any tag if
		tag is NULL), and with a matching attribute.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find_down_match(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_find_match()`.  */
	/**
		Search the siblings of XML nodes starting with item looking for
		the first with the given tag (or any tag if tag is NULL), and
		with a matching attribute.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find_match(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_find_next()`.  */
	/**
		Search the siblings of XML nodes starting with the first sibling
		of item looking for the first with the given tag.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find_next(const char *tag) const;

	/** Class-aware wrapper for `::fz_xml_find_next_dfs()`.  */
	/**
		Perform a depth first search onwards from item, returning the first
		child that matches the given tag (or any tag if tag is NULL),
		with the given attribute (if att is non NULL), that matches
		match (if match is non NULL).
	*/
	FZ_FUNCTION FzXml fz_xml_find_next_dfs(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_find_next_dfs_top()`.  */
	/**
		Perform a depth first search onwards from item, returning the first
		child that matches the given tag (or any tag if tag is NULL),
		with the given attribute (if att is non NULL), that matches
		match (if match is non NULL). The search stops if it ever reaches
		the top of the tree, or the declared 'top' item.
	*/
	FZ_FUNCTION FzXml fz_xml_find_next_dfs_top(const char *tag, const char *att, const char *match, const FzXml& top) const;

	/** Class-aware wrapper for `::fz_xml_find_next_match()`.  */
	/**
		Search the siblings of XML nodes starting with the first sibling
		of item looking for the first with the given tag (or any tag if tag
		is NULL), and with a matching attribute.
	
		Return NULL if none found.
	*/
	FZ_FUNCTION FzXml fz_xml_find_next_match(const char *tag, const char *att, const char *match) const;

	/** Class-aware wrapper for `::fz_xml_is_tag()`.  */
	/**
		Return true if the tag name matches.
	*/
	FZ_FUNCTION int fz_xml_is_tag(const char *name) const;

	/** Class-aware wrapper for `::fz_xml_next()`.  */
	/**
		Return next sibling of XML node.
	*/
	FZ_FUNCTION FzXml fz_xml_next() const;

	/** Class-aware wrapper for `::fz_xml_prev()`.  */
	/**
		Return previous sibling of XML node.
	*/
	FZ_FUNCTION FzXml fz_xml_prev() const;

	/** Class-aware wrapper for `::fz_xml_root()`.  */
	/**
		Return the topmost XML node of a document.
	*/
	FZ_FUNCTION FzXml fz_xml_root() const;

	/** Class-aware wrapper for `::fz_xml_tag()`.  */
	/**
		Return tag of XML node. Return NULL for text nodes.
	*/
	FZ_FUNCTION char *fz_xml_tag() const;

	/** Class-aware wrapper for `::fz_xml_text()`.  */
	/**
		Return the text content of an XML node.
		Return NULL if the node is a tag.
	*/
	FZ_FUNCTION char *fz_xml_text() const;

	/** Class-aware wrapper for `::fz_xml_up()`.  */
	/**
		Return parent of XML node.
	*/
	FZ_FUNCTION FzXml fz_xml_up() const;

	/** Constructor using raw copy of pre-existing `::fz_xml`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_xml* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzXml(::fz_xml* internal);

	/** Destructor using fz_drop_xml(). */
	FZ_FUNCTION ~FzXml();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_xml* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `fz_xml_doc`. Not copyable or assignable. */
struct FzXmlDoc
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzXmlDoc();

	/** Constructor using raw copy of pre-existing `::fz_xml_doc`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a fz_xml_doc* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit FzXmlDoc(::fz_xml_doc* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~FzXmlDoc();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_xml_doc* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzXmlDoc(const FzXmlDoc& rhs);
	FzXmlDoc& operator=(const FzXmlDoc& rhs);
};

/** Wrapper class for struct `fz_zip_writer`. Not copyable or assignable. */
/**
	fz_zip_writer offers methods for creating and writing zip files.
	It can be seen as the reverse of the fz_archive zip
	implementation.
*/
struct FzZipWriter
{
	/** == Constructors. */

	/** Constructor using `fz_new_zip_writer()`. */
	/**
		Create a new zip writer that writes to a given file.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	*/
	FZ_FUNCTION FzZipWriter(const char *filename);

	/** Constructor using `fz_new_zip_writer_with_output()`. */
	/**
		Create a new zip writer that writes to a given output stream.
	
		Ownership of out passes in immediately upon calling this function.
		The caller should never drop the fz_output, even if this function throws
		an exception.
	*/
	FZ_FUNCTION FzZipWriter(const FzOutput& out);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION FzZipWriter();

	/* == Methods. */

	/** Class-aware wrapper for `::fz_close_zip_writer()`.  */
	/**
		Close the zip file for writing.
	
		This flushes any pending data to the file. This can throw
		exceptions.
	*/
	FZ_FUNCTION void fz_close_zip_writer() const;

	/** Class-aware wrapper for `::fz_write_zip_entry()`.  */
	/**
		Given a buffer of data, (optionally) compress it, and add it to
		the zip file with the given name.
	*/
	FZ_FUNCTION void fz_write_zip_entry(const char *name, const FzBuffer& buf, int compress) const;

	/** Constructor using raw copy of pre-existing `::fz_zip_writer`. */
	FZ_FUNCTION FzZipWriter(::fz_zip_writer* internal);

	/** Destructor using fz_drop_zip_writer(). */
	FZ_FUNCTION ~FzZipWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::fz_zip_writer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	FzZipWriter(const FzZipWriter& rhs);
	FzZipWriter& operator=(const FzZipWriter& rhs);
};

/** Wrapper class for struct `pdf_alert_event`. Not copyable or assignable. */
struct PdfAlertEvent
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfAlertEvent();

	/** Constructor using raw copy of pre-existing `::pdf_alert_event`. */
	FZ_FUNCTION PdfAlertEvent(::pdf_alert_event* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfAlertEvent();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_alert_event* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfAlertEvent(const PdfAlertEvent& rhs);
	PdfAlertEvent& operator=(const PdfAlertEvent& rhs);
};

/** Wrapper class for struct `pdf_annot`. */
struct PdfAnnot
{
	/** Copy constructor using `pdf_keep_annot()`. */
	FZ_FUNCTION PdfAnnot(const PdfAnnot& rhs);

	/** operator= using `pdf_keep_annot()` and `pdf_drop_annot()`. */
	FZ_FUNCTION PdfAnnot& operator=(const PdfAnnot& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_add_annot_border_dash_item()`.  */
	FZ_FUNCTION void pdf_add_annot_border_dash_item(float length) const;

	/** Class-aware wrapper for `::pdf_add_annot_ink_list_stroke()`.  */
	FZ_FUNCTION void pdf_add_annot_ink_list_stroke() const;

	/** Class-aware wrapper for `::pdf_add_annot_ink_list_stroke_vertex()`.  */
	FZ_FUNCTION void pdf_add_annot_ink_list_stroke_vertex(const FzPoint& p) const;

	/** Class-aware wrapper for `::pdf_add_annot_quad_point()`.  */
	FZ_FUNCTION void pdf_add_annot_quad_point(const FzQuad& quad) const;

	/** Class-aware wrapper for `::pdf_add_annot_vertex()`.  */
	FZ_FUNCTION void pdf_add_annot_vertex(const FzPoint& p) const;

	/** Class-aware wrapper for `::pdf_annot_MK_BC()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_MK_BC(float color[4])` => int n
	 */
	FZ_FUNCTION void pdf_annot_MK_BC(int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_MK_BC_rgb()`.  */
	FZ_FUNCTION int pdf_annot_MK_BC_rgb(float rgb[3]) const;

	/** Class-aware wrapper for `::pdf_annot_MK_BG()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_MK_BG(float color[4])` => int n
	 */
	FZ_FUNCTION void pdf_annot_MK_BG(int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_MK_BG_rgb()`.  */
	FZ_FUNCTION int pdf_annot_MK_BG_rgb(float rgb[3]) const;

	/** Class-aware wrapper for `::pdf_annot_active()`.  */
	FZ_FUNCTION int pdf_annot_active() const;

	/** Class-aware wrapper for `::pdf_annot_ap()`.  */
	FZ_FUNCTION PdfObj pdf_annot_ap() const;

	/** Class-aware wrapper for `::pdf_annot_author()`.  */
	FZ_FUNCTION const char *pdf_annot_author() const;

	/** Class-aware wrapper for `::pdf_annot_border()`.  */
	FZ_FUNCTION float pdf_annot_border() const;

	/** Class-aware wrapper for `::pdf_annot_border_dash_count()`.  */
	FZ_FUNCTION int pdf_annot_border_dash_count() const;

	/** Class-aware wrapper for `::pdf_annot_border_dash_item()`.  */
	FZ_FUNCTION float pdf_annot_border_dash_item(int i) const;

	/** Class-aware wrapper for `::pdf_annot_border_effect()`.  */
	FZ_FUNCTION enum pdf_border_effect pdf_annot_border_effect() const;

	/** Class-aware wrapper for `::pdf_annot_border_effect_intensity()`.  */
	FZ_FUNCTION float pdf_annot_border_effect_intensity() const;

	/** Class-aware wrapper for `::pdf_annot_border_style()`.  */
	FZ_FUNCTION enum pdf_border_style pdf_annot_border_style() const;

	/** Class-aware wrapper for `::pdf_annot_border_width()`.  */
	FZ_FUNCTION float pdf_annot_border_width() const;

	/** Class-aware wrapper for `::pdf_annot_callout_point()`.  */
	FZ_FUNCTION FzPoint pdf_annot_callout_point() const;

	/** Class-aware wrapper for `::pdf_annot_callout_style()`.  */
	FZ_FUNCTION enum pdf_line_ending pdf_annot_callout_style() const;

	/** Class-aware wrapper for `::pdf_annot_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_color(float color[4])` => int n
	 */
	FZ_FUNCTION void pdf_annot_color(int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_contents()`.  */
	FZ_FUNCTION const char *pdf_annot_contents() const;

	/** Class-aware wrapper for `::pdf_annot_creation_date()`.  */
	FZ_FUNCTION int64_t pdf_annot_creation_date() const;

	/** Class-aware wrapper for `::pdf_annot_default_appearance()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_default_appearance(float color[4])` => `(const char *font, float size, int n)`
	 */
	FZ_FUNCTION void pdf_annot_default_appearance(const char **font, float *size, int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_default_appearance_unmapped()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_default_appearance_unmapped(char *font_name, int font_name_len, float color[4])` => `(float size, int n)`
	 */
	FZ_FUNCTION void pdf_annot_default_appearance_unmapped(char *font_name, int font_name_len, float *size, int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_ensure_local_xref()`.  */
	FZ_FUNCTION void pdf_annot_ensure_local_xref() const;

	/** Class-aware wrapper for `::pdf_annot_event_blur()`.  */
	FZ_FUNCTION void pdf_annot_event_blur() const;

	/** Class-aware wrapper for `::pdf_annot_event_down()`.  */
	FZ_FUNCTION void pdf_annot_event_down() const;

	/** Class-aware wrapper for `::pdf_annot_event_enter()`.  */
	FZ_FUNCTION void pdf_annot_event_enter() const;

	/** Class-aware wrapper for `::pdf_annot_event_exit()`.  */
	FZ_FUNCTION void pdf_annot_event_exit() const;

	/** Class-aware wrapper for `::pdf_annot_event_focus()`.  */
	FZ_FUNCTION void pdf_annot_event_focus() const;

	/** Class-aware wrapper for `::pdf_annot_event_page_close()`.  */
	FZ_FUNCTION void pdf_annot_event_page_close() const;

	/** Class-aware wrapper for `::pdf_annot_event_page_invisible()`.  */
	FZ_FUNCTION void pdf_annot_event_page_invisible() const;

	/** Class-aware wrapper for `::pdf_annot_event_page_open()`.  */
	FZ_FUNCTION void pdf_annot_event_page_open() const;

	/** Class-aware wrapper for `::pdf_annot_event_page_visible()`.  */
	FZ_FUNCTION void pdf_annot_event_page_visible() const;

	/** Class-aware wrapper for `::pdf_annot_event_up()`.  */
	FZ_FUNCTION void pdf_annot_event_up() const;

	/** Class-aware wrapper for `::pdf_annot_field_flags()`.  */
	FZ_FUNCTION int pdf_annot_field_flags() const;

	/** Class-aware wrapper for `::pdf_annot_field_label()`.  */
	FZ_FUNCTION const char *pdf_annot_field_label() const;

	/** Class-aware wrapper for `::pdf_annot_field_value()`.  */
	FZ_FUNCTION const char *pdf_annot_field_value() const;

	/** Class-aware wrapper for `::pdf_annot_filespec()`.  */
	FZ_FUNCTION PdfObj pdf_annot_filespec() const;

	/** Class-aware wrapper for `::pdf_annot_flags()`.  */
	FZ_FUNCTION int pdf_annot_flags() const;

	/** Class-aware wrapper for `::pdf_annot_has_author()`.  */
	FZ_FUNCTION int pdf_annot_has_author() const;

	/** Class-aware wrapper for `::pdf_annot_has_border()`.  */
	FZ_FUNCTION int pdf_annot_has_border() const;

	/** Class-aware wrapper for `::pdf_annot_has_border_effect()`.  */
	FZ_FUNCTION int pdf_annot_has_border_effect() const;

	/** Class-aware wrapper for `::pdf_annot_has_callout()`.  */
	FZ_FUNCTION int pdf_annot_has_callout() const;

	/** Class-aware wrapper for `::pdf_annot_has_default_appearance()`.  */
	FZ_FUNCTION int pdf_annot_has_default_appearance() const;

	/** Class-aware wrapper for `::pdf_annot_has_filespec()`.  */
	FZ_FUNCTION int pdf_annot_has_filespec() const;

	/** Class-aware wrapper for `::pdf_annot_has_icon_name()`.  */
	FZ_FUNCTION int pdf_annot_has_icon_name() const;

	/** Class-aware wrapper for `::pdf_annot_has_ink_list()`.  */
	FZ_FUNCTION int pdf_annot_has_ink_list() const;

	/** Class-aware wrapper for `::pdf_annot_has_intent()`.  */
	FZ_FUNCTION int pdf_annot_has_intent() const;

	/** Class-aware wrapper for `::pdf_annot_has_interior_color()`.  */
	FZ_FUNCTION int pdf_annot_has_interior_color() const;

	/** Class-aware wrapper for `::pdf_annot_has_line()`.  */
	FZ_FUNCTION int pdf_annot_has_line() const;

	/** Class-aware wrapper for `::pdf_annot_has_line_ending_styles()`.  */
	FZ_FUNCTION int pdf_annot_has_line_ending_styles() const;

	/** Class-aware wrapper for `::pdf_annot_has_open()`.  */
	FZ_FUNCTION int pdf_annot_has_open() const;

	/** Class-aware wrapper for `::pdf_annot_has_popup()`.  */
	FZ_FUNCTION int pdf_annot_has_popup() const;

	/** Class-aware wrapper for `::pdf_annot_has_quad_points()`.  */
	FZ_FUNCTION int pdf_annot_has_quad_points() const;

	/** Class-aware wrapper for `::pdf_annot_has_quadding()`.  */
	FZ_FUNCTION int pdf_annot_has_quadding() const;

	/** Class-aware wrapper for `::pdf_annot_has_rect()`.  */
	FZ_FUNCTION int pdf_annot_has_rect() const;

	/** Class-aware wrapper for `::pdf_annot_has_rich_contents()`.  */
	FZ_FUNCTION int pdf_annot_has_rich_contents() const;

	/** Class-aware wrapper for `::pdf_annot_has_rich_defaults()`.  */
	FZ_FUNCTION int pdf_annot_has_rich_defaults() const;

	/** Class-aware wrapper for `::pdf_annot_has_vertices()`.  */
	FZ_FUNCTION int pdf_annot_has_vertices() const;

	/** Class-aware wrapper for `::pdf_annot_hidden_for_editing()`.  */
	FZ_FUNCTION int pdf_annot_hidden_for_editing() const;

	/** Class-aware wrapper for `::pdf_annot_hot()`.  */
	FZ_FUNCTION int pdf_annot_hot() const;

	/** Class-aware wrapper for `::pdf_annot_icon_name()`.  */
	FZ_FUNCTION const char *pdf_annot_icon_name() const;

	/** Class-aware wrapper for `::pdf_annot_ink_list_count()`.  */
	FZ_FUNCTION int pdf_annot_ink_list_count() const;

	/** Class-aware wrapper for `::pdf_annot_ink_list_stroke_count()`.  */
	FZ_FUNCTION int pdf_annot_ink_list_stroke_count(int i) const;

	/** Class-aware wrapper for `::pdf_annot_ink_list_stroke_vertex()`.  */
	FZ_FUNCTION FzPoint pdf_annot_ink_list_stroke_vertex(int i, int k) const;

	/** Class-aware wrapper for `::pdf_annot_intent()`.  */
	FZ_FUNCTION enum pdf_intent pdf_annot_intent() const;

	/** Class-aware wrapper for `::pdf_annot_interior_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_interior_color(float color[4])` => int n
	 */
	FZ_FUNCTION void pdf_annot_interior_color(int *n, float color[4]) const;

	/** Class-aware wrapper for `::pdf_annot_is_open()`.  */
	FZ_FUNCTION int pdf_annot_is_open() const;

	/** Class-aware wrapper for `::pdf_annot_is_standard_stamp()`.  */
	FZ_FUNCTION int pdf_annot_is_standard_stamp() const;

	/** Class-aware wrapper for `::pdf_annot_line()`.  */
	FZ_FUNCTION void pdf_annot_line(FzPoint& a, FzPoint& b) const;

	/** Class-aware wrapper for `::pdf_annot_line_caption()`.  */
	FZ_FUNCTION int pdf_annot_line_caption() const;

	/** Class-aware wrapper for `::pdf_annot_line_caption_offset()`.  */
	FZ_FUNCTION FzPoint pdf_annot_line_caption_offset() const;

	/** Class-aware wrapper for `::pdf_annot_line_end_style()`.  */
	FZ_FUNCTION enum pdf_line_ending pdf_annot_line_end_style() const;

	/** Class-aware wrapper for `::pdf_annot_line_ending_styles()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_annot_line_ending_styles()` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
	 */
	FZ_FUNCTION void pdf_annot_line_ending_styles(enum pdf_line_ending *start_style, enum pdf_line_ending *end_style) const;

	/** Class-aware wrapper for `::pdf_annot_line_leader()`.  */
	FZ_FUNCTION float pdf_annot_line_leader() const;

	/** Class-aware wrapper for `::pdf_annot_line_leader_extension()`.  */
	FZ_FUNCTION float pdf_annot_line_leader_extension() const;

	/** Class-aware wrapper for `::pdf_annot_line_leader_offset()`.  */
	FZ_FUNCTION float pdf_annot_line_leader_offset() const;

	/** Class-aware wrapper for `::pdf_annot_line_start_style()`.  */
	FZ_FUNCTION enum pdf_line_ending pdf_annot_line_start_style() const;

	/** Class-aware wrapper for `::pdf_annot_modification_date()`.  */
	FZ_FUNCTION int64_t pdf_annot_modification_date() const;

	/** Class-aware wrapper for `::pdf_annot_needs_resynthesis()`.  */
	FZ_FUNCTION int pdf_annot_needs_resynthesis() const;

	/** Class-aware wrapper for `::pdf_annot_obj()`.  */
	FZ_FUNCTION PdfObj pdf_annot_obj() const;

	/** Class-aware wrapper for `::pdf_annot_opacity()`.  */
	FZ_FUNCTION float pdf_annot_opacity() const;

	/** Class-aware wrapper for `::pdf_annot_page()`.  */
	FZ_FUNCTION PdfPage pdf_annot_page() const;

	/** Class-aware wrapper for `::pdf_annot_pop_and_discard_local_xref()`.  */
	FZ_FUNCTION void pdf_annot_pop_and_discard_local_xref() const;

	/** Class-aware wrapper for `::pdf_annot_pop_local_xref()`.  */
	FZ_FUNCTION void pdf_annot_pop_local_xref() const;

	/** Class-aware wrapper for `::pdf_annot_popup()`.  */
	FZ_FUNCTION FzRect pdf_annot_popup() const;

	/** Class-aware wrapper for `::pdf_annot_push_local_xref()`.  */
	FZ_FUNCTION void pdf_annot_push_local_xref() const;

	/** Class-aware wrapper for `::pdf_annot_quad_point()`.  */
	FZ_FUNCTION FzQuad pdf_annot_quad_point(int i) const;

	/** Class-aware wrapper for `::pdf_annot_quad_point_count()`.  */
	FZ_FUNCTION int pdf_annot_quad_point_count() const;

	/** Class-aware wrapper for `::pdf_annot_quadding()`.  */
	FZ_FUNCTION int pdf_annot_quadding() const;

	/** Class-aware wrapper for `::pdf_annot_rect()`.  */
	FZ_FUNCTION FzRect pdf_annot_rect() const;

	/** Class-aware wrapper for `::pdf_annot_request_resynthesis()`.  */
	FZ_FUNCTION void pdf_annot_request_resynthesis() const;

	/** Class-aware wrapper for `::pdf_annot_request_synthesis()`.  */
	FZ_FUNCTION void pdf_annot_request_synthesis() const;

	/** Class-aware wrapper for `::pdf_annot_rich_contents()`.  */
	FZ_FUNCTION const char *pdf_annot_rich_contents() const;

	/** Class-aware wrapper for `::pdf_annot_rich_defaults()`.  */
	FZ_FUNCTION const char *pdf_annot_rich_defaults() const;

	/** Class-aware wrapper for `::pdf_annot_stamp_image_obj()`.  */
	FZ_FUNCTION PdfObj pdf_annot_stamp_image_obj() const;

	/** Class-aware wrapper for `::pdf_annot_transform()`.  */
	FZ_FUNCTION FzMatrix pdf_annot_transform() const;

	/** Class-aware wrapper for `::pdf_annot_type()`.  */
	FZ_FUNCTION enum pdf_annot_type pdf_annot_type() const;

	/** Class-aware wrapper for `::pdf_annot_vertex()`.  */
	FZ_FUNCTION FzPoint pdf_annot_vertex(int i) const;

	/** Class-aware wrapper for `::pdf_annot_vertex_count()`.  */
	FZ_FUNCTION int pdf_annot_vertex_count() const;

	/** Class-aware wrapper for `::pdf_apply_redaction()`.  */
	FZ_FUNCTION int pdf_apply_redaction(PdfRedactOptions& opts) const;

	/** Class-aware wrapper for `::pdf_bound_annot()`.  */
	FZ_FUNCTION FzRect pdf_bound_annot() const;

	/** Class-aware wrapper for `::pdf_bound_widget()`.  */
	FZ_FUNCTION FzRect pdf_bound_widget() const;

	/** Class-aware wrapper for `::pdf_choice_widget_is_multiselect()`.  */
	FZ_FUNCTION int pdf_choice_widget_is_multiselect() const;

	/** Class-aware wrapper for `::pdf_choice_widget_options()`.  */
	FZ_FUNCTION int pdf_choice_widget_options(int exportval, const char *opts[]) const;

	/** Class-aware wrapper for `::pdf_choice_widget_options2()`.  */
	/** Swig-friendly wrapper for pdf_choice_widget_options(), returns the
	options directly in a vector. */
	FZ_FUNCTION std::vector<std::string> pdf_choice_widget_options2(int exportval) const;

	/** Class-aware wrapper for `::pdf_choice_widget_set_value()`.  */
	FZ_FUNCTION void pdf_choice_widget_set_value(int n, const char *opts[]) const;

	/** Class-aware wrapper for `::pdf_choice_widget_value()`.  */
	FZ_FUNCTION int pdf_choice_widget_value(const char *opts[]) const;

	/** Class-aware wrapper for `::pdf_clear_annot_border_dash()`.  */
	FZ_FUNCTION void pdf_clear_annot_border_dash() const;

	/** Class-aware wrapper for `::pdf_clear_annot_ink_list()`.  */
	FZ_FUNCTION void pdf_clear_annot_ink_list() const;

	/** Class-aware wrapper for `::pdf_clear_annot_quad_points()`.  */
	FZ_FUNCTION void pdf_clear_annot_quad_points() const;

	/** Class-aware wrapper for `::pdf_clear_annot_vertices()`.  */
	FZ_FUNCTION void pdf_clear_annot_vertices() const;

	/** Class-aware wrapper for `::pdf_clear_signature()`.  */
	FZ_FUNCTION void pdf_clear_signature() const;

	/** Class-aware wrapper for `::pdf_dirty_annot()`.  */
	FZ_FUNCTION void pdf_dirty_annot() const;

	/** Class-aware wrapper for `::pdf_edit_text_field_value()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_edit_text_field_value(const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
	 */
	FZ_FUNCTION int pdf_edit_text_field_value(const char *value, const char *change, int *selStart, int *selEnd, char **newvalue) const;

	/** Class-aware wrapper for `::pdf_get_widget_editing_state()`.  */
	FZ_FUNCTION int pdf_get_widget_editing_state() const;

	/** Class-aware wrapper for `::pdf_incremental_change_since_signing_widget()`.  */
	FZ_FUNCTION int pdf_incremental_change_since_signing_widget() const;

	/** Class-aware wrapper for `::pdf_new_display_list_from_annot()`.  */
	FZ_FUNCTION FzDisplayList pdf_new_display_list_from_annot() const;

	/** Class-aware wrapper for `::pdf_new_pixmap_from_annot()`.  */
	FZ_FUNCTION FzPixmap pdf_new_pixmap_from_annot(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha) const;

	/** Class-aware wrapper for `::pdf_next_annot()`.  */
	FZ_FUNCTION PdfAnnot pdf_next_annot() const;

	/** Class-aware wrapper for `::pdf_next_widget()`.  */
	FZ_FUNCTION PdfAnnot pdf_next_widget() const;

	/** Class-aware wrapper for `::pdf_run_annot()`.  */
	FZ_FUNCTION void pdf_run_annot(const FzDevice& dev, const FzMatrix& ctm, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_set_annot_active()`.  */
	FZ_FUNCTION void pdf_set_annot_active(int active) const;

	/** Class-aware wrapper for `::pdf_set_annot_appearance()`.  */
	FZ_FUNCTION void pdf_set_annot_appearance(const char *appearance, const char *state, const FzMatrix& ctm, const FzRect& bbox, const PdfObj& res, const FzBuffer& contents) const;

	/** Class-aware wrapper for `::pdf_set_annot_appearance_from_display_list()`.  */
	FZ_FUNCTION void pdf_set_annot_appearance_from_display_list(const char *appearance, const char *state, const FzMatrix& ctm, const FzDisplayList& list) const;

	/** Class-aware wrapper for `::pdf_set_annot_author()`.  */
	FZ_FUNCTION void pdf_set_annot_author(const char *author) const;

	/** Class-aware wrapper for `::pdf_set_annot_border()`.  */
	FZ_FUNCTION void pdf_set_annot_border(float width) const;

	/** Class-aware wrapper for `::pdf_set_annot_border_effect()`.  */
	FZ_FUNCTION void pdf_set_annot_border_effect(enum pdf_border_effect effect) const;

	/** Class-aware wrapper for `::pdf_set_annot_border_effect_intensity()`.  */
	FZ_FUNCTION void pdf_set_annot_border_effect_intensity(float intensity) const;

	/** Class-aware wrapper for `::pdf_set_annot_border_style()`.  */
	FZ_FUNCTION void pdf_set_annot_border_style(enum pdf_border_style style) const;

	/** Class-aware wrapper for `::pdf_set_annot_border_width()`.  */
	FZ_FUNCTION void pdf_set_annot_border_width(float width) const;

	/** Class-aware wrapper for `::pdf_set_annot_callout_line2()`.  */
	/** SWIG-friendly wrapper for pdf_set_annot_callout_line(). */
	FZ_FUNCTION void pdf_set_annot_callout_line2(std::vector<fz_point> &callout) const;

	/** Class-aware wrapper for `::pdf_set_annot_callout_point()`.  */
	FZ_FUNCTION void pdf_set_annot_callout_point(const FzPoint& p) const;

	/** Class-aware wrapper for `::pdf_set_annot_callout_style()`.  */
	FZ_FUNCTION void pdf_set_annot_callout_style(enum pdf_line_ending style) const;

	/** Class-aware wrapper for `::pdf_set_annot_color()`.  */
	FZ_FUNCTION void pdf_set_annot_color(int n, const float *color) const;

	/** Class-aware wrapper for `::pdf_set_annot_contents()`.  */
	FZ_FUNCTION void pdf_set_annot_contents(const char *text) const;

	/** Class-aware wrapper for `::pdf_set_annot_creation_date()`.  */
	FZ_FUNCTION void pdf_set_annot_creation_date(int64_t time) const;

	/** Class-aware wrapper for `::pdf_set_annot_default_appearance()`.  */
	FZ_FUNCTION void pdf_set_annot_default_appearance(const char *font, float size, int n, const float *color) const;

	/** Class-aware wrapper for `::pdf_set_annot_filespec()`.  */
	FZ_FUNCTION void pdf_set_annot_filespec(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_set_annot_flags()`.  */
	FZ_FUNCTION void pdf_set_annot_flags(int flags) const;

	/** Class-aware wrapper for `::pdf_set_annot_hidden_for_editing()`.  */
	FZ_FUNCTION void pdf_set_annot_hidden_for_editing(int hidden) const;

	/** Class-aware wrapper for `::pdf_set_annot_hot()`.  */
	FZ_FUNCTION void pdf_set_annot_hot(int hot) const;

	/** Class-aware wrapper for `::pdf_set_annot_icon_name()`.  */
	FZ_FUNCTION void pdf_set_annot_icon_name(const char *name) const;

	/** Class-aware wrapper for `::pdf_set_annot_ink_list()`.  */
	FZ_FUNCTION void pdf_set_annot_ink_list(int n, const int *count, FzPoint& v) const;

	/** Class-aware wrapper for `::pdf_set_annot_intent()`.  */
	FZ_FUNCTION void pdf_set_annot_intent(enum pdf_intent it) const;

	/** Class-aware wrapper for `::pdf_set_annot_interior_color()`.  */
	FZ_FUNCTION void pdf_set_annot_interior_color(int n, const float *color) const;

	/** Class-aware wrapper for `::pdf_set_annot_is_open()`.  */
	FZ_FUNCTION void pdf_set_annot_is_open(int is_open) const;

	/** Class-aware wrapper for `::pdf_set_annot_language()`.  */
	FZ_FUNCTION void pdf_set_annot_language(::fz_text_language lang) const;

	/** Class-aware wrapper for `::pdf_set_annot_line()`.  */
	FZ_FUNCTION void pdf_set_annot_line(const FzPoint& a, const FzPoint& b) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_caption()`.  */
	FZ_FUNCTION void pdf_set_annot_line_caption(int cap) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_caption_offset()`.  */
	FZ_FUNCTION void pdf_set_annot_line_caption_offset(const FzPoint& offset) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_end_style()`.  */
	FZ_FUNCTION void pdf_set_annot_line_end_style(enum pdf_line_ending e) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_ending_styles()`.  */
	FZ_FUNCTION void pdf_set_annot_line_ending_styles(enum pdf_line_ending start_style, enum pdf_line_ending end_style) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_leader()`.  */
	FZ_FUNCTION void pdf_set_annot_line_leader(float ll) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_leader_extension()`.  */
	FZ_FUNCTION void pdf_set_annot_line_leader_extension(float lle) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_leader_offset()`.  */
	FZ_FUNCTION void pdf_set_annot_line_leader_offset(float llo) const;

	/** Class-aware wrapper for `::pdf_set_annot_line_start_style()`.  */
	FZ_FUNCTION void pdf_set_annot_line_start_style(enum pdf_line_ending s) const;

	/** Class-aware wrapper for `::pdf_set_annot_modification_date()`.  */
	FZ_FUNCTION void pdf_set_annot_modification_date(int64_t time) const;

	/** Class-aware wrapper for `::pdf_set_annot_opacity()`.  */
	FZ_FUNCTION void pdf_set_annot_opacity(float opacity) const;

	/** Class-aware wrapper for `::pdf_set_annot_popup()`.  */
	FZ_FUNCTION void pdf_set_annot_popup(const FzRect& rect) const;

	/** Class-aware wrapper for `::pdf_set_annot_quad_points()`.  */
	FZ_FUNCTION void pdf_set_annot_quad_points(int n, FzQuad& qv) const;

	/** Class-aware wrapper for `::pdf_set_annot_quadding()`.  */
	FZ_FUNCTION void pdf_set_annot_quadding(int q) const;

	/** Class-aware wrapper for `::pdf_set_annot_rect()`.  */
	FZ_FUNCTION void pdf_set_annot_rect(const FzRect& rect) const;

	/** Class-aware wrapper for `::pdf_set_annot_resynthesised()`.  */
	FZ_FUNCTION void pdf_set_annot_resynthesised() const;

	/** Class-aware wrapper for `::pdf_set_annot_rich_contents()`.  */
	FZ_FUNCTION void pdf_set_annot_rich_contents(const char *plain, const char *rich) const;

	/** Class-aware wrapper for `::pdf_set_annot_rich_defaults()`.  */
	FZ_FUNCTION void pdf_set_annot_rich_defaults(const char *style) const;

	/** Class-aware wrapper for `::pdf_set_annot_stamp_image()`.  */
	FZ_FUNCTION void pdf_set_annot_stamp_image(const FzImage& image) const;

	/** Class-aware wrapper for `::pdf_set_annot_stamp_image_obj()`.  */
	FZ_FUNCTION void pdf_set_annot_stamp_image_obj(const PdfObj& ref) const;

	/** Class-aware wrapper for `::pdf_set_annot_vertex()`.  */
	FZ_FUNCTION void pdf_set_annot_vertex(int i, const FzPoint& p) const;

	/** Class-aware wrapper for `::pdf_set_annot_vertices()`.  */
	FZ_FUNCTION void pdf_set_annot_vertices(int n, FzPoint& v) const;

	/** Class-aware wrapper for `::pdf_set_choice_field_value()`.  */
	FZ_FUNCTION int pdf_set_choice_field_value(const char *value) const;

	/** Class-aware wrapper for `::pdf_set_text_field_value()`.  */
	FZ_FUNCTION int pdf_set_text_field_value(const char *value) const;

	/** Class-aware wrapper for `::pdf_set_widget_editing_state()`.  */
	FZ_FUNCTION void pdf_set_widget_editing_state(int editing) const;

	/** Class-aware wrapper for `::pdf_sign_signature()`.  */
	FZ_FUNCTION void pdf_sign_signature(const PdfPkcs7Signer& signer, int appearance_flags, const FzImage& graphic, const char *reason, const char *location) const;

	/** Class-aware wrapper for `::pdf_sign_signature_with_appearance()`.  */
	FZ_FUNCTION void pdf_sign_signature_with_appearance(const PdfPkcs7Signer& signer, int64_t date, const FzDisplayList& disp_list) const;

	/** Class-aware wrapper for `::pdf_text_widget_format()`.  */
	FZ_FUNCTION int pdf_text_widget_format() const;

	/** Class-aware wrapper for `::pdf_text_widget_max_len()`.  */
	FZ_FUNCTION int pdf_text_widget_max_len() const;

	/** Class-aware wrapper for `::pdf_toggle_widget()`.  */
	FZ_FUNCTION int pdf_toggle_widget() const;

	/** Class-aware wrapper for `::pdf_update_annot()`.  */
	FZ_FUNCTION int pdf_update_annot() const;

	/** Class-aware wrapper for `::pdf_update_widget()`.  */
	FZ_FUNCTION int pdf_update_widget() const;

	/** Class-aware wrapper for `::pdf_validate_signature()`.  */
	FZ_FUNCTION int pdf_validate_signature() const;

	/** Class-aware wrapper for `::pdf_widget_is_readonly()`.  */
	FZ_FUNCTION int pdf_widget_is_readonly() const;

	/** Class-aware wrapper for `::pdf_widget_is_signed()`.  */
	FZ_FUNCTION int pdf_widget_is_signed() const;

	/** Class-aware wrapper for `::pdf_widget_type()`.  */
	FZ_FUNCTION enum pdf_widget_type pdf_widget_type() const;

	/** Constructor using raw copy of pre-existing `::pdf_annot`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_annot* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfAnnot(::pdf_annot* internal=NULL);

	/** Destructor using pdf_drop_annot(). */
	FZ_FUNCTION ~PdfAnnot();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_annot* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_clean_options`. */
struct PdfCleanOptions
{
	/** Default constructor, makes copy of pdf_default_write_options. */
	FZ_FUNCTION PdfCleanOptions();

	/** Copy constructor using raw memcopy(). */
	FZ_FUNCTION PdfCleanOptions(const PdfCleanOptions& rhs);

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Assignment using plain memcpy(). */
	FZ_FUNCTION PdfCleanOptions& operator=(const PdfCleanOptions& rhs);

	/** Copies <text> into write.opwd_utf8[]. */
	FZ_FUNCTION void write_opwd_utf8_set(const std::string& text);

	/** Copies <text> into upwd_utf8[]. */
	FZ_FUNCTION void write_upwd_utf8_set(const std::string& text);

	/** Constructor using raw copy of pre-existing `::pdf_clean_options`. */
	FZ_FUNCTION PdfCleanOptions(const ::pdf_clean_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_clean_options`. */
	FZ_FUNCTION PdfCleanOptions(const ::pdf_clean_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_clean_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_clean_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfCleanOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_clean_options. */
	::pdf_write_options write;
	::pdf_image_rewriter_options image;
	int subset_fonts;
	::pdf_clean_options_structure structure;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfCleanOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfCleanOptions& rhs);
};

/** Wrapper class for struct `pdf_cmap`. */
struct PdfCmap
{
	/** == Constructors. */

	/** Constructor using `pdf_new_cmap()`. */
	FZ_FUNCTION PdfCmap();

	/** Constructor using `pdf_new_identity_cmap()`. */
	FZ_FUNCTION PdfCmap(int wmode, int bytes);

	/** Copy constructor using `pdf_keep_cmap()`. */
	FZ_FUNCTION PdfCmap(const PdfCmap& rhs);

	/** operator= using `pdf_keep_cmap()` and `pdf_drop_cmap()`. */
	FZ_FUNCTION PdfCmap& operator=(const PdfCmap& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_add_codespace()`.  */
	FZ_FUNCTION void pdf_add_codespace(unsigned int low, unsigned int high, size_t n) const;

	/** Class-aware wrapper for `::pdf_cmap_size()`.  */
	FZ_FUNCTION size_t pdf_cmap_size() const;

	/** Class-aware wrapper for `::pdf_cmap_wmode()`.  */
	FZ_FUNCTION int pdf_cmap_wmode() const;

	/** Class-aware wrapper for `::pdf_decode_cmap()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_decode_cmap(unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
	 */
	FZ_FUNCTION int pdf_decode_cmap(unsigned char *s, unsigned char *e, unsigned int *cpt) const;

	/** Class-aware wrapper for `::pdf_lookup_cmap()`.  */
	FZ_FUNCTION int pdf_lookup_cmap(unsigned int cpt) const;

	/** Class-aware wrapper for `::pdf_lookup_cmap_full()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_lookup_cmap_full(unsigned int cpt)` => `(int, int out)`
	 */
	FZ_FUNCTION int pdf_lookup_cmap_full(unsigned int cpt, int *out) const;

	/** Class-aware wrapper for `::pdf_map_one_to_many()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_map_one_to_many(unsigned int one, size_t len)` => int many
	 */
	FZ_FUNCTION void pdf_map_one_to_many(unsigned int one, int *many, size_t len) const;

	/** Class-aware wrapper for `::pdf_map_range_to_range()`.  */
	FZ_FUNCTION void pdf_map_range_to_range(unsigned int srclo, unsigned int srchi, int dstlo) const;

	/** Class-aware wrapper for `::pdf_set_cmap_wmode()`.  */
	FZ_FUNCTION void pdf_set_cmap_wmode(int wmode) const;

	/** Class-aware wrapper for `::pdf_set_usecmap()`.  */
	FZ_FUNCTION void pdf_set_usecmap(const PdfCmap& usecmap) const;

	/** Class-aware wrapper for `::pdf_sort_cmap()`.  */
	FZ_FUNCTION void pdf_sort_cmap() const;

	/** Constructor using raw copy of pre-existing `::pdf_cmap`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_cmap* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfCmap(::pdf_cmap* internal);

	/** Destructor using pdf_drop_cmap(). */
	FZ_FUNCTION ~PdfCmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_cmap* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_color_filter_options`. Not copyable or assignable. */
struct PdfColorFilterOptions
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfColorFilterOptions();

	/** Constructor using raw copy of pre-existing `::pdf_color_filter_options`. */
	FZ_FUNCTION PdfColorFilterOptions(::pdf_color_filter_options* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfColorFilterOptions();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_color_filter_options* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfColorFilterOptions(const PdfColorFilterOptions& rhs);
	PdfColorFilterOptions& operator=(const PdfColorFilterOptions& rhs);
};

/** Wrapper class for struct `pdf_colorspace_resource_key`. Not copyable or assignable. */
struct PdfColorspaceResourceKey
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfColorspaceResourceKey();

	/** Constructor using raw copy of pre-existing `::pdf_colorspace_resource_key`. */
	FZ_FUNCTION PdfColorspaceResourceKey(::pdf_colorspace_resource_key* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfColorspaceResourceKey();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_colorspace_resource_key* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfColorspaceResourceKey(const PdfColorspaceResourceKey& rhs);
	PdfColorspaceResourceKey& operator=(const PdfColorspaceResourceKey& rhs);
};

/** Wrapper class for struct `pdf_crypt`. Not copyable or assignable. */
struct PdfCrypt
{
	/** == Constructors. */

	/** Constructor using `pdf_new_crypt()`. */
	FZ_FUNCTION PdfCrypt(const PdfObj& enc, const PdfObj& id);

	/** Constructor using `pdf_new_encrypt()`. */
	FZ_FUNCTION PdfCrypt(const char *opwd_utf8, const char *upwd_utf8, const PdfObj& id, int permissions, int algorithm);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfCrypt();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_crypt_encrypt_metadata()`.  */
	FZ_FUNCTION int pdf_crypt_encrypt_metadata() const;

	/** Class-aware wrapper for `::pdf_crypt_key()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_key() const;

	/** Class-aware wrapper for `::pdf_crypt_length()`.  */
	FZ_FUNCTION int pdf_crypt_length() const;

	/** Class-aware wrapper for `::pdf_crypt_method()`.  */
	FZ_FUNCTION const char *pdf_crypt_method() const;

	/** Class-aware wrapper for `::pdf_crypt_obj()`.  */
	FZ_FUNCTION void pdf_crypt_obj(const PdfObj& obj, int num, int gen) const;

	/** Class-aware wrapper for `::pdf_crypt_owner_encryption()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_owner_encryption() const;

	/** Class-aware wrapper for `::pdf_crypt_owner_password()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_owner_password() const;

	/** Class-aware wrapper for `::pdf_crypt_permissions()`.  */
	FZ_FUNCTION int pdf_crypt_permissions() const;

	/** Class-aware wrapper for `::pdf_crypt_permissions_encryption()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_permissions_encryption() const;

	/** Class-aware wrapper for `::pdf_crypt_revision()`.  */
	FZ_FUNCTION int pdf_crypt_revision() const;

	/** Class-aware wrapper for `::pdf_crypt_stream_method()`.  */
	FZ_FUNCTION const char *pdf_crypt_stream_method() const;

	/** Class-aware wrapper for `::pdf_crypt_string_method()`.  */
	FZ_FUNCTION const char *pdf_crypt_string_method() const;

	/** Class-aware wrapper for `::pdf_crypt_user_encryption()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_user_encryption() const;

	/** Class-aware wrapper for `::pdf_crypt_user_password()`.  */
	FZ_FUNCTION unsigned char *pdf_crypt_user_password() const;

	/** Class-aware wrapper for `::pdf_crypt_version()`.  */
	FZ_FUNCTION int pdf_crypt_version() const;

	/** Class-aware wrapper for `::pdf_encrypt_data()`.  */
	FZ_FUNCTION void pdf_encrypt_data(int num, int gen, void (*fmt_str_out)(::fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n) const;

	/** Class-aware wrapper for `::pdf_encrypted_len()`.  */
	FZ_FUNCTION size_t pdf_encrypted_len(int num, int gen, size_t len) const;

	/** Constructor using raw copy of pre-existing `::pdf_crypt`. */
	FZ_FUNCTION PdfCrypt(::pdf_crypt* internal);

	/** Destructor using pdf_drop_crypt(). */
	FZ_FUNCTION ~PdfCrypt();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_crypt* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfCrypt(const PdfCrypt& rhs);
	PdfCrypt& operator=(const PdfCrypt& rhs);
};

/** Wrapper class for struct `pdf_csi`. Not copyable or assignable. */
struct PdfCsi
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfCsi();

	/** Constructor using raw copy of pre-existing `::pdf_csi`. */
	FZ_FUNCTION PdfCsi(::pdf_csi* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfCsi();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_csi* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfCsi(const PdfCsi& rhs);
	PdfCsi& operator=(const PdfCsi& rhs);
};

/** Wrapper class for struct `pdf_cycle_list`. Not copyable or assignable. */
struct PdfCycleList
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfCycleList();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_cycle()`.  */
	FZ_FUNCTION int pdf_cycle(const PdfCycleList& prev, const PdfObj& obj) const;

	/** Constructor using raw copy of pre-existing `::pdf_cycle_list`. */
	FZ_FUNCTION PdfCycleList(::pdf_cycle_list* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfCycleList();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_cycle_list* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfCycleList(const PdfCycleList& rhs);
	PdfCycleList& operator=(const PdfCycleList& rhs);
};

/** Wrapper class for struct `pdf_doc_event`. Not copyable or assignable. */
struct PdfDocEvent
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfDocEvent();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_access_exec_menu_item_event()`.  */
	FZ_FUNCTION const char *pdf_access_exec_menu_item_event() const;

	/** Constructor using raw copy of pre-existing `::pdf_doc_event`. */
	FZ_FUNCTION PdfDocEvent(::pdf_doc_event* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfDocEvent();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_doc_event* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfDocEvent(const PdfDocEvent& rhs);
	PdfDocEvent& operator=(const PdfDocEvent& rhs);
};

/** Wrapper class for struct `pdf_document`. */
struct PdfDocument
{
	/** == Constructors. */

	/** Constructor using `pdf_create_document()`. */
	FZ_FUNCTION PdfDocument();

	/** Constructor using `pdf_document_from_fz_document()`. */
	FZ_FUNCTION PdfDocument(const FzDocument& ptr);

	/** Constructor using `pdf_open_document()`. */
	FZ_FUNCTION PdfDocument(const char *filename);

	/** Constructor using `pdf_open_document_with_stream()`. */
	FZ_FUNCTION PdfDocument(const FzStream& file);

	/** Copy constructor using `pdf_keep_document()`. */
	FZ_FUNCTION PdfDocument(const PdfDocument& rhs);

	/** operator= using `pdf_keep_document()` and `pdf_drop_document()`. */
	FZ_FUNCTION PdfDocument& operator=(const PdfDocument& rhs);

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_abandon_operation()`.  */
	FZ_FUNCTION void pdf_abandon_operation() const;

	/** Class-aware wrapper for `::pdf_add_cid_font()`.  */
	FZ_FUNCTION PdfObj pdf_add_cid_font(const FzFont& font) const;

	/** Class-aware wrapper for `::pdf_add_cjk_font()`.  */
	FZ_FUNCTION PdfObj pdf_add_cjk_font(const FzFont& font, int script, int wmode, int serif) const;

	/** Class-aware wrapper for `::pdf_add_colorspace()`.  */
	FZ_FUNCTION PdfObj pdf_add_colorspace(const FzColorspace& cs) const;

	/** Class-aware wrapper for `::pdf_add_embedded_file()`.  */
	FZ_FUNCTION PdfObj pdf_add_embedded_file(const char *filename, const char *mimetype, const FzBuffer& contents, int64_t created, int64_t modified, int add_checksum) const;

	/** Class-aware wrapper for `::pdf_add_image()`.  */
	FZ_FUNCTION PdfObj pdf_add_image(const FzImage& image) const;

	/** Class-aware wrapper for `::pdf_add_journal_fragment()`.  */
	FZ_FUNCTION void pdf_add_journal_fragment(int parent, const PdfObj& copy, const FzBuffer& copy_stream, int newobj) const;

	/** Class-aware wrapper for `::pdf_add_new_array()`.  */
	FZ_FUNCTION PdfObj pdf_add_new_array(int initial) const;

	/** Class-aware wrapper for `::pdf_add_new_dict()`.  */
	FZ_FUNCTION PdfObj pdf_add_new_dict(int initial) const;

	/** Class-aware wrapper for `::pdf_add_object()`.  */
	FZ_FUNCTION PdfObj pdf_add_object(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_add_page()`.  */
	FZ_FUNCTION PdfObj pdf_add_page(const FzRect& mediabox, int rotate, const PdfObj& resources, const FzBuffer& contents) const;

	/** Class-aware wrapper for `::pdf_add_simple_font()`.  */
	FZ_FUNCTION PdfObj pdf_add_simple_font(const FzFont& font, int encoding) const;

	/** Class-aware wrapper for `::pdf_add_stream()`.  */
	FZ_FUNCTION PdfObj pdf_add_stream(const FzBuffer& buf, const PdfObj& obj, int compressed) const;

	/** Class-aware wrapper for `::pdf_add_substitute_font()`.  */
	FZ_FUNCTION PdfObj pdf_add_substitute_font(const FzFont& font) const;

	/** Class-aware wrapper for `::pdf_annot_field_event_keystroke()`.  */
	FZ_FUNCTION int pdf_annot_field_event_keystroke(const PdfAnnot& annot, const PdfKeystrokeEvent& evt) const;

	/** Class-aware wrapper for `::pdf_authenticate_password()`.  */
	FZ_FUNCTION int pdf_authenticate_password(const char *pw) const;

	/** Class-aware wrapper for `::pdf_bake_document()`.  */
	FZ_FUNCTION void pdf_bake_document(int bake_annots, int bake_widgets) const;

	/** Class-aware wrapper for `::pdf_begin_implicit_operation()`.  */
	FZ_FUNCTION void pdf_begin_implicit_operation() const;

	/** Class-aware wrapper for `::pdf_begin_operation()`.  */
	FZ_FUNCTION void pdf_begin_operation(const char *operation) const;

	/** Class-aware wrapper for `::pdf_calculate_form()`.  */
	FZ_FUNCTION void pdf_calculate_form() const;

	/** Class-aware wrapper for `::pdf_can_be_saved_incrementally()`.  */
	FZ_FUNCTION int pdf_can_be_saved_incrementally() const;

	/** Class-aware wrapper for `::pdf_can_redo()`.  */
	FZ_FUNCTION int pdf_can_redo() const;

	/** Class-aware wrapper for `::pdf_can_undo()`.  */
	FZ_FUNCTION int pdf_can_undo() const;

	/** Class-aware wrapper for `::pdf_clear_xref()`.  */
	FZ_FUNCTION void pdf_clear_xref() const;

	/** Class-aware wrapper for `::pdf_clear_xref_to_mark()`.  */
	FZ_FUNCTION void pdf_clear_xref_to_mark() const;

	/** Class-aware wrapper for `::pdf_count_document_associated_files()`.  */
	FZ_FUNCTION int pdf_count_document_associated_files() const;

	/** Class-aware wrapper for `::pdf_count_layer_config_ui()`.  */
	FZ_FUNCTION int pdf_count_layer_config_ui() const;

	/** Class-aware wrapper for `::pdf_count_layer_configs()`.  */
	FZ_FUNCTION int pdf_count_layer_configs() const;

	/** Class-aware wrapper for `::pdf_count_layers()`.  */
	FZ_FUNCTION int pdf_count_layers() const;

	/** Class-aware wrapper for `::pdf_count_objects()`.  */
	FZ_FUNCTION int pdf_count_objects() const;

	/** Class-aware wrapper for `::pdf_count_pages()`.  */
	FZ_FUNCTION int pdf_count_pages() const;

	/** Class-aware wrapper for `::pdf_count_q_balance()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_count_q_balance(::pdf_obj *res, ::pdf_obj *stm)` => `(int prepend, int append)`
	 */
	FZ_FUNCTION void pdf_count_q_balance(const PdfObj& res, const PdfObj& stm, int *prepend, int *append) const;

	/** Class-aware wrapper for `::pdf_count_signatures()`.  */
	FZ_FUNCTION int pdf_count_signatures() const;

	/** Class-aware wrapper for `::pdf_count_unsaved_versions()`.  */
	FZ_FUNCTION int pdf_count_unsaved_versions() const;

	/** Class-aware wrapper for `::pdf_count_versions()`.  */
	FZ_FUNCTION int pdf_count_versions() const;

	/** Class-aware wrapper for `::pdf_create_field_name()`.  */
	FZ_FUNCTION void pdf_create_field_name(const char *prefix, char *buf, size_t len) const;

	/** Class-aware wrapper for `::pdf_create_object()`.  */
	FZ_FUNCTION int pdf_create_object() const;

	/** Class-aware wrapper for `::pdf_debug_doc_changes()`.  */
	FZ_FUNCTION void pdf_debug_doc_changes() const;

	/** Class-aware wrapper for `::pdf_delete_object()`.  */
	FZ_FUNCTION void pdf_delete_object(int num) const;

	/** Class-aware wrapper for `::pdf_delete_page()`.  */
	FZ_FUNCTION void pdf_delete_page(int number) const;

	/** Class-aware wrapper for `::pdf_delete_page_labels()`.  */
	FZ_FUNCTION void pdf_delete_page_labels(int index) const;

	/** Class-aware wrapper for `::pdf_delete_page_range()`.  */
	FZ_FUNCTION void pdf_delete_page_range(int start, int end) const;

	/** Class-aware wrapper for `::pdf_deselect_layer_config_ui()`.  */
	FZ_FUNCTION void pdf_deselect_layer_config_ui(int ui) const;

	/** Class-aware wrapper for `::pdf_deserialise_journal()`.  */
	FZ_FUNCTION void pdf_deserialise_journal(const FzStream& stm) const;

	/** Class-aware wrapper for `::pdf_disable_js()`.  */
	FZ_FUNCTION void pdf_disable_js() const;

	/** Class-aware wrapper for `::pdf_doc_was_linearized()`.  */
	FZ_FUNCTION int pdf_doc_was_linearized() const;

	/** Class-aware wrapper for `::pdf_document_associated_file()`.  */
	FZ_FUNCTION PdfObj pdf_document_associated_file(int idx) const;

	/** Class-aware wrapper for `::pdf_document_event_did_print()`.  */
	FZ_FUNCTION void pdf_document_event_did_print() const;

	/** Class-aware wrapper for `::pdf_document_event_did_save()`.  */
	FZ_FUNCTION void pdf_document_event_did_save() const;

	/** Class-aware wrapper for `::pdf_document_event_will_close()`.  */
	FZ_FUNCTION void pdf_document_event_will_close() const;

	/** Class-aware wrapper for `::pdf_document_event_will_print()`.  */
	FZ_FUNCTION void pdf_document_event_will_print() const;

	/** Class-aware wrapper for `::pdf_document_event_will_save()`.  */
	FZ_FUNCTION void pdf_document_event_will_save() const;

	/** Class-aware wrapper for `::pdf_document_output_intent()`.  */
	FZ_FUNCTION FzColorspace pdf_document_output_intent() const;

	/** Class-aware wrapper for `::pdf_document_permissions()`.  */
	FZ_FUNCTION int pdf_document_permissions() const;

	/** Class-aware wrapper for `::pdf_empty_store()`.  */
	FZ_FUNCTION void pdf_empty_store() const;

	/** Class-aware wrapper for `::pdf_enable_journal()`.  */
	FZ_FUNCTION void pdf_enable_journal() const;

	/** Class-aware wrapper for `::pdf_enable_js()`.  */
	FZ_FUNCTION void pdf_enable_js() const;

	/** Class-aware wrapper for `::pdf_enable_layer()`.  */
	FZ_FUNCTION void pdf_enable_layer(int layer, int enabled) const;

	/** Class-aware wrapper for `::pdf_end_operation()`.  */
	FZ_FUNCTION void pdf_end_operation() const;

	/** Class-aware wrapper for `::pdf_ensure_solid_xref()`.  */
	FZ_FUNCTION void pdf_ensure_solid_xref(int num) const;

	/** Class-aware wrapper for `::pdf_event_issue_alert()`.  */
	FZ_FUNCTION void pdf_event_issue_alert(const PdfAlertEvent& evt) const;

	/** Class-aware wrapper for `::pdf_event_issue_exec_menu_item()`.  */
	FZ_FUNCTION void pdf_event_issue_exec_menu_item(const char *item) const;

	/** Class-aware wrapper for `::pdf_event_issue_launch_url()`.  */
	FZ_FUNCTION void pdf_event_issue_launch_url(const char *url, int new_frame) const;

	/** Class-aware wrapper for `::pdf_event_issue_mail_doc()`.  */
	FZ_FUNCTION void pdf_event_issue_mail_doc(const PdfMailDocEvent& evt) const;

	/** Class-aware wrapper for `::pdf_event_issue_print()`.  */
	FZ_FUNCTION void pdf_event_issue_print() const;

	/** Class-aware wrapper for `::pdf_field_event_calculate()`.  */
	FZ_FUNCTION void pdf_field_event_calculate(const PdfObj& field) const;

	/** Class-aware wrapper for `::pdf_field_event_format()`.  */
	FZ_FUNCTION char *pdf_field_event_format(const PdfObj& field) const;

	/** Class-aware wrapper for `::pdf_field_event_keystroke()`.  */
	FZ_FUNCTION int pdf_field_event_keystroke(const PdfObj& field, const PdfKeystrokeEvent& evt) const;

	/** Class-aware wrapper for `::pdf_field_event_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_field_event_validate(::pdf_obj *field, const char *value)` => `(int, char *newvalue)`
	 */
	FZ_FUNCTION int pdf_field_event_validate(const PdfObj& field, const char *value, char **newvalue) const;

	/** Class-aware wrapper for `::pdf_field_reset()`.  */
	FZ_FUNCTION void pdf_field_reset(const PdfObj& field) const;

	/** Class-aware wrapper for `::pdf_filter_annot_contents()`.  */
	FZ_FUNCTION void pdf_filter_annot_contents(const PdfAnnot& annot, PdfFilterOptions& options) const;

	/** Class-aware wrapper for `::pdf_filter_page_contents()`.  */
	FZ_FUNCTION void pdf_filter_page_contents(const PdfPage& page, PdfFilterOptions& options) const;

	/** Class-aware wrapper for `::pdf_find_colorspace_resource()`.  */
	FZ_FUNCTION PdfObj pdf_find_colorspace_resource(const FzColorspace& item, const PdfColorspaceResourceKey& key) const;

	/** Class-aware wrapper for `::pdf_find_font_resource()`.  */
	FZ_FUNCTION PdfObj pdf_find_font_resource(int type, int encoding, const FzFont& item, const PdfFontResourceKey& key) const;

	/** Class-aware wrapper for `::pdf_find_version_for_obj()`.  */
	FZ_FUNCTION int pdf_find_version_for_obj(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_forget_xref()`.  */
	FZ_FUNCTION void pdf_forget_xref() const;

	/** Class-aware wrapper for `::pdf_get_doc_event_callback_data()`.  */
	FZ_FUNCTION void *pdf_get_doc_event_callback_data() const;

	/** Class-aware wrapper for `::pdf_graft_object()`.  */
	FZ_FUNCTION PdfObj pdf_graft_object(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_graft_page()`.  */
	FZ_FUNCTION void pdf_graft_page(int page_to, const PdfDocument& src, int page_from) const;

	/** Class-aware wrapper for `::pdf_has_permission()`.  */
	FZ_FUNCTION int pdf_has_permission(::fz_permission p) const;

	/** Class-aware wrapper for `::pdf_has_unsaved_changes()`.  */
	FZ_FUNCTION int pdf_has_unsaved_changes() const;

	/** Class-aware wrapper for `::pdf_has_unsaved_sigs()`.  */
	FZ_FUNCTION int pdf_has_unsaved_sigs() const;

	/** Class-aware wrapper for `::pdf_insert_colorspace_resource()`.  */
	FZ_FUNCTION PdfObj pdf_insert_colorspace_resource(const PdfColorspaceResourceKey& key, const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_insert_font_resource()`.  */
	FZ_FUNCTION PdfObj pdf_insert_font_resource(const PdfFontResourceKey& key, const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_insert_page()`.  */
	FZ_FUNCTION void pdf_insert_page(int at, const PdfObj& page) const;

	/** Class-aware wrapper for `::pdf_invalidate_xfa()`.  */
	FZ_FUNCTION void pdf_invalidate_xfa() const;

	/** Class-aware wrapper for `::pdf_is_local_object()`.  */
	FZ_FUNCTION int pdf_is_local_object(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_is_ocg_hidden()`.  */
	FZ_FUNCTION int pdf_is_ocg_hidden(const PdfObj& rdb, const char *usage, const PdfObj& ocg) const;

	/** Class-aware wrapper for `::pdf_js_set_console()`.  */
	FZ_FUNCTION void pdf_js_set_console(const PdfJsConsole& console, void *user) const;

	/** Class-aware wrapper for `::pdf_js_supported()`.  */
	FZ_FUNCTION int pdf_js_supported() const;

	/** Class-aware wrapper for `::pdf_layer_config_info()`.  */
	FZ_FUNCTION void pdf_layer_config_info(int config_num, PdfLayerConfig& info) const;

	/** Class-aware wrapper for `::pdf_layer_config_ui_info()`.  */
	FZ_FUNCTION void pdf_layer_config_ui_info(int ui, PdfLayerConfigUi& info) const;

	/** Class-aware wrapper for `::pdf_layer_is_enabled()`.  */
	FZ_FUNCTION int pdf_layer_is_enabled(int layer) const;

	/** Class-aware wrapper for `::pdf_layer_name()`.  */
	FZ_FUNCTION const char *pdf_layer_name(int layer) const;

	/** Class-aware wrapper for `::pdf_load_compressed_inline_image()`.  */
	FZ_FUNCTION void pdf_load_compressed_inline_image(const PdfObj& dict, int length, const FzStream& cstm, int indexed, const FzCompressedImage& image) const;

	/** Class-aware wrapper for `::pdf_load_compressed_stream()`.  */
	FZ_FUNCTION FzCompressedBuffer pdf_load_compressed_stream(int num, size_t worst_case) const;

	/** Class-aware wrapper for `::pdf_load_default_colorspaces()`.  */
	FZ_FUNCTION FzDefaultColorspaces pdf_load_default_colorspaces(const PdfPage& page) const;

	/** Class-aware wrapper for `::pdf_load_embedded_cmap()`.  */
	FZ_FUNCTION PdfCmap pdf_load_embedded_cmap(const PdfObj& ref) const;

	/** Class-aware wrapper for `::pdf_load_image()`.  */
	FZ_FUNCTION FzImage pdf_load_image(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_load_inline_image()`.  */
	FZ_FUNCTION FzImage pdf_load_inline_image(const PdfObj& rdb, const PdfObj& dict, const FzStream& file) const;

	/** Class-aware wrapper for `::pdf_load_journal()`.  */
	FZ_FUNCTION void pdf_load_journal(const char *filename) const;

	/** Class-aware wrapper for `::pdf_load_link_annots()`.  */
	FZ_FUNCTION FzLink pdf_load_link_annots(const PdfPage& arg_1, const PdfObj& annots, int pagenum, const FzMatrix& page_ctm) const;

	/** Class-aware wrapper for `::pdf_load_name_tree()`.  */
	FZ_FUNCTION PdfObj pdf_load_name_tree(const PdfObj& which) const;

	/** Class-aware wrapper for `::pdf_load_object()`.  */
	/**
		Load a given object.
	
		This can cause xref reorganisations (solidifications etc) due to
		repairs, so all held pdf_xref_entries should be considered
		invalid after this call (other than the returned one).
	*/
	FZ_FUNCTION PdfObj pdf_load_object(int num) const;

	/** Class-aware wrapper for `::pdf_load_outline()`.  */
	FZ_FUNCTION FzOutline pdf_load_outline() const;

	/** Class-aware wrapper for `::pdf_load_page()`.  */
	FZ_FUNCTION PdfPage pdf_load_page(int number) const;

	/** Class-aware wrapper for `::pdf_load_page_tree()`.  */
	FZ_FUNCTION void pdf_load_page_tree() const;

	/** Class-aware wrapper for `::pdf_load_pattern()`.  */
	FZ_FUNCTION PdfPattern pdf_load_pattern(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_load_raw_stream_number()`.  */
	FZ_FUNCTION FzBuffer pdf_load_raw_stream_number(int num) const;

	/** Class-aware wrapper for `::pdf_load_shading()`.  */
	FZ_FUNCTION FzShade pdf_load_shading(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_load_stream_number()`.  */
	FZ_FUNCTION FzBuffer pdf_load_stream_number(int num) const;

	/** Class-aware wrapper for `::pdf_load_to_unicode()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_load_to_unicode(::pdf_font_desc *font, char *collection, ::pdf_obj *cmapstm)` => const char *strings
	 */
	FZ_FUNCTION void pdf_load_to_unicode(const PdfFontDesc& font, const char **strings, char *collection, const PdfObj& cmapstm) const;

	/** Class-aware wrapper for `::pdf_load_type3_glyphs()`.  */
	FZ_FUNCTION void pdf_load_type3_glyphs(const PdfFontDesc& fontdesc) const;

	/** Class-aware wrapper for `::pdf_load_unencrypted_object()`.  */
	FZ_FUNCTION PdfObj pdf_load_unencrypted_object(int num) const;

	/** Class-aware wrapper for `::pdf_lookup_dest()`.  */
	FZ_FUNCTION PdfObj pdf_lookup_dest(const PdfObj& needle) const;

	/** Class-aware wrapper for `::pdf_lookup_metadata()`.  */
	FZ_FUNCTION int pdf_lookup_metadata(const char *key, char *ptr, size_t size) const;

	/** Class-aware wrapper for `::pdf_lookup_metadata2()`.  */
	/**
	C++ alternative to `pdf_lookup_metadata()` that returns a `std::string`
	or calls `fz_throw()` if not found.
	*/
	FZ_FUNCTION std::string pdf_lookup_metadata2(const char *key) const;

	/** Class-aware wrapper for `::pdf_lookup_name()`.  */
	FZ_FUNCTION PdfObj pdf_lookup_name(const PdfObj& which, const PdfObj& needle) const;

	/** Class-aware wrapper for `::pdf_lookup_page_loc()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_lookup_page_loc(int needle, ::pdf_obj **parentp)` => `(pdf_obj *, int indexp)`
	 */
	FZ_FUNCTION PdfObj pdf_lookup_page_loc(int needle, PdfObj& parentp, int *indexp) const;

	/** Class-aware wrapper for `::pdf_lookup_page_number()`.  */
	FZ_FUNCTION int pdf_lookup_page_number(const PdfObj& pageobj) const;

	/** Class-aware wrapper for `::pdf_lookup_page_obj()`.  */
	FZ_FUNCTION PdfObj pdf_lookup_page_obj(int needle) const;

	/** Class-aware wrapper for `::pdf_mark_xref()`.  */
	FZ_FUNCTION void pdf_mark_xref() const;

	/** Class-aware wrapper for `::pdf_metadata()`.  */
	FZ_FUNCTION PdfObj pdf_metadata() const;

	/** Class-aware wrapper for `::pdf_minimize_document()`.  */
	FZ_FUNCTION void pdf_minimize_document() const;

	/** Class-aware wrapper for `::pdf_needs_password()`.  */
	FZ_FUNCTION int pdf_needs_password() const;

	/** Class-aware wrapper for `::pdf_new_action_from_link()`.  */
	FZ_FUNCTION PdfObj pdf_new_action_from_link(const char *uri) const;

	/** Class-aware wrapper for `::pdf_new_array()`.  */
	FZ_FUNCTION PdfObj pdf_new_array(int initialcap) const;

	/** Class-aware wrapper for `::pdf_new_color_filter()`.  */
	FZ_FUNCTION PdfProcessor pdf_new_color_filter(const PdfProcessor& chain, int struct_parents, const FzMatrix& transform, PdfFilterOptions& options, void *copts) const;

	/** Class-aware wrapper for `::pdf_new_date()`.  */
	FZ_FUNCTION PdfObj pdf_new_date(int64_t time) const;

	/** Class-aware wrapper for `::pdf_new_dest_from_link()`.  */
	FZ_FUNCTION PdfObj pdf_new_dest_from_link(const char *uri, int is_remote) const;

	/** Class-aware wrapper for `::pdf_new_dict()`.  */
	FZ_FUNCTION PdfObj pdf_new_dict(int initialcap) const;

	/** Class-aware wrapper for `::pdf_new_graft_map()`.  */
	FZ_FUNCTION PdfGraftMap pdf_new_graft_map() const;

	/** Class-aware wrapper for `::pdf_new_indirect()`.  */
	FZ_FUNCTION PdfObj pdf_new_indirect(int num, int gen) const;

	/** Class-aware wrapper for `::pdf_new_matrix()`.  */
	FZ_FUNCTION PdfObj pdf_new_matrix(const FzMatrix& mtx) const;

	/** Class-aware wrapper for `::pdf_new_pdf_device()`.  */
	FZ_FUNCTION FzDevice pdf_new_pdf_device(const FzMatrix& topctm, const PdfObj& resources, const FzBuffer& contents) const;

	/** Class-aware wrapper for `::pdf_new_point()`.  */
	FZ_FUNCTION PdfObj pdf_new_point(const FzPoint& point) const;

	/** Class-aware wrapper for `::pdf_new_rect()`.  */
	FZ_FUNCTION PdfObj pdf_new_rect(const FzRect& rect) const;

	/** Class-aware wrapper for `::pdf_new_run_processor()`.  */
	FZ_FUNCTION PdfProcessor pdf_new_run_processor(const FzDevice& dev, const FzMatrix& ctm, int struct_parent, const char *usage, const PdfGstate& gstate, const FzDefaultColorspaces& default_cs, FzCookie& cookie, const PdfGstate& fill_gstate, const PdfGstate& stroke_gstate) const;

	/** Class-aware wrapper for `::pdf_new_sanitize_filter()`.  */
	FZ_FUNCTION PdfProcessor pdf_new_sanitize_filter(const PdfProcessor& chain, int struct_parents, const FzMatrix& transform, PdfFilterOptions& options, void *sopts) const;

	/** Class-aware wrapper for `::pdf_new_xobject()`.  */
	FZ_FUNCTION PdfObj pdf_new_xobject(const FzRect& bbox, const FzMatrix& matrix, const PdfObj& res, const FzBuffer& buffer) const;

	/** Class-aware wrapper for `::pdf_obj_num_is_stream()`.  */
	FZ_FUNCTION int pdf_obj_num_is_stream(int num) const;

	/** Class-aware wrapper for `::pdf_object_exists()`.  */
	FZ_FUNCTION int pdf_object_exists(int num) const;

	/** Class-aware wrapper for `::pdf_open_contents_stream()`.  */
	FZ_FUNCTION FzStream pdf_open_contents_stream(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_open_inline_stream()`.  */
	FZ_FUNCTION FzStream pdf_open_inline_stream(const PdfObj& stmobj, int length, const FzStream& chain, const FzCompressionParams& params) const;

	/** Class-aware wrapper for `::pdf_open_raw_stream_number()`.  */
	FZ_FUNCTION FzStream pdf_open_raw_stream_number(int num) const;

	/** Class-aware wrapper for `::pdf_open_stream_number()`.  */
	FZ_FUNCTION FzStream pdf_open_stream_number(int num) const;

	/** Class-aware wrapper for `::pdf_open_stream_with_offset()`.  */
	FZ_FUNCTION FzStream pdf_open_stream_with_offset(int num, const PdfObj& dict, int64_t stm_ofs) const;

	/** Class-aware wrapper for `::pdf_page_label()`.  */
	FZ_FUNCTION void pdf_page_label(int page, char *buf, size_t size) const;

	/** Class-aware wrapper for `::pdf_page_write()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_page_write(::fz_rect mediabox, ::pdf_obj **presources, ::fz_buffer **pcontents)` => `(fz_device *)`
	 */
	FZ_FUNCTION FzDevice pdf_page_write(const FzRect& mediabox, PdfObj& presources, FzBuffer& pcontents) const;

	/** Class-aware wrapper for `::pdf_parse_array()`.  */
	FZ_FUNCTION PdfObj pdf_parse_array(const FzStream& f, const PdfLexbuf& buf) const;

	/** Class-aware wrapper for `::pdf_parse_dict()`.  */
	FZ_FUNCTION PdfObj pdf_parse_dict(const FzStream& f, const PdfLexbuf& buf) const;

	/** Class-aware wrapper for `::pdf_parse_ind_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_parse_ind_obj(::fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
	 */
	FZ_FUNCTION PdfObj pdf_parse_ind_obj(const FzStream& f, int *num, int *gen, int64_t *stm_ofs, int *try_repair) const;

	/** Class-aware wrapper for `::pdf_parse_journal_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_parse_journal_obj(::fz_stream *stm, ::fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
	 */
	FZ_FUNCTION PdfObj pdf_parse_journal_obj(const FzStream& stm, int *onum, FzBuffer& ostm, int *newobj) const;

	/** Class-aware wrapper for `::pdf_parse_stm_obj()`.  */
	FZ_FUNCTION PdfObj pdf_parse_stm_obj(const FzStream& f, const PdfLexbuf& buf) const;

	/** Class-aware wrapper for `::pdf_progressive_advance()`.  */
	FZ_FUNCTION PdfObj pdf_progressive_advance(int pagenum) const;

	/** Class-aware wrapper for `::pdf_purge_local_resources()`.  */
	FZ_FUNCTION void pdf_purge_local_resources() const;

	/** Class-aware wrapper for `::pdf_purge_locals_from_store()`.  */
	FZ_FUNCTION void pdf_purge_locals_from_store() const;

	/** Class-aware wrapper for `::pdf_purge_object_from_store()`.  */
	FZ_FUNCTION void pdf_purge_object_from_store(int num) const;

	/** Class-aware wrapper for `::pdf_read_journal()`.  */
	FZ_FUNCTION void pdf_read_journal(const FzStream& stm) const;

	/** Class-aware wrapper for `::pdf_rearrange_pages()`.  */
	FZ_FUNCTION void pdf_rearrange_pages(int count, const int *pages, ::pdf_clean_options_structure structure) const;

	/** Class-aware wrapper for `::pdf_rearrange_pages2()`.  */
	/** Swig-friendly wrapper for pdf_rearrange_pages(). */
	FZ_FUNCTION void pdf_rearrange_pages2(const std::vector<int> &pages, ::pdf_clean_options_structure structure) const;

	/** Class-aware wrapper for `::pdf_recolor_page()`.  */
	FZ_FUNCTION void pdf_recolor_page(int pagenum, PdfRecolorOptions& opts) const;

	/** Class-aware wrapper for `::pdf_redact_page()`.  */
	FZ_FUNCTION int pdf_redact_page(const PdfPage& page, PdfRedactOptions& opts) const;

	/** Class-aware wrapper for `::pdf_redo()`.  */
	FZ_FUNCTION void pdf_redo() const;

	/** Class-aware wrapper for `::pdf_remove_output_intents()`.  */
	FZ_FUNCTION void pdf_remove_output_intents() const;

	/** Class-aware wrapper for `::pdf_repair_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_repair_obj(::pdf_lexbuf *buf, ::pdf_obj **encrypt, ::pdf_obj **id, ::pdf_obj **page, ::pdf_obj **root)` => `(int, int64_t stmofsp, int64_t stmlenp, int64_t tmpofs)`
	 */
	FZ_FUNCTION int pdf_repair_obj(const PdfLexbuf& buf, int64_t *stmofsp, int64_t *stmlenp, PdfObj& encrypt, PdfObj& id, PdfObj& page, int64_t *tmpofs, PdfObj& root) const;

	/** Class-aware wrapper for `::pdf_repair_xref()`.  */
	FZ_FUNCTION void pdf_repair_xref() const;

	/** Class-aware wrapper for `::pdf_replace_xref()`.  */
	FZ_FUNCTION void pdf_replace_xref(const PdfXrefEntry& entries, int n) const;

	/** Class-aware wrapper for `::pdf_reset_form()`.  */
	FZ_FUNCTION void pdf_reset_form(const PdfObj& fields, int exclude) const;

	/** Class-aware wrapper for `::pdf_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_resolve_link(const char *uri)` => `(int, float xp, float yp)`
	 */
	FZ_FUNCTION int pdf_resolve_link(const char *uri, float *xp, float *yp) const;

	/** Class-aware wrapper for `::pdf_rewrite_images()`.  */
	FZ_FUNCTION void pdf_rewrite_images(PdfImageRewriterOptions& opts) const;

	/** Class-aware wrapper for `::pdf_run_document_structure()`.  */
	FZ_FUNCTION void pdf_run_document_structure(const FzDevice& dev, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_glyph()`.  */
	FZ_FUNCTION void pdf_run_glyph(const PdfObj& resources, const FzBuffer& contents, const FzDevice& dev, const FzMatrix& ctm, void *gstate, const FzDefaultColorspaces& default_cs, void *fill_gstate, void *stroke_gstate) const;

	/** Class-aware wrapper for `::pdf_save_document()`.  */
	FZ_FUNCTION void pdf_save_document(const char *filename, PdfWriteOptions& opts) const;

	/** Class-aware wrapper for `::pdf_save_journal()`.  */
	FZ_FUNCTION void pdf_save_journal(const char *filename) const;

	/** Class-aware wrapper for `::pdf_save_snapshot()`.  */
	FZ_FUNCTION void pdf_save_snapshot(const char *filename) const;

	/** Class-aware wrapper for `::pdf_select_layer_config()`.  */
	FZ_FUNCTION void pdf_select_layer_config(int config_num) const;

	/** Class-aware wrapper for `::pdf_select_layer_config_ui()`.  */
	FZ_FUNCTION void pdf_select_layer_config_ui(int ui) const;

	/** Class-aware wrapper for `::pdf_serialise_journal()`.  */
	FZ_FUNCTION void pdf_serialise_journal(const FzOutput& out) const;

	/** Class-aware wrapper for `::pdf_set_annot_field_value()`.  */
	FZ_FUNCTION int pdf_set_annot_field_value(const PdfAnnot& widget, const char *text, int ignore_trigger_events) const;

	/** Class-aware wrapper for `::pdf_set_doc_event_callback()`.  */
	FZ_FUNCTION void pdf_set_doc_event_callback(::pdf_doc_event_cb *event_cb, ::pdf_free_doc_event_data_cb *free_event_data_cb, void *data) const;

	/** Class-aware wrapper for `::pdf_set_document_language()`.  */
	FZ_FUNCTION void pdf_set_document_language(::fz_text_language lang) const;

	/** Class-aware wrapper for `::pdf_set_field_value()`.  */
	FZ_FUNCTION int pdf_set_field_value(const PdfObj& field, const char *text, int ignore_trigger_events) const;

	/** Class-aware wrapper for `::pdf_set_layer_config_as_default()`.  */
	FZ_FUNCTION void pdf_set_layer_config_as_default() const;

	/** Class-aware wrapper for `::pdf_set_page_labels()`.  */
	FZ_FUNCTION void pdf_set_page_labels(int index, ::pdf_page_label_style style, const char *prefix, int start) const;

	/** Class-aware wrapper for `::pdf_set_populating_xref_trailer()`.  */
	FZ_FUNCTION void pdf_set_populating_xref_trailer(const PdfObj& trailer) const;

	/** Class-aware wrapper for `::pdf_signature_byte_range()`.  */
	FZ_FUNCTION int pdf_signature_byte_range(const PdfObj& signature, const FzRange& byte_range) const;

	/** Class-aware wrapper for `::pdf_signature_contents()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_signature_contents(::pdf_obj *signature)` => `(size_t, char *contents)`
	 */
	FZ_FUNCTION size_t pdf_signature_contents(const PdfObj& signature, char **contents) const;

	/** Class-aware wrapper for `::pdf_signature_hash_bytes()`.  */
	FZ_FUNCTION FzStream pdf_signature_hash_bytes(const PdfObj& signature) const;

	/** Class-aware wrapper for `::pdf_signature_incremental_change_since_signing()`.  */
	FZ_FUNCTION int pdf_signature_incremental_change_since_signing(const PdfObj& signature) const;

	/** Class-aware wrapper for `::pdf_signature_is_signed()`.  */
	FZ_FUNCTION int pdf_signature_is_signed(const PdfObj& field) const;

	/** Class-aware wrapper for `::pdf_signature_set_value()`.  */
	FZ_FUNCTION void pdf_signature_set_value(const PdfObj& field, const PdfPkcs7Signer& signer, int64_t stime) const;

	/** Class-aware wrapper for `::pdf_subset_fonts()`.  */
	FZ_FUNCTION void pdf_subset_fonts(int pages_len, const int *pages) const;

	/** Class-aware wrapper for `::pdf_subset_fonts2()`.  */
	/** Swig-friendly wrapper for pdf_subset_fonts(). */
	FZ_FUNCTION void pdf_subset_fonts2(const std::vector<int> &pages) const;

	/** Class-aware wrapper for `::pdf_sync_open_pages()`.  */
	FZ_FUNCTION void pdf_sync_open_pages() const;

	/** Class-aware wrapper for `::pdf_toggle_layer_config_ui()`.  */
	FZ_FUNCTION void pdf_toggle_layer_config_ui(int ui) const;

	/** Class-aware wrapper for `::pdf_trailer()`.  */
	FZ_FUNCTION PdfObj pdf_trailer() const;

	/** Class-aware wrapper for `::pdf_undo()`.  */
	FZ_FUNCTION void pdf_undo() const;

	/** Class-aware wrapper for `::pdf_undoredo_state()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_undoredo_state()` => `(int, int steps)`
	 */
	FZ_FUNCTION int pdf_undoredo_state(int *steps) const;

	/** Class-aware wrapper for `::pdf_undoredo_step()`.  */
	FZ_FUNCTION const char *pdf_undoredo_step(int step) const;

	/** Class-aware wrapper for `::pdf_update_object()`.  */
	FZ_FUNCTION void pdf_update_object(int num, const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_update_stream()`.  */
	FZ_FUNCTION void pdf_update_stream(const PdfObj& ref, const FzBuffer& buf, int compressed) const;

	/** Class-aware wrapper for `::pdf_update_xobject()`.  */
	FZ_FUNCTION void pdf_update_xobject(const PdfObj& xobj, const FzRect& bbox, const FzMatrix& mat, const PdfObj& res, const FzBuffer& buffer) const;

	/** Class-aware wrapper for `::pdf_validate_change_history()`.  */
	FZ_FUNCTION int pdf_validate_change_history() const;

	/** Class-aware wrapper for `::pdf_validate_changes()`.  */
	FZ_FUNCTION int pdf_validate_changes(int version) const;

	/** Class-aware wrapper for `::pdf_version()`.  */
	FZ_FUNCTION int pdf_version() const;

	/** Class-aware wrapper for `::pdf_was_pure_xfa()`.  */
	FZ_FUNCTION int pdf_was_pure_xfa() const;

	/** Class-aware wrapper for `::pdf_was_repaired()`.  */
	FZ_FUNCTION int pdf_was_repaired() const;

	/** Class-aware wrapper for `::pdf_write_document()`.  */
	FZ_FUNCTION void pdf_write_document(const FzOutput& out, PdfWriteOptions& opts) const;

	/** Class-aware wrapper for `::pdf_write_journal()`.  */
	FZ_FUNCTION void pdf_write_journal(const FzOutput& out) const;

	/** Class-aware wrapper for `::pdf_write_snapshot()`.  */
	FZ_FUNCTION void pdf_write_snapshot(const FzOutput& out) const;

	/** Class-aware wrapper for `::pdf_xref_ensure_incremental_object()`.  */
	FZ_FUNCTION int pdf_xref_ensure_incremental_object(int num) const;

	/** Class-aware wrapper for `::pdf_xref_ensure_local_object()`.  */
	FZ_FUNCTION void pdf_xref_ensure_local_object(int num) const;

	/** Class-aware wrapper for `::pdf_xref_entry_map()`.  */
	FZ_FUNCTION void pdf_xref_entry_map(void (*fn)(::fz_context *, ::pdf_xref_entry *, int , ::pdf_document *, void *), void *arg) const;

	/** Class-aware wrapper for `::pdf_xref_is_incremental()`.  */
	FZ_FUNCTION int pdf_xref_is_incremental(int num) const;

	/** Class-aware wrapper for `::pdf_xref_len()`.  */
	FZ_FUNCTION int pdf_xref_len() const;

	/** Class-aware wrapper for `::pdf_xref_obj_is_unsaved_signature()`.  */
	FZ_FUNCTION int pdf_xref_obj_is_unsaved_signature(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_xref_remove_unsaved_signature()`.  */
	FZ_FUNCTION void pdf_xref_remove_unsaved_signature(const PdfObj& field) const;

	/** Class-aware wrapper for `::pdf_xref_store_unsaved_signature()`.  */
	FZ_FUNCTION void pdf_xref_store_unsaved_signature(const PdfObj& field, const PdfPkcs7Signer& signer) const;

	/** Class-aware wrapper for `::pdf_zugferd_profile()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_zugferd_profile()` => `(enum pdf_zugferd_profile, float version)`
	 */
	FZ_FUNCTION enum pdf_zugferd_profile pdf_zugferd_profile(float *version) const;

	/** Class-aware wrapper for `::pdf_zugferd_xml()`.  */
	FZ_FUNCTION FzBuffer pdf_zugferd_xml() const;

	/** Returns wrapper for .super member. */
	FZ_FUNCTION FzDocument super();

	/** Constructor using raw copy of pre-existing `::pdf_document`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_document* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfDocument(::pdf_document* internal);

	/** Destructor using pdf_drop_document(). */
	FZ_FUNCTION ~PdfDocument();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_document* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_filespec_params`. Not copyable or assignable. */
struct PdfFilespecParams
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfFilespecParams();

	/** Constructor using raw copy of pre-existing `::pdf_filespec_params`. */
	FZ_FUNCTION PdfFilespecParams(::pdf_filespec_params* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfFilespecParams();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_filespec_params* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfFilespecParams(const PdfFilespecParams& rhs);
	PdfFilespecParams& operator=(const PdfFilespecParams& rhs);
};

/** Wrapper class for struct `pdf_filter_factory`. */
struct PdfFilterFactory
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfFilterFactory();

	/** Constructor using raw copy of pre-existing `::pdf_filter_factory`. */
	FZ_FUNCTION PdfFilterFactory(const ::pdf_filter_factory* internal);

	/** Constructor using raw copy of pre-existing `::pdf_filter_factory`. */
	FZ_FUNCTION PdfFilterFactory(const ::pdf_filter_factory internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_filter_factory* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_filter_factory* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfFilterFactory();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_filter_factory. */
	::pdf_filter_factory_fn *filter;
	void *options;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfFilterFactory& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfFilterFactory& rhs);
};

/** Wrapper class for struct pdf_filter_factory with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfFilterFactory2 : PdfFilterFactory
{

	/** == Constructor. */
	FZ_FUNCTION PdfFilterFactory2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~PdfFilterFactory2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_filter( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual ::pdf_processor * filter(::fz_context *arg_0, ::pdf_document *arg_1, ::pdf_processor *arg_2, int arg_3, ::fz_matrix arg_4, ::pdf_filter_options *arg_5);
};

/** Wrapper class for struct `pdf_filter_options`. */
struct PdfFilterOptions
{
	/** Default constructor initialises all fields to null/zero. */
	FZ_FUNCTION PdfFilterOptions();

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Appends `factory` to internal vector and updates this->filters. */
	FZ_FUNCTION void add_factory( const pdf_filter_factory& factory);

	/** Constructor using raw copy of pre-existing `::pdf_filter_options`. */
	FZ_FUNCTION PdfFilterOptions(const ::pdf_filter_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_filter_options`. */
	FZ_FUNCTION PdfFilterOptions(const ::pdf_filter_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_filter_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_filter_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfFilterOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_filter_options. */
	int recurse;
	int instance_forms;
	int ascii;
	int no_update;
	void *opaque;
	void (*complete)(::fz_context *, ::fz_buffer *, void *);
	::pdf_filter_factory *filters;
	int newlines;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfFilterOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfFilterOptions& rhs);

	std::vector< pdf_filter_factory> m_filters;
};

/** Wrapper class for struct pdf_filter_options with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfFilterOptions2 : PdfFilterOptions
{

	/** == Constructor. */
	FZ_FUNCTION PdfFilterOptions2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~PdfFilterOptions2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_complete( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void complete(::fz_context *arg_0, ::fz_buffer *arg_1);
};

/** Wrapper class for struct `pdf_font_desc`. Not copyable or assignable. */
struct PdfFontDesc
{
	/** == Constructors. */

	/** Constructor using `pdf_new_font_desc()`. */
	FZ_FUNCTION PdfFontDesc();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_add_hmtx()`.  */
	FZ_FUNCTION void pdf_add_hmtx(int lo, int hi, int w) const;

	/** Class-aware wrapper for `::pdf_add_vmtx()`.  */
	FZ_FUNCTION void pdf_add_vmtx(int lo, int hi, int x, int y, int w) const;

	/** Class-aware wrapper for `::pdf_end_hmtx()`.  */
	FZ_FUNCTION void pdf_end_hmtx() const;

	/** Class-aware wrapper for `::pdf_end_vmtx()`.  */
	FZ_FUNCTION void pdf_end_vmtx() const;

	/** Class-aware wrapper for `::pdf_font_cid_to_gid()`.  */
	FZ_FUNCTION int pdf_font_cid_to_gid(int cid) const;

	/** Class-aware wrapper for `::pdf_set_default_hmtx()`.  */
	FZ_FUNCTION void pdf_set_default_hmtx(int w) const;

	/** Class-aware wrapper for `::pdf_set_default_vmtx()`.  */
	FZ_FUNCTION void pdf_set_default_vmtx(int y, int w) const;

	/** Class-aware wrapper for `::pdf_set_font_wmode()`.  */
	FZ_FUNCTION void pdf_set_font_wmode(int wmode) const;

	/** Constructor using raw copy of pre-existing `::pdf_font_desc`. */
	FZ_FUNCTION PdfFontDesc(::pdf_font_desc* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfFontDesc();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_font_desc* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfFontDesc(const PdfFontDesc& rhs);
	PdfFontDesc& operator=(const PdfFontDesc& rhs);
};

/** Wrapper class for struct `pdf_font_resource_key`. Not copyable or assignable. */
struct PdfFontResourceKey
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfFontResourceKey();

	/** Constructor using raw copy of pre-existing `::pdf_font_resource_key`. */
	FZ_FUNCTION PdfFontResourceKey(::pdf_font_resource_key* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfFontResourceKey();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_font_resource_key* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfFontResourceKey(const PdfFontResourceKey& rhs);
	PdfFontResourceKey& operator=(const PdfFontResourceKey& rhs);
};

/** Wrapper class for struct `pdf_function`. */
struct PdfFunction
{
	/** Copy constructor using `pdf_keep_function()`. */
	FZ_FUNCTION PdfFunction(const PdfFunction& rhs);

	/** operator= using `pdf_keep_function()` and `pdf_drop_function()`. */
	FZ_FUNCTION PdfFunction& operator=(const PdfFunction& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfFunction();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_eval_function()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_eval_function(const float *in, int inlen, int outlen)` => float out
	 */
	FZ_FUNCTION void pdf_eval_function(const float *in, int inlen, float *out, int outlen) const;

	/** Class-aware wrapper for `::pdf_function_size()`.  */
	FZ_FUNCTION size_t pdf_function_size() const;

	/** Constructor using raw copy of pre-existing `::pdf_function`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_function* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfFunction(::pdf_function* internal);

	/** Destructor using pdf_drop_function(). */
	FZ_FUNCTION ~PdfFunction();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_function* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_graft_map`. */
struct PdfGraftMap
{
	/** == Constructors. */

	/** Constructor using `pdf_new_graft_map()`. */
	FZ_FUNCTION PdfGraftMap(const PdfDocument& dst);

	/** Copy constructor using `pdf_keep_graft_map()`. */
	FZ_FUNCTION PdfGraftMap(const PdfGraftMap& rhs);

	/** operator= using `pdf_keep_graft_map()` and `pdf_drop_graft_map()`. */
	FZ_FUNCTION PdfGraftMap& operator=(const PdfGraftMap& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfGraftMap();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_graft_mapped_object()`.  */
	FZ_FUNCTION PdfObj pdf_graft_mapped_object(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_graft_mapped_page()`.  */
	FZ_FUNCTION void pdf_graft_mapped_page(int page_to, const PdfDocument& src, int page_from) const;

	/** Constructor using raw copy of pre-existing `::pdf_graft_map`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_graft_map* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfGraftMap(::pdf_graft_map* internal);

	/** Destructor using pdf_drop_graft_map(). */
	FZ_FUNCTION ~PdfGraftMap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_graft_map* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_gstate`. Not copyable or assignable. */
struct PdfGstate
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfGstate();

	/** Constructor using raw copy of pre-existing `::pdf_gstate`. */
	FZ_FUNCTION PdfGstate(::pdf_gstate* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfGstate();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_gstate* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfGstate(const PdfGstate& rhs);
	PdfGstate& operator=(const PdfGstate& rhs);
};

/** Wrapper class for struct `pdf_hint_page`. Not copyable or assignable. */
struct PdfHintPage
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfHintPage();

	/** Constructor using raw copy of pre-existing `::pdf_hint_page`. */
	FZ_FUNCTION PdfHintPage(::pdf_hint_page* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfHintPage();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_hint_page* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfHintPage(const PdfHintPage& rhs);
	PdfHintPage& operator=(const PdfHintPage& rhs);
};

/** Wrapper class for struct `pdf_hint_shared`. Not copyable or assignable. */
struct PdfHintShared
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfHintShared();

	/** Constructor using raw copy of pre-existing `::pdf_hint_shared`. */
	FZ_FUNCTION PdfHintShared(::pdf_hint_shared* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfHintShared();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_hint_shared* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfHintShared(const PdfHintShared& rhs);
	PdfHintShared& operator=(const PdfHintShared& rhs);
};

/** Wrapper class for struct `pdf_hmtx`. Not copyable or assignable. */
struct PdfHmtx
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfHmtx();

	/** Constructor using raw copy of pre-existing `::pdf_hmtx`. */
	FZ_FUNCTION PdfHmtx(::pdf_hmtx* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfHmtx();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_hmtx* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfHmtx(const PdfHmtx& rhs);
	PdfHmtx& operator=(const PdfHmtx& rhs);
};

/** Wrapper class for struct `pdf_image_rewriter_options`. */
struct PdfImageRewriterOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfImageRewriterOptions();

	/** Constructor using raw copy of pre-existing `::pdf_image_rewriter_options`. */
	FZ_FUNCTION PdfImageRewriterOptions(const ::pdf_image_rewriter_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_image_rewriter_options`. */
	FZ_FUNCTION PdfImageRewriterOptions(const ::pdf_image_rewriter_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_image_rewriter_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_image_rewriter_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfImageRewriterOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_image_rewriter_options. */
	int color_lossless_image_subsample_method;
	int color_lossy_image_subsample_method;
	int color_lossless_image_subsample_threshold;
	int color_lossless_image_subsample_to;
	int color_lossy_image_subsample_threshold;
	int color_lossy_image_subsample_to;
	int color_lossless_image_recompress_method;
	int color_lossy_image_recompress_method;
	char *color_lossy_image_recompress_quality;
	char *color_lossless_image_recompress_quality;
	int gray_lossless_image_subsample_method;
	int gray_lossy_image_subsample_method;
	int gray_lossless_image_subsample_threshold;
	int gray_lossless_image_subsample_to;
	int gray_lossy_image_subsample_threshold;
	int gray_lossy_image_subsample_to;
	int gray_lossless_image_recompress_method;
	int gray_lossy_image_recompress_method;
	char *gray_lossy_image_recompress_quality;
	char *gray_lossless_image_recompress_quality;
	int bitonal_image_subsample_method;
	int bitonal_image_subsample_threshold;
	int bitonal_image_subsample_to;
	int bitonal_image_recompress_method;
	char *bitonal_image_recompress_quality;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfImageRewriterOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfImageRewriterOptions& rhs);
};

/** Wrapper class for struct `pdf_journal`. Not copyable or assignable. */
struct PdfJournal
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfJournal();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_discard_journal()`.  */
	FZ_FUNCTION void pdf_discard_journal() const;

	/** Constructor using raw copy of pre-existing `::pdf_journal`. */
	FZ_FUNCTION PdfJournal(::pdf_journal* internal);

	/** Destructor using pdf_drop_journal(). */
	FZ_FUNCTION ~PdfJournal();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_journal* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfJournal(const PdfJournal& rhs);
	PdfJournal& operator=(const PdfJournal& rhs);
};

/** Wrapper class for struct `pdf_js`. Not copyable or assignable. */
struct PdfJs
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfJs();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_js_event_init()`.  */
	FZ_FUNCTION void pdf_js_event_init(const PdfObj& target, const char *value, int willCommit) const;

	/** Class-aware wrapper for `::pdf_js_event_init_keystroke()`.  */
	FZ_FUNCTION void pdf_js_event_init_keystroke(const PdfObj& target, const PdfKeystrokeEvent& evt) const;

	/** Class-aware wrapper for `::pdf_js_event_result()`.  */
	FZ_FUNCTION int pdf_js_event_result() const;

	/** Class-aware wrapper for `::pdf_js_event_result_keystroke()`.  */
	FZ_FUNCTION int pdf_js_event_result_keystroke(const PdfKeystrokeEvent& evt) const;

	/** Class-aware wrapper for `::pdf_js_event_result_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_js_event_result_validate()` => `(int, char *newvalue)`
	 */
	FZ_FUNCTION int pdf_js_event_result_validate(char **newvalue) const;

	/** Class-aware wrapper for `::pdf_js_event_value()`.  */
	FZ_FUNCTION char *pdf_js_event_value() const;

	/** Class-aware wrapper for `::pdf_js_execute()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_js_execute(const char *name, const char *code)` => char *result
	 */
	FZ_FUNCTION void pdf_js_execute(const char *name, const char *code, char **result) const;

	/** Constructor using raw copy of pre-existing `::pdf_js`. */
	FZ_FUNCTION PdfJs(::pdf_js* internal);

	/** Destructor using pdf_drop_js(). */
	FZ_FUNCTION ~PdfJs();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_js* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfJs(const PdfJs& rhs);
	PdfJs& operator=(const PdfJs& rhs);
};

/** Wrapper class for struct `pdf_js_console`. Not copyable or assignable. */
struct PdfJsConsole
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfJsConsole();

	/** Constructor using raw copy of pre-existing `::pdf_js_console`. */
	FZ_FUNCTION PdfJsConsole(::pdf_js_console* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfJsConsole();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_js_console* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfJsConsole(const PdfJsConsole& rhs);
	PdfJsConsole& operator=(const PdfJsConsole& rhs);
};

/** Wrapper class for struct `pdf_keystroke_event`. Not copyable or assignable. */
struct PdfKeystrokeEvent
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfKeystrokeEvent();

	/** Constructor using raw copy of pre-existing `::pdf_keystroke_event`. */
	FZ_FUNCTION PdfKeystrokeEvent(::pdf_keystroke_event* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfKeystrokeEvent();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_keystroke_event* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfKeystrokeEvent(const PdfKeystrokeEvent& rhs);
	PdfKeystrokeEvent& operator=(const PdfKeystrokeEvent& rhs);
};

/** Wrapper class for struct `pdf_launch_url_event`. Not copyable or assignable. */
struct PdfLaunchUrlEvent
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfLaunchUrlEvent();

	/** Constructor using raw copy of pre-existing `::pdf_launch_url_event`. */
	FZ_FUNCTION PdfLaunchUrlEvent(::pdf_launch_url_event* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfLaunchUrlEvent();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_launch_url_event* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfLaunchUrlEvent(const PdfLaunchUrlEvent& rhs);
	PdfLaunchUrlEvent& operator=(const PdfLaunchUrlEvent& rhs);
};

/** Wrapper class for struct `pdf_layer_config`. */
struct PdfLayerConfig
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfLayerConfig();

	/** Constructor using raw copy of pre-existing `::pdf_layer_config`. */
	FZ_FUNCTION PdfLayerConfig(const ::pdf_layer_config* internal);

	/** Constructor using raw copy of pre-existing `::pdf_layer_config`. */
	FZ_FUNCTION PdfLayerConfig(const ::pdf_layer_config internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_layer_config* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_layer_config* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfLayerConfig();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_layer_config. */
	const char *name;
	const char *creator;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfLayerConfig& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfLayerConfig& rhs);
};

/** Wrapper class for struct `pdf_layer_config_ui`. */
struct PdfLayerConfigUi
{
	/** Default constructor sets .text to null, .type to PDF_LAYER_UI_LABEL, and other fields to zero. */
	FZ_FUNCTION PdfLayerConfigUi();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `::pdf_layer_config_ui`. */
	FZ_FUNCTION PdfLayerConfigUi(const ::pdf_layer_config_ui* internal);

	/** Constructor using raw copy of pre-existing `::pdf_layer_config_ui`. */
	FZ_FUNCTION PdfLayerConfigUi(const ::pdf_layer_config_ui internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_layer_config_ui* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_layer_config_ui* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfLayerConfigUi();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_layer_config_ui. */
	const char *text;
	int depth;
	::pdf_layer_config_ui_type type;
	int selected;
	int locked;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfLayerConfigUi& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfLayerConfigUi& rhs);
};

/** Wrapper class for struct `pdf_lexbuf`. Not copyable or assignable. */
struct PdfLexbuf
{
	/** Constructor that calls pdf_lexbuf_init(size). */
	FZ_FUNCTION PdfLexbuf(int size);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfLexbuf();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_lexbuf_fin()`.  */
	FZ_FUNCTION void pdf_lexbuf_fin() const;

	/** Class-aware wrapper for `::pdf_lexbuf_grow()`.  */
	FZ_FUNCTION ptrdiff_t pdf_lexbuf_grow() const;

	/** Class-aware wrapper for `::pdf_lexbuf_init()`.  */
	FZ_FUNCTION void pdf_lexbuf_init(int size) const;

	/** Destructor that calls pdf_lexbuf_fin(). */
	FZ_FUNCTION ~PdfLexbuf();

	/** Constructor using raw copy of pre-existing `::pdf_lexbuf`. */
	FZ_FUNCTION PdfLexbuf(::pdf_lexbuf* internal);

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_lexbuf* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfLexbuf(const PdfLexbuf& rhs);
	PdfLexbuf& operator=(const PdfLexbuf& rhs);
};

/** Wrapper class for struct `pdf_lexbuf_large`. Not copyable or assignable. */
struct PdfLexbufLarge
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfLexbufLarge();

	/** Constructor using raw copy of pre-existing `::pdf_lexbuf_large`. */
	FZ_FUNCTION PdfLexbufLarge(::pdf_lexbuf_large* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfLexbufLarge();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_lexbuf_large* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfLexbufLarge(const PdfLexbufLarge& rhs);
	PdfLexbufLarge& operator=(const PdfLexbufLarge& rhs);
};

/** Wrapper class for struct `pdf_locked_fields`. Not copyable or assignable. */
struct PdfLockedFields
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfLockedFields();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_is_field_locked()`.  */
	FZ_FUNCTION int pdf_is_field_locked(const char *name) const;

	/** Constructor using raw copy of pre-existing `::pdf_locked_fields`. */
	FZ_FUNCTION PdfLockedFields(::pdf_locked_fields* internal);

	/** Destructor using pdf_drop_locked_fields(). */
	FZ_FUNCTION ~PdfLockedFields();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_locked_fields* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfLockedFields(const PdfLockedFields& rhs);
	PdfLockedFields& operator=(const PdfLockedFields& rhs);
};

/** Wrapper class for struct `pdf_mail_doc_event`. Not copyable or assignable. */
struct PdfMailDocEvent
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfMailDocEvent();

	/** Constructor using raw copy of pre-existing `::pdf_mail_doc_event`. */
	FZ_FUNCTION PdfMailDocEvent(::pdf_mail_doc_event* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfMailDocEvent();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_mail_doc_event* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfMailDocEvent(const PdfMailDocEvent& rhs);
	PdfMailDocEvent& operator=(const PdfMailDocEvent& rhs);
};

/** Wrapper class for struct `pdf_mark_bits`. Not copyable or assignable. */
struct PdfMarkBits
{
	/** == Constructors. */

	/** Constructor using `pdf_new_mark_bits()`. */
	FZ_FUNCTION PdfMarkBits(const PdfDocument& doc);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfMarkBits();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_mark_bits_reset()`.  */
	FZ_FUNCTION void pdf_mark_bits_reset() const;

	/** Class-aware wrapper for `::pdf_mark_bits_set()`.  */
	FZ_FUNCTION int pdf_mark_bits_set(const PdfObj& obj) const;

	/** Constructor using raw copy of pre-existing `::pdf_mark_bits`. */
	FZ_FUNCTION PdfMarkBits(::pdf_mark_bits* internal);

	/** Destructor using pdf_drop_mark_bits(). */
	FZ_FUNCTION ~PdfMarkBits();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_mark_bits* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfMarkBits(const PdfMarkBits& rhs);
	PdfMarkBits& operator=(const PdfMarkBits& rhs);
};

/** Wrapper class for struct `pdf_mark_list`. Not copyable or assignable. */
struct PdfMarkList
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfMarkList();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_mark_list_check()`.  */
	FZ_FUNCTION int pdf_mark_list_check(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_mark_list_free()`.  */
	FZ_FUNCTION void pdf_mark_list_free() const;

	/** Class-aware wrapper for `::pdf_mark_list_init()`.  */
	FZ_FUNCTION void pdf_mark_list_init() const;

	/** Class-aware wrapper for `::pdf_mark_list_pop()`.  */
	FZ_FUNCTION void pdf_mark_list_pop() const;

	/** Class-aware wrapper for `::pdf_mark_list_push()`.  */
	FZ_FUNCTION int pdf_mark_list_push(const PdfObj& obj) const;

	/** Constructor using raw copy of pre-existing `::pdf_mark_list`. */
	FZ_FUNCTION PdfMarkList(::pdf_mark_list* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfMarkList();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_mark_list* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfMarkList(const PdfMarkList& rhs);
	PdfMarkList& operator=(const PdfMarkList& rhs);
};

/** Wrapper class for struct `pdf_mrange`. Not copyable or assignable. */
struct PdfMrange
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfMrange();

	/** Constructor using raw copy of pre-existing `::pdf_mrange`. */
	FZ_FUNCTION PdfMrange(::pdf_mrange* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfMrange();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_mrange* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfMrange(const PdfMrange& rhs);
	PdfMrange& operator=(const PdfMrange& rhs);
};

/** Wrapper class for struct `pdf_obj`. */
struct PdfObj
{
	/** == Constructors. */

	/** Constructor using `pdf_new_action_from_link()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const char *uri);

	/** Constructor using `pdf_new_array()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int initialcap);

	/** Constructor using `pdf_new_date()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int64_t time);

	/** Constructor using `pdf_new_dest_from_link()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const char *uri, int is_remote);

	/** Constructor using `pdf_new_indirect()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int num, int gen);

	/** Constructor using `pdf_new_int()`. */
	FZ_FUNCTION PdfObj(int64_t i);

	/** Constructor using `pdf_new_matrix()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const FzMatrix& mtx);

	/** Constructor using `pdf_new_name()`. */
	FZ_FUNCTION PdfObj(const char *str);

	/** Constructor using `pdf_new_point()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const FzPoint& point);

	/** Constructor using `pdf_new_real()`. */
	FZ_FUNCTION PdfObj(float f);

	/** Constructor using `pdf_new_rect()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const FzRect& rect);

	/** Constructor using `pdf_new_string()`. */
	FZ_FUNCTION PdfObj(const char *str, size_t len);

	/** Constructor using `pdf_new_xobject()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const FzRect& bbox, const FzMatrix& matrix, const PdfObj& res, const FzBuffer& buffer);

	/** Copy constructor using `pdf_keep_obj()`. */
	FZ_FUNCTION PdfObj(const PdfObj& rhs);

	/** operator= using `pdf_keep_obj()` and `pdf_drop_obj()`. */
	FZ_FUNCTION PdfObj& operator=(const PdfObj& rhs);

	/* == Static methods. */

	/** Class-aware wrapper for `::pdf_new_text_string()`.  */
	FZ_FUNCTION static PdfObj pdf_new_text_string(const char *s);

	/** Class-aware wrapper for `::pdf_new_dict()`.  */
	FZ_FUNCTION static PdfObj pdf_new_dict(const PdfDocument& doc, int initialcap);

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_array_contains()`.  */
	FZ_FUNCTION int pdf_array_contains(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_array_delete()`.  */
	FZ_FUNCTION void pdf_array_delete(int index) const;

	/** Class-aware wrapper for `::pdf_array_find()`.  */
	FZ_FUNCTION int pdf_array_find(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_array_get()`.  */
	FZ_FUNCTION PdfObj pdf_array_get(int i) const;

	/** Class-aware wrapper for `::pdf_array_get_bool()`.  */
	FZ_FUNCTION int pdf_array_get_bool(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_int()`.  */
	FZ_FUNCTION int pdf_array_get_int(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_matrix()`.  */
	FZ_FUNCTION FzMatrix pdf_array_get_matrix(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_name()`.  */
	FZ_FUNCTION const char *pdf_array_get_name(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_real()`.  */
	FZ_FUNCTION float pdf_array_get_real(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_rect()`.  */
	FZ_FUNCTION FzRect pdf_array_get_rect(int index) const;

	/** Class-aware wrapper for `::pdf_array_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_array_get_string(int index)` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *pdf_array_get_string(int index, size_t *sizep) const;

	/** Class-aware wrapper for `::pdf_array_get_text_string()`.  */
	FZ_FUNCTION const char *pdf_array_get_text_string(int index) const;

	/** Class-aware wrapper for `::pdf_array_insert()`.  */
	FZ_FUNCTION void pdf_array_insert(const PdfObj& obj, int index) const;

	/** Class-aware wrapper for `::pdf_array_len()`.  */
	FZ_FUNCTION int pdf_array_len() const;

	/** Class-aware wrapper for `::pdf_array_push()`.  */
	FZ_FUNCTION void pdf_array_push(const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_array_push_array()`.  */
	FZ_FUNCTION PdfObj pdf_array_push_array(int initial) const;

	/** Class-aware wrapper for `::pdf_array_push_bool()`.  */
	FZ_FUNCTION void pdf_array_push_bool(int x) const;

	/** Class-aware wrapper for `::pdf_array_push_dict()`.  */
	FZ_FUNCTION PdfObj pdf_array_push_dict(int initial) const;

	/** Class-aware wrapper for `::pdf_array_push_int()`.  */
	FZ_FUNCTION void pdf_array_push_int(int64_t x) const;

	/** Class-aware wrapper for `::pdf_array_push_name()`.  */
	FZ_FUNCTION void pdf_array_push_name(const char *x) const;

	/** Class-aware wrapper for `::pdf_array_push_real()`.  */
	FZ_FUNCTION void pdf_array_push_real(double x) const;

	/** Class-aware wrapper for `::pdf_array_push_string()`.  */
	FZ_FUNCTION void pdf_array_push_string(const char *x, size_t n) const;

	/** Class-aware wrapper for `::pdf_array_push_text_string()`.  */
	FZ_FUNCTION void pdf_array_push_text_string(const char *x) const;

	/** Class-aware wrapper for `::pdf_array_put()`.  */
	FZ_FUNCTION void pdf_array_put(int i, const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_array_put_array()`.  */
	FZ_FUNCTION PdfObj pdf_array_put_array(int i, int initial) const;

	/** Class-aware wrapper for `::pdf_array_put_bool()`.  */
	FZ_FUNCTION void pdf_array_put_bool(int i, int x) const;

	/** Class-aware wrapper for `::pdf_array_put_dict()`.  */
	FZ_FUNCTION PdfObj pdf_array_put_dict(int i, int initial) const;

	/** Class-aware wrapper for `::pdf_array_put_int()`.  */
	FZ_FUNCTION void pdf_array_put_int(int i, int64_t x) const;

	/** Class-aware wrapper for `::pdf_array_put_name()`.  */
	FZ_FUNCTION void pdf_array_put_name(int i, const char *x) const;

	/** Class-aware wrapper for `::pdf_array_put_real()`.  */
	FZ_FUNCTION void pdf_array_put_real(int i, double x) const;

	/** Class-aware wrapper for `::pdf_array_put_string()`.  */
	FZ_FUNCTION void pdf_array_put_string(int i, const char *x, size_t n) const;

	/** Class-aware wrapper for `::pdf_array_put_text_string()`.  */
	FZ_FUNCTION void pdf_array_put_text_string(int i, const char *x) const;

	/** Class-aware wrapper for `::pdf_button_field_on_state()`.  */
	FZ_FUNCTION PdfObj pdf_button_field_on_state() const;

	/** Class-aware wrapper for `::pdf_choice_field_option()`.  */
	FZ_FUNCTION const char *pdf_choice_field_option(int exportval, int i) const;

	/** Class-aware wrapper for `::pdf_choice_field_option_count()`.  */
	FZ_FUNCTION int pdf_choice_field_option_count() const;

	/** Class-aware wrapper for `::pdf_clean_obj()`.  */
	FZ_FUNCTION void pdf_clean_obj() const;

	/** Class-aware wrapper for `::pdf_copy_array()`.  */
	FZ_FUNCTION PdfObj pdf_copy_array() const;

	/** Class-aware wrapper for `::pdf_copy_dict()`.  */
	FZ_FUNCTION PdfObj pdf_copy_dict() const;

	/** Class-aware wrapper for `::pdf_debug_obj()`.  */
	FZ_FUNCTION void pdf_debug_obj() const;

	/** Class-aware wrapper for `::pdf_debug_ref()`.  */
	FZ_FUNCTION void pdf_debug_ref() const;

	/** Class-aware wrapper for `::pdf_deep_copy_obj()`.  */
	FZ_FUNCTION PdfObj pdf_deep_copy_obj() const;

	/** Class-aware wrapper for `::pdf_dict_del()`.  */
	FZ_FUNCTION void pdf_dict_del(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_dels()`.  */
	FZ_FUNCTION void pdf_dict_dels(const char *key) const;

	/** Class-aware wrapper for `::pdf_dict_get()`.  */
	FZ_FUNCTION PdfObj pdf_dict_get(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_bool()`.  */
	FZ_FUNCTION int pdf_dict_get_bool(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_bool_default()`.  */
	FZ_FUNCTION int pdf_dict_get_bool_default(const PdfObj& key, int def) const;

	/** Class-aware wrapper for `::pdf_dict_get_date()`.  */
	FZ_FUNCTION int64_t pdf_dict_get_date(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable()`.  */
	FZ_FUNCTION PdfObj pdf_dict_get_inheritable(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_bool()`.  */
	FZ_FUNCTION int pdf_dict_get_inheritable_bool(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_date()`.  */
	FZ_FUNCTION int64_t pdf_dict_get_inheritable_date(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_int()`.  */
	FZ_FUNCTION int pdf_dict_get_inheritable_int(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_int64()`.  */
	FZ_FUNCTION int64_t pdf_dict_get_inheritable_int64(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_matrix()`.  */
	FZ_FUNCTION FzMatrix pdf_dict_get_inheritable_matrix(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_name()`.  */
	FZ_FUNCTION const char *pdf_dict_get_inheritable_name(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_real()`.  */
	FZ_FUNCTION float pdf_dict_get_inheritable_real(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_rect()`.  */
	FZ_FUNCTION FzRect pdf_dict_get_inheritable_rect(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_dict_get_inheritable_string(::pdf_obj *key)` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *pdf_dict_get_inheritable_string(const PdfObj& key, size_t *sizep) const;

	/** Class-aware wrapper for `::pdf_dict_get_inheritable_text_string()`.  */
	FZ_FUNCTION const char *pdf_dict_get_inheritable_text_string(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_int()`.  */
	FZ_FUNCTION int pdf_dict_get_int(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_int64()`.  */
	FZ_FUNCTION int64_t pdf_dict_get_int64(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_int_default()`.  */
	FZ_FUNCTION int pdf_dict_get_int_default(const PdfObj& key, int def) const;

	/** Class-aware wrapper for `::pdf_dict_get_key()`.  */
	FZ_FUNCTION PdfObj pdf_dict_get_key(int idx) const;

	/** Class-aware wrapper for `::pdf_dict_get_matrix()`.  */
	FZ_FUNCTION FzMatrix pdf_dict_get_matrix(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_name()`.  */
	FZ_FUNCTION const char *pdf_dict_get_name(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_point()`.  */
	FZ_FUNCTION FzPoint pdf_dict_get_point(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_real()`.  */
	FZ_FUNCTION float pdf_dict_get_real(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_real_default()`.  */
	FZ_FUNCTION float pdf_dict_get_real_default(const PdfObj& key, float def) const;

	/** Class-aware wrapper for `::pdf_dict_get_rect()`.  */
	FZ_FUNCTION FzRect pdf_dict_get_rect(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_dict_get_string(::pdf_obj *key)` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *pdf_dict_get_string(const PdfObj& key, size_t *sizep) const;

	/** Class-aware wrapper for `::pdf_dict_get_text_string()`.  */
	FZ_FUNCTION const char *pdf_dict_get_text_string(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_text_string_opt()`.  */
	FZ_FUNCTION const char *pdf_dict_get_text_string_opt(const PdfObj& key) const;

	/** Class-aware wrapper for `::pdf_dict_get_val()`.  */
	FZ_FUNCTION PdfObj pdf_dict_get_val(int idx) const;

	/** Class-aware wrapper for `::pdf_dict_geta()`.  */
	FZ_FUNCTION PdfObj pdf_dict_geta(const PdfObj& key, const PdfObj& abbrev) const;

	/** Class-aware wrapper for `::pdf_dict_getp()`.  */
	FZ_FUNCTION PdfObj pdf_dict_getp(const char *path) const;

	/** Class-aware wrapper for `::pdf_dict_getp_inheritable()`.  */
	FZ_FUNCTION PdfObj pdf_dict_getp_inheritable(const char *path) const;

	/** Class-aware wrapper for `::pdf_dict_gets()`.  */
	FZ_FUNCTION PdfObj pdf_dict_gets(const char *key) const;

	/** Class-aware wrapper for `::pdf_dict_gets_inheritable()`.  */
	FZ_FUNCTION PdfObj pdf_dict_gets_inheritable(const char *key) const;

	/** Class-aware wrapper for `::pdf_dict_getsa()`.  */
	FZ_FUNCTION PdfObj pdf_dict_getsa(const char *key, const char *abbrev) const;

	/** Class-aware wrapper for `::pdf_dict_len()`.  */
	FZ_FUNCTION int pdf_dict_len() const;

	/** Class-aware wrapper for `::pdf_dict_put()`.  */
	FZ_FUNCTION void pdf_dict_put(const PdfObj& key, const PdfObj& val) const;

	/** Class-aware wrapper for `::pdf_dict_put_array()`.  */
	FZ_FUNCTION PdfObj pdf_dict_put_array(const PdfObj& key, int initial) const;

	/** Class-aware wrapper for `::pdf_dict_put_bool()`.  */
	FZ_FUNCTION void pdf_dict_put_bool(const PdfObj& key, int x) const;

	/** Class-aware wrapper for `::pdf_dict_put_date()`.  */
	FZ_FUNCTION void pdf_dict_put_date(const PdfObj& key, int64_t time) const;

	/** Class-aware wrapper for `::pdf_dict_put_dict()`.  */
	FZ_FUNCTION PdfObj pdf_dict_put_dict(const PdfObj& key, int initial) const;

	/** Class-aware wrapper for `::pdf_dict_put_indirect()`.  */
	FZ_FUNCTION void pdf_dict_put_indirect(const PdfObj& key, int num) const;

	/** Class-aware wrapper for `::pdf_dict_put_int()`.  */
	FZ_FUNCTION void pdf_dict_put_int(const PdfObj& key, int64_t x) const;

	/** Class-aware wrapper for `::pdf_dict_put_matrix()`.  */
	FZ_FUNCTION void pdf_dict_put_matrix(const PdfObj& key, const FzMatrix& x) const;

	/** Class-aware wrapper for `::pdf_dict_put_name()`.  */
	FZ_FUNCTION void pdf_dict_put_name(const PdfObj& key, const char *x) const;

	/** Class-aware wrapper for `::pdf_dict_put_point()`.  */
	FZ_FUNCTION void pdf_dict_put_point(const PdfObj& key, const FzPoint& x) const;

	/** Class-aware wrapper for `::pdf_dict_put_real()`.  */
	FZ_FUNCTION void pdf_dict_put_real(const PdfObj& key, double x) const;

	/** Class-aware wrapper for `::pdf_dict_put_rect()`.  */
	FZ_FUNCTION void pdf_dict_put_rect(const PdfObj& key, const FzRect& x) const;

	/** Class-aware wrapper for `::pdf_dict_put_string()`.  */
	FZ_FUNCTION void pdf_dict_put_string(const PdfObj& key, const char *x, size_t n) const;

	/** Class-aware wrapper for `::pdf_dict_put_text_string()`.  */
	FZ_FUNCTION void pdf_dict_put_text_string(const PdfObj& key, const char *x) const;

	/** Class-aware wrapper for `::pdf_dict_put_val_null()`.  */
	FZ_FUNCTION void pdf_dict_put_val_null(int idx) const;

	/** Class-aware wrapper for `::pdf_dict_putp()`.  */
	FZ_FUNCTION void pdf_dict_putp(const char *path, const PdfObj& val) const;

	/** Class-aware wrapper for `::pdf_dict_puts()`.  */
	FZ_FUNCTION void pdf_dict_puts(const char *key, const PdfObj& val) const;

	/** Class-aware wrapper for `::pdf_dict_puts_dict()`.  */
	FZ_FUNCTION PdfObj pdf_dict_puts_dict(const char *key, int initial) const;

	/** Class-aware wrapper for `::pdf_dirty_obj()`.  */
	FZ_FUNCTION void pdf_dirty_obj() const;

	/** Class-aware wrapper for `::pdf_field_border_style()`.  */
	FZ_FUNCTION char *pdf_field_border_style() const;

	/** Class-aware wrapper for `::pdf_field_display()`.  */
	FZ_FUNCTION int pdf_field_display() const;

	/** Class-aware wrapper for `::pdf_field_flags()`.  */
	FZ_FUNCTION int pdf_field_flags() const;

	/** Class-aware wrapper for `::pdf_field_label()`.  */
	FZ_FUNCTION const char *pdf_field_label() const;

	/** Class-aware wrapper for `::pdf_field_set_border_style()`.  */
	FZ_FUNCTION void pdf_field_set_border_style(const char *text) const;

	/** Class-aware wrapper for `::pdf_field_set_button_caption()`.  */
	FZ_FUNCTION void pdf_field_set_button_caption(const char *text) const;

	/** Class-aware wrapper for `::pdf_field_set_display()`.  */
	FZ_FUNCTION void pdf_field_set_display(int d) const;

	/** Class-aware wrapper for `::pdf_field_set_fill_color()`.  */
	FZ_FUNCTION void pdf_field_set_fill_color(const PdfObj& col) const;

	/** Class-aware wrapper for `::pdf_field_set_text_color()`.  */
	FZ_FUNCTION void pdf_field_set_text_color(const PdfObj& col) const;

	/** Class-aware wrapper for `::pdf_field_type()`.  */
	FZ_FUNCTION int pdf_field_type() const;

	/** Class-aware wrapper for `::pdf_field_type_string()`.  */
	FZ_FUNCTION const char *pdf_field_type_string() const;

	/** Class-aware wrapper for `::pdf_field_value()`.  */
	FZ_FUNCTION const char *pdf_field_value() const;

	/** Class-aware wrapper for `::pdf_filter_xobject_instance()`.  */
	FZ_FUNCTION PdfObj pdf_filter_xobject_instance(const PdfObj& page_res, const FzMatrix& ctm, PdfFilterOptions& options, const PdfCycleList& cycle_up) const;

	/** Class-aware wrapper for `::pdf_flatten_inheritable_page_items()`.  */
	FZ_FUNCTION void pdf_flatten_inheritable_page_items() const;

	/** Class-aware wrapper for `::pdf_get_bound_document()`.  */
	FZ_FUNCTION PdfDocument pdf_get_bound_document() const;

	/** Class-aware wrapper for `::pdf_get_filespec_params()`.  */
	FZ_FUNCTION void pdf_get_filespec_params(const PdfFilespecParams& out) const;

	/** Class-aware wrapper for `::pdf_get_indirect_document()`.  */
	FZ_FUNCTION PdfDocument pdf_get_indirect_document() const;

	/** Class-aware wrapper for `::pdf_intent_from_name()`.  */
	FZ_FUNCTION enum pdf_intent pdf_intent_from_name() const;

	/** Class-aware wrapper for `::pdf_is_array()`.  */
	FZ_FUNCTION int pdf_is_array() const;

	/** Class-aware wrapper for `::pdf_is_bool()`.  */
	FZ_FUNCTION int pdf_is_bool() const;

	/** Class-aware wrapper for `::pdf_is_dict()`.  */
	FZ_FUNCTION int pdf_is_dict() const;

	/** Class-aware wrapper for `::pdf_is_embedded_file()`.  */
	FZ_FUNCTION int pdf_is_embedded_file() const;

	/** Class-aware wrapper for `::pdf_is_filespec()`.  */
	FZ_FUNCTION int pdf_is_filespec() const;

	/** Class-aware wrapper for `::pdf_is_image_stream()`.  */
	FZ_FUNCTION int pdf_is_image_stream() const;

	/** Class-aware wrapper for `::pdf_is_indirect()`.  */
	FZ_FUNCTION int pdf_is_indirect() const;

	/** Class-aware wrapper for `::pdf_is_int()`.  */
	FZ_FUNCTION int pdf_is_int() const;

	/** Class-aware wrapper for `::pdf_is_jpx_image()`.  */
	FZ_FUNCTION int pdf_is_jpx_image() const;

	/** Class-aware wrapper for `::pdf_is_name()`.  */
	FZ_FUNCTION int pdf_is_name() const;

	/** Class-aware wrapper for `::pdf_is_null()`.  */
	FZ_FUNCTION int pdf_is_null() const;

	/** Class-aware wrapper for `::pdf_is_number()`.  */
	FZ_FUNCTION int pdf_is_number() const;

	/** Class-aware wrapper for `::pdf_is_real()`.  */
	FZ_FUNCTION int pdf_is_real() const;

	/** Class-aware wrapper for `::pdf_is_stream()`.  */
	FZ_FUNCTION int pdf_is_stream() const;

	/** Class-aware wrapper for `::pdf_is_string()`.  */
	FZ_FUNCTION int pdf_is_string() const;

	/** Class-aware wrapper for `::pdf_line_ending_from_name()`.  */
	FZ_FUNCTION enum pdf_line_ending pdf_line_ending_from_name() const;

	/** Class-aware wrapper for `::pdf_load_colorspace()`.  */
	FZ_FUNCTION FzColorspace pdf_load_colorspace() const;

	/** Class-aware wrapper for `::pdf_load_embedded_file_contents()`.  */
	FZ_FUNCTION FzBuffer pdf_load_embedded_file_contents() const;

	/** Class-aware wrapper for `::pdf_load_field_name()`.  */
	FZ_FUNCTION char *pdf_load_field_name() const;

	/** Class-aware wrapper for `::pdf_load_function()`.  */
	FZ_FUNCTION PdfFunction pdf_load_function(int in, int out) const;

	/** Class-aware wrapper for `::pdf_load_raw_stream()`.  */
	FZ_FUNCTION FzBuffer pdf_load_raw_stream() const;

	/** Class-aware wrapper for `::pdf_load_stream()`.  */
	FZ_FUNCTION FzBuffer pdf_load_stream() const;

	/** Class-aware wrapper for `::pdf_load_stream_or_string_as_utf8()`.  */
	FZ_FUNCTION char *pdf_load_stream_or_string_as_utf8() const;

	/** Class-aware wrapper for `::pdf_lookup_field()`.  */
	FZ_FUNCTION PdfObj pdf_lookup_field(const char *name) const;

	/** Class-aware wrapper for `::pdf_lookup_number()`.  */
	FZ_FUNCTION PdfObj pdf_lookup_number(int needle) const;

	/** Class-aware wrapper for `::pdf_mark_obj()`.  */
	FZ_FUNCTION int pdf_mark_obj() const;

	/** Class-aware wrapper for `::pdf_name_eq()`.  */
	FZ_FUNCTION int pdf_name_eq(const PdfObj& b) const;

	/** Class-aware wrapper for `::pdf_new_utf8_from_pdf_stream_obj()`.  */
	FZ_FUNCTION char *pdf_new_utf8_from_pdf_stream_obj() const;

	/** Class-aware wrapper for `::pdf_new_utf8_from_pdf_string_obj()`.  */
	FZ_FUNCTION char *pdf_new_utf8_from_pdf_string_obj() const;

	/** Class-aware wrapper for `::pdf_obj_is_dirty()`.  */
	FZ_FUNCTION int pdf_obj_is_dirty() const;

	/** Class-aware wrapper for `::pdf_obj_is_incremental()`.  */
	FZ_FUNCTION int pdf_obj_is_incremental() const;

	/** Class-aware wrapper for `::pdf_obj_marked()`.  */
	FZ_FUNCTION int pdf_obj_marked() const;

	/** Class-aware wrapper for `::pdf_obj_memo()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_obj_memo(int bit)` => `(int, int memo)`
	 */
	FZ_FUNCTION int pdf_obj_memo(int bit, int *memo) const;

	/** Class-aware wrapper for `::pdf_obj_parent_num()`.  */
	FZ_FUNCTION int pdf_obj_parent_num() const;

	/** Class-aware wrapper for `::pdf_obj_refs()`.  */
	FZ_FUNCTION int pdf_obj_refs() const;

	/** Class-aware wrapper for `::pdf_objcmp()`.  */
	FZ_FUNCTION int pdf_objcmp(const PdfObj& b) const;

	/** Class-aware wrapper for `::pdf_objcmp_deep()`.  */
	FZ_FUNCTION int pdf_objcmp_deep(const PdfObj& b) const;

	/** Class-aware wrapper for `::pdf_objcmp_resolve()`.  */
	FZ_FUNCTION int pdf_objcmp_resolve(const PdfObj& b) const;

	/** Class-aware wrapper for `::pdf_open_raw_stream()`.  */
	FZ_FUNCTION FzStream pdf_open_raw_stream() const;

	/** Class-aware wrapper for `::pdf_open_stream()`.  */
	FZ_FUNCTION FzStream pdf_open_stream() const;

	/** Class-aware wrapper for `::pdf_page_obj_transform()`.  */
	FZ_FUNCTION void pdf_page_obj_transform(FzRect& outbox, FzMatrix& outctm) const;

	/** Class-aware wrapper for `::pdf_page_obj_transform_box()`.  */
	FZ_FUNCTION void pdf_page_obj_transform_box(FzRect& outbox, FzMatrix& out, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_pin_document()`.  */
	FZ_FUNCTION PdfDocument pdf_pin_document() const;

	/** Class-aware wrapper for `::pdf_recolor_shade()`.  */
	/**
		Recolor a shade.
	*/
	FZ_FUNCTION PdfObj pdf_recolor_shade(::pdf_shade_recolorer *reshade, void *opaque) const;

	/** Class-aware wrapper for `::pdf_resolve_indirect()`.  */
	/**
		Resolve an indirect object (or chain of objects).
	
		This can cause xref reorganisations (solidifications etc) due to
		repairs, so all held pdf_xref_entries should be considered
		invalid after this call (other than the returned one).
	*/
	FZ_FUNCTION PdfObj pdf_resolve_indirect() const;

	/** Class-aware wrapper for `::pdf_resolve_indirect_chain()`.  */
	FZ_FUNCTION PdfObj pdf_resolve_indirect_chain() const;

	/** Class-aware wrapper for `::pdf_set_int()`.  */
	FZ_FUNCTION void pdf_set_int(int64_t i) const;

	/** Class-aware wrapper for `::pdf_set_obj_memo()`.  */
	FZ_FUNCTION void pdf_set_obj_memo(int bit, int memo) const;

	/** Class-aware wrapper for `::pdf_set_obj_parent()`.  */
	FZ_FUNCTION void pdf_set_obj_parent(int num) const;

	/** Class-aware wrapper for `::pdf_set_str_len()`.  */
	FZ_FUNCTION void pdf_set_str_len(size_t newlen) const;

	/** Class-aware wrapper for `::pdf_sort_dict()`.  */
	FZ_FUNCTION void pdf_sort_dict() const;

	/** Class-aware wrapper for `::pdf_store_item()`.  */
	FZ_FUNCTION void pdf_store_item(void *val, size_t itemsize) const;

	/** Class-aware wrapper for `::pdf_to_bool()`.  */
	FZ_FUNCTION int pdf_to_bool() const;

	/** Class-aware wrapper for `::pdf_to_bool_default()`.  */
	FZ_FUNCTION int pdf_to_bool_default(int def) const;

	/** Class-aware wrapper for `::pdf_to_date()`.  */
	FZ_FUNCTION int64_t pdf_to_date() const;

	/** Class-aware wrapper for `::pdf_to_gen()`.  */
	FZ_FUNCTION int pdf_to_gen() const;

	/** Class-aware wrapper for `::pdf_to_int()`.  */
	FZ_FUNCTION int pdf_to_int() const;

	/** Class-aware wrapper for `::pdf_to_int64()`.  */
	FZ_FUNCTION int64_t pdf_to_int64() const;

	/** Class-aware wrapper for `::pdf_to_int_default()`.  */
	FZ_FUNCTION int pdf_to_int_default(int def) const;

	/** Class-aware wrapper for `::pdf_to_matrix()`.  */
	FZ_FUNCTION FzMatrix pdf_to_matrix() const;

	/** Class-aware wrapper for `::pdf_to_name()`.  */
	FZ_FUNCTION const char *pdf_to_name() const;

	/** Class-aware wrapper for `::pdf_to_num()`.  */
	FZ_FUNCTION int pdf_to_num() const;

	/** Class-aware wrapper for `::pdf_to_point()`.  */
	FZ_FUNCTION FzPoint pdf_to_point(int offset) const;

	/** Class-aware wrapper for `::pdf_to_quad()`.  */
	FZ_FUNCTION FzQuad pdf_to_quad(int offset) const;

	/** Class-aware wrapper for `::pdf_to_real()`.  */
	FZ_FUNCTION float pdf_to_real() const;

	/** Class-aware wrapper for `::pdf_to_real_default()`.  */
	FZ_FUNCTION float pdf_to_real_default(float def) const;

	/** Class-aware wrapper for `::pdf_to_rect()`.  */
	FZ_FUNCTION FzRect pdf_to_rect() const;

	/** Class-aware wrapper for `::pdf_to_str_buf()`.  */
	FZ_FUNCTION char *pdf_to_str_buf() const;

	/** Class-aware wrapper for `::pdf_to_str_len()`.  */
	FZ_FUNCTION size_t pdf_to_str_len() const;

	/** Class-aware wrapper for `::pdf_to_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_to_string()` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *pdf_to_string(size_t *sizep) const;

	/** Class-aware wrapper for `::pdf_to_text_string()`.  */
	FZ_FUNCTION const char *pdf_to_text_string() const;

	/** Class-aware wrapper for `::pdf_unmark_obj()`.  */
	FZ_FUNCTION void pdf_unmark_obj() const;

	/** Class-aware wrapper for `::pdf_verify_embedded_file_checksum()`.  */
	FZ_FUNCTION int pdf_verify_embedded_file_checksum() const;

	/** Class-aware wrapper for `::pdf_walk_tree()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_walk_tree(::pdf_obj *kid_name, void (*arrive)(::fz_context *, ::pdf_obj *, void *, ::pdf_obj **), void (*leave)(::fz_context *, ::pdf_obj *, void *), void *arg, ::pdf_obj **names, ::pdf_obj **values)` => `()`
	 */
	FZ_FUNCTION void pdf_walk_tree(const PdfObj& kid_name, void (*arrive)(::fz_context *, ::pdf_obj *, void *, ::pdf_obj **), void (*leave)(::fz_context *, ::pdf_obj *, void *), void *arg, PdfObj& names, PdfObj& values) const;

	/** Class-aware wrapper for `::pdf_xobject_bbox()`.  */
	FZ_FUNCTION FzRect pdf_xobject_bbox() const;

	/** Class-aware wrapper for `::pdf_xobject_colorspace()`.  */
	FZ_FUNCTION FzColorspace pdf_xobject_colorspace() const;

	/** Class-aware wrapper for `::pdf_xobject_isolated()`.  */
	FZ_FUNCTION int pdf_xobject_isolated() const;

	/** Class-aware wrapper for `::pdf_xobject_knockout()`.  */
	FZ_FUNCTION int pdf_xobject_knockout() const;

	/** Class-aware wrapper for `::pdf_xobject_matrix()`.  */
	FZ_FUNCTION FzMatrix pdf_xobject_matrix() const;

	/** Class-aware wrapper for `::pdf_xobject_resources()`.  */
	FZ_FUNCTION PdfObj pdf_xobject_resources() const;

	/** Class-aware wrapper for `::pdf_xobject_transparency()`.  */
	FZ_FUNCTION int pdf_xobject_transparency() const;

	/** Typesafe wrapper for looking up things such as PDF_ENUM_NAME_Annots. */
	FZ_FUNCTION PdfObj pdf_dict_get(int key);

	/** Alternative to `pdf_load_field_name()` that returns a std::string. */
	FZ_FUNCTION std::string pdf_load_field_name2();

	/** Constructor using raw copy of pre-existing `::pdf_obj`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_obj* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfObj(::pdf_obj* internal=NULL);

	/** Destructor using pdf_drop_obj(). */
	FZ_FUNCTION ~PdfObj();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_obj* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_object_labels`. Not copyable or assignable. */
struct PdfObjectLabels
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfObjectLabels();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_label_object()`.  */
	FZ_FUNCTION void pdf_label_object(int num, ::pdf_label_object_fn *callback, void *arg) const;

	/** Constructor using raw copy of pre-existing `::pdf_object_labels`. */
	FZ_FUNCTION PdfObjectLabels(::pdf_object_labels* internal);

	/** Destructor using pdf_drop_object_labels(). */
	FZ_FUNCTION ~PdfObjectLabels();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_object_labels* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfObjectLabels(const PdfObjectLabels& rhs);
	PdfObjectLabels& operator=(const PdfObjectLabels& rhs);
};

/** Wrapper class for struct `pdf_ocg_descriptor`. Not copyable or assignable. */
struct PdfOcgDescriptor
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfOcgDescriptor();

	/** Constructor using raw copy of pre-existing `::pdf_ocg_descriptor`. */
	FZ_FUNCTION PdfOcgDescriptor(::pdf_ocg_descriptor* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfOcgDescriptor();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_ocg_descriptor* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfOcgDescriptor(const PdfOcgDescriptor& rhs);
	PdfOcgDescriptor& operator=(const PdfOcgDescriptor& rhs);
};

/** Wrapper class for struct `pdf_page`. */
struct PdfPage
{
	/** Copy constructor using `pdf_keep_page()`. */
	FZ_FUNCTION PdfPage(const PdfPage& rhs);

	/** operator= using `pdf_keep_page()` and `pdf_drop_page()`. */
	FZ_FUNCTION PdfPage& operator=(const PdfPage& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfPage();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_bound_page()`.  */
	FZ_FUNCTION FzRect pdf_bound_page(::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_clip_page()`.  */
	FZ_FUNCTION void pdf_clip_page(FzRect& clip) const;

	/** Class-aware wrapper for `::pdf_count_page_associated_files()`.  */
	FZ_FUNCTION int pdf_count_page_associated_files() const;

	/** Class-aware wrapper for `::pdf_create_annot()`.  */
	FZ_FUNCTION PdfAnnot pdf_create_annot(enum pdf_annot_type type) const;

	/** Class-aware wrapper for `::pdf_create_annot_raw()`.  */
	FZ_FUNCTION PdfAnnot pdf_create_annot_raw(enum pdf_annot_type type) const;

	/** Class-aware wrapper for `::pdf_create_link()`.  */
	FZ_FUNCTION FzLink pdf_create_link(const FzRect& bbox, const char *uri) const;

	/** Class-aware wrapper for `::pdf_create_signature_widget()`.  */
	FZ_FUNCTION PdfAnnot pdf_create_signature_widget(char *name) const;

	/** Class-aware wrapper for `::pdf_delete_annot()`.  */
	FZ_FUNCTION void pdf_delete_annot(const PdfAnnot& annot) const;

	/** Class-aware wrapper for `::pdf_delete_link()`.  */
	FZ_FUNCTION void pdf_delete_link(const FzLink& link) const;

	/** Class-aware wrapper for `::pdf_first_annot()`.  */
	FZ_FUNCTION PdfAnnot pdf_first_annot() const;

	/** Class-aware wrapper for `::pdf_first_widget()`.  */
	FZ_FUNCTION PdfAnnot pdf_first_widget() const;

	/** Class-aware wrapper for `::pdf_load_links()`.  */
	FZ_FUNCTION FzLink pdf_load_links() const;

	/** Class-aware wrapper for `::pdf_new_link()`.  */
	FZ_FUNCTION FzLink pdf_new_link(const FzRect& rect, const char *uri, const PdfObj& obj) const;

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_contents_with_separations_and_usage()`.  */
	FZ_FUNCTION FzPixmap pdf_new_pixmap_from_page_contents_with_separations_and_usage(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha, const char *usage, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_contents_with_usage()`.  */
	FZ_FUNCTION FzPixmap pdf_new_pixmap_from_page_contents_with_usage(const FzMatrix& ctm, const FzColorspace& cs, int alpha, const char *usage, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_with_separations_and_usage()`.  */
	FZ_FUNCTION FzPixmap pdf_new_pixmap_from_page_with_separations_and_usage(const FzMatrix& ctm, const FzColorspace& cs, const FzSeparations& seps, int alpha, const char *usage, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_new_pixmap_from_page_with_usage()`.  */
	FZ_FUNCTION FzPixmap pdf_new_pixmap_from_page_with_usage(const FzMatrix& ctm, const FzColorspace& cs, int alpha, const char *usage, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_nuke_annots()`.  */
	FZ_FUNCTION void pdf_nuke_annots() const;

	/** Class-aware wrapper for `::pdf_nuke_links()`.  */
	FZ_FUNCTION void pdf_nuke_links() const;

	/** Class-aware wrapper for `::pdf_nuke_page()`.  */
	FZ_FUNCTION void pdf_nuke_page() const;

	/** Class-aware wrapper for `::pdf_page_associated_file()`.  */
	FZ_FUNCTION PdfObj pdf_page_associated_file(int idx) const;

	/** Class-aware wrapper for `::pdf_page_contents()`.  */
	FZ_FUNCTION PdfObj pdf_page_contents() const;

	/** Class-aware wrapper for `::pdf_page_event_close()`.  */
	FZ_FUNCTION void pdf_page_event_close() const;

	/** Class-aware wrapper for `::pdf_page_event_open()`.  */
	FZ_FUNCTION void pdf_page_event_open() const;

	/** Class-aware wrapper for `::pdf_page_group()`.  */
	FZ_FUNCTION PdfObj pdf_page_group() const;

	/** Class-aware wrapper for `::pdf_page_has_transparency()`.  */
	FZ_FUNCTION int pdf_page_has_transparency() const;

	/** Class-aware wrapper for `::pdf_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_page_presentation(::fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
	FZ_FUNCTION FzTransition pdf_page_presentation(FzTransition& transition, float *duration) const;

	/** Class-aware wrapper for `::pdf_page_resources()`.  */
	FZ_FUNCTION PdfObj pdf_page_resources() const;

	/** Class-aware wrapper for `::pdf_page_separations()`.  */
	FZ_FUNCTION FzSeparations pdf_page_separations() const;

	/** Class-aware wrapper for `::pdf_page_transform()`.  */
	FZ_FUNCTION void pdf_page_transform(FzRect& mediabox, FzMatrix& ctm) const;

	/** Class-aware wrapper for `::pdf_page_transform_box()`.  */
	FZ_FUNCTION void pdf_page_transform_box(FzRect& mediabox, FzMatrix& ctm, ::fz_box_type box) const;

	/** Class-aware wrapper for `::pdf_run_page()`.  */
	FZ_FUNCTION void pdf_run_page(const FzDevice& dev, const FzMatrix& ctm, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_annots()`.  */
	FZ_FUNCTION void pdf_run_page_annots(const FzDevice& dev, const FzMatrix& ctm, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_annots_with_usage()`.  */
	FZ_FUNCTION void pdf_run_page_annots_with_usage(const FzDevice& dev, const FzMatrix& ctm, const char *usage, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_contents()`.  */
	FZ_FUNCTION void pdf_run_page_contents(const FzDevice& dev, const FzMatrix& ctm, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_contents_with_usage()`.  */
	FZ_FUNCTION void pdf_run_page_contents_with_usage(const FzDevice& dev, const FzMatrix& ctm, const char *usage, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_widgets()`.  */
	FZ_FUNCTION void pdf_run_page_widgets(const FzDevice& dev, const FzMatrix& ctm, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_widgets_with_usage()`.  */
	FZ_FUNCTION void pdf_run_page_widgets_with_usage(const FzDevice& dev, const FzMatrix& ctm, const char *usage, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_run_page_with_usage()`.  */
	FZ_FUNCTION void pdf_run_page_with_usage(const FzDevice& dev, const FzMatrix& ctm, const char *usage, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_set_page_box()`.  */
	FZ_FUNCTION void pdf_set_page_box(::fz_box_type box, const FzRect& rect) const;

	/** Class-aware wrapper for `::pdf_sync_annots()`.  */
	FZ_FUNCTION void pdf_sync_annots() const;

	/** Class-aware wrapper for `::pdf_sync_links()`.  */
	FZ_FUNCTION void pdf_sync_links() const;

	/** Class-aware wrapper for `::pdf_sync_page()`.  */
	FZ_FUNCTION void pdf_sync_page() const;

	/** Class-aware wrapper for `::pdf_update_page()`.  */
	FZ_FUNCTION int pdf_update_page() const;

	/** Returns wrapper for .super member. */
	FZ_FUNCTION FzPage super();

	/** Returns wrapper for .doc member. */
	FZ_FUNCTION PdfDocument doc();

	/** Returns wrapper for .obj member. */
	FZ_FUNCTION PdfObj obj();

	/** Constructor using raw copy of pre-existing `::pdf_page`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_page* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfPage(::pdf_page* internal);

	/** Destructor using pdf_drop_page(). */
	FZ_FUNCTION ~PdfPage();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_page* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_pattern`. */
struct PdfPattern
{
	/** Copy constructor using `pdf_keep_pattern()`. */
	FZ_FUNCTION PdfPattern(const PdfPattern& rhs);

	/** operator= using `pdf_keep_pattern()` and `pdf_drop_pattern()`. */
	FZ_FUNCTION PdfPattern& operator=(const PdfPattern& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfPattern();

	/** Constructor using raw copy of pre-existing `::pdf_pattern`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_pattern* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfPattern(::pdf_pattern* internal);

	/** Destructor using pdf_drop_pattern(). */
	FZ_FUNCTION ~PdfPattern();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_pattern* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct `pdf_pkcs7_distinguished_name`. Not copyable or assignable. */
struct PdfPkcs7DistinguishedName
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfPkcs7DistinguishedName();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_signature_drop_distinguished_name()`.  */
	FZ_FUNCTION void pdf_signature_drop_distinguished_name() const;

	/** Class-aware wrapper for `::pdf_signature_format_distinguished_name()`.  */
	FZ_FUNCTION char *pdf_signature_format_distinguished_name() const;

	/** Constructor using raw copy of pre-existing `::pdf_pkcs7_distinguished_name`. */
	FZ_FUNCTION PdfPkcs7DistinguishedName(::pdf_pkcs7_distinguished_name* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfPkcs7DistinguishedName();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_pkcs7_distinguished_name* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7DistinguishedName(const PdfPkcs7DistinguishedName& rhs);
	PdfPkcs7DistinguishedName& operator=(const PdfPkcs7DistinguishedName& rhs);
};

/** Wrapper class for struct `pdf_pkcs7_signer`. Not copyable or assignable. */
struct PdfPkcs7Signer
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfPkcs7Signer();

	/** Constructor using raw copy of pre-existing `::pdf_pkcs7_signer`. */
	FZ_FUNCTION PdfPkcs7Signer(::pdf_pkcs7_signer* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfPkcs7Signer();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_pkcs7_signer* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7Signer(const PdfPkcs7Signer& rhs);
	PdfPkcs7Signer& operator=(const PdfPkcs7Signer& rhs);
};

/** Wrapper class for struct `pdf_pkcs7_verifier`. Not copyable or assignable. */
struct PdfPkcs7Verifier
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfPkcs7Verifier();

	/** Constructor using raw copy of pre-existing `::pdf_pkcs7_verifier`. */
	FZ_FUNCTION PdfPkcs7Verifier(::pdf_pkcs7_verifier* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfPkcs7Verifier();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_pkcs7_verifier* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7Verifier(const PdfPkcs7Verifier& rhs);
	PdfPkcs7Verifier& operator=(const PdfPkcs7Verifier& rhs);
};

/** Wrapper class for struct `pdf_processor`. */
struct PdfProcessor
{
	/** == Constructors. */

	/** Constructor using `pdf_new_buffer_processor()`. */
	FZ_FUNCTION PdfProcessor(const FzBuffer& buffer, int ahxencode, int newlines);

	/** Constructor using `pdf_new_output_processor()`. */
	FZ_FUNCTION PdfProcessor(const FzOutput& out, int ahxencode, int newlines);

	/** Constructor using `pdf_new_run_processor()`. */
	FZ_FUNCTION PdfProcessor(const PdfDocument& doc, const FzDevice& dev, const FzMatrix& ctm, int struct_parent, const char *usage, const PdfGstate& gstate, const FzDefaultColorspaces& default_cs, FzCookie& cookie, const PdfGstate& fill_gstate, const PdfGstate& stroke_gstate);

	/** Constructor using `pdf_new_sanitize_filter()`. */
	FZ_FUNCTION PdfProcessor(const PdfDocument& doc, const PdfProcessor& chain, int struct_parents, const FzMatrix& transform, PdfFilterOptions& options, void *sopts);

	/** Copy constructor using `pdf_keep_processor()`. */
	FZ_FUNCTION PdfProcessor(const PdfProcessor& rhs);

	/** operator= using `pdf_keep_processor()` and `pdf_drop_processor()`. */
	FZ_FUNCTION PdfProcessor& operator=(const PdfProcessor& rhs);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfProcessor();

	/* == Static methods. */

	/** Class-aware wrapper for `::pdf_new_color_filter()`.  */
	FZ_FUNCTION static PdfProcessor pdf_new_color_filter(const PdfDocument& doc, const PdfProcessor& chain, int struct_parents, const FzMatrix& transform, PdfFilterOptions& options, void *copts);

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_close_processor()`.  */
	FZ_FUNCTION void pdf_close_processor() const;

	/** Class-aware wrapper for `::pdf_process_annot()`.  */
	FZ_FUNCTION void pdf_process_annot(const PdfAnnot& annot, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_process_contents()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_process_contents(::pdf_document *doc, ::pdf_obj *res, ::pdf_obj *stm, ::fz_cookie *cookie, ::pdf_obj **out_res)` => 
	 */
	FZ_FUNCTION void pdf_process_contents(const PdfDocument& doc, const PdfObj& res, const PdfObj& stm, FzCookie& cookie, PdfObj& out_res) const;

	/** Class-aware wrapper for `::pdf_process_glyph()`.  */
	FZ_FUNCTION void pdf_process_glyph(const PdfDocument& doc, const PdfObj& resources, const FzBuffer& contents) const;

	/** Class-aware wrapper for `::pdf_process_raw_contents()`.  */
	FZ_FUNCTION void pdf_process_raw_contents(const PdfDocument& doc, const PdfObj& rdb, const PdfObj& stmobj, FzCookie& cookie) const;

	/** Class-aware wrapper for `::pdf_processor_pop_resources()`.  */
	FZ_FUNCTION PdfObj pdf_processor_pop_resources() const;

	/** Class-aware wrapper for `::pdf_processor_push_resources()`.  */
	FZ_FUNCTION void pdf_processor_push_resources(const PdfObj& res) const;

	/** Class-aware wrapper for `::pdf_reset_processor()`.  */
	FZ_FUNCTION void pdf_reset_processor() const;

	/** Constructor using raw copy of pre-existing `::pdf_processor`. */
	/* This constructor is marked as `explicit` because wrapper classes do not
	call `keep`in constructors, but do call `drop` in destructors. So
	automatic construction from a pdf_processor* will generally cause an
	unbalanced `drop` resulting in errors such as SEGV. */
	FZ_FUNCTION explicit PdfProcessor(::pdf_processor* internal);

	/** Destructor using pdf_drop_processor(). */
	FZ_FUNCTION ~PdfProcessor();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_processor* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;
};

/** Wrapper class for struct pdf_processor with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfProcessor2 : PdfProcessor
{

	/** == Constructor. */
	FZ_FUNCTION PdfProcessor2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~PdfProcessor2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_close_processor( bool use=true);
	FZ_FUNCTION void use_virtual_drop_processor( bool use=true);
	FZ_FUNCTION void use_virtual_reset_processor( bool use=true);
	FZ_FUNCTION void use_virtual_push_resources( bool use=true);
	FZ_FUNCTION void use_virtual_pop_resources( bool use=true);
	FZ_FUNCTION void use_virtual_op_w( bool use=true);
	FZ_FUNCTION void use_virtual_op_j( bool use=true);
	FZ_FUNCTION void use_virtual_op_J( bool use=true);
	FZ_FUNCTION void use_virtual_op_M( bool use=true);
	FZ_FUNCTION void use_virtual_op_d( bool use=true);
	FZ_FUNCTION void use_virtual_op_ri( bool use=true);
	FZ_FUNCTION void use_virtual_op_i( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_begin( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_BM( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_ca( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_CA( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_SMask( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_end( bool use=true);
	FZ_FUNCTION void use_virtual_op_q( bool use=true);
	FZ_FUNCTION void use_virtual_op_Q( bool use=true);
	FZ_FUNCTION void use_virtual_op_cm( bool use=true);
	FZ_FUNCTION void use_virtual_op_m( bool use=true);
	FZ_FUNCTION void use_virtual_op_l( bool use=true);
	FZ_FUNCTION void use_virtual_op_c( bool use=true);
	FZ_FUNCTION void use_virtual_op_v( bool use=true);
	FZ_FUNCTION void use_virtual_op_y( bool use=true);
	FZ_FUNCTION void use_virtual_op_h( bool use=true);
	FZ_FUNCTION void use_virtual_op_re( bool use=true);
	FZ_FUNCTION void use_virtual_op_S( bool use=true);
	FZ_FUNCTION void use_virtual_op_s( bool use=true);
	FZ_FUNCTION void use_virtual_op_F( bool use=true);
	FZ_FUNCTION void use_virtual_op_f( bool use=true);
	FZ_FUNCTION void use_virtual_op_fstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_B( bool use=true);
	FZ_FUNCTION void use_virtual_op_Bstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_b( bool use=true);
	FZ_FUNCTION void use_virtual_op_bstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_n( bool use=true);
	FZ_FUNCTION void use_virtual_op_W( bool use=true);
	FZ_FUNCTION void use_virtual_op_Wstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_BT( bool use=true);
	FZ_FUNCTION void use_virtual_op_ET( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tc( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tw( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tz( bool use=true);
	FZ_FUNCTION void use_virtual_op_TL( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tf( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tr( bool use=true);
	FZ_FUNCTION void use_virtual_op_Ts( bool use=true);
	FZ_FUNCTION void use_virtual_op_Td( bool use=true);
	FZ_FUNCTION void use_virtual_op_TD( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tm( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_TJ( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tj( bool use=true);
	FZ_FUNCTION void use_virtual_op_squote( bool use=true);
	FZ_FUNCTION void use_virtual_op_dquote( bool use=true);
	FZ_FUNCTION void use_virtual_op_d0( bool use=true);
	FZ_FUNCTION void use_virtual_op_d1( bool use=true);
	FZ_FUNCTION void use_virtual_op_CS( bool use=true);
	FZ_FUNCTION void use_virtual_op_cs( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_pattern( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_pattern( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_shade( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_shade( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_color( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_color( bool use=true);
	FZ_FUNCTION void use_virtual_op_G( bool use=true);
	FZ_FUNCTION void use_virtual_op_g( bool use=true);
	FZ_FUNCTION void use_virtual_op_RG( bool use=true);
	FZ_FUNCTION void use_virtual_op_rg( bool use=true);
	FZ_FUNCTION void use_virtual_op_K( bool use=true);
	FZ_FUNCTION void use_virtual_op_k( bool use=true);
	FZ_FUNCTION void use_virtual_op_BI( bool use=true);
	FZ_FUNCTION void use_virtual_op_sh( bool use=true);
	FZ_FUNCTION void use_virtual_op_Do_image( bool use=true);
	FZ_FUNCTION void use_virtual_op_Do_form( bool use=true);
	FZ_FUNCTION void use_virtual_op_MP( bool use=true);
	FZ_FUNCTION void use_virtual_op_DP( bool use=true);
	FZ_FUNCTION void use_virtual_op_BMC( bool use=true);
	FZ_FUNCTION void use_virtual_op_BDC( bool use=true);
	FZ_FUNCTION void use_virtual_op_EMC( bool use=true);
	FZ_FUNCTION void use_virtual_op_BX( bool use=true);
	FZ_FUNCTION void use_virtual_op_EX( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_OP( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_op( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_OPM( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_UseBlackPtComp( bool use=true);
	FZ_FUNCTION void use_virtual_op_EOD( bool use=true);
	FZ_FUNCTION void use_virtual_op_END( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void close_processor(::fz_context *arg_0);
	FZ_FUNCTION virtual void drop_processor(::fz_context *arg_0);
	FZ_FUNCTION virtual void reset_processor(::fz_context *arg_0);
	FZ_FUNCTION virtual void push_resources(::fz_context *arg_0, ::pdf_obj *arg_2);
	FZ_FUNCTION virtual ::pdf_obj * pop_resources(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_w(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_j(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_J(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_M(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_d(::fz_context *arg_0, ::pdf_obj *arg_2, float arg_3);
	FZ_FUNCTION virtual void op_ri(::fz_context *arg_0, const char *arg_2);
	FZ_FUNCTION virtual void op_i(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_gs_begin(::fz_context *arg_0, const char *arg_2, ::pdf_obj *arg_3);
	FZ_FUNCTION virtual void op_gs_BM(::fz_context *arg_0, const char *arg_2);
	FZ_FUNCTION virtual void op_gs_ca(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_gs_CA(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_gs_SMask(::fz_context *arg_0, ::pdf_obj *arg_2, ::fz_colorspace *arg_3, float *arg_4, int arg_5, ::pdf_obj *arg_6);
	FZ_FUNCTION virtual void op_gs_end(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_q(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_Q(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_cm(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_m(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_l(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_c(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_v(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_y(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_h(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_re(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_S(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_s(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_F(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_f(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_fstar(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_B(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_Bstar(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_b(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_bstar(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_n(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_W(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_Wstar(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_BT(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_ET(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_Tc(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_Tw(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_Tz(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_TL(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_Tf(::fz_context *arg_0, const char *arg_2, ::pdf_font_desc *arg_3, float arg_4);
	FZ_FUNCTION virtual void op_Tr(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_Ts(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_Td(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_TD(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_Tm(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_Tstar(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_TJ(::fz_context *arg_0, ::pdf_obj *arg_2);
	FZ_FUNCTION virtual void op_Tj(::fz_context *arg_0, char *arg_2, unsigned long long arg_3);
	FZ_FUNCTION virtual void op_squote(::fz_context *arg_0, char *arg_2, unsigned long long arg_3);
	FZ_FUNCTION virtual void op_dquote(::fz_context *arg_0, float arg_2, float arg_3, char *arg_4, unsigned long long arg_5);
	FZ_FUNCTION virtual void op_d0(::fz_context *arg_0, float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_d1(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_CS(::fz_context *arg_0, const char *arg_2, ::fz_colorspace *arg_3);
	FZ_FUNCTION virtual void op_cs(::fz_context *arg_0, const char *arg_2, ::fz_colorspace *arg_3);
	FZ_FUNCTION virtual void op_SC_pattern(::fz_context *arg_0, const char *arg_2, ::pdf_pattern *arg_3, int arg_4, float *arg_5);
	FZ_FUNCTION virtual void op_sc_pattern(::fz_context *arg_0, const char *arg_2, ::pdf_pattern *arg_3, int arg_4, float *arg_5);
	FZ_FUNCTION virtual void op_SC_shade(::fz_context *arg_0, const char *arg_2, ::fz_shade *arg_3);
	FZ_FUNCTION virtual void op_sc_shade(::fz_context *arg_0, const char *arg_2, ::fz_shade *arg_3);
	FZ_FUNCTION virtual void op_SC_color(::fz_context *arg_0, int arg_2, float *arg_3);
	FZ_FUNCTION virtual void op_sc_color(::fz_context *arg_0, int arg_2, float *arg_3);
	FZ_FUNCTION virtual void op_G(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_g(::fz_context *arg_0, float arg_2);
	FZ_FUNCTION virtual void op_RG(::fz_context *arg_0, float arg_2, float arg_3, float arg_4);
	FZ_FUNCTION virtual void op_rg(::fz_context *arg_0, float arg_2, float arg_3, float arg_4);
	FZ_FUNCTION virtual void op_K(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_k(::fz_context *arg_0, float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_BI(::fz_context *arg_0, ::fz_image *arg_2, const char *arg_3);
	FZ_FUNCTION virtual void op_sh(::fz_context *arg_0, const char *arg_2, ::fz_shade *arg_3);
	FZ_FUNCTION virtual void op_Do_image(::fz_context *arg_0, const char *arg_2, ::fz_image *arg_3);
	FZ_FUNCTION virtual void op_Do_form(::fz_context *arg_0, const char *arg_2, ::pdf_obj *arg_3);
	FZ_FUNCTION virtual void op_MP(::fz_context *arg_0, const char *arg_2);
	FZ_FUNCTION virtual void op_DP(::fz_context *arg_0, const char *arg_2, ::pdf_obj *arg_3, ::pdf_obj *arg_4);
	FZ_FUNCTION virtual void op_BMC(::fz_context *arg_0, const char *arg_2);
	FZ_FUNCTION virtual void op_BDC(::fz_context *arg_0, const char *arg_2, ::pdf_obj *arg_3, ::pdf_obj *arg_4);
	FZ_FUNCTION virtual void op_EMC(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_BX(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_EX(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_gs_OP(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_gs_op(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_gs_OPM(::fz_context *arg_0, int arg_2);
	FZ_FUNCTION virtual void op_gs_UseBlackPtComp(::fz_context *arg_0, ::pdf_obj *arg_2);
	FZ_FUNCTION virtual void op_EOD(::fz_context *arg_0);
	FZ_FUNCTION virtual void op_END(::fz_context *arg_0);
};

/** Wrapper class for struct `pdf_range`. Not copyable or assignable. */
struct PdfRange
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfRange();

	/** Constructor using raw copy of pre-existing `::pdf_range`. */
	FZ_FUNCTION PdfRange(::pdf_range* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfRange();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_range* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfRange(const PdfRange& rhs);
	PdfRange& operator=(const PdfRange& rhs);
};

/** Wrapper class for struct `pdf_recolor_options`. */
struct PdfRecolorOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfRecolorOptions();

	/** Constructor using raw copy of pre-existing `::pdf_recolor_options`. */
	FZ_FUNCTION PdfRecolorOptions(const ::pdf_recolor_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_recolor_options`. */
	FZ_FUNCTION PdfRecolorOptions(const ::pdf_recolor_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_recolor_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_recolor_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfRecolorOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_recolor_options. */
	int num_comp;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfRecolorOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfRecolorOptions& rhs);
};

/** Wrapper class for struct `pdf_redact_options`. */
struct PdfRedactOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfRedactOptions();

	/** Constructor using raw copy of pre-existing `::pdf_redact_options`. */
	FZ_FUNCTION PdfRedactOptions(const ::pdf_redact_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_redact_options`. */
	FZ_FUNCTION PdfRedactOptions(const ::pdf_redact_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_redact_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_redact_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfRedactOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_redact_options. */
	int black_boxes;
	int image_method;
	int line_art;
	int text;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfRedactOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfRedactOptions& rhs);
};

/** Wrapper class for struct `pdf_rev_page_map`. Not copyable or assignable. */
struct PdfRevPageMap
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfRevPageMap();

	/** Constructor using raw copy of pre-existing `::pdf_rev_page_map`. */
	FZ_FUNCTION PdfRevPageMap(::pdf_rev_page_map* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfRevPageMap();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_rev_page_map* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfRevPageMap(const PdfRevPageMap& rhs);
	PdfRevPageMap& operator=(const PdfRevPageMap& rhs);
};

/** Wrapper class for struct `pdf_sanitize_filter_options`. */
struct PdfSanitizeFilterOptions
{
	/** We use default copy constructor and operator=. */

	/** Default constructor, sets each member to default value. */
	FZ_FUNCTION PdfSanitizeFilterOptions();

	/** Constructor using raw copy of pre-existing `::pdf_sanitize_filter_options`. */
	FZ_FUNCTION PdfSanitizeFilterOptions(const ::pdf_sanitize_filter_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_sanitize_filter_options`. */
	FZ_FUNCTION PdfSanitizeFilterOptions(const ::pdf_sanitize_filter_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_sanitize_filter_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_sanitize_filter_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfSanitizeFilterOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_sanitize_filter_options. */
	void *opaque;
	::fz_image *(*image_filter)(::fz_context *, void *, ::fz_matrix , const char *, ::fz_image *, ::fz_rect );
	int (*text_filter)(::fz_context *, void *, int *, int , ::fz_matrix , ::fz_matrix , ::fz_rect );
	void (*after_text_object)(::fz_context *, void *, ::pdf_document *, ::pdf_processor *, ::fz_matrix );
	int (*culler)(::fz_context *, void *, ::fz_rect , ::fz_cull_type );

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfSanitizeFilterOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfSanitizeFilterOptions& rhs);
};

/** Wrapper class for struct pdf_sanitize_filter_options with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfSanitizeFilterOptions2 : PdfSanitizeFilterOptions
{

	/** == Constructor. */
	FZ_FUNCTION PdfSanitizeFilterOptions2();

	/** == Destructor. */
	FZ_FUNCTION virtual ~PdfSanitizeFilterOptions2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_image_filter( bool use=true);
	FZ_FUNCTION void use_virtual_text_filter( bool use=true);
	FZ_FUNCTION void use_virtual_after_text_object( bool use=true);
	FZ_FUNCTION void use_virtual_culler( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual ::fz_image * image_filter(::fz_context *arg_0, ::fz_matrix arg_2, const char *arg_3, ::fz_image *arg_4, ::fz_rect arg_5);
	FZ_FUNCTION virtual int text_filter(::fz_context *arg_0, int *arg_2, int arg_3, ::fz_matrix arg_4, ::fz_matrix arg_5, ::fz_rect arg_6);
	FZ_FUNCTION virtual void after_text_object(::fz_context *arg_0, ::pdf_document *arg_2, ::pdf_processor *arg_3, ::fz_matrix arg_4);
	FZ_FUNCTION virtual int culler(::fz_context *arg_0, ::fz_rect arg_2, ::fz_cull_type arg_3);
};

/** Wrapper class for struct `pdf_text_object_state`. Not copyable or assignable. */
struct PdfTextObjectState
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfTextObjectState();

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_tos_get_text()`.  */
	FZ_FUNCTION FzText pdf_tos_get_text() const;

	/** Class-aware wrapper for `::pdf_tos_make_trm()`.
	
	This method has out-params. Python/C# wrappers look like:
		`pdf_tos_make_trm(::pdf_text_state *text, ::pdf_font_desc *fontdesc, int cid, ::fz_matrix *trm)` => `(int, float adv)`
	 */
	FZ_FUNCTION int pdf_tos_make_trm(const PdfTextState& text, const PdfFontDesc& fontdesc, int cid, FzMatrix& trm, float *adv) const;

	/** Class-aware wrapper for `::pdf_tos_move_after_char()`.  */
	FZ_FUNCTION void pdf_tos_move_after_char() const;

	/** Class-aware wrapper for `::pdf_tos_newline()`.  */
	FZ_FUNCTION void pdf_tos_newline(float leading) const;

	/** Class-aware wrapper for `::pdf_tos_reset()`.  */
	FZ_FUNCTION void pdf_tos_reset(int render) const;

	/** Class-aware wrapper for `::pdf_tos_set_matrix()`.  */
	FZ_FUNCTION void pdf_tos_set_matrix(float a, float b, float c, float d, float e, float f) const;

	/** Class-aware wrapper for `::pdf_tos_translate()`.  */
	FZ_FUNCTION void pdf_tos_translate(float tx, float ty) const;

	/** Constructor using raw copy of pre-existing `::pdf_text_object_state`. */
	FZ_FUNCTION PdfTextObjectState(::pdf_text_object_state* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfTextObjectState();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_text_object_state* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfTextObjectState(const PdfTextObjectState& rhs);
	PdfTextObjectState& operator=(const PdfTextObjectState& rhs);
};

/** Wrapper class for struct `pdf_text_state`. Not copyable or assignable. */
struct PdfTextState
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfTextState();

	/** Constructor using raw copy of pre-existing `::pdf_text_state`. */
	FZ_FUNCTION PdfTextState(::pdf_text_state* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfTextState();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_text_state* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfTextState(const PdfTextState& rhs);
	PdfTextState& operator=(const PdfTextState& rhs);
};

/** Wrapper class for struct `pdf_unsaved_sig`. Not copyable or assignable. */
struct PdfUnsavedSig
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfUnsavedSig();

	/** Constructor using raw copy of pre-existing `::pdf_unsaved_sig`. */
	FZ_FUNCTION PdfUnsavedSig(::pdf_unsaved_sig* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfUnsavedSig();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_unsaved_sig* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfUnsavedSig(const PdfUnsavedSig& rhs);
	PdfUnsavedSig& operator=(const PdfUnsavedSig& rhs);
};

/** Wrapper class for struct `pdf_vmtx`. Not copyable or assignable. */
struct PdfVmtx
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfVmtx();

	/** Constructor using raw copy of pre-existing `::pdf_vmtx`. */
	FZ_FUNCTION PdfVmtx(::pdf_vmtx* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfVmtx();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_vmtx* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfVmtx(const PdfVmtx& rhs);
	PdfVmtx& operator=(const PdfVmtx& rhs);
};

/** Wrapper class for struct `pdf_write_options`. */
struct PdfWriteOptions
{
	/** Default constructor, makes copy of pdf_default_write_options. */
	FZ_FUNCTION PdfWriteOptions();

	/** Copy constructor using raw memcopy(). */
	FZ_FUNCTION PdfWriteOptions(const PdfWriteOptions& rhs);

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Class-aware wrapper for `::pdf_parse_write_options()`.  */
	FZ_FUNCTION PdfWriteOptions pdf_parse_write_options(const char *args);

	/** Assignment using plain memcpy(). */
	FZ_FUNCTION PdfWriteOptions& operator=(const PdfWriteOptions& rhs);

	/** Copies <text> into opwd_utf8[]. */
	FZ_FUNCTION void opwd_utf8_set_value(const std::string& text);

	/** Copies <text> into upwd_utf8[]. */
	FZ_FUNCTION void upwd_utf8_set_value(const std::string& text);

	/** Constructor using raw copy of pre-existing `::pdf_write_options`. */
	FZ_FUNCTION PdfWriteOptions(const ::pdf_write_options* internal);

	/** Constructor using raw copy of pre-existing `::pdf_write_options`. */
	FZ_FUNCTION PdfWriteOptions(const ::pdf_write_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION ::pdf_write_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const ::pdf_write_options* internal() const;

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfWriteOptions();
	#else
	/** We use default destructor. */
	#endif

	/* == Member data. */

	/* These members are the same as the members of ::pdf_write_options. */
	int do_incremental;
	int do_pretty;
	int do_ascii;
	int do_compress;
	int do_compress_images;
	int do_compress_fonts;
	int do_decompress;
	int do_garbage;
	int do_linear;
	int do_clean;
	int do_sanitize;
	int do_appearance;
	int do_encrypt;
	int dont_regenerate_id;
	int permissions;
	char opwd_utf8[128];
	char upwd_utf8[128];
	int do_snapshot;
	int do_preserve_metadata;
	int do_use_objstms;
	int compression_effort;
	int do_labels;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	/** Comparison method. */
	FZ_FUNCTION bool operator==(const PdfWriteOptions& rhs);

	/** Comparison method. */
	FZ_FUNCTION bool operator!=(const PdfWriteOptions& rhs);
};

/** Wrapper class for struct `pdf_xrange`. Not copyable or assignable. */
struct PdfXrange
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfXrange();

	/** Constructor using raw copy of pre-existing `::pdf_xrange`. */
	FZ_FUNCTION PdfXrange(::pdf_xrange* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfXrange();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_xrange* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfXrange(const PdfXrange& rhs);
	PdfXrange& operator=(const PdfXrange& rhs);
};

/** Wrapper class for struct `pdf_xref`. Not copyable or assignable. */
struct PdfXref
{
	/** == Constructors. */

	/** Constructor using `pdf_new_local_xref()`. */
	FZ_FUNCTION PdfXref(const PdfDocument& doc);

	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfXref();

	/** Constructor using raw copy of pre-existing `::pdf_xref`. */
	FZ_FUNCTION PdfXref(::pdf_xref* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfXref();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_xref* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfXref(const PdfXref& rhs);
	PdfXref& operator=(const PdfXref& rhs);
};

/** Wrapper class for struct `pdf_xref_entry`. Not copyable or assignable. */
struct PdfXrefEntry
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfXrefEntry();

	/** Constructor using raw copy of pre-existing `::pdf_xref_entry`. */
	FZ_FUNCTION PdfXrefEntry(::pdf_xref_entry* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfXrefEntry();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_xref_entry* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfXrefEntry(const PdfXrefEntry& rhs);
	PdfXrefEntry& operator=(const PdfXrefEntry& rhs);
};

/** Wrapper class for struct `pdf_xref_subsec`. Not copyable or assignable. */
struct PdfXrefSubsec
{
	/** Default constructor, sets `m_internal` to null. */
	FZ_FUNCTION PdfXrefSubsec();

	/** Constructor using raw copy of pre-existing `::pdf_xref_subsec`. */
	FZ_FUNCTION PdfXrefSubsec(::pdf_xref_subsec* internal);

	#ifndef NDEBUG
	/** Destructor only decrements s_num_instances. */
	FZ_FUNCTION ~PdfXrefSubsec();
	#else
	/** We use default destructor. */
	#endif

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/** Return true iff `m_internal` is not null. */
	FZ_FUNCTION operator bool();

	/* == Member data. */

	/** Pointer to wrapped data. */
	::pdf_xref_subsec* m_internal;

	/* Ideally this would be in `#ifndef NDEBUG...#endif`, but Swig will
	generate code regardless so we always need to have this available. */
	FZ_DATA static int s_num_instances;

	private:

	/** This class is not copyable or assignable. */
	PdfXrefSubsec(const PdfXrefSubsec& rhs);
	PdfXrefSubsec& operator=(const PdfXrefSubsec& rhs);
};

/** Returns map from class name (for example FzDocument) to s_num_instances. */
FZ_FUNCTION std::map<std::string, int> num_instances();

struct FzLinkIterator
{
	FZ_FUNCTION FzLinkIterator(const FzLink& item);
	FZ_FUNCTION FzLinkIterator& operator++();
	FZ_FUNCTION bool operator==( const FzLinkIterator& rhs);
	FZ_FUNCTION bool operator!=( const FzLinkIterator& rhs);
	FZ_FUNCTION FzLink operator*();
	FZ_FUNCTION FzLink* operator->();
	private:
	FzLink m_item;
};

struct FzStextBlockIterator
{
	FZ_FUNCTION FzStextBlockIterator(const FzStextLine& item);
	FZ_FUNCTION FzStextBlockIterator& operator++();
	FZ_FUNCTION bool operator==( const FzStextBlockIterator& rhs);
	FZ_FUNCTION bool operator!=( const FzStextBlockIterator& rhs);
	FZ_FUNCTION FzStextLine operator*();
	FZ_FUNCTION FzStextLine* operator->();
	private:
	FzStextLine m_item;
};

struct FzStextLineIterator
{
	FZ_FUNCTION FzStextLineIterator(const FzStextChar& item);
	FZ_FUNCTION FzStextLineIterator& operator++();
	FZ_FUNCTION bool operator==( const FzStextLineIterator& rhs);
	FZ_FUNCTION bool operator!=( const FzStextLineIterator& rhs);
	FZ_FUNCTION FzStextChar operator*();
	FZ_FUNCTION FzStextChar* operator->();
	private:
	FzStextChar m_item;
};

struct FzStextPageIterator
{
	FZ_FUNCTION FzStextPageIterator(const FzStextBlock& item);
	FZ_FUNCTION FzStextPageIterator& operator++();
	FZ_FUNCTION bool operator==( const FzStextPageIterator& rhs);
	FZ_FUNCTION bool operator!=( const FzStextPageIterator& rhs);
	FZ_FUNCTION FzStextBlock operator*();
	FZ_FUNCTION FzStextBlock* operator->();
	private:
	FzStextBlock m_item;
};

} /* End of namespace mupdf. */

/** mupdf::FzAaContext: writes underlying fz_aa_context's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzAaContext& rhs);

/** mupdf::FzAaContext: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzAaContext& lhs, const mupdf::FzAaContext& rhs);

/** mupdf::FzAaContext: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzAaContext& lhs, const mupdf::FzAaContext& rhs);

/** mupdf::FzColorParams: writes underlying fz_color_params's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzColorParams& rhs);

/** mupdf::FzColorParams: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzColorParams& lhs, const mupdf::FzColorParams& rhs);

/** mupdf::FzColorParams: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzColorParams& lhs, const mupdf::FzColorParams& rhs);

/** mupdf::FzCookie: writes underlying fz_cookie's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzCookie& rhs);

/** mupdf::FzCookie: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzCookie& lhs, const mupdf::FzCookie& rhs);

/** mupdf::FzCookie: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzCookie& lhs, const mupdf::FzCookie& rhs);

/** mupdf::FzDrawOptions: writes underlying fz_draw_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzDrawOptions& rhs);

/** mupdf::FzDrawOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzDrawOptions& lhs, const mupdf::FzDrawOptions& rhs);

/** mupdf::FzDrawOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzDrawOptions& lhs, const mupdf::FzDrawOptions& rhs);

/** mupdf::FzInstallLoadSystemFontFuncsArgs: writes underlying fz_install_load_system_font_funcs_args's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzInstallLoadSystemFontFuncsArgs& rhs);

/** mupdf::FzInstallLoadSystemFontFuncsArgs: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzInstallLoadSystemFontFuncsArgs& lhs, const mupdf::FzInstallLoadSystemFontFuncsArgs& rhs);

/** mupdf::FzInstallLoadSystemFontFuncsArgs: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzInstallLoadSystemFontFuncsArgs& lhs, const mupdf::FzInstallLoadSystemFontFuncsArgs& rhs);

/** mupdf::FzIrect: writes underlying fz_irect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzIrect& rhs);

/** mupdf::FzIrect: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzIrect& lhs, const mupdf::FzIrect& rhs);

/** mupdf::FzIrect: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzIrect& lhs, const mupdf::FzIrect& rhs);

/** mupdf::FzLocation: writes underlying fz_location's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzLocation& rhs);

/** mupdf::FzLocation: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzLocation& lhs, const mupdf::FzLocation& rhs);

/** mupdf::FzLocation: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzLocation& lhs, const mupdf::FzLocation& rhs);

/** mupdf::FzMatrix: writes underlying fz_matrix's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzMatrix& rhs);

/** mupdf::FzMatrix: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzMatrix& lhs, const mupdf::FzMatrix& rhs);

/** mupdf::FzMatrix: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzMatrix& lhs, const mupdf::FzMatrix& rhs);

/** mupdf::FzMd5: writes underlying fz_md5's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzMd5& rhs);

/** mupdf::FzMd5: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzMd5& lhs, const mupdf::FzMd5& rhs);

/** mupdf::FzMd5: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzMd5& lhs, const mupdf::FzMd5& rhs);

/** mupdf::FzPdfocrOptions: writes underlying fz_pdfocr_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzPdfocrOptions& rhs);

/** mupdf::FzPdfocrOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzPdfocrOptions& lhs, const mupdf::FzPdfocrOptions& rhs);

/** mupdf::FzPdfocrOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzPdfocrOptions& lhs, const mupdf::FzPdfocrOptions& rhs);

/** mupdf::FzPoint: writes underlying fz_point's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzPoint& rhs);

/** mupdf::FzPoint: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzPoint& lhs, const mupdf::FzPoint& rhs);

/** mupdf::FzPoint: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzPoint& lhs, const mupdf::FzPoint& rhs);

/** mupdf::FzPwgOptions: writes underlying fz_pwg_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzPwgOptions& rhs);

/** mupdf::FzPwgOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzPwgOptions& lhs, const mupdf::FzPwgOptions& rhs);

/** mupdf::FzPwgOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzPwgOptions& lhs, const mupdf::FzPwgOptions& rhs);

/** mupdf::FzQuad: writes underlying fz_quad's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzQuad& rhs);

/** mupdf::FzQuad: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzQuad& lhs, const mupdf::FzQuad& rhs);

/** mupdf::FzQuad: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzQuad& lhs, const mupdf::FzQuad& rhs);

/** mupdf::FzRect: writes underlying fz_rect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzRect& rhs);

/** mupdf::FzRect: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzRect& lhs, const mupdf::FzRect& rhs);

/** mupdf::FzRect: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzRect& lhs, const mupdf::FzRect& rhs);

/** mupdf::FzStextOptions: writes underlying fz_stext_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzStextOptions& rhs);

/** mupdf::FzStextOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzStextOptions& lhs, const mupdf::FzStextOptions& rhs);

/** mupdf::FzStextOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzStextOptions& lhs, const mupdf::FzStextOptions& rhs);

/** mupdf::FzStoryElementPosition: writes underlying fz_story_element_position's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzStoryElementPosition& rhs);

/** mupdf::FzStoryElementPosition: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzStoryElementPosition& lhs, const mupdf::FzStoryElementPosition& rhs);

/** mupdf::FzStoryElementPosition: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzStoryElementPosition& lhs, const mupdf::FzStoryElementPosition& rhs);

/** mupdf::FzTransition: writes underlying fz_transition's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::FzTransition& rhs);

/** mupdf::FzTransition: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::FzTransition& lhs, const mupdf::FzTransition& rhs);

/** mupdf::FzTransition: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::FzTransition& lhs, const mupdf::FzTransition& rhs);

/** mupdf::PdfCleanOptions: writes underlying pdf_clean_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfCleanOptions& rhs);

/** mupdf::PdfCleanOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfCleanOptions& lhs, const mupdf::PdfCleanOptions& rhs);

/** mupdf::PdfCleanOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfCleanOptions& lhs, const mupdf::PdfCleanOptions& rhs);

/** mupdf::PdfFilterFactory: writes underlying pdf_filter_factory's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfFilterFactory& rhs);

/** mupdf::PdfFilterFactory: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfFilterFactory& lhs, const mupdf::PdfFilterFactory& rhs);

/** mupdf::PdfFilterFactory: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfFilterFactory& lhs, const mupdf::PdfFilterFactory& rhs);

/** mupdf::PdfFilterOptions: writes underlying pdf_filter_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfFilterOptions& rhs);

/** mupdf::PdfFilterOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfFilterOptions& lhs, const mupdf::PdfFilterOptions& rhs);

/** mupdf::PdfFilterOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfFilterOptions& lhs, const mupdf::PdfFilterOptions& rhs);

/** mupdf::PdfImageRewriterOptions: writes underlying pdf_image_rewriter_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfImageRewriterOptions& rhs);

/** mupdf::PdfImageRewriterOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfImageRewriterOptions& lhs, const mupdf::PdfImageRewriterOptions& rhs);

/** mupdf::PdfImageRewriterOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfImageRewriterOptions& lhs, const mupdf::PdfImageRewriterOptions& rhs);

/** mupdf::PdfLayerConfig: writes underlying pdf_layer_config's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfLayerConfig& rhs);

/** mupdf::PdfLayerConfig: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfLayerConfig& lhs, const mupdf::PdfLayerConfig& rhs);

/** mupdf::PdfLayerConfig: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfLayerConfig& lhs, const mupdf::PdfLayerConfig& rhs);

/** mupdf::PdfLayerConfigUi: writes underlying pdf_layer_config_ui's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfLayerConfigUi& rhs);

/** mupdf::PdfLayerConfigUi: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfLayerConfigUi& lhs, const mupdf::PdfLayerConfigUi& rhs);

/** mupdf::PdfLayerConfigUi: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfLayerConfigUi& lhs, const mupdf::PdfLayerConfigUi& rhs);

/** mupdf::PdfRecolorOptions: writes underlying pdf_recolor_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfRecolorOptions& rhs);

/** mupdf::PdfRecolorOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfRecolorOptions& lhs, const mupdf::PdfRecolorOptions& rhs);

/** mupdf::PdfRecolorOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfRecolorOptions& lhs, const mupdf::PdfRecolorOptions& rhs);

/** mupdf::PdfRedactOptions: writes underlying pdf_redact_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfRedactOptions& rhs);

/** mupdf::PdfRedactOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfRedactOptions& lhs, const mupdf::PdfRedactOptions& rhs);

/** mupdf::PdfRedactOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfRedactOptions& lhs, const mupdf::PdfRedactOptions& rhs);

/** mupdf::PdfSanitizeFilterOptions: writes underlying pdf_sanitize_filter_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfSanitizeFilterOptions& rhs);

/** mupdf::PdfSanitizeFilterOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfSanitizeFilterOptions& lhs, const mupdf::PdfSanitizeFilterOptions& rhs);

/** mupdf::PdfSanitizeFilterOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfSanitizeFilterOptions& lhs, const mupdf::PdfSanitizeFilterOptions& rhs);

/** mupdf::PdfWriteOptions: writes underlying pdf_write_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const mupdf::PdfWriteOptions& rhs);

/** mupdf::PdfWriteOptions: comparison function. */
FZ_FUNCTION bool operator==( const mupdf::PdfWriteOptions& lhs, const mupdf::PdfWriteOptions& rhs);

/** mupdf::PdfWriteOptions: comparison function. */
FZ_FUNCTION bool operator!=( const mupdf::PdfWriteOptions& lhs, const mupdf::PdfWriteOptions& rhs);

#endif
