/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeClusterVmAffinityRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#compute_cluster_id ComputeClusterVmAffinityRule#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * Enable this rule in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#enabled ComputeClusterVmAffinityRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#id ComputeClusterVmAffinityRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When true, prevents any virtual machine operations that may violate this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#mandatory ComputeClusterVmAffinityRule#mandatory}
    */
    readonly mandatory?: boolean | cdktf.IResolvable;
    /**
    * The unique name of the virtual machine group in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#name ComputeClusterVmAffinityRule#name}
    */
    readonly name: string;
    /**
    * The UUIDs of the virtual machines to run on the same host together.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#virtual_machine_ids ComputeClusterVmAffinityRule#virtual_machine_ids}
    */
    readonly virtualMachineIds: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule vsphere_compute_cluster_vm_affinity_rule}
*/
export declare class ComputeClusterVmAffinityRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_compute_cluster_vm_affinity_rule";
    /**
    * Generates CDKTF code for importing a ComputeClusterVmAffinityRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeClusterVmAffinityRule to import
    * @param importFromId The id of the existing ComputeClusterVmAffinityRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeClusterVmAffinityRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster_vm_affinity_rule vsphere_compute_cluster_vm_affinity_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterVmAffinityRuleConfig
    */
    constructor(scope: Construct, id: string, config: ComputeClusterVmAffinityRuleConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mandatory?;
    get mandatory(): boolean | cdktf.IResolvable;
    set mandatory(value: boolean | cdktf.IResolvable);
    resetMandatory(): void;
    get mandatoryInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualMachineIds?;
    get virtualMachineIds(): string[];
    set virtualMachineIds(value: string[]);
    get virtualMachineIdsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
