"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeCluster = exports.ComputeClusterVsanStretchedClusterOutputReference = exports.ComputeClusterVsanFaultDomainsList = exports.ComputeClusterVsanFaultDomainsOutputReference = exports.ComputeClusterVsanFaultDomainsFaultDomainList = exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = exports.ComputeClusterVsanDiskGroupList = exports.ComputeClusterVsanDiskGroupOutputReference = exports.ComputeClusterHostImageOutputReference = exports.ComputeClusterHostImageComponentList = exports.ComputeClusterHostImageComponentOutputReference = void 0;
exports.computeClusterHostImageComponentToTerraform = computeClusterHostImageComponentToTerraform;
exports.computeClusterHostImageComponentToHclTerraform = computeClusterHostImageComponentToHclTerraform;
exports.computeClusterHostImageToTerraform = computeClusterHostImageToTerraform;
exports.computeClusterHostImageToHclTerraform = computeClusterHostImageToHclTerraform;
exports.computeClusterVsanDiskGroupToTerraform = computeClusterVsanDiskGroupToTerraform;
exports.computeClusterVsanDiskGroupToHclTerraform = computeClusterVsanDiskGroupToHclTerraform;
exports.computeClusterVsanFaultDomainsFaultDomainToTerraform = computeClusterVsanFaultDomainsFaultDomainToTerraform;
exports.computeClusterVsanFaultDomainsFaultDomainToHclTerraform = computeClusterVsanFaultDomainsFaultDomainToHclTerraform;
exports.computeClusterVsanFaultDomainsToTerraform = computeClusterVsanFaultDomainsToTerraform;
exports.computeClusterVsanFaultDomainsToHclTerraform = computeClusterVsanFaultDomainsToHclTerraform;
exports.computeClusterVsanStretchedClusterToTerraform = computeClusterVsanStretchedClusterToTerraform;
exports.computeClusterVsanStretchedClusterToHclTerraform = computeClusterVsanStretchedClusterToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeClusterHostImageComponentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        version: cdktf.stringToTerraform(struct.version),
    };
}
function computeClusterHostImageComponentToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        key: {
            value: cdktf.stringToHclTerraform(struct.key),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        version: {
            value: cdktf.stringToHclTerraform(struct.version),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterHostImageComponentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._key !== undefined) {
            hasAnyValues = true;
            internalValueResult.key = this._key;
        }
        if (this._version !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._key = undefined;
            this._version = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._key = value.key;
            this._version = value.version;
        }
    }
    get key() {
        return this.getStringAttribute('key');
    }
    set key(value) {
        this._key = value;
    }
    resetKey() {
        this._key = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyInput() {
        return this._key;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
}
exports.ComputeClusterHostImageComponentOutputReference = ComputeClusterHostImageComponentOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentOutputReference", version: "11.1.1" };
class ComputeClusterHostImageComponentList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterHostImageComponentOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterHostImageComponentList = ComputeClusterHostImageComponentList;
_b = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentList[_b] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentList", version: "11.1.1" };
function computeClusterHostImageToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        esx_version: cdktf.stringToTerraform(struct.esxVersion),
        component: cdktf.listMapper(computeClusterHostImageComponentToTerraform, true)(struct.component),
    };
}
function computeClusterHostImageToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        esx_version: {
            value: cdktf.stringToHclTerraform(struct.esxVersion),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        component: {
            value: cdktf.listMapperHcl(computeClusterHostImageComponentToHclTerraform, true)(struct.component),
            isBlock: true,
            type: "list",
            storageClassType: "ComputeClusterHostImageComponentList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterHostImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // component - computed: false, optional: true, required: false
        this._component = new ComputeClusterHostImageComponentList(this, "component", false);
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._esxVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.esxVersion = this._esxVersion;
        }
        if (this._component?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.component = this._component?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._esxVersion = undefined;
            this._component.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._esxVersion = value.esxVersion;
            this._component.internalValue = value.component;
        }
    }
    get esxVersion() {
        return this.getStringAttribute('esx_version');
    }
    set esxVersion(value) {
        this._esxVersion = value;
    }
    resetEsxVersion() {
        this._esxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get esxVersionInput() {
        return this._esxVersion;
    }
    get component() {
        return this._component;
    }
    putComponent(value) {
        this._component.internalValue = value;
    }
    resetComponent() {
        this._component.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get componentInput() {
        return this._component.internalValue;
    }
}
exports.ComputeClusterHostImageOutputReference = ComputeClusterHostImageOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageOutputReference", version: "11.1.1" };
function computeClusterVsanDiskGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache: cdktf.stringToTerraform(struct.cache),
        storage: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.storage),
    };
}
function computeClusterVsanDiskGroupToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        cache: {
            value: cdktf.stringToHclTerraform(struct.cache),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        storage: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.storage),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cache !== undefined) {
            hasAnyValues = true;
            internalValueResult.cache = this._cache;
        }
        if (this._storage !== undefined) {
            hasAnyValues = true;
            internalValueResult.storage = this._storage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._cache = undefined;
            this._storage = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._cache = value.cache;
            this._storage = value.storage;
        }
    }
    get cache() {
        return this.getStringAttribute('cache');
    }
    set cache(value) {
        this._cache = value;
    }
    resetCache() {
        this._cache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInput() {
        return this._cache;
    }
    get storage() {
        return cdktf.Fn.tolist(this.getListAttribute('storage'));
    }
    set storage(value) {
        this._storage = value;
    }
    resetStorage() {
        this._storage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageInput() {
        return this._storage;
    }
}
exports.ComputeClusterVsanDiskGroupOutputReference = ComputeClusterVsanDiskGroupOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupOutputReference[_d] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupOutputReference", version: "11.1.1" };
class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanDiskGroupOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanDiskGroupList = ComputeClusterVsanDiskGroupList;
_e = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupList[_e] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupList", version: "11.1.1" };
function computeClusterVsanFaultDomainsFaultDomainToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.hostIds),
        name: cdktf.stringToTerraform(struct.name),
    };
}
function computeClusterVsanFaultDomainsFaultDomainToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.hostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        name: {
            value: cdktf.stringToHclTerraform(struct.name),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterVsanFaultDomainsFaultDomainOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._hostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostIds = this._hostIds;
        }
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._hostIds = undefined;
            this._name = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._hostIds = value.hostIds;
            this._name = value.name;
        }
    }
    get hostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_ids'));
    }
    set hostIds(value) {
        this._hostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostIdsInput() {
        return this._hostIds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = ComputeClusterVsanFaultDomainsFaultDomainOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainOutputReference[_f] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainOutputReference", version: "11.1.1" };
class ComputeClusterVsanFaultDomainsFaultDomainList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsFaultDomainOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainList = ComputeClusterVsanFaultDomainsFaultDomainList;
_g = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainList[_g] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainList", version: "11.1.1" };
function computeClusterVsanFaultDomainsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fault_domain: cdktf.listMapper(computeClusterVsanFaultDomainsFaultDomainToTerraform, true)(struct.faultDomain),
    };
}
function computeClusterVsanFaultDomainsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        fault_domain: {
            value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsFaultDomainToHclTerraform, true)(struct.faultDomain),
            isBlock: true,
            type: "set",
            storageClassType: "ComputeClusterVsanFaultDomainsFaultDomainList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterVsanFaultDomainsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
        // fault_domain - computed: false, optional: true, required: false
        this._faultDomain = new ComputeClusterVsanFaultDomainsFaultDomainList(this, "fault_domain", true);
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._faultDomain?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.faultDomain = this._faultDomain?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = value.faultDomain;
        }
    }
    get faultDomain() {
        return this._faultDomain;
    }
    putFaultDomain(value) {
        this._faultDomain.internalValue = value;
    }
    resetFaultDomain() {
        this._faultDomain.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faultDomainInput() {
        return this._faultDomain.internalValue;
    }
}
exports.ComputeClusterVsanFaultDomainsOutputReference = ComputeClusterVsanFaultDomainsOutputReference;
_h = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsOutputReference[_h] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsOutputReference", version: "11.1.1" };
class ComputeClusterVsanFaultDomainsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsList = ComputeClusterVsanFaultDomainsList;
_j = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsList[_j] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsList", version: "11.1.1" };
function computeClusterVsanStretchedClusterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        preferred_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.preferredFaultDomainHostIds),
        preferred_fault_domain_name: cdktf.stringToTerraform(struct.preferredFaultDomainName),
        secondary_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.secondaryFaultDomainHostIds),
        secondary_fault_domain_name: cdktf.stringToTerraform(struct.secondaryFaultDomainName),
        witness_node: cdktf.stringToTerraform(struct.witnessNode),
    };
}
function computeClusterVsanStretchedClusterToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        preferred_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.preferredFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        preferred_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.preferredFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        secondary_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.secondaryFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        secondary_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.secondaryFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        witness_node: {
            value: cdktf.stringToHclTerraform(struct.witnessNode),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class ComputeClusterVsanStretchedClusterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._preferredFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainHostIds = this._preferredFaultDomainHostIds;
        }
        if (this._preferredFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainName = this._preferredFaultDomainName;
        }
        if (this._secondaryFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainHostIds = this._secondaryFaultDomainHostIds;
        }
        if (this._secondaryFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainName = this._secondaryFaultDomainName;
        }
        if (this._witnessNode !== undefined) {
            hasAnyValues = true;
            internalValueResult.witnessNode = this._witnessNode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._preferredFaultDomainHostIds = undefined;
            this._preferredFaultDomainName = undefined;
            this._secondaryFaultDomainHostIds = undefined;
            this._secondaryFaultDomainName = undefined;
            this._witnessNode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._preferredFaultDomainHostIds = value.preferredFaultDomainHostIds;
            this._preferredFaultDomainName = value.preferredFaultDomainName;
            this._secondaryFaultDomainHostIds = value.secondaryFaultDomainHostIds;
            this._secondaryFaultDomainName = value.secondaryFaultDomainName;
            this._witnessNode = value.witnessNode;
        }
    }
    get preferredFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('preferred_fault_domain_host_ids'));
    }
    set preferredFaultDomainHostIds(value) {
        this._preferredFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainHostIdsInput() {
        return this._preferredFaultDomainHostIds;
    }
    get preferredFaultDomainName() {
        return this.getStringAttribute('preferred_fault_domain_name');
    }
    set preferredFaultDomainName(value) {
        this._preferredFaultDomainName = value;
    }
    resetPreferredFaultDomainName() {
        this._preferredFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainNameInput() {
        return this._preferredFaultDomainName;
    }
    get secondaryFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('secondary_fault_domain_host_ids'));
    }
    set secondaryFaultDomainHostIds(value) {
        this._secondaryFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainHostIdsInput() {
        return this._secondaryFaultDomainHostIds;
    }
    get secondaryFaultDomainName() {
        return this.getStringAttribute('secondary_fault_domain_name');
    }
    set secondaryFaultDomainName(value) {
        this._secondaryFaultDomainName = value;
    }
    resetSecondaryFaultDomainName() {
        this._secondaryFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainNameInput() {
        return this._secondaryFaultDomainName;
    }
    get witnessNode() {
        return this.getStringAttribute('witness_node');
    }
    set witnessNode(value) {
        this._witnessNode = value;
    }
    // Temporarily expose input value. Use with caution.
    get witnessNodeInput() {
        return this._witnessNode;
    }
}
exports.ComputeClusterVsanStretchedClusterOutputReference = ComputeClusterVsanStretchedClusterOutputReference;
_k = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanStretchedClusterOutputReference[_k] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanStretchedClusterOutputReference", version: "11.1.1" };
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster vsphere_compute_cluster}
*/
class ComputeCluster extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ComputeCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeCluster to import
    * @param importFromId The id of the existing ComputeCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_compute_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_compute_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.14.1',
                providerVersionConstraint: '~> 2.13'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // host_image - computed: false, optional: true, required: false
        this._hostImage = new ComputeClusterHostImageOutputReference(this, "host_image");
        // vsan_disk_group - computed: false, optional: true, required: false
        this._vsanDiskGroup = new ComputeClusterVsanDiskGroupList(this, "vsan_disk_group", false);
        // vsan_fault_domains - computed: false, optional: true, required: false
        this._vsanFaultDomains = new ComputeClusterVsanFaultDomainsList(this, "vsan_fault_domains", true);
        // vsan_stretched_cluster - computed: false, optional: true, required: false
        this._vsanStretchedCluster = new ComputeClusterVsanStretchedClusterOutputReference(this, "vsan_stretched_cluster");
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._dpmAutomationLevel = config.dpmAutomationLevel;
        this._dpmEnabled = config.dpmEnabled;
        this._dpmThreshold = config.dpmThreshold;
        this._drsAdvancedOptions = config.drsAdvancedOptions;
        this._drsAutomationLevel = config.drsAutomationLevel;
        this._drsEnablePredictiveDrs = config.drsEnablePredictiveDrs;
        this._drsEnableVmOverrides = config.drsEnableVmOverrides;
        this._drsEnabled = config.drsEnabled;
        this._drsMigrationThreshold = config.drsMigrationThreshold;
        this._drsScaleDescendantsShares = config.drsScaleDescendantsShares;
        this._folder = config.folder;
        this._forceEvacuateOnDestroy = config.forceEvacuateOnDestroy;
        this._haAdmissionControlFailoverHostSystemIds = config.haAdmissionControlFailoverHostSystemIds;
        this._haAdmissionControlHostFailureTolerance = config.haAdmissionControlHostFailureTolerance;
        this._haAdmissionControlPerformanceTolerance = config.haAdmissionControlPerformanceTolerance;
        this._haAdmissionControlPolicy = config.haAdmissionControlPolicy;
        this._haAdmissionControlResourcePercentageAutoCompute = config.haAdmissionControlResourcePercentageAutoCompute;
        this._haAdmissionControlResourcePercentageCpu = config.haAdmissionControlResourcePercentageCpu;
        this._haAdmissionControlResourcePercentageMemory = config.haAdmissionControlResourcePercentageMemory;
        this._haAdmissionControlSlotPolicyExplicitCpu = config.haAdmissionControlSlotPolicyExplicitCpu;
        this._haAdmissionControlSlotPolicyExplicitMemory = config.haAdmissionControlSlotPolicyExplicitMemory;
        this._haAdmissionControlSlotPolicyUseExplicitSize = config.haAdmissionControlSlotPolicyUseExplicitSize;
        this._haAdvancedOptions = config.haAdvancedOptions;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haEnabled = config.haEnabled;
        this._haHeartbeatDatastoreIds = config.haHeartbeatDatastoreIds;
        this._haHeartbeatDatastorePolicy = config.haHeartbeatDatastorePolicy;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haHostMonitoring = config.haHostMonitoring;
        this._haVmComponentProtection = config.haVmComponentProtection;
        this._haVmDependencyRestartCondition = config.haVmDependencyRestartCondition;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmRestartAdditionalDelay = config.haVmRestartAdditionalDelay;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._hostClusterExitTimeout = config.hostClusterExitTimeout;
        this._hostManaged = config.hostManaged;
        this._hostSystemIds = config.hostSystemIds;
        this._id = config.id;
        this._name = config.name;
        this._proactiveHaAutomationLevel = config.proactiveHaAutomationLevel;
        this._proactiveHaEnabled = config.proactiveHaEnabled;
        this._proactiveHaModerateRemediation = config.proactiveHaModerateRemediation;
        this._proactiveHaProviderIds = config.proactiveHaProviderIds;
        this._proactiveHaSevereRemediation = config.proactiveHaSevereRemediation;
        this._tags = config.tags;
        this._vsanCompressionEnabled = config.vsanCompressionEnabled;
        this._vsanDedupEnabled = config.vsanDedupEnabled;
        this._vsanDitEncryptionEnabled = config.vsanDitEncryptionEnabled;
        this._vsanDitRekeyInterval = config.vsanDitRekeyInterval;
        this._vsanEnabled = config.vsanEnabled;
        this._vsanEsaEnabled = config.vsanEsaEnabled;
        this._vsanNetworkDiagnosticModeEnabled = config.vsanNetworkDiagnosticModeEnabled;
        this._vsanPerformanceEnabled = config.vsanPerformanceEnabled;
        this._vsanRemoteDatastoreIds = config.vsanRemoteDatastoreIds;
        this._vsanUnmapEnabled = config.vsanUnmapEnabled;
        this._vsanVerboseModeEnabled = config.vsanVerboseModeEnabled;
        this._hostImage.internalValue = config.hostImage;
        this._vsanDiskGroup.internalValue = config.vsanDiskGroup;
        this._vsanFaultDomains.internalValue = config.vsanFaultDomains;
        this._vsanStretchedCluster.internalValue = config.vsanStretchedCluster;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get dpmAutomationLevel() {
        return this.getStringAttribute('dpm_automation_level');
    }
    set dpmAutomationLevel(value) {
        this._dpmAutomationLevel = value;
    }
    resetDpmAutomationLevel() {
        this._dpmAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmAutomationLevelInput() {
        return this._dpmAutomationLevel;
    }
    get dpmEnabled() {
        return this.getBooleanAttribute('dpm_enabled');
    }
    set dpmEnabled(value) {
        this._dpmEnabled = value;
    }
    resetDpmEnabled() {
        this._dpmEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmEnabledInput() {
        return this._dpmEnabled;
    }
    get dpmThreshold() {
        return this.getNumberAttribute('dpm_threshold');
    }
    set dpmThreshold(value) {
        this._dpmThreshold = value;
    }
    resetDpmThreshold() {
        this._dpmThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmThresholdInput() {
        return this._dpmThreshold;
    }
    get drsAdvancedOptions() {
        return this.getStringMapAttribute('drs_advanced_options');
    }
    set drsAdvancedOptions(value) {
        this._drsAdvancedOptions = value;
    }
    resetDrsAdvancedOptions() {
        this._drsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAdvancedOptionsInput() {
        return this._drsAdvancedOptions;
    }
    get drsAutomationLevel() {
        return this.getStringAttribute('drs_automation_level');
    }
    set drsAutomationLevel(value) {
        this._drsAutomationLevel = value;
    }
    resetDrsAutomationLevel() {
        this._drsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAutomationLevelInput() {
        return this._drsAutomationLevel;
    }
    get drsEnablePredictiveDrs() {
        return this.getBooleanAttribute('drs_enable_predictive_drs');
    }
    set drsEnablePredictiveDrs(value) {
        this._drsEnablePredictiveDrs = value;
    }
    resetDrsEnablePredictiveDrs() {
        this._drsEnablePredictiveDrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnablePredictiveDrsInput() {
        return this._drsEnablePredictiveDrs;
    }
    get drsEnableVmOverrides() {
        return this.getBooleanAttribute('drs_enable_vm_overrides');
    }
    set drsEnableVmOverrides(value) {
        this._drsEnableVmOverrides = value;
    }
    resetDrsEnableVmOverrides() {
        this._drsEnableVmOverrides = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnableVmOverridesInput() {
        return this._drsEnableVmOverrides;
    }
    get drsEnabled() {
        return this.getBooleanAttribute('drs_enabled');
    }
    set drsEnabled(value) {
        this._drsEnabled = value;
    }
    resetDrsEnabled() {
        this._drsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnabledInput() {
        return this._drsEnabled;
    }
    get drsMigrationThreshold() {
        return this.getNumberAttribute('drs_migration_threshold');
    }
    set drsMigrationThreshold(value) {
        this._drsMigrationThreshold = value;
    }
    resetDrsMigrationThreshold() {
        this._drsMigrationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsMigrationThresholdInput() {
        return this._drsMigrationThreshold;
    }
    get drsScaleDescendantsShares() {
        return this.getStringAttribute('drs_scale_descendants_shares');
    }
    set drsScaleDescendantsShares(value) {
        this._drsScaleDescendantsShares = value;
    }
    resetDrsScaleDescendantsShares() {
        this._drsScaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsScaleDescendantsSharesInput() {
        return this._drsScaleDescendantsShares;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get forceEvacuateOnDestroy() {
        return this.getBooleanAttribute('force_evacuate_on_destroy');
    }
    set forceEvacuateOnDestroy(value) {
        this._forceEvacuateOnDestroy = value;
    }
    resetForceEvacuateOnDestroy() {
        this._forceEvacuateOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceEvacuateOnDestroyInput() {
        return this._forceEvacuateOnDestroy;
    }
    get haAdmissionControlFailoverHostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_admission_control_failover_host_system_ids'));
    }
    set haAdmissionControlFailoverHostSystemIds(value) {
        this._haAdmissionControlFailoverHostSystemIds = value;
    }
    resetHaAdmissionControlFailoverHostSystemIds() {
        this._haAdmissionControlFailoverHostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlFailoverHostSystemIdsInput() {
        return this._haAdmissionControlFailoverHostSystemIds;
    }
    get haAdmissionControlHostFailureTolerance() {
        return this.getNumberAttribute('ha_admission_control_host_failure_tolerance');
    }
    set haAdmissionControlHostFailureTolerance(value) {
        this._haAdmissionControlHostFailureTolerance = value;
    }
    resetHaAdmissionControlHostFailureTolerance() {
        this._haAdmissionControlHostFailureTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlHostFailureToleranceInput() {
        return this._haAdmissionControlHostFailureTolerance;
    }
    get haAdmissionControlPerformanceTolerance() {
        return this.getNumberAttribute('ha_admission_control_performance_tolerance');
    }
    set haAdmissionControlPerformanceTolerance(value) {
        this._haAdmissionControlPerformanceTolerance = value;
    }
    resetHaAdmissionControlPerformanceTolerance() {
        this._haAdmissionControlPerformanceTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPerformanceToleranceInput() {
        return this._haAdmissionControlPerformanceTolerance;
    }
    get haAdmissionControlPolicy() {
        return this.getStringAttribute('ha_admission_control_policy');
    }
    set haAdmissionControlPolicy(value) {
        this._haAdmissionControlPolicy = value;
    }
    resetHaAdmissionControlPolicy() {
        this._haAdmissionControlPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPolicyInput() {
        return this._haAdmissionControlPolicy;
    }
    get haAdmissionControlResourcePercentageAutoCompute() {
        return this.getBooleanAttribute('ha_admission_control_resource_percentage_auto_compute');
    }
    set haAdmissionControlResourcePercentageAutoCompute(value) {
        this._haAdmissionControlResourcePercentageAutoCompute = value;
    }
    resetHaAdmissionControlResourcePercentageAutoCompute() {
        this._haAdmissionControlResourcePercentageAutoCompute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageAutoComputeInput() {
        return this._haAdmissionControlResourcePercentageAutoCompute;
    }
    get haAdmissionControlResourcePercentageCpu() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_cpu');
    }
    set haAdmissionControlResourcePercentageCpu(value) {
        this._haAdmissionControlResourcePercentageCpu = value;
    }
    resetHaAdmissionControlResourcePercentageCpu() {
        this._haAdmissionControlResourcePercentageCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageCpuInput() {
        return this._haAdmissionControlResourcePercentageCpu;
    }
    get haAdmissionControlResourcePercentageMemory() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_memory');
    }
    set haAdmissionControlResourcePercentageMemory(value) {
        this._haAdmissionControlResourcePercentageMemory = value;
    }
    resetHaAdmissionControlResourcePercentageMemory() {
        this._haAdmissionControlResourcePercentageMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageMemoryInput() {
        return this._haAdmissionControlResourcePercentageMemory;
    }
    get haAdmissionControlSlotPolicyExplicitCpu() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_cpu');
    }
    set haAdmissionControlSlotPolicyExplicitCpu(value) {
        this._haAdmissionControlSlotPolicyExplicitCpu = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitCpu() {
        this._haAdmissionControlSlotPolicyExplicitCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitCpuInput() {
        return this._haAdmissionControlSlotPolicyExplicitCpu;
    }
    get haAdmissionControlSlotPolicyExplicitMemory() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_memory');
    }
    set haAdmissionControlSlotPolicyExplicitMemory(value) {
        this._haAdmissionControlSlotPolicyExplicitMemory = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitMemory() {
        this._haAdmissionControlSlotPolicyExplicitMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitMemoryInput() {
        return this._haAdmissionControlSlotPolicyExplicitMemory;
    }
    get haAdmissionControlSlotPolicyUseExplicitSize() {
        return this.getBooleanAttribute('ha_admission_control_slot_policy_use_explicit_size');
    }
    set haAdmissionControlSlotPolicyUseExplicitSize(value) {
        this._haAdmissionControlSlotPolicyUseExplicitSize = value;
    }
    resetHaAdmissionControlSlotPolicyUseExplicitSize() {
        this._haAdmissionControlSlotPolicyUseExplicitSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyUseExplicitSizeInput() {
        return this._haAdmissionControlSlotPolicyUseExplicitSize;
    }
    get haAdvancedOptions() {
        return this.getStringMapAttribute('ha_advanced_options');
    }
    set haAdvancedOptions(value) {
        this._haAdvancedOptions = value;
    }
    resetHaAdvancedOptions() {
        this._haAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdvancedOptionsInput() {
        return this._haAdvancedOptions;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haEnabled() {
        return this.getBooleanAttribute('ha_enabled');
    }
    set haEnabled(value) {
        this._haEnabled = value;
    }
    resetHaEnabled() {
        this._haEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haEnabledInput() {
        return this._haEnabled;
    }
    get haHeartbeatDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_heartbeat_datastore_ids'));
    }
    set haHeartbeatDatastoreIds(value) {
        this._haHeartbeatDatastoreIds = value;
    }
    resetHaHeartbeatDatastoreIds() {
        this._haHeartbeatDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastoreIdsInput() {
        return this._haHeartbeatDatastoreIds;
    }
    get haHeartbeatDatastorePolicy() {
        return this.getStringAttribute('ha_heartbeat_datastore_policy');
    }
    set haHeartbeatDatastorePolicy(value) {
        this._haHeartbeatDatastorePolicy = value;
    }
    resetHaHeartbeatDatastorePolicy() {
        this._haHeartbeatDatastorePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastorePolicyInput() {
        return this._haHeartbeatDatastorePolicy;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haHostMonitoring() {
        return this.getStringAttribute('ha_host_monitoring');
    }
    set haHostMonitoring(value) {
        this._haHostMonitoring = value;
    }
    resetHaHostMonitoring() {
        this._haHostMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostMonitoringInput() {
        return this._haHostMonitoring;
    }
    get haVmComponentProtection() {
        return this.getStringAttribute('ha_vm_component_protection');
    }
    set haVmComponentProtection(value) {
        this._haVmComponentProtection = value;
    }
    resetHaVmComponentProtection() {
        this._haVmComponentProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmComponentProtectionInput() {
        return this._haVmComponentProtection;
    }
    get haVmDependencyRestartCondition() {
        return this.getStringAttribute('ha_vm_dependency_restart_condition');
    }
    set haVmDependencyRestartCondition(value) {
        this._haVmDependencyRestartCondition = value;
    }
    resetHaVmDependencyRestartCondition() {
        this._haVmDependencyRestartCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmDependencyRestartConditionInput() {
        return this._haVmDependencyRestartCondition;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmRestartAdditionalDelay() {
        return this.getNumberAttribute('ha_vm_restart_additional_delay');
    }
    set haVmRestartAdditionalDelay(value) {
        this._haVmRestartAdditionalDelay = value;
    }
    resetHaVmRestartAdditionalDelay() {
        this._haVmRestartAdditionalDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartAdditionalDelayInput() {
        return this._haVmRestartAdditionalDelay;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get hostClusterExitTimeout() {
        return this.getNumberAttribute('host_cluster_exit_timeout');
    }
    set hostClusterExitTimeout(value) {
        this._hostClusterExitTimeout = value;
    }
    resetHostClusterExitTimeout() {
        this._hostClusterExitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostClusterExitTimeoutInput() {
        return this._hostClusterExitTimeout;
    }
    get hostManaged() {
        return this.getBooleanAttribute('host_managed');
    }
    set hostManaged(value) {
        this._hostManaged = value;
    }
    resetHostManaged() {
        this._hostManaged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostManagedInput() {
        return this._hostManaged;
    }
    get hostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_system_ids'));
    }
    set hostSystemIds(value) {
        this._hostSystemIds = value;
    }
    resetHostSystemIds() {
        this._hostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdsInput() {
        return this._hostSystemIds;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get proactiveHaAutomationLevel() {
        return this.getStringAttribute('proactive_ha_automation_level');
    }
    set proactiveHaAutomationLevel(value) {
        this._proactiveHaAutomationLevel = value;
    }
    resetProactiveHaAutomationLevel() {
        this._proactiveHaAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaAutomationLevelInput() {
        return this._proactiveHaAutomationLevel;
    }
    get proactiveHaEnabled() {
        return this.getBooleanAttribute('proactive_ha_enabled');
    }
    set proactiveHaEnabled(value) {
        this._proactiveHaEnabled = value;
    }
    resetProactiveHaEnabled() {
        this._proactiveHaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaEnabledInput() {
        return this._proactiveHaEnabled;
    }
    get proactiveHaModerateRemediation() {
        return this.getStringAttribute('proactive_ha_moderate_remediation');
    }
    set proactiveHaModerateRemediation(value) {
        this._proactiveHaModerateRemediation = value;
    }
    resetProactiveHaModerateRemediation() {
        this._proactiveHaModerateRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaModerateRemediationInput() {
        return this._proactiveHaModerateRemediation;
    }
    get proactiveHaProviderIds() {
        return cdktf.Fn.tolist(this.getListAttribute('proactive_ha_provider_ids'));
    }
    set proactiveHaProviderIds(value) {
        this._proactiveHaProviderIds = value;
    }
    resetProactiveHaProviderIds() {
        this._proactiveHaProviderIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaProviderIdsInput() {
        return this._proactiveHaProviderIds;
    }
    get proactiveHaSevereRemediation() {
        return this.getStringAttribute('proactive_ha_severe_remediation');
    }
    set proactiveHaSevereRemediation(value) {
        this._proactiveHaSevereRemediation = value;
    }
    resetProactiveHaSevereRemediation() {
        this._proactiveHaSevereRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaSevereRemediationInput() {
        return this._proactiveHaSevereRemediation;
    }
    // resource_pool_id - computed: true, optional: false, required: false
    get resourcePoolId() {
        return this.getStringAttribute('resource_pool_id');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get vsanCompressionEnabled() {
        return this.getBooleanAttribute('vsan_compression_enabled');
    }
    set vsanCompressionEnabled(value) {
        this._vsanCompressionEnabled = value;
    }
    resetVsanCompressionEnabled() {
        this._vsanCompressionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanCompressionEnabledInput() {
        return this._vsanCompressionEnabled;
    }
    get vsanDedupEnabled() {
        return this.getBooleanAttribute('vsan_dedup_enabled');
    }
    set vsanDedupEnabled(value) {
        this._vsanDedupEnabled = value;
    }
    resetVsanDedupEnabled() {
        this._vsanDedupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDedupEnabledInput() {
        return this._vsanDedupEnabled;
    }
    get vsanDitEncryptionEnabled() {
        return this.getBooleanAttribute('vsan_dit_encryption_enabled');
    }
    set vsanDitEncryptionEnabled(value) {
        this._vsanDitEncryptionEnabled = value;
    }
    resetVsanDitEncryptionEnabled() {
        this._vsanDitEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitEncryptionEnabledInput() {
        return this._vsanDitEncryptionEnabled;
    }
    get vsanDitRekeyInterval() {
        return this.getNumberAttribute('vsan_dit_rekey_interval');
    }
    set vsanDitRekeyInterval(value) {
        this._vsanDitRekeyInterval = value;
    }
    resetVsanDitRekeyInterval() {
        this._vsanDitRekeyInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitRekeyIntervalInput() {
        return this._vsanDitRekeyInterval;
    }
    get vsanEnabled() {
        return this.getBooleanAttribute('vsan_enabled');
    }
    set vsanEnabled(value) {
        this._vsanEnabled = value;
    }
    resetVsanEnabled() {
        this._vsanEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEnabledInput() {
        return this._vsanEnabled;
    }
    get vsanEsaEnabled() {
        return this.getBooleanAttribute('vsan_esa_enabled');
    }
    set vsanEsaEnabled(value) {
        this._vsanEsaEnabled = value;
    }
    resetVsanEsaEnabled() {
        this._vsanEsaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEsaEnabledInput() {
        return this._vsanEsaEnabled;
    }
    get vsanNetworkDiagnosticModeEnabled() {
        return this.getBooleanAttribute('vsan_network_diagnostic_mode_enabled');
    }
    set vsanNetworkDiagnosticModeEnabled(value) {
        this._vsanNetworkDiagnosticModeEnabled = value;
    }
    resetVsanNetworkDiagnosticModeEnabled() {
        this._vsanNetworkDiagnosticModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanNetworkDiagnosticModeEnabledInput() {
        return this._vsanNetworkDiagnosticModeEnabled;
    }
    get vsanPerformanceEnabled() {
        return this.getBooleanAttribute('vsan_performance_enabled');
    }
    set vsanPerformanceEnabled(value) {
        this._vsanPerformanceEnabled = value;
    }
    resetVsanPerformanceEnabled() {
        this._vsanPerformanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanPerformanceEnabledInput() {
        return this._vsanPerformanceEnabled;
    }
    get vsanRemoteDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('vsan_remote_datastore_ids'));
    }
    set vsanRemoteDatastoreIds(value) {
        this._vsanRemoteDatastoreIds = value;
    }
    resetVsanRemoteDatastoreIds() {
        this._vsanRemoteDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanRemoteDatastoreIdsInput() {
        return this._vsanRemoteDatastoreIds;
    }
    get vsanUnmapEnabled() {
        return this.getBooleanAttribute('vsan_unmap_enabled');
    }
    set vsanUnmapEnabled(value) {
        this._vsanUnmapEnabled = value;
    }
    resetVsanUnmapEnabled() {
        this._vsanUnmapEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanUnmapEnabledInput() {
        return this._vsanUnmapEnabled;
    }
    get vsanVerboseModeEnabled() {
        return this.getBooleanAttribute('vsan_verbose_mode_enabled');
    }
    set vsanVerboseModeEnabled(value) {
        this._vsanVerboseModeEnabled = value;
    }
    resetVsanVerboseModeEnabled() {
        this._vsanVerboseModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanVerboseModeEnabledInput() {
        return this._vsanVerboseModeEnabled;
    }
    get hostImage() {
        return this._hostImage;
    }
    putHostImage(value) {
        this._hostImage.internalValue = value;
    }
    resetHostImage() {
        this._hostImage.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostImageInput() {
        return this._hostImage.internalValue;
    }
    get vsanDiskGroup() {
        return this._vsanDiskGroup;
    }
    putVsanDiskGroup(value) {
        this._vsanDiskGroup.internalValue = value;
    }
    resetVsanDiskGroup() {
        this._vsanDiskGroup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDiskGroupInput() {
        return this._vsanDiskGroup.internalValue;
    }
    get vsanFaultDomains() {
        return this._vsanFaultDomains;
    }
    putVsanFaultDomains(value) {
        this._vsanFaultDomains.internalValue = value;
    }
    resetVsanFaultDomains() {
        this._vsanFaultDomains.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanFaultDomainsInput() {
        return this._vsanFaultDomains.internalValue;
    }
    get vsanStretchedCluster() {
        return this._vsanStretchedCluster;
    }
    putVsanStretchedCluster(value) {
        this._vsanStretchedCluster.internalValue = value;
    }
    resetVsanStretchedCluster() {
        this._vsanStretchedCluster.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanStretchedClusterInput() {
        return this._vsanStretchedCluster.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            dpm_automation_level: cdktf.stringToTerraform(this._dpmAutomationLevel),
            dpm_enabled: cdktf.booleanToTerraform(this._dpmEnabled),
            dpm_threshold: cdktf.numberToTerraform(this._dpmThreshold),
            drs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._drsAdvancedOptions),
            drs_automation_level: cdktf.stringToTerraform(this._drsAutomationLevel),
            drs_enable_predictive_drs: cdktf.booleanToTerraform(this._drsEnablePredictiveDrs),
            drs_enable_vm_overrides: cdktf.booleanToTerraform(this._drsEnableVmOverrides),
            drs_enabled: cdktf.booleanToTerraform(this._drsEnabled),
            drs_migration_threshold: cdktf.numberToTerraform(this._drsMigrationThreshold),
            drs_scale_descendants_shares: cdktf.stringToTerraform(this._drsScaleDescendantsShares),
            folder: cdktf.stringToTerraform(this._folder),
            force_evacuate_on_destroy: cdktf.booleanToTerraform(this._forceEvacuateOnDestroy),
            ha_admission_control_failover_host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
            ha_admission_control_host_failure_tolerance: cdktf.numberToTerraform(this._haAdmissionControlHostFailureTolerance),
            ha_admission_control_performance_tolerance: cdktf.numberToTerraform(this._haAdmissionControlPerformanceTolerance),
            ha_admission_control_policy: cdktf.stringToTerraform(this._haAdmissionControlPolicy),
            ha_admission_control_resource_percentage_auto_compute: cdktf.booleanToTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
            ha_admission_control_resource_percentage_cpu: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageCpu),
            ha_admission_control_resource_percentage_memory: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageMemory),
            ha_admission_control_slot_policy_explicit_cpu: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
            ha_admission_control_slot_policy_explicit_memory: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
            ha_admission_control_slot_policy_use_explicit_size: cdktf.booleanToTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
            ha_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._haAdvancedOptions),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_enabled: cdktf.booleanToTerraform(this._haEnabled),
            ha_heartbeat_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haHeartbeatDatastoreIds),
            ha_heartbeat_datastore_policy: cdktf.stringToTerraform(this._haHeartbeatDatastorePolicy),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_host_monitoring: cdktf.stringToTerraform(this._haHostMonitoring),
            ha_vm_component_protection: cdktf.stringToTerraform(this._haVmComponentProtection),
            ha_vm_dependency_restart_condition: cdktf.stringToTerraform(this._haVmDependencyRestartCondition),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_restart_additional_delay: cdktf.numberToTerraform(this._haVmRestartAdditionalDelay),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            host_cluster_exit_timeout: cdktf.numberToTerraform(this._hostClusterExitTimeout),
            host_managed: cdktf.booleanToTerraform(this._hostManaged),
            host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._hostSystemIds),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            proactive_ha_automation_level: cdktf.stringToTerraform(this._proactiveHaAutomationLevel),
            proactive_ha_enabled: cdktf.booleanToTerraform(this._proactiveHaEnabled),
            proactive_ha_moderate_remediation: cdktf.stringToTerraform(this._proactiveHaModerateRemediation),
            proactive_ha_provider_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._proactiveHaProviderIds),
            proactive_ha_severe_remediation: cdktf.stringToTerraform(this._proactiveHaSevereRemediation),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            vsan_compression_enabled: cdktf.booleanToTerraform(this._vsanCompressionEnabled),
            vsan_dedup_enabled: cdktf.booleanToTerraform(this._vsanDedupEnabled),
            vsan_dit_encryption_enabled: cdktf.booleanToTerraform(this._vsanDitEncryptionEnabled),
            vsan_dit_rekey_interval: cdktf.numberToTerraform(this._vsanDitRekeyInterval),
            vsan_enabled: cdktf.booleanToTerraform(this._vsanEnabled),
            vsan_esa_enabled: cdktf.booleanToTerraform(this._vsanEsaEnabled),
            vsan_network_diagnostic_mode_enabled: cdktf.booleanToTerraform(this._vsanNetworkDiagnosticModeEnabled),
            vsan_performance_enabled: cdktf.booleanToTerraform(this._vsanPerformanceEnabled),
            vsan_remote_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._vsanRemoteDatastoreIds),
            vsan_unmap_enabled: cdktf.booleanToTerraform(this._vsanUnmapEnabled),
            vsan_verbose_mode_enabled: cdktf.booleanToTerraform(this._vsanVerboseModeEnabled),
            host_image: computeClusterHostImageToTerraform(this._hostImage.internalValue),
            vsan_disk_group: cdktf.listMapper(computeClusterVsanDiskGroupToTerraform, true)(this._vsanDiskGroup.internalValue),
            vsan_fault_domains: cdktf.listMapper(computeClusterVsanFaultDomainsToTerraform, true)(this._vsanFaultDomains.internalValue),
            vsan_stretched_cluster: computeClusterVsanStretchedClusterToTerraform(this._vsanStretchedCluster.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_automation_level: {
                value: cdktf.stringToHclTerraform(this._dpmAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_enabled: {
                value: cdktf.booleanToHclTerraform(this._dpmEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            dpm_threshold: {
                value: cdktf.numberToHclTerraform(this._dpmThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._drsAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            drs_automation_level: {
                value: cdktf.stringToHclTerraform(this._drsAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            drs_enable_predictive_drs: {
                value: cdktf.booleanToHclTerraform(this._drsEnablePredictiveDrs),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enable_vm_overrides: {
                value: cdktf.booleanToHclTerraform(this._drsEnableVmOverrides),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enabled: {
                value: cdktf.booleanToHclTerraform(this._drsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_migration_threshold: {
                value: cdktf.numberToHclTerraform(this._drsMigrationThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_scale_descendants_shares: {
                value: cdktf.stringToHclTerraform(this._drsScaleDescendantsShares),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            force_evacuate_on_destroy: {
                value: cdktf.booleanToHclTerraform(this._forceEvacuateOnDestroy),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_failover_host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_admission_control_host_failure_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlHostFailureTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_performance_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlPerformanceTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_policy: {
                value: cdktf.stringToHclTerraform(this._haAdmissionControlPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_admission_control_resource_percentage_auto_compute: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_resource_percentage_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_resource_percentage_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_use_explicit_size: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._haAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            ha_datastore_apd_recovery_action: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdRecoveryAction),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response_delay: {
                value: cdktf.numberToHclTerraform(this._haDatastoreApdResponseDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_datastore_pdl_response: {
                value: cdktf.stringToHclTerraform(this._haDatastorePdlResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._haEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_heartbeat_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haHeartbeatDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_heartbeat_datastore_policy: {
                value: cdktf.stringToHclTerraform(this._haHeartbeatDatastorePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_isolation_response: {
                value: cdktf.stringToHclTerraform(this._haHostIsolationResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_monitoring: {
                value: cdktf.stringToHclTerraform(this._haHostMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_component_protection: {
                value: cdktf.stringToHclTerraform(this._haVmComponentProtection),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_dependency_restart_condition: {
                value: cdktf.stringToHclTerraform(this._haVmDependencyRestartCondition),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_failure_interval: {
                value: cdktf.numberToHclTerraform(this._haVmFailureInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_failure_window: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumFailureWindow),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_resets: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumResets),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_minimum_uptime: {
                value: cdktf.numberToHclTerraform(this._haVmMinimumUptime),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_monitoring: {
                value: cdktf.stringToHclTerraform(this._haVmMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_additional_delay: {
                value: cdktf.numberToHclTerraform(this._haVmRestartAdditionalDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_restart_priority: {
                value: cdktf.stringToHclTerraform(this._haVmRestartPriority),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_timeout: {
                value: cdktf.numberToHclTerraform(this._haVmRestartTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_cluster_exit_timeout: {
                value: cdktf.numberToHclTerraform(this._hostClusterExitTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_managed: {
                value: cdktf.booleanToHclTerraform(this._hostManaged),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._hostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_automation_level: {
                value: cdktf.stringToHclTerraform(this._proactiveHaAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._proactiveHaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            proactive_ha_moderate_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaModerateRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_provider_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._proactiveHaProviderIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            proactive_ha_severe_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaSevereRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_compression_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanCompressionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dedup_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDedupEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_encryption_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDitEncryptionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_rekey_interval: {
                value: cdktf.numberToHclTerraform(this._vsanDitRekeyInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            vsan_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_esa_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEsaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_network_diagnostic_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanNetworkDiagnosticModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_performance_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanPerformanceEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_remote_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._vsanRemoteDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_unmap_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanUnmapEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_verbose_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanVerboseModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_image: {
                value: computeClusterHostImageToHclTerraform(this._hostImage.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterHostImageList",
            },
            vsan_disk_group: {
                value: cdktf.listMapperHcl(computeClusterVsanDiskGroupToHclTerraform, true)(this._vsanDiskGroup.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanDiskGroupList",
            },
            vsan_fault_domains: {
                value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsToHclTerraform, true)(this._vsanFaultDomains.internalValue),
                isBlock: true,
                type: "set",
                storageClassType: "ComputeClusterVsanFaultDomainsList",
            },
            vsan_stretched_cluster: {
                value: computeClusterVsanStretchedClusterToHclTerraform(this._vsanStretchedCluster.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanStretchedClusterList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ComputeCluster = ComputeCluster;
_l = JSII_RTTI_SYMBOL_1;
ComputeCluster[_l] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeCluster", version: "11.1.1" };
// =================
// STATIC PROPERTIES
// =================
ComputeCluster.tfResourceType = "vsphere_compute_cluster";
//# sourceMappingURL=data:application/json;base64,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