/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContentLibraryItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional description of the content library item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#description ContentLibraryItem#description}
    */
    readonly description?: string;
    /**
    * ID of source VM of content library item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#file_url ContentLibraryItem#file_url}
    */
    readonly fileUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#id ContentLibraryItem#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the content library to contain item
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#library_id ContentLibraryItem#library_id}
    */
    readonly libraryId: string;
    /**
    * The name of the content library item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#name ContentLibraryItem#name}
    */
    readonly name: string;
    /**
    * The managed object ID of an existing VM to be cloned to the content library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#source_uuid ContentLibraryItem#source_uuid}
    */
    readonly sourceUuid?: string;
    /**
    * Type of content library item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#type ContentLibraryItem#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item vsphere_content_library_item}
*/
export declare class ContentLibraryItem extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_content_library_item";
    /**
    * Generates CDKTF code for importing a ContentLibraryItem resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContentLibraryItem to import
    * @param importFromId The id of the existing ContentLibraryItem that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContentLibraryItem to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library_item vsphere_content_library_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContentLibraryItemConfig
    */
    constructor(scope: Construct, id: string, config: ContentLibraryItemConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _fileUrl?;
    get fileUrl(): string;
    set fileUrl(value: string);
    resetFileUrl(): void;
    get fileUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _libraryId?;
    get libraryId(): string;
    set libraryId(value: string);
    get libraryIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceUuid?;
    get sourceUuid(): string;
    set sourceUuid(value: string);
    resetSourceUuid(): void;
    get sourceUuidInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
