/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContentLibraryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional description of the content library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#description ContentLibrary#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#id ContentLibrary#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the content library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#name ContentLibrary#name}
    */
    readonly name: string;
    /**
    * The name of the content library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#storage_backing ContentLibrary#storage_backing}
    */
    readonly storageBacking: string[];
    /**
    * publication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#publication ContentLibrary#publication}
    */
    readonly publication?: ContentLibraryPublication;
    /**
    * subscription block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#subscription ContentLibrary#subscription}
    */
    readonly subscription?: ContentLibrarySubscription;
}
export interface ContentLibraryPublication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#authentication_method ContentLibrary#authentication_method}
    */
    readonly authenticationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#password ContentLibrary#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#published ContentLibrary#published}
    */
    readonly published?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#username ContentLibrary#username}
    */
    readonly username?: string;
}
export declare function contentLibraryPublicationToTerraform(struct?: ContentLibraryPublicationOutputReference | ContentLibraryPublication): any;
export declare function contentLibraryPublicationToHclTerraform(struct?: ContentLibraryPublicationOutputReference | ContentLibraryPublication): any;
export declare class ContentLibraryPublicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContentLibraryPublication | undefined;
    set internalValue(value: ContentLibraryPublication | undefined);
    private _authenticationMethod?;
    get authenticationMethod(): string;
    set authenticationMethod(value: string);
    resetAuthenticationMethod(): void;
    get authenticationMethodInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get publishUrl(): string;
    private _published?;
    get published(): boolean | cdktf.IResolvable;
    set published(value: boolean | cdktf.IResolvable);
    resetPublished(): void;
    get publishedInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface ContentLibrarySubscription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#authentication_method ContentLibrary#authentication_method}
    */
    readonly authenticationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#automatic_sync ContentLibrary#automatic_sync}
    */
    readonly automaticSync?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#on_demand ContentLibrary#on_demand}
    */
    readonly onDemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#password ContentLibrary#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#subscription_url ContentLibrary#subscription_url}
    */
    readonly subscriptionUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#username ContentLibrary#username}
    */
    readonly username?: string;
}
export declare function contentLibrarySubscriptionToTerraform(struct?: ContentLibrarySubscriptionOutputReference | ContentLibrarySubscription): any;
export declare function contentLibrarySubscriptionToHclTerraform(struct?: ContentLibrarySubscriptionOutputReference | ContentLibrarySubscription): any;
export declare class ContentLibrarySubscriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContentLibrarySubscription | undefined;
    set internalValue(value: ContentLibrarySubscription | undefined);
    private _authenticationMethod?;
    get authenticationMethod(): string;
    set authenticationMethod(value: string);
    resetAuthenticationMethod(): void;
    get authenticationMethodInput(): string | undefined;
    private _automaticSync?;
    get automaticSync(): boolean | cdktf.IResolvable;
    set automaticSync(value: boolean | cdktf.IResolvable);
    resetAutomaticSync(): void;
    get automaticSyncInput(): boolean | cdktf.IResolvable | undefined;
    private _onDemand?;
    get onDemand(): boolean | cdktf.IResolvable;
    set onDemand(value: boolean | cdktf.IResolvable);
    resetOnDemand(): void;
    get onDemandInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _subscriptionUrl?;
    get subscriptionUrl(): string;
    set subscriptionUrl(value: string);
    resetSubscriptionUrl(): void;
    get subscriptionUrlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library vsphere_content_library}
*/
export declare class ContentLibrary extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_content_library";
    /**
    * Generates CDKTF code for importing a ContentLibrary resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContentLibrary to import
    * @param importFromId The id of the existing ContentLibrary that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContentLibrary to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/content_library vsphere_content_library} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContentLibraryConfig
    */
    constructor(scope: Construct, id: string, config: ContentLibraryConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageBacking?;
    get storageBacking(): string[];
    set storageBacking(value: string[]);
    get storageBackingInput(): string[] | undefined;
    private _publication;
    get publication(): ContentLibraryPublicationOutputReference;
    putPublication(value: ContentLibraryPublication): void;
    resetPublication(): void;
    get publicationInput(): ContentLibraryPublication | undefined;
    private _subscription;
    get subscription(): ContentLibrarySubscriptionOutputReference;
    putSubscription(value: ContentLibrarySubscription): void;
    resetSubscription(): void;
    get subscriptionInput(): ContentLibrarySubscription | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
