/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereDatastoreStatsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The capacity of the datastores.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats#capacity DataVsphereDatastoreStats#capacity}
    */
    readonly capacity?: {
        [key: string]: string;
    };
    /**
    * The managed object ID of the datacenter to get datastores from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats#datacenter_id DataVsphereDatastoreStats#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The free space of the datastores.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats#free_space DataVsphereDatastoreStats#free_space}
    */
    readonly freeSpace?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats#id DataVsphereDatastoreStats#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats vsphere_datastore_stats}
*/
export declare class DataVsphereDatastoreStats extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_datastore_stats";
    /**
    * Generates CDKTF code for importing a DataVsphereDatastoreStats resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereDatastoreStats to import
    * @param importFromId The id of the existing DataVsphereDatastoreStats that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereDatastoreStats to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/datastore_stats vsphere_datastore_stats} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereDatastoreStatsConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereDatastoreStatsConfig);
    private _capacity?;
    get capacity(): {
        [key: string]: string;
    };
    set capacity(value: {
        [key: string]: string;
    });
    resetCapacity(): void;
    get capacityInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _freeSpace?;
    get freeSpace(): {
        [key: string]: string;
    };
    set freeSpace(value: {
        [key: string]: string;
    });
    resetFreeSpace(): void;
    get freeSpaceInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
