/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereHostPciDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The hexadecimal value of the PCI device's class ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#class_id DataVsphereHostPciDevice#class_id}
    */
    readonly classId?: string;
    /**
    * The Managed Object ID of the host system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#host_id DataVsphereHostPciDevice#host_id}
    */
    readonly hostId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#id DataVsphereHostPciDevice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A regular expression used to match the PCI device name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#name_regex DataVsphereHostPciDevice#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * The hexadecimal value of the PCI device's vendor ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#vendor_id DataVsphereHostPciDevice#vendor_id}
    */
    readonly vendorId?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device vsphere_host_pci_device}
*/
export declare class DataVsphereHostPciDevice extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_host_pci_device";
    /**
    * Generates CDKTF code for importing a DataVsphereHostPciDevice resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereHostPciDevice to import
    * @param importFromId The id of the existing DataVsphereHostPciDevice that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereHostPciDevice to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_pci_device vsphere_host_pci_device} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereHostPciDeviceConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereHostPciDeviceConfig);
    private _classId?;
    get classId(): string;
    set classId(value: string);
    resetClassId(): void;
    get classIdInput(): string | undefined;
    private _hostId?;
    get hostId(): string;
    set hostId(value: string);
    get hostIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _vendorId?;
    get vendorId(): string;
    set vendorId(value: string);
    resetVendorId(): void;
    get vendorIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
