/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereHostThumbprintConfig extends cdktf.TerraformMetaArguments {
    /**
    * The address of the ESXi to extract the thumbprint from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint#address DataVsphereHostThumbprint#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint#id DataVsphereHostThumbprint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Boolean that can be set to true to disable SSL certificate verification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint#insecure DataVsphereHostThumbprint#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * The port to connect to on the ESXi host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint#port DataVsphereHostThumbprint#port}
    */
    readonly port?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint vsphere_host_thumbprint}
*/
export declare class DataVsphereHostThumbprint extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_host_thumbprint";
    /**
    * Generates CDKTF code for importing a DataVsphereHostThumbprint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereHostThumbprint to import
    * @param importFromId The id of the existing DataVsphereHostThumbprint that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereHostThumbprint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_thumbprint vsphere_host_thumbprint} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereHostThumbprintConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereHostThumbprintConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable;
    set insecure(value: boolean | cdktf.IResolvable);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
