/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereHostVgpuProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Managed Object ID of the host system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile#host_id DataVsphereHostVgpuProfile#host_id}
    */
    readonly hostId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile#id DataVsphereHostVgpuProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A regular expression used to match the vGPU Profile on the host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile#name_regex DataVsphereHostVgpuProfile#name_regex}
    */
    readonly nameRegex?: string;
}
export interface DataVsphereHostVgpuProfileVgpuProfiles {
}
export declare function dataVsphereHostVgpuProfileVgpuProfilesToTerraform(struct?: DataVsphereHostVgpuProfileVgpuProfiles): any;
export declare function dataVsphereHostVgpuProfileVgpuProfilesToHclTerraform(struct?: DataVsphereHostVgpuProfileVgpuProfiles): any;
export declare class DataVsphereHostVgpuProfileVgpuProfilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereHostVgpuProfileVgpuProfiles | undefined;
    set internalValue(value: DataVsphereHostVgpuProfileVgpuProfiles | undefined);
    get diskSnapshotSupported(): cdktf.IResolvable;
    get memorySnapshotSupported(): cdktf.IResolvable;
    get migrateSupported(): cdktf.IResolvable;
    get suspendSupported(): cdktf.IResolvable;
    get vgpu(): string;
}
export declare class DataVsphereHostVgpuProfileVgpuProfilesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereHostVgpuProfileVgpuProfilesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile vsphere_host_vgpu_profile}
*/
export declare class DataVsphereHostVgpuProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_host_vgpu_profile";
    /**
    * Generates CDKTF code for importing a DataVsphereHostVgpuProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereHostVgpuProfile to import
    * @param importFromId The id of the existing DataVsphereHostVgpuProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereHostVgpuProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/host_vgpu_profile vsphere_host_vgpu_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereHostVgpuProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereHostVgpuProfileConfig);
    private _hostId?;
    get hostId(): string;
    set hostId(value: string);
    get hostIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _vgpuProfiles;
    get vgpuProfiles(): DataVsphereHostVgpuProfileVgpuProfilesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
