/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereOvfVmTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow unverified ssl certificates while deploying ovf/ova from url.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#allow_unverified_ssl_cert DataVsphereOvfVmTemplate#allow_unverified_ssl_cert}
    */
    readonly allowUnverifiedSslCert?: boolean | cdktf.IResolvable;
    /**
    * The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#datastore_id DataVsphereOvfVmTemplate#datastore_id}
    */
    readonly datastoreId?: string;
    /**
    * The Deployment option to be chosen. If empty, the default option is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#deployment_option DataVsphereOvfVmTemplate#deployment_option}
    */
    readonly deploymentOption?: string;
    /**
    * An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#disk_provisioning DataVsphereOvfVmTemplate#disk_provisioning}
    */
    readonly diskProvisioning?: string;
    /**
    * Allow properties with ovf:userConfigurable=false to be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#enable_hidden_properties DataVsphereOvfVmTemplate#enable_hidden_properties}
    */
    readonly enableHiddenProperties?: boolean | cdktf.IResolvable;
    /**
    * The name of the folder to locate the virtual machine in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#folder DataVsphereOvfVmTemplate#folder}
    */
    readonly folder?: string;
    /**
    * The ID of an optional host system to pin the virtual machine to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#host_system_id DataVsphereOvfVmTemplate#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#id DataVsphereOvfVmTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The IP allocation policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#ip_allocation_policy DataVsphereOvfVmTemplate#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: string;
    /**
    * The IP protocol.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#ip_protocol DataVsphereOvfVmTemplate#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * The absolute path to the ovf/ova file in the local system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#local_ovf_path DataVsphereOvfVmTemplate#local_ovf_path}
    */
    readonly localOvfPath?: string;
    /**
    * Name of the virtual machine to create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#name DataVsphereOvfVmTemplate#name}
    */
    readonly name: string;
    /**
    * The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#ovf_network_map DataVsphereOvfVmTemplate#ovf_network_map}
    */
    readonly ovfNetworkMap?: {
        [key: string]: string;
    };
    /**
    * URL to the remote ovf/ova file to be deployed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#remote_ovf_url DataVsphereOvfVmTemplate#remote_ovf_url}
    */
    readonly remoteOvfUrl?: string;
    /**
    * The ID of a resource pool to put the virtual machine in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#resource_pool_id DataVsphereOvfVmTemplate#resource_pool_id}
    */
    readonly resourcePoolId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template vsphere_ovf_vm_template}
*/
export declare class DataVsphereOvfVmTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_ovf_vm_template";
    /**
    * Generates CDKTF code for importing a DataVsphereOvfVmTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereOvfVmTemplate to import
    * @param importFromId The id of the existing DataVsphereOvfVmTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereOvfVmTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/ovf_vm_template vsphere_ovf_vm_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereOvfVmTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereOvfVmTemplateConfig);
    private _allowUnverifiedSslCert?;
    get allowUnverifiedSslCert(): boolean | cdktf.IResolvable;
    set allowUnverifiedSslCert(value: boolean | cdktf.IResolvable);
    resetAllowUnverifiedSslCert(): void;
    get allowUnverifiedSslCertInput(): boolean | cdktf.IResolvable | undefined;
    get alternateGuestName(): string;
    get annotation(): string;
    get cpuHotAddEnabled(): cdktf.IResolvable;
    get cpuHotRemoveEnabled(): cdktf.IResolvable;
    get cpuPerformanceCountersEnabled(): cdktf.IResolvable;
    private _datastoreId?;
    get datastoreId(): string;
    set datastoreId(value: string);
    resetDatastoreId(): void;
    get datastoreIdInput(): string | undefined;
    private _deploymentOption?;
    get deploymentOption(): string;
    set deploymentOption(value: string);
    resetDeploymentOption(): void;
    get deploymentOptionInput(): string | undefined;
    private _diskProvisioning?;
    get diskProvisioning(): string;
    set diskProvisioning(value: string);
    resetDiskProvisioning(): void;
    get diskProvisioningInput(): string | undefined;
    private _enableHiddenProperties?;
    get enableHiddenProperties(): boolean | cdktf.IResolvable;
    set enableHiddenProperties(value: boolean | cdktf.IResolvable);
    resetEnableHiddenProperties(): void;
    get enableHiddenPropertiesInput(): boolean | cdktf.IResolvable | undefined;
    get firmware(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get guestId(): string;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ideControllerCount(): number;
    private _ipAllocationPolicy?;
    get ipAllocationPolicy(): string;
    set ipAllocationPolicy(value: string);
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _localOvfPath?;
    get localOvfPath(): string;
    set localOvfPath(value: string);
    resetLocalOvfPath(): void;
    get localOvfPathInput(): string | undefined;
    get memory(): number;
    get memoryHotAddEnabled(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nestedHvEnabled(): cdktf.IResolvable;
    get numCoresPerSocket(): number;
    get numCpus(): number;
    private _ovfNetworkMap?;
    get ovfNetworkMap(): {
        [key: string]: string;
    };
    set ovfNetworkMap(value: {
        [key: string]: string;
    });
    resetOvfNetworkMap(): void;
    get ovfNetworkMapInput(): {
        [key: string]: string;
    } | undefined;
    private _remoteOvfUrl?;
    get remoteOvfUrl(): string;
    set remoteOvfUrl(value: string);
    resetRemoteOvfUrl(): void;
    get remoteOvfUrlInput(): string | undefined;
    private _resourcePoolId?;
    get resourcePoolId(): string;
    set resourcePoolId(value: string);
    get resourcePoolIdInput(): string | undefined;
    get sataControllerCount(): number;
    get scsiControllerCount(): number;
    get scsiType(): string;
    get swapPlacementPolicy(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
