"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVsphereVirtualMachine = exports.DataVsphereVirtualMachineVappOutputReference = exports.DataVsphereVirtualMachineNetworkInterfacesList = exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = exports.DataVsphereVirtualMachineDisksList = exports.DataVsphereVirtualMachineDisksOutputReference = void 0;
exports.dataVsphereVirtualMachineDisksToTerraform = dataVsphereVirtualMachineDisksToTerraform;
exports.dataVsphereVirtualMachineDisksToHclTerraform = dataVsphereVirtualMachineDisksToHclTerraform;
exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = dataVsphereVirtualMachineNetworkInterfacesToTerraform;
exports.dataVsphereVirtualMachineNetworkInterfacesToHclTerraform = dataVsphereVirtualMachineNetworkInterfacesToHclTerraform;
exports.dataVsphereVirtualMachineVappToTerraform = dataVsphereVirtualMachineVappToTerraform;
exports.dataVsphereVirtualMachineVappToHclTerraform = dataVsphereVirtualMachineVappToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dataVsphereVirtualMachineDisksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
function dataVsphereVirtualMachineDisksToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
class DataVsphereVirtualMachineDisksOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // eagerly_scrub - computed: true, optional: false, required: false
    get eagerlyScrub() {
        return this.getBooleanAttribute('eagerly_scrub');
    }
    // label - computed: true, optional: false, required: false
    get label() {
        return this.getStringAttribute('label');
    }
    // size - computed: true, optional: false, required: false
    get size() {
        return this.getNumberAttribute('size');
    }
    // thin_provisioned - computed: true, optional: false, required: false
    get thinProvisioned() {
        return this.getBooleanAttribute('thin_provisioned');
    }
    // unit_number - computed: true, optional: false, required: false
    get unitNumber() {
        return this.getNumberAttribute('unit_number');
    }
}
exports.DataVsphereVirtualMachineDisksOutputReference = DataVsphereVirtualMachineDisksOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksOutputReference", version: "11.1.1" };
class DataVsphereVirtualMachineDisksList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineDisksOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineDisksList = DataVsphereVirtualMachineDisksList;
_b = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksList[_b] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksList", version: "11.1.1" };
function dataVsphereVirtualMachineNetworkInterfacesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
function dataVsphereVirtualMachineNetworkInterfacesToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
class DataVsphereVirtualMachineNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // adapter_type - computed: true, optional: false, required: false
    get adapterType() {
        return this.getStringAttribute('adapter_type');
    }
    // bandwidth_limit - computed: true, optional: false, required: false
    get bandwidthLimit() {
        return this.getNumberAttribute('bandwidth_limit');
    }
    // bandwidth_reservation - computed: true, optional: false, required: false
    get bandwidthReservation() {
        return this.getNumberAttribute('bandwidth_reservation');
    }
    // bandwidth_share_count - computed: true, optional: false, required: false
    get bandwidthShareCount() {
        return this.getNumberAttribute('bandwidth_share_count');
    }
    // bandwidth_share_level - computed: true, optional: false, required: false
    get bandwidthShareLevel() {
        return this.getStringAttribute('bandwidth_share_level');
    }
    // mac_address - computed: true, optional: false, required: false
    get macAddress() {
        return this.getStringAttribute('mac_address');
    }
    // network_id - computed: true, optional: false, required: false
    get networkId() {
        return this.getStringAttribute('network_id');
    }
    // physical_function - computed: true, optional: false, required: false
    get physicalFunction() {
        return this.getStringAttribute('physical_function');
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = DataVsphereVirtualMachineNetworkInterfacesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesOutputReference", version: "11.1.1" };
class DataVsphereVirtualMachineNetworkInterfacesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineNetworkInterfacesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesList = DataVsphereVirtualMachineNetworkInterfacesList;
_d = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesList[_d] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesList", version: "11.1.1" };
function dataVsphereVirtualMachineVappToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        properties: cdktf.hashMapper(cdktf.stringToTerraform)(struct.properties),
    };
}
function dataVsphereVirtualMachineVappToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        properties: {
            value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(struct.properties),
            isBlock: false,
            type: "map",
            storageClassType: "stringMap",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class DataVsphereVirtualMachineVappOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._properties !== undefined) {
            hasAnyValues = true;
            internalValueResult.properties = this._properties;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._properties = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._properties = value.properties;
        }
    }
    get properties() {
        return this.getStringMapAttribute('properties');
    }
    set properties(value) {
        this._properties = value;
    }
    resetProperties() {
        this._properties = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties;
    }
}
exports.DataVsphereVirtualMachineVappOutputReference = DataVsphereVirtualMachineVappOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineVappOutputReference[_e] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineVappOutputReference", version: "11.1.1" };
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/virtual_machine vsphere_virtual_machine}
*/
class DataVsphereVirtualMachine extends cdktf.TerraformDataSource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DataVsphereVirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereVirtualMachine to import
    * @param importFromId The id of the existing DataVsphereVirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereVirtualMachine to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_virtual_machine", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/virtual_machine vsphere_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVirtualMachineConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vsphere_virtual_machine',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.14.1',
                providerVersionConstraint: '~> 2.13'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // disks - computed: true, optional: false, required: false
        this._disks = new DataVsphereVirtualMachineDisksList(this, "disks", false);
        // network_interfaces - computed: true, optional: false, required: false
        this._networkInterfaces = new DataVsphereVirtualMachineNetworkInterfacesList(this, "network_interfaces", false);
        // vapp - computed: false, optional: true, required: false
        this._vapp = new DataVsphereVirtualMachineVappOutputReference(this, "vapp");
        this._alternateGuestName = config.alternateGuestName;
        this._annotation = config.annotation;
        this._bootDelay = config.bootDelay;
        this._bootRetryDelay = config.bootRetryDelay;
        this._bootRetryEnabled = config.bootRetryEnabled;
        this._cpuHotAddEnabled = config.cpuHotAddEnabled;
        this._cpuHotRemoveEnabled = config.cpuHotRemoveEnabled;
        this._cpuLimit = config.cpuLimit;
        this._cpuPerformanceCountersEnabled = config.cpuPerformanceCountersEnabled;
        this._cpuReservation = config.cpuReservation;
        this._cpuShareCount = config.cpuShareCount;
        this._cpuShareLevel = config.cpuShareLevel;
        this._datacenterId = config.datacenterId;
        this._efiSecureBootEnabled = config.efiSecureBootEnabled;
        this._enableDiskUuid = config.enableDiskUuid;
        this._enableLogging = config.enableLogging;
        this._eptRviMode = config.eptRviMode;
        this._extraConfig = config.extraConfig;
        this._extraConfigRebootRequired = config.extraConfigRebootRequired;
        this._firmware = config.firmware;
        this._folder = config.folder;
        this._guestId = config.guestId;
        this._hardwareVersion = config.hardwareVersion;
        this._hvMode = config.hvMode;
        this._id = config.id;
        this._ideControllerScanCount = config.ideControllerScanCount;
        this._latencySensitivity = config.latencySensitivity;
        this._memory = config.memory;
        this._memoryHotAddEnabled = config.memoryHotAddEnabled;
        this._memoryLimit = config.memoryLimit;
        this._memoryReservation = config.memoryReservation;
        this._memoryReservationLockedToMax = config.memoryReservationLockedToMax;
        this._memoryShareCount = config.memoryShareCount;
        this._memoryShareLevel = config.memoryShareLevel;
        this._moid = config.moid;
        this._name = config.name;
        this._nestedHvEnabled = config.nestedHvEnabled;
        this._numCoresPerSocket = config.numCoresPerSocket;
        this._numCpus = config.numCpus;
        this._nvmeControllerScanCount = config.nvmeControllerScanCount;
        this._replaceTrigger = config.replaceTrigger;
        this._runToolsScriptsAfterPowerOn = config.runToolsScriptsAfterPowerOn;
        this._runToolsScriptsAfterResume = config.runToolsScriptsAfterResume;
        this._runToolsScriptsBeforeGuestReboot = config.runToolsScriptsBeforeGuestReboot;
        this._runToolsScriptsBeforeGuestShutdown = config.runToolsScriptsBeforeGuestShutdown;
        this._runToolsScriptsBeforeGuestStandby = config.runToolsScriptsBeforeGuestStandby;
        this._sataControllerScanCount = config.sataControllerScanCount;
        this._scsiControllerScanCount = config.scsiControllerScanCount;
        this._storagePolicyId = config.storagePolicyId;
        this._swapPlacementPolicy = config.swapPlacementPolicy;
        this._syncTimeWithHost = config.syncTimeWithHost;
        this._syncTimeWithHostPeriodically = config.syncTimeWithHostPeriodically;
        this._toolsUpgradePolicy = config.toolsUpgradePolicy;
        this._uuid = config.uuid;
        this._vbsEnabled = config.vbsEnabled;
        this._vvtdEnabled = config.vvtdEnabled;
        this._vapp.internalValue = config.vapp;
    }
    get alternateGuestName() {
        return this.getStringAttribute('alternate_guest_name');
    }
    set alternateGuestName(value) {
        this._alternateGuestName = value;
    }
    resetAlternateGuestName() {
        this._alternateGuestName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alternateGuestNameInput() {
        return this._alternateGuestName;
    }
    get annotation() {
        return this.getStringAttribute('annotation');
    }
    set annotation(value) {
        this._annotation = value;
    }
    resetAnnotation() {
        this._annotation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get annotationInput() {
        return this._annotation;
    }
    get bootDelay() {
        return this.getNumberAttribute('boot_delay');
    }
    set bootDelay(value) {
        this._bootDelay = value;
    }
    resetBootDelay() {
        this._bootDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootDelayInput() {
        return this._bootDelay;
    }
    get bootRetryDelay() {
        return this.getNumberAttribute('boot_retry_delay');
    }
    set bootRetryDelay(value) {
        this._bootRetryDelay = value;
    }
    resetBootRetryDelay() {
        this._bootRetryDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryDelayInput() {
        return this._bootRetryDelay;
    }
    get bootRetryEnabled() {
        return this.getBooleanAttribute('boot_retry_enabled');
    }
    set bootRetryEnabled(value) {
        this._bootRetryEnabled = value;
    }
    resetBootRetryEnabled() {
        this._bootRetryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryEnabledInput() {
        return this._bootRetryEnabled;
    }
    // change_version - computed: true, optional: false, required: false
    get changeVersion() {
        return this.getStringAttribute('change_version');
    }
    get cpuHotAddEnabled() {
        return this.getBooleanAttribute('cpu_hot_add_enabled');
    }
    set cpuHotAddEnabled(value) {
        this._cpuHotAddEnabled = value;
    }
    resetCpuHotAddEnabled() {
        this._cpuHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotAddEnabledInput() {
        return this._cpuHotAddEnabled;
    }
    get cpuHotRemoveEnabled() {
        return this.getBooleanAttribute('cpu_hot_remove_enabled');
    }
    set cpuHotRemoveEnabled(value) {
        this._cpuHotRemoveEnabled = value;
    }
    resetCpuHotRemoveEnabled() {
        this._cpuHotRemoveEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotRemoveEnabledInput() {
        return this._cpuHotRemoveEnabled;
    }
    get cpuLimit() {
        return this.getNumberAttribute('cpu_limit');
    }
    set cpuLimit(value) {
        this._cpuLimit = value;
    }
    resetCpuLimit() {
        this._cpuLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuLimitInput() {
        return this._cpuLimit;
    }
    get cpuPerformanceCountersEnabled() {
        return this.getBooleanAttribute('cpu_performance_counters_enabled');
    }
    set cpuPerformanceCountersEnabled(value) {
        this._cpuPerformanceCountersEnabled = value;
    }
    resetCpuPerformanceCountersEnabled() {
        this._cpuPerformanceCountersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerformanceCountersEnabledInput() {
        return this._cpuPerformanceCountersEnabled;
    }
    get cpuReservation() {
        return this.getNumberAttribute('cpu_reservation');
    }
    set cpuReservation(value) {
        this._cpuReservation = value;
    }
    resetCpuReservation() {
        this._cpuReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuReservationInput() {
        return this._cpuReservation;
    }
    get cpuShareCount() {
        return this.getNumberAttribute('cpu_share_count');
    }
    set cpuShareCount(value) {
        this._cpuShareCount = value;
    }
    resetCpuShareCount() {
        this._cpuShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareCountInput() {
        return this._cpuShareCount;
    }
    get cpuShareLevel() {
        return this.getStringAttribute('cpu_share_level');
    }
    set cpuShareLevel(value) {
        this._cpuShareLevel = value;
    }
    resetCpuShareLevel() {
        this._cpuShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareLevelInput() {
        return this._cpuShareLevel;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    resetDatacenterId() {
        this._datacenterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    // default_ip_address - computed: true, optional: false, required: false
    get defaultIpAddress() {
        return this.getStringAttribute('default_ip_address');
    }
    get disks() {
        return this._disks;
    }
    get efiSecureBootEnabled() {
        return this.getBooleanAttribute('efi_secure_boot_enabled');
    }
    set efiSecureBootEnabled(value) {
        this._efiSecureBootEnabled = value;
    }
    resetEfiSecureBootEnabled() {
        this._efiSecureBootEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get efiSecureBootEnabledInput() {
        return this._efiSecureBootEnabled;
    }
    get enableDiskUuid() {
        return this.getBooleanAttribute('enable_disk_uuid');
    }
    set enableDiskUuid(value) {
        this._enableDiskUuid = value;
    }
    resetEnableDiskUuid() {
        this._enableDiskUuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDiskUuidInput() {
        return this._enableDiskUuid;
    }
    get enableLogging() {
        return this.getBooleanAttribute('enable_logging');
    }
    set enableLogging(value) {
        this._enableLogging = value;
    }
    resetEnableLogging() {
        this._enableLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableLoggingInput() {
        return this._enableLogging;
    }
    get eptRviMode() {
        return this.getStringAttribute('ept_rvi_mode');
    }
    set eptRviMode(value) {
        this._eptRviMode = value;
    }
    resetEptRviMode() {
        this._eptRviMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eptRviModeInput() {
        return this._eptRviMode;
    }
    get extraConfig() {
        return this.getStringMapAttribute('extra_config');
    }
    set extraConfig(value) {
        this._extraConfig = value;
    }
    resetExtraConfig() {
        this._extraConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigInput() {
        return this._extraConfig;
    }
    get extraConfigRebootRequired() {
        return this.getBooleanAttribute('extra_config_reboot_required');
    }
    set extraConfigRebootRequired(value) {
        this._extraConfigRebootRequired = value;
    }
    resetExtraConfigRebootRequired() {
        this._extraConfigRebootRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigRebootRequiredInput() {
        return this._extraConfigRebootRequired;
    }
    get firmware() {
        return this.getStringAttribute('firmware');
    }
    set firmware(value) {
        this._firmware = value;
    }
    resetFirmware() {
        this._firmware = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firmwareInput() {
        return this._firmware;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get guestId() {
        return this.getStringAttribute('guest_id');
    }
    set guestId(value) {
        this._guestId = value;
    }
    resetGuestId() {
        this._guestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get guestIdInput() {
        return this._guestId;
    }
    // guest_ip_addresses - computed: true, optional: false, required: false
    get guestIpAddresses() {
        return this.getListAttribute('guest_ip_addresses');
    }
    get hardwareVersion() {
        return this.getNumberAttribute('hardware_version');
    }
    set hardwareVersion(value) {
        this._hardwareVersion = value;
    }
    resetHardwareVersion() {
        this._hardwareVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hardwareVersionInput() {
        return this._hardwareVersion;
    }
    get hvMode() {
        return this.getStringAttribute('hv_mode');
    }
    set hvMode(value) {
        this._hvMode = value;
    }
    resetHvMode() {
        this._hvMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hvModeInput() {
        return this._hvMode;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ideControllerScanCount() {
        return this.getNumberAttribute('ide_controller_scan_count');
    }
    set ideControllerScanCount(value) {
        this._ideControllerScanCount = value;
    }
    resetIdeControllerScanCount() {
        this._ideControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ideControllerScanCountInput() {
        return this._ideControllerScanCount;
    }
    // instance_uuid - computed: true, optional: false, required: false
    get instanceUuid() {
        return this.getStringAttribute('instance_uuid');
    }
    get latencySensitivity() {
        return this.getStringAttribute('latency_sensitivity');
    }
    set latencySensitivity(value) {
        this._latencySensitivity = value;
    }
    resetLatencySensitivity() {
        this._latencySensitivity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get latencySensitivityInput() {
        return this._latencySensitivity;
    }
    get memory() {
        return this.getNumberAttribute('memory');
    }
    set memory(value) {
        this._memory = value;
    }
    resetMemory() {
        this._memory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryInput() {
        return this._memory;
    }
    get memoryHotAddEnabled() {
        return this.getBooleanAttribute('memory_hot_add_enabled');
    }
    set memoryHotAddEnabled(value) {
        this._memoryHotAddEnabled = value;
    }
    resetMemoryHotAddEnabled() {
        this._memoryHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryHotAddEnabledInput() {
        return this._memoryHotAddEnabled;
    }
    get memoryLimit() {
        return this.getNumberAttribute('memory_limit');
    }
    set memoryLimit(value) {
        this._memoryLimit = value;
    }
    resetMemoryLimit() {
        this._memoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryLimitInput() {
        return this._memoryLimit;
    }
    get memoryReservation() {
        return this.getNumberAttribute('memory_reservation');
    }
    set memoryReservation(value) {
        this._memoryReservation = value;
    }
    resetMemoryReservation() {
        this._memoryReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationInput() {
        return this._memoryReservation;
    }
    get memoryReservationLockedToMax() {
        return this.getBooleanAttribute('memory_reservation_locked_to_max');
    }
    set memoryReservationLockedToMax(value) {
        this._memoryReservationLockedToMax = value;
    }
    resetMemoryReservationLockedToMax() {
        this._memoryReservationLockedToMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationLockedToMaxInput() {
        return this._memoryReservationLockedToMax;
    }
    get memoryShareCount() {
        return this.getNumberAttribute('memory_share_count');
    }
    set memoryShareCount(value) {
        this._memoryShareCount = value;
    }
    resetMemoryShareCount() {
        this._memoryShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareCountInput() {
        return this._memoryShareCount;
    }
    get memoryShareLevel() {
        return this.getStringAttribute('memory_share_level');
    }
    set memoryShareLevel(value) {
        this._memoryShareLevel = value;
    }
    resetMemoryShareLevel() {
        this._memoryShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareLevelInput() {
        return this._memoryShareLevel;
    }
    get moid() {
        return this.getStringAttribute('moid');
    }
    set moid(value) {
        this._moid = value;
    }
    resetMoid() {
        this._moid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get moidInput() {
        return this._moid;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nestedHvEnabled() {
        return this.getBooleanAttribute('nested_hv_enabled');
    }
    set nestedHvEnabled(value) {
        this._nestedHvEnabled = value;
    }
    resetNestedHvEnabled() {
        this._nestedHvEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nestedHvEnabledInput() {
        return this._nestedHvEnabled;
    }
    // network_interface_types - computed: true, optional: false, required: false
    get networkInterfaceTypes() {
        return this.getListAttribute('network_interface_types');
    }
    get networkInterfaces() {
        return this._networkInterfaces;
    }
    get numCoresPerSocket() {
        return this.getNumberAttribute('num_cores_per_socket');
    }
    set numCoresPerSocket(value) {
        this._numCoresPerSocket = value;
    }
    resetNumCoresPerSocket() {
        this._numCoresPerSocket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCoresPerSocketInput() {
        return this._numCoresPerSocket;
    }
    get numCpus() {
        return this.getNumberAttribute('num_cpus');
    }
    set numCpus(value) {
        this._numCpus = value;
    }
    resetNumCpus() {
        this._numCpus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCpusInput() {
        return this._numCpus;
    }
    get nvmeControllerScanCount() {
        return this.getNumberAttribute('nvme_controller_scan_count');
    }
    set nvmeControllerScanCount(value) {
        this._nvmeControllerScanCount = value;
    }
    resetNvmeControllerScanCount() {
        this._nvmeControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nvmeControllerScanCountInput() {
        return this._nvmeControllerScanCount;
    }
    get replaceTrigger() {
        return this.getStringAttribute('replace_trigger');
    }
    set replaceTrigger(value) {
        this._replaceTrigger = value;
    }
    resetReplaceTrigger() {
        this._replaceTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceTriggerInput() {
        return this._replaceTrigger;
    }
    get runToolsScriptsAfterPowerOn() {
        return this.getBooleanAttribute('run_tools_scripts_after_power_on');
    }
    set runToolsScriptsAfterPowerOn(value) {
        this._runToolsScriptsAfterPowerOn = value;
    }
    resetRunToolsScriptsAfterPowerOn() {
        this._runToolsScriptsAfterPowerOn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterPowerOnInput() {
        return this._runToolsScriptsAfterPowerOn;
    }
    get runToolsScriptsAfterResume() {
        return this.getBooleanAttribute('run_tools_scripts_after_resume');
    }
    set runToolsScriptsAfterResume(value) {
        this._runToolsScriptsAfterResume = value;
    }
    resetRunToolsScriptsAfterResume() {
        this._runToolsScriptsAfterResume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterResumeInput() {
        return this._runToolsScriptsAfterResume;
    }
    get runToolsScriptsBeforeGuestReboot() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_reboot');
    }
    set runToolsScriptsBeforeGuestReboot(value) {
        this._runToolsScriptsBeforeGuestReboot = value;
    }
    resetRunToolsScriptsBeforeGuestReboot() {
        this._runToolsScriptsBeforeGuestReboot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestRebootInput() {
        return this._runToolsScriptsBeforeGuestReboot;
    }
    get runToolsScriptsBeforeGuestShutdown() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_shutdown');
    }
    set runToolsScriptsBeforeGuestShutdown(value) {
        this._runToolsScriptsBeforeGuestShutdown = value;
    }
    resetRunToolsScriptsBeforeGuestShutdown() {
        this._runToolsScriptsBeforeGuestShutdown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestShutdownInput() {
        return this._runToolsScriptsBeforeGuestShutdown;
    }
    get runToolsScriptsBeforeGuestStandby() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_standby');
    }
    set runToolsScriptsBeforeGuestStandby(value) {
        this._runToolsScriptsBeforeGuestStandby = value;
    }
    resetRunToolsScriptsBeforeGuestStandby() {
        this._runToolsScriptsBeforeGuestStandby = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestStandbyInput() {
        return this._runToolsScriptsBeforeGuestStandby;
    }
    get sataControllerScanCount() {
        return this.getNumberAttribute('sata_controller_scan_count');
    }
    set sataControllerScanCount(value) {
        this._sataControllerScanCount = value;
    }
    resetSataControllerScanCount() {
        this._sataControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sataControllerScanCountInput() {
        return this._sataControllerScanCount;
    }
    // scsi_bus_sharing - computed: true, optional: false, required: false
    get scsiBusSharing() {
        return this.getStringAttribute('scsi_bus_sharing');
    }
    get scsiControllerScanCount() {
        return this.getNumberAttribute('scsi_controller_scan_count');
    }
    set scsiControllerScanCount(value) {
        this._scsiControllerScanCount = value;
    }
    resetScsiControllerScanCount() {
        this._scsiControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scsiControllerScanCountInput() {
        return this._scsiControllerScanCount;
    }
    // scsi_type - computed: true, optional: false, required: false
    get scsiType() {
        return this.getStringAttribute('scsi_type');
    }
    get storagePolicyId() {
        return this.getStringAttribute('storage_policy_id');
    }
    set storagePolicyId(value) {
        this._storagePolicyId = value;
    }
    resetStoragePolicyId() {
        this._storagePolicyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storagePolicyIdInput() {
        return this._storagePolicyId;
    }
    get swapPlacementPolicy() {
        return this.getStringAttribute('swap_placement_policy');
    }
    set swapPlacementPolicy(value) {
        this._swapPlacementPolicy = value;
    }
    resetSwapPlacementPolicy() {
        this._swapPlacementPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapPlacementPolicyInput() {
        return this._swapPlacementPolicy;
    }
    get syncTimeWithHost() {
        return this.getBooleanAttribute('sync_time_with_host');
    }
    set syncTimeWithHost(value) {
        this._syncTimeWithHost = value;
    }
    resetSyncTimeWithHost() {
        this._syncTimeWithHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostInput() {
        return this._syncTimeWithHost;
    }
    get syncTimeWithHostPeriodically() {
        return this.getBooleanAttribute('sync_time_with_host_periodically');
    }
    set syncTimeWithHostPeriodically(value) {
        this._syncTimeWithHostPeriodically = value;
    }
    resetSyncTimeWithHostPeriodically() {
        this._syncTimeWithHostPeriodically = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostPeriodicallyInput() {
        return this._syncTimeWithHostPeriodically;
    }
    get toolsUpgradePolicy() {
        return this.getStringAttribute('tools_upgrade_policy');
    }
    set toolsUpgradePolicy(value) {
        this._toolsUpgradePolicy = value;
    }
    resetToolsUpgradePolicy() {
        this._toolsUpgradePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get toolsUpgradePolicyInput() {
        return this._toolsUpgradePolicy;
    }
    get uuid() {
        return this.getStringAttribute('uuid');
    }
    set uuid(value) {
        this._uuid = value;
    }
    resetUuid() {
        this._uuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uuidInput() {
        return this._uuid;
    }
    // vapp_transport - computed: true, optional: false, required: false
    get vappTransport() {
        return this.getListAttribute('vapp_transport');
    }
    get vbsEnabled() {
        return this.getBooleanAttribute('vbs_enabled');
    }
    set vbsEnabled(value) {
        this._vbsEnabled = value;
    }
    resetVbsEnabled() {
        this._vbsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vbsEnabledInput() {
        return this._vbsEnabled;
    }
    // vtpm - computed: true, optional: false, required: false
    get vtpm() {
        return this.getBooleanAttribute('vtpm');
    }
    get vvtdEnabled() {
        return this.getBooleanAttribute('vvtd_enabled');
    }
    set vvtdEnabled(value) {
        this._vvtdEnabled = value;
    }
    resetVvtdEnabled() {
        this._vvtdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vvtdEnabledInput() {
        return this._vvtdEnabled;
    }
    get vapp() {
        return this._vapp;
    }
    putVapp(value) {
        this._vapp.internalValue = value;
    }
    resetVapp() {
        this._vapp.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vappInput() {
        return this._vapp.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alternate_guest_name: cdktf.stringToTerraform(this._alternateGuestName),
            annotation: cdktf.stringToTerraform(this._annotation),
            boot_delay: cdktf.numberToTerraform(this._bootDelay),
            boot_retry_delay: cdktf.numberToTerraform(this._bootRetryDelay),
            boot_retry_enabled: cdktf.booleanToTerraform(this._bootRetryEnabled),
            cpu_hot_add_enabled: cdktf.booleanToTerraform(this._cpuHotAddEnabled),
            cpu_hot_remove_enabled: cdktf.booleanToTerraform(this._cpuHotRemoveEnabled),
            cpu_limit: cdktf.numberToTerraform(this._cpuLimit),
            cpu_performance_counters_enabled: cdktf.booleanToTerraform(this._cpuPerformanceCountersEnabled),
            cpu_reservation: cdktf.numberToTerraform(this._cpuReservation),
            cpu_share_count: cdktf.numberToTerraform(this._cpuShareCount),
            cpu_share_level: cdktf.stringToTerraform(this._cpuShareLevel),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            efi_secure_boot_enabled: cdktf.booleanToTerraform(this._efiSecureBootEnabled),
            enable_disk_uuid: cdktf.booleanToTerraform(this._enableDiskUuid),
            enable_logging: cdktf.booleanToTerraform(this._enableLogging),
            ept_rvi_mode: cdktf.stringToTerraform(this._eptRviMode),
            extra_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._extraConfig),
            extra_config_reboot_required: cdktf.booleanToTerraform(this._extraConfigRebootRequired),
            firmware: cdktf.stringToTerraform(this._firmware),
            folder: cdktf.stringToTerraform(this._folder),
            guest_id: cdktf.stringToTerraform(this._guestId),
            hardware_version: cdktf.numberToTerraform(this._hardwareVersion),
            hv_mode: cdktf.stringToTerraform(this._hvMode),
            id: cdktf.stringToTerraform(this._id),
            ide_controller_scan_count: cdktf.numberToTerraform(this._ideControllerScanCount),
            latency_sensitivity: cdktf.stringToTerraform(this._latencySensitivity),
            memory: cdktf.numberToTerraform(this._memory),
            memory_hot_add_enabled: cdktf.booleanToTerraform(this._memoryHotAddEnabled),
            memory_limit: cdktf.numberToTerraform(this._memoryLimit),
            memory_reservation: cdktf.numberToTerraform(this._memoryReservation),
            memory_reservation_locked_to_max: cdktf.booleanToTerraform(this._memoryReservationLockedToMax),
            memory_share_count: cdktf.numberToTerraform(this._memoryShareCount),
            memory_share_level: cdktf.stringToTerraform(this._memoryShareLevel),
            moid: cdktf.stringToTerraform(this._moid),
            name: cdktf.stringToTerraform(this._name),
            nested_hv_enabled: cdktf.booleanToTerraform(this._nestedHvEnabled),
            num_cores_per_socket: cdktf.numberToTerraform(this._numCoresPerSocket),
            num_cpus: cdktf.numberToTerraform(this._numCpus),
            nvme_controller_scan_count: cdktf.numberToTerraform(this._nvmeControllerScanCount),
            replace_trigger: cdktf.stringToTerraform(this._replaceTrigger),
            run_tools_scripts_after_power_on: cdktf.booleanToTerraform(this._runToolsScriptsAfterPowerOn),
            run_tools_scripts_after_resume: cdktf.booleanToTerraform(this._runToolsScriptsAfterResume),
            run_tools_scripts_before_guest_reboot: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestReboot),
            run_tools_scripts_before_guest_shutdown: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestShutdown),
            run_tools_scripts_before_guest_standby: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestStandby),
            sata_controller_scan_count: cdktf.numberToTerraform(this._sataControllerScanCount),
            scsi_controller_scan_count: cdktf.numberToTerraform(this._scsiControllerScanCount),
            storage_policy_id: cdktf.stringToTerraform(this._storagePolicyId),
            swap_placement_policy: cdktf.stringToTerraform(this._swapPlacementPolicy),
            sync_time_with_host: cdktf.booleanToTerraform(this._syncTimeWithHost),
            sync_time_with_host_periodically: cdktf.booleanToTerraform(this._syncTimeWithHostPeriodically),
            tools_upgrade_policy: cdktf.stringToTerraform(this._toolsUpgradePolicy),
            uuid: cdktf.stringToTerraform(this._uuid),
            vbs_enabled: cdktf.booleanToTerraform(this._vbsEnabled),
            vvtd_enabled: cdktf.booleanToTerraform(this._vvtdEnabled),
            vapp: dataVsphereVirtualMachineVappToTerraform(this._vapp.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            alternate_guest_name: {
                value: cdktf.stringToHclTerraform(this._alternateGuestName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            annotation: {
                value: cdktf.stringToHclTerraform(this._annotation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            boot_delay: {
                value: cdktf.numberToHclTerraform(this._bootDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            boot_retry_delay: {
                value: cdktf.numberToHclTerraform(this._bootRetryDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            boot_retry_enabled: {
                value: cdktf.booleanToHclTerraform(this._bootRetryEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_hot_add_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuHotAddEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_hot_remove_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuHotRemoveEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_limit: {
                value: cdktf.numberToHclTerraform(this._cpuLimit),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_performance_counters_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuPerformanceCountersEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_reservation: {
                value: cdktf.numberToHclTerraform(this._cpuReservation),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_share_count: {
                value: cdktf.numberToHclTerraform(this._cpuShareCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_share_level: {
                value: cdktf.stringToHclTerraform(this._cpuShareLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            efi_secure_boot_enabled: {
                value: cdktf.booleanToHclTerraform(this._efiSecureBootEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_disk_uuid: {
                value: cdktf.booleanToHclTerraform(this._enableDiskUuid),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_logging: {
                value: cdktf.booleanToHclTerraform(this._enableLogging),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ept_rvi_mode: {
                value: cdktf.stringToHclTerraform(this._eptRviMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            extra_config: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._extraConfig),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            extra_config_reboot_required: {
                value: cdktf.booleanToHclTerraform(this._extraConfigRebootRequired),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            firmware: {
                value: cdktf.stringToHclTerraform(this._firmware),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            guest_id: {
                value: cdktf.stringToHclTerraform(this._guestId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            hardware_version: {
                value: cdktf.numberToHclTerraform(this._hardwareVersion),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            hv_mode: {
                value: cdktf.stringToHclTerraform(this._hvMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ide_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._ideControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            latency_sensitivity: {
                value: cdktf.stringToHclTerraform(this._latencySensitivity),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            memory: {
                value: cdktf.numberToHclTerraform(this._memory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_hot_add_enabled: {
                value: cdktf.booleanToHclTerraform(this._memoryHotAddEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            memory_limit: {
                value: cdktf.numberToHclTerraform(this._memoryLimit),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_reservation: {
                value: cdktf.numberToHclTerraform(this._memoryReservation),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_reservation_locked_to_max: {
                value: cdktf.booleanToHclTerraform(this._memoryReservationLockedToMax),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            memory_share_count: {
                value: cdktf.numberToHclTerraform(this._memoryShareCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_share_level: {
                value: cdktf.stringToHclTerraform(this._memoryShareLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            moid: {
                value: cdktf.stringToHclTerraform(this._moid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            nested_hv_enabled: {
                value: cdktf.booleanToHclTerraform(this._nestedHvEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            num_cores_per_socket: {
                value: cdktf.numberToHclTerraform(this._numCoresPerSocket),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            num_cpus: {
                value: cdktf.numberToHclTerraform(this._numCpus),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            nvme_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._nvmeControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            replace_trigger: {
                value: cdktf.stringToHclTerraform(this._replaceTrigger),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            run_tools_scripts_after_power_on: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsAfterPowerOn),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_after_resume: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsAfterResume),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_reboot: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestReboot),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_shutdown: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestShutdown),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_standby: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestStandby),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sata_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._sataControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            scsi_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._scsiControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            storage_policy_id: {
                value: cdktf.stringToHclTerraform(this._storagePolicyId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            swap_placement_policy: {
                value: cdktf.stringToHclTerraform(this._swapPlacementPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sync_time_with_host: {
                value: cdktf.booleanToHclTerraform(this._syncTimeWithHost),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sync_time_with_host_periodically: {
                value: cdktf.booleanToHclTerraform(this._syncTimeWithHostPeriodically),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tools_upgrade_policy: {
                value: cdktf.stringToHclTerraform(this._toolsUpgradePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            uuid: {
                value: cdktf.stringToHclTerraform(this._uuid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            vbs_enabled: {
                value: cdktf.booleanToHclTerraform(this._vbsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vvtd_enabled: {
                value: cdktf.booleanToHclTerraform(this._vvtdEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vapp: {
                value: dataVsphereVirtualMachineVappToHclTerraform(this._vapp.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "DataVsphereVirtualMachineVappList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DataVsphereVirtualMachine = DataVsphereVirtualMachine;
_f = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachine[_f] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachine", version: "11.1.1" };
// =================
// STATIC PROPERTIES
// =================
DataVsphereVirtualMachine.tfResourceType = "vsphere_virtual_machine";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZGF0YS12c3BoZXJlLXZpcnR1YWwtbWFjaGluZS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBeVdBLDhGQU9DO0FBR0Qsb0dBUUM7QUE2RUQsc0hBT0M7QUFHRCw0SEFRQztBQWtHRCw0RkFRQztBQUdELGtHQWdCQzs7QUE5a0JELCtCQUErQjtBQWdXL0IsU0FBZ0IseUNBQXlDLENBQUMsTUFBdUM7SUFDL0YsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUFDLE9BQU8sTUFBTSxDQUFDO0lBQUMsQ0FBQztJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ25DLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztJQUN4SSxDQUFDO0lBQ0QsT0FBTyxFQUNOLENBQUE7QUFDSCxDQUFDO0FBR0QsU0FBZ0IsNENBQTRDLENBQUMsTUFBdUM7SUFDbEcsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUFDLE9BQU8sTUFBTSxDQUFDO0lBQUMsQ0FBQztJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ25DLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztJQUN4SSxDQUFDO0lBQ0QsTUFBTSxLQUFLLEdBQUcsRUFDYixDQUFDO0lBQ0YsT0FBTyxLQUFLLENBQUM7QUFDZixDQUFDO0FBRUQsTUFBYSw2Q0FBOEMsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUdwRjs7Ozs7TUFLRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQixFQUFFLGtCQUEwQixFQUFFLHNCQUErQjtRQUN2SixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsc0JBQXNCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQVRuRixrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVU5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQWlEO1FBQ3hFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1FBQzdCLENBQUM7YUFDSSxDQUFDO1lBQ0osSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7UUFDdkQsQ0FBQztJQUNILENBQUM7SUFFRCxtRUFBbUU7SUFDbkUsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsc0VBQXNFO0lBQ3RFLElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRCxpRUFBaUU7SUFDakUsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7O0FBbkRILHNHQW9EQzs7O0FBRUQsTUFBYSxrQ0FBbUMsU0FBUSxLQUFLLENBQUMsV0FBVztJQUV2RTs7OztNQUlFO0lBQ0YsWUFBc0IsaUJBQTZDLEVBQVksa0JBQTBCLEVBQVksUUFBaUI7UUFDcEksS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFBO1FBRGxDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBNEI7UUFBWSx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFBWSxhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRXRJLENBQUM7SUFFRDs7TUFFRTtJQUNLLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sSUFBSSw2Q0FBNkMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDbEksQ0FBQzs7QUFoQkgsZ0ZBaUJDOzs7QUFJRCxTQUFnQixxREFBcUQsQ0FBQyxNQUFtRDtJQUN2SCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQUMsT0FBTyxNQUFNLENBQUM7SUFBQyxDQUFDO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDbkMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0lBQ3hJLENBQUM7SUFDRCxPQUFPLEVBQ04sQ0FBQTtBQUNILENBQUM7QUFHRCxTQUFnQix3REFBd0QsQ0FBQyxNQUFtRDtJQUMxSCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQUMsT0FBTyxNQUFNLENBQUM7SUFBQyxDQUFDO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDbkMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0lBQ3hJLENBQUM7SUFDRCxNQUFNLEtBQUssR0FBRyxFQUNiLENBQUM7SUFDRixPQUFPLEtBQUssQ0FBQztBQUNmLENBQUM7QUFFRCxNQUFhLHlEQUEwRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR2hHOzs7OztNQUtFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCLEVBQUUsa0JBQTBCLEVBQUUsc0JBQStCO1FBQ3ZKLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxzQkFBc0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBVG5GLGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBVTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBNkQ7UUFDcEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7UUFDN0IsQ0FBQzthQUNJLENBQUM7WUFDSixJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztRQUN2RCxDQUFDO0lBQ0gsQ0FBQztJQUVELGtFQUFrRTtJQUNsRSxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVELHFFQUFxRTtJQUNyRSxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQsMkVBQTJFO0lBQzNFLElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUVELDJFQUEyRTtJQUMzRSxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRCwyRUFBMkU7SUFDM0UsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBRUQsaUVBQWlFO0lBQ2pFLElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQsZ0VBQWdFO0lBQ2hFLElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQsdUVBQXVFO0lBQ3ZFLElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQzs7QUFsRUgsOEhBbUVDOzs7QUFFRCxNQUFhLDhDQUErQyxTQUFRLEtBQUssQ0FBQyxXQUFXO0lBRW5GOzs7O01BSUU7SUFDRixZQUFzQixpQkFBNkMsRUFBWSxrQkFBMEIsRUFBWSxRQUFpQjtRQUNwSSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQUE7UUFEbEMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE0QjtRQUFZLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUFZLGFBQVEsR0FBUixRQUFRLENBQVM7SUFFdEksQ0FBQztJQUVEOztNQUVFO0lBQ0ssR0FBRyxDQUFDLEtBQWE7UUFDdEIsT0FBTyxJQUFJLHlEQUF5RCxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUM5SSxDQUFDOztBQWhCSCx3R0FpQkM7OztBQVVELFNBQWdCLHdDQUF3QyxDQUFDLE1BQXFGO0lBQzVJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFBQyxPQUFPLE1BQU0sQ0FBQztJQUFDLENBQUM7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7SUFDeEksQ0FBQztJQUNELE9BQU87UUFDTCxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxNQUFPLENBQUMsVUFBVSxDQUFDO0tBQzFFLENBQUE7QUFDSCxDQUFDO0FBR0QsU0FBZ0IsMkNBQTJDLENBQUMsTUFBcUY7SUFDL0ksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUFDLE9BQU8sTUFBTSxDQUFDO0lBQUMsQ0FBQztJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ25DLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztJQUN4SSxDQUFDO0lBQ0QsTUFBTSxLQUFLLEdBQUc7UUFDWixVQUFVLEVBQUU7WUFDVixLQUFLLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxNQUFPLENBQUMsVUFBVSxDQUFDO1lBQzFFLE9BQU8sRUFBRSxLQUFLO1lBQ2QsSUFBSSxFQUFFLEtBQUs7WUFDWCxnQkFBZ0IsRUFBRSxXQUFXO1NBQzlCO0tBQ0YsQ0FBQztJQUVGLDhCQUE4QjtJQUM5QixPQUFPLE1BQU0sQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsRUFBRSxFQUFFLENBQUMsS0FBSyxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsS0FBSyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUM7QUFDNUgsQ0FBQztBQUVELE1BQWEsNENBQTZDLFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHbkY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3BELENBQUM7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBZ0Q7UUFDdkUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7UUFDL0IsQ0FBQzthQUNJLENBQUM7WUFDSixJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDdEMsQ0FBQztJQUNILENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWdDO1FBQ3BELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDOztBQTlDSCxvR0ErQ0M7OztBQUVEOztFQUVFO0FBQ0YsTUFBYSx5QkFBMEIsU0FBUSxLQUFLLENBQUMsbUJBQW1CO0lBT3RFLGlCQUFpQjtJQUNqQixpQkFBaUI7SUFDakIsaUJBQWlCO0lBQ2pCOzs7Ozs7TUFNRTtJQUNLLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxLQUFnQixFQUFFLFVBQWtCLEVBQUUsWUFBb0IsRUFBRSxRQUFrQztRQUM5SCxPQUFPLElBQUksS0FBSyxDQUFDLGtCQUFrQixDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsRUFBRSxxQkFBcUIsRUFBRSx5QkFBeUIsRUFBRSxRQUFRLEVBQUUsWUFBWSxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQUM7SUFDakosQ0FBQztJQUVMLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFNBQTBDLEVBQUU7UUFDM0YsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSx5QkFBeUI7WUFDaEQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxTQUFTO2dCQUN2QixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsU0FBUzthQUNyQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUEwUkwsMkRBQTJEO1FBQ25ELFdBQU0sR0FBRyxJQUFJLGtDQUFrQyxDQUFDLElBQUksRUFBRSxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFvWjlFLHdFQUF3RTtRQUNoRSx1QkFBa0IsR0FBRyxJQUFJLDhDQUE4QyxDQUFDLElBQUksRUFBRSxvQkFBb0IsRUFBRSxLQUFLLENBQUMsQ0FBQztRQXlVbkgsMERBQTBEO1FBQ2xELFVBQUssR0FBRyxJQUFJLDRDQUE0QyxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQztRQXovQjdFLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxNQUFNLENBQUMsNkJBQTZCLENBQUM7UUFDM0UsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsdUJBQXVCLEdBQUcsTUFBTSxDQUFDLHNCQUFzQixDQUFDO1FBQzdELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQztRQUN6RSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsd0JBQXdCLEdBQUcsTUFBTSxDQUFDLHVCQUF1QixDQUFDO1FBQy9ELElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBQ3ZFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxNQUFNLENBQUMsMEJBQTBCLENBQUM7UUFDckUsSUFBSSxDQUFDLGlDQUFpQyxHQUFHLE1BQU0sQ0FBQyxnQ0FBZ0MsQ0FBQztRQUNqRixJQUFJLENBQUMsbUNBQW1DLEdBQUcsTUFBTSxDQUFDLGtDQUFrQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxrQ0FBa0MsR0FBRyxNQUFNLENBQUMsaUNBQWlDLENBQUM7UUFDbkYsSUFBSSxDQUFDLHdCQUF3QixHQUFHLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQztRQUMvRCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsTUFBTSxDQUFDLHVCQUF1QixDQUFDO1FBQy9ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsTUFBTSxDQUFDLDRCQUE0QixDQUFDO1FBQ3pFLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztJQUN6QyxDQUFDO0lBUUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNNLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBa0M7UUFDNUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBRUQsb0VBQW9FO0lBQ3BFLElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQWtDO1FBQzVELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsU0FBUyxDQUFDO0lBQ3JDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBa0M7UUFDL0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyw2QkFBNkI7UUFDdEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBQ0QsSUFBVyw2QkFBNkIsQ0FBQyxLQUFrQztRQUN6RSxJQUFJLENBQUMsOEJBQThCLEdBQUcsS0FBSyxDQUFDO0lBQzlDLENBQUM7SUFDTSxrQ0FBa0M7UUFDdkMsSUFBSSxDQUFDLDhCQUE4QixHQUFHLFNBQVMsQ0FBQztJQUNsRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0NBQWtDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLDhCQUE4QixDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBYTtRQUNyQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBQ00sbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO0lBQ25DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQWE7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNNLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNqQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBRUQsd0VBQXdFO0lBQ3hFLElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUlELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFrQztRQUNoRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBa0M7UUFDMUQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWtDO1FBQ3pELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBZ0M7UUFDckQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNsRSxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUFrQztRQUNyRSxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUVELHdFQUF3RTtJQUN4RSxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsRUFBRTtRQUNYLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLEVBQUUsQ0FBQyxLQUFhO1FBQ3pCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFDTSxPQUFPO1FBQ1osSUFBSSxDQUFDLEdBQUcsR0FBRyxTQUFTLENBQUM7SUFDdkIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFJRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlELENBQUM7SUFDRCxJQUFXLHNCQUFzQixDQUFDLEtBQWE7UUFDN0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sMkJBQTJCO1FBQ2hDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztJQUN0QyxDQUFDO0lBRUQsbUVBQW1FO0lBQ25FLElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBSUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNNLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFrQztRQUMvRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFDTSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDdEUsQ0FBQztJQUNELElBQVcsNEJBQTRCLENBQUMsS0FBa0M7UUFDeEUsSUFBSSxDQUFDLDZCQUE2QixHQUFHLEtBQUssQ0FBQztJQUM3QyxDQUFDO0lBQ00saUNBQWlDO1FBQ3RDLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxTQUFTLENBQUM7SUFDakQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlDQUFpQztRQUMxQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFhO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsU0FBUyxDQUFDO0lBQ3JDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxJQUFXLGVBQWUsQ0FBQyxLQUFrQztRQUMzRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFFRCw2RUFBNkU7SUFDN0UsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFDRCxJQUFXLHVCQUF1QixDQUFDLEtBQWE7UUFDOUMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ00sNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFrQztRQUN2RSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxnQ0FBZ0M7UUFDckMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFNBQVMsQ0FBQztJQUNoRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFDRCxJQUFXLDBCQUEwQixDQUFDLEtBQWtDO1FBQ3RFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNNLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsMkJBQTJCLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHVDQUF1QyxDQUFDLENBQUM7SUFDM0UsQ0FBQztJQUNELElBQVcsZ0NBQWdDLENBQUMsS0FBa0M7UUFDNUUsSUFBSSxDQUFDLGlDQUFpQyxHQUFHLEtBQUssQ0FBQztJQUNqRCxDQUFDO0lBQ00scUNBQXFDO1FBQzFDLElBQUksQ0FBQyxpQ0FBaUMsR0FBRyxTQUFTLENBQUM7SUFDckQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFDQUFxQztRQUM5QyxPQUFPLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQztJQUNoRCxDQUFDO0lBSUQsSUFBVyxrQ0FBa0M7UUFDM0MsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMseUNBQXlDLENBQUMsQ0FBQztJQUM3RSxDQUFDO0lBQ0QsSUFBVyxrQ0FBa0MsQ0FBQyxLQUFrQztRQUM5RSxJQUFJLENBQUMsbUNBQW1DLEdBQUcsS0FBSyxDQUFDO0lBQ25ELENBQUM7SUFDTSx1Q0FBdUM7UUFDNUMsSUFBSSxDQUFDLG1DQUFtQyxHQUFHLFNBQVMsQ0FBQztJQUN2RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUNBQXVDO1FBQ2hELE9BQU8sSUFBSSxDQUFDLG1DQUFtQyxDQUFDO0lBQ2xELENBQUM7SUFJRCxJQUFXLGlDQUFpQztRQUMxQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO0lBQzVFLENBQUM7SUFDRCxJQUFXLGlDQUFpQyxDQUFDLEtBQWtDO1FBQzdFLElBQUksQ0FBQyxrQ0FBa0MsR0FBRyxLQUFLLENBQUM7SUFDbEQsQ0FBQztJQUNNLHNDQUFzQztRQUMzQyxJQUFJLENBQUMsa0NBQWtDLEdBQUcsU0FBUyxDQUFDO0lBQ3RELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQ0FBc0M7UUFDL0MsT0FBTyxJQUFJLENBQUMsa0NBQWtDLENBQUM7SUFDakQsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0QsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBYTtRQUM5QyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFFRCxzRUFBc0U7SUFDdEUsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0QsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBYTtRQUM5QyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFFRCwrREFBK0Q7SUFDL0QsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFrQztRQUM1RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3RFLENBQUM7SUFDRCxJQUFXLDRCQUE0QixDQUFDLEtBQWtDO1FBQ3hFLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUNNLGlDQUFpQztRQUN0QyxJQUFJLENBQUMsNkJBQTZCLEdBQUcsU0FBUyxDQUFDO0lBQ2pELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQ0FBaUM7UUFDMUMsT0FBTyxJQUFJLENBQUMsNkJBQTZCLENBQUM7SUFDNUMsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsb0VBQW9FO0lBQ3BFLElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWtDO1FBQ3RELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBRUQsMERBQTBEO0lBQzFELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWtDO1FBQ3ZELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ00sT0FBTyxDQUFDLEtBQW9DO1FBQ2pELElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO0lBQ2xDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFRixvQkFBb0I7UUFDNUIsT0FBTztZQUNMLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7WUFDdkUsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3JELFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUNwRCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUMvRCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ3BFLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7WUFDckUsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztZQUMzRSxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDbEQsZ0NBQWdDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyw4QkFBOEIsQ0FBQztZQUMvRixlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDOUQsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQzdELGVBQWUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQztZQUM3RCxhQUFhLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDMUQsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztZQUM3RSxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUNoRSxjQUFjLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDN0QsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3ZELFlBQVksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDMUUsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQztZQUN2RixRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDakQsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQzdDLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoRCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1lBQ2hFLE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztZQUM5QyxFQUFFLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDckMseUJBQXlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztZQUNoRixtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3RFLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztZQUM3QyxzQkFBc0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1lBQzNFLFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN4RCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1lBQ3BFLGdDQUFnQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUM7WUFDOUYsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztZQUNuRSxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ25FLElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN6QyxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNsRSxvQkFBb0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1lBQ3RFLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoRCwwQkFBMEIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1lBQ2xGLGVBQWUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUM5RCxnQ0FBZ0MsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLDRCQUE0QixDQUFDO1lBQzdGLDhCQUE4QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsMkJBQTJCLENBQUM7WUFDMUYscUNBQXFDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQztZQUN2Ryx1Q0FBdUMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLG1DQUFtQyxDQUFDO1lBQzNHLHNDQUFzQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsa0NBQWtDLENBQUM7WUFDekcsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztZQUNsRiwwQkFBMEIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1lBQ2xGLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDakUscUJBQXFCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztZQUN6RSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ3JFLGdDQUFnQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUM7WUFDOUYsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztZQUN2RSxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsV0FBVyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3ZELFlBQVksRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN6RCxJQUFJLEVBQUUsd0NBQXdDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUM7U0FDekUsQ0FBQztJQUNKLENBQUM7SUFFUyx1QkFBdUI7UUFDL0IsTUFBTSxLQUFLLEdBQUc7WUFDWixvQkFBb0IsRUFBRTtnQkFDcEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQzNELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxVQUFVLEVBQUU7Z0JBQ1YsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2dCQUNuRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsVUFBVSxFQUFFO2dCQUNWLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztnQkFDbEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGdCQUFnQixFQUFFO2dCQUNoQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7Z0JBQ3ZELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7Z0JBQzFELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7Z0JBQzFELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxzQkFBc0IsRUFBRTtnQkFDdEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7Z0JBQzdELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxTQUFTLEVBQUU7Z0JBQ1QsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNqRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsZ0NBQWdDLEVBQUU7Z0JBQ2hDLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLDhCQUE4QixDQUFDO2dCQUN2RSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsZUFBZSxFQUFFO2dCQUNmLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztnQkFDdkQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGVBQWUsRUFBRTtnQkFDZixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7Z0JBQ3RELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO2dCQUN0RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsYUFBYSxFQUFFO2dCQUNiLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztnQkFDckQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELHVCQUF1QixFQUFFO2dCQUN2QixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztnQkFDOUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELGdCQUFnQixFQUFFO2dCQUNoQixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7Z0JBQ3hELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxjQUFjLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO2dCQUN2RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsWUFBWSxFQUFFO2dCQUNaLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztnQkFDbkQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO2dCQUN6RSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsS0FBSztnQkFDWCxnQkFBZ0IsRUFBRSxXQUFXO2FBQzlCO1lBQ0QsNEJBQTRCLEVBQUU7Z0JBQzVCLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDO2dCQUNuRSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztnQkFDakQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELE1BQU0sRUFBRTtnQkFDTixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7Z0JBQy9DLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO2dCQUNoRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsZ0JBQWdCLEVBQUU7Z0JBQ2hCLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO2dCQUN4RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsT0FBTyxFQUFFO2dCQUNQLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztnQkFDL0MsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELEVBQUUsRUFBRTtnQkFDRixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7Z0JBQzNDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCx5QkFBeUIsRUFBRTtnQkFDekIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsdUJBQXVCLENBQUM7Z0JBQy9ELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQzNELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxNQUFNLEVBQUU7Z0JBQ04sS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO2dCQUMvQyxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0Qsc0JBQXNCLEVBQUU7Z0JBQ3RCLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO2dCQUM3RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0QsWUFBWSxFQUFFO2dCQUNaLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztnQkFDcEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztnQkFDMUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGdDQUFnQyxFQUFFO2dCQUNoQyxLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztnQkFDdEUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztnQkFDekQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztnQkFDekQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELElBQUksRUFBRTtnQkFDSixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7Z0JBQzdDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO2dCQUM3QyxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsaUJBQWlCLEVBQUU7Z0JBQ2pCLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO2dCQUN6RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxTQUFTO2FBQzVCO1lBQ0Qsb0JBQW9CLEVBQUU7Z0JBQ3BCLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO2dCQUMxRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztnQkFDaEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELDBCQUEwQixFQUFFO2dCQUMxQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztnQkFDaEUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGVBQWUsRUFBRTtnQkFDZixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7Z0JBQ3ZELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxnQ0FBZ0MsRUFBRTtnQkFDaEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUM7Z0JBQ3JFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCw4QkFBOEIsRUFBRTtnQkFDOUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsMkJBQTJCLENBQUM7Z0JBQ3BFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxxQ0FBcUMsRUFBRTtnQkFDckMsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsaUNBQWlDLENBQUM7Z0JBQzFFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCx1Q0FBdUMsRUFBRTtnQkFDdkMsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsbUNBQW1DLENBQUM7Z0JBQzVFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxzQ0FBc0MsRUFBRTtnQkFDdEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsa0NBQWtDLENBQUM7Z0JBQzNFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCwwQkFBMEIsRUFBRTtnQkFDMUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUM7Z0JBQ2hFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCwwQkFBMEIsRUFBRTtnQkFDMUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUM7Z0JBQ2hFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxpQkFBaUIsRUFBRTtnQkFDakIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7Z0JBQ3hELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7Z0JBQzVELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7Z0JBQzFELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxnQ0FBZ0MsRUFBRTtnQkFDaEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUM7Z0JBQ3RFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxvQkFBb0IsRUFBRTtnQkFDcEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQzNELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO2dCQUM3QyxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLEtBQUssRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztnQkFDcEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7Z0JBQ3JELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFLDJDQUEyQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO2dCQUM1RSxPQUFPLEVBQUUsSUFBSTtnQkFDYixJQUFJLEVBQUUsTUFBTTtnQkFDWixnQkFBZ0IsRUFBRSxtQ0FBbUM7YUFDdEQ7U0FDRixDQUFDO1FBRUYsOEJBQThCO1FBQzlCLE9BQU8sTUFBTSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsQ0FBQyxLQUFLLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssU0FBUyxDQUFFLENBQUMsQ0FBQTtJQUM1SCxDQUFDOztBQXQ5Q0gsOERBdTlDQzs7O0FBcjlDQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLHdDQUFjLEdBQUcseUJBQXlCLEFBQTVCLENBQTZCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbiAqL1xuXG4vLyBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZVxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogVGhlIGd1ZXN0IG5hbWUgZm9yIHRoZSBvcGVyYXRpbmcgc3lzdGVtIHdoZW4gZ3Vlc3RfaWQgaXMgb3RoZXJHdWVzdCBvciBvdGhlckd1ZXN0NjQuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2FsdGVybmF0ZV9ndWVzdF9uYW1lIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjYWx0ZXJuYXRlX2d1ZXN0X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGFsdGVybmF0ZUd1ZXN0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogVXNlci1wcm92aWRlZCBkZXNjcmlwdGlvbiBvZiB0aGUgdmlydHVhbCBtYWNoaW5lLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNhbm5vdGF0aW9uIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjYW5ub3RhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgYW5ub3RhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG51bWJlciBvZiBtaWxsaXNlY29uZHMgdG8gd2FpdCBiZWZvcmUgc3RhcnRpbmcgdGhlIGJvb3Qgc2VxdWVuY2UuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2Jvb3RfZGVsYXkgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNib290X2RlbGF5fVxuICAqL1xuICByZWFkb25seSBib290RGVsYXk/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBudW1iZXIgb2YgbWlsbGlzZWNvbmRzIHRvIHdhaXQgYmVmb3JlIHJldHJ5aW5nIHRoZSBib290IHNlcXVlbmNlLiBUaGlzIG9ubHkgdmFsaWQgaWYgYm9vdF9yZXRyeV9lbmFibGVkIGlzIHRydWUuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2Jvb3RfcmV0cnlfZGVsYXkgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNib290X3JldHJ5X2RlbGF5fVxuICAqL1xuICByZWFkb25seSBib290UmV0cnlEZWxheT86IG51bWJlcjtcbiAgLyoqXG4gICogSWYgc2V0IHRvIHRydWUsIGEgdmlydHVhbCBtYWNoaW5lIHRoYXQgZmFpbHMgdG8gYm9vdCB3aWxsIHRyeSBhZ2FpbiBhZnRlciB0aGUgZGVsYXkgZGVmaW5lZCBpbiBib290X3JldHJ5X2RlbGF5LlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNib290X3JldHJ5X2VuYWJsZWQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNib290X3JldHJ5X2VuYWJsZWR9XG4gICovXG4gIHJlYWRvbmx5IGJvb3RSZXRyeUVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEFsbG93IENQVXMgdG8gYmUgYWRkZWQgdG8gdGhpcyB2aXJ0dWFsIG1hY2hpbmUgd2hpbGUgaXQgaXMgcnVubmluZy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjY3B1X2hvdF9hZGRfZW5hYmxlZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2NwdV9ob3RfYWRkX2VuYWJsZWR9XG4gICovXG4gIHJlYWRvbmx5IGNwdUhvdEFkZEVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEFsbG93IENQVXMgdG8gYmUgYWRkZWQgdG8gdGhpcyB2aXJ0dWFsIG1hY2hpbmUgd2hpbGUgaXQgaXMgcnVubmluZy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjY3B1X2hvdF9yZW1vdmVfZW5hYmxlZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2NwdV9ob3RfcmVtb3ZlX2VuYWJsZWR9XG4gICovXG4gIHJlYWRvbmx5IGNwdUhvdFJlbW92ZUVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBtYXhpbXVtIGFtb3VudCBvZiBtZW1vcnkgKGluIE1CKSBvciBDUFUgKGluIE1IeikgdGhhdCB0aGlzIHZpcnR1YWwgbWFjaGluZSBjYW4gY29uc3VtZSwgcmVnYXJkbGVzcyBvZiBhdmFpbGFibGUgcmVzb3VyY2VzLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNjcHVfbGltaXQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNjcHVfbGltaXR9XG4gICovXG4gIHJlYWRvbmx5IGNwdUxpbWl0PzogbnVtYmVyO1xuICAvKipcbiAgKiBFbmFibGUgQ1BVIHBlcmZvcm1hbmNlIGNvdW50ZXJzIG9uIHRoaXMgdmlydHVhbCBtYWNoaW5lLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNjcHVfcGVyZm9ybWFuY2VfY291bnRlcnNfZW5hYmxlZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2NwdV9wZXJmb3JtYW5jZV9jb3VudGVyc19lbmFibGVkfVxuICAqL1xuICByZWFkb25seSBjcHVQZXJmb3JtYW5jZUNvdW50ZXJzRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIGFtb3VudCBvZiBtZW1vcnkgKGluIE1CKSBvciBDUFUgKGluIE1IeikgdGhhdCB0aGlzIHZpcnR1YWwgbWFjaGluZSBpcyBndWFyYW50ZWVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNjcHVfcmVzZXJ2YXRpb24gRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNjcHVfcmVzZXJ2YXRpb259XG4gICovXG4gIHJlYWRvbmx5IGNwdVJlc2VydmF0aW9uPzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgYW1vdW50IG9mIHNoYXJlcyB0byBhbGxvY2F0ZSB0byBjcHUgZm9yIGEgY3VzdG9tIHNoYXJlIGxldmVsLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNjcHVfc2hhcmVfY291bnQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNjcHVfc2hhcmVfY291bnR9XG4gICovXG4gIHJlYWRvbmx5IGNwdVNoYXJlQ291bnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBhbGxvY2F0aW9uIGxldmVsIGZvciBjcHUgcmVzb3VyY2VzLiBDYW4gYmUgb25lIG9mIGhpZ2gsIGxvdywgbm9ybWFsLCBvciBjdXN0b20uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2NwdV9zaGFyZV9sZXZlbCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2NwdV9zaGFyZV9sZXZlbH1cbiAgKi9cbiAgcmVhZG9ubHkgY3B1U2hhcmVMZXZlbD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG1hbmFnZWQgb2JqZWN0IElEIG9mIHRoZSBkYXRhY2VudGVyIHRoZSB2aXJ0dWFsIG1hY2hpbmUgaXMgaW4uIFRoaXMgaXMgbm90IHJlcXVpcmVkIHdoZW4gdXNpbmcgRVNYaSBkaXJlY3RseSwgb3IgaWYgdGhlcmUgaXMgb25seSBvbmUgZGF0YWNlbnRlciBpbiB5b3VyIGluZnJhc3RydWN0dXJlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNkYXRhY2VudGVyX2lkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjZGF0YWNlbnRlcl9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgZGF0YWNlbnRlcklkPzogc3RyaW5nO1xuICAvKipcbiAgKiBXaGVuIHRoZSBib290IHR5cGUgc2V0IGluIGZpcm13YXJlIGlzIGVmaSwgdGhpcyBlbmFibGVzIEVGSSBzZWN1cmUgYm9vdC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjZWZpX3NlY3VyZV9ib290X2VuYWJsZWQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNlZmlfc2VjdXJlX2Jvb3RfZW5hYmxlZH1cbiAgKi9cbiAgcmVhZG9ubHkgZWZpU2VjdXJlQm9vdEVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEV4cG9zZSB0aGUgVVVJRHMgb2YgYXR0YWNoZWQgdmlydHVhbCBkaXNrcyB0byB0aGUgdmlydHVhbCBtYWNoaW5lLCBhbGxvd2luZyBhY2Nlc3MgdG8gdGhlbSBpbiB0aGUgZ3Vlc3QuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2VuYWJsZV9kaXNrX3V1aWQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNlbmFibGVfZGlza191dWlkfVxuICAqL1xuICByZWFkb25seSBlbmFibGVEaXNrVXVpZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRW5hYmxlIGxvZ2dpbmcgb24gdGhpcyB2aXJ0dWFsIG1hY2hpbmUuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2VuYWJsZV9sb2dnaW5nIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjZW5hYmxlX2xvZ2dpbmd9XG4gICovXG4gIHJlYWRvbmx5IGVuYWJsZUxvZ2dpbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBFUFQvUlZJIChoYXJkd2FyZSBtZW1vcnkgdmlydHVhbGl6YXRpb24pIHNldHRpbmcgZm9yIHRoaXMgdmlydHVhbCBtYWNoaW5lLiBDYW4gYmUgb25lIG9mIGF1dG9tYXRpYywgb24sIG9yIG9mZi5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjZXB0X3J2aV9tb2RlIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjZXB0X3J2aV9tb2RlfVxuICAqL1xuICByZWFkb25seSBlcHRSdmlNb2RlPzogc3RyaW5nO1xuICAvKipcbiAgKiBFeHRyYSBjb25maWd1cmF0aW9uIGRhdGEgZm9yIHRoaXMgdmlydHVhbCBtYWNoaW5lLiBDYW4gYmUgdXNlZCB0byBzdXBwbHkgYWR2YW5jZWQgcGFyYW1ldGVycyBub3Qgbm9ybWFsbHkgaW4gY29uZmlndXJhdGlvbiwgc3VjaCBhcyBpbnN0YW5jZSBtZXRhZGF0YSwgb3IgY29uZmlndXJhdGlvbiBkYXRhIGZvciBPVkYgaW1hZ2VzLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNleHRyYV9jb25maWcgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNleHRyYV9jb25maWd9XG4gICovXG4gIHJlYWRvbmx5IGV4dHJhQ29uZmlnPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgLyoqXG4gICogQWxsb3cgdGhlIHZpcnR1YWwgbWFjaGluZSB0byBiZSByZWJvb3RlZCB3aGVuIGEgY2hhbmdlIHRvIGBleHRyYV9jb25maWdgIG9jY3Vycy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjZXh0cmFfY29uZmlnX3JlYm9vdF9yZXF1aXJlZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2V4dHJhX2NvbmZpZ19yZWJvb3RfcmVxdWlyZWR9XG4gICovXG4gIHJlYWRvbmx5IGV4dHJhQ29uZmlnUmVib290UmVxdWlyZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBmaXJtd2FyZSBpbnRlcmZhY2UgdG8gdXNlIG9uIHRoZSB2aXJ0dWFsIG1hY2hpbmUuIENhbiBiZSBvbmUgb2YgYmlvcyBvciBlZmkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2Zpcm13YXJlIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjZmlybXdhcmV9XG4gICovXG4gIHJlYWRvbmx5IGZpcm13YXJlPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgbmFtZSBvZiB0aGUgZm9sZGVyIHRoZSB2aXJ0dWFsIG1hY2hpbmUgaXMgaW4uIEFsbG93cyBkaXN0aW5ndWlzaGluZyB2aXJ0dWFsIG1hY2hpbmVzIHdpdGggdGhlIHNhbWUgbmFtZSBpbiBkaWZmZXJlbnQgZm9sZGVyIHBhdGhzXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2ZvbGRlciBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2ZvbGRlcn1cbiAgKi9cbiAgcmVhZG9ubHkgZm9sZGVyPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgZ3Vlc3QgSUQgZm9yIHRoZSBvcGVyYXRpbmcgc3lzdGVtLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNndWVzdF9pZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2d1ZXN0X2lkfVxuICAqL1xuICByZWFkb25seSBndWVzdElkPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgaGFyZHdhcmUgdmVyc2lvbiBmb3IgdGhlIHZpcnR1YWwgbWFjaGluZS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjaGFyZHdhcmVfdmVyc2lvbiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI2hhcmR3YXJlX3ZlcnNpb259XG4gICovXG4gIHJlYWRvbmx5IGhhcmR3YXJlVmVyc2lvbj86IG51bWJlcjtcbiAgLyoqXG4gICogVGhlIChub24tbmVzdGVkKSBoYXJkd2FyZSB2aXJ0dWFsaXphdGlvbiBzZXR0aW5nIGZvciB0aGlzIHZpcnR1YWwgbWFjaGluZS4gQ2FuIGJlIG9uZSBvZiBodkF1dG8sIGh2T24sIG9yIGh2T2ZmLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNodl9tb2RlIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjaHZfbW9kZX1cbiAgKi9cbiAgcmVhZG9ubHkgaHZNb2RlPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2lkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBudW1iZXIgb2YgSURFIGNvbnRyb2xsZXJzIHRvIHNjYW4gZm9yIGRpc2sgc2l6ZXMgYW5kIGNvbnRyb2xsZXIgdHlwZXMgb24uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2lkZV9jb250cm9sbGVyX3NjYW5fY291bnQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNpZGVfY29udHJvbGxlcl9zY2FuX2NvdW50fVxuICAqL1xuICByZWFkb25seSBpZGVDb250cm9sbGVyU2NhbkNvdW50PzogbnVtYmVyO1xuICAvKipcbiAgKiBDb250cm9scyB0aGUgc2NoZWR1bGluZyBkZWxheSBvZiB0aGUgdmlydHVhbCBtYWNoaW5lLiBVc2UgYSBoaWdoZXIgc2Vuc2l0aXZpdHkgZm9yIGFwcGxpY2F0aW9ucyB0aGF0IHJlcXVpcmUgbG93ZXIgbGF0ZW5jeSwgc3VjaCBhcyBWT0lQLCBtZWRpYSBwbGF5ZXIgYXBwbGljYXRpb25zLCBvciBhcHBsaWNhdGlvbnMgdGhhdCByZXF1aXJlIGZyZXF1ZW50IGFjY2VzcyB0byBtb3VzZSBvciBrZXlib2FyZCBkZXZpY2VzLiBDYW4gYmUgb25lIG9mIGxvdywgbm9ybWFsLCBtZWRpdW0sIG9yIGhpZ2guXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2xhdGVuY3lfc2Vuc2l0aXZpdHkgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNsYXRlbmN5X3NlbnNpdGl2aXR5fVxuICAqL1xuICByZWFkb25seSBsYXRlbmN5U2Vuc2l0aXZpdHk/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBzaXplIG9mIHRoZSB2aXJ0dWFsIG1hY2hpbmUncyBtZW1vcnksIGluIE1CLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNtZW1vcnkgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNtZW1vcnl9XG4gICovXG4gIHJlYWRvbmx5IG1lbW9yeT86IG51bWJlcjtcbiAgLyoqXG4gICogQWxsb3cgbWVtb3J5IHRvIGJlIGFkZGVkIHRvIHRoaXMgdmlydHVhbCBtYWNoaW5lIHdoaWxlIGl0IGlzIHJ1bm5pbmcuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI21lbW9yeV9ob3RfYWRkX2VuYWJsZWQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNtZW1vcnlfaG90X2FkZF9lbmFibGVkfVxuICAqL1xuICByZWFkb25seSBtZW1vcnlIb3RBZGRFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaGUgbWF4aW11bSBhbW91bnQgb2YgbWVtb3J5IChpbiBNQikgb3IgQ1BVIChpbiBNSHopIHRoYXQgdGhpcyB2aXJ0dWFsIG1hY2hpbmUgY2FuIGNvbnN1bWUsIHJlZ2FyZGxlc3Mgb2YgYXZhaWxhYmxlIHJlc291cmNlcy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjbWVtb3J5X2xpbWl0IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjbWVtb3J5X2xpbWl0fVxuICAqL1xuICByZWFkb25seSBtZW1vcnlMaW1pdD86IG51bWJlcjtcbiAgLyoqXG4gICogVGhlIGFtb3VudCBvZiBtZW1vcnkgKGluIE1CKSBvciBDUFUgKGluIE1IeikgdGhhdCB0aGlzIHZpcnR1YWwgbWFjaGluZSBpcyBndWFyYW50ZWVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNtZW1vcnlfcmVzZXJ2YXRpb24gRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNtZW1vcnlfcmVzZXJ2YXRpb259XG4gICovXG4gIHJlYWRvbmx5IG1lbW9yeVJlc2VydmF0aW9uPzogbnVtYmVyO1xuICAvKipcbiAgKiBJZiBzZXQgdHJ1ZSwgbWVtb3J5IHJlc291cmNlIHJlc2VydmF0aW9uIGZvciB0aGlzIHZpcnR1YWwgbWFjaGluZSB3aWxsIGFsd2F5cyBiZSBlcXVhbCB0byB0aGUgdmlydHVhbCBtYWNoaW5lJ3MgbWVtb3J5IHNpemU7aW5jcmVhc2VzIGluIG1lbW9yeSBzaXplIHdpbGwgYmUgcmVqZWN0ZWQgd2hlbiBhIGNvcnJlc3BvbmRpbmcgcmVzZXJ2YXRpb24gaW5jcmVhc2UgaXMgbm90IHBvc3NpYmxlLiBUaGlzIGZlYXR1cmUgbWF5IG9ubHkgYmUgZW5hYmxlZCBpZiBpdCBpcyBjdXJyZW50bHkgcG9zc2libGUgdG8gcmVzZXJ2ZSBhbGwgb2YgdGhlIHZpcnR1YWwgbWFjaGluZSdzIG1lbW9yeS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjbWVtb3J5X3Jlc2VydmF0aW9uX2xvY2tlZF90b19tYXggRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNtZW1vcnlfcmVzZXJ2YXRpb25fbG9ja2VkX3RvX21heH1cbiAgKi9cbiAgcmVhZG9ubHkgbWVtb3J5UmVzZXJ2YXRpb25Mb2NrZWRUb01heD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIGFtb3VudCBvZiBzaGFyZXMgdG8gYWxsb2NhdGUgdG8gbWVtb3J5IGZvciBhIGN1c3RvbSBzaGFyZSBsZXZlbC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjbWVtb3J5X3NoYXJlX2NvdW50IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjbWVtb3J5X3NoYXJlX2NvdW50fVxuICAqL1xuICByZWFkb25seSBtZW1vcnlTaGFyZUNvdW50PzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgYWxsb2NhdGlvbiBsZXZlbCBmb3IgbWVtb3J5IHJlc291cmNlcy4gQ2FuIGJlIG9uZSBvZiBoaWdoLCBsb3csIG5vcm1hbCwgb3IgY3VzdG9tLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNtZW1vcnlfc2hhcmVfbGV2ZWwgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNtZW1vcnlfc2hhcmVfbGV2ZWx9XG4gICovXG4gIHJlYWRvbmx5IG1lbW9yeVNoYXJlTGV2ZWw/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBtYWNoaW5lIG9iamVjdCBJRCBmcm9tIFZNd2FyZSB2U3BoZXJlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNtb2lkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjbW9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgbW9pZD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG5hbWUgb2YgdGhpcyB2aXJ0dWFsIG1hY2hpbmUuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI25hbWUgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBFbmFibGUgbmVzdGVkIGhhcmR3YXJlIHZpcnR1YWxpemF0aW9uIG9uIHRoaXMgdmlydHVhbCBtYWNoaW5lLCBmYWNpbGl0YXRpbmcgbmVzdGVkIHZpcnR1YWxpemF0aW9uIGluIHRoZSBndWVzdC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjbmVzdGVkX2h2X2VuYWJsZWQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNuZXN0ZWRfaHZfZW5hYmxlZH1cbiAgKi9cbiAgcmVhZG9ubHkgbmVzdGVkSHZFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaGUgbnVtYmVyIG9mIGNvcmVzIHRvIGRpc3RyaWJ1dGUgYW1vbmdzdCB0aGUgQ1BVcyBpbiB0aGlzIHZpcnR1YWwgbWFjaGluZS4gSWYgc3BlY2lmaWVkLCB0aGUgdmFsdWUgc3VwcGxpZWQgdG8gbnVtX2NwdXMgbXVzdCBiZSBldmVubHkgZGl2aXNpYmxlIGJ5IHRoaXMgdmFsdWUuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI251bV9jb3Jlc19wZXJfc29ja2V0IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjbnVtX2NvcmVzX3Blcl9zb2NrZXR9XG4gICovXG4gIHJlYWRvbmx5IG51bUNvcmVzUGVyU29ja2V0PzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgbnVtYmVyIG9mIHZpcnR1YWwgcHJvY2Vzc29ycyB0byBhc3NpZ24gdG8gdGhpcyB2aXJ0dWFsIG1hY2hpbmUuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI251bV9jcHVzIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjbnVtX2NwdXN9XG4gICovXG4gIHJlYWRvbmx5IG51bUNwdXM/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBudW1iZXIgb2YgTlZNZSBjb250cm9sbGVycyB0byBzY2FuIGZvciBkaXNrIHNpemVzIGFuZCBjb250cm9sbGVyIHR5cGVzIG9uLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNudm1lX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI252bWVfY29udHJvbGxlcl9zY2FuX2NvdW50fVxuICAqL1xuICByZWFkb25seSBudm1lQ29udHJvbGxlclNjYW5Db3VudD86IG51bWJlcjtcbiAgLyoqXG4gICogVHJpZ2dlcnMgcmVwbGFjZW1lbnQgb2YgcmVzb3VyY2Ugd2hlbmV2ZXIgaXQgY2hhbmdlcy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjcmVwbGFjZV90cmlnZ2VyIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjcmVwbGFjZV90cmlnZ2VyfVxuICAqL1xuICByZWFkb25seSByZXBsYWNlVHJpZ2dlcj86IHN0cmluZztcbiAgLyoqXG4gICogRW5hYmxlIHRoZSBydW4gb2Ygc2NyaXB0cyBhZnRlciB2aXJ0dWFsIG1hY2hpbmUgcG93ZXItb24gd2hlbiBWTXdhcmUgVG9vbHMgaXMgaW5zdGFsbGVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNydW5fdG9vbHNfc2NyaXB0c19hZnRlcl9wb3dlcl9vbiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI3J1bl90b29sc19zY3JpcHRzX2FmdGVyX3Bvd2VyX29ufVxuICAqL1xuICByZWFkb25seSBydW5Ub29sc1NjcmlwdHNBZnRlclBvd2VyT24/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEVuYWJsZSB0aGUgcnVuIG9mIHNjcmlwdHMgYWZ0ZXIgdmlydHVhbCBtYWNoaW5lIHJlc3VtZSB3aGVuIHdoZW4gVk13YXJlIFRvb2xzIGlzIGluc3RhbGxlZC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjcnVuX3Rvb2xzX3NjcmlwdHNfYWZ0ZXJfcmVzdW1lIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjcnVuX3Rvb2xzX3NjcmlwdHNfYWZ0ZXJfcmVzdW1lfVxuICAqL1xuICByZWFkb25seSBydW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRW5hYmxlIHRoZSBydW4gb2Ygc2NyaXB0cyBiZWZvcmUgZ3Vlc3Qgb3BlcmF0aW5nIHN5c3RlbSByZWJvb3Qgd2hlbiBWTXdhcmUgVG9vbHMgaXMgaW5zdGFsbGVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3RfcmVib290IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjcnVuX3Rvb2xzX3NjcmlwdHNfYmVmb3JlX2d1ZXN0X3JlYm9vdH1cbiAgKi9cbiAgcmVhZG9ubHkgcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3Q/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEVuYWJsZSB0aGUgcnVuIG9mIHNjcmlwdHMgYmVmb3JlIGd1ZXN0IG9wZXJhdGluZyBzeXN0ZW0gc2h1dGRvd24gd2hlbiBWTXdhcmUgVG9vbHMgaXMgaW5zdGFsbGVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc2h1dGRvd24gRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc2h1dGRvd259XG4gICovXG4gIHJlYWRvbmx5IHJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U2h1dGRvd24/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEVuYWJsZSB0aGUgcnVuIG9mIHNjcmlwdHMgYmVmb3JlIGd1ZXN0IG9wZXJhdGluZyBzeXN0ZW0gc3RhbmRieSB3aGVuIFZNd2FyZSBUb29scyBpcyBpbnN0YWxsZWQuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI3J1bl90b29sc19zY3JpcHRzX2JlZm9yZV9ndWVzdF9zdGFuZGJ5IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjcnVuX3Rvb2xzX3NjcmlwdHNfYmVmb3JlX2d1ZXN0X3N0YW5kYnl9XG4gICovXG4gIHJlYWRvbmx5IHJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIG51bWJlciBvZiBTQVRBIGNvbnRyb2xsZXJzIHRvIHNjYW4gZm9yIGRpc2sgc2l6ZXMgYW5kIGNvbnRyb2xsZXIgdHlwZXMgb24uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI3NhdGFfY29udHJvbGxlcl9zY2FuX2NvdW50IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjc2F0YV9jb250cm9sbGVyX3NjYW5fY291bnR9XG4gICovXG4gIHJlYWRvbmx5IHNhdGFDb250cm9sbGVyU2NhbkNvdW50PzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgbnVtYmVyIG9mIFNDU0kgY29udHJvbGxlcnMgdG8gc2NhbiBmb3IgZGlzayBzaXplcyBhbmQgY29udHJvbGxlciB0eXBlcyBvbi5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjc2NzaV9jb250cm9sbGVyX3NjYW5fY291bnQgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNzY3NpX2NvbnRyb2xsZXJfc2Nhbl9jb3VudH1cbiAgKi9cbiAgcmVhZG9ubHkgc2NzaUNvbnRyb2xsZXJTY2FuQ291bnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBJRCBvZiB0aGUgc3RvcmFnZSBwb2xpY3kgdG8gYXNzaWduIHRvIHRoZSB2aXJ0dWFsIG1hY2hpbmUgaG9tZSBkaXJlY3RvcnkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI3N0b3JhZ2VfcG9saWN5X2lkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjc3RvcmFnZV9wb2xpY3lfaWR9XG4gICovXG4gIHJlYWRvbmx5IHN0b3JhZ2VQb2xpY3lJZD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHN3YXAgZmlsZSBwbGFjZW1lbnQgcG9saWN5IGZvciB0aGlzIHZpcnR1YWwgbWFjaGluZS4gQ2FuIGJlIG9uZSBvZiBpbmhlcml0LCBob3N0TG9jYWwsIG9yIHZtRGlyZWN0b3J5LlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNzd2FwX3BsYWNlbWVudF9wb2xpY3kgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNzd2FwX3BsYWNlbWVudF9wb2xpY3l9XG4gICovXG4gIHJlYWRvbmx5IHN3YXBQbGFjZW1lbnRQb2xpY3k/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEVuYWJsZSBndWVzdCBjbG9jayBzeW5jaHJvbml6YXRpb24gd2l0aCB0aGUgaG9zdC4gT24gdlNwaGVyZSA3LjAgVTEgYW5kIGFib3ZlLCB3aXRoIG9ubHkgdGhpcyBzZXR0aW5nIHRoZSBjbG9jayBpcyBzeW5jaHJvbml6ZWQgb24gc3RhcnR1cCBhbmQgcmVzdW1lLiBSZXF1aXJlcyBWTXdhcmUgVG9vbHMgdG8gYmUgaW5zdGFsbGVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNzeW5jX3RpbWVfd2l0aF9ob3N0IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjc3luY190aW1lX3dpdGhfaG9zdH1cbiAgKi9cbiAgcmVhZG9ubHkgc3luY1RpbWVXaXRoSG9zdD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRW5hYmxlIHBlcmlvZGljIGNsb2NrIHN5bmNocm9uaXphdGlvbiB3aXRoIHRoZSBob3N0LiBTdXBwb3J0ZWQgb25seSBvbiB2U3BoZXJlIDcuMCBVMSBhbmQgYWJvdmUuIE9uIHByaW9yIHZlcnNpb25zIHNldHRpbmcgYHN5bmNfdGltZV93aXRoX2hvc3RgIGlzIGVub3VnaCBmb3IgcGVyaW9kaWMgc3luY2hyb25pemF0aW9uLiBSZXF1aXJlcyBWTXdhcmUgVG9vbHMgdG8gYmUgaW5zdGFsbGVkLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSNzeW5jX3RpbWVfd2l0aF9ob3N0X3BlcmlvZGljYWxseSBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI3N5bmNfdGltZV93aXRoX2hvc3RfcGVyaW9kaWNhbGx5fVxuICAqL1xuICByZWFkb25seSBzeW5jVGltZVdpdGhIb3N0UGVyaW9kaWNhbGx5PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBTZXQgdGhlIHVwZ3JhZGUgcG9saWN5IGZvciBWTXdhcmUgVG9vbHMuIENhbiBiZSBvbmUgb2YgYG1hbnVhbGAgb3IgYHVwZ3JhZGVBdFBvd2VyQ3ljbGVgLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSN0b29sc191cGdyYWRlX3BvbGljeSBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI3Rvb2xzX3VwZ3JhZGVfcG9saWN5fVxuICAqL1xuICByZWFkb25seSB0b29sc1VwZ3JhZGVQb2xpY3k/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBVVUlEIG9mIHRoZSB2aXJ0dWFsIG1hY2hpbmUuIEFsc28gZXhwb3NlZCBhcyB0aGUgSUQgb2YgdGhlIHJlc291cmNlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSN1dWlkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjdXVpZH1cbiAgKi9cbiAgcmVhZG9ubHkgdXVpZD86IHN0cmluZztcbiAgLyoqXG4gICogRmxhZyB0byBzcGVjaWZ5IGlmIFZpcnR1YWxpemF0aW9uLWJhc2VkIHNlY3VyaXR5IGlzIGVuYWJsZWQgZm9yIHRoaXMgdmlydHVhbCBtYWNoaW5lLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSN2YnNfZW5hYmxlZCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lI3Zic19lbmFibGVkfVxuICAqL1xuICByZWFkb25seSB2YnNFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBGbGFnIHRvIHNwZWNpZnkgaWYgSS9PIE1NVSB2aXJ0dWFsaXphdGlvbiwgYWxzbyBjYWxsZWQgSW50ZWwgVmlydHVhbGl6YXRpb24gVGVjaG5vbG9neSBmb3IgRGlyZWN0ZWQgSS9PIChWVC1kKSBhbmQgQU1EIEkvTyBWaXJ0dWFsaXphdGlvbiAoQU1ELVZpIG9yIElPTU1VKSwgaXMgZW5hYmxlZC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Ztd2FyZS92c3BoZXJlLzIuMTQuMS9kb2NzL2RhdGEtc291cmNlcy92aXJ0dWFsX21hY2hpbmUjdnZ0ZF9lbmFibGVkIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjdnZ0ZF9lbmFibGVkfVxuICAqL1xuICByZWFkb25seSB2dnRkRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogdmFwcCBibG9ja1xuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSN2YXBwIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmUjdmFwcH1cbiAgKi9cbiAgcmVhZG9ubHkgdmFwcD86IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwO1xufVxuZXhwb3J0IGludGVyZmFjZSBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lRGlza3Mge1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZURpc2tzVG9UZXJyYWZvcm0oc3RydWN0PzogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZURpc2tzKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICB9XG59XG5cblxuZXhwb3J0IGZ1bmN0aW9uIGRhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVEaXNrc1RvSGNsVGVycmFmb3JtKHN0cnVjdD86IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVEaXNrcyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgY29uc3QgYXR0cnMgPSB7XG4gIH07XG4gIHJldHVybiBhdHRycztcbn1cblxuZXhwb3J0IGNsYXNzIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVEaXNrc091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKiBAcGFyYW0gY29tcGxleE9iamVjdEluZGV4IHRoZSBpbmRleCBvZiB0aGlzIGl0ZW0gaW4gdGhlIGxpc3RcbiAgKiBAcGFyYW0gY29tcGxleE9iamVjdElzRnJvbVNldCB3aGV0aGVyIHRoZSBsaXN0IGlzIHdyYXBwaW5nIGEgc2V0ICh3aWxsIGFkZCB0b2xpc3QoKSB0byBiZSBhYmxlIHRvIGFjY2VzcyBhbiBpdGVtIHZpYSBhbiBpbmRleClcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGNvbXBsZXhPYmplY3RJbmRleDogbnVtYmVyLCBjb21wbGV4T2JqZWN0SXNGcm9tU2V0OiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgY29tcGxleE9iamVjdElzRnJvbVNldCwgY29tcGxleE9iamVjdEluZGV4KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lRGlza3MgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVEaXNrcyB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgIH1cbiAgfVxuXG4gIC8vIGVhZ2VybHlfc2NydWIgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBlYWdlcmx5U2NydWIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZWFnZXJseV9zY3J1YicpO1xuICB9XG5cbiAgLy8gbGFiZWwgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBsYWJlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2xhYmVsJyk7XG4gIH1cblxuICAvLyBzaXplIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3NpemUnKTtcbiAgfVxuXG4gIC8vIHRoaW5fcHJvdmlzaW9uZWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCB0aGluUHJvdmlzaW9uZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgndGhpbl9wcm92aXNpb25lZCcpO1xuICB9XG5cbiAgLy8gdW5pdF9udW1iZXIgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCB1bml0TnVtYmVyKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndW5pdF9udW1iZXInKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZURpc2tzTGlzdCBleHRlbmRzIGNka3RmLkNvbXBsZXhMaXN0IHtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKiBAcGFyYW0gd3JhcHNTZXQgd2hldGhlciB0aGUgbGlzdCBpcyB3cmFwcGluZyBhIHNldCAod2lsbCBhZGQgdG9saXN0KCkgdG8gYmUgYWJsZSB0byBhY2Nlc3MgYW4gaXRlbSB2aWEgYW4gaW5kZXgpXG4gICovXG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpXG4gIH1cblxuICAvKipcbiAgKiBAcGFyYW0gaW5kZXggdGhlIGluZGV4IG9mIHRoZSBpdGVtIHRvIHJldHVyblxuICAqL1xuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpOiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lRGlza3NPdXRwdXRSZWZlcmVuY2Uge1xuICAgIHJldHVybiBuZXcgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZURpc2tzT3V0cHV0UmVmZXJlbmNlKHRoaXMudGVycmFmb3JtUmVzb3VyY2UsIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLCBpbmRleCwgdGhpcy53cmFwc1NldCk7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZU5ldHdvcmtJbnRlcmZhY2VzIHtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVOZXR3b3JrSW50ZXJmYWNlc1RvVGVycmFmb3JtKHN0cnVjdD86IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVOZXR3b3JrSW50ZXJmYWNlcyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgfVxufVxuXG5cbmV4cG9ydCBmdW5jdGlvbiBkYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lTmV0d29ya0ludGVyZmFjZXNUb0hjbFRlcnJhZm9ybShzdHJ1Y3Q/OiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lTmV0d29ya0ludGVyZmFjZXMpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIGNvbnN0IGF0dHJzID0ge1xuICB9O1xuICByZXR1cm4gYXR0cnM7XG59XG5cbmV4cG9ydCBjbGFzcyBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lTmV0d29ya0ludGVyZmFjZXNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICogQHBhcmFtIGNvbXBsZXhPYmplY3RJbmRleCB0aGUgaW5kZXggb2YgdGhpcyBpdGVtIGluIHRoZSBsaXN0XG4gICogQHBhcmFtIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQgd2hldGhlciB0aGUgbGlzdCBpcyB3cmFwcGluZyBhIHNldCAod2lsbCBhZGQgdG9saXN0KCkgdG8gYmUgYWJsZSB0byBhY2Nlc3MgYW4gaXRlbSB2aWEgYW4gaW5kZXgpXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBjb21wbGV4T2JqZWN0SW5kZXg6IG51bWJlciwgY29tcGxleE9iamVjdElzRnJvbVNldDogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQsIGNvbXBsZXhPYmplY3RJbmRleCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZU5ldHdvcmtJbnRlcmZhY2VzIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lTmV0d29ya0ludGVyZmFjZXMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICB9XG4gIH1cblxuICAvLyBhZGFwdGVyX3R5cGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBhZGFwdGVyVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FkYXB0ZXJfdHlwZScpO1xuICB9XG5cbiAgLy8gYmFuZHdpZHRoX2xpbWl0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgYmFuZHdpZHRoTGltaXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdiYW5kd2lkdGhfbGltaXQnKTtcbiAgfVxuXG4gIC8vIGJhbmR3aWR0aF9yZXNlcnZhdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGJhbmR3aWR0aFJlc2VydmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnYmFuZHdpZHRoX3Jlc2VydmF0aW9uJyk7XG4gIH1cblxuICAvLyBiYW5kd2lkdGhfc2hhcmVfY291bnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBiYW5kd2lkdGhTaGFyZUNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnYmFuZHdpZHRoX3NoYXJlX2NvdW50Jyk7XG4gIH1cblxuICAvLyBiYW5kd2lkdGhfc2hhcmVfbGV2ZWwgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBiYW5kd2lkdGhTaGFyZUxldmVsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYmFuZHdpZHRoX3NoYXJlX2xldmVsJyk7XG4gIH1cblxuICAvLyBtYWNfYWRkcmVzcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG1hY0FkZHJlc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtYWNfYWRkcmVzcycpO1xuICB9XG5cbiAgLy8gbmV0d29ya19pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG5ldHdvcmtJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ25ldHdvcmtfaWQnKTtcbiAgfVxuXG4gIC8vIHBoeXNpY2FsX2Z1bmN0aW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgcGh5c2ljYWxGdW5jdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BoeXNpY2FsX2Z1bmN0aW9uJyk7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVOZXR3b3JrSW50ZXJmYWNlc0xpc3QgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4TGlzdCB7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICogQHBhcmFtIHdyYXBzU2V0IHdoZXRoZXIgdGhlIGxpc3QgaXMgd3JhcHBpbmcgYSBzZXQgKHdpbGwgYWRkIHRvbGlzdCgpIHRvIGJlIGFibGUgdG8gYWNjZXNzIGFuIGl0ZW0gdmlhIGFuIGluZGV4KVxuICAqL1xuICBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIHdyYXBzU2V0KVxuICB9XG5cbiAgLyoqXG4gICogQHBhcmFtIGluZGV4IHRoZSBpbmRleCBvZiB0aGUgaXRlbSB0byByZXR1cm5cbiAgKi9cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKTogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZU5ldHdvcmtJbnRlcmZhY2VzT3V0cHV0UmVmZXJlbmNlIHtcbiAgICByZXR1cm4gbmV3IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVOZXR3b3JrSW50ZXJmYWNlc091dHB1dFJlZmVyZW5jZSh0aGlzLnRlcnJhZm9ybVJlc291cmNlLCB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSwgaW5kZXgsIHRoaXMud3JhcHNTZXQpO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwIHtcbiAgLyoqXG4gICogQSBtYXAgb2YgY3VzdG9taXphYmxlIHZBcHAgcHJvcGVydGllcyBhbmQgdGhlaXIgdmFsdWVzLiBBbGxvd3MgY3VzdG9taXphdGlvbiBvZiBWTXMgY2xvbmVkIGZyb20gT1ZGIHRlbXBsYXRlcyB3aGljaCBoYXZlIGN1c3RvbWl6YWJsZSB2QXBwIHByb3BlcnRpZXMuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI3Byb3BlcnRpZXMgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSNwcm9wZXJ0aWVzfVxuICAqL1xuICByZWFkb25seSBwcm9wZXJ0aWVzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwVG9UZXJyYWZvcm0oc3RydWN0PzogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZVZhcHBPdXRwdXRSZWZlcmVuY2UgfCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lVmFwcCk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBwcm9wZXJ0aWVzOiBjZGt0Zi5oYXNoTWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLnByb3BlcnRpZXMpLFxuICB9XG59XG5cblxuZXhwb3J0IGZ1bmN0aW9uIGRhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwVG9IY2xUZXJyYWZvcm0oc3RydWN0PzogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZVZhcHBPdXRwdXRSZWZlcmVuY2UgfCBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lVmFwcCk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgY29uc3QgYXR0cnMgPSB7XG4gICAgcHJvcGVydGllczoge1xuICAgICAgdmFsdWU6IGNka3RmLmhhc2hNYXBwZXJIY2woY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0pKHN0cnVjdCEucHJvcGVydGllcyksXG4gICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgIHR5cGU6IFwibWFwXCIsXG4gICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ01hcFwiLFxuICAgIH0sXG4gIH07XG5cbiAgLy8gcmVtb3ZlIHVuZGVmaW5lZCBhdHRyaWJ1dGVzXG4gIHJldHVybiBPYmplY3QuZnJvbUVudHJpZXMoT2JqZWN0LmVudHJpZXMoYXR0cnMpLmZpbHRlcigoW18sIHZhbHVlXSkgPT4gdmFsdWUgIT09IHVuZGVmaW5lZCAmJiB2YWx1ZS52YWx1ZSAhPT0gdW5kZWZpbmVkKSk7XG59XG5cbmV4cG9ydCBjbGFzcyBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lVmFwcE91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZVZhcHAgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX3Byb3BlcnRpZXMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHJvcGVydGllcyA9IHRoaXMuX3Byb3BlcnRpZXM7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lVmFwcCB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX3Byb3BlcnRpZXMgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX3Byb3BlcnRpZXMgPSB2YWx1ZS5wcm9wZXJ0aWVzO1xuICAgIH1cbiAgfVxuXG4gIC8vIHByb3BlcnRpZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJvcGVydGllcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07IFxuICBwdWJsaWMgZ2V0IHByb3BlcnRpZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nTWFwQXR0cmlidXRlKCdwcm9wZXJ0aWVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcm9wZXJ0aWVzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9KSB7XG4gICAgdGhpcy5fcHJvcGVydGllcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByb3BlcnRpZXMoKSB7XG4gICAgdGhpcy5fcHJvcGVydGllcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJvcGVydGllc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcm9wZXJ0aWVzO1xuICB9XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lIHZzcGhlcmVfdmlydHVhbF9tYWNoaW5lfVxuKi9cbmV4cG9ydCBjbGFzcyBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtRGF0YVNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwidnNwaGVyZV92aXJ0dWFsX21hY2hpbmVcIjtcblxuICAvLyA9PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgTWV0aG9kc1xuICAvLyA9PT09PT09PT09PT09PVxuICAvKipcbiAgKiBHZW5lcmF0ZXMgQ0RLVEYgY29kZSBmb3IgaW1wb3J0aW5nIGEgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZSByZXNvdXJjZSB1cG9uIHJ1bm5pbmcgXCJjZGt0ZiBwbGFuIDxzdGFjay1uYW1lPlwiXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaW1wb3J0VG9JZCBUaGUgY29uc3RydWN0IGlkIHVzZWQgaW4gdGhlIGdlbmVyYXRlZCBjb25maWcgZm9yIHRoZSBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lIHRvIGltcG9ydFxuICAqIEBwYXJhbSBpbXBvcnRGcm9tSWQgVGhlIGlkIG9mIHRoZSBleGlzdGluZyBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lIHRoYXQgc2hvdWxkIGJlIGltcG9ydGVkLiBSZWZlciB0byB0aGUge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy92bXdhcmUvdnNwaGVyZS8yLjE0LjEvZG9jcy9kYXRhLXNvdXJjZXMvdmlydHVhbF9tYWNoaW5lI2ltcG9ydCBpbXBvcnQgc2VjdGlvbn0gaW4gdGhlIGRvY3VtZW50YXRpb24gb2YgdGhpcyByZXNvdXJjZSBmb3IgdGhlIGlkIHRvIHVzZVxuICAqIEBwYXJhbSBwcm92aWRlcj8gT3B0aW9uYWwgaW5zdGFuY2Ugb2YgdGhlIHByb3ZpZGVyIHdoZXJlIHRoZSBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lIHRvIGltcG9ydCBpcyBmb3VuZFxuICAqL1xuICBwdWJsaWMgc3RhdGljIGdlbmVyYXRlQ29uZmlnRm9ySW1wb3J0KHNjb3BlOiBDb25zdHJ1Y3QsIGltcG9ydFRvSWQ6IHN0cmluZywgaW1wb3J0RnJvbUlkOiBzdHJpbmcsIHByb3ZpZGVyPzogY2RrdGYuVGVycmFmb3JtUHJvdmlkZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZGt0Zi5JbXBvcnRhYmxlUmVzb3VyY2Uoc2NvcGUsIGltcG9ydFRvSWQsIHsgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiBcInZzcGhlcmVfdmlydHVhbF9tYWNoaW5lXCIsIGltcG9ydElkOiBpbXBvcnRGcm9tSWQsIHByb3ZpZGVyIH0pO1xuICAgICAgfVxuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvdm13YXJlL3ZzcGhlcmUvMi4xNC4xL2RvY3MvZGF0YS1zb3VyY2VzL3ZpcnR1YWxfbWFjaGluZSB2c3BoZXJlX3ZpcnR1YWxfbWFjaGluZX0gRGF0YSBTb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZUNvbmZpZyA9IHt9XG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVDb25maWcgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAndnNwaGVyZV92aXJ0dWFsX21hY2hpbmUnLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAndnNwaGVyZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzIuMTQuMScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiAyLjEzJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlLFxuICAgICAgcHJvdmlzaW9uZXJzOiBjb25maWcucHJvdmlzaW9uZXJzLFxuICAgICAgY29ubmVjdGlvbjogY29uZmlnLmNvbm5lY3Rpb24sXG4gICAgICBmb3JFYWNoOiBjb25maWcuZm9yRWFjaFxuICAgIH0pO1xuICAgIHRoaXMuX2FsdGVybmF0ZUd1ZXN0TmFtZSA9IGNvbmZpZy5hbHRlcm5hdGVHdWVzdE5hbWU7XG4gICAgdGhpcy5fYW5ub3RhdGlvbiA9IGNvbmZpZy5hbm5vdGF0aW9uO1xuICAgIHRoaXMuX2Jvb3REZWxheSA9IGNvbmZpZy5ib290RGVsYXk7XG4gICAgdGhpcy5fYm9vdFJldHJ5RGVsYXkgPSBjb25maWcuYm9vdFJldHJ5RGVsYXk7XG4gICAgdGhpcy5fYm9vdFJldHJ5RW5hYmxlZCA9IGNvbmZpZy5ib290UmV0cnlFbmFibGVkO1xuICAgIHRoaXMuX2NwdUhvdEFkZEVuYWJsZWQgPSBjb25maWcuY3B1SG90QWRkRW5hYmxlZDtcbiAgICB0aGlzLl9jcHVIb3RSZW1vdmVFbmFibGVkID0gY29uZmlnLmNwdUhvdFJlbW92ZUVuYWJsZWQ7XG4gICAgdGhpcy5fY3B1TGltaXQgPSBjb25maWcuY3B1TGltaXQ7XG4gICAgdGhpcy5fY3B1UGVyZm9ybWFuY2VDb3VudGVyc0VuYWJsZWQgPSBjb25maWcuY3B1UGVyZm9ybWFuY2VDb3VudGVyc0VuYWJsZWQ7XG4gICAgdGhpcy5fY3B1UmVzZXJ2YXRpb24gPSBjb25maWcuY3B1UmVzZXJ2YXRpb247XG4gICAgdGhpcy5fY3B1U2hhcmVDb3VudCA9IGNvbmZpZy5jcHVTaGFyZUNvdW50O1xuICAgIHRoaXMuX2NwdVNoYXJlTGV2ZWwgPSBjb25maWcuY3B1U2hhcmVMZXZlbDtcbiAgICB0aGlzLl9kYXRhY2VudGVySWQgPSBjb25maWcuZGF0YWNlbnRlcklkO1xuICAgIHRoaXMuX2VmaVNlY3VyZUJvb3RFbmFibGVkID0gY29uZmlnLmVmaVNlY3VyZUJvb3RFbmFibGVkO1xuICAgIHRoaXMuX2VuYWJsZURpc2tVdWlkID0gY29uZmlnLmVuYWJsZURpc2tVdWlkO1xuICAgIHRoaXMuX2VuYWJsZUxvZ2dpbmcgPSBjb25maWcuZW5hYmxlTG9nZ2luZztcbiAgICB0aGlzLl9lcHRSdmlNb2RlID0gY29uZmlnLmVwdFJ2aU1vZGU7XG4gICAgdGhpcy5fZXh0cmFDb25maWcgPSBjb25maWcuZXh0cmFDb25maWc7XG4gICAgdGhpcy5fZXh0cmFDb25maWdSZWJvb3RSZXF1aXJlZCA9IGNvbmZpZy5leHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkO1xuICAgIHRoaXMuX2Zpcm13YXJlID0gY29uZmlnLmZpcm13YXJlO1xuICAgIHRoaXMuX2ZvbGRlciA9IGNvbmZpZy5mb2xkZXI7XG4gICAgdGhpcy5fZ3Vlc3RJZCA9IGNvbmZpZy5ndWVzdElkO1xuICAgIHRoaXMuX2hhcmR3YXJlVmVyc2lvbiA9IGNvbmZpZy5oYXJkd2FyZVZlcnNpb247XG4gICAgdGhpcy5faHZNb2RlID0gY29uZmlnLmh2TW9kZTtcbiAgICB0aGlzLl9pZCA9IGNvbmZpZy5pZDtcbiAgICB0aGlzLl9pZGVDb250cm9sbGVyU2NhbkNvdW50ID0gY29uZmlnLmlkZUNvbnRyb2xsZXJTY2FuQ291bnQ7XG4gICAgdGhpcy5fbGF0ZW5jeVNlbnNpdGl2aXR5ID0gY29uZmlnLmxhdGVuY3lTZW5zaXRpdml0eTtcbiAgICB0aGlzLl9tZW1vcnkgPSBjb25maWcubWVtb3J5O1xuICAgIHRoaXMuX21lbW9yeUhvdEFkZEVuYWJsZWQgPSBjb25maWcubWVtb3J5SG90QWRkRW5hYmxlZDtcbiAgICB0aGlzLl9tZW1vcnlMaW1pdCA9IGNvbmZpZy5tZW1vcnlMaW1pdDtcbiAgICB0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbiA9IGNvbmZpZy5tZW1vcnlSZXNlcnZhdGlvbjtcbiAgICB0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4ID0gY29uZmlnLm1lbW9yeVJlc2VydmF0aW9uTG9ja2VkVG9NYXg7XG4gICAgdGhpcy5fbWVtb3J5U2hhcmVDb3VudCA9IGNvbmZpZy5tZW1vcnlTaGFyZUNvdW50O1xuICAgIHRoaXMuX21lbW9yeVNoYXJlTGV2ZWwgPSBjb25maWcubWVtb3J5U2hhcmVMZXZlbDtcbiAgICB0aGlzLl9tb2lkID0gY29uZmlnLm1vaWQ7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX25lc3RlZEh2RW5hYmxlZCA9IGNvbmZpZy5uZXN0ZWRIdkVuYWJsZWQ7XG4gICAgdGhpcy5fbnVtQ29yZXNQZXJTb2NrZXQgPSBjb25maWcubnVtQ29yZXNQZXJTb2NrZXQ7XG4gICAgdGhpcy5fbnVtQ3B1cyA9IGNvbmZpZy5udW1DcHVzO1xuICAgIHRoaXMuX252bWVDb250cm9sbGVyU2NhbkNvdW50ID0gY29uZmlnLm52bWVDb250cm9sbGVyU2NhbkNvdW50O1xuICAgIHRoaXMuX3JlcGxhY2VUcmlnZ2VyID0gY29uZmlnLnJlcGxhY2VUcmlnZ2VyO1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0FmdGVyUG93ZXJPbiA9IGNvbmZpZy5ydW5Ub29sc1NjcmlwdHNBZnRlclBvd2VyT247XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWUgPSBjb25maWcucnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWU7XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3QgPSBjb25maWcucnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3Q7XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTaHV0ZG93biA9IGNvbmZpZy5ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFNodXRkb3duO1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieSA9IGNvbmZpZy5ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFN0YW5kYnk7XG4gICAgdGhpcy5fc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQgPSBjb25maWcuc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQ7XG4gICAgdGhpcy5fc2NzaUNvbnRyb2xsZXJTY2FuQ291bnQgPSBjb25maWcuc2NzaUNvbnRyb2xsZXJTY2FuQ291bnQ7XG4gICAgdGhpcy5fc3RvcmFnZVBvbGljeUlkID0gY29uZmlnLnN0b3JhZ2VQb2xpY3lJZDtcbiAgICB0aGlzLl9zd2FwUGxhY2VtZW50UG9saWN5ID0gY29uZmlnLnN3YXBQbGFjZW1lbnRQb2xpY3k7XG4gICAgdGhpcy5fc3luY1RpbWVXaXRoSG9zdCA9IGNvbmZpZy5zeW5jVGltZVdpdGhIb3N0O1xuICAgIHRoaXMuX3N5bmNUaW1lV2l0aEhvc3RQZXJpb2RpY2FsbHkgPSBjb25maWcuc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseTtcbiAgICB0aGlzLl90b29sc1VwZ3JhZGVQb2xpY3kgPSBjb25maWcudG9vbHNVcGdyYWRlUG9saWN5O1xuICAgIHRoaXMuX3V1aWQgPSBjb25maWcudXVpZDtcbiAgICB0aGlzLl92YnNFbmFibGVkID0gY29uZmlnLnZic0VuYWJsZWQ7XG4gICAgdGhpcy5fdnZ0ZEVuYWJsZWQgPSBjb25maWcudnZ0ZEVuYWJsZWQ7XG4gICAgdGhpcy5fdmFwcC5pbnRlcm5hbFZhbHVlID0gY29uZmlnLnZhcHA7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFsdGVybmF0ZV9ndWVzdF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsdGVybmF0ZUd1ZXN0TmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYWx0ZXJuYXRlR3Vlc3ROYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYWx0ZXJuYXRlX2d1ZXN0X25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFsdGVybmF0ZUd1ZXN0TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fYWx0ZXJuYXRlR3Vlc3ROYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWx0ZXJuYXRlR3Vlc3ROYW1lKCkge1xuICAgIHRoaXMuX2FsdGVybmF0ZUd1ZXN0TmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWx0ZXJuYXRlR3Vlc3ROYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FsdGVybmF0ZUd1ZXN0TmFtZTtcbiAgfVxuXG4gIC8vIGFubm90YXRpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hbm5vdGF0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhbm5vdGF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYW5ub3RhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYW5ub3RhdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fYW5ub3RhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEFubm90YXRpb24oKSB7XG4gICAgdGhpcy5fYW5ub3RhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYW5ub3RhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hbm5vdGF0aW9uO1xuICB9XG5cbiAgLy8gYm9vdF9kZWxheSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ib290RGVsYXk/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGJvb3REZWxheSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2Jvb3RfZGVsYXknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJvb3REZWxheSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fYm9vdERlbGF5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Qm9vdERlbGF5KCkge1xuICAgIHRoaXMuX2Jvb3REZWxheSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYm9vdERlbGF5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jvb3REZWxheTtcbiAgfVxuXG4gIC8vIGJvb3RfcmV0cnlfZGVsYXkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYm9vdFJldHJ5RGVsYXk/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGJvb3RSZXRyeURlbGF5KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnYm9vdF9yZXRyeV9kZWxheScpO1xuICB9XG4gIHB1YmxpYyBzZXQgYm9vdFJldHJ5RGVsYXkodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2Jvb3RSZXRyeURlbGF5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Qm9vdFJldHJ5RGVsYXkoKSB7XG4gICAgdGhpcy5fYm9vdFJldHJ5RGVsYXkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJvb3RSZXRyeURlbGF5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jvb3RSZXRyeURlbGF5O1xuICB9XG5cbiAgLy8gYm9vdF9yZXRyeV9lbmFibGVkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jvb3RSZXRyeUVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGJvb3RSZXRyeUVuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnYm9vdF9yZXRyeV9lbmFibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCBib290UmV0cnlFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9ib290UmV0cnlFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Qm9vdFJldHJ5RW5hYmxlZCgpIHtcbiAgICB0aGlzLl9ib290UmV0cnlFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBib290UmV0cnlFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jvb3RSZXRyeUVuYWJsZWQ7XG4gIH1cblxuICAvLyBjaGFuZ2VfdmVyc2lvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGNoYW5nZVZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjaGFuZ2VfdmVyc2lvbicpO1xuICB9XG5cbiAgLy8gY3B1X2hvdF9hZGRfZW5hYmxlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcHVIb3RBZGRFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBjcHVIb3RBZGRFbmFibGVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2NwdV9ob3RfYWRkX2VuYWJsZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNwdUhvdEFkZEVuYWJsZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2NwdUhvdEFkZEVuYWJsZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcHVIb3RBZGRFbmFibGVkKCkge1xuICAgIHRoaXMuX2NwdUhvdEFkZEVuYWJsZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNwdUhvdEFkZEVuYWJsZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3B1SG90QWRkRW5hYmxlZDtcbiAgfVxuXG4gIC8vIGNwdV9ob3RfcmVtb3ZlX2VuYWJsZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3B1SG90UmVtb3ZlRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgY3B1SG90UmVtb3ZlRW5hYmxlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdjcHVfaG90X3JlbW92ZV9lbmFibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCBjcHVIb3RSZW1vdmVFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9jcHVIb3RSZW1vdmVFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3B1SG90UmVtb3ZlRW5hYmxlZCgpIHtcbiAgICB0aGlzLl9jcHVIb3RSZW1vdmVFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcHVIb3RSZW1vdmVFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NwdUhvdFJlbW92ZUVuYWJsZWQ7XG4gIH1cblxuICAvLyBjcHVfbGltaXQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3B1TGltaXQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNwdUxpbWl0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY3B1X2xpbWl0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBjcHVMaW1pdCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fY3B1TGltaXQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcHVMaW1pdCgpIHtcbiAgICB0aGlzLl9jcHVMaW1pdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY3B1TGltaXRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3B1TGltaXQ7XG4gIH1cblxuICAvLyBjcHVfcGVyZm9ybWFuY2VfY291bnRlcnNfZW5hYmxlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcHVQZXJmb3JtYW5jZUNvdW50ZXJzRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgY3B1UGVyZm9ybWFuY2VDb3VudGVyc0VuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnY3B1X3BlcmZvcm1hbmNlX2NvdW50ZXJzX2VuYWJsZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNwdVBlcmZvcm1hbmNlQ291bnRlcnNFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9jcHVQZXJmb3JtYW5jZUNvdW50ZXJzRW5hYmxlZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENwdVBlcmZvcm1hbmNlQ291bnRlcnNFbmFibGVkKCkge1xuICAgIHRoaXMuX2NwdVBlcmZvcm1hbmNlQ291bnRlcnNFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcHVQZXJmb3JtYW5jZUNvdW50ZXJzRW5hYmxlZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jcHVQZXJmb3JtYW5jZUNvdW50ZXJzRW5hYmxlZDtcbiAgfVxuXG4gIC8vIGNwdV9yZXNlcnZhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcHVSZXNlcnZhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY3B1UmVzZXJ2YXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjcHVfcmVzZXJ2YXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNwdVJlc2VydmF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jcHVSZXNlcnZhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENwdVJlc2VydmF0aW9uKCkge1xuICAgIHRoaXMuX2NwdVJlc2VydmF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcHVSZXNlcnZhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jcHVSZXNlcnZhdGlvbjtcbiAgfVxuXG4gIC8vIGNwdV9zaGFyZV9jb3VudCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NwdVNoYXJlQ291bnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNwdVNoYXJlQ291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjcHVfc2hhcmVfY291bnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNwdVNoYXJlQ291bnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2NwdVNoYXJlQ291bnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcHVTaGFyZUNvdW50KCkge1xuICAgIHRoaXMuX2NwdVNoYXJlQ291bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNwdVNoYXJlQ291bnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3B1U2hhcmVDb3VudDtcbiAgfVxuXG4gIC8vIGNwdV9zaGFyZV9sZXZlbCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcHVTaGFyZUxldmVsPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjcHVTaGFyZUxldmVsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY3B1X3NoYXJlX2xldmVsJyk7XG4gIH1cbiAgcHVibGljIHNldCBjcHVTaGFyZUxldmVsKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jcHVTaGFyZUxldmVsID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3B1U2hhcmVMZXZlbCgpIHtcbiAgICB0aGlzLl9jcHVTaGFyZUxldmVsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcHVTaGFyZUxldmVsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NwdVNoYXJlTGV2ZWw7XG4gIH1cblxuICAvLyBkYXRhY2VudGVyX2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RhdGFjZW50ZXJJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGF0YWNlbnRlcklkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGF0YWNlbnRlcl9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGF0YWNlbnRlcklkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kYXRhY2VudGVySWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREYXRhY2VudGVySWQoKSB7XG4gICAgdGhpcy5fZGF0YWNlbnRlcklkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkYXRhY2VudGVySWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGF0YWNlbnRlcklkO1xuICB9XG5cbiAgLy8gZGVmYXVsdF9pcF9hZGRyZXNzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgZGVmYXVsdElwQWRkcmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RlZmF1bHRfaXBfYWRkcmVzcycpO1xuICB9XG5cbiAgLy8gZGlza3MgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlza3MgPSBuZXcgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZURpc2tzTGlzdCh0aGlzLCBcImRpc2tzXCIsIGZhbHNlKTtcbiAgcHVibGljIGdldCBkaXNrcygpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlza3M7XG4gIH1cblxuICAvLyBlZmlfc2VjdXJlX2Jvb3RfZW5hYmxlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lZmlTZWN1cmVCb290RW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZWZpU2VjdXJlQm9vdEVuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZWZpX3NlY3VyZV9ib290X2VuYWJsZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVmaVNlY3VyZUJvb3RFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9lZmlTZWN1cmVCb290RW5hYmxlZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVmaVNlY3VyZUJvb3RFbmFibGVkKCkge1xuICAgIHRoaXMuX2VmaVNlY3VyZUJvb3RFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlZmlTZWN1cmVCb290RW5hYmxlZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lZmlTZWN1cmVCb290RW5hYmxlZDtcbiAgfVxuXG4gIC8vIGVuYWJsZV9kaXNrX3V1aWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5hYmxlRGlza1V1aWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGVuYWJsZURpc2tVdWlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9kaXNrX3V1aWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuYWJsZURpc2tVdWlkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9lbmFibGVEaXNrVXVpZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZURpc2tVdWlkKCkge1xuICAgIHRoaXMuX2VuYWJsZURpc2tVdWlkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbmFibGVEaXNrVXVpZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVEaXNrVXVpZDtcbiAgfVxuXG4gIC8vIGVuYWJsZV9sb2dnaW5nIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VuYWJsZUxvZ2dpbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGVuYWJsZUxvZ2dpbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZW5hYmxlX2xvZ2dpbmcnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuYWJsZUxvZ2dpbmcodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZUxvZ2dpbmcgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFbmFibGVMb2dnaW5nKCkge1xuICAgIHRoaXMuX2VuYWJsZUxvZ2dpbmcgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZUxvZ2dpbmdJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZW5hYmxlTG9nZ2luZztcbiAgfVxuXG4gIC8vIGVwdF9ydmlfbW9kZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VwdFJ2aU1vZGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGVwdFJ2aU1vZGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdlcHRfcnZpX21vZGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVwdFJ2aU1vZGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2VwdFJ2aU1vZGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFcHRSdmlNb2RlKCkge1xuICAgIHRoaXMuX2VwdFJ2aU1vZGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVwdFJ2aU1vZGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZXB0UnZpTW9kZTtcbiAgfVxuXG4gIC8vIGV4dHJhX2NvbmZpZyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9leHRyYUNvbmZpZz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07IFxuICBwdWJsaWMgZ2V0IGV4dHJhQ29uZmlnKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ01hcEF0dHJpYnV0ZSgnZXh0cmFfY29uZmlnJyk7XG4gIH1cbiAgcHVibGljIHNldCBleHRyYUNvbmZpZyh2YWx1ZTogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSkge1xuICAgIHRoaXMuX2V4dHJhQ29uZmlnID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RXh0cmFDb25maWcoKSB7XG4gICAgdGhpcy5fZXh0cmFDb25maWcgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGV4dHJhQ29uZmlnSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2V4dHJhQ29uZmlnO1xuICB9XG5cbiAgLy8gZXh0cmFfY29uZmlnX3JlYm9vdF9yZXF1aXJlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9leHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBleHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2V4dHJhX2NvbmZpZ19yZWJvb3RfcmVxdWlyZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGV4dHJhQ29uZmlnUmVib290UmVxdWlyZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2V4dHJhQ29uZmlnUmVib290UmVxdWlyZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFeHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkKCkge1xuICAgIHRoaXMuX2V4dHJhQ29uZmlnUmVib290UmVxdWlyZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGV4dHJhQ29uZmlnUmVib290UmVxdWlyZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZXh0cmFDb25maWdSZWJvb3RSZXF1aXJlZDtcbiAgfVxuXG4gIC8vIGZpcm13YXJlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Zpcm13YXJlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBmaXJtd2FyZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Zpcm13YXJlJyk7XG4gIH1cbiAgcHVibGljIHNldCBmaXJtd2FyZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZmlybXdhcmUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRGaXJtd2FyZSgpIHtcbiAgICB0aGlzLl9maXJtd2FyZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZmlybXdhcmVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZmlybXdhcmU7XG4gIH1cblxuICAvLyBmb2xkZXIgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZm9sZGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBmb2xkZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdmb2xkZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGZvbGRlcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZm9sZGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Rm9sZGVyKCkge1xuICAgIHRoaXMuX2ZvbGRlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZm9sZGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ZvbGRlcjtcbiAgfVxuXG4gIC8vIGd1ZXN0X2lkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZ3Vlc3RJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZ3Vlc3RJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2d1ZXN0X2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBndWVzdElkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9ndWVzdElkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3Vlc3RJZCgpIHtcbiAgICB0aGlzLl9ndWVzdElkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBndWVzdElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2d1ZXN0SWQ7XG4gIH1cblxuICAvLyBndWVzdF9pcF9hZGRyZXNzZXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBndWVzdElwQWRkcmVzc2VzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2d1ZXN0X2lwX2FkZHJlc3NlcycpO1xuICB9XG5cbiAgLy8gaGFyZHdhcmVfdmVyc2lvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2hhcmR3YXJlVmVyc2lvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaGFyZHdhcmVWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnaGFyZHdhcmVfdmVyc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgaGFyZHdhcmVWZXJzaW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9oYXJkd2FyZVZlcnNpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIYXJkd2FyZVZlcnNpb24oKSB7XG4gICAgdGhpcy5faGFyZHdhcmVWZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBoYXJkd2FyZVZlcnNpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faGFyZHdhcmVWZXJzaW9uO1xuICB9XG5cbiAgLy8gaHZfbW9kZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2h2TW9kZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaHZNb2RlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaHZfbW9kZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgaHZNb2RlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9odk1vZGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIdk1vZGUoKSB7XG4gICAgdGhpcy5faHZNb2RlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBodk1vZGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faHZNb2RlO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gaWRlX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZGVDb250cm9sbGVyU2NhbkNvdW50PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBpZGVDb250cm9sbGVyU2NhbkNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnaWRlX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWRlQ29udHJvbGxlclNjYW5Db3VudCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5faWRlQ29udHJvbGxlclNjYW5Db3VudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElkZUNvbnRyb2xsZXJTY2FuQ291bnQoKSB7XG4gICAgdGhpcy5faWRlQ29udHJvbGxlclNjYW5Db3VudCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRlQ29udHJvbGxlclNjYW5Db3VudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pZGVDb250cm9sbGVyU2NhbkNvdW50O1xuICB9XG5cbiAgLy8gaW5zdGFuY2VfdXVpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGluc3RhbmNlVXVpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2luc3RhbmNlX3V1aWQnKTtcbiAgfVxuXG4gIC8vIGxhdGVuY3lfc2Vuc2l0aXZpdHkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbGF0ZW5jeVNlbnNpdGl2aXR5Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBsYXRlbmN5U2Vuc2l0aXZpdHkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdsYXRlbmN5X3NlbnNpdGl2aXR5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBsYXRlbmN5U2Vuc2l0aXZpdHkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2xhdGVuY3lTZW5zaXRpdml0eSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldExhdGVuY3lTZW5zaXRpdml0eSgpIHtcbiAgICB0aGlzLl9sYXRlbmN5U2Vuc2l0aXZpdHkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxhdGVuY3lTZW5zaXRpdml0eUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9sYXRlbmN5U2Vuc2l0aXZpdHk7XG4gIH1cblxuICAvLyBtZW1vcnkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtb3J5PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBtZW1vcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdtZW1vcnknKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1lbW9yeSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWVtb3J5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWVtb3J5KCkge1xuICAgIHRoaXMuX21lbW9yeSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWVtb3J5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21lbW9yeTtcbiAgfVxuXG4gIC8vIG1lbW9yeV9ob3RfYWRkX2VuYWJsZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtb3J5SG90QWRkRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgbWVtb3J5SG90QWRkRW5hYmxlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdtZW1vcnlfaG90X2FkZF9lbmFibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCBtZW1vcnlIb3RBZGRFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9tZW1vcnlIb3RBZGRFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWVtb3J5SG90QWRkRW5hYmxlZCgpIHtcbiAgICB0aGlzLl9tZW1vcnlIb3RBZGRFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZW1vcnlIb3RBZGRFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21lbW9yeUhvdEFkZEVuYWJsZWQ7XG4gIH1cblxuICAvLyBtZW1vcnlfbGltaXQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtb3J5TGltaXQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1lbW9yeUxpbWl0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnbWVtb3J5X2xpbWl0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtZW1vcnlMaW1pdCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWVtb3J5TGltaXQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNZW1vcnlMaW1pdCgpIHtcbiAgICB0aGlzLl9tZW1vcnlMaW1pdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWVtb3J5TGltaXRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWVtb3J5TGltaXQ7XG4gIH1cblxuICAvLyBtZW1vcnlfcmVzZXJ2YXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtb3J5UmVzZXJ2YXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1lbW9yeVJlc2VydmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnbWVtb3J5X3Jlc2VydmF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBtZW1vcnlSZXNlcnZhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWVtb3J5UmVzZXJ2YXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNZW1vcnlSZXNlcnZhdGlvbigpIHtcbiAgICB0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWVtb3J5UmVzZXJ2YXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWVtb3J5UmVzZXJ2YXRpb247XG4gIH1cblxuICAvLyBtZW1vcnlfcmVzZXJ2YXRpb25fbG9ja2VkX3RvX21heCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBtZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ21lbW9yeV9yZXNlcnZhdGlvbl9sb2NrZWRfdG9fbWF4Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWVtb3J5UmVzZXJ2YXRpb25Mb2NrZWRUb01heCgpIHtcbiAgICB0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21lbW9yeVJlc2VydmF0aW9uTG9ja2VkVG9NYXg7XG4gIH1cblxuICAvLyBtZW1vcnlfc2hhcmVfY291bnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tZW1vcnlTaGFyZUNvdW50PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBtZW1vcnlTaGFyZUNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnbWVtb3J5X3NoYXJlX2NvdW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtZW1vcnlTaGFyZUNvdW50KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9tZW1vcnlTaGFyZUNvdW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWVtb3J5U2hhcmVDb3VudCgpIHtcbiAgICB0aGlzLl9tZW1vcnlTaGFyZUNvdW50ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZW1vcnlTaGFyZUNvdW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21lbW9yeVNoYXJlQ291bnQ7XG4gIH1cblxuICAvLyBtZW1vcnlfc2hhcmVfbGV2ZWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtb3J5U2hhcmVMZXZlbD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbWVtb3J5U2hhcmVMZXZlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21lbW9yeV9zaGFyZV9sZXZlbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWVtb3J5U2hhcmVMZXZlbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbWVtb3J5U2hhcmVMZXZlbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1lbW9yeVNoYXJlTGV2ZWwoKSB7XG4gICAgdGhpcy5fbWVtb3J5U2hhcmVMZXZlbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWVtb3J5U2hhcmVMZXZlbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tZW1vcnlTaGFyZUxldmVsO1xuICB9XG5cbiAgLy8gbW9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21vaWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1vaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBtb2lkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TW9pZCgpIHtcbiAgICB0aGlzLl9tb2lkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb2lkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21vaWQ7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX25hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TmFtZSgpIHtcbiAgICB0aGlzLl9uYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICAvLyBuZXN0ZWRfaHZfZW5hYmxlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9uZXN0ZWRIdkVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IG5lc3RlZEh2RW5hYmxlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCduZXN0ZWRfaHZfZW5hYmxlZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmVzdGVkSHZFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9uZXN0ZWRIdkVuYWJsZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXROZXN0ZWRIdkVuYWJsZWQoKSB7XG4gICAgdGhpcy5fbmVzdGVkSHZFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuZXN0ZWRIdkVuYWJsZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmVzdGVkSHZFbmFibGVkO1xuICB9XG5cbiAgLy8gbmV0d29ya19pbnRlcmZhY2VfdHlwZXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBuZXR3b3JrSW50ZXJmYWNlVHlwZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnbmV0d29ya19pbnRlcmZhY2VfdHlwZXMnKTtcbiAgfVxuXG4gIC8vIG5ldHdvcmtfaW50ZXJmYWNlcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9uZXR3b3JrSW50ZXJmYWNlcyA9IG5ldyBEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lTmV0d29ya0ludGVyZmFjZXNMaXN0KHRoaXMsIFwibmV0d29ya19pbnRlcmZhY2VzXCIsIGZhbHNlKTtcbiAgcHVibGljIGdldCBuZXR3b3JrSW50ZXJmYWNlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fbmV0d29ya0ludGVyZmFjZXM7XG4gIH1cblxuICAvLyBudW1fY29yZXNfcGVyX3NvY2tldCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9udW1Db3Jlc1BlclNvY2tldD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbnVtQ29yZXNQZXJTb2NrZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdudW1fY29yZXNfcGVyX3NvY2tldCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbnVtQ29yZXNQZXJTb2NrZXQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX251bUNvcmVzUGVyU29ja2V0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TnVtQ29yZXNQZXJTb2NrZXQoKSB7XG4gICAgdGhpcy5fbnVtQ29yZXNQZXJTb2NrZXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG51bUNvcmVzUGVyU29ja2V0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX251bUNvcmVzUGVyU29ja2V0O1xuICB9XG5cbiAgLy8gbnVtX2NwdXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbnVtQ3B1cz86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbnVtQ3B1cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ251bV9jcHVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBudW1DcHVzKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9udW1DcHVzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TnVtQ3B1cygpIHtcbiAgICB0aGlzLl9udW1DcHVzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBudW1DcHVzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX251bUNwdXM7XG4gIH1cblxuICAvLyBudm1lX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9udm1lQ29udHJvbGxlclNjYW5Db3VudD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbnZtZUNvbnRyb2xsZXJTY2FuQ291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdudm1lX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbnZtZUNvbnRyb2xsZXJTY2FuQ291bnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX252bWVDb250cm9sbGVyU2NhbkNvdW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TnZtZUNvbnRyb2xsZXJTY2FuQ291bnQoKSB7XG4gICAgdGhpcy5fbnZtZUNvbnRyb2xsZXJTY2FuQ291bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG52bWVDb250cm9sbGVyU2NhbkNvdW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX252bWVDb250cm9sbGVyU2NhbkNvdW50O1xuICB9XG5cbiAgLy8gcmVwbGFjZV90cmlnZ2VyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcGxhY2VUcmlnZ2VyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZXBsYWNlVHJpZ2dlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcGxhY2VfdHJpZ2dlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVwbGFjZVRyaWdnZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlcGxhY2VUcmlnZ2VyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVwbGFjZVRyaWdnZXIoKSB7XG4gICAgdGhpcy5fcmVwbGFjZVRyaWdnZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcGxhY2VUcmlnZ2VySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcGxhY2VUcmlnZ2VyO1xuICB9XG5cbiAgLy8gcnVuX3Rvb2xzX3NjcmlwdHNfYWZ0ZXJfcG93ZXJfb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcnVuVG9vbHNTY3JpcHRzQWZ0ZXJQb3dlck9uPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBydW5Ub29sc1NjcmlwdHNBZnRlclBvd2VyT24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgncnVuX3Rvb2xzX3NjcmlwdHNfYWZ0ZXJfcG93ZXJfb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJ1blRvb2xzU2NyaXB0c0FmdGVyUG93ZXJPbih2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQWZ0ZXJQb3dlck9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UnVuVG9vbHNTY3JpcHRzQWZ0ZXJQb3dlck9uKCkge1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0FmdGVyUG93ZXJPbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQWZ0ZXJQb3dlck9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3J1blRvb2xzU2NyaXB0c0FmdGVyUG93ZXJPbjtcbiAgfVxuXG4gIC8vIHJ1bl90b29sc19zY3JpcHRzX2FmdGVyX3Jlc3VtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ydW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgncnVuX3Rvb2xzX3NjcmlwdHNfYWZ0ZXJfcmVzdW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBydW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSdW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZSgpIHtcbiAgICB0aGlzLl9ydW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcnVuVG9vbHNTY3JpcHRzQWZ0ZXJSZXN1bWU7XG4gIH1cblxuICAvLyBydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3RfcmVib290IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0UmVib290PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFJlYm9vdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3RfcmVib290Jyk7XG4gIH1cbiAgcHVibGljIHNldCBydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFJlYm9vdCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3QgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSdW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFJlYm9vdCgpIHtcbiAgICB0aGlzLl9ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFJlYm9vdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3Q7XG4gIH1cblxuICAvLyBydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc2h1dGRvd24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTaHV0ZG93bj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTaHV0ZG93bigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc2h1dGRvd24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U2h1dGRvd24odmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U2h1dGRvd24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSdW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFNodXRkb3duKCkge1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U2h1dGRvd24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U2h1dGRvd25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTaHV0ZG93bjtcbiAgfVxuXG4gIC8vIHJ1bl90b29sc19zY3JpcHRzX2JlZm9yZV9ndWVzdF9zdGFuZGJ5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTdGFuZGJ5KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3J1bl90b29sc19zY3JpcHRzX2JlZm9yZV9ndWVzdF9zdGFuZGJ5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFN0YW5kYnkodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieSgpIHtcbiAgICB0aGlzLl9ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFN0YW5kYnkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJ1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFN0YW5kYnk7XG4gIH1cblxuICAvLyBzYXRhX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zYXRhQ29udHJvbGxlclNjYW5Db3VudD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdzYXRhX2NvbnRyb2xsZXJfc2Nhbl9jb3VudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3NhdGFDb250cm9sbGVyU2NhbkNvdW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2F0YUNvbnRyb2xsZXJTY2FuQ291bnQoKSB7XG4gICAgdGhpcy5fc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNhdGFDb250cm9sbGVyU2NhbkNvdW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NhdGFDb250cm9sbGVyU2NhbkNvdW50O1xuICB9XG5cbiAgLy8gc2NzaV9idXNfc2hhcmluZyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNjc2lCdXNTaGFyaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc2NzaV9idXNfc2hhcmluZycpO1xuICB9XG5cbiAgLy8gc2NzaV9jb250cm9sbGVyX3NjYW5fY291bnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2NzaUNvbnRyb2xsZXJTY2FuQ291bnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHNjc2lDb250cm9sbGVyU2NhbkNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnc2NzaV9jb250cm9sbGVyX3NjYW5fY291bnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNjc2lDb250cm9sbGVyU2NhbkNvdW50KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9zY3NpQ29udHJvbGxlclNjYW5Db3VudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNjc2lDb250cm9sbGVyU2NhbkNvdW50KCkge1xuICAgIHRoaXMuX3Njc2lDb250cm9sbGVyU2NhbkNvdW50ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzY3NpQ29udHJvbGxlclNjYW5Db3VudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zY3NpQ29udHJvbGxlclNjYW5Db3VudDtcbiAgfVxuXG4gIC8vIHNjc2lfdHlwZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNjc2lUeXBlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc2NzaV90eXBlJyk7XG4gIH1cblxuICAvLyBzdG9yYWdlX3BvbGljeV9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0b3JhZ2VQb2xpY3lJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc3RvcmFnZVBvbGljeUlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc3RvcmFnZV9wb2xpY3lfaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHN0b3JhZ2VQb2xpY3lJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RvcmFnZVBvbGljeUlkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U3RvcmFnZVBvbGljeUlkKCkge1xuICAgIHRoaXMuX3N0b3JhZ2VQb2xpY3lJZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RvcmFnZVBvbGljeUlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N0b3JhZ2VQb2xpY3lJZDtcbiAgfVxuXG4gIC8vIHN3YXBfcGxhY2VtZW50X3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zd2FwUGxhY2VtZW50UG9saWN5Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzd2FwUGxhY2VtZW50UG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc3dhcF9wbGFjZW1lbnRfcG9saWN5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBzd2FwUGxhY2VtZW50UG9saWN5KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zd2FwUGxhY2VtZW50UG9saWN5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U3dhcFBsYWNlbWVudFBvbGljeSgpIHtcbiAgICB0aGlzLl9zd2FwUGxhY2VtZW50UG9saWN5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzd2FwUGxhY2VtZW50UG9saWN5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N3YXBQbGFjZW1lbnRQb2xpY3k7XG4gIH1cblxuICAvLyBzeW5jX3RpbWVfd2l0aF9ob3N0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N5bmNUaW1lV2l0aEhvc3Q/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHN5bmNUaW1lV2l0aEhvc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc3luY190aW1lX3dpdGhfaG9zdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3luY1RpbWVXaXRoSG9zdCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc3luY1RpbWVXaXRoSG9zdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN5bmNUaW1lV2l0aEhvc3QoKSB7XG4gICAgdGhpcy5fc3luY1RpbWVXaXRoSG9zdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3luY1RpbWVXaXRoSG9zdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zeW5jVGltZVdpdGhIb3N0O1xuICB9XG5cbiAgLy8gc3luY190aW1lX3dpdGhfaG9zdF9wZXJpb2RpY2FsbHkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzeW5jX3RpbWVfd2l0aF9ob3N0X3BlcmlvZGljYWxseScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN5bmNUaW1lV2l0aEhvc3RQZXJpb2RpY2FsbHkoKSB7XG4gICAgdGhpcy5fc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zeW5jVGltZVdpdGhIb3N0UGVyaW9kaWNhbGx5O1xuICB9XG5cbiAgLy8gdG9vbHNfdXBncmFkZV9wb2xpY3kgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdG9vbHNVcGdyYWRlUG9saWN5Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0b29sc1VwZ3JhZGVQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0b29sc191cGdyYWRlX3BvbGljeScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdG9vbHNVcGdyYWRlUG9saWN5KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90b29sc1VwZ3JhZGVQb2xpY3kgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUb29sc1VwZ3JhZGVQb2xpY3koKSB7XG4gICAgdGhpcy5fdG9vbHNVcGdyYWRlUG9saWN5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b29sc1VwZ3JhZGVQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdG9vbHNVcGdyYWRlUG9saWN5O1xuICB9XG5cbiAgLy8gdXVpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3V1aWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHV1aWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1dWlkJyk7XG4gIH1cbiAgcHVibGljIHNldCB1dWlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91dWlkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXVpZCgpIHtcbiAgICB0aGlzLl91dWlkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1dWlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3V1aWQ7XG4gIH1cblxuICAvLyB2YXBwX3RyYW5zcG9ydCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHZhcHBUcmFuc3BvcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgndmFwcF90cmFuc3BvcnQnKTtcbiAgfVxuXG4gIC8vIHZic19lbmFibGVkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Zic0VuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHZic0VuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgndmJzX2VuYWJsZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHZic0VuYWJsZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3Zic0VuYWJsZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRWYnNFbmFibGVkKCkge1xuICAgIHRoaXMuX3Zic0VuYWJsZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHZic0VuYWJsZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmJzRW5hYmxlZDtcbiAgfVxuXG4gIC8vIHZ0cG0gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCB2dHBtKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3Z0cG0nKTtcbiAgfVxuXG4gIC8vIHZ2dGRfZW5hYmxlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF92dnRkRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdnZ0ZEVuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgndnZ0ZF9lbmFibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCB2dnRkRW5hYmxlZCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fdnZ0ZEVuYWJsZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRWdnRkRW5hYmxlZCgpIHtcbiAgICB0aGlzLl92dnRkRW5hYmxlZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdnZ0ZEVuYWJsZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdnZ0ZEVuYWJsZWQ7XG4gIH1cblxuICAvLyB2YXBwIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3ZhcHAgPSBuZXcgRGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZVZhcHBPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ2YXBwXCIpO1xuICBwdWJsaWMgZ2V0IHZhcHAoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZhcHA7XG4gIH1cbiAgcHVibGljIHB1dFZhcHAodmFsdWU6IERhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwKSB7XG4gICAgdGhpcy5fdmFwcC5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VmFwcCgpIHtcbiAgICB0aGlzLl92YXBwLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHZhcHBJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFwcC5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhbHRlcm5hdGVfZ3Vlc3RfbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWx0ZXJuYXRlR3Vlc3ROYW1lKSxcbiAgICAgIGFubm90YXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Fubm90YXRpb24pLFxuICAgICAgYm9vdF9kZWxheTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fYm9vdERlbGF5KSxcbiAgICAgIGJvb3RfcmV0cnlfZGVsYXk6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX2Jvb3RSZXRyeURlbGF5KSxcbiAgICAgIGJvb3RfcmV0cnlfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Jvb3RSZXRyeUVuYWJsZWQpLFxuICAgICAgY3B1X2hvdF9hZGRfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2NwdUhvdEFkZEVuYWJsZWQpLFxuICAgICAgY3B1X2hvdF9yZW1vdmVfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2NwdUhvdFJlbW92ZUVuYWJsZWQpLFxuICAgICAgY3B1X2xpbWl0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9jcHVMaW1pdCksXG4gICAgICBjcHVfcGVyZm9ybWFuY2VfY291bnRlcnNfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2NwdVBlcmZvcm1hbmNlQ291bnRlcnNFbmFibGVkKSxcbiAgICAgIGNwdV9yZXNlcnZhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fY3B1UmVzZXJ2YXRpb24pLFxuICAgICAgY3B1X3NoYXJlX2NvdW50OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9jcHVTaGFyZUNvdW50KSxcbiAgICAgIGNwdV9zaGFyZV9sZXZlbDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY3B1U2hhcmVMZXZlbCksXG4gICAgICBkYXRhY2VudGVyX2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9kYXRhY2VudGVySWQpLFxuICAgICAgZWZpX3NlY3VyZV9ib290X2VuYWJsZWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9lZmlTZWN1cmVCb290RW5hYmxlZCksXG4gICAgICBlbmFibGVfZGlza191dWlkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZW5hYmxlRGlza1V1aWQpLFxuICAgICAgZW5hYmxlX2xvZ2dpbmc6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9lbmFibGVMb2dnaW5nKSxcbiAgICAgIGVwdF9ydmlfbW9kZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZXB0UnZpTW9kZSksXG4gICAgICBleHRyYV9jb25maWc6IGNka3RmLmhhc2hNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0pKHRoaXMuX2V4dHJhQ29uZmlnKSxcbiAgICAgIGV4dHJhX2NvbmZpZ19yZWJvb3RfcmVxdWlyZWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9leHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkKSxcbiAgICAgIGZpcm13YXJlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9maXJtd2FyZSksXG4gICAgICBmb2xkZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2ZvbGRlciksXG4gICAgICBndWVzdF9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZ3Vlc3RJZCksXG4gICAgICBoYXJkd2FyZV92ZXJzaW9uOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9oYXJkd2FyZVZlcnNpb24pLFxuICAgICAgaHZfbW9kZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5faHZNb2RlKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBpZGVfY29udHJvbGxlcl9zY2FuX2NvdW50OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9pZGVDb250cm9sbGVyU2NhbkNvdW50KSxcbiAgICAgIGxhdGVuY3lfc2Vuc2l0aXZpdHk6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2xhdGVuY3lTZW5zaXRpdml0eSksXG4gICAgICBtZW1vcnk6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX21lbW9yeSksXG4gICAgICBtZW1vcnlfaG90X2FkZF9lbmFibGVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fbWVtb3J5SG90QWRkRW5hYmxlZCksXG4gICAgICBtZW1vcnlfbGltaXQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX21lbW9yeUxpbWl0KSxcbiAgICAgIG1lbW9yeV9yZXNlcnZhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbWVtb3J5UmVzZXJ2YXRpb24pLFxuICAgICAgbWVtb3J5X3Jlc2VydmF0aW9uX2xvY2tlZF90b19tYXg6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbkxvY2tlZFRvTWF4KSxcbiAgICAgIG1lbW9yeV9zaGFyZV9jb3VudDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbWVtb3J5U2hhcmVDb3VudCksXG4gICAgICBtZW1vcnlfc2hhcmVfbGV2ZWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21lbW9yeVNoYXJlTGV2ZWwpLFxuICAgICAgbW9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbW9pZCksXG4gICAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9uYW1lKSxcbiAgICAgIG5lc3RlZF9odl9lbmFibGVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fbmVzdGVkSHZFbmFibGVkKSxcbiAgICAgIG51bV9jb3Jlc19wZXJfc29ja2V0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9udW1Db3Jlc1BlclNvY2tldCksXG4gICAgICBudW1fY3B1czogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbnVtQ3B1cyksXG4gICAgICBudm1lX2NvbnRyb2xsZXJfc2Nhbl9jb3VudDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbnZtZUNvbnRyb2xsZXJTY2FuQ291bnQpLFxuICAgICAgcmVwbGFjZV90cmlnZ2VyOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9yZXBsYWNlVHJpZ2dlciksXG4gICAgICBydW5fdG9vbHNfc2NyaXB0c19hZnRlcl9wb3dlcl9vbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3J1blRvb2xzU2NyaXB0c0FmdGVyUG93ZXJPbiksXG4gICAgICBydW5fdG9vbHNfc2NyaXB0c19hZnRlcl9yZXN1bWU6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9ydW5Ub29sc1NjcmlwdHNBZnRlclJlc3VtZSksXG4gICAgICBydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3RfcmVib290OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RSZWJvb3QpLFxuICAgICAgcnVuX3Rvb2xzX3NjcmlwdHNfYmVmb3JlX2d1ZXN0X3NodXRkb3duOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTaHV0ZG93biksXG4gICAgICBydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc3RhbmRieTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3J1blRvb2xzU2NyaXB0c0JlZm9yZUd1ZXN0U3RhbmRieSksXG4gICAgICBzYXRhX2NvbnRyb2xsZXJfc2Nhbl9jb3VudDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fc2F0YUNvbnRyb2xsZXJTY2FuQ291bnQpLFxuICAgICAgc2NzaV9jb250cm9sbGVyX3NjYW5fY291bnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3Njc2lDb250cm9sbGVyU2NhbkNvdW50KSxcbiAgICAgIHN0b3JhZ2VfcG9saWN5X2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zdG9yYWdlUG9saWN5SWQpLFxuICAgICAgc3dhcF9wbGFjZW1lbnRfcG9saWN5OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zd2FwUGxhY2VtZW50UG9saWN5KSxcbiAgICAgIHN5bmNfdGltZV93aXRoX2hvc3Q6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9zeW5jVGltZVdpdGhIb3N0KSxcbiAgICAgIHN5bmNfdGltZV93aXRoX2hvc3RfcGVyaW9kaWNhbGx5OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc3luY1RpbWVXaXRoSG9zdFBlcmlvZGljYWxseSksXG4gICAgICB0b29sc191cGdyYWRlX3BvbGljeTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdG9vbHNVcGdyYWRlUG9saWN5KSxcbiAgICAgIHV1aWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3V1aWQpLFxuICAgICAgdmJzX2VuYWJsZWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl92YnNFbmFibGVkKSxcbiAgICAgIHZ2dGRfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3Z2dGRFbmFibGVkKSxcbiAgICAgIHZhcHA6IGRhdGFWc3BoZXJlVmlydHVhbE1hY2hpbmVWYXBwVG9UZXJyYWZvcm0odGhpcy5fdmFwcC5pbnRlcm5hbFZhbHVlKSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVIY2xBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBjb25zdCBhdHRycyA9IHtcbiAgICAgIGFsdGVybmF0ZV9ndWVzdF9uYW1lOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9hbHRlcm5hdGVHdWVzdE5hbWUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBhbm5vdGF0aW9uOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9hbm5vdGF0aW9uKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgYm9vdF9kZWxheToge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fYm9vdERlbGF5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgYm9vdF9yZXRyeV9kZWxheToge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fYm9vdFJldHJ5RGVsYXkpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBib290X3JldHJ5X2VuYWJsZWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9ib290UmV0cnlFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGNwdV9ob3RfYWRkX2VuYWJsZWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9jcHVIb3RBZGRFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGNwdV9ob3RfcmVtb3ZlX2VuYWJsZWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9jcHVIb3RSZW1vdmVFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGNwdV9saW1pdDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fY3B1TGltaXQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBjcHVfcGVyZm9ybWFuY2VfY291bnRlcnNfZW5hYmxlZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX2NwdVBlcmZvcm1hbmNlQ291bnRlcnNFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGNwdV9yZXNlcnZhdGlvbjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fY3B1UmVzZXJ2YXRpb24pLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBjcHVfc2hhcmVfY291bnQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX2NwdVNoYXJlQ291bnQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBjcHVfc2hhcmVfbGV2ZWw6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX2NwdVNoYXJlTGV2ZWwpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBkYXRhY2VudGVyX2lkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9kYXRhY2VudGVySWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBlZmlfc2VjdXJlX2Jvb3RfZW5hYmxlZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX2VmaVNlY3VyZUJvb3RFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGVuYWJsZV9kaXNrX3V1aWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9lbmFibGVEaXNrVXVpZCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBlbmFibGVfbG9nZ2luZzoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX2VuYWJsZUxvZ2dpbmcpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJib29sZWFuXCIsXG4gICAgICB9LFxuICAgICAgZXB0X3J2aV9tb2RlOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9lcHRSdmlNb2RlKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgZXh0cmFfY29uZmlnOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5oYXNoTWFwcGVySGNsKGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKSh0aGlzLl9leHRyYUNvbmZpZyksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcIm1hcFwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ01hcFwiLFxuICAgICAgfSxcbiAgICAgIGV4dHJhX2NvbmZpZ19yZWJvb3RfcmVxdWlyZWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9leHRyYUNvbmZpZ1JlYm9vdFJlcXVpcmVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGZpcm13YXJlOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9maXJtd2FyZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIGZvbGRlcjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fZm9sZGVyKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgZ3Vlc3RfaWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX2d1ZXN0SWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBoYXJkd2FyZV92ZXJzaW9uOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9oYXJkd2FyZVZlcnNpb24pLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBodl9tb2RlOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9odk1vZGUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBpZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBpZGVfY29udHJvbGxlcl9zY2FuX2NvdW50OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9pZGVDb250cm9sbGVyU2NhbkNvdW50KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgbGF0ZW5jeV9zZW5zaXRpdml0eToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbGF0ZW5jeVNlbnNpdGl2aXR5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbWVtb3J5OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9tZW1vcnkpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBtZW1vcnlfaG90X2FkZF9lbmFibGVkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fbWVtb3J5SG90QWRkRW5hYmxlZCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBtZW1vcnlfbGltaXQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX21lbW9yeUxpbWl0KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgbWVtb3J5X3Jlc2VydmF0aW9uOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9tZW1vcnlSZXNlcnZhdGlvbiksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcIm51bWJlclwiLFxuICAgICAgfSxcbiAgICAgIG1lbW9yeV9yZXNlcnZhdGlvbl9sb2NrZWRfdG9fbWF4OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fbWVtb3J5UmVzZXJ2YXRpb25Mb2NrZWRUb01heCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBtZW1vcnlfc2hhcmVfY291bnQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX21lbW9yeVNoYXJlQ291bnQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBtZW1vcnlfc2hhcmVfbGV2ZWw6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX21lbW9yeVNoYXJlTGV2ZWwpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBtb2lkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9tb2lkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbmFtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG5lc3RlZF9odl9lbmFibGVkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fbmVzdGVkSHZFbmFibGVkKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIG51bV9jb3Jlc19wZXJfc29ja2V0OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9udW1Db3Jlc1BlclNvY2tldCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcIm51bWJlclwiLFxuICAgICAgfSxcbiAgICAgIG51bV9jcHVzOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9udW1DcHVzKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgbnZtZV9jb250cm9sbGVyX3NjYW5fY291bnQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLm51bWJlclRvSGNsVGVycmFmb3JtKHRoaXMuX252bWVDb250cm9sbGVyU2NhbkNvdW50KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgcmVwbGFjZV90cmlnZ2VyOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9yZXBsYWNlVHJpZ2dlciksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHJ1bl90b29sc19zY3JpcHRzX2FmdGVyX3Bvd2VyX29uOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fcnVuVG9vbHNTY3JpcHRzQWZ0ZXJQb3dlck9uKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHJ1bl90b29sc19zY3JpcHRzX2FmdGVyX3Jlc3VtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX3J1blRvb2xzU2NyaXB0c0FmdGVyUmVzdW1lKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHJ1bl90b29sc19zY3JpcHRzX2JlZm9yZV9ndWVzdF9yZWJvb3Q6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFJlYm9vdCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBydW5fdG9vbHNfc2NyaXB0c19iZWZvcmVfZ3Vlc3Rfc2h1dGRvd246IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9ydW5Ub29sc1NjcmlwdHNCZWZvcmVHdWVzdFNodXRkb3duKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHJ1bl90b29sc19zY3JpcHRzX2JlZm9yZV9ndWVzdF9zdGFuZGJ5OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fcnVuVG9vbHNTY3JpcHRzQmVmb3JlR3Vlc3RTdGFuZGJ5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHNhdGFfY29udHJvbGxlcl9zY2FuX2NvdW50OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9zYXRhQ29udHJvbGxlclNjYW5Db3VudCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcIm51bWJlclwiLFxuICAgICAgfSxcbiAgICAgIHNjc2lfY29udHJvbGxlcl9zY2FuX2NvdW50OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl9zY3NpQ29udHJvbGxlclNjYW5Db3VudCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcIm51bWJlclwiLFxuICAgICAgfSxcbiAgICAgIHN0b3JhZ2VfcG9saWN5X2lkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9zdG9yYWdlUG9saWN5SWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBzd2FwX3BsYWNlbWVudF9wb2xpY3k6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3N3YXBQbGFjZW1lbnRQb2xpY3kpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBzeW5jX3RpbWVfd2l0aF9ob3N0OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fc3luY1RpbWVXaXRoSG9zdCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBzeW5jX3RpbWVfd2l0aF9ob3N0X3BlcmlvZGljYWxseToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX3N5bmNUaW1lV2l0aEhvc3RQZXJpb2RpY2FsbHkpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJib29sZWFuXCIsXG4gICAgICB9LFxuICAgICAgdG9vbHNfdXBncmFkZV9wb2xpY3k6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3Rvb2xzVXBncmFkZVBvbGljeSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHV1aWQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3V1aWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICB2YnNfZW5hYmxlZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX3Zic0VuYWJsZWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJib29sZWFuXCIsXG4gICAgICB9LFxuICAgICAgdnZ0ZF9lbmFibGVkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fdnZ0ZEVuYWJsZWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJib29sZWFuXCIsXG4gICAgICB9LFxuICAgICAgdmFwcDoge1xuICAgICAgICB2YWx1ZTogZGF0YVZzcGhlcmVWaXJ0dWFsTWFjaGluZVZhcHBUb0hjbFRlcnJhZm9ybSh0aGlzLl92YXBwLmludGVybmFsVmFsdWUpLFxuICAgICAgICBpc0Jsb2NrOiB0cnVlLFxuICAgICAgICB0eXBlOiBcImxpc3RcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJEYXRhVnNwaGVyZVZpcnR1YWxNYWNoaW5lVmFwcExpc3RcIixcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIC8vIHJlbW92ZSB1bmRlZmluZWQgYXR0cmlidXRlc1xuICAgIHJldHVybiBPYmplY3QuZnJvbUVudHJpZXMoT2JqZWN0LmVudHJpZXMoYXR0cnMpLmZpbHRlcigoW18sIHZhbHVlXSkgPT4gdmFsdWUgIT09IHVuZGVmaW5lZCAmJiB2YWx1ZS52YWx1ZSAhPT0gdW5kZWZpbmVkICkpXG4gIH1cbn1cbiJdfQ==