/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereVmfsDisksConfig extends cdktf.TerraformMetaArguments {
    /**
    * A regular expression to filter the disks against. Only disks with canonical names that match will be included.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks#filter DataVsphereVmfsDisks#filter}
    */
    readonly filter?: string;
    /**
    * The managed object ID of the host to search for disks on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks#host_system_id DataVsphereVmfsDisks#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks#id DataVsphereVmfsDisks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Rescan the system for disks before querying. This may lengthen the time it takes to gather information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks#rescan DataVsphereVmfsDisks#rescan}
    */
    readonly rescan?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks vsphere_vmfs_disks}
*/
export declare class DataVsphereVmfsDisks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_vmfs_disks";
    /**
    * Generates CDKTF code for importing a DataVsphereVmfsDisks resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereVmfsDisks to import
    * @param importFromId The id of the existing DataVsphereVmfsDisks that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereVmfsDisks to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/data-sources/vmfs_disks vsphere_vmfs_disks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVmfsDisksConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereVmfsDisksConfig);
    get disks(): string[];
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rescan?;
    get rescan(): boolean | cdktf.IResolvable;
    set rescan(value: boolean | cdktf.IResolvable);
    resetRescan(): void;
    get rescanInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
