/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatastoreClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#custom_attributes DatastoreCluster#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The managed object ID of the datacenter to put the datastore cluster in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#datacenter_id DatastoreCluster#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The name of the folder to locate the datastore cluster in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#folder DatastoreCluster#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#id DatastoreCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for the new storage pod.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#name DatastoreCluster#name}
    */
    readonly name: string;
    /**
    * Advanced configuration options for storage DRS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_advanced_options DatastoreCluster#sdrs_advanced_options}
    */
    readonly sdrsAdvancedOptions?: {
        [key: string]: string;
    };
    /**
    * The default automation level for all virtual machines in this storage cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_automation_level DatastoreCluster#sdrs_automation_level}
    */
    readonly sdrsAutomationLevel?: string;
    /**
    * When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_default_intra_vm_affinity DatastoreCluster#sdrs_default_intra_vm_affinity}
    */
    readonly sdrsDefaultIntraVmAffinity?: boolean | cdktf.IResolvable;
    /**
    * Enable storage DRS for this datastore cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_enabled DatastoreCluster#sdrs_enabled}
    */
    readonly sdrsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_free_space_threshold DatastoreCluster#sdrs_free_space_threshold}
    */
    readonly sdrsFreeSpaceThreshold?: number;
    /**
    * The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to freeSpace, drs_free_space_threshold is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_free_space_threshold_mode DatastoreCluster#sdrs_free_space_threshold_mode}
    */
    readonly sdrsFreeSpaceThresholdMode?: string;
    /**
    * The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to balance the space.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_free_space_utilization_difference DatastoreCluster#sdrs_free_space_utilization_difference}
    */
    readonly sdrsFreeSpaceUtilizationDifference?: number;
    /**
    * Overrides the default automation settings when correcting I/O load imbalances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_balance_automation_level DatastoreCluster#sdrs_io_balance_automation_level}
    */
    readonly sdrsIoBalanceAutomationLevel?: string;
    /**
    * The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_latency_threshold DatastoreCluster#sdrs_io_latency_threshold}
    */
    readonly sdrsIoLatencyThreshold?: number;
    /**
    * Enable I/O load balancing for this datastore cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_load_balance_enabled DatastoreCluster#sdrs_io_load_balance_enabled}
    */
    readonly sdrsIoLoadBalanceEnabled?: boolean | cdktf.IResolvable;
    /**
    * The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_load_imbalance_threshold DatastoreCluster#sdrs_io_load_imbalance_threshold}
    */
    readonly sdrsIoLoadImbalanceThreshold?: number;
    /**
    * The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to move VMs off of a datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_reservable_iops_threshold DatastoreCluster#sdrs_io_reservable_iops_threshold}
    */
    readonly sdrsIoReservableIopsThreshold?: number;
    /**
    * The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_reservable_percent_threshold DatastoreCluster#sdrs_io_reservable_percent_threshold}
    */
    readonly sdrsIoReservablePercentThreshold?: number;
    /**
    * The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_io_reservable_threshold_mode DatastoreCluster#sdrs_io_reservable_threshold_mode}
    */
    readonly sdrsIoReservableThresholdMode?: string;
    /**
    * The storage DRS poll interval, in minutes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_load_balance_interval DatastoreCluster#sdrs_load_balance_interval}
    */
    readonly sdrsLoadBalanceInterval?: number;
    /**
    * Overrides the default automation settings when correcting storage and VM policy violations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_policy_enforcement_automation_level DatastoreCluster#sdrs_policy_enforcement_automation_level}
    */
    readonly sdrsPolicyEnforcementAutomationLevel?: string;
    /**
    * Overrides the default automation settings when correcting affinity rule violations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_rule_enforcement_automation_level DatastoreCluster#sdrs_rule_enforcement_automation_level}
    */
    readonly sdrsRuleEnforcementAutomationLevel?: string;
    /**
    * Overrides the default automation settings when correcting disk space imbalances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_space_balance_automation_level DatastoreCluster#sdrs_space_balance_automation_level}
    */
    readonly sdrsSpaceBalanceAutomationLevel?: string;
    /**
    * The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_space_utilization_threshold DatastoreCluster#sdrs_space_utilization_threshold}
    */
    readonly sdrsSpaceUtilizationThreshold?: number;
    /**
    * Overrides the default automation settings when generating recommendations for datastore evacuation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#sdrs_vm_evacuation_automation_level DatastoreCluster#sdrs_vm_evacuation_automation_level}
    */
    readonly sdrsVmEvacuationAutomationLevel?: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#tags DatastoreCluster#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster vsphere_datastore_cluster}
*/
export declare class DatastoreCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_datastore_cluster";
    /**
    * Generates CDKTF code for importing a DatastoreCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatastoreCluster to import
    * @param importFromId The id of the existing DatastoreCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatastoreCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/datastore_cluster vsphere_datastore_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastoreClusterConfig
    */
    constructor(scope: Construct, id: string, config: DatastoreClusterConfig);
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sdrsAdvancedOptions?;
    get sdrsAdvancedOptions(): {
        [key: string]: string;
    };
    set sdrsAdvancedOptions(value: {
        [key: string]: string;
    });
    resetSdrsAdvancedOptions(): void;
    get sdrsAdvancedOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _sdrsAutomationLevel?;
    get sdrsAutomationLevel(): string;
    set sdrsAutomationLevel(value: string);
    resetSdrsAutomationLevel(): void;
    get sdrsAutomationLevelInput(): string | undefined;
    private _sdrsDefaultIntraVmAffinity?;
    get sdrsDefaultIntraVmAffinity(): boolean | cdktf.IResolvable;
    set sdrsDefaultIntraVmAffinity(value: boolean | cdktf.IResolvable);
    resetSdrsDefaultIntraVmAffinity(): void;
    get sdrsDefaultIntraVmAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _sdrsEnabled?;
    get sdrsEnabled(): boolean | cdktf.IResolvable;
    set sdrsEnabled(value: boolean | cdktf.IResolvable);
    resetSdrsEnabled(): void;
    get sdrsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sdrsFreeSpaceThreshold?;
    get sdrsFreeSpaceThreshold(): number;
    set sdrsFreeSpaceThreshold(value: number);
    resetSdrsFreeSpaceThreshold(): void;
    get sdrsFreeSpaceThresholdInput(): number | undefined;
    private _sdrsFreeSpaceThresholdMode?;
    get sdrsFreeSpaceThresholdMode(): string;
    set sdrsFreeSpaceThresholdMode(value: string);
    resetSdrsFreeSpaceThresholdMode(): void;
    get sdrsFreeSpaceThresholdModeInput(): string | undefined;
    private _sdrsFreeSpaceUtilizationDifference?;
    get sdrsFreeSpaceUtilizationDifference(): number;
    set sdrsFreeSpaceUtilizationDifference(value: number);
    resetSdrsFreeSpaceUtilizationDifference(): void;
    get sdrsFreeSpaceUtilizationDifferenceInput(): number | undefined;
    private _sdrsIoBalanceAutomationLevel?;
    get sdrsIoBalanceAutomationLevel(): string;
    set sdrsIoBalanceAutomationLevel(value: string);
    resetSdrsIoBalanceAutomationLevel(): void;
    get sdrsIoBalanceAutomationLevelInput(): string | undefined;
    private _sdrsIoLatencyThreshold?;
    get sdrsIoLatencyThreshold(): number;
    set sdrsIoLatencyThreshold(value: number);
    resetSdrsIoLatencyThreshold(): void;
    get sdrsIoLatencyThresholdInput(): number | undefined;
    private _sdrsIoLoadBalanceEnabled?;
    get sdrsIoLoadBalanceEnabled(): boolean | cdktf.IResolvable;
    set sdrsIoLoadBalanceEnabled(value: boolean | cdktf.IResolvable);
    resetSdrsIoLoadBalanceEnabled(): void;
    get sdrsIoLoadBalanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sdrsIoLoadImbalanceThreshold?;
    get sdrsIoLoadImbalanceThreshold(): number;
    set sdrsIoLoadImbalanceThreshold(value: number);
    resetSdrsIoLoadImbalanceThreshold(): void;
    get sdrsIoLoadImbalanceThresholdInput(): number | undefined;
    private _sdrsIoReservableIopsThreshold?;
    get sdrsIoReservableIopsThreshold(): number;
    set sdrsIoReservableIopsThreshold(value: number);
    resetSdrsIoReservableIopsThreshold(): void;
    get sdrsIoReservableIopsThresholdInput(): number | undefined;
    private _sdrsIoReservablePercentThreshold?;
    get sdrsIoReservablePercentThreshold(): number;
    set sdrsIoReservablePercentThreshold(value: number);
    resetSdrsIoReservablePercentThreshold(): void;
    get sdrsIoReservablePercentThresholdInput(): number | undefined;
    private _sdrsIoReservableThresholdMode?;
    get sdrsIoReservableThresholdMode(): string;
    set sdrsIoReservableThresholdMode(value: string);
    resetSdrsIoReservableThresholdMode(): void;
    get sdrsIoReservableThresholdModeInput(): string | undefined;
    private _sdrsLoadBalanceInterval?;
    get sdrsLoadBalanceInterval(): number;
    set sdrsLoadBalanceInterval(value: number);
    resetSdrsLoadBalanceInterval(): void;
    get sdrsLoadBalanceIntervalInput(): number | undefined;
    private _sdrsPolicyEnforcementAutomationLevel?;
    get sdrsPolicyEnforcementAutomationLevel(): string;
    set sdrsPolicyEnforcementAutomationLevel(value: string);
    resetSdrsPolicyEnforcementAutomationLevel(): void;
    get sdrsPolicyEnforcementAutomationLevelInput(): string | undefined;
    private _sdrsRuleEnforcementAutomationLevel?;
    get sdrsRuleEnforcementAutomationLevel(): string;
    set sdrsRuleEnforcementAutomationLevel(value: string);
    resetSdrsRuleEnforcementAutomationLevel(): void;
    get sdrsRuleEnforcementAutomationLevelInput(): string | undefined;
    private _sdrsSpaceBalanceAutomationLevel?;
    get sdrsSpaceBalanceAutomationLevel(): string;
    set sdrsSpaceBalanceAutomationLevel(value: string);
    resetSdrsSpaceBalanceAutomationLevel(): void;
    get sdrsSpaceBalanceAutomationLevelInput(): string | undefined;
    private _sdrsSpaceUtilizationThreshold?;
    get sdrsSpaceUtilizationThreshold(): number;
    set sdrsSpaceUtilizationThreshold(value: number);
    resetSdrsSpaceUtilizationThreshold(): void;
    get sdrsSpaceUtilizationThresholdInput(): number | undefined;
    private _sdrsVmEvacuationAutomationLevel?;
    get sdrsVmEvacuationAutomationLevel(): string;
    set sdrsVmEvacuationAutomationLevel(value: string);
    resetSdrsVmEvacuationAutomationLevel(): void;
    get sdrsVmEvacuationAutomationLevelInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
