"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributedPortGroup = exports.DistributedPortGroupVlanRangeList = exports.DistributedPortGroupVlanRangeOutputReference = void 0;
exports.distributedPortGroupVlanRangeToTerraform = distributedPortGroupVlanRangeToTerraform;
exports.distributedPortGroupVlanRangeToHclTerraform = distributedPortGroupVlanRangeToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function distributedPortGroupVlanRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_vlan: cdktf.numberToTerraform(struct.maxVlan),
        min_vlan: cdktf.numberToTerraform(struct.minVlan),
    };
}
function distributedPortGroupVlanRangeToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        max_vlan: {
            value: cdktf.numberToHclTerraform(struct.maxVlan),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        min_vlan: {
            value: cdktf.numberToHclTerraform(struct.minVlan),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class DistributedPortGroupVlanRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxVlan = this._maxVlan;
        }
        if (this._minVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.minVlan = this._minVlan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._maxVlan = undefined;
            this._minVlan = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._maxVlan = value.maxVlan;
            this._minVlan = value.minVlan;
        }
    }
    get maxVlan() {
        return this.getNumberAttribute('max_vlan');
    }
    set maxVlan(value) {
        this._maxVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxVlanInput() {
        return this._maxVlan;
    }
    get minVlan() {
        return this.getNumberAttribute('min_vlan');
    }
    set minVlan(value) {
        this._minVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get minVlanInput() {
        return this._minVlan;
    }
}
exports.DistributedPortGroupVlanRangeOutputReference = DistributedPortGroupVlanRangeOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeOutputReference", version: "11.1.1" };
class DistributedPortGroupVlanRangeList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedPortGroupVlanRangeOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedPortGroupVlanRangeList = DistributedPortGroupVlanRangeList;
_b = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeList[_b] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeList", version: "11.1.1" };
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_port_group vsphere_distributed_port_group}
*/
class DistributedPortGroup extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DistributedPortGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DistributedPortGroup to import
    * @param importFromId The id of the existing DistributedPortGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_port_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DistributedPortGroup to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_distributed_port_group", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_port_group vsphere_distributed_port_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedPortGroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_distributed_port_group',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.14.1',
                providerVersionConstraint: '~> 2.13'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // vlan_range - computed: false, optional: true, required: false
        this._vlanRange = new DistributedPortGroupVlanRangeList(this, "vlan_range", true);
        this._activeUplinks = config.activeUplinks;
        this._allowForgedTransmits = config.allowForgedTransmits;
        this._allowMacChanges = config.allowMacChanges;
        this._allowPromiscuous = config.allowPromiscuous;
        this._autoExpand = config.autoExpand;
        this._blockAllPorts = config.blockAllPorts;
        this._blockOverrideAllowed = config.blockOverrideAllowed;
        this._checkBeacon = config.checkBeacon;
        this._customAttributes = config.customAttributes;
        this._description = config.description;
        this._directpathGen2Allowed = config.directpathGen2Allowed;
        this._distributedVirtualSwitchUuid = config.distributedVirtualSwitchUuid;
        this._egressShapingAverageBandwidth = config.egressShapingAverageBandwidth;
        this._egressShapingBurstSize = config.egressShapingBurstSize;
        this._egressShapingEnabled = config.egressShapingEnabled;
        this._egressShapingPeakBandwidth = config.egressShapingPeakBandwidth;
        this._failback = config.failback;
        this._id = config.id;
        this._ingressShapingAverageBandwidth = config.ingressShapingAverageBandwidth;
        this._ingressShapingBurstSize = config.ingressShapingBurstSize;
        this._ingressShapingEnabled = config.ingressShapingEnabled;
        this._ingressShapingPeakBandwidth = config.ingressShapingPeakBandwidth;
        this._lacpEnabled = config.lacpEnabled;
        this._lacpMode = config.lacpMode;
        this._livePortMovingAllowed = config.livePortMovingAllowed;
        this._name = config.name;
        this._netflowEnabled = config.netflowEnabled;
        this._netflowOverrideAllowed = config.netflowOverrideAllowed;
        this._networkResourcePoolKey = config.networkResourcePoolKey;
        this._networkResourcePoolOverrideAllowed = config.networkResourcePoolOverrideAllowed;
        this._notifySwitches = config.notifySwitches;
        this._numberOfPorts = config.numberOfPorts;
        this._portConfigResetAtDisconnect = config.portConfigResetAtDisconnect;
        this._portNameFormat = config.portNameFormat;
        this._portPrivateSecondaryVlanId = config.portPrivateSecondaryVlanId;
        this._securityPolicyOverrideAllowed = config.securityPolicyOverrideAllowed;
        this._shapingOverrideAllowed = config.shapingOverrideAllowed;
        this._standbyUplinks = config.standbyUplinks;
        this._tags = config.tags;
        this._teamingPolicy = config.teamingPolicy;
        this._trafficFilterOverrideAllowed = config.trafficFilterOverrideAllowed;
        this._txUplink = config.txUplink;
        this._type = config.type;
        this._uplinkTeamingOverrideAllowed = config.uplinkTeamingOverrideAllowed;
        this._vlanId = config.vlanId;
        this._vlanOverrideAllowed = config.vlanOverrideAllowed;
        this._vlanRange.internalValue = config.vlanRange;
    }
    get activeUplinks() {
        return this.getListAttribute('active_uplinks');
    }
    set activeUplinks(value) {
        this._activeUplinks = value;
    }
    resetActiveUplinks() {
        this._activeUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeUplinksInput() {
        return this._activeUplinks;
    }
    get allowForgedTransmits() {
        return this.getBooleanAttribute('allow_forged_transmits');
    }
    set allowForgedTransmits(value) {
        this._allowForgedTransmits = value;
    }
    resetAllowForgedTransmits() {
        this._allowForgedTransmits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForgedTransmitsInput() {
        return this._allowForgedTransmits;
    }
    get allowMacChanges() {
        return this.getBooleanAttribute('allow_mac_changes');
    }
    set allowMacChanges(value) {
        this._allowMacChanges = value;
    }
    resetAllowMacChanges() {
        this._allowMacChanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMacChangesInput() {
        return this._allowMacChanges;
    }
    get allowPromiscuous() {
        return this.getBooleanAttribute('allow_promiscuous');
    }
    set allowPromiscuous(value) {
        this._allowPromiscuous = value;
    }
    resetAllowPromiscuous() {
        this._allowPromiscuous = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPromiscuousInput() {
        return this._allowPromiscuous;
    }
    get autoExpand() {
        return this.getBooleanAttribute('auto_expand');
    }
    set autoExpand(value) {
        this._autoExpand = value;
    }
    resetAutoExpand() {
        this._autoExpand = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoExpandInput() {
        return this._autoExpand;
    }
    get blockAllPorts() {
        return this.getBooleanAttribute('block_all_ports');
    }
    set blockAllPorts(value) {
        this._blockAllPorts = value;
    }
    resetBlockAllPorts() {
        this._blockAllPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockAllPortsInput() {
        return this._blockAllPorts;
    }
    get blockOverrideAllowed() {
        return this.getBooleanAttribute('block_override_allowed');
    }
    set blockOverrideAllowed(value) {
        this._blockOverrideAllowed = value;
    }
    resetBlockOverrideAllowed() {
        this._blockOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockOverrideAllowedInput() {
        return this._blockOverrideAllowed;
    }
    get checkBeacon() {
        return this.getBooleanAttribute('check_beacon');
    }
    set checkBeacon(value) {
        this._checkBeacon = value;
    }
    resetCheckBeacon() {
        this._checkBeacon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkBeaconInput() {
        return this._checkBeacon;
    }
    // config_version - computed: true, optional: false, required: false
    get configVersion() {
        return this.getStringAttribute('config_version');
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get directpathGen2Allowed() {
        return this.getBooleanAttribute('directpath_gen2_allowed');
    }
    set directpathGen2Allowed(value) {
        this._directpathGen2Allowed = value;
    }
    resetDirectpathGen2Allowed() {
        this._directpathGen2Allowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get directpathGen2AllowedInput() {
        return this._directpathGen2Allowed;
    }
    get distributedVirtualSwitchUuid() {
        return this.getStringAttribute('distributed_virtual_switch_uuid');
    }
    set distributedVirtualSwitchUuid(value) {
        this._distributedVirtualSwitchUuid = value;
    }
    // Temporarily expose input value. Use with caution.
    get distributedVirtualSwitchUuidInput() {
        return this._distributedVirtualSwitchUuid;
    }
    get egressShapingAverageBandwidth() {
        return this.getNumberAttribute('egress_shaping_average_bandwidth');
    }
    set egressShapingAverageBandwidth(value) {
        this._egressShapingAverageBandwidth = value;
    }
    resetEgressShapingAverageBandwidth() {
        this._egressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingAverageBandwidthInput() {
        return this._egressShapingAverageBandwidth;
    }
    get egressShapingBurstSize() {
        return this.getNumberAttribute('egress_shaping_burst_size');
    }
    set egressShapingBurstSize(value) {
        this._egressShapingBurstSize = value;
    }
    resetEgressShapingBurstSize() {
        this._egressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingBurstSizeInput() {
        return this._egressShapingBurstSize;
    }
    get egressShapingEnabled() {
        return this.getBooleanAttribute('egress_shaping_enabled');
    }
    set egressShapingEnabled(value) {
        this._egressShapingEnabled = value;
    }
    resetEgressShapingEnabled() {
        this._egressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingEnabledInput() {
        return this._egressShapingEnabled;
    }
    get egressShapingPeakBandwidth() {
        return this.getNumberAttribute('egress_shaping_peak_bandwidth');
    }
    set egressShapingPeakBandwidth(value) {
        this._egressShapingPeakBandwidth = value;
    }
    resetEgressShapingPeakBandwidth() {
        this._egressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingPeakBandwidthInput() {
        return this._egressShapingPeakBandwidth;
    }
    get failback() {
        return this.getBooleanAttribute('failback');
    }
    set failback(value) {
        this._failback = value;
    }
    resetFailback() {
        this._failback = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failbackInput() {
        return this._failback;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ingressShapingAverageBandwidth() {
        return this.getNumberAttribute('ingress_shaping_average_bandwidth');
    }
    set ingressShapingAverageBandwidth(value) {
        this._ingressShapingAverageBandwidth = value;
    }
    resetIngressShapingAverageBandwidth() {
        this._ingressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingAverageBandwidthInput() {
        return this._ingressShapingAverageBandwidth;
    }
    get ingressShapingBurstSize() {
        return this.getNumberAttribute('ingress_shaping_burst_size');
    }
    set ingressShapingBurstSize(value) {
        this._ingressShapingBurstSize = value;
    }
    resetIngressShapingBurstSize() {
        this._ingressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingBurstSizeInput() {
        return this._ingressShapingBurstSize;
    }
    get ingressShapingEnabled() {
        return this.getBooleanAttribute('ingress_shaping_enabled');
    }
    set ingressShapingEnabled(value) {
        this._ingressShapingEnabled = value;
    }
    resetIngressShapingEnabled() {
        this._ingressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingEnabledInput() {
        return this._ingressShapingEnabled;
    }
    get ingressShapingPeakBandwidth() {
        return this.getNumberAttribute('ingress_shaping_peak_bandwidth');
    }
    set ingressShapingPeakBandwidth(value) {
        this._ingressShapingPeakBandwidth = value;
    }
    resetIngressShapingPeakBandwidth() {
        this._ingressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingPeakBandwidthInput() {
        return this._ingressShapingPeakBandwidth;
    }
    // key - computed: true, optional: false, required: false
    get key() {
        return this.getStringAttribute('key');
    }
    get lacpEnabled() {
        return this.getBooleanAttribute('lacp_enabled');
    }
    set lacpEnabled(value) {
        this._lacpEnabled = value;
    }
    resetLacpEnabled() {
        this._lacpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpEnabledInput() {
        return this._lacpEnabled;
    }
    get lacpMode() {
        return this.getStringAttribute('lacp_mode');
    }
    set lacpMode(value) {
        this._lacpMode = value;
    }
    resetLacpMode() {
        this._lacpMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpModeInput() {
        return this._lacpMode;
    }
    get livePortMovingAllowed() {
        return this.getBooleanAttribute('live_port_moving_allowed');
    }
    set livePortMovingAllowed(value) {
        this._livePortMovingAllowed = value;
    }
    resetLivePortMovingAllowed() {
        this._livePortMovingAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get livePortMovingAllowedInput() {
        return this._livePortMovingAllowed;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get netflowEnabled() {
        return this.getBooleanAttribute('netflow_enabled');
    }
    set netflowEnabled(value) {
        this._netflowEnabled = value;
    }
    resetNetflowEnabled() {
        this._netflowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowEnabledInput() {
        return this._netflowEnabled;
    }
    get netflowOverrideAllowed() {
        return this.getBooleanAttribute('netflow_override_allowed');
    }
    set netflowOverrideAllowed(value) {
        this._netflowOverrideAllowed = value;
    }
    resetNetflowOverrideAllowed() {
        this._netflowOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowOverrideAllowedInput() {
        return this._netflowOverrideAllowed;
    }
    get networkResourcePoolKey() {
        return this.getStringAttribute('network_resource_pool_key');
    }
    set networkResourcePoolKey(value) {
        this._networkResourcePoolKey = value;
    }
    resetNetworkResourcePoolKey() {
        this._networkResourcePoolKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolKeyInput() {
        return this._networkResourcePoolKey;
    }
    get networkResourcePoolOverrideAllowed() {
        return this.getBooleanAttribute('network_resource_pool_override_allowed');
    }
    set networkResourcePoolOverrideAllowed(value) {
        this._networkResourcePoolOverrideAllowed = value;
    }
    resetNetworkResourcePoolOverrideAllowed() {
        this._networkResourcePoolOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolOverrideAllowedInput() {
        return this._networkResourcePoolOverrideAllowed;
    }
    get notifySwitches() {
        return this.getBooleanAttribute('notify_switches');
    }
    set notifySwitches(value) {
        this._notifySwitches = value;
    }
    resetNotifySwitches() {
        this._notifySwitches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifySwitchesInput() {
        return this._notifySwitches;
    }
    get numberOfPorts() {
        return this.getNumberAttribute('number_of_ports');
    }
    set numberOfPorts(value) {
        this._numberOfPorts = value;
    }
    resetNumberOfPorts() {
        this._numberOfPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberOfPortsInput() {
        return this._numberOfPorts;
    }
    get portConfigResetAtDisconnect() {
        return this.getBooleanAttribute('port_config_reset_at_disconnect');
    }
    set portConfigResetAtDisconnect(value) {
        this._portConfigResetAtDisconnect = value;
    }
    resetPortConfigResetAtDisconnect() {
        this._portConfigResetAtDisconnect = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portConfigResetAtDisconnectInput() {
        return this._portConfigResetAtDisconnect;
    }
    get portNameFormat() {
        return this.getStringAttribute('port_name_format');
    }
    set portNameFormat(value) {
        this._portNameFormat = value;
    }
    resetPortNameFormat() {
        this._portNameFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameFormatInput() {
        return this._portNameFormat;
    }
    get portPrivateSecondaryVlanId() {
        return this.getNumberAttribute('port_private_secondary_vlan_id');
    }
    set portPrivateSecondaryVlanId(value) {
        this._portPrivateSecondaryVlanId = value;
    }
    resetPortPrivateSecondaryVlanId() {
        this._portPrivateSecondaryVlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portPrivateSecondaryVlanIdInput() {
        return this._portPrivateSecondaryVlanId;
    }
    get securityPolicyOverrideAllowed() {
        return this.getBooleanAttribute('security_policy_override_allowed');
    }
    set securityPolicyOverrideAllowed(value) {
        this._securityPolicyOverrideAllowed = value;
    }
    resetSecurityPolicyOverrideAllowed() {
        this._securityPolicyOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityPolicyOverrideAllowedInput() {
        return this._securityPolicyOverrideAllowed;
    }
    get shapingOverrideAllowed() {
        return this.getBooleanAttribute('shaping_override_allowed');
    }
    set shapingOverrideAllowed(value) {
        this._shapingOverrideAllowed = value;
    }
    resetShapingOverrideAllowed() {
        this._shapingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingOverrideAllowedInput() {
        return this._shapingOverrideAllowed;
    }
    get standbyUplinks() {
        return this.getListAttribute('standby_uplinks');
    }
    set standbyUplinks(value) {
        this._standbyUplinks = value;
    }
    resetStandbyUplinks() {
        this._standbyUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyUplinksInput() {
        return this._standbyUplinks;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get teamingPolicy() {
        return this.getStringAttribute('teaming_policy');
    }
    set teamingPolicy(value) {
        this._teamingPolicy = value;
    }
    resetTeamingPolicy() {
        this._teamingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamingPolicyInput() {
        return this._teamingPolicy;
    }
    get trafficFilterOverrideAllowed() {
        return this.getBooleanAttribute('traffic_filter_override_allowed');
    }
    set trafficFilterOverrideAllowed(value) {
        this._trafficFilterOverrideAllowed = value;
    }
    resetTrafficFilterOverrideAllowed() {
        this._trafficFilterOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trafficFilterOverrideAllowedInput() {
        return this._trafficFilterOverrideAllowed;
    }
    get txUplink() {
        return this.getBooleanAttribute('tx_uplink');
    }
    set txUplink(value) {
        this._txUplink = value;
    }
    resetTxUplink() {
        this._txUplink = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get txUplinkInput() {
        return this._txUplink;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get uplinkTeamingOverrideAllowed() {
        return this.getBooleanAttribute('uplink_teaming_override_allowed');
    }
    set uplinkTeamingOverrideAllowed(value) {
        this._uplinkTeamingOverrideAllowed = value;
    }
    resetUplinkTeamingOverrideAllowed() {
        this._uplinkTeamingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uplinkTeamingOverrideAllowedInput() {
        return this._uplinkTeamingOverrideAllowed;
    }
    get vlanId() {
        return this.getNumberAttribute('vlan_id');
    }
    set vlanId(value) {
        this._vlanId = value;
    }
    resetVlanId() {
        this._vlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanIdInput() {
        return this._vlanId;
    }
    get vlanOverrideAllowed() {
        return this.getBooleanAttribute('vlan_override_allowed');
    }
    set vlanOverrideAllowed(value) {
        this._vlanOverrideAllowed = value;
    }
    resetVlanOverrideAllowed() {
        this._vlanOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanOverrideAllowedInput() {
        return this._vlanOverrideAllowed;
    }
    get vlanRange() {
        return this._vlanRange;
    }
    putVlanRange(value) {
        this._vlanRange.internalValue = value;
    }
    resetVlanRange() {
        this._vlanRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanRangeInput() {
        return this._vlanRange.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            active_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._activeUplinks),
            allow_forged_transmits: cdktf.booleanToTerraform(this._allowForgedTransmits),
            allow_mac_changes: cdktf.booleanToTerraform(this._allowMacChanges),
            allow_promiscuous: cdktf.booleanToTerraform(this._allowPromiscuous),
            auto_expand: cdktf.booleanToTerraform(this._autoExpand),
            block_all_ports: cdktf.booleanToTerraform(this._blockAllPorts),
            block_override_allowed: cdktf.booleanToTerraform(this._blockOverrideAllowed),
            check_beacon: cdktf.booleanToTerraform(this._checkBeacon),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            description: cdktf.stringToTerraform(this._description),
            directpath_gen2_allowed: cdktf.booleanToTerraform(this._directpathGen2Allowed),
            distributed_virtual_switch_uuid: cdktf.stringToTerraform(this._distributedVirtualSwitchUuid),
            egress_shaping_average_bandwidth: cdktf.numberToTerraform(this._egressShapingAverageBandwidth),
            egress_shaping_burst_size: cdktf.numberToTerraform(this._egressShapingBurstSize),
            egress_shaping_enabled: cdktf.booleanToTerraform(this._egressShapingEnabled),
            egress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._egressShapingPeakBandwidth),
            failback: cdktf.booleanToTerraform(this._failback),
            id: cdktf.stringToTerraform(this._id),
            ingress_shaping_average_bandwidth: cdktf.numberToTerraform(this._ingressShapingAverageBandwidth),
            ingress_shaping_burst_size: cdktf.numberToTerraform(this._ingressShapingBurstSize),
            ingress_shaping_enabled: cdktf.booleanToTerraform(this._ingressShapingEnabled),
            ingress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._ingressShapingPeakBandwidth),
            lacp_enabled: cdktf.booleanToTerraform(this._lacpEnabled),
            lacp_mode: cdktf.stringToTerraform(this._lacpMode),
            live_port_moving_allowed: cdktf.booleanToTerraform(this._livePortMovingAllowed),
            name: cdktf.stringToTerraform(this._name),
            netflow_enabled: cdktf.booleanToTerraform(this._netflowEnabled),
            netflow_override_allowed: cdktf.booleanToTerraform(this._netflowOverrideAllowed),
            network_resource_pool_key: cdktf.stringToTerraform(this._networkResourcePoolKey),
            network_resource_pool_override_allowed: cdktf.booleanToTerraform(this._networkResourcePoolOverrideAllowed),
            notify_switches: cdktf.booleanToTerraform(this._notifySwitches),
            number_of_ports: cdktf.numberToTerraform(this._numberOfPorts),
            port_config_reset_at_disconnect: cdktf.booleanToTerraform(this._portConfigResetAtDisconnect),
            port_name_format: cdktf.stringToTerraform(this._portNameFormat),
            port_private_secondary_vlan_id: cdktf.numberToTerraform(this._portPrivateSecondaryVlanId),
            security_policy_override_allowed: cdktf.booleanToTerraform(this._securityPolicyOverrideAllowed),
            shaping_override_allowed: cdktf.booleanToTerraform(this._shapingOverrideAllowed),
            standby_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._standbyUplinks),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            teaming_policy: cdktf.stringToTerraform(this._teamingPolicy),
            traffic_filter_override_allowed: cdktf.booleanToTerraform(this._trafficFilterOverrideAllowed),
            tx_uplink: cdktf.booleanToTerraform(this._txUplink),
            type: cdktf.stringToTerraform(this._type),
            uplink_teaming_override_allowed: cdktf.booleanToTerraform(this._uplinkTeamingOverrideAllowed),
            vlan_id: cdktf.numberToTerraform(this._vlanId),
            vlan_override_allowed: cdktf.booleanToTerraform(this._vlanOverrideAllowed),
            vlan_range: cdktf.listMapper(distributedPortGroupVlanRangeToTerraform, true)(this._vlanRange.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            active_uplinks: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._activeUplinks),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            allow_forged_transmits: {
                value: cdktf.booleanToHclTerraform(this._allowForgedTransmits),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            allow_mac_changes: {
                value: cdktf.booleanToHclTerraform(this._allowMacChanges),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            allow_promiscuous: {
                value: cdktf.booleanToHclTerraform(this._allowPromiscuous),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            auto_expand: {
                value: cdktf.booleanToHclTerraform(this._autoExpand),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            block_all_ports: {
                value: cdktf.booleanToHclTerraform(this._blockAllPorts),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            block_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._blockOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            check_beacon: {
                value: cdktf.booleanToHclTerraform(this._checkBeacon),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            description: {
                value: cdktf.stringToHclTerraform(this._description),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            directpath_gen2_allowed: {
                value: cdktf.booleanToHclTerraform(this._directpathGen2Allowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            distributed_virtual_switch_uuid: {
                value: cdktf.stringToHclTerraform(this._distributedVirtualSwitchUuid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            egress_shaping_average_bandwidth: {
                value: cdktf.numberToHclTerraform(this._egressShapingAverageBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            egress_shaping_burst_size: {
                value: cdktf.numberToHclTerraform(this._egressShapingBurstSize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            egress_shaping_enabled: {
                value: cdktf.booleanToHclTerraform(this._egressShapingEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            egress_shaping_peak_bandwidth: {
                value: cdktf.numberToHclTerraform(this._egressShapingPeakBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            failback: {
                value: cdktf.booleanToHclTerraform(this._failback),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ingress_shaping_average_bandwidth: {
                value: cdktf.numberToHclTerraform(this._ingressShapingAverageBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ingress_shaping_burst_size: {
                value: cdktf.numberToHclTerraform(this._ingressShapingBurstSize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ingress_shaping_enabled: {
                value: cdktf.booleanToHclTerraform(this._ingressShapingEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ingress_shaping_peak_bandwidth: {
                value: cdktf.numberToHclTerraform(this._ingressShapingPeakBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            lacp_enabled: {
                value: cdktf.booleanToHclTerraform(this._lacpEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            lacp_mode: {
                value: cdktf.stringToHclTerraform(this._lacpMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            live_port_moving_allowed: {
                value: cdktf.booleanToHclTerraform(this._livePortMovingAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            netflow_enabled: {
                value: cdktf.booleanToHclTerraform(this._netflowEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            netflow_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._netflowOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            network_resource_pool_key: {
                value: cdktf.stringToHclTerraform(this._networkResourcePoolKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            network_resource_pool_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._networkResourcePoolOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            notify_switches: {
                value: cdktf.booleanToHclTerraform(this._notifySwitches),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            number_of_ports: {
                value: cdktf.numberToHclTerraform(this._numberOfPorts),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            port_config_reset_at_disconnect: {
                value: cdktf.booleanToHclTerraform(this._portConfigResetAtDisconnect),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            port_name_format: {
                value: cdktf.stringToHclTerraform(this._portNameFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            port_private_secondary_vlan_id: {
                value: cdktf.numberToHclTerraform(this._portPrivateSecondaryVlanId),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            security_policy_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._securityPolicyOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            shaping_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._shapingOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            standby_uplinks: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._standbyUplinks),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            teaming_policy: {
                value: cdktf.stringToHclTerraform(this._teamingPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            traffic_filter_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._trafficFilterOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tx_uplink: {
                value: cdktf.booleanToHclTerraform(this._txUplink),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            type: {
                value: cdktf.stringToHclTerraform(this._type),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            uplink_teaming_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._uplinkTeamingOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vlan_id: {
                value: cdktf.numberToHclTerraform(this._vlanId),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            vlan_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._vlanOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vlan_range: {
                value: cdktf.listMapperHcl(distributedPortGroupVlanRangeToHclTerraform, true)(this._vlanRange.internalValue),
                isBlock: true,
                type: "set",
                storageClassType: "DistributedPortGroupVlanRangeList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DistributedPortGroup = DistributedPortGroup;
_c = JSII_RTTI_SYMBOL_1;
DistributedPortGroup[_c] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroup", version: "11.1.1" };
// =================
// STATIC PROPERTIES
// =================
DistributedPortGroup.tfResourceType = "vsphere_distributed_port_group";
//# sourceMappingURL=data:application/json;base64,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