/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DistributedVirtualSwitchPvlanMappingAConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the distributed virtual switch to attach this mapping to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#distributed_virtual_switch_id DistributedVirtualSwitchPvlanMappingA#distributed_virtual_switch_id}
    */
    readonly distributedVirtualSwitchId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#id DistributedVirtualSwitchPvlanMappingA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#primary_vlan_id DistributedVirtualSwitchPvlanMappingA#primary_vlan_id}
    */
    readonly primaryVlanId: number;
    /**
    * The private VLAN type. Valid values are promiscuous, community and isolated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#pvlan_type DistributedVirtualSwitchPvlanMappingA#pvlan_type}
    */
    readonly pvlanType: string;
    /**
    * The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#secondary_vlan_id DistributedVirtualSwitchPvlanMappingA#secondary_vlan_id}
    */
    readonly secondaryVlanId: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping vsphere_distributed_virtual_switch_pvlan_mapping}
*/
export declare class DistributedVirtualSwitchPvlanMappingA extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_distributed_virtual_switch_pvlan_mapping";
    /**
    * Generates CDKTF code for importing a DistributedVirtualSwitchPvlanMappingA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DistributedVirtualSwitchPvlanMappingA to import
    * @param importFromId The id of the existing DistributedVirtualSwitchPvlanMappingA that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DistributedVirtualSwitchPvlanMappingA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/distributed_virtual_switch_pvlan_mapping vsphere_distributed_virtual_switch_pvlan_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedVirtualSwitchPvlanMappingAConfig
    */
    constructor(scope: Construct, id: string, config: DistributedVirtualSwitchPvlanMappingAConfig);
    private _distributedVirtualSwitchId?;
    get distributedVirtualSwitchId(): string;
    set distributedVirtualSwitchId(value: string);
    get distributedVirtualSwitchIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _primaryVlanId?;
    get primaryVlanId(): number;
    set primaryVlanId(value: number);
    get primaryVlanIdInput(): number | undefined;
    private _pvlanType?;
    get pvlanType(): string;
    set pvlanType(value: string);
    get pvlanTypeInput(): string | undefined;
    private _secondaryVlanId?;
    get secondaryVlanId(): number;
    set secondaryVlanId(value: number);
    get secondaryVlanIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
