/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DpmHostOverrideConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#compute_cluster_id DpmHostOverride#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * The automation level for power operations on this host. Can be one of manual or automated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#dpm_automation_level DpmHostOverride#dpm_automation_level}
    */
    readonly dpmAutomationLevel?: string;
    /**
    * Enable DPM for this host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#dpm_enabled DpmHostOverride#dpm_enabled}
    */
    readonly dpmEnabled?: boolean | cdktf.IResolvable;
    /**
    * The managed object ID of the host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#host_system_id DpmHostOverride#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#id DpmHostOverride#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override vsphere_dpm_host_override}
*/
export declare class DpmHostOverride extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_dpm_host_override";
    /**
    * Generates CDKTF code for importing a DpmHostOverride resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DpmHostOverride to import
    * @param importFromId The id of the existing DpmHostOverride that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DpmHostOverride to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/dpm_host_override vsphere_dpm_host_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DpmHostOverrideConfig
    */
    constructor(scope: Construct, id: string, config: DpmHostOverrideConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _dpmAutomationLevel?;
    get dpmAutomationLevel(): string;
    set dpmAutomationLevel(value: string);
    resetDpmAutomationLevel(): void;
    get dpmAutomationLevelInput(): string | undefined;
    private _dpmEnabled?;
    get dpmEnabled(): boolean | cdktf.IResolvable;
    set dpmEnabled(value: boolean | cdktf.IResolvable);
    resetDpmEnabled(): void;
    get dpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
