/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to create the parent directories of the destination file if they do not exist.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#create_directories File#create_directories}
    */
    readonly createDirectories?: boolean | cdktf.IResolvable;
    /**
    * The name of a datacenter to which the file will be uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#datacenter File#datacenter}
    */
    readonly datacenter?: string;
    /**
    * The name of the datastore to which to upload the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#datastore File#datastore}
    */
    readonly datastore: string;
    /**
    * The path to where the file should be uploaded or copied to on the destination datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#destination_file File#destination_file}
    */
    readonly destinationFile: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#id File#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a datacenter from which the file will be copied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#source_datacenter File#source_datacenter}
    */
    readonly sourceDatacenter?: string;
    /**
    * The name of the datastore from which file will be copied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#source_datastore File#source_datastore}
    */
    readonly sourceDatastore?: string;
    /**
    * The path to the file being uploaded from or copied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#source_file File#source_file}
    */
    readonly sourceFile: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file vsphere_file}
*/
export declare class File extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_file";
    /**
    * Generates CDKTF code for importing a File resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the File to import
    * @param importFromId The id of the existing File that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the File to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/file vsphere_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileConfig
    */
    constructor(scope: Construct, id: string, config: FileConfig);
    private _createDirectories?;
    get createDirectories(): boolean | cdktf.IResolvable;
    set createDirectories(value: boolean | cdktf.IResolvable);
    resetCreateDirectories(): void;
    get createDirectoriesInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _datastore?;
    get datastore(): string;
    set datastore(value: string);
    get datastoreInput(): string | undefined;
    private _destinationFile?;
    get destinationFile(): string;
    set destinationFile(value: string);
    get destinationFileInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sourceDatacenter?;
    get sourceDatacenter(): string;
    set sourceDatacenter(value: string);
    resetSourceDatacenter(): void;
    get sourceDatacenterInput(): string | undefined;
    private _sourceDatastore?;
    get sourceDatastore(): string;
    set sourceDatastore(value: string);
    resetSourceDatastore(): void;
    get sourceDatastoreInput(): string | undefined;
    private _sourceFile?;
    get sourceFile(): string;
    set sourceFile(value: string);
    get sourceFileInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
