/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GuestOsCustomizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description for the customization specification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#description GuestOsCustomization#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#id GuestOsCustomization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the customization specification is the unique identifier per vCenter Server instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#name GuestOsCustomization#name}
    */
    readonly name: string;
    /**
    * The type of customization specification: One among: Windows, Linux.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#type GuestOsCustomization#type}
    */
    readonly type: string;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#spec GuestOsCustomization#spec}
    */
    readonly spec: GuestOsCustomizationSpec;
}
export interface GuestOsCustomizationSpecLinuxOptions {
    /**
    * The domain name for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#domain GuestOsCustomization#domain}
    */
    readonly domain: string;
    /**
    * The hostname for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#host_name GuestOsCustomization#host_name}
    */
    readonly hostName: string;
    /**
    * Specifies whether or not the hardware clock should be in UTC or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#hw_clock_utc GuestOsCustomization#hw_clock_utc}
    */
    readonly hwClockUtc?: boolean | cdktf.IResolvable;
    /**
    * The customization script to run before and or after guest customization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#script_text GuestOsCustomization#script_text}
    */
    readonly scriptText?: string;
    /**
    * Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#time_zone GuestOsCustomization#time_zone}
    */
    readonly timeZone?: string;
}
export declare function guestOsCustomizationSpecLinuxOptionsToTerraform(struct?: GuestOsCustomizationSpecLinuxOptionsOutputReference | GuestOsCustomizationSpecLinuxOptions): any;
export declare function guestOsCustomizationSpecLinuxOptionsToHclTerraform(struct?: GuestOsCustomizationSpecLinuxOptionsOutputReference | GuestOsCustomizationSpecLinuxOptions): any;
export declare class GuestOsCustomizationSpecLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GuestOsCustomizationSpecLinuxOptions | undefined;
    set internalValue(value: GuestOsCustomizationSpecLinuxOptions | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _hwClockUtc?;
    get hwClockUtc(): boolean | cdktf.IResolvable;
    set hwClockUtc(value: boolean | cdktf.IResolvable);
    resetHwClockUtc(): void;
    get hwClockUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _scriptText?;
    get scriptText(): string;
    set scriptText(value: string);
    resetScriptText(): void;
    get scriptTextInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export interface GuestOsCustomizationSpecNetworkInterface {
    /**
    * A DNS search domain to add to the DNS configuration on the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#dns_domain GuestOsCustomization#dns_domain}
    */
    readonly dnsDomain?: string;
    /**
    * Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#dns_server_list GuestOsCustomization#dns_server_list}
    */
    readonly dnsServerList?: string[];
    /**
    * The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv4_address GuestOsCustomization#ipv4_address}
    */
    readonly ipv4Address?: string;
    /**
    * The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv4_netmask GuestOsCustomization#ipv4_netmask}
    */
    readonly ipv4Netmask?: number;
    /**
    * The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv6_address GuestOsCustomization#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv6_netmask GuestOsCustomization#ipv6_netmask}
    */
    readonly ipv6Netmask?: number;
}
export declare function guestOsCustomizationSpecNetworkInterfaceToTerraform(struct?: GuestOsCustomizationSpecNetworkInterface | cdktf.IResolvable): any;
export declare function guestOsCustomizationSpecNetworkInterfaceToHclTerraform(struct?: GuestOsCustomizationSpecNetworkInterface | cdktf.IResolvable): any;
export declare class GuestOsCustomizationSpecNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GuestOsCustomizationSpecNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GuestOsCustomizationSpecNetworkInterface | cdktf.IResolvable | undefined);
    private _dnsDomain?;
    get dnsDomain(): string;
    set dnsDomain(value: string);
    resetDnsDomain(): void;
    get dnsDomainInput(): string | undefined;
    private _dnsServerList?;
    get dnsServerList(): string[];
    set dnsServerList(value: string[]);
    resetDnsServerList(): void;
    get dnsServerListInput(): string[] | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    resetIpv4Address(): void;
    get ipv4AddressInput(): string | undefined;
    private _ipv4Netmask?;
    get ipv4Netmask(): number;
    set ipv4Netmask(value: number);
    resetIpv4Netmask(): void;
    get ipv4NetmaskInput(): number | undefined;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    private _ipv6Netmask?;
    get ipv6Netmask(): number;
    set ipv6Netmask(value: number);
    resetIpv6Netmask(): void;
    get ipv6NetmaskInput(): number | undefined;
}
export declare class GuestOsCustomizationSpecNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GuestOsCustomizationSpecNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GuestOsCustomizationSpecNetworkInterfaceOutputReference;
}
export interface GuestOsCustomizationSpecWindowsOptions {
    /**
    * The new administrator password for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#admin_password GuestOsCustomization#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Specifies whether or not the VM automatically logs on as Administrator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#auto_logon GuestOsCustomization#auto_logon}
    */
    readonly autoLogon?: boolean | cdktf.IResolvable;
    /**
    * Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#auto_logon_count GuestOsCustomization#auto_logon_count}
    */
    readonly autoLogonCount?: number;
    /**
    * The host name for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#computer_name GuestOsCustomization#computer_name}
    */
    readonly computerName: string;
    /**
    * The password of the domain administrator used to join this virtual machine to the domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#domain_admin_password GuestOsCustomization#domain_admin_password}
    */
    readonly domainAdminPassword?: string;
    /**
    * The user account of the domain administrator used to join this virtual machine to the domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#domain_admin_user GuestOsCustomization#domain_admin_user}
    */
    readonly domainAdminUser?: string;
    /**
    * The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#domain_ou GuestOsCustomization#domain_ou}
    */
    readonly domainOu?: string;
    /**
    * The full name of the user of this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#full_name GuestOsCustomization#full_name}
    */
    readonly fullName?: string;
    /**
    * The domain that the virtual machine should join.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#join_domain GuestOsCustomization#join_domain}
    */
    readonly joinDomain?: string;
    /**
    * The organization name this virtual machine is being installed for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#organization_name GuestOsCustomization#organization_name}
    */
    readonly organizationName?: string;
    /**
    * The product key for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#product_key GuestOsCustomization#product_key}
    */
    readonly productKey?: string;
    /**
    * A list of commands to run at first user logon, after guest customization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#run_once_command_list GuestOsCustomization#run_once_command_list}
    */
    readonly runOnceCommandList?: string[];
    /**
    * The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#time_zone GuestOsCustomization#time_zone}
    */
    readonly timeZone?: number;
    /**
    * The workgroup for this virtual machine if not joining a domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#workgroup GuestOsCustomization#workgroup}
    */
    readonly workgroup?: string;
}
export declare function guestOsCustomizationSpecWindowsOptionsToTerraform(struct?: GuestOsCustomizationSpecWindowsOptionsOutputReference | GuestOsCustomizationSpecWindowsOptions): any;
export declare function guestOsCustomizationSpecWindowsOptionsToHclTerraform(struct?: GuestOsCustomizationSpecWindowsOptionsOutputReference | GuestOsCustomizationSpecWindowsOptions): any;
export declare class GuestOsCustomizationSpecWindowsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GuestOsCustomizationSpecWindowsOptions | undefined;
    set internalValue(value: GuestOsCustomizationSpecWindowsOptions | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _autoLogon?;
    get autoLogon(): boolean | cdktf.IResolvable;
    set autoLogon(value: boolean | cdktf.IResolvable);
    resetAutoLogon(): void;
    get autoLogonInput(): boolean | cdktf.IResolvable | undefined;
    private _autoLogonCount?;
    get autoLogonCount(): number;
    set autoLogonCount(value: number);
    resetAutoLogonCount(): void;
    get autoLogonCountInput(): number | undefined;
    private _computerName?;
    get computerName(): string;
    set computerName(value: string);
    get computerNameInput(): string | undefined;
    private _domainAdminPassword?;
    get domainAdminPassword(): string;
    set domainAdminPassword(value: string);
    resetDomainAdminPassword(): void;
    get domainAdminPasswordInput(): string | undefined;
    private _domainAdminUser?;
    get domainAdminUser(): string;
    set domainAdminUser(value: string);
    resetDomainAdminUser(): void;
    get domainAdminUserInput(): string | undefined;
    private _domainOu?;
    get domainOu(): string;
    set domainOu(value: string);
    resetDomainOu(): void;
    get domainOuInput(): string | undefined;
    private _fullName?;
    get fullName(): string;
    set fullName(value: string);
    resetFullName(): void;
    get fullNameInput(): string | undefined;
    private _joinDomain?;
    get joinDomain(): string;
    set joinDomain(value: string);
    resetJoinDomain(): void;
    get joinDomainInput(): string | undefined;
    private _organizationName?;
    get organizationName(): string;
    set organizationName(value: string);
    resetOrganizationName(): void;
    get organizationNameInput(): string | undefined;
    private _productKey?;
    get productKey(): string;
    set productKey(value: string);
    resetProductKey(): void;
    get productKeyInput(): string | undefined;
    private _runOnceCommandList?;
    get runOnceCommandList(): string[];
    set runOnceCommandList(value: string[]);
    resetRunOnceCommandList(): void;
    get runOnceCommandListInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): number;
    set timeZone(value: number);
    resetTimeZone(): void;
    get timeZoneInput(): number | undefined;
    private _workgroup?;
    get workgroup(): string;
    set workgroup(value: string);
    resetWorkgroup(): void;
    get workgroupInput(): string | undefined;
}
export interface GuestOsCustomizationSpec {
    /**
    * The list of DNS servers for a virtual network adapter with a static IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#dns_server_list GuestOsCustomization#dns_server_list}
    */
    readonly dnsServerList?: string[];
    /**
    * A list of DNS search domains to add to the DNS configuration on the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#dns_suffix_list GuestOsCustomization#dns_suffix_list}
    */
    readonly dnsSuffixList?: string[];
    /**
    * The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv4_gateway GuestOsCustomization#ipv4_gateway}
    */
    readonly ipv4Gateway?: string;
    /**
    * The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#ipv6_gateway GuestOsCustomization#ipv6_gateway}
    */
    readonly ipv6Gateway?: string;
    /**
    * Use this option to specify a windows sysprep file directly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#windows_sysprep_text GuestOsCustomization#windows_sysprep_text}
    */
    readonly windowsSysprepText?: string;
    /**
    * linux_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#linux_options GuestOsCustomization#linux_options}
    */
    readonly linuxOptions?: GuestOsCustomizationSpecLinuxOptions;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#network_interface GuestOsCustomization#network_interface}
    */
    readonly networkInterface?: GuestOsCustomizationSpecNetworkInterface[] | cdktf.IResolvable;
    /**
    * windows_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#windows_options GuestOsCustomization#windows_options}
    */
    readonly windowsOptions?: GuestOsCustomizationSpecWindowsOptions;
}
export declare function guestOsCustomizationSpecToTerraform(struct?: GuestOsCustomizationSpecOutputReference | GuestOsCustomizationSpec): any;
export declare function guestOsCustomizationSpecToHclTerraform(struct?: GuestOsCustomizationSpecOutputReference | GuestOsCustomizationSpec): any;
export declare class GuestOsCustomizationSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GuestOsCustomizationSpec | undefined;
    set internalValue(value: GuestOsCustomizationSpec | undefined);
    private _dnsServerList?;
    get dnsServerList(): string[];
    set dnsServerList(value: string[]);
    resetDnsServerList(): void;
    get dnsServerListInput(): string[] | undefined;
    private _dnsSuffixList?;
    get dnsSuffixList(): string[];
    set dnsSuffixList(value: string[]);
    resetDnsSuffixList(): void;
    get dnsSuffixListInput(): string[] | undefined;
    private _ipv4Gateway?;
    get ipv4Gateway(): string;
    set ipv4Gateway(value: string);
    resetIpv4Gateway(): void;
    get ipv4GatewayInput(): string | undefined;
    private _ipv6Gateway?;
    get ipv6Gateway(): string;
    set ipv6Gateway(value: string);
    resetIpv6Gateway(): void;
    get ipv6GatewayInput(): string | undefined;
    private _windowsSysprepText?;
    get windowsSysprepText(): string;
    set windowsSysprepText(value: string);
    resetWindowsSysprepText(): void;
    get windowsSysprepTextInput(): string | undefined;
    private _linuxOptions;
    get linuxOptions(): GuestOsCustomizationSpecLinuxOptionsOutputReference;
    putLinuxOptions(value: GuestOsCustomizationSpecLinuxOptions): void;
    resetLinuxOptions(): void;
    get linuxOptionsInput(): GuestOsCustomizationSpecLinuxOptions | undefined;
    private _networkInterface;
    get networkInterface(): GuestOsCustomizationSpecNetworkInterfaceList;
    putNetworkInterface(value: GuestOsCustomizationSpecNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | GuestOsCustomizationSpecNetworkInterface[] | undefined;
    private _windowsOptions;
    get windowsOptions(): GuestOsCustomizationSpecWindowsOptionsOutputReference;
    putWindowsOptions(value: GuestOsCustomizationSpecWindowsOptions): void;
    resetWindowsOptions(): void;
    get windowsOptionsInput(): GuestOsCustomizationSpecWindowsOptions | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization vsphere_guest_os_customization}
*/
export declare class GuestOsCustomization extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_guest_os_customization";
    /**
    * Generates CDKTF code for importing a GuestOsCustomization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GuestOsCustomization to import
    * @param importFromId The id of the existing GuestOsCustomization that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GuestOsCustomization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/guest_os_customization vsphere_guest_os_customization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GuestOsCustomizationConfig
    */
    constructor(scope: Construct, id: string, config: GuestOsCustomizationConfig);
    get changeVersion(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastUpdateTime(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _spec;
    get spec(): GuestOsCustomizationSpecOutputReference;
    putSpec(value: GuestOsCustomizationSpec): void;
    get specInput(): GuestOsCustomizationSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
