/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HaVmOverrideConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#compute_cluster_id HaVmOverride#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an APD event. Can be one of useClusterDefault, none or reset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_datastore_apd_recovery_action HaVmOverride#ha_datastore_apd_recovery_action}
    */
    readonly haDatastoreApdRecoveryAction?: string;
    /**
    * Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_datastore_apd_response HaVmOverride#ha_datastore_apd_response}
    */
    readonly haDatastoreApdResponse?: string;
    /**
    * Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in ha_datastore_apd_response. Specify -1 to use the cluster setting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_datastore_apd_response_delay HaVmOverride#ha_datastore_apd_response_delay}
    */
    readonly haDatastoreApdResponseDelay?: number;
    /**
    * Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_datastore_pdl_response HaVmOverride#ha_datastore_pdl_response}
    */
    readonly haDatastorePdlResponse?: string;
    /**
    * The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of clusterIsolationResponse, none, powerOff, or shutdown.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_host_isolation_response HaVmOverride#ha_host_isolation_response}
    */
    readonly haHostIsolationResponse?: string;
    /**
    * If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked as failed. The value is in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_failure_interval HaVmOverride#ha_vm_failure_interval}
    */
    readonly haVmFailureInterval?: number;
    /**
    * The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset time is allotted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_maximum_failure_window HaVmOverride#ha_vm_maximum_failure_window}
    */
    readonly haVmMaximumFailureWindow?: number;
    /**
    * The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_maximum_resets HaVmOverride#ha_vm_maximum_resets}
    */
    readonly haVmMaximumResets?: number;
    /**
    * The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_minimum_uptime HaVmOverride#ha_vm_minimum_uptime}
    */
    readonly haVmMinimumUptime?: number;
    /**
    * The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled, vmMonitoringOnly, or vmAndAppMonitoring.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_monitoring HaVmOverride#ha_vm_monitoring}
    */
    readonly haVmMonitoring?: string;
    /**
    * Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_monitoring_use_cluster_defaults HaVmOverride#ha_vm_monitoring_use_cluster_defaults}
    */
    readonly haVmMonitoringUseClusterDefaults?: boolean | cdktf.IResolvable;
    /**
    * The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority, lowest, low, medium, high, or highest.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_restart_priority HaVmOverride#ha_vm_restart_priority}
    */
    readonly haVmRestartPriority?: string;
    /**
    * The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#ha_vm_restart_timeout HaVmOverride#ha_vm_restart_timeout}
    */
    readonly haVmRestartTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#id HaVmOverride#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The managed object ID of the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#virtual_machine_id HaVmOverride#virtual_machine_id}
    */
    readonly virtualMachineId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override vsphere_ha_vm_override}
*/
export declare class HaVmOverride extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_ha_vm_override";
    /**
    * Generates CDKTF code for importing a HaVmOverride resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HaVmOverride to import
    * @param importFromId The id of the existing HaVmOverride that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HaVmOverride to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/ha_vm_override vsphere_ha_vm_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HaVmOverrideConfig
    */
    constructor(scope: Construct, id: string, config: HaVmOverrideConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _haDatastoreApdRecoveryAction?;
    get haDatastoreApdRecoveryAction(): string;
    set haDatastoreApdRecoveryAction(value: string);
    resetHaDatastoreApdRecoveryAction(): void;
    get haDatastoreApdRecoveryActionInput(): string | undefined;
    private _haDatastoreApdResponse?;
    get haDatastoreApdResponse(): string;
    set haDatastoreApdResponse(value: string);
    resetHaDatastoreApdResponse(): void;
    get haDatastoreApdResponseInput(): string | undefined;
    private _haDatastoreApdResponseDelay?;
    get haDatastoreApdResponseDelay(): number;
    set haDatastoreApdResponseDelay(value: number);
    resetHaDatastoreApdResponseDelay(): void;
    get haDatastoreApdResponseDelayInput(): number | undefined;
    private _haDatastorePdlResponse?;
    get haDatastorePdlResponse(): string;
    set haDatastorePdlResponse(value: string);
    resetHaDatastorePdlResponse(): void;
    get haDatastorePdlResponseInput(): string | undefined;
    private _haHostIsolationResponse?;
    get haHostIsolationResponse(): string;
    set haHostIsolationResponse(value: string);
    resetHaHostIsolationResponse(): void;
    get haHostIsolationResponseInput(): string | undefined;
    private _haVmFailureInterval?;
    get haVmFailureInterval(): number;
    set haVmFailureInterval(value: number);
    resetHaVmFailureInterval(): void;
    get haVmFailureIntervalInput(): number | undefined;
    private _haVmMaximumFailureWindow?;
    get haVmMaximumFailureWindow(): number;
    set haVmMaximumFailureWindow(value: number);
    resetHaVmMaximumFailureWindow(): void;
    get haVmMaximumFailureWindowInput(): number | undefined;
    private _haVmMaximumResets?;
    get haVmMaximumResets(): number;
    set haVmMaximumResets(value: number);
    resetHaVmMaximumResets(): void;
    get haVmMaximumResetsInput(): number | undefined;
    private _haVmMinimumUptime?;
    get haVmMinimumUptime(): number;
    set haVmMinimumUptime(value: number);
    resetHaVmMinimumUptime(): void;
    get haVmMinimumUptimeInput(): number | undefined;
    private _haVmMonitoring?;
    get haVmMonitoring(): string;
    set haVmMonitoring(value: string);
    resetHaVmMonitoring(): void;
    get haVmMonitoringInput(): string | undefined;
    private _haVmMonitoringUseClusterDefaults?;
    get haVmMonitoringUseClusterDefaults(): boolean | cdktf.IResolvable;
    set haVmMonitoringUseClusterDefaults(value: boolean | cdktf.IResolvable);
    resetHaVmMonitoringUseClusterDefaults(): void;
    get haVmMonitoringUseClusterDefaultsInput(): boolean | cdktf.IResolvable | undefined;
    private _haVmRestartPriority?;
    get haVmRestartPriority(): string;
    set haVmRestartPriority(value: string);
    resetHaVmRestartPriority(): void;
    get haVmRestartPriorityInput(): string | undefined;
    private _haVmRestartTimeout?;
    get haVmRestartTimeout(): number;
    set haVmRestartTimeout(value: number);
    resetHaVmRestartTimeout(): void;
    get haVmRestartTimeoutInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
