/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourcePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Determines if the reservation on a resource pool can grow beyond the specified value, if the parent resource pool has unreserved resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#cpu_expandable ResourcePool#cpu_expandable}
    */
    readonly cpuExpandable?: boolean | cdktf.IResolvable;
    /**
    * The utilization of a resource pool will not exceed this limit, even if there are available resources. Set to -1 for unlimited.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#cpu_limit ResourcePool#cpu_limit}
    */
    readonly cpuLimit?: number;
    /**
    * Amount of CPU (MHz) that is guaranteed available to the resource pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#cpu_reservation ResourcePool#cpu_reservation}
    */
    readonly cpuReservation?: number;
    /**
    * The allocation level. The level is a simplified view of shares. Levels map to a pre-determined set of numeric values for shares. Can be one of low, normal, high, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#cpu_share_level ResourcePool#cpu_share_level}
    */
    readonly cpuShareLevel?: string;
    /**
    * The number of shares allocated. Used to determine resource allocation in case of resource contention. If this is set, cpu_share_level must be custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#cpu_shares ResourcePool#cpu_shares}
    */
    readonly cpuShares?: number;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#custom_attributes ResourcePool#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#id ResourcePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Determines if the reservation on a resource pool can grow beyond the specified value, if the parent resource pool has unreserved resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#memory_expandable ResourcePool#memory_expandable}
    */
    readonly memoryExpandable?: boolean | cdktf.IResolvable;
    /**
    * The utilization of a resource pool will not exceed this limit, even if there are available resources. Set to -1 for unlimited.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#memory_limit ResourcePool#memory_limit}
    */
    readonly memoryLimit?: number;
    /**
    * Amount of memory (MB) that is guaranteed available to the resource pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#memory_reservation ResourcePool#memory_reservation}
    */
    readonly memoryReservation?: number;
    /**
    * The allocation level. The level is a simplified view of shares. Levels map to a pre-determined set of numeric values for shares. Can be one of low, normal, high, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#memory_share_level ResourcePool#memory_share_level}
    */
    readonly memoryShareLevel?: string;
    /**
    * The number of shares allocated. Used to determine resource allocation in case of resource contention. If this is set, memory_share_level must be custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#memory_shares ResourcePool#memory_shares}
    */
    readonly memoryShares?: number;
    /**
    * Name of resource pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#name ResourcePool#name}
    */
    readonly name: string;
    /**
    * The ID of the root resource pool of the compute resource the resource pool is in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#parent_resource_pool_id ResourcePool#parent_resource_pool_id}
    */
    readonly parentResourcePoolId: string;
    /**
    * Determines if the shares of all descendants of the resource pool are scaled up or down when the shares of the resource pool are scaled up or down.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#scale_descendants_shares ResourcePool#scale_descendants_shares}
    */
    readonly scaleDescendantsShares?: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#tags ResourcePool#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool vsphere_resource_pool}
*/
export declare class ResourcePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_resource_pool";
    /**
    * Generates CDKTF code for importing a ResourcePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourcePool to import
    * @param importFromId The id of the existing ResourcePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourcePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/resource_pool vsphere_resource_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourcePoolConfig
    */
    constructor(scope: Construct, id: string, config: ResourcePoolConfig);
    private _cpuExpandable?;
    get cpuExpandable(): boolean | cdktf.IResolvable;
    set cpuExpandable(value: boolean | cdktf.IResolvable);
    resetCpuExpandable(): void;
    get cpuExpandableInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuLimit?;
    get cpuLimit(): number;
    set cpuLimit(value: number);
    resetCpuLimit(): void;
    get cpuLimitInput(): number | undefined;
    private _cpuReservation?;
    get cpuReservation(): number;
    set cpuReservation(value: number);
    resetCpuReservation(): void;
    get cpuReservationInput(): number | undefined;
    private _cpuShareLevel?;
    get cpuShareLevel(): string;
    set cpuShareLevel(value: string);
    resetCpuShareLevel(): void;
    get cpuShareLevelInput(): string | undefined;
    private _cpuShares?;
    get cpuShares(): number;
    set cpuShares(value: number);
    resetCpuShares(): void;
    get cpuSharesInput(): number | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memoryExpandable?;
    get memoryExpandable(): boolean | cdktf.IResolvable;
    set memoryExpandable(value: boolean | cdktf.IResolvable);
    resetMemoryExpandable(): void;
    get memoryExpandableInput(): boolean | cdktf.IResolvable | undefined;
    private _memoryLimit?;
    get memoryLimit(): number;
    set memoryLimit(value: number);
    resetMemoryLimit(): void;
    get memoryLimitInput(): number | undefined;
    private _memoryReservation?;
    get memoryReservation(): number;
    set memoryReservation(value: number);
    resetMemoryReservation(): void;
    get memoryReservationInput(): number | undefined;
    private _memoryShareLevel?;
    get memoryShareLevel(): string;
    set memoryShareLevel(value: string);
    resetMemoryShareLevel(): void;
    get memoryShareLevelInput(): string | undefined;
    private _memoryShares?;
    get memoryShares(): number;
    set memoryShares(value: number);
    resetMemoryShares(): void;
    get memorySharesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentResourcePoolId?;
    get parentResourcePoolId(): string;
    set parentResourcePoolId(value: string);
    get parentResourcePoolIdInput(): string | undefined;
    private _scaleDescendantsShares?;
    get scaleDescendantsShares(): string;
    set scaleDescendantsShares(value: string);
    resetScaleDescendantsShares(): void;
    get scaleDescendantsSharesInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
