/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SupervisorConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the vSphere cluster on which workload management will be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#cluster Supervisor#cluster}
    */
    readonly cluster: string;
    /**
    * ID of the subscribed content library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#content_library Supervisor#content_library}
    */
    readonly contentLibrary: string;
    /**
    * The UUID (not ID) of the distributed switch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#dvs_uuid Supervisor#dvs_uuid}
    */
    readonly dvsUuid: string;
    /**
    * ID of the NSX Edge Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#edge_cluster Supervisor#edge_cluster}
    */
    readonly edgeCluster: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#id Supervisor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of DNS servers to use on the Kubernetes API server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#main_dns Supervisor#main_dns}
    */
    readonly mainDns: string[];
    /**
    * List of NTP servers to use on the Kubernetes API server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#main_ntp Supervisor#main_ntp}
    */
    readonly mainNtp: string[];
    /**
    * List of DNS search domains.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#search_domains Supervisor#search_domains}
    */
    readonly searchDomains: string[];
    /**
    * Size of the Kubernetes API server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#sizing_hint Supervisor#sizing_hint}
    */
    readonly sizingHint: string;
    /**
    * The name of a storage policy associated with the datastore where the container images will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#storage_policy Supervisor#storage_policy}
    */
    readonly storagePolicy: string;
    /**
    * List of DNS servers to use on the worker nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#worker_dns Supervisor#worker_dns}
    */
    readonly workerDns: string[];
    /**
    * List of NTP servers to use on the worker nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#worker_ntp Supervisor#worker_ntp}
    */
    readonly workerNtp: string[];
    /**
    * egress_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#egress_cidr Supervisor#egress_cidr}
    */
    readonly egressCidr: SupervisorEgressCidr[] | cdktf.IResolvable;
    /**
    * ingress_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#ingress_cidr Supervisor#ingress_cidr}
    */
    readonly ingressCidr: SupervisorIngressCidr[] | cdktf.IResolvable;
    /**
    * management_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#management_network Supervisor#management_network}
    */
    readonly managementNetwork: SupervisorManagementNetwork;
    /**
    * namespace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#namespace Supervisor#namespace}
    */
    readonly namespace?: SupervisorNamespace[] | cdktf.IResolvable;
    /**
    * pod_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#pod_cidr Supervisor#pod_cidr}
    */
    readonly podCidr: SupervisorPodCidr[] | cdktf.IResolvable;
    /**
    * service_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#service_cidr Supervisor#service_cidr}
    */
    readonly serviceCidr: SupervisorServiceCidr;
}
export interface SupervisorEgressCidr {
    /**
    * Network address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#address Supervisor#address}
    */
    readonly address: string;
    /**
    * Subnet prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#prefix Supervisor#prefix}
    */
    readonly prefix: number;
}
export declare function supervisorEgressCidrToTerraform(struct?: SupervisorEgressCidr | cdktf.IResolvable): any;
export declare function supervisorEgressCidrToHclTerraform(struct?: SupervisorEgressCidr | cdktf.IResolvable): any;
export declare class SupervisorEgressCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SupervisorEgressCidr | cdktf.IResolvable | undefined;
    set internalValue(value: SupervisorEgressCidr | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _prefix?;
    get prefix(): number;
    set prefix(value: number);
    get prefixInput(): number | undefined;
}
export declare class SupervisorEgressCidrList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SupervisorEgressCidr[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SupervisorEgressCidrOutputReference;
}
export interface SupervisorIngressCidr {
    /**
    * Network address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#address Supervisor#address}
    */
    readonly address: string;
    /**
    * Subnet prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#prefix Supervisor#prefix}
    */
    readonly prefix: number;
}
export declare function supervisorIngressCidrToTerraform(struct?: SupervisorIngressCidr | cdktf.IResolvable): any;
export declare function supervisorIngressCidrToHclTerraform(struct?: SupervisorIngressCidr | cdktf.IResolvable): any;
export declare class SupervisorIngressCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SupervisorIngressCidr | cdktf.IResolvable | undefined;
    set internalValue(value: SupervisorIngressCidr | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _prefix?;
    get prefix(): number;
    set prefix(value: number);
    get prefixInput(): number | undefined;
}
export declare class SupervisorIngressCidrList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SupervisorIngressCidr[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SupervisorIngressCidrOutputReference;
}
export interface SupervisorManagementNetwork {
    /**
    * Number of addresses to allocate. Starts from 'starting_address'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#address_count Supervisor#address_count}
    */
    readonly addressCount: number;
    /**
    * Gateway IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#gateway Supervisor#gateway}
    */
    readonly gateway: string;
    /**
    * ID of the network. (e.g. a distributed port group).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#network Supervisor#network}
    */
    readonly network: string;
    /**
    * Starting address of the management network range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#starting_address Supervisor#starting_address}
    */
    readonly startingAddress: string;
    /**
    * Subnet mask.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#subnet_mask Supervisor#subnet_mask}
    */
    readonly subnetMask: string;
}
export declare function supervisorManagementNetworkToTerraform(struct?: SupervisorManagementNetworkOutputReference | SupervisorManagementNetwork): any;
export declare function supervisorManagementNetworkToHclTerraform(struct?: SupervisorManagementNetworkOutputReference | SupervisorManagementNetwork): any;
export declare class SupervisorManagementNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SupervisorManagementNetwork | undefined;
    set internalValue(value: SupervisorManagementNetwork | undefined);
    private _addressCount?;
    get addressCount(): number;
    set addressCount(value: number);
    get addressCountInput(): number | undefined;
    private _gateway?;
    get gateway(): string;
    set gateway(value: string);
    get gatewayInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _startingAddress?;
    get startingAddress(): string;
    set startingAddress(value: string);
    get startingAddressInput(): string | undefined;
    private _subnetMask?;
    get subnetMask(): string;
    set subnetMask(value: string);
    get subnetMaskInput(): string | undefined;
}
export interface SupervisorNamespace {
    /**
    * A list of content libraries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#content_libraries Supervisor#content_libraries}
    */
    readonly contentLibraries?: string[];
    /**
    * The name of the namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#name Supervisor#name}
    */
    readonly name: string;
    /**
    * A list of virtual machine classes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#vm_classes Supervisor#vm_classes}
    */
    readonly vmClasses?: string[];
}
export declare function supervisorNamespaceToTerraform(struct?: SupervisorNamespace | cdktf.IResolvable): any;
export declare function supervisorNamespaceToHclTerraform(struct?: SupervisorNamespace | cdktf.IResolvable): any;
export declare class SupervisorNamespaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SupervisorNamespace | cdktf.IResolvable | undefined;
    set internalValue(value: SupervisorNamespace | cdktf.IResolvable | undefined);
    private _contentLibraries?;
    get contentLibraries(): string[];
    set contentLibraries(value: string[]);
    resetContentLibraries(): void;
    get contentLibrariesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vmClasses?;
    get vmClasses(): string[];
    set vmClasses(value: string[]);
    resetVmClasses(): void;
    get vmClassesInput(): string[] | undefined;
}
export declare class SupervisorNamespaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SupervisorNamespace[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SupervisorNamespaceOutputReference;
}
export interface SupervisorPodCidr {
    /**
    * Network address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#address Supervisor#address}
    */
    readonly address: string;
    /**
    * Subnet prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#prefix Supervisor#prefix}
    */
    readonly prefix: number;
}
export declare function supervisorPodCidrToTerraform(struct?: SupervisorPodCidr | cdktf.IResolvable): any;
export declare function supervisorPodCidrToHclTerraform(struct?: SupervisorPodCidr | cdktf.IResolvable): any;
export declare class SupervisorPodCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SupervisorPodCidr | cdktf.IResolvable | undefined;
    set internalValue(value: SupervisorPodCidr | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _prefix?;
    get prefix(): number;
    set prefix(value: number);
    get prefixInput(): number | undefined;
}
export declare class SupervisorPodCidrList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SupervisorPodCidr[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SupervisorPodCidrOutputReference;
}
export interface SupervisorServiceCidr {
    /**
    * Network address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#address Supervisor#address}
    */
    readonly address: string;
    /**
    * Subnet prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#prefix Supervisor#prefix}
    */
    readonly prefix: number;
}
export declare function supervisorServiceCidrToTerraform(struct?: SupervisorServiceCidrOutputReference | SupervisorServiceCidr): any;
export declare function supervisorServiceCidrToHclTerraform(struct?: SupervisorServiceCidrOutputReference | SupervisorServiceCidr): any;
export declare class SupervisorServiceCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SupervisorServiceCidr | undefined;
    set internalValue(value: SupervisorServiceCidr | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _prefix?;
    get prefix(): number;
    set prefix(value: number);
    get prefixInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor vsphere_supervisor}
*/
export declare class Supervisor extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_supervisor";
    /**
    * Generates CDKTF code for importing a Supervisor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Supervisor to import
    * @param importFromId The id of the existing Supervisor that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Supervisor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/supervisor vsphere_supervisor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SupervisorConfig
    */
    constructor(scope: Construct, id: string, config: SupervisorConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _contentLibrary?;
    get contentLibrary(): string;
    set contentLibrary(value: string);
    get contentLibraryInput(): string | undefined;
    private _dvsUuid?;
    get dvsUuid(): string;
    set dvsUuid(value: string);
    get dvsUuidInput(): string | undefined;
    private _edgeCluster?;
    get edgeCluster(): string;
    set edgeCluster(value: string);
    get edgeClusterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mainDns?;
    get mainDns(): string[];
    set mainDns(value: string[]);
    get mainDnsInput(): string[] | undefined;
    private _mainNtp?;
    get mainNtp(): string[];
    set mainNtp(value: string[]);
    get mainNtpInput(): string[] | undefined;
    private _searchDomains?;
    get searchDomains(): string[];
    set searchDomains(value: string[]);
    get searchDomainsInput(): string[] | undefined;
    private _sizingHint?;
    get sizingHint(): string;
    set sizingHint(value: string);
    get sizingHintInput(): string | undefined;
    private _storagePolicy?;
    get storagePolicy(): string;
    set storagePolicy(value: string);
    get storagePolicyInput(): string | undefined;
    private _workerDns?;
    get workerDns(): string[];
    set workerDns(value: string[]);
    get workerDnsInput(): string[] | undefined;
    private _workerNtp?;
    get workerNtp(): string[];
    set workerNtp(value: string[]);
    get workerNtpInput(): string[] | undefined;
    private _egressCidr;
    get egressCidr(): SupervisorEgressCidrList;
    putEgressCidr(value: SupervisorEgressCidr[] | cdktf.IResolvable): void;
    get egressCidrInput(): cdktf.IResolvable | SupervisorEgressCidr[] | undefined;
    private _ingressCidr;
    get ingressCidr(): SupervisorIngressCidrList;
    putIngressCidr(value: SupervisorIngressCidr[] | cdktf.IResolvable): void;
    get ingressCidrInput(): cdktf.IResolvable | SupervisorIngressCidr[] | undefined;
    private _managementNetwork;
    get managementNetwork(): SupervisorManagementNetworkOutputReference;
    putManagementNetwork(value: SupervisorManagementNetwork): void;
    get managementNetworkInput(): SupervisorManagementNetwork | undefined;
    private _namespace;
    get namespace(): SupervisorNamespaceList;
    putNamespace(value: SupervisorNamespace[] | cdktf.IResolvable): void;
    resetNamespace(): void;
    get namespaceInput(): cdktf.IResolvable | SupervisorNamespace[] | undefined;
    private _podCidr;
    get podCidr(): SupervisorPodCidrList;
    putPodCidr(value: SupervisorPodCidr[] | cdktf.IResolvable): void;
    get podCidrInput(): cdktf.IResolvable | SupervisorPodCidr[] | undefined;
    private _serviceCidr;
    get serviceCidr(): SupervisorServiceCidrOutputReference;
    putServiceCidr(value: SupervisorServiceCidr): void;
    get serviceCidrInput(): SupervisorServiceCidr | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
