/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#adapter_type VirtualDisk#adapter_type}
    */
    readonly adapterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#create_directories VirtualDisk#create_directories}
    */
    readonly createDirectories?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#datacenter VirtualDisk#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#datastore VirtualDisk#datastore}
    */
    readonly datastore: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#id VirtualDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#size VirtualDisk#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#type VirtualDisk#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#vmdk_path VirtualDisk#vmdk_path}
    */
    readonly vmdkPath: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk vsphere_virtual_disk}
*/
export declare class VirtualDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_virtual_disk";
    /**
    * Generates CDKTF code for importing a VirtualDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualDisk to import
    * @param importFromId The id of the existing VirtualDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/vmware/vsphere/2.14.1/docs/resources/virtual_disk vsphere_virtual_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualDiskConfig
    */
    constructor(scope: Construct, id: string, config: VirtualDiskConfig);
    private _adapterType?;
    get adapterType(): string;
    set adapterType(value: string);
    resetAdapterType(): void;
    get adapterTypeInput(): string | undefined;
    private _createDirectories?;
    get createDirectories(): boolean | cdktf.IResolvable;
    set createDirectories(value: boolean | cdktf.IResolvable);
    resetCreateDirectories(): void;
    get createDirectoriesInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _datastore?;
    get datastore(): string;
    set datastore(value: string);
    get datastoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _vmdkPath?;
    get vmdkPath(): string;
    set vmdkPath(value: string);
    get vmdkPathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
