import s3notifications = require('@aws-cdk/aws-s3-notifications');
import cdk = require('@aws-cdk/cdk');
/**
 * Since we can't take a dependency on @aws-cdk/sns, this is a simple wrapper
 * for AWS::SNS::Topic which implements IBucketNotificationDestination.
 */
export declare class Topic extends cdk.Construct implements s3notifications.IBucketNotificationDestination {
    readonly topicArn: string;
    private readonly policy;
    private readonly notifyingBucketPaths;
    constructor(scope: cdk.Construct, id: string);
    asBucketNotificationDestination(bucketArn: string, bucketId: string): s3notifications.BucketNotificationDestinationProps;
}
