/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.task;

import java.util.ArrayList;
import java.util.List;
import org.ray.api.Ray;
import org.ray.api.RayObject;
import org.ray.api.id.ObjectId;
import org.ray.api.runtime.RayRuntime;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.RayMultiWorkerNativeRuntime;
import org.ray.runtime.generated.Common;
import org.ray.runtime.object.NativeRayObject;
import org.ray.runtime.object.ObjectSerializer;
import org.ray.runtime.task.FunctionArg;

public class ArgumentsBuilder {
    private static final int LARGEST_SIZE_PASS_BY_VALUE = 102400;
    private static final NativeRayObject PYTHON_DUMMY_TYPE = ObjectSerializer.serialize("__RAY_DUMMY__".getBytes());

    public static List<FunctionArg> wrap(Object[] args, Common.Language language) {
        ArrayList<FunctionArg> ret = new ArrayList<FunctionArg>();
        for (Object arg : args) {
            ObjectId id = null;
            NativeRayObject value = null;
            if (arg instanceof RayObject) {
                id = ((RayObject)arg).getId();
            } else {
                value = ObjectSerializer.serialize(arg);
                if (value.data.length > 102400) {
                    RayRuntime runtime = Ray.internal();
                    if (runtime instanceof RayMultiWorkerNativeRuntime) {
                        runtime = ((RayMultiWorkerNativeRuntime)runtime).getCurrentRuntime();
                    }
                    id = ((AbstractRayRuntime)runtime).getObjectStore().putRaw(value);
                    value = null;
                }
            }
            if (language == Common.Language.PYTHON) {
                ret.add(FunctionArg.passByValue(PYTHON_DUMMY_TYPE));
            }
            if (id != null) {
                ret.add(FunctionArg.passByReference(id));
                continue;
            }
            ret.add(FunctionArg.passByValue(value));
        }
        return ret;
    }

    public static Object[] unwrap(List<NativeRayObject> args, ClassLoader classLoader) {
        Object[] realArgs = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            realArgs[i] = ObjectSerializer.deserialize(args.get(i), null, classLoader);
        }
        return realArgs;
    }
}

