/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.task;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.ray.api.BaseActor;
import org.ray.api.id.ObjectId;
import org.ray.api.options.ActorCreationOptions;
import org.ray.api.options.CallOptions;
import org.ray.runtime.actor.NativeRayActor;
import org.ray.runtime.functionmanager.FunctionDescriptor;
import org.ray.runtime.task.FunctionArg;
import org.ray.runtime.task.TaskSubmitter;

public class NativeTaskSubmitter
implements TaskSubmitter {
    private final long nativeCoreWorkerPointer;

    public NativeTaskSubmitter(long nativeCoreWorkerPointer) {
        this.nativeCoreWorkerPointer = nativeCoreWorkerPointer;
    }

    @Override
    public List<ObjectId> submitTask(FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitTask(this.nativeCoreWorkerPointer, functionDescriptor, args, numReturns, options);
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    @Override
    public BaseActor createActor(FunctionDescriptor functionDescriptor, List<FunctionArg> args, ActorCreationOptions options) {
        byte[] actorId = NativeTaskSubmitter.nativeCreateActor(this.nativeCoreWorkerPointer, functionDescriptor, args, options);
        return NativeRayActor.create(this.nativeCoreWorkerPointer, actorId, functionDescriptor.getLanguage());
    }

    @Override
    public List<ObjectId> submitActorTask(BaseActor actor, FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        Preconditions.checkState(actor instanceof NativeRayActor);
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitActorTask(this.nativeCoreWorkerPointer, actor.getId().getBytes(), functionDescriptor, args, numReturns, options);
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    private static native List<byte[]> nativeSubmitTask(long var0, FunctionDescriptor var2, List<FunctionArg> var3, int var4, CallOptions var5);

    private static native byte[] nativeCreateActor(long var0, FunctionDescriptor var2, List<FunctionArg> var3, ActorCreationOptions var4);

    private static native List<byte[]> nativeSubmitActorTask(long var0, byte[] var2, FunctionDescriptor var3, List<FunctionArg> var4, int var5, CallOptions var6);
}

