/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.task;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ray.api.exception.RayTaskException;
import org.ray.api.id.ActorId;
import org.ray.api.id.JobId;
import org.ray.api.id.TaskId;
import org.ray.api.id.UniqueId;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.config.RayConfig;
import org.ray.runtime.config.RunMode;
import org.ray.runtime.functionmanager.JavaFunctionDescriptor;
import org.ray.runtime.functionmanager.RayFunction;
import org.ray.runtime.generated.Common;
import org.ray.runtime.object.NativeRayObject;
import org.ray.runtime.object.ObjectSerializer;
import org.ray.runtime.task.ArgumentsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutor.class);
    private static ConcurrentHashMap<UniqueId, TaskExecutor> taskExecutors = new ConcurrentHashMap();
    protected final AbstractRayRuntime runtime;
    protected Object currentActor = null;
    private Exception actorCreationException = null;

    protected TaskExecutor(AbstractRayRuntime runtime) {
        this.runtime = runtime;
        if (RayConfig.getInstance().runMode == RunMode.CLUSTER) {
            taskExecutors.put(runtime.getWorkerContext().getCurrentWorkerId(), this);
        }
    }

    public static TaskExecutor get(byte[] workerId) {
        return taskExecutors.get(new UniqueId(workerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NativeRayObject> execute(List<String> rayFunctionInfo, List<NativeRayObject> argsBytes) {
        JobId jobId = this.runtime.getWorkerContext().getCurrentJobId();
        Common.TaskType taskType = this.runtime.getWorkerContext().getCurrentTaskType();
        TaskId taskId = this.runtime.getWorkerContext().getCurrentTaskId();
        LOGGER.debug("Executing task {}", (Object)taskId);
        ArrayList<NativeRayObject> returnObjects = new ArrayList<NativeRayObject>();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        JavaFunctionDescriptor functionDescriptor = this.parseFunctionDescriptor(rayFunctionInfo);
        RayFunction rayFunction = null;
        try {
            rayFunction = this.runtime.getFunctionManager().getFunction(jobId, functionDescriptor);
            Thread.currentThread().setContextClassLoader(rayFunction.classLoader);
            this.runtime.getWorkerContext().setCurrentClassLoader(rayFunction.classLoader);
            Object actor = null;
            if (taskType == Common.TaskType.ACTOR_TASK) {
                if (this.actorCreationException != null) {
                    throw this.actorCreationException;
                }
                actor = this.currentActor;
            }
            Object[] args = ArgumentsBuilder.unwrap(argsBytes, rayFunction.classLoader);
            Object result = !rayFunction.isConstructor() ? rayFunction.getMethod().invoke(actor, args) : rayFunction.getConstructor().newInstance(args);
            if (taskType != Common.TaskType.ACTOR_CREATION_TASK) {
                if (taskType == Common.TaskType.ACTOR_TASK) {
                    this.maybeSaveCheckpoint(actor, this.runtime.getWorkerContext().getCurrentActorId());
                }
                if (rayFunction.hasReturn()) {
                    returnObjects.add(ObjectSerializer.serialize(result));
                }
            } else {
                this.maybeLoadCheckpoint(result, this.runtime.getWorkerContext().getCurrentActorId());
                this.currentActor = result;
            }
            LOGGER.debug("Finished executing task {}", (Object)taskId);
        }
        catch (Exception e) {
            LOGGER.error("Error executing task " + taskId, e);
            if (taskType != Common.TaskType.ACTOR_CREATION_TASK) {
                boolean hasReturn = rayFunction != null && rayFunction.hasReturn();
                boolean isCrossLanguage = functionDescriptor.signature.equals("");
                if (hasReturn || isCrossLanguage) {
                    returnObjects.add(ObjectSerializer.serialize(new RayTaskException("Error executing task " + taskId, e)));
                }
            } else {
                this.actorCreationException = e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.runtime.getWorkerContext().setCurrentClassLoader(null);
        }
        return returnObjects;
    }

    private JavaFunctionDescriptor parseFunctionDescriptor(List<String> rayFunctionInfo) {
        Preconditions.checkState(rayFunctionInfo != null && rayFunctionInfo.size() == 3);
        return new JavaFunctionDescriptor(rayFunctionInfo.get(0), rayFunctionInfo.get(1), rayFunctionInfo.get(2));
    }

    protected abstract void maybeSaveCheckpoint(Object var1, ActorId var2);

    protected abstract void maybeLoadCheckpoint(Object var1, ActorId var2);
}

