/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.api.context;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.ray.streaming.api.stream.StreamSink;
import org.ray.streaming.jobgraph.JobGraph;
import org.ray.streaming.jobgraph.JobGraphBuilder;
import org.ray.streaming.schedule.JobScheduler;

public class StreamingContext
implements Serializable {
    private transient AtomicInteger idGenerator = new AtomicInteger(0);
    private List<StreamSink> streamSinks = new ArrayList<StreamSink>();
    private Map<String, String> jobConfig = new HashMap<String, String>();
    private JobGraph jobGraph;

    private StreamingContext() {
    }

    public static StreamingContext buildContext() {
        return new StreamingContext();
    }

    public void execute(String jobName) {
        JobGraphBuilder jobGraphBuilder = new JobGraphBuilder(this.streamSinks, jobName);
        this.jobGraph = jobGraphBuilder.build();
        this.jobGraph.printJobGraph();
        ServiceLoader<JobScheduler> serviceLoader = ServiceLoader.load(JobScheduler.class);
        Iterator<JobScheduler> iterator = serviceLoader.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "No JobScheduler implementation has been provided.");
        JobScheduler jobSchedule = iterator.next();
        jobSchedule.schedule(this.jobGraph, this.jobConfig);
    }

    public int generateId() {
        return this.idGenerator.incrementAndGet();
    }

    public void addSink(StreamSink streamSink) {
        this.streamSinks.add(streamSink);
    }

    public List<StreamSink> getStreamSinks() {
        return this.streamSinks;
    }

    public void withConfig(Map<String, String> jobConfig) {
        this.jobConfig = jobConfig;
    }
}

