/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ray.streaming.jobgraph.JobEdge;
import org.ray.streaming.jobgraph.JobVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobGraph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(JobGraph.class);
    private final String jobName;
    private final Map<String, String> jobConfig;
    private List<JobVertex> jobVertexList;
    private List<JobEdge> jobEdgeList;
    private String digraph;

    public JobGraph(String jobName, Map<String, String> jobConfig) {
        this.jobName = jobName;
        this.jobConfig = jobConfig;
        this.jobVertexList = new ArrayList<JobVertex>();
        this.jobEdgeList = new ArrayList<JobEdge>();
    }

    public String generateDigraph() {
        StringBuilder digraph = new StringBuilder();
        digraph.append("digraph ").append(this.jobName + " ").append(" {");
        for (JobEdge jobEdge : this.jobEdgeList) {
            String srcNode = null;
            String targetNode = null;
            for (JobVertex jobVertex : this.jobVertexList) {
                if (jobEdge.getSrcVertexId() == jobVertex.getVertexId()) {
                    srcNode = jobVertex.getVertexId() + "-" + jobVertex.getStreamOperator().getName();
                    continue;
                }
                if (jobEdge.getTargetVertexId() != jobVertex.getVertexId()) continue;
                targetNode = jobVertex.getVertexId() + "-" + jobVertex.getStreamOperator().getName();
            }
            digraph.append(System.getProperty("line.separator"));
            digraph.append(srcNode).append(" -> ").append(targetNode);
        }
        digraph.append(System.getProperty("line.separator")).append("}");
        this.digraph = digraph.toString();
        return this.digraph;
    }

    public void addVertex(JobVertex vertex) {
        this.jobVertexList.add(vertex);
    }

    public void addEdge(JobEdge jobEdge) {
        this.jobEdgeList.add(jobEdge);
    }

    public List<JobVertex> getJobVertexList() {
        return this.jobVertexList;
    }

    public List<JobEdge> getJobEdgeList() {
        return this.jobEdgeList;
    }

    public String getDigraph() {
        return this.digraph;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getJobConfig() {
        return this.jobConfig;
    }

    public void printJobGraph() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        LOG.info("Printing job graph:");
        for (JobVertex jobVertex : this.jobVertexList) {
            LOG.info(jobVertex.toString());
        }
        for (JobEdge jobEdge : this.jobEdgeList) {
            LOG.info(jobEdge.toString());
        }
    }
}

