/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.resource;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ray.api.id.UniqueId;
import org.ray.streaming.runtime.config.master.ResourceConfig;
import org.ray.streaming.runtime.core.resource.Container;
import org.ray.streaming.runtime.core.resource.ContainerID;
import org.ray.streaming.runtime.core.resource.Slot;

public class Resources
implements Serializable {
    private List<Container> registerContainers = new ArrayList<Container>();
    private Map<ContainerID, List<Slot>> allocatingMap = new HashMap<ContainerID, List<Slot>>(16);
    private int slotNumPerContainer = 0;
    private int actorPerContainer = 0;
    private int currentContainerAllocatedActorNum = 0;
    private int currentContainerIndex = 0;
    private int maxActorNumPerContainer;

    public Resources(ResourceConfig resourceConfig) {
        this.maxActorNumPerContainer = resourceConfig.maxActorNumPerContainer();
    }

    public List<Container> getRegisterContainers() {
        return this.registerContainers;
    }

    public void setSlotNumPerContainer(int slotNumPerContainer) {
        this.slotNumPerContainer = slotNumPerContainer;
    }

    public int getSlotNumPerContainer() {
        return this.slotNumPerContainer;
    }

    public void setRegisterContainers(List<Container> registerContainers) {
        this.registerContainers = registerContainers;
    }

    public void setCurrentContainerIndex(int currentContainerIndex) {
        this.currentContainerIndex = currentContainerIndex;
    }

    public int getCurrentContainerIndex() {
        return this.currentContainerIndex;
    }

    public void setCurrentContainerAllocatedActorNum(int currentContainerAllocatedActorNum) {
        this.currentContainerAllocatedActorNum = currentContainerAllocatedActorNum;
    }

    public int getCurrentContainerAllocatedActorNum() {
        return this.currentContainerAllocatedActorNum;
    }

    public int getActorPerContainer() {
        return this.actorPerContainer;
    }

    public void setActorPerContainer(int actorPerContainer) {
        this.actorPerContainer = actorPerContainer;
    }

    public Container getRegisterContainerByContainerId(ContainerID containerID) {
        return this.registerContainers.stream().filter(container -> container.getContainerId().equals(containerID)).findFirst().get();
    }

    public int getMaxActorNumPerContainer() {
        return this.maxActorNumPerContainer;
    }

    public Map<ContainerID, List<Slot>> getAllocatingMap() {
        return this.allocatingMap;
    }

    public void setAllocatingMap(Map<ContainerID, List<Slot>> allocatingMap) {
        this.allocatingMap = allocatingMap;
    }

    public Map<UniqueId, Map<String, Double>> getAllAvailableResource() {
        HashMap<UniqueId, Map<String, Double>> availableResource = new HashMap<UniqueId, Map<String, Double>>();
        for (Container container : this.registerContainers) {
            availableResource.put(container.getNodeId(), container.getAvailableResource());
        }
        return availableResource;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("registerContainers", this.registerContainers).add("allocatingMap", this.allocatingMap).add("slotNumPerContainer", this.slotNumPerContainer).add("actorPerContainer", this.actorPerContainer).add("currentContainerAllocatedActorNum", this.currentContainerAllocatedActorNum).add("currentContainerIndex", this.currentContainerIndex).add("maxActorNumPerContainer", this.maxActorNumPerContainer).toString();
    }
}

