"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
from fathom_python import errors, models, utils
from fathom_python._hooks import HookContext, SDKHooks
from fathom_python.types import OptionalNullable, UNSET
from fathom_python.utils import get_security_from_env
from fathom_python.utils.unmarshal_json_response import unmarshal_json_response
import httpx
from jsonpath import JSONPath
from typing import Any, Callable, Dict, List, Mapping, Optional, Union, cast
import weakref

# region imports
import functools
import time
from urllib.parse import urlencode
import requests
from svix.webhooks import Webhook
# endregion imports


class Fathom(BaseSDK):
    r"""Fathom External API: The Fathom External API lets you poll meetings, teams, and team members, and
    optionally receive webhooks when content from a new meeting is ready.

    """

    def __init__(
        self,
        security: Optional[
            Union[models.Security, Callable[[], models.Security]]
        ] = None,
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self.sdk_configuration = hooks.sdk_init(self.sdk_configuration)

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None

    # region sdk-class-body
    class TokenStore:
        def __init__(self):
            self.token = ""
            self.refresh_token = ""
            self.expires = 0

        def get(self):
            return {
                "token": self.token,
                "refresh_token": self.refresh_token,
                "expires": self.expires,
            }

        def set(self, token: str, refresh_token: str, expires: int):
            self.token = token
            self.refresh_token = refresh_token
            self.expires = expires

    @staticmethod
    def verify_webhook(webhook_secret: str, headers: dict, payload: str):
        wh = Webhook(webhook_secret)
        return wh.verify(payload, headers)

    @staticmethod
    def new_token_store():
        return Fathom.TokenStore()

    @staticmethod
    def get_authorization_url(
        client_id: str, redirect_uri: str, scope: str, state: str
    ) -> str:
        base_url = "https://fathom.video/external/v1/oauth2/authorize"
        params = {
            "client_id": client_id,
            "redirect_uri": redirect_uri,
            "scope": scope,
            "state": state,
            "response_type": "code",
        }
        return f"{base_url}?{urlencode(params)}"

    @staticmethod
    def with_authorization(
        client_id: str,
        client_secret: str,
        code: str,
        redirect_uri: str,
        token_store: "Fathom.TokenStore",
    ) -> Callable[[], models.Security]:
        def get_credentials_func(
            client_id: str,
            client_secret: str,
            code: str,
            redirect_uri: str,
            token_store: "Fathom.TokenStore",
        ):
            token_endpoint = "https://fathom.video/external/v1/oauth2/token"
            session = token_store.get()
            if (
                session
                and session["token"] != ""
                and session["expires"] > int(time.time())
            ):
                return models.Security(bearer_auth=session["token"])

            if session and session["token"] == "":
                try:
                    response = requests.post(
                        token_endpoint,
                        data={
                            "client_id": client_id,
                            "client_secret": client_secret,
                            "code": code,
                            "redirect_uri": redirect_uri,
                            "grant_type": "authorization_code",
                        },
                        timeout=15,
                    )
                    response.raise_for_status()
                    data = response.json()
                    token_store.set(
                        data["access_token"],
                        data.get("refresh_token", ""),
                        int(time.time()) + data["expires_in"],
                    )
                    return models.Security(bearer_auth=data["access_token"])

                except Exception as e:
                    raise Exception(
                        f"Failed to obtain OAuth token with authorization code: {str(e)}"
                    ) from e
            try:
                response = requests.post(
                    token_endpoint,
                    data={
                        "client_id": client_id,
                        "client_secret": client_secret,
                        "refresh_token": session["refresh_token"],
                        "grant_type": "refresh_token",
                    },
                    timeout=15,
                )
                response.raise_for_status()
                data = response.json()
                token_store.set(
                    data["access_token"],
                    data.get("refresh_token", ""),
                    int(time.time()) + data["expires_in"],
                )
                return models.Security(bearer_auth=data["access_token"])
            except Exception as e:
                raise Exception(
                    f"Failed to obtain OAuth token with refresh token: {str(e)}"
                ) from e

        return functools.partial(
            get_credentials_func,
            client_id,
            client_secret,
            code,
            redirect_uri,
            token_store,
        )

    # endregion sdk-class-body

    def list_meetings(
        self,
        *,
        calendar_invitees: Optional[List[str]] = None,
        calendar_invitees_domains: Optional[List[str]] = None,
        calendar_invitees_domains_type: Optional[
            models.ListMeetingsCalendarInviteesDomainsType
        ] = models.ListMeetingsCalendarInviteesDomainsType.ALL,
        created_after: Optional[str] = None,
        created_before: Optional[str] = None,
        cursor: Optional[str] = None,
        include_action_items: Optional[bool] = False,
        include_crm_matches: Optional[bool] = False,
        include_summary: Optional[bool] = False,
        include_transcript: Optional[bool] = False,
        meeting_type: Optional[models.MeetingType] = None,
        recorded_by: Optional[List[str]] = None,
        teams: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListMeetingsResponse]:
        r"""List meetings

        :param calendar_invitees: Email address of calendar_invitees to filter by.  Pass the parameter once per value, e.g. `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.  Returns meetings where any of the given email addresses appear in the calendar_invitees list.
        :param calendar_invitees_domains: Domains of the companies to filter by. Exact match.  Pass the parameter once per value, e.g. `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.  Returns meetings where any of the given company domains appear in the meeting.
        :param calendar_invitees_domains_type: Filter by whether calendar invitee list includes external email domains.
        :param created_after: Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.
        :param created_before: Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.
        :param cursor: Cursor for pagination.
        :param include_action_items: Include the action items for each meeting.
        :param include_crm_matches: Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.
        :param include_summary: Include the summary for each meeting. Unavailable for OAuth connected apps (use /recordings instead).
        :param include_transcript: Include the transcript for each meeting. Unavailable for OAuth connected apps (use /recordings instead).
        :param meeting_type: Filter by meeting type.
        :param recorded_by: Email addresses of users who recorded meetings.  Pass the parameter once per value, e.g. `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.  Returns meetings recorded by any of the specified users.
        :param teams: Team names to filter by.  Pass the parameter once per value, e.g. `teams[]=Sales&teams[]=Engineering`.  Returns meetings that belong to any of the specified teams.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMeetingsRequest(
            calendar_invitees=calendar_invitees,
            calendar_invitees_domains=calendar_invitees_domains,
            calendar_invitees_domains_type=calendar_invitees_domains_type,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            meeting_type=meeting_type,
            recorded_by=recorded_by,
            teams=teams,
        )

        req = self._build_request(
            method="GET",
            path="/meetings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listMeetings",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListMeetingsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_meetings(
                calendar_invitees=calendar_invitees,
                calendar_invitees_domains=calendar_invitees_domains,
                calendar_invitees_domains_type=calendar_invitees_domains_type,
                created_after=created_after,
                created_before=created_before,
                cursor=next_cursor,
                include_action_items=include_action_items,
                include_crm_matches=include_crm_matches,
                include_summary=include_summary,
                include_transcript=include_transcript,
                meeting_type=meeting_type,
                recorded_by=recorded_by,
                teams=teams,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListMeetingsResponse(
                result=unmarshal_json_response(models.MeetingListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def list_meetings_async(
        self,
        *,
        calendar_invitees: Optional[List[str]] = None,
        calendar_invitees_domains: Optional[List[str]] = None,
        calendar_invitees_domains_type: Optional[
            models.ListMeetingsCalendarInviteesDomainsType
        ] = models.ListMeetingsCalendarInviteesDomainsType.ALL,
        created_after: Optional[str] = None,
        created_before: Optional[str] = None,
        cursor: Optional[str] = None,
        include_action_items: Optional[bool] = False,
        include_crm_matches: Optional[bool] = False,
        include_summary: Optional[bool] = False,
        include_transcript: Optional[bool] = False,
        meeting_type: Optional[models.MeetingType] = None,
        recorded_by: Optional[List[str]] = None,
        teams: Optional[List[str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListMeetingsResponse]:
        r"""List meetings

        :param calendar_invitees: Email address of calendar_invitees to filter by.  Pass the parameter once per value, e.g. `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.  Returns meetings where any of the given email addresses appear in the calendar_invitees list.
        :param calendar_invitees_domains: Domains of the companies to filter by. Exact match.  Pass the parameter once per value, e.g. `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.  Returns meetings where any of the given company domains appear in the meeting.
        :param calendar_invitees_domains_type: Filter by whether calendar invitee list includes external email domains.
        :param created_after: Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.
        :param created_before: Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.
        :param cursor: Cursor for pagination.
        :param include_action_items: Include the action items for each meeting.
        :param include_crm_matches: Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.
        :param include_summary: Include the summary for each meeting. Unavailable for OAuth connected apps (use /recordings instead).
        :param include_transcript: Include the transcript for each meeting. Unavailable for OAuth connected apps (use /recordings instead).
        :param meeting_type: Filter by meeting type.
        :param recorded_by: Email addresses of users who recorded meetings.  Pass the parameter once per value, e.g. `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.  Returns meetings recorded by any of the specified users.
        :param teams: Team names to filter by.  Pass the parameter once per value, e.g. `teams[]=Sales&teams[]=Engineering`.  Returns meetings that belong to any of the specified teams.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMeetingsRequest(
            calendar_invitees=calendar_invitees,
            calendar_invitees_domains=calendar_invitees_domains,
            calendar_invitees_domains_type=calendar_invitees_domains_type,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            meeting_type=meeting_type,
            recorded_by=recorded_by,
            teams=teams,
        )

        req = self._build_request_async(
            method="GET",
            path="/meetings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listMeetings",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListMeetingsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_meetings(
                calendar_invitees=calendar_invitees,
                calendar_invitees_domains=calendar_invitees_domains,
                calendar_invitees_domains_type=calendar_invitees_domains_type,
                created_after=created_after,
                created_before=created_before,
                cursor=next_cursor,
                include_action_items=include_action_items,
                include_crm_matches=include_crm_matches,
                include_summary=include_summary,
                include_transcript=include_transcript,
                meeting_type=meeting_type,
                recorded_by=recorded_by,
                teams=teams,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListMeetingsResponse(
                result=unmarshal_json_response(models.MeetingListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def get_recording_summary(
        self,
        *,
        recording_id: int,
        destination_url: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetRecordingSummaryResponse:
        r"""Get summary

        This endpoint has two behaviors depending on your request payload:
        - If you send `destination_url`, the endpoint will behave in an asynchronous manner.
        - If you do not send `destination_url`, the endpoint will return the data directly.


        :param recording_id: The ID of the meeting recording to fetch the call summary for.
        :param destination_url: Destination URL for where we'll POST the call summary. If not sent, this endpoint will return the data directly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRecordingSummaryRequest(
            recording_id=recording_id,
            destination_url=destination_url,
        )

        req = self._build_request(
            method="GET",
            path="/recordings/{recording_id}/summary",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRecordingSummary",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetRecordingSummaryResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def get_recording_summary_async(
        self,
        *,
        recording_id: int,
        destination_url: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetRecordingSummaryResponse:
        r"""Get summary

        This endpoint has two behaviors depending on your request payload:
        - If you send `destination_url`, the endpoint will behave in an asynchronous manner.
        - If you do not send `destination_url`, the endpoint will return the data directly.


        :param recording_id: The ID of the meeting recording to fetch the call summary for.
        :param destination_url: Destination URL for where we'll POST the call summary. If not sent, this endpoint will return the data directly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRecordingSummaryRequest(
            recording_id=recording_id,
            destination_url=destination_url,
        )

        req = self._build_request_async(
            method="GET",
            path="/recordings/{recording_id}/summary",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRecordingSummary",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetRecordingSummaryResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def get_recording_transcript(
        self,
        *,
        recording_id: int,
        destination_url: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetRecordingTranscriptResponse:
        r"""Get transcript

        This endpoint has two behaviors depending on your request payload:
        - If you send `destination_url`, the endpoint will behave in an asynchronous manner.
        - If you do not send `destination_url`, the endpoint will return the data directly.


        :param recording_id: The ID of the meeting recording to fetch the transcript for.
        :param destination_url: Destination URL for where we'll POST the transcript. If not sent, this endpoint will return the data directly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRecordingTranscriptRequest(
            recording_id=recording_id,
            destination_url=destination_url,
        )

        req = self._build_request(
            method="GET",
            path="/recordings/{recording_id}/transcript",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRecordingTranscript",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetRecordingTranscriptResponse, http_res
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def get_recording_transcript_async(
        self,
        *,
        recording_id: int,
        destination_url: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetRecordingTranscriptResponse:
        r"""Get transcript

        This endpoint has two behaviors depending on your request payload:
        - If you send `destination_url`, the endpoint will behave in an asynchronous manner.
        - If you do not send `destination_url`, the endpoint will return the data directly.


        :param recording_id: The ID of the meeting recording to fetch the transcript for.
        :param destination_url: Destination URL for where we'll POST the transcript. If not sent, this endpoint will return the data directly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRecordingTranscriptRequest(
            recording_id=recording_id,
            destination_url=destination_url,
        )

        req = self._build_request_async(
            method="GET",
            path="/recordings/{recording_id}/transcript",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRecordingTranscript",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetRecordingTranscriptResponse, http_res
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def list_teams(
        self,
        *,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListTeamsResponse]:
        r"""List teams

        :param cursor: Cursor for pagination.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListTeamsRequest(
            cursor=cursor,
        )

        req = self._build_request(
            method="GET",
            path="/teams",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listTeams",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListTeamsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_teams(
                cursor=next_cursor,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListTeamsResponse(
                result=unmarshal_json_response(models.TeamListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def list_teams_async(
        self,
        *,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListTeamsResponse]:
        r"""List teams

        :param cursor: Cursor for pagination.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListTeamsRequest(
            cursor=cursor,
        )

        req = self._build_request_async(
            method="GET",
            path="/teams",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listTeams",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListTeamsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_teams(
                cursor=next_cursor,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListTeamsResponse(
                result=unmarshal_json_response(models.TeamListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def list_team_members(
        self,
        *,
        cursor: Optional[str] = None,
        team: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListTeamMembersResponse]:
        r"""List team members

        :param cursor: Cursor for pagination.
        :param team: Team name to filter by.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListTeamMembersRequest(
            cursor=cursor,
            team=team,
        )

        req = self._build_request(
            method="GET",
            path="/team_members",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listTeamMembers",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListTeamMembersResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_team_members(
                cursor=next_cursor,
                team=team,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListTeamMembersResponse(
                result=unmarshal_json_response(models.TeamMemberListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def list_team_members_async(
        self,
        *,
        cursor: Optional[str] = None,
        team: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListTeamMembersResponse]:
        r"""List team members

        :param cursor: Cursor for pagination.
        :param team: Team name to filter by.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListTeamMembersRequest(
            cursor=cursor,
            team=team,
        )

        req = self._build_request_async(
            method="GET",
            path="/team_members",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listTeamMembers",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListTeamMembersResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list_team_members(
                cursor=next_cursor,
                team=team,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListTeamMembersResponse(
                result=unmarshal_json_response(models.TeamMemberListResponse, http_res),
                next=next_func,
            )
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def create_webhook(
        self,
        *,
        destination_url: str,
        triggered_for: List[models.CreateWebhookTriggeredFor],
        include_action_items: Optional[bool] = False,
        include_crm_matches: Optional[bool] = False,
        include_summary: Optional[bool] = False,
        include_transcript: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Webhook:
        r"""Create a webhook

        Create a webhook to receive new meeting content.
        At least one of `include_transcript`, `include_crm_matches`, `include_summary`, or `include_action_items` must be true.


        :param destination_url: The URL to send the webhook to.
        :param triggered_for: You must send at least one of the following types of recordings to trigger on. - `my_recordings`: Your private recordings, as well as those you've shared with individuals. (On Team Plans, this excludes recordings you've shared with any teams.) - `shared_external_recordings`: Recordings shared with you by other users. (For Team Plans, this does not include recordings shared by other users on your Team Plan.) - `my_shared_with_team_recordings`: (Team Plans only). All recordings that you have shared with other teams (e.g. Marketing or Sales). Recordings you've shared with individuals but not with teams are not included. - `shared_team_recordings`: (Team Plans only) All recordings you can access from other users on your Team Plan, whether shared with you individually or with your team.
        :param include_action_items: Include the action items for each meeting.
        :param include_crm_matches: Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.
        :param include_summary: Include the summary for each meeting.
        :param include_transcript: Include the transcript for each meeting.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateWebhookRequest(
            destination_url=destination_url,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            triggered_for=triggered_for,
        )

        req = self._build_request(
            method="POST",
            path="/webhooks",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateWebhookRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createWebhook",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Webhook, http_res)
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def create_webhook_async(
        self,
        *,
        destination_url: str,
        triggered_for: List[models.CreateWebhookTriggeredFor],
        include_action_items: Optional[bool] = False,
        include_crm_matches: Optional[bool] = False,
        include_summary: Optional[bool] = False,
        include_transcript: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Webhook:
        r"""Create a webhook

        Create a webhook to receive new meeting content.
        At least one of `include_transcript`, `include_crm_matches`, `include_summary`, or `include_action_items` must be true.


        :param destination_url: The URL to send the webhook to.
        :param triggered_for: You must send at least one of the following types of recordings to trigger on. - `my_recordings`: Your private recordings, as well as those you've shared with individuals. (On Team Plans, this excludes recordings you've shared with any teams.) - `shared_external_recordings`: Recordings shared with you by other users. (For Team Plans, this does not include recordings shared by other users on your Team Plan.) - `my_shared_with_team_recordings`: (Team Plans only). All recordings that you have shared with other teams (e.g. Marketing or Sales). Recordings you've shared with individuals but not with teams are not included. - `shared_team_recordings`: (Team Plans only) All recordings you can access from other users on your Team Plan, whether shared with you individually or with your team.
        :param include_action_items: Include the action items for each meeting.
        :param include_crm_matches: Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.
        :param include_summary: Include the summary for each meeting.
        :param include_transcript: Include the transcript for each meeting.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateWebhookRequest(
            destination_url=destination_url,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            triggered_for=triggered_for,
        )

        req = self._build_request_async(
            method="POST",
            path="/webhooks",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateWebhookRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createWebhook",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Webhook, http_res)
        if utils.match_response(http_res, ["400", "401", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def delete_webhook(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a webhook

        Delete a webhook.

        :param id: The ID of the webhook to delete.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteWebhookRequest(
            id=id,
        )

        req = self._build_request(
            method="DELETE",
            path="/webhooks/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteWebhook",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "404", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, ["400", "401", "404", "429", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def delete_webhook_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a webhook

        Delete a webhook.

        :param id: The ID of the webhook to delete.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteWebhookRequest(
            id=id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/webhooks/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteWebhook",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "404", "429", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, ["400", "401", "404", "429", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
