# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError as core_api_error_ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.api_error import ApiError as types_api_error_ApiError
from ..types.apidata_document import ApidataDocument
from ..types.apidata_document_collection import ApidataDocumentCollection
from ..types.apidata_document_search_response import ApidataDocumentSearchResponse
from ..types.create_document_request import CreateDocumentRequest
from ..types.search_type import SearchType
from ..types.success_response import SuccessResponse
from ..types.update_document_list_request import UpdateDocumentListRequest

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_collections(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.List[ApidataDocumentCollection]]:
        """
        Returns a list of all DocumentCollections.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[ApidataDocumentCollection]]
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.list_collections()
        """
        _response = self._client_wrapper.httpx_client.request(
            "collections", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[ApidataDocumentCollection]], _response.json())  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_collection(
        self, collection_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApidataDocumentCollection:
        """
        Returns a DocumentCollection if it exists.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocumentCollection
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.get_collection(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocumentCollection, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add_collection(
        self,
        collection_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        If a collection with the same name already exists, an error will be returned.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.add_collection(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}",
            method="POST",
            json={"description": description, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete_collection(
        self, collection_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        If a collection with the same name already exists, it will be overwritten.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.delete_collection(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def update_collection(
        self,
        collection_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates a DocumentCollection

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.update_collection(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}",
            method="PATCH",
            json={"description": description, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[CreateDocumentRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.List[str]]:
        """
        Creates Documents in a specified DocumentCollection and returns their UUIDs.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[CreateDocumentRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[str]]
            OK

        Examples
        --------
        from zep_cloud import CreateDocumentRequest
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.add_documents(
            collection_name="collectionName",
            request=[
                CreateDocumentRequest(
                    content="content",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[str]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def batch_delete_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deletes specified Documents from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.batch_delete_documents(
            collection_name="collectionName",
            request=["string"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchDelete",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def batch_get_documents(
        self,
        collection_name: str,
        *,
        document_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        uuids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.List[ApidataDocument]]:
        """
        Returns Documents from a DocumentCollection specified by UUID or ID.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_ids : typing.Optional[typing.Sequence[str]]

        uuids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[ApidataDocument]]
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.batch_get_documents(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchGet",
            method="POST",
            json={"document_ids": document_ids, "uuids": uuids},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[ApidataDocument]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def batch_update_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[UpdateDocumentListRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates Documents in a specified DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[UpdateDocumentListRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud import UpdateDocumentListRequest
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.batch_update_documents(
            collection_name="collectionName",
            request=[
                UpdateDocumentListRequest(
                    uuid_="uuid",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchUpdate",
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def gets_a_document_from_a_document_collection_by_uuid_cloud_only(
        self, collection_name: str, document_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApidataDocument:
        """
        Returns specified Document from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be updated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocument
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.gets_a_document_from_a_document_collection_by_uuid_cloud_only(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="GET",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocument, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete_document(
        self, collection_name: str, document_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Delete specified Document from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.delete_document(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def updates_a_document_cloud_only(
        self,
        collection_name: str,
        document_uuid: str,
        *,
        document_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates a Document in a DocumentCollection by UUID

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be updated

        document_id : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.updates_a_document_cloud_only(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="PATCH",
            json={"document_id": document_id, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def search(
        self,
        collection_name: str,
        *,
        limit: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApidataDocumentSearchResponse:
        """
        Searches over documents in a collection based on provided search criteria. One of text or metadata must be provided. Returns an empty list if no documents are found.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        limit : typing.Optional[int]
            Limit the number of returned documents

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Document metadata to filter on.

        min_score : typing.Optional[float]

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm.

        search_type : typing.Optional[SearchType]
            The type of search to perform. Defaults to "similarity". Must be one of "similarity" or "mmr".

        text : typing.Optional[str]
            The search text.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocumentSearchResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.document.search(
            collection_name="collectionName",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/search",
            method="POST",
            params={"limit": limit},
            json={
                "metadata": metadata,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "search_type": search_type,
                "text": text,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocumentSearchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDocumentClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_collections(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.List[ApidataDocumentCollection]]:
        """
        Returns a list of all DocumentCollections.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[ApidataDocumentCollection]]
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.list_collections()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "collections", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[ApidataDocumentCollection]], _response.json())  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_collection(
        self, collection_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApidataDocumentCollection:
        """
        Returns a DocumentCollection if it exists.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocumentCollection
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.get_collection(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocumentCollection, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add_collection(
        self,
        collection_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        If a collection with the same name already exists, an error will be returned.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.add_collection(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}",
            method="POST",
            json={"description": description, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_collection(
        self, collection_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        If a collection with the same name already exists, it will be overwritten.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.delete_collection(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def update_collection(
        self,
        collection_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates a DocumentCollection

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.update_collection(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}",
            method="PATCH",
            json={"description": description, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[CreateDocumentRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.List[str]]:
        """
        Creates Documents in a specified DocumentCollection and returns their UUIDs.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[CreateDocumentRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[str]]
            OK

        Examples
        --------
        from zep_cloud import CreateDocumentRequest
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.add_documents(
            collection_name="collectionName",
            request=[
                CreateDocumentRequest(
                    content="content",
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[str]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def batch_delete_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deletes specified Documents from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.batch_delete_documents(
            collection_name="collectionName",
            request=["string"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchDelete",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def batch_get_documents(
        self,
        collection_name: str,
        *,
        document_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        uuids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.List[ApidataDocument]]:
        """
        Returns Documents from a DocumentCollection specified by UUID or ID.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_ids : typing.Optional[typing.Sequence[str]]

        uuids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.List[ApidataDocument]]
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.batch_get_documents(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchGet",
            method="POST",
            json={"document_ids": document_ids, "uuids": uuids},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(typing.List[typing.List[ApidataDocument]], _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def batch_update_documents(
        self,
        collection_name: str,
        *,
        request: typing.Sequence[UpdateDocumentListRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates Documents in a specified DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        request : typing.Sequence[UpdateDocumentListRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud import UpdateDocumentListRequest
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.batch_update_documents(
            collection_name="collectionName",
            request=[
                UpdateDocumentListRequest(
                    uuid_="uuid",
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/batchUpdate",
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def gets_a_document_from_a_document_collection_by_uuid_cloud_only(
        self, collection_name: str, document_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApidataDocument:
        """
        Returns specified Document from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be updated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocument
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.gets_a_document_from_a_document_collection_by_uuid_cloud_only(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="GET",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocument, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_document(
        self, collection_name: str, document_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Delete specified Document from a DocumentCollection.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.delete_document(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def updates_a_document_cloud_only(
        self,
        collection_name: str,
        document_uuid: str,
        *,
        document_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Updates a Document in a DocumentCollection by UUID

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        document_uuid : str
            UUID of the Document to be updated

        document_id : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.updates_a_document_cloud_only(
            collection_name="collectionName",
            document_uuid="documentUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/documents/uuid/{jsonable_encoder(document_uuid)}",
            method="PATCH",
            json={"document_id": document_id, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def search(
        self,
        collection_name: str,
        *,
        limit: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApidataDocumentSearchResponse:
        """
        Searches over documents in a collection based on provided search criteria. One of text or metadata must be provided. Returns an empty list if no documents are found.

        Parameters
        ----------
        collection_name : str
            Name of the Document Collection

        limit : typing.Optional[int]
            Limit the number of returned documents

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Document metadata to filter on.

        min_score : typing.Optional[float]

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm.

        search_type : typing.Optional[SearchType]
            The type of search to perform. Defaults to "similarity". Must be one of "similarity" or "mmr".

        text : typing.Optional[str]
            The search text.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApidataDocumentSearchResponse
            OK

        Examples
        --------
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.document.search(
            collection_name="collectionName",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"collections/{jsonable_encoder(collection_name)}/search",
            method="POST",
            params={"limit": limit},
            json={
                "metadata": metadata,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "search_type": search_type,
                "text": text,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(ApidataDocumentSearchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)
