# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1


class EntityEdge(pydantic_v1.BaseModel):
    created_at: str = pydantic_v1.Field()
    """
    Creation time of the edge
    """

    episodes: typing.Optional[typing.List[str]] = pydantic_v1.Field(default=None)
    """
    List of episode ids that reference these entity edges
    """

    expired_at: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Datetime of when the node was invalidated
    """

    fact: str = pydantic_v1.Field()
    """
    Fact representing the edge and nodes that it connects
    """

    invalid_at: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Datetime of when the fact stopped being true
    """

    name: str = pydantic_v1.Field()
    """
    Name of the edge, relation name
    """

    source_node_uuid: str = pydantic_v1.Field()
    """
    UUID of the source node
    """

    target_node_uuid: str = pydantic_v1.Field()
    """
    UUID of the target node
    """

    uuid_: str = pydantic_v1.Field(alias="uuid")
    """
    UUID of the edge
    """

    valid_at: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Datetime of when the fact became true
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
