# coding: utf-8

"""
    STACKIT Git API

    STACKIT Git management API.

    The version of the OpenAPI document: 1beta.0.4
    Contact: git@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self


class CreateInstancePayload(BaseModel):
    """
    Request a STACKIT Git instance to be created with these properties.
    """  # noqa: E501

    acl: Optional[Annotated[List[StrictStr], Field(max_length=50)]] = Field(
        default=None, description="A list of CIDR network addresses that are allowed to access the instance."
    )
    flavor: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(
        default=None, description="Desired instance flavor. Must be one of the defined enum values"
    )
    name: Annotated[str, Field(min_length=5, strict=True, max_length=32)] = Field(
        description="A user chosen name to distinguish multiple STACKIT Git instances."
    )
    __properties: ClassVar[List[str]] = ["acl", "flavor", "name"]

    @field_validator("flavor")
    def flavor_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["git-10", "git-100"]):
            raise ValueError("must be one of enum values ('git-10', 'git-100')")
        return value

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z]([a-z0-9\-]){0,30}[a-z0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-z]([a-z0-9\-]){0,30}[a-z0-9]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInstancePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInstancePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({"acl": obj.get("acl"), "flavor": obj.get("flavor"), "name": obj.get("name")})
        return _obj
