"""
This type stub file was generated by pyright.
"""

"""
sasl.py - support for SASL mechanism

See https://www.python-ldap.org/ for details.

Description:
The ldap.sasl module provides SASL authentication classes.
Each class provides support for one SASL mechanism. This is done by
implementing a callback() - method, which will be called by the
LDAPObject's sasl_bind_s() method
Implementing support for new sasl mechanism is very easy --- see
the examples of digest_md5 and gssapi.
"""
if __debug__:
    ...
CB_USER = ...
CB_AUTHNAME = ...
CB_LANGUAGE = ...
CB_PASS = ...
CB_ECHOPROMPT = ...
CB_NOECHOPROMPT = ...
CB_GETREALM = ...
class sasl:
    """
    This class handles SASL interactions for authentication.
    If an instance of this class is passed to ldap's sasl_bind_s()
    method, the library will call its callback() method. For
    specific SASL authentication mechanisms, this method can be
    overridden
    """
    def __init__(self, cb_value_dict, mech) -> None:
        """
        The (generic) base class takes a cb_value_dictionary of
        question-answer pairs. Questions are specified by the respective
        SASL callback id's. The mech argument is a string that specifies
        the SASL mechaninsm to be uesd.
        """
        ...
    
    def callback(self, cb_id, challenge, prompt, defresult): # -> bytes:
        """
        The callback method will be called by the sasl_bind_s()
        method several times. Each time it will provide the id, which
        tells us what kind of information is requested (the CB_*
        constants above). The challenge might be a short (English) text
        or some binary string, from which the return value is calculated.
        The prompt argument is always a human-readable description string;
        The defresult is a default value provided by the sasl library

        Currently, we do not use the challenge and prompt information, and
        return only information which is stored in the self.cb_value_dict
        cb_value_dictionary. Note that the current callback interface is not very
        useful for writing generic sasl GUIs, which would need to know all
        the questions to ask, before the answers are returned to the sasl
        lib (in contrast to one question at a time).

        Unicode strings are always converted to bytes.
        """
        ...
    


class cram_md5(sasl):
    """
    This class handles SASL CRAM-MD5 authentication.
    """
    def __init__(self, authc_id, password, authz_id=...) -> None:
        ...
    


class digest_md5(sasl):
    """
    This class handles SASL DIGEST-MD5 authentication.
    """
    def __init__(self, authc_id, password, authz_id=...) -> None:
        ...
    


class gssapi(sasl):
    """
    This class handles SASL GSSAPI (i.e. Kerberos V) authentication.
    """
    def __init__(self, authz_id=...) -> None:
        ...
    


class external(sasl):
    """
    This class handles SASL EXTERNAL authentication
    (i.e. X.509 client certificate)
    """
    def __init__(self, authz_id=...) -> None:
        ...
    


