"""
This type stub file was generated by pyright.
"""

from collections import UserDict

"""
schema.py - support for subSchemaSubEntry information

See https://www.python-ldap.org/ for details.
"""
NOT_HUMAN_READABLE_LDAP_SYNTAXES = ...
class SchemaElement:
  """
  Base class for all schema element classes. Not used directly!

  Arguments:

  schema_element_str
    String which contains the schema element description to be parsed.
    (Bytestrings are decoded using UTF-8)

  Class attributes:

  schema_attribute
    LDAP attribute type containing a certain schema element description
  token_defaults
    Dictionary internally used by the schema element parser
    containing the defaults for certain schema description key-words
  """
  token_defaults = ...
  def __init__(self, schema_element_str=...) -> None:
    ...
  
  def set_id(self, element_id): # -> None:
    ...
  
  def get_id(self):
    ...
  
  def key_attr(self, key, value, quoted=...): # -> str:
    ...
  
  def key_list(self, key, values, sep=..., quoted=...): # -> str:
    ...
  
  def __str__(self) -> str:
    ...
  


class ObjectClass(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an ObjectClassDescription

  Class attributes:

  oid
    OID assigned to the object class
  names
    All NAMEs of the object class (tuple of strings)
  desc
    Description text (DESC) of the object class (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the object class is marked
    as OBSOLETE in the schema
  must
    NAMEs or OIDs of all attributes an entry of the object class must have
    (tuple of strings)
  may
    NAMEs or OIDs of additional attributes an entry of the object class may
    have (tuple of strings)
  kind
    Kind of an object class:
    0 = STRUCTURAL,
    1 = ABSTRACT,
    2 = AUXILIARY
  sup
    NAMEs or OIDs of object classes this object class is derived from
    (tuple of strings)
  x_origin
    Value of the X-ORIGIN extension flag (tuple of strings)

    Although it's not official, X-ORIGIN is used in several LDAP server
    implementations to indicate the source of the associated schema
    element
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


AttributeUsage = ...
class AttributeType(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an AttributeTypeDescription

  Class attributes:

  oid
    OID assigned to the attribute type (string)
  names
    All NAMEs of the attribute type (tuple of strings)
  desc
    Description text (DESC) of the attribute type (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the attribute type is marked
    as OBSOLETE in the schema
  single_value
    Integer flag (0 or 1) indicating whether the attribute must
    have only one value
  syntax
    OID of the LDAP syntax assigned to the attribute type
  no_user_mod
    Integer flag (0 or 1) indicating whether the attribute is modifiable
    by a client application
  equality
    NAME or OID of the matching rule used for checking whether attribute values
    are equal (string, or None if missing)
  substr
    NAME or OID of the matching rule used for checking whether an attribute
    value contains another value (string, or None if missing)
  ordering
    NAME or OID of the matching rule used for checking whether attribute values
    are lesser-equal than (string, or None if missing)
  usage
    USAGE of an attribute type:
    0 = userApplications
    1 = directoryOperation,
    2 = distributedOperation,
    3 = dSAOperation
  sup
    NAMEs or OIDs of attribute types this attribute type is derived from
    (tuple of strings)
  x_origin
    Value of the X-ORIGIN extension flag (tuple of strings).

    Although it's not official, X-ORIGIN is used in several LDAP server
    implementations to indicate the source of the associated schema
    element
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class LDAPSyntax(SchemaElement):
  """
  SyntaxDescription

  oid
    OID assigned to the LDAP syntax
  desc
    Description text (DESC) of the LDAP syntax (string, or None if missing)
  not_human_readable
    Integer flag (0 or 1) indicating whether the attribute type is marked
    as not human-readable (X-NOT-HUMAN-READABLE)
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class MatchingRule(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an MatchingRuleDescription

  Class attributes:

  oid
    OID assigned to the matching rule
  names
    All NAMEs of the matching rule (tuple of strings)
  desc
    Description text (DESC) of the matching rule
  obsolete
    Integer flag (0 or 1) indicating whether the matching rule is marked
    as OBSOLETE in the schema
  syntax
    OID of the LDAP syntax this matching rule is usable with
    (string, or None if missing)
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class MatchingRuleUse(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an MatchingRuleUseDescription

  Class attributes:

  oid
    OID of the accompanying matching rule
  names
    All NAMEs of the matching rule (tuple of strings)
  desc
    Description text (DESC) of the matching rule (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the matching rule is marked
    as OBSOLETE in the schema
  applies
    NAMEs or OIDs of attribute types for which this matching rule is used
    (tuple of strings)
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class DITContentRule(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an DITContentRuleDescription

  Class attributes:

  oid
    OID of the accompanying structural object class
  names
    All NAMEs of the DIT content rule (tuple of strings)
  desc
    Description text (DESC) of the DIT content rule
    (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the DIT content rule is marked
    as OBSOLETE in the schema
  aux
    NAMEs or OIDs of all auxiliary object classes usable in an entry of the
    object class (tuple of strings)
  must
    NAMEs or OIDs of all attributes an entry of the object class must
    have, which may extend the list of required attributes of the object
    classes of an entry.
    (tuple of strings)
  may
    NAMEs or OIDs of additional attributes an entry of the object class may
    have. which may extend the list of optional attributes of the object
    classes of an entry.
    (tuple of strings)
  nots
    NAMEs or OIDs of attributes which may not be present in an entry of the
    object class. (tuple of strings)
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class DITStructureRule(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an DITStructureRuleDescription

  Class attributes:

  ruleid
    rule ID of the DIT structure rule (only locally unique)
  names
    All NAMEs of the DIT structure rule (tuple of strings)
  desc
    Description text (DESC) of the DIT structure rule
    (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the DIT content rule is marked
    as OBSOLETE in the schema
  form
    NAMEs or OIDs of associated name forms (tuple of strings)
  sup
    NAMEs or OIDs of allowed structural object classes
    of superior entries in the DIT (tuple of strings)
  """
  schema_attribute = ...
  token_defaults = ...
  def set_id(self, element_id): # -> None:
    ...
  
  def get_id(self):
    ...
  
  def __str__(self) -> str:
    ...
  


class NameForm(SchemaElement):
  """
  Arguments:

  schema_element_str
    String containing an NameFormDescription

  Class attributes:

  oid
    OID of the name form
  names
    All NAMEs of the name form (tuple of strings)
  desc
    Description text (DESC) of the name form (string, or None if missing)
  obsolete
    Integer flag (0 or 1) indicating whether the name form is marked
    as OBSOLETE in the schema
  form
    NAMEs or OIDs of associated name forms (tuple of strings)
  oc
    NAME or OID of structural object classes this name form
    is usable with (string)
  must
    NAMEs or OIDs of all attributes an RDN must contain (tuple of strings)
  may
    NAMEs or OIDs of additional attributes an RDN may contain
    (tuple of strings)
  """
  schema_attribute = ...
  token_defaults = ...
  def __str__(self) -> str:
    ...
  


class Entry(UserDict):
  """
  Schema-aware implementation of an LDAP entry class.

  Mainly it holds the attributes in a string-keyed dictionary with
  the OID as key.
  """
  def __init__(self, schema, dn, entry) -> None:
    ...
  
  def update(self, dict): # -> None:
    ...
  
  def __contains__(self, nameoroid): # -> bool:
    ...
  
  def __getitem__(self, nameoroid):
    ...
  
  def __setitem__(self, nameoroid, attr_values): # -> None:
    ...
  
  def __delitem__(self, nameoroid): # -> None:
    ...
  
  def has_key(self, nameoroid): # -> bool:
    ...
  
  def keys(self): # -> dict_values[Any, Any]:
    ...
  
  def items(self): # -> list[tuple[Any, Any]]:
    ...
  
  def attribute_types(self, attr_type_filter=..., raise_keyerror=...):
    """
    Convenience wrapper around SubSchema.attribute_types() which
    passes object classes of this particular entry as argument to
    SubSchema.attribute_types()
    """
    ...
  


