/*
 *  mixmax.c
 *  A Pseudo-Random Number Generator
 *  
 * skipping coefficients for N=240, m=2^51+1 and s=487013230256099140
 * Property of K. Savvidy, requires a permission for redistribution
 
 *	G.K.Savvidy and N.G.Ter-Arutyunian,
 *  On the Monte Carlo simulation of physical systems,
 *	J.Comput.Phys. 97, 566 (1991);
 *  Preprint EPI-865-16-86, Yerevan, Jan. 1986
 *
 *  K.Savvidy
 *  The MIXMAX random number generator
 *  Comp. Phys. Commun. 196 (2015), pp 161–165
 *  http://dx.doi.org/10.1016/j.cpc.2015.06.003
 *
 */


/* coefficients for N=240
 */


{

{ 147557768950818897 ,  825133352304978716 ,  1959369794442930943 ,  157945336809794517 ,  1007305741538005548 ,  997845597835227837 ,  2237106781065501670 ,  185411209385525488 ,  2155022964904000251 ,  54539580860463617 ,  2195617775622918670 ,  2176604593526135726 ,  1356798058257258300 ,  427496932780309659 ,  1919420557375826938 ,  1492825106609310508 ,  1314351910136580423 ,  1859694927360852075 ,  2201695788582002371 ,  227246664072247390 ,  965553353716081879 ,  1434987628057099775 ,  1916496220691828231 ,  289384880218753401 ,  894161154704979014 ,  633653029449970378 ,  1236272720725765006 ,  2086689110939840754 ,  1455682030489107722 ,  975041398069222507 ,  2094968468839838096 ,  1237065014190114849 ,  870626492287412674 ,  536169457944296816 ,  1327073549461903065 ,  1514335406189461372 ,  151283940608608510 ,  1479880287909622486 ,  1300484922029491001 ,  1682646551246977543 ,  639541909128079591 ,  976828589587193989 ,  1764013895438172888 ,  113216187002346785 ,  2160126783682940354 ,  2060546360254012295 ,  572940092830729459 ,  592955518802844020 ,  1333842590302396923 ,  226084636249372661 ,  920750053406496685 ,  889511921922433300 ,  1907023540291672501 ,  919578268831452643 ,  986495881417338512 ,  699313664677333747 ,  1112177957473970520 ,  1678762831593490453 ,  1295088653369360855 ,  1551564599847040965 ,  655287105059054148 ,  1590259782564288523 ,  476543029513928666 ,  610939162506416036 ,  595720634894551748 ,  1390930602623980143 ,  1051700865676532821 ,  792101631719963176 ,  164135526749315322 ,  121442973140252410 ,  1526905098362006848 ,  1959782908437738504 ,  1578853935895456931 ,  2234421900395440184 ,  1483617795422191953 ,  2137283160171860220 ,  496110616750889044 ,  1078043880140815952 ,  582817630982790765 ,  726530627219841402 ,  1903408108676642458 ,  1123366204827856121 ,  884648326069047510 ,  1152851950882035999 ,  2269495717337963856 ,  837487726629726120 ,  547290367881407217 ,  1670722237948011543 ,  422806319888869177 ,  388045795241582476 ,  606947857089386994 ,  301893080888120663 ,  1842937995893957814 ,  849381636074980672 ,  1656270665869103977 ,  425838724641808481 ,  2225543517503903825 ,  1894525919926094810 ,  824773463489918877 ,  318853014444323322 ,  1543782532867732791 ,  1343013891813047935 ,  1545635365911253591 ,  1888614976277859549 ,  1564502174845857810 ,  1633160136697916746 ,  403928369802739612 ,  1431172374500668030 ,  2006996260727663508 ,  1857359427185949363 ,  537398480086304822 ,  147461498635386865 ,  1643760418831452469 ,  1386740592853441134 ,  264058735614174300 ,  1157025362688192408 ,  200709821719439190 ,  382394598187517192 ,  2205811985192200553 ,  2027891021050912853 ,  287831077498042146 ,  823589730094807737 ,  777635196419996272 ,  339509647791133518 ,  499757401593278672 ,  1809050636364629368 ,  1572231734616042570 ,  2117215407288229907 ,  2176450221840286908 ,  1113980961121210855 ,  890058969996700068 ,  642179106222351463 ,  765956510942033289 ,  1228557813627054973 ,  118441667218472692 ,  668911609195039873 ,  1383504984237036229 ,  602610849208126208 ,  1302959072774195296 ,  1729386990189151269 ,  1825081051151424415 ,  954699948553452528 ,  2264226523406665903 ,  389787434342062000 ,  942057577805181747 ,  1786523444013582547 ,  2300410435977113311 ,  610768371573859701 ,  2298076785355297249 ,  404990238303387938 ,  2249257972884539477 ,  1928871505615911866 ,  1762047314745145061 ,  841384265237817563 ,  1823419327761111224 ,  1459878028890436401 ,  2222063805218571626 ,  1061691836571274536 ,  1274620160918893236 ,  1742650977348871242 ,  1342463319698575930 ,  2114603942385321024 ,  1460313320550359984 ,  397402588407622684 ,  1216892749502126676 ,  1499132182875011452 ,  858596060575300712 ,  1877215981583465478 ,  488343221559502614 ,  493125101341847021 ,  1291543964932828745 ,  1843628915311556562 ,  798586855414764921 ,  1315628484174312914 ,  787891125323599379 ,  2061544207702904179 ,  1275949254516541820 ,  2092370888389961724 ,  1363263955192735252 ,  1072380113410913494 ,  234074410447838831 ,  964809835619086142 ,  401509299174850166 ,  1775755870670254816 ,  108560052546291732 ,  1103323288654561794 ,  946813664129831717 ,  1099069091609129491 ,  706837161941725420 ,  672642017864389897 ,  651930067546542625 ,  2041452310288495960 ,  1585953072690956323 ,  186194483389532017 ,  665440674501317339 ,  1455436521915403036 ,  120842309465829389 ,  1006783954844339472 ,  2117871784277292328 ,  307163978502546896 ,  843611804202762820 ,  1219147558952192984 ,  466993243531218455 ,  1113168385275739535 ,  1041318111979082324 ,  1452216819674686211 ,  1630372107707391861 ,  320556529444760069 ,  794619751841609504 ,  1964507749046518922 ,  1747354630645615381 ,  1702809289750489301 ,  339284922226076423 ,  1194548004760742663 ,  301176186326634873 ,  485530764652639481 ,  123314854642744253 ,  691939667259864398 ,  1169045420378844024 ,  1347633953871341061 ,  456352244423098764 ,  1989808746910566307 ,  432173122426839919 ,  2102595220152310658 ,  197563487849930037 ,  1951068228746731061 ,  953386214754916295 ,  178973722315795092 ,  12142407719131820 ,  1274105595381578369 ,  1277734573595430723 ,  522888005534671070 ,  2066087202440915022 ,  2112904888496860434 ,  1536484714433573084 ,  291647934747674929 ,  1868765057321343189 ,  128309017256193112 ,  148287326175054698 ,  726633148030527597 }, // x^2^512

{ 152053818506178025 ,  1392434774907374555 ,  1351146690584614178 ,  947101898762899903 ,  1497813749782919976 ,  1074352678451536874 ,  2002450022429974310 ,  1685270340636773209 ,  1389176229214392458 ,  850598468984590143 ,  746724593208858112 ,  1410661215306733476 ,  1981652493559602609 ,  1248846559570771078 ,  308676097285831304 ,  53001073677294067 ,  386953691531817196 ,  435786308394160457 ,  1404926690151978771 ,  1452142847392457800 ,  1993637292575004327 ,  168696064886047358 ,  521441241451621980 ,  536101196488742815 ,  1523322290384329668 ,  766786857012649095 ,  1074912521641254720 ,  1000250134859510398 ,  1621298897286695715 ,  576180572412539333 ,  1580042343521808044 ,  2043014702345813380 ,  1086237814252765953 ,  64242871744048186 ,  39511613311139901 ,  563379432898565948 ,  552826332874252630 ,  226114948390163580 ,  83599720669978940 ,  1133503294879722255 ,  466702721875424320 ,  2149859679811532706 ,  1561849875299340103 ,  106120889471119059 ,  1234614201396471062 ,  1422643817717325226 ,  648756485483133798 ,  738232706267424893 ,  1931657442385370990 ,  833379924115682898 ,  1966158160446379358 ,  1798795367163567432 ,  730161549861724827 ,  1939119434672454598 ,  1658290667248038944 ,  1914442509036710898 ,  1484213305123086992 ,  547070694640776407 ,  1621653733763054136 ,  1482351715542747324 ,  656675476946556972 ,  1559201439879688310 ,  142086210801326187 ,  1411599350254602446 ,  251006120013358952 ,  1291049948372419455 ,  1764018639129776014 ,  871373468171522432 ,  386011503703366635 ,  655246574931994828 ,  1553678858837939756 ,  1126349462668338434 ,  1645980347834286828 ,  1880621130000333281 ,  1393297028364057316 ,  1348512815375056469 ,  1331357441562084578 ,  1142667776432759790 ,  1438625696711060591 ,  209640709059112990 ,  1410313813914432753 ,  1659080210619738567 ,  1663615913016708266 ,  866841148412138004 ,  1863864992397707919 ,  2135723550488344091 ,  1251649677046749679 ,  1597533466512082678 ,  2044690826087890117 ,  1264080888975615137 ,  2218439535654843211 ,  381904180259717360 ,  615644354280012168 ,  1740121323421494964 ,  1424179670267840288 ,  1401617865930733304 ,  1315853788135992222 ,  1264883624781927369 ,  605945136168883166 ,  198805548425342762 ,  123250202901917710 ,  346420884514028200 ,  247590428673995643 ,  2220810864949542276 ,  954226705294108399 ,  36756247642643483 ,  948988955841920110 ,  1953812693557692085 ,  868456791583573344 ,  1715335324694524756 ,  193885053090764797 ,  888692937505544268 ,  394579250943533968 ,  26193046762681854 ,  811367869586341039 ,  1029735953525790336 ,  1382895505238938049 ,  514418985761372337 ,  249833241452691971 ,  728759016430037016 ,  1288862039514107798 ,  463230078068476209 ,  163559122784242955 ,  2045657635678488911 ,  222736983484368039 ,  2187494041244429429 ,  2245371094256133023 ,  1299448291411574045 ,  824745627037501824 ,  1137472145563063980 ,  1482772405591064507 ,  188944240571858092 ,  1376116393253740916 ,  804070616344935495 ,  1252202783316907793 ,  1520888214076578083 ,  938521836691220584 ,  480344897099870521 ,  174923194287192737 ,  91703801935667063 ,  1065529061573003426 ,  1294689260434560254 ,  288308991737458245 ,  1384546091374705185 ,  1027694242329684203 ,  1724283077335727014 ,  1329231779177191520 ,  710750565064373744 ,  1990010457085553185 ,  860545701253702909 ,  888095158029991212 ,  1894181579748437901 ,  104638606032691777 ,  472217766345943178 ,  1232117346253397185 ,  1746658791977979197 ,  2226241758905998096 ,  571011967137628194 ,  913410604521919105 ,  2004943075087888633 ,  47979303804677653 ,  876293171388675821 ,  1900062804473511780 ,  1314947343937637536 ,  2016672687792363994 ,  650318661216762578 ,  967697704940063911 ,  911454546536521401 ,  313100846909225230 ,  2095691786027250547 ,  68971783891098327 ,  1421250778785627443 ,  869397621084575987 ,  6355633451375459 ,  1347572850094546240 ,  1640211313189403938 ,  2303057065826777070 ,  697025671443250870 ,  1051541455465198670 ,  701986661041539216 ,  2209043882581178463 ,  1113938794620717504 ,  160125180826860706 ,  1679568876176056684 ,  1500420292766973170 ,  627155335598826244 ,  1177131499970336055 ,  1629921509254469684 ,  2102944858011626261 ,  1276350372330980279 ,  2012494254006893409 ,  948635849440296628 ,  881405775005441534 ,  1163437193471942890 ,  452416765204005972 ,  1397891284331860987 ,  1462042044263227053 ,  1073575694829006933 ,  245407720848386108 ,  1505861838166216594 ,  1055221243095961084 ,  438736335910238527 ,  2299487558181110639 ,  1611739408219402877 ,  1712867234977620862 ,  240176459387277586 ,  234330474425746942 ,  1348563818408777482 ,  1647584359116330110 ,  735167617189857300 ,  294750226195820837 ,  2253146758816799229 ,  1170604787250220541 ,  1975275685705582636 ,  1702530642619688991 ,  1330150990961963215 ,  1319310079021271808 ,  755897341758714548 ,  1819816434777546945 ,  1188028063037777674 ,  984983846677940666 ,  2028765804510220568 ,  1410353660522414089 ,  716149322392522976 ,  1952697384167739783 ,  259873076709602626 ,  1517304177614512973 ,  632716854172983544 ,  651403256090818403 ,  412638510710555254 ,  1392042666308798597 ,  647321747157878473 ,  109226345787671823 ,  1473967054558075862 ,  1302645417580077198 ,  776428362404392538 ,  1021568058323039290 ,  396697373782960415 ,  1295881302380543065 ,  1470476179059321829 }, // x^2^513

{ 1726000400445754541 ,  2078121029474912598 ,  732602202010222960 ,  1302897538740175981 ,  1243296221740246737 ,  21296829714542588 ,  1078144553485814889 ,  499612937429804074 ,  152606310052512613 ,  1660272455550539053 ,  1623661730489502675 ,  647770902014565571 ,  119137770343796813 ,  1989598272379610026 ,  821387340478708435 ,  520264784447485020 ,  1583378630415781998 ,  665682735625950817 ,  989688396862805464 ,  705648909235027634 ,  302484962588489459 ,  1853015804142949869 ,  902151970608556161 ,  779000488649309457 ,  1919496864585677731 ,  210996660525284839 ,  801021535761379618 ,  980589178459849751 ,  1416515593457662660 ,  951117623398183999 ,  460313554667886436 ,  1836241133810642640 ,  263926681682153421 ,  418472142625865530 ,  836010910990536378 ,  895863295452207882 ,  376749473859498743 ,  2249563551285340 ,  1797553658400825882 ,  817617683040091276 ,  768697987369375617 ,  727182936696722977 ,  939074503151204967 ,  398902187092784062 ,  1617866450979818701 ,  2080549694761529492 ,  728590965478435550 ,  1240206805490389285 ,  713830349579433467 ,  708032314929262329 ,  902230408992365911 ,  2151382305653737154 ,  105932673767180723 ,  534318949503425580 ,  1647146930774182053 ,  1382033592896749005 ,  427514795570822056 ,  2253974512686480198 ,  1815119033562280083 ,  2193757905616121999 ,  921823625017951272 ,  110842686986834023 ,  896537055939501809 ,  887513929264771012 ,  1963348111735666972 ,  1199594186185070430 ,  1382344326047150142 ,  348209622580676414 ,  759283876375482848 ,  1301730830807904589 ,  880521417871421998 ,  1407011729544421910 ,  856929762896575588 ,  1230278909456520995 ,  1896217803497317182 ,  846749286973598403 ,  160173474754724860 ,  27701014704521521 ,  2241582976126598612 ,  573323215364336847 ,  207055681577883556 ,  1604247846550765043 ,  1135166205481048802 ,  2118356094119008752 ,  2272448257902145009 ,  1831996797195880760 ,  1560658885387003237 ,  488837366280258405 ,  587268768989104125 ,  307171494425683642 ,  1597123101386975045 ,  1271453265763255608 ,  1907902693197701247 ,  1270679240830680495 ,  1818585837318575938 ,  407786825625065497 ,  273378728289958877 ,  54887250390284220 ,  1075501989024595377 ,  253835455759819414 ,  1057735583731938890 ,  1570893197416133064 ,  941808687876056054 ,  1951926054973770095 ,  632180677080456146 ,  267755124757354365 ,  848555371287511182 ,  267445000043244063 ,  1794486527102123539 ,  960436570838786569 ,  431598340357537722 ,  2122845840634412908 ,  1408862928016972867 ,  1139974968708992659 ,  1349953997300137260 ,  1923977775066804901 ,  877268451840569464 ,  1127421615533524334 ,  125186428769333068 ,  1729389561053389386 ,  1022829124096322994 ,  1643859921311414235 ,  1164596719309718631 ,  1263280648182695657 ,  2185804400040599136 ,  506654482411174089 ,  1300322139489648630 ,  237040593093736745 ,  593582225056257079 ,  1862783486938207084 ,  1743074229840207570 ,  1074030020119546548 ,  390146682015738754 ,  1418023218806280617 ,  2302151132967690174 ,  255722564663443461 ,  914010832406414807 ,  1998545083969951572 ,  1882778022500176281 ,  501087451589489202 ,  1163493834634530061 ,  1761491996782377613 ,  253081392780015420 ,  1710966945172427856 ,  488947733080294772 ,  474635197041421813 ,  1345016584776830097 ,  1161274388418216958 ,  249434988300096138 ,  713461436528052438 ,  521157677735726565 ,  785412878710071089 ,  1656675291942892326 ,  592838701155929275 ,  1458059076807671511 ,  316332204227828928 ,  662522646542051405 ,  258469722309433365 ,  372607363184306090 ,  562866461695032568 ,  178941522264679640 ,  398674053274165394 ,  1298785987151240683 ,  1370277890262031458 ,  1563028156762137128 ,  1354587525242332071 ,  271602887750696109 ,  481609100035361278 ,  1196740050221398283 ,  947494376431937610 ,  1859461722270667187 ,  1797883752048770441 ,  417497040555828063 ,  90714226813319924 ,  1933294680786528163 ,  838119849482741639 ,  1681105345511371421 ,  2088423095324315062 ,  833960657126842319 ,  634983459331152598 ,  1129165720811705927 ,  270310826318221034 ,  1409333392013635475 ,  1978154072906838259 ,  1613525061705089403 ,  684077889448151311 ,  324515998802625995 ,  1908478499639933414 ,  111498141741218506 ,  30986221150875057 ,  344338840256309920 ,  1620326972560168880 ,  106212048277145821 ,  1692651336945773833 ,  1764247727410531046 ,  1819179934402015452 ,  1146760080781196860 ,  16836044960347962 ,  1838690779782988462 ,  2028098934972331112 ,  43307265698772677 ,  32868706197763025 ,  1313490231158454532 ,  1398486589813731862 ,  204606985529384615 ,  1028241334640188156 ,  267437006908659792 ,  536267069504210853 ,  1183727189289851653 ,  2086816063435316670 ,  81411224093991583 ,  93356628812452800 ,  556523968053550204 ,  1485741747439234308 ,  241097288203937893 ,  2304638977334003000 ,  80173423574213091 ,  1881947177734483691 ,  231778702015178918 ,  865036952873093477 ,  20048968492170106 ,  1804608129121046178 ,  1129117402027319117 ,  1830518228863032106 ,  1389282783625475640 ,  1203348987548449859 ,  307809597311544057 ,  294865314352745783 ,  2170235468505404493 ,  848528376602558630 ,  1664209858184963320 ,  736784054841003565 ,  1309730847110011392 ,  1755388327958704809 ,  1406021805309350663 ,  1119015085415100299 ,  2003626702157951442 ,  2190358398410158950 ,  198622257278788708 ,  906292284147262674 }, // x^2^514

{ 1466370053304250000 ,  1114583952073505271 ,  1675825645819552262 ,  1226168676621269044 ,  394190169912383784 ,  1304189796616102150 ,  1984895148625429126 ,  1925960132798605649 ,  1268712293860949566 ,  1336319401266642445 ,  92569795893648287 ,  1845578106533195263 ,  1527710748062178492 ,  70362224765489752 ,  1261563323270168613 ,  966671706984541096 ,  990439976298305104 ,  788624260440911350 ,  873700654403745979 ,  1563392902584972482 ,  85214545959793492 ,  1601954623722315072 ,  652314940232916513 ,  2115224289268022402 ,  2271838060183772457 ,  1717318596758420515 ,  1462864802887422278 ,  1397347908902566285 ,  2042951665491656951 ,  307812413032047417 ,  1160013675681179466 ,  1676805944856595088 ,  2047566839814193978 ,  361488266097090305 ,  971749777890922892 ,  887478743883955999 ,  412161941639343030 ,  2300655887594779519 ,  2115158143036540573 ,  2194873246352419974 ,  2148813911271019748 ,  1977555370892924289 ,  421393487362434671 ,  39027070774393729 ,  1066317548614219323 ,  2274354133703169195 ,  74626886249513749 ,  1981804690861239281 ,  1244663083716634978 ,  720220677752928537 ,  1934174296382270526 ,  765811225091142797 ,  1291811435588202566 ,  1985320420109055912 ,  260795320417236356 ,  912500941594496839 ,  1806052334886938704 ,  759851055140531772 ,  1102210966249479690 ,  98601083579087581 ,  565617241614207003 ,  33117558703115614 ,  1527977208442195942 ,  109548708041323762 ,  667655955507914473 ,  37412073729305288 ,  289923547107664365 ,  1842456851094550000 ,  1706950882484271078 ,  710042724754662250 ,  1358541098951380874 ,  1483040310898198888 ,  1793831596734746841 ,  255893098266352533 ,  2207392970321981110 ,  1425475095405606854 ,  1683345396488063911 ,  667343831561094988 ,  1050333158278941947 ,  1888502693325903901 ,  864958015633780212 ,  24655683293917901 ,  2055186153829533164 ,  1577510425931191370 ,  2020742183627177457 ,  2239443249180231123 ,  808174115298249986 ,  735508088702347827 ,  1961747843919930098 ,  784512442185698570 ,  542433824302309326 ,  2156323284122226861 ,  422127544692596925 ,  456140756691695136 ,  1592005635508889774 ,  1624884438409876210 ,  169461333329677868 ,  1067004716333248147 ,  78909429004680624 ,  1032403478757665973 ,  1074578339703705610 ,  31850271808152688 ,  991644137624977011 ,  2102168070606825163 ,  1102002811291761022 ,  744431239330754890 ,  375034356186796799 ,  164964068453362778 ,  1837367173271428836 ,  1608887366008185272 ,  966039516308531737 ,  1859367309291213353 ,  2071471939723600750 ,  1770938229431401413 ,  1343973990262797937 ,  1677786975108182723 ,  1895648040410520274 ,  1721676021958500128 ,  640355088955456092 ,  1387611761427900282 ,  155718041545062228 ,  1798534865414755047 ,  2012643651190222545 ,  463545204193742518 ,  217683539455326242 ,  1397302395331750747 ,  2239825087736165123 ,  902853262063432377 ,  2100802626344373600 ,  322867221268265680 ,  1632485422035977952 ,  128249546785355234 ,  475097322189765637 ,  844955207221338478 ,  102295142978999059 ,  808417679837104885 ,  2084975745016135378 ,  407810010552632509 ,  1893367200722829811 ,  1353434190129368178 ,  1417358020493281986 ,  1037150764707813353 ,  318050070740447795 ,  313047022823334466 ,  1819357858627721977 ,  69141850011915165 ,  1345347750236240673 ,  2099896666439486408 ,  1328764272869485230 ,  1409223006392716224 ,  918377753911372124 ,  1118303403948813474 ,  2083304485172392603 ,  1925564497605342471 ,  546310491348067158 ,  377039715406774665 ,  1661137560246968853 ,  1093113748814102767 ,  1305192921277115953 ,  2114865025894660213 ,  674258354521860999 ,  2047960665906972304 ,  1346982284265277181 ,  2265928111699595831 ,  2125241706349181155 ,  1079918611217840706 ,  1210352901167420064 ,  1720561792157844308 ,  2078420754457754805 ,  2241601451786751353 ,  2011752282137321536 ,  487529624487944485 ,  1817651088060938881 ,  1882388596560873184 ,  1117435576902454602 ,  1433229245221145100 ,  680447904616061522 ,  1040802556895240757 ,  407154088677327333 ,  830453809394948057 ,  908461353525013780 ,  33756864651758086 ,  235947975926424160 ,  282876734224297473 ,  1629305675785850370 ,  483568046111689137 ,  524251912346839919 ,  66932553052552615 ,  1332943138591662706 ,  787500638463087200 ,  777982797639555036 ,  1780247098640859794 ,  1788052929562769782 ,  834259097875251858 ,  211080927918668967 ,  606741175631565795 ,  303854310214122695 ,  1346463288030899164 ,  2019844630829545254 ,  757421265613662348 ,  2026192193629628390 ,  192543342473570282 ,  2005772733169628836 ,  2003160662019838052 ,  1938513055823035429 ,  110972080043996441 ,  918499168214853772 ,  1171610135263366664 ,  1215942908418692580 ,  1313966551615868228 ,  2197928096719415080 ,  60629379862108163 ,  1116708932539950362 ,  2121733708133673143 ,  691413046269643042 ,  2031607405271488182 ,  1885018356874242963 ,  880847492514671852 ,  1606012718635720529 ,  1693664983256317612 ,  270299226866200743 ,  289741147517592776 ,  160281844177513028 ,  1992703888006337302 ,  331460944821139918 ,  96548653432269344 ,  1093477859395997865 ,  1675537304889046346 ,  1615371709597094906 ,  1929708370606240451 ,  2048000714473244840 ,  1867258747158896849 ,  1740584293839693478 ,  837165282530481748 ,  1740611365563479605 ,  1230260350543171669 ,  2256945398188710748 ,  85362684559086360 ,  765630385419028787 ,  706640480459736765 }, // x^2^515

{ 1656720270946921549 ,  1726376118309891959 ,  1755923060745298004 ,  690976884823524572 ,  1500023972842280026 ,  1908230701832094706 ,  35578243078252066 ,  13589693303148824 ,  1003630231866756530 ,  1384588524688069420 ,  1884538810630156231 ,  362584888568682615 ,  518292098522708838 ,  829677321420101445 ,  2156422406455897039 ,  675373461466140086 ,  65974355245987351 ,  1838124252776293595 ,  70099779890022043 ,  2217578393144895513 ,  314579547744355546 ,  1788497513914360278 ,  1459617498365967897 ,  662906410849951468 ,  60819261842104662 ,  59551660635671590 ,  444074170667341393 ,  1931176960919646282 ,  1678741934605253549 ,  2104560650751858661 ,  497392766353643949 ,  1549968497236585546 ,  1876137526811377120 ,  422742686562128007 ,  1923400998998810082 ,  426041385384662514 ,  1790473002946220958 ,  825511145723275045 ,  1719788801161358966 ,  422139173663589189 ,  1600285337470260984 ,  1472822491993154090 ,  1361961445214271321 ,  1142400882905421122 ,  1030701539002224015 ,  1794295954790568136 ,  2199009336139578193 ,  254055307803987371 ,  1315912607607633227 ,  475169282008198204 ,  68953540510069403 ,  1626452432246865011 ,  2092210928142107694 ,  1182091603493420910 ,  740544121568740456 ,  291761675096214872 ,  175954288414536003 ,  1219622492830677755 ,  1028756963107721367 ,  1488072486048803167 ,  1495927304197829298 ,  1017721848105399293 ,  528166949980630418 ,  1431342057849612476 ,  672089592923703013 ,  455107413541076791 ,  930494895161613696 ,  1415496372161025493 ,  920373792020959269 ,  500897500832530061 ,  726263619581170962 ,  751898470722463508 ,  856382986767063647 ,  868208578139721090 ,  202682409384238265 ,  998171289300284673 ,  756909477221353633 ,  331292387407436909 ,  169230626606761447 ,  1458308525905505385 ,  500662962399236157 ,  2032252372698318528 ,  894884962876688255 ,  45272720358487577 ,  1893746517536455004 ,  1169156127496581301 ,  1134273620787448224 ,  2199794918291840894 ,  15683844274154311 ,  870880342316021259 ,  1534952405712185194 ,  1052069896544602693 ,  1764562439123173761 ,  118375846813349992 ,  1907291181218308845 ,  1673359153674212261 ,  1452106958802826124 ,  872991930094125939 ,  1783235838902790290 ,  1570330874756294078 ,  418732295508041999 ,  1935568872346308710 ,  1653803801579327248 ,  1839435779478380577 ,  1412531805520594061 ,  1856475841762133197 ,  1094300948603756440 ,  140739553064121961 ,  1526580243376992109 ,  319275935332694102 ,  359436489594898247 ,  1322641358397022945 ,  1091309641117803124 ,  1501692346483836996 ,  2257045239040035029 ,  1726960440061249741 ,  1881338237034165536 ,  2150034220123464360 ,  296703423114876820 ,  1035125806985228923 ,  1125201419809149711 ,  855288341892691018 ,  1173396209197443013 ,  1969893884595425689 ,  1520335020831571319 ,  309212439326164991 ,  1538627036143646783 ,  741786698121428492 ,  606616797712027009 ,  453222264987123554 ,  662472318867662859 ,  849675609768139560 ,  1910021043790428555 ,  1478672702640417382 ,  296962797678444290 ,  1487658282433243347 ,  1137019413965826283 ,  2247202021855297982 ,  1326927192158810278 ,  905781878114557351 ,  1346801228026234576 ,  539658204043202915 ,  700957724025161872 ,  277077546329157225 ,  1926246135619296059 ,  1185882847536645045 ,  1157356179524480145 ,  281914318683248649 ,  804643802295737499 ,  519593491968422318 ,  1308094225925912184 ,  1561564811121465470 ,  1251027626081330792 ,  885108453851249564 ,  580354902522168399 ,  1993501039845675610 ,  478581938182092356 ,  1804887695073530081 ,  2264195127012370693 ,  2113721059110559758 ,  1457467777661511126 ,  1482870620495924617 ,  1898884069143197112 ,  2172826941650555587 ,  930896855272499195 ,  2104562176479645398 ,  1043147023343729955 ,  1523353571052935418 ,  2057642050368378197 ,  644945952260216777 ,  2195096865571283118 ,  1610964448537845031 ,  1703260269107632833 ,  2252084330497955300 ,  1250214938025354540 ,  1643207761734444432 ,  1207211246997805465 ,  437363303922134680 ,  1129771841368732219 ,  558565163486946129 ,  203996297883922566 ,  52561124404542875 ,  1318938953031903433 ,  1765083149671579630 ,  931694120392161530 ,  152394521222135496 ,  1233145423768007944 ,  905603961673505810 ,  845326638094068508 ,  600585589606001674 ,  1343445141807690600 ,  1340166498715747781 ,  1258805567326216298 ,  1888057566759945563 ,  2268228719043135253 ,  907196125452206372 ,  363071979810979588 ,  2056213925776328229 ,  489440554019508388 ,  495501337065099245 ,  115648161071519563 ,  672528351102855547 ,  1430106522060134639 ,  2129820202334721384 ,  135123722906496991 ,  1959254751921527548 ,  2193680572537710914 ,  1793140483418614864 ,  1130781810881536562 ,  1707292094064174093 ,  1114771695559318978 ,  1081425745030625456 ,  1529175648405418112 ,  431171259923220710 ,  437910929691441873 ,  125578961139331216 ,  618843322712970563 ,  670685256579191066 ,  261005873040990226 ,  884739833894215576 ,  964346154130161666 ,  2111538623704004364 ,  949458870494703718 ,  435790040241901211 ,  1155030446073582549 ,  1296464016887417848 ,  177004204916585677 ,  660812630776337836 ,  2160139686548358562 ,  2226338924121315988 ,  692842497901077772 ,  1742894761225977289 ,  1199468993352856462 ,  1753024240180773644 ,  2075098676090219547 ,  1612697436741198015 ,  1824255083352083430 ,  1212639083116390401 ,  39254284205096216 ,  1529693895648369341 }, // x^2^516

{ 137331402831219031 ,  1275379088213403436 ,  1699088487798026270 ,  1358306201220763416 ,  17408351117102934 ,  187979499135691140 ,  1622279508868154203 ,  2157391559624291174 ,  67654800209117342 ,  538475617609092985 ,  1646042473541387807 ,  2168813873726604185 ,  774496659846148443 ,  229907501544583023 ,  27870728736664754 ,  760557968220256907 ,  427989392343356996 ,  2206369374707213719 ,  61796808467700425 ,  2288849223666877220 ,  1558084142286803701 ,  1887660829395087457 ,  904118079456618885 ,  216003749369547632 ,  1111538653059899365 ,  108395397200281430 ,  2031554699769125363 ,  1888152934048780158 ,  891929349727468969 ,  1950112897989617061 ,  1154035691219767062 ,  2139766041557706195 ,  1229919152454191960 ,  250487404775188166 ,  1934888141393685371 ,  978273602487713400 ,  400633514225341063 ,  755975143609941276 ,  1349216387273571794 ,  423422811870950659 ,  619253717392683829 ,  400342576406887361 ,  236535594293512927 ,  925265888057888744 ,  1102633061722784847 ,  909389674613685193 ,  114499228631122837 ,  557335707070605602 ,  2250602121628163887 ,  1417105716999375730 ,  1771853588644084243 ,  1155928307863122083 ,  1095542193792666697 ,  1965834227039301025 ,  1574252797768286106 ,  697686826501581023 ,  1544923536595197821 ,  272086387310333744 ,  1962814596378937473 ,  1627788666836852167 ,  1051622728372302726 ,  2004868633700630403 ,  841849175090376294 ,  931471562586517238 ,  32053872514970881 ,  1329286048006791000 ,  570290896585545997 ,  794347536467698784 ,  2147182403397863848 ,  571646606117170841 ,  1774469110040824369 ,  436271989250679705 ,  443671245506094195 ,  1100618133166994961 ,  622766293168348934 ,  587778713296515968 ,  1683219984854639776 ,  667502809555933386 ,  1825007699446885541 ,  83446542288960435 ,  2301218498286715664 ,  1033672247462969536 ,  289150934185959828 ,  1228697189521769137 ,  453881944649586557 ,  714641287463892548 ,  810328935054360995 ,  2120217265822184025 ,  1331219702980687991 ,  167416777000809459 ,  125718234269267870 ,  441358506410484600 ,  827562154065192820 ,  1197487432434036987 ,  618977569426633801 ,  482484925088777486 ,  1343656773086408792 ,  408298522088177851 ,  1303227171823192452 ,  1702305825444487519 ,  2302059270379906326 ,  538114623483787071 ,  47802507544314237 ,  554131856144678063 ,  1936059390430757248 ,  2224187135209408293 ,  2220217003969376814 ,  691280446993268828 ,  1450567161214744345 ,  665777860144209066 ,  1780299499861645361 ,  267687032542121759 ,  708437217571908545 ,  802892013859531466 ,  353200358832593432 ,  973949362297901504 ,  1597665263827773289 ,  1595008849969079856 ,  756541363477610000 ,  2107552300398549096 ,  1907843575417071262 ,  604585463828578340 ,  439519666599934506 ,  775377839231346070 ,  618542927108499870 ,  94782407477920500 ,  1472847156647634092 ,  1115668544947357770 ,  1814259879203181769 ,  165015120253769354 ,  344060609211891830 ,  1876736880684257169 ,  51846901581953378 ,  270097329738108392 ,  1550526467550726635 ,  1582657121576897278 ,  967623728234320291 ,  252502217420182550 ,  109643780117074892 ,  1462665350074398065 ,  365016416708565339 ,  2204189414118115863 ,  682425046333625718 ,  628765733765029859 ,  54800827039118230 ,  2172615621494282 ,  1801267599319419186 ,  107708759111660955 ,  1690784686132183552 ,  2019466257956626033 ,  2201013203735672017 ,  1996582060025818856 ,  1125596859269609385 ,  542897439403401053 ,  285976395165992170 ,  552154391584779390 ,  1271037370094710213 ,  351727570007626712 ,  833407240131281201 ,  1772905383910109782 ,  1074894280384813145 ,  246540599800757098 ,  323207512862640727 ,  248721949258974695 ,  973650070444359137 ,  1733201989250457099 ,  1495415487318305509 ,  1841064800934654041 ,  999165418201703638 ,  1189298727442890483 ,  1742689215892764988 ,  996845510302016963 ,  1643072714671609345 ,  2154331550269636265 ,  1363406680469950412 ,  199037500165703163 ,  1132418651348003460 ,  1983011652579854846 ,  1931181959514850884 ,  408413588326987512 ,  1815061149956446288 ,  882665839556741699 ,  850655390869544922 ,  320609037123697511 ,  1298429058862906024 ,  1852555583254350967 ,  979425060313923250 ,  710732408379205943 ,  437081977750788753 ,  2188213764716718619 ,  1433755683026406573 ,  894856636773265538 ,  2294497172619630751 ,  259594104518557562 ,  738655799304181622 ,  1413331336772722964 ,  1199926243660541759 ,  915018286764951442 ,  876369381477048902 ,  226506077058825426 ,  35570205209076172 ,  1849587397133020725 ,  953917001037853946 ,  1937478490526761184 ,  548392715324678821 ,  38651431498736531 ,  35839853860511562 ,  474165439099463469 ,  899287346535543574 ,  743736265961272430 ,  97851339182292708 ,  1239561746833829481 ,  789081745882436494 ,  173994841248846153 ,  191024149275580282 ,  460955505960125174 ,  648050573301625248 ,  906476099227779171 ,  385270193186595519 ,  1018110105012745362 ,  1218918632350098181 ,  1375662042098136128 ,  2060305023568997906 ,  2020059604229569382 ,  609194014162656743 ,  1481112217457535499 ,  1409909474240509985 ,  1181989843487175141 ,  310137765752975684 ,  1313568364197612523 ,  803869869492995714 ,  2119707293128221245 ,  2015488721410477616 ,  1156562252366917649 ,  2295171540669560493 ,  78162684748167214 ,  1715170842787963473 ,  408621030335545316 ,  1640835473733004105 ,  554895680893093007 }, // x^2^517

{ 1626265400040579023 ,  2166344507453249462 ,  1297113929646060129 ,  446341236925203437 ,  2229916059693711040 ,  406595804924373814 ,  1783194355995887737 ,  1103942573998245722 ,  1588201047192720983 ,  455753342469670807 ,  296194410942794028 ,  2193787782598360507 ,  1155697609476022245 ,  2038221055903536701 ,  407185063322718860 ,  2157007380342757371 ,  2180307829597998894 ,  2692315618164951 ,  2282597131916465210 ,  1467243579250808881 ,  851604026445215685 ,  1129046355059716274 ,  421767896219788374 ,  1137578440571393721 ,  1328439427531440502 ,  2086520486825116889 ,  547745955915623335 ,  606584919636669447 ,  879936160411355927 ,  1180458993843872632 ,  1247418687929633997 ,  24156718343546527 ,  1741300317939891787 ,  409145664461847116 ,  1210949885272665756 ,  1026194384917900757 ,  1356428130534212629 ,  977605395419730187 ,  2107025863171098934 ,  1282968417917313591 ,  2253812200409626832 ,  2155661918930838767 ,  996805411687738278 ,  1800343268404621411 ,  845278476191151047 ,  273004717853064444 ,  1361979850246413718 ,  841155654154022539 ,  1653328376505898154 ,  1395462164616502524 ,  96291123776684693 ,  1855824278453727955 ,  1272195337501729356 ,  1868581039716537615 ,  1387893495449966569 ,  441740753725599861 ,  1960857590271355454 ,  674852030150337720 ,  1558710859933419074 ,  828022886281639590 ,  1076892734182910123 ,  2167012586958299757 ,  28816136511538914 ,  767548098718254409 ,  2014529697523911853 ,  1165153321369041773 ,  338474001016623656 ,  1841627785266607759 ,  1308796520166208665 ,  1011547922366207758 ,  233858902966098650 ,  1505935923974462204 ,  627411430954509422 ,  282966275062305556 ,  1182202269489558746 ,  1767524299929960589 ,  1856690077677065044 ,  386067181349142157 ,  2239645261620984346 ,  159734439778679496 ,  688422026454221405 ,  224540162945808002 ,  1602420405816425326 ,  1683487003753065393 ,  1324027810219476289 ,  2056733691785183064 ,  1827733304351417478 ,  1218829504088503270 ,  1099251851427057655 ,  1179822088866335833 ,  870550510635042356 ,  1055698182028701679 ,  911359692582884617 ,  877895300341636381 ,  397606715362777609 ,  1359861209045674808 ,  611113132030093861 ,  1083304984536341590 ,  1454788719711127781 ,  2183906121374455861 ,  354414700121506625 ,  664629452833078090 ,  1875057083123699851 ,  1359420890700413978 ,  324340367461837941 ,  2105891445856279854 ,  1863700013375432624 ,  1640758522084996785 ,  1134643283549026689 ,  422955233473401534 ,  1067876166442594903 ,  56502430000244282 ,  2190535023735267512 ,  1553606437932905962 ,  1972062100842550108 ,  2284614802241038692 ,  1829204101109591468 ,  1147943136931435361 ,  183624067933071088 ,  2034668372907046768 ,  293755069179666492 ,  299992570158642885 ,  1140325157173289318 ,  1411825887165020450 ,  726597133454819445 ,  338306303839062846 ,  1861042936133808805 ,  1055196730886757627 ,  1403703763056627344 ,  23510391194205248 ,  1652196700071467910 ,  408644134784020775 ,  1224359921120962977 ,  616794297573155716 ,  1453203906334731967 ,  1434148194594792263 ,  181815711226662500 ,  293363545712791254 ,  740955938063495268 ,  1207646898008066044 ,  410282768188979744 ,  1451411906635878989 ,  105090151392136339 ,  1716369720532285108 ,  1526516040339783176 ,  1290505932852326480 ,  2182300264426707797 ,  2284744373143659936 ,  79086659794881018 ,  2178224460160263789 ,  1339991595346595716 ,  1688846571332223039 ,  2053709716110309581 ,  1374914147976551564 ,  54060780819777509 ,  2012334809831238271 ,  1823688890314511533 ,  628669432059041461 ,  1204517515248836846 ,  1002266853270714757 ,  2302255695813372110 ,  1516485650593422631 ,  1302266428587440007 ,  1649641085275113782 ,  2265733125296938746 ,  507919521161433464 ,  1193935045045335689 ,  1624786531570389503 ,  968467003033577056 ,  1599668613250400658 ,  1505497910932231087 ,  100766371751137221 ,  876509224578462866 ,  641741086809455771 ,  1257429210633094635 ,  2180875574422859262 ,  2021786066703835956 ,  2084648013470037424 ,  369821995964392825 ,  1056888720835268292 ,  1432142467504206753 ,  1144345867095716361 ,  1725437203801969152 ,  959633053322022607 ,  41884338022334607 ,  521583627833295170 ,  591220717320772711 ,  1668460138265047768 ,  475662083193329829 ,  120269778736127317 ,  1857734339939575493 ,  1241318164225090819 ,  1565280723208488095 ,  1650999510947809046 ,  284462250316536653 ,  2007224343246642149 ,  2111532547666483005 ,  451216165356049963 ,  98469985851533230 ,  2296704723272000720 ,  189456099054165983 ,  1509328070346832520 ,  1066394886336999485 ,  2211954454821111765 ,  2248979627225165239 ,  2020793002395628336 ,  721510218615540863 ,  1696172759648419971 ,  126323024172244372 ,  1794781852625871227 ,  1545663516998552812 ,  1081851324794037365 ,  207238746914956553 ,  1458308229510195496 ,  1239722502647102659 ,  1260336260681381814 ,  909160021647562035 ,  33327255296395006 ,  824436196708281459 ,  1542957510332773753 ,  813775552780941513 ,  870087030925456355 ,  262839891262744439 ,  2188027551887521772 ,  2265971931537897174 ,  1974089825367848415 ,  201236276673177595 ,  1914779434990960014 ,  1307014129704879750 ,  346659903645156299 ,  2098021462131171968 ,  1898064872400763854 ,  717966364074075810 ,  1244207066400139759 ,  2018437778294369892 ,  1174595982425367200 ,  299890031784283265 ,  1639677678802952371 ,  1827542951875975244 ,  412309397233149913 }, // x^2^518

{ 554396697175992601 ,  167161468661026602 ,  1952865852542685340 ,  604822202788002597 ,  1006603343752106479 ,  204460806934227726 ,  2045802850248425827 ,  1264343889016830860 ,  523873352614341610 ,  1354279099177659790 ,  1494352208796849781 ,  1773405028989364030 ,  881869785528265982 ,  1781978209198307008 ,  328846144014229979 ,  951159101311685389 ,  424518267843312974 ,  1919163114811076817 ,  1354456864463983522 ,  1348837845964101045 ,  1448377115908063694 ,  454738734328373031 ,  2021982023382909915 ,  1295050107289947951 ,  672494486026951877 ,  1039711945405435311 ,  1864328146725151021 ,  2080008138947044566 ,  715688559694727377 ,  458299297539845378 ,  1563383726761952964 ,  868497603818950015 ,  691131085025762038 ,  940377221627527769 ,  1145995733484462501 ,  745945003238570323 ,  33142623959510514 ,  37988329542894196 ,  555453172104814954 ,  241221024384871558 ,  1354025546822578080 ,  1636464531031769400 ,  1230733199919557455 ,  681854635710549145 ,  219413659943755898 ,  424666383270221532 ,  1617520822490620515 ,  1754267424007634311 ,  1004477295370825484 ,  1596998380292881543 ,  193758237836310106 ,  1038171653592157044 ,  119809119601211127 ,  624679811744321027 ,  1467375073998900116 ,  635050405848146759 ,  625998491643491273 ,  220948576070536824 ,  55657487399219641 ,  1191785659158218387 ,  1226471173023758105 ,  20984907756370043 ,  20732614178393550 ,  1825769851831162023 ,  356770092458391136 ,  172568683245702926 ,  1028449617410676190 ,  1362976384648092067 ,  734561425011611437 ,  1019465308159453854 ,  1245406860384076972 ,  1587719590406735238 ,  2205227200792907565 ,  602574790511491282 ,  1435952084195820956 ,  1727998971789561900 ,  849942390591801567 ,  2021235100609770209 ,  387188750953535201 ,  2056467749540154039 ,  711810357291616426 ,  1223689918046958180 ,  1839354176212816072 ,  1979133530282825439 ,  243530875428853127 ,  1073164113337219760 ,  1554310562194863840 ,  365579302468033428 ,  1671429401012187358 ,  1408883645826186302 ,  1257097307407660128 ,  328365794926854007 ,  698620500965344045 ,  1144320354612481540 ,  2257502709973126415 ,  830735946533840970 ,  2095696236883112992 ,  1108314373154286521 ,  934788722382338812 ,  674708815184175631 ,  672025195159395331 ,  1643483017260060231 ,  781644924270070279 ,  210255414626092032 ,  700582016207623408 ,  376383643723255583 ,  32922431396397510 ,  61841672975880377 ,  370168168402716013 ,  556093226366384214 ,  2268172435728954204 ,  459889351078314910 ,  1700987793251198923 ,  493082824151806337 ,  1053005173026144032 ,  161086460961703966 ,  1997674157960312181 ,  2043516906688500789 ,  62534157091870832 ,  473368180825850073 ,  1438811978066425655 ,  1486169359110613315 ,  1680011422125228922 ,  1107253883269398702 ,  1592067765786722509 ,  631297014715285879 ,  731499037107016245 ,  628895241798105721 ,  74157864419890287 ,  1043340463620139864 ,  2056448138820530402 ,  1807137951722453962 ,  633289665957769489 ,  487793680129785501 ,  1667237272963445010 ,  1728155004405537355 ,  1890376208973476899 ,  342300435087619287 ,  300184905098609938 ,  395119882277980510 ,  573171104297926715 ,  1490880554803062885 ,  1989407085194445264 ,  18490443457537244 ,  1474057409683233754 ,  751196822848552818 ,  452031556089932716 ,  370664607862150220 ,  1114901379128964384 ,  766498369859406300 ,  415919673758955529 ,  723326428700086070 ,  316890737669119386 ,  649808966537273527 ,  626329813821955742 ,  1551323080921639810 ,  1940130079618756477 ,  1061314389224671278 ,  584041038415160369 ,  505666677921020931 ,  804797344475358621 ,  1750758372117503913 ,  985713566991811796 ,  1800810240239997011 ,  2039259942503163966 ,  759615443357366655 ,  1815028040174998792 ,  542861055693520916 ,  1144187797568716074 ,  748711395596167874 ,  1151874183751814492 ,  1078809445881782449 ,  1032400507951959627 ,  1832130366718490651 ,  758804511062420295 ,  993557420418524275 ,  399666854410113992 ,  2118747195357071479 ,  1972087493949431783 ,  2226551170542166314 ,  1704391662624702211 ,  67467650000687858 ,  452905934670894546 ,  449292303597218685 ,  1056997711814905553 ,  856997545616372037 ,  1480656534479922747 ,  1730277840928538879 ,  352997811671091878 ,  846773810589752721 ,  1986188902988125075 ,  651902903292608770 ,  945752589559372958 ,  2078368790345775573 ,  935657221617458239 ,  1528202639269874122 ,  846877209204227165 ,  1885540434967721547 ,  392864740641619946 ,  358077049903475283 ,  2009540081698245274 ,  702947100179354415 ,  585479044050897093 ,  2229190091814771145 ,  672110144712886270 ,  1864795269888883924 ,  852286476933390176 ,  1102918660668279362 ,  1496073710697094126 ,  1642205141638624770 ,  11125031372955747 ,  1489477577206455385 ,  115185644293767957 ,  635597689451401554 ,  1953772871752062087 ,  1375689650313350151 ,  414054969344893201 ,  1706521565188874283 ,  2000642401042498238 ,  2238409129655325219 ,  169247026421787205 ,  114274225938485180 ,  243834505968259697 ,  1197165275148143793 ,  971877303591273295 ,  263002008485470475 ,  417002440756345788 ,  2201603736460110332 ,  886108292012032475 ,  1440231839499122784 ,  1935052303918815353 ,  528991703051771633 ,  1922636334452321656 ,  1410488463544992882 ,  1853232698646987994 ,  812571082892254269 ,  1865675516931730012 ,  381687915271190841 ,  1862456685910603614 ,  873083918631850145 }, // x^2^519

{ 2215934612102046108 ,  832651105400601157 ,  804657356335032135 ,  1730510256688521147 ,  1641434553230896258 ,  82603353324314256 ,  470998343493763085 ,  2220904594003296553 ,  2074477954792507132 ,  761946941746450283 ,  329405195551223119 ,  874726162573404885 ,  1844355389287023883 ,  1852594641131530546 ,  2115649760828937439 ,  2302629898238244564 ,  622812172195315780 ,  228809535652870083 ,  1644101963707638435 ,  2091113229476732161 ,  1327162906350147099 ,  837165471876701895 ,  19926901652380624 ,  69572102197830382 ,  1191806096228270557 ,  636946940958333062 ,  666443646748171189 ,  1342526361910936347 ,  2014866513078835574 ,  259041974024986255 ,  1610222604451480159 ,  1827793812447453785 ,  951103038408369576 ,  545757325391398750 ,  783964796733815467 ,  1650137793439195698 ,  1246716799595478640 ,  486719729909228306 ,  728551407846568550 ,  2162765046140679363 ,  2225398858163461272 ,  1749810998152261790 ,  634413306604710261 ,  2243620213389070101 ,  1718466844754827907 ,  482589453215355940 ,  1421370552129464505 ,  495076994534268527 ,  244802555066868051 ,  330761284866160102 ,  984770159009678624 ,  1910041599055422902 ,  1262110804643960888 ,  1552389289291557412 ,  1514260584544879106 ,  1492741676359331352 ,  1579938734307621092 ,  274739786734410602 ,  1270293326679666418 ,  109295366440324878 ,  1592297183113037887 ,  2123017106213820794 ,  2174089542063583929 ,  1990826808058497391 ,  1263718609160444042 ,  1150602203637961919 ,  119488355518623675 ,  1732493831831439162 ,  1376020212839727076 ,  2051737329029891092 ,  379888790478468925 ,  777490697149452665 ,  894076085601110965 ,  235495518871705695 ,  333684694601037893 ,  1746315529451743891 ,  1886540405758103748 ,  1046959065552764167 ,  2189683075210972311 ,  1553680924795548674 ,  2124577566169027504 ,  875205597006289279 ,  1476217834095937434 ,  1137723362747133883 ,  2049677408462276233 ,  1738595672771062395 ,  1490255528006503312 ,  607488495354631809 ,  1417828841100234045 ,  1528653181388586449 ,  705486518341789198 ,  375407093182307148 ,  1117406968142320891 ,  624088576920758457 ,  1497737173123891748 ,  878673973836010551 ,  526372788486169756 ,  2199955149546244057 ,  1071752030287369687 ,  1991741861309164081 ,  848884735061283266 ,  2233606156489008981 ,  767254387702087471 ,  1870321883413245657 ,  334610987022706346 ,  1716108107688410641 ,  1322226321517363594 ,  1390491283192947705 ,  1839372841119845316 ,  596171774112305012 ,  121084914813168477 ,  973564585077589854 ,  136532308769946709 ,  278360601444442409 ,  327357596308368070 ,  1391009084756523435 ,  465719920508758227 ,  755300531274780364 ,  570292079529843056 ,  1688953249561486655 ,  416148126120653905 ,  2304340666298451091 ,  1407634752696718239 ,  919420091223005648 ,  1993931290518836937 ,  1709435429117524858 ,  1599369552162278520 ,  1538676344552138587 ,  1429777673335474874 ,  1155288977600384422 ,  2235790882289102665 ,  781006466605856079 ,  2210776996482876097 ,  643559695968634601 ,  874859008761322115 ,  1038068019978599941 ,  852320665305501797 ,  470370147817892059 ,  168169983493602414 ,  471805445143639174 ,  902996439407742055 ,  1447685346579102534 ,  1579865461517904357 ,  481469241722555539 ,  400462192821363820 ,  1406550999743963497 ,  2158641866295687927 ,  1512594540042236500 ,  408906971127694593 ,  280841376560334024 ,  709108607300752769 ,  951867291185709262 ,  653908159272838040 ,  917139574688163478 ,  487992055639080060 ,  1602442697705823794 ,  1634620072601976135 ,  2088300574161696488 ,  1661500849573755368 ,  1660329531541291497 ,  1314216599682587282 ,  505740884956269013 ,  834025977975287880 ,  307153226184460678 ,  1802029399743737315 ,  1056724024798649609 ,  595170410780468832 ,  1357675103700426174 ,  1102552490757046080 ,  767439024165602180 ,  941228087022421791 ,  1286758869821250892 ,  2054446085016801833 ,  317170650686575976 ,  30500642547654272 ,  2298049743790178117 ,  1791206345535807886 ,  891568864162021552 ,  1018596083150458382 ,  77316296477441004 ,  2105395145523479706 ,  1725042672470381481 ,  838513172080092355 ,  1538137879762987585 ,  513243242345804737 ,  1270794582241678895 ,  1872534377857460901 ,  1474120289980149849 ,  1655971158271919295 ,  248561573244085396 ,  2073933380517776043 ,  1207846064306760826 ,  1517576434451739581 ,  1706097777902268558 ,  246858012413837544 ,  1511754662881778736 ,  1367932059837576629 ,  1217371259464770129 ,  290489125304997276 ,  1603338159408188682 ,  45095757827776383 ,  2082696523013897918 ,  432370802968072666 ,  1831159994752808980 ,  2059073162237841670 ,  799568037307753678 ,  1222409032933116107 ,  449855980274369315 ,  431406206020108304 ,  750793460093212246 ,  117587202874664506 ,  468768135276922177 ,  1776148310771112267 ,  37588106351019900 ,  633257205706748364 ,  583533559628855461 ,  778169343953229275 ,  2080480489517702854 ,  1015723745210129442 ,  507711324299235765 ,  1458768122281364474 ,  1937810309495803227 ,  1711860040865662995 ,  2060335986712966644 ,  56614431765154293 ,  1586080521561863539 ,  937770505246944081 ,  1844720670408109272 ,  2121457897165428507 ,  856266061469271938 ,  75307453367959875 ,  1055920693278750631 ,  242626629683962716 ,  1425262823976006131 ,  1910010238349009465 ,  661708023464819758 ,  1506138837590722464 ,  945217372812388455 ,  177335012414701806 ,  1044726529542791680 }, // x^2^520

{ 1344929607991377311 ,  1613748985879577251 ,  2003502456524005138 ,  1648025833968685971 ,  1560071363763284698 ,  247098602363860046 ,  1931114061948709506 ,  1022930548269536829 ,  890648918917241843 ,  524201153732944715 ,  1203974520252712965 ,  31040513222079413 ,  1231330663211759651 ,  2126170591336586386 ,  1921670516585090943 ,  1701754575208610457 ,  1279354086628980590 ,  566908526104671507 ,  1663963216633810876 ,  1475498293604344340 ,  2021419329835017597 ,  540810006599206908 ,  2106616463927059599 ,  41169898676511431 ,  247058501352509834 ,  693464305018851464 ,  2084811728562591284 ,  794117031223118996 ,  6956737977901923 ,  36516974143493907 ,  705348153392714625 ,  1471757055262790668 ,  959421127665698317 ,  10684984752568268 ,  485934306472447619 ,  526030714898249417 ,  1889258681664092070 ,  755891332228902518 ,  813859245976654896 ,  645617929202970739 ,  417925895795140076 ,  725180851677415986 ,  893872269458831175 ,  881154633015820757 ,  942550915581542559 ,  969386716982972784 ,  520486926344548120 ,  1301330546715452133 ,  1363501496484328615 ,  705263921959613257 ,  1243666637946012665 ,  1438717113177275076 ,  1126455468541184209 ,  1668584732936870215 ,  738085638104321841 ,  843799450555137548 ,  467557904376513422 ,  27909998869158349 ,  813828109509048016 ,  638721290500720795 ,  549538228228208607 ,  1003675998480157940 ,  1858369656365640984 ,  1883791435246438550 ,  2174479480362692545 ,  2018857364583591201 ,  1417513321190526801 ,  102871499848952173 ,  2181233213375613297 ,  413241313828050966 ,  406250634957767165 ,  577194605694086218 ,  405595162413995969 ,  904313930616512876 ,  384690596645451681 ,  663508430468494461 ,  2125761579320257384 ,  1465384610892139113 ,  1068492762018392217 ,  479823420842895337 ,  2270271745465042627 ,  387452018307736283 ,  527696732758488152 ,  1776263166291272771 ,  590826333644135497 ,  707056823215231581 ,  559469503785253100 ,  1930379428195046884 ,  861260053071424981 ,  1595134495024121293 ,  2279063831132729924 ,  1602793360254698519 ,  561874859612879131 ,  1838320193648060543 ,  757746726658836357 ,  889238015013775333 ,  1400484206609537997 ,  931940976751182018 ,  2154862031786192938 ,  1545478104435656555 ,  295281822772808104 ,  320847656081186237 ,  1310279084143974746 ,  128908886612279615 ,  46904476713718337 ,  2088672989623420281 ,  168211104915443962 ,  2173608909087616278 ,  1035099542714981435 ,  1502075521587905609 ,  1712958274069186225 ,  926688157736198053 ,  238388110055530527 ,  2189201923465154398 ,  660894849541422908 ,  552781490792529624 ,  1863035079488532001 ,  660972151506696858 ,  448952274809662140 ,  2235641511602576455 ,  603024439548900208 ,  98938254631477393 ,  347713161745030352 ,  964564751622088868 ,  418317936623867129 ,  2253759691142285146 ,  1178296045851750332 ,  796843194267636207 ,  1607437611378224594 ,  1132330545827700761 ,  543670530230534974 ,  1664229651379604245 ,  2126133457275695815 ,  259667740530000908 ,  1927107519113702767 ,  1019077148679853308 ,  186475101384558848 ,  1331974260539984681 ,  2152861427014988220 ,  1837280870761925090 ,  1415794918551552507 ,  1298117401280983705 ,  534853191942777966 ,  210603729214872657 ,  2182148756936673866 ,  356763227753915763 ,  2001535751814378010 ,  1717732231816914435 ,  2018074584573149524 ,  1130269503308553422 ,  1312921115741679785 ,  1118937775545760279 ,  1745308833711431459 ,  319833796653773891 ,  1233635150167216079 ,  2305121767410086099 ,  1536381729157335936 ,  545996925420674481 ,  1221496417921307253 ,  348449927432618276 ,  1539228286593915496 ,  803555983376312255 ,  994866618355449124 ,  2134951429714311441 ,  2083178338233477254 ,  1020222951581908111 ,  1308044525380370837 ,  971330879943319450 ,  1020969083116685177 ,  1226968868197015320 ,  1856587947313753499 ,  74365124173959879 ,  987309467941910297 ,  502492012238422494 ,  544280590283881013 ,  906127823200679647 ,  1325644845593004231 ,  1665941630863690020 ,  1470899527422571372 ,  2046166266546608137 ,  84999923627651493 ,  1995281391165799984 ,  949516776288104781 ,  1768835056985342103 ,  228357722131287796 ,  950607936661554233 ,  2152304306923583919 ,  312766292918819008 ,  2255361789881958196 ,  1585255663154298085 ,  1796348547151877376 ,  1347880192333756745 ,  378898106406955941 ,  244517029653030227 ,  269540309284323671 ,  818257357524271192 ,  2010097880911767118 ,  1711881964476469073 ,  2092985180781491346 ,  1941583422894573931 ,  2110283359718021588 ,  268790106387685388 ,  1542190709608709470 ,  430106643491579200 ,  1414805658292555187 ,  1944780327981157514 ,  1342146891486105106 ,  1122477574612867170 ,  2303213873905266076 ,  532777001141237245 ,  1381049147662728364 ,  2034186818710763300 ,  1445382679935473512 ,  638581722626979735 ,  430434170096145627 ,  960671319345600651 ,  1652750384855713757 ,  2191394781487659532 ,  1928102891463590882 ,  63760123266030760 ,  5372695850931626 ,  1880910716208661338 ,  647074443759886094 ,  712009575863958673 ,  2152821480620870046 ,  99878553182755033 ,  269072941435760692 ,  1015831889775328694 ,  1232944616928407625 ,  387290279427689283 ,  839619515075430756 ,  879844274280749517 ,  305707711053335236 ,  1538441512275457405 ,  1994955433309161132 ,  511744158565389226 ,  236053545401547640 ,  45070959017345837 ,  195212976811828502 ,  126561750317993091 }, // x^2^521

{ 1739223081271389356 ,  1980953154419217369 ,  1811432918342626548 ,  1643282211261444121 ,  1565189073713426789 ,  2064318993399310449 ,  2127748710846524570 ,  1558578514299139372 ,  1679502001539905226 ,  853279241068816905 ,  2259072583018015338 ,  254152226434513991 ,  875194839171078877 ,  1089178560417590269 ,  1034957928776690959 ,  517998760634558693 ,  1699606774474583168 ,  41969124982832639 ,  4444619749524649 ,  75871435638198008 ,  2031795088545023358 ,  502124196973342156 ,  1180349309118916234 ,  1283158980417784797 ,  1047103009560973760 ,  2184271405196246076 ,  1262610037348165431 ,  431177632092763242 ,  2095697719955385979 ,  47961898728488754 ,  1592458462481507590 ,  2071022320606371763 ,  1950537830538797542 ,  874403232891252150 ,  81649682554412 ,  1579025420288897754 ,  783556557580205658 ,  1267998293009453756 ,  1359978768960865053 ,  2190300905449405349 ,  1879824074347741455 ,  994440459316279422 ,  2189996429468342723 ,  984441107928640468 ,  135734606138911786 ,  472004440087493848 ,  681410434936047180 ,  822695759465125034 ,  258808921600115037 ,  2064226220564490008 ,  1816213523806898839 ,  447499395948321078 ,  74233335464004776 ,  211331224642918905 ,  1855320174614784638 ,  455509227996723993 ,  1376778538734057255 ,  1539828908222667904 ,  2125251208911789797 ,  889003295772420254 ,  987037848760327521 ,  1925920967003822953 ,  1080548744363542409 ,  1915517549624011703 ,  1820784207808015066 ,  1850688287828553747 ,  354798346979470516 ,  470066362251838095 ,  1378572414352571981 ,  830884256714011012 ,  1179260693641260985 ,  578434782168268946 ,  602314677438863747 ,  1653269455857504386 ,  294188389902291048 ,  69087746823085592 ,  994886619215288875 ,  144310634833033599 ,  1189939146351810200 ,  172836731876194371 ,  987017541198224274 ,  307793832253116956 ,  2026853896069525521 ,  806551227532424928 ,  180962549899486231 ,  1062256111694760025 ,  695514084448033843 ,  1392962525189542617 ,  1757006845714338780 ,  1109110339206590556 ,  1170888244430815233 ,  1524533826028136470 ,  1302824180404313327 ,  857073514716330169 ,  1682476773293847471 ,  1541068293483334290 ,  1156828386397359161 ,  652926336063436860 ,  1231846446893304124 ,  535726601545251512 ,  1168733113412569748 ,  102011208919853422 ,  263770635948709812 ,  152964426250806406 ,  634003595708945068 ,  392958000899332745 ,  1676616564000937083 ,  2295729184852934562 ,  322813837510908016 ,  1210288967007672237 ,  670056585931499801 ,  584775442122997290 ,  1049598426189776153 ,  780237198174503662 ,  185205385526223975 ,  2083269068869490913 ,  564363718561566646 ,  1238526824164628036 ,  1280524504453298058 ,  10592186500582917 ,  2145576946220946715 ,  83442286793640172 ,  1350140265343733685 ,  952486807782136163 ,  1221844067610227194 ,  2185374880447012933 ,  584492655897604951 ,  25222446401881207 ,  721887660218307547 ,  1207987857672032374 ,  1014571671750351950 ,  1890989167035096507 ,  436130864566004217 ,  399641941954411456 ,  2122004384365287305 ,  448982800059206384 ,  2015088360685979978 ,  1707694642375823372 ,  1607850130144506845 ,  1689449432942553343 ,  933835086334830817 ,  1100830188682513522 ,  892891458585603025 ,  1261107335476651255 ,  633736940367372494 ,  1209520505176397079 ,  996128658504253937 ,  287766825472023134 ,  1678773904899216726 ,  132747547932548668 ,  221694399915767448 ,  1304420374933702333 ,  2268521732660964521 ,  91529407195726833 ,  1619417068679542639 ,  695774484718944699 ,  271712050650544491 ,  1990023358674639551 ,  1067895562790116849 ,  593254762495854766 ,  659014553488416839 ,  478588490609669349 ,  113791975007278734 ,  762762433319812647 ,  1893846060022385159 ,  1665058646131617166 ,  361060681994968567 ,  642681867060082112 ,  1995349150424716526 ,  1624628163906955657 ,  1704008601350720078 ,  591054397674635238 ,  1317285349289867167 ,  1876956575294321924 ,  732186553994346916 ,  214303497841844662 ,  1378440178897510544 ,  416018333829018808 ,  389050333348136249 ,  1716306870564594017 ,  2009672145525862085 ,  946333770021029915 ,  434262669646598623 ,  1846011434119590751 ,  1123936997423253145 ,  252689726513994562 ,  1418656305663311990 ,  1128563802941695666 ,  1627372899053440950 ,  1042375429722169351 ,  853371044859318858 ,  1611246347849066463 ,  718409332850522012 ,  2096355997141257407 ,  652460736378131330 ,  1456638477133722724 ,  2191131436238446459 ,  1910235130218273344 ,  982779139087576534 ,  1037260902476003601 ,  2155825053273688137 ,  708388749068336221 ,  980917849035423171 ,  89601497458302801 ,  2191297001420870522 ,  465073374135713367 ,  1744734795935632678 ,  748024752115302917 ,  547751401419335536 ,  115711438914129647 ,  2263173749658956437 ,  955138775488836055 ,  292717699229172804 ,  477048459259703980 ,  2256941067196682902 ,  629021056335322526 ,  1838919614082381852 ,  2104089104073871839 ,  2153455098364486097 ,  772681269977877345 ,  946285144002189861 ,  1153516910845028190 ,  1736817462557958347 ,  1728869145336238696 ,  2223576832044954811 ,  1994645215360577985 ,  1169577762997577600 ,  360197376915479259 ,  165366693747374122 ,  2295771999256403629 ,  1151116782659852793 ,  2303534131019806928 ,  1728926061046553684 ,  1760006043393427814 ,  674232674202927442 ,  1771623982943983289 ,  2285195703304314160 ,  1732774850017175634 ,  1212580855966596111 ,  584237494485520800 }, // x^2^522

{ 95628759097082973 ,  593216228959445761 ,  1391955505169252521 ,  1098522278764034605 ,  2305657272400064890 ,  2304886576132398805 ,  1318594842114896255 ,  1868793651526804930 ,  2171166664321024011 ,  2226672047355201877 ,  406007712446720338 ,  1418428206644817854 ,  1879521380952438248 ,  1646263488367495053 ,  1821748782071656637 ,  270807034497734457 ,  88896207344299859 ,  1159837056580916547 ,  1044011269075634154 ,  2201994783584487460 ,  2176786471885226993 ,  56677410682886956 ,  625794273392758680 ,  751648372623899356 ,  2298815256253648493 ,  2198807885018852511 ,  1172092405025631743 ,  1267506696155359092 ,  351918368992066310 ,  2116823208994113835 ,  409566984012596362 ,  869138097118577454 ,  1646687549095675109 ,  1075718157969355608 ,  1879370124090980906 ,  331296330329730636 ,  1455282633871567687 ,  2118267074762469173 ,  1570292976920176992 ,  1719110608688320099 ,  436441373070352252 ,  627923367336203766 ,  374437890258701595 ,  1077363177623800612 ,  809391976938957404 ,  1013372667635088963 ,  369675323346391521 ,  2038018290858283925 ,  1199857713322579694 ,  1262321090654016061 ,  186265580332098336 ,  1671851155855414078 ,  1620333519248020632 ,  2135560354309241079 ,  1165965350553349936 ,  383980302752776385 ,  1565848816988106366 ,  1529659630214630383 ,  1108965248354421132 ,  1766226867708320107 ,  142032591929092538 ,  1719990895472845760 ,  1787487392615263339 ,  690367656553810868 ,  733243574712041227 ,  1196728217908014097 ,  583371363191072622 ,  2153613828745850088 ,  1741520748530855225 ,  403223933747318225 ,  1976437056598257979 ,  1276562107944170294 ,  194463617535953927 ,  1592663973087632065 ,  903882747905838832 ,  1608376604202849086 ,  2222198697993413106 ,  1245484867576149593 ,  721061886985764498 ,  2019330630960962561 ,  1549643967957250086 ,  989880286446531707 ,  1121157089070964238 ,  639204975476848679 ,  1827737767852938901 ,  789057754324852434 ,  178507628519268950 ,  1790047315226566401 ,  967833758473594194 ,  2245286027110495533 ,  1810908357482112272 ,  2289395331161973872 ,  592517058349676501 ,  40190094242115534 ,  2122244697770511969 ,  1054892407502136347 ,  1052919145031416459 ,  319535941023316740 ,  2066996919701546447 ,  1144923522664718731 ,  2159728351251529646 ,  665868414156789574 ,  2044788061430035292 ,  1700733715986658244 ,  1231835474206848470 ,  655084932698826484 ,  1115832640265182074 ,  1602443109379322372 ,  1463078365617555818 ,  264553348628790667 ,  1080588555940705780 ,  878100323628729239 ,  1242371864517073937 ,  587647052568171601 ,  1248320845338539152 ,  1975521191586240774 ,  1005467399840076041 ,  370613186544291744 ,  2292663857135527632 ,  1498849017167872928 ,  1679324112218896115 ,  1392502692674032878 ,  2004537799398009843 ,  1617954327760480935 ,  258383420303312472 ,  1127726539876369269 ,  1657636311872298985 ,  1700815923561894544 ,  1960309747223863437 ,  1539941565923438776 ,  494041043334597959 ,  1829707932734998680 ,  1723318441186682059 ,  2165374770428460740 ,  1762194390092114281 ,  1280205504016580684 ,  92649607163592361 ,  221554406103612555 ,  533657234134899912 ,  1991970702262497461 ,  226053604423118725 ,  2255846113786239230 ,  723336721223604316 ,  1335458565678967782 ,  899845004253526501 ,  1744455975082332604 ,  444145374310802241 ,  1262897217998712052 ,  1092459624340660948 ,  1669317138738141280 ,  1468641061483480576 ,  590970248633485885 ,  1219776459625678654 ,  1584858389970252332 ,  1429269318488781510 ,  718724832664189629 ,  2100939539251838470 ,  690510525258864756 ,  945464700768295027 ,  865311425273976153 ,  218047072621212823 ,  2069046896243728521 ,  146492218373328020 ,  460072094139716444 ,  845775626067202811 ,  891714768391922874 ,  1998295897094967984 ,  149125518663198692 ,  1360245691866143893 ,  617516320308376085 ,  240393119558429738 ,  2023822406405176587 ,  2122909678114565109 ,  2255270842101165651 ,  433165793453951776 ,  1016450213524826979 ,  2214163998344317489 ,  2106557136704470321 ,  1440882736895542815 ,  1881543954702990805 ,  991298323605592136 ,  451101477677885120 ,  1159764841743989962 ,  8645451201075776 ,  370724874241978480 ,  76107328213679251 ,  653005887465935871 ,  1048184701802756038 ,  592039709331277301 ,  277219890308637472 ,  678564838699883188 ,  1211162430874386780 ,  2287784396591816953 ,  2223782761947385426 ,  2113736615915394217 ,  989183275638428100 ,  367613405479821148 ,  1051338922618868759 ,  2019867381352115488 ,  1668349768364364562 ,  1978163383216643936 ,  2055070009905882658 ,  325068671199596764 ,  646476379326884361 ,  451456364804738176 ,  2245497376205993752 ,  1375154304296102810 ,  151022181278460894 ,  456294913232545455 ,  453394850534702629 ,  738361691606841094 ,  1556031559554877625 ,  1808141127561046919 ,  873438115666760906 ,  2076039269970484094 ,  1142602462302777592 ,  1080568073035507886 ,  1908302775985136705 ,  445900867456672837 ,  1085846308182727646 ,  1558172182582776149 ,  893173233345726693 ,  1726009592225401323 ,  1662127876538804522 ,  2282521835678875867 ,  480628844892553385 ,  1302962977956109469 ,  2024517852275217358 ,  742110403412120718 ,  1287310153434955922 ,  2212708491520482906 ,  1508070562592761543 ,  1247930645784952341 ,  575581361031312124 ,  2089844681714109946 ,  1976750746468495125 ,  469481143379691532 ,  1860976420275992046 ,  1034442873515426157 ,  376753386733262391 }, // x^2^523

{ 1563316987700114850 ,  698213585751322256 ,  1495893357129685561 ,  341774679080260008 ,  748034659482920168 ,  1755704263757600323 ,  1341117808511219483 ,  980420608798587969 ,  817087556196827552 ,  532317405851022838 ,  712990310510462873 ,  152894311673902812 ,  460708930114851135 ,  354289528595445345 ,  684556944583551249 ,  746053498774343352 ,  1844920542730502989 ,  1959233489235504630 ,  1565535915634058098 ,  760899083164109644 ,  75718210010522346 ,  2056182134659371914 ,  1561718856545285301 ,  1593053699524753494 ,  1309017366435963953 ,  1411710063309032761 ,  1968106751566536146 ,  1557536320877074952 ,  137989065561988313 ,  228105993628526265 ,  1724288455817494752 ,  2165510531620915365 ,  1331749890314930167 ,  1945546669381689831 ,  1557061822451853413 ,  1813156943838314678 ,  291911096282664992 ,  1258305402326508258 ,  2249786792553177285 ,  984526861121334584 ,  1298617410846107128 ,  1789701622561149743 ,  358737529116427990 ,  2176241761446049184 ,  1807886391220240994 ,  2142917748784728532 ,  1926315032919958899 ,  568115456979135656 ,  941200633321983896 ,  541003053908665563 ,  813150797560453991 ,  966396888754356002 ,  897939212161533671 ,  1883535558882717036 ,  2195089730059492613 ,  875605690164395965 ,  1266573652137531998 ,  1721548923520081519 ,  800994596601613146 ,  2224538232033465646 ,  1477674503853981126 ,  306494306113964959 ,  1390526778623826786 ,  1212570384362169005 ,  1020974758377483940 ,  431490589186344242 ,  649960835975013396 ,  949787438400591030 ,  108361258088495549 ,  1721961736117353920 ,  1920137747263693620 ,  2072119044723065707 ,  1731373036662332452 ,  1394322569440148005 ,  1919708333302874387 ,  1929406040178814727 ,  532256462050291034 ,  1626864791430470070 ,  1085200493986805404 ,  1601056332357088085 ,  1602845537366165499 ,  366421321087511183 ,  1315248736347443322 ,  199958751790773454 ,  1691286822826820095 ,  1387490690616327045 ,  292410085395820045 ,  435912904587269527 ,  1198972632272492072 ,  1257418995724110201 ,  1370768338224562310 ,  929736742132848151 ,  1697244296987663347 ,  1412305949352770764 ,  1017171606940928240 ,  997619203941081539 ,  1148596460494862837 ,  1491957395514804012 ,  2259353657953527432 ,  2181343364977832708 ,  1189755666273652919 ,  1355504559437233860 ,  234422877897913840 ,  1017130923520273327 ,  983517289008136984 ,  81072624515137942 ,  352485785047764664 ,  1873197924133170299 ,  1381964321377854870 ,  1465779303172729793 ,  1308137681447835811 ,  218749358473121876 ,  149874116098733204 ,  2017556180545171792 ,  211434377893642354 ,  843177270422165748 ,  908572908676800722 ,  488375891327243215 ,  1518680438164826493 ,  1225724322530413066 ,  1692713158372818463 ,  1074700211236750357 ,  279909396385421459 ,  164764458556578347 ,  424802782985481025 ,  421500589049701422 ,  258198091763335570 ,  128804802919766213 ,  189972611937127649 ,  2112776521787202150 ,  1501742382802182902 ,  2293455123171592827 ,  1217095821491488795 ,  1913437688000340476 ,  884663603944029910 ,  468357547776654772 ,  1106696031532299209 ,  752134394825068489 ,  1625466190703232790 ,  647846017591699377 ,  970317628392671544 ,  551484198729166567 ,  358809079031339219 ,  1581107499555944382 ,  2154449345237008079 ,  1259972658637114259 ,  1404175045666016536 ,  810572233810359231 ,  35850133054646974 ,  991123327519933499 ,  43676000126176262 ,  495846080751740042 ,  2260122200856727304 ,  662788736478322697 ,  553924923953351825 ,  33855985460049920 ,  1312600423274522262 ,  1235327472043557464 ,  395979933676508488 ,  739267556328849927 ,  1789547981279742357 ,  853278692204087012 ,  2187168962368522817 ,  847640127163316260 ,  1168854529206790549 ,  1629114205348862386 ,  998197980374052096 ,  1743064141250532531 ,  2017734135338212887 ,  1199271850348653059 ,  1304214747055793311 ,  619429006261016995 ,  526168187967640337 ,  412569110728561608 ,  214461155667110815 ,  500934800678243871 ,  1130482572281296725 ,  224461548667575617 ,  609238204547110266 ,  1221684988019321243 ,  1533419767761534619 ,  1727259650451347733 ,  1358128277225808598 ,  784708429657413001 ,  362068553299257119 ,  894601869851393867 ,  809455473476213091 ,  1833563767132109918 ,  1490015537646493952 ,  1917039784192119702 ,  406130826468377201 ,  617761802422395236 ,  2203211005098625353 ,  1632405344381073037 ,  753913734353161875 ,  1687848608352401811 ,  1066164336970112991 ,  542745428339381417 ,  643750400486873023 ,  1485243245156413345 ,  283339591868023784 ,  1202297440796043554 ,  1671665314446550694 ,  2126581219191964871 ,  917926210034730332 ,  1052019437582253693 ,  1746043661107673754 ,  1770815556450169285 ,  855695282383381227 ,  1215625172058766618 ,  276810260033788937 ,  2264359444083960844 ,  288098780636959809 ,  869776115927562563 ,  1846718354595665101 ,  580298668054673356 ,  141892324235860887 ,  1379935245927328660 ,  58146753120325795 ,  300296760441488889 ,  332912493567277120 ,  1196871716534399553 ,  32258943545933844 ,  440049914760032051 ,  973345533299137330 ,  2276896960515219768 ,  379092811936994477 ,  2254385428620334833 ,  745416356245729648 ,  1003451646529961255 ,  2499228410973363 ,  192249400939278749 ,  2033315942643387433 ,  1948594975374929383 ,  759226832963986303 ,  1239243800384671135 ,  734764245517980043 ,  2262574532799058627 ,  1957216903941652033 ,  1729103640870376975 }, // x^2^524

{ 1341291172521716159 ,  1635001815751678067 ,  296318589387768351 ,  1000489862600965114 ,  1228801052412066773 ,  659021502758693985 ,  1281081440411423489 ,  1494246424934945191 ,  2173318368954455390 ,  2053218753198263196 ,  1059357999447650760 ,  1794553192269689117 ,  315721914347891227 ,  33184766280583705 ,  930169219721176715 ,  731014362938892653 ,  1437840813144491424 ,  181374645482001019 ,  126575045381856297 ,  1758608318778331915 ,  71918171684237437 ,  389315267202150374 ,  676001780277159539 ,  382348764809816615 ,  1767105262549327587 ,  1433851575906532246 ,  2111110663625937389 ,  681365367820266439 ,  29759308698306649 ,  2153535907041518794 ,  314236493086158945 ,  305945844672908870 ,  1586871433915432138 ,  1347506007449050858 ,  1654700510330470483 ,  2102429969029406199 ,  1149902723057332991 ,  1008552223547332535 ,  1355780835600240052 ,  540274499540506281 ,  2199758096193097158 ,  1115752568208349500 ,  165597319240942360 ,  62599123363745991 ,  805415880019984313 ,  1463900661649054938 ,  558959514082017948 ,  130505194429294881 ,  42304945169356437 ,  1402677698240663626 ,  1300883207473378177 ,  1285723944033729962 ,  1868583054281931282 ,  1013151508556373099 ,  585731128814069024 ,  2183722341965918014 ,  2094728431028624981 ,  386002369320291309 ,  164826890092064002 ,  1811487873422254667 ,  435736480652933114 ,  2223621505251823515 ,  651125199925926702 ,  1625146059633116002 ,  611865617842538953 ,  904651874054836765 ,  2013288055555840117 ,  1113608165899730452 ,  828387271052381561 ,  743855780164779606 ,  2154573252187826288 ,  396860840743096668 ,  1526512175738009092 ,  929582075928807841 ,  2184677946849163020 ,  281002724613312046 ,  644560876860026491 ,  2114285737561411030 ,  20498186897604085 ,  2098522519050279492 ,  1850710843803566294 ,  716634873732960367 ,  1829527927177948634 ,  2214579128610867942 ,  1653625095051795734 ,  1140727282112998138 ,  477642914679344242 ,  1829717173261889298 ,  1367007077878277402 ,  2161229639764073535 ,  624077791061398259 ,  143617909920994722 ,  1250664717300992682 ,  2212496883841759840 ,  307244343199540743 ,  1005639999514992064 ,  1604547120137382405 ,  654268835817348693 ,  2286037208292858566 ,  1271031181302956585 ,  2273678731079825234 ,  1409206176604136602 ,  1824372158947496540 ,  621277622219199270 ,  1412490954663645074 ,  2034879534787328122 ,  288535837363698481 ,  2054770719598332202 ,  532134617236113111 ,  1142494416052430254 ,  1591671365220164482 ,  1431324508354234946 ,  1594344297685382691 ,  187887588523232658 ,  929525118876764030 ,  1053084543472311990 ,  294813192585629357 ,  1863567045519733642 ,  1124666458444504556 ,  200843438382250259 ,  2051642978048083940 ,  1739600177346738945 ,  1283647264314352790 ,  2205060166620751917 ,  1358881484453385106 ,  1142883715089540926 ,  1077285624625534212 ,  2002294209533352566 ,  1711306755475445707 ,  1281323811062311753 ,  912579771925528510 ,  2135605772609830512 ,  1001322700450722783 ,  519813095909025416 ,  426632650931886648 ,  8691726397311564 ,  92937471241009927 ,  1357156188966365709 ,  1541777149880096312 ,  2179906439693321255 ,  1773295548914455949 ,  1700421248344956638 ,  225414051559750327 ,  773885535218038545 ,  400258861361243157 ,  2241257162816104656 ,  1747319440313804398 ,  1901497735886187832 ,  2113390950548188314 ,  210757308683688336 ,  2088893915159240535 ,  2061165103005487478 ,  71734529894083386 ,  181855946269664953 ,  994726763644976547 ,  1594494285877099723 ,  569426630421015319 ,  1788446633046356806 ,  1001049186993525117 ,  2143548261589599564 ,  763913579435347839 ,  503932870818003873 ,  2252022237548321898 ,  1889424711030997472 ,  149431449353337966 ,  145373296791917552 ,  534322936363385404 ,  1707672590501905794 ,  356331040855671353 ,  747925893622652902 ,  1315642564190552544 ,  1196756643650858727 ,  612852927491454352 ,  2209590201338060536 ,  2172586713951907515 ,  47552443938218256 ,  2159098756959870616 ,  186096853296616481 ,  1166379512589337004 ,  142629300831472462 ,  944905703658286269 ,  744233769209097870 ,  2261985845126049439 ,  2126303885953347543 ,  1390100616186872627 ,  1754391268863158824 ,  1496575181292789207 ,  1440935905653829241 ,  46531242592727071 ,  75502491368906285 ,  1854292305802005223 ,  878113632591404215 ,  686980531868902365 ,  1143294528543319048 ,  2103602309032862919 ,  1765124681431471665 ,  1804661513384194459 ,  573413122502357197 ,  2134277877336917864 ,  490718690962460555 ,  789549677959969748 ,  1889499488144631694 ,  283836406317707299 ,  995751723564482441 ,  451362761532762220 ,  328596141598374153 ,  1356082917185238 ,  1637467792727358149 ,  763920967105695996 ,  1635792700708357408 ,  1322745482157551236 ,  617224359428913267 ,  692920166884590823 ,  2241770759451084327 ,  2008492868939332573 ,  1076096978914036854 ,  187466585070312947 ,  1845474747858631639 ,  1618314901935940867 ,  619658157430896212 ,  1617706085216338301 ,  895065979832241305 ,  1874886200291473021 ,  545317160561833493 ,  2126864092408072252 ,  1765221802094076349 ,  284633048606327215 ,  607832908487455758 ,  804915290550071528 ,  662286945234531414 ,  1836411830427556605 ,  1264791620189547800 ,  545120680432668774 ,  463801970837906099 ,  548465458395390712 ,  1780879711777470107 ,  666587757985836439 ,  391032229635096933 ,  1866566672159084693 ,  101510742738628731 }, // x^2^525

{ 44092719128952907 ,  236068265111638856 ,  1762176121960026831 ,  865514423529919679 ,  1307818949214916032 ,  2115668178490708681 ,  306149917504215568 ,  1921613780552562022 ,  1508805278893140888 ,  1704894437750766014 ,  1938110223702564101 ,  1632842630831091203 ,  1833827791468333711 ,  885513340965206572 ,  1882066068514674274 ,  1257051571085846396 ,  1342554738380623646 ,  225754840140073614 ,  907799294359344104 ,  2081040360167145422 ,  475096889457238691 ,  588455660902318589 ,  1190416020687312539 ,  1956403683883166101 ,  2112859075353785574 ,  384798720301902943 ,  711675689056437098 ,  397789433563607289 ,  2088216233695632249 ,  185817977826322028 ,  1462221249151491669 ,  1067245315416529852 ,  176617769458215542 ,  788695776941448134 ,  53350759022642743 ,  743892593592770285 ,  372263094191883860 ,  1568863509745655758 ,  1924465337802748705 ,  1533536450452437745 ,  1944335041046479703 ,  1271904947290016450 ,  740191407045660131 ,  295967414862522761 ,  728342927505833137 ,  953772984522256916 ,  1328985634121452491 ,  806581680721301656 ,  554280830193845407 ,  1800090687094928607 ,  170803512647907954 ,  344008656439474771 ,  689150876012068538 ,  1321579287667900883 ,  800354258241701400 ,  2166038406108702930 ,  1490377978308125564 ,  1246569772887297387 ,  1060386663880104525 ,  1942063453009963963 ,  1999284992828183140 ,  1705672426736419382 ,  1718315366160442978 ,  1808198663733309175 ,  1800748188609212180 ,  2135205927329730490 ,  294780319988492760 ,  1047668014397961777 ,  1036070559560704651 ,  2120105770965283106 ,  1100652552982521758 ,  1219369732316834949 ,  1368974093039091998 ,  2303663020986426397 ,  922818462343779178 ,  2216012095939894725 ,  1023300677287306202 ,  202584935637841354 ,  530687807642759151 ,  813723879732343308 ,  274898444469734096 ,  952186308523321018 ,  1318164614040586461 ,  2049526893698526037 ,  1761850380478118332 ,  770851780116356333 ,  156999953007753662 ,  1022994428701268668 ,  1308969740906897186 ,  810689284373142208 ,  1407919007950784902 ,  1310046871405269570 ,  995134626246430701 ,  780016220637312755 ,  1242899464291820972 ,  1045184966462163844 ,  2229364608470619509 ,  2155025884140972527 ,  1055353387168054772 ,  1794943060505840727 ,  350229057135213707 ,  769689924616515289 ,  1094310170657644652 ,  497760682551239829 ,  314046854576443374 ,  1338453435341326734 ,  2067017257901871400 ,  1157268656587611723 ,  1263092959985693683 ,  1020413287450704778 ,  1897819894647987806 ,  1352658770837063943 ,  472272876624638880 ,  476490171141353073 ,  1244505329168951974 ,  2249885383736704682 ,  1606498916149390701 ,  386040601662760742 ,  1778108881844385149 ,  1051157234207839718 ,  1071189610847366715 ,  1374145591714096559 ,  1465859221842036167 ,  888994406190650502 ,  486197158902001715 ,  1193062354886570961 ,  1706697214774262027 ,  746249729589688531 ,  2252879205263889434 ,  1986307765224794122 ,  1197300730762665537 ,  2228219341864096065 ,  1229999303591581891 ,  1486776011985646654 ,  1845103067650085447 ,  1714776409758243864 ,  1415410502440720460 ,  1429091593016239711 ,  2113325542587051790 ,  1125431994704954089 ,  1895680490550315148 ,  224728511359170331 ,  1776709089828440954 ,  182874517346604500 ,  2226167748789272212 ,  764468907250370131 ,  1315211217963383911 ,  2039216132755916646 ,  1269748692340124722 ,  1122088884473196494 ,  169762019692946085 ,  1959115751955337369 ,  2108023612658648678 ,  1471051374873095104 ,  1637116641100310311 ,  2152604400446587837 ,  2286603997339091994 ,  2030772177605598994 ,  771444191539115508 ,  1944903907158360970 ,  305739422924039259 ,  933651112143496321 ,  1480064874990503532 ,  2292604084134347484 ,  706879552556669614 ,  2000182619171119885 ,  1403271859420709964 ,  379740869988329566 ,  1404434402131873728 ,  77687260524502101 ,  1888433822164422208 ,  862985658611356856 ,  1391707194936119858 ,  1139050441802697668 ,  870435042711121983 ,  1358194345408169743 ,  848702463524968118 ,  1142847198002510314 ,  235496313414506155 ,  243314494896757784 ,  671712645283250006 ,  1977850407149086310 ,  546061537940015714 ,  636255795478066558 ,  201565341849557323 ,  1844277938168519033 ,  1465990460639443927 ,  354362474458695443 ,  1258530358316217272 ,  862928634100278929 ,  2184331732917145850 ,  2216915586054465020 ,  1781605774937496170 ,  1296721009387572029 ,  349595847387616109 ,  1517423509771465926 ,  928536694256029663 ,  1025370585223465891 ,  999405932509214009 ,  2179561035787232994 ,  2035490930616257480 ,  1356024598001206758 ,  439795895981614632 ,  899959830155328137 ,  2264277925763644189 ,  1277518401867540776 ,  149983231748228365 ,  360894355803853560 ,  1126629774012959049 ,  290220859634542652 ,  80828174809179961 ,  1471395868694340257 ,  1852882578717292159 ,  2066555604053961930 ,  1508358291276635495 ,  603634927608818686 ,  1934165168459821081 ,  2163471295054962742 ,  1672191852323933054 ,  1402194418923539472 ,  769380087226014464 ,  1875594992400333119 ,  2179154994662398788 ,  2212729505423201693 ,  136990056284042009 ,  1810281377222018369 ,  1843191157483673297 ,  1258784238602784840 ,  1128198023691522880 ,  1302825587752922500 ,  529436160349947830 ,  1598491890344747187 ,  1552351796037678610 ,  625323538934795903 ,  736328929487756215 ,  1103992031970911279 ,  259776789760286784 ,  766071802322781998 ,  1928824616128779706 ,  215078492058589931 }, // x^2^526

{ 231946375736650413 ,  1238319867280175500 ,  1165239687389812143 ,  2267105490604550891 ,  294710411509449605 ,  219822365188451525 ,  151216347210061667 ,  1761663713725042991 ,  1528695137261021515 ,  1066458228105681204 ,  399244438367936451 ,  1799853771226366728 ,  637944901044439063 ,  583903534432892356 ,  1456856837815988550 ,  878027258023858559 ,  754624904623499894 ,  1699917300539046303 ,  1455456845434396994 ,  1216659338208734072 ,  560109194342530370 ,  1546242131295477164 ,  98939172932990118 ,  319535498982524871 ,  1552120958237005143 ,  537958626935823209 ,  2111528123085360441 ,  42949548991711285 ,  2055769122327256110 ,  1783139955038363795 ,  70818090984482763 ,  831914730153421910 ,  276403587152005883 ,  1031758757996439870 ,  310471327850151228 ,  268806983591993004 ,  2194835422948967786 ,  1004029843145226875 ,  178605047155426972 ,  2118677114377772194 ,  473319974104136480 ,  2147653489829752038 ,  2148896894143120991 ,  1111525736287742337 ,  136732603886408145 ,  2110702613316259204 ,  667471480426570839 ,  1120474322325433011 ,  1922627413168192931 ,  144390238189725795 ,  2223366379463706047 ,  549421533677653351 ,  1920429419265826832 ,  912836650474958767 ,  183958370374175010 ,  1005544500525537390 ,  1777963086802443927 ,  1082525087549250036 ,  1363772723239123414 ,  2043968106190950049 ,  1372878416810087766 ,  686991576888992497 ,  1631637129084502561 ,  102923359027303527 ,  785967587772941015 ,  2066801220244373006 ,  1328537456818936498 ,  2250470530844052939 ,  1961333754963136790 ,  34290035353097976 ,  724945931660126032 ,  2205336054709976851 ,  1285294382918160778 ,  169117785206539140 ,  2131745505330809445 ,  325614619651015327 ,  1255523428839358046 ,  341730884890712287 ,  994856295499051424 ,  2221509777302144964 ,  1976712863680664998 ,  1512827423847421890 ,  1003491348639942069 ,  1828672610059050805 ,  1161123864837530432 ,  1073999992944776258 ,  639451902098350179 ,  482118454005639689 ,  293803288979918007 ,  1237548443996316757 ,  834438802020174603 ,  1557475456392784185 ,  518686712650268213 ,  477735465419560484 ,  440997777409399334 ,  1977278956564182389 ,  1908085818619399924 ,  2206831900286637926 ,  892152636967937427 ,  1899868769386900284 ,  796161654854448220 ,  693543440582560487 ,  1897241734530870427 ,  1836155196442193187 ,  282409920643761093 ,  1997976204045893645 ,  1351511899808393670 ,  1940372143512799232 ,  128989810040577575 ,  784389439156871168 ,  993939180583193017 ,  1482351188326618053 ,  835062032470258688 ,  1059706128121894891 ,  1285143068618275983 ,  2117700884056933258 ,  731271458996875862 ,  598112101548493918 ,  1517150021505784758 ,  1733302363667581527 ,  1741893316431364139 ,  244504336773501621 ,  612215110233710398 ,  1812190899684734967 ,  325583369799784856 ,  67600361291092431 ,  1464089564440643531 ,  1253226585278928791 ,  378194868318777906 ,  215832178759622099 ,  486893958181673544 ,  1996040274884607945 ,  1017817851909014149 ,  20847173953021123 ,  1662186388407039949 ,  1942594792098854021 ,  2061954896931939985 ,  957311731434322201 ,  903582056457103552 ,  237692707639304647 ,  1430013858341569574 ,  324218635517384526 ,  1881362263933504189 ,  1152956349685315771 ,  1618974743925310841 ,  1296339846325464498 ,  1898373624718086731 ,  595762024078451059 ,  777662323694499611 ,  81348137942683515 ,  370334267012121327 ,  1651728851584554555 ,  321272121063563270 ,  289179724228861334 ,  1359023485848766511 ,  260656875125042398 ,  192528483152741176 ,  1521745471130181919 ,  1653774107740422402 ,  1708263463841425561 ,  2294715370464190557 ,  349166251951031057 ,  261060345481805759 ,  939374910166619167 ,  643393814402427437 ,  1095653261836457103 ,  1150600715035033522 ,  2202006955645105812 ,  737727067130184181 ,  1807313820170227538 ,  1417889104334087303 ,  260840532835684354 ,  2259375022103843680 ,  203544263691483350 ,  487803960835646755 ,  875117695454820957 ,  1444056494024295098 ,  374810412544524575 ,  1725116619140679779 ,  72524255881051458 ,  359557617010948038 ,  1966596344191678717 ,  26651083967291475 ,  1708841076786338975 ,  1357668426550597108 ,  1496970124458069193 ,  727024714136242299 ,  1486966795048763488 ,  322638102498519567 ,  528814424120237063 ,  2289562218431074471 ,  2066635096947118154 ,  386287637674733658 ,  2229391544861333050 ,  1072950590369074418 ,  1021774334845456409 ,  1980861977622326331 ,  698834021148841336 ,  1940134329987859144 ,  484695858087950655 ,  1096485100693475584 ,  908901203897044233 ,  1845692482934944210 ,  2078170756036039255 ,  500151057258432402 ,  1966213884254226370 ,  1094873038181876535 ,  2074944659514885858 ,  1893326571204385325 ,  769851099766485904 ,  1172328738105566651 ,  789799596407862145 ,  2040574049272228745 ,  1415379247503246941 ,  675858550556933676 ,  1396944239484732018 ,  1369836377608575462 ,  313864711094016470 ,  953819367245536552 ,  2298937857666410632 ,  1307877698492510684 ,  53888154212362776 ,  43878279768506945 ,  221795111509083584 ,  713385628942452958 ,  1596161106900785074 ,  808244118465746314 ,  581727913448692830 ,  337787751139051564 ,  852436544653442261 ,  1104802783338500010 ,  95055742251306223 ,  1370727403076212564 ,  137516327857453016 ,  2285051082088515297 ,  2037817111935883262 ,  2282122585681468410 ,  1353538389298135705 ,  2192720383575097 ,  377062342212976811 }, // x^2^527

{ 1953458080402839452 ,  553336947409183113 ,  1834679332271019587 ,  1828361020013759347 ,  1455407493826257304 ,  397284743925236173 ,  526636685106655590 ,  967894783453896994 ,  2141437885184856720 ,  1715036688791148458 ,  1373886315389839061 ,  202330609467461498 ,  762349233536477918 ,  336339440011010625 ,  1275152165588564598 ,  1857058357868250099 ,  1353459279059000967 ,  2219076646260003842 ,  313811208732508117 ,  1637416289725270226 ,  2148904882261660989 ,  1132047994117883633 ,  1747875564835091365 ,  812222120976460581 ,  1972087227590977088 ,  653904230862711218 ,  1497119230634874570 ,  279567102922183718 ,  2103105207000266030 ,  45118440763741966 ,  557793599576876599 ,  1681121449827731594 ,  1279523797732259032 ,  2076948175983550059 ,  2221093849755192030 ,  82942017619081609 ,  868921117451341638 ,  562557352017936423 ,  1100128842542832284 ,  110402269021315982 ,  758017528510692242 ,  324659624416369936 ,  885359404980176912 ,  1687251380710227449 ,  2101055825794359713 ,  1661381728044067010 ,  329289583849426892 ,  1192042271707350814 ,  2017308085668542055 ,  1649122946834837070 ,  558124781291410258 ,  1531490488673905410 ,  2073512793773883501 ,  145153022706288830 ,  365511028391712682 ,  2119358304669610069 ,  1834800031029760217 ,  2275742028364400175 ,  707105114247122767 ,  1039614604913740748 ,  734228543040928096 ,  1822519263763737952 ,  1845785656988326043 ,  317565777056836462 ,  371040221616215843 ,  945323034144015983 ,  606341043541253502 ,  108475923503973150 ,  1065352681645630662 ,  689665018576641561 ,  1821086389865333426 ,  426567858873510791 ,  804716288329883681 ,  1070224267845001771 ,  1917601663492812016 ,  185302807573188527 ,  84511994851658652 ,  352529462346976232 ,  866808007642168960 ,  1934921664125346247 ,  310110267531974950 ,  723807596594512079 ,  121973543585078583 ,  159642183079107714 ,  1493585716450071605 ,  770213122258570189 ,  1844464442487175552 ,  1130996502832497004 ,  1888271593511743005 ,  845339287413186343 ,  471416737032956765 ,  336041146563362185 ,  870186788843310214 ,  634326394735810396 ,  634920283055276821 ,  1603025262228662379 ,  1644621228142458003 ,  953164487507030236 ,  578721290903358213 ,  1167707315856877653 ,  1945215900877904076 ,  437148099784834969 ,  838629952501158738 ,  1135835051656121170 ,  527794412260427976 ,  288863351679515554 ,  1649212880768350177 ,  883757622822861420 ,  1158346450671185989 ,  25540339484523177 ,  152165494507361485 ,  643734955920084050 ,  430316516608593362 ,  1377210945075360340 ,  1779345696619982993 ,  1354523186014767449 ,  309311507262385129 ,  1813424536455444773 ,  1468630996656621710 ,  1640344114703513868 ,  2209437712473408815 ,  5451574499530960 ,  481839722358480423 ,  615407227482550357 ,  477714787050337663 ,  2254444768345599227 ,  1264646062780051705 ,  1250999705219336145 ,  1676237675571831243 ,  306844847426788172 ,  321206975141460493 ,  2220645105855601685 ,  816007760369484429 ,  1159517700257574957 ,  2254520836004394661 ,  1971058078785830701 ,  197162633133380244 ,  1239080747916209719 ,  1611572896928282795 ,  313356964915888610 ,  22576198065854759 ,  653013721280757667 ,  1809501792434355095 ,  2229474202024340019 ,  85553166510571347 ,  7130196868874228 ,  143593402228500647 ,  1976310568548025483 ,  1639101257274997106 ,  2024353212336649822 ,  2128187016194922235 ,  1493865188451383272 ,  176179676889247904 ,  527995213552791444 ,  714766033857128193 ,  1822984003179037451 ,  140001615262547188 ,  1585401167991581774 ,  1306700265709820826 ,  69282463191559093 ,  1482519087386655364 ,  2279466834642219108 ,  1266824761679531793 ,  279146511180549215 ,  1636385678029796381 ,  279215195898578650 ,  1271822994747938278 ,  2015662742893254352 ,  687796213304730923 ,  417066129073000659 ,  1066504849505021735 ,  1942804979732647434 ,  204211209573191007 ,  1802144534725947525 ,  1193643274989011167 ,  1967275581943385985 ,  1553518170255938317 ,  1591874937551298761 ,  419003379356676474 ,  175948002684730892 ,  2199278191464955059 ,  199982738705702651 ,  1723785688505603278 ,  1205855622029276088 ,  1074785743834805605 ,  318064353331331610 ,  466635814060358886 ,  381305509362119319 ,  50891748549268301 ,  420912974167443514 ,  2052822769288948988 ,  1571666076828239832 ,  1477417579877192842 ,  2222601440050826474 ,  499273795581843978 ,  1263800283830532110 ,  1099273659881434242 ,  554452905181839736 ,  1719536678467164630 ,  962334903552591619 ,  1268705792949932047 ,  487100253844988307 ,  765746819763619011 ,  1380127481556857990 ,  1529019562621897061 ,  1540419812323786033 ,  454264835238166627 ,  1309206257550877764 ,  2211532031244639251 ,  727153134507596321 ,  1761187675688927428 ,  942787860051280381 ,  1170593041105709592 ,  2129715835217896908 ,  1587897575868612263 ,  1030936192209012071 ,  1259844721347533274 ,  1070848430053884090 ,  2004565189335493779 ,  472157433416557748 ,  1100001654928742847 ,  168930324607283719 ,  1163666865044461237 ,  1987371390635715445 ,  1095271067489400407 ,  1100925221673883505 ,  916794273738175176 ,  356110519110157589 ,  735533574041948903 ,  787515254782997031 ,  967969536944250660 ,  1134712169138596877 ,  2185312804864293508 ,  1839679592052539378 ,  1763788046650341876 ,  357211031100665499 ,  953902359593650269 ,  940178884154110888 ,  1066396659163447571 ,  437570120036667813 }, // x^2^528

{ 1974681816418124725 ,  363305035860088258 ,  348542001030659453 ,  446229133782356166 ,  785137944148317412 ,  952783307860038956 ,  2024276303983178678 ,  2107668553931010092 ,  2209689964062873639 ,  514781956107991825 ,  2044630302555277907 ,  1964685301864915409 ,  197677113425861168 ,  1925949800957248548 ,  1862890281458349226 ,  1048401963999853366 ,  1757042980332167606 ,  2199216610008153996 ,  2028197595279640627 ,  1932126806879704606 ,  1908893924145415616 ,  668187759661004806 ,  977101011933463491 ,  1271507204556196890 ,  681454997817692173 ,  1482381823167816812 ,  1345356755689270396 ,  1234734980829344590 ,  324522481794399617 ,  790009027120552150 ,  615593981051186579 ,  2062549361894623256 ,  1429712822838795652 ,  48009345125359965 ,  1694001462656902537 ,  2183576415751129348 ,  93669573219145823 ,  143322802212732922 ,  315850161856820030 ,  713253819200812249 ,  1595238218370789835 ,  36957244014044704 ,  1699771329279179894 ,  1235830040161928625 ,  527207798424185582 ,  1982717788766665742 ,  717410199543541082 ,  482280798737560968 ,  156498326678465379 ,  1443624626218242182 ,  1517378055134423542 ,  1222836283409531052 ,  579218549441480996 ,  150001082231484100 ,  2218855607442952088 ,  1388417171444330490 ,  1965832769228565564 ,  1021298485574276869 ,  1671772952608501324 ,  1906261776108405139 ,  858026284361149421 ,  861999404302338758 ,  880628700312147361 ,  2065468953338202888 ,  1015994712355713328 ,  702326657534896625 ,  1271404044887599920 ,  1819139580716435106 ,  1000488899600880886 ,  1405129036129590523 ,  1357085700892069130 ,  2299705101861214841 ,  1260605874646386225 ,  1413901742236795802 ,  703734619523364592 ,  1993421407640841489 ,  168588617804829963 ,  886306601808756952 ,  199903464951430774 ,  1516665754341771416 ,  1230889470084953122 ,  2173809712130499599 ,  261614727269208144 ,  1371781323349635172 ,  1638353558924741033 ,  1881788350587846096 ,  888828233459289093 ,  208282571733986055 ,  2239273527346927920 ,  648295753030377458 ,  2298041651395618475 ,  261841172124279919 ,  2300802603529819090 ,  2141453623225379377 ,  716164173829498721 ,  2276718025862413700 ,  1275855577593159190 ,  1109174634194930741 ,  1959041728491447729 ,  626237564722191442 ,  1842988873257040698 ,  962100279124266724 ,  49675824569262 ,  921988498290125998 ,  882361514439008252 ,  61326239927141235 ,  667261896542857177 ,  952627224116577112 ,  1491722390062415724 ,  2057739260943859791 ,  709800307074608116 ,  1948807903651034843 ,  1482795672483111210 ,  1889051764420805072 ,  1100108864549678594 ,  699968710870782461 ,  1596763124993234205 ,  1892924487423806396 ,  662348362165189286 ,  635151133114830957 ,  1887902342466014382 ,  985568288010720223 ,  346060563874498913 ,  13377344626091094 ,  244275844670008761 ,  2125966168657561661 ,  948068164226879494 ,  2080284635774316070 ,  917958527839321174 ,  777152463076652037 ,  1863172212724681944 ,  965824063835789307 ,  861463319310971409 ,  379908572944805713 ,  1730833693243996324 ,  1377831015149961762 ,  531333620633340014 ,  983625724404631532 ,  1227380721229156024 ,  2022679670248832535 ,  239667772437029993 ,  1631373386285106588 ,  407676374997156376 ,  1049329734685405425 ,  717858050846496533 ,  1520308354086648801 ,  1581563614694837032 ,  182332072272985725 ,  562596202788448439 ,  281683219326068400 ,  361379557906714478 ,  375253822141881780 ,  1582730402355696818 ,  142325242221810980 ,  1190327287731865926 ,  2192102420054501315 ,  1016351276044794379 ,  1895367029396081706 ,  2179478451224019784 ,  2086148079757841773 ,  1705051824540779635 ,  1499847433468828771 ,  1529720327786774485 ,  2024912028128185482 ,  1978766222066318667 ,  1731189058274605489 ,  1528759365181355107 ,  1090107379419828159 ,  1375957375331077329 ,  1373063764155002575 ,  791269938124084019 ,  1527345541880184647 ,  2191657693742438511 ,  2150619352247821414 ,  1106993588562970689 ,  1077125132557742308 ,  7701498866201344 ,  2131783370319343786 ,  2010882913385477456 ,  1808103024681687877 ,  1569971477020389634 ,  1887040844633319466 ,  1988390603110455605 ,  862605431637587330 ,  1209207559007341081 ,  916689878661953782 ,  555903588066260088 ,  453630981069980697 ,  1291806587371721436 ,  1829268763515261119 ,  1435615489763321519 ,  1787177375649594583 ,  2040081098192499015 ,  487124067925792984 ,  1959763881192990798 ,  1180320557216323957 ,  867074193996384903 ,  1510588670151690859 ,  1689958953409265701 ,  1371091019654324224 ,  1705229726992601449 ,  2069499334330143247 ,  2032777267545656383 ,  1699794950054620428 ,  18284334211973868 ,  513779996746634272 ,  603434077570635391 ,  559777933929132841 ,  354727340149749802 ,  1965474422035123801 ,  1193830219382633009 ,  2282324408828709404 ,  996086590989564935 ,  1642797232791181874 ,  1287605449192272583 ,  1172407812312752019 ,  2172951316516342655 ,  2285090802795398894 ,  239250329880796600 ,  1291523763221031425 ,  814349168942115801 ,  84844704897104759 ,  168083037313605362 ,  1588926991954556784 ,  400743550371483058 ,  663129005511502452 ,  813800833770490337 ,  926902359433585234 ,  853114374659309111 ,  725524597842744084 ,  2272076283281195259 ,  1284900862329574808 ,  453384740023373636 ,  1513159572877054210 ,  1467485368836693945 ,  251861797817043732 ,  853884386632801330 ,  1506704935351481187 ,  1062208938611591164 ,  1196911383848553590 }, // x^2^529

{ 2255025325400522190 ,  1052067759630395500 ,  578693897337558605 ,  1655757428766724013 ,  2172975924049972797 ,  2021421863763053311 ,  2157780215551321064 ,  229668625811252746 ,  129875314222630146 ,  1075903777004023431 ,  669252255401583613 ,  809252605612225689 ,  1022106874100440 ,  2180415168419885670 ,  1691380402454549395 ,  1695895127119151218 ,  1531029675565561738 ,  1736145515036827668 ,  2292310899674852183 ,  1242216445498770887 ,  808578968464165932 ,  1196223035737386373 ,  1225011237819697151 ,  1394485288394934793 ,  511196148520311497 ,  1963151735163290883 ,  1860603480885810363 ,  21061113281523369 ,  581077903797113084 ,  398393901818570961 ,  2139895443859603490 ,  937873200103745020 ,  177697219254189316 ,  477763326554404937 ,  84077585628056083 ,  612638115436655268 ,  277492372745662021 ,  472376898261498882 ,  643556438781728902 ,  1335855114915790255 ,  1789510628288055015 ,  1885539335411657682 ,  311958502385133541 ,  766666230106859036 ,  1301422287431807549 ,  940367761323504290 ,  1871699632788889251 ,  380287401582041911 ,  1040737394926200779 ,  1467085950060161342 ,  1522721601171692995 ,  1645046980001542672 ,  697192137156914074 ,  1725441743495137006 ,  79958685224175682 ,  134074613465625691 ,  1863684156689548783 ,  1592553940253277174 ,  830047815249326394 ,  402020178750960922 ,  1542722447728157624 ,  513208016306620843 ,  763751248709463709 ,  1846372452553753338 ,  267356994396339827 ,  1727818599927712529 ,  336729955170559011 ,  361011374915599895 ,  1327959274352655979 ,  1586422515024798283 ,  1197637416860719980 ,  1878231243472275723 ,  349354074889802552 ,  1773424978491433372 ,  1262088143167503363 ,  1275461134722388591 ,  233780206984953059 ,  1705681818713767252 ,  1393807461716295939 ,  983241379219446984 ,  695711492323041505 ,  1201352611133349324 ,  935880937951461709 ,  1413556556917987194 ,  1916812528266835916 ,  971605394888050115 ,  2048179781334224927 ,  2264435130943708704 ,  1288644267992247905 ,  452670132210295326 ,  152064473045786891 ,  873123137616499253 ,  1742665091139806701 ,  1648358472644965847 ,  1728812149498126078 ,  1273192511976596667 ,  643814413513069753 ,  1023305477797449967 ,  970740364644518649 ,  847869644848249778 ,  1248586902108784881 ,  1927718539122486511 ,  537240891568882753 ,  1275974831829345935 ,  2150460268968514802 ,  95137270339944044 ,  602597604154507663 ,  864130301947990825 ,  210325310948468352 ,  2269689801610986140 ,  2073435816200106926 ,  304221757581069373 ,  922781287431584730 ,  1386569173246414513 ,  373912775231184859 ,  228742459159072176 ,  619705989187380873 ,  1293096158742695061 ,  2067557708828949833 ,  86349802988508509 ,  1694135545363476219 ,  658669593631487070 ,  1798794974581783192 ,  707336611788385226 ,  366433620769061304 ,  2226888364923177260 ,  1393285945752290033 ,  1079638402143756776 ,  1478072938211477431 ,  261891642720927036 ,  1931115947646070402 ,  392494139855134500 ,  735437219014279939 ,  684753142858723070 ,  2215341738526887880 ,  2236114605392150525 ,  1097648372470849246 ,  1845200078111466182 ,  1958172537715143743 ,  2242509162554143401 ,  1885556717265332721 ,  1303529820631577473 ,  1570315851842855603 ,  963199503631601636 ,  460896292288436232 ,  1000659710468276551 ,  1797568944367219735 ,  593826433797345839 ,  1950232670089562573 ,  1076093998362263317 ,  610775796106158390 ,  991678265827558669 ,  1788677745114048490 ,  229791285639452170 ,  969302437426745572 ,  609545807095343987 ,  785823407480804794 ,  282202254797317504 ,  2066056115978828393 ,  1218848343248263387 ,  1698114138773064879 ,  360666799823857336 ,  868224343875535953 ,  946891730623864581 ,  1188385754097766499 ,  202335433551909449 ,  1071195651768940873 ,  2185555569583092766 ,  322665679418563248 ,  1117910932327656663 ,  974872621541974737 ,  2239824561530626696 ,  1216026298585074541 ,  1757943585926776531 ,  858990632217481229 ,  595239991886061772 ,  1513204195191436326 ,  130191177460449724 ,  1561374414269484035 ,  902489812670836281 ,  1208902986134666335 ,  262684268322598169 ,  1176196630049274645 ,  2226278691472604324 ,  1725025803833041369 ,  1653821769306298580 ,  770755966530003090 ,  1690010878141548618 ,  459932642896772155 ,  2111514317746087199 ,  2167225943066388141 ,  736585859432755000 ,  2217897396742731368 ,  447282193937218855 ,  506438585454168148 ,  1406356678696068869 ,  1714513307746249327 ,  541150590079984283 ,  902584147904737521 ,  265018636260951081 ,  1376350956469588239 ,  662479508152307495 ,  2247583016203377659 ,  1661802295986753439 ,  461408926085293148 ,  1469318863421145431 ,  1500654163559902817 ,  1691512779011132558 ,  1748096146607729323 ,  1244691665819710038 ,  2069951699408005725 ,  1076486077555294134 ,  988216357208129843 ,  1251696210604619610 ,  220236544795573395 ,  39958973570795186 ,  1156620075432140547 ,  405369105200185707 ,  2255776072112777348 ,  1698512441915421119 ,  2217581004582419798 ,  2056974786951292527 ,  1273483780247387549 ,  1574769980975158715 ,  2087903845899962062 ,  384208855546090292 ,  361628774930083410 ,  1164160897951833844 ,  2281272907284333742 ,  1758832359949961872 ,  1980983420893852708 ,  1111305408540197714 ,  1633568876656520661 ,  717338840956958573 ,  1358763840939772703 ,  2287736318849243848 ,  44379162638272953 ,  987035527655082238 ,  2033112319978541809 ,  1859813643041038682 }, // x^2^530

{ 1548577225716308710 ,  1426983295284410127 ,  530321667024439583 ,  887164522068230628 ,  2121615723530949046 ,  1124668516259965572 ,  742622023013785344 ,  1872916768081159061 ,  1522748993820586749 ,  924920388736428925 ,  424989149280526457 ,  1707631935722296641 ,  368697548106552015 ,  1598598207637715333 ,  1437167518673464650 ,  114631781765278988 ,  317654707795816908 ,  981183507908826478 ,  1849796280619587917 ,  442844824887708225 ,  949512144891485760 ,  845199749253594747 ,  2142087607822598411 ,  1672961261265633714 ,  1701148240714746742 ,  1961075260154252226 ,  54775832916840383 ,  934134910721237690 ,  1095396086422628144 ,  403189356457142799 ,  454820951430763071 ,  1850762224325542591 ,  1051178207810585608 ,  108404328994653303 ,  1021838739653159365 ,  2105904776492266633 ,  2263183042975757378 ,  602539335490521928 ,  875858800039579506 ,  810745468011802501 ,  239048787720822418 ,  1024171824706013329 ,  316680078310052454 ,  20642148039666738 ,  2177199335922277999 ,  1387633009399766937 ,  760324469242044972 ,  1880840528345698785 ,  1194479717928647697 ,  342967931282948378 ,  1357243983491534930 ,  447089524436339744 ,  2215670505797179703 ,  1910493115919222385 ,  665694157953999438 ,  280686020178476275 ,  156128792476838248 ,  1556216446193254200 ,  1229056595542683432 ,  949988352117130343 ,  2095923750259610246 ,  1636040553866126913 ,  353486114276546352 ,  895388650728146369 ,  1412729163015319246 ,  1144553267710621470 ,  1666249597399193612 ,  2093703236513119025 ,  91999115186414957 ,  620033408256636206 ,  1675956202991801704 ,  842936181442334174 ,  373727750913690156 ,  1045534427085917305 ,  279983565462431884 ,  205302340851073801 ,  2001291991033730139 ,  1812800713038856870 ,  1213007825195397965 ,  429201855120569249 ,  1708479298608694579 ,  912459936095044031 ,  340029813591261658 ,  879110892755344478 ,  102544038653804462 ,  301486544088971265 ,  54030351626501929 ,  862985846184635228 ,  1163169835321212558 ,  454284370079594941 ,  2182846721034098424 ,  290269822668407855 ,  1788033642147443837 ,  1203366256956256773 ,  1501269533207312614 ,  877763084811953734 ,  329284611411599446 ,  2217845882413991788 ,  897411448351407525 ,  1924728194636013670 ,  228937131765423348 ,  604095605870786320 ,  690033314968519522 ,  520639760917894960 ,  1471494158495397591 ,  1642341110712218157 ,  710947941209406975 ,  1921923889124275256 ,  1793853119331083828 ,  1978057684242104000 ,  2812984421150831 ,  327054672866018708 ,  1412569165344897126 ,  278686572314921366 ,  1564368977784383386 ,  1228016675376189077 ,  868620316195087544 ,  564239497728984299 ,  677901242980245390 ,  2149830123664291313 ,  387925516085852605 ,  1239537747924391475 ,  123912111364782851 ,  876145842769324119 ,  1041980242017637228 ,  1054810614472308923 ,  390556453332549668 ,  375818115003440291 ,  468969179818590881 ,  1645142370138205268 ,  24335757896409775 ,  122095867289269198 ,  743063882414386103 ,  1598777370361360939 ,  50685631128899187 ,  1229794029117672344 ,  525766441706260137 ,  394666702533700237 ,  491420458501235169 ,  2050069535013763565 ,  298187861435035614 ,  1211725013842873961 ,  738936330714935604 ,  103469188498496195 ,  821077655526095542 ,  1672898167763388365 ,  1281735159317157364 ,  956374695482903168 ,  1501438674082799969 ,  620476653311299582 ,  529582243997326135 ,  1720877887550841080 ,  1652712366163808815 ,  1631079137036297375 ,  2201185900348101547 ,  1150330794620041488 ,  930547509848892789 ,  1106258703861952494 ,  1853433701385867990 ,  1809709853221084933 ,  45027968252408732 ,  337663078577537762 ,  1264100433525322700 ,  688511313335731314 ,  754267008495129244 ,  1781081731193672754 ,  78192503396157913 ,  447895594515955382 ,  1570668949702449221 ,  1705879100497293346 ,  1347249616209315488 ,  646311556245175636 ,  2162052900486364796 ,  1482844382946476928 ,  431102908848025903 ,  424129003045145533 ,  450623168985525612 ,  1200293633150309842 ,  1078227785685200368 ,  1761221646142590174 ,  341057831050996862 ,  337731428201108170 ,  364132045753930486 ,  1381086064966763281 ,  459223947595713167 ,  1320379822769511385 ,  555752810557145353 ,  450948866762459704 ,  847413613474846500 ,  2232672198002136725 ,  336989272794625423 ,  1968993263881384863 ,  2241634077476220784 ,  1519252481245053781 ,  976025792424008770 ,  1794898599613476542 ,  458204029979723813 ,  444733162932906891 ,  55174973279462817 ,  113250060860336724 ,  1440820792133344661 ,  738482525829957114 ,  981763011360023620 ,  1119534103408393090 ,  119523172790747482 ,  72976661597634511 ,  924097148917527931 ,  1394065845711302226 ,  1946289525821596287 ,  1670745000410876320 ,  1429291058956172153 ,  524099819304045055 ,  788362534570732755 ,  1624146725254790122 ,  1830242350785472616 ,  1560866220792210885 ,  1711345636036850188 ,  837404338622519515 ,  735253545299941676 ,  1692440748018444837 ,  1189249450954794603 ,  1448855814863620110 ,  160536702106884912 ,  2173815212558300955 ,  1792228448111539758 ,  1771694285620787058 ,  1401352556593426470 ,  606366159798763678 ,  1214958057608949661 ,  829731446402305285 ,  1381560858759892908 ,  2108184040396470327 ,  2213361008223820289 ,  1887383307400264048 ,  49596898702346730 ,  219112266264678350 ,  1905649258737339166 ,  279267058951224186 ,  136983312384036620 ,  1838606109245615977 }, // x^2^531

{ 325803714646813520 ,  1769839088201985887 ,  657468421708774798 ,  1285699454764675785 ,  1599968067067724681 ,  1829311899604092693 ,  690768019881834878 ,  34163212153214789 ,  1559006833750950196 ,  1697073781724662975 ,  1270358627428053785 ,  1112367818698118417 ,  2215905356343731133 ,  2103336930194228224 ,  337668235668343069 ,  698542782571923212 ,  1078712287624019406 ,  664083831469801938 ,  797616815395588300 ,  1648635860570102118 ,  1064140262934617612 ,  2258277450242513584 ,  1621396589513118495 ,  1625682076323014180 ,  3916327697026332 ,  977414264753283867 ,  1741597670275228765 ,  238966763663423014 ,  606113440422664367 ,  1237242095232517337 ,  1304446407658338072 ,  1512396012107024699 ,  199768489174807621 ,  1998655988646795895 ,  1286300175839211300 ,  80924382505707442 ,  1361133443616891005 ,  1110611390874291976 ,  1905807362698707125 ,  1076232236358724395 ,  2019900340051745592 ,  1181047028222633440 ,  760424447317168123 ,  1994103078187192957 ,  1020882948840593260 ,  459350107774390078 ,  2078661189647046409 ,  589136177270743018 ,  1552350817796698083 ,  944039413322410917 ,  171721310911115353 ,  728159715214864350 ,  1311000662567174433 ,  1582182030219604757 ,  448200806495236574 ,  1469631108125556259 ,  1819499494489993916 ,  1474825298416057379 ,  765626001927257816 ,  403715812148623972 ,  300642884830729260 ,  1072696886840565769 ,  2028659337784855178 ,  365800965572184169 ,  1894795093401279643 ,  653469869662477869 ,  1699773544543123145 ,  1142895222878112784 ,  1926858352906085102 ,  2104086656091675504 ,  2198303586941235605 ,  752351160923423295 ,  801043924217412798 ,  1996023121521192057 ,  359661639063168973 ,  1208593512698215918 ,  1371210585249787953 ,  1245626091597755134 ,  1156166812336609769 ,  1268000317755091639 ,  1556079030655766423 ,  148382867216789922 ,  21877494291510280 ,  543955045548339233 ,  842259624344068762 ,  793503903537992952 ,  1782824039921214079 ,  1171212243822506368 ,  1915762184184737940 ,  1173480561642862788 ,  1254350592303062827 ,  1696194468170216582 ,  487197487110557126 ,  1675252436704888078 ,  1464961051059458091 ,  1994008501261137974 ,  966834082847543405 ,  1542489373076415049 ,  1752213203961426747 ,  539230497685093654 ,  690715488442552459 ,  1688740990133851169 ,  73586777609595459 ,  1522394266114443256 ,  754000406153332428 ,  1487778392740391514 ,  2269037737054009735 ,  59361561984366938 ,  1202819914476267517 ,  941361563980952562 ,  599142021535957959 ,  1771095877523125023 ,  2279627055527016363 ,  1169087118659254797 ,  1664530939494365604 ,  2278211998782419497 ,  1769702047388071643 ,  314012688919363582 ,  296101221643273661 ,  2093165490963753051 ,  425703294673503369 ,  1730072207059139074 ,  480667634733364898 ,  792657776671946937 ,  2198458980836315973 ,  1310839556870108105 ,  692918454423111988 ,  2214214521047084619 ,  1442999056735712208 ,  2106831022576260194 ,  314934580385761982 ,  1300017490909829292 ,  532203541448847798 ,  268828385131439655 ,  2240132725466609391 ,  1348715693882520255 ,  836381290348637798 ,  1785266120199677806 ,  330973740046796167 ,  202521757821502015 ,  1180507960002909137 ,  1127175725017540650 ,  1584333239273788057 ,  1089751119055278636 ,  2073413904504514858 ,  768181692316896539 ,  1347800514699013557 ,  1379504688718330185 ,  508508352950888881 ,  2226767514607551375 ,  1374780146153261675 ,  1941123697671807386 ,  1078356817250024140 ,  704932474828591695 ,  698230467610154180 ,  948896866829110169 ,  539275158281472937 ,  328896497054350085 ,  375199572805299999 ,  51043645575610832 ,  2156816304260226222 ,  291963461230873968 ,  2155229303304094899 ,  756415902472263203 ,  1441185765732058029 ,  268474134332745745 ,  1356750888420277822 ,  1182098540482833793 ,  90166993200620218 ,  2019027619385884455 ,  902698243559411079 ,  1599408087505594505 ,  1488436422833209207 ,  1800948399308038017 ,  1058476258887672685 ,  2084252814141866934 ,  1864144833204076061 ,  838360763781734438 ,  510708377582317642 ,  764862345016604063 ,  1444689254198959648 ,  284358083113998477 ,  518584896533694282 ,  1182777222148226310 ,  862623611831786265 ,  604038202547656262 ,  376082988824834744 ,  2094328345779019959 ,  1176163046535178800 ,  1077349236832235981 ,  1464246446618138566 ,  1254965793948533919 ,  1714122357318000301 ,  455030882386045750 ,  1454814027025679697 ,  2038205245654373176 ,  1164931081965866888 ,  88832429829192479 ,  1406975030022466347 ,  1970499622461157605 ,  1628004959061373550 ,  375013572016019450 ,  1549297641016463314 ,  631254673240184990 ,  1842593008696207561 ,  1476590606135499481 ,  1459250255577416399 ,  255876177421242077 ,  417170996569789926 ,  1815050073717529690 ,  1238220711885369577 ,  1777759144504711055 ,  1565418836258684729 ,  982969863598036800 ,  850276162019742935 ,  1654648865247013811 ,  448122093908907453 ,  1040656193088738512 ,  714775027597759192 ,  2259708546071816419 ,  2193229214874883583 ,  1058304959106857238 ,  1603694472794786064 ,  953140108697400838 ,  940691950323121924 ,  728897402169516540 ,  238955144737885407 ,  953020113358364521 ,  1460278560165572958 ,  1636543023643395519 ,  645605757220334819 ,  370500891306867491 ,  319014094772840042 ,  104995303017138176 ,  893788212369177254 ,  2246174527812222000 ,  941570910508855527 ,  1239973591615868935 ,  265616939537061420 ,  674270056172474784 }, // x^2^532

{ 771177958184342915 ,  1820995613565909417 ,  1678742813431506004 ,  1117328662288628830 ,  2188348957192397020 ,  1435363306612288207 ,  386416297444645724 ,  1497319404697685284 ,  1174733792126311966 ,  1595822630944059494 ,  1112046341442195439 ,  603499630377171600 ,  645190847293268802 ,  1813805565938814306 ,  1983956870064100160 ,  1138406481849029048 ,  800580653943017445 ,  169258044568079432 ,  377000052210893008 ,  450486595636304632 ,  281168860779374136 ,  403989241638221998 ,  2133857785013774941 ,  441980705290647494 ,  159423072177625410 ,  881982751628732710 ,  1360852125856095214 ,  2144204831166507215 ,  2161768609883434571 ,  333745109901005141 ,  1852127606068356676 ,  639772412407592912 ,  789416628080892939 ,  1329208595252738527 ,  2290222413804483376 ,  1876883506854570336 ,  2088331024098575927 ,  2156969249477756571 ,  942692264335245106 ,  386357965593365654 ,  2156329210628328197 ,  6804879772271891 ,  105555230390755499 ,  1393638961416398804 ,  1033492100375677805 ,  1471919990677701005 ,  896846241823791445 ,  419307852062952476 ,  2102123386723296323 ,  1130980426189775468 ,  153929753004135402 ,  261288184334735265 ,  128021191484758242 ,  1971498348392494121 ,  964979739958115545 ,  178559148778863146 ,  1062061276764528004 ,  350963210270848546 ,  2233184564685241407 ,  562748971919793541 ,  2252419478937317500 ,  34271131043216174 ,  2227578777178999461 ,  1539188768274123086 ,  1353253116516832860 ,  1918417027448971449 ,  88294420122293691 ,  328212510748971645 ,  810159372588376460 ,  130612080807953445 ,  1518096032272565376 ,  628125909809267559 ,  1693920234720785483 ,  1912975189563062470 ,  189964748420949697 ,  282226875057778190 ,  1530636134083048230 ,  1900856421816244563 ,  2269227279642876989 ,  2079867718364528342 ,  955490601373560242 ,  435394131705329497 ,  1625196064239660405 ,  802067687650855778 ,  2020978952072074518 ,  1907190209877553318 ,  2187174241463213501 ,  258650171237723429 ,  677316202903901871 ,  1873889144597021557 ,  275460189960750414 ,  1869944626178374626 ,  872718159650874025 ,  129906469324400332 ,  2204189962049997096 ,  2041617630475676218 ,  2016884489806941017 ,  81928847791718798 ,  1737966680213346742 ,  1772077004196040758 ,  829235558379182734 ,  1455981827327425579 ,  2270608506004974164 ,  67747417707378681 ,  406452503594157449 ,  2304098075022656967 ,  1910260777927424986 ,  514962059177823532 ,  2282544266702662143 ,  1964450835989183588 ,  960495739366268473 ,  1118459579660804113 ,  1202885235005843903 ,  58309647703779256 ,  561893281482858122 ,  1282667852937052168 ,  1991766885559015881 ,  1104172300023725491 ,  1027973491972948577 ,  438414595042065678 ,  1950421015464420404 ,  147844470891103308 ,  150407096777440391 ,  335234863629043752 ,  1626872858500965905 ,  1526261059127468014 ,  1746235070571288641 ,  856999939086620702 ,  1244915611952889545 ,  1626778188284309396 ,  837035937904479187 ,  469724850537443653 ,  1863316325558449707 ,  1157533783355270719 ,  1171362154786377795 ,  1330284518691964744 ,  1952440249194479489 ,  1343156924494865691 ,  67880729539095256 ,  1270459017616390597 ,  228745334212045826 ,  658575780184691308 ,  120376958345896187 ,  1045598811329222877 ,  2075652104126703927 ,  142033287726226568 ,  1826901978974451371 ,  1618415341710678235 ,  1359322617529432236 ,  2027830124891285945 ,  1559821422677086946 ,  2274086565376029982 ,  623749076216520703 ,  574023008226229273 ,  1168671396895915379 ,  440192564485538365 ,  1919022109863204754 ,  1316971041866281185 ,  1615751099949421606 ,  865034314894204138 ,  1526145361352812060 ,  101239631944715984 ,  1755412739125708993 ,  823868416732591144 ,  1221933407533257698 ,  1497084206128112127 ,  550119750451774669 ,  737915677844734291 ,  90521578917325575 ,  290496215500389136 ,  75030508183545545 ,  2239934134723898805 ,  1355527464168061290 ,  1719554172320480492 ,  2156135757149294270 ,  1403123210955283709 ,  1214835867557105828 ,  750673818575064217 ,  282062223795427674 ,  2028246282269331327 ,  66107590729891636 ,  1667273864693419129 ,  443238540525164760 ,  1178100492899707741 ,  329159342246899733 ,  634447943962777114 ,  881763904112814025 ,  1175172282173787057 ,  677403445274537499 ,  1250329955085511139 ,  451786186570828588 ,  931125292519532426 ,  640607125763522099 ,  2301409328008703193 ,  36470656661924241 ,  1837447731431605710 ,  409667731117873473 ,  64627052317558475 ,  1570825403671023536 ,  1547906098525388373 ,  524539690732011201 ,  1406782892612237492 ,  4672048971626619 ,  798933272691127574 ,  397475392126973556 ,  298448489841099320 ,  305439976742683393 ,  1862540654874309902 ,  1003093475603922606 ,  564231061425134617 ,  1176037640744606725 ,  1029013165575127078 ,  919312521012710439 ,  895552722703062983 ,  1536841486309819628 ,  445952339134612600 ,  2180617678408443115 ,  1953221997218335786 ,  409559213711547138 ,  1445365228262009703 ,  1450975918755176704 ,  1783230525990520443 ,  1580490498042259985 ,  1314819449194970119 ,  311747771362305105 ,  1876965548775468436 ,  2088139126638968736 ,  826107469239259993 ,  2163408549226631783 ,  1659929203897049955 ,  1442705575538089688 ,  1526389706767265776 ,  555160782008850051 ,  1492911548308914249 ,  226534903064879456 ,  1783818744740748783 ,  1486787945446857802 ,  1608010096232910884 ,  93868463290445666 ,  604498392565929530 }, // x^2^533

{ 1217831642686882235 ,  1979375127011908413 ,  1768182703374126747 ,  136658516481033718 ,  707502488717251234 ,  1120978770396124699 ,  354050886151560775 ,  1765615612171113237 ,  2259974763995068409 ,  1689394232714230559 ,  95301968726732475 ,  239264458619138685 ,  428756754928475715 ,  850760174007369820 ,  108835576092577394 ,  2105277459929393684 ,  271478726865753771 ,  1571704824576018076 ,  1296916242895300523 ,  1881733850707966019 ,  510867555597321521 ,  1015682377587861689 ,  617904300923605208 ,  236553575528745027 ,  1640687910788310308 ,  1319914138007413125 ,  1551819384792820170 ,  590228837539664677 ,  310115615470450784 ,  1541614943631112783 ,  2073087169453134877 ,  1699400898735362774 ,  2077738430423967159 ,  293335844355436815 ,  1366751947774536529 ,  1812231178958732892 ,  393108021773097160 ,  838702822639927319 ,  1395300570234988999 ,  1485257454316333367 ,  1133672262440169590 ,  727539196343275852 ,  405180343676262349 ,  2165752882894950312 ,  2275585608012254742 ,  399617670249678986 ,  2141731365531922898 ,  1201389743902545983 ,  1587197356744147958 ,  2169022329010750166 ,  1111158085929271549 ,  1989010010031798093 ,  1172565323578097037 ,  2292908803082578444 ,  1186368680221124672 ,  1373338530989170862 ,  1440672347986515369 ,  1649963703354448787 ,  1103930414605853265 ,  451850724184523088 ,  498610354429881910 ,  1564298989239672178 ,  1987544382488430576 ,  861792144095377879 ,  1202076370446188918 ,  902343658762989309 ,  363102563371376444 ,  1872949610840098933 ,  1610916378142638068 ,  1506266728844242784 ,  1850320129851198468 ,  897294467849199294 ,  340647454799210853 ,  1368830645561377291 ,  106983910905363704 ,  1374756356543325236 ,  969543042155522036 ,  1484151701795531654 ,  334462842193018781 ,  1421306383792781831 ,  2005642017309570610 ,  769989352558499994 ,  1630133442010731253 ,  766828909464813885 ,  2291532309357621892 ,  957689166353668325 ,  413542677430156212 ,  1960956185938082314 ,  355696403945505198 ,  1450441349063289910 ,  385710268683024747 ,  1333032010358929673 ,  1906812648998453058 ,  1409464240165471180 ,  1046603529486483362 ,  2101759181699533710 ,  360896483475513206 ,  1101498467365397339 ,  394453328667852652 ,  2081614182539285942 ,  1249715394033156773 ,  1890460343515934001 ,  477443472412675705 ,  882030330341211078 ,  363122634266971294 ,  408295156389855546 ,  952851140473505607 ,  2151578694357874249 ,  475034975552120659 ,  972146878020387088 ,  561008218799040016 ,  1041567703010600207 ,  241530594650901322 ,  386762587086366910 ,  1801439203829893359 ,  765177065553597551 ,  276772979036038829 ,  2237280233725678401 ,  937508739027049521 ,  296347156377309206 ,  1204211420334822611 ,  331737684397848713 ,  1462705937575970001 ,  46084622710029591 ,  924719748278348980 ,  1349273714476468845 ,  1385437629842288584 ,  658954982468333323 ,  1077829666590020864 ,  117027004777128854 ,  1353816211859312593 ,  748672279175927900 ,  1372166330059912399 ,  1638036272719280392 ,  1122031882338646303 ,  1865039798841648728 ,  69252606291448112 ,  996919193729459074 ,  683537216338450716 ,  1235393745055335566 ,  2102002688765841887 ,  902609208979020784 ,  390130727666419425 ,  1152780223191365762 ,  1495836828810019013 ,  2220319558650104918 ,  2074844585744287397 ,  1253600282546916742 ,  1182632989291993465 ,  1824315026696239824 ,  367175593322295738 ,  1900133578309737558 ,  1204384054486556355 ,  1575865867596307079 ,  285134286228886151 ,  305439256934114041 ,  1642229926566380855 ,  2268364156399763932 ,  1400262744184844960 ,  648236621885770908 ,  439332154870997996 ,  2132179949754148491 ,  2237017212119441465 ,  2283170666371082795 ,  519633215315611894 ,  212058321184143342 ,  1929767028318567828 ,  1102926871963829708 ,  2223543083048063738 ,  1436686988822412297 ,  2168973213471512578 ,  45680900543254592 ,  561721279529950494 ,  1945063947790753574 ,  945812210188560724 ,  582392378352262165 ,  2274069738052005992 ,  615055758592044349 ,  2220161015383179994 ,  1627118025182074477 ,  1467942153030578265 ,  848531863586312916 ,  758563677728535647 ,  1200560777518896933 ,  1658576653721112712 ,  182638538453027267 ,  468063709871671083 ,  2204723999565242318 ,  1105344553599993390 ,  2069055710060886261 ,  154256507368859384 ,  2290309257206976126 ,  351659441886977239 ,  988032486412852728 ,  400133615996302741 ,  1013831857531187836 ,  1051491771756759445 ,  1197262735070861158 ,  1249380463723880975 ,  922595736421628799 ,  296651855410808287 ,  8913745045210894 ,  1797430471491899077 ,  580384003447613162 ,  1396975535742905067 ,  219751457126922643 ,  460253800312408652 ,  2183856053720331685 ,  1379514041059493577 ,  576856239868096383 ,  278884030645644279 ,  1243125732782073876 ,  461366120418893971 ,  1920092610404829471 ,  1226104337598274375 ,  388384299077857669 ,  1429726964133510435 ,  1003531826885249030 ,  1985485766262804409 ,  1544871433530776229 ,  2168657492932509018 ,  36822591195900737 ,  347409458885642109 ,  1335017792405981149 ,  2172246532914303787 ,  1531315206453495009 ,  2047234215976728497 ,  1323711542099907526 ,  2030844840277501285 ,  1570856750389180698 ,  490393852296958269 ,  791750499172742775 ,  772854049829090137 ,  1822778117402424149 ,  1218313488801429730 ,  711070787980557999 ,  1165699537086638426 ,  480623502298292578 ,  1893410714292258268 ,  432765725010036244 }, // x^2^534

{ 918361968418603341 ,  286056079982056684 ,  641931510201932085 ,  303650448935130379 ,  806887339822621064 ,  891827126561412648 ,  2218500621078192895 ,  1102568769866218565 ,  926645560303427464 ,  2067447435236841606 ,  185934103725338839 ,  807509917141905911 ,  1976290284315235880 ,  1110767411458126739 ,  966849049082113405 ,  3655711345575809 ,  819757044405237042 ,  2043234338201127580 ,  1891179729113633351 ,  1922943264631128378 ,  367870975569355022 ,  47202410798630521 ,  1320401833512245649 ,  408338366867289640 ,  669849268379409411 ,  1141445694754699372 ,  853660082928914600 ,  1532024125459087635 ,  607529545101571139 ,  1351327162342893504 ,  1413571145173284930 ,  1923676019465978856 ,  2128800868532359621 ,  311605652093669260 ,  442753104953921752 ,  898289201391446790 ,  517660219045898803 ,  397705527544373593 ,  1115101921803629602 ,  1826428515537916675 ,  941355847904181238 ,  349031628196583138 ,  1606609207754179034 ,  233347615795485892 ,  924279254876867678 ,  1069389219732861840 ,  1254908679695979023 ,  1086715622054144738 ,  1640188717637330157 ,  2175121791958288938 ,  1515302936721096947 ,  1910747232452267430 ,  205688141327265281 ,  922376909449541351 ,  1364740292481687014 ,  1798677779855825599 ,  803525026997670124 ,  1066909397981755329 ,  1972368581188239366 ,  1484141786858347634 ,  1642893253342820862 ,  1289583877234593499 ,  1259543412296559055 ,  985761761762118821 ,  2000447208317744578 ,  1556803445260926275 ,  1450750234309217527 ,  52106333804845072 ,  1774467393372226665 ,  133845102245995786 ,  244685052436564150 ,  1693951194121605953 ,  949845341094933259 ,  1950185309372686234 ,  1980262068234121192 ,  63241314971131448 ,  1821642448302079981 ,  1657587535794992525 ,  2050602377424781669 ,  206981776491702375 ,  1109840565797389306 ,  1162135999985386643 ,  1540355457800686568 ,  343404164927142496 ,  1357731448035458218 ,  760642475932619519 ,  2256505378027997307 ,  1700080120672998156 ,  1455969486254957196 ,  1044566447979161765 ,  213954888079465057 ,  238819163719579063 ,  2081089541532121057 ,  1619073129996382218 ,  47600955501043012 ,  1400471419368810322 ,  745272247003318501 ,  1587054727623727561 ,  336832912971105380 ,  893757642670731215 ,  358078321112119244 ,  213329707514961970 ,  431734207264273050 ,  747152012296730859 ,  456637024893689843 ,  1038114808683350026 ,  549081810588005540 ,  282974424068539998 ,  2096855663068218313 ,  865253274022685393 ,  506574554147460345 ,  565344532431316708 ,  1282261165009413308 ,  631175122668621044 ,  1181602878730266802 ,  510402094457222815 ,  1421612537145452701 ,  747823857571461012 ,  355375794204576699 ,  1666041545033592666 ,  897991769642941241 ,  450548546737842990 ,  603908699954943962 ,  1665073733255418745 ,  681403085921555152 ,  2295099694471851797 ,  451106399428187051 ,  1348592604397773890 ,  517252636603680953 ,  1358426179096989586 ,  185140938916067192 ,  1033104568928965446 ,  584916295442358547 ,  1780878812615855195 ,  3997315768931842 ,  1411962161902830787 ,  815061595851779985 ,  185860540067907170 ,  2008533490517851343 ,  1564054569610890448 ,  1131312486868433432 ,  2154658710805184386 ,  2050493203475271333 ,  645612222810865889 ,  238884667546501847 ,  296251655836875036 ,  1585318085444408392 ,  1520986864634793533 ,  629929991215471985 ,  1286915220202244569 ,  1011456820635570647 ,  1439070916664316322 ,  1766197056417469231 ,  977884157592746388 ,  42651029786366296 ,  882386407632911839 ,  1437187855378321600 ,  1970519141292405271 ,  1336752797687788617 ,  100484396303504809 ,  446448625105639715 ,  695777571977562365 ,  370430156910220436 ,  277264171893929246 ,  1586729417737494503 ,  1090764854190220591 ,  1655760852044359373 ,  1314776621814445942 ,  1722041541403097696 ,  1117392407416437303 ,  1674162509792601541 ,  2046672333210303574 ,  1108995036590642636 ,  100012979307479536 ,  676317333040531670 ,  1246088547123568639 ,  1713712559428304895 ,  749316320951980168 ,  1572145832954848524 ,  1155384657367892980 ,  1257469612557134068 ,  1306227224741433439 ,  384731361744297364 ,  2038485669271452967 ,  152628028872366413 ,  1918587694527043922 ,  234559936357747904 ,  1366239451287688344 ,  2139610448499037871 ,  1353069916574052045 ,  1479305944191817838 ,  1765058075348045379 ,  502171956249925216 ,  342583502568952350 ,  2201000604428927729 ,  431350746429637793 ,  2284806603922433780 ,  1228652568452145985 ,  904758087418656589 ,  1694049244019339039 ,  1849194865017838726 ,  1295715958835177531 ,  1575505352353311370 ,  1051699681116144794 ,  1256471321231097831 ,  373713838676229578 ,  352382725607360911 ,  1139288848065549320 ,  2207301491699313455 ,  113772207075480538 ,  384715038983787618 ,  341605556139111903 ,  1726786471499692572 ,  1117659670363004749 ,  301999179711136433 ,  1145696056612000104 ,  138968876883656517 ,  42005412669334770 ,  2127917937062498002 ,  2206726240081310716 ,  59607568832251964 ,  565571937829143605 ,  1322946169358053898 ,  2150556488564852805 ,  1200535340029098525 ,  1586018362806942940 ,  858995196777876020 ,  1714513028468659794 ,  2027093913773581016 ,  88343228811646112 ,  919797695208255744 ,  1935837152342823790 ,  740745822080222905 ,  167654965710764393 ,  745964848157455790 ,  803415551717912921 ,  38915146155470017 ,  840301130513932251 ,  887302053548570271 ,  2241741928156865277 }, // x^2^535

{ 13040998553971885 ,  303140849424464143 ,  120771220507980518 ,  1944833050072512883 ,  327082491505929723 ,  490171493136151875 ,  1121769828356724194 ,  1634807470774597064 ,  418844177677259740 ,  903919253984597035 ,  1859927900037065779 ,  147371115875355525 ,  525809051174994621 ,  938927538222248976 ,  257705958505693838 ,  1977699166916362074 ,  830928790777991638 ,  1510207527185726842 ,  1872594113777076931 ,  1834959461213252581 ,  774723962492704470 ,  1922813413967610829 ,  17046616556618588 ,  1693613091319170373 ,  1138719059806064969 ,  1666233596589152814 ,  2281815743579513709 ,  1572029777564052101 ,  327707111157552417 ,  1996308217891571260 ,  2151181629210974947 ,  500347470216777656 ,  1671100433725842620 ,  352991729617717813 ,  2170553447206768585 ,  843706514748322532 ,  255321199766974210 ,  810115296181393704 ,  1692144797786351055 ,  1504214591956367755 ,  428502918038995001 ,  1056013430493146554 ,  1852672482912150927 ,  1333440455952851665 ,  156551640511584448 ,  2075182635598600414 ,  914129483570085604 ,  1554064483308315949 ,  2123421136412606229 ,  743862518538096110 ,  505308061964904346 ,  1618910078850399919 ,  803151927466267408 ,  452194230378513098 ,  1584237276331579577 ,  1015304220120195713 ,  2256533387427442535 ,  943516339452273630 ,  925495422875570073 ,  88064721795334641 ,  901266661907689948 ,  828694717961703009 ,  456525556122237118 ,  101265622391464889 ,  1409588523188312334 ,  1107220794720346825 ,  517492380489583391 ,  619072970114012569 ,  163662054360978172 ,  30366686540698113 ,  2301964884041198913 ,  1629221680320070369 ,  603558750989047943 ,  1291559782566884238 ,  1385284123057726876 ,  786787899866915139 ,  956123003072430106 ,  1373461466206135082 ,  731462505483780580 ,  2126574337959286575 ,  1916485851464065336 ,  1553776445464882512 ,  1263723763328600170 ,  1991037123346700528 ,  2290487633153772137 ,  1318514656963481700 ,  826982883162187202 ,  415745552492416607 ,  2081069399963111361 ,  188670219299768140 ,  2152816510204499792 ,  556449966746625664 ,  1395878055509794658 ,  119648771706757477 ,  702836823527046208 ,  1756278750534372991 ,  184769203511459312 ,  1399817994441105151 ,  1499752339962060602 ,  1805922532083117068 ,  1784350452854380156 ,  2222827195551721856 ,  2174421093855808069 ,  183472196513064178 ,  998179060953277842 ,  1447767823830257607 ,  2005415907617981371 ,  2296545469721281500 ,  204684013836624009 ,  589016931954419248 ,  145861672922626398 ,  1188645284012790253 ,  991744192253484479 ,  2275788637336642167 ,  1702107931567027578 ,  1787624533511652723 ,  1381144934246172045 ,  109656377769215643 ,  1607030259439041410 ,  506554892224725822 ,  1495898516881966607 ,  1099396378927477256 ,  888931142469639400 ,  801225952618677952 ,  692849548406327067 ,  525511733480674145 ,  1169835681959274762 ,  1735409423937281671 ,  1294516749461651184 ,  113000162105405141 ,  518066664556103005 ,  1255934937047945071 ,  1330190450773975666 ,  1547836227711124167 ,  1532255043152075924 ,  1169041475937529936 ,  1139344001072617551 ,  615840402227960660 ,  1453994602609630557 ,  349609434527177456 ,  2250563788310246702 ,  282316028602433172 ,  268260545933854048 ,  906436627701620103 ,  1949539643431777873 ,  1606980433310837356 ,  2242925860751829039 ,  1867843019792542780 ,  303635681134559585 ,  257744365282068105 ,  2220562330411412085 ,  2186770723585178199 ,  742842888209709325 ,  1912931808945368251 ,  876365904153243743 ,  2010941787962538466 ,  2174875442641780390 ,  1769887309791442494 ,  2039893295694565559 ,  1431394886319674400 ,  1584955946869824547 ,  2033221876662242233 ,  1213931266947022447 ,  503689009478733506 ,  885594099533211063 ,  1357829528806346621 ,  2207691633968394456 ,  1539168024052157842 ,  496657440734520722 ,  183462415809462697 ,  2030941503364791183 ,  1109793236692774146 ,  855167005417733885 ,  658174488804380365 ,  1289256027784341574 ,  1380085434102858544 ,  2116843257629146657 ,  1283330970578021321 ,  348259724788335159 ,  1970574551063933797 ,  1143958075307668391 ,  128190944197843548 ,  1720346779518438896 ,  1847691289654468475 ,  2237157947927616531 ,  492258231098713857 ,  942889775924330388 ,  1590833010789039890 ,  37955671721016267 ,  1500208626004869128 ,  1272099133019075401 ,  2159660140005039682 ,  1090132377019811538 ,  1066564256364313074 ,  1794461363846814527 ,  2154380886802355746 ,  2133140827047792143 ,  2165930259235996105 ,  1839274029188116470 ,  1501820330494437606 ,  1920202391317011140 ,  1014360760640219014 ,  790395718183999897 ,  1524189164779637628 ,  1316085981865218559 ,  650560520928663033 ,  1429105125039509174 ,  2168377478941572943 ,  925218355464046302 ,  2069384988010238126 ,  697657982207400123 ,  601505625290366658 ,  463759812300040907 ,  1982178567604849931 ,  1254540311393961750 ,  1745239940428451420 ,  298664297951316200 ,  888976845574825099 ,  281167597988965492 ,  1917682957522932550 ,  258015062613864021 ,  2082303691463802527 ,  1773921158588160648 ,  662164613227023180 ,  1236005563377840929 ,  71577037906489458 ,  808553502604868365 ,  1408123119101493563 ,  798102685933052192 ,  921118863874840207 ,  706517623813917616 ,  811006922217558124 ,  1938658978540846838 ,  1740867707908539563 ,  1006916843221167977 ,  1109682135539478474 ,  779397563269641789 ,  183589701355457194 ,  812757277552983522 ,  856784464207634609 }, // x^2^536

{ 1250652536253946207 ,  798838956785072226 ,  2214506858234559591 ,  1561450091589317314 ,  1053300375975256064 ,  1794563514337522832 ,  1973422639054610578 ,  101679291951926304 ,  1722087270042213381 ,  416027910484016780 ,  2088441610934195297 ,  466316722076371695 ,  150284833204104356 ,  1394188593191911880 ,  2206495374789304216 ,  877481998476468706 ,  1128848313087952535 ,  247813398903569818 ,  2235389545881690832 ,  1061664246025765233 ,  2201208969825614977 ,  1400864405299500798 ,  226631900703605115 ,  2039478654551080869 ,  674424785320804850 ,  807514796604209236 ,  395295392105776998 ,  444504575592546489 ,  560165330126221584 ,  28761152341103666 ,  339860819600005377 ,  2009509838658763288 ,  847960691207645386 ,  1157582225810496656 ,  401775081407955586 ,  1193449747483245420 ,  1666250488495996163 ,  5225961777209255 ,  227074825510387928 ,  1861621809152120744 ,  309948304106606338 ,  275673572670096615 ,  1954039192678840064 ,  881552473815499877 ,  464176329248772554 ,  1499613830212792312 ,  627399196374708289 ,  1134756340504112241 ,  1161483390253828098 ,  459367980644818891 ,  235377552607921088 ,  2024240145609100479 ,  722244383602381998 ,  887533110324861105 ,  343985124962971179 ,  346144218757991884 ,  983181369139129372 ,  1131943474310464929 ,  747022899595895973 ,  1675352660853326485 ,  94779448388465894 ,  2099086175371802525 ,  413586700712767259 ,  256206763214049994 ,  1262787569038735004 ,  614462649016627724 ,  254730517099546648 ,  876358198078728582 ,  1614381026924453259 ,  760354709158855102 ,  1592879012970557528 ,  249053191907126651 ,  1139992081093244809 ,  892948665933458530 ,  630315816954830754 ,  1911835758074313580 ,  180758776122867942 ,  543281377969689482 ,  1429659287054492609 ,  316977368447509586 ,  291444716493365792 ,  1967878351838223250 ,  653298067089611351 ,  1332553443247369936 ,  1834746494856187945 ,  1974214586624545601 ,  2246039507206601063 ,  730264186010890707 ,  2171515596441936143 ,  2253307365127263227 ,  732098682858502570 ,  1675385949436076747 ,  1325001630802146462 ,  2170042544157870473 ,  82633806606691622 ,  1230989088977896086 ,  563025845427792083 ,  1735266938809740244 ,  1465368358253895134 ,  1782658548157895606 ,  1781434877899803938 ,  66267795544236088 ,  1638634519118542414 ,  1421650751721343439 ,  1700263282975095705 ,  781498737356533647 ,  1887713001890175565 ,  1611384770453022021 ,  1458389263840190298 ,  1503127258248191274 ,  871105274949429730 ,  449385927055483334 ,  1021698153031329878 ,  834938040142550526 ,  1316228643105149773 ,  16321929044437396 ,  938683133392387858 ,  545132881431704110 ,  1535587337576791879 ,  2167867591861185463 ,  1143290371000898833 ,  231171157227041870 ,  1370880427109498421 ,  783718232097492811 ,  1971341244549807163 ,  2118686445170033502 ,  492662951862823685 ,  2270084297279302645 ,  1916834606766377398 ,  2134452484131102439 ,  1234239735318005603 ,  375355439879086081 ,  1182727727517772983 ,  2214982231354517352 ,  801473061197725603 ,  1995339757551769983 ,  1366329205616254247 ,  655981593026239475 ,  1267350759796932460 ,  1316936135948206027 ,  1993946969748937240 ,  27570431613356636 ,  108542649772483600 ,  1436934960193007871 ,  1112430192196005872 ,  479350356125620785 ,  309925626853294017 ,  1862428322690234563 ,  664677211794136451 ,  1002684623302881737 ,  1287350368221374778 ,  1626205022812231748 ,  1917832786803477958 ,  1469548272237331565 ,  915457673388458582 ,  1178244231264786152 ,  1956627799066063662 ,  1970386445365831648 ,  1932499600168706494 ,  1679054219767428102 ,  123762920133641129 ,  2061194764124534415 ,  2110164320039832801 ,  1915411462768272865 ,  2078081849144894086 ,  2016878287031614549 ,  492458576624491261 ,  1609624057771468253 ,  1584056327025705413 ,  1825989708001279453 ,  93130782107876768 ,  577319449830527211 ,  180117595729511155 ,  295990277738117430 ,  616503774593981760 ,  152264453654096149 ,  1986587116154710633 ,  1675307028590326508 ,  1666481568574748271 ,  1586129353003187010 ,  1024220717197316256 ,  235669786679913604 ,  851198065202671991 ,  1067157321081594925 ,  2228687991737565650 ,  1821954277179951261 ,  361146652621744630 ,  1421799488102807256 ,  1782073897422781840 ,  1673362585128887435 ,  1758225557377290009 ,  2163722781291599422 ,  1073099068786375309 ,  342865136346322336 ,  365401777894639151 ,  914902604102522349 ,  202396864082473582 ,  754849635100107252 ,  1057393640367875385 ,  399805596023922299 ,  1665136982784937497 ,  1767765126609995414 ,  1359338420264014315 ,  1484416974431342229 ,  230469063834861241 ,  220383500712047184 ,  1667667336543831916 ,  1944385621550112791 ,  724771003591740428 ,  1077169214865487659 ,  412797573938302343 ,  1123988884727536980 ,  741046885553555776 ,  1854790691393709466 ,  1541469280055196773 ,  750418608190173024 ,  102319321855059621 ,  1245747365489005486 ,  1269476791277371944 ,  811644221868025176 ,  735782903951753325 ,  1723717826103049176 ,  2158860956393759662 ,  759644115476900689 ,  322303603203395918 ,  328754839245256331 ,  2077990605508222752 ,  125460590227787547 ,  2045741912628416326 ,  1047934331772201623 ,  2048735475506253320 ,  1611700212719155310 ,  1284795827370535200 ,  125434170866798586 ,  683294879313211695 ,  2280743470070673146 ,  630248273230035960 ,  1533795087295063476 ,  1401110744999792890 ,  415304535884136260 }, // x^2^537

{ 1490032927629695155 ,  1006433879476805785 ,  1634116595306289124 ,  77285088405540670 ,  439902906928445966 ,  54223369633241812 ,  1105557732132497639 ,  366562279172176285 ,  1468395864422438759 ,  430085189034399073 ,  494064836866185461 ,  541479487993045395 ,  1142819761101884849 ,  918556165186521875 ,  760255051953968193 ,  594654418127697819 ,  2295232883647098242 ,  431043690070908742 ,  700678069094245579 ,  412213909844035096 ,  1444484294686387558 ,  2047064780976718560 ,  1405628951645259710 ,  1564091631066284690 ,  392431499513105855 ,  320770218797442452 ,  1119139480488397708 ,  146444029677937884 ,  850057628658200017 ,  694020986238406556 ,  2064446355908638036 ,  806014752435202467 ,  1837617557008306154 ,  63717168476827840 ,  461136923995743850 ,  135798148226978039 ,  2284547888325974645 ,  1863570675634112406 ,  2073387249071550561 ,  1662553497828605351 ,  403918798290308129 ,  1227578964255753152 ,  1978077623290378077 ,  290892621401067953 ,  209852961458186775 ,  99649234029676962 ,  684616140736328077 ,  279678310338275035 ,  1876819186464873370 ,  395280744513033122 ,  525431218508535497 ,  1644580143560570356 ,  822845085730544137 ,  713807196589766678 ,  1059777652004704323 ,  90799647202151929 ,  1230258767270246755 ,  1703996882261781046 ,  2203315006746533765 ,  223086048009748827 ,  357651647342169410 ,  2038327686261900392 ,  1388833084469630754 ,  100932426216272261 ,  269242224381457371 ,  816028243587384616 ,  1545153174866567377 ,  44820527173811435 ,  1097875546901205406 ,  873889244831820133 ,  1081999716996731859 ,  258590834373504366 ,  931886962003838071 ,  1063388966691876931 ,  444870314859377802 ,  1188192899444827595 ,  2106861712617375582 ,  882805422132374766 ,  1944087437866962108 ,  655404518647301696 ,  999946016517693765 ,  2036683103902856486 ,  1436362275431402202 ,  256501165542535359 ,  2064843150967556840 ,  995850790364825843 ,  424505419867263602 ,  2125853760678120668 ,  1037452103199685309 ,  1256257273110672775 ,  2087551110589984941 ,  1294177232771661387 ,  140455525790887204 ,  1327507188684283536 ,  315026085764194012 ,  1741645677872308800 ,  2159956846024145392 ,  1614680579510189874 ,  1257056787437019905 ,  644793495257167965 ,  1956903956056849931 ,  1890502782743176221 ,  1301857294240384914 ,  1000490591331101584 ,  564206571749879176 ,  182218865740518875 ,  90968732601997468 ,  1577598669078348437 ,  1085339970511199244 ,  2288741339702366981 ,  2016800199468570091 ,  1468556082863500285 ,  1954725102236942295 ,  626086972320202293 ,  1464600832733670372 ,  1165266877128066206 ,  2132487096424394523 ,  2260220090268686908 ,  2100567027267308572 ,  381997709059126017 ,  1180201363571340003 ,  279547221731001645 ,  1959656398932678187 ,  1715438190412923917 ,  1886771507640335086 ,  2201618767344928052 ,  1534246943401534420 ,  1221891250862798836 ,  1644992284688671876 ,  1386948218493874835 ,  347438664697937939 ,  1043014057545831171 ,  2018052959196570417 ,  1418205286273055556 ,  1937607327926871888 ,  957915244291491472 ,  395559990180769192 ,  1252494536643693282 ,  1976729703387245965 ,  730715904798555961 ,  2022889404492977590 ,  1521630752921769092 ,  1347654644511504111 ,  917508331152882611 ,  1733460443120550229 ,  1540993107991884501 ,  1573388630854445012 ,  17451009618430286 ,  1787158997603660544 ,  1888361606720997465 ,  1896315977179397361 ,  1759350304962774662 ,  2050072277089800742 ,  1830570738245271535 ,  1252404085357568797 ,  427506257888031183 ,  1666924759052985848 ,  611670483387244378 ,  1964794279427433255 ,  1615682127940938173 ,  127015755634564218 ,  455873758482751985 ,  1264375844655371232 ,  2100534133094396579 ,  2045187329976050438 ,  857292388017104729 ,  600340829275068755 ,  2064280186762320906 ,  413938499148054908 ,  827971611013112261 ,  328462490253112711 ,  1715810885958115181 ,  2242480115077712914 ,  144982803123435445 ,  218478650615905414 ,  1906143696787082424 ,  992091041744444326 ,  804836467907266988 ,  149852314197452311 ,  1553302854667713893 ,  2242568635960990204 ,  254899979703411900 ,  1465932593104614216 ,  2022672841918995255 ,  1138468346886206508 ,  1497941194818738662 ,  1888252133034449571 ,  1835398653325324302 ,  694174957639262430 ,  1527223826206668393 ,  1850709945432868586 ,  407953059504890619 ,  541431940403407179 ,  669125289312492175 ,  252283493421735301 ,  374159960288761164 ,  774037296728372102 ,  1618449947152460239 ,  596097782700030451 ,  48237773266540601 ,  468371530442739454 ,  270666788458984371 ,  2011827641863299620 ,  1625056947747065969 ,  486341972203628073 ,  2196063532196632899 ,  1132247016063551336 ,  1329932366861629899 ,  2209112813208496797 ,  1083063706160830547 ,  1190665703629402707 ,  1971084440027970182 ,  1590703740578719530 ,  2017808561237603378 ,  589933362016035483 ,  1582508246790547580 ,  1781994822970892716 ,  60343942095744376 ,  1813075477745238075 ,  738285815487376108 ,  2112409727868001668 ,  1502687644645318688 ,  1692653290794272037 ,  1063054802277065275 ,  1510531485336664511 ,  2261706970703863058 ,  84469372003666436 ,  444468925992189738 ,  1701317513239459783 ,  2122596744703694800 ,  602626680730784084 ,  1130472641976665257 ,  499818176090617411 ,  1845543814334519977 ,  622463528454191513 ,  2051279066677712034 ,  2033163301423470653 ,  576968615884898585 ,  1825575381964707132 ,  1886619905828139603 }, // x^2^538

{ 2034108142529386090 ,  562026819650765486 ,  1049238946452053109 ,  1527661394255641437 ,  1650694063161229344 ,  2151018951100713848 ,  1128826608064633901 ,  2195435818737330633 ,  346184643228454399 ,  1916652311746492386 ,  107923843112736073 ,  1155998049624142777 ,  892671468237848448 ,  1883933592739525847 ,  1517373263891036681 ,  1651739673699365148 ,  846871689478532860 ,  2251203498595925550 ,  818017457665673634 ,  971615725125351953 ,  746936751509379652 ,  1729645343768078647 ,  1280375081732357305 ,  2040822983461491124 ,  1496717449162312569 ,  1198282152508507729 ,  174986282583063725 ,  1743433185275098713 ,  568860270656024523 ,  159567170732645558 ,  1451531372317191777 ,  1591253478588939364 ,  1641144116132956879 ,  276996764010919325 ,  2053254627300718190 ,  2037754221530894717 ,  1447188093546371476 ,  804834475337601221 ,  1361641821579964197 ,  1331808639228832204 ,  1137550973429852133 ,  1816881013886927299 ,  526455985396427881 ,  1445325061797848823 ,  487670271017609555 ,  812062017513632273 ,  2010722577229099801 ,  680687032194524503 ,  1977143802506374577 ,  980709742714407440 ,  479714306742808894 ,  418293839645608141 ,  1936673761099551033 ,  317636867096076512 ,  2177030112968470675 ,  642141473526747866 ,  1753908057820406892 ,  331446437041131088 ,  1025066502507712277 ,  130727376163421375 ,  615878199245626641 ,  2052863095343520043 ,  1292250826578238606 ,  453498527993014158 ,  539232457584626631 ,  723768215437901080 ,  49195405960110979 ,  1224592560413672843 ,  1846751697481548841 ,  382562283510789685 ,  2148518473213200237 ,  1633229169081192939 ,  1511205330821600769 ,  2196012768455245257 ,  1941349565003958236 ,  1042039505672769416 ,  1165769321578558553 ,  1228180098849207724 ,  503478102461336069 ,  768271893900910327 ,  50002478373118778 ,  847500577516693510 ,  103360376556209554 ,  2144267940716228995 ,  1599902110227411221 ,  798328333642811290 ,  212493369217671072 ,  646816855209976034 ,  825296885516628009 ,  457230780082180674 ,  1827835473615169935 ,  1134308368845608972 ,  554647739132084339 ,  601351992744876986 ,  468889029741875853 ,  166958126354659199 ,  2248924366497403035 ,  110250901298868041 ,  1359230467266065569 ,  794042936624763099 ,  2086172641691455582 ,  1347677402007725873 ,  444406738192403732 ,  1451261452202356425 ,  2247810752847830816 ,  28273793733546812 ,  1486621837711121610 ,  823103918006857869 ,  1817442711096098881 ,  1413967076186898678 ,  318993867530666123 ,  1009858133277056440 ,  1988153244584061287 ,  55279596879348833 ,  1980615485824335161 ,  262802553079260706 ,  1045518500261338742 ,  723944743778176354 ,  1955727009406931210 ,  367595405261075368 ,  979940679706862142 ,  238114134841719892 ,  729010959446745070 ,  2009653319134897736 ,  53856947807743699 ,  1358781353304694889 ,  693617487405151346 ,  405361224831909843 ,  1853233250690275937 ,  2183662526593285245 ,  2280980834328701695 ,  1509053194275559898 ,  1011584003450021514 ,  405014078199992608 ,  335483375760672062 ,  1872799671072936922 ,  414726228735224593 ,  2139150482397859085 ,  2021420631913327757 ,  1275069184823577945 ,  493795960798625208 ,  2062927088667858052 ,  633820431767143241 ,  1124589723980412099 ,  1650384379005863472 ,  546911238390755796 ,  884019944933044997 ,  632083323144771531 ,  1314364107474169154 ,  349774785288037889 ,  580612687445341542 ,  447969177042472903 ,  1135372251716760327 ,  1080682935355445354 ,  2022322630269532429 ,  2204411965257338354 ,  446316283778660569 ,  1431439912179758071 ,  2018557625566376901 ,  1813019721694365941 ,  259098472445394377 ,  2102129040894604584 ,  595907497477053718 ,  121256224070376885 ,  1948133147130223147 ,  617176915515797270 ,  719204670550859993 ,  1167949843572276272 ,  858395591595759124 ,  1116524742460511727 ,  632364504495345590 ,  1333099963187732713 ,  629599985001856863 ,  1027179866935702654 ,  1809316307410299248 ,  205926274210999103 ,  261011570084324804 ,  2024676963714992969 ,  1502353835778526824 ,  1522867624365857388 ,  1540321598793199844 ,  1325139302775020141 ,  2223731146168200 ,  470756791766948816 ,  1308557415739261862 ,  67324319675396764 ,  605072233109850858 ,  526989466496685121 ,  1031915332610844049 ,  297544524701755325 ,  1216089653088013500 ,  451815632915988972 ,  1887544732891464908 ,  1183188085390866926 ,  315837148396060611 ,  706842976764036420 ,  849444894514833607 ,  639374639789744333 ,  80129451183312673 ,  1784267603653328152 ,  71243984711361770 ,  2191646534977365182 ,  1404604625055400736 ,  645084527239547214 ,  350996586960810297 ,  295115595342059228 ,  218571760157078359 ,  887431070607573424 ,  1528411117477653354 ,  1666182476771143687 ,  561672642378351392 ,  1573091910520953863 ,  1181904125058456651 ,  716151743337713584 ,  952466992017933092 ,  1562439649953755112 ,  1457360692363568426 ,  15670501561901735 ,  1221778160773855118 ,  123775950883209011 ,  1512206385010700179 ,  226830408803895711 ,  928862921153359651 ,  1637688129025250127 ,  758658404820878804 ,  301172000452156176 ,  2073611838292345172 ,  1017784259488398927 ,  510248646948480754 ,  1554932475142631555 ,  1119509160010003553 ,  37085718341975087 ,  1533712224630644410 ,  351493890018919605 ,  2184428260766085850 ,  254222205270125808 ,  674181364156906933 ,  1863870348149773997 ,  1157613166553737586 ,  2279111220870916537 }, // x^2^539

{ 987255044233295323 ,  898000591529875685 ,  874704116644721077 ,  2286829832041656442 ,  706756609390496896 ,  433446435589238249 ,  835421973500651924 ,  1620143279132920900 ,  469948467004645608 ,  1092870119380365189 ,  984619333168106646 ,  592551896263548549 ,  1465950875712101351 ,  1882086943717647407 ,  991181442643942825 ,  1320991327308369591 ,  2187894814949012356 ,  862428896441603334 ,  618431323561939412 ,  1991935743398864159 ,  157800207631083910 ,  1577822501077010634 ,  1314535356106863669 ,  39664028523774668 ,  589996738456882863 ,  1197972704596742333 ,  1275454271310993773 ,  1747209596458441699 ,  1551029179961974253 ,  149151223845978184 ,  988041617850465425 ,  1350230338482428363 ,  1231354448446401561 ,  2193565958813915659 ,  1564062395919088636 ,  1778628374899044466 ,  1782076046449971475 ,  2039853717770171939 ,  2007456428313442877 ,  51171718966596933 ,  69361391013290857 ,  1012801003198028230 ,  578348354416381980 ,  1972927637196302778 ,  1517662209745742849 ,  2209975582278240711 ,  944286265349217126 ,  1378227653786945132 ,  1355363967503863184 ,  1767103544373891192 ,  2084918029808836690 ,  1840575984483765407 ,  1550225060664684486 ,  1182292626727922313 ,  1901797068533338628 ,  1473237819711707253 ,  1118684997875423863 ,  1203942403140439233 ,  275099668895069562 ,  34741811473678569 ,  1537938165263706447 ,  608161553019751969 ,  2245046934499972547 ,  1655236990671999318 ,  1274442611268325289 ,  926385470607398999 ,  2282660234512490921 ,  520930854577623614 ,  1366467072766852360 ,  1977228703064522963 ,  1632881693971186304 ,  1196322803129428609 ,  1818485932429166511 ,  1755855145197143580 ,  352225881837854468 ,  1925491498151601407 ,  1803469023134180741 ,  1287783521871619801 ,  504016084060183696 ,  10907497255208626 ,  2030896926940665153 ,  2007559547897905688 ,  903975825321298562 ,  437525528458749620 ,  395885985213013664 ,  687557344432984802 ,  1773524541697370042 ,  444589375734698838 ,  623633556325125773 ,  137391495673241566 ,  1517444332359406556 ,  1447237246320280438 ,  1181248311876474134 ,  2280641634415291069 ,  1706573334381101837 ,  281289774568230564 ,  894252654905502261 ,  172119707197865022 ,  906849411632701705 ,  1023631200745428804 ,  1487184402606236658 ,  961677713478327406 ,  1442506321125450108 ,  1458415192331280467 ,  2242467263845510498 ,  691474531494192712 ,  1366453296579528981 ,  1660201392918888575 ,  2196950712970572643 ,  1134306391240704121 ,  500808390283277607 ,  742483327645952236 ,  381985410617599745 ,  1098610480322699426 ,  102181972366818866 ,  586340450796242342 ,  2153521602066415492 ,  2170486696259961491 ,  991869168804391999 ,  2177429743793311710 ,  2273935185297587768 ,  298349742490539363 ,  143117892652906739 ,  173569924513340335 ,  1737651849634958719 ,  367287624044657274 ,  851686831706589911 ,  946168256613264425 ,  874265893631211010 ,  1650903563906396759 ,  1104870313447937991 ,  1228666817706816761 ,  1759390685889493356 ,  537723198626007596 ,  510153418425013218 ,  1212519452215165766 ,  1314023111412493859 ,  1235142860761166355 ,  767121436252806370 ,  2272415023268337282 ,  1261580895119650017 ,  103323981258026735 ,  727610164136629479 ,  467186834093853852 ,  1597606223123972699 ,  2260643869480180109 ,  1479854427857206649 ,  656378665205078388 ,  2212162912054785446 ,  1715577524299035864 ,  1320749171962530126 ,  1410805819417888344 ,  950038324715316909 ,  183549214659778986 ,  859810649134746064 ,  791679566838160176 ,  1373939411906716248 ,  1871724140976904082 ,  1664271707299281718 ,  660223227282251039 ,  1502626130519874769 ,  939415424219011026 ,  1851831026088198412 ,  412197228657989218 ,  910194511279993590 ,  1866528100463622181 ,  569808130337196371 ,  1120126978669059910 ,  1859546751132540173 ,  1397271720730248154 ,  1658569312304800452 ,  1641192262402422339 ,  1151809266542568976 ,  6570246200023714 ,  216492786901804052 ,  1861014566747097341 ,  901984614331097240 ,  1537104367831273982 ,  1427076123117574644 ,  339777108575652307 ,  1208124461474129398 ,  1501649994331361485 ,  772843697801383685 ,  1318586622554989492 ,  187976443894799039 ,  2173489789672325300 ,  646037141298978933 ,  380147032948390619 ,  1877172385919765815 ,  1985456121750239104 ,  1360920281928226808 ,  2258504114681220729 ,  597894049513765243 ,  233494584907892129 ,  2076334871124878303 ,  509198881329960925 ,  1759372711641249072 ,  2024657520919773469 ,  2060659242097525528 ,  63587270468193043 ,  1691383158436897894 ,  649387355599135147 ,  987507773007510854 ,  1010168447400164002 ,  1715898872505061261 ,  582000787592134950 ,  51158088283674826 ,  819920936343117800 ,  701684965502701591 ,  1172993940260041854 ,  1856001383689260888 ,  7244968734342980 ,  1401682899888414262 ,  127339929173202809 ,  297109059116085239 ,  822408324155584359 ,  1541366879129549187 ,  2111464500231073294 ,  1648722306916493616 ,  1610979031324764780 ,  1873774884358078893 ,  1044032685768662684 ,  1635233685980912459 ,  138543347962164484 ,  1363283574620506857 ,  579648920937029624 ,  2186019175076475031 ,  2123832773409937470 ,  328468669742929752 ,  998384863424968672 ,  1740682816350252355 ,  1439811572073536631 ,  1260703092620173685 ,  1414216370357459135 ,  1322216871821351466 ,  1329942751165720286 ,  570725735376086544 ,  1395010479054812265 ,  1265642993189451620 ,  1998766488705994044 }, // x^2^540

{ 1393668419517161745 ,  2211102709976339010 ,  1203017039902096306 ,  1652867592302308212 ,  248344621633186448 ,  1549302239659131892 ,  165576212179569156 ,  1637286421598880212 ,  1001761978031586786 ,  1767758479395720565 ,  670873391170714614 ,  879260502431763186 ,  387694598265383870 ,  2216063472002274230 ,  1558397567476945685 ,  800352399405725334 ,  1877778543942373237 ,  1225958866164811612 ,  964620763896993984 ,  2151502276096500928 ,  713032175730487135 ,  321290299505517071 ,  2059826203174705497 ,  725785850101625192 ,  1792570604626705405 ,  976188241851491027 ,  354819737248520337 ,  123370547678509543 ,  655044777712960401 ,  2261581772394499273 ,  1648438664939006856 ,  2030324554649171658 ,  1358369996993798913 ,  1947539731102759584 ,  2116978812619279465 ,  1562656466982485534 ,  185195805784477175 ,  390079122392220087 ,  1790824964897438043 ,  1312839512363695377 ,  2252624495702669823 ,  1663391768919956255 ,  1226459609617089898 ,  924988274868488579 ,  193995930662675327 ,  2056951448724066619 ,  632935561009194283 ,  243747153141104849 ,  830799207131371119 ,  340446212829673541 ,  905048464646366652 ,  60753404713872325 ,  1786285434598932618 ,  2067297442482897730 ,  1643449054779587943 ,  1396768872343240263 ,  2293886965871987043 ,  1302814788304371993 ,  197847807406601968 ,  424068840572470369 ,  1884853064014939706 ,  1915102133683326548 ,  538786246362005609 ,  763852424138459995 ,  1426099705012980336 ,  1112473960326262089 ,  2071447173042357028 ,  120392636958619081 ,  902501303553436382 ,  1356920723029819181 ,  1953783073361936710 ,  680399044339457680 ,  1445927228623074653 ,  1069926893777439444 ,  1340754412874633970 ,  1282714732835641500 ,  272836555217240650 ,  1403950588479962647 ,  38351631917565364 ,  2301957069180617846 ,  1956812663157984566 ,  2225227412740234815 ,  1765998984299909801 ,  1005455705707370840 ,  1207612835529243445 ,  343459231229781800 ,  1097849282742610762 ,  1761155437504525084 ,  679656188430520479 ,  836237393527996505 ,  1254889921643518235 ,  307331856277649606 ,  16298744737293822 ,  1030107733779011563 ,  1506424400906446874 ,  54887810099517909 ,  2305034149388474467 ,  259332774699210946 ,  1529876371765486800 ,  2248127450323734763 ,  366778925450612591 ,  2045596867831963173 ,  627766991097984230 ,  1675589863481796136 ,  957623827270142344 ,  1491686631330657726 ,  1412453407325614018 ,  699992184724844102 ,  969792176814418911 ,  2187615011390957809 ,  1536170359435839973 ,  870264652255319248 ,  2205249205743777787 ,  2119416327498273809 ,  96812553567027290 ,  2248236735721325399 ,  809965451223538871 ,  1885615377610084507 ,  985674186111945741 ,  2044442686528459493 ,  683270450212289391 ,  1234565528685351304 ,  856106750540698596 ,  2032232495743443729 ,  1455542025662928647 ,  81057326379148346 ,  1242454492370043645 ,  1621611313274725162 ,  603790158844331637 ,  170629407226722450 ,  1444157643343717174 ,  1284776407114065655 ,  2257213374438309843 ,  1376486161890701640 ,  636453558858374339 ,  263340997538052456 ,  1098868745842950261 ,  2090694154844005528 ,  161499373804225427 ,  518715908130453042 ,  562382554890018838 ,  1711634120298959571 ,  1082818794853499376 ,  1354224919181044698 ,  204962659984415394 ,  2097948143531008876 ,  937885996381939179 ,  48699042478207941 ,  323885514211563781 ,  219024593746774661 ,  1669102050866055343 ,  1888001285257300529 ,  323555305647521424 ,  2152216182602772577 ,  1738331982476969902 ,  89988238863820518 ,  426037109084771744 ,  2068704725950318104 ,  131221588635737069 ,  121347220995975969 ,  546949329268830497 ,  1027368677454457792 ,  110018935654452588 ,  245218975027716445 ,  1700106368725337207 ,  1918775305460137062 ,  2129491610970130827 ,  956898648588742077 ,  1160268909571357360 ,  1513899661284166492 ,  677845799183090298 ,  1962488760287667695 ,  1453085276723062844 ,  1142365127899123503 ,  313270275919058066 ,  1627714767751726224 ,  1218967858660164217 ,  1644579706890182674 ,  689859499160559676 ,  1853296489660952624 ,  2280941130821213967 ,  1553613315986962052 ,  327270269736547078 ,  629703773424373212 ,  75087388579819669 ,  1629699056811162623 ,  2091942151766414173 ,  1988364759424506788 ,  2140341513731544984 ,  1663246056924927652 ,  748571122275243951 ,  18856609528303674 ,  1081816314030611713 ,  2026069096578327723 ,  1226514640644265390 ,  1474221011565110853 ,  1320622775172339483 ,  693998373656470022 ,  2078374982348767677 ,  706480480635027870 ,  1209513947701202688 ,  526108692260758404 ,  515544797901147877 ,  965061948331020035 ,  2097772907696945544 ,  1391022262880713129 ,  141485393919149798 ,  2014148817177728544 ,  135146452928901054 ,  2160444246508758558 ,  1050208681436062121 ,  1823232405285193976 ,  700204800292810191 ,  1482985783062871412 ,  623435979103791997 ,  1098624184368298367 ,  1252824932809095868 ,  2233572196775758262 ,  480719982898417721 ,  36395801837854779 ,  1601126025453359272 ,  316166601504561059 ,  2064910634336603354 ,  622579664611033583 ,  2285620799340138404 ,  1090949410966763068 ,  1745997607212466645 ,  1836752114212495398 ,  1339887113305592765 ,  670434428884203358 ,  2294856828797413859 ,  1148452500267165720 ,  279843476837155495 ,  2292691668047663641 ,  2100234247534721089 ,  2229254187721942275 ,  759491380917804379 ,  1930952246878266384 ,  1820186310777535732 ,  620095503123587871 }, // x^2^541

{ 1712396517495442193 ,  2228585469283271690 ,  412182614139509306 ,  1933966901221562970 ,  1602922270209909026 ,  1096801257128929463 ,  971592978905834569 ,  1727197405278570635 ,  405064797665489808 ,  53141968323665635 ,  1673022850347380302 ,  1773762497715988786 ,  964799146500255516 ,  963582312490428693 ,  544970111287685032 ,  2060884959444591553 ,  1816467696449187624 ,  1487851544229152906 ,  1169787974509858003 ,  1363734114202153115 ,  1449958308790504952 ,  2277787519973906744 ,  1207929374693798466 ,  1927148228563908155 ,  894016835225228054 ,  789502073479208723 ,  1412827759064653386 ,  1488756424096015022 ,  1935500643472658929 ,  911460409104845103 ,  1444244503539672274 ,  1026375151762510736 ,  1150429537049044974 ,  1501424350613219529 ,  318635600396836297 ,  599621904654664867 ,  1300808174443988168 ,  1943828806286025056 ,  2170208847938764217 ,  2047447102468714237 ,  2179648836320587977 ,  522709413402083281 ,  1951156372695006363 ,  980298130443446188 ,  1902419945993540458 ,  167928678011191048 ,  1631170783208810439 ,  1933126301188437282 ,  1930143141012454015 ,  2242733274347276709 ,  1568589188210233755 ,  1955289471265277980 ,  1767395441673946864 ,  1289290823683082450 ,  964351216157335228 ,  2105400816020605659 ,  1206019244744221688 ,  2290835858819205554 ,  680085867511899626 ,  1454536799477794053 ,  389524716143590393 ,  1910826437381693631 ,  1219328334112968649 ,  1951603402574013551 ,  1947969445571068193 ,  596838138026189536 ,  841586097927841193 ,  71121389647452400 ,  1480160431943246271 ,  238055169368912984 ,  2181699855824445451 ,  747497065301541670 ,  757143775384862826 ,  1368918772221926275 ,  1652291694876932826 ,  2292717802083688323 ,  2045134721091874273 ,  2193437835442063582 ,  1342202517190991622 ,  827586846531839864 ,  1739847601622571732 ,  275376940107967557 ,  704597854056405230 ,  72088090206797919 ,  1648139093469324227 ,  515137532879633652 ,  1824066820317565718 ,  559059543532268559 ,  719592772507506170 ,  322467327070556023 ,  140121300877771462 ,  2144282642904317886 ,  66456032806357657 ,  1751519924899501016 ,  2111230451781789875 ,  1173218046757588561 ,  104560488234563213 ,  1083803382956366595 ,  1017191356333212195 ,  1333860213357941787 ,  1370660827675046783 ,  56136659058759694 ,  286021622720981244 ,  1766498204186835758 ,  1807462141287730790 ,  169008331980246044 ,  591809240554303446 ,  735475261406009461 ,  593707312284455161 ,  207945186922591627 ,  932481736399446117 ,  2145471109449179860 ,  2022343948329973800 ,  151144551925295375 ,  667950977076276899 ,  745798976880855946 ,  49950278094894252 ,  129802817731541624 ,  1011107689598471985 ,  1970271856319778095 ,  1676385526668142154 ,  2270639375863463587 ,  129297951355172026 ,  5248414176806423 ,  346635843024188893 ,  541486044734577971 ,  1598030037644221500 ,  1750886878140400476 ,  746044708255029372 ,  957698302899596324 ,  590550949165440030 ,  2287925225439808466 ,  273486301162795246 ,  596495230541803165 ,  496165342417461370 ,  341493898276568584 ,  585711089980289961 ,  2027982497493870488 ,  1331891086900575784 ,  257307714646817425 ,  1473322295291481561 ,  116283917363127762 ,  1544108319464928476 ,  688852375431406271 ,  1434185120765536348 ,  377802374709059577 ,  1922134175977998625 ,  296984352111063747 ,  1904931547267627394 ,  624247734693957939 ,  688889082965188551 ,  963425902524415612 ,  1584405550710625647 ,  1274385563200553335 ,  366336935666899719 ,  763088022388452938 ,  2114903434021753672 ,  1925418644798066017 ,  140377964653594108 ,  456548167059048975 ,  373560773705137290 ,  1009084952346156812 ,  2067450271809003750 ,  135912011556275207 ,  1906700524173155551 ,  2029318890239031810 ,  659028262355789320 ,  833066639196725593 ,  174873100120708886 ,  996363731107532915 ,  718271499599371948 ,  1390007789574791443 ,  1372695125049877861 ,  2057902382673287602 ,  1720663362517744245 ,  1238858192705319068 ,  17499142646745857 ,  1714728980905140618 ,  1567910679844465787 ,  1451939699942100339 ,  2186375080052134983 ,  108665953194187743 ,  38434588339513561 ,  1320760517595787715 ,  1975409219621187128 ,  1320272380617507222 ,  496972673867528234 ,  776705899578995437 ,  349414364346576012 ,  1851951858824198751 ,  95289252922654243 ,  823641887944629600 ,  1323859859109736514 ,  1408162678205829709 ,  1769737592259342912 ,  2016422349995389255 ,  121007277064507543 ,  600892511690051631 ,  1718915389447530482 ,  213360374774979384 ,  2284554924380659881 ,  742218199880398494 ,  1445844150555863842 ,  361995609831946166 ,  1323722485785307627 ,  1260284140600408733 ,  1401732909894714598 ,  761545452511118622 ,  1014336618378394543 ,  287216809600202335 ,  2117385269153457344 ,  607856019771738418 ,  1950480118662654351 ,  1885128756141560923 ,  2240874642733121979 ,  2136983008338496920 ,  1292099701022857989 ,  728745293708519291 ,  1833044556992287734 ,  1857044391043673295 ,  321143560357799341 ,  2016069538023776153 ,  296438394964259715 ,  967462033565629887 ,  1934007778524304089 ,  825170413474843788 ,  2241398657966695305 ,  1043164162782144809 ,  1159936526827181740 ,  1316981332576635182 ,  415606871198481236 ,  1961687439568125258 ,  2221890650935089785 ,  1260015036957368849 ,  1843270918625129242 ,  569091656994875816 ,  455778546022551039 ,  2175485544225109602 ,  799995683913056063 ,  328068157787731169 }, // x^2^542

{ 966306292573051755 ,  1154659621003316548 ,  317302110120887680 ,  1998213210208133273 ,  686583795449005150 ,  2085763248576628504 ,  147311811642576736 ,  881961014134769479 ,  48470416791311108 ,  2294679525647229935 ,  1919458605870971071 ,  1207053297135259610 ,  337781306255508830 ,  2150497340395628978 ,  2116896158630273064 ,  1169507969082008362 ,  1023221574659011100 ,  1175191727957049504 ,  1086283170120961395 ,  386933822096916177 ,  46794235681584303 ,  2100897994060633219 ,  2012657855597196499 ,  589874900201742392 ,  2024961218593388150 ,  1783245192554937419 ,  791342196515610123 ,  579259405954514851 ,  2171156728338756844 ,  1000386999627686670 ,  240695497800402255 ,  2183895248007202354 ,  64468547547451189 ,  1980092642965430222 ,  1925710566566059386 ,  285607844536950492 ,  2148962552566389573 ,  901588510559523836 ,  1966017093933913519 ,  745438869476080314 ,  1159799943658559403 ,  679629745512256786 ,  1553210604743414123 ,  1258072726010467615 ,  1600265575704385526 ,  1305268034572229886 ,  648436534419866593 ,  165947909885656640 ,  542531059379727660 ,  1026745106443988073 ,  2224840635972305951 ,  1618477496582402636 ,  1344766962100709318 ,  199333357753453962 ,  249397264661058672 ,  809534569898688855 ,  247647563233304937 ,  1870999690343765854 ,  1497879563407685386 ,  1034570384484899211 ,  545735377415162657 ,  1452832266573320388 ,  650973519263331949 ,  1452315665308681312 ,  1557776676889172311 ,  1625627926749110679 ,  1311333853640865098 ,  91346217289923694 ,  865643822726031365 ,  1323043290996450901 ,  322727419534458107 ,  966150455756737111 ,  1014373586724496304 ,  542652759023209470 ,  409730172266873801 ,  258045928163573080 ,  1600952023762567147 ,  1634082223075227373 ,  2147637521494823135 ,  2169268652862148169 ,  46884653981545277 ,  1361835309027287315 ,  1841754842592034596 ,  25142969279039686 ,  1420564743565634862 ,  366301483796930549 ,  916464256794384648 ,  840333667255435761 ,  267102267913980204 ,  1202601263931520212 ,  1345395380744758144 ,  813297412841825913 ,  579632861795042388 ,  1604315109502854249 ,  1483511688103331251 ,  1753391545247147365 ,  378361061641635021 ,  652559102533156136 ,  1627435072093412826 ,  775857851335294811 ,  1671859119142540936 ,  959544822367377710 ,  2117961665123732780 ,  545737447948089634 ,  1427666132950681529 ,  1083300887656365353 ,  739239606575056551 ,  1556642474340561280 ,  511334188783188008 ,  1299312182085824851 ,  1287386547435983926 ,  921945644614110610 ,  185182162345637580 ,  289337591212318850 ,  1745855286837821539 ,  2206472123030325508 ,  1476911610329747296 ,  1614073606925394563 ,  140084952007482036 ,  924310229302678893 ,  878820570507064948 ,  1621993440999191634 ,  1662182511171305591 ,  1597208242075340297 ,  926549170980521695 ,  1152819721178858823 ,  1372043220652379821 ,  1386992479502891199 ,  1765717963063658353 ,  897928015102806220 ,  358443824480937252 ,  1285195525900622532 ,  829750880094911907 ,  1101395732208211604 ,  415045449296963182 ,  1448686062597149512 ,  163176441360906838 ,  395291109590956275 ,  1727020493328123198 ,  1416124995736613035 ,  1746625352448760069 ,  75617127323709120 ,  506402612394982949 ,  1351052478080993941 ,  649593727321752729 ,  2287449628157947466 ,  627778260258967556 ,  1001579456935131729 ,  1348131378389784509 ,  1094269961144909820 ,  2110944528842509417 ,  30281785152732674 ,  1628189919069122583 ,  844697358272510341 ,  8104304756536171 ,  1152558388781686521 ,  1640343234819836011 ,  1691801556242589150 ,  1653836997298772615 ,  1076631518130023699 ,  1448541052520984662 ,  584417717653344861 ,  1323430592618582570 ,  105902079799984096 ,  1575752668706383736 ,  2119726074223308614 ,  1200435724471948932 ,  1936184632662869246 ,  892673498722292637 ,  1126119063343231502 ,  1075759788383993727 ,  98868218571005090 ,  1938007775756105167 ,  567666470303142399 ,  441930197670620839 ,  883799035407481283 ,  1865947854912605797 ,  93438961248944017 ,  1693917284253770945 ,  2023338719789515404 ,  999313367966267139 ,  241544352446988271 ,  389967484319738047 ,  1299432369276854271 ,  1669388559786897979 ,  482128577414507490 ,  1436468722679523058 ,  416384843409408992 ,  603212447596975593 ,  515232945709348795 ,  675102423725340620 ,  1459723578000386325 ,  1026655083694313247 ,  2187619693006590475 ,  2168780033829845567 ,  683806554462408464 ,  1747365344450362389 ,  1150096635693217072 ,  2154623769360749671 ,  887026423603689236 ,  1666184321986349367 ,  1405492048574668353 ,  249218408736048054 ,  1464577370192789974 ,  303410242623287391 ,  1196631900019801886 ,  1989314670069361545 ,  81341813181347587 ,  971957548653057151 ,  1391913555872958595 ,  889628174552305416 ,  1047196321863164905 ,  1178237352113934336 ,  237362275068919647 ,  1669115191461357528 ,  1990980818101187578 ,  1082640990171642799 ,  933837414717393703 ,  357301043758423944 ,  1133338949521586554 ,  460851789195542242 ,  1852397358522055704 ,  409193785451683400 ,  1306660358966831275 ,  109689260667912283 ,  1963981078998000518 ,  809874383172403080 ,  1653312087113687875 ,  1811548800003081115 ,  971910457467086422 ,  1741915306655892611 ,  565269548489820661 ,  2256821047860609448 ,  1831517698410855155 ,  1490352520819978265 ,  1321815077380061474 ,  2099228335677036723 ,  1045058323526155611 ,  2080562310809933701 ,  2201370279533562725 }, // x^2^543

{ 1148585206835093140 ,  11477107932782206 ,  2243331576942483461 ,  877703661651732439 ,  477566437796343125 ,  1452735527089325697 ,  877874066468274356 ,  185090186143249098 ,  1505593608948754268 ,  300555195357184971 ,  1304751265131020233 ,  939833694320300853 ,  878322642686777305 ,  1470471697785276971 ,  1184134959496421635 ,  167998073904559852 ,  1530624207860193540 ,  884097594496790126 ,  2110344037896627383 ,  1417683937091870194 ,  2245311011207690199 ,  1019271120593912819 ,  1599405621513830911 ,  459783641507949032 ,  695497362628263662 ,  1259230751461406171 ,  1086729499654945990 ,  1285001101185320686 ,  1971876197733584447 ,  388870677005732212 ,  1734955664748870413 ,  1956473796683144067 ,  1284123306678336225 ,  2221191320605860760 ,  260394586467384125 ,  259975996432475757 ,  1508261614570524870 ,  609793135315819228 ,  1435264381142845930 ,  1496697313458887091 ,  1894921837134434073 ,  971730383402475259 ,  2217153145779532963 ,  1401406340283371346 ,  1214371860028073547 ,  2081087540367595510 ,  1058223715714681528 ,  901375783281324124 ,  1526458821148201190 ,  54648766664525802 ,  662199179585118776 ,  2147344650917805812 ,  2201243969044088342 ,  2124822802865715126 ,  2242119877417340548 ,  238037967726537279 ,  1834094341388699741 ,  790700522781588483 ,  372338971622925787 ,  1543004684923338273 ,  943561640815813867 ,  362023642138734060 ,  330637625960799665 ,  2034940000742836573 ,  1528579575274176501 ,  837615082629931311 ,  1994251231831295446 ,  1746780536697819146 ,  499549472182225294 ,  1080633979695846639 ,  1984088651644714289 ,  1514695188332530131 ,  1898245892024757305 ,  430833576288569831 ,  375252951259043671 ,  1023294318038512035 ,  1492460264145603042 ,  1263378212562650994 ,  827306691479651858 ,  199611334111533035 ,  1447091732787831199 ,  1538303143186877722 ,  696006934595767799 ,  848952793391973430 ,  202947214428879426 ,  1716816654699479946 ,  1326797398063152068 ,  1382826684870391209 ,  1937080160586446198 ,  770015179940743039 ,  1339329445898371181 ,  1854167703939032968 ,  1958567929289092700 ,  2006473051893647695 ,  320885154597253589 ,  1249128425911110882 ,  16778276673725295 ,  1952274567050521040 ,  472695178682954836 ,  174972769567370114 ,  1625149428731553554 ,  426448306578334029 ,  2264700079796049637 ,  772173021610599224 ,  1719364082108419195 ,  1487670955881890980 ,  288535610781390689 ,  233043940813218584 ,  1886927254225987091 ,  599552296994757765 ,  181631473950887489 ,  1931064155927773849 ,  1243373643328871499 ,  1421590176439589554 ,  2251393465604609315 ,  1196801866294415860 ,  1962031362246994196 ,  1338251201915561750 ,  1203244243043420040 ,  1606333383190353872 ,  2158231961319668302 ,  1640007188613571578 ,  772055149376829273 ,  229669074988084496 ,  412926643670682218 ,  2101141199642699729 ,  1444454700002806699 ,  256166674138116708 ,  288747922376256084 ,  1303862353005268912 ,  1320834309627679297 ,  957955839996897048 ,  666530042438881345 ,  562161838276050546 ,  936640925116400794 ,  1947704469778086794 ,  121692478125798161 ,  283412818843107468 ,  1818869205892095885 ,  553271638791741916 ,  733776579065947391 ,  525582665901420905 ,  1525122101379172542 ,  719199912128721611 ,  947375348606819255 ,  416872256825054679 ,  1628885503357568775 ,  2238822813785925886 ,  1466896821601654761 ,  1114766999871783583 ,  141877165129516389 ,  1935963618979349321 ,  318663202179131523 ,  72518037703925930 ,  1171364329961521471 ,  79495931598240091 ,  2146672723874652924 ,  2091508290055697675 ,  573480483110466176 ,  1052454360610162519 ,  1873975835567872645 ,  1857353024341089342 ,  1580715759391219172 ,  2192471734244589955 ,  1270048920353357845 ,  1845018277164646250 ,  2026631842230448139 ,  53244934347573707 ,  2017790830689030446 ,  2206319283773826913 ,  523318134704452355 ,  1429503980303402720 ,  388283768098586774 ,  2151306010189217925 ,  1953051611232585240 ,  1921750783543563557 ,  1531425413827345801 ,  2123839827461092057 ,  1334609735686624905 ,  1993561831862099212 ,  1265306141247117893 ,  1586116967765560109 ,  586779132656192068 ,  932634564172004222 ,  1928239715282331963 ,  2295143469264410354 ,  164883381091374209 ,  1933007904522680387 ,  1576482917184723872 ,  2303172168266651435 ,  1629506606116727754 ,  1241036877945850055 ,  1841268669730095255 ,  1853113577881429166 ,  838875661747118665 ,  319317840709124362 ,  434482695344355826 ,  2114806960158871271 ,  1705528350471587303 ,  979813359044000847 ,  483970179765692234 ,  1137215517224569689 ,  215681203211210632 ,  377606009896782591 ,  1893488588647429299 ,  1578653735178905618 ,  1536912123865802205 ,  1707575267791568562 ,  854836911114869742 ,  1427938514867878514 ,  1793029003789353053 ,  1750308830938665901 ,  1050512926321458216 ,  654014661466161525 ,  848232843502641035 ,  539875742463553589 ,  870835379132606494 ,  873820080117553914 ,  1317152178089523980 ,  1783754541068471052 ,  2141350633602714646 ,  795036374855563751 ,  26199335323298264 ,  1646956913977482772 ,  1973032908604708697 ,  2058881416826405660 ,  2000009028920682891 ,  468617956508690904 ,  79208233862488794 ,  24146697610030905 ,  1891189939788941031 ,  616570794107970900 ,  1512996730013821465 ,  1188248410075876895 ,  2006318831775365619 ,  1662968298565379266 ,  322640530197210965 ,  1348175030296189392 ,  739579689033067338 ,  1912136531255484663 }, // x^2^544

{ 1842228269421644122 ,  1857385874302541512 ,  17359686366853950 ,  1801763904620934750 ,  72238465598741027 ,  1575785228834927111 ,  429986141909994643 ,  2222026503352432675 ,  142689891094857369 ,  1109005891976244143 ,  393907153461093438 ,  73361330731582494 ,  990869027803962163 ,  1544438206279500694 ,  1013855455793081833 ,  417372464874381920 ,  744280490917675970 ,  2074583779265611744 ,  312112144913092098 ,  1664023502220952457 ,  2140856294733785524 ,  833742362711796160 ,  1815681487724365030 ,  823921781221836195 ,  1875376410556972900 ,  1922013314267864769 ,  589118555494769910 ,  978318872759392057 ,  2194055079066619559 ,  1289081708250198457 ,  1142933828951727899 ,  2208044175953298546 ,  1764612878196167045 ,  1858788144514669921 ,  1919607355364126671 ,  1003958098203005617 ,  728076061961928212 ,  508206474959280938 ,  1278045558226860166 ,  1393723706495729423 ,  2009074334757821367 ,  1514468616781629145 ,  423365349228520763 ,  356785606076572625 ,  1569718123486191686 ,  475341287216612709 ,  890869293742108121 ,  2106227982088348175 ,  1663015722905904653 ,  490856504304002441 ,  181343082568631707 ,  1492366560498954117 ,  1798707123959911940 ,  587772244947936042 ,  1921835029816023763 ,  764201149228383320 ,  1757101151979225223 ,  194441309153520054 ,  1243823253400684827 ,  2027458925533545082 ,  906563990196081918 ,  1516190187663057550 ,  351989084570722631 ,  1642290462866781169 ,  2030093461603681816 ,  366618682588072089 ,  2088680867592429453 ,  1707414502727039963 ,  1126371875959958717 ,  451276991875102897 ,  1170229922276212634 ,  623783017152910223 ,  553386352611061445 ,  1583174818877520349 ,  314339985945371810 ,  66790426364386665 ,  1023320643779804828 ,  859761341810661097 ,  291339432199914524 ,  1079605167779386078 ,  1501645673348545724 ,  1663427097159808745 ,  1206952927916542373 ,  347143268943985730 ,  1519100524746429662 ,  53135831913838678 ,  327289587428152933 ,  1065290411391120734 ,  587935108950459097 ,  811634320179489255 ,  1677572437525669393 ,  197355587968904824 ,  72977867148593284 ,  1649796182648995904 ,  2030473773621931544 ,  62066614029951455 ,  249785984268105552 ,  3927451751482280 ,  1676778275077930644 ,  1800416835339777563 ,  1329752110211322337 ,  1577525911703414536 ,  2087192656897621052 ,  1700442040604977477 ,  346416151743219940 ,  162036205659412446 ,  204257874386277715 ,  726341463560662411 ,  1334974930558151945 ,  1411381454648203719 ,  2218651536801601884 ,  705428317070995348 ,  1825500738142225118 ,  2160797161268260645 ,  2055815779468612035 ,  1811775357690006467 ,  933548975401099474 ,  1029148087448230032 ,  304983119732828392 ,  1781346382226412164 ,  416460516392056784 ,  1574943271073252892 ,  1463368831025209181 ,  2067677182579032142 ,  576028755079820939 ,  1437624104691592912 ,  2060112723326881246 ,  1368837570004339844 ,  1867486920675185029 ,  1633430904283570874 ,  494959551145445138 ,  1219172531350721045 ,  665979878231006619 ,  1798665588802655145 ,  2154486629024128969 ,  1851172287645796646 ,  591157671768232447 ,  717826590504024694 ,  914425197324043142 ,  2018862107513749405 ,  617349599195738857 ,  643217211924508083 ,  1547669941128921084 ,  113350300983019588 ,  1214206322754406803 ,  227579404067527381 ,  2265842172100688616 ,  228309568809313214 ,  1764671411619585268 ,  1494906481546643634 ,  1343485664652122044 ,  1609593089530539916 ,  2117066564145521160 ,  772607385155267697 ,  71877459913055315 ,  856314282726523380 ,  1797892730210623932 ,  1931357976819443474 ,  1808459479280330048 ,  487118184252338264 ,  687078262748090278 ,  484159081955392992 ,  2252732706370230047 ,  797752370925783421 ,  1188554048363997098 ,  1613383946807805982 ,  1962504901071553561 ,  1701704686069482645 ,  1861377134827817124 ,  1550511825719834956 ,  1476403344154928687 ,  1673070578897185510 ,  156167955317471556 ,  1105546526759219686 ,  546298865019992495 ,  895832898588394048 ,  822523261456033930 ,  588648319382316794 ,  2209896061258525220 ,  834464995002115059 ,  1647012140660924962 ,  1521563528703826537 ,  1085414208232985922 ,  1763630215165785261 ,  1219947149977903451 ,  2066140165646307459 ,  46286451515856800 ,  1971325119722925739 ,  2092971409417641545 ,  2251654692478340894 ,  1228042096339721057 ,  862390815359249738 ,  716791706210077503 ,  140828465105881152 ,  2053684497171519971 ,  1489199089483877967 ,  1197070651202499377 ,  228711277054187988 ,  1210427861152466831 ,  2005796212467382760 ,  1410465366140614526 ,  1535113725778484138 ,  527076646851685858 ,  2025419945756532944 ,  1467033491270085621 ,  1754424727990475729 ,  165424677320718702 ,  38842163309009332 ,  280870474007189126 ,  1062097227235527998 ,  17951633287639222 ,  2227997053455009580 ,  2299410591329709114 ,  2289104431427355297 ,  666001753911311889 ,  107492449297079176 ,  881247217504714126 ,  1843976615273226060 ,  169956278573505515 ,  1637462521140218856 ,  1849086470862837267 ,  1195069166643301337 ,  826683355427597514 ,  813387585216105900 ,  435930068001711172 ,  248820192771629224 ,  803893713301823451 ,  1214411226299878863 ,  1630470254313539777 ,  957723274984519524 ,  1330767532890869820 ,  1972181203973581170 ,  372745020916249571 ,  2215348964831794693 ,  1493789530257046343 ,  1328034818360845860 ,  1571229633695139914 ,  1458385315339004132 ,  1038542141841450957 ,  1818532228446777021 }, // x^2^545

{ 270777136833744725 ,  2141925960827270267 ,  1728624896946962862 ,  350050548951777031 ,  940600186114245803 ,  2252939747378141631 ,  1472498135589482949 ,  1016379294701019348 ,  1338771057312956616 ,  580590628474499279 ,  428461605098050582 ,  1530735358221538162 ,  1060516419525570357 ,  1972680155855352893 ,  2280973644911695722 ,  237179347237842597 ,  1761945774167800976 ,  332485489332283347 ,  2225494989112969835 ,  1940742347965197925 ,  918011466993786441 ,  893685124334660077 ,  244853102829826878 ,  2095429793890253120 ,  975732792485781677 ,  773008544170558447 ,  158443839583357018 ,  1879984136309098277 ,  298765650323595505 ,  385042354221228016 ,  617173953817727254 ,  579002966001710612 ,  527074696321816831 ,  1376860026062220104 ,  1277521571935039366 ,  640494792468723236 ,  973710440418039518 ,  1182500950482092685 ,  1922526167362467429 ,  382088883627717524 ,  1959358449800549993 ,  91563242872941694 ,  1660986609495973572 ,  110466849233706993 ,  390068317935727832 ,  1642116090733250765 ,  801654680727881911 ,  2039743912247745502 ,  2280343385496506593 ,  3693522888104929 ,  1027614353088916906 ,  1224949842540672255 ,  2156472000209856649 ,  959020869847505239 ,  80122956253128626 ,  1942211174799879234 ,  1762372379765633203 ,  1959692275533908489 ,  346855096887973641 ,  1297448918885704324 ,  2237893884502329119 ,  1879024896009538424 ,  1831123704916225814 ,  894505475045343868 ,  506455533320893403 ,  2294588074663841833 ,  2215589060625281812 ,  2086226876893210407 ,  1953348005154949003 ,  770531203057133551 ,  1669614305064356784 ,  1056157529129701595 ,  520049509172234342 ,  1961243294015860002 ,  1655243019371358770 ,  728429834642913693 ,  688830294749963937 ,  204676527455453339 ,  1796765484435148 ,  83626696484617794 ,  762868341113291023 ,  892583380950197402 ,  673953969989064736 ,  2140882817245147788 ,  1333248819582051138 ,  2216348412215555636 ,  894721851304850098 ,  724870667813468018 ,  42299257370736368 ,  1457213044865723218 ,  2069901989502303317 ,  166620757926434564 ,  528005792240867895 ,  1998371147288709337 ,  2016758791723055075 ,  2040640494464950463 ,  2209066549191185534 ,  674580082145214939 ,  57676993362873472 ,  631507183754189246 ,  1293609867953892950 ,  2281140382438927951 ,  1571472992241456009 ,  1903541902138232611 ,  1012607117945313589 ,  1035019200747250949 ,  459177206416578536 ,  1277871381074445746 ,  1939459615215938014 ,  643062625554315253 ,  1766346320313997933 ,  2201819470592216731 ,  1190971747064878115 ,  1736145906528760409 ,  1555425207465513024 ,  745589324512245153 ,  114885881355847252 ,  2198350161537999349 ,  438444210748635939 ,  87825172116379463 ,  958347165225176837 ,  2146326175049749805 ,  374597219169580819 ,  1128982625404644234 ,  1531093096215166374 ,  814647620045196390 ,  341812114196124668 ,  414475022097717827 ,  1145905471676852406 ,  657310034461897299 ,  1092948518998810272 ,  977874274470099879 ,  1535478034244532985 ,  2278580852923753981 ,  1129581304942690487 ,  690260667588042674 ,  547996125261151085 ,  1444241385255474020 ,  35580143960530315 ,  384699004087599803 ,  2254075460282599056 ,  1557865954915815603 ,  1145489894025685317 ,  404775742812299425 ,  2273871293251701793 ,  810748743649097025 ,  1633128295098888959 ,  2225769455825805957 ,  17156690226285738 ,  26857217982803547 ,  2111089192577737026 ,  716053355517355497 ,  149863933632050919 ,  1116102888289618075 ,  1939015961667801091 ,  1714557279847448942 ,  425105593869079565 ,  820882597133677888 ,  2160689521285565357 ,  731509885474478166 ,  1474236262025632718 ,  770218526851269716 ,  2169953887571820741 ,  622890386860448734 ,  1874137381722494655 ,  985281440497894583 ,  1700600055347397144 ,  955072214067620437 ,  1272195992189509950 ,  998700408114582547 ,  2099333356619556034 ,  1810339060214518215 ,  295996064118194376 ,  1528306588458629019 ,  2058657416213404500 ,  1831763397755855646 ,  917438455478093139 ,  2084796813032177982 ,  814230668979942054 ,  1663977330278520533 ,  610801515483349396 ,  642476429290656387 ,  861982630361239221 ,  1835360864577598812 ,  1177631158099536413 ,  2103212462022787230 ,  1465422560506264240 ,  1380518120285121735 ,  1038904727087980611 ,  645233110592182934 ,  1604397601837727135 ,  2227776089881612556 ,  229004798764644373 ,  293416853894897761 ,  182652659342831984 ,  75829655517865545 ,  1679238607855842474 ,  110643412569426429 ,  1594369881003033310 ,  612865623548524667 ,  350657408804777538 ,  1574707753600525330 ,  1635454944789936081 ,  1775773813591012870 ,  581214913781454028 ,  311670833601603824 ,  1567278762902104639 ,  1730515855928893989 ,  401682849425720473 ,  567938597534575982 ,  1395891237847346700 ,  1310739631835831974 ,  428507896823683635 ,  1614590287317650099 ,  1279700489124516658 ,  367133090003768644 ,  930608307836680716 ,  1040380288943409968 ,  813718599016998481 ,  106442195684390430 ,  1731190415381461204 ,  150126863674970241 ,  745186783076522712 ,  359598881745530748 ,  917344060958162508 ,  2230493130254895149 ,  1493369407641462056 ,  1741850820646604856 ,  1249273133524004942 ,  664190331771971546 ,  1962710848252951120 ,  304717349995362956 ,  1549029988941032906 ,  203759640180486119 ,  207965982549286236 ,  1869929239668120254 ,  2246763150742727772 ,  44806574224906112 ,  432654781781740956 ,  2283916646912772113 }, // x^2^546

{ 1335970261513074711 ,  490253827670180746 ,  216143513921924338 ,  1263651486040989462 ,  637437498104902960 ,  989333539635423165 ,  1013603916120605007 ,  134625718233275594 ,  1827668592725413273 ,  2001638953804691613 ,  705392221548673063 ,  853301855849437986 ,  1641544315743409037 ,  1667585061139227722 ,  1766707860835164947 ,  592184933828781669 ,  313192869476172418 ,  2278411498846335601 ,  24647747279598613 ,  2281659080443480688 ,  468170527824964925 ,  2082674270050626318 ,  1991068310626927180 ,  1369177864596844335 ,  687382039117263029 ,  1498922632818680448 ,  1161364179346474561 ,  1928219869500751632 ,  1256826175377824520 ,  933998746207497445 ,  98427163353149912 ,  1108948948219467428 ,  389708868081345847 ,  291515066497339225 ,  265808098541397354 ,  1475732711907052576 ,  1487672087476372258 ,  798231329701171371 ,  19295227939945459 ,  510436069097208484 ,  672465625559082539 ,  584135702237373211 ,  816692879847756171 ,  994224374445563870 ,  1617201948009509329 ,  607174977862980889 ,  1129987284381344567 ,  2189542532874912148 ,  196597168296130691 ,  546859766189531902 ,  1174880426068032704 ,  1371417943420614674 ,  1477162630446453341 ,  2026668633377094724 ,  1284385674475921405 ,  1483414407105567751 ,  1460848549309892339 ,  2116586970060004629 ,  1295576857129413078 ,  611674143217855894 ,  1671602359647341664 ,  2065659427316270732 ,  128364033165662053 ,  464121273601114579 ,  1809831873435339844 ,  1108808246805392583 ,  801356939207363770 ,  2142296486059159564 ,  1676695038388292312 ,  1255669913660584800 ,  311952981675406416 ,  2200765191299636561 ,  1262031351545003756 ,  1256096430486671932 ,  1912364043741140243 ,  45419787959040737 ,  1025322733915980707 ,  1555507426518428886 ,  1779375926694785261 ,  1067384494373050316 ,  1182118094254911520 ,  1214380227379149094 ,  2108496633500082086 ,  793810761648335831 ,  2170915410771757843 ,  604490976705123622 ,  1966604525318678420 ,  668028020114790230 ,  1719929969030391591 ,  577730641385578144 ,  559895903348984422 ,  1485986905911122314 ,  1626804439792490893 ,  744031230554292679 ,  627955270237019665 ,  1014917366054086985 ,  433452650253425420 ,  515777747553211377 ,  2060380586460829914 ,  1589229529193304895 ,  747438398563450414 ,  1623902145552605578 ,  1483108845272979074 ,  1636439464839673660 ,  2286333023843037517 ,  1648171236379501258 ,  1522487368123844048 ,  476977545850202334 ,  989983810890442005 ,  1155266917385695118 ,  1460024512919774354 ,  1081766591685475835 ,  769646096993871376 ,  1924570042843685519 ,  99768846323150584 ,  1188213697610319158 ,  1175055412442625669 ,  521085069849201152 ,  494302906344002488 ,  1279639895900672827 ,  1598005674412949366 ,  257070237376090436 ,  962942490867172927 ,  986079336237604639 ,  333386750364775953 ,  1882082797846012623 ,  225109705242484897 ,  416415750860988906 ,  2129784421036680516 ,  201759437597656215 ,  1864645130397898996 ,  2220334101126158925 ,  582516157110889755 ,  1124000909316096246 ,  197272036624413765 ,  1379616382134644694 ,  1384537866181628030 ,  1433752200617805427 ,  1742844370405739052 ,  1955887413071822875 ,  698330166816261285 ,  1795694147297729170 ,  1371753482870656262 ,  2059843233890973568 ,  2070185782408789787 ,  1923984060925579589 ,  121779226392547527 ,  1736537893308096604 ,  2186067252606472903 ,  1343706266104822419 ,  1499517061035024184 ,  533197187047053123 ,  744841224140675936 ,  1516675261754316698 ,  774780911325840827 ,  1836886486183954020 ,  2297087317280672032 ,  354622571049931791 ,  839065057025177146 ,  233891264505806097 ,  1793701530434514320 ,  127828833815627375 ,  583503816381585717 ,  163319013428920585 ,  2175624001722276254 ,  2000390277583505619 ,  1100004962894919398 ,  989504875862831271 ,  1302198617490919035 ,  1783103344359714994 ,  1052107103453955335 ,  824704170596805392 ,  571557660722237267 ,  1524050152742660411 ,  815961856102460484 ,  708620851357832778 ,  1101257243655511153 ,  2194330217952816813 ,  1797957028837572905 ,  927477166723071754 ,  365696635879966177 ,  26297150726509411 ,  1408798139576174028 ,  2162258890042795929 ,  1621183537641506754 ,  1497182622158995267 ,  432135121504192471 ,  1123687894419345143 ,  627945171148429085 ,  1492250445767550803 ,  307786310672126535 ,  569042601150287999 ,  2125373583765257143 ,  953726371751031532 ,  1713674823712736631 ,  1471873267385930966 ,  800358356505993494 ,  577880807968307290 ,  980399590009604654 ,  76713017822539561 ,  591926702470207185 ,  179619258267746101 ,  1083478394828589822 ,  1629520573926911260 ,  1224573517499837903 ,  1309100235408650994 ,  1415659521273384084 ,  2075888698018996064 ,  1855896114777515300 ,  1821163434219812801 ,  493128444163906553 ,  1497206127489417765 ,  319850365283142943 ,  1124830934088332832 ,  2272799493466534958 ,  2264848385978183219 ,  1470492446358919730 ,  263052040827958131 ,  8557121962050686 ,  1645669318030667530 ,  2026822817095342911 ,  1973072071514618942 ,  738679756610800104 ,  1613801661012667355 ,  983740531435178254 ,  1889177419022708197 ,  1354955117604693242 ,  811402653257327905 ,  1466296652757238443 ,  2130494639674615590 ,  333119601807114780 ,  5519305590829111 ,  53637682645747280 ,  2087072247331863423 ,  1580606717984969978 ,  1737134482926640339 ,  895119003799551820 ,  2175282216107773432 ,  920187741229219388 ,  636582710555857167 }, // x^2^547

{ 1309061423545233348 ,  818594098551450568 ,  1353913810601274774 ,  1383283681694262425 ,  1363377849417635728 ,  216206989579697528 ,  378192286888911077 ,  190817864873085260 ,  688835917510699273 ,  507885855645981630 ,  1422404236660679090 ,  2285242129689638144 ,  1495469904014664506 ,  1046656376473270444 ,  1495642613941447730 ,  77919942912586620 ,  207297082946793373 ,  440100857113364709 ,  555879997622669268 ,  1600176522564880069 ,  1159979453068832498 ,  661495438256771741 ,  1067344037232161567 ,  1561101000350815392 ,  2254839494441799277 ,  958190723845593729 ,  1432632433299504330 ,  600286127391732583 ,  1555630883843379721 ,  1482886573520275258 ,  1125702595465325210 ,  155220582687869578 ,  99026510688541807 ,  1781549073520500751 ,  1067935564589350319 ,  326967625977880003 ,  1698485611607576419 ,  2115129259907672585 ,  882556727200774365 ,  981924323351261144 ,  1933698328609566340 ,  993855152006977275 ,  1169597297994424372 ,  335027639920132693 ,  508961011258636194 ,  1888960992416808950 ,  575436015279588776 ,  420924837968742377 ,  848773944269029338 ,  1233845571534827224 ,  1248733346317993113 ,  1495793665981397004 ,  1267180676227792182 ,  542894665141529345 ,  1811379181170744545 ,  562178270017611270 ,  1908782956544848466 ,  978322573136637516 ,  1039927490021170857 ,  1295157193608742006 ,  462579208691982677 ,  481329838368949021 ,  2116497916815087872 ,  700814161858852540 ,  305054255385534372 ,  817237611722206719 ,  641675888626454735 ,  1063653361858236455 ,  525771871201345951 ,  2095080947560876234 ,  1398620869138246770 ,  344844547335680317 ,  2095760823679064802 ,  699838249815008113 ,  2103017899717558551 ,  1539037010109658505 ,  1756547851437127933 ,  2248399380611711438 ,  1726631856590900673 ,  563573397991741955 ,  752907139947024238 ,  2258977137093168963 ,  1760560386038257658 ,  682040174849032300 ,  2140377822545160326 ,  766448525036610386 ,  2102661513704914190 ,  771658636147548999 ,  1317875042259112043 ,  1969553337965319359 ,  1316407997949861332 ,  930015836314147345 ,  191058086554782599 ,  1378950504211382623 ,  525082154861624082 ,  2062955183446280807 ,  2074603643309527421 ,  2219446916810010698 ,  2071601225589811919 ,  1830948618560393560 ,  1241878783498626937 ,  1243356407197049382 ,  160690113021552768 ,  198274010430208085 ,  2039045304684615146 ,  1060894587416377705 ,  1044272973150078663 ,  1001907104293455569 ,  182936764749801569 ,  846346408684746131 ,  1525268578219551441 ,  2168792642166681608 ,  13041017453981246 ,  1069804319653489206 ,  2273356003954751027 ,  587832800077603487 ,  1876123432699358340 ,  349957981786559988 ,  907683875673625535 ,  1055490100625882702 ,  1373393512287465557 ,  2225472862023851853 ,  603544719899400994 ,  664295699082256594 ,  459360373435854884 ,  1545977420655618619 ,  1441755933978691862 ,  374614399134417122 ,  994220747374315783 ,  719289112679386056 ,  1076797623584868511 ,  1971977108973648369 ,  1065665502230190520 ,  1777743132152233446 ,  1511277077045220451 ,  1777363457102555051 ,  644900385147844852 ,  1573633479401228545 ,  210917264264234726 ,  1253043707278046178 ,  1905529217999076255 ,  10584490870796611 ,  849978788113137212 ,  1025155243952984353 ,  1314773963726646345 ,  650914852151916385 ,  58659162410788112 ,  1289524549689978949 ,  2101933343990156168 ,  1678534435836136298 ,  118853691361324501 ,  218855348222633560 ,  1711718110667570777 ,  2060772716063806337 ,  1306057642082573123 ,  1162017686930465188 ,  320435251697943485 ,  242636552652184347 ,  1521825114262581498 ,  1556165296513179190 ,  1952021474174238272 ,  440651291894257541 ,  832034899217437089 ,  485166919199053531 ,  1476569270732773751 ,  321873449542555814 ,  1959680069213792484 ,  1707744010893876484 ,  1484555873241778276 ,  1439968645812778300 ,  2002357297172006863 ,  199144088639089974 ,  151787031482630434 ,  1978449861277321034 ,  1591480834507640418 ,  2071643605476310250 ,  1326520278402252203 ,  975476594510936475 ,  2024393416166176010 ,  968148675577466025 ,  1905157459692195595 ,  1532694525583610472 ,  2237458560937255759 ,  345758806171317005 ,  639334556896743921 ,  294620006751050007 ,  1509986957914098585 ,  1430596962192390537 ,  613693882113898432 ,  822893160494684448 ,  939549066268715503 ,  494054435488870502 ,  1152425399206029328 ,  1206491183458038046 ,  2263486058904790160 ,  753647953784659276 ,  885588782507664158 ,  266777162867668017 ,  1450120952711375952 ,  333225971942691223 ,  1945231363718163185 ,  1512867555638262646 ,  356846431085981266 ,  582636088768891830 ,  2167564245612383014 ,  1341358151071787331 ,  247845331465075330 ,  2149863047486901416 ,  431086438545825531 ,  1827373837954192898 ,  1619605756775528788 ,  2172085193329116969 ,  457016366573547352 ,  620288183835178503 ,  1842889942049897354 ,  93589111036397021 ,  563617900524527535 ,  1396195866989377346 ,  401356572766137382 ,  722580205902405926 ,  193077575049652149 ,  1661864887069573980 ,  396980530149598346 ,  1389169205622850005 ,  2052796600263707952 ,  1930231173384558396 ,  2247854897228275825 ,  2197278127030328651 ,  854055429774085560 ,  1622506440207945426 ,  1568958344225262776 ,  593400437126764846 ,  1009531645646961391 ,  1565889434095547661 ,  1762575755624998433 ,  577499412325856232 ,  1285924226587554787 ,  470107628581682936 ,  2132711275053138711 ,  950776008311028702 }, // x^2^548

{ 1601983802033680506 ,  2117262754861674065 ,  2018162739409361740 ,  1577674728356784463 ,  416240588731935907 ,  821367336806534300 ,  1331123751935545893 ,  2186087377595683447 ,  2012011148473068913 ,  1591159410702607292 ,  1930719935469253852 ,  710426075498426788 ,  2181293707563150111 ,  1126822053906056124 ,  1444204235274262015 ,  857832880325481394 ,  1366252837146233978 ,  286236240594230761 ,  1567545505890608741 ,  530164657628323911 ,  200568424738303698 ,  144548484884853739 ,  2260531028867315279 ,  150730955468437451 ,  2155437266560679364 ,  407484321639271527 ,  2093295590025019624 ,  1945112177845044241 ,  689906539440798578 ,  248156492632635300 ,  347679050426552596 ,  321606329280883337 ,  753034968472164749 ,  1146516768142490613 ,  1945329688430829779 ,  191289276779322302 ,  1460524677470004021 ,  638642270046874652 ,  551655770036159112 ,  1067131196199347952 ,  565644266224936120 ,  1276198658095667184 ,  161951582580470192 ,  490717301859001036 ,  624991550347710921 ,  366967641234441516 ,  858481029682893153 ,  427667198694625586 ,  1583086624726678633 ,  692564231294832111 ,  682057597579966281 ,  277094151426179873 ,  549332015775454556 ,  2037835764657283868 ,  767739392829670371 ,  2159640488184772957 ,  278394226459734550 ,  357150160392346299 ,  1216389009374477542 ,  574438577197167173 ,  906879838864322817 ,  50125922223372352 ,  1495272260982369594 ,  847565087484888007 ,  1684811444655052583 ,  199649099372888367 ,  2059133785987693141 ,  1876645351085899019 ,  1697291146198639899 ,  578038900820416747 ,  2110930405903916162 ,  1170201304974073217 ,  1197455317579094392 ,  890753840043625139 ,  119803506783999157 ,  1285542792354720941 ,  1914694499906548325 ,  805619684805875310 ,  1868694006400407533 ,  161675252077126683 ,  444371209954410610 ,  2271034912792823266 ,  2455450565864492 ,  815977392722000465 ,  1075113299032283462 ,  919357494959975247 ,  670497559064590496 ,  1085835609016474786 ,  209409212456415096 ,  847746285060791737 ,  769099074461289652 ,  1839434238352405924 ,  1082325711044214604 ,  1008342149558683472 ,  1906269669740673836 ,  1666539775664734008 ,  1202222745544407514 ,  850477046653253769 ,  119097779385967858 ,  1582239524733889861 ,  657759482632335378 ,  1481070186780895699 ,  1572081601124170424 ,  302818042732404900 ,  378230107308817876 ,  995551050152322753 ,  745607054298409988 ,  1999068291392133174 ,  1674354643950341881 ,  1343051835335241352 ,  1794291827624637942 ,  309822475787978703 ,  310662407449334393 ,  1267473062835566785 ,  191376170346531415 ,  282640043748254422 ,  463635778309216197 ,  1676362676871087600 ,  516266797766819249 ,  1152269022741618705 ,  1296480897614509735 ,  1008636990860900251 ,  957752969695142083 ,  706179689425855890 ,  1160503732164391794 ,  251222515253175948 ,  2136930543845573054 ,  1073879571634057472 ,  1244676297722556164 ,  1536004822351730564 ,  772258191193806828 ,  1064602170331414785 ,  846235555650620048 ,  1095747167475757897 ,  49945427313178383 ,  294022634078781936 ,  444872117710621709 ,  745443721076889111 ,  2052949082949851829 ,  514106433213050626 ,  2039421635792684192 ,  659939268246059753 ,  1307087654700618587 ,  1654306970885487199 ,  1844849966554738378 ,  330418862359586086 ,  1972318550089612358 ,  20091855790395451 ,  1526625453750009198 ,  1455790128670251966 ,  1084211390291101948 ,  1393902201603257680 ,  1846550080725800703 ,  516897973282479068 ,  1466459406571942143 ,  1903318533574549099 ,  128967701962616752 ,  154562740172418006 ,  1782731747974763684 ,  1329772298324983141 ,  901510029322802064 ,  2042228725312456830 ,  1329395124833070294 ,  1039539328573064448 ,  658985733312127670 ,  100572416598827718 ,  1171608560845182848 ,  1076138022993603079 ,  1621317869848761289 ,  182926349442359960 ,  1337403029960193988 ,  2005698736561013588 ,  892856740988817936 ,  594552144940728668 ,  1734683075740371989 ,  2228436042319219279 ,  1667765526146124592 ,  625191491699371872 ,  262602787053379427 ,  2004447816038950883 ,  881310014545093696 ,  775082402521855563 ,  1161014537778669459 ,  412964071636057075 ,  1966113425867243462 ,  681988397409298380 ,  1147994125784970850 ,  1060970801990191807 ,  322333611515151281 ,  1297300555116529449 ,  330599691216178208 ,  1198142955010891332 ,  75520263407249212 ,  2259442742581001161 ,  410414712715656666 ,  1036815340392468395 ,  843463440680833386 ,  1907282183151545959 ,  1438096575520193487 ,  1433784021468220346 ,  659156519448162393 ,  1422603873845115890 ,  670611670282452250 ,  2277059984453691204 ,  743738568466084512 ,  40188667669803288 ,  2156569777790469679 ,  45109646548691337 ,  1126225419757601644 ,  1122364864779485856 ,  859255881288524377 ,  1202088848798740099 ,  1456806482626259128 ,  1840612350764168289 ,  1347628354278593609 ,  702760000208389251 ,  224551334124778405 ,  2268840538387809004 ,  1921914283321945000 ,  2231180853001257066 ,  1550484045947388958 ,  262467432483161131 ,  1405265403001880520 ,  530284768201979650 ,  378170493855046559 ,  1951182225514640385 ,  1404385720988413002 ,  632619027919217535 ,  159917977504639386 ,  1011062486642151455 ,  256258638683770773 ,  703876706271111489 ,  17270033003803081 ,  2200071122473910579 ,  2123183780223190301 ,  4992710024904979 ,  173407914575299143 ,  60514073706652566 ,  931142083875201998 ,  1208756716600429720 }, // x^2^549

{ 988157563125276681 ,  34604300634922022 ,  2021646681196157816 ,  295684594738532824 ,  391271610864866101 ,  1850933372687194324 ,  1000595946328418874 ,  2238839494085159722 ,  937204122830487389 ,  428072447117942250 ,  2130774731367064382 ,  1535149410904911187 ,  2204125144242600463 ,  1549815003082171129 ,  1682826349709181088 ,  926976340829815923 ,  1348426381932262142 ,  690259539786613307 ,  1258290431594670392 ,  1552300623237382520 ,  456433440857168323 ,  2058571645843994489 ,  587406256251398678 ,  736823078939776111 ,  1035667843253125388 ,  1062201343547015698 ,  366240963790629390 ,  734847371321054174 ,  1397844857068091617 ,  1533702889525160614 ,  904571487120008256 ,  412928926349745357 ,  1493156158711428269 ,  1495938924706108833 ,  1967446932995165948 ,  616529183325103717 ,  1598893471696285495 ,  2004581171445707611 ,  1963839840121025868 ,  1263762557375094215 ,  2069097648223619301 ,  1647814487746354499 ,  2170871489126071525 ,  905258323081189832 ,  1457910117560588985 ,  1412824323839947668 ,  1320638497810942772 ,  1440758766225861934 ,  1194610580847739113 ,  92735354196383741 ,  1826310093505154870 ,  2224733077403233084 ,  833740711100687630 ,  1321407323069122419 ,  896023717925317312 ,  116260234360602007 ,  1797660140719397153 ,  1274939899289755239 ,  777816488737978009 ,  1743179556819275302 ,  93953890904005823 ,  1876887256690443689 ,  769402474826437390 ,  891896943391273007 ,  797212878924850299 ,  129460203781036109 ,  679171846132004214 ,  1338571729218840671 ,  545764782505783769 ,  36765199860190636 ,  1184447643106878904 ,  2136026250721393324 ,  1497836464305734490 ,  803197760927262007 ,  570846514195514203 ,  2123385106489193100 ,  2108698434150727308 ,  412736110080447450 ,  1569542531566361988 ,  2303128576376838116 ,  2045400284627994258 ,  469994953082421815 ,  184342962092634312 ,  1111432718928884608 ,  1743463373038441772 ,  1974026887206467206 ,  865088258774299779 ,  1680573375803023521 ,  2170116739461738413 ,  659267277309877381 ,  1816027765688166877 ,  1750799377635506796 ,  88886434734406822 ,  688054684255433619 ,  318848557246158134 ,  1129458179069079586 ,  987704070683862992 ,  2075474153660361733 ,  855467735062804150 ,  633918591333175943 ,  1152286246078552700 ,  662229925796302937 ,  814880725086985524 ,  324300860791447102 ,  909227098379654287 ,  1930683934030838132 ,  1273265424264653873 ,  540520409693995880 ,  729890455295895712 ,  1785039242298538837 ,  2118827617559016656 ,  478844794896342350 ,  563049540651083038 ,  2072850703229701289 ,  2185775340526802533 ,  2177485332466203475 ,  2254788323966676370 ,  436669824134879471 ,  922280606114395416 ,  1749830530459753410 ,  1545436763340970477 ,  1374539425312819836 ,  520692143431153573 ,  380562493853970297 ,  2248763854102053366 ,  1665537778457376192 ,  1808467308142048969 ,  363712800055237147 ,  463617376434984763 ,  1226966224544325474 ,  20793693685166949 ,  2140147492412012402 ,  111696147925957214 ,  178125235394206324 ,  1024817232802780900 ,  471767865209583603 ,  669282077943150442 ,  2184055882289303967 ,  352299279981347460 ,  2067218955495067262 ,  1388998314661086122 ,  884850087546148585 ,  1468367314959545470 ,  1970454529272632475 ,  1597274004553240475 ,  362876284287888541 ,  1000536057068792869 ,  604741057176350858 ,  440464642090610002 ,  1329610723372979004 ,  163294228514020344 ,  1772278534290482502 ,  2294234185235967441 ,  1662985097995625625 ,  850254165112815222 ,  2041064078223100190 ,  1847781119413254059 ,  2280349330619670392 ,  369974933708233 ,  1483093340810646723 ,  1425266459150320751 ,  358646723306063809 ,  309823069806595857 ,  311586617989081702 ,  819463028299972351 ,  580536245084159826 ,  1654685408354487565 ,  512502511871145369 ,  877579864479226282 ,  2163227271164159479 ,  282320072966611832 ,  2100715624727891017 ,  1320431684083604126 ,  1560792171720532511 ,  722523211681674157 ,  1032623685279382214 ,  2140001537319114138 ,  1997178873754758724 ,  704123500528881796 ,  1798750716143724193 ,  600625040444401037 ,  663815473095973677 ,  544178769451632755 ,  2212442693382572555 ,  2116162450634578495 ,  102847613612588441 ,  872846489294569411 ,  748822282695865099 ,  1281222916223202681 ,  614747538600825474 ,  752202530958287372 ,  458639617316404270 ,  2233021315749490027 ,  262593840750747180 ,  761574000890138750 ,  1652425047408482674 ,  2304560512388152661 ,  442399423659461930 ,  1915793443074127845 ,  1072551474433034261 ,  984162527323657890 ,  64855481289582562 ,  818770155302739607 ,  157825689583812000 ,  1246057687423369177 ,  2036690953134209250 ,  8763997390113151 ,  1234453017012287405 ,  886860354183261170 ,  1067940504124341419 ,  1827905254683705907 ,  1645188292946909544 ,  2103270273332268646 ,  610416626239956367 ,  474018296883328796 ,  1811654002342755830 ,  817002413129517040 ,  1180317273247623473 ,  1079263416319699806 ,  1409467884707176257 ,  2166130726931181385 ,  306467021732544247 ,  1500865006770497925 ,  849287671626317599 ,  1050509499977061067 ,  1121753692960162787 ,  1079352045846062367 ,  1379052983693081998 ,  1909224774255717104 ,  1334951035542778328 ,  1530530585786623008 ,  1542129240832090208 ,  1167392091064795917 ,  353452540085225787 ,  1388433708456787218 ,  2269926384265598685 ,  239292140573317638 ,  454770491435951870 ,  1171539467908172672 ,  979911991304016648 }, // x^2^550

{ 446521612877473249 ,  2203904921717383616 ,  1725595743718220185 ,  563928041401926490 ,  2087430950174001021 ,  76135098022907622 ,  1254564712466246142 ,  1195706284891996756 ,  1703759859049140749 ,  1122298057312299579 ,  276711693323435749 ,  1804141394175180916 ,  1428981244861051344 ,  1798143716342773949 ,  1645017035552889556 ,  857521607341729768 ,  800451734327046133 ,  181301399186792798 ,  1089630096134744951 ,  173704420964440489 ,  2303517016407517143 ,  1790257959265654358 ,  1145941173277936859 ,  1271793316023900700 ,  1245404074057766101 ,  1509374070597882061 ,  2267698035795394540 ,  1010355300412103670 ,  1929628403408317271 ,  1231663564130070372 ,  303149991004360025 ,  2032359668591782648 ,  1268406711594463383 ,  1286101298698065137 ,  1275398781243013093 ,  1291170636810835894 ,  1242332426615017332 ,  1244531382761539850 ,  1329448410931911658 ,  1429795765170350535 ,  1102871844204690999 ,  1212298561444786298 ,  2129655340851105301 ,  898421623801079032 ,  1185546440055516013 ,  15785060912049261 ,  404065167268251305 ,  412495493182308983 ,  2012867973523061159 ,  1656474212510144516 ,  377673506998172311 ,  91734050554976592 ,  1170923769217491148 ,  1106983164067138222 ,  464596565037373916 ,  598072846704475775 ,  1441883059131038668 ,  708928612328715606 ,  515564226641242770 ,  433674508487306198 ,  629291433191644881 ,  89585117300892713 ,  1646967458811946120 ,  898853423668624517 ,  82863554324874964 ,  2239251981429781704 ,  2131815097932839226 ,  1276057203223140246 ,  1518543100428891414 ,  658260530753892608 ,  2275470687320302768 ,  1797476968046843565 ,  1219922276537637998 ,  1572908098734878803 ,  1483269258704141853 ,  2085517110265983205 ,  809561928119620680 ,  1931376145167732126 ,  1452128566418550847 ,  1954798421600904732 ,  785051616380784552 ,  1763060681944779306 ,  1042381251122455424 ,  409528326564874366 ,  1947837744412986622 ,  1219066771768783816 ,  489438245452763840 ,  847586332265345965 ,  1785855413793335419 ,  1459396714926142124 ,  836973816592408286 ,  1124718677916393549 ,  2057620303868710553 ,  1770262902394636658 ,  1078757193214290358 ,  656310727184118223 ,  2214649854691068498 ,  1585951635384612741 ,  946898349106469163 ,  124076839835489763 ,  1551464402202745648 ,  1156772785444875669 ,  1110407837577556096 ,  1613320863869746985 ,  2160963586879656429 ,  1310323158189285301 ,  2252905968342492336 ,  605114976387361736 ,  1674007647384243654 ,  991481993946882264 ,  2233163498521858650 ,  1014949222083147894 ,  729652446699414749 ,  1398298420378186171 ,  1736916905417162072 ,  898335815877115546 ,  47584762571891741 ,  1561509368491760852 ,  1022278533564993837 ,  33925557524436357 ,  213693919952728038 ,  1557886816266714587 ,  1068905733503259245 ,  490096817431633528 ,  426906163984174749 ,  75522408225953463 ,  1653159528662921138 ,  182102153822065447 ,  249245982202669168 ,  962691492379019027 ,  1221638060178671811 ,  2148211967286420071 ,  1213601815227166142 ,  1695118302896541499 ,  12027793047906056 ,  100524360628793293 ,  1622861681548412893 ,  1862269943354445504 ,  1857486796190435332 ,  692554349395796482 ,  1241260698396671334 ,  1781556596303645928 ,  171736612918575835 ,  1141611381381528705 ,  1397242862012887178 ,  1014508135928504964 ,  630886245735500994 ,  192707917511671206 ,  1311193693710270371 ,  712624106573976585 ,  1031258850067748357 ,  994484205249134855 ,  1721070033828088941 ,  1377944444174852101 ,  1571691443530225099 ,  1813696593385586326 ,  255657726472419829 ,  1757287996692125481 ,  572275570918219842 ,  1056581438781935556 ,  486297511787847979 ,  2130966811549153074 ,  1022353178765517494 ,  1043648274887683003 ,  740045159601895433 ,  1107548595442295482 ,  2300157867097211282 ,  318095253024609761 ,  1480837806660372895 ,  2075528768219268051 ,  646965322700729898 ,  678806841635465112 ,  2182063915410161829 ,  1665290065150269724 ,  571191747765022855 ,  1914553057754088366 ,  2241728797194179060 ,  932358200473070466 ,  2201929880622997311 ,  1843599349315600100 ,  1797657406636129059 ,  1028686141652488709 ,  1900414356838626873 ,  369393135306684124 ,  719067074148113137 ,  1214843582093048163 ,  32259939022201140 ,  2163832741753641523 ,  814152609497378918 ,  2245990777927869219 ,  2227581494568369235 ,  1755955713006649493 ,  519160327769245733 ,  1243698487291899255 ,  1346990942526033544 ,  184262897796265153 ,  459886850953423013 ,  1369055608071577857 ,  511178736463915107 ,  1664279158611938073 ,  143565115046449262 ,  287035502618123455 ,  97661751786491037 ,  1529749545734703549 ,  2182713515730756648 ,  1391323398027313930 ,  1701831436618759428 ,  1843076949965294416 ,  2284141311533588450 ,  1330619143026062484 ,  1166818874515847050 ,  544132829760998611 ,  2204922598695655132 ,  1452788337904482015 ,  1348369366568547830 ,  760490475043109160 ,  1686702428417589906 ,  1277369952319706446 ,  1632603767089125129 ,  1579639216305674619 ,  2033534198726794388 ,  1128446197567249648 ,  63585770678922385 ,  2149199612819505830 ,  1795795081163993855 ,  2098716961949861366 ,  1904782143218762464 ,  724120397912981715 ,  2207164724793251121 ,  909111924697654595 ,  869817063531952874 ,  7369430748069294 ,  2026709384713875445 ,  1824911935910750936 ,  1382213537654007280 ,  344042109335360252 ,  1042156771719228538 ,  599945368707356476 ,  1975183457094355415 ,  741657325266551292 }, // x^2^551

{ 1764110509126655728 ,  2130511340430026386 ,  2158054329698695069 ,  2254011506914138916 ,  1672431919206745272 ,  1853639242932274390 ,  2061305517711445617 ,  628760274031380100 ,  1252804288163928777 ,  1198424815555919841 ,  454577986833961481 ,  14078635460665851 ,  29610834636627346 ,  1407681307148149457 ,  1070600643677424636 ,  1818522032378012046 ,  1836659467059450608 ,  794424274691149849 ,  1235862547013421504 ,  944054304695088147 ,  1324017246614775865 ,  897773197615756974 ,  1407162880187547598 ,  1579641037167725430 ,  1665971466958337494 ,  1799451170624981228 ,  742077038383815206 ,  1683483234871523080 ,  2281002544184116991 ,  273439169226137849 ,  426987217138600245 ,  887767716297183957 ,  97914139699045052 ,  271148755559821232 ,  401271973558479416 ,  2118601253621148007 ,  153455326802622450 ,  1214711877048064555 ,  1624752379822619393 ,  208751760507690592 ,  1320614490427060414 ,  243443200538926241 ,  128379375604418959 ,  1387705322360691190 ,  1509148229539450164 ,  2218832729262897112 ,  1774370375821120587 ,  1128005696434211571 ,  1239857283925403990 ,  379855919880863162 ,  2200830473260977795 ,  1644779081416320912 ,  859124985627205283 ,  1996242039891970408 ,  2216926178309306005 ,  579047703434446281 ,  1562631887291456477 ,  94553177963478753 ,  352067365454831911 ,  1367505061310716458 ,  532134609441417089 ,  973286822444492752 ,  502137682928105211 ,  264051577099388666 ,  389645205710095500 ,  100400814297959408 ,  2132961997505112721 ,  1012842338242846304 ,  1642016436716026035 ,  772564377947730114 ,  734686857836880503 ,  1130055469125204155 ,  845059708048196135 ,  1979344587128510558 ,  689536581073346867 ,  2110526049382724248 ,  1576162878472794461 ,  2173910180289321277 ,  2299719241633858992 ,  1384502123602453943 ,  1105751833215136782 ,  792724352020090179 ,  1879163407139703814 ,  732884958338957867 ,  236031187301576774 ,  1836008205805486086 ,  855119804253927468 ,  1624310848839726947 ,  1523627903900839882 ,  2107483107414046145 ,  485286480784982639 ,  2292428259445062994 ,  2120913796389655246 ,  540347245023256537 ,  897316739803042267 ,  808697971760936735 ,  1647207000020494727 ,  1986851491578414942 ,  1209766620320593803 ,  315419664642911675 ,  925497442411988374 ,  817895940053244677 ,  274775879614048440 ,  2072000690350148413 ,  194675260091134073 ,  615154925082346702 ,  604962847119320094 ,  282266680111875042 ,  1772618130887664361 ,  659253181915664201 ,  1621943837851790616 ,  1735625738422472169 ,  741414493712383322 ,  2233574754766935006 ,  1238605346212601306 ,  1518080548110672423 ,  1571754469357510791 ,  54939014976574729 ,  725723442000592826 ,  2015880997154471342 ,  1439285400761166509 ,  1823572342574817009 ,  1457738106913092833 ,  1610160017962929843 ,  1173563660503331180 ,  2143978084753957399 ,  1156732758455837941 ,  524981750785450062 ,  231505650934602760 ,  1699312974628358222 ,  937600602600956620 ,  1955046276300203295 ,  970544043172034913 ,  1807223433391032633 ,  225523685848656213 ,  1617145025420564459 ,  342255078740995164 ,  1681133978845788239 ,  131427034619583788 ,  495296432655530203 ,  146010605591004625 ,  1868166108657369799 ,  640354828888904345 ,  1491499546179058837 ,  808645397171128511 ,  2297415495006528978 ,  205181079841976902 ,  1959271056434269185 ,  1347621699643343179 ,  947126025172337470 ,  406753172175188492 ,  876700427406780280 ,  46138218431570729 ,  542120198349474625 ,  695741101168466915 ,  611708710394022129 ,  918173316542900732 ,  1077413869350998979 ,  1963547628476730737 ,  2231160675920832597 ,  1500639225817881629 ,  74834392495920202 ,  973029494027277779 ,  1761000139145937201 ,  845440122272138440 ,  133856547078174657 ,  1395013866859818831 ,  2083101070517607878 ,  1610496258981610563 ,  2180677615676899585 ,  1812397194758001509 ,  1194430852862499817 ,  1225352048533039152 ,  361001311875477031 ,  1196377885883910370 ,  1866163278398047929 ,  2157306226282991461 ,  1814952761344416834 ,  801710565039827706 ,  1265091984396476859 ,  897616071692080369 ,  2135903303267393344 ,  1330648798426821522 ,  2072194354800828202 ,  580989687254004966 ,  196537010678549800 ,  2149185623349602253 ,  2277668132325276216 ,  894056632025217177 ,  1961797939772030772 ,  1973962802040588254 ,  760781545579740651 ,  2048307075679390070 ,  894228161114060950 ,  851844784560311943 ,  1037304772635119389 ,  1878715319920857550 ,  1555637010964473611 ,  1450164621362240642 ,  926182324345742364 ,  1734063264086491327 ,  673787038969105159 ,  1789191514951115407 ,  196762307585655791 ,  1885166048521153582 ,  366525426585038558 ,  1741612476937354798 ,  2255402430874206822 ,  216970254283366030 ,  568343083865594380 ,  741395892538309920 ,  1065546139108157087 ,  1625526157138259046 ,  1652603358294977370 ,  1567998512299659883 ,  279761644666114535 ,  1654972735243054005 ,  1243912657295809477 ,  607623453752842638 ,  1691289328454909813 ,  77220442467440658 ,  1761547689012284124 ,  573249571863823070 ,  2294716387660644998 ,  1741885474956259415 ,  230616314212093225 ,  937089410985665011 ,  1096674916994392563 ,  1466071906156843236 ,  504633358669877656 ,  1674427522449519134 ,  982138189467809799 ,  309281480148332873 ,  407646971154547554 ,  1806032826111175344 ,  1695993388768375857 ,  942755262639940895 ,  394717316199561372 ,  973472762594900172 ,  1434010489966753377 }, // x^2^552

{ 418386730913400267 ,  167301389759136073 ,  631160620292865538 ,  160136666616820792 ,  1443827191953871566 ,  1397398334690114538 ,  1828334319475469520 ,  1636671457793735609 ,  830506038618066495 ,  986751941273124377 ,  1320567145645058929 ,  1161633634562463349 ,  889156395143993376 ,  1538927768979040317 ,  862680730523102305 ,  2167048982987543368 ,  685116938218627152 ,  1796230511200506079 ,  428106782567327368 ,  925785848645633688 ,  1675715071517815306 ,  1603581341678652656 ,  1554863964737853644 ,  1822592347576921548 ,  1631577987095528701 ,  2239061540258919860 ,  964625651089162158 ,  93697097178970560 ,  271300300876822668 ,  3512757341592181 ,  888965987386799055 ,  79528762071903857 ,  1753415216122589225 ,  21130395409178687 ,  1896067589735416905 ,  1536501428126383506 ,  2080248884747927945 ,  912710229211185523 ,  2154061922688488849 ,  102466616348354009 ,  1787571399172792925 ,  2231918472316675968 ,  78470526607355192 ,  730012192274267383 ,  624667491286208588 ,  1090654926492189915 ,  305575630301846094 ,  1806843391358283822 ,  1815982326295586906 ,  1597637753015467075 ,  1791170244593419815 ,  57217873929490912 ,  21148662748258534 ,  1065970044973607356 ,  1574635445832806607 ,  61274079107334486 ,  611124903202364561 ,  223820055789366946 ,  1801360477058254756 ,  273968016071648679 ,  453003983796113932 ,  639462433076656959 ,  1945049385044020426 ,  64110977119985598 ,  1653038050539800910 ,  592880172530607187 ,  2167333047207848902 ,  1234735979567784541 ,  1508821510796550560 ,  1078985969156152830 ,  1135507898388533424 ,  371804369666789456 ,  424825853741142134 ,  338110282415633803 ,  60996523697070020 ,  2237011729664797663 ,  1360450395920477692 ,  1878538799269066224 ,  760847735455069268 ,  1958105705511333688 ,  1955363319749329333 ,  29343313724722074 ,  1828621503212349655 ,  861614600638575306 ,  128853831425950862 ,  610949762411724288 ,  1174171772665428774 ,  2165855069366821981 ,  1837161106016062405 ,  43594570198562552 ,  253394888716419020 ,  822697631200745482 ,  1319252460641994466 ,  369884636272230774 ,  949848356644256354 ,  226996039898811737 ,  1092453287600322171 ,  1092998987962084124 ,  829935829461340248 ,  1187545963533144887 ,  1415802365495549576 ,  838392875278991473 ,  1423649210170669326 ,  1804654281910410334 ,  1348675988212568067 ,  1814296995844090873 ,  1856444711771908265 ,  17899424677269983 ,  499633541110119369 ,  1968366898459832363 ,  1490059530952743613 ,  646919753049296657 ,  1514685096964367496 ,  1756774720321012345 ,  2304097363433143495 ,  573482472534846569 ,  2242601315297799638 ,  1843951816425624806 ,  565194235029777716 ,  1013486144691095485 ,  452432528789347111 ,  209815913436969405 ,  851971240216565450 ,  868979702842725254 ,  386805421763506519 ,  1037495536919912553 ,  582504676391748473 ,  100126707143034202 ,  926479289465350931 ,  2209736801887145461 ,  522220002951269963 ,  400747255272815708 ,  33601395792109182 ,  1446471972088824857 ,  406701259872668122 ,  942546384571845171 ,  278043595603441542 ,  1414044705605279392 ,  1304716336505061356 ,  1408986324028905069 ,  1711718974064677026 ,  728285068938734929 ,  1511712172902424924 ,  2212702356050361428 ,  1767274659502374547 ,  1042482245124426565 ,  1623623395241958566 ,  124173238345969581 ,  1415688498280480481 ,  1980826373446490073 ,  22470929821185297 ,  1298397653826154609 ,  600421883209947816 ,  1374326704025364024 ,  920585059591018546 ,  1023277572546902027 ,  1359684077701582583 ,  2227712140685549111 ,  1045863138843576706 ,  1363416382313880100 ,  1812853611955637075 ,  524369496439797454 ,  2243090648143786432 ,  1549181626870614075 ,  39526832695961845 ,  206958183762708637 ,  1124252089777001 ,  374624551849359717 ,  1283662208530285330 ,  1975320048953534021 ,  2121349264346984812 ,  1026464508842466950 ,  2238578364111766155 ,  223962357867683829 ,  1379948835203775901 ,  869331428472240877 ,  429344917781315760 ,  466845545715042498 ,  1229531969205707736 ,  3493883151583963 ,  757046290023789431 ,  2051451438349203295 ,  640221721316252351 ,  609283804862717601 ,  988056579586540683 ,  2137674408177138142 ,  1420262385596362193 ,  1416979197599131546 ,  879790790333626188 ,  1514799862773624470 ,  1318107265897001871 ,  23574376802157167 ,  1056696082708046249 ,  862418067214376478 ,  1396753721074226143 ,  2256640304585860185 ,  1344576958725371975 ,  366456242493581368 ,  779867188253068027 ,  111070360962323412 ,  1992235161488753581 ,  1454294263092179055 ,  2305347054536569103 ,  198175045045000006 ,  72875156717105332 ,  486344475061937720 ,  1711114580413651324 ,  2235413248563181181 ,  14671583644185456 ,  494744402652071752 ,  2305494957899214268 ,  861832280815789290 ,  2069819846516409062 ,  155780203361381874 ,  1896762678251209243 ,  801361824734680792 ,  1825747178226293771 ,  505488086649320242 ,  1421251568514840747 ,  495161271154113893 ,  2053256162265523212 ,  812819656376879106 ,  2164355072589560196 ,  1927515198124266413 ,  2124627064938529117 ,  1076818585196745247 ,  1135547205201873085 ,  601894035010146719 ,  1446943142810775554 ,  1841370835601314778 ,  1508225526558964930 ,  1177955206353220537 ,  1855525548892516820 ,  65722676440686423 ,  1832447962575275245 ,  698149575548127080 ,  1010613951131855824 ,  20553602332911569 ,  1033566682969446007 ,  1068230122100086827 }, // x^2^553

{ 144330498721100247 ,  1539566670957978698 ,  30620332901152389 ,  132299603723117121 ,  1208775681440974171 ,  714957818450649668 ,  688685137540367003 ,  892181700994989392 ,  627793195420146036 ,  205190939730034481 ,  1317150178409559481 ,  1473951853694406714 ,  1439449339100843426 ,  154381938318899286 ,  2269709261092892329 ,  1814802040354714713 ,  1867824437726779146 ,  1186575948888479808 ,  1591577583633787002 ,  1679457415766311501 ,  739078652737251920 ,  2158026215617875915 ,  2132415749598391238 ,  1982833562057510637 ,  2174975784441226254 ,  2010930909919488463 ,  867240815587432415 ,  1180006548088905191 ,  658007564358932666 ,  605857308547890913 ,  297578523724522308 ,  1335943160373535179 ,  221445507014715282 ,  755524814959595930 ,  1875331900813542829 ,  1991943668262321064 ,  828058423100238381 ,  1690308095272486358 ,  20665923392358233 ,  1932402479358333337 ,  517293869197150208 ,  1750216542943969742 ,  849448865739721980 ,  2146702499415824278 ,  429067567607923291 ,  675134782181542198 ,  952336993049209401 ,  370930848375161702 ,  1475053972953807522 ,  991165937559451434 ,  1564202225087957760 ,  1506098499523134569 ,  311996760295357357 ,  357434551908784500 ,  1708934778542414006 ,  1701453853210669638 ,  273889813109707360 ,  2140597838791393733 ,  2106475212920596114 ,  1482473257088261496 ,  1274806470394836132 ,  175166555201779075 ,  2269131673688709708 ,  613780876683751575 ,  634771389328190581 ,  2210826949137185129 ,  1681547741908192330 ,  341543484914324179 ,  877694970096919451 ,  818782056638797780 ,  914500652801892828 ,  779881287906386505 ,  2011951705331517103 ,  1489630506054948614 ,  1109756097385759268 ,  1631960517999230939 ,  1169621454641149505 ,  2221364657863443515 ,  726477392198064893 ,  734919500374560238 ,  5713126712309685 ,  1168913747501780815 ,  1742905445454625644 ,  121634865334878910 ,  2170019830297900978 ,  1801876327522815446 ,  2238250930025746082 ,  1559796330480048804 ,  84226915034165834 ,  1877476365688883440 ,  1616233326368017663 ,  323844020400943901 ,  72695310206574673 ,  1714705669911957010 ,  978146571408282388 ,  841903108010504277 ,  298193803188568815 ,  1057006704594083373 ,  1280001295193546037 ,  1482052380227743521 ,  1787502779918330165 ,  1258555493971930602 ,  1918609473515030417 ,  407501260118410306 ,  188689540995943078 ,  661533380804629046 ,  858821813429681373 ,  510341723859305506 ,  1653807106774764551 ,  783181218471022464 ,  725282243965586998 ,  1848490082632545651 ,  168074094329691734 ,  223559412527561337 ,  272457159608923191 ,  738999937295238031 ,  686175970161728025 ,  252500328281733667 ,  722279059478230784 ,  1594356153538595380 ,  484687781279797242 ,  752607733758129552 ,  289724263968220764 ,  1182707503907374183 ,  1110766423675599388 ,  1850161577993957049 ,  2021007319496359364 ,  1466140333023327406 ,  1616175094597501587 ,  620869642914564302 ,  1767894210984718236 ,  298315080481610688 ,  1175901281552647329 ,  1526601223642118054 ,  948823093913780167 ,  1000257802862492764 ,  266728770175250614 ,  309798977539422299 ,  2003395125014385308 ,  833738378131955302 ,  2142354794537326687 ,  62472006472088247 ,  293886986592124857 ,  298991229875329526 ,  929411955452486901 ,  1604784449807289167 ,  838721769371679774 ,  1545736646272273605 ,  1309889713755767823 ,  240340954573646292 ,  909097454219851769 ,  1601380635876384649 ,  2142824620223504857 ,  1261827311222570719 ,  1097101536242760375 ,  809278976715654059 ,  1190545993008139498 ,  1673052962485765151 ,  644681415799782330 ,  1969535609804645574 ,  1792257930056131477 ,  2228800928997971948 ,  114690102264771723 ,  1091753856737418769 ,  902851716540544385 ,  1611427988066061376 ,  1106112334359525766 ,  1581674080512790217 ,  616865014215674118 ,  528754425590329006 ,  52773126849503340 ,  1652239897032407835 ,  1106696648394362997 ,  1838926320543137166 ,  455745906100435860 ,  346050498896457917 ,  841767482792067384 ,  332345343144336726 ,  1632105769080508251 ,  1410388431823196739 ,  1036583537230686061 ,  1555445796412156603 ,  2155689305368271741 ,  2265428329186300763 ,  2182619859392678169 ,  1032577515677243705 ,  254419632484059949 ,  1868915006333086293 ,  1274373314433449205 ,  553030362219799721 ,  245826735679856675 ,  1069147668433976575 ,  774549212198553925 ,  620963273155974862 ,  1559116365837171993 ,  1931838973515607482 ,  1706675160132293255 ,  1243678194580398126 ,  1974567789435430730 ,  1601760590238470135 ,  719743117453504423 ,  505201350372387346 ,  58658667848147105 ,  601845351257545851 ,  593332100809575933 ,  2143004001451422956 ,  890556473779195059 ,  860810469145728234 ,  1502224795123355556 ,  955903233984837730 ,  2052340761001484902 ,  1305139872856170886 ,  2273764595194559870 ,  1191809406791118364 ,  81441626528425802 ,  1726906616956819450 ,  2261789751392096291 ,  849138389838255725 ,  163917008041403191 ,  1163550808427278292 ,  1626772776726344673 ,  339771334146911893 ,  522853615076833009 ,  1444173109936995148 ,  4841516020048646 ,  2303561208256744210 ,  441159605467667077 ,  1194087375288069117 ,  1960511090881080184 ,  2074788928662572906 ,  701181586481034611 ,  480944915789285020 ,  471812544338153322 ,  2255709275044515029 ,  1072140600445276161 ,  652779791581125938 ,  1987998551788439254 ,  2266351770995755827 ,  1641305989989847002 ,  1130141291994219455 }, // x^2^554

{ 1107929390176257692 ,  695544283350161776 ,  256689227009944237 ,  902249128910128397 ,  287130964813024215 ,  1347338066038748260 ,  59289259040049152 ,  1022317174804757870 ,  1466688635817778780 ,  1994425147637098584 ,  2026106239965014909 ,  1870011306964531472 ,  383376208025782445 ,  303123626700884661 ,  1857474032009139577 ,  1873432072399480532 ,  1890701150310568776 ,  54822303361800545 ,  1224922178773406091 ,  1617836695981562926 ,  2209885616820871792 ,  1153053485653912696 ,  594819938654080934 ,  2147581711119585736 ,  1384941434637816712 ,  103407199269585684 ,  1342536154539793327 ,  2030088833063804031 ,  459220978007380948 ,  544132665765212849 ,  2097080917910166680 ,  1753121715862853696 ,  48713861873412703 ,  1447212215172987146 ,  1523964054340070825 ,  1861105326130520561 ,  1938211271514756879 ,  1434118194822437923 ,  899857005841347270 ,  1455419615340154517 ,  1276356032183888463 ,  1084995421103256397 ,  1373532662622328550 ,  2280715462882836873 ,  1923554877514072376 ,  1806644926772677095 ,  1637125038652807010 ,  47049151018253453 ,  1821600001891221222 ,  398915488967034161 ,  965402870247621760 ,  1677748782121003221 ,  390283752768639395 ,  118287503252318823 ,  833352104826656627 ,  64761894372293929 ,  1528278785034340089 ,  1047825326514361057 ,  2060167592921806365 ,  1092454513110379345 ,  1510443725564295986 ,  1405199124476936698 ,  652585463030238612 ,  1637062060838676671 ,  2004711183072189459 ,  1491132368249104247 ,  980703617778486515 ,  1093962407647666403 ,  121701582488340350 ,  1400877466017856849 ,  309887765481189814 ,  2171294138933747179 ,  2082241415555050342 ,  1710556033687534348 ,  2059116924648684097 ,  2257260013915294461 ,  147746646948978809 ,  1671675359471534930 ,  2207612750981487945 ,  51535086417673517 ,  110836829862181056 ,  837869782605383383 ,  1361770447440740688 ,  552615900199982003 ,  786185816251748986 ,  176884089002776878 ,  1616700731868819873 ,  2127236211400628113 ,  1470367428429502398 ,  788389550681091487 ,  1644064019085561275 ,  911084662182119261 ,  1260212947185189836 ,  1318486411925338516 ,  1517924785915229897 ,  1978545323805488443 ,  1154733939584781877 ,  1808415431760791306 ,  2297029221869339678 ,  73278720060322927 ,  463258869591339316 ,  1185613429894751930 ,  2250877269432208963 ,  1964080799278636926 ,  902250019635676662 ,  1137496371453769059 ,  574547810535656954 ,  1042303286814965005 ,  1521833246537501743 ,  295932732399175627 ,  1439149551448761100 ,  1711579538930709975 ,  948508489909380980 ,  1085603928218877133 ,  1774753116501342555 ,  501344029936470492 ,  1684493812984462823 ,  1030621967698697784 ,  1887698646836902084 ,  1684444891334550336 ,  894926737070998174 ,  822796241924603924 ,  1472078945683552985 ,  1144799461237596256 ,  11436421162980494 ,  942433036839227336 ,  280833854662007878 ,  749988789715400760 ,  649585908798556194 ,  1739281572828328249 ,  1811110445441141230 ,  2016356357060555267 ,  2218156305819408921 ,  1442718035498849396 ,  1303618784255142908 ,  879138221996445423 ,  675956309664178149 ,  2227683856266784875 ,  808806742333600457 ,  2233570469880098909 ,  1803819702966102625 ,  1325683467776959664 ,  2267308840961320366 ,  1684311042672492211 ,  371319301639537614 ,  2152105869280164122 ,  1758974315791506169 ,  710975607923455919 ,  382988031927531507 ,  595853473002118974 ,  216922357391683054 ,  1832900282709916822 ,  1436212788941708007 ,  1234131105043075467 ,  805523299733487054 ,  2238517284808582472 ,  642051150052466176 ,  331357669617360101 ,  474141604207031305 ,  614701000759457808 ,  1490706035512225982 ,  887934326253834676 ,  2157339722243812875 ,  910159605058481821 ,  1834786196779428025 ,  2058780092063466354 ,  1986213873974071682 ,  767033630105164706 ,  408745168982449086 ,  395006264838086464 ,  1548925808993134444 ,  320188246689148829 ,  1967366226609774482 ,  612858253950043859 ,  514131329451809427 ,  1138309647086631901 ,  369291593492152044 ,  1592236597692298295 ,  702037341107371345 ,  2068858751307794392 ,  1396249005453294566 ,  1175621633326321047 ,  31629154731759145 ,  365320844888931908 ,  976959551506345853 ,  1113908792473848070 ,  449996893196673664 ,  1965112103434055110 ,  846338454303724936 ,  1565683104312173155 ,  1954780631573576124 ,  1793020966777362551 ,  1015228992417126608 ,  1871257492551132156 ,  266741964095614063 ,  1418841252267385657 ,  193660961487535602 ,  1629299753741230456 ,  1783999283623951142 ,  1828459969807681136 ,  1134130594683519997 ,  1414178983099774448 ,  1242801766628661478 ,  1935378277966819897 ,  27789092465203576 ,  1043864896801156299 ,  389405588382370192 ,  1539734650642211940 ,  1851534311280376013 ,  1239276933932532600 ,  1000753671931568793 ,  2140518671741618762 ,  1370804560494902761 ,  280770956727158810 ,  969146893777374281 ,  1366836857895110974 ,  1753972205610404908 ,  834490017376653443 ,  1293544537852217979 ,  614342487108118394 ,  198498198289359262 ,  599977944494003966 ,  537665492950445860 ,  2176535256385880840 ,  659383327962340356 ,  1433787303073133501 ,  1454775876109770778 ,  423217440891500352 ,  1577354628013582542 ,  636071954314092089 ,  1936436898930315703 ,  1535893886267058836 ,  773871309847191113 ,  151813622584752846 ,  1336786670681300314 ,  291917833091028612 ,  970363837679023950 ,  2233152384253927606 ,  87575535057734152 ,  1824305906414937647 }, // x^2^555

{ 1408452007238727622 ,  407266758823135883 ,  140956193702145887 ,  104116458078193282 ,  961965554224189902 ,  1703933508900563207 ,  1918788466151730481 ,  168890118763781865 ,  1975688691745160216 ,  305623442602507609 ,  1556180497346605604 ,  711644801649792440 ,  77296281609414311 ,  2009488519526882107 ,  536282700160712197 ,  1597680765627948101 ,  1442973185403310643 ,  1635888170679732856 ,  970893555378195199 ,  1537591151140484785 ,  505493329375955746 ,  889972344161397257 ,  461462603875871376 ,  2199818951873089898 ,  833210569493302427 ,  648942060284357584 ,  275219815435163181 ,  979109872998250375 ,  1877369851610447459 ,  1010077437527379910 ,  1338644583114733969 ,  1122101679464730962 ,  308647755600643696 ,  933253303359632249 ,  1694657530706163582 ,  2068678918851656268 ,  460292728428345802 ,  2082719384870159553 ,  1959563856434366371 ,  788737660620913296 ,  1671013838639767504 ,  1401899188317897911 ,  1213346055849358774 ,  281084582960152058 ,  2288262378303595520 ,  2145976812770088494 ,  126600038883677009 ,  139565851642976886 ,  1794870653552541725 ,  1755512816549945880 ,  395977671610761632 ,  2273533031215159958 ,  1507855365010415553 ,  1559873296736075845 ,  669652199753463528 ,  76189369775299240 ,  783385790540278857 ,  1402701807610354072 ,  2263125028558844557 ,  633632281910662030 ,  1506561655090205445 ,  390039597723410663 ,  756686873144850438 ,  1093176034401018522 ,  775848876139865576 ,  1962591909108155598 ,  1708657058418989767 ,  1251799837377638126 ,  2063672168929221286 ,  1052057113832035290 ,  272026111353051597 ,  2055527385467680923 ,  896540192744469066 ,  726886163891138100 ,  307171698471145488 ,  1638894790968755724 ,  881282524488202792 ,  1714625553843052689 ,  1754213615329353098 ,  1212291861482400667 ,  1430432332817985073 ,  684090744583851220 ,  864734444061079240 ,  1712669365881732230 ,  1697631988650388594 ,  482819410977513133 ,  643394409906923809 ,  1144576047115506025 ,  253272368769541584 ,  1550843979282092761 ,  2132023998817013621 ,  1338829817741056779 ,  1792496606896183131 ,  1736235856320922529 ,  149800101854410377 ,  1777540893502715556 ,  291740408063923798 ,  1574449470100104419 ,  521360585832365449 ,  834095034708747236 ,  577523759139126489 ,  1787656311967384684 ,  644788042181536651 ,  829764480620345626 ,  697218968492632889 ,  938798735759056818 ,  1947579385883548456 ,  711250302051159388 ,  295471053120028726 ,  363035385071867710 ,  1299084771578814394 ,  632628836246428275 ,  1269147000919526931 ,  131364854515481806 ,  692636928243224346 ,  1756807772405071035 ,  1855737476041972581 ,  1881826021912591908 ,  2006054650650213647 ,  567571854392520792 ,  308205749094415840 ,  1522242221031839949 ,  313891372433748982 ,  1811276302860134100 ,  408098515326485808 ,  1738546579564067067 ,  2301082735765013298 ,  1558786763594405486 ,  1005532292603398996 ,  486968192678090057 ,  557744472980544921 ,  1189761563372156411 ,  1554909863307559200 ,  676644657403553318 ,  753085851213332924 ,  461687632711531118 ,  1744397391781972717 ,  1340947728108993133 ,  2195521232377565628 ,  1243938869184458835 ,  1080873079656489615 ,  1713357716600302283 ,  281964692140830479 ,  80030000489672466 ,  130313712554529791 ,  1924869041190857503 ,  1279410683579452792 ,  653158622288827553 ,  203797252030728835 ,  521779251726109297 ,  1159151319157292320 ,  1605433584262070797 ,  1693710284144208624 ,  1459761638534174448 ,  604898157784515478 ,  1474605308754971137 ,  579951600405053804 ,  1261590269802461347 ,  2209610420921015131 ,  1216776194897742133 ,  1368059359989392737 ,  2215180412647961068 ,  1817177871263070848 ,  416776149916947008 ,  842310368011278818 ,  188305393115677393 ,  1615674589099073582 ,  1551556147546110239 ,  1717965466988087193 ,  2055859428167942874 ,  128348062541381384 ,  550926387364674692 ,  742593678836899992 ,  1205382090083750189 ,  1195020544848405111 ,  2058260494116140811 ,  1843358776343971035 ,  812728134698455975 ,  963148586542354477 ,  2278882835895966993 ,  521159247751700194 ,  1958274711882250114 ,  1072082208437454184 ,  2133452276022070684 ,  937808894005909732 ,  426975304265979460 ,  1579178477804404271 ,  2200476470800035877 ,  1512148919591442314 ,  1153902101838825715 ,  1455980232666468623 ,  1146817507925079180 ,  1203717889461653874 ,  1970512820248892343 ,  624373770392581321 ,  1278503449041458921 ,  1822677227567583512 ,  496280091352274762 ,  1868642513523297251 ,  99581763456245077 ,  1110585684341307337 ,  583364323943961256 ,  1767399112471775328 ,  1896089836867937867 ,  1689744872043394558 ,  1316603679246569287 ,  2112337094746287589 ,  25025004795700458 ,  1084038674128371901 ,  1330389177048456370 ,  2255477947667539011 ,  22318180763125267 ,  1776380871936903719 ,  128017396788573230 ,  1009850864556902355 ,  2155141537553981397 ,  2273897082155336277 ,  604786235078983053 ,  2157288784661893495 ,  1861714634766895144 ,  1818410851576694569 ,  1521732719335330524 ,  181477801509440034 ,  1300301653226213818 ,  786968301478557681 ,  639573761882621391 ,  340396060485094023 ,  701065200535392662 ,  123105106900577598 ,  648878955938946890 ,  1281819410863932042 ,  401974829080684572 ,  842938026669052914 ,  1884327614267200651 ,  285087131424514058 ,  1347997835551171375 ,  152254195068263728 ,  521001430322269108 ,  837367640116017330 ,  1424294611703158918 }, // x^2^556

{ 531541758031131665 ,  441617075031865708 ,  1784023080394652691 ,  1207843250307036552 ,  1501301349541431686 ,  629441383352750275 ,  1605172818240110794 ,  1294793640548419743 ,  1452359942723705820 ,  355259814019147433 ,  223725082782544641 ,  1422471182377001297 ,  584415474322381645 ,  1851818889747161503 ,  994848775628985940 ,  292550421438505474 ,  263910327296878395 ,  1840991265201413380 ,  1224560994320303701 ,  909520365925066719 ,  2071086221904559534 ,  267556738851260248 ,  28271182690738279 ,  79214265395321532 ,  2014646258987723153 ,  969934594948569918 ,  185842889337801613 ,  1256759868188455721 ,  92096062506214467 ,  2238896718953255601 ,  966108577470936229 ,  741656483769909646 ,  848725004101765895 ,  717282909783175418 ,  1841524485986661981 ,  259367382660226040 ,  467517217487841822 ,  1248120093867071088 ,  2037395539942039303 ,  1045057489856801080 ,  2156542185697099299 ,  446420064943003586 ,  2300442331631592925 ,  358858786260207286 ,  655965025809213115 ,  781790492438646223 ,  766342863200721545 ,  862963861398465543 ,  2102169771985298473 ,  1107419128049250143 ,  1775704665976063024 ,  1397251434108701465 ,  958789730018702795 ,  486187134813899956 ,  1605280290756516149 ,  509346790990997084 ,  1589107406565386902 ,  2227221099291644380 ,  1398570907869543574 ,  1565577118410688855 ,  2008452332318064849 ,  2197354154879339943 ,  1929979445138490454 ,  693132407361714705 ,  1985139133527299021 ,  463716271365687746 ,  350061212914991333 ,  4092549241574887 ,  2144325916192201010 ,  1653969325520641162 ,  2081334093639588137 ,  1184629301061852289 ,  134055125536561993 ,  1345802705566896095 ,  1129804889945661099 ,  1969350383356507705 ,  483258288201448014 ,  2028552835551129871 ,  617589288338082916 ,  916214056765077272 ,  2211109986414982477 ,  280508187580016520 ,  1205741007528264472 ,  774908637263296955 ,  621320244461149988 ,  154984430130155543 ,  1326812972383304032 ,  343948022815032546 ,  361538835295014446 ,  1321542142156450211 ,  1895405043320813541 ,  1512828758936322690 ,  969162061145536513 ,  1123953538997287158 ,  768834347844245985 ,  1864362016947706060 ,  1533708572403583387 ,  1717685760868355865 ,  764770180617686344 ,  2287722508854224159 ,  1775437472629239204 ,  687296161724288154 ,  460989866423580384 ,  52743881901431351 ,  963924751046668714 ,  914841070272650872 ,  1503966801086874516 ,  1999787749110645621 ,  1241198420639779488 ,  1612190245280332879 ,  651596565004189885 ,  1138271508391237691 ,  1564600454786096508 ,  1707747531771472097 ,  565671507508421161 ,  79371159508787170 ,  1434634946285834326 ,  251529336846724024 ,  1421940595201903729 ,  2211179594628887401 ,  2116131701214960129 ,  1783789083695699717 ,  1823842242616703148 ,  1454841668272592769 ,  1458722981948583815 ,  1913147618814790944 ,  1374518234035904185 ,  1447196893531412385 ,  462421176624106092 ,  2206661175258198319 ,  1687461107927716927 ,  718003412286038256 ,  943983102706684051 ,  2184199434465274066 ,  1836639488900680860 ,  1666941829784479408 ,  1551042341743103510 ,  1414396219751460350 ,  1134652800760064814 ,  2299384414684093442 ,  1331152873284270115 ,  1680942948599629651 ,  1696678636081669899 ,  767783739667499596 ,  693501587767883668 ,  1264143251864284675 ,  1852685808370612756 ,  1080286193223548785 ,  914379512294204189 ,  1881525188411134687 ,  280215593224184887 ,  377282093309168171 ,  1569234339855022693 ,  611384294123419604 ,  1529500828383358863 ,  1745965340572637312 ,  1592149825477654833 ,  1960818835754630110 ,  606859437570066938 ,  1448654990789700644 ,  215947698917998181 ,  2279310470355662219 ,  638670120672268847 ,  2287844756920942076 ,  1724189934108061678 ,  218375726581768065 ,  793963953162559629 ,  74503272712698431 ,  1688723706454621117 ,  1478198658823520516 ,  30999632056841925 ,  1962378393435809044 ,  2203398999719822034 ,  562764608481998430 ,  1264284323352128316 ,  247436479363670330 ,  428550444376421907 ,  1781439108442689668 ,  2073796114082337071 ,  953585344220052739 ,  1165267290585883544 ,  371045966209692929 ,  75544096231000213 ,  1227898663631904913 ,  2027726994136273927 ,  284096324721715064 ,  808735357262567900 ,  1599477878599780052 ,  163997788975797976 ,  150667344176187600 ,  1806331689917386441 ,  1283650775873098289 ,  2234326129182656726 ,  226475354195229424 ,  1610149265206486113 ,  546396238604051675 ,  1266745164943860699 ,  2107814282791823612 ,  437227937721654963 ,  2098455771778217477 ,  1257475310666345664 ,  117944934535094502 ,  1901058983446269914 ,  2264347509988035990 ,  130437516847861564 ,  2023660183268537148 ,  1923038300709930076 ,  792279338051978214 ,  796478724550151097 ,  1014146797386737574 ,  35780849366723079 ,  1329802150679619012 ,  1353075552679477616 ,  1499006358730920067 ,  1655600571147898703 ,  213370119499983875 ,  153717089683404234 ,  236336479367773578 ,  1300992306778726314 ,  1659507461890918448 ,  2152199036758098255 ,  1310293273198636015 ,  180103199799149191 ,  2273559104625396590 ,  2148903120226715244 ,  348423162860412395 ,  413464722270833620 ,  239179930215805816 ,  984636430395990998 ,  1018403049886094368 ,  1358551657931276940 ,  110033496437562799 ,  2159451515859260064 ,  1211165352927495106 ,  189598652053526699 ,  609590774215259590 ,  1107988819015452370 ,  2284649620000160004 ,  627120592551699245 ,  2025723255363196647 }, // x^2^557

{ 1524507195749167581 ,  712006368341134823 ,  766512809624264008 ,  843862215888140743 ,  244354606614439887 ,  1592584684102311290 ,  1028787047308827612 ,  736917564458930857 ,  675483367868235100 ,  530221973547943521 ,  1273054123544930677 ,  636347319209637545 ,  1766841031021827041 ,  2094418095138333336 ,  1871482272334586058 ,  624856452863092350 ,  934691592172657631 ,  1272448770446123789 ,  588509366345068042 ,  1040343662245821754 ,  289808949736994802 ,  2232880625500933226 ,  844988502082690892 ,  864214336482526584 ,  1098688608165355739 ,  2143440890795226168 ,  1558924155187675575 ,  698962252269722901 ,  130072553428338873 ,  2217319187735592684 ,  549661116716090197 ,  1936065027298358515 ,  2229223028372655037 ,  381321681971128666 ,  2268625282524889515 ,  2258621995733446142 ,  481207961784133335 ,  1809917811490696260 ,  1101420486052952880 ,  2246847756890429707 ,  1596727559110785751 ,  269626723677952345 ,  838088141201475000 ,  1183741862192989318 ,  736106114434469282 ,  1888147115848050242 ,  350965921855229290 ,  56906517827679183 ,  629257064501618435 ,  1208547509058023765 ,  261900868088390719 ,  471726949512864752 ,  1731219167893792998 ,  753298184712262462 ,  2297448678001190153 ,  1069637798473016949 ,  1788366271346718769 ,  1306532585284368115 ,  1629659193614277294 ,  751732035523021578 ,  2090704373726053456 ,  932471184215936717 ,  162443069972285296 ,  120403229602778129 ,  1795880149902323968 ,  467622272141219394 ,  1809607945559790957 ,  1568514698513684032 ,  1775185687135096836 ,  590395886765402244 ,  825578479929423435 ,  2295813065130112114 ,  1876211059150482526 ,  1047873291642395998 ,  629341228326660405 ,  847992167698251369 ,  2031378287260061099 ,  425181925636042814 ,  511591887959488482 ,  55767082830098681 ,  1419446549405061450 ,  1337457553533130764 ,  1775454232719058592 ,  751311588800035682 ,  1531981241134127298 ,  1775145785615785827 ,  1619643597497636713 ,  2015793336694371402 ,  2116449471215982 ,  700651795374596225 ,  374590859100360696 ,  2113457131021992735 ,  584627115016355762 ,  386366574073382461 ,  1090999778278781343 ,  726602466287758314 ,  33993766247626768 ,  938271804088055950 ,  472975245719637410 ,  1412291023709679028 ,  1593808901084568748 ,  2258208378627078003 ,  576080158908924745 ,  1904051534654520541 ,  1527315113786083590 ,  2284260903397949926 ,  1535274232744188100 ,  960775771207091480 ,  1279511552880201938 ,  1667323538504028525 ,  1932924865883178385 ,  1542656364488111229 ,  2018060488356018234 ,  17235717520584856 ,  1563971678209024239 ,  2177881330230079617 ,  1881519689581367817 ,  2153104084381573253 ,  514133378979491825 ,  1554804411070089218 ,  2093118127079367042 ,  1795811199348426894 ,  1780049567162720074 ,  79622643115306575 ,  1169772949210075583 ,  254944480683398764 ,  645900732694160793 ,  194801471414496885 ,  215914245729515927 ,  777578353834618589 ,  509097524307910874 ,  1101695860408216556 ,  1501877181426196590 ,  1042136720664299738 ,  1522264288279932755 ,  1717788539995090068 ,  2110163812622756464 ,  419154079543171224 ,  1337129361174929463 ,  239684168343260143 ,  1389973938019627505 ,  1611263856196454653 ,  715301402731238309 ,  2001986550599655448 ,  1322033342358722209 ,  2271707240122978388 ,  306863251773894065 ,  359160870161875194 ,  1852525780264282327 ,  512445174329954965 ,  939046064055675541 ,  2303593199800871562 ,  1739001247081368248 ,  1904072920719095578 ,  214517922186556966 ,  159063575786167500 ,  1834917258257415221 ,  53656705274436099 ,  1986297137694320683 ,  828931255221008790 ,  1096978148695626211 ,  1004317718197573068 ,  1718734617145554076 ,  536941640605073556 ,  802038745077429759 ,  585416358794322177 ,  70684056033237114 ,  2193413780468279716 ,  256526263603295581 ,  2293179323214780204 ,  1858142226604202536 ,  1068751785375017765 ,  1319073486113994228 ,  1936662707947904702 ,  783967495837269147 ,  1874985790990349638 ,  976345109183422893 ,  493295052004535009 ,  484566472079342734 ,  1101303114454603982 ,  1840496515947321825 ,  743366433995006221 ,  274865026834396597 ,  219263458859018114 ,  751066784824787792 ,  1854902035826524060 ,  1047299728829583694 ,  2023054063316772824 ,  2200494941690351795 ,  1868794202627711315 ,  1254540097131618406 ,  393975137254181766 ,  1190357238563069078 ,  831966759260337018 ,  441502105764651226 ,  1206510623670657318 ,  1409003127260961909 ,  834219804911251700 ,  1342606034553838497 ,  950964867522768703 ,  2276629425236501977 ,  1450117408812802011 ,  284997797490064001 ,  1709231661415989196 ,  564888233209201100 ,  1218078887887221704 ,  1240561992008174572 ,  373504463619612744 ,  1780347801177294026 ,  713529508354093488 ,  876256768230928565 ,  1889343302124475427 ,  1360552956300381278 ,  701709106274941017 ,  945494640008229611 ,  809035965525592792 ,  1887809448514924844 ,  1982307882268047433 ,  2234623246885546639 ,  345583898698385519 ,  1410712672726395554 ,  1105993922876850951 ,  570258304088281411 ,  1168594884645914285 ,  654444733257433815 ,  866705578419890495 ,  1492210851806270554 ,  315862882817522372 ,  1670331916283410532 ,  1142763970962319090 ,  1423480870270172521 ,  1674466332581426049 ,  408546533086455889 ,  1340194364616545222 ,  605696418521165201 ,  2284235875607163187 ,  2087067248435685961 ,  1476892904922089897 ,  295408513788858777 ,  640239862655782947 }, // x^2^558

{ 1791407670056282089 ,  1662417691983440060 ,  1173247654028698646 ,  953965373442511276 ,  932405438744060893 ,  945390800111159179 ,  1189384677332952160 ,  1302065158890962294 ,  1468595863771345820 ,  1358535224611071132 ,  1003393248403943634 ,  600229603214305269 ,  2188479825981329685 ,  940669556145998011 ,  1351324339384856524 ,  1752891147705097124 ,  1898450710356659000 ,  2222933333133239832 ,  1839566960336571190 ,  1338785496070855080 ,  1077257579625580230 ,  2151636901132636699 ,  1755831434464267646 ,  461318878401050029 ,  35784318011058762 ,  1900592723117547942 ,  2122732096943214720 ,  648384496458441289 ,  363031812294903187 ,  1480244071234898923 ,  171261077952642700 ,  1659748151784599108 ,  1643064705591439490 ,  1003988746576491801 ,  2089944497271490011 ,  1405038802765823095 ,  169840413660114202 ,  839883723382702750 ,  1712642053743307622 ,  462860906323532805 ,  1987924450040393075 ,  565940716501479950 ,  103713989207586578 ,  1061556607535946369 ,  1231197550799582261 ,  1062282451200005477 ,  2021739987638836112 ,  309718467004517199 ,  955590261376749455 ,  929125968240333824 ,  232580647799184792 ,  2259781082568030911 ,  272532894817775091 ,  1537153632330230054 ,  387130863230722111 ,  1707273265585946585 ,  1647526468756294110 ,  1398320490143434904 ,  436770391386724329 ,  203815728746621184 ,  656144502618197501 ,  1058207834076468753 ,  1121955883466045634 ,  1682245671093944876 ,  1399416081690639425 ,  1979442125160424907 ,  902062269563296339 ,  1929000938310760602 ,  1858328191543911269 ,  1182063387963290985 ,  1052335330060872691 ,  1567504565474634323 ,  2171121200868717225 ,  785970028088543162 ,  155792876321083825 ,  2056730897733257006 ,  1414327396159440838 ,  613038348530262196 ,  526877025171318721 ,  1410092866788920047 ,  1189747539599361252 ,  1487786751497051070 ,  566301398590993902 ,  139051720353768728 ,  84806541231457560 ,  2001513402324947062 ,  2061594374142380913 ,  250943226870251591 ,  1865614717266409320 ,  496960364552450755 ,  1247824933229314174 ,  1425647322807007707 ,  1740417231807902681 ,  1774037930590253978 ,  1728716494942648272 ,  1664971476795510523 ,  122707143211380779 ,  2189625880400430809 ,  2230337924642064428 ,  60783344105970153 ,  1529732694573060267 ,  1596825952671542176 ,  1524619761573193560 ,  82592398399631698 ,  2233588211587607332 ,  1725556876693593223 ,  1558254759702647233 ,  1299367087178094542 ,  1508225722537535521 ,  126333353596921626 ,  93968936402785551 ,  1606955902796931327 ,  1280947885434452020 ,  1850678404865996521 ,  293274543072329537 ,  1867064805712452183 ,  1055392311529073168 ,  1817828495369516049 ,  1400613615235604380 ,  497830268742057974 ,  1518767954652301034 ,  2029743243470465757 ,  1374972386144260384 ,  236104340828754206 ,  1044432096764866533 ,  140868170613214783 ,  1033268578446713633 ,  1785493975127153729 ,  1361358051516267576 ,  35331188750955946 ,  711214786619565684 ,  1226010684310808856 ,  973222919345414616 ,  61807029404058573 ,  1373717604992965147 ,  344470637771270716 ,  1150483909077243499 ,  753509156524506150 ,  1997854468775208979 ,  821875810556869530 ,  282266524470535374 ,  579580355341598528 ,  1263505662171938976 ,  448862616129155059 ,  2097516107401229519 ,  2253735573792355567 ,  2277245427138064346 ,  137787714319108795 ,  813165893428642785 ,  2282330794052814060 ,  2165262178594497892 ,  518924431506384568 ,  391984141395376100 ,  1518581399111392244 ,  413532578165043204 ,  2305095334225359589 ,  1404442874282947064 ,  1726984299328958404 ,  735079958942530046 ,  1482817790062574296 ,  1245989632336666826 ,  2299409797461809668 ,  1090357385736756278 ,  469427790038478370 ,  1411392384053036014 ,  1377232416449815914 ,  1669548123971859898 ,  1395683953599309908 ,  1917722957912073236 ,  1794192351990352410 ,  962627189616423659 ,  1550611535483494709 ,  1023695280194583344 ,  9148254261544597 ,  462195864721461364 ,  2020018212170604812 ,  2016296948085882924 ,  271056586195514796 ,  1235421095712023842 ,  1247843779298537295 ,  1215996974884373672 ,  981611771970663063 ,  840828759613321263 ,  1795672954873557422 ,  1947592258087652420 ,  2218122178968701915 ,  1841553052014563792 ,  2068852469904459273 ,  1917250203787591789 ,  1793969512332684683 ,  656017297487145162 ,  27025288333366227 ,  1390977950776577447 ,  2004332025137061542 ,  68718548811806245 ,  176678044061502402 ,  885551028549673255 ,  1283890937622465913 ,  2242694761827433211 ,  43000377656816764 ,  1663473652475064169 ,  697749907452126691 ,  2205094342948290696 ,  980347853449381154 ,  1893654286839287330 ,  924272619950645057 ,  745041442475161488 ,  1491493748661718117 ,  1049926425046467247 ,  1516134262594730572 ,  275979491573451255 ,  2034452104466455858 ,  2255152083628872340 ,  1887162215830015907 ,  713932056588122630 ,  1140693896785687872 ,  2186177684475466112 ,  681559803226494434 ,  1821252451832016659 ,  1953084694113889985 ,  1653270502015291889 ,  1878405271209936144 ,  1238775234450879450 ,  2272555023217623189 ,  1308053210958897583 ,  1656283339261772945 ,  275345516009926219 ,  892335781525810907 ,  537254981489315982 ,  145676862996927342 ,  593320756243573948 ,  2298042826473526349 ,  409722004270424811 ,  1531810839448032733 ,  1715843525814310025 ,  969580212657813620 ,  1451894881444263847 ,  522666738089238396 ,  1672819093419916530 ,  2268381888520001256 }, // x^2^559

{ 1763365069215604953 ,  998756400121474472 ,  2174961935474068917 ,  1173945838676043928 ,  646654885777711808 ,  760806322373190956 ,  1937047336020014975 ,  1403384651090468185 ,  1854368200442298208 ,  848519550130606750 ,  1374332472951950001 ,  120159689054915353 ,  516117233768596967 ,  820908862007680089 ,  1527743669980630021 ,  936829743255260222 ,  1669771175706007320 ,  1626060385122116275 ,  263417017786983778 ,  1168426666989714611 ,  385427196923714554 ,  77512159069647512 ,  765265416198331052 ,  1314125066502465150 ,  276579268082989497 ,  1230481642615098273 ,  1426409928672910803 ,  873981500011242892 ,  347781438002841224 ,  773799993762995846 ,  1891611375507588637 ,  1183881736365604270 ,  861802091497288673 ,  1146023501151103952 ,  345262787663491387 ,  2041134426554759067 ,  104745136717114794 ,  1070299350358697438 ,  1645798928911169918 ,  429772021733691111 ,  19893790603781854 ,  1994943770321063271 ,  2230090482026123476 ,  74462453823167691 ,  1960503443508346984 ,  1780203926344018028 ,  1784958146949909591 ,  367885976918261972 ,  1627520235514346272 ,  831016905093947933 ,  200935707734904677 ,  1191829124843284268 ,  912508091213527861 ,  99359796592714146 ,  1896810054439780962 ,  1840204329152670906 ,  1125403646115848989 ,  1198504842074205750 ,  513436531431627744 ,  1278910211293211352 ,  1042274534179666650 ,  1269805303281623354 ,  1778411178295259081 ,  1100331279758308870 ,  814624289964286227 ,  1126772209666369674 ,  82453282450492201 ,  1567612777926985090 ,  1330594368199933514 ,  1809556864228017962 ,  1781545201670262346 ,  924003031618228640 ,  75135532189272416 ,  530522212299493450 ,  2004068999486905254 ,  2168606353302785992 ,  669152241905830996 ,  454719427015509930 ,  1137356694405942422 ,  1626699434048063003 ,  1463579331729775603 ,  741815359908115092 ,  2039172900693694310 ,  2021075622795884990 ,  1053268231102633605 ,  557700824644014806 ,  930244610908616466 ,  794210574943904642 ,  1445427063630124045 ,  1810120264099674609 ,  2068559184640573145 ,  1817300493618021843 ,  78119803929445273 ,  630754569823937661 ,  560116121881451329 ,  1203316949825993297 ,  630009114134793003 ,  377486833750842705 ,  2030122095563514494 ,  656014438317225604 ,  2227938555496158555 ,  2006112122684417193 ,  1716199582115412409 ,  1859441633703996290 ,  511135314734915676 ,  1471218002469757004 ,  1599531131146929131 ,  1325969632731446701 ,  1968015252078060539 ,  2218483650304887422 ,  1092335026542422485 ,  1895224278629813766 ,  1778660704659725730 ,  594635628934686535 ,  1151303091491043660 ,  1339497809029738888 ,  237785747826244305 ,  1830472467680782309 ,  1948982600147086248 ,  342227484064068798 ,  130674235122463140 ,  1218628743902617087 ,  1884217240474168940 ,  2149620760377775 ,  1652320866811554736 ,  1448540998927243295 ,  722697677238215311 ,  2142929998620939471 ,  941185224034774138 ,  74530812530861951 ,  194432393984793078 ,  1357682994531162250 ,  705353752036322358 ,  317757758527494115 ,  229678376997681668 ,  789475967903542183 ,  772635141848098971 ,  1469960701247803456 ,  1264168044603787996 ,  465209315670150402 ,  1841383337043927177 ,  2130390468270220824 ,  1351716181142771008 ,  478559800033909350 ,  1508745529779698525 ,  2056186516919266065 ,  471886494563321345 ,  1899730581479028866 ,  2211038884834825369 ,  198437958085180236 ,  2163276826817249301 ,  1537447520000986985 ,  1339091396682114106 ,  893572027248722085 ,  1342682625187034236 ,  862495005971887491 ,  1713890538616190778 ,  2188583692845704012 ,  880886257085526419 ,  590398180937105502 ,  112267659567921498 ,  1689169092128178567 ,  960073551686922669 ,  1617069461674527168 ,  851641127206662127 ,  1327501877442290889 ,  814205049045375969 ,  1290833728117467182 ,  2288796019523652963 ,  301354848209019886 ,  1710248405779825414 ,  129937427459112121 ,  1065423211614658709 ,  383146348584385191 ,  1592854374801091222 ,  1034003624741974062 ,  1578751685535941134 ,  2163898363831988862 ,  1550239167894772520 ,  650438267514253287 ,  1497453897475093343 ,  52714747104202492 ,  1337409646650818340 ,  2116986977670962899 ,  1916971904696230326 ,  559778993478684988 ,  1098730212771348775 ,  1200524400154093418 ,  19622872131886800 ,  1661928778877902915 ,  1112809342110061265 ,  960306408106390336 ,  490348279082962296 ,  1403240200738557854 ,  1661187942243904318 ,  676452705637070312 ,  1583000320958187991 ,  1183224370230265190 ,  233658338565130017 ,  378527327757210838 ,  203074796869258022 ,  466121648673947454 ,  89934555473970340 ,  1808320451614343523 ,  661831389747275281 ,  1012468348426249977 ,  744925940154105947 ,  521929788856147521 ,  1714821776030640647 ,  437390544878871514 ,  2154283022132429826 ,  881079728427063801 ,  10820864749372624 ,  30872773022483650 ,  2172177239584179979 ,  317369561975838235 ,  488172346449291585 ,  1451119313387594849 ,  1978154503320521382 ,  259518139062559977 ,  1641054709323604085 ,  2090343904966101526 ,  1327130866249345315 ,  92528780348091945 ,  1951595967886500861 ,  2200280460887517985 ,  2127441186809887733 ,  1691232832285258916 ,  836467861679148236 ,  1116071045476419776 ,  1285162027135131180 ,  717578656005522774 ,  503800911791757135 ,  1292228141709765230 ,  1968005112430150466 ,  190626361778262916 ,  2304914098972111801 ,  1862523615367836459 ,  1247935099142049801 ,  274991818640392749 }, // x^2^560

{ 1736498356256760876 ,  1025660140124567360 ,  1756130591017030835 ,  251358227010589494 ,  1748534600204327353 ,  825064513746119343 ,  1054743878161399872 ,  2257480801547567714 ,  1272482715513757125 ,  1345638754524432609 ,  1660800280323096565 ,  2017369822861014353 ,  53774846272103119 ,  1406787358281222135 ,  1589877577395398489 ,  565771501913535779 ,  1741976101604309958 ,  703474804969898517 ,  1832432872557245422 ,  405463925692749160 ,  534671884736714687 ,  1312895828658562214 ,  2263272926523109891 ,  450808066728496184 ,  1736534156514794123 ,  617799036970303011 ,  716979905493961811 ,  978552761133871045 ,  1912970609313114560 ,  2070863114289971606 ,  13129563243978886 ,  803924273577905317 ,  166335760056295664 ,  2010466527961620154 ,  1838658318050666443 ,  882044488245546615 ,  274439361231866877 ,  1984271634246685730 ,  1029018748766092266 ,  1462884464543038879 ,  1032269481637449351 ,  820585665077979006 ,  1189809560394753662 ,  1495842095434519738 ,  1572167953497370586 ,  1319567152957975408 ,  1756682770827400084 ,  871231335981464326 ,  1533350422022708229 ,  449549609304056822 ,  1018712399400179361 ,  1666010045734112564 ,  2203760922673068658 ,  1962392988076046964 ,  201846891090551914 ,  2243732535413366763 ,  1299537940057135440 ,  850774047654866909 ,  1626894245900947286 ,  268002845967734638 ,  1711446644286273767 ,  383255279390231839 ,  1298426393884782888 ,  1612886999518094277 ,  637962922673428132 ,  1725604765511685594 ,  19042470770035553 ,  280652269245725552 ,  1929794199284076540 ,  550519463218172710 ,  1797049549748503811 ,  1535717125876773563 ,  921143839272484039 ,  2153419007744255475 ,  119682717606122704 ,  1491107136952881599 ,  493756013035923061 ,  430147828649937701 ,  527133824539682958 ,  776041003501479778 ,  44527932701230493 ,  2255107383358412230 ,  1913850755911414759 ,  2002538688909847805 ,  705412621041463470 ,  2262607415915183642 ,  102259085213798324 ,  550567647509696442 ,  391101614337111446 ,  2054890080423531748 ,  1364611008967507423 ,  1930212480936225239 ,  881183811831623285 ,  4302650658704298 ,  660516378392713754 ,  2181831611265970732 ,  1380295139922067219 ,  2161742088805173055 ,  1106372185493396701 ,  97566874705121021 ,  959131953415706824 ,  265875138879429472 ,  12069629251458110 ,  72597490895734477 ,  191395733935576700 ,  214980229283043753 ,  572103656266154693 ,  267336060518534499 ,  1760802864894231646 ,  679949721481920742 ,  552276970571916680 ,  431978176070318889 ,  412029250725895050 ,  792590558157007712 ,  1933374925153184364 ,  656785775416408034 ,  2158692289175139142 ,  1513719022043778959 ,  2291284225883597043 ,  2138436044926917424 ,  1542410266507905607 ,  1050243921196096072 ,  1530985801481332382 ,  65828944943528296 ,  1122339095359868277 ,  743969759362438479 ,  117207558054662993 ,  1251334298670460548 ,  1504511938888335641 ,  307328954456093074 ,  1888027620573744995 ,  1793110763656246516 ,  1943060979098505001 ,  101780792249181247 ,  1940174400347785135 ,  2119997497710241973 ,  1042513803664766317 ,  948200305753455439 ,  1325785086825863046 ,  973331851921462221 ,  727433272565226982 ,  1020238934096961004 ,  559598147888329737 ,  7003064284077779 ,  52661826932795532 ,  1458705424517097246 ,  775726936873205673 ,  2163310211428514857 ,  521433050446989809 ,  1417929099125087294 ,  1062683098700315692 ,  1343859088714470889 ,  638873020386595928 ,  1595046376593647445 ,  1135281583538842865 ,  2295356697445985684 ,  1082361906683800533 ,  789471600529304225 ,  2037601935101553018 ,  440414167885257117 ,  1491922195022429442 ,  1286788262306289427 ,  1709487696293198991 ,  416296198862166288 ,  1592275689035207960 ,  618258084101164405 ,  1068488609338418998 ,  182841484520718359 ,  174617220668608956 ,  1071070762047293981 ,  758239787665816796 ,  1766156489481864534 ,  840066802285138118 ,  1912802709510228383 ,  565975608999570159 ,  1528694052971049022 ,  2285023984282209516 ,  1961816390341806882 ,  1740388083076651125 ,  1572425348285432662 ,  1511396704537120894 ,  530353917280839629 ,  1647356167285307798 ,  203572709784793911 ,  2011879981418637428 ,  1778592949620886793 ,  192408635618185177 ,  1206460714073231352 ,  1226132874286604968 ,  935238403331178369 ,  79380313777755653 ,  1307166550421626884 ,  1227476964947497601 ,  1912050624745453442 ,  1406608104557291876 ,  1082592084898600963 ,  1870794205486954077 ,  1965246221500987186 ,  1351856290643259119 ,  510839677174212002 ,  1728197032284466641 ,  1419636962115772710 ,  1880585316273618234 ,  278839160693096873 ,  983714875845522897 ,  648592412231507397 ,  1610534524930746069 ,  1145110547103020579 ,  1976384718108700522 ,  355979539496492825 ,  35981311629902827 ,  1561798769522930791 ,  359459524513262369 ,  358044111992738083 ,  749401056448478054 ,  511034247448030614 ,  2263213702486988910 ,  1709738618017394640 ,  2038039982927968045 ,  2100044776303084109 ,  1134738765837856656 ,  135532111126581621 ,  464687176108140081 ,  40806238800245710 ,  729667722925803457 ,  1531718726316400555 ,  2273797683639381049 ,  154566058645844687 ,  56251768094158944 ,  1308489356624666383 ,  2186016833421770704 ,  1386858611340755799 ,  236069981734014917 ,  2000952616899405537 ,  594810572622558082 ,  1704774429521495677 ,  1444709245044523928 ,  1642739850369609989 ,  1064322353041810671 ,  474996830568881057 }, // x^2^561

{ 1314277971546790892 ,  283259707048004914 ,  2287769935056333759 ,  1533079371914170420 ,  2090956584606665176 ,  1031766389918397599 ,  2015163850255340148 ,  163422682576112155 ,  2128038086512728621 ,  193586925286014539 ,  268483887217885142 ,  1771064343677125182 ,  1382054186168082782 ,  61924722126439210 ,  1855328565422941672 ,  2056132513126649519 ,  1210401482010801359 ,  2246019013305550871 ,  960692036124015550 ,  1723542522519954767 ,  2130734603682147426 ,  1033474486191420935 ,  2124372205151039864 ,  1846746077925106441 ,  1593480962043069701 ,  1218782731522856713 ,  1008662155918821610 ,  756867438461101203 ,  1832725308047255923 ,  298731028916834350 ,  1186896908798425706 ,  921183173152578256 ,  114543556430942701 ,  15635998430971540 ,  446713912503063036 ,  99329737282791472 ,  794765503931874670 ,  2009930541840330767 ,  879819788853268844 ,  1901491059082503513 ,  1272153468708045773 ,  123100126739489325 ,  767774540496076808 ,  1428123206824784664 ,  1258370610474731757 ,  951294371948311174 ,  1823922790030202057 ,  866049112397129353 ,  813131424988067592 ,  1631526239833597766 ,  966883010935009054 ,  1792214383204039510 ,  2154458545459948322 ,  1812800681292745186 ,  582699262693378453 ,  527847462161196776 ,  916835393164628925 ,  52057556248070688 ,  106234083393310625 ,  1665080711952317253 ,  1490054377550975505 ,  1023701001500903221 ,  1028579702092816644 ,  799096447780709327 ,  1769562043088972317 ,  1613492503576603962 ,  1102617212579687827 ,  1932833647602529412 ,  639360221755846062 ,  149385279733579099 ,  1130074652889294670 ,  2050061360021935755 ,  1026974124997503939 ,  31005969043509618 ,  1315054763767132378 ,  1531765972763759821 ,  54489609443054131 ,  457514356605746382 ,  154949063345510740 ,  1461224430847674922 ,  1383418469482937236 ,  904474041601383967 ,  2173912673259187471 ,  248000424269419118 ,  1862937365754326203 ,  168726053179306028 ,  642603410907975787 ,  637422975645531207 ,  520614098904678645 ,  872865872523077573 ,  1740017110204626867 ,  2151099281318798693 ,  160756787094555799 ,  743969960729660569 ,  666141256661193504 ,  1965120215418504172 ,  1766686253412636379 ,  177169260181633526 ,  345743876256925403 ,  1175405029107157541 ,  862182353708505897 ,  1410445661977290189 ,  1946454609225861803 ,  552875169345502441 ,  1776233094178100069 ,  1235515121804465449 ,  2074172863726086172 ,  817612973760830303 ,  2026612562434755647 ,  2102107481790912256 ,  1243862824652021332 ,  1781074031158388754 ,  1309138828749292801 ,  2280863446118201185 ,  605831157358804412 ,  598604345509733018 ,  1761716433393709676 ,  1091653014727644566 ,  1059159838227924989 ,  1720985123943603618 ,  582093543656003377 ,  396922700791183971 ,  1974229431423204322 ,  1803842258721318110 ,  2091498624331194092 ,  2037835453749634052 ,  1667717516319994834 ,  153677763293934702 ,  719308437726596114 ,  1646422146076119489 ,  1192297299187349498 ,  96223910637206779 ,  1065296895360215146 ,  2063615233648606343 ,  1956493178716178710 ,  1774762572516689809 ,  1600592066975090238 ,  1142752559812924731 ,  1133562440628770578 ,  519074165435350095 ,  426025584857503910 ,  1256022613909370716 ,  529239672088466125 ,  2238827253350130768 ,  1854306107163719257 ,  1378437744649210515 ,  1761854099956281831 ,  2030771073999593499 ,  1980817198812454017 ,  1543078298281659994 ,  918938223539802720 ,  827163878208053932 ,  1031431148389535886 ,  358703572557104133 ,  2198289352406916479 ,  1285434116035354307 ,  434960610458335334 ,  276545110367259534 ,  1946311708988383215 ,  1815337394772833916 ,  1683119313933801540 ,  131276072472032847 ,  2000126503940242492 ,  377591469129846404 ,  621432791305923903 ,  269974805171231870 ,  2113093514486236017 ,  75838532253523496 ,  293003556017861924 ,  602507439859760197 ,  1354320242019873000 ,  39974489666713775 ,  1305369827401920097 ,  944556095006848718 ,  2001617827314631680 ,  755140560710103283 ,  1232551025304758180 ,  684835169359253692 ,  298882597064460324 ,  471586713338388764 ,  1350197487842268771 ,  1861395332507904964 ,  1221150353078418523 ,  1820530465796740324 ,  1757068829118138271 ,  1794597388680722592 ,  1397243268805198429 ,  108378481613174295 ,  1639224021399821002 ,  1238331343216630598 ,  841323397419933124 ,  337489570497277926 ,  39312645439580765 ,  1023152577898404176 ,  649045532815968285 ,  1608840455241032818 ,  1603278402869097532 ,  2253703617351786364 ,  709470885036609181 ,  1447265560917173737 ,  710020349670013158 ,  469309532152092905 ,  2057881019747142213 ,  589935503866834500 ,  1348288471225738279 ,  2159757449392737565 ,  1750646663600101726 ,  712752051982173545 ,  712759597832861411 ,  1110374941697411123 ,  987549314665285364 ,  2236596474816357025 ,  254840124286670862 ,  864572765206980346 ,  145902052666578132 ,  1824079891127430641 ,  2210592566133758000 ,  201822585672888836 ,  253431260904518970 ,  118152699772069132 ,  1423829053813299664 ,  89113975577547904 ,  753339110300364058 ,  176192735632903215 ,  1209875166377024066 ,  15123623807286163 ,  2205274663139003712 ,  130523286345018444 ,  1272963629375020634 ,  909941457571100606 ,  2176977116823021454 ,  95080699664076940 ,  769435485501094287 ,  1777168594396471806 ,  358392888222261116 ,  1555589971534001453 ,  557475262707420183 ,  2271536472750958975 ,  142748997507453973 ,  966985810538503562 }, // x^2^562

{ 474011625747633271 ,  561633649451135872 ,  1518361596930154725 ,  2174090689240273961 ,  647662408243613098 ,  861027072021103427 ,  2016630103061284146 ,  1892388096425118028 ,  2217688997328081150 ,  1829295432852832517 ,  220672458837506316 ,  1286155303526014486 ,  1397318531589840732 ,  1674174975971032836 ,  62088687920525036 ,  1364532822009228269 ,  123802020950263064 ,  697071982869478761 ,  1929452070463929679 ,  1398091086643542281 ,  644701917346698926 ,  1594220521642655985 ,  2256160270621065369 ,  2279823840595612490 ,  1912571217227975954 ,  160720819189993716 ,  742258970663558076 ,  2008951493524210558 ,  884650708003984570 ,  355758060699306544 ,  961913080655888297 ,  574301623418764719 ,  2036373841507682215 ,  1442151760823418654 ,  473577726712891122 ,  1624230412808250581 ,  1736156302462015193 ,  1298126738644865834 ,  1678174184380136742 ,  1822411379712491768 ,  882412728128760603 ,  1235803998019045467 ,  2085377328087682725 ,  1500578210235126690 ,  136384548264986327 ,  2250633454379996411 ,  177550753549158288 ,  285770679714566321 ,  1229992859005730606 ,  1127141634391958241 ,  2265876257697452887 ,  1061520524361986971 ,  1641521504497740180 ,  673611586936408846 ,  314940572581931041 ,  1185078185368661777 ,  2111416848774160206 ,  721294014660193321 ,  369239224000531237 ,  75282186060922748 ,  2188000246957766489 ,  1085733915625835232 ,  155213084298221822 ,  409637102875965671 ,  1010452948259684387 ,  345481722575637866 ,  2056999752375576718 ,  144042630335098262 ,  489380665280951537 ,  239164777320468021 ,  1229043418891230255 ,  2215757964117862927 ,  1571841998990079786 ,  1603515524350195358 ,  153051251272707846 ,  2156457429737714169 ,  2075510820236863205 ,  1400733456969094670 ,  2239586623203421475 ,  469978344893076783 ,  1408652338345915987 ,  1053636726537970413 ,  127390052075741158 ,  303162486845259070 ,  367653040377237755 ,  1426126940352466852 ,  839234564008188394 ,  453100262583494712 ,  14247206441464378 ,  1269567647109462153 ,  1158159551767677583 ,  411287118451767702 ,  1519784519722160480 ,  1812405463604568975 ,  2227026280438221658 ,  598076157362175115 ,  1337524178398777854 ,  1280770122146272344 ,  1546109936872747373 ,  1642521880495838561 ,  1422006391069458745 ,  946941419794627210 ,  1000538387446121852 ,  1247823243630584957 ,  543759838072203904 ,  1399234384514051530 ,  1663147935337839051 ,  1493358630446718300 ,  1881656153418920136 ,  10032818881525682 ,  1811120074630990532 ,  442066904407779217 ,  1211408587965793904 ,  1069387673810373153 ,  336996931440199643 ,  367744519392228273 ,  1244415499979697753 ,  2001909563586398523 ,  1570454167351759795 ,  492171050861155283 ,  1460033989736239895 ,  1978303193834201407 ,  2107226483460177309 ,  793331757893956146 ,  1972639728015508163 ,  1934528211755945953 ,  1862085289832192678 ,  644824371792866879 ,  481271784688690955 ,  1959039005642785657 ,  1535951049530580355 ,  546549419627145589 ,  945341216682902878 ,  1842789738928773532 ,  242590823132671916 ,  2102166905658767904 ,  2119924226541892570 ,  545300433550193136 ,  1178928982613919319 ,  2111531054826259314 ,  254246332598086233 ,  788295618913502838 ,  275700060271887632 ,  55883402291383895 ,  1698033382669837753 ,  1793705366841495504 ,  1720457489430062976 ,  1869651701871612382 ,  995978263631023645 ,  352893696121104429 ,  2116254833607076505 ,  505330006992201977 ,  1108661002856917627 ,  80904649382155120 ,  906895110626172082 ,  1881571714800024635 ,  1983480921480391555 ,  393286637432722629 ,  239301524467548817 ,  1798010201365111826 ,  197801330150154516 ,  571485302252660229 ,  1683256038791853265 ,  1288876033952104667 ,  962909731281179070 ,  940000674718922138 ,  900622874057664393 ,  1285102190805881370 ,  482772736421613721 ,  1827425823003102013 ,  230356157295193075 ,  1280756524883981484 ,  187778071352472292 ,  1189935512316947099 ,  1303555408703416965 ,  1921382529453705490 ,  1885731079204634921 ,  1085936646161759527 ,  615731453812352640 ,  1795517317181577816 ,  23368412596517061 ,  200369825223062893 ,  1527712470197258805 ,  269986800301257713 ,  1573410855144878305 ,  239854207167091234 ,  1134123357824703390 ,  2081877410789784209 ,  1826346052852261391 ,  1111966911254181732 ,  1318054922694722534 ,  1010835945509628969 ,  369434291911419805 ,  600450265866845419 ,  2090694942849405485 ,  2273950023270531171 ,  647164154342612834 ,  824253634545439386 ,  1374746009642773928 ,  2286025810371300295 ,  478781349898790709 ,  1061380594628513653 ,  1820714453773254147 ,  696649318221666943 ,  2050277525833250894 ,  1293131238080310611 ,  1321643550910575969 ,  2143901739074798968 ,  193260263482127012 ,  192052194085030884 ,  1563019312391850329 ,  516801684386387510 ,  532020400259939316 ,  1057045464550275903 ,  830031166205008428 ,  1488448038338581405 ,  1657339084137323106 ,  554986830816802635 ,  2251515745375788511 ,  1472917127979626315 ,  1579345133145919457 ,  1070380114877703768 ,  313822873471112251 ,  489800572262128615 ,  1397138938221950781 ,  1479814618154091172 ,  1045220400915218566 ,  1505318487370407837 ,  1120133895676898513 ,  1479780095431708907 ,  942687335150460581 ,  2192768313085374888 ,  1804632813400253856 ,  907118510287988037 ,  1326903192995050664 ,  2216403355863359884 ,  601670954973017305 ,  2248381219992545009 ,  1153335721773922658 ,  529305675159920169 }, // x^2^563

{ 1883711895241229009 ,  1105494755403150495 ,  693558660148497272 ,  206178922873819597 ,  1749604328544439718 ,  243717086990229454 ,  157307889707504345 ,  21066884006707882 ,  1829362343407726415 ,  625167549953656879 ,  711990195675444970 ,  865813500644411238 ,  388209273907645195 ,  1577390872747379803 ,  1170866361357248952 ,  901848869184952546 ,  1886799948104109911 ,  1645322044564964302 ,  1289555216446438804 ,  2119174567811436561 ,  1520239187304982652 ,  1064262999036700857 ,  1283679069970314368 ,  1167691174454310730 ,  1520935494858371074 ,  1099206750699121903 ,  2193245080128321893 ,  1718889138353621907 ,  2085997934786263774 ,  2123399949796426561 ,  1214066568119774487 ,  947273032910607499 ,  673158408073666412 ,  1599727915173682453 ,  489011121476115083 ,  535179270850402684 ,  1152916640006018241 ,  226359200200022730 ,  988259556642672805 ,  336260322019893740 ,  493013219030006033 ,  982740246562289754 ,  1156247446404250360 ,  1321880065530452729 ,  1817306707363593428 ,  412437650176149657 ,  1522644320692722945 ,  1453450981252435717 ,  1087870080503960932 ,  840120756487523365 ,  118664274176228269 ,  2054548228474641282 ,  2270903745846053454 ,  1734472161765370718 ,  2166428930333056916 ,  576653254660909290 ,  1140607282360082283 ,  1651284900473659241 ,  346891550640655008 ,  1792587504636585712 ,  672087209628100566 ,  848936513599913039 ,  1569038949187747548 ,  1230659976172360754 ,  1203713665122585759 ,  2016796719142818796 ,  1961463064286144676 ,  2188869377169048759 ,  2266821812007301471 ,  1804226765558649582 ,  651164174219489271 ,  311006304077553676 ,  1666225819839731165 ,  238235920424262383 ,  458038843940876382 ,  200811710949768877 ,  1513728664860449305 ,  281026084041588206 ,  2254168531969123453 ,  1669815852771955748 ,  1825501988415049572 ,  1026044660611161954 ,  614943392254520530 ,  250557472327369996 ,  1533657379380590638 ,  988681622119508962 ,  817708479407182712 ,  2050289530181755756 ,  1651900730920589495 ,  453282611726357833 ,  753012382281963203 ,  2133762905139146364 ,  846499582740417646 ,  2127374939648045158 ,  1765919724556637559 ,  759062063094959080 ,  1752255550443803772 ,  1050256937307405188 ,  57635782524438840 ,  1143257914284800811 ,  2248210355276197172 ,  712932187803424190 ,  2228773011350595885 ,  2133461903828294778 ,  340157745097917474 ,  1225825959284621417 ,  1234334982544609934 ,  315714138008321583 ,  723156401306767162 ,  95759769032191190 ,  1415728453486071427 ,  270862462116810943 ,  606734557064583372 ,  769676564389176917 ,  800011264752219776 ,  2017861857440004981 ,  1866907036964502470 ,  128547466841104348 ,  2195020672981629155 ,  580051042987602013 ,  521196423564011148 ,  1093020330468842812 ,  615426420660826617 ,  1452112686448344695 ,  1417223951391948542 ,  2053427096404504066 ,  1449241572693916898 ,  790097699303721297 ,  1762502249726704806 ,  1057964698357858046 ,  152666895203650612 ,  808712624639851406 ,  434550742979395091 ,  296725831194749185 ,  714621874738685224 ,  699619204265883811 ,  146866759506200985 ,  786937362744548994 ,  781634063390122401 ,  1439597993020973742 ,  2016949619513950101 ,  505434273980609138 ,  534016939370744780 ,  283623737028966774 ,  2270868407962136648 ,  1902579749668488406 ,  413585211002349342 ,  800435844546995800 ,  1401585389604606040 ,  89587150118210301 ,  1873830326489089482 ,  791856842573776576 ,  1576941397472873352 ,  821370745794301617 ,  641080993235141970 ,  1964131412933492648 ,  1723748822752646735 ,  2248159423336599071 ,  1451431956195685432 ,  1312195746716926701 ,  1082638070259971176 ,  1560647791682735211 ,  670421496439823933 ,  1956337788774412225 ,  897919649815773947 ,  468283954192985260 ,  491365083016124978 ,  1659876006557864875 ,  1711733659147792652 ,  1814704396631384120 ,  2117092445056524874 ,  201989375399594424 ,  1635046925385084398 ,  488821424872257380 ,  306584450479556523 ,  1394856269208244965 ,  890815732742196319 ,  2218327365845961168 ,  887356917556201723 ,  1665449037859966301 ,  1249752604978138955 ,  815198567399554302 ,  2126200599785921132 ,  546989687332818752 ,  1335609783321432196 ,  688214785068109690 ,  1356155394738816538 ,  1406571296659839125 ,  539213694725151762 ,  466640457724586923 ,  2068770771155510085 ,  126420605104588936 ,  1649801675925377877 ,  1095623653827890107 ,  1661463390237505254 ,  731966031525635886 ,  1594060062645145855 ,  1543653310030720828 ,  2030653055446822212 ,  37183515981599597 ,  485695919316075865 ,  1600784403014405468 ,  2079896783460554290 ,  1890973378696880838 ,  1547741878786098240 ,  119696257654553713 ,  1129357917928740698 ,  558958010559155041 ,  1763972928638968938 ,  1861270759586753504 ,  1880683889117936995 ,  1253947866323619174 ,  557851458396348421 ,  230827192716225164 ,  658176876390482631 ,  668928323607577385 ,  1618034338434978558 ,  1321503206854987460 ,  1297400245880020460 ,  455923361034753437 ,  1113867189423467373 ,  1244654556244889688 ,  1984248999676284947 ,  2109150680273091918 ,  2257025195640434647 ,  931605843644969946 ,  1616011489445240402 ,  535608186116609785 ,  1211380118739311752 ,  2234767144667797853 ,  1742199428467752910 ,  2108197455617575072 ,  631249432456801659 ,  1768976422046164064 ,  1873779022054384765 ,  2094197828024622502 ,  2016250954667209530 ,  558293236704456365 ,  459092000620390046 ,  131691648296911979 }, // x^2^564

{ 509727112194198848 ,  2276721405179710567 ,  1768439981384034577 ,  963044934094767355 ,  838104686535014413 ,  2187729958539941755 ,  629251223235233884 ,  976741528966725045 ,  200724099339561638 ,  134137516502549474 ,  2287171233747014245 ,  1231760474674567614 ,  217894342429490728 ,  150694333283598569 ,  179755988444121451 ,  1710166565801712694 ,  109455755580356812 ,  736972456984468509 ,  2292037913190860106 ,  2041180427878275945 ,  1016398629630617580 ,  1748733977821204084 ,  614015973519821566 ,  2075713316727044998 ,  48923062906884284 ,  2241383877091235549 ,  2082222366498456746 ,  523838002062734203 ,  2270922623750439236 ,  1804401639049174714 ,  1022821219049077067 ,  2198977418470639750 ,  410255671224427550 ,  310962633858959451 ,  1902344092869163525 ,  2191806375732142186 ,  584121346086900797 ,  967721418954609142 ,  260116350480338575 ,  730785387000356782 ,  1573554696463464531 ,  499214270293389061 ,  1550124805090572424 ,  2101031519664102640 ,  803814602733296900 ,  412375535923895112 ,  119174907226486862 ,  973168474001169478 ,  1122059123461745904 ,  1926913551445302367 ,  1760198857246421721 ,  742932532441391903 ,  2145058529048345354 ,  269797611033328397 ,  183062932172403762 ,  1469059143844854797 ,  840705475290853292 ,  1251571677333716601 ,  593744700931184061 ,  964833841973161541 ,  2027295018862191710 ,  1870868558157845777 ,  808164753000806309 ,  1078000987085726101 ,  1579803950102990495 ,  877361019726980971 ,  1117521592132853528 ,  850561182893477570 ,  990670884188481537 ,  823669956432103510 ,  56908426962319406 ,  1690453880303727939 ,  607991325872913729 ,  562414043112139586 ,  1135753923681157373 ,  44418190845241617 ,  1788294807535092052 ,  366157324693723408 ,  1802911493180501457 ,  1523037346370065525 ,  2200286928025001652 ,  1684727857368551676 ,  1066687139810743595 ,  942680053084439728 ,  874429539468260752 ,  107138889983567733 ,  481866007568627204 ,  1094134711282333764 ,  1652333006734915522 ,  1526204080797977559 ,  1305883453638208141 ,  883005576018179414 ,  1964185525296441852 ,  1978043529628695648 ,  589286002651553883 ,  1649776047882124944 ,  2128569954565814214 ,  365589006869536034 ,  9195590927770 ,  537763057252902668 ,  269961541378256985 ,  1749333499319960820 ,  1011033564287467826 ,  391561946886152522 ,  610580225140402444 ,  155936359347342131 ,  873700109292141974 ,  2237403821174804115 ,  836075498787513795 ,  1425613267420766606 ,  1199954996120158985 ,  1375662089267155511 ,  709180740700430517 ,  604160352327225815 ,  817959638581598488 ,  486185011752876497 ,  852776724304183955 ,  240280335346487698 ,  765811302746580712 ,  1047055654681524038 ,  1634338767969427200 ,  16384891342132125 ,  478495572354554450 ,  551152010343579776 ,  2027077979450094191 ,  195310856597342680 ,  588345031319841302 ,  2304818080524767436 ,  482282053009698565 ,  716412450230858901 ,  471268286292782775 ,  2295524238593605481 ,  1727179908670933333 ,  116948550179372094 ,  565779646605722598 ,  2105145742866272046 ,  430303127600288849 ,  850792634014434302 ,  1402733001451804260 ,  1040931539891875291 ,  1058764318115033918 ,  355049273228919508 ,  1903959486405453061 ,  467348789504031712 ,  1689611878774784576 ,  1445170277932662202 ,  1708138886985742441 ,  287782449187169435 ,  1567824286451289940 ,  52603216845890330 ,  2187721625737277846 ,  3722675130675562 ,  64476340886218034 ,  1080034573960882389 ,  1298436424860931947 ,  1307228908324449865 ,  1770382556837996891 ,  2046888043122433325 ,  1391761946925742543 ,  224783498164068297 ,  392564098497221332 ,  1827942275791574914 ,  414025172245387690 ,  708650857317790511 ,  2152600596330147604 ,  1975670464921278567 ,  1345934394223020561 ,  136808193036145569 ,  1231428882170586293 ,  1000331969101202153 ,  43651141607532456 ,  2265496055872160139 ,  259630997948868091 ,  1023317620573033416 ,  1238124214910437314 ,  1638364201445858804 ,  127505550817578681 ,  69429185032133329 ,  819191601511761640 ,  1350506915189689684 ,  1779697208243687500 ,  1351835461001042716 ,  1809045276738640038 ,  2294083556292160727 ,  22072802896201698 ,  1585360259919387294 ,  322449792243557911 ,  2303427176915715978 ,  1984113189667908099 ,  1511228952705390550 ,  1421699987831122738 ,  861541722744473447 ,  811307318403731627 ,  2188079873546800504 ,  1867566767998959787 ,  498840060963168865 ,  61267253242103178 ,  1683201642907617704 ,  1300850904185528713 ,  977539780420655190 ,  751732996594324247 ,  2053967637505900321 ,  1368959249326008080 ,  930226396254011158 ,  486019340704546928 ,  511770912987307262 ,  882440337881476750 ,  921655638461195623 ,  951513861243922932 ,  522100734877161211 ,  252320709103967126 ,  680265143201425403 ,  1396975462102251691 ,  1814273202079782383 ,  565824650737022496 ,  909924334028423192 ,  1235389537424584639 ,  1141519728051440717 ,  1325911581660448042 ,  1267404225910042724 ,  2011561717292075464 ,  1013581185215322440 ,  1968465018452988142 ,  559370744638049089 ,  1016832458800565164 ,  655026582972120924 ,  600473667369578345 ,  1563626557993594124 ,  1816551067149543052 ,  810183334950548259 ,  873221297062171004 ,  1067242729395778811 ,  93340813727864925 ,  1051566492858193836 ,  1288888827250793862 ,  760417019760675054 ,  1051496275250949321 ,  1837109345318708597 ,  20328208985386951 ,  572635495792094427 }, // x^2^565

{ 343376086277431038 ,  57104196266818549 ,  1541877993547772479 ,  1997092269462095776 ,  471401985595668137 ,  1535314896400757782 ,  2018114791657225896 ,  2278420437739998410 ,  2080035709189189217 ,  234360396042840213 ,  1993108943090746027 ,  286220737157487412 ,  1419021873401664893 ,  2178152181841339588 ,  428668007393260667 ,  700052223418213595 ,  531554076658389534 ,  1503405651303710128 ,  740488787888630184 ,  1163528102476798966 ,  2103007770621813601 ,  405695387875587794 ,  1596791331052531958 ,  702209081338267039 ,  606549495317923474 ,  795065480710535132 ,  615930075761461622 ,  751388064123218410 ,  1427918284794048484 ,  1234769657386238986 ,  2220916693873151556 ,  1958037548788362691 ,  74181432021797523 ,  14148863489240827 ,  2114336744958144939 ,  222142356913749621 ,  428525715168126441 ,  2122552170125526159 ,  1834441674943495299 ,  1043554801222568408 ,  1896390536639601062 ,  332780189865973074 ,  1323233665753380409 ,  226268869264523567 ,  218220108542787312 ,  591106579695194662 ,  493898376507413347 ,  1305084109469347728 ,  928955076726659263 ,  195792660507677015 ,  2016777300330327818 ,  1245018734311477861 ,  1440698317536339781 ,  1046097363159137973 ,  97530554496882168 ,  1378959926820408168 ,  1526330125833166578 ,  949054188653559931 ,  1456141501750794615 ,  1901607749874952726 ,  227673246125660520 ,  1708352512046055296 ,  2241964514823928241 ,  550159915928633024 ,  226540071194901139 ,  1651486697328663858 ,  1864562023566627581 ,  1201211866774839234 ,  72850749124796458 ,  195541401795496298 ,  1947075422501787345 ,  1140747165941517214 ,  1078757964922010805 ,  297611567956183173 ,  1231112652074386448 ,  564446041461841977 ,  1135199361234392056 ,  2193728916568621189 ,  390805644303769464 ,  435197963432151627 ,  1641292794108218224 ,  1273111009761633884 ,  1441800341889308488 ,  343683355459978593 ,  1281182061253082175 ,  177506468891215342 ,  43349305863821436 ,  141653440030926930 ,  1175335504448493967 ,  983494825066734219 ,  1498850911364623396 ,  1516214515989953715 ,  2182217362687393062 ,  1141043324475978493 ,  2256788714426469004 ,  710658343607181405 ,  312674892100622910 ,  1281169458320270751 ,  804557218956237479 ,  1316583349996273859 ,  85377764814740091 ,  428387888044146771 ,  1997242540357278918 ,  2018236605337700829 ,  1533127507298150835 ,  800783700757200784 ,  1630646192907553044 ,  132606878220780896 ,  2293199530535343189 ,  1010499334793747097 ,  617599214736026098 ,  1066630634135969220 ,  1231716314659113758 ,  1497526986507218783 ,  2299216661001530935 ,  154831296011862717 ,  236234526807645930 ,  45026539038972343 ,  2298352618192117092 ,  262789743331261434 ,  1308697561070440318 ,  2140619925738552078 ,  618329233033935990 ,  408492424370776634 ,  1628409493911435847 ,  1911262081943605956 ,  1201497757331555220 ,  1515836809693860282 ,  1556816307287877543 ,  707408769380667801 ,  387631574324872785 ,  727734023709739262 ,  1806186913583213224 ,  381517340801017538 ,  1565361837241679970 ,  431336705762115307 ,  2080779004811568370 ,  811096979345874365 ,  164553760531775606 ,  347628657754247528 ,  207633063470231637 ,  294676725640718119 ,  978424333714878533 ,  464019738017586808 ,  1210784785422164589 ,  1865176449412838993 ,  868577958363695875 ,  855693269290146855 ,  1649772339049342744 ,  204663623968639565 ,  1390733442519574597 ,  2185298498224451133 ,  2238214753029135507 ,  2232196731494908188 ,  910957399435514602 ,  1503611636819564935 ,  1505563090951051143 ,  99430211311684989 ,  601677087379511991 ,  1608969168365673377 ,  858030574405336097 ,  313214653839445772 ,  1951226647325324979 ,  1148430179234885373 ,  1357787664212610339 ,  1352752946029877720 ,  932911852956345504 ,  1910823278710789147 ,  1715604660297255922 ,  1464802626819459379 ,  837997712380988409 ,  382081731396897065 ,  1957796529672939287 ,  22841511827664156 ,  435150120301271679 ,  1152303728265819731 ,  627737041387359027 ,  1382893418189901269 ,  1097997442641224433 ,  39389020599631444 ,  1163551596722490425 ,  1898465054522972045 ,  476528411636326254 ,  1714913847885805060 ,  2136619743813211512 ,  111494237257573000 ,  358322516526780531 ,  1468124877874328970 ,  43387234063539222 ,  53267892520199043 ,  1440393543376208155 ,  1066819286838996359 ,  772600136308021519 ,  1109304414356877311 ,  330314540259734381 ,  2227549049806769384 ,  473859520520012338 ,  1596111436420289021 ,  740860357993312846 ,  1452017726053991358 ,  949051192768864056 ,  909251622214910893 ,  1264784081250501396 ,  223597523409438114 ,  1763323759232459145 ,  2133303935262374321 ,  868319750209568054 ,  743559393305460211 ,  1387452134096097168 ,  652332989702483130 ,  766761399284097955 ,  452984042560745904 ,  581222131075855571 ,  14537393915866369 ,  1154875378557103694 ,  90244177721010790 ,  1247619562145403573 ,  1418164728976171870 ,  2292152995525400696 ,  1704873870496120039 ,  727721728491609466 ,  1996017019448064455 ,  194640085393200032 ,  337016582691866382 ,  653691841871792597 ,  1468609642138371448 ,  945229627470531010 ,  134914129341426712 ,  589929159796700282 ,  2300468102502827084 ,  270296371060194207 ,  1469549747438919275 ,  1835752576612316496 ,  2129163173462984437 ,  748443207452884040 ,  495867022800748535 ,  1448635072138190484 ,  222850753272147120 ,  1339063485883171691 ,  1791018071967448849 }, // x^2^566

{ 1368985642356590263 ,  1682162959042222984 ,  1259509820870392901 ,  554486614194227414 ,  1675478356152550039 ,  291477733512646248 ,  734260591930214500 ,  2010162803686430982 ,  927841285511995963 ,  1407335475712419872 ,  1839971611119645185 ,  998986087233120978 ,  1446572893980511587 ,  1813880852415114815 ,  1018214807536986708 ,  2136556129306911443 ,  237719880426645382 ,  1940383494300417603 ,  486425922743161542 ,  968466629348194685 ,  1888077027675065745 ,  962681407312455152 ,  286885113242920232 ,  1551674631281494187 ,  710615378243003238 ,  1543538205383972957 ,  36423303452581906 ,  1535788609241661706 ,  906993184783959072 ,  520907866921383360 ,  1245254714024640640 ,  1977225694288758330 ,  1697290595217901489 ,  1285965018204121295 ,  1042568848605489641 ,  2063146470729060481 ,  1854031132052856396 ,  1530778395525133636 ,  1681463547449184167 ,  1327406341266270989 ,  1026343772230328781 ,  1497119939198087597 ,  852249698213853269 ,  1205208240306527518 ,  631796057771173753 ,  2122459945476866567 ,  458764465665241782 ,  1021169944109490958 ,  867850013590643638 ,  845288775207587884 ,  2106201099546953903 ,  1387678667844821295 ,  1064935441494886830 ,  53196023950735095 ,  1163783434142459957 ,  211401025513871215 ,  1317379107831277582 ,  938444979246329571 ,  959409843037366140 ,  1920488978035816667 ,  233745053964158534 ,  1675703019648489024 ,  1005639524448332740 ,  544704435195664397 ,  2206578975412498453 ,  582386556549704666 ,  1531341544627352556 ,  1298501290657529553 ,  1867906498251717883 ,  2077453432439895922 ,  422793454717417731 ,  896776601800071309 ,  894839325140427623 ,  2183713261073098940 ,  187257498840047428 ,  752359046789913536 ,  1422601252475479970 ,  1533257738070622723 ,  1176029520766082775 ,  262197207213554821 ,  1482631746074984185 ,  1905764589002187292 ,  35821308132347801 ,  1747193063004333107 ,  603572978807727283 ,  343592822567410980 ,  1769429886035739896 ,  1420808972343183303 ,  921672757631231873 ,  1383285724825882279 ,  1911057487696952102 ,  1424872629963189231 ,  1330354227518971465 ,  1376053241007193561 ,  2163570299997906405 ,  740267058948762270 ,  431118111279074639 ,  668361441125258069 ,  886923401840982942 ,  1874883399967483924 ,  311754476690385423 ,  689698857810968157 ,  1850326311196437020 ,  913170040624586703 ,  1403399900972296952 ,  1945461966357484188 ,  356542313718312836 ,  396153621491941844 ,  2089005995228673044 ,  2111631423470631733 ,  547294091967653039 ,  830692215085008661 ,  1675867269378385810 ,  1320861398252477655 ,  650176288461004403 ,  2245074110408983479 ,  1871216894640738030 ,  1308663843221916965 ,  1502115988091274394 ,  844191283529761919 ,  1794597286510662137 ,  707753851816910189 ,  1234769190031483347 ,  248178401147928770 ,  1679702035908437529 ,  521629444134787549 ,  2083862196816974911 ,  1177202798149876217 ,  839345957442275219 ,  2214201298392810086 ,  2067165752577877668 ,  1756489414745503304 ,  518095819248480628 ,  48896389374778367 ,  119300372524664947 ,  1598837132011746771 ,  1677557330520505215 ,  615488340743938263 ,  253084921176007943 ,  1492933030645548163 ,  1235908080845325995 ,  908579248949972381 ,  1128833459975515697 ,  583763813636029629 ,  1315580441181402990 ,  485107039449954465 ,  1646763025241534464 ,  1950446593799468308 ,  1269558161287785009 ,  347904760093650876 ,  787942530609392511 ,  1775306409717680656 ,  1938251189462729122 ,  1800285239786373332 ,  98240657414442397 ,  1917160448772833965 ,  193906573633903754 ,  76618141104700191 ,  1818481821385378669 ,  1748568376570917722 ,  11133668077753204 ,  2269467453251061870 ,  562149978598461735 ,  1980983649207456751 ,  942554424373787515 ,  1002626652156148873 ,  1055769449391132016 ,  1061569633043161744 ,  1089537572189638474 ,  236916749216757680 ,  151932737853907522 ,  780685330255346049 ,  906060558313162063 ,  154282321807560027 ,  2174235204443357360 ,  346869202923593533 ,  532897947706215981 ,  224178897493149728 ,  747481574613749788 ,  2037007205114080815 ,  1275869806948930764 ,  948642482926411262 ,  1028318348093280662 ,  1744166105777103123 ,  445142532949791812 ,  1252861661551461154 ,  1904085025112207446 ,  1764752078817010428 ,  1402146836961937526 ,  401692504666367914 ,  314110120359150632 ,  1610925094267110237 ,  496241012306334387 ,  1263710472334658581 ,  1996268742155098382 ,  67281574800469750 ,  2114454096486336784 ,  512768174908567507 ,  536835803751258421 ,  1887088086103654463 ,  209388895434530979 ,  197334515505453340 ,  372484717769637945 ,  1869329311886340399 ,  1179031001079061079 ,  2195712423846560366 ,  2028337594830976583 ,  1352804541098512451 ,  2223719945233879318 ,  247804488403711035 ,  1455506119243778890 ,  457466076442453838 ,  196000464243754934 ,  464994248584501124 ,  1207202421625543612 ,  1571360495106614101 ,  1536086378202400923 ,  1031883876644412586 ,  77979469892471393 ,  327132922845682587 ,  2117010033942621561 ,  936712360517991263 ,  1410682803543523767 ,  1161354434626631376 ,  1038857179577056352 ,  138348951974046967 ,  2283942661043994505 ,  2043974789799927675 ,  446216928765599573 ,  149881092056735865 ,  2236385346964315451 ,  984448196510805061 ,  2078727132887920173 ,  568808120544204946 ,  942955838793760815 ,  804026289023030897 ,  1752698821289588514 ,  677762014144983145 ,  1617114309010950880 ,  1949200803692335677 }, // x^2^567

{ 1962206128146491810 ,  1127072829411764600 ,  1804376210489760604 ,  407621121713160582 ,  2261344832881890921 ,  613064937421164608 ,  2001263914459603821 ,  1358281153688213191 ,  1204729790215208998 ,  1190801785282887296 ,  2127517321382228402 ,  1015884295517982768 ,  557083367694746307 ,  1832843105493679409 ,  778993785291229914 ,  1525855439815356365 ,  1875246679986130654 ,  1359224464840843563 ,  2148323045620478038 ,  512853643204044761 ,  2019543444885412415 ,  2115784888728689837 ,  1124424534076581098 ,  1855624135005967775 ,  1461874658506215304 ,  1632928804120419642 ,  2134583390932961054 ,  188161037296927857 ,  432903972733406256 ,  227877682201442770 ,  346063976582171078 ,  1319982801497371424 ,  2019986609469790631 ,  162645280846511109 ,  878300803253866638 ,  1345398827973664605 ,  383262085243870523 ,  956357335675671022 ,  1491367653288890786 ,  824175615765786302 ,  397692595547703899 ,  1182545058755211193 ,  1092474761832036001 ,  1011565995117292165 ,  1584352394003546068 ,  1969455984572319665 ,  2144742247684740773 ,  2187890113282348429 ,  1702371685949618913 ,  1743743258421739280 ,  468035788493617430 ,  930559207912938333 ,  1774160310733735476 ,  1431648695590252764 ,  929723259431133510 ,  1677129328204522658 ,  294148910604181564 ,  2046620552664874572 ,  1139114412583393365 ,  1962984487819370965 ,  1570466340430949062 ,  1653617855736750679 ,  1956718078636769182 ,  143090058460037078 ,  330010959515065927 ,  1043903406477340991 ,  1493880062695518272 ,  293478044726997344 ,  26050865206145833 ,  1094457801027846448 ,  168169450990014 ,  2045953347637693870 ,  77696504314087471 ,  339181593969215366 ,  373373365303484148 ,  88744890759993507 ,  327488397935932426 ,  1631571992540541048 ,  1205716151491817877 ,  574738353986728302 ,  2196711677384761214 ,  1116476970478172493 ,  56573151579084686 ,  1372771857568714715 ,  1832725641017474487 ,  194244343290699022 ,  920505902308885269 ,  430003638350863274 ,  1941043011009013977 ,  2175513826299281339 ,  1037902764469591285 ,  1598550701917515219 ,  1889846478540746840 ,  926831077964772881 ,  387343754924493598 ,  1059513344831555946 ,  1128941528471671612 ,  1838289592157147967 ,  1026317686125255827 ,  1526069709775703948 ,  929495920813658807 ,  934623294181542009 ,  1164911156568467571 ,  1235506776341842309 ,  1401602555709503924 ,  247803530757679818 ,  1789244172703249719 ,  2073129334916398585 ,  364284987559390721 ,  1940189480579774557 ,  1793944949102730133 ,  1193519258919628653 ,  533182596326025352 ,  571059909019264251 ,  205599340209034562 ,  1481571113935055573 ,  662318368341880153 ,  1856359179250295129 ,  1831710341424376347 ,  49879088620380371 ,  1876353743932575229 ,  959717095989710808 ,  1866221882953879394 ,  1240262398831069336 ,  248586161885430976 ,  1744763988748003731 ,  1037298359373608304 ,  1417465779822087541 ,  2141917914085245918 ,  327444438809145454 ,  739792757912364747 ,  1087331233048550573 ,  1128992460718402706 ,  1471664521249734866 ,  1116591223866081767 ,  300840579720663845 ,  1511586220607788645 ,  228723459387230128 ,  1938396235834611579 ,  739795999535320239 ,  379966834147864149 ,  1824455777947887651 ,  619500416897568489 ,  2081558784689493815 ,  782159510368922482 ,  1248794334796432959 ,  594906627422823257 ,  1035696435549243014 ,  297712709060088893 ,  410128123361884740 ,  1181479402576463527 ,  2165150270710516565 ,  19830059664509253 ,  1310007635119451147 ,  1969515208945904389 ,  1895863798884066736 ,  971383080444805826 ,  1970313324597570165 ,  1962993367945938800 ,  327415163773791671 ,  2224714965633587898 ,  945097888825928191 ,  1771737886442272862 ,  25576373708938405 ,  1490495484788727451 ,  33839604319013234 ,  1709682292276861513 ,  1088985390034142500 ,  1822381447649426997 ,  1980407852313164588 ,  2063095322174584924 ,  584926707925918454 ,  1932895409880723396 ,  864160295827269366 ,  2121929531153020429 ,  885460024803875752 ,  374659273780617560 ,  444158296310843609 ,  167390236357676342 ,  255511336717735150 ,  502084069639089513 ,  28566625663837669 ,  2017978242197453499 ,  347061110659951737 ,  1107412299815632566 ,  1051602610471523539 ,  719622149503477090 ,  2270263947824725597 ,  2002848202916374907 ,  349452724952895286 ,  2095746460902287706 ,  893208911544371514 ,  904642423681257516 ,  1059516877718577536 ,  2292053946715429973 ,  2010480311047651853 ,  1401973261208998685 ,  1072222833488926048 ,  246630695712016716 ,  1793500040045802479 ,  1764875681985846588 ,  212495752905595889 ,  2074518542463179315 ,  2036563118607711069 ,  1225001601619490360 ,  1707969342901143060 ,  1635533000909476965 ,  2212563032253651875 ,  1358848795654739091 ,  1766482103293453537 ,  1378776869090905769 ,  1830872731279193934 ,  1367467912372585857 ,  1756654530876255882 ,  341792666535770834 ,  226743307161501175 ,  1717456919254160005 ,  918987921110872579 ,  567109992837758145 ,  1425041586452606692 ,  2237589380602869308 ,  2170340481884807442 ,  1249203186108399586 ,  1902220523073036832 ,  458311452681713480 ,  1586881270688530652 ,  2160817238974980733 ,  680563639005892332 ,  1515272912500440183 ,  511470305758476045 ,  1999824700127481821 ,  289384843311833673 ,  1353004339465141025 ,  420552665388975290 ,  1059948880347901583 ,  283795937410368733 ,  1358342792423026198 ,  728113549011197388 ,  2299006851081460352 ,  1420796089341923155 }, // x^2^568

{ 1328363921991235487 ,  2012067618467251613 ,  599689551537802540 ,  222342616258839965 ,  209528359799665234 ,  976676419886765344 ,  1207427938853200851 ,  1617634097558702815 ,  1324586854748461373 ,  1464552374313684836 ,  1490165959111518104 ,  1913443388174842308 ,  1278430751814812066 ,  404310393968498150 ,  1814416524491608857 ,  1092359517953881641 ,  549358118178446833 ,  926924143629980739 ,  2147807613208621557 ,  202431124608977107 ,  2146792362288108433 ,  1910469290911338139 ,  2104857128669690005 ,  1475959904045924319 ,  447945249612613232 ,  779551227997038419 ,  108522320929935338 ,  417323493055537350 ,  128981854172246534 ,  16137888324308171 ,  2106394083578468057 ,  1980706072044632821 ,  330080181590809644 ,  987217633055610123 ,  1995392016527825541 ,  1883622148236498178 ,  1006937352137948169 ,  2212765377082304537 ,  1568555461709424690 ,  1312408785190340150 ,  1943920627080778291 ,  506637196654604821 ,  1529214156019896809 ,  1189958093542143637 ,  1789668021670693236 ,  902485717152875776 ,  674154894846438621 ,  1417940757743138582 ,  1916357319289012090 ,  121177326786331244 ,  1513464979212793979 ,  1314428024740365535 ,  1011392320512907848 ,  1949250532558204217 ,  622049756838592335 ,  2255676171349956626 ,  1843470839914869069 ,  1656617698885677413 ,  1095917167158666167 ,  1696658262300305519 ,  1692993429441917236 ,  869278206493177775 ,  1029382737811447286 ,  822314961232455932 ,  122728885158586713 ,  1661963158699235038 ,  750738314833865365 ,  1933020970758953366 ,  1329798848137916575 ,  5553095502109295 ,  2126419462985857165 ,  2231343087060119897 ,  1267019991349394941 ,  206443009244896708 ,  1273483363273078624 ,  328100751531728404 ,  701253599032254144 ,  1603232278220803536 ,  644125257871565822 ,  717379679411430475 ,  2039113359064555281 ,  2230062658359168183 ,  71266159864869633 ,  969060018108765277 ,  1765345025168570043 ,  194559189766976773 ,  551891383464783932 ,  2246572414741303175 ,  403303856582853896 ,  946874288798049588 ,  1035205562754334309 ,  2283851299815110867 ,  238900941642494066 ,  1357178403437664451 ,  737524221684052871 ,  2277511486792144493 ,  1106258323550515766 ,  2154461997997058024 ,  1310278048387783181 ,  130246277548649250 ,  109936374355658780 ,  1010846839209955244 ,  2204094652298994076 ,  268049971104808809 ,  1687122434565562765 ,  2003397383797242767 ,  632963810886974385 ,  1464801271572846539 ,  2033691001556249888 ,  2240209493064694069 ,  1355302542093026119 ,  940918671937163288 ,  306892854287964927 ,  1944970206764344322 ,  2255147432004717729 ,  1996382276102521963 ,  2231078711332292716 ,  828205293775652976 ,  1222658414407724028 ,  787925203773816461 ,  233704113453370391 ,  2086080325157018497 ,  360461871686988593 ,  183405373709153961 ,  1963111371578611039 ,  1453852771887625977 ,  2119125700813616453 ,  1701375223023404372 ,  2098062786648757845 ,  1276004430358194610 ,  591029159247091655 ,  1084661880124152356 ,  1351213477548069829 ,  1213979798701989088 ,  1901809594918436934 ,  1796656353383896146 ,  1053131903728236259 ,  1976174309623903225 ,  1693297624618714631 ,  897855126906128712 ,  1342847408347268874 ,  1733372452948989922 ,  99488521945761604 ,  685190128683384674 ,  1662463918096640684 ,  2125559592377684151 ,  309521579632339184 ,  799296711622819626 ,  1874000508249475552 ,  2085908140628006974 ,  2137966199412005856 ,  968791405037598116 ,  1775714157883186487 ,  1054088588328916683 ,  671706222970580528 ,  1941653993561403282 ,  996316111957114357 ,  1449641743011742427 ,  851403359904214662 ,  84273788471046522 ,  884530494181339916 ,  986449617417787920 ,  1029405910216847328 ,  734867081575500849 ,  681674336838276433 ,  714933750764988234 ,  1266922409628834984 ,  1826886202256692925 ,  1184967736787325110 ,  838225926554048734 ,  1639985161962474898 ,  120432940256951544 ,  1807642574423254922 ,  1039406122821334959 ,  1644401374076589392 ,  640925817278773720 ,  1913845812338767134 ,  539101706510475045 ,  180623775992829014 ,  1436548748263282755 ,  1931356836816820852 ,  415138920609453041 ,  1391059959881694687 ,  874116772640054172 ,  184747938563070326 ,  65611961984594156 ,  161871036235131222 ,  1861018323759757487 ,  2220022446997903234 ,  906672624943317434 ,  1610959579092122131 ,  1132190222910104239 ,  1977029010522778696 ,  842579678630747044 ,  2065846705758958068 ,  113838186832999840 ,  1088040353132468967 ,  647366942272177806 ,  1390928528290169039 ,  776896091245759132 ,  1482392738792323855 ,  1016675516642035298 ,  1224207826055775485 ,  748150087811723957 ,  1026523594546289644 ,  2030152736923827426 ,  233098667496595811 ,  569140252471564690 ,  1389154913269216652 ,  2099745338909835082 ,  22312649559350912 ,  763279174943471360 ,  976430410550784819 ,  1840237067960739235 ,  922133945958677301 ,  898321261737334471 ,  2238091605461052915 ,  795604472837112608 ,  1758250759463721123 ,  1236828351859592344 ,  708288940447653233 ,  871214896568663874 ,  1105571489713714576 ,  1377803200750713502 ,  364721613650209521 ,  689303675397970927 ,  148024784414873048 ,  602969165844598965 ,  153739736168204670 ,  2100003579395546918 ,  126923409034988805 ,  203351869505930629 ,  842024115784120846 ,  854917263131255045 ,  715159172335322765 ,  1362772752008213974 ,  1327954815989425674 ,  341141865120934773 ,  1630112536248623207 ,  877346789619290198 }, // x^2^569

{ 721992794649146771 ,  1954521864661496139 ,  1912226903214122959 ,  1808860060284511117 ,  565772566169776934 ,  2131806591704953477 ,  1429323346860607101 ,  704257450332130299 ,  500818142925499434 ,  138031085132585715 ,  1904531103706682091 ,  1681169368551245020 ,  759998619553095798 ,  223768061220787653 ,  1679224066280699996 ,  371101086920412866 ,  69536288879179531 ,  1502579298406510990 ,  203442565842931827 ,  907612429717108301 ,  870298302592709676 ,  1260128182708838692 ,  2092286043520409790 ,  907750907268998163 ,  1579691542459934714 ,  333794166716360986 ,  152921430258828464 ,  1748246650944621884 ,  936500704816815158 ,  1529423351799073696 ,  765366692543333118 ,  1193661295851002458 ,  2187065640898221289 ,  174793078236205907 ,  82311063656737768 ,  1628630900633822317 ,  1773722459982303973 ,  917011659188006250 ,  281861452863723530 ,  705107070814764318 ,  2175517422708993703 ,  2277557828878439174 ,  1949494616972036759 ,  1188465220831757446 ,  1719589893462539182 ,  2177097296180252956 ,  844631659257863355 ,  2270965575107480740 ,  1569967226832516313 ,  1028903146568543175 ,  736745947295737207 ,  963831796681399514 ,  1617835337025597501 ,  2297309149919389539 ,  2031076443178401251 ,  2243499108481901877 ,  385133692430054138 ,  347192796877038176 ,  370593280445462107 ,  488103291020020908 ,  2023557405811082106 ,  230131466994523581 ,  2176569082554556378 ,  1257029358466698921 ,  1898704055629539289 ,  1120354085393907105 ,  488388671803342292 ,  1729547423210474575 ,  273533232265718734 ,  306187592773286000 ,  599989284020831225 ,  1339602417160521 ,  924161148512913813 ,  2140371407810982072 ,  1023656052386405335 ,  1000008774825367556 ,  17761583717847363 ,  485221987515699824 ,  2087192764942778489 ,  57250086067313115 ,  436673947575208244 ,  1001302151114979518 ,  1703235135769825036 ,  170035424342533817 ,  1775944828213390392 ,  1376981576260654974 ,  2222482038303848024 ,  1206853856018036495 ,  2289944460614517928 ,  612859298448182967 ,  1074038041770995679 ,  1137340959162485230 ,  1729982588850317123 ,  1561744777423180807 ,  837395125714799670 ,  430217271493062920 ,  2266601929877080772 ,  1514777792026741913 ,  985076587809062198 ,  161917135501258423 ,  1098844638205596582 ,  936913953136605220 ,  1946539942352590447 ,  1393041054075242345 ,  1386846104211310611 ,  1748401579180310904 ,  613331482834566814 ,  518227191154296682 ,  1246924665932338946 ,  379722585382841009 ,  595220438440213602 ,  1684730817737159898 ,  496581737008228509 ,  245904267596575781 ,  1635951498619017100 ,  145121491175804126 ,  648800550822334145 ,  148026454488805830 ,  1204955927204733914 ,  1677985352587745752 ,  982835321086297647 ,  1301022610927987139 ,  1970478999091951658 ,  373542408374359883 ,  1056297291504456042 ,  1732852079381070221 ,  2262746270802130133 ,  2705138788611869 ,  2020436331548991562 ,  899818095388676950 ,  1339114157575502377 ,  1247616261317971130 ,  1191148192697858324 ,  1043484043343855864 ,  2045842423827995103 ,  1199611534830539796 ,  1795012795980985478 ,  151780977829617707 ,  1328188958131263302 ,  2054070731801572780 ,  789776637912985790 ,  1153078912196269065 ,  1687132642280665495 ,  1234661552820931904 ,  294699286267914819 ,  2164793642392626134 ,  862417477504360023 ,  1089154096455378926 ,  2077530276534975542 ,  1019734639144000151 ,  1518420759435843301 ,  1919159791712808481 ,  1535176727454338878 ,  1059813115855347707 ,  1243673802121975219 ,  996436401289045090 ,  1697722034138624119 ,  827424655149052200 ,  634661323793073276 ,  1191935828450184058 ,  128613663854899560 ,  1396133738505596312 ,  749749306510131768 ,  1054829425854064546 ,  2074962223660359645 ,  1266956323849548830 ,  115336934137501805 ,  1981911612153010186 ,  400862379594238429 ,  583561145463889096 ,  818286411640670849 ,  1446068462669155994 ,  1266507152446278196 ,  2013309963181155191 ,  2045057026832662921 ,  2001959990422280316 ,  1786055464660516774 ,  2176025050626884492 ,  789045974641322609 ,  337874538458148761 ,  1701935089836234883 ,  2215280153495025903 ,  1055756597602804474 ,  2272985930021541021 ,  1192594107814030039 ,  826015000128360557 ,  1908971286437567269 ,  1852969457880908742 ,  1408723905117337659 ,  492516417607312540 ,  1966016013907360192 ,  479194398719742762 ,  134225385654873874 ,  1681997827676010077 ,  144405493782502219 ,  179053086798775604 ,  350280516186917110 ,  1262562956011500840 ,  357666934796173885 ,  889593181240548819 ,  1583478889373083420 ,  11066314003841789 ,  759648468109826529 ,  174214990785890883 ,  202800860573944903 ,  431623302332790332 ,  128578550121471831 ,  688638012192587527 ,  1752014478451520300 ,  97355591190218172 ,  829532695928098026 ,  833088153638627606 ,  786884839501043317 ,  193459894933645417 ,  504561329504007323 ,  2202164430466969680 ,  1124906543189713046 ,  2011068331798426722 ,  1517001514189400301 ,  764472266122460345 ,  1352726868931841462 ,  1045433874384438844 ,  2296082549059629696 ,  2220950966454326591 ,  1416165983872398684 ,  2004696340743346470 ,  2130210231274953834 ,  527182651058745555 ,  226013754035228579 ,  1859124633303779982 ,  1260837733501912309 ,  1597446114864164792 ,  2015175844946029387 ,  1267790584658628884 ,  2290022260127803795 ,  1451642566115002129 ,  2021629309167219341 ,  1848041465146990077 ,  2133360876761438789 ,  1219519960807447713 }, // x^2^570

{ 1565106495119792338 ,  75685496298070530 ,  1860975674740961284 ,  1604617192081372561 ,  276609017145851417 ,  201643995729990749 ,  1469044866354319459 ,  262459285437912007 ,  1650587316422755574 ,  849226096038724807 ,  681318704632962957 ,  587341335780077648 ,  2064332958574581328 ,  1686520719198133873 ,  1660831245270559932 ,  251729084324389769 ,  1409735393508770719 ,  1470083198241640572 ,  2093981817053968200 ,  343252164938066306 ,  872773383708469071 ,  251500248099229583 ,  2223860788635744541 ,  1513877923114874602 ,  1081732373274738816 ,  2055462600628721247 ,  1419099869768189598 ,  1459735262038028251 ,  168674284760006868 ,  2033770208297889907 ,  757648865062976303 ,  447331500389782354 ,  1121624687250412702 ,  1511958103947008109 ,  429026255889860521 ,  595471069523706355 ,  731620130862375268 ,  1338556156580236752 ,  645666138215454088 ,  1249217567862901888 ,  1349614111266152805 ,  1640065850907606870 ,  716406198348459651 ,  769044427171998743 ,  447322731830146729 ,  1311396177661938292 ,  1785326971610941736 ,  2242225001031555752 ,  1531589903951881495 ,  270297977799067403 ,  1888717331469139965 ,  225859754088808795 ,  2137643940209909718 ,  690181302844952599 ,  273719823453513326 ,  1830834264193325390 ,  888015424936483840 ,  2204835800234694582 ,  1934452381488556697 ,  674664473173923815 ,  744737271982116701 ,  816685409060415707 ,  1465841506206869270 ,  1003512313518328179 ,  198407465523432367 ,  942848649100051082 ,  852943130573015302 ,  2210221009197274670 ,  288379559363540909 ,  18529573345010193 ,  1048438846963775424 ,  1699215871635454582 ,  1458660329372037622 ,  1658242860597467308 ,  2113320332367354628 ,  1718954533855699215 ,  1366730319612219361 ,  2116897021254050609 ,  424054693231842222 ,  367140715168624425 ,  286944407570594197 ,  198979602136221482 ,  794362567156102942 ,  864447475062510037 ,  418110860504000833 ,  2042213448970663726 ,  1618599407064344140 ,  477606203840661855 ,  1049069754553030997 ,  1557640420548952552 ,  1225269419709319008 ,  1169059793977782054 ,  1740738696545203641 ,  1699618110021277490 ,  898172726045457362 ,  857064436167240067 ,  331089342000322851 ,  2294024293469536508 ,  71001110361706782 ,  2063785717866350163 ,  1288210610850923082 ,  94137076331406808 ,  115038770854653983 ,  1971765013003541474 ,  305065861862529761 ,  2292134189197699818 ,  1531605052044950413 ,  1164779307206757980 ,  1893865832424256566 ,  1889835612734298308 ,  1582222360543335399 ,  1755946678675278155 ,  1475457779276635088 ,  762153541624294629 ,  1290027101555960241 ,  1528447510019494505 ,  1214392664328321508 ,  972877071385442711 ,  684061871597967310 ,  2253996741407931748 ,  1115251658286540120 ,  664534992549702539 ,  290544410675022879 ,  468836706435812207 ,  1680637667128797207 ,  388539906785022999 ,  666023950463814356 ,  1100662076707326575 ,  585936328688763514 ,  1309505814300082637 ,  1262601806555789957 ,  1205871573818097368 ,  1634569549573685214 ,  1692966930836890521 ,  500827083884256047 ,  283312224439324263 ,  995352971333593759 ,  1891022749618877839 ,  2074903397970301938 ,  110851505379473743 ,  2074764598391539266 ,  1539410229940983478 ,  1155669957635990830 ,  390244834415224071 ,  483853018330089456 ,  95965086299808580 ,  1631943720234575021 ,  1980627042420847752 ,  306026340324780410 ,  121713240246101643 ,  2214572369798025896 ,  1409433872289992547 ,  31429690380430926 ,  72524773559512503 ,  1931902613020476574 ,  900517386713863926 ,  525954105903205889 ,  723789732582342177 ,  30465143831057970 ,  53563576774794930 ,  1532573525056279643 ,  1858209760312466198 ,  1597353466456757347 ,  918311562247987934 ,  2171405237138347854 ,  959523441941249104 ,  2293111942753492126 ,  999899449622999227 ,  171713997799479821 ,  584912607536560262 ,  672414254870080826 ,  784073886410757349 ,  1994391345757559719 ,  198173031289342575 ,  558726664789711796 ,  116311653185227351 ,  1458038209766990651 ,  2107205187936548282 ,  2032919540936474559 ,  1571522264839080360 ,  2231855024960311337 ,  997410125422654959 ,  2146341457295542215 ,  2267764022550671293 ,  18808494738736282 ,  585184090444407265 ,  1102011067356977493 ,  510342311154399219 ,  801827322805163282 ,  170989704465167194 ,  806177163254541023 ,  1250131617463143527 ,  1401884928995466573 ,  905666610101965961 ,  2184326592390980936 ,  2114906710887294719 ,  994111996451248397 ,  376592939466620696 ,  168155174529848087 ,  1433978970960699986 ,  1791049692291497003 ,  1938024329621654025 ,  1812254348975839309 ,  276123777323487039 ,  945623905133647237 ,  401673315259793995 ,  231072702390186029 ,  879236188888881749 ,  969921668847164314 ,  1891762657575095594 ,  1318274238971667578 ,  699506384728459226 ,  1326591170981860995 ,  576018184170251365 ,  1663951231586471243 ,  734504675058546378 ,  1785490392487209415 ,  1731342215889475041 ,  223477350715633500 ,  1161231752833795251 ,  961697032103357906 ,  2264568217757084923 ,  656397108115144913 ,  65241686724659117 ,  1173043076920642432 ,  559158215511691408 ,  390191119861701883 ,  1261868364940688375 ,  1101386002266611501 ,  690980748528674483 ,  1423003984918004152 ,  2049694984069154114 ,  2060115533321894332 ,  2002521643500028346 ,  357165278720326135 ,  543836785037316433 ,  529908482635594021 ,  140308545775348361 ,  1990128791073396917 ,  1416202551732679236 }, // x^2^571

{ 1890149622177599748 ,  826282472360819217 ,  1852760471887390639 ,  183728776597290656 ,  2068258819972864402 ,  1903959516276267204 ,  1012245351543654000 ,  234232209978084379 ,  1553305060159791395 ,  859928299519461892 ,  1436654959609927421 ,  1214968896154061469 ,  167010318330194085 ,  1656618696387980548 ,  2199266792043713738 ,  1176008792119368868 ,  757799209338192433 ,  898565658567539905 ,  227016072812909170 ,  1075719407471135133 ,  1297698059473497413 ,  1572823335299555171 ,  144696347575036083 ,  266960628430320080 ,  2106235597681589330 ,  203508268100791647 ,  123163939730776020 ,  2117462073225800183 ,  460933320321087130 ,  1202825096892677999 ,  1057824325010959692 ,  185374361006956179 ,  2134725389427171267 ,  1845179718384921714 ,  1629783950484659631 ,  1852708282025543687 ,  2052258800782790495 ,  619468273430466445 ,  2085435567807400465 ,  746277841983963850 ,  2298303605729050932 ,  1113967823840166952 ,  522781989977372638 ,  1342747211405440262 ,  2124080555729718652 ,  2121853966189857050 ,  168300961682534023 ,  1561201129858523415 ,  965804259402468732 ,  1514077273036887128 ,  547432253979803859 ,  985144397243497217 ,  1782296856143557190 ,  1600791778145919142 ,  602000812586770144 ,  1527660436156387847 ,  607778206339957798 ,  903207578681070490 ,  1420890430635720031 ,  1622349873132733554 ,  29001469155533 ,  2052151316272487649 ,  1577888511643962828 ,  1247454214425328023 ,  1924967552699200881 ,  924643462026453514 ,  1463394490375867647 ,  1620302469117929579 ,  1645513867257656607 ,  1138515254339424318 ,  834024363214465115 ,  2196316279154662688 ,  942036455831740271 ,  505585008122251416 ,  1935130276916768204 ,  1397281190300795496 ,  468692537091959978 ,  108228011524930284 ,  1829009145628992622 ,  1626467124552930501 ,  158736481180856158 ,  607741980375295663 ,  697110202192588337 ,  1461467695281539243 ,  313154146448484833 ,  1340934719066921085 ,  706497835540630952 ,  1497346269817994807 ,  2014791057944941509 ,  617345273697843230 ,  1077920178308607742 ,  2103868858151324051 ,  223515915466617172 ,  546048815100853875 ,  1943962064205149779 ,  1475684221583503146 ,  601145571815058896 ,  26750477639504573 ,  1447582356773519484 ,  1478668370533328062 ,  1881149102376097541 ,  2207262920066549611 ,  349713987274448734 ,  1641959868108561577 ,  1148128913875342948 ,  2066351184650309083 ,  2285242056979991448 ,  493359391797583119 ,  188930649158052020 ,  29314732834475570 ,  1061755760390804097 ,  1855352124683715786 ,  1231748711203278524 ,  2140792379455700135 ,  85183540591528423 ,  1529545294371554443 ,  374896557575438938 ,  629137582487133377 ,  2269437199232934391 ,  766758226401948711 ,  1117233550980833964 ,  842702189079648656 ,  325318713311082110 ,  1616877482692183879 ,  673416985666011503 ,  876675253193238729 ,  318481583070330310 ,  1621407351027592437 ,  628724207439087241 ,  2215816014630684598 ,  1955254098211645908 ,  957094566535396318 ,  504491954497247339 ,  1930168700260728571 ,  225606063837222689 ,  1497655750058244162 ,  1299295339387091801 ,  1420051171974811380 ,  2004904425229430485 ,  117251592601431650 ,  1590162684597138460 ,  59811996851450145 ,  309792559846860890 ,  1534262962092066248 ,  1695733977940385753 ,  1444588633611189139 ,  1482060941443908743 ,  13802161480065923 ,  1455171895526398533 ,  795753654818824131 ,  1730858491255107128 ,  193892149267318389 ,  1070189887482388596 ,  1542875872906095819 ,  1460946791126630041 ,  1871257932159322226 ,  1842405534055039857 ,  1898823245040595973 ,  1228493435675347281 ,  702262898566001922 ,  544872817471685516 ,  2209929759603966406 ,  1448027661938605750 ,  1429566212496584685 ,  116844311361712463 ,  612285484029064118 ,  139371879277900070 ,  1520571725241608963 ,  1418691156968555103 ,  1913712038603746227 ,  921078418853014580 ,  652484693777948764 ,  523925071656541671 ,  234088540075987656 ,  1357470276392800726 ,  1914892049911913863 ,  1842394149247532169 ,  1746004140860264021 ,  729371390555194171 ,  1274038019036599358 ,  2013805271943882794 ,  1930985458409047243 ,  1764470698282900313 ,  189849105877346257 ,  2106645694971558170 ,  1981449950658012416 ,  1100731569098569473 ,  880160810980582459 ,  1755718061333695677 ,  1629837378805377360 ,  2123299855813092338 ,  453852978651208316 ,  842398473713668560 ,  1856223046006571351 ,  1973846764724518810 ,  1089100408754352104 ,  1706423047692150541 ,  28033308230013199 ,  1900713576532766005 ,  2119004594653378055 ,  1629167622509274543 ,  1113242608086497576 ,  828397786262479445 ,  1713288682773095367 ,  1426825633479947233 ,  1351669803945837653 ,  2212104694866137853 ,  409901488866642615 ,  604430708911306706 ,  949076779566504604 ,  2045406329811864250 ,  1478240205254530808 ,  793703691443620001 ,  511444822920450079 ,  518232944396212918 ,  1960212654506362805 ,  327426284807811981 ,  2053575655111412084 ,  1492927569741821194 ,  1904999184353546057 ,  2212924619750547898 ,  515259798817589024 ,  1036051553604128963 ,  207976551976004377 ,  653807428209078506 ,  1230712650945642791 ,  1516974632871120159 ,  1587162609510760082 ,  320759735793781909 ,  66610686896784903 ,  525315319539116355 ,  594746774495138861 ,  1710323051006073739 ,  2251217367474966328 ,  662151283623025331 ,  45801057104523089 ,  667949119991359695 ,  912046941508029230 ,  89510032273511797 ,  907725551123559377 }, // x^2^572

{ 1093241882602189147 ,  298046481911432695 ,  352378661255201075 ,  372623087189538066 ,  2140062140689580093 ,  462169102006518902 ,  1237233047919048499 ,  1242381088068440078 ,  626893652023043415 ,  931335688958767689 ,  153893963426140306 ,  544046534404824909 ,  582303408926605393 ,  797380559161611818 ,  2208599459350149907 ,  2013962599549275327 ,  1235099209569083947 ,  405929474790572260 ,  1796559824298953325 ,  877139727159330013 ,  2196244969297853150 ,  921624550637430613 ,  1246286878671689218 ,  2040415715976130372 ,  545587836766347996 ,  1219465422764848834 ,  298348378165435252 ,  830981822032203022 ,  810420704139455800 ,  1993738954213718755 ,  134309327341119271 ,  123077234696344861 ,  635869252605936414 ,  434263774731165859 ,  737384614560268421 ,  158295167418239075 ,  786275106800104929 ,  1463016206797811971 ,  314178806470811681 ,  734793890842133549 ,  2302169620338582287 ,  614954006939276571 ,  2067161583924719569 ,  1754288180364893150 ,  1748377391285657798 ,  1612658060281788394 ,  2005550337566638371 ,  2207049145189195748 ,  1197995442154659453 ,  1751256457270550624 ,  1558171212345866381 ,  1381025563874781501 ,  1882096256537137949 ,  1799926843877364322 ,  2234544374892046056 ,  2101264156372814793 ,  1506612628625840985 ,  946433891171074528 ,  1697216148296626991 ,  1618600137428024397 ,  1719563120040608485 ,  327575020143014300 ,  1729025391373481779 ,  415777766477302452 ,  2154461311462839502 ,  1575406163312109790 ,  1040638179108084123 ,  2163693749187259777 ,  2060073222126064841 ,  1557396160840656235 ,  2259124749644159271 ,  2268697846868199733 ,  1053096164866211987 ,  273461933400125310 ,  706954828278244764 ,  1252575320992651111 ,  16207890677042230 ,  919306005817528899 ,  1702337973935561461 ,  1556941768737354231 ,  1820356687183475066 ,  1702530843250899410 ,  1031236171200540571 ,  1829703630147086351 ,  1335804822018447280 ,  1436915438021847965 ,  523824826687244472 ,  1430666618870956557 ,  702527680237815597 ,  555821803318903210 ,  1311212518613453555 ,  168392692105498895 ,  1885127832255507626 ,  157454556012350370 ,  349990752376310279 ,  364515789877447482 ,  1590122086712091894 ,  262755999609854895 ,  1682818378465995614 ,  1972651086933077677 ,  1533142787970214026 ,  3198824608682094 ,  45379591977031769 ,  1412468841371018717 ,  834533711360784782 ,  1008852319968659604 ,  1570460188010234825 ,  1530201829573233871 ,  1710881591248231730 ,  1606520106030557727 ,  272886071348433779 ,  1754665018533026093 ,  611143537277872392 ,  198767745709116692 ,  1597665687060430716 ,  2051278707638539646 ,  2200692079219259040 ,  1332600483732773927 ,  2262836560414498871 ,  570456020591700580 ,  942814612099286679 ,  517777334255120780 ,  1981918330466069006 ,  451212102219959682 ,  1819818795664993412 ,  2195633129414955404 ,  9370152872641006 ,  1162698872690012105 ,  249713882572899253 ,  864184357922303342 ,  125690658373833897 ,  1472420472211709911 ,  232270112964467042 ,  2140081753339401062 ,  1808106101882308439 ,  271633040859083360 ,  1673598651614802329 ,  1223192080997446867 ,  1199632850294503791 ,  913725371858904404 ,  1085512779475782170 ,  1566478743482961165 ,  329119759456826059 ,  545294459504735380 ,  1419621932734065127 ,  1856878428246307668 ,  2118597135593553424 ,  1623049386769622341 ,  1904099867473945500 ,  1646017172301608185 ,  1285970593037524229 ,  645286893758065951 ,  2033158175181908644 ,  325897097994521404 ,  1802303202538195733 ,  132573098947151278 ,  1669178711994144397 ,  334620187372767482 ,  1817841897035954183 ,  1481127560146284947 ,  412386055526103040 ,  1538443795760795853 ,  544541998290690272 ,  913429473931856358 ,  1345632423725887120 ,  605799783407538709 ,  162165983127630304 ,  1930532878877601995 ,  1506758853788431282 ,  769864638646867081 ,  1196021627466169396 ,  965778544620238913 ,  441794346227605030 ,  1035813684185134813 ,  866007153543092800 ,  1856726876324968365 ,  1716848054479686896 ,  1337273133768837292 ,  388561562425170982 ,  1500215212572823498 ,  2244714869936620186 ,  614573208977452236 ,  1259029653623856165 ,  417872627421981276 ,  1890288018338007721 ,  266593240130091436 ,  2042593632389382405 ,  115357063935272937 ,  1422053498325902582 ,  305268016623821391 ,  351239441195103225 ,  2194944054763935755 ,  1245740640120936736 ,  1913721222757894000 ,  1331064929106067388 ,  293481879246009097 ,  1791354724383250710 ,  910993368163279878 ,  1264056132659809888 ,  748382823792328818 ,  1931756847787181509 ,  866572674355857264 ,  1575162908272540285 ,  1385894569768963674 ,  2137937947474307912 ,  844537718666183936 ,  1951273510678302503 ,  935498234495223744 ,  482745604238930461 ,  1101618253414477903 ,  1532844872388975267 ,  258225812773407352 ,  577861472855730859 ,  2047751023321851282 ,  73122630675989836 ,  192688566842547426 ,  1710799987331275931 ,  1290644438249447915 ,  1625341521291730507 ,  1955559019935015911 ,  252678793157680044 ,  2251637405988476666 ,  1726948160591852349 ,  987542975393268734 ,  1064921757439095433 ,  1392714104508848374 ,  1296753625177452132 ,  2279628455136812895 ,  1972341732151343364 ,  488737693003464394 ,  1839772320727874611 ,  1650437984946276475 ,  89629096462982146 ,  2205702827637837292 ,  257077826151388678 ,  36465136257725574 ,  2202657042534343785 ,  107401804939463498 ,  777337582101421994 ,  1909564673661776880 }, // x^2^573

{ 820803616491149704 ,  928939071163069029 ,  711878584001276846 ,  2225491949601022148 ,  1469553273736944743 ,  2140227574230923201 ,  1626235268450689477 ,  518515133095370825 ,  529158882196732335 ,  896488711515274076 ,  147629520117838726 ,  660224739622424380 ,  980610362134325540 ,  2115802982376282319 ,  1576528065389557400 ,  475273681382574263 ,  1487778156003383118 ,  502414490702555099 ,  2103795549429902878 ,  1381609274292913404 ,  2019570052709540106 ,  1085604027216786378 ,  577911392011223801 ,  1198814860450578009 ,  1647940664274229672 ,  1040756557903929227 ,  1967420690197877223 ,  1132335115228803146 ,  1756014356371726090 ,  1481025270934130182 ,  937806614720005536 ,  1786835995874024294 ,  2098059315209685532 ,  1797494875548500280 ,  910676062101075675 ,  1502496101666377306 ,  737556584182634939 ,  491944318128029435 ,  757276729436821131 ,  602078585460150219 ,  1428229263908543718 ,  1902626674185128591 ,  2138302851627752810 ,  2292263246765814550 ,  407592028148113667 ,  1091442489944894792 ,  2217259914955762057 ,  514717837579520430 ,  2025182017234764868 ,  599026486962696445 ,  741102406074044244 ,  1195885243711883121 ,  565690213192062946 ,  557748692656801204 ,  588224617150644071 ,  1104408437387529140 ,  510811251480044862 ,  986577287835090959 ,  116702706381990020 ,  98347921975891661 ,  881464328828409340 ,  168282513366575690 ,  961342217269280428 ,  751945270494321858 ,  1107061342713422131 ,  186055105592977591 ,  98122483296908934 ,  1800390655524956899 ,  1468642737948119279 ,  1946839540479680039 ,  860120112719566597 ,  1418897030162147806 ,  1215981309954593672 ,  609705291473441664 ,  336550206982034756 ,  933270706318934556 ,  1248372474879226232 ,  1119699708308428728 ,  2171309538130292751 ,  2214245076701698319 ,  10519307502772164 ,  866716790477275642 ,  357872751607727218 ,  1018506559333771072 ,  429887363499959607 ,  2283192852840903148 ,  1579817613812617010 ,  826754619099474159 ,  1683811871095547702 ,  2079631926393549625 ,  1867810571999175073 ,  1323777358447511083 ,  102668301299468634 ,  703725367243745100 ,  1131701304249204610 ,  339058256400245590 ,  2217188920676851935 ,  911116908003413399 ,  953307624242213543 ,  8389132607474906 ,  1304065705466099037 ,  900527294165160454 ,  1587347969800505303 ,  1113497952170507459 ,  920679090132559173 ,  579684515132874751 ,  2223785774431217585 ,  806416999442916063 ,  137648170891873779 ,  2205073722888744528 ,  1838053163887792454 ,  542537374874917770 ,  1925598291643321415 ,  2216180267119940574 ,  734983521320462466 ,  265975774197539864 ,  1696638652093640841 ,  2160372292162158948 ,  914915510446076265 ,  902604230629473409 ,  540699222271365581 ,  1544436132775635086 ,  1643499414883939009 ,  614285106003863042 ,  217798031417979540 ,  1731610014337551168 ,  1756318128767452913 ,  1973661551365401246 ,  881946980913283152 ,  1324373614370834563 ,  2289139460302935003 ,  1618412339615227061 ,  1877148296430652164 ,  17297595031994973 ,  114920269805587496 ,  646818885262280605 ,  1969601274678303538 ,  1452824758630969147 ,  351791870836747496 ,  136147725382275369 ,  2170660143534545265 ,  1573506560328737251 ,  834831003197678245 ,  1737315416155315740 ,  1208564424836423170 ,  883217324294524723 ,  1303327666008574333 ,  1045056420093507116 ,  733184198103453119 ,  2042611719545036391 ,  38270972226297178 ,  1102621323439177677 ,  1406892930086182385 ,  1748075866220141614 ,  541672987771497693 ,  142892660164271085 ,  1352607859269613223 ,  1782540241175514295 ,  2209861857285125370 ,  1846236689356837012 ,  235966013579759749 ,  1383441224836276005 ,  698361459044114606 ,  1563296303679288839 ,  1981788210619457717 ,  2046922584049681400 ,  752379481913620333 ,  1019666891383762272 ,  791905869253972581 ,  1897646190100156169 ,  1818547812689187514 ,  1602030527450603524 ,  1954749438475229120 ,  2233319001791632313 ,  1690781872331086125 ,  2187703696251425890 ,  626703079004670577 ,  996319036418805101 ,  114277937529528155 ,  285719579954768865 ,  354033764687118594 ,  626738122216663151 ,  2176648894853088093 ,  1352363314695365502 ,  1170135331241104895 ,  2076781091677971742 ,  107260584721212390 ,  2234388207147975447 ,  1117227454703127536 ,  1228074024914984129 ,  449310786023982611 ,  259123818103315500 ,  33032706421079418 ,  1267794514833234799 ,  1505806931101056540 ,  645184748111979487 ,  880155068526243793 ,  1727894347757901137 ,  1746234223547656799 ,  392655204145933451 ,  522033874569248172 ,  72776526069866135 ,  1246055209039719608 ,  838994214039044002 ,  1427444660388673668 ,  2136450005439433670 ,  1513819810131555473 ,  2177383024279260738 ,  1955673957902590156 ,  2077828665243311198 ,  661163060721657156 ,  1277978026176037516 ,  526493847455643362 ,  3642525547513124 ,  2203458460815386046 ,  1867855208745582037 ,  137996526129326875 ,  29192198009219362 ,  1571701251913733918 ,  2010221484919059429 ,  1386384163436316666 ,  501549848923489728 ,  866704479748597753 ,  1408961587469106410 ,  452640514573255730 ,  713858423619237609 ,  1765267340805128055 ,  484967647770589122 ,  2268496160456544096 ,  2098975326918357948 ,  2214035125246696004 ,  595827041245653491 ,  1166255829519403442 ,  56488038373411160 ,  710313731307732748 ,  622385526576772142 ,  2250725984599996833 ,  1791985910302028839 ,  1086297411479064554 ,  1564392449931110299 }, // x^2^574

{ 1410130598399263584 ,  1808795842312073819 ,  1602028328284794667 ,  2235460662435153523 ,  1372001403444819686 ,  1872084428093012047 ,  2226038377218828171 ,  1995776668728916697 ,  365981528576953414 ,  2094325876435992436 ,  963161083218015791 ,  1679377860941369055 ,  2235732253505547379 ,  1439769561140253151 ,  499783165686700092 ,  2292172111514593151 ,  325622132643107739 ,  1676797952651144144 ,  403897563179654532 ,  919883410251000916 ,  668839855395901390 ,  595812910992363219 ,  80272630821600372 ,  1305377434459809015 ,  1768918718333354267 ,  940589617396411569 ,  584496184082361028 ,  25070683088477229 ,  2147885830985016075 ,  1324960348640011107 ,  1416938337811018371 ,  395644551278618188 ,  1745084109219482995 ,  101890668763240568 ,  1068174263173411498 ,  2042779302281622106 ,  409109771755486253 ,  654904256881131801 ,  1721567901606342525 ,  2269786845259833860 ,  184408370192808353 ,  2259674099642142841 ,  475821077813502322 ,  807743613577134688 ,  1588445463069589640 ,  548653089026884013 ,  2108545361916835238 ,  1107292940525678249 ,  317155103224403641 ,  1666056935370061405 ,  1460168536134924677 ,  545670234107888996 ,  2214864944376507510 ,  1633135003704757056 ,  1035027624274293041 ,  1523270530887014635 ,  2285360417749580744 ,  1284443362079218312 ,  1024163043496063529 ,  427085138463060508 ,  606702021581805879 ,  1527152338872355553 ,  764088957977350528 ,  1246351686875420530 ,  684471833377646296 ,  1533223930593662087 ,  818503658377147939 ,  1611030755000481989 ,  2167632714393602728 ,  1956350587863040596 ,  777960408128337283 ,  2127212191707849563 ,  1413091767415679301 ,  1906410830026695409 ,  1895355713422971473 ,  1004541071114908819 ,  1156845811990274329 ,  1832113792319309273 ,  1942382540639632193 ,  754197375697268550 ,  1183905854780540495 ,  1046497959459211911 ,  2021550900232361105 ,  50724754461615283 ,  883218396032044059 ,  472522968901802891 ,  936437810789122019 ,  256964235655878555 ,  1705210387605297275 ,  2089794517985261961 ,  1716085990302509440 ,  851074055337423640 ,  592331701402813770 ,  425679874350251745 ,  11733353812979307 ,  384760370129020997 ,  1206508434151669404 ,  1465845174549400458 ,  1274801069102476207 ,  90042171183627248 ,  696452532354734120 ,  173275143724323923 ,  1787685854605840357 ,  809668227368264033 ,  1287678004777972893 ,  672016489932680029 ,  120265337423592356 ,  1953384311472163637 ,  2295213441993648335 ,  1796590083767845510 ,  999205483649385232 ,  451295975400389922 ,  162421426148142759 ,  1398871824731551191 ,  1225094494789560737 ,  867573030661690032 ,  1073173354464278369 ,  1015179374823938273 ,  661275061747091458 ,  527065008805123572 ,  1045141246504480536 ,  2280944438897837430 ,  2037082856902070324 ,  525646007384273694 ,  1025455214670013386 ,  101312644188214525 ,  1223248772418556580 ,  150105523619596921 ,  2008926410278054962 ,  1073946453485465833 ,  651052171605254848 ,  1268921392176490692 ,  1599639125863146588 ,  618712100128716940 ,  343472806895414373 ,  1872535137688352970 ,  2286541527587426076 ,  1386166795671082315 ,  1972464317565058399 ,  1756864799457021022 ,  390430148280288536 ,  1036526989331172593 ,  326448936912808499 ,  109005255683697037 ,  813672263256052663 ,  463063788207954098 ,  1857276389658702762 ,  1172735941084996997 ,  166705810277093955 ,  1808956883176007452 ,  1292467933975835473 ,  254572921508800553 ,  1401567191692630176 ,  1341466210721866852 ,  1860539418709699005 ,  639280219165488853 ,  2269300825404991261 ,  1946439785640768505 ,  1519700921115270159 ,  102296095508559384 ,  236414157840446593 ,  266535117764394406 ,  1529773036639207333 ,  1593948299720832761 ,  438014011824946797 ,  1553509736718467269 ,  1431018395434408141 ,  648724227005040393 ,  863080091744866454 ,  2237879865812631559 ,  874888681454832025 ,  1946076742334875161 ,  245116763137871688 ,  1094225261305226646 ,  1360561416881898452 ,  1405513016608628068 ,  1931341304501935008 ,  447762198873291416 ,  898431009056069526 ,  209766904967693631 ,  2145794517718846349 ,  1698096577063995819 ,  701451612096738521 ,  223647256056826850 ,  1417746649696492783 ,  845879234178286550 ,  1983299520741495335 ,  1090563951291913197 ,  62474105792415066 ,  2253823911724512771 ,  876861736339035092 ,  1299455541901799608 ,  1066147412102821810 ,  2174612556723212639 ,  125429767450970798 ,  1454665002027806212 ,  670755462375014730 ,  2075497580385713315 ,  1593178693295097217 ,  439227812452934847 ,  1521942407984345085 ,  115835723191346234 ,  1109253722395908747 ,  1126033156873372304 ,  1470981123318804435 ,  1474385820840491750 ,  1618088939206416995 ,  136160607492037482 ,  158443391602787551 ,  1176922434907115182 ,  182894491514079568 ,  1979302490897539015 ,  1760937283760882214 ,  735592293765429423 ,  1858812671509073870 ,  201101973299011753 ,  960822610075980584 ,  86463220088575193 ,  979065522615283401 ,  1617997946713267496 ,  1427346374345260891 ,  2059353702648462793 ,  955633658796534287 ,  777244725693225954 ,  12698021415894243 ,  394261407376664222 ,  2249898652406830333 ,  1638217262094043539 ,  1171491851928449012 ,  149264193542926239 ,  1009886578526870401 ,  907205714694152335 ,  1595281961673142346 ,  282499435063886285 ,  489650225596491766 ,  2139574558570058378 ,  1410675692126963578 ,  1148461709718146423 ,  1088341016593491072 ,  180776980457029118 }, // x^2^575

{ 1995204931454918377 ,  311907203977358971 ,  900005039003104703 ,  1362439196449734798 ,  1292272014641983256 ,  1557843733784546810 ,  665447603651886968 ,  2147641205823555642 ,  176665441350144121 ,  2166562919099313967 ,  22442383732753421 ,  1096104096781267620 ,  1623988150301719450 ,  2230451637398921379 ,  78851419832064642 ,  1984936361868512126 ,  1603155953988395083 ,  169446155547734333 ,  2064841343551403847 ,  2204008742823618169 ,  1766072541108588320 ,  1863867750401378623 ,  537990772759652970 ,  1673267240545661717 ,  1037852000741870978 ,  396003798960280487 ,  324312248885194923 ,  631969935867676494 ,  1883023858640862660 ,  2094916965387523326 ,  1741650556844047736 ,  1197294144993230828 ,  2181827024374464265 ,  2134593334571974906 ,  1536273081568175887 ,  1762770313107895855 ,  343949622130775964 ,  1387604403162870929 ,  1455676817179291928 ,  1675482367066972747 ,  1831570601481475104 ,  209387023206857001 ,  770999986882805791 ,  431307398314366346 ,  1020691178007037870 ,  1586369358325054693 ,  1842531974027602461 ,  770456670333320300 ,  969698018697745582 ,  1012775736687014297 ,  1739472325512591959 ,  534593245187823491 ,  463408676443411975 ,  2220786207386790982 ,  1460484641212649292 ,  371840132765811093 ,  99998379608875785 ,  1645990464836778029 ,  500257451034566746 ,  947599043576880938 ,  1168754655566054802 ,  1145851541276374299 ,  482331215977979711 ,  220279022332617453 ,  1667284096330112923 ,  1917403773751749522 ,  848631404833359137 ,  289279294347825674 ,  2080070630936152214 ,  1857870981555998273 ,  2008103111556573021 ,  1545736458498225235 ,  1946747748331650557 ,  1118781546946049049 ,  470879165528909760 ,  311668280115210022 ,  1034745329179340406 ,  2121153224155528410 ,  1939432296407796920 ,  1709733502115383922 ,  1299674512169001817 ,  1588470279800127799 ,  1270355171213219012 ,  218964259454804199 ,  1308711816612183635 ,  2004221645036826757 ,  988906023400653881 ,  1671145044351093664 ,  755672441619968481 ,  938534900323945449 ,  2081734451320219210 ,  13928124134825463 ,  449765590241103622 ,  103614242055329375 ,  448079783167930809 ,  1823681430456904296 ,  2131947762744997676 ,  747559886640782278 ,  541188501864040533 ,  2244585123338752991 ,  1595160331217390420 ,  707424828264188272 ,  23608450029045777 ,  1338758296232951786 ,  220958607956322609 ,  2283602179205948740 ,  1892119814914892945 ,  1179499655062194404 ,  1385073111828413852 ,  1393353704498883642 ,  122161445861213538 ,  1052478811192056168 ,  1547436758899540906 ,  1994845286830784743 ,  980703642484526395 ,  2179423862397801971 ,  2203771184955418224 ,  23036037317585637 ,  691959568297481300 ,  1316506608228191779 ,  339801307977689678 ,  2254640469579531155 ,  1611569151622237219 ,  1500046201868811603 ,  1718494123498579767 ,  1981605912482145282 ,  232402922977062520 ,  925224187610130810 ,  151302698820183684 ,  1394197436069170472 ,  1116769374207266958 ,  1118105168423705932 ,  290675089219396958 ,  1888895752067922659 ,  1299825844883646073 ,  513070900332996553 ,  1993442393550870208 ,  2045470863325674886 ,  2237062412879617917 ,  1172601319651244250 ,  1974602514876829151 ,  809239565545343231 ,  2021132113732176566 ,  956212675727972763 ,  1546977039642701148 ,  1087670614728343496 ,  1929044839936562952 ,  1273348516145991351 ,  2147810186114747942 ,  82147121673764015 ,  1510350222975455006 ,  90142932618863044 ,  714496901528365717 ,  890862103424631065 ,  1047500929983729664 ,  859280234400940673 ,  940968387751930376 ,  2183337439682932172 ,  2228898336271995879 ,  910411644034904907 ,  1304501086353932156 ,  1987641283320433530 ,  5008206662103938 ,  329898765385884656 ,  2220948794634347666 ,  1399740491955396877 ,  567733170443124313 ,  1693778045086531437 ,  1479671975175005901 ,  546364026624529620 ,  686294602268622035 ,  1603721620360298290 ,  1230822204739220534 ,  1521534887941113691 ,  801297711465534653 ,  430683511235715760 ,  1962198130764269582 ,  1142702331074739493 ,  509857582842425605 ,  69567284194236839 ,  511665531662772155 ,  1773619684068114676 ,  23421631156372569 ,  1189137821797441206 ,  316160830850463820 ,  1756255113844103034 ,  1363681825190772216 ,  1393801015471872668 ,  138824988860633558 ,  1630932847119389698 ,  656341341865579300 ,  815401802027556211 ,  967203951862705986 ,  457351565769114131 ,  2172892388917396565 ,  1598158218662579404 ,  1143267825844719322 ,  1316842756126621811 ,  2005019030998782053 ,  1493936558017896989 ,  1241402154412769458 ,  2090452446119258707 ,  1764079597118975500 ,  1212922219965396296 ,  565558525300788629 ,  1126650366297192122 ,  1309280384978140609 ,  1918156685138738617 ,  256822139442076786 ,  906843373373075174 ,  847131217493419697 ,  1271457693773928894 ,  1594296218513649225 ,  1564400777725784219 ,  1921395639848947314 ,  272987438865957767 ,  782322186232541510 ,  1001079805091983474 ,  745524863533348775 ,  557914937902579015 ,  863428494700772244 ,  393451223109394148 ,  1349323609498016215 ,  72702474402181344 ,  1784645381820288520 ,  1098621781022326511 ,  1318226719451343504 ,  2231787734909769510 ,  1238850066276192041 ,  2227164844204568293 ,  1845334649159434839 ,  982914970721184714 ,  323309096381114920 ,  447857284215858378 ,  251587268687877853 ,  1563909248572834852 ,  44365368055883199 ,  980508655318112370 ,  1533687220036696170 ,  345016583673784281 }, // x^2^576

{ 1767577162773489476 ,  1367323248227253023 ,  2223202189087076840 ,  2215226914108196391 ,  157781675395289329 ,  895309246416325771 ,  1490415632650113388 ,  53293849365057470 ,  827162289655277937 ,  1746128833717983961 ,  593403875587098088 ,  128843434456438415 ,  970916831151352739 ,  1217207304867545806 ,  1024520674503019309 ,  429088594876981596 ,  1128345152832718085 ,  1622789449590459525 ,  1948934309105936019 ,  757342032110794433 ,  1166210521860987464 ,  633652598873256886 ,  1985431072464406387 ,  594903452625441734 ,  460158398184651147 ,  951122836989470009 ,  1784876198868635894 ,  666541638656018219 ,  2242423832297303143 ,  739040014792258834 ,  1409320500392183745 ,  1925757766273862930 ,  1936960809220829993 ,  586481586549272460 ,  393877104371489070 ,  1432073686723363400 ,  1377651496292693011 ,  1651805624853267033 ,  1764525407620473911 ,  392864393121120991 ,  1207782689820982960 ,  610990179723973635 ,  1608113961776516117 ,  537303054562191311 ,  499195219974271278 ,  1764944633313711795 ,  2021020117264156437 ,  1152637675092489247 ,  695119469463989518 ,  1184354500733579003 ,  422721330168014313 ,  292627802415511668 ,  656793337187638617 ,  665138078779402078 ,  2012500808964809102 ,  960491003350858118 ,  384998836955204109 ,  1283612463847963288 ,  2209695397716057653 ,  1391445829268882163 ,  1273002447587264338 ,  977457035110053634 ,  932518713696111862 ,  941138314689756691 ,  2213780577387551635 ,  593751707379440443 ,  955533543058032256 ,  1602056451643416998 ,  1695651240417780347 ,  1129256531117510128 ,  951505978924522383 ,  1467627299652328997 ,  2225471180719734432 ,  1866524799779690925 ,  1884216990815079248 ,  109407811271152578 ,  1117044039432978288 ,  2167405213660260094 ,  556444049889720452 ,  2222614026843513411 ,  1073826342226503327 ,  1787749993544359685 ,  497848565623975271 ,  2054697265790255255 ,  962008173731355530 ,  2249640544973370539 ,  2063371615756353489 ,  785013525435862621 ,  297674570240437444 ,  475050034008562579 ,  343431400365548674 ,  722828218043338867 ,  562934085126145676 ,  433960373270209921 ,  2127282862122436938 ,  588913205604757099 ,  1382921925047356648 ,  8978812829267070 ,  1828510600158359195 ,  374950423442577935 ,  269448399777655302 ,  1218382536931436489 ,  612104918684322755 ,  1989803184213587262 ,  1694212947376875587 ,  2115651081429155706 ,  885822689388545048 ,  857550192422321670 ,  1196759817344279742 ,  868250424342385848 ,  592264834136551267 ,  1526323016726796741 ,  1517983427854386941 ,  89927830977240856 ,  478723083835317693 ,  285657930771721802 ,  1793421230332191548 ,  1481470424576163824 ,  270431694669045192 ,  1878887442680509173 ,  418330858039661943 ,  2018683600985133290 ,  142003570301257873 ,  1961980010618735889 ,  1693330293620894275 ,  1648724916252875414 ,  560361765741675505 ,  1188537971101277181 ,  2245689094534158835 ,  1511189522898129791 ,  1501344226853704974 ,  583501363515328949 ,  1802347346128872097 ,  953206966840505718 ,  1357504503952919678 ,  561951654314890331 ,  92682991654335795 ,  349989925077360994 ,  1567206410517965335 ,  1081032567931089095 ,  1173308680379630281 ,  707244154283885796 ,  38078748949916753 ,  2045818190888498748 ,  1520780758493266971 ,  1038228997910723964 ,  1541377830236824057 ,  818281907049006260 ,  2104523562952260068 ,  814847908355185323 ,  1865721458813888318 ,  1111960821741674555 ,  1370723615158352909 ,  1711652369741618312 ,  899026897647721268 ,  2095897036968216954 ,  175716876021099272 ,  1352164856745799411 ,  846844748151615536 ,  836258135228840810 ,  408854739504858784 ,  1281054963174143341 ,  844257572354114186 ,  1780822123793481190 ,  1587914613179060415 ,  34702867095275576 ,  472251201232076834 ,  1029600905323815554 ,  2140774096308780059 ,  65675056747641239 ,  305722419999296078 ,  1621002497778524700 ,  1965685982217607072 ,  469612172706140748 ,  220416534769817368 ,  565779262138260911 ,  1013716017532668373 ,  483323627350055696 ,  730624222919117231 ,  1187823954880594473 ,  17932149185000654 ,  1972980677280775164 ,  1727776650925923067 ,  798833740460962554 ,  9714986061519370 ,  2078066750131721979 ,  2014858486762286350 ,  1955707037895352815 ,  4258963066706341 ,  2205443467495486826 ,  1686567505836663140 ,  453770380578747249 ,  864251319924759835 ,  1398262814393166683 ,  30258335583328587 ,  1821012823859054151 ,  88196714583649983 ,  600860470968921093 ,  229853070873335483 ,  78395480915293331 ,  1652751200500931270 ,  541497819672726916 ,  477484753368185921 ,  1217048918665980588 ,  668410437792359150 ,  87290194501024874 ,  1071233685104726979 ,  1932790193133300260 ,  2278101072886371608 ,  678729243588229352 ,  1929017111242112814 ,  1221753280798295610 ,  2257436924628271899 ,  536477981078677843 ,  1581909062883880492 ,  463443744675898886 ,  1711960571860402837 ,  1185581055027523454 ,  1652338714375936070 ,  1645653843179460561 ,  1102058264865411854 ,  801134465799508286 ,  322644254113794421 ,  662130006486862565 ,  1951958537111271773 ,  379555570663299975 ,  968494874301070122 ,  1184081343375518250 ,  2222680232772958880 ,  1847646839510739489 ,  343453628777436875 ,  1335149154072691467 ,  1720862511865900002 ,  727247795599443156 ,  1732263064213512407 ,  1694358099649082027 ,  459068968036182442 ,  41475065105941514 ,  1766568565332341313 ,  1289937637079669841 }, // x^2^577

{ 245647373638690755 ,  723228161179860918 ,  989394933785376600 ,  515085270045178654 ,  1249417796546101433 ,  155103266537706633 ,  1962649522493305191 ,  1405371244247652697 ,  1871243649288429642 ,  458089301658193854 ,  936013533641644763 ,  983501199903199654 ,  2203524010078689751 ,  1270844335849798973 ,  1960131073461307695 ,  1795873674054284192 ,  496333766337408631 ,  175371500242175489 ,  2262868688899570765 ,  403696368566808695 ,  1950229631625600214 ,  1105169763712829286 ,  480723925534276391 ,  1422940725222316993 ,  2140175825774128779 ,  144414928903659257 ,  369858619549027210 ,  2112635455056582941 ,  1705348944018777515 ,  1731528033357435738 ,  733503520572731423 ,  223591002795653788 ,  835867685475976191 ,  498978017188909855 ,  425908966724659686 ,  707737364615652309 ,  434041787946459036 ,  1146460511163493588 ,  733368330781141295 ,  555192214341495978 ,  993944629369118988 ,  1034360260818182102 ,  1282845029566963507 ,  11149598676121827 ,  639438893827826391 ,  100735130650271257 ,  1483254488608442343 ,  1953132272077634299 ,  1866683296631284124 ,  337792027792527337 ,  852788927327047837 ,  2260131314778973589 ,  1748901640916369572 ,  236162068199520451 ,  2169066984579059583 ,  1563118379122142965 ,  1703345508042850375 ,  1162776614491950895 ,  696607369827808370 ,  1002258363385524312 ,  1992062849507124060 ,  1848817589746326520 ,  15426679500761443 ,  1399171937315259090 ,  1204408726911708848 ,  417957081700655015 ,  2236058376111698826 ,  1879701229795631175 ,  1939923497708364881 ,  435436869873639413 ,  422532644647766501 ,  248847531886541936 ,  1151219706294080062 ,  765095537213717128 ,  820031871277855051 ,  1597601466840549474 ,  1117755673369828595 ,  184716515720355759 ,  1420549956030052655 ,  978016140394955758 ,  1514975139308669487 ,  871019443315763277 ,  2284082675661988432 ,  578007761511647369 ,  949634845038956009 ,  415778074521759176 ,  2027546988218307839 ,  1994561109064588710 ,  2018649227793053622 ,  2039441907725249729 ,  187425758058709434 ,  862514614120912458 ,  2183249357667895727 ,  1568155472564209378 ,  1922141005465073495 ,  1218793086585747471 ,  11229897683442065 ,  1755515833533678558 ,  1241445334730710156 ,  1564803422471040582 ,  834679421622824672 ,  754449854047228510 ,  1762251991587931197 ,  1529328898675638483 ,  138515334942246347 ,  281656796334668196 ,  1017027885271037254 ,  38957046222401777 ,  521952277061241444 ,  971499630428715529 ,  624534504852856255 ,  228976752474896096 ,  183198507915595748 ,  82809496451740797 ,  718413467746565186 ,  1555816953113440004 ,  1336708628488330090 ,  823569836165527841 ,  2190046543402029602 ,  2140146553779668682 ,  967803615746069126 ,  140465769133445841 ,  1689926038152037148 ,  1428614857806657527 ,  1257138669517649283 ,  366936863161244981 ,  1624527128747028599 ,  1516308026295850537 ,  869178535485956661 ,  504424754495184980 ,  1677849156614973770 ,  1788113752513272645 ,  789010460153647072 ,  1813777569781218874 ,  1037136267974758287 ,  678501795345976239 ,  1461667534739862310 ,  2142118406324858644 ,  221714363753283939 ,  2239299439995755378 ,  1536833822229401852 ,  1712606753781270109 ,  2084438704798619974 ,  1646663165007083008 ,  1169400919089629053 ,  185030486210737647 ,  2072730066850729771 ,  1672253596503394107 ,  1049564667236979789 ,  808132037028874529 ,  517389180169219633 ,  812682692638581133 ,  1504251943966084896 ,  1407590172406284314 ,  679957617665406795 ,  503519031457263385 ,  26443134837117148 ,  1428780494703740625 ,  2193838704743897286 ,  1622703059982025170 ,  2280228775800789245 ,  1888934924568685617 ,  2125651755732173431 ,  1792964662011010715 ,  1414124639702700010 ,  1153152899254739513 ,  2175833624099384063 ,  1466861792322021403 ,  186017143916897390 ,  1963387017520889846 ,  1673531748648655790 ,  676330919346964096 ,  225464795837042259 ,  1096005095557927693 ,  1151902670480485346 ,  1928784329082136946 ,  329366041566554154 ,  1457394099455721786 ,  2152958120700793666 ,  1602825401491580826 ,  1041033247829140205 ,  1408151800900583471 ,  737748366239294354 ,  583169525346054250 ,  2284069987124536225 ,  1577438836716073656 ,  1781404205182635049 ,  2019349001179470946 ,  1429027357334424002 ,  117734696248269589 ,  666193671217067461 ,  1775420686442050099 ,  223343602390481728 ,  1288186675002079299 ,  50171865053753559 ,  625489511748187272 ,  1380760964906390041 ,  1626453051522680917 ,  1387060000427124616 ,  759826028527134598 ,  383659352500028133 ,  1157358647008387308 ,  2228739516232592229 ,  524384287404815343 ,  2169503890250798019 ,  808589182431114668 ,  1988804043060581874 ,  344558470302310173 ,  2274381084270527666 ,  365201404516355003 ,  711928411433009795 ,  2001290472342706616 ,  231884107595079850 ,  1831450015829572696 ,  1714666537472834358 ,  1853492636025399300 ,  522334092763922584 ,  442595594565577607 ,  2198610593425932009 ,  498108189886944824 ,  1851349464357468523 ,  612824961582096236 ,  1379739358573910543 ,  1334155797539792509 ,  1731400152267047948 ,  611105778961955367 ,  2247834951109862120 ,  432215155719225510 ,  1869232957329991402 ,  411722088548282589 ,  781446166536254381 ,  2253649371906314771 ,  766599749367977202 ,  1916019878195953644 ,  560456575341072263 ,  1829863107582865006 ,  1436816867953321095 ,  1071875325921226081 ,  732394554061415909 ,  1310543366884231664 }, // x^2^578

{ 444262999451813178 ,  1196726945337991502 ,  1295017869599666867 ,  1777619695657984 ,  630087115949046460 ,  402979685694666226 ,  1345029864727570037 ,  899585963247587946 ,  400437918779304280 ,  352745060161154107 ,  1228408273660952055 ,  186333751372447706 ,  1985047533316584998 ,  1170371406838312953 ,  1649662127234794922 ,  1241720619827131098 ,  251384641126997909 ,  1051906616987787071 ,  885047141109472033 ,  1425029303522420508 ,  2161012268386343064 ,  692805957937508176 ,  547011407060013843 ,  560817272487302652 ,  2226152430613237 ,  539735511754228121 ,  286297902017269537 ,  566370319739832124 ,  2166729101697818466 ,  404901845612913643 ,  1782223246017533789 ,  1747478405837983079 ,  902063790659283153 ,  907994135491708822 ,  110601404988527990 ,  1883009438893829771 ,  1728181307175597243 ,  798139764003245804 ,  1437942835719665811 ,  2234613826552889167 ,  1573768847010760781 ,  588063689070900106 ,  2078878106379580040 ,  498625436932877454 ,  205068807307268035 ,  1531568093600073716 ,  1911612807835024027 ,  1797036634371455214 ,  955175538738110968 ,  52147714681594715 ,  1836459629240987362 ,  1052369247530825377 ,  271562118354619855 ,  1844975600825143475 ,  313865658282576733 ,  826422128717593612 ,  1151571252158861831 ,  1013297434399132872 ,  1997895830134241756 ,  1023631845290308799 ,  308430927883527191 ,  416657183326150961 ,  559121849545400831 ,  113775695086882580 ,  115066404950752837 ,  940701446321325795 ,  531920528353797778 ,  1994741741831638229 ,  698356717427082884 ,  1961512716137836253 ,  1895119526342822259 ,  158073456101498378 ,  1930002066397082864 ,  2235792388726309018 ,  1255975970302799245 ,  879820523203314479 ,  50935036178447541 ,  1422346509707014298 ,  1878674900507502396 ,  1573897552683364844 ,  673434428509993025 ,  59846998459492667 ,  880879969636326828 ,  889260379563954168 ,  222649276671419752 ,  1264387441559248035 ,  132656196174301553 ,  1617706742202308887 ,  2076583957140506921 ,  2175567692630578556 ,  441698758900039541 ,  165426053544824813 ,  151695268134147765 ,  126911720302188544 ,  936020944901045536 ,  1818814490066737889 ,  1274385094023027904 ,  1373873671581733049 ,  174004770300338407 ,  1073518904489391506 ,  407670067342761031 ,  625968632303382876 ,  1013328117137678336 ,  1791895550942914416 ,  603111681969184457 ,  113199064135485166 ,  180741191999007795 ,  1249493506548500578 ,  1972224100418165259 ,  403393725008018578 ,  958870396965570503 ,  1034891902712832305 ,  2004119610683070554 ,  212257562596395755 ,  1589990603959511188 ,  1146300723327393307 ,  658265118370539245 ,  175165041869104271 ,  16335039789971451 ,  470139121460312164 ,  809451944762409876 ,  122017896405030403 ,  1300236714401712026 ,  2228638216564654418 ,  1714777253462109625 ,  47539534325792873 ,  1683733316971353738 ,  902949779073152934 ,  471602174320977706 ,  2304715227808217180 ,  1627234126804023071 ,  165001574486205577 ,  1072294689364207399 ,  1202442259040375106 ,  374849438794815914 ,  490066095477988340 ,  287619788100008544 ,  2147165039068761460 ,  1239936082914950061 ,  1031581326968142200 ,  1117642104108166540 ,  284679636372306504 ,  664998073261434484 ,  896789140912336344 ,  111000644438127005 ,  574421053148100867 ,  1638547650063056246 ,  351475960938318915 ,  1217230346153153467 ,  1947467790437249980 ,  1527501663877634726 ,  2154928599807018747 ,  1499319138106210154 ,  1126065329545522961 ,  60560722563919643 ,  246299520569730999 ,  1617735536620073079 ,  1600216920301967003 ,  338171329701600657 ,  2129946411991223133 ,  41308306219579800 ,  1199214109219479720 ,  1134910989734832035 ,  888099127490049309 ,  2159152819369107497 ,  774557979493059370 ,  2085129710830747814 ,  1044202716226925572 ,  1132634336260893229 ,  485670231054971137 ,  1884540240665389936 ,  416908279475759100 ,  205087074923545371 ,  2051798225952186644 ,  999508577854263739 ,  2297966672429681186 ,  1116439400732121618 ,  1604341669219597078 ,  1329665420657489242 ,  1019110217711188872 ,  1198010013600486766 ,  1538354626043221881 ,  1164084835444273892 ,  769589609790805167 ,  313863581186264872 ,  935278600676530758 ,  2224994282330333139 ,  970748943005384380 ,  1565158451566890346 ,  1857422563705313972 ,  1055555264092481056 ,  1226195946064381757 ,  344824315404909257 ,  981207614121822384 ,  552212669790338415 ,  1910189837231074002 ,  749461264413877418 ,  238358466364827472 ,  1327819370355889605 ,  445786450134214841 ,  2209625780330666270 ,  1109109508853957852 ,  1196197438376615507 ,  817779525510027453 ,  807620266971696385 ,  1273329160316793021 ,  876503555718250733 ,  275924375007372915 ,  979551382820500413 ,  509020789994923680 ,  1206963638222241397 ,  1309316478708081304 ,  1182518505967991601 ,  74874918900548207 ,  279226508781567419 ,  787058475554300008 ,  1789590470207394304 ,  354148150317594602 ,  1940110064211358935 ,  59283221041026913 ,  346144763295345966 ,  2230747783546741810 ,  2275086647600438307 ,  1762044499692525101 ,  353260426258525488 ,  501301154584016566 ,  815673854552566999 ,  63351416216243744 ,  1903057422659842605 ,  2246284721869675507 ,  381914004665389434 ,  2191101327311590329 ,  2005166843367530375 ,  282534531067415068 ,  1713247268843597775 ,  1734613521731595445 ,  2006339191288875787 ,  88704854664583561 ,  1429777622344153919 ,  1274032905747213312 }, // x^2^579

{ 1068853986298457334 ,  1991750511174884139 ,  1208588714899884799 ,  1238335990925313809 ,  1652325469240775321 ,  450455641933291665 ,  1954730061059047762 ,  432804582075052336 ,  1356523848980958417 ,  863487915558497910 ,  2152309487571299612 ,  459490667505200439 ,  1448166205558464437 ,  2103774999642969031 ,  2029529844431405058 ,  830867950929040377 ,  2227352714329721860 ,  165066510297408308 ,  734989760733916984 ,  1097005608151204345 ,  886428185778231896 ,  743410370430501937 ,  789677968545171694 ,  1434798499646014153 ,  587193468032709871 ,  1839618331813775726 ,  1266877455456576005 ,  1774397904604226103 ,  2269883165629034452 ,  850185441730708080 ,  1604542924485658262 ,  359561781894491237 ,  73122350684231415 ,  951126154136227184 ,  1100516013721493125 ,  627583424241664440 ,  303912258012756190 ,  1097684291840373504 ,  1417965296701505784 ,  1835817795603059947 ,  943190850348348425 ,  1293953607052923228 ,  633361847574768266 ,  370311930420255152 ,  617768594750788252 ,  1403674815225486909 ,  1469524969318865919 ,  1366620789872153553 ,  1255246452094664024 ,  1338137880251711756 ,  1380076749578019391 ,  761120580531584575 ,  1704951125135259988 ,  1137026931916211122 ,  1068392879904457843 ,  1609720767721962798 ,  1871364608963983909 ,  622855072811135053 ,  2039992454636479019 ,  438631165675914452 ,  1853542619672034908 ,  470356737021419117 ,  1322132691059157732 ,  498558984073752207 ,  1745848295202945694 ,  1035099431272711838 ,  518251046144732711 ,  594615107927166835 ,  667458517840948469 ,  1505544945459862998 ,  427768740041129927 ,  1452647633760562675 ,  414873051521476020 ,  868961521165960538 ,  672047169362470033 ,  517302689595500833 ,  2114194701817093454 ,  1335774833121941825 ,  1286461525119607037 ,  24899789299058661 ,  1148181603866287282 ,  507151607633600700 ,  1539927207620754800 ,  1230167762698696720 ,  154842019442015064 ,  201761743048956136 ,  768323047699257214 ,  113296450798326621 ,  1261959907361673976 ,  1034748231416817772 ,  1028797737994774965 ,  1517654934642170542 ,  245106361342420124 ,  1964575053502778311 ,  1175896410147880584 ,  913021522652089008 ,  1045540274891956428 ,  1223471914009967024 ,  1755910525668953020 ,  2022056001018217881 ,  1444619176715455291 ,  2038931385680236689 ,  60833548269116899 ,  1433818600801799890 ,  1636989011712838051 ,  489832321998411379 ,  1058265130243976892 ,  1963867379479006989 ,  1448907502294087497 ,  1307367301107092931 ,  1338771799188916978 ,  1823729185044186985 ,  1165546613323272872 ,  1095533954703296010 ,  1465978923774085426 ,  2125246857655595979 ,  1543533955634108779 ,  463858050154545361 ,  2298767591655172517 ,  1399771148620682076 ,  504182040209409667 ,  440244584906785839 ,  2134817611064572187 ,  681440870322285638 ,  255807025638810385 ,  1261455111532901704 ,  1937829581892526597 ,  385651928080625132 ,  1728486950080252158 ,  1754523350081238514 ,  848169707367938213 ,  478572409770454740 ,  715818149487655998 ,  1801907576811361675 ,  1418297345433141588 ,  283562132316330043 ,  1601825007122753590 ,  124955760297466947 ,  1577835778662883686 ,  2215082410816627530 ,  1455804121653500729 ,  713159764412891846 ,  1083357004872915670 ,  952807202529809554 ,  129799109808311914 ,  279544230922317206 ,  762694099538621067 ,  943940718617565532 ,  239691650092783020 ,  2083995788460976778 ,  1186244458619067989 ,  1053120195396505370 ,  459724165466246935 ,  2111892274111760067 ,  626752045879167244 ,  1363937379554571542 ,  1247288404380891757 ,  1913150859102348343 ,  1352242803022148319 ,  44116972967296015 ,  1016542014929733621 ,  317331250031043947 ,  924864081393294845 ,  510476002582020062 ,  2252227191574417634 ,  2269120491972688905 ,  1640758251882152986 ,  1636153139265606035 ,  1085645829044753263 ,  1402072052650725872 ,  1333776931717406521 ,  889584479024667411 ,  207108050347420675 ,  773357293882904012 ,  1314529968815141481 ,  1684251152661814237 ,  1523113368995246283 ,  2005891675292127100 ,  809681632896702607 ,  403268813307414926 ,  1448628397432606543 ,  197889107762619396 ,  891578967127883301 ,  1689664838614303780 ,  50636789520966185 ,  185318881436733378 ,  724561800226214556 ,  1699418084756539475 ,  1659075980166318433 ,  470130188136765538 ,  1695124755271992689 ,  76795409860771145 ,  1082370822719223899 ,  301266935779503287 ,  1518499432536811330 ,  244914298221022177 ,  216726165537017562 ,  445883527580128239 ,  1464810174177850680 ,  3164980037367216 ,  1460319940145013739 ,  750418572452670611 ,  730152126687799315 ,  1580625255561944538 ,  1345164862123095382 ,  2022698720874064378 ,  1924883918532098438 ,  1558736085310032498 ,  1847924117525976314 ,  1418988634989479002 ,  736523464062295771 ,  1206392908022207590 ,  1057406304074693052 ,  1136002960714583890 ,  1201733983095015411 ,  1991059340992484850 ,  2249975132078706198 ,  509720536190992383 ,  1891377941658119908 ,  2085608266851072153 ,  815325074695079413 ,  2037708634178860807 ,  337854648566011434 ,  1321153223075788556 ,  403225707347127006 ,  992369686438153080 ,  1474587157266240958 ,  1520724653315958724 ,  2024304722014830770 ,  1887205052467810932 ,  847129628581099901 ,  1368407171250816170 ,  1722274572775896162 ,  1817820340016191550 ,  1309436644548923019 ,  604832950615705218 ,  838322908833843141 ,  2301656895105003106 ,  117095605027557663 ,  838434540307595140 }, // x^2^580

{ 133718003771229742 ,  88580512144606202 ,  1209117337056462273 ,  1929885918704857505 ,  2115472581682907883 ,  1994376878088474296 ,  1672526460886109998 ,  204329198036702821 ,  1729944095070353476 ,  2088788029551022088 ,  1417225145060193880 ,  1367466276437062579 ,  549106010617935199 ,  161818589989808131 ,  2188885984814200991 ,  1338183128633666572 ,  1045420477646075420 ,  2101447935818346727 ,  2149293501717384956 ,  934371789549262094 ,  2057867426556533814 ,  649933598774005087 ,  889744547729495980 ,  1882612387359685730 ,  1937004959834813310 ,  589616299793027227 ,  1771103603012921105 ,  1728074008613959050 ,  1034609262555766370 ,  1550660094870041865 ,  1464207136196940043 ,  405288493971444389 ,  1187993486184423644 ,  1845410128973362239 ,  1794832821117975257 ,  1055596821856535009 ,  806708140866062082 ,  406331497243495898 ,  2042915356191450975 ,  206644819866995179 ,  378281969981502965 ,  2278282948288615839 ,  2189930254676842479 ,  2024256992168690013 ,  1957056565287927890 ,  182127632696991893 ,  87977583747292076 ,  2020598505164977726 ,  1777524939323812821 ,  727392275290208456 ,  466809580720013849 ,  1960363313378664734 ,  691890704753508863 ,  227071066061546777 ,  12081115953295506 ,  2079121494081252175 ,  282514775862801976 ,  2288694191147597317 ,  2284140595880308406 ,  1623546446649008286 ,  551222586868395823 ,  1601607532930276067 ,  1953973470636525235 ,  753716207641545881 ,  667867146191217923 ,  1659598801035736671 ,  1015603755819349571 ,  1255549975542681919 ,  2027012972247909217 ,  2179444257798961398 ,  966838684036058056 ,  791127235757395085 ,  891784982945298736 ,  810625919420042001 ,  2137361394066954370 ,  1110476752927718025 ,  2219836766842413810 ,  1082861481056995845 ,  254088947361566155 ,  1080608082848836929 ,  152999007771633199 ,  1521142356915797870 ,  2160303218782046522 ,  792961221587378444 ,  1678527546318626375 ,  989172763992105790 ,  405173902522616807 ,  2019080236895310482 ,  1982623864417190240 ,  36314796813453089 ,  1475770868854908341 ,  279832195195235891 ,  551833767985759052 ,  1239681202079558141 ,  1420888181900493922 ,  1595612289951694038 ,  296673616809797766 ,  1683735061901616220 ,  1740540941757703341 ,  1485181163933156017 ,  887351165358773552 ,  1756382484418856336 ,  1660921909541296188 ,  1924749893551701594 ,  1810391900007404869 ,  572441134774892418 ,  934785352676096824 ,  1100831997311858295 ,  1400015442918712646 ,  844884725745308026 ,  1129762138273387477 ,  257760510778769041 ,  1798132405556588684 ,  868279124757615828 ,  1981897149545554905 ,  1849355145191629251 ,  408934810849543331 ,  406489437069112663 ,  594559617001961797 ,  1112495004310480415 ,  298919039311940534 ,  168510807365411614 ,  1311483931762186236 ,  171402749739502637 ,  937148736340850129 ,  299668409250205049 ,  1387397340037240922 ,  2080986055078299666 ,  112631658077460999 ,  680311167791097316 ,  1878477857698083804 ,  194125625724646095 ,  1727887092599523125 ,  1437285586401877375 ,  266231076168752835 ,  305135453859685571 ,  463222323986941039 ,  416811845296230648 ,  414058846580534222 ,  1077489181866491715 ,  2163331029140166619 ,  9755339451158953 ,  1494150969618508490 ,  287328701726557557 ,  492460708751670834 ,  1608151807205773682 ,  1308604076802037979 ,  368983834952390981 ,  1508251540253601862 ,  1734924024532911269 ,  36849951057051526 ,  2089355547201236513 ,  1609078741590776134 ,  774129851734087447 ,  1079408801583994794 ,  2207983244983171890 ,  2120694486378094295 ,  396823664471937883 ,  1315789719692816834 ,  1204356251938661996 ,  2159297207948450451 ,  1588319421345584934 ,  2255269115900165799 ,  403222245109058287 ,  1133771623572594879 ,  64379268613924006 ,  764554119831164819 ,  588012025270255918 ,  1831811686918895187 ,  1938691642114310247 ,  441343455200227790 ,  1311427627683021418 ,  1986497492064370957 ,  2128632625182728410 ,  487148674962795086 ,  2168942838604041890 ,  420897346582405855 ,  913563181226672050 ,  568542726229132690 ,  961297714757216440 ,  2138858010793789139 ,  1000292995039517812 ,  1141375760860384093 ,  1697628622549738432 ,  39714181089764264 ,  426334655982250453 ,  750493414562208982 ,  1957217538071554922 ,  22336693789753619 ,  518439554639396078 ,  2220776615225148954 ,  249555838987196327 ,  309346466209539687 ,  672743672414174168 ,  1361666592770747621 ,  1556256670022067746 ,  2094904242708520789 ,  1925920204072447523 ,  302510870794461573 ,  2193968606822198928 ,  832979585736258200 ,  599658915790076817 ,  15073774114348418 ,  622262324085990084 ,  2184802444279108153 ,  2042852643233992758 ,  346844196803172065 ,  696561048019257640 ,  1655155364137586968 ,  1985437875103993434 ,  1279926894321876674 ,  716444524074015324 ,  365913128111449021 ,  1191114847505673092 ,  1544361914792954242 ,  2202151859819553299 ,  1990721761893444590 ,  2219923431239315050 ,  2133369008944634033 ,  498805787446541292 ,  1357120528168779095 ,  1264942877198121725 ,  1405043968154898153 ,  2141809133122601340 ,  1979272852344828934 ,  459849714059834601 ,  387361699835113482 ,  1919303176601986615 ,  2170354638451489635 ,  2254915584951441559 ,  1618454075296321205 ,  1172143742348322240 ,  1036803872209685604 ,  80037767118159841 ,  1203208571354391753 ,  249077489172794530 ,  1383802100008298058 ,  1402617136777090303 ,  1256756302014493013 ,  879503282141869660 }, // x^2^581

{ 785576218604252842 ,  251885225723319355 ,  1941587184097489054 ,  401270013743541891 ,  236759252174615976 ,  403584417311662501 ,  205395071782979794 ,  1792483488463685169 ,  1224921059142968031 ,  1985764186112186864 ,  80017543901499987 ,  981838765289803216 ,  325655223532638090 ,  1823151661238169996 ,  987664063721205453 ,  1742377427831057353 ,  2124803696863626056 ,  716550315928932500 ,  1794381971767618050 ,  1412921204198984889 ,  1200937982281378595 ,  293571731980907153 ,  360880303223771731 ,  1455724854556352080 ,  906907119791731057 ,  870785847811895713 ,  1104275690294539692 ,  1234468975280190916 ,  1241206483698038643 ,  1998344636957083278 ,  224685231279938504 ,  2125533067589923696 ,  1080585020439402103 ,  846489742300012570 ,  692221143733039674 ,  544983188329733673 ,  1929670176461297137 ,  933668188979760971 ,  992391867829492249 ,  2047528610402695672 ,  410702102931493262 ,  1712221635842991030 ,  2271656988969074288 ,  1135659295340122062 ,  543592278254027950 ,  399758915567648171 ,  421794380626841731 ,  110195585997361997 ,  582591102712881872 ,  592886247879658113 ,  686114951019514516 ,  1024009805372562041 ,  1149414422173430768 ,  2156800457284061585 ,  767620202362993125 ,  436003830460395933 ,  1811425337729262158 ,  33528697491587012 ,  784650636405933941 ,  124716464422824414 ,  168131838978294872 ,  837715498132632100 ,  756971168665175795 ,  2027235634034839808 ,  158597074583375810 ,  2208763924262683101 ,  1162016172349654855 ,  2052667782988558550 ,  933623285055199111 ,  729292053054510976 ,  1882590234555432280 ,  705987214539294368 ,  385922807874103850 ,  241725963163649589 ,  2052660769792402683 ,  1137710783267781148 ,  1189195685053110338 ,  2009671203824464717 ,  1036545054449008584 ,  1096295309931869475 ,  1267584382489364665 ,  1473180373396372917 ,  1916125887545051244 ,  1630625050229564583 ,  1519065779634935963 ,  1981007174377771077 ,  1007617740034972379 ,  423131686391252300 ,  1426561665278311399 ,  1082352523823873191 ,  2001444167604203727 ,  250492692492754300 ,  514654637613981831 ,  484917571313233564 ,  2258517389132099425 ,  254164419610418729 ,  1228820863658701807 ,  2113281444244313197 ,  224386163588701939 ,  1083304649545624469 ,  330732239882411392 ,  543301959956662053 ,  151230996027300823 ,  1409304524671568481 ,  1660572104301000622 ,  1412493311540197249 ,  421971867563119110 ,  440586390913915398 ,  1311489013896244439 ,  846043460560557835 ,  1685530252831768902 ,  1021805086285062821 ,  74430186917776769 ,  926359774244008110 ,  565482992620491976 ,  910264016192759565 ,  371531396086484519 ,  1367447618018733913 ,  503031032912899124 ,  1629867003130940010 ,  1630687412607461570 ,  1568596489693560764 ,  2194273748917671962 ,  405146929301693839 ,  375918777204364671 ,  1184527039909774534 ,  2124937490536989709 ,  803980903410507466 ,  379861260294883581 ,  809646006514119043 ,  582374352853019104 ,  110549617891529466 ,  190784844082024599 ,  1590631579476487759 ,  239037551884852839 ,  1067326773542751602 ,  1502781395347009720 ,  1230290872421861675 ,  1156226968300402924 ,  1264676625199307419 ,  1255127908430462884 ,  927259528164133415 ,  1546379221318272755 ,  1829733459680187424 ,  936504115503103273 ,  624185687288761410 ,  2250957737252390270 ,  1718505018006136710 ,  2006203413289328440 ,  1056579427424492159 ,  2040676953053522851 ,  1595150759911057720 ,  1574829328527335144 ,  1162495191238981900 ,  2121773260065588974 ,  1374136698334065583 ,  1517831757089830245 ,  1228053344237617083 ,  1133397934827370919 ,  1426541968976089876 ,  1632219129565559898 ,  738370581452007476 ,  293173239279685083 ,  478557264516044563 ,  16365431111652558 ,  1512603052365470523 ,  852352823980823494 ,  1115947247587039193 ,  2077163499350513162 ,  2197682313378524592 ,  668279477618389719 ,  860097633257273067 ,  372350656938241929 ,  1302075725924812063 ,  764203254520836528 ,  300029711579502891 ,  226903439928368463 ,  584205908270401797 ,  1758859411653290522 ,  1570220041766912090 ,  321788567775175699 ,  59411273469078066 ,  936180077968040410 ,  931481075106697371 ,  229909749611122572 ,  842626491226464517 ,  1123958931638173502 ,  322404029133869769 ,  842173434840542894 ,  519654531464116526 ,  1795889522376556444 ,  1691170839653366646 ,  1852254785258432391 ,  1297237798173604850 ,  1197910064264301247 ,  439498819846739110 ,  2276815096456475187 ,  2088557090197743759 ,  2300059031660651150 ,  2242694900966518597 ,  900182840755983668 ,  1440230589809261167 ,  1184138921092510008 ,  1095643865242079490 ,  1900192139097182254 ,  1927701051738673795 ,  2148874555756942929 ,  2117444242732377417 ,  824847525908515031 ,  1597367628966601846 ,  2038005915336454617 ,  609762970110590463 ,  2140639065281272098 ,  2171342291954188582 ,  860849110783239337 ,  285926943075505395 ,  517015631844660098 ,  192230945903401533 ,  586593956693683637 ,  632330688548189994 ,  558518039282490025 ,  966895307002484438 ,  1321234613705362007 ,  787769301328852226 ,  268038548504117593 ,  1757125468100052075 ,  237077787256957685 ,  184145555253215126 ,  1208147386351790342 ,  1052760851075168911 ,  883498796842211635 ,  2191439134288409451 ,  1895692723791910521 ,  1203030661245072739 ,  1651471727873501467 ,  1065974451180473417 ,  1942680366343485862 ,  2063493430939286234 ,  60100160403827834 ,  2246792956828761099 }, // x^2^582

{ 266409043597247201 ,  627705255078968639 ,  241049891527722328 ,  2264419133167784326 ,  765267795654321470 ,  1713721214243842935 ,  14666134923698424 ,  1508683964394741526 ,  127810528899507623 ,  210170867589788884 ,  203855235663960882 ,  1199038451429916879 ,  1698725091126926789 ,  1153433653707016283 ,  1143990912526915362 ,  899681012098097561 ,  167234045689844254 ,  1949956083143158740 ,  746167568022747361 ,  1257453304216402761 ,  736610735923784555 ,  435255789794118063 ,  2014625437680419834 ,  1268490201985734809 ,  1266534269833934399 ,  755642290821761826 ,  1454074450439365439 ,  1654940223619692382 ,  480375402025173467 ,  1848636017426899926 ,  701658181147249519 ,  210947180587922900 ,  1432013180716478855 ,  1610047007486213548 ,  802949889800052641 ,  1119923410022595310 ,  131440848203991452 ,  732080268507046260 ,  268863934621060849 ,  2112290681682417398 ,  797369292488553179 ,  226334591844393133 ,  989284872893963971 ,  1355897245210444861 ,  768570332493445262 ,  561630913169162645 ,  2049823225767798450 ,  2292337580632574711 ,  1046080675001460239 ,  255161182923125371 ,  2443470440262480 ,  893089250752284704 ,  1787724036685869989 ,  1595759298382703536 ,  1208869402361342605 ,  383849610420443230 ,  316682778807879395 ,  2202270741195242070 ,  1891639349353576124 ,  2179466032795956646 ,  145802095756516744 ,  1981963091151580239 ,  2304382001008310353 ,  1996186202259685367 ,  1656274327334693091 ,  985237772170527283 ,  1927611262859267402 ,  944288744529957493 ,  1986413213983366392 ,  1960792902587839159 ,  48861523723842298 ,  1445625224879869553 ,  1282912193906085842 ,  1116008118084618711 ,  821502424218133505 ,  1340276899042494156 ,  849597265965289394 ,  268803663732986547 ,  1899775431197698040 ,  1423080581506170289 ,  120197913303244996 ,  756946373957495987 ,  1736825239929481561 ,  1490024390374984645 ,  1378539567916227888 ,  1237897676674774950 ,  2017350912125565487 ,  2049957633767629795 ,  249210228468792666 ,  363118840826815920 ,  2249579870787005825 ,  2142060226737670353 ,  2133141914566478081 ,  1497047823950691270 ,  38553350606904012 ,  1293522052378259949 ,  1866255089804710317 ,  519760768742126124 ,  688710406169804980 ,  1795684326773796672 ,  108838550470599500 ,  747801470343147077 ,  924340240748964065 ,  1409170309323720694 ,  1108751184311125410 ,  1221449982026798067 ,  1022433519730641280 ,  716161748714738068 ,  549494088209557664 ,  1368949680629535011 ,  645271711184104853 ,  1454932886005639924 ,  1327781651026112162 ,  2019831040203522022 ,  1112354423400662363 ,  1823672304735130801 ,  1431928752739191250 ,  1292549541677137162 ,  1338934545780771160 ,  176411189630537288 ,  1792965773242758311 ,  250808933372059527 ,  1435388873625690716 ,  921970855928570490 ,  2231713497264467098 ,  417855448932067673 ,  456365119153385704 ,  192915776296809493 ,  1893577798246655405 ,  1570330119935096205 ,  1855912062031481380 ,  770735373820266924 ,  1554136098632482664 ,  1525146417942407929 ,  228355717416979613 ,  2295955971495311730 ,  1399096059935185100 ,  425312080448133599 ,  2042132363714204971 ,  204251001155280874 ,  463755509312037825 ,  1781288276946955728 ,  2022725372678507069 ,  2229966334173188225 ,  467355549612904439 ,  1476051983394210398 ,  1762730683865076582 ,  1992838299337851852 ,  2201074367421054590 ,  445623222320581282 ,  142347071288937900 ,  2072458004872133731 ,  887977415024371856 ,  505458367215540462 ,  911023299587541949 ,  808056501835667300 ,  1934979334491401068 ,  206220181371356300 ,  1975715636884148512 ,  1569082074567650573 ,  1788944639427201180 ,  208493170488382557 ,  1947913108206682559 ,  559520034156872252 ,  746260462827326118 ,  698668580766440265 ,  1187658346512222064 ,  209873520240071553 ,  2197525288871096280 ,  1607546208260216411 ,  665259860016141166 ,  1922397389792618287 ,  45200055492812403 ,  1561858941732058112 ,  437479111471950615 ,  2015993662686383275 ,  852106805644448209 ,  1141030356260478676 ,  856685415242696110 ,  986500196639585353 ,  1866966638662133295 ,  1882540564485140614 ,  178933177930882151 ,  460298190553102038 ,  309825145198434167 ,  731664871029421633 ,  1215159419576491009 ,  2265774266693182052 ,  41688176411358888 ,  1465089505162460058 ,  504289555231989642 ,  2039406327468809050 ,  608191662762832671 ,  281336067833381063 ,  1527966848442446730 ,  679587379096270410 ,  208502947148849935 ,  1142068792185814399 ,  1630434396544820782 ,  1802763379939452772 ,  1984110038960299950 ,  1072405587079559895 ,  2033961410665104574 ,  868285701605488652 ,  782032347256815331 ,  1366770520299650942 ,  230056505533543462 ,  75456226959657379 ,  1748396559480390007 ,  16102655759515971 ,  846091011337287580 ,  1449185532106297760 ,  930398136036453068 ,  1332688902787031308 ,  2026100955012314474 ,  1735775133938890822 ,  226707863808969961 ,  1691689857020506154 ,  44335491962482156 ,  192652760538307748 ,  603410982243276190 ,  1481789957066607076 ,  2134356795396174136 ,  1770743821228992808 ,  2045949696890247729 ,  1804894343871436312 ,  729366875176888853 ,  1340085893695458068 ,  2107660253702698158 ,  1089906775784276112 ,  2199036277872650442 ,  1481389139905881933 ,  707432649457828102 ,  1577612483831015320 ,  1660170982826886700 ,  1620581069521363560 ,  1384717975694327022 ,  1638162676105347291 ,  1893817989948389042 ,  374139496541254813 }, // x^2^583

{ 1089933850881170838 ,  2044936142201067819 ,  2028977460485341308 ,  541370721017739460 ,  1587519993954893553 ,  1810534071430800624 ,  411399896830638408 ,  1109438151375618282 ,  1339043111626249946 ,  787152278987112725 ,  597411538211377088 ,  1369415209764120574 ,  1226837055083533287 ,  1732726523460251146 ,  866570025698044345 ,  285437094977639627 ,  961547290755494096 ,  1241779847303147648 ,  1510943962276832522 ,  901958186799598854 ,  1631828150461798081 ,  614576384835330934 ,  2004892023357163268 ,  932160642557580034 ,  641388060357759327 ,  1246426413069254851 ,  1109517581112161296 ,  452142226338525259 ,  928338158455933154 ,  554924863952162816 ,  1178370785312354068 ,  1149295738742526089 ,  127649856087873652 ,  977126215091041894 ,  313901202292814306 ,  1543382086559224321 ,  247504850410869043 ,  486336953104851530 ,  1060145123241988931 ,  1858563207574330908 ,  726481339912293789 ,  1556230529547054833 ,  1556394924398704292 ,  868548809453913461 ,  2016490927039710965 ,  898562327034480501 ,  449144849795918387 ,  1959622808072085602 ,  1618025220508097668 ,  414442608026897226 ,  44984648697063663 ,  528649545880954210 ,  1335252008615524137 ,  1983554521312505931 ,  1278411210391935114 ,  2111195390790270618 ,  150893510166390280 ,  1701983880200575666 ,  1285314642089390569 ,  227145178482823880 ,  1484747038536178973 ,  2131137206072408123 ,  1512929668583068316 ,  1185847391666293154 ,  812347627816559539 ,  1995643862237434668 ,  550924945541284122 ,  2264140139133658631 ,  2072272224964514699 ,  1754072942912252412 ,  314477988833492460 ,  437863382133651875 ,  277284255979515596 ,  1109645499054309254 ,  2188627435256192128 ,  1198204281704536352 ,  592611143228565275 ,  1939582834055766230 ,  2024067549703339504 ,  493538305504271394 ,  925717475638438075 ,  2077359452168695655 ,  845823986481076984 ,  1686879406765493140 ,  682353868533067302 ,  808776843628499116 ,  996186773030110851 ,  322047156283556429 ,  373385806814184606 ,  1632473811923309402 ,  1699834488225721175 ,  2251011519785776742 ,  384062045798304196 ,  371001200591780117 ,  1716434680275908081 ,  2127054849713616405 ,  2217487524299956163 ,  149637311986823425 ,  1095275409391964980 ,  1527937194385342938 ,  1551140166945739320 ,  526148997279229550 ,  1462431576706529848 ,  1797136963586543978 ,  275147513854741874 ,  273375686904355248 ,  1244609041388892195 ,  1290912640739779707 ,  577363966318817559 ,  1532707035009866322 ,  564750779316574441 ,  1935043668884707934 ,  1972091223622176985 ,  1922460441322872691 ,  2032404707966810983 ,  871960267945849612 ,  1016000668559571555 ,  1734810829824600295 ,  967122620260658005 ,  2292173093913958875 ,  403025893079577271 ,  1457771201772406014 ,  1714093767398774886 ,  1979598836303453279 ,  2124805136401933659 ,  696663610750952504 ,  666821562156533464 ,  1245282476117214574 ,  224179233464808077 ,  1595746895467497952 ,  2045698030176062694 ,  980902330373263330 ,  810000801263180524 ,  1568594684278555544 ,  2232263771768626215 ,  168740540616013543 ,  114968752263257752 ,  1963582146572808944 ,  793513452685684800 ,  1575686132197766454 ,  1846190915985834913 ,  43118705369284983 ,  1737313775327073761 ,  101175524195577935 ,  514390404306448925 ,  374130680369162812 ,  82537228996609627 ,  1186108775227778216 ,  1017173067620418094 ,  1385401373212061498 ,  902895214779765937 ,  1218867036366004589 ,  851973570086339102 ,  1191313916833616098 ,  1163380464393885880 ,  1213246231460265275 ,  885920681841696121 ,  2079451528233856141 ,  121815623761217693 ,  1579767776342287153 ,  2035357471214608252 ,  694337137580779781 ,  1219131265230053333 ,  516465567430461741 ,  1800825565499471848 ,  1669185959323457979 ,  180248100083445141 ,  1360003368826684145 ,  1040719737256603723 ,  303557411684538552 ,  173701481740687991 ,  1836063518080285727 ,  1792240804452977340 ,  907480304137721017 ,  431611978662077324 ,  881070244545379885 ,  1194656405655921911 ,  2170268808837858549 ,  149924176979581745 ,  624718062836482160 ,  50748099155058950 ,  1837839480595849260 ,  701271029767363079 ,  1959370197369347413 ,  2270593942507971967 ,  652725931566051604 ,  1346534227996132757 ,  1473545420279756882 ,  1009339655429674054 ,  20856838521575838 ,  530572383011701842 ,  311484570903067063 ,  2127226038638065281 ,  1603142381634430291 ,  813991856263428473 ,  519164936021223455 ,  676995252199598730 ,  535483518819691333 ,  689100327746432257 ,  1264946449110365041 ,  336155791696936545 ,  397601285704819646 ,  1773327641336299710 ,  1198332073618954913 ,  509243907081446270 ,  687371511723362307 ,  1094689378132889210 ,  231122237024651321 ,  2125706136464544142 ,  348822786272362436 ,  1364176452197990922 ,  116812319970817758 ,  485120284802950164 ,  776869423015370201 ,  1416092320634663691 ,  223003228092259097 ,  1879566234302159807 ,  1196625051406996653 ,  556617872368273774 ,  746360181728394690 ,  1374788816268097639 ,  2214865954083133514 ,  689237721228371052 ,  2255452259305985214 ,  1748476816773602860 ,  914523387094138756 ,  1878101116289047730 ,  1157712470131309939 ,  1609339627206410916 ,  1078556283883305964 ,  2277362755442399337 ,  2254396306812613351 ,  1733789593061323302 ,  776591840052892609 ,  1649743108409928498 ,  1978827634234448142 ,  2142479229485048712 ,  317874812789124760 ,  914289294870582300 ,  210733631958449554 }, // x^2^584

{ 2268172685133936152 ,  202628667414217110 ,  197844814000822320 ,  1330698976016591657 ,  2215765939126548568 ,  2299862805635551987 ,  202547025219862514 ,  1622623527999308803 ,  318198851966134483 ,  1157609134825343043 ,  1792424851493277131 ,  911409363637850216 ,  1603410814582634890 ,  1165777042347812734 ,  287174737698987620 ,  2073344198643795110 ,  606984229913491413 ,  1715425861741355624 ,  1285093920049251911 ,  1697128335629248530 ,  1450020800326267577 ,  1678593470015395598 ,  2292796181675562533 ,  843733569741842336 ,  1637214892994501658 ,  851443085809557674 ,  753001061780921542 ,  2002132283129063197 ,  1881288321759155698 ,  552630259945362721 ,  1657551102081684724 ,  1616286708987070970 ,  2146845958662107152 ,  1031163908650654710 ,  1493470233491775928 ,  1168260593039128790 ,  478937649906332295 ,  1435134605472574493 ,  405422194624561560 ,  87303048110128524 ,  1746763611240131040 ,  2098540367462235558 ,  1095189409464531870 ,  125723311085770920 ,  1914400698978520793 ,  1522344102790198904 ,  1427903703000066054 ,  395802542918744723 ,  1325328707894602216 ,  232121106299133087 ,  1811503543816918922 ,  186291171955583092 ,  298912129595737444 ,  1395166554348850949 ,  1028580321403023949 ,  1886554197332586764 ,  338117153560460649 ,  1177333840219262581 ,  2031940800242478436 ,  1606588105849782198 ,  630468238487618525 ,  778927469929846617 ,  716495116590398410 ,  1935891546211923750 ,  364990530917335809 ,  474929823887057433 ,  218909591365868181 ,  1535089314402225652 ,  359956615840242193 ,  794046070925930443 ,  1999173852104491792 ,  1195561869221947882 ,  347670609728695033 ,  2201434367061589394 ,  183021048676939186 ,  1277788256375535753 ,  649502937227564042 ,  1000624067826442327 ,  280735522447852228 ,  2267376288233153168 ,  2103401965929710290 ,  824422139857419426 ,  11009659390963657 ,  1047272421441011779 ,  1279826043403432264 ,  699475660545886250 ,  1090927290587976175 ,  1221688949977808815 ,  1284030743234989823 ,  365460867231195214 ,  314452402375740320 ,  326404693266554705 ,  656577691549609215 ,  2270236372001098374 ,  561377624424920145 ,  1562252623118744744 ,  883466190441532859 ,  2266544023105081889 ,  2093436915246872676 ,  337110348548872242 ,  732467551533862163 ,  2008463897503318478 ,  2146828333933888942 ,  198415963058863415 ,  1980142659764954215 ,  905153101507267024 ,  821272401585433296 ,  401540826320004598 ,  1950882359907614634 ,  95540189615105740 ,  1763341625395562226 ,  2251468359529339055 ,  1365077870852565681 ,  490027513187822785 ,  341574808221016183 ,  1166198875904011076 ,  1945705211219796791 ,  1374173829049425714 ,  1048675696280496891 ,  1121850634023920677 ,  843513294256035562 ,  2248406880099015143 ,  989900839300225042 ,  1128337605309909373 ,  781724081576517533 ,  1435708361226124043 ,  490417685273384784 ,  1226275449426248306 ,  1469589237209857548 ,  2286649736485784068 ,  971041276475902182 ,  1947290128582719917 ,  1693420312707468071 ,  1837331392130883064 ,  1299725935881958953 ,  2023022625801301634 ,  591378441309831576 ,  2260499814060204752 ,  1323692096490316124 ,  82088854493570348 ,  1012809342701025611 ,  2261358533942775303 ,  1049577049553974419 ,  2233688322554010827 ,  1834674671836922464 ,  991023377814291653 ,  128601857718866957 ,  1467720049969515373 ,  273169959733255613 ,  1445070933776396239 ,  399311984336843443 ,  520616322809617096 ,  507040867214729439 ,  862402258164486565 ,  1989810747361833011 ,  1564157944155126424 ,  376560599873117121 ,  364327628271492256 ,  1436246485188693853 ,  934108243487939345 ,  1394224364401715210 ,  536104885570595671 ,  894663730545783111 ,  1698831908411399774 ,  920379438607917579 ,  1718309526200187636 ,  1652743931824535801 ,  1058087222181947261 ,  977902403167841300 ,  1312380681339704554 ,  306482467805453430 ,  1646281187576083780 ,  550944171797487390 ,  2059293142610785308 ,  2087725913451260342 ,  962425852133617899 ,  60270525326171825 ,  1381685893062265365 ,  1886235341598255311 ,  794170866508033331 ,  1549763383233761837 ,  2256230674195220430 ,  10227460870964224 ,  1236669772480057937 ,  1697889991975438799 ,  738806370178993981 ,  225623271790951972 ,  1189440165690601394 ,  452372378336143501 ,  729358672126660811 ,  1401685138686056713 ,  1926626570163741659 ,  105839522965726277 ,  1668277147647283361 ,  430144419893445162 ,  2144176447757592135 ,  2180776986849253485 ,  1861995171712185121 ,  586619965967342795 ,  1699146245439707379 ,  2226174150423938668 ,  1272255409064481607 ,  1724755197373805358 ,  514912396278041718 ,  502609976980468278 ,  1994835232158121856 ,  354077085824747747 ,  510197886758853970 ,  164302875703254154 ,  2026609897312801325 ,  1000645860875196969 ,  1978582582781468936 ,  1979240569315732622 ,  485377733676389384 ,  436198064596234079 ,  284523662901640485 ,  931079224501956173 ,  1549954502762385856 ,  902895333800081798 ,  1599651976347677293 ,  1269511652098794374 ,  1324187878852609429 ,  980496712143684479 ,  770255061942227633 ,  1704842192856652100 ,  1708594288094294077 ,  308140005772405101 ,  338915416153821243 ,  640612789018956568 ,  1291829075025555751 ,  771670193964212883 ,  971918762708937032 ,  236074106664747382 ,  1510301470690225404 ,  419866899172331515 ,  1623861885849665796 ,  660895715515117534 ,  2059996567970490175 ,  1058138986481469026 ,  2047369691212068342 }, // x^2^585

{ 1263343222719330955 ,  2132572471239992887 ,  866008330390750349 ,  1231796784523122837 ,  498471235291138564 ,  1217139652304532083 ,  362877269407227292 ,  1309098953671122542 ,  1703771966571075073 ,  1741323758094159964 ,  1591102463366010732 ,  1701332294521029216 ,  377620953141763360 ,  36036092160665525 ,  1553719306502264558 ,  1828098528989327414 ,  672758326271752425 ,  1702416019320848965 ,  1229926729035867748 ,  36838018821807697 ,  2013532374530936546 ,  736455874879136386 ,  821432201754799653 ,  108334474913985677 ,  1363946885988119721 ,  1462718391701797312 ,  1768090749016856833 ,  2049884231166154117 ,  301971625419391140 ,  1310061827695389915 ,  756994509939208049 ,  276682467688605023 ,  879243889361859246 ,  789568825999339514 ,  277939020162780178 ,  136967126697615743 ,  1445270493085094110 ,  1186639183481973208 ,  1807308235868287481 ,  2098267865508147598 ,  1723496971987744953 ,  2174619319700503538 ,  1785389108815341045 ,  1137952544469896958 ,  161461164426459518 ,  2181834675654439831 ,  1807366044238475692 ,  2176340637153576913 ,  2029970040538794788 ,  752016902057370184 ,  459554998605785722 ,  1915936609706877532 ,  1824135630194359173 ,  1590612022021642297 ,  1789570911744207617 ,  1517505228772735139 ,  562230453047357186 ,  1521146865190014737 ,  1206837854178538860 ,  2174431927882145116 ,  192667924198142044 ,  1536306856270076581 ,  1078310295351375417 ,  1754995548047970953 ,  1034675193330438605 ,  542355417142601781 ,  2211521152122601749 ,  527281077507874464 ,  1809959915319515319 ,  17767556031408285 ,  607772024796837701 ,  1136111340481008712 ,  300235233000270003 ,  77305547161777488 ,  1433543602183205492 ,  1060481101471880308 ,  1334318942130958031 ,  1137369358341998320 ,  850289619608679315 ,  1770663035332092569 ,  920648183539792101 ,  218991093654071143 ,  973308355957058463 ,  1418657267268338398 ,  2037714403361978185 ,  562521016337881638 ,  1093923670516575066 ,  492599419641644297 ,  1398462587728774803 ,  2180673252376046211 ,  804050464720377577 ,  853992101361303657 ,  1926246933224634334 ,  955311164904586230 ,  959350996759836411 ,  136136670616965355 ,  2029469324804735964 ,  196254692715990078 ,  1916180770162339989 ,  1096459342542995864 ,  1363752838969401934 ,  832826380348375602 ,  114469913568087535 ,  889913190837985825 ,  1650566778060704896 ,  2102735095864598951 ,  1631785702461614974 ,  1073362302535630270 ,  1041262250873506766 ,  465315516618034068 ,  323358853604333029 ,  961186672218170563 ,  719627241055229974 ,  1211428083515572303 ,  1938759615576174627 ,  165568582724389080 ,  159663821397297203 ,  154369521042300381 ,  1046068796253612555 ,  795861792041758560 ,  1969133423237910786 ,  1282563850655778527 ,  1767463802233852690 ,  1900122801476934434 ,  497315688584025577 ,  1497106458950892796 ,  1893647959813408513 ,  481745992139643323 ,  425894576380093369 ,  1008877647936821055 ,  480591079631976992 ,  2074905341382874757 ,  467951402719595640 ,  659913399847230383 ,  900995762950435847 ,  1242084880090953158 ,  1750203141901127885 ,  847573632124495905 ,  985719441808104571 ,  670184916059395543 ,  1575820236119752996 ,  1396019417542520120 ,  4075056165909996 ,  720059951250631224 ,  2160012549984579627 ,  1355551470592599906 ,  183035559128978035 ,  819607231596078565 ,  926886160884785564 ,  2043299602159645629 ,  1792888822807458661 ,  118823273250583750 ,  839385872736948169 ,  1126450383269187057 ,  2250355011437921750 ,  152523986975161568 ,  292411534105808141 ,  1434936224342814051 ,  1810765381401001077 ,  352601207609583461 ,  1160311349065615215 ,  1467353579530778664 ,  503185356171236371 ,  1888747323758284574 ,  666249888667392728 ,  2157384740664575152 ,  1071180628996379722 ,  108072288020074465 ,  1167828441820525056 ,  1609134114557388094 ,  223536016092557321 ,  488580366972425729 ,  5925059199575181 ,  1644383352164406084 ,  478475532400227729 ,  634318052414467704 ,  1624446017287132230 ,  642853068561153510 ,  1701839795042103337 ,  2016119373235693667 ,  73970047696637212 ,  180842486036647994 ,  96750579983942339 ,  2114521571185707717 ,  410991172764500921 ,  534582286212605196 ,  1500389022111918886 ,  1535224969377130700 ,  476782230665765437 ,  350522263524433771 ,  459834717261674414 ,  1250871589310311063 ,  1113979638512409028 ,  712560236540036272 ,  608064166107355287 ,  2264471536597808701 ,  2114603352981206149 ,  2103101565240908892 ,  1643752390063234482 ,  858462897164246148 ,  104918664679521249 ,  724446885998146034 ,  1661813180652597405 ,  1580380953875149125 ,  857592967083320936 ,  1448038511038591191 ,  1201943204411136174 ,  598476766432294217 ,  2081648922133605375 ,  1788643856657455171 ,  2130710123660365583 ,  2192457580690753503 ,  1545337016256966201 ,  1337572914406959762 ,  2016434187685978841 ,  52611263539820001 ,  528440293562259526 ,  699131055200030555 ,  653897055613303427 ,  343567361241530396 ,  282972020609837406 ,  1747203397876624074 ,  1504223368186714056 ,  1514966517399443484 ,  1602548193387762285 ,  2033427115032940890 ,  1688967514283592072 ,  1601112459813555211 ,  1992330520986584842 ,  203771028920282951 ,  345476377468300928 ,  1336618534157561380 ,  284228131661752975 ,  2115620235251696779 ,  1897233021664148637 ,  1015603020269483365 ,  1298450742487731401 ,  602117482865946785 ,  1309369790423807319 ,  123934366736321995 }, // x^2^586

{ 1832988889485698800 ,  2118189968317813474 ,  1188659191491521208 ,  53275705363007011 ,  1672527530598118606 ,  2297692338231392311 ,  1532587725827717139 ,  960666493703635804 ,  233306109698804976 ,  270499181604291576 ,  696963962534670986 ,  285755467846236114 ,  1252771896265610609 ,  30909714057760256 ,  752380024972194713 ,  2079979144774750013 ,  408908755085352065 ,  465319886599062092 ,  1526556816242419445 ,  617093677308967561 ,  2028299169645110350 ,  1811703372349988812 ,  1107480177277817834 ,  1124887859275056111 ,  947848163930109324 ,  549894291929302280 ,  279494637476972611 ,  572816756163665096 ,  1250329069097677371 ,  1239253768632336926 ,  234970007871371886 ,  121314073880896414 ,  1789752175497164174 ,  2223708781061024017 ,  1721168702012888807 ,  673062920663334031 ,  1623623230508911370 ,  160937570947198987 ,  2015612586314078713 ,  2061131682042916823 ,  1299479620703518024 ,  1117931950967492001 ,  1656639270857972135 ,  462095000032151633 ,  303115678106069365 ,  560468372967508237 ,  2103010709098560802 ,  682460830383132857 ,  1678827992122612985 ,  2166733198481698344 ,  1604471453494784305 ,  320989649614298355 ,  1489604552139285353 ,  969934243467224283 ,  762043388037289643 ,  284439667531405792 ,  1846448898668707002 ,  1904410277247954499 ,  1084402660960314859 ,  2008767622138775118 ,  925303835344109867 ,  1515749674588343795 ,  580514778194194542 ,  234699172238780553 ,  2266242583766881624 ,  775758120426602775 ,  769858047420314612 ,  643566888647226937 ,  239354115787464329 ,  1709197055468650140 ,  2168506250747487014 ,  1746338346370550026 ,  2030115979765274696 ,  732958808086894378 ,  2129546893770482344 ,  860037510408254383 ,  1812639191347125896 ,  2280901135851372190 ,  1986597512918490903 ,  74987925574751473 ,  2097330241311753878 ,  2293294996238285862 ,  574534015802253483 ,  1901038711868608009 ,  2276927400213257770 ,  1483131745743555362 ,  1535073777475165941 ,  1336673309735344813 ,  269324251256223628 ,  1063500122102589822 ,  1209692826861766204 ,  103459437886411218 ,  583999261368280046 ,  747564527010790510 ,  518044075823812665 ,  1531073009097410811 ,  148196485997135788 ,  171225097650039898 ,  1837393792915489906 ,  272990821755800982 ,  1988146633080523015 ,  2263640616773194712 ,  640985643816145844 ,  1614502779840953547 ,  966327883710481713 ,  1807438312471180006 ,  1915755897478549021 ,  968025916606975530 ,  1066407712506312766 ,  1567730597892966401 ,  2095521698441144965 ,  1272990512972554284 ,  343237222859321270 ,  1940929888759539196 ,  2099819295142467333 ,  1704719816378068108 ,  440063721205167706 ,  2191900591883573646 ,  1766282197671915649 ,  346561541270792700 ,  16916607478526618 ,  2057783862063899877 ,  1776471335910174017 ,  1918891674547762473 ,  224405068516749643 ,  709013977761852067 ,  513782428375592706 ,  2209717742479491538 ,  2045052576011624758 ,  841619430543976214 ,  1348018164100813918 ,  1589952102191899856 ,  1599097391260941526 ,  1597136198479024927 ,  100336562148904015 ,  2261941182489038072 ,  1752827573946174664 ,  1265200117775795155 ,  1523784068515766697 ,  1568667562211387722 ,  1059331630080159519 ,  96873788588614213 ,  857779327806953249 ,  126601367410377105 ,  270041642803939142 ,  481654462962159990 ,  96762411553597727 ,  1557404920721603286 ,  1199178651296596626 ,  1239026009313263289 ,  2169944403461127124 ,  1549591945184113291 ,  1774458727142128664 ,  1321144474959931629 ,  469184642542862579 ,  1613955063396661709 ,  1903811618621776720 ,  429621433305066255 ,  1861444823981547499 ,  194355521045434546 ,  2245740090400297710 ,  1396142182431380332 ,  2043753570541528467 ,  1761454369110185196 ,  703028086594147719 ,  1105964951937513609 ,  1954304108494259768 ,  688791949237773645 ,  1889022576061008152 ,  1655011782336938450 ,  1593013498075349610 ,  73611897188664781 ,  1432996635411193626 ,  1553567085873390297 ,  655971371550265527 ,  2231631402097446527 ,  805211598366675123 ,  1310308287166410114 ,  755026513812969829 ,  1847054752690589012 ,  1437152986344086473 ,  1289115952448719555 ,  1395443139758550988 ,  301276875429546176 ,  2301209029420309734 ,  1825710463320891843 ,  1490677354109224226 ,  2120714397739221318 ,  1208944198642004716 ,  1423414727788020832 ,  892423885603383225 ,  1821176149367445291 ,  590689863994641690 ,  1213988308647987787 ,  1061990363687616770 ,  116414896974837984 ,  843963815203200569 ,  1004019800634456181 ,  1098544463156641044 ,  603880356309638243 ,  1484803985942717007 ,  448523451561117156 ,  925704273454107544 ,  1430148584049757502 ,  2010707384629613323 ,  416529884202498574 ,  270649477457166395 ,  210308697138136103 ,  817645082575377473 ,  2292166693438378833 ,  524895238426312127 ,  305945528075241059 ,  1620717853664274449 ,  1009442687414888465 ,  1060452093791384402 ,  1738332701092710518 ,  528938227674363570 ,  451632035775139477 ,  1227350623634126187 ,  7647314179066609 ,  47736818458654378 ,  1616147745904893305 ,  814236124998184880 ,  965014704000030260 ,  455518106622238050 ,  247881977914826684 ,  622175837438793997 ,  339133362542392428 ,  1215694016973660034 ,  190418633666030640 ,  1278269809599700064 ,  2280924793908514611 ,  582797849891860179 ,  277158951674403090 ,  1122352789466843643 ,  82255669482738977 ,  86597664988245914 ,  2021212138967082768 ,  550073142751673510 ,  1141485603141821334 }, // x^2^587

{ 1387911987221795332 ,  1665014173805696070 ,  378014149497618985 ,  892478503981891908 ,  484243583476835379 ,  756824153273508554 ,  1473728863178512524 ,  1147016667170534175 ,  2108293271691691685 ,  1390539124528348708 ,  2189996409061632564 ,  326424051100450502 ,  357895695435246076 ,  1184813955555506553 ,  173797868809164128 ,  37013654614745194 ,  356770057366198515 ,  1198446992322034344 ,  1378634335204257407 ,  1468575628323737927 ,  1472202580271856855 ,  998609547944761849 ,  1814445655718866747 ,  1700800117615007158 ,  543612311155249684 ,  1263444927716468966 ,  1966328493167779216 ,  2198095178385011160 ,  552333934449854049 ,  537587885061075821 ,  679160490522658432 ,  1500688081694990082 ,  518116619295326124 ,  1619531471909728946 ,  546509081106978909 ,  2192051820960117745 ,  730165631113886829 ,  2020927524381762052 ,  293005841314712575 ,  2130266206391149879 ,  775113579569518139 ,  1366052414119769533 ,  1364066873132495347 ,  836772769452462417 ,  713942304625886954 ,  2180647950538512597 ,  1765417428029871949 ,  628734429320477042 ,  1567278332422411873 ,  789670909806838824 ,  2015789765337182220 ,  1342838653358726902 ,  991835701266517990 ,  634176368760299851 ,  1736476375910545478 ,  1148144954985712108 ,  601629932635043943 ,  667300665361309365 ,  569839669771189718 ,  759852197740239405 ,  856613192712341580 ,  147142230752009131 ,  1802162636012273738 ,  1802092845017822930 ,  201532073366628088 ,  293831057004165474 ,  1056193405091957216 ,  1414911206221700233 ,  2165741981772008953 ,  1344653807302933280 ,  903377206270425754 ,  939542863402106470 ,  80125230045575283 ,  229176291630954456 ,  2276243009663044810 ,  1405429843465366862 ,  937195706949447469 ,  450460254295451662 ,  298453758579997117 ,  327765990779749189 ,  738941299548167712 ,  2253615925853561039 ,  1130831340795660854 ,  771590143670240718 ,  2056759958180114241 ,  979577822763972560 ,  842979374790039145 ,  896739604703160486 ,  907990503952210304 ,  1405242589442214104 ,  2296661029706727284 ,  1169847913950500780 ,  1089352712072171198 ,  493931056369958784 ,  699191817524484240 ,  389365676473854540 ,  2094529675283253821 ,  1623522830351863775 ,  910818113773713699 ,  449979550738816666 ,  1747697527767801220 ,  2233106922584052894 ,  1747299036800506388 ,  436541287619569143 ,  602932805629051072 ,  1353757123236263479 ,  2018026353070716372 ,  434123734692931011 ,  1832522850083326670 ,  1878422753288825118 ,  1928742388989223404 ,  923402374883786547 ,  592656466320569553 ,  867518052498494086 ,  313097508820924387 ,  854136413242652881 ,  1580364623043003025 ,  345033729467830532 ,  1077832297845341398 ,  2181769490480682272 ,  172576705105284165 ,  2181334651332849101 ,  526343999518655572 ,  1628420895703863818 ,  838176801200378954 ,  1051356668420051398 ,  133854478181061092 ,  387316208306074060 ,  1763079833238189175 ,  2098649100316553163 ,  1874340891818838285 ,  1265414404899023315 ,  1127331212133182497 ,  129310233750337624 ,  2070893934881427576 ,  1355458668013601527 ,  257503850684790651 ,  2047649890011930451 ,  1376134297190437045 ,  346710068583720810 ,  2115473607945697901 ,  1801057893813138673 ,  1429684418112864236 ,  2198669120803854060 ,  1126242792622261212 ,  1046452154022952937 ,  1244227787048698464 ,  621600970973840065 ,  1678635917523764237 ,  1173545317784621811 ,  430539560748996956 ,  835622578706155761 ,  50276851505390014 ,  104857375947287678 ,  1320816162376880900 ,  863393070035820208 ,  442102137989780371 ,  1300488002571916454 ,  957683576913712012 ,  1573071073830510594 ,  1806954493877485748 ,  406032843737969092 ,  2039002883991299824 ,  880260014291753450 ,  179192861934569397 ,  1197539072378822135 ,  1253561601646250007 ,  1727370764980917233 ,  1066540403341899256 ,  1042445287552606753 ,  1869146755662896751 ,  1262245881348210118 ,  1598176039684787214 ,  188284140562441024 ,  622342091042801936 ,  1163221192371429647 ,  987811025068263900 ,  2123332262934953740 ,  1074975562431548967 ,  600093171974290583 ,  1245267385712484395 ,  1419652194384068119 ,  1713636162762879300 ,  1669820855420502445 ,  580453012399485370 ,  883240256860715847 ,  390935001138220471 ,  139347977681404952 ,  1743253843775558319 ,  1553649665476338636 ,  552157110768351001 ,  759306809524287085 ,  563148303933107539 ,  598909716491354590 ,  1623059050264202804 ,  1814129440457060755 ,  1037128199375466357 ,  320183504019502615 ,  2173753468076428592 ,  2077113829452994615 ,  818101537701174007 ,  2270575463416817970 ,  1112653030246847448 ,  1514163713206873217 ,  1719045344885968690 ,  1296827080429132028 ,  336417256170516971 ,  1024114541540008986 ,  1289552541800005656 ,  2276355332558729695 ,  2204189437805854821 ,  502529848515980276 ,  1266536847418038720 ,  822535012502226151 ,  1447319676477068981 ,  1087191499556271339 ,  669958181641063335 ,  977474643483898901 ,  284755828539615709 ,  1843240619594560909 ,  1966149577992592415 ,  941754254922058759 ,  590914755486546084 ,  1099313793187907049 ,  1520025764578178701 ,  135155158016857623 ,  1520272636308247281 ,  588208183031629360 ,  2233820141346904525 ,  74113280586156408 ,  1368861801460023997 ,  1872437368409133854 ,  388625455485859415 ,  1925974331392142426 ,  1427420662532997318 ,  1716293809680261787 ,  1992795396709675080 ,  1867175722111290627 ,  79829625083238263 ,  185090874510655492 }, // x^2^588

{ 1339145750484528084 ,  349865016067309598 ,  1051810437605491886 ,  415952868131393292 ,  883643852988451914 ,  1904258490985028516 ,  1237468184762382784 ,  1793669376425634414 ,  1217287266447957897 ,  2201994873861347540 ,  2143534436277677601 ,  505422172168640725 ,  162385376789845189 ,  1776117577053929959 ,  266816082718729020 ,  734231585803570995 ,  1046242273228055522 ,  1999817161178506526 ,  1645926274039376175 ,  854619185172257528 ,  1089251492059175409 ,  1785957747582417761 ,  703420030279816760 ,  475428109438760065 ,  149060012723519311 ,  926272846265658646 ,  134561855635716853 ,  1114250203426354109 ,  2028782369701581987 ,  1484489257655220094 ,  1959316485718336097 ,  945390122433285746 ,  641345368434369236 ,  1321552448025817666 ,  1217135168004862301 ,  1224769619174838467 ,  1356113494754128026 ,  837790623235839759 ,  931551497700068495 ,  812728036978172518 ,  548815057232337745 ,  651977347021687082 ,  2202826575662493161 ,  1270597792455865292 ,  2146025959543686001 ,  1553115582170281728 ,  1476824077672787793 ,  1591502611794132737 ,  1690510196403070425 ,  1762950754543317281 ,  1589731885831117590 ,  248551051181441215 ,  1771276493178647286 ,  357983063235055065 ,  1129020836775334292 ,  375563361487912522 ,  1770491246291554254 ,  97169451875835546 ,  788527856470801272 ,  339199737666217919 ,  12208349927857404 ,  1119148913551848359 ,  1670995237371674621 ,  2299241810554897171 ,  415539635353265633 ,  652944388145149795 ,  2049178820179505542 ,  1535996023264831758 ,  896137760059854904 ,  1086874643401968341 ,  2280895306447193346 ,  128601587905593314 ,  1605787096890589775 ,  1558884456818585887 ,  299817284267665511 ,  1853518279093545240 ,  2121923536481706001 ,  337074545110971405 ,  549797391394630356 ,  1186149920765578608 ,  342936806026629544 ,  1184422215376474072 ,  1033899260448026490 ,  1141487536947211648 ,  2252455904447492757 ,  1866764782768563587 ,  829638932053831801 ,  1196981250901337304 ,  1711062857180154511 ,  805941111142649114 ,  473653353134651151 ,  784356198921947546 ,  551075336752830077 ,  380649677612379108 ,  1239529588444800342 ,  2095376717236270361 ,  338309445385363846 ,  1703977090400331292 ,  2052682992112673487 ,  146647726902992079 ,  1925973203907241922 ,  65142725823605524 ,  1131905936600647110 ,  1840186998351810584 ,  85252578907971031 ,  1327169281130048737 ,  1216060116724216198 ,  2247032625510131852 ,  2204762175986138751 ,  1470171754313702940 ,  1870850106643392907 ,  697321327418437068 ,  3707888992085195 ,  1634738964976549095 ,  1759102273080979476 ,  1218987688288118403 ,  2173538514017078051 ,  2117423575113682161 ,  1336918213147267613 ,  174102907268379567 ,  310007306819497497 ,  1734071380530255003 ,  1799795958030458960 ,  809846234554721781 ,  1167385954895546230 ,  454916216866389504 ,  222842982614659357 ,  1356020968363255791 ,  966236456659359758 ,  1819671901482996990 ,  660311198755464515 ,  1306135436761881740 ,  948569440744763422 ,  1648887894540207608 ,  8887615202987214 ,  2302288787863133341 ,  1632744948944672850 ,  792412302395469059 ,  1027337789908825354 ,  1205512624617390885 ,  1570579532611829183 ,  972672050367762515 ,  2027020733508677180 ,  1064227519403991865 ,  163966630111351448 ,  1448253124351904122 ,  566418712109566978 ,  1707969041995615808 ,  2282228114316661939 ,  1313931918099790162 ,  1166998456829038427 ,  1378634565041130949 ,  1123324583463795093 ,  2156577999824025049 ,  658392394544405878 ,  711737532212199851 ,  1738163974883967463 ,  1968037290152645698 ,  1459194437625752546 ,  1966953886152911310 ,  1966419072307391293 ,  399223153556197995 ,  697656005568138297 ,  1237290883089606041 ,  1366674987590328556 ,  1509793474035528289 ,  139444405719331332 ,  1555877654292985058 ,  2201063544728961430 ,  757132093960961933 ,  1998094880583062870 ,  272325325604740767 ,  814077967379054915 ,  1820643515742253575 ,  29630530764152849 ,  1173028154409627731 ,  2037077105487215069 ,  1745231596936791447 ,  451283396910110883 ,  1804150589010790247 ,  1320867899421960597 ,  1317263204976225224 ,  1697855965661747707 ,  222082217076367938 ,  1393181370882978290 ,  133778218670584926 ,  352766629702154219 ,  778817301098731416 ,  443658582894884985 ,  1086030336696069592 ,  1874953134698629493 ,  1138896145680705220 ,  1118951447079244678 ,  156671243359868743 ,  180630557390451051 ,  1725476797676300547 ,  5527741588643771 ,  449209919580807657 ,  2257614683958963952 ,  1691789041238741480 ,  956219804886093520 ,  1903256438107452874 ,  1369450787050808306 ,  471681706066094678 ,  2262460154761875462 ,  1046463376772498178 ,  1563637526914057737 ,  1383969115978701282 ,  1064386792224350640 ,  852498295093688218 ,  1216175575722477685 ,  594178066364078385 ,  170643639866919662 ,  1716700832485056712 ,  2200860944562055920 ,  603827711400981020 ,  1608928716588339464 ,  994765693252061606 ,  2029491718190505230 ,  531799104172648253 ,  808202125487275451 ,  457802572486361738 ,  1942603385019473251 ,  1089096747083860332 ,  378810820084689286 ,  1395586561078519378 ,  48706336790577664 ,  499509802715343678 ,  1731512128720870741 ,  143802449266287193 ,  143459940548392618 ,  2119045051385968407 ,  1346585582811686906 ,  1177537475001128713 ,  1649703617408578452 ,  668484737870259971 ,  1140279498671125351 ,  2233042690105576931 ,  926679506566248303 ,  2171396870320700369 }, // x^2^589

{ 973669942799515700 ,  894871768550133868 ,  130220065515155693 ,  2195481533565005249 ,  907864657453996340 ,  2277616639408321406 ,  800792889618677003 ,  893240171107791948 ,  816710849062906108 ,  1188295103141792428 ,  825363503777260234 ,  1259842327347681120 ,  1191611803390762108 ,  2130917923747754465 ,  972777628969091946 ,  1017965143444616862 ,  1531797483543861391 ,  994598592348820657 ,  899885652486983649 ,  618892238206525669 ,  1034221301676759778 ,  2250659582956428482 ,  2270681194034281335 ,  748183760481673582 ,  458837547964824934 ,  1867502596966279469 ,  203405302104716518 ,  1450785123857036886 ,  437968155355629932 ,  590774673111706013 ,  1013926237096854895 ,  745431770974388405 ,  2211711353746881660 ,  425784631172702291 ,  1428460759327123482 ,  1126062830127684142 ,  397462365146127441 ,  927637367108471115 ,  1280732369429167231 ,  408457864011772638 ,  1288075102193442694 ,  1843098813098998029 ,  548587867651524397 ,  886290968526234043 ,  1806163070402864458 ,  874890423226928297 ,  1576929220006911361 ,  1817804677276679949 ,  519721606040531701 ,  2168577548153578534 ,  1814192563063296790 ,  1751745882197208669 ,  1369996125023385110 ,  148339688102218063 ,  899319686127988257 ,  39693684382404358 ,  1516299758211828776 ,  1351395446883015358 ,  2159288052764575737 ,  542200007700312247 ,  189370591980511983 ,  2145525359926720278 ,  1970158433063303897 ,  1499664455525446102 ,  401547748472168229 ,  427146123077859482 ,  1294508839025364832 ,  1048393951986514747 ,  2017298221866597706 ,  2276009683302337535 ,  6409587462229540 ,  751576590581249818 ,  733222040168149292 ,  2149483725992426653 ,  2086701170240318877 ,  1777400899187530888 ,  1861748468312603697 ,  1916875558279262136 ,  945639350618150656 ,  1701132647483874201 ,  2000189717210482778 ,  2117476536811687142 ,  1477526753209864457 ,  186627625697787329 ,  843219688306988739 ,  1826164539592657355 ,  47253028990659685 ,  857402601834652478 ,  1323777888062606061 ,  498767271108648677 ,  1504499589515114536 ,  2060300666355508029 ,  212445321415665975 ,  1607465511281554627 ,  1686031271732969729 ,  874371557432294750 ,  618835997423044620 ,  1664285072928476608 ,  576032000527811710 ,  262367234559961496 ,  1437409182143005115 ,  395377654208835695 ,  184675434511854718 ,  1913796469415468182 ,  965195111864756933 ,  1120388687000089061 ,  416191251825329753 ,  215460692019518841 ,  1617092870376235126 ,  1993348133736952112 ,  1426724617168026626 ,  2132952853773037714 ,  1844428779571982093 ,  2003323431292804080 ,  189513115836274967 ,  599781444430204037 ,  2106546550895034951 ,  310089660935871039 ,  1642757957143899894 ,  1293307389028188806 ,  866317300830630349 ,  569028682872773848 ,  1747287259081060319 ,  328311632919779321 ,  70746325179474415 ,  299014932565189351 ,  1379599695308911710 ,  452589907890302702 ,  2012735267454389514 ,  1086252367510809243 ,  1837853996341968750 ,  198471013570420314 ,  324950435854167650 ,  139733229969808410 ,  918348437261534265 ,  1876470843428616270 ,  47535840412303285 ,  1561266965379262119 ,  2182517342383500934 ,  173441075358020344 ,  341975302002617768 ,  2038095322090379033 ,  1139262216209965424 ,  1067509280553311779 ,  1335444198713433835 ,  850104350849340062 ,  794136235285691049 ,  1990624707021056781 ,  2228974301051352516 ,  1079782367493057617 ,  59261753772809206 ,  746335494525333215 ,  905957961271103196 ,  2064780424071916478 ,  1960481197479943138 ,  576610406322858590 ,  1554406393441251258 ,  227545387192199625 ,  852698505980023108 ,  1670855631712452172 ,  1807632622080985271 ,  801003664866215238 ,  2206518378446956446 ,  1466253635166515105 ,  2286090169526544573 ,  2049871713369407374 ,  256410276571259811 ,  277239878634397058 ,  1891877061568753398 ,  353901616347067717 ,  606561970545614121 ,  107214575818954297 ,  112180577884725350 ,  11969984046125013 ,  778879552930056860 ,  1491086761629153598 ,  2099525397807731858 ,  1453988246276277741 ,  2007964157097980096 ,  1472341466951876738 ,  1638879540086477227 ,  652029078204153929 ,  2211329388914486096 ,  470235339795483243 ,  1288229511702182753 ,  536045843096779367 ,  1905992580827223835 ,  302285208590083751 ,  1906020084051406785 ,  278620879584900768 ,  1538358860200239530 ,  1593294455133141226 ,  2251590853147316037 ,  1192657023939863928 ,  2199279867098783865 ,  1082416027384409958 ,  34398003566906492 ,  2195252080029190864 ,  943220027604941373 ,  2094173325796622067 ,  2093959811578184176 ,  1409992656375488497 ,  2074328902499815410 ,  1685807509974166160 ,  882408672266840419 ,  1471308441624165626 ,  1464843230999881933 ,  1061315222715966977 ,  755159606210795800 ,  1707483261243353128 ,  2139844229528372607 ,  1723129603664671820 ,  608507855104527628 ,  2108449073528403338 ,  1288921336644036253 ,  889438263103016355 ,  420424167142692587 ,  2193129999662596283 ,  2192704243464730668 ,  666234435893283455 ,  353229627013157640 ,  1084317908654252826 ,  1882161425952604950 ,  497025146559001933 ,  982283708049556550 ,  1762642232667329716 ,  1058838199697735755 ,  723433195588993532 ,  683340306563202537 ,  1165795942962269638 ,  1833048106167350039 ,  640292773738958091 ,  277210518512688386 ,  858814621094124054 ,  421154296242910759 ,  1632440209950461218 ,  772070383207213778 ,  1724215459341293976 ,  1500058750628904638 ,  1875310816759413653 }, // x^2^590

{ 55611628902397119 ,  1028359133937988147 ,  1061266827020496089 ,  589060636534096690 ,  1557103970975822156 ,  2184708257550328847 ,  1835096752599264188 ,  842273786249518633 ,  668995778789790531 ,  711964121237389647 ,  1589633010875131177 ,  2271257339338551548 ,  544959090169768061 ,  1049403030172299884 ,  1614319231438571964 ,  1349740270643154538 ,  1756772850800558185 ,  1928729160802822094 ,  2200942283945517898 ,  1017122933484108874 ,  957686684138160413 ,  484399322608312477 ,  1348154095335921179 ,  1673327307954041572 ,  1997542020806050040 ,  1377905768610162115 ,  2150892074774844207 ,  1758629566327126933 ,  1315099098938824903 ,  859066274686510263 ,  1860742275966781025 ,  1037364683976979412 ,  1844016268573592033 ,  1368543491375964681 ,  1865584113429843466 ,  853382412727862783 ,  1240483482138782799 ,  756390223827127098 ,  1739890935703473538 ,  1690509961777246875 ,  2071511863572109976 ,  1886830853127106973 ,  1030170627708954918 ,  1979309646769984789 ,  643169581183726282 ,  1569763206660091838 ,  1484237301029873523 ,  409437274422768454 ,  148129517910563284 ,  848632985887926194 ,  86056308922870878 ,  725381064246409598 ,  1297057607026936936 ,  266048787459569865 ,  962438694048555829 ,  1452531781081978236 ,  1879148813621721612 ,  51879119015950734 ,  2166024359924609377 ,  11609738395398927 ,  1811009122643686861 ,  483429171053341539 ,  1048214232079716306 ,  1390060433983341759 ,  724028482598016255 ,  404357322067713012 ,  248120614387677447 ,  1009573122728840268 ,  1128648041722400556 ,  297952276844362106 ,  1990123735955750291 ,  1461241639384411576 ,  261859958006368209 ,  1759916491563861640 ,  1679443384361365063 ,  2003047352060917760 ,  838807604321856739 ,  389079397144009174 ,  991574627734189341 ,  1660417289357095506 ,  345814722114951681 ,  1497489563303379704 ,  643313884479474134 ,  346613082147745495 ,  304669360304712415 ,  738488025467244736 ,  1778543587512269047 ,  461084259800729223 ,  801503311660584456 ,  2188198543573859034 ,  521289480660406383 ,  362923965539436078 ,  1515583617887486243 ,  635859960565216680 ,  913631719037111515 ,  1836422691193756993 ,  1037073094475995505 ,  1941995758302922030 ,  1138225946820588749 ,  1246527088125973955 ,  1849903439256388906 ,  1239344999513517011 ,  1758513614387455482 ,  1391617838685953246 ,  637513542226629025 ,  191132971766956128 ,  2288736530628450920 ,  1956784397420656283 ,  1357316052263414829 ,  1516025387995530752 ,  1857463435675337715 ,  1303744674800340006 ,  937358536040983494 ,  1310239815240754791 ,  1067476873278879626 ,  1669269492932923240 ,  180610232003191441 ,  1719481669020577921 ,  541419447884755992 ,  1120219613733172907 ,  804553864878246415 ,  277693582102788704 ,  697554437593174854 ,  2164114301386398539 ,  1990175294874820972 ,  1024699444119846005 ,  106712994391067553 ,  2215276565768693345 ,  1422479037926491001 ,  1377889069198571653 ,  1552180437904804361 ,  1351980774536409835 ,  936723559439898283 ,  213789489800510707 ,  1983520084807417312 ,  2003495125569153115 ,  1654266771223679465 ,  1774293293659139448 ,  78982654777247322 ,  1599794412367370395 ,  1459513577592684959 ,  1484387261023403495 ,  367105346298756796 ,  2050971821033820718 ,  83627098063635166 ,  1693589476898405511 ,  357744283420780082 ,  1110645909773505185 ,  117508561892181945 ,  2064846892685281848 ,  2239839083456264042 ,  738509269590592916 ,  1900941640367553554 ,  2265349654381327752 ,  1643727159618421301 ,  544627181939092331 ,  357906760230346499 ,  2206958717598897238 ,  285316137987971426 ,  544111353983885639 ,  2169191179230366150 ,  536781832753857589 ,  1117501102965607545 ,  65960812713443572 ,  1840348587383486783 ,  1952521955447008794 ,  1739345078840545556 ,  1775508214614881988 ,  2059300890044813791 ,  1787695991803703294 ,  2118211856629045898 ,  870407138048084204 ,  1016502508507894345 ,  1570821688116506555 ,  1684806628136763462 ,  1734364290826562320 ,  2241287603139694446 ,  1514113965901512573 ,  869464995554654472 ,  300799170819009429 ,  1870436925203315138 ,  759026769349724214 ,  33539013035028575 ,  2086164029196637759 ,  1356055620335111272 ,  1825077057698298900 ,  131132785299577988 ,  2174072954557181833 ,  35040727211159990 ,  1269057752944422989 ,  1320118692811719678 ,  1748167032662593263 ,  557652745617855205 ,  1664895300283998595 ,  1119138132884960216 ,  881397531056254482 ,  464238438842302975 ,  2289162940105242321 ,  2010857552216082320 ,  1976000691547619790 ,  1457572298450802518 ,  1326564097660318159 ,  448871548253660475 ,  2126910736917685944 ,  232157555839164393 ,  1167237754223090917 ,  2179452218085224160 ,  1088487068191168349 ,  396761070116573856 ,  300916285258055071 ,  2007064729316343445 ,  98986532271239021 ,  1844791144158802685 ,  295278558915349248 ,  321917804746645667 ,  385827195176535482 ,  1023906483388408436 ,  636767025476194078 ,  565531389935826020 ,  833786450363924588 ,  1849797823152430871 ,  872388377645655814 ,  470249744400799872 ,  1278578130288734657 ,  154476011001885278 ,  470367808433459627 ,  449382783095936146 ,  8557538279680084 ,  1079896124650730205 ,  1923007982998081888 ,  1312974678718007449 ,  269380304364598907 ,  1008881590001470267 ,  2217141856042044905 ,  1932093677421104014 ,  1815220581723410695 ,  2072802920533689329 ,  147140612819736408 ,  2300203079247428933 ,  193310369201328070 }, // x^2^591

{ 42226865299259244 ,  2200769323128293916 ,  642844877949807206 ,  916009958476624311 ,  1364947724505619553 ,  1568312276491694056 ,  2292971609387974565 ,  2129586087328458116 ,  2010717552257601882 ,  124720455822558058 ,  807197090306768139 ,  1526270574972337018 ,  1479006886122830558 ,  1618841744712737277 ,  1218276266367655130 ,  1451838295471475996 ,  886060344903407681 ,  464867106513927050 ,  1985645264300824159 ,  1866283615442549823 ,  645143198563545881 ,  937001240858937914 ,  914519799954903133 ,  204873011827793221 ,  228706315885249535 ,  1998735479748180978 ,  169659290256386660 ,  675897336722417554 ,  351618611227630883 ,  881997051381997124 ,  862491074867882965 ,  312902962035796063 ,  214799374350394823 ,  1916734583023861835 ,  1635821034053798859 ,  1468034363776787861 ,  1969444364285096705 ,  1543293821838508572 ,  877202204246024697 ,  42523826504400617 ,  482942059940930501 ,  320037130320152642 ,  1152583501350144648 ,  1308116110931862472 ,  225535949979801018 ,  1803309708103144582 ,  986180927832069671 ,  1024495563998206042 ,  976321677584829365 ,  1645595294554304100 ,  990909677573678752 ,  270706495787038858 ,  679425245205196324 ,  1725211378501929666 ,  455029436823438253 ,  1644018510527994139 ,  1369865531566256828 ,  2190449484311044267 ,  1808564546884175683 ,  2148368023225477629 ,  1953832000592468653 ,  153510228633353565 ,  64884917545937213 ,  737995536784078789 ,  1803719992743325468 ,  348118574784360315 ,  767015360206910913 ,  1862512790604705367 ,  1198235315416950599 ,  2055422091839872265 ,  1220771991529551467 ,  1127281454985008441 ,  2272019083234172546 ,  1278107031449624278 ,  558079228105141721 ,  564230615291996070 ,  25807114007626248 ,  2100020843667808220 ,  1303283346130388367 ,  885753170694003990 ,  1093071621744281881 ,  2087640435792296028 ,  464002676836421513 ,  86730037765119221 ,  1846300036934621438 ,  1406053949428409579 ,  1323488286563774304 ,  542456564776871322 ,  53167732394064897 ,  2032834531263708571 ,  1036832522693470958 ,  343046339089360123 ,  1177796922181734352 ,  825237593507308429 ,  1237859208694141120 ,  1101833487677928438 ,  632948154650403215 ,  885184264202142268 ,  723690253701927316 ,  360075608807007942 ,  1982514757575160286 ,  1491702190788247887 ,  349519484518478926 ,  1389203295125476080 ,  1286692808018042984 ,  701615460979305607 ,  452263313608595785 ,  484018700040611542 ,  212051050201865392 ,  1970329353730792258 ,  689117405984470347 ,  1037954166812257058 ,  1513615855663009543 ,  1186076839423908069 ,  1088181598296416500 ,  117106498031431840 ,  216035231308675183 ,  2050527143387659528 ,  1924524290791464166 ,  2199564098727403786 ,  2030240864441614963 ,  1227638196547212389 ,  16546301407773845 ,  952517475083343799 ,  318095445050572538 ,  827247518586798648 ,  1104183447457972521 ,  1316818434378044349 ,  1371658447191986498 ,  481164929985521 ,  1945017084437688398 ,  419010751184675372 ,  1437749756846865403 ,  545617478895548663 ,  1939797940874495779 ,  234337345903011969 ,  457511230675411421 ,  1352052567207259312 ,  506252353819285731 ,  846561846411170893 ,  1844115657018409923 ,  90678666874974817 ,  485910972975951297 ,  1523070346037846333 ,  1891684498684515199 ,  264907628371903606 ,  1032507759311504471 ,  2008732240703928672 ,  391337938024664121 ,  1239417179585615685 ,  1720935578087332317 ,  557319682400948129 ,  262741572665778019 ,  1775359183318812527 ,  1769535211480652491 ,  1276501128150350903 ,  256396241349765225 ,  2033105047104503576 ,  1466368164938552906 ,  931460246680228993 ,  123938320155332968 ,  1860825245273299547 ,  641963335428945059 ,  600224849780856333 ,  678887548208237740 ,  2014843401736447103 ,  166495216127997209 ,  690467860893982505 ,  1657050760461481210 ,  1135124435394656952 ,  1623257996117522202 ,  1074957816050207211 ,  933467034747183833 ,  995278711166151765 ,  2109461407238821106 ,  1526819387400846483 ,  467434277366176895 ,  464364503539994171 ,  1442048550661131175 ,  808819117035278353 ,  802258547038086886 ,  1490467874973612017 ,  1705773565929056095 ,  2156307114525575956 ,  1888493880512040390 ,  1933803054063603770 ,  57651106638602496 ,  2027707778493228532 ,  381192546979031577 ,  1007378583555849032 ,  417827060890284289 ,  717104280149188709 ,  1123253125290457357 ,  769272830074976378 ,  1099447797636156356 ,  2134152525768811861 ,  792070996670570142 ,  160349726645651697 ,  1226491289118324106 ,  788126091928035774 ,  1271970740270165853 ,  306984472092142938 ,  440690159360433137 ,  1235103530993772117 ,  1763180566917010757 ,  1717406456931543752 ,  1896579297991961589 ,  1977893530741561088 ,  664314995954976423 ,  1140051249129735773 ,  995956799972560626 ,  1047712582318391811 ,  1654776948947890512 ,  135367928423161995 ,  845038600363031716 ,  469614414547341128 ,  732573665130598807 ,  896212669058512843 ,  2247944385694364543 ,  1927469187329682256 ,  929397595311747884 ,  1912142439765541896 ,  314224937312530561 ,  1805887475174987601 ,  2296091552301408239 ,  79699237698028827 ,  2220848706414703425 ,  2175953989558488458 ,  1759948560427455455 ,  687325095791818558 ,  1696919734232967996 ,  1744661518845848180 ,  854744636080229601 ,  1682650321426410892 ,  617249664812668820 ,  827299086963628026 ,  1281947202323251166 ,  746179327349471177 ,  714602312427911833 ,  591548914489109565 }, // x^2^592

{ 282105733065210669 ,  2189350964750160724 ,  247645358102154827 ,  1250103823135001437 ,  719573056785623544 ,  864530287250186644 ,  1321950178804981133 ,  398088536598291758 ,  1740217516512302091 ,  1705776387313677404 ,  158402323224183037 ,  1818234371637890248 ,  986438477572804473 ,  708037619273646524 ,  593685810938137030 ,  1106267442574501980 ,  862470982696034573 ,  1111157690224870147 ,  1396801658256741978 ,  1583466541124974423 ,  2007568379539268651 ,  200493392537583562 ,  1857660585220999473 ,  2273075737209481871 ,  769407731717730789 ,  1363122570970782061 ,  1307849445856117636 ,  1894047256443158757 ,  754679697842521201 ,  621707843368937245 ,  7615200517307404 ,  2010467801710040112 ,  1071272434287943145 ,  2278093283891375573 ,  1457620745666688450 ,  2276847794307331133 ,  762297199987243939 ,  1021658524789554644 ,  1748524642179154371 ,  1968309442123679483 ,  9508266098554400 ,  380550148564243699 ,  627446919234323488 ,  1244308405328405031 ,  504723463668649004 ,  2179655654011515716 ,  965228786311524832 ,  506067769794535320 ,  1970016418272276542 ,  365908348310041762 ,  1124610788413058755 ,  2082264931577637654 ,  2003106504742539872 ,  269690265381585916 ,  1800174769273550938 ,  629391821817603648 ,  904642428409537074 ,  514976952019327825 ,  545229521951324011 ,  1578160048999017159 ,  1048590748914116705 ,  1618580956435315479 ,  1294800616214227326 ,  810211438601999074 ,  1372091613094908052 ,  645048723072545966 ,  1304671182313880660 ,  1428373828171855882 ,  2109124142271901071 ,  1132732959971665642 ,  1378520613359451839 ,  919710265356759399 ,  195644730508235650 ,  367493434724287504 ,  2011020058811711050 ,  2160468958363533999 ,  580642556973725812 ,  297879387787332362 ,  1147680272487681851 ,  688736041722883479 ,  1859493002574262175 ,  302769324288956091 ,  1357058136278991925 ,  989913636813101699 ,  1518247690337977622 ,  128989388628397569 ,  1842993612902421992 ,  537095624733584638 ,  15683109383615220 ,  186159614350445983 ,  261654507576507411 ,  2059623126034334886 ,  1230639472230069013 ,  417100828070400409 ,  2212032099209762141 ,  1839388093049619508 ,  182051799078767053 ,  307493021419358948 ,  1562324566472857875 ,  67482889532691700 ,  987262585008110471 ,  1693028079674564372 ,  504001566301716156 ,  1747012267086838861 ,  732508213520333709 ,  1044176308273482307 ,  83846108487443795 ,  254354205305780158 ,  1237873770940348984 ,  292026138055847495 ,  1226192314544986174 ,  546951979111313862 ,  2218835278499606147 ,  2019355657832169022 ,  1971593710335357018 ,  447492930820118107 ,  1314976575393034855 ,  1869892566068044594 ,  1671312184010214455 ,  745904833193055867 ,  913376173106620675 ,  2208218008896020800 ,  37195655578782945 ,  1381054455229685496 ,  1551313834100898319 ,  1426430858900182012 ,  1086377913035086773 ,  405566056791642677 ,  264652238447857415 ,  673119501899207924 ,  1797056743241999832 ,  702201860834120833 ,  442577115492702253 ,  81113150378875956 ,  195371831333010968 ,  550485765633994987 ,  621572106019611732 ,  1284498729204879886 ,  287145327179726650 ,  953762227866412864 ,  892158005575566179 ,  1393495775295813700 ,  1114277360422700271 ,  217630031087450455 ,  2172432578685871496 ,  1820671893878870682 ,  1288777518871614773 ,  1280115059347626990 ,  657853677288818994 ,  967011068798461564 ,  1193887435676826652 ,  2298371600411059852 ,  962790119961209359 ,  1901886097013117030 ,  180435104377445830 ,  1717351981301698759 ,  972483210753018353 ,  391471005649674663 ,  336983184251413432 ,  1226367090628768901 ,  1314722231505155936 ,  760891128838890085 ,  1710065307853495097 ,  60409222358436263 ,  1221477616938131054 ,  339606012580416418 ,  2299057902337162205 ,  2060391769761248600 ,  1492193247420196664 ,  1705837124003768925 ,  1022847470153360632 ,  1107133036581371309 ,  1826490959440722333 ,  2197146328420456030 ,  574614563295198367 ,  2183610842698824553 ,  799772635579137733 ,  1949722677711552793 ,  466379734357240629 ,  335350653678573622 ,  1676955591934674 ,  1248732957623074874 ,  1889009433263812465 ,  945187649125750110 ,  23739273047986066 ,  2150508559591399883 ,  797328518584289591 ,  1738719754466824402 ,  1892636081572598971 ,  653288681594063096 ,  652656561181518014 ,  824176371473296828 ,  1772011948770317057 ,  1026913299139369984 ,  1730942818573194092 ,  1116768408538208555 ,  383488634642161912 ,  2207006244279106438 ,  1263882946367655077 ,  45170412123104031 ,  1034271611061555730 ,  1026857227141899888 ,  973049033325070505 ,  725213716692562930 ,  1250679970161190538 ,  1562926147785044638 ,  94327843521764803 ,  1013302467056320020 ,  248405603423667143 ,  406317536489844770 ,  1925457133131677845 ,  2145723951150925670 ,  1280437319675472915 ,  1029050943358232591 ,  1224054656682862999 ,  1398370081505099080 ,  732948990117556628 ,  1991114387913247572 ,  42862393657590106 ,  703889686358581216 ,  1653644524854039517 ,  919273478326989541 ,  1344355247641582971 ,  1496088402273809821 ,  1221851933253972809 ,  781258350603305785 ,  280530678880863930 ,  1466679813026756018 ,  953487458255115451 ,  505649181988433364 ,  1210661467733105619 ,  1406375167956063800 ,  1887805683370415785 ,  727280828951387425 ,  499380301769496786 ,  953939304340669019 ,  1227378084570815782 ,  520476832786091692 ,  2092053007180937336 ,  999219798202226121 }, // x^2^593

{ 2056492150917731248 ,  611058266220440055 ,  1223066572158633420 ,  13068858466044222 ,  1591830977215627691 ,  1634194135692118528 ,  1949885044409832910 ,  1761905915981965715 ,  1389904451618157726 ,  211189819269041471 ,  1931417182498455252 ,  2251558395987020728 ,  248676593410209122 ,  1931677884917882982 ,  292690581654099565 ,  1180488235320673013 ,  1681732452864699009 ,  1013523703477700560 ,  2101315857672337321 ,  2293256647428605922 ,  747982737129309332 ,  506072419123516835 ,  262790724254218372 ,  1590508671192011554 ,  1675913588864696886 ,  220888324023362159 ,  1240759464528272986 ,  1553909708832836382 ,  57997477061450121 ,  2821112992457463 ,  232175598600161593 ,  111672531558761208 ,  1663154754748726721 ,  1131178488123800183 ,  1524686968012130773 ,  1735289134291546512 ,  307564270494446656 ,  1534469113713179404 ,  806627851751979095 ,  324939863953048588 ,  1552145963179361202 ,  555667762255251442 ,  1516348713907530758 ,  176759037378720651 ,  1253726733670820621 ,  2054280251695313128 ,  1883634099032788671 ,  680278723844665560 ,  1273491105532927243 ,  842273408197828404 ,  690444441757366820 ,  1838175116453400377 ,  582270578610579708 ,  1347074168061564819 ,  118051384601315231 ,  1386518415853200276 ,  1168574043991120540 ,  2065366911208297715 ,  1888467553920966601 ,  2098546907515158535 ,  1870758846071416405 ,  1140205061157502087 ,  534271948749754100 ,  1764885457989386711 ,  2065091970066498914 ,  1766598766803503310 ,  1019086435193629960 ,  870887547248039066 ,  1205423483334134756 ,  345953261508970384 ,  1638353682228923454 ,  978459468093232514 ,  382482360045704581 ,  489127057039630569 ,  228261645148657646 ,  911579803787249577 ,  995613513272729201 ,  1473448461995069061 ,  1331476792916475441 ,  2242464957625295833 ,  2062730914099340146 ,  1467847783866268862 ,  1594271827004255832 ,  243130579662613347 ,  616004444238395855 ,  2270181696574930387 ,  2281317886445775122 ,  2153921633579478104 ,  1718028774690493569 ,  1138201288655328228 ,  1981238574061343641 ,  1163724539661823724 ,  704355049895083625 ,  1150811249351035662 ,  1022794445611518030 ,  281208572691755869 ,  1443392552548344255 ,  1412077324475836074 ,  1258965983785583087 ,  307613328727609702 ,  381106842583637849 ,  1446533025342206077 ,  1155802690149132618 ,  1788924071399257561 ,  165530300894096453 ,  2191880838017625588 ,  1808726926736725391 ,  1329240689258044729 ,  282407284021338714 ,  615904703048309598 ,  241012548222318183 ,  1512328017379407711 ,  1076719507993377951 ,  2128255730174834518 ,  2301370180494567292 ,  839605353035079362 ,  1079901995773390857 ,  807996044938436371 ,  1324822834670381128 ,  1905926994469777661 ,  364555029725934523 ,  1024738999046090268 ,  2260787931984393966 ,  1044447931086521542 ,  2163723371828071003 ,  637119758477513652 ,  47377185973094262 ,  1527909522659351400 ,  1975125061641746404 ,  1208401626677294706 ,  1378536917504848597 ,  136844414537324473 ,  503189237215813391 ,  190885898415116614 ,  1731873990102715703 ,  1779160096618615241 ,  67965504012810317 ,  136841150715053907 ,  551681218593252822 ,  958127188771521643 ,  1433814646287592919 ,  656434484378933481 ,  1405739275151398555 ,  1254563664054564434 ,  1768964318889151272 ,  591930947963837639 ,  1210709146246401596 ,  586873096309153507 ,  1227218968174834144 ,  47312333227826702 ,  1913572614869330094 ,  2225983123489898261 ,  1617141376175229527 ,  976541146229037694 ,  1361888025560020846 ,  1997365579629713378 ,  2258018622480454031 ,  1730010866183204128 ,  2297621765660359378 ,  1905541026158717564 ,  258874560109193209 ,  1971018676634833692 ,  982507275179148619 ,  490379047383483644 ,  1425476556806513174 ,  1339354977353672579 ,  1220200189427896689 ,  1513560574613305987 ,  2117403500000205355 ,  90572226455040749 ,  1692874767881921690 ,  1344437752255044460 ,  528360065124948247 ,  511671676353770175 ,  784730080881923308 ,  1736605071351410488 ,  817119810871789602 ,  1880630928595166983 ,  98021364574033670 ,  2052152334420016576 ,  2005172654850111203 ,  1404970942350166697 ,  567949631776115983 ,  916679604624968716 ,  1336204025059944787 ,  854600583837468858 ,  2224618547227422328 ,  2302426975997660843 ,  969090120111652924 ,  257207317267703162 ,  1858892872353760319 ,  2293325582683311454 ,  1454179541961734814 ,  361118719522198754 ,  1314079363366136305 ,  468220857025380049 ,  1457705944960308563 ,  1140961874920476650 ,  1177758207116726558 ,  1133308843677018014 ,  337395775211079816 ,  1697937632486153224 ,  1401685975036421712 ,  2295314838208797816 ,  1386168579697516001 ,  115683396146511585 ,  363811073553130531 ,  2190924353918162721 ,  1002925413747115377 ,  521435103122005209 ,  1691768643868290923 ,  1808413732142417501 ,  1782763068315728333 ,  1009960464714462279 ,  1672773397130058079 ,  1559063275529587754 ,  1372366214343504496 ,  1815259147130403770 ,  1833969520166407293 ,  1746340554947791051 ,  133079604370730641 ,  1358768404369260254 ,  1089977403990882058 ,  394872470451623033 ,  1811228289212459844 ,  1444894157993075485 ,  49569375083113846 ,  274470337922159040 ,  1757315581647921025 ,  2092526099968506481 ,  629312703966728499 ,  1787003175436691298 ,  2018280388319072922 ,  1106467415095498295 ,  34273253652267926 ,  1568960897475233831 ,  1452140565837489768 ,  275871338778291045 ,  1781712690440945688 ,  408809880828433742 }, // x^2^594

{ 515862073511864535 ,  1622489604002231522 ,  983002306753751713 ,  795629301340582442 ,  814402702670089568 ,  1829715446485926761 ,  2055158252401467273 ,  511060597429134680 ,  1366601643322225567 ,  2076119109033325664 ,  506233964990493764 ,  1320540048443604731 ,  1595742478620030731 ,  1227458289571818477 ,  1895189323092789051 ,  2010778661455242500 ,  1043746582200700736 ,  229347674928943441 ,  1223604879586761066 ,  1920660959939348322 ,  945201629364317976 ,  995885044168506898 ,  1738352223463066437 ,  2166063312571642925 ,  130443038528550605 ,  1608761738317560700 ,  590311860953975849 ,  672770913729912628 ,  35397562153898598 ,  1470492438535092340 ,  1428341029311555080 ,  644206071358534520 ,  776031447372223882 ,  627871594061620354 ,  1427533034942807539 ,  1980306730935890858 ,  1915001544751852017 ,  318014523181721765 ,  1594006864493894089 ,  1273217745415334103 ,  774102286298323142 ,  762441311155956697 ,  34329207002591034 ,  1511893107722965935 ,  1467788736933837440 ,  431510975484998253 ,  1205512937425947968 ,  2183375413411297437 ,  76735279915195209 ,  1140202881094000045 ,  1530845891082181131 ,  1541442194715298861 ,  1348107910963842073 ,  1427330757069484964 ,  2184799928951863779 ,  211439397734210047 ,  1957481624234297156 ,  646346631975047955 ,  746655235857910494 ,  1879898735975225788 ,  657091898163023231 ,  1591053723970581116 ,  1142786521862567303 ,  202816850407945971 ,  1007526422949311328 ,  2061147955092666208 ,  1154177518823238694 ,  1057038060895632758 ,  2248995810855600537 ,  795273530191001904 ,  1932193386304246650 ,  1779030411727440766 ,  1814065742058380009 ,  1068094900378795410 ,  20987434602245433 ,  1569901231569179661 ,  841714882444123122 ,  1898244498090031263 ,  184810847716897049 ,  903640929678941678 ,  186006984084905891 ,  274582495271578724 ,  574249280091887849 ,  1935430197504226970 ,  1480316828903852355 ,  657750075041530050 ,  2175038506811494270 ,  1158893382880905634 ,  2222949568965302521 ,  978874911631056425 ,  180352995392997706 ,  1007526075040347435 ,  228198429925990554 ,  1989011222274643314 ,  1974471533019774069 ,  1144372469003553842 ,  405372299453110883 ,  1441250948657375703 ,  2252109768705862316 ,  950207266989873035 ,  1934048925278456190 ,  1846469862230348489 ,  110652984512227041 ,  786455272938448028 ,  1743346747839310873 ,  1630717325115801132 ,  1366952787016430021 ,  57715803062679564 ,  1419632135214657905 ,  332713659101068782 ,  852023638586230742 ,  1048903882863884945 ,  211498629577233711 ,  1086734805847524733 ,  785043361198363756 ,  598662861242828778 ,  1511030271581834381 ,  83721746576757899 ,  1309655413044894672 ,  1047897177205060076 ,  753927927657456153 ,  1545262046218034885 ,  1634337990629411195 ,  1125413895519834481 ,  327774628793509123 ,  798495822336568215 ,  2194886609083557689 ,  1326894791745489326 ,  740535345687152191 ,  1165574338902591285 ,  1328916775236351899 ,  1463777618106514968 ,  1395354595720708734 ,  292416310252421858 ,  1516589052752162254 ,  1778109746192936826 ,  1733870992709935471 ,  1203513811707661159 ,  1270007844025534929 ,  791191528925502624 ,  1465034992653345173 ,  1938214533766409651 ,  747827210655010726 ,  112516094012286412 ,  1551530052029020657 ,  1499656201563711504 ,  1770373350502861424 ,  2057824350648094909 ,  362191726562123649 ,  901835145019132209 ,  1768500399990861104 ,  1623035249507596264 ,  886129185585262328 ,  768518751448613558 ,  1640237096429529005 ,  1320113651525158123 ,  527256575231025688 ,  1272207431040546649 ,  100388977795993349 ,  1884396728561697273 ,  815654216841682575 ,  1330705693767732340 ,  849629989012857000 ,  268446719864190806 ,  905875471741256674 ,  1779031551590708084 ,  374867304959861023 ,  151232701896988413 ,  276591778022989653 ,  2211696487663527974 ,  1609077535431738498 ,  2209230629991027746 ,  374267527234924039 ,  1012694591852051164 ,  3000703259889149 ,  1309087701661879389 ,  521805541543899072 ,  219836417635049875 ,  455867311845396519 ,  1227995868587201383 ,  1899150102996265157 ,  1993245466108594717 ,  1353267940604057992 ,  821107552420974914 ,  1859294121406505152 ,  1982219589238519213 ,  1879003323605144172 ,  672518200471928732 ,  2127383195531959986 ,  84901412632445367 ,  2116803871831201192 ,  1492184414666635323 ,  1671351895030595797 ,  846733756841440299 ,  2172929666260747728 ,  544531691267111544 ,  2213863746979375538 ,  201427020979769850 ,  1069444602185517727 ,  1241364568098606734 ,  750149262687071664 ,  876866434810719570 ,  2176508855160184282 ,  953173667465528374 ,  1253942242922882271 ,  76312917823071099 ,  888742955544327453 ,  786997461911518739 ,  140919102875811459 ,  685870835766502550 ,  672018655464842894 ,  641005602236152849 ,  1656210275607249373 ,  1729901180460769859 ,  87344391551004225 ,  1424774790148654429 ,  481411986248763536 ,  946429317156736918 ,  1310138192384906963 ,  366822005678975857 ,  1881269227889269814 ,  1221720050578826697 ,  1767723141211098175 ,  1605586341259515449 ,  1756974900583799511 ,  2070737967103289879 ,  1350669025882350215 ,  1898071866704015829 ,  1692369600102143908 ,  706952802903774232 ,  1568519463199519081 ,  1319734904803844233 ,  1559566426568692786 ,  1825070887997509831 ,  989030045266411359 ,  1484439077424380524 ,  763430200725296104 ,  464367159486012105 ,  1477736430282022403 ,  313551046385236818 }, // x^2^595

{ 231132643382071941 ,  647171932617700675 ,  1683106097715319311 ,  263657676404897481 ,  76009392010580034 ,  520422392015141395 ,  908773966190949012 ,  1072510144095619471 ,  929645793369545820 ,  1189636300681097543 ,  1194871630987914528 ,  633397249899809517 ,  1382590792421983460 ,  795693795791723334 ,  13649888800034861 ,  1691747108536050537 ,  770259284056057122 ,  2018811686517889186 ,  2260821264570244669 ,  1660078716596119421 ,  1262484867028273487 ,  1059332236955702756 ,  1543234324004010230 ,  1736426630919826302 ,  1391011227726376009 ,  2056363808085290968 ,  2099360810000739521 ,  1290179317359291747 ,  386381649559716060 ,  492023333724679550 ,  628287423343484408 ,  466701706129715584 ,  1901943976995202385 ,  508429322275974177 ,  1539869593995174368 ,  121436532035307099 ,  2157047132950814231 ,  1621883929673834246 ,  816309541938218499 ,  1448304183255283560 ,  1803663848842682950 ,  1745229007292337721 ,  2181851446551658856 ,  743865796384177491 ,  542189775450702394 ,  48233254841638766 ,  1691455656935602614 ,  830538440682013915 ,  1390877699587054459 ,  1887033636407154523 ,  2260480412699617715 ,  660061462558224781 ,  74957207150754077 ,  1272107533300536493 ,  1035418617432688538 ,  1772574076546125760 ,  328996733068816052 ,  291194611254951011 ,  460107743878031589 ,  740479220240096670 ,  1848453977820131771 ,  432430725911005378 ,  1868451582705335386 ,  2290919429984254030 ,  365906239123424760 ,  323007793793153322 ,  1617229248041942082 ,  1334774980242806826 ,  1799444742754467411 ,  865849833205171559 ,  26171686751688952 ,  265981223917539087 ,  787376893314140702 ,  843634965638177346 ,  339054618039458700 ,  1894816011463823564 ,  1851239938668887571 ,  735554349207901372 ,  1003264706218524377 ,  1744905367984069723 ,  574238163270583572 ,  1082131453411799390 ,  221698031868610981 ,  1802231753682478316 ,  1066296670960795362 ,  997028364693972379 ,  1575437334828870668 ,  1605313455065312605 ,  1063742981082416040 ,  1222654088511550668 ,  342428162799267114 ,  644499390392374097 ,  1962816516696670428 ,  275927324527366504 ,  1610838143809148967 ,  1385001851545344165 ,  771874987641096228 ,  1428679581332601064 ,  374209369806173418 ,  1198858776576156611 ,  1090681242603124987 ,  496307485646050644 ,  1547861351215450563 ,  1989952811903441690 ,  1403610671727476192 ,  1066790636751758541 ,  691330805032900459 ,  989732185634709200 ,  56949948959666243 ,  235663321038693377 ,  327311782108441265 ,  75891671359764953 ,  2070345764594759779 ,  1805881874673849737 ,  892656068894607664 ,  1658679410129742578 ,  1745535250294420783 ,  2049588246166300471 ,  388986595171054378 ,  1645891550946016386 ,  1860405186940195397 ,  2050407604970362108 ,  1976153946192947663 ,  1146257561343858507 ,  1275873452221726537 ,  807747503399553548 ,  2248156523255714974 ,  1422423832220964391 ,  1349644570862910414 ,  249753401257930936 ,  338039960381043164 ,  1344066098294873486 ,  996375678137043604 ,  814801608794841895 ,  971794605286453015 ,  1350902410228225227 ,  20455216133564618 ,  1891654427007925204 ,  779340158487148913 ,  1234141638826465184 ,  981995750385588857 ,  299932666213551076 ,  1488218428824283645 ,  2156297481034877301 ,  706915575058588690 ,  1118622822178009662 ,  1103226676401387560 ,  1834202050537121282 ,  720721360048272690 ,  1178472923286613753 ,  337092287422355084 ,  251952273359026734 ,  782258679604339120 ,  1732204150126383468 ,  1290412396566617862 ,  324610192123572660 ,  138055915613505629 ,  1058337952150506302 ,  2001596081246356976 ,  519644007193442628 ,  754912009999051161 ,  703585476089741546 ,  585129320596605516 ,  131508932765627616 ,  1726081924803578078 ,  1525104871525911129 ,  1673386765921125976 ,  231025527320189491 ,  1771439104467511833 ,  932927441611127770 ,  706216336041344577 ,  133457905539118654 ,  1329428143989075404 ,  992158360872937959 ,  1144404407275847255 ,  1317209193831156116 ,  1950943914743602315 ,  1016460713615005029 ,  938955667195760637 ,  525019772302761589 ,  382881427950550653 ,  837574341152465411 ,  1395782483300857364 ,  481013986642022774 ,  732831983758182 ,  167064160890195042 ,  1858491855618533418 ,  557911950422767286 ,  1102051698335362702 ,  1979598742425667526 ,  77824239418661316 ,  1739777890649808336 ,  624954014623061874 ,  1211926011987657645 ,  1072634344673454692 ,  1005882199922936467 ,  868422296684942891 ,  1965002574698431533 ,  1472446087228399270 ,  1291859206977327726 ,  1587404190184442717 ,  1008982777478938315 ,  1711775639873622950 ,  90413055195555438 ,  1617324376151245267 ,  895935331587464473 ,  1954955280777202110 ,  1629736170174370986 ,  538893560578959179 ,  1401523937309572783 ,  530158998617163708 ,  1759856598527854375 ,  545002420753956018 ,  1333180343657375683 ,  758297648237456825 ,  829915515446893966 ,  154771611129763850 ,  329995718172463264 ,  1618231232204541773 ,  1412478307011232288 ,  1701036643169202643 ,  103897939455053657 ,  432680663866021900 ,  1743482155358072680 ,  2175558164973909421 ,  1614512583342465916 ,  632323510531252284 ,  1792304474094081681 ,  2086386841403698240 ,  1613945064275417452 ,  306800322235637796 ,  1028931046026529772 ,  691673265403999622 ,  1519524669246963063 ,  630041655594638085 ,  1358536307063157398 ,  940079689300453674 ,  1985364639238066443 ,  1542932775609642094 ,  1178582654383897334 }, // x^2^596

{ 1492178945114711956 ,  993894509005260770 ,  728559754399423915 ,  1601430066199654205 ,  753749210252170075 ,  978982972698235965 ,  665587850166914072 ,  2197577275495077793 ,  1863800556759344268 ,  872369842281488044 ,  1212012308751350085 ,  1635874987654059073 ,  996655223258270975 ,  2165412001639789649 ,  1110473349201499759 ,  1887688291159088622 ,  378854490158681889 ,  2057809372139384833 ,  1520342637363458806 ,  1533697580379234155 ,  1496670356130703039 ,  1562419712325300396 ,  1642534183498939769 ,  414437061327026238 ,  349294497695425567 ,  1048158213133562155 ,  1315803875938581412 ,  1861974706988738236 ,  2020742508546907199 ,  1870368480006727990 ,  592767219500598515 ,  1067850474193488221 ,  2129252425097745957 ,  1711872317886938556 ,  889989726464853859 ,  1011033964704204690 ,  1039289934779806739 ,  2215136681508198686 ,  762600280051664811 ,  531079699799920263 ,  634575820899401192 ,  593386993971956478 ,  1832149745734928195 ,  2236616071394776903 ,  623515215158875265 ,  775131599629864748 ,  1977363267286356271 ,  1552639620874234522 ,  1725848386720187736 ,  524460112665920408 ,  1871203353169912597 ,  1643296936519638069 ,  1700706537466247934 ,  1331437916741540448 ,  1838573869366684505 ,  1033968189970569729 ,  1233494684308316145 ,  1135753163896534955 ,  2262922042211309905 ,  2258834913731340024 ,  422894940286595766 ,  1810680095854374163 ,  2264580757684364598 ,  1639973737016593275 ,  2293558285847745257 ,  956159906637373820 ,  1611574833633835652 ,  1302373598829419353 ,  880912325386653475 ,  737822345113071420 ,  2065370965053487068 ,  1811530581643883962 ,  1987854036123949553 ,  1564259178043437714 ,  2155131598936275914 ,  111322056311416293 ,  695540133978361413 ,  348526430895781576 ,  666705567821037934 ,  796842910223021387 ,  1641786170840875440 ,  327515412109516945 ,  1255482245366996841 ,  834893549930087643 ,  992363042430296548 ,  290590850723495558 ,  212286620391268445 ,  1567588712317946070 ,  1671135039479059213 ,  610115525157078482 ,  1810012038605216185 ,  2051441521570282072 ,  1488459785028608933 ,  808426309785993694 ,  754204450370277116 ,  288499106205302059 ,  287050292969031785 ,  1869142017019619804 ,  829304768345879357 ,  1068536504001493291 ,  1483317653133469102 ,  1065656696196965562 ,  481935495712460467 ,  2145932691926655878 ,  191403952556774584 ,  1571677300646728635 ,  162665195371241651 ,  1288765223879803440 ,  1937110758529008734 ,  2005983856405412982 ,  2083840707094869175 ,  918961145301211806 ,  2259531471197183433 ,  568331064252186203 ,  2074803685537108873 ,  1623682900062639583 ,  1675044915514150794 ,  1965415188045404665 ,  2060036049779599142 ,  831104190441021553 ,  432454247724988735 ,  502852644054930935 ,  1987180430777045788 ,  180224808928242263 ,  837213004643259271 ,  829869236781029691 ,  2017542321981477192 ,  414344101409638909 ,  2213685143336387993 ,  1201657481221588412 ,  1063140973093104403 ,  344297864235944835 ,  1456412060529496050 ,  263688948925503710 ,  33429853406380243 ,  824703546481109204 ,  1695895992399339397 ,  2118463091595961585 ,  450366154899504356 ,  1565655382580966817 ,  1275382502803707104 ,  401850664871037007 ,  1757776741616083677 ,  1587260319614974015 ,  269375667496966937 ,  1510103825166011341 ,  1529263172545675141 ,  177898138713102040 ,  1439418813458079904 ,  2108537324962185447 ,  2148366976560084499 ,  410249471555180695 ,  1802905215769615212 ,  294683952115288707 ,  815689098599939953 ,  553555390266407330 ,  168394998680048383 ,  205724048026892275 ,  44456299633088351 ,  1207229765718812189 ,  1822939661207796491 ,  689667713488347870 ,  1876818640029883998 ,  1564996669219987879 ,  2238801167853648 ,  1660603445051112061 ,  625240586666510657 ,  400736238030817988 ,  1537796003242329436 ,  1138880957060270632 ,  1516160356564303826 ,  507836559578158000 ,  226272856526679159 ,  575906934558614613 ,  748101201074429281 ,  676864582809976049 ,  305849639346017368 ,  361461503816514151 ,  1619312497632551344 ,  1776882615041234671 ,  153013702455729127 ,  35799390788790412 ,  2282025178173766977 ,  63004703035099450 ,  2001417016880144631 ,  135528818051628224 ,  248290743021680531 ,  871655061042169611 ,  851179197377513285 ,  1034180801051649155 ,  432760609159148660 ,  1092887757753482942 ,  759505742058399390 ,  1654803678198288954 ,  1948244316949954738 ,  2057746138434134084 ,  620035612550254234 ,  1429959698727764876 ,  2134944057525681660 ,  1183403329473307188 ,  539883510773038975 ,  590057981468898908 ,  958870966896467194 ,  1100127101379135943 ,  2131227349280086892 ,  788928246968719487 ,  2241663582372324667 ,  1238280599772647343 ,  923015153806816727 ,  2259038077653298030 ,  302570079672308980 ,  1636986160996760714 ,  1610174664595735726 ,  1911446938223639847 ,  1648269806168063276 ,  1344796347016022646 ,  1064039448596910315 ,  1708184871556302262 ,  1996805217107374817 ,  1373873086413205237 ,  538842410583175161 ,  314350043923137535 ,  703373407455707959 ,  1764080833400411716 ,  850980069408049268 ,  1175971629293070257 ,  365033040610977312 ,  149580361036951269 ,  1660798582899651337 ,  1171594575800475067 ,  421699940471122701 ,  62727619234084591 ,  1851488143843967492 ,  1293488606667413857 ,  1800301838300530795 ,  749561616972088576 ,  632845913323014159 ,  105344126318250795 ,  1818784586873925178 ,  271090014099278440 }, // x^2^597

{ 1440663969112459527 ,  337309414629032671 ,  80860990942544469 ,  298575193194236139 ,  1349227134572206293 ,  2123073476451851875 ,  15331023348834115 ,  934228570998617226 ,  462868875023400393 ,  591285319027504674 ,  1774529141790946300 ,  1344267576451608881 ,  73768578744668088 ,  1178855278112200841 ,  1755783363830146864 ,  2189969524105989865 ,  1895539635022223832 ,  2276776226031798552 ,  271404518845280911 ,  775034932834774125 ,  1482468386951438291 ,  849605065366738975 ,  810275464871055269 ,  826376606540561415 ,  270622067113277716 ,  1645887914400160227 ,  1328340267813858858 ,  182313391975226765 ,  296283126189682186 ,  1390839771996311594 ,  161397262810012822 ,  1669849512255280056 ,  1421625540185321825 ,  274927026827777871 ,  14949455577866881 ,  1068956120894270231 ,  487689552515467640 ,  1461978653847311313 ,  1053425247562714583 ,  62004479312974568 ,  349436967109930513 ,  1913745140199540421 ,  1346918626898295845 ,  903362972174777809 ,  1415562190668895078 ,  1629306445979530998 ,  51989789861316241 ,  1056318715909544632 ,  1143099120924839100 ,  30916511017471744 ,  1998407906443498701 ,  278595674837100684 ,  1290895355597700094 ,  758169446521420741 ,  1876148232251108112 ,  1057690007033756917 ,  1385155878732198526 ,  971640139781320333 ,  1358922800836965606 ,  1941988284386580671 ,  918929053729613434 ,  39248062539513268 ,  70726536037694660 ,  1812743177070720076 ,  1786610465150920612 ,  2288577894170173545 ,  2070834784743410710 ,  11964884098267061 ,  2048232632566619433 ,  210985678839417697 ,  2112090107275061365 ,  1804626987373940772 ,  2154739010371068960 ,  782692708114122660 ,  372569118778078856 ,  1299266667365342104 ,  1085350031845146110 ,  212898516337845075 ,  1705233541225292523 ,  668104181497685918 ,  351854500045892995 ,  576178025177875648 ,  453573676976182410 ,  1036176092346200998 ,  643647576751291919 ,  1267309026298649034 ,  329427678414224582 ,  508006760052294465 ,  2016234254722453538 ,  902556361727289776 ,  1354186216596787230 ,  854471418665639377 ,  1873491197708844185 ,  968477273874824313 ,  1814982492174136337 ,  226333412710664467 ,  1505254897020246040 ,  186655792032505079 ,  1072602482702985725 ,  54910667364385067 ,  966042585879506626 ,  1695479539047169321 ,  1776124243330266402 ,  1858997118095099055 ,  445508048521674879 ,  237950897614110492 ,  299049393396561004 ,  1231559637030090727 ,  1034546713064167319 ,  1705939015549310741 ,  489298230851220632 ,  795867991123847921 ,  1191535265412930650 ,  407794787196278164 ,  2066566698447185274 ,  1042658850115265436 ,  628259709927574020 ,  1980541286661962970 ,  1899266740309770998 ,  1965251928583634375 ,  1661782831506777115 ,  1154898848909502360 ,  1627175211826212104 ,  1181146151211017017 ,  1157487739174120945 ,  1078412760249120895 ,  57257239568707037 ,  518455178187731790 ,  736710117935186127 ,  1975142113591695173 ,  1339951770688451606 ,  2258754547101953005 ,  645102413385653076 ,  583783934875787909 ,  914432458461828238 ,  166246050149912315 ,  1747238631053261099 ,  1599412358411448009 ,  173699562997827959 ,  2027108504540942930 ,  638157350946106743 ,  1830776838219481021 ,  1950194796045477166 ,  438937359982337503 ,  545716128744396703 ,  1551380585010088974 ,  43566039430810588 ,  1172365779828990774 ,  1324504311340491311 ,  1618821158521482734 ,  661309178185917279 ,  741524685144781832 ,  1727451619713925656 ,  2227089627304377683 ,  41476453345980678 ,  2067550568607657664 ,  2242777447190486711 ,  176832484155684057 ,  1286423172798825905 ,  202911039627365239 ,  44715461098698277 ,  2148636181842081279 ,  1665445074032568460 ,  909470954652750277 ,  2109762078531976504 ,  1487620834827259511 ,  2186523116928064634 ,  2241045681709243656 ,  1225029848253400483 ,  1404855740675709169 ,  117824275952082295 ,  1452056009679214438 ,  1186674791769566115 ,  272372587321003101 ,  588397812134601791 ,  1388989952816497375 ,  540651902010930852 ,  727291963176335396 ,  2265273486377216844 ,  74825476209324318 ,  817277587979785387 ,  1786347527708768051 ,  1676803655696866865 ,  2165162734950921877 ,  1379697277009454743 ,  383313627901847351 ,  1055860093486991120 ,  850808361122451477 ,  429228848087333371 ,  984227631686767695 ,  227827037869684921 ,  830429925591551922 ,  127404879532717193 ,  234431138915804852 ,  1902142544220781573 ,  1421708157032670444 ,  643654815933604099 ,  1960341179927908732 ,  359123897651212058 ,  751569554085151749 ,  1660421037616959608 ,  1458866770665945361 ,  1572642161877964339 ,  366780132734344810 ,  538577578067014612 ,  354439832101799039 ,  1199566269748948885 ,  1457491180899270587 ,  2049457496495739562 ,  451696269217745085 ,  695401712669642672 ,  1704225835071843448 ,  2032524141712428111 ,  98670011346220335 ,  2097519977072878842 ,  438105519085798073 ,  396801299939076599 ,  1758884093925031205 ,  1788926632108565242 ,  1454995001808126899 ,  1816171082077389703 ,  2282188504152264468 ,  779278358391153674 ,  183051244166594978 ,  1730750988689552132 ,  1822220849284815237 ,  1917508477317120900 ,  382552390733941585 ,  1511775053565120162 ,  1291332443350876376 ,  2178499266773050820 ,  1069442434090211921 ,  891962992929790505 ,  1359573926186545790 ,  403982244710183669 ,  492155144500532526 ,  155487821172728130 ,  1215753637021446349 ,  1435572360098184535 ,  1493045578490214569 }, // x^2^598

{ 1449952864703640194 ,  2018213377230172105 ,  977978132679276461 ,  641427455592931936 ,  784879298741029899 ,  1828206487956064328 ,  74714321611508990 ,  1275533858975357665 ,  414195393974975276 ,  2112214658468867665 ,  903197118773499769 ,  98941874966206108 ,  1149759481713311391 ,  1221570250057530365 ,  567611757195610477 ,  1315790278754599956 ,  1417074645800539637 ,  270483315795480735 ,  1760943660936341638 ,  2302790440141664210 ,  308045896137860924 ,  1026996824367520910 ,  1450857895703370301 ,  1536820028661728151 ,  1762383791331118555 ,  1426385052499203251 ,  1564942893259473122 ,  337384723925928552 ,  383225546435980618 ,  1295150479410769631 ,  1309550557366347734 ,  2244759681836212578 ,  588295398230212407 ,  2151947639037470915 ,  1714638001028686791 ,  1558603171601924748 ,  1236278083532676078 ,  1646060452649362334 ,  684385766456230934 ,  320128196573750385 ,  1935900955915383440 ,  321972869053440016 ,  204623697988438985 ,  1101137854354715544 ,  1452266464593241191 ,  581642527424472442 ,  1705682067761087915 ,  1256578104350634223 ,  583931135337462382 ,  596720630338487833 ,  1586307199038396297 ,  1877216775042588990 ,  1332107279686503416 ,  221326676146413293 ,  1219290863644981658 ,  1015080522826412706 ,  1078045936976995414 ,  1685075051077296470 ,  1448998924568218242 ,  1492122401238152007 ,  902051847997144914 ,  2196183314776200838 ,  1239978244465290196 ,  946844260718378726 ,  1103475033531202693 ,  1541453641557247416 ,  1487861347828272724 ,  52157953371790204 ,  81126469128940006 ,  898767411326871213 ,  293090834092695933 ,  1830183009070541056 ,  573394721508712714 ,  231607785988214294 ,  1127121226424336937 ,  334708425155986073 ,  1902099659128822281 ,  1147742130723945375 ,  1549610954084289759 ,  53727379344404606 ,  1914611441418730460 ,  1050493085420526663 ,  1695648685232089719 ,  1209820230691926697 ,  260414450347607424 ,  224723961580921104 ,  126594229755148048 ,  1585702862950084626 ,  1282012391887968546 ,  1352162422178459163 ,  288061676067483819 ,  1770517359740262085 ,  2200219062142405897 ,  2097764748943439435 ,  517441705630118825 ,  1773417940656411337 ,  2208839919539904294 ,  900087969118377218 ,  522404290550028584 ,  2284541138656425143 ,  1417121019282495713 ,  2174233303547591369 ,  1958658937169601591 ,  936250751927138874 ,  912014790411966997 ,  1852677782616784629 ,  1564866923580604765 ,  509383366698518149 ,  553468964465426267 ,  2049605302538386824 ,  1207039207158793232 ,  1300159758218722145 ,  286057262266954569 ,  1732866886206436171 ,  630226612912742497 ,  544238900146020063 ,  1550887731573529907 ,  177318375039293866 ,  87202735666481756 ,  389711503277485159 ,  1656582234232146398 ,  1943816855579404027 ,  1083691864519875170 ,  848491644720337499 ,  909761851130912489 ,  2302316456016515367 ,  1532034753221899620 ,  1362624399312121687 ,  1542371168746789487 ,  1857769811949661255 ,  2277605145873617339 ,  1695450320623325300 ,  2239861169699981836 ,  430706214733385169 ,  1592570574526635120 ,  105917487446939534 ,  1957215573782181263 ,  9294396203929131 ,  2135901821375393266 ,  409418894504473576 ,  1132298350034148252 ,  428389888440493944 ,  1761938876123597198 ,  347832546014467095 ,  1963648174941643655 ,  1699619884195106189 ,  1345332905934143069 ,  2002452963159431310 ,  1882269855321679651 ,  669319720427258354 ,  826126599215021118 ,  792718656575490075 ,  1682461696871462461 ,  1300964922948048374 ,  93231555431681340 ,  1328562410361530476 ,  2256856000034938452 ,  1133427977543075777 ,  1009458218511096009 ,  1731385339503031080 ,  1417950060932082354 ,  299412158949965339 ,  685482169562464442 ,  1140735465655941417 ,  2125434648988839139 ,  116920096379868888 ,  688852068456733095 ,  1829625368845053759 ,  665943832539447610 ,  919236210168651968 ,  2061312026089466956 ,  1096049996588729747 ,  1646318749611969507 ,  2113868791190661196 ,  2180822301592138433 ,  375332448879987023 ,  1326370121649187467 ,  2172588802046769548 ,  1504648200931242662 ,  2049979480195885955 ,  1401719307196411257 ,  169669638018993289 ,  1206326787627769138 ,  2273964407237138823 ,  1559519103991153344 ,  898737720897220018 ,  1269444401016790317 ,  624126110388366759 ,  2155934381242379070 ,  1251474646265337867 ,  846774547582109315 ,  1476837011818070195 ,  913119429922519110 ,  1880687908751790768 ,  1090031081534203264 ,  1050286411151979041 ,  1418377659548628080 ,  1574045606522349246 ,  1704740078234153341 ,  429768353809365194 ,  2089764778629001260 ,  2097633736088136104 ,  1748424674335082000 ,  1379900394941623696 ,  1247167286243604782 ,  857773327683622868 ,  75185627837671618 ,  163111478577744388 ,  1998098832041127427 ,  1426742652524698465 ,  491058167460337014 ,  1914169778831614818 ,  31141718607944021 ,  323156202015501122 ,  529143528672520598 ,  1478062514159952007 ,  1518912767395889934 ,  251665596463193833 ,  471313041897980473 ,  400683064734649290 ,  2088728573937105566 ,  489187981606118945 ,  561681278968600474 ,  21661435235038237 ,  1946477921802807475 ,  184678631864419360 ,  686321709630559443 ,  1320512545207269332 ,  1857866485914939040 ,  1816195001366481002 ,  1004705638427082528 ,  1064927234570263349 ,  2093830709108171512 ,  405558589741472942 ,  594574554683125355 ,  775338440322549960 ,  764142564658940578 ,  2025246321186983907 ,  1598103435792367263 ,  2279925921822132446 }, // x^2^599

{ 1828046772245666234 ,  2057692414358779538 ,  1349053430862209071 ,  1447002518569299075 ,  1717116393157959676 ,  2063749976209666811 ,  373760514939597629 ,  2067153240882156611 ,  1252838339897686567 ,  2283274557003827324 ,  1587858542649677322 ,  1552776248350160046 ,  2020085637665949237 ,  2096558953296524309 ,  155706850536558174 ,  952352930503276649 ,  521968588537104410 ,  881738202816992615 ,  1056082063892491142 ,  1195477225885701089 ,  869079709456390956 ,  1205922549898074620 ,  331769764235753689 ,  2255557580813468193 ,  1832655230284618686 ,  1332305141983129839 ,  784545279461869253 ,  1316835285607145648 ,  578095331554484288 ,  279412745732699963 ,  1609795094882065550 ,  2126658104695652230 ,  1230063895644182767 ,  1397860581730256907 ,  2106087926157473963 ,  269354031790942360 ,  1442338905555465678 ,  2150442077262038571 ,  1245646461313919244 ,  447749772720483097 ,  382667959062156950 ,  1173382009246393119 ,  327640484287519194 ,  1573077378906193705 ,  2117653538477056974 ,  1992371735032860876 ,  382457083797446730 ,  2123664378621787524 ,  1846295444041312004 ,  1149567033140267858 ,  1053558853836555934 ,  341725396400705452 ,  1958561346295629151 ,  1346051630489826478 ,  215683299377260060 ,  662614627914703765 ,  1281184419058658522 ,  1909369102592212005 ,  605465678210722830 ,  1455070764489976973 ,  724891160791671725 ,  240637261459911413 ,  1668773536232162790 ,  1589906877257729125 ,  1156580252505281339 ,  1607038617871568046 ,  8381827606109447 ,  1558631206918316532 ,  521762823443872275 ,  1469055133156646420 ,  38071196216988736 ,  163030610253486059 ,  1043274944894656884 ,  1651257135659922135 ,  2042546148869119153 ,  2269965696639136881 ,  1111873347374656214 ,  958474768859573832 ,  191301145531924834 ,  1829751703922830743 ,  116487593157961952 ,  960814328410520373 ,  69319667756638600 ,  1013271629762047701 ,  1584980440996643216 ,  2282764996411591741 ,  452366028987108622 ,  578431028102467909 ,  1866039636750375891 ,  810962405806515870 ,  202031819475539672 ,  1928477493572786377 ,  914291894735188104 ,  2235328502806102264 ,  92292092041088436 ,  1400369805485284996 ,  1512658653442403763 ,  2210404839944476852 ,  927223650839487658 ,  696967950949968862 ,  1438002400204153167 ,  550585598787447880 ,  1722692604202607788 ,  82723685260348265 ,  332106172867772539 ,  1450909613271982291 ,  484260433376699797 ,  1282964270070788938 ,  989224744903630762 ,  2064994959967583959 ,  77506633077625880 ,  2100291810234279551 ,  306199537351744938 ,  153621382428429979 ,  93917968105375941 ,  1560016875272353271 ,  491330338018947567 ,  1205040120140765341 ,  515220063798712489 ,  581272584194208954 ,  956588190112155576 ,  226215060995570752 ,  1713423031995375186 ,  1626879393513058451 ,  1018687753745583653 ,  2192898928842140770 ,  1467737625007512463 ,  2116609370312674099 ,  2174542704207481973 ,  2277279599897700226 ,  230179200141846724 ,  807402959635706284 ,  917159263306788761 ,  471879039555068335 ,  1958875340006773647 ,  396854395100002817 ,  1855051814018534939 ,  1777636965081144260 ,  1076587855498016111 ,  1654105260506716338 ,  1397006276439219658 ,  18942503313455088 ,  246619390020379876 ,  1544116384155293785 ,  1396942124523702450 ,  2229835854950552260 ,  431250403014273177 ,  206577490405545787 ,  257175748907140813 ,  1737651320474404528 ,  1320277867914585763 ,  425144984070192492 ,  1124370081020462197 ,  105798369860597523 ,  105746442656494670 ,  1478868580430725686 ,  1402255324496948242 ,  1327889352412826352 ,  230580157694504679 ,  1727076776979076222 ,  2246888646455555689 ,  920912325438099012 ,  317560511839496816 ,  2144924983103494943 ,  386391919468265412 ,  1846045841916545776 ,  2189522707713383009 ,  953637522481610876 ,  1200376584856592032 ,  1047343781044330947 ,  573578297514061872 ,  989630987556585759 ,  745398739964318620 ,  657842384800662914 ,  363935746082733110 ,  1840290471267212832 ,  557773295637893049 ,  2252412831917707196 ,  619430991222971468 ,  1170014825511103715 ,  537457995709823325 ,  2123961923752819342 ,  1217415078246336771 ,  2254979575658923565 ,  2005272225895099614 ,  91620317049948146 ,  2041546891234021055 ,  1371679369408239293 ,  1523145054495198637 ,  922389947397411854 ,  2195819744817200406 ,  1147395787256808926 ,  1298188419491301079 ,  855675386344803912 ,  1402406843810408409 ,  517013900576696088 ,  722985121191220861 ,  214946176714831560 ,  273032724319456079 ,  490677709717622689 ,  1273310261281917214 ,  604666887318053533 ,  1049749098073226035 ,  1530195668829138671 ,  663952805226015171 ,  1943970132369449023 ,  708909702639821711 ,  1330438312846749817 ,  1082330004894528034 ,  1408705687514464450 ,  589304157666027219 ,  1427590212162692591 ,  849889438776178574 ,  1405972224621803199 ,  1419727572623462117 ,  1957955303520643620 ,  560266826996239952 ,  945370651411114074 ,  210254871753261991 ,  2054719889670938886 ,  353244564069470290 ,  1978475781579317825 ,  511907549109118080 ,  1452244496880882000 ,  853596625251841978 ,  2137481923619846588 ,  1246954628819759656 ,  290584903432034868 ,  1334529498972985340 ,  1831395280766865147 ,  432051779321847337 ,  1228216274536282719 ,  1397540807508243769 ,  2146592640621576390 ,  721775601696226456 ,  488023605889869905 ,  851336996042860395 ,  946867542320933730 ,  1572413816402237835 ,  401212341032653934 }, // x^2^600

{ 1902299337349569855 ,  525996428112656412 ,  1089144630173947223 ,  1757040546791513064 ,  937599517878148307 ,  363390880001432875 ,  1470275197194617262 ,  1454311010857077456 ,  2144273555452011428 ,  727375802352479706 ,  1569991120221153872 ,  2147749469372662874 ,  375499942360401757 ,  1484365692919604011 ,  1994252235030853814 ,  1928319910901108850 ,  1938162567710754691 ,  2139048075017551780 ,  2214142124710808492 ,  1788341201847453159 ,  1538595457548405046 ,  1879106849837138444 ,  2296701985470236155 ,  2232362134006935829 ,  2157285299293699456 ,  1840522511802136194 ,  559958993358799966 ,  1509697357049486201 ,  324674202091419857 ,  2082306429421952623 ,  990949652450144161 ,  428215533614914478 ,  567682126042821230 ,  2015859945616268787 ,  1667400291573404700 ,  514414294573700668 ,  625985942929828749 ,  795224144421042261 ,  1379917069088641800 ,  898439021479118141 ,  1790165655411542551 ,  353651376470299841 ,  457577141058457774 ,  152512428513450366 ,  2240485195457157665 ,  1236080585144770779 ,  1965872228054311268 ,  1282875583773411242 ,  690196826147637315 ,  1177270553590273391 ,  1403069604467652978 ,  2044730392018813060 ,  951582806746947686 ,  2202002374794991031 ,  1065228159786340263 ,  1873493586928091289 ,  1100052092975481597 ,  953585307783164455 ,  1322852836966102762 ,  110833661252256668 ,  1931085038618726991 ,  1491856462226596930 ,  589059859941693283 ,  1189548199480420153 ,  82397217326645466 ,  1460705568411898895 ,  1538838089555116259 ,  621462550634175122 ,  386662041912730766 ,  68012303908379115 ,  125208933829230726 ,  2039744547394401104 ,  2265913724055556206 ,  2237960247726234763 ,  1907800651041846367 ,  650226227880776541 ,  1012077698043511260 ,  1635943299496311055 ,  846167118332666670 ,  2265885685708363429 ,  1805677656063752031 ,  1451581899319966531 ,  925539416455927236 ,  138080664486397236 ,  1500280468812253854 ,  901995016549550488 ,  993475571484968627 ,  1128985770484632454 ,  1453644486744271138 ,  1830580244890430398 ,  1721599707450722021 ,  2128623991953703592 ,  849576062217936342 ,  337816032831790039 ,  2276245507488355683 ,  582427338082971069 ,  890849074910135147 ,  788601159446718242 ,  728914361726751250 ,  542441144588317046 ,  1354367614167774246 ,  1468523719299757941 ,  190116585462750014 ,  1817840341995557140 ,  1913682271264390471 ,  1147401952236425418 ,  510259509225003885 ,  452482487405393431 ,  538894112443093452 ,  1851174200115146526 ,  436536434000639060 ,  2075427527834796661 ,  1019656379609927551 ,  82621169187333043 ,  1116919723627375135 ,  756877130774184489 ,  976629385426108154 ,  842476685060003979 ,  413983166632894460 ,  1986505231871029554 ,  902030718901932240 ,  80083746429538636 ,  1340275648045128854 ,  445412663934515942 ,  860682663954789743 ,  910499369628042831 ,  474137104685814486 ,  647470387398270137 ,  518375072033485927 ,  20102756539663302 ,  1992212118921289115 ,  1439570375960971908 ,  651304850446511726 ,  105412513617837370 ,  1629483001722643930 ,  1058109036445031407 ,  1931599363349758293 ,  1843963149476425041 ,  116389008377220717 ,  320101963246152756 ,  1983708918735913006 ,  607932030604725669 ,  913025207373984425 ,  857865583495670264 ,  461850978733806289 ,  179944817419434973 ,  1362802226698564381 ,  1761574289060833129 ,  998946784452278812 ,  901560143485189157 ,  697755304889037260 ,  204853354034036355 ,  1432612563581268325 ,  1747063262806097086 ,  2248711027528735979 ,  408392626271987042 ,  1266117647747745823 ,  750506739363732089 ,  591938672345691390 ,  278523792446279194 ,  1069433876608989842 ,  493081794304328976 ,  1908105915547988522 ,  2062375196262815976 ,  1948003989287219651 ,  2026553976426051072 ,  792827611425118006 ,  859757483927325113 ,  140481253014115979 ,  195501978668294716 ,  413149794890058985 ,  1751262764746019231 ,  2304419834250532618 ,  273484415128436973 ,  2214042727252868514 ,  823947115615198281 ,  734853269998345180 ,  160918597209216724 ,  726466973592927081 ,  2236416346382697915 ,  1481267516187924877 ,  1609833597210504396 ,  379685752246654216 ,  562382261249336591 ,  1506463947872170550 ,  1373587859436127812 ,  737309036271362796 ,  492642878038497522 ,  931889207511628548 ,  449731315565107183 ,  1377846660988523005 ,  609342630609708728 ,  2225361577092520210 ,  2056345759633383104 ,  2254569890379560264 ,  1443975504260164366 ,  1931222970225595435 ,  956799800835350319 ,  1941404124571882497 ,  1242297208125410323 ,  1807683672080917472 ,  461186064131006824 ,  2201878995177136943 ,  382140185345481408 ,  90406606637439398 ,  352718726851560639 ,  1589849090738449567 ,  38737870451231241 ,  848102586206025975 ,  770810499258533359 ,  453873856890127437 ,  1458543570543357225 ,  784637740701900058 ,  325800567206078932 ,  1548147795692803388 ,  269151648318602354 ,  595866895163881518 ,  1827018281993829561 ,  1865676939194868910 ,  1705323090818884295 ,  1948296764737722047 ,  1678599119614292330 ,  1172621710119221569 ,  2083753399976715929 ,  2208231738627919585 ,  1262162951780734677 ,  1518466003091535211 ,  1868587452263355903 ,  1628067577918995481 ,  1472576990253594652 ,  921928649375495204 ,  2250583424272044736 ,  350258012296269915 ,  2085640739647675485 ,  1666348619647702964 ,  1346837476178517019 ,  461933441796982600 ,  1479568616053277642 ,  2153967308923642985 ,  1655288400673236940 }, // x^2^601

{ 743814222720526625 ,  166096029439590301 ,  342584176452424286 ,  1260879903066796019 ,  2016081756136218410 ,  960689747714558626 ,  2250874471186152736 ,  224959882247886676 ,  384302731083001123 ,  1120299271001125775 ,  1218949243156015236 ,  2066079529222674763 ,  1292990912719460045 ,  1922997586535346610 ,  1873520105227163931 ,  1771460276750504804 ,  2254056722947255241 ,  1569009050033547086 ,  1488088074200413740 ,  1881577178389112331 ,  2295721019138441502 ,  1152592759824611022 ,  694944577671006185 ,  529346947627302432 ,  1666256843850061239 ,  1775121133486803287 ,  93910227935267912 ,  1632307541556119478 ,  1930670828123040766 ,  1169556083116661501 ,  553245283585560942 ,  1406779889625310640 ,  1095670908685762388 ,  60148716770121582 ,  2106939540540852906 ,  591463008516928096 ,  349412636306348454 ,  567981626548553969 ,  1078115988844330708 ,  166416653724213089 ,  1959085188303968430 ,  413191411986893863 ,  1812545232715151380 ,  2080889000026636862 ,  944625717302626091 ,  1459989856121160005 ,  1304199940845757781 ,  2124669044533695865 ,  1662386752632199498 ,  1204435448936643627 ,  75027298840958679 ,  1121614656067487224 ,  311126438157446662 ,  1182120979858551302 ,  1034143521903453657 ,  398112082463831759 ,  1766314506884515125 ,  1057464044030607282 ,  1336402934811284499 ,  155992687204944826 ,  949344298437519601 ,  242739041748557195 ,  204709437489597681 ,  491046423358169572 ,  530594247941683546 ,  2294932066545114077 ,  2015278073581471942 ,  1253198638409383254 ,  895867353606265104 ,  1998484065801122009 ,  356886798032437562 ,  1068111295278185528 ,  1129109017513966868 ,  514550684860959636 ,  1756510109034546780 ,  1636621297270242697 ,  1947697140125177784 ,  2096890167226158915 ,  2179777391282821457 ,  1608094359660981137 ,  1899294104645624556 ,  1873446086078579809 ,  1921334567945859543 ,  1127926219340514537 ,  954926994991034974 ,  1670330391066559354 ,  704408649837875972 ,  487523534523978968 ,  911158742218798922 ,  1583305905766822378 ,  642475736956856908 ,  1815090828267085105 ,  1331261667108585022 ,  1856936095651170320 ,  187417503536673042 ,  454405180198466609 ,  1160053234856403429 ,  702064292745800561 ,  1891511333461718372 ,  556448767186362594 ,  1917973091583267303 ,  2117102018393003464 ,  374031538755675907 ,  1961918601712511278 ,  1484569633306178583 ,  2091274805839810504 ,  44179226611638643 ,  371103427578039613 ,  1566541262752815488 ,  1672898454336857250 ,  507524008639447996 ,  1042800325677065510 ,  872509229412806410 ,  1325768366419525226 ,  2302370704195007578 ,  14973140448505016 ,  909811427683160090 ,  1581117590346904612 ,  1981162220054245607 ,  989940173595208251 ,  1955215312938160212 ,  614289910241056321 ,  2059582369471651947 ,  1220890755483901212 ,  1461850837304878923 ,  383706574271629336 ,  1027096150490908578 ,  887805911020350235 ,  1067130145666412937 ,  1951358246885367930 ,  1424637901349675593 ,  773156396600265121 ,  1061592600155602465 ,  279205129526804910 ,  2152418116393012851 ,  1174769958821596894 ,  1446515779736046437 ,  1127715078813207059 ,  1001068111644010813 ,  1223806728604542754 ,  1395695116423127955 ,  1202736197973115798 ,  2111043474052332649 ,  168629913295461431 ,  1260937301559045858 ,  1056302224194126804 ,  607893608159182951 ,  2206821346826550903 ,  1942019701358553892 ,  475159113922161591 ,  2194667768033294657 ,  2258279790107604825 ,  1978471911026049222 ,  1734813932132152980 ,  853791955473657572 ,  2180999651579522172 ,  1590297118767548677 ,  1091617937684708908 ,  1288222326617616083 ,  1069777546828708944 ,  1700756938491920389 ,  2121945771565705505 ,  1701321689326276071 ,  1156148038696306835 ,  2189609499563049800 ,  432926845467733335 ,  865142528754183239 ,  1071401021137522985 ,  300542823863778880 ,  1510567317108733111 ,  53370048274406960 ,  1478007691972671847 ,  1390974875579171060 ,  664377036906158713 ,  1813707178372957737 ,  338583545125623144 ,  2170810610762113312 ,  2138076929313437101 ,  526796863583184190 ,  1941091943840399824 ,  653461151457352988 ,  55313540036900852 ,  1840294609133919153 ,  1523260818729739186 ,  1437681684280708208 ,  1315880822894177977 ,  521662601312763591 ,  1896906956352508824 ,  1671673637264785250 ,  118776759799059786 ,  1413127950067951832 ,  388481227675341034 ,  1800424750825325449 ,  1053537638307711484 ,  1350891365975299307 ,  2133223846902459157 ,  746049443491320268 ,  412961249388214463 ,  1008999505433193853 ,  592298261400523844 ,  2137019095138248837 ,  1247800253133957930 ,  1645878657327133691 ,  1170548461089216502 ,  2157373677326204394 ,  171055105686409072 ,  1306945565395299116 ,  2214486225322866511 ,  2178473135022640226 ,  226929991689249570 ,  455551978570273199 ,  1053567085242036163 ,  1008789528703226240 ,  1475164509464470869 ,  1339825261750334097 ,  322101076374249588 ,  826671719060177030 ,  776332228901870583 ,  1514836217918762340 ,  1441647450184795173 ,  1070859768299649363 ,  398859885250973002 ,  2035118306990424212 ,  1715438121898148113 ,  863368331814685769 ,  2259868940752629639 ,  327631397447464453 ,  188674388249779690 ,  865356431884979285 ,  1499196163091707778 ,  1858440252868693501 ,  148285081091699144 ,  2107277361357332348 ,  444517692369589467 ,  742272627392628473 ,  532613275440043272 ,  2101106518958084543 ,  1391624458532748333 ,  1250808473042394107 ,  284670755230246839 }, // x^2^602

{ 318718074375379047 ,  1823725433513058060 ,  1335895194830318253 ,  1324171490133306676 ,  1135565349361093985 ,  1683848238082057291 ,  748761841776296382 ,  1362280678477097251 ,  1016420130941995611 ,  603309124473580249 ,  794204301827224648 ,  128687824085108290 ,  62032652559013454 ,  1649688507644425566 ,  1660684992728785987 ,  1428253080430996427 ,  2232340912410281475 ,  2179130223082058525 ,  897341623414105373 ,  1071423397101815570 ,  2103053153159959980 ,  640269677104578759 ,  1564907273756249705 ,  1661868189859208749 ,  135141266195677505 ,  899141674160311378 ,  918397503719356468 ,  806204209323107151 ,  547037495190454386 ,  215063972259867207 ,  2277913521688312769 ,  2273202642651371941 ,  75893542839064269 ,  1755678779388572438 ,  481569834768823731 ,  1795827737862882080 ,  361053791541629668 ,  337122268240938331 ,  1022271194888300777 ,  1577993537870224973 ,  884802384010424197 ,  1057775321867178407 ,  1020125531299099948 ,  263276466549358373 ,  898581106228008474 ,  2098943862346041975 ,  2010104631271929935 ,  576125661791292063 ,  408009820904852976 ,  2218355635038238435 ,  1543218700502066667 ,  1054081810669593500 ,  668288997212835556 ,  1885307604400084486 ,  1676958139262986600 ,  1943114398643001993 ,  734683818534727848 ,  2254403991368443067 ,  1474141399098507269 ,  1156439790514088951 ,  2107904719912654183 ,  1508773173886903237 ,  1003970563098928941 ,  1523076129537089770 ,  1830345415657140745 ,  1792557808720082635 ,  1674903493337795285 ,  312272683814835781 ,  1952456019538085419 ,  1410925335169505210 ,  1543461492860014628 ,  112874877970870949 ,  888244925658994918 ,  1678927979525959332 ,  1604451799358819950 ,  1237957086133643525 ,  86932387230602144 ,  400134536009781337 ,  1704868889267403759 ,  2059336322291862389 ,  1687783050641531285 ,  1260326927676718838 ,  2257579118995457895 ,  1406377088373961260 ,  730027886779069068 ,  265357836444103635 ,  2036667451565694982 ,  324510274768453994 ,  993563832210555030 ,  1223370626799533166 ,  742128445725249787 ,  1492374076773390373 ,  331481002386018056 ,  1327931833111440486 ,  1309013233358609531 ,  1913262749539391272 ,  261931232133850753 ,  1188940548923757650 ,  73468136438567105 ,  307415616803580912 ,  1924004882495386727 ,  425176891774120834 ,  1663586757700883031 ,  35013709731372726 ,  1558066981135009759 ,  1228085263281888174 ,  43506380438630022 ,  912122261094668727 ,  865176762453998910 ,  456248598959194203 ,  701041811203695085 ,  1565464216675075401 ,  1518011078943468340 ,  1518076665527924504 ,  821333736179539104 ,  1983319759697051029 ,  256595921258155024 ,  1829736940475173050 ,  1123861905203419211 ,  2040934877693351930 ,  440529739991461064 ,  113791086170787940 ,  499635743108152884 ,  1996487349215144550 ,  257823477467843665 ,  846470737290101557 ,  1784706401318138753 ,  1135436746442698383 ,  1328911401733322890 ,  444269708058864030 ,  1032896723818838456 ,  425306777385064331 ,  620976440606504938 ,  2217358446069928652 ,  1575548042199067252 ,  1842651991822061875 ,  1733068623760535744 ,  92560042226866356 ,  2095337305431704096 ,  1219280207503992052 ,  2067615156764792166 ,  156717061379415413 ,  5276980498722093 ,  1671719853321124972 ,  796331376920193047 ,  1925095316545484584 ,  1950708218866226019 ,  885082431652363046 ,  1712580945316634581 ,  1213468396470893247 ,  641648178384897439 ,  718460017531956061 ,  583668987260269218 ,  479717951742377928 ,  1571903453299694361 ,  1504640932671363643 ,  1850759602949711288 ,  1990840122761160625 ,  1500722774866451024 ,  698075174100774882 ,  1902553646628088233 ,  684937856488020134 ,  1932097077268368712 ,  1441746758621457970 ,  423117202903593868 ,  360886856972257929 ,  1300188719186860398 ,  1044808472256333481 ,  929659244325028081 ,  982672325428067451 ,  1016290088101564274 ,  2081332903337339018 ,  2116000483383791935 ,  356947998345468745 ,  1394008906534575075 ,  1333905207504532770 ,  1437120345880697757 ,  303703373253373772 ,  2134259230812091465 ,  2235631208327733061 ,  1398998105577819759 ,  2016147645530851508 ,  336100310647661682 ,  810053299032033591 ,  2167696832545011177 ,  583146406776227258 ,  1547769109823398431 ,  617436124468102633 ,  1791528870935309756 ,  774963668967027293 ,  1350705054198519489 ,  1964203551807794131 ,  1215048204249399120 ,  82248149612307371 ,  1417087897976521944 ,  332381226392319448 ,  1915672961802366405 ,  59301319977415388 ,  398601052811739008 ,  173409753229849798 ,  1682867823639422877 ,  1275026150188415660 ,  2241462497670361153 ,  2075216371838716070 ,  2203305805237518107 ,  1909749404187132557 ,  2202943005074762886 ,  351741966700907746 ,  1520584079481696950 ,  1652499507248263496 ,  1181092523493806182 ,  1168179349135879717 ,  721844284326631457 ,  1725999788233899108 ,  1605025004700454517 ,  1950091022332313102 ,  1406875232834231415 ,  539793045027906202 ,  2242642206679266093 ,  859625853606816834 ,  1270775512007533670 ,  1587623858024071110 ,  1126823619671732345 ,  1132796445934436499 ,  231673766251267323 ,  818744511985954760 ,  605486094777148103 ,  1130171564448138174 ,  367067183807896857 ,  2119817682801223638 ,  2046978275682334436 ,  1590305196900099985 ,  1049536496561630295 ,  739200177995228412 ,  1950515579110155568 ,  96292491060336667 ,  191055421716604162 ,  489724776771304143 ,  729613180939051757 ,  1991389087773134245 }, // x^2^603

{ 1713645240344629228 ,  954177415228776699 ,  355924617334308065 ,  2206566816194546159 ,  1554125458510099866 ,  2196876913901184316 ,  81743553662934898 ,  1846095245186437871 ,  1572956828975115182 ,  50928967886926128 ,  896166741558700482 ,  308573779765801199 ,  154586807547550383 ,  889607830518160144 ,  302495759345340057 ,  181283580014827866 ,  705347661066299668 ,  840117702593150377 ,  1032010068728847661 ,  1181164515127683754 ,  2136908146866931686 ,  291161539681497161 ,  860331303382698073 ,  2136787294189840308 ,  568250843579661793 ,  904658328766972047 ,  379569614075142588 ,  1771067387243268216 ,  1503310429508451971 ,  603079497367666735 ,  845026979523592358 ,  789730425862028696 ,  181980158282701211 ,  793006000175621801 ,  1924618047348597050 ,  1775237035126146363 ,  1797074463503521703 ,  1773656783956982589 ,  1542449576200724500 ,  818762041873590088 ,  2138613264434096421 ,  98916435188503961 ,  24544516222086257 ,  1385253059607283327 ,  346925329389674115 ,  721788560247272558 ,  793482801146765636 ,  1316853912905263628 ,  1618472022491575943 ,  1829063711456704454 ,  1223995352693452104 ,  986076053771692064 ,  184546328764471004 ,  1740211190817282657 ,  566783267838658863 ,  2062310612243976685 ,  2200063652970312450 ,  362461666902270823 ,  2038487592035347480 ,  958077456277086652 ,  1289846750779711154 ,  725053311032655636 ,  1942863927223225356 ,  1588817512209402292 ,  1171417927667251408 ,  1005535434444275966 ,  1043770320329290679 ,  575519180836274253 ,  1606283365035068212 ,  157680757003567538 ,  1706884215204537255 ,  209366592818873686 ,  9882687130007496 ,  2200235235601462069 ,  980733139248663876 ,  411725301158658603 ,  895542844738626379 ,  209767796664108879 ,  1759003666435894144 ,  646915135438820215 ,  1872786466469264370 ,  370665239294931045 ,  749231371771815013 ,  2167061656659189723 ,  1374326500830639279 ,  158472886686838373 ,  1957471773188824235 ,  897086627631956667 ,  1187691322556155842 ,  1344638989382675480 ,  896475516180834075 ,  738621570507280099 ,  243888213600524072 ,  2149827695192069865 ,  1397475741959639990 ,  2034658607243469338 ,  1458215445759249860 ,  2043570676962608226 ,  876466093023447946 ,  1972308795990840048 ,  136964790629375843 ,  1498325704310495363 ,  1540468674740742218 ,  1242940936815128714 ,  1307186129011499530 ,  1994025322997760901 ,  748494080080858072 ,  963726424883822350 ,  1957559767222118303 ,  1716429434433855350 ,  1645201765653316974 ,  238204291527508812 ,  460629918774853996 ,  1993978963646429347 ,  375646454653159731 ,  739246131630142705 ,  1652685707429136154 ,  1079719674819505332 ,  900305917868507054 ,  282168251760148168 ,  1905683213991001520 ,  259220092624060858 ,  1738822145179781951 ,  1255471777702766488 ,  549368827461306097 ,  1780257618960229954 ,  2114993885253689866 ,  1500796727052259641 ,  1846061318907029804 ,  273191062162576210 ,  14009593433163467 ,  2149958709687506087 ,  1609341571342526616 ,  1168998659845728662 ,  1656451760258211782 ,  2039136752834935149 ,  1229761274688636588 ,  1465822818315746851 ,  1061135507367875797 ,  1231603021273075652 ,  1281493058328914328 ,  158859892600347415 ,  677437914446653819 ,  2208226521748242164 ,  13993639013287283 ,  1959985613868396244 ,  1489902000061233178 ,  2111111215644179860 ,  1349472910505534655 ,  438603365840666105 ,  2286228930109779717 ,  1897436284336779246 ,  1564559307443243690 ,  724347231271332306 ,  299180890460692996 ,  227577741712982618 ,  1185100958234021647 ,  1288966677003642546 ,  1260833529187880425 ,  1410538047884657912 ,  963023714858650189 ,  612513570180841519 ,  1226193568594031330 ,  2256099157304339723 ,  1200753185374946576 ,  616940552949001035 ,  1786304264571620594 ,  1395864422457761855 ,  2157525359178334385 ,  252897370951492110 ,  1387985564459333963 ,  1385217179953454945 ,  1075099082966038422 ,  2026544609848701932 ,  525355557832231537 ,  2123935833199474253 ,  779363581272484612 ,  2297921182218305880 ,  1086427163261024669 ,  1549969684058269509 ,  1107369671324681265 ,  118958067865218816 ,  747199637673008853 ,  127087575593429891 ,  710362170784542044 ,  1702706717886012885 ,  208367207641890099 ,  266465906405803509 ,  2153135573400188146 ,  1220755085041207252 ,  1605851300608888773 ,  235667849945500631 ,  61613458744980821 ,  1528935190183470278 ,  599336976528096570 ,  343031522994603247 ,  2302527042211616619 ,  1352220086920306245 ,  724636070546477267 ,  266178980364473244 ,  1604295592831678456 ,  19990426041628832 ,  1323361073014873553 ,  1094548573380665295 ,  770957255086334707 ,  1001944063809639738 ,  1721690788019013028 ,  1631084833989771393 ,  1785905373418072328 ,  2072946547320448419 ,  2028249598998481582 ,  1650134778010076719 ,  1680663149093074830 ,  1551333188828288648 ,  2169332696794223392 ,  1429200860254863696 ,  770165187934387709 ,  1161926433381424791 ,  1246679296971475339 ,  1609863945380713658 ,  2281434553789156484 ,  187250357298672217 ,  22979571256846476 ,  1395731785310138851 ,  1568790693226663893 ,  1571584301939909246 ,  260948858499473513 ,  379166786789568114 ,  160241101536046205 ,  1947064809496019285 ,  1609795898899733380 ,  209804873056717835 ,  561216185155954253 ,  2271117708926318017 ,  1801450766061700472 ,  2100495308338962590 ,  1539746545402690354 ,  2181104959933564425 ,  1747681407347361903 ,  1274718925091869213 }, // x^2^604

{ 2087789091100945396 ,  1089468133761830439 ,  1879117414766269367 ,  958128092293132587 ,  1502176804226854247 ,  2167109095070758447 ,  542974260467349004 ,  230353712026516483 ,  1299487270721437669 ,  1482875234894904125 ,  18738419900092136 ,  280917894308468118 ,  1332098318169553883 ,  405808383857407330 ,  1923185928758258671 ,  719643364739084843 ,  209499888404929261 ,  277038804242072758 ,  1820515896036631884 ,  2228262670460700371 ,  2192586031356360785 ,  2132909729420111363 ,  1503567309431255294 ,  1014938358091410128 ,  1361113820390453239 ,  2214451895590158383 ,  2143762154951545774 ,  277644411863070171 ,  1370329862556126274 ,  1986020385809258456 ,  1321152922841683243 ,  1596081201857271314 ,  80099773803334453 ,  1552506497055672583 ,  128033078116243026 ,  1306975263879551125 ,  1483192729973648946 ,  74696156475353912 ,  1748625051004900959 ,  1938816313028992318 ,  1900724899967571571 ,  962322280497951630 ,  791646463569362759 ,  1555494987751659748 ,  41996322400114985 ,  1971704236289239826 ,  508302665946664276 ,  870234693105650626 ,  587813769586513107 ,  1632890082666087977 ,  263145295919585960 ,  1109127309210778042 ,  493959536292157555 ,  1012368920100163851 ,  881208344384912163 ,  1649784136001065596 ,  888753464879465749 ,  301857164963205409 ,  928601171565063691 ,  942119451100552126 ,  1154700066067273809 ,  1640086768883803868 ,  324746570501976963 ,  711426088099198445 ,  540147448330489428 ,  290491417011741688 ,  2211153383110534785 ,  2236779609080580082 ,  1959963033753619707 ,  1487357923143860277 ,  536690544489372727 ,  190767290190943776 ,  1209355033999823047 ,  1092014181279827204 ,  84607489314745354 ,  197146010524204818 ,  1414449371367733040 ,  317160094259744309 ,  2036816155469138370 ,  1427808288020031256 ,  1262353085731720515 ,  1931053279836144882 ,  119344957032006291 ,  1235600653603312498 ,  769598187357727876 ,  840083898051225430 ,  1216460585689891361 ,  1504975812001680556 ,  1429669120860895580 ,  933621452998456419 ,  1613458578027712537 ,  255886852254485995 ,  2272995082101307115 ,  445746894926280395 ,  1049409272875310893 ,  2148873122932995367 ,  166830160929426664 ,  297380109294155010 ,  1533384795121278855 ,  1783386410750282570 ,  1970131919312499636 ,  1886064725875249296 ,  532850666835540117 ,  2157750114808486377 ,  481887514687427747 ,  358110312969827853 ,  248708289270054677 ,  321137649328308051 ,  708216677244208921 ,  293667018078156141 ,  1582303494422611407 ,  1559683438690519606 ,  2084331862120591125 ,  1670766100744329603 ,  1314331166894856645 ,  756973464541442115 ,  13837927695792061 ,  2274642760012300179 ,  1483527433527024759 ,  2079674048583857032 ,  1961003814412008808 ,  850007703677069458 ,  1985959011850860200 ,  109936985099596148 ,  713277007945726321 ,  2202587017322338018 ,  1438471256400693192 ,  2028259929331662515 ,  192761215833824371 ,  664997525672366654 ,  869199058427351070 ,  2057667893899929554 ,  1060274134717744616 ,  1037261114925505408 ,  1921202770750627285 ,  1773858646303791294 ,  504784075956008814 ,  596371742549965488 ,  235313937950232965 ,  981453246786385619 ,  955651224064640097 ,  118494962207730418 ,  210021195154484741 ,  1576174352253872621 ,  1035409680509716623 ,  701948742896356564 ,  1895659069251064307 ,  1594057628373193241 ,  654161007103337588 ,  356970441912270982 ,  20391354254307823 ,  332588602072694545 ,  91594159185810156 ,  417438563572438153 ,  88000769295647186 ,  1249675037580566999 ,  717868169907882868 ,  910034358760655879 ,  1484352200366752300 ,  2232388950038333079 ,  718002164239982281 ,  1277880513958936700 ,  1520455581184751660 ,  14525052225162292 ,  1006323882153801330 ,  551867282350620221 ,  1107249551270911710 ,  2159161691806997110 ,  1672407220496906759 ,  219740386006845646 ,  1872177343630477950 ,  1237962049398920466 ,  1025771069556906468 ,  1117546757599548890 ,  1918068966923010295 ,  340843595125046069 ,  945845347018220349 ,  2006036139394553223 ,  457914669645859000 ,  775474964710690616 ,  1415062590595385274 ,  1775967132172947387 ,  1568817441786969370 ,  1345422032690640673 ,  183750730498269499 ,  1899526069515188909 ,  795244875218260631 ,  1888312001694635392 ,  2189342813413575820 ,  1403312306592089577 ,  1799312148628752124 ,  1807967986990407094 ,  1508616387742898604 ,  1604707742407851489 ,  28996950971063992 ,  2223202766821402886 ,  2208557918529611092 ,  980549689312663666 ,  602319419475171314 ,  885989053354375274 ,  366207161812836071 ,  1407657738767386255 ,  87223738038669495 ,  1151124740420848812 ,  1711838895171050002 ,  354909258942463598 ,  2272319124791191391 ,  1958442088382215170 ,  1094753958045339685 ,  2044937821287682905 ,  1665626176743990777 ,  1546441946297553598 ,  664251033188149767 ,  2101315818161067603 ,  1020315909592240124 ,  737733835563293177 ,  1083442791584163919 ,  721096204752005828 ,  2049205728253521545 ,  712689863921525592 ,  362003061777513937 ,  1796495508258599605 ,  1264518938435308487 ,  2077416664832209240 ,  1439502724966922042 ,  1739457913385898496 ,  1259647546246149310 ,  1015319095064347083 ,  2272917399599254920 ,  2012790334959867884 ,  130969842559326001 ,  821008018353979115 ,  1073585680228846843 ,  1343999260930523228 ,  307288649332069991 ,  2020605326599166986 ,  1953335516420134328 ,  1667192089498290531 ,  991840381294403855 ,  1635254338171005629 }, // x^2^605

{ 1805116468398202356 ,  1403545153823592064 ,  2068210756686001168 ,  1993947423255992639 ,  1992495380245355096 ,  851854603161811807 ,  2169998362182827874 ,  66399420948370904 ,  23208305259867841 ,  1906838225980347139 ,  712783428014832477 ,  939291637415678140 ,  1141470646668544250 ,  1356661527282770142 ,  534471961174618519 ,  1239190611604282310 ,  764572719377484532 ,  928445813706779851 ,  869954208837685999 ,  2003340766135738552 ,  357078664839927273 ,  1554150157762172173 ,  1608599697887758045 ,  2112482554631276232 ,  1265162733658419737 ,  1825055184585872130 ,  114302904684898861 ,  1767032896240815442 ,  1576928113811643659 ,  536653620996449198 ,  2242934392973985180 ,  101748055925559336 ,  1513695625860973368 ,  1836641667448599712 ,  241685071580513233 ,  970499917102594615 ,  1301672048276028842 ,  47433355539109898 ,  1130403280867714553 ,  1276977350413533599 ,  1628278602292124719 ,  1236984822597965979 ,  1386050745890953922 ,  81018582611480622 ,  1715033439844491699 ,  1178259255453276248 ,  1168335829010169859 ,  1898423582537057745 ,  1604886966245067025 ,  248934406235913268 ,  1098943482901457768 ,  427525732971522970 ,  41605830516823296 ,  1679973330833544136 ,  1975675339271115811 ,  1577546584781969142 ,  710109112238828670 ,  2271287630863264857 ,  137284363080257069 ,  590477801185578725 ,  849742472948835214 ,  1742092038936315793 ,  1048182410404593690 ,  453229548217812626 ,  2132750113729673082 ,  1598706052229347579 ,  1884905259727490206 ,  1328352653540291330 ,  1094618482469107737 ,  1761293917407321482 ,  704517112724965417 ,  1435574040981524225 ,  1672683219903918400 ,  910130289763376924 ,  1003441972146637433 ,  299436936926198260 ,  2296756810093964779 ,  2107303966532206368 ,  1443801359142284644 ,  2209659812123449369 ,  2045841328833835917 ,  1268588857692744778 ,  460708973505879600 ,  323264436365730601 ,  1755814560450035773 ,  2255893487552723301 ,  1489190125914192029 ,  1917051750299860653 ,  995204082611307585 ,  327274867487439501 ,  543668080313967105 ,  2092588844736734934 ,  1639089351416777412 ,  531576672290801648 ,  2027921756978697722 ,  1366653629372129049 ,  2117987813260671770 ,  1966587866572744905 ,  405909200514902494 ,  23250398926997025 ,  293849947159410283 ,  1201037209367075382 ,  295747278854470020 ,  901229835029980261 ,  773256719469531438 ,  1127259464699404357 ,  1979550336273732715 ,  644428740811899200 ,  93123980191663781 ,  1062702544423535810 ,  2302449690212816983 ,  1186542540102129773 ,  1045091223723371083 ,  1086213843754487944 ,  1867511895181968546 ,  2159468101324058061 ,  531491140259979799 ,  361488855934863954 ,  2161896167857911767 ,  777032004767274532 ,  438594913625367942 ,  993924965157532911 ,  26250977445574483 ,  1424678639283922452 ,  1569448383501309703 ,  949705667989565669 ,  292609056817318740 ,  1418960970295099315 ,  1291205107110887138 ,  57418318769593119 ,  1509452389005038116 ,  338016719658007558 ,  2223002370482807665 ,  201686427503596229 ,  287140658868536555 ,  1888322132913630502 ,  2239814087850010496 ,  1558150671888360190 ,  564399852801013568 ,  142905909611789248 ,  1186170775860726550 ,  535480235225346491 ,  1330988088586157514 ,  2002027807220701157 ,  523081960221438553 ,  1333848458397914604 ,  1838209194555961133 ,  216687546366044561 ,  701268296265116945 ,  576258426564873056 ,  913866495434627256 ,  1855366009648452350 ,  1355058543577443451 ,  872026837817478621 ,  1740633206862425062 ,  1083154068768244246 ,  1469399922805837744 ,  1719637175033300121 ,  1441673018781003758 ,  1702571113476088075 ,  1789789169820893929 ,  319830396891311436 ,  1107732762465684561 ,  2247776590972247956 ,  1597149684434939107 ,  1934421540571689496 ,  323114329970901061 ,  590900186584556130 ,  1323923160025331353 ,  1202175118787353921 ,  427105796857340337 ,  785323684637045682 ,  2107930721491578439 ,  130929668716556051 ,  1019190809466626962 ,  133023393673252354 ,  1456741059312597008 ,  989163042795540775 ,  476702603039439090 ,  234911495532339051 ,  1279156697321768124 ,  1233305201166207667 ,  1136576043315179199 ,  2118840158773885007 ,  338068144144816324 ,  966892490078383019 ,  376498006232245696 ,  258741956666573341 ,  2302110538267093828 ,  2131736838653339331 ,  1321692804857960080 ,  951622773065845846 ,  1764287305620540141 ,  1743286734377006046 ,  2203317893249191335 ,  1128877434685718379 ,  1100604172480664161 ,  841070934885122790 ,  2043638970920217394 ,  481076697861365373 ,  1913002947496289922 ,  2172020104300187853 ,  485241298077643138 ,  1509048437517913746 ,  627685352546185915 ,  199394450827275234 ,  1724769752777546730 ,  888333328827513353 ,  1544511047842178523 ,  1302463829993776126 ,  2113638013696694974 ,  59878856482266013 ,  1587818791015376801 ,  1038655402609789335 ,  1894601756799230166 ,  347812831299757898 ,  1258801166976422792 ,  1151597763617496497 ,  1062088299201099709 ,  753874749028091917 ,  2254094533931450677 ,  718879898856712004 ,  629385914143836066 ,  65035739694539117 ,  28246463097982335 ,  1021620184545094968 ,  1006652437324080992 ,  1650508796861737407 ,  1006300153808807284 ,  1345139801065509625 ,  954870406050334626 ,  966876359233459528 ,  1154889757953020663 ,  439920402101224051 ,  1100235822241603788 ,  798366961432087126 ,  471961807700356762 ,  552414562415499065 ,  550453291012566044 ,  1858122050772552159 }, // x^2^606

{ 2261491717681751648 ,  649626425205846990 ,  1432905035242668048 ,  1927455052460228294 ,  30984028735188538 ,  1930340339248279866 ,  866810722655320205 ,  962701595280063274 ,  1001431367195795052 ,  465730982185518870 ,  270109229238186906 ,  2298506686171110629 ,  139559279725211455 ,  1999765243110670366 ,  1934731331748232415 ,  1436910426325748486 ,  1759383624505112212 ,  2291585831561140838 ,  901128641883952414 ,  2296390358514800066 ,  1813721010007857473 ,  587694716433498614 ,  2046887642193516651 ,  940150719789864776 ,  477382473323006915 ,  513651349378727033 ,  573561455244486012 ,  2187612192691471907 ,  261781330099949190 ,  1879537847065032184 ,  2067879291539216977 ,  185911530608440878 ,  1513931614725823148 ,  831594325819621945 ,  1857452227001119658 ,  1479489086622663735 ,  60064645244645242 ,  1995941599448750304 ,  2108244832565197063 ,  1116636394942657124 ,  1980671144672490015 ,  1347652260552427874 ,  1755893846140210748 ,  572033041721877752 ,  1616405210239649850 ,  816016362114058744 ,  1858417250256857130 ,  1091316414770748359 ,  197596502900015745 ,  867687702751926184 ,  1256313235112663154 ,  945907077219538531 ,  1608270130620529514 ,  5050685364276652 ,  805061956533991959 ,  465540615374640765 ,  801753280234636065 ,  1458105353659723320 ,  473094614687528955 ,  1400103847517896729 ,  1252261468033411878 ,  1625359579745258903 ,  2300075729064476778 ,  754813150452908012 ,  918989075052374271 ,  1231129926573691897 ,  1386989450306325663 ,  548536062302250533 ,  266091982137583022 ,  1766885801599846889 ,  1159966961964847528 ,  354000293009680534 ,  813389364490317832 ,  1244397438279028204 ,  474810879664069506 ,  2277798609614913578 ,  614329729479026509 ,  966948299011389963 ,  1189555763625575345 ,  1444960447724513473 ,  2268547178848851762 ,  1046531628049294548 ,  1265764928979033145 ,  71436245956471564 ,  1542554107688759836 ,  262966367799362448 ,  232543165215841034 ,  774087538315736634 ,  152544849568064560 ,  273729793673977713 ,  1332414251965933041 ,  1060446773383983545 ,  794616029186450274 ,  1267896137384473577 ,  1820032417493002195 ,  494966252722808424 ,  615548277953814555 ,  446200230839938804 ,  83735604463900020 ,  208014004208217445 ,  1050592980740466632 ,  993169128081570731 ,  797421462278475628 ,  1239367820219147953 ,  1806775696410914491 ,  379785871281470807 ,  1595926091534714760 ,  121864371382924979 ,  557630686811198421 ,  1738882461850659012 ,  2203882590547023081 ,  443618027005245438 ,  926830230760824926 ,  1254039941060345576 ,  1890565946582263470 ,  1919881464323926608 ,  831756762737112305 ,  282729537489051933 ,  1008910713159800985 ,  567044459295111119 ,  52741192320083769 ,  1915515229098336180 ,  1872125492887196478 ,  170914794704719955 ,  2275293205552441865 ,  2136138375152335345 ,  2050802785722867202 ,  1493225652254291540 ,  418641874895363017 ,  601623718876973915 ,  208707807893048411 ,  2201145492497747600 ,  373333750075212810 ,  1458943575784563525 ,  1048433375173802430 ,  1500864812207652059 ,  1649828794653105018 ,  1745460363466577879 ,  1764384744686281053 ,  21167374779526192 ,  758458361676839435 ,  847794317917170506 ,  626862601333336257 ,  1557271489791360980 ,  1207279690332023952 ,  1619747191039413624 ,  204580292257562331 ,  282229014874508851 ,  1185826875446572530 ,  1887836179875155790 ,  1320308354605815281 ,  1223718888109086154 ,  779311717544423111 ,  335591624473271905 ,  58333149977465560 ,  1206348676634702054 ,  601849724723066521 ,  767750237568469189 ,  1954278817636463672 ,  2285158210963519959 ,  1243110307405183432 ,  1662204271294602441 ,  670859688954867432 ,  1683754028072589485 ,  1016696242682677131 ,  1450100556453498669 ,  231378794360183882 ,  1451984555781561021 ,  1142172875685110879 ,  1012006784244522720 ,  188375457806257096 ,  235431995692012840 ,  398396519375105986 ,  1043018695768513332 ,  2052516898019632916 ,  1365310315305362734 ,  130334050513932537 ,  785267279731979543 ,  2023563710608726594 ,  265987737737731946 ,  347577175905639131 ,  403221985201043266 ,  192086648305993888 ,  806725885451779272 ,  44622725795424790 ,  589326612162936954 ,  987350294044179713 ,  1942720943099365399 ,  56744532768715627 ,  1505931419334029901 ,  1734461221703974827 ,  2156832143197865446 ,  1081951362210935230 ,  1136365375211549642 ,  153153535622673467 ,  1161179386452212861 ,  1106510120219524287 ,  1838464521534111895 ,  694369184499320625 ,  887681035988002900 ,  629159150342534896 ,  647221543565026651 ,  2202625740725596989 ,  554808405520457256 ,  654591728694585968 ,  237845259389597453 ,  1221908154589720558 ,  504899638643814780 ,  569087234134202744 ,  2251634957799736137 ,  449166324511239974 ,  1359667872189996505 ,  1011657331040954963 ,  1488009762041417810 ,  566846150153211400 ,  82053319170685877 ,  2179705200473358229 ,  292588867263587945 ,  588177304323074542 ,  92738389664551501 ,  1305093169145190294 ,  1843483643876307421 ,  1994403110714151292 ,  78231724576093328 ,  264180796883600197 ,  577035670871506261 ,  1601379996207439768 ,  987368106167109565 ,  1081852260681779686 ,  803904872499757649 ,  1005291803001093514 ,  1706741098706850060 ,  1757639207368234893 ,  360424515745126414 ,  405632293099055970 ,  799700429997317227 ,  1360930888988143720 ,  1917703479818879467 ,  589870951768328043 ,  855189918151400798 }, // x^2^607

{ 257485522246879951 ,  2278135322156550472 ,  1506821152464287187 ,  2151652030244167449 ,  531110952496394333 ,  1377757052212379651 ,  528918556576959625 ,  2189436139352940618 ,  542655741165201018 ,  493538446325121023 ,  1297705098841612751 ,  1489194234958559533 ,  616224949765496963 ,  755972616089061781 ,  2232836978187547520 ,  2048640438923832751 ,  1687144245815339183 ,  338433237553267389 ,  1966633499348506464 ,  974953930675061095 ,  307868892582108886 ,  1013993332192999648 ,  944602759192041851 ,  1753357415204233965 ,  1372487661778406608 ,  1217796942834705955 ,  2015057090920627869 ,  615856735033973444 ,  2237945593098819098 ,  1881094847947563843 ,  1454644551323909544 ,  858977364836598156 ,  420976264395631003 ,  2082355290539450651 ,  795142866838208282 ,  282970966103454910 ,  1227464585657098217 ,  938385084886482879 ,  687684355690779294 ,  1190622275298233896 ,  427901340540180517 ,  499834920782876650 ,  1250874546648094163 ,  586197302545861287 ,  1808223511150637429 ,  2164455724394003289 ,  1544384663695023950 ,  913827106669225118 ,  388649221236802407 ,  493005221848273064 ,  717943320596216540 ,  907308442944132944 ,  1007685923831514920 ,  158293342875313378 ,  463731030600333647 ,  1383139955946566422 ,  649310089515186198 ,  1025436750244406796 ,  928763745206679174 ,  1220834520296430178 ,  1743770380334892122 ,  68090285747118971 ,  2110077219253303454 ,  392307181687377206 ,  647575388517728985 ,  1845289268053666331 ,  860612815908527459 ,  1884758450010815570 ,  1592257040313927146 ,  367260040425879295 ,  500994367814779848 ,  1606708253046832455 ,  2049571286006761221 ,  2047598800204150652 ,  1566428109834905235 ,  332556194340924346 ,  1453738487583025935 ,  93624468774085864 ,  1971712488360387532 ,  809968732093334979 ,  1921483688054467187 ,  1888115817757661436 ,  51740468759899629 ,  276684875689734083 ,  1927126637134258447 ,  674653788079559944 ,  1706595667147221837 ,  2022701420369915087 ,  317151540410197100 ,  1395627672060654645 ,  591980051480250535 ,  260727613149641654 ,  2268097513816571777 ,  172892374709786964 ,  862383293138954900 ,  451020690094552045 ,  710114220503435011 ,  1068250629829998912 ,  1807475095304333905 ,  1529658474769266521 ,  1197669708507377054 ,  478690265781083903 ,  1928946090427439625 ,  1368117979826569906 ,  339891341329342022 ,  402351941711815911 ,  2024580545948850271 ,  1659886983543567035 ,  1773317590724084730 ,  2011587335213399532 ,  563975757532846754 ,  1034239615071117826 ,  1459427789254314945 ,  503150845691126682 ,  1888155509555175323 ,  686045229580663972 ,  414386273375744855 ,  1939118339196264978 ,  89464380072865221 ,  1035588825990488616 ,  1280974257475383048 ,  386675267555061547 ,  1726854244363992847 ,  273608268748676702 ,  1154274498302338758 ,  1951238833020129910 ,  229010532862313011 ,  1198738952290224730 ,  1133091960193589566 ,  1304709460153411303 ,  2215065164088784682 ,  357316684865681263 ,  2052388922696499836 ,  347358842697771948 ,  731700855873542939 ,  905434594756942428 ,  67048372108011776 ,  87713117785085938 ,  797038105524628469 ,  475273543579400799 ,  543511100194540604 ,  1564212686002370258 ,  2060640682316245246 ,  1788394776040018433 ,  723089720192989845 ,  551402327137751243 ,  1291219901168152488 ,  2650829831219706 ,  890705149814871439 ,  1331004621495578572 ,  1279409804211656603 ,  519857606364919554 ,  342447192477266770 ,  791114650247411866 ,  729288334196990228 ,  384144519666111938 ,  354855922159453596 ,  2242755658528140442 ,  1406098322800494072 ,  1913845090376584772 ,  1611470679455249989 ,  2241866645488915475 ,  446279847195748695 ,  843751409454277661 ,  1778516270832511204 ,  1442759962392584408 ,  1654006536873269432 ,  342430387969223283 ,  271914025820889714 ,  888348149315278445 ,  798586779558302559 ,  1677622116048655388 ,  976007694392241553 ,  1985071697079745041 ,  2248379066901190824 ,  1173299600794573795 ,  555157661750563459 ,  2241974723180355596 ,  2296794438970163797 ,  1382696265677025469 ,  395668598931004666 ,  164173898915868276 ,  1081976691075384309 ,  1324220926030739000 ,  1071779282817043672 ,  517729843588744587 ,  1035401183890292726 ,  429608143615298093 ,  827506202329419919 ,  2201189475383681579 ,  702134573536102344 ,  1289012588723339396 ,  913500316483228495 ,  711704368793839808 ,  330520919343448987 ,  1283662526753492215 ,  1194977117767376427 ,  111505971145246606 ,  203908429662833308 ,  858294194599070695 ,  1853834993477096712 ,  2238066956093368818 ,  1205350752337723036 ,  1631832481038425312 ,  1947750861411667590 ,  2029981665200833239 ,  831284768404143101 ,  339086921987327265 ,  990846394342852398 ,  542141788696982751 ,  1271164781274518185 ,  1973700542807547458 ,  212235441042484558 ,  946434248154284394 ,  172852140700318572 ,  499297699215249060 ,  2255959231474561332 ,  1109253736483334281 ,  672351364215670399 ,  781859996952228948 ,  1706226451221531207 ,  1268200801911099170 ,  598044106208058828 ,  475985280339485460 ,  1097526216470032859 ,  1190036618608915707 ,  1305994047156667510 ,  872475585691037414 ,  945118934412854673 ,  199657985491331864 ,  2015803515105897673 ,  505743820020175847 ,  750282580798346244 ,  1301800399260161064 ,  1681485275627427643 ,  930039521847119352 ,  427174347122394303 ,  593555840125041017 ,  1634443239882774456 ,  1531343287779430993 }, // x^2^608

{ 1654397590176439478 ,  1606520786427343471 ,  645614972250729486 ,  2271247372276635812 ,  1935616925846375069 ,  832342573737637555 ,  577533120184876069 ,  1108700115284616127 ,  738736231798154708 ,  1778375896008096141 ,  755640816796250980 ,  1458027612756127025 ,  2012122355863371505 ,  2050564851173710860 ,  1204272457504755774 ,  1504047789207968159 ,  59723960812690104 ,  2203043482694341035 ,  1171333672887879645 ,  1198786117079120423 ,  1562890778877365325 ,  1308178237518539495 ,  225986380240584535 ,  2257164404471645062 ,  652224501364256896 ,  902686233401246188 ,  1587813505662418631 ,  805480209103326680 ,  208469992385215851 ,  2162975286827229875 ,  1944488181965621724 ,  364806016476299433 ,  319212814821194098 ,  985281969308352629 ,  1943642548604830171 ,  1113448314039066645 ,  787699132207324828 ,  468342152439161815 ,  1290535714186997115 ,  34873162202555587 ,  1776639487238851725 ,  211231050552522177 ,  2142264104725641433 ,  52560663340965426 ,  299585131692336362 ,  901515390952923890 ,  582031288013624036 ,  843838754496142850 ,  68692792381514022 ,  2272195691096955187 ,  639618973002979390 ,  1066360541253168821 ,  465068216309081330 ,  1262460056020890550 ,  1019169763387346093 ,  2226649003330300495 ,  796649796468107276 ,  1359899753786309707 ,  2041555565019278173 ,  1813934177968150290 ,  38105735481366642 ,  1895209586314616130 ,  1797162289793139226 ,  90377243746797702 ,  702592403402755629 ,  1733253405258134017 ,  1925669190352398725 ,  450407443212886000 ,  1603294179294347109 ,  2046724103069244068 ,  1838939592849069410 ,  367114505051847879 ,  1017299561819667190 ,  1999273857859785333 ,  865959576013873069 ,  1176672687151353324 ,  1747089639284731217 ,  351579874138983414 ,  1813929184574907770 ,  643551206931109253 ,  916442521371816646 ,  1954923138233924968 ,  1749840452504548487 ,  1985310497709015060 ,  714704804816949750 ,  1172101589969798821 ,  2006530116003054178 ,  438946423183580417 ,  806600037054305545 ,  2217142287720510928 ,  1585849304223006609 ,  495685663805558255 ,  1550671288740459208 ,  1998520382719095092 ,  150594366363164498 ,  513002012836066946 ,  377930109775832200 ,  836351354688958864 ,  2099075368141894788 ,  2061114222209692903 ,  2086669299549577534 ,  1973038821617759335 ,  189769272050075459 ,  413589807345749090 ,  608434397957795433 ,  315042611867676977 ,  2138359909520888040 ,  1433564629404956585 ,  1924653573801402534 ,  1746880492192620060 ,  1545980330445082472 ,  1059279424261433997 ,  1660436800956049995 ,  528828782339595724 ,  1153625539101941285 ,  74750793196815849 ,  2242400855776280943 ,  226800940703519953 ,  2227774758127739586 ,  2238997648204628830 ,  1283865508149926321 ,  177345718565068089 ,  39922089948513078 ,  1747437475249831541 ,  450171023533260629 ,  2175163095931232690 ,  718266219688648327 ,  1981555482317294943 ,  1907764429596797708 ,  710018104262032392 ,  1814549434842582778 ,  644649216666983439 ,  1227426560305438609 ,  537787228917877254 ,  136939772255707207 ,  299790618600776480 ,  1035894756362823457 ,  1187976512953203987 ,  218856391684754720 ,  1853896134469646637 ,  927557909176315956 ,  1177614997881483525 ,  195622251167950232 ,  1278070318843829476 ,  755223140267849524 ,  745923539302012632 ,  1256962924838799995 ,  529186894753970444 ,  1739792581743066058 ,  466914599949609519 ,  2236980659928565882 ,  2067795326318106661 ,  1254340435626212990 ,  767688430336899564 ,  1226853185044850396 ,  1640610335682855053 ,  532784949922212060 ,  1054984338420827697 ,  1123373333409991465 ,  1568378439670922730 ,  7538049369524850 ,  1494761616003942522 ,  1610707645392734206 ,  1245541462319542822 ,  688794881170340939 ,  1692279367953805861 ,  1827746991094187789 ,  1324738906216233255 ,  261769972954567720 ,  1309928206373849304 ,  1593709005072868988 ,  598818446235449141 ,  2069789804233182353 ,  1213598586227329553 ,  1681496097291176942 ,  34613554977753183 ,  1055653714381300335 ,  518095883580292613 ,  2095982691268766386 ,  991383744641376231 ,  1382560293493344821 ,  2066506589054224876 ,  1775365516408962623 ,  1849902218163868567 ,  1728432381404281336 ,  1005943189322323510 ,  800111549115983112 ,  1148410935260364214 ,  1971265449909533181 ,  2258168146657555546 ,  1952024111201354218 ,  1087076835521393491 ,  1416568175850825891 ,  1356081027860086547 ,  156914384911185145 ,  433254207451505412 ,  1424698657290864208 ,  877168542587587166 ,  1039175205384811555 ,  1655162742746524009 ,  634343444143124220 ,  412213065253208348 ,  1406017577451008720 ,  1972357177269886934 ,  1458284831998954715 ,  541710919403793051 ,  753362640603317949 ,  924438638033989742 ,  763864039732235143 ,  636659184238884277 ,  223929276424563268 ,  1724595949460952477 ,  2179258974557602969 ,  145122358775555169 ,  1043402789674826205 ,  425606150737296244 ,  11226990994061580 ,  151305094748046937 ,  208048097687193693 ,  1530137932573558515 ,  401501689612169573 ,  2172498966121167474 ,  360400920958790596 ,  423313430020278966 ,  1104530466145210325 ,  69929763905517365 ,  718506939609955643 ,  427523541855426731 ,  1991179454045729330 ,  972008789429258317 ,  430329690136800820 ,  1961404359648193200 ,  1417198735104363370 ,  1469844207440308872 ,  475490103756200243 ,  113261241061557819 ,  1814789354982400918 ,  230480619830457874 ,  617321941916107302 ,  427614444059670465 }, // x^2^609

{ 537914051596091085 ,  2101864251151746564 ,  1720178254555843791 ,  961676544777116585 ,  1942114250750334768 ,  705520030048776026 ,  446350841474139827 ,  1969613793511381992 ,  1262630217997123742 ,  206429791111373509 ,  1931466590854049193 ,  66462658854370882 ,  2271508279436332297 ,  305983900180787330 ,  1966886717391202388 ,  1969792591121478292 ,  385403606481991756 ,  1839123182019247967 ,  769799299943470547 ,  920952423749134911 ,  2072048563824442102 ,  820943320997506741 ,  2018685507879834019 ,  374001821674445968 ,  584764810755690958 ,  840460137035780960 ,  1381899549275946365 ,  687025000640742727 ,  1454320408766257001 ,  787323028649667939 ,  976209682249825021 ,  1301601880852212584 ,  2039034367553954803 ,  1737686486861181138 ,  804857718633492745 ,  416698682063510292 ,  304457297999065287 ,  8460458683184722 ,  1238935034505354705 ,  1033137018934729354 ,  2032392762215727123 ,  436455990701108362 ,  1793918475509211844 ,  857428101956667631 ,  558735384249898728 ,  2187255676757868669 ,  1146017428856909544 ,  1301847460816074348 ,  1025105244033580334 ,  788227121105372053 ,  1569168326662680368 ,  1033461897616568543 ,  2013298063333047275 ,  1010670930253854481 ,  827266299493936420 ,  617854551607362930 ,  500647243000005327 ,  2106869611701663 ,  327341963110770868 ,  2217443953220511124 ,  1185987052166280020 ,  711227255894974218 ,  815955304651185838 ,  2232705558979637670 ,  1929978028250884076 ,  190343612891365211 ,  1021849396770799506 ,  1526677828951044975 ,  100332308107906878 ,  948213804762634910 ,  2215134471623995694 ,  1383861089831350908 ,  1334408747091487823 ,  1325746004788757086 ,  250457917099691385 ,  86601001932578647 ,  1028574969285181758 ,  1425973352629019577 ,  107043659798312362 ,  2292847342670054875 ,  1926831598240955757 ,  1357676652291016311 ,  507136191256878897 ,  1434139715506118654 ,  2274627695549714307 ,  1990166575653289313 ,  220710716138281571 ,  1959857737963231567 ,  1750741358093455429 ,  2229718410704343190 ,  281060391980977523 ,  742886984068708640 ,  2217950895598616368 ,  524349039580080955 ,  363072035921293157 ,  1842297644625887852 ,  1269402526164715335 ,  868538914687108319 ,  1936160941456238148 ,  2041892533331810307 ,  2002395048979913274 ,  340502719213492049 ,  1667581827771283037 ,  1784040361668293616 ,  162508580322890936 ,  27692813753234903 ,  217941348060413581 ,  1395391746027194077 ,  1756944835725311752 ,  1120339023303227244 ,  2225574340362472245 ,  1036112162128760548 ,  1113729854536276101 ,  1004366969720398174 ,  181854233918734954 ,  2243600354285810136 ,  306305685080343460 ,  648595063751904576 ,  1734478291148777151 ,  725967122214603921 ,  11363140258773582 ,  84081198256461082 ,  1520468593237368292 ,  718591490693140044 ,  2189197399693230348 ,  1695423102212819992 ,  715846104292959363 ,  200260047928144826 ,  1146107965274853311 ,  84566454106038817 ,  1409492502867676974 ,  2112640829042847578 ,  1791495274604997379 ,  769524676410648198 ,  722095633220748898 ,  2265987370464856722 ,  327747272328184396 ,  746237952490767095 ,  1014535554732940028 ,  434963647540013453 ,  1395479617046714683 ,  1495546093944085997 ,  317762042664004000 ,  45067528904310849 ,  984398685005558775 ,  2036788749510915246 ,  2210640930632250459 ,  1712085445040237441 ,  145962240165539791 ,  312074153989733362 ,  1389181519927170339 ,  700810823283829076 ,  2187954926140409649 ,  1415270824000066447 ,  355995130172179206 ,  1003237263323692006 ,  204395202463440583 ,  1909405313647122437 ,  399823791159340164 ,  775310941429614357 ,  449045932812968269 ,  917525166034385228 ,  346785699878301311 ,  60009423742899579 ,  867042384245813488 ,  2119851764413136810 ,  782258392155492562 ,  1002390786367865910 ,  1673821197928899308 ,  2161004334771563107 ,  1501624021919134329 ,  1841775684215404417 ,  13867492117939494 ,  268927714455566019 ,  1075997925434322380 ,  1593143966146292587 ,  385124358660016787 ,  2262078885626818344 ,  959797481837714083 ,  559229946196301280 ,  896911891061988163 ,  63201655235665133 ,  615338172914763443 ,  1988061887282975605 ,  1744329742955253257 ,  1451704403172485693 ,  286623558963492804 ,  147558180515891517 ,  1292346082802568878 ,  1699404295372349710 ,  1069075265585555983 ,  1298618916236689301 ,  45322308886698332 ,  1179085642335641289 ,  279891691932714666 ,  1174858754528883891 ,  158412957410617124 ,  1670719451854194264 ,  1629482979762940017 ,  1808475189194872247 ,  333761626224204210 ,  516412152248546374 ,  1505174186841074530 ,  1188763116326270701 ,  1059875215815973634 ,  1458972053832353599 ,  826722728269504954 ,  1874378618013922229 ,  2052212202576361682 ,  213639515990556525 ,  1130491590597116657 ,  2073575494348614253 ,  1951154486275687005 ,  117103112704418896 ,  729988788345566835 ,  2250911813033412869 ,  1928117871560754277 ,  1536012237339576562 ,  169694540108443396 ,  309471984649224854 ,  1576979267566257545 ,  2024850274960649966 ,  1397510487431961283 ,  2162146052464067976 ,  1806771427429969420 ,  1579075943986299301 ,  489996274123979373 ,  414314200355271132 ,  1518586280368955847 ,  2102509722568342627 ,  634938439721809313 ,  629914438202344141 ,  1787426439438022617 ,  163038003226854957 ,  2074249324970741281 ,  1427849734376210033 ,  243691357309089505 ,  1404079136141934341 ,  1140726564674838440 ,  1330522551503031147 }, // x^2^610

{ 2140826324480318559 ,  2078388480826751507 ,  1031102742652928675 ,  1386286111894174750 ,  471623031639294139 ,  835619444910194565 ,  612371915699285970 ,  1889282638476298640 ,  229027426830007503 ,  1549568171527145719 ,  666995031892582006 ,  1563952640382363558 ,  1207452264361792620 ,  263002700204814206 ,  2054511124001012252 ,  1390781852091908273 ,  1718580545654073599 ,  1143491825414307673 ,  1771132101040965316 ,  183011144637556923 ,  602010469698339957 ,  537353168961416050 ,  1654198558447892952 ,  170387989601092732 ,  1924703625900106168 ,  2188364961940629087 ,  1789840323077101443 ,  2199071894553694651 ,  7929637171818013 ,  2024197646502073067 ,  2254046032330407437 ,  468075731081434140 ,  365649994305447195 ,  626033380691270016 ,  920641573227151214 ,  1701145503530819615 ,  1724470007383934391 ,  2139891164656093034 ,  1773514575086461368 ,  662619642984221256 ,  1796275606135615645 ,  1339299398841258210 ,  252488219870543200 ,  1295002059005802940 ,  2059784764447428036 ,  776129656577820282 ,  822164735025148909 ,  1626778968397065995 ,  1384929590080784065 ,  436629724764945044 ,  467158922902276313 ,  315577448616632609 ,  580667156830100151 ,  1368539928405777516 ,  1684405575808456416 ,  2031144425701233160 ,  2139352488050727584 ,  703040951529572892 ,  1200232389444216488 ,  1712210785979328227 ,  725749360943827853 ,  1616220980653372360 ,  1652740535956089970 ,  1587259072824493425 ,  512561157043440780 ,  1042696143723408863 ,  1189901128090487990 ,  1786618568331996948 ,  1189634909379897788 ,  1914233296806115867 ,  737494103157306420 ,  797822254256434107 ,  297115959267517258 ,  876959081683441777 ,  1169917737937274443 ,  1863166614226261263 ,  959442756195009999 ,  2010607364963056686 ,  2172750160910386840 ,  832252744450450291 ,  101661073622169754 ,  2276465539436979239 ,  2214662113140407126 ,  1631634887069651730 ,  1599120578896816203 ,  309761898425818709 ,  889285571364664540 ,  817299501910623246 ,  912135514527154408 ,  2217216543730130011 ,  776704793887177384 ,  1892594011659589511 ,  19057398755036506 ,  125894154628816520 ,  2065434990900952642 ,  937840526701461167 ,  1996092640255113274 ,  788067160960242002 ,  63307165487324504 ,  1466122740662989358 ,  1995831369213354930 ,  1729007852682372816 ,  1747202917407339351 ,  1878265918079470491 ,  562862018225938053 ,  685159710121570837 ,  15119034720999885 ,  524745848009989135 ,  486798579014520489 ,  1570699385370456409 ,  358458692000527619 ,  610720392845322821 ,  1935870045105197295 ,  350009363047542975 ,  1127105819598109215 ,  1734345657906181877 ,  1801410932269882517 ,  861503224354356736 ,  1059974598414168922 ,  1599601782644524500 ,  1140445342118715654 ,  94372793267711858 ,  2151869037595676519 ,  574662151173984650 ,  2213747859141903364 ,  1381126603238630684 ,  1369654822064103031 ,  848558715314091467 ,  1729144490918005300 ,  1475309300575550601 ,  718168520546189885 ,  2160404233162644412 ,  629160784347478088 ,  932987526212208035 ,  2136137862826182503 ,  977528850668447691 ,  215713754147150121 ,  493938517852614889 ,  231206927336737580 ,  1726806301433835707 ,  1524160870515601305 ,  133334779488638489 ,  1970660661611484438 ,  1364859194942148363 ,  1700444833539627233 ,  1544447677199766956 ,  32282300540496272 ,  2215177772605829600 ,  1615219003794293030 ,  1355669958175555518 ,  1612926109445834777 ,  972444996505808515 ,  1601820633813468390 ,  1472634915518322505 ,  547348025945270549 ,  726502603250743738 ,  2115575905177222712 ,  1992979234566069794 ,  2263130099702021548 ,  1748619667733442102 ,  1581600065121260797 ,  216517463737728295 ,  890840267568143494 ,  1384584784783179132 ,  1143884736652106611 ,  30107611597571095 ,  142215521159825838 ,  1154186614636119613 ,  417944638859897253 ,  693575344384752478 ,  1329198088372509512 ,  270705275759831754 ,  1516211867338080459 ,  6843882505099162 ,  2038114429918465194 ,  385325513568702418 ,  1637148539852771996 ,  1598771242685303446 ,  2204057079041672599 ,  24891454811520804 ,  500498550676534433 ,  222927030092574667 ,  553288817713371117 ,  1188692725044405314 ,  1914027909047027805 ,  1581606045741143156 ,  1561817556237860849 ,  1543568079036468895 ,  1746079807247147782 ,  2175794574197565880 ,  1599298465331314584 ,  954867494160323910 ,  2023280280267535092 ,  249367687618026113 ,  360343418649269536 ,  1977487618753893075 ,  1763069009854445074 ,  1602933691527936768 ,  1363676943084189466 ,  1907466264248013702 ,  1882655594995912679 ,  2302559728659304790 ,  1895886932396602946 ,  389389167824938425 ,  1925297331496177290 ,  361374400035564907 ,  1846642414715816514 ,  1940028723178642442 ,  2175989931276261589 ,  850860090781966917 ,  1163170664914812862 ,  36676777790502239 ,  783028337578002636 ,  997007049436044596 ,  1525120200521122306 ,  489713891807298193 ,  934083871994707883 ,  322271461324861588 ,  544353399736840172 ,  1098484179576019641 ,  553913847775721222 ,  506254940425696746 ,  2068481858593211561 ,  941808274010118630 ,  1760005556221512898 ,  1430885890883601197 ,  593885437117085183 ,  1054997401529221199 ,  1816430332464537785 ,  2153326731337190249 ,  1065273743458319342 ,  449850178625015910 ,  522348543711340671 ,  1276769447276490461 ,  427236504059960498 ,  1461108634541216132 ,  1225476052594097931 ,  2132828807288372716 ,  1890500740184710013 ,  1918303815819961481 }, // x^2^611

{ 251947724435418314 ,  2190281725396540818 ,  264012000958012712 ,  1617109271005163854 ,  1777000403765090913 ,  221116522627856243 ,  276085834567414021 ,  816916034139382812 ,  5467206146052068 ,  669374809038100392 ,  1745971897417321939 ,  1363517271251732491 ,  524410503924942791 ,  1079991180213342655 ,  1159681488317587555 ,  1853053095429746096 ,  130331013996732142 ,  651774787790187702 ,  2248091805025820191 ,  1250807340429023734 ,  40642213041041116 ,  1911276665596492973 ,  1287932542015147536 ,  1452960781039198011 ,  1381746473670059498 ,  1555645286042433097 ,  390055308846958418 ,  297056125073397090 ,  66523086615920514 ,  1473954293908065326 ,  538739734988808839 ,  294489180340463924 ,  1252891420382984888 ,  1294127228960165503 ,  706619167584616748 ,  1914684495402382822 ,  107206633938099645 ,  451400444200921423 ,  2186560379640592340 ,  914002962250962372 ,  1313271016945377207 ,  606863479331961954 ,  2201997933929287503 ,  858208163507100852 ,  1102084150438697698 ,  1213260459382002170 ,  1948477553216674504 ,  573853731075531436 ,  805368460117082367 ,  1356772244539248806 ,  1358513052362880391 ,  258517319668768870 ,  570583590054890592 ,  1344385532879905224 ,  460387827051220625 ,  2150413544167119375 ,  842582507687228644 ,  574469452087883298 ,  2277639703186032201 ,  958025085372652360 ,  61510926276356920 ,  1585260048574241550 ,  900279903614337591 ,  358605207828575137 ,  580307140130978133 ,  1210282358917139172 ,  961986493339671035 ,  1361815211568639615 ,  667359628850286299 ,  1725268379140402801 ,  1247687666504172915 ,  977220138362788083 ,  1470799927815799124 ,  702456584586605503 ,  286924988066081811 ,  805098850678782688 ,  1340577900556095855 ,  1908937539114228414 ,  1833065622980452107 ,  1124788999134666733 ,  1818270031062496210 ,  253870035585044603 ,  692434728228692640 ,  2264511071356417392 ,  1581531286779273220 ,  1836301495114053578 ,  353410740851833530 ,  668203120350233301 ,  2263156821191606556 ,  2299014634272142327 ,  2029076033233155774 ,  343351433931216746 ,  912484520400763358 ,  306852503534417206 ,  1291430585053730112 ,  1070459562431465468 ,  1802567504722007066 ,  1209283685538816407 ,  165174613230705200 ,  1463612354585020357 ,  262464256222565679 ,  1974002170317743479 ,  1260483396060424368 ,  2132505539974183871 ,  768059330244803521 ,  843678417318128634 ,  1729374146071751266 ,  353956277824713915 ,  1518650567177756435 ,  2100903743233247987 ,  1606121753780087401 ,  1492559517492463497 ,  46023252226989331 ,  1819712322286266244 ,  824729200725272800 ,  806836085588104171 ,  1785098712482552593 ,  1277042079151912889 ,  1661208670170614971 ,  1779140767066928545 ,  858982947586825329 ,  2004340862302755463 ,  1127064041408127957 ,  2044441731455514235 ,  395141587289988493 ,  1794499959889441254 ,  2164236024523226489 ,  30539673040652429 ,  1796019360211746318 ,  2051875136743561419 ,  1305264918931635538 ,  2276460436504593546 ,  891287720293688450 ,  1253821423180093895 ,  1577814291119154641 ,  1927099055024151890 ,  1361826709693917180 ,  1567563339808304002 ,  615230333063973460 ,  1700491005069325900 ,  789786696028447972 ,  877418259680317517 ,  1720322845577921544 ,  916177174966266953 ,  1076434326087816971 ,  1414132049569889342 ,  1974219703790998520 ,  1934111876820114638 ,  587282602385302694 ,  1081974554493596558 ,  20387094674064226 ,  886020616093713464 ,  1593545044193652967 ,  2236244093273562126 ,  2279574832812287846 ,  1611703323069641227 ,  420415070889139627 ,  91298128868525815 ,  1872962651705781078 ,  727582447553456663 ,  704607665029069617 ,  2159889415325935060 ,  1356742552688879578 ,  2060240147394961326 ,  1292222551151518648 ,  1385201634128022832 ,  83448544544241367 ,  1968020917722111047 ,  1215893513994947335 ,  216194756830339257 ,  400414472730031137 ,  1773198023090690175 ,  1804632456439786803 ,  1065718655612063487 ,  1768643670297574336 ,  2224451237082758217 ,  1670366164128915379 ,  1436039935111800481 ,  1575703122457556522 ,  381710980202769414 ,  2066827271262506991 ,  290631287658030767 ,  2071008736374356575 ,  2240767539863116199 ,  767407786231866474 ,  357894728696804761 ,  2122191721443480234 ,  256195658653142935 ,  1093014470066880719 ,  1006683606227183003 ,  1920363146510401160 ,  2034207089857317370 ,  2027901651234009230 ,  2193801610280813642 ,  406035793476679506 ,  921122707529653441 ,  812039737586223911 ,  692130546168151545 ,  2243688573485067986 ,  108385207742033293 ,  338481030937183810 ,  1166552628844909419 ,  1627680470385554937 ,  2261718900486612546 ,  2090771964046963854 ,  41702332154969090 ,  1184029705522900747 ,  2066725395003003611 ,  781480041287939555 ,  1369554289195290875 ,  1603084679482670145 ,  1044756163783513678 ,  1154153240464261260 ,  1386697019999078650 ,  1231115762970496045 ,  1423968425170967881 ,  1706896180188888114 ,  2280268304976780666 ,  319311530359492925 ,  1314590357802310092 ,  756897247950335971 ,  2289111222843878192 ,  631037056213397871 ,  1534338244469486723 ,  1378276986577405817 ,  1845970076484847888 ,  1852571630969698579 ,  2262692998643363625 ,  94498236277631442 ,  113275597371606127 ,  65816870504036641 ,  1557735489755839038 ,  1503309804281158464 ,  959152303700123457 ,  590803343605908855 ,  1834860696080286118 ,  1689409587870169701 ,  1124001508941124583 ,  214268982549307960 ,  557375740045127164 }, // x^2^612

{ 828851588113987790 ,  76201241374091933 ,  540883615277635816 ,  1650498781694356326 ,  954983177265321565 ,  2254115676573739370 ,  1331893089459078321 ,  2204222991835254945 ,  2124624118724168255 ,  414517176145028424 ,  854748598898582504 ,  187247048591084780 ,  287406451098068068 ,  1435968393380230299 ,  1794674424983564089 ,  1151562857483565876 ,  1826228002726233793 ,  2135595285527557359 ,  1269951679722654474 ,  1691133653182593929 ,  634409005927466875 ,  884273855969607092 ,  2116765489734222598 ,  68392860106207388 ,  1375576673004500287 ,  24428349786631139 ,  565967126070250563 ,  2222028267994456297 ,  138375297585879678 ,  485830532814628279 ,  1361060540512593245 ,  848267266555499488 ,  580368869315240439 ,  1571698829852473379 ,  705768037599361882 ,  803583401537690272 ,  916051091377340597 ,  2025192679772673977 ,  2119388686962100810 ,  1411067624432024600 ,  1449127528338227372 ,  1218757766138011945 ,  993084311595438848 ,  1881925892842441230 ,  289832986898795646 ,  990845168145248735 ,  1980312304832369308 ,  1418540520116470801 ,  390457614591343600 ,  203458621118222477 ,  2239560806589514524 ,  1064948002118706010 ,  1490729908005688090 ,  1641033139960783515 ,  400095273279964830 ,  1069304866952243834 ,  335230519426246340 ,  2080655749982773401 ,  130475322771981228 ,  1039777424329757328 ,  3071307905558329 ,  1702393281631449935 ,  585223042842549150 ,  1053924793660476030 ,  1692570151627040823 ,  485685092043321732 ,  1764876138919088145 ,  1894706547245816641 ,  311171341346600596 ,  1463941203201987867 ,  459840194471714537 ,  1044698352497794165 ,  1854012960145842016 ,  1049830279163102875 ,  2026088891414966769 ,  256789759023939004 ,  136786429747993715 ,  1685318206965581739 ,  2165232373212799331 ,  1839672195565944529 ,  1129643261185348195 ,  1811451798166332439 ,  2199331606999561928 ,  311543787150926665 ,  1176715703831350464 ,  282781652951724759 ,  1254782750575513229 ,  102880684890251330 ,  957764768384530579 ,  974373095066584362 ,  1651468218278893306 ,  2270310813666628823 ,  914068877831429923 ,  1806394418138328146 ,  509679031739666180 ,  894423805326045198 ,  585494903536630831 ,  1059546279448480328 ,  452661601162864339 ,  2115537260409637272 ,  1171453053470135654 ,  979789510083572661 ,  1147723338135561778 ,  893364196628845631 ,  107986687001737508 ,  1458902122624691326 ,  2172842697762063866 ,  569713394269695660 ,  1429689367992198272 ,  616241542363619832 ,  71691375884136437 ,  2156732320074997339 ,  2181193486221760045 ,  1786512565276156434 ,  647288757972925498 ,  347506570722301399 ,  183184787724705588 ,  1391529405776101417 ,  72398798832503004 ,  1191146066616105564 ,  1337095247342313025 ,  1108193673150020570 ,  183603453295521886 ,  2173216736879453106 ,  1825496110995860366 ,  1776773179338717999 ,  2266459965484957626 ,  961854661574297788 ,  1381349922932278143 ,  1746465269681459432 ,  2254276912703117819 ,  745922852115515759 ,  260239504349170691 ,  739498581720563520 ,  1878328435297634152 ,  100766033600770576 ,  1178716311725620316 ,  981381484378979898 ,  1567331411583755496 ,  1800096727073465568 ,  837941079645178345 ,  1050611638932194114 ,  2259278505005814042 ,  1211534771189312191 ,  600112169115219137 ,  1298464161958745794 ,  1401949782734934631 ,  1810047314118366579 ,  1397619066002631316 ,  1782590661352378254 ,  423526364243234023 ,  1399611531026125586 ,  900900042375995789 ,  1444036301996932165 ,  1133626776331179018 ,  1758633021519276462 ,  991736403408034800 ,  1318287697813958180 ,  1776955209259957702 ,  1484098729673458283 ,  2108694091037441122 ,  731109408713383714 ,  1278835382039763675 ,  2033521999597797677 ,  1147284694843422149 ,  517860217339472706 ,  1807453876856966730 ,  1000212595141201288 ,  1420085114750175554 ,  1436440170300307222 ,  2248680694081214041 ,  494873906218475202 ,  246982841576556722 ,  2262907114004709394 ,  1123296535695964357 ,  2091410604332419080 ,  767751310971656417 ,  1198252853741637770 ,  1535994396480184244 ,  364531965415350497 ,  1399205499579999542 ,  703080839272466533 ,  1201693788981969582 ,  1419908948236972748 ,  1330560464465664854 ,  431411769748320796 ,  581391437455925811 ,  1109970151062919390 ,  721454752649094753 ,  1646302079930125808 ,  695648572436129366 ,  1602296798794387959 ,  317636402637323096 ,  999589999480340246 ,  1151629361399521290 ,  1022138560731930141 ,  1905560025306997860 ,  1038981466041626639 ,  291680586451079053 ,  1571643470051564238 ,  1807292121010073233 ,  1552422137083748628 ,  1237738330052414693 ,  1264692749104710012 ,  960366356723142508 ,  653629687761154701 ,  450208144439609096 ,  70306644445711825 ,  160183176092253343 ,  515769293510979068 ,  1014617281306005584 ,  526784626158629460 ,  1293581003234585537 ,  70670844126444887 ,  1567693095608458154 ,  1993818416144860665 ,  1948312089075637196 ,  1160935822769549680 ,  594068804167977644 ,  1668648894570201930 ,  2085778493290865981 ,  867999607289691810 ,  2005544563090683303 ,  1284482424163409393 ,  1455644153818510734 ,  943721086632369975 ,  2026389020371903303 ,  792514384277485430 ,  2291463848488930040 ,  1760166694593970089 ,  599631431549477387 ,  1110395327568632034 ,  1750081060063228202 ,  1596087397461945943 ,  1039966462583405502 ,  1246936644834781252 ,  1172089674273269456 ,  568060869034293187 ,  1202757846469346260 ,  2300761948834387231 }, // x^2^613

{ 1752554598415259223 ,  2169733312409060225 ,  215240087565597090 ,  1702597585783040925 ,  1863771622052677162 ,  671973796232864466 ,  1287555089184652386 ,  475296940906886701 ,  1156280627419987753 ,  1680216192057390569 ,  46015376623775783 ,  2121046088926035849 ,  1557317115737106712 ,  1702524901453773510 ,  2112502668984802222 ,  1893281896710742158 ,  517929815786212659 ,  699920643998256729 ,  89947555826090973 ,  594028736335892984 ,  1131010784734912399 ,  2103437746869622069 ,  814639410016922541 ,  1329137380477769127 ,  471578157433315723 ,  1208299666805988746 ,  317688487935667944 ,  141293408114893671 ,  136721108242085567 ,  1687541456633758207 ,  113760570464009286 ,  38181659955090883 ,  1464624906978453491 ,  2046729757509930498 ,  248353595569125130 ,  1958383013580087760 ,  220228393070659223 ,  401905247218079237 ,  462306281261358142 ,  1082782528957865284 ,  767335798582235659 ,  2115755026481330876 ,  1782945813106593441 ,  2168796983753827431 ,  2157375895636607620 ,  1906143768748727236 ,  1718635148810841359 ,  53415028158319444 ,  1356753202871030265 ,  1964227876289140768 ,  474680720023476921 ,  1050584645394331274 ,  120946586504771214 ,  376741646823283000 ,  369774974309116002 ,  691008519136568942 ,  441479800503860969 ,  2185811914425634573 ,  1955655352835530539 ,  1543946974536113914 ,  1185912955294293043 ,  2229650477780003412 ,  2268178173122866546 ,  107044188177590246 ,  1220242398049242471 ,  83792313384591355 ,  1805857021214756312 ,  1663610838791713743 ,  1420043190531050421 ,  1360489166800155148 ,  1792809672926929805 ,  1914241834305011269 ,  1748792926932914319 ,  1272492187837658148 ,  1357175863837275498 ,  533096001248328223 ,  1119905906120880868 ,  1289173634548436996 ,  1821461072989104856 ,  1138637144315437444 ,  372582286520299237 ,  1860892604865698607 ,  2020710608884512901 ,  1177490878053173181 ,  1889825938909115849 ,  291322276548392742 ,  1789414797639408869 ,  327389605831178225 ,  269458659885364883 ,  2197154894295893639 ,  1650352743498687673 ,  1658461322587179690 ,  1687791546564413384 ,  444634011796241033 ,  1016275026013863289 ,  136863282806170449 ,  1972555205805206651 ,  1780630752872391172 ,  20387732090377189 ,  724890484701439154 ,  867834447961193372 ,  2159648289953092009 ,  1722902389758425136 ,  1522574739733406752 ,  135643491990015739 ,  545560693212899757 ,  300581068289379593 ,  921702964985718772 ,  1257312758377719207 ,  859559913580582167 ,  931622520574918461 ,  63410299157000802 ,  35577331007847586 ,  1163194230133889517 ,  551746256269934839 ,  501218344138338566 ,  1870991987007295636 ,  1185335677057734080 ,  1452875929504086384 ,  577122664500602390 ,  12993347555257083 ,  592036100481542385 ,  2222248701998324227 ,  1301959380435018471 ,  1915286494580340151 ,  1118434784822104997 ,  1151825256127116926 ,  1000401482043151196 ,  260772241185785044 ,  1917670953085502224 ,  2089539970450916283 ,  1439161338644871437 ,  1788412990408895835 ,  1358748420576065535 ,  2180499576968836400 ,  1170510137055145114 ,  1925926891731256092 ,  405010476699812847 ,  1413538390430150934 ,  1381271122361663655 ,  2040429127239062921 ,  518798814264669178 ,  1415068472357077705 ,  84846686821430447 ,  1570093897680366310 ,  772864962801092244 ,  432194362621913360 ,  1951924863843818130 ,  970212915076281574 ,  1981568501243766293 ,  1630995825550550178 ,  1372574629526559854 ,  713089330441867469 ,  374928173896884552 ,  752833776629519002 ,  1797148645246220284 ,  1349328558574307897 ,  2060404993307201819 ,  1433783272253128314 ,  874376390779651510 ,  1569781161623132375 ,  2180873105964632999 ,  1480770050782504183 ,  1479870428393423513 ,  2001867074208671304 ,  970782817026912475 ,  1657208679455571539 ,  2088003056481740347 ,  716294436709995902 ,  1648037319801569211 ,  2117619433230759335 ,  1177246207788556098 ,  142604608205002557 ,  141265252244677770 ,  1272706989540804203 ,  81260601530324450 ,  1217387138684791450 ,  451931643060141569 ,  2216521735529134413 ,  2172406047639240509 ,  403520234127074342 ,  768596039291040315 ,  538042547330107520 ,  1559097185542217111 ,  492961586995383987 ,  1632076119178804344 ,  976942161700403735 ,  174196317801087014 ,  1349066218201501363 ,  124608225984747914 ,  2082822116987533475 ,  804601221130009108 ,  1097482544971188794 ,  836514957762166024 ,  1434437519688756516 ,  434962540610952970 ,  42957263851557285 ,  2305383870911658913 ,  298182778795491503 ,  1910309884097755213 ,  1102415844968250941 ,  2196470400036974368 ,  1936114775121838461 ,  364091362929464769 ,  1656772437569173188 ,  1362232520898522323 ,  1576442352767590408 ,  500521164287517660 ,  1174988616870661850 ,  981685945515112594 ,  1035266550650109421 ,  1051620079461843029 ,  830772083603568118 ,  1152194825187864946 ,  360244470673288903 ,  2179999259249032469 ,  938331062137876991 ,  24375723858488968 ,  128756779494191173 ,  1853329327400066888 ,  579828748736774909 ,  1907180234121744126 ,  879730427221196963 ,  1532111019964538430 ,  1396955797785334898 ,  2022310073289576764 ,  1747502751936865391 ,  81286164073094792 ,  346124441458138189 ,  1597089252379324912 ,  292558157114837969 ,  1269033933131864281 ,  1750430964404298473 ,  1877543374976382377 ,  1107156676132519854 ,  207018854467885004 ,  462064078685975415 ,  336519177676671956 ,  1183297600199412726 ,  1831303200903121711 }, // x^2^614

{ 1626390147865236874 ,  1035333247850749517 ,  509933829097207554 ,  1500682070519588170 ,  1189409711021995181 ,  371301149435455408 ,  2176799279625854326 ,  687255808672345780 ,  1924950717323826771 ,  1574715176933273584 ,  981615490426848189 ,  1545636114176955070 ,  2079827394789304409 ,  252971138479584714 ,  1047594318788785027 ,  2179061804708797533 ,  1206444249629636223 ,  1420728262496950564 ,  278958075259251375 ,  1953257888729185862 ,  2160839043840402662 ,  1191022806551627061 ,  669089703943938547 ,  403921452061248906 ,  2131242698304763707 ,  756966521520143771 ,  1494148271004187873 ,  479583000264630783 ,  513299569791998903 ,  717188331812814755 ,  220719266804727800 ,  1483463060644383331 ,  1926984317888262673 ,  1704104099066259283 ,  1192988062671605602 ,  183158403526749632 ,  1580956964100298569 ,  7116996414064451 ,  774200339899917552 ,  524238710644727657 ,  2126667913679202264 ,  1789635461992147630 ,  2154514665290324470 ,  1053992148058288865 ,  1968253424427145023 ,  1189682423182223648 ,  388249505208599766 ,  539148269012046573 ,  330108919762433328 ,  1863683687071526195 ,  518266627703472534 ,  1486724570408430662 ,  1300598648546708635 ,  1853534024917964071 ,  1121031906844152336 ,  1793931498518441866 ,  197521673292330846 ,  1682171118641539740 ,  989492578864421683 ,  1459059816567714175 ,  265340322900757419 ,  959905207102402875 ,  543912063860321896 ,  753503011733577052 ,  1699831034522181912 ,  1129689634211557203 ,  1968772523532697550 ,  1526333356230803979 ,  1640570025854126074 ,  832904639887399784 ,  733178126836840282 ,  795570485393484077 ,  93785550728100268 ,  545352982211534483 ,  1301425527624106988 ,  1306850570187196044 ,  658707627489751869 ,  466353858133419330 ,  1607634005949058267 ,  1943511995578046377 ,  1295300221912604296 ,  849052499612912702 ,  1326088758952575905 ,  1445691821289695762 ,  2184948824642687425 ,  1561099124787763327 ,  833228849735826310 ,  12543031172562781 ,  121420695699361616 ,  995357542247538669 ,  258302601902470375 ,  66902262118694735 ,  1884152550000991644 ,  597842718109286475 ,  1969858098403891932 ,  1686837938715788049 ,  2126786962356797117 ,  1032831394472091602 ,  1664204912677138916 ,  624790162522773383 ,  1105400291695748609 ,  1639495495728185269 ,  2110789266546401615 ,  1291842021218166200 ,  1435063193846855018 ,  1389465169662115069 ,  337468770563747075 ,  227121224660764155 ,  2250562407655527811 ,  844183243943077038 ,  930932880670666273 ,  1304735935539235445 ,  1788159308787564691 ,  2292446160237588300 ,  162267814749916422 ,  345235974377308816 ,  1065821186187503855 ,  1310425278704268248 ,  680090753794704094 ,  1728393581435128151 ,  1487514189620406287 ,  328205546758898283 ,  1053044585966231968 ,  1131741433618670317 ,  672545415418748834 ,  2169823804699285679 ,  1308953635392227669 ,  1238432780212226218 ,  398579036859815466 ,  1515141033353672347 ,  2057918524824663201 ,  879025212091428919 ,  1564621451079222289 ,  1216140300952776932 ,  1484298887409291200 ,  342410051963649380 ,  122350770483448406 ,  1836753443513340849 ,  1621199690678666720 ,  2232499542521849251 ,  2146599497719061973 ,  625527283796872017 ,  660215197260067373 ,  1628175293284687434 ,  2294989070653605219 ,  347034413217758237 ,  1104958400001995194 ,  1699063853486380027 ,  697386615106612642 ,  997156429427109206 ,  1967530116279985852 ,  1411613675461196510 ,  407629802035672503 ,  1231551865636483548 ,  239023506074356420 ,  2253174544535565073 ,  2000389434550191818 ,  987648896659427479 ,  1039846171938507783 ,  693467939094886202 ,  2229737432802087017 ,  1115051903979699948 ,  795722380162926810 ,  2116104022754228782 ,  1246930607482530185 ,  11070371264798746 ,  2166444155130293921 ,  1838055745642292717 ,  917722768407978778 ,  911784897290874874 ,  89857540245941898 ,  894991279012674829 ,  2210417663327866114 ,  447864558000789259 ,  877083996170874790 ,  2089177398601491184 ,  474659740361871535 ,  736202066425749581 ,  48424868405913716 ,  1066265896219234201 ,  1064271363581513558 ,  1498484023606391523 ,  2102080286208251754 ,  1265056209944300779 ,  754699331302060091 ,  2263275920842052972 ,  2064235264762638336 ,  1597483031183961688 ,  18259998086332839 ,  1427271558626803702 ,  1441005840482847050 ,  934160924528413519 ,  28836140846734280 ,  2047727736837543581 ,  397680897011117057 ,  1184518307410029889 ,  1535958222277924933 ,  1796960101931741625 ,  187343432954807233 ,  657243722349206205 ,  1765222368620127897 ,  688014588915198512 ,  1388395352013533036 ,  1829225935068233991 ,  1545539742231431015 ,  407825759215420365 ,  1453430230453373456 ,  2151639453314558021 ,  502500093273956026 ,  2020189863191994770 ,  1400178890597375618 ,  1393628529318526092 ,  928397929368874842 ,  1463590631196236739 ,  308986445389395778 ,  1188418498567496032 ,  250400240471103292 ,  48520681417550566 ,  1660145975989415835 ,  1907581769401987935 ,  808462669873047252 ,  890356429565095241 ,  749432262630778491 ,  1994391907625900852 ,  953329374533395282 ,  1398946384122847797 ,  1882470555760094953 ,  234329706839006070 ,  2225683696982304545 ,  760559634840638013 ,  1577651045871873463 ,  1205232336423178420 ,  2046433267255966627 ,  107922334731397400 ,  1117925175616064676 ,  1085268773199284492 ,  219824566372442810 ,  72889311856235098 ,  276966612623978338 ,  678838681382299043 }, // x^2^615

{ 240320497181159703 ,  1291960367292828512 ,  1743521553258571987 ,  1405392076556095742 ,  620678472663847797 ,  1183344836702603007 ,  646039728993723123 ,  370922197204239652 ,  1563602619601005044 ,  1150033048220048647 ,  2134669333117134844 ,  2082416352337329502 ,  355720393097026562 ,  1514282187975270945 ,  2281186396949317154 ,  1414542008817110741 ,  1167108404240646301 ,  440849629107840738 ,  1890370975069165788 ,  426335900859580344 ,  618029907173987048 ,  535020818785873682 ,  690544065329060968 ,  2090209228012601302 ,  2107531629691154139 ,  1293867077257306215 ,  1832097972513968685 ,  92299876803048643 ,  1404286780067478174 ,  2170358357182723506 ,  370288715250811470 ,  1053580815086059074 ,  1539278007120837354 ,  207146074608871951 ,  1634609291023857568 ,  2107992837090211509 ,  1024710133821608685 ,  1526713467008358388 ,  451640207395235846 ,  1967891268351357726 ,  113683110003487786 ,  1907871423270814424 ,  2181944687059952327 ,  2116249362370021770 ,  2280658563084511348 ,  874158585339405510 ,  2002911789561850947 ,  1120560089980128962 ,  48544608449684752 ,  1705466052676599272 ,  643227899270283065 ,  517042150000459115 ,  1915684951928178687 ,  400930241834440300 ,  446820342790768727 ,  1823556147458663428 ,  1854140028292761936 ,  1329046838557274428 ,  2123443813355963730 ,  1456798769448442885 ,  174141158318052713 ,  1226617996297416852 ,  2065659630839410006 ,  1655862338938055541 ,  757954961389043085 ,  2143238128689853934 ,  2070157758420603461 ,  1765784439686674535 ,  2242418842115764953 ,  1243307791330385358 ,  133611631608330767 ,  1400797343602266168 ,  330692538470709576 ,  1951182917389500197 ,  690989537039383430 ,  1717330933268062183 ,  1753079170067173685 ,  1203230366173479771 ,  1994312488944051230 ,  1251822018621043573 ,  1154930563604027911 ,  442816369078740369 ,  2059073212873831288 ,  2028942693581647170 ,  414925131453053895 ,  657061388120949371 ,  2133882826236248048 ,  580015628515845143 ,  1575487066556926754 ,  860016401422243189 ,  1074780258555348787 ,  271437010341839728 ,  2039516065806375816 ,  1289819713801978223 ,  1844032058087561572 ,  391793011204447399 ,  1250397005684454751 ,  1815068256294628237 ,  1559537075017781958 ,  2221253141959287545 ,  2285568959672086535 ,  686950464060535621 ,  1049491698013536328 ,  1822012525743173608 ,  90569094381000654 ,  89857416451959845 ,  2163454422284026033 ,  621501570459820353 ,  740484379080146857 ,  2277071886455295690 ,  1070975188292041291 ,  1658539002899799567 ,  551625550795905939 ,  1139652588321742849 ,  1277030577234626641 ,  1461901801040910001 ,  2046453891540435975 ,  1874535814377458914 ,  1259150191642340221 ,  1651006666883437895 ,  324986971296655530 ,  650576896898812225 ,  445375229260380408 ,  1851221839061859441 ,  445332383646497919 ,  692203573903116664 ,  954116821333850649 ,  62072168927623819 ,  1221990697489267744 ,  71322892630710526 ,  311803492930095266 ,  266737220133017405 ,  436660286208288052 ,  97262233503859224 ,  1185158489132392996 ,  2102853490959394265 ,  839463312938297473 ,  596573757184143009 ,  491479699220128591 ,  1146198042367885231 ,  2217486855494240026 ,  759689728757644468 ,  81025075682794493 ,  824431033051407007 ,  746357476206626165 ,  619268718366974181 ,  1681473520380870330 ,  750444753368514146 ,  802128712843596266 ,  1485494105876699645 ,  1093747302650333116 ,  1097970608056797160 ,  703401460439580679 ,  1097917567135473463 ,  2180701456524825793 ,  1133157364786479414 ,  2266198688323647855 ,  1509395392578145293 ,  876644439178175519 ,  1722833131883137371 ,  708280749175960209 ,  1861802860934021051 ,  2043333702662721365 ,  498961977482782018 ,  2096907452106554098 ,  519899192498615221 ,  1889646003680781208 ,  1568806115878214292 ,  489838531172587336 ,  1046598500151918711 ,  470491658845876969 ,  35757524896804428 ,  738442651316973827 ,  317297534755880204 ,  1959824691431272331 ,  1567451338979861655 ,  1422594409174863707 ,  175247707179658860 ,  2298270632724643897 ,  153790422243908443 ,  1129107500545234284 ,  1080066600088261554 ,  2081304388950155367 ,  1885657031472240966 ,  2068640892090733835 ,  982094993827809168 ,  629180643344289757 ,  2123519626953970013 ,  1853523971282662130 ,  2096322189318856654 ,  1654851379776962332 ,  452888709442826122 ,  961849334613390106 ,  1316723967384967468 ,  1846653794963135632 ,  1743294549595363413 ,  1613819199872952485 ,  606603847674973729 ,  400756020013758697 ,  660747474406689111 ,  855230665117236127 ,  1766183674974273493 ,  653944681887152047 ,  1495358995168368377 ,  397427279249509242 ,  578604195572128649 ,  1008157302314080661 ,  1103549192774745038 ,  305948868424531819 ,  1247636223532185830 ,  1025598719121270730 ,  120477133707154466 ,  640481542377486410 ,  425891432368240462 ,  1806359202830638014 ,  375907733945211269 ,  1781989850064365984 ,  52964152973014784 ,  930323771889757602 ,  171170894132684077 ,  1092259726966885383 ,  1191225795447850069 ,  1347229153028896228 ,  2134081997249506517 ,  1054902211560108200 ,  208952925020551515 ,  611457942620811510 ,  1585496747095256138 ,  753947423109754605 ,  1629928452108634394 ,  1571138957981461071 ,  1690698843724255949 ,  1477123816174627583 ,  457456430624166678 ,  1230253932718639214 ,  1306873486472759242 ,  1861607409501782619 ,  169970748957522045 ,  1939303794643086906 ,  329369406024209195 }, // x^2^616

{ 470747571606885779 ,  205931566804793383 ,  1510723297662938066 ,  1766432689215657254 ,  397119000996287119 ,  1625762984264216326 ,  125094080580761849 ,  2156364260947318608 ,  71654567525457433 ,  1490581347197001915 ,  1167938547762699695 ,  915613734055360477 ,  582683495759190997 ,  305165922429094402 ,  167557525706893119 ,  755009968271288108 ,  470746869306740597 ,  2161777951337611544 ,  991427663331555822 ,  2028489883085459168 ,  1785588978550722730 ,  967925695486096815 ,  1919185085592357269 ,  1948295351319229264 ,  2053804948968979256 ,  154677773227643647 ,  1524148377223175150 ,  64268507429359301 ,  1281406311214684259 ,  541882527734348472 ,  1724352643669658095 ,  106861883020027611 ,  706946723505596755 ,  950691376567868105 ,  144316980862253944 ,  450988079053983233 ,  1282779994264089813 ,  613083241257477477 ,  130661500134456583 ,  169797143186567591 ,  677803627121832661 ,  1764953423495590808 ,  285918691758506823 ,  1406822456525703869 ,  1554481647407609045 ,  2087989521696570787 ,  1280016880835212638 ,  314265435044500653 ,  607366117190047270 ,  1883781564611733901 ,  1221217836099379392 ,  536645806968247215 ,  2236593647837381245 ,  1880974151475675399 ,  1412062303725719859 ,  359828971972098037 ,  2264513014869809004 ,  1128637110947436802 ,  203559387477468415 ,  357424497304995087 ,  321299861225340276 ,  87390258042940421 ,  1315612162494467138 ,  33312376294754311 ,  1898805172813746338 ,  482462745971940974 ,  718449334856291136 ,  1497149190981395355 ,  458357382196643623 ,  2238411868042520429 ,  1151169158707932423 ,  1907655400796208321 ,  1746076951419226077 ,  234645220178056373 ,  628464501336035591 ,  1473644680576155850 ,  1225468029322010339 ,  1709876018205778599 ,  907536212349249981 ,  414103017131460676 ,  1908447661067970874 ,  1614042573608410775 ,  964597016830741786 ,  753820397394311318 ,  2170258063476618990 ,  1492951992963474008 ,  1236031364068570664 ,  1728854885628613931 ,  461278432563329741 ,  768019129208111379 ,  572152462623993196 ,  1208612388238679767 ,  599990154740091409 ,  359200000730830129 ,  1824635137394246230 ,  1093674984652835250 ,  1749504479852352362 ,  755856052332896600 ,  1918589582905437972 ,  1265865062382516411 ,  895469040679034471 ,  465216155214062663 ,  258851692203534172 ,  1113848170751430119 ,  2281071068888502714 ,  983927477538415735 ,  82594859675010915 ,  2244540045639880552 ,  1374606494010813033 ,  700761815781234946 ,  122648270793441303 ,  153370725148916283 ,  1588533780719395441 ,  895177425811714019 ,  1184479181135534139 ,  201179689759331189 ,  1016628785264196700 ,  601198124094609430 ,  14347419478005380 ,  2259815278309972416 ,  1802117949517900107 ,  495935998585793409 ,  2106463222494387790 ,  50921565273481627 ,  2033911658457164565 ,  1136804332800470588 ,  1409565588224456557 ,  606899099831561898 ,  128363585663687814 ,  1335997378863389904 ,  934790728203442952 ,  1539071528046992175 ,  1294305332201979396 ,  866223301824849475 ,  906749513989167008 ,  2140204494124002993 ,  1072992693827590362 ,  2281643564531123798 ,  1066078360043624267 ,  208456387366656007 ,  1412312497332559796 ,  1889202120278508104 ,  1166012725104088672 ,  1866154249721101428 ,  241789925315761583 ,  249408006123207165 ,  2042040027037473056 ,  2222455889709523524 ,  770747640898434562 ,  2034193722715549674 ,  722867164793052477 ,  850627948313233514 ,  243436406697890723 ,  481855669842571524 ,  123711058314539495 ,  1361698815698640890 ,  253025637120383270 ,  521733326408390881 ,  2289275032740720077 ,  275749439103487559 ,  1111801740999139150 ,  965483957056839727 ,  1354741320584395307 ,  1902048403910885642 ,  1059687764776143938 ,  989994989739507785 ,  2184409994610823530 ,  2104119816836736049 ,  6960722150586988 ,  321485554204483865 ,  1924889892969045456 ,  1441270079172390244 ,  797462122812191744 ,  1732417666739592836 ,  989530723782744454 ,  1395205726738042297 ,  123848054835954526 ,  1655086091525961347 ,  543892744090631782 ,  2228383594644670904 ,  1784425975508434627 ,  1750728331422717460 ,  816307578359033867 ,  1766660081029197635 ,  176565631848188202 ,  2046999573395429294 ,  982102012494977045 ,  871100330102421979 ,  990723107021783902 ,  753547607368100060 ,  1460826025794470245 ,  1556350057709429259 ,  1499946722379187531 ,  2115918086358240205 ,  1328391207337050155 ,  1429270527736988001 ,  861313163393574534 ,  1530928108488841131 ,  1771491453228441954 ,  1099792181444606835 ,  587862405821992522 ,  1398506916454302592 ,  2226509467995043656 ,  686162499147481951 ,  797008347690955226 ,  1400932226348927109 ,  2013493730913255376 ,  1868259024887159396 ,  1845361118292389788 ,  1934686269609211934 ,  1799120990378663735 ,  2185314111760629341 ,  1163590119655751421 ,  959786334545226408 ,  576748514103797938 ,  1447607881787722024 ,  456303399836974788 ,  1403581682555666062 ,  2215047878466956671 ,  303810347371891655 ,  1755018482881764382 ,  2187613639460319548 ,  731068696912223309 ,  169010678237980453 ,  661722901869523766 ,  778443844361438635 ,  1464807329974178461 ,  631444169143991730 ,  1018863027213183249 ,  185370102754030831 ,  1665344023227315378 ,  343727194970367856 ,  2114260316160767345 ,  405758246835022751 ,  883596304450286872 ,  1766428285500509411 ,  1525298397245101163 ,  625429665568599757 ,  462268328916558607 ,  1036934847659553128 }, // x^2^617

{ 1417152757112452674 ,  1182705292347881200 ,  707769799709850381 ,  439067864352666006 ,  146546457541143357 ,  1189344436162230222 ,  658308920702231382 ,  2132545143742502667 ,  1916669987226363783 ,  637478507662184812 ,  921417877128776957 ,  380434879238696704 ,  1438765814310242103 ,  44873082547472862 ,  564710030015856525 ,  1325027007682518496 ,  20473286146509630 ,  1584530151854675122 ,  1540767010818989445 ,  35828953771795309 ,  2040735369205109125 ,  383927773154449186 ,  1557503521750065190 ,  364543007613795008 ,  2129818852369080104 ,  75732786977971158 ,  2273769514376728716 ,  1716286616649427625 ,  472825855644900217 ,  272958558994419554 ,  653281397919583977 ,  2056794969827717676 ,  2071540740811190040 ,  1405924399001755201 ,  245314391798430117 ,  1163975402408274870 ,  843882022925617959 ,  2017276394065920521 ,  1823683511563215165 ,  410910287138142392 ,  151827952056733075 ,  899744233532260455 ,  2232163891694207291 ,  1979602971086002697 ,  1730970808953308078 ,  1653184624476848379 ,  110758419286465432 ,  1680844105569663072 ,  1140768719652527891 ,  396061847928700727 ,  2008554314196216293 ,  93714567333131236 ,  1567722269540118421 ,  28334446544050773 ,  350348405136077622 ,  201727797833364201 ,  1079797181982893965 ,  1362934255451586211 ,  2086656402599882965 ,  653017774340349107 ,  1783857308321438325 ,  908206219575348496 ,  21003708415854917 ,  400435557533824844 ,  258245597481426418 ,  1956824552604091735 ,  949501141610273228 ,  2194629338721749309 ,  340131574305524777 ,  991468181260163661 ,  1803596040490409731 ,  229178828391054566 ,  1423974322382773196 ,  2117942654991449154 ,  2231528921222193529 ,  1656253035879374881 ,  2088074750884231216 ,  1952581910072774126 ,  2264080196618840271 ,  685194996957173937 ,  1224529917836913789 ,  583303005159238310 ,  858789847574132809 ,  979037780855555684 ,  1194016351831754326 ,  159835585652238112 ,  1612030103158735833 ,  1023271695538265294 ,  1586645796774394617 ,  299321145627255471 ,  553148844561983345 ,  528660538908681191 ,  230955580796958824 ,  1682878238040236224 ,  2238453226005403398 ,  36074591740989965 ,  2220569493585106217 ,  1561006292984153095 ,  1150606197974261152 ,  752731418604612951 ,  219014834553811281 ,  52830098026164322 ,  499275316542396342 ,  1321937794558997024 ,  1193353955389098725 ,  1137162538220587519 ,  436914052491528563 ,  1071109053945046042 ,  1091779790321928031 ,  1774248913696334349 ,  406175756137361402 ,  701375706879675373 ,  1723157070065007855 ,  1461135942207826994 ,  1674999733716558097 ,  2028787359349248807 ,  615883069753202398 ,  1096337296486536070 ,  1908464428905459068 ,  1973708173942127191 ,  1463155549175103974 ,  2042029009469589090 ,  26607214609549216 ,  86044777108519291 ,  129517571121731479 ,  1058456727788949060 ,  104695902137092887 ,  2156803911996927538 ,  1705288348711776098 ,  139330895628399104 ,  1338326277785640030 ,  1031218843379675271 ,  465783106083268556 ,  1821847776790484517 ,  135236945396705334 ,  1221805305798947170 ,  1221182150034211927 ,  2286431141499776578 ,  2270163048317016587 ,  935610773806352846 ,  865003916613816550 ,  1341914567345247058 ,  1158764722625006779 ,  1391843147613939133 ,  2139318362305860279 ,  1793746716712785161 ,  1154774691369970940 ,  1984782015861560679 ,  1846896836648095511 ,  453102289248910287 ,  1567206430036183139 ,  1852453356825002087 ,  1184021925819130557 ,  1813364432539846785 ,  369418114726993029 ,  1196409523002864436 ,  1477516515597704290 ,  1862477974937544936 ,  318355123431840508 ,  910402428679980256 ,  303588337611753282 ,  637224738572493086 ,  2055066050263242067 ,  498325611720758817 ,  939139285322602267 ,  2116207542838961681 ,  334777408178723009 ,  269247287705629357 ,  1495179950931435517 ,  803166335374871226 ,  2296304889672099402 ,  1935910519190184170 ,  608120993030507140 ,  1417367304726256141 ,  1666062617347567791 ,  1395011404987035672 ,  1737127528914598344 ,  1073317019164014412 ,  2217654999356049194 ,  1825492498625339604 ,  1401382000790795537 ,  1163775523953941383 ,  1913798523568653534 ,  1872114057409951925 ,  1442576510891275403 ,  1154178457395717997 ,  1535504641344962376 ,  1226628453691188132 ,  1170578641862243927 ,  2261906175740976574 ,  1440299032932884995 ,  1663608305384847962 ,  32495825924298295 ,  540024062185277236 ,  598871430898860317 ,  939000375005976117 ,  510457597727087370 ,  512062618315527158 ,  86585417220425493 ,  2084183379308041784 ,  2222111826229973114 ,  1465799208583601530 ,  796135377769771416 ,  10795576639455978 ,  1126802184768314092 ,  1543992463676656793 ,  803828510719095286 ,  1275164560713094117 ,  1779652165044137355 ,  1714898968460523032 ,  1238178532508676330 ,  1582135977890162959 ,  611925426802940212 ,  1027696338213083376 ,  2123085413456278058 ,  413469236310617390 ,  1314740517873143336 ,  2294914778288939981 ,  2078960653960710653 ,  769284914208450223 ,  1341414136570148545 ,  1543926725282255291 ,  2116735812014032963 ,  1810579833568809358 ,  726157983289621296 ,  1740923382558702344 ,  121886944212864895 ,  1086790592164623358 ,  1624983793252225062 ,  1420378927177514380 ,  453560901929522641 ,  713121791683831432 ,  2050528664403513159 ,  168390553727861610 ,  1633139234040683975 ,  2211552252672574231 ,  204221785382774644 ,  1990770765634407380 ,  1546877813055930130 ,  1444794136416087855 }, // x^2^618

{ 783049153942631978 ,  2106982387415276483 ,  465703249022503451 ,  1917240272864429634 ,  1269678980209913857 ,  1094108191053727617 ,  860642502406721904 ,  2198076256968940369 ,  137979645235937857 ,  1653230289712578003 ,  1153097869799994658 ,  1443693068353266919 ,  579400913058396183 ,  1594459034632057165 ,  2190099825774544023 ,  989683355089216149 ,  837097353086542709 ,  25578770237043200 ,  415891400758695805 ,  1091489857459107118 ,  2223240553568913483 ,  1914964884543726583 ,  113934248347707222 ,  136461714295238527 ,  411248942682237135 ,  1811111099574698984 ,  1283768177932648311 ,  370064426417486772 ,  240462926863588331 ,  414822901637939189 ,  1229205754030491959 ,  1057219845965526129 ,  1032827114074216423 ,  720961598603987528 ,  1337579614047231283 ,  662936259539755405 ,  805804805295082768 ,  359138650298258776 ,  1018973124832454000 ,  2298171061610901145 ,  944558031757352000 ,  793344430584743198 ,  1366275500526213894 ,  809100955717404937 ,  98849207365893064 ,  16269643105369916 ,  1305994980484127064 ,  515675956466869821 ,  1606435211170431333 ,  1616709249115892616 ,  828670890961080025 ,  857669197237784300 ,  575652474465261230 ,  1129603863892386214 ,  1108104462034407898 ,  1394564841187976849 ,  821982020121583293 ,  1333714589779106865 ,  380639609657804420 ,  1022916736125909743 ,  1415115514097411448 ,  1538449815973689862 ,  233963280474613064 ,  239708601300341106 ,  480630967981444376 ,  192935911593151057 ,  1330955161286720407 ,  786611212155797407 ,  2120971265728138793 ,  295493410231959925 ,  2046921969568316443 ,  426170197475268901 ,  1073521604707674059 ,  356403957650116886 ,  1409805788278768883 ,  1684725361933547704 ,  1803746548409088221 ,  2142569278972730464 ,  1760492943803083720 ,  1654110912138836805 ,  2044735889344318795 ,  377943563035847513 ,  573346568793253766 ,  746959572484708105 ,  552821682997487334 ,  981769615184126878 ,  1226114112178052109 ,  119883975490908860 ,  47467306243911581 ,  922933799634157087 ,  1370777382367897983 ,  1245686518019086862 ,  434597594370216885 ,  2198830671035644657 ,  791005963145557380 ,  1302014697040474480 ,  989692302290261417 ,  1862310228960435424 ,  72016211269408 ,  11253120641884187 ,  136288730519073496 ,  183085202050951605 ,  1190689738523578497 ,  2106685446800246818 ,  1137363660026936898 ,  664568134187226521 ,  1722195847394222479 ,  2234208432013485854 ,  256277088408229099 ,  2233825505244118497 ,  720066981601893508 ,  1246197661003852265 ,  1312059991060179150 ,  1866870728864865300 ,  1029201197571838900 ,  1847889196767238367 ,  706123124122885563 ,  809324149202365881 ,  1938106817043113991 ,  961743215021705977 ,  1629925504536087437 ,  1864181899540497583 ,  2240725081233358235 ,  2156355309459352270 ,  1941508821801045074 ,  1827601740860368819 ,  1013844828442123644 ,  680094346054426911 ,  1511415375557124554 ,  1095269274016010064 ,  751648698430210222 ,  157569458342867304 ,  354957573842224978 ,  1237859613173912072 ,  842717730950004553 ,  2089927898683471359 ,  1637512810565303117 ,  852437530059813497 ,  770420356144111881 ,  871766631666554665 ,  611266060490746649 ,  2155420429172989744 ,  847559364261577732 ,  644296154828271298 ,  443735158428218101 ,  29460677810838346 ,  695078670261554471 ,  1113727221741488728 ,  234689631474650021 ,  108584051360288011 ,  1597462951111865746 ,  1923157230990093926 ,  794253535601270624 ,  369095392759524312 ,  1783060704613719667 ,  1222067210564300812 ,  191478831941599654 ,  1623085803867987678 ,  792520391480189949 ,  464545120266776643 ,  2066286233470527353 ,  1078894561277634034 ,  1980258804110577881 ,  1539762683557768542 ,  2042399126268806377 ,  1513825741795908334 ,  2032637221950463771 ,  127288681431586092 ,  1835356695552923728 ,  571476257463146639 ,  994805353440545848 ,  1520247351744453866 ,  788388275705460524 ,  27057337787943181 ,  2252824520290291093 ,  1026966992428010434 ,  877516827817519754 ,  1735339543846005262 ,  248387235123673942 ,  1934301347015247174 ,  976353780336728671 ,  984471051333995099 ,  904874448392631698 ,  1292792148951307668 ,  400615988784029153 ,  2039933242858395515 ,  1539480520766585966 ,  810308621231804432 ,  1515191670876970156 ,  1737420975525611865 ,  125926003891088381 ,  1166364728824827819 ,  1751150033219466959 ,  1891737335513654057 ,  194874493955139940 ,  1339919467129308898 ,  1818595965700786740 ,  630951499279787298 ,  678900027072382910 ,  1094282643786197826 ,  929464392304724582 ,  568889879419758576 ,  61650585002390908 ,  1024837454071773925 ,  64504980370707819 ,  783965217054225197 ,  1821324825010429783 ,  1395713393391221632 ,  2258809903745155971 ,  1468897610782222512 ,  1721012666105098517 ,  463209983692325439 ,  1659946747597799233 ,  1552204912686869536 ,  1164561085932329813 ,  608876493069368628 ,  2082555739270776354 ,  11314029816777613 ,  453662421549918582 ,  446857940036264214 ,  892583572947799627 ,  418453187469220616 ,  1382735357588596819 ,  2199839460016011912 ,  361775953009766812 ,  993721183669600393 ,  2174813815646482342 ,  184796160563974987 ,  548075176438499653 ,  1734682309833414894 ,  1061414352717214754 ,  528327742246725274 ,  1168232251068074671 ,  807657406901374934 ,  1633285769685028070 ,  616304837696749111 ,  1908885555631795857 ,  1436271103304192271 ,  1321122604264103621 ,  2048886537918933126 }, // x^2^619

{ 1958367779888361055 ,  1941080747978861032 ,  1605464363730569601 ,  1834650678873504006 ,  900231292828836223 ,  1446285902155222146 ,  1585297108305312448 ,  1663945917903464933 ,  1158621627328223661 ,  362239642964175797 ,  531763995058261387 ,  655946133400202671 ,  1637084095163176398 ,  1223534409874623035 ,  64247648348633161 ,  2106610720859104188 ,  67154755737090082 ,  1992230859711996489 ,  1645178326079677777 ,  2268532471313551115 ,  809769198972649147 ,  518854191082872755 ,  1505581041261825773 ,  126100798976134610 ,  753964710064954544 ,  1922550500610132552 ,  1692062243190522019 ,  1380197304719234962 ,  686867088036950987 ,  555906835016712985 ,  289285868008665628 ,  814406282246844375 ,  493387636697639685 ,  1662926192130734668 ,  1102750155267644035 ,  625148703498013033 ,  690160307781128685 ,  713712554983285585 ,  752190638621150764 ,  1842608776061692634 ,  2104365606045651189 ,  346335343218568343 ,  308040850307407872 ,  534336405847505414 ,  810898206493992108 ,  1110994931229139225 ,  1145302795114943651 ,  330622525532608059 ,  1222781037461865460 ,  1069688115065730295 ,  299055034776928195 ,  1229610446066956089 ,  542238273215866613 ,  95768548044772965 ,  1100553681773294515 ,  347398868134791455 ,  1813454319502245755 ,  685710142615583193 ,  1521213665193835479 ,  2053466027674796317 ,  2230893363637874948 ,  1583561224926885337 ,  1911321310401048395 ,  1137339481778597736 ,  2093555255112146275 ,  526694021474160223 ,  902018460862298109 ,  1960868517231687874 ,  1114821593076496509 ,  176885044987084516 ,  569555330189506590 ,  503794614620462217 ,  723164879011870087 ,  1524581284710725826 ,  1968551461475025459 ,  1290299303041437510 ,  142603856736843712 ,  2128902717884750555 ,  2223780279483464448 ,  1751162213307465653 ,  2177002476999996922 ,  1660674092518427882 ,  1301831445832315052 ,  1663651623181442590 ,  1494972833477537874 ,  1286847539184848043 ,  452136199152328760 ,  2074300312425434683 ,  2140852876090342231 ,  845859788475032390 ,  2047545093622124196 ,  1299588861523969899 ,  1331586877059711105 ,  450100713027241286 ,  957114570218379253 ,  228863601183476605 ,  51281104036443040 ,  1940635017534433663 ,  1567931074654459433 ,  983210758264310107 ,  837550541792996364 ,  157587832421582197 ,  913228929778701167 ,  217659974644122554 ,  1244392860682015347 ,  1944339658213078228 ,  1740300461863708611 ,  2201437823909445158 ,  2254929450936471825 ,  1307570554810524654 ,  1504169391852508152 ,  2195442611522901169 ,  1115318551690250389 ,  1824457365336249385 ,  1794325790617915719 ,  1353505394496442443 ,  179807368562981938 ,  605008490044676538 ,  1375658359986016034 ,  820472195170295982 ,  1222245123473374980 ,  2295417140857178973 ,  1717873660182659580 ,  1951964130682079186 ,  1197608318303737258 ,  1724194286906248009 ,  482992254985723831 ,  1897641567021419358 ,  2009271588303721644 ,  41628611427314152 ,  1280280002249924227 ,  2178608977415257469 ,  2112258085921337423 ,  322344952751239034 ,  499715985254870976 ,  2153725202883188310 ,  1718873029657612480 ,  2062071014774412127 ,  102385700440692862 ,  814501971961231284 ,  589671365239293624 ,  633307446751759941 ,  1997574222238216161 ,  1397412512271574848 ,  505925347915515289 ,  1391350717481970541 ,  1881455323376422300 ,  2099641871824087029 ,  2035758359622341208 ,  2072014692447359994 ,  353423064808657737 ,  400754442886526812 ,  281091902945869408 ,  9291332782790196 ,  1448855796853079577 ,  1724619153349286887 ,  1229965751442672908 ,  872210761654869535 ,  1630532737998724496 ,  370896410087893077 ,  1102084278882120502 ,  918892235797572870 ,  1889948738802833124 ,  1176059178328866900 ,  896623434896811707 ,  1517107565085436732 ,  1772963042486986207 ,  1883278077434472344 ,  898794552703174157 ,  1023474151761909005 ,  2157697816069399518 ,  1580254123349258789 ,  2201769873599382289 ,  1665946778461996439 ,  1517199243486848560 ,  1426284569478100848 ,  579200526329666123 ,  2052699161132210382 ,  2270255352656012036 ,  2167018301081902907 ,  2262517339588009961 ,  1235006197106725677 ,  2238336141420758295 ,  35277814971799676 ,  887468382680582447 ,  780229460420738257 ,  1204809757359630047 ,  2242068933604498439 ,  100303613681059827 ,  1340187740971589797 ,  1235118326297028221 ,  1422176910782789975 ,  1067269283199935617 ,  1050401476994072200 ,  332885999098689642 ,  1430463062664496416 ,  416077454530489085 ,  288654827325379850 ,  1867482208518987108 ,  1332300660659951933 ,  1936242769659432673 ,  1014747724514129357 ,  192129788847473006 ,  986304454943590957 ,  650569076161417411 ,  1746382633208335045 ,  1676104611322699774 ,  591276911009513838 ,  666494296686418152 ,  1498343973992629155 ,  2072181580958472008 ,  1195359698682346559 ,  2161605901770300646 ,  1485172627316863794 ,  1926125299837260139 ,  1800273923740872125 ,  1719382630911752171 ,  1850472939388995938 ,  1421598918428589580 ,  1015067679069654461 ,  993529657584146697 ,  162033996620068806 ,  1295654316273496674 ,  1497148861703953776 ,  1583036716638476686 ,  1746132326441469153 ,  469963179652197911 ,  1394541477281703004 ,  2134618277443124627 ,  278274135300315506 ,  1063248842691156701 ,  6982309025909949 ,  1663775177836622153 ,  90375034319468494 ,  1307111561845249450 ,  1783667260550614240 ,  1019431442366171851 ,  1123049702962868748 ,  2093465542483153474 ,  1833938681990246043 }, // x^2^620

{ 1858660014828263778 ,  487720752238183870 ,  1908370383591586209 ,  2141387256639192094 ,  1819410834791963678 ,  2083861421731078740 ,  1722713322404039887 ,  404444522092675556 ,  967368033298140512 ,  39279058259627147 ,  1968333063002260006 ,  1871684724330308348 ,  390203148156066742 ,  778146172090792012 ,  1983846699617980843 ,  437154850743732682 ,  646199143256242115 ,  1046759132929131046 ,  329939381183399884 ,  632618103509822674 ,  1287611816861843107 ,  56504648164730706 ,  891566563407516196 ,  238372640391990229 ,  439794979823720287 ,  732170260039438847 ,  1556962501736887558 ,  1916533448561608667 ,  1457138111644293539 ,  1712261689806820079 ,  1507917281517975907 ,  783546749442563656 ,  2114040071024154820 ,  909697069927090183 ,  2076429158402949754 ,  2090391598963318313 ,  992363144980625932 ,  556278352633969234 ,  491338112207264247 ,  1457256296895801192 ,  194798098957694715 ,  1181908798637857060 ,  1538920543919218066 ,  1192985470623723835 ,  2141548738931804023 ,  179903252006535782 ,  276838670868815759 ,  170592691746077072 ,  1357680279517022726 ,  213902124796557606 ,  2239497780676597660 ,  1107337644650689012 ,  1285527400076725174 ,  136220811238015354 ,  801122232420037274 ,  2165319012841663825 ,  792829631449784705 ,  1048888184466097383 ,  596637300671537793 ,  317712502461700583 ,  1879469533276681405 ,  1904890059308900710 ,  879537840237872883 ,  294358408117342331 ,  840034328588352984 ,  625705750010590027 ,  8653923577701884 ,  662324610103748059 ,  1348966937437877393 ,  636820546497410320 ,  1087582054050323936 ,  1653893311358467840 ,  286442450350526256 ,  1984111587648627355 ,  1068804406597650213 ,  660224856453020066 ,  2210217598417193170 ,  1452517677202831997 ,  1588408596615717797 ,  1454315634178225298 ,  953147646240066767 ,  772945413402853041 ,  1099656009947097776 ,  129918622797139180 ,  1153371582054734099 ,  536121915846897999 ,  2293691780218962885 ,  1928305988832943679 ,  156365759261563716 ,  1500641562006265610 ,  2040424892051604633 ,  1659865467598777518 ,  729850762812722253 ,  591736313985940345 ,  1860713938071629331 ,  2266382778707774150 ,  1585877382638544123 ,  885491075602795965 ,  504968541150291159 ,  326992308106422910 ,  14957144303202779 ,  964812508308839226 ,  590733881875049936 ,  2013906695274416438 ,  589564472202265827 ,  549511140382913061 ,  2215286820186437066 ,  274796150222936679 ,  836388499743835634 ,  1200478346064729171 ,  780272839456343260 ,  458975930819443853 ,  227558267534528074 ,  1476576971783030973 ,  1303618546482256113 ,  1666088330863005930 ,  499684916418129161 ,  672555591480169519 ,  356267147605439103 ,  791812824017159978 ,  436998019572598726 ,  751052001783755422 ,  1382883288144807825 ,  1250026642031736706 ,  1652592737778812287 ,  470968759493128356 ,  1819207017934420397 ,  1865769216166573744 ,  1207490533133414542 ,  936843567518652340 ,  1992612019105508677 ,  1525422151271945927 ,  1301592605716591109 ,  1585431000169536024 ,  1428113745882318616 ,  1285862750403084630 ,  2225226221378909687 ,  1826320697982751405 ,  45914106315263210 ,  1320023113697903572 ,  2074660158945493650 ,  1751029904784096699 ,  432294065901766724 ,  61909151813889990 ,  616206045967416744 ,  1885751474866219151 ,  650814381972945777 ,  158134900307948079 ,  778954888162617630 ,  1305371239829219131 ,  2111581318983070200 ,  183762741395773346 ,  795905711356852792 ,  971641458611603858 ,  1782589465064949696 ,  1744787690780430820 ,  666375820530806907 ,  1775407873609319375 ,  691621700642144649 ,  1806458360821205820 ,  2160996115051406035 ,  389027770783105473 ,  520923895931643460 ,  606968148779712152 ,  1425898307807669787 ,  745208797723242419 ,  710754700066447108 ,  1649281468794321570 ,  1174448513091061759 ,  1719026750662352330 ,  1948290436201793653 ,  842241790630684547 ,  1518461992876811443 ,  412803094024791182 ,  1894240616524882772 ,  1605650164641082314 ,  2077316544046287719 ,  1016017820010065971 ,  1736683045852764215 ,  444309409780722878 ,  2072922214554467427 ,  155187570554313092 ,  129693989625950594 ,  180275865962372791 ,  1341575282838390259 ,  129228306740920272 ,  445943153439643897 ,  1325722349151120120 ,  9842652127760615 ,  951960906461341284 ,  634549035673995152 ,  1559409759341884183 ,  2228815259812815516 ,  1660692265853607447 ,  1547601703440044512 ,  2137219290680270616 ,  1856115567884638121 ,  1018197471741113880 ,  1470733057055890127 ,  1860997912677753228 ,  2191069299577217434 ,  672703112810203875 ,  321758042182570897 ,  1371962291285842739 ,  2152136144300205865 ,  78944872702097006 ,  365763532258820030 ,  456041031490124390 ,  2098696910010223670 ,  2230861644620306261 ,  384115678943400050 ,  2280861450313649261 ,  35171446182301465 ,  954675340973032266 ,  1817946538989711762 ,  1118288074378751196 ,  1727277285900772084 ,  1164435616380515992 ,  1859554029175479736 ,  1824415996301344765 ,  1429574569351545497 ,  2038933516875767403 ,  1378233332268242620 ,  414770015210824707 ,  1102906406097309945 ,  1591596214262472406 ,  1297117401533701568 ,  1200907073007473485 ,  1762434929035546060 ,  170861301978168945 ,  909497407405618125 ,  444099368126139612 ,  1945454416283586395 ,  1939409256413233317 ,  385868404744761978 ,  549878694502576594 ,  1557006485114088963 ,  900633613324654801 ,  1782485002060420937 ,  1200032831733310752 }, // x^2^621

{ 666418193262276415 ,  343498303021673603 ,  40558473590009060 ,  55941526080853015 ,  15679723346870307 ,  268991629135884312 ,  1358214672190953053 ,  1109877256769970116 ,  1185910783997550050 ,  1863321405336832851 ,  706124303012568146 ,  294372463481881584 ,  1202005425722083986 ,  1663513730800120514 ,  1828413513182344110 ,  1762688464911315884 ,  209709555771031389 ,  1940587030858938307 ,  889029404100895606 ,  1680440572121681970 ,  547703933296442322 ,  1331015872091541070 ,  803992753288870965 ,  1121679274310444785 ,  2167613553435936085 ,  1159827613444441898 ,  262594842095758812 ,  1361604811778383727 ,  299349033945322451 ,  197289513009595587 ,  1444336131697770714 ,  1713578710959296163 ,  1844874153617965792 ,  2182676917963116394 ,  300042966833287868 ,  89249424527459799 ,  2031216466935702001 ,  956677381775680090 ,  989139674509060138 ,  1645516813456030611 ,  668225042957304241 ,  2144293462603636887 ,  1181594416763443805 ,  1597552595637166367 ,  2000369047237457243 ,  408310837012345157 ,  1792699439758832113 ,  693754648497224049 ,  300483597051640214 ,  366565038174622033 ,  678505798196921133 ,  702693819497707762 ,  1941241801333099978 ,  1467391439260339777 ,  47630721779946486 ,  1339147185721993170 ,  183977360239939937 ,  1993457703106337979 ,  470114333278457767 ,  1554109697726551900 ,  179951955870116449 ,  1936099376819577945 ,  183579792708625410 ,  1022405502339410961 ,  1169169713667424811 ,  611887179075456035 ,  2081917707098907061 ,  478373812198499899 ,  1513708147256117146 ,  442028620986482186 ,  2117355179124325857 ,  476515987329360757 ,  991101176622010931 ,  1108522847122303562 ,  2065852931631887652 ,  527714647145143233 ,  2103347961362219187 ,  856543249140582636 ,  1218997573564723830 ,  2281640990992494045 ,  1691946388851663750 ,  50677771351207426 ,  2031777782945266334 ,  1244203738764172354 ,  1083595547864353911 ,  378609608205343268 ,  2179313838854089797 ,  1833953382369760830 ,  1287403094856342900 ,  212904088466909621 ,  1154283631976125943 ,  1047572865202168625 ,  957431013464319054 ,  1163521461702140335 ,  1564228106492601064 ,  1438339205451154230 ,  963063778872772205 ,  2277687252271781671 ,  1791696236905864398 ,  1150909732846732828 ,  1222413912660498282 ,  1892944128797852472 ,  21985694703205464 ,  1798264965436312661 ,  650047191069287455 ,  1278700216923370985 ,  41163438955142999 ,  305543518230285648 ,  7186985776996699 ,  13423053090203534 ,  2157131863765719427 ,  642973839361268674 ,  1319649506353487432 ,  712530823619279288 ,  1928823603292617089 ,  1588466282202526258 ,  790662887723296727 ,  1580024808741175413 ,  2195893962884091742 ,  2285888434767661422 ,  912024075568789582 ,  275091567526278031 ,  1737779209838539671 ,  1726983555429300459 ,  1189542964515267074 ,  917417465860372974 ,  2128006722311054341 ,  1655106869670348105 ,  1331717616936191881 ,  252275332711966806 ,  307348589604067589 ,  2062435263971548455 ,  1013643468103012999 ,  1615872692650826635 ,  186984717580641272 ,  150641129132955883 ,  879667332315637246 ,  1107684476930515992 ,  1969929490836368275 ,  93071128880732777 ,  65690727819212460 ,  433479996117116312 ,  1420506936869783274 ,  1486458539128819383 ,  1749492596863831017 ,  411003455989755632 ,  838938156294065310 ,  1093721778230414290 ,  17103287961015956 ,  1185229726004507151 ,  1243548833843855337 ,  711362173737934551 ,  1129210780379859079 ,  634659412741195997 ,  1251809544446542500 ,  591059228220122863 ,  789545382205586726 ,  2298025901613731878 ,  2138569439267383401 ,  491330726262906658 ,  785571002183967621 ,  1639633545457749375 ,  65854212973616690 ,  691608681969984387 ,  386783949158273421 ,  1138532854047003382 ,  673178004219135980 ,  1341396085761338154 ,  2269464516978130075 ,  971449790748018199 ,  176187176580597036 ,  1901472111470233280 ,  1563131223133993240 ,  1345805911227857402 ,  937136518125811776 ,  1867617314409831406 ,  343682756072728298 ,  690632955040230392 ,  1849066031554451509 ,  1631105197949179482 ,  938884397054636590 ,  1644069989141156897 ,  1217459317684755832 ,  1781904284580577919 ,  505798549572259636 ,  1857625873931668530 ,  769106419692430955 ,  1521398037477352760 ,  1153485210473381854 ,  368114826412898225 ,  1214068485447979004 ,  1157071060869848420 ,  1413137672155839933 ,  935629323420672164 ,  935199417818708920 ,  1666490898948051473 ,  2138393329998946963 ,  603148961257859246 ,  2207206308134114913 ,  328195979296551324 ,  1220256023886783389 ,  194322371071599927 ,  386279676484232236 ,  2168500856415391169 ,  1265211556043979699 ,  2173343773534157484 ,  692769676494422167 ,  164173945410603106 ,  899627743757563274 ,  2273122515674587413 ,  1678765268129544117 ,  39233368705166274 ,  1244704708476074951 ,  1740588302230047430 ,  1859030661030202241 ,  2287752457320308726 ,  1863059069829625904 ,  1134181588293095102 ,  2229289638255256407 ,  1390636525565960591 ,  897703927071343966 ,  152824866082523976 ,  452413137295853312 ,  1136125578899600056 ,  1022745641917075934 ,  847619386721925593 ,  112894835894400160 ,  74473034627067198 ,  1392512829615768713 ,  519403913404203407 ,  549701775197440367 ,  1981163802581481660 ,  1540725035995136680 ,  465275882798205878 ,  1723615218353389251 ,  1660090505015822690 ,  241640913440537393 ,  85074249089090899 ,  254282614857180340 ,  1158068190565164546 }, // x^2^622

{ 687958790607750434 ,  1329430008659004031 ,  1624488096435706055 ,  1560523645280824374 ,  958970993966773729 ,  268512387840126615 ,  414891158648181560 ,  1989011966070665627 ,  615519311115882377 ,  1661654269769074856 ,  1428465332027997729 ,  1140167596082987672 ,  1923893583663899874 ,  1409962322121801252 ,  38038233853381247 ,  646886108894893050 ,  1887613608390710129 ,  2105360737611902933 ,  886742193742945891 ,  1700182017065052816 ,  1498353007359918103 ,  594533113897595327 ,  1924545926501965919 ,  98842142578936748 ,  1708098251109023835 ,  1694118816471352765 ,  939838491184671754 ,  1728137457553524565 ,  928404470513224228 ,  1212768465227692329 ,  480018947186272724 ,  337768289966233821 ,  2262154840865506848 ,  1795613933672396497 ,  895151218480946712 ,  1816277686196635397 ,  2013938506788779778 ,  1870701841644453148 ,  1719803600706192927 ,  1644302406681972754 ,  688459911110757395 ,  1664622140958457343 ,  1506062342432653694 ,  2293947517282635998 ,  1397575582884532254 ,  1486002956973997851 ,  888160909823046477 ,  1660228091460638028 ,  1984572123444750721 ,  1054062344338736436 ,  1341041618929006714 ,  1573670320710229308 ,  92231631870944936 ,  1437447627029899402 ,  1442229674894326556 ,  844917550967468428 ,  2023655060848625342 ,  772171145508734881 ,  1130710922743260752 ,  2030943739091877465 ,  18776684143246415 ,  1685227008830028645 ,  798562290970275831 ,  950094527699369072 ,  350463173530202452 ,  725234066792871697 ,  1475674146723109855 ,  526011176790585804 ,  978045076983746047 ,  587110414654418309 ,  1711594571489388530 ,  1342052219734768477 ,  1895125952707350831 ,  817306448872951092 ,  238106871063713445 ,  1461055914010345366 ,  2068402231099815692 ,  1229097513547936078 ,  944111534482429303 ,  361795916608468357 ,  1144961000546639155 ,  1419248949197111803 ,  1867656041325636931 ,  2205537100874156705 ,  1728189097855468776 ,  1585338221381586505 ,  1797413698879189213 ,  2026124480649616108 ,  1791396442876014366 ,  684797748426431394 ,  299510733313352881 ,  1232889484202322145 ,  1595725999837395498 ,  1821476800255072289 ,  1726801283319793742 ,  1078388483613429746 ,  2179951850398580748 ,  967117454123248617 ,  521537944693684413 ,  259032368804107920 ,  1712568911308561498 ,  1317305998050784396 ,  2009666233765443220 ,  680103269494609630 ,  1440533930619877001 ,  207841593452439160 ,  1329336509218881156 ,  907577198791885935 ,  2201484715816618569 ,  2078514094084220200 ,  631242805000409065 ,  2283432061352925313 ,  1886805790639365141 ,  1740352765996422899 ,  519511910158506686 ,  1906794780740236966 ,  1499601491637540585 ,  2010099542421082326 ,  776693314456874710 ,  670089719534738331 ,  2066014280688353973 ,  607433710159487585 ,  1236579070734722798 ,  90435479111379880 ,  1886481955452841389 ,  1061636604311751835 ,  958300853883701314 ,  2068710242829536409 ,  826447470412582358 ,  1982825478495555782 ,  188322618475422486 ,  144060945502916915 ,  2151413825939753959 ,  717654133532165394 ,  1643238395176893917 ,  468897324255277583 ,  2035933271388424228 ,  674848603571998379 ,  807642180919966256 ,  1972527647874245632 ,  1605645489957523986 ,  1770279705638631539 ,  415643189752737902 ,  431326307077588087 ,  120891717673172027 ,  1314977844903981577 ,  251003770879221544 ,  2043569618209983598 ,  516931554326013498 ,  1501566870081719183 ,  1092201432276586958 ,  136471590392791282 ,  843057521801677907 ,  642311272465741251 ,  1900290523653369279 ,  1782647456436002796 ,  374725685538649171 ,  2046775135754202891 ,  421445713424852362 ,  1267082650375041696 ,  2249006993638583460 ,  511358428968938072 ,  1651943383991290092 ,  204899312718553674 ,  634833535711180643 ,  30545073775499568 ,  290109226338052552 ,  644558037105686118 ,  937743137790478778 ,  1397145529360503468 ,  1630025875875963630 ,  1536422773052553282 ,  993197904071807741 ,  779988507443386895 ,  1193228815757673326 ,  243947115291833093 ,  1373606305550078035 ,  997454302487611931 ,  1152855812597997880 ,  1935097303958271051 ,  1876940227551185684 ,  2058161765202804324 ,  2300728461049129665 ,  241833871120650482 ,  1653558583559064785 ,  880814684955653897 ,  1774554712912487266 ,  981575975007333399 ,  1910787445520017176 ,  1460019391917410463 ,  417920513819277274 ,  1741061296048732009 ,  1430830059754354456 ,  2195091617731984859 ,  1933196661627377054 ,  1938591714206001625 ,  686763500420539211 ,  822960074312487649 ,  556369743569831777 ,  194000528548911304 ,  2070703572716976280 ,  1734385758651248918 ,  1224639801620759609 ,  1891946863298402507 ,  298164773528048292 ,  296378431077584154 ,  196467889907755613 ,  639845841505113646 ,  2232084463091334583 ,  2043251348348835993 ,  88096266607772280 ,  1060595519675848501 ,  1501653229063218169 ,  1245160287920678813 ,  499283241663437284 ,  228336663962851568 ,  828446935691071505 ,  512662537538111139 ,  568807651899838143 ,  1917029726688581899 ,  476579715964340510 ,  723180112741826737 ,  445837300843183589 ,  1625627572848871434 ,  1109782792105874094 ,  1709500310208560467 ,  238899001037606163 ,  1744927749463727394 ,  851325213000353736 ,  1007917219475018452 ,  2216273710407102083 ,  6281967201746444 ,  1014857623839807919 ,  561419052576992323 ,  1388951683656312646 ,  2272630736925592542 ,  139775188207874987 ,  1375219035113773023 ,  1154404508917680588 ,  955624432103175962 }, // x^2^623

{ 234874261143580469 ,  184569574400088140 ,  694198080351710133 ,  2162870071385801032 ,  1402931781941079391 ,  2244887643871770879 ,  252226336345970490 ,  712272227497516450 ,  1073572418083108548 ,  1085739852707604868 ,  2030133204991736977 ,  2233265895958850305 ,  101858677189397363 ,  1767706012630900387 ,  1938697670746382458 ,  1117758965339558435 ,  1799327107519450458 ,  2031906762936907290 ,  734098638871659120 ,  305695701010115634 ,  2086855539294400158 ,  1321807023285474602 ,  968925105447548234 ,  172101924561791958 ,  169566632835655438 ,  1156358810829507274 ,  2094015568903048323 ,  1248431972709721919 ,  188102637281332180 ,  126755072786972104 ,  511267324225343524 ,  217678853095015268 ,  36719745035065619 ,  2284043732825242819 ,  2210322607195913949 ,  173999758647598245 ,  1663118433819931761 ,  428930446312013 ,  925010534735037542 ,  1383971419895281376 ,  959440536976969830 ,  1315418823107796760 ,  1743055642050804071 ,  593464224405570280 ,  747398787156929776 ,  1109588158387624072 ,  443338783739069763 ,  1509704386366978958 ,  1445086948941862549 ,  1174323084993377169 ,  501670680253509949 ,  1327572618424718197 ,  2252047170561874884 ,  655528916210077927 ,  692253723261662877 ,  1564623811848986759 ,  2042768924959863591 ,  1997449069366488950 ,  59955060841130425 ,  1492590469879434864 ,  2141813272938547585 ,  1005189803721934835 ,  935661366408881694 ,  1640787023689478770 ,  404390647432306945 ,  150944618191210069 ,  2072768512595302681 ,  1410787863947777451 ,  2141334412012394318 ,  2236716649121212715 ,  1243154380641707001 ,  1449205990171162300 ,  2278784721298595531 ,  1983840244242035018 ,  1480543847946980932 ,  728175574196456260 ,  1750234169059819414 ,  805630982538448568 ,  1660260043871344638 ,  151645728738250027 ,  1965121711104788793 ,  2000302196417416797 ,  903006989726820831 ,  1773885559373482637 ,  1715963859210353442 ,  243842153416824901 ,  201174020312241755 ,  986384435503504555 ,  244208177608414121 ,  1120892560631336257 ,  1881663919308335036 ,  1453310694089575150 ,  348878683538416527 ,  1506962850864998808 ,  1513995681716502260 ,  1775770010207852655 ,  1580006669758019552 ,  1678160878022177817 ,  1518509299486081723 ,  1824836173509996521 ,  1456046571244769329 ,  1484128044320174783 ,  2156408636331702085 ,  2014532072660952028 ,  1824469077909245200 ,  1054830575563946983 ,  1433671280673843252 ,  1588282919555356668 ,  80718149630819791 ,  1765642157950784905 ,  258536627842495417 ,  1036975666007332456 ,  861571815378023825 ,  249286952382396449 ,  2013622987959031034 ,  289113201439407069 ,  227782441837900031 ,  2032614130339466350 ,  1761885202434523689 ,  2126843277382240838 ,  2239316569657088040 ,  2140115451253053745 ,  2292364110329844157 ,  2019625434946554468 ,  1279730002344897469 ,  142392074275077293 ,  1085821488990214647 ,  2062158737115622416 ,  604280148744934027 ,  90934663123562011 ,  65414630793340686 ,  1800924295582990164 ,  2014061202107405376 ,  559059745763546389 ,  993747044636675196 ,  42227796622925746 ,  1663728669980404715 ,  2262944987433385590 ,  2210215347480209463 ,  1230988682967245693 ,  2125414252537982780 ,  358178561834365345 ,  2040653658129157438 ,  2023849721207664018 ,  2144637697617588840 ,  1199133780077510080 ,  2243095206816632456 ,  1770133786214970062 ,  1910357163387622505 ,  2166801443587744702 ,  490136771748953965 ,  793100406517361146 ,  663115889949544466 ,  1370615206271706220 ,  1831340638803744947 ,  1350323293941258806 ,  529403249017942093 ,  1640521899373270431 ,  301658162089750672 ,  1506609059176410253 ,  834667598862300054 ,  992531294431651820 ,  1022822434305058749 ,  22347413388277400 ,  589582190837423385 ,  241776907402465980 ,  589063930437701596 ,  2036711226479520912 ,  1783283899884357184 ,  137595350255190905 ,  311668635254754865 ,  375778112012347719 ,  222787806328499403 ,  1426455977300339998 ,  708778739772560357 ,  1939385521322216301 ,  1504715278942658916 ,  362846353613854925 ,  141320778790869470 ,  1617940560677054445 ,  193514642933683367 ,  925803259330398445 ,  864391743223291334 ,  1013956346768831632 ,  314541478189083792 ,  1388439302820407966 ,  1265567376890876115 ,  1164698149519597315 ,  1454376616232082454 ,  66900980711415330 ,  148074877005717753 ,  2141646883078248809 ,  212519311817015458 ,  560987461900361202 ,  1146499170355758134 ,  1226316155249659066 ,  336792247155918997 ,  235900036132007924 ,  529107021299541085 ,  1522177380531543900 ,  1738670327393177905 ,  358362960197797914 ,  2171306999349129366 ,  1812266563893386273 ,  211973356294790214 ,  512432219097406866 ,  1139026356884468043 ,  937921615804571423 ,  1754703575716196802 ,  2129804845462874666 ,  2158802851055970395 ,  94272132576893195 ,  508410563296375412 ,  1989449957005071309 ,  1202140186079085189 ,  810223889201240472 ,  163962246937042254 ,  1449471085931972142 ,  1032837336820309950 ,  1311900382216134400 ,  1629023307133228501 ,  1403297592468176914 ,  1999508456458110709 ,  1207506088376600224 ,  1230073428127061422 ,  1395807148355448253 ,  846858575522860753 ,  277332764092747194 ,  403428841802779305 ,  493028912350485624 ,  1798828353503134164 ,  1871467912683771137 ,  1232612135658622061 ,  518855616535169218 ,  1476417902323989322 ,  1638708695148027167 ,  536149635329757367 ,  1049287866203606072 ,  758714916050217818 ,  2226439721452503034 }, // x^2^624

{ 1409760975739695860 ,  1100450424368296448 ,  1988165219272540067 ,  29463221614297961 ,  1805945788486623741 ,  527459999673140464 ,  348902631493453404 ,  1762425582172492499 ,  166375916055732336 ,  2234646108896099486 ,  666991908918195773 ,  1674748879522254571 ,  1099182770257805125 ,  1753796340604590777 ,  1191096269487263109 ,  78021342263452537 ,  90651454909551395 ,  2031533326679746556 ,  1381264085072487871 ,  374580870821040250 ,  627343545686985278 ,  1113648290703353887 ,  237260125057727351 ,  300862149102496834 ,  1386054643378594686 ,  61593059291152214 ,  689766141517706250 ,  2133887508237303227 ,  2266555054887219067 ,  480459543955157183 ,  296619616683553909 ,  1166868660495126677 ,  632423537164208384 ,  284157477856649237 ,  797875080538202834 ,  1725380889949244917 ,  766714087593260852 ,  999677586106048141 ,  85693917208883204 ,  1631855785757129617 ,  946860299624655877 ,  463147224189708453 ,  654385947065206438 ,  1598812551850914744 ,  247279854267570710 ,  1666507325254801831 ,  1742949432771806683 ,  1819276367879593999 ,  1367278268392654078 ,  2000553029886760046 ,  593405621958736695 ,  1459490577657385161 ,  1650937169997965655 ,  1215675757716738062 ,  1105234929838615003 ,  275816826552827758 ,  1258000592804089326 ,  1346567941423780369 ,  2224017302534482662 ,  1457276601174150202 ,  1245996474103080620 ,  585291253754937905 ,  1776655863309317173 ,  2011332895853705148 ,  1839555651055912791 ,  279750251992264475 ,  1372733066156628840 ,  1195262328096382195 ,  2166588908182071829 ,  1908999275578791582 ,  316105197492702785 ,  1217880111969273192 ,  1498952756828228356 ,  1366617199984765948 ,  2112844440352800578 ,  2064488978752387122 ,  2199771146152120222 ,  487303052485972573 ,  2106293004761036469 ,  200855674342201228 ,  2010213218306409117 ,  1216778816415656605 ,  551777345290748129 ,  789066734366537899 ,  2086354383340507332 ,  1943788698160053360 ,  811854538146309717 ,  506495187838140435 ,  1176347629430579772 ,  1318324177888779630 ,  1713275126899131644 ,  901230667458904630 ,  1180075068428489202 ,  1367589714048721635 ,  1083929720262465117 ,  1722375947149499723 ,  1485365800981134854 ,  2114705399057215619 ,  309134521007561847 ,  1989366946948232434 ,  1258055827482406774 ,  1411434119712975081 ,  520368626453867816 ,  1795206536608429879 ,  1254367745990629277 ,  407629586289725603 ,  481439364941583775 ,  560113321047370023 ,  1160240167750572669 ,  2189865854716548316 ,  451776995750969564 ,  1786572440966511206 ,  1916733929516012697 ,  61770570916486420 ,  1069710818071277270 ,  2302031791048972402 ,  62138462334696943 ,  766545518089448633 ,  81897677161986697 ,  731535743643705205 ,  2067100490172901645 ,  1756357768423760255 ,  2251976402047789082 ,  333037341118180632 ,  1086425128624830726 ,  1262279113807682293 ,  901686337567294395 ,  2258269735325366190 ,  17439249238835493 ,  648298390178402771 ,  1306421261245276361 ,  1137786794309084731 ,  2106523007901506175 ,  407830080768391565 ,  823401880249366305 ,  362354527033567586 ,  216987888091098449 ,  1433112156117157709 ,  2180573582814503044 ,  1984939840467614567 ,  60572694198529665 ,  281579856904980715 ,  1121346819189184808 ,  345078611929930338 ,  2302168888371529833 ,  1058169083092841981 ,  928740015674059737 ,  1315617760346438911 ,  1435544594286220968 ,  3910560841170197 ,  2169459392944906537 ,  898283237598264402 ,  797193227829703690 ,  527968148887861786 ,  1076485986006053649 ,  2090943764501650389 ,  1091834623894275151 ,  1944493970559919011 ,  1578857704551334455 ,  1385009163092460029 ,  1210764750412584523 ,  71964501768456454 ,  1267882288638367181 ,  1142182635699712057 ,  907142616679419521 ,  1657917168343308243 ,  1730849973613506683 ,  894239242468320704 ,  849853373047227377 ,  507751871984004643 ,  536620481107705530 ,  1028492633587453755 ,  1676782310636628389 ,  1489631555217381958 ,  1535307841701346507 ,  1652162781578246371 ,  944927148546642085 ,  283235197913449382 ,  2229011768295975149 ,  2104400092523295645 ,  1443523548776664253 ,  2160287594200958727 ,  1535779980668151554 ,  835513185598265941 ,  500301470879802109 ,  1652156156512031185 ,  2043668901846828956 ,  387332072139696256 ,  1839228931935348967 ,  908908232699524961 ,  1793929099851167855 ,  1315628343555811529 ,  29839668311189449 ,  212907920939680296 ,  1931040793573965802 ,  1654937542385449162 ,  140217814304088695 ,  118082768342632928 ,  1917736381144240032 ,  450847565219126205 ,  2185351634999283884 ,  1310646054884559186 ,  800236881412484408 ,  1027557743546515790 ,  1129411548215889263 ,  641153525484021117 ,  784052543153472440 ,  2121796509941878285 ,  1248082578559287115 ,  1254554047470408124 ,  1108859785811268668 ,  1237284843634748071 ,  518589040364508679 ,  590452456769428289 ,  360270915120764833 ,  302455184058378601 ,  829088903711254073 ,  530996583278087598 ,  440392503481537834 ,  1503786688721635245 ,  58177207533655303 ,  2165901485746311380 ,  1737658582122938151 ,  925761901669917303 ,  219402003195718941 ,  245165262423545066 ,  2292151741175252739 ,  1468765695840240840 ,  1079172941723394396 ,  978332048304216635 ,  394033150839442703 ,  1126234624151980069 ,  1198417974461353135 ,  1829145649005644007 ,  1289923680175873838 ,  1778818190543378614 ,  611952308409101978 ,  1661829481649197733 ,  1015944235321284199 ,  1818176469439602429 }, // x^2^625

{ 2134189586185845501 ,  580613839518061626 ,  465666968567842057 ,  1482931564604042311 ,  2047361438937328745 ,  31343123139390785 ,  1878017303194094317 ,  2099068702498194229 ,  894232773622352220 ,  421450479364414130 ,  1493018995295742094 ,  1240711824875016562 ,  1682011324634025095 ,  677195464384561995 ,  1889568147544820618 ,  528205936329308028 ,  1672255693019130445 ,  620127595305234350 ,  1900765053111447269 ,  1725704073280908801 ,  613913323889263618 ,  1890739128465091354 ,  1179597718380553094 ,  2205589602894911885 ,  1320805886123802139 ,  1435409023063290249 ,  2230760919963985579 ,  2222658963634127364 ,  251246514299944530 ,  65623327331599296 ,  1286394491257475305 ,  1768799862584621377 ,  1423240945835564862 ,  112718446597273031 ,  504312556297507673 ,  253130521277759223 ,  15505537300912229 ,  1784619818694930635 ,  722202083188164566 ,  11387648174137888 ,  2303268553101674664 ,  1923513002810381825 ,  214303102462752341 ,  353594375004484866 ,  320455478238205587 ,  1638672438248051740 ,  268601581524218726 ,  1861853595520969885 ,  363915525489375436 ,  827923681513585164 ,  911866756604647674 ,  190542042509998187 ,  1054666819204321662 ,  753207449420359559 ,  980786416250368436 ,  600906005824944927 ,  1797390395663946878 ,  1805118664426268101 ,  1614643605016362908 ,  1396720723330587130 ,  1324997168705404776 ,  1381203025026398694 ,  1009193980938080304 ,  786153357743467085 ,  1968126624559875240 ,  2299203056784302807 ,  1888635191182564421 ,  1731776819342708266 ,  946326371469410660 ,  1055156631259502283 ,  335452099935382482 ,  599003738999446332 ,  2225965039709576213 ,  105118155800758512 ,  1215605262746675377 ,  1957163072364802273 ,  1839183518663478537 ,  1258319910997824261 ,  963737292503604203 ,  2208363489570457334 ,  2287766642581051483 ,  1939464578053506731 ,  443392721784045797 ,  1879308920594207355 ,  1195826658201470918 ,  1532347894157342405 ,  116118107892165615 ,  1630127331189325456 ,  10470945284075980 ,  972001438833571920 ,  1722144971938315048 ,  842844320759437087 ,  1630594975149171963 ,  137037621256212706 ,  1236231858911099913 ,  919885015145275142 ,  1311228507355030977 ,  772382631526598314 ,  802279604013155314 ,  2270404280412720502 ,  605526641835289158 ,  75975741748004002 ,  309792215907012744 ,  1349052741233068526 ,  1139549055209696465 ,  919737006908646086 ,  902561591590633928 ,  2169491004211592672 ,  219469952678897053 ,  1370486137047427346 ,  969613248950204294 ,  2100046136531862699 ,  2259679473206531676 ,  2154155632952679592 ,  843251139526587039 ,  643041180446820611 ,  668330518529729861 ,  86662121355453416 ,  2285703245967928971 ,  409299629834988959 ,  126331648041986076 ,  1398366854706449732 ,  807556363004415811 ,  244779394047910477 ,  850379768506054149 ,  2193434174555511082 ,  1354186224835824003 ,  951945226009788549 ,  1284372553893335221 ,  143803197650663588 ,  2235807739249630619 ,  1504509158373045611 ,  1395137544755550583 ,  977764886693304765 ,  257502549916758227 ,  1426184705956740865 ,  1499003103707347580 ,  442642636009898917 ,  75891896353636590 ,  1889471366153380201 ,  2251127193333823654 ,  1548271768442846467 ,  1426719600761853988 ,  1963963530658351840 ,  2264854150520684354 ,  1863308975798302925 ,  1987814826948486459 ,  1379105379520294650 ,  1495010404612951726 ,  889841746082673937 ,  698889537448603466 ,  1551741804405747076 ,  1012492015638720577 ,  2203785093004893320 ,  892048473097176241 ,  2249699403620272540 ,  1020397167939386822 ,  1969024279222892773 ,  88590610097288680 ,  826282444166370525 ,  158926001049821229 ,  88216952270914359 ,  1369284393021154178 ,  2121188823886350438 ,  1486293688684597700 ,  1749290639026307730 ,  2236887814744821159 ,  669557279964936752 ,  1588025568909220081 ,  688688023072470198 ,  511360306717888662 ,  371328613316857907 ,  1336181839920531110 ,  1195696688311513698 ,  2252948763505354475 ,  2214835845417062164 ,  2192849509926322645 ,  2225661152800014140 ,  1936171181369351672 ,  24021891676171733 ,  802173841848789764 ,  145375002584544535 ,  519479828638560077 ,  791718135364812411 ,  1839406270280301467 ,  712611666234350821 ,  1656323172610306033 ,  505188534253643736 ,  1552325659970402259 ,  469866758079642001 ,  2150850668908594238 ,  1523614220181753618 ,  1440978753174669618 ,  1256352480351844554 ,  2147225955336694921 ,  2119599910001568644 ,  1951077918542590205 ,  1441662936600421281 ,  1924986064547788100 ,  1085968025959479955 ,  695621890511165437 ,  2213834380964840543 ,  695464610381191515 ,  1435190542037857148 ,  99461758567395536 ,  1375221346563798969 ,  1033491701130085963 ,  1517446065928743306 ,  359967354209141111 ,  180554574352880726 ,  322896666208509988 ,  48165519774989598 ,  240701508510065670 ,  396613947222680829 ,  333700496465526948 ,  1418873746500323090 ,  593991318254607978 ,  1609078392936716404 ,  2288627974493938300 ,  1852752031263526911 ,  1596604790393395367 ,  1515127558865486216 ,  826258623254494345 ,  1115755185931567376 ,  826890596735703828 ,  268417662687681763 ,  1871031547294103787 ,  954592788896781830 ,  164698493508057153 ,  391730485580727103 ,  291460012147200275 ,  1767486940850613735 ,  716252128683761379 ,  1651423164876444250 ,  1667333989297149555 ,  1713756193606089819 ,  47699803775400758 ,  1906922176009136958 ,  1059323159274995677 ,  774093828642242156 }, // x^2^626

{ 75635917719500452 ,  1925233348711383931 ,  941719697033190898 ,  1058927488747061060 ,  1770601764985616179 ,  969598238426192044 ,  1389064565996594051 ,  2209182876346680935 ,  740546765289764282 ,  2047243818569589217 ,  642880568289943182 ,  903614546549976951 ,  424215856903423212 ,  1591561696734418598 ,  1189174200394892512 ,  1375251484224768327 ,  346570930944492774 ,  929919357599915488 ,  75007703625071090 ,  1324696940781385054 ,  116204606369784488 ,  2115615275075505222 ,  711745824419623924 ,  1735587328775122565 ,  999606067352890220 ,  1800549799368331025 ,  762545755846486306 ,  645255633699629849 ,  953102120067423274 ,  590763724628005846 ,  188760346056553170 ,  2295631405270392666 ,  1229307209614647331 ,  2254502463018143571 ,  1620108428393649653 ,  715209520066495313 ,  2202888061782706678 ,  2197344896680826042 ,  1289992336271624239 ,  228016731376472078 ,  364346534958001217 ,  989844722701617689 ,  1375469271662905726 ,  305756745246096861 ,  796972093718340689 ,  1150216182209842103 ,  1354609732519356714 ,  1505359404193621255 ,  214484170963115400 ,  281294396392044440 ,  466560775178938031 ,  759805678035019043 ,  560672848398794879 ,  1401610253694762202 ,  1811291765674830727 ,  870114951356497624 ,  1807059901400806366 ,  206656273337265836 ,  1222062225536886252 ,  2118643573813272720 ,  1157283222343653011 ,  74493757310071654 ,  907976282812210739 ,  414550412127740131 ,  878616980383949844 ,  1399714849152059629 ,  1808042230744403156 ,  751770498374501536 ,  803043771641290616 ,  1949154120829472652 ,  285569810065339316 ,  1441018777183494937 ,  406666848211791489 ,  374506524928716581 ,  1790972926203486191 ,  641280181382485586 ,  2119648124593352769 ,  1149915335438613584 ,  25722425882316540 ,  1390910113008226578 ,  1668966005435555391 ,  1444671516529468081 ,  1982950296756190032 ,  2011244388947601167 ,  305179033503799366 ,  1253628664251001928 ,  328198526167933043 ,  1230859263088158823 ,  588406958377168174 ,  223200116286143877 ,  675128002365580807 ,  598930818871433931 ,  1866616422117100502 ,  1884568656832277081 ,  249964218073036859 ,  1103239190571345950 ,  1452247363032979097 ,  378728875696557248 ,  268281065818709954 ,  1231475445493806456 ,  994405743175072705 ,  2233326765260312222 ,  723624585044815865 ,  334903530414913995 ,  1879586749694181225 ,  507306830595188788 ,  442888131015656486 ,  50432578424933927 ,  570569209857981269 ,  1743736774995387192 ,  1276025515250079199 ,  2140538595444759934 ,  574676247539325435 ,  1980626017180614942 ,  537549154178011217 ,  1381543938228576739 ,  472586848710350174 ,  776458041895095009 ,  494960626802925315 ,  732187046384808045 ,  779537195139605637 ,  1184787460767356181 ,  547529287993898364 ,  990257773314272422 ,  1802963944874977544 ,  1803306941355706060 ,  1559285690958177772 ,  267871456721003089 ,  2140448943665284705 ,  2244448360410490859 ,  2026372528446507931 ,  2125393853733410342 ,  772496477824448000 ,  539346354438798387 ,  2024669312357219496 ,  547263914111016273 ,  924936330033114853 ,  2226765683835737691 ,  1419886746801968383 ,  1178017965228540731 ,  785674568835933529 ,  831582938431072878 ,  943588793148860462 ,  1462147688894610073 ,  1210956593167409650 ,  2240190569757641423 ,  1311090648163133251 ,  1398923868564400887 ,  412745890030832255 ,  1455668360670540540 ,  1591918109647923512 ,  1589799537477802661 ,  1347163955756389695 ,  1540057230816354857 ,  1923149527898452143 ,  1247524408911679586 ,  190601898709947488 ,  1938177742933314353 ,  1800695622134860192 ,  458510225351739649 ,  1300249804410820981 ,  118772481120599760 ,  401038145284374981 ,  1025789246201347560 ,  49586160403072051 ,  1263064398941088237 ,  1618420403249028073 ,  1645667121541149684 ,  273902170700581908 ,  261582483162470521 ,  1970247229613484277 ,  2054815729502408063 ,  1356914498708072214 ,  1032871123519224131 ,  1543642077964102630 ,  450443152538127996 ,  2269847594154891836 ,  2170649211507388354 ,  681467874073113900 ,  333107569455094852 ,  436581819469857537 ,  419635523605991765 ,  285936494621955859 ,  1863335369177671797 ,  756823894565345036 ,  50195977880405590 ,  1687198518500570603 ,  1973364951781690551 ,  1018361882267097861 ,  162432910594058567 ,  1351882838178653455 ,  737049002304460960 ,  657481715655403048 ,  705661538305475702 ,  2285278122278934523 ,  1976087730746848416 ,  1881797101279635363 ,  2266533588159433216 ,  58486875755378913 ,  791282966509273194 ,  1775910008134989240 ,  513481587244338665 ,  1302678926225525216 ,  719306278479453736 ,  116581519640807693 ,  4064596728580618 ,  148854685513407735 ,  1134089882689332966 ,  160848935176833670 ,  2209676362883143710 ,  254601921899068977 ,  995373874111766494 ,  1615039203079342008 ,  577666899088865133 ,  2119189752998022988 ,  1806051688477413326 ,  1352681984684409282 ,  956722082060318890 ,  1262412525449351397 ,  2054723108873260558 ,  1189649014391215749 ,  175826590204950677 ,  1779493089617391111 ,  1938411106398862382 ,  1906712454039608691 ,  1234489616425666778 ,  1652794551165951095 ,  894266710454979207 ,  1734779872452825466 ,  2264712591825370519 ,  2176473674353142713 ,  1239262094511497174 ,  1202662940321535627 ,  1538490682596222151 ,  920399364166671028 ,  1211942417137087883 ,  1186216449541525595 ,  318720711325721350 ,  2303607991662018880 ,  799618645798068495 }, // x^2^627

{ 1540636221262062660 ,  1102479485246975328 ,  34309822371883701 ,  10625563176951735 ,  1457219342924695032 ,  1979697139045345741 ,  64530595171487474 ,  1944243593588211465 ,  471147586162292890 ,  702769313372443642 ,  1411901538614702256 ,  1879258847395029056 ,  1823165955414145773 ,  1837744797838498013 ,  169928465224738524 ,  124751169898772923 ,  1837679450270562637 ,  1254676920098515865 ,  1361991771705280302 ,  810300468309732054 ,  404202354076847271 ,  1721952203712941479 ,  1799396258266873123 ,  225671746451542800 ,  816828423689362364 ,  1697337109324362320 ,  1828757086119937579 ,  665261194577490545 ,  1707451233897810033 ,  1593681087802777152 ,  1580873733117524721 ,  636170233031861298 ,  540627931657231189 ,  1951336641257922644 ,  816334134699544608 ,  241709837695737130 ,  1613407193323119573 ,  665504962058176165 ,  171710905332789851 ,  1528508467950218082 ,  492065190681729844 ,  592424203738676978 ,  2044180894631256143 ,  2282540575014287602 ,  1547219933300765726 ,  530618587316283 ,  1080228510701021533 ,  1030989508169498662 ,  1187958957229619025 ,  422602654039218775 ,  1745367416935425295 ,  1241833872270320271 ,  1328484804399106351 ,  1907135150888675494 ,  371660218293744273 ,  2041370781892490546 ,  2072488563381761521 ,  927998219134789523 ,  1644236804162509849 ,  1253323549096038599 ,  921601876285891433 ,  1977211658466459404 ,  1467005815786890197 ,  2266718733213151552 ,  769974124598689795 ,  674785471290783489 ,  312986247693779062 ,  1723700034154890865 ,  1479677603122697822 ,  452033132880421967 ,  1665721616508759421 ,  231125892419539612 ,  1893949263440558911 ,  1748366656052643263 ,  1054292794730767075 ,  702323049492119863 ,  434554221290518999 ,  685580596387995002 ,  577523320535196282 ,  1202165105411751849 ,  1900018135003940418 ,  1020072961160531657 ,  1101823111048351379 ,  910039542790864968 ,  263719067498114503 ,  1576709913143323997 ,  1018736987815372378 ,  1698148162892531018 ,  2281991830460459035 ,  675875974371791299 ,  600691342722510483 ,  1509135744049328274 ,  1456840651005164398 ,  1205925982463718485 ,  1470801650324292391 ,  488582728051823999 ,  2187107697552909044 ,  2036765874089819168 ,  777529790596047182 ,  2042123150533660823 ,  1145111141601463499 ,  1321401105948084075 ,  1806328134165474420 ,  1360309121221881176 ,  2141538913068953600 ,  370472998792580751 ,  267467411749557872 ,  1591247888816235148 ,  803167412403829340 ,  1141201883093839531 ,  412255249818552938 ,  657845307822740115 ,  63973889850344881 ,  695132475446514736 ,  1294471445822921137 ,  2005113250486659936 ,  348895344477067794 ,  1802878351843682573 ,  2044270436330125623 ,  1907539875880566595 ,  212906164185023903 ,  2106468447223272716 ,  1921275555991669874 ,  2034375797788450251 ,  1688312214676256096 ,  2279798962446171367 ,  2285024181750006645 ,  1322387193186862999 ,  1991036920621144966 ,  2038975438130297814 ,  579354491209970314 ,  2260096449225634060 ,  2215693488614221514 ,  1650268433266808202 ,  844447763421609813 ,  101527661928989841 ,  2261264408843329370 ,  1101159626708361964 ,  929576399901452895 ,  886459844044264810 ,  877627332265913726 ,  721377761432919161 ,  2067261751933077895 ,  2070289774771951597 ,  843630447140501340 ,  1555411785789104727 ,  2287360552509814688 ,  78767114747773648 ,  1118064134333972975 ,  235344850856887957 ,  1422383094254888285 ,  767266687549170271 ,  1876390437199427694 ,  2070885536036126807 ,  823309240236878996 ,  1534248918928322760 ,  190529700367972849 ,  1784967032264704862 ,  632135283328765095 ,  1862134357424028421 ,  1108372925859081679 ,  1415022505550716027 ,  617257512783230473 ,  2074248733507353460 ,  1895644514719752952 ,  333561610349309757 ,  1788564446225383468 ,  1450099564701405995 ,  2102095275798924681 ,  1313957406997887944 ,  570325202597685936 ,  2111909274628952652 ,  2263891412002944384 ,  2280467744669934169 ,  247151876605792217 ,  241049953381016180 ,  1150671696427103584 ,  816468901031950836 ,  1879146096712238546 ,  265190293810119049 ,  1301228628378885101 ,  808764734126487728 ,  447117908734464823 ,  2194537407269486158 ,  2226767399201716131 ,  215787751843589779 ,  655002565207128639 ,  72944297737809843 ,  580703065385669389 ,  970926366373192456 ,  1978027953180058129 ,  601119203178064087 ,  350915206997409169 ,  1088460713593248426 ,  482278772895828176 ,  2256657257148738081 ,  159916022896574589 ,  256650547520650443 ,  1303614069020215931 ,  199173134624977768 ,  1550126426106989822 ,  2160074857420202747 ,  1488948434861835792 ,  908343171174420175 ,  1320556873791733056 ,  1883680038556059868 ,  683056637537371828 ,  1230293613884173114 ,  2229989768020949209 ,  2182515565072834912 ,  2022249117496929356 ,  2046108561080971106 ,  1621685303838856307 ,  2064259386814639407 ,  1468746063450711324 ,  1521080329528665846 ,  1072933992539752192 ,  931429193916235110 ,  58661313142510504 ,  656332524297163426 ,  2051665851284081814 ,  32123871881369284 ,  873220638859342509 ,  1366345390207249263 ,  222155340070874388 ,  1033104471586517676 ,  1089072756747527475 ,  947244322268567013 ,  1002219239790608097 ,  329809659894333318 ,  1037399235175069028 ,  451530301386567096 ,  1070468736861302634 ,  1822950889620393121 ,  1911479059747464968 ,  1466492128904532486 ,  2019683602434190119 ,  65543265227975387 ,  1891344918143535867 ,  1430569967863901050 }, // x^2^628

{ 2260421585793186090 ,  723656512708018246 ,  1868653208712039631 ,  894840555708266533 ,  928586666050516711 ,  894967214633262084 ,  499569818690592287 ,  2194782956895961297 ,  2233540489488533125 ,  1017267946135960362 ,  1542345090980668009 ,  699054884634735329 ,  1733461644962139798 ,  2054012198268068571 ,  2107957652762584774 ,  994567694012176179 ,  266909612123007760 ,  1278570596276979079 ,  2046300838885468773 ,  1139828815184101664 ,  1676425962069428207 ,  2078147362855650451 ,  1494100180099766429 ,  1717225273942204567 ,  1953465719914235853 ,  399481610123498226 ,  2072838313967428015 ,  249258157760235664 ,  230853795617470424 ,  440265820629962452 ,  1601506882078308472 ,  419377893828737762 ,  179465869288181768 ,  2085792463691548763 ,  1885304511159691019 ,  1838974178976528059 ,  1492652164417102640 ,  1919591711598313388 ,  1386887387195694460 ,  2145028103322315050 ,  1637411383870376148 ,  429363329383963778 ,  654030048650603945 ,  345484525108162846 ,  904469137288168004 ,  1012637363552263213 ,  496163283612628819 ,  1818805997141514872 ,  1473108245720694585 ,  1909965672091254790 ,  542437889135119711 ,  1639232830853003976 ,  1846452694999709716 ,  1178963232469433503 ,  981495476294077008 ,  273461662742663468 ,  210136895222739702 ,  2273348455533840719 ,  1305014637726605818 ,  1038493459043349871 ,  492549873014790641 ,  1040274777760789770 ,  1794342803821039457 ,  1214589235539123297 ,  525957682630264913 ,  1650008279478063067 ,  271999483963342230 ,  456036684364995665 ,  1308913871234151882 ,  846710537894607846 ,  1903716768329057252 ,  211897854891057500 ,  2138472484595949327 ,  608590573158968395 ,  532837310209793734 ,  1508137419309412545 ,  1382484203013771715 ,  419824546513616703 ,  892654076511258987 ,  480961753798411800 ,  2000476374127265403 ,  1652539805456260417 ,  1100717742735505944 ,  484928144313915468 ,  1036008734505410257 ,  455121665316025435 ,  878516851089727726 ,  1316318844529385768 ,  137683587342866493 ,  1476550880727651901 ,  703495182001061385 ,  127992352133373841 ,  602608481671716825 ,  1577088968756226779 ,  633965006185661909 ,  910868938882302929 ,  1992627813490516652 ,  583289597326665083 ,  1850058261947754579 ,  1770343037660550250 ,  1315867531965985057 ,  1908507971684480815 ,  72271139325131505 ,  567064451196874148 ,  154101805273977973 ,  1123256910241062665 ,  98449675516431327 ,  2214677626194220842 ,  537270009428711657 ,  928617154640832286 ,  784389618290847674 ,  1222982124247589525 ,  1686103358794712487 ,  1137142557865888244 ,  459834276865928255 ,  2194926251041826951 ,  1264282181294420975 ,  406385571303962296 ,  1053558177710105546 ,  71866645294077573 ,  327721640552096861 ,  370790515806225969 ,  1916990723837735698 ,  383743584491822466 ,  519049420695754241 ,  1223490492932629245 ,  1729519492682006340 ,  101854367947359325 ,  1860664881016683422 ,  1218842309628274650 ,  740371565216124922 ,  535806518509063542 ,  413255906098259782 ,  270233803970317498 ,  173180632969818775 ,  1270219206638751207 ,  1715218795979461619 ,  747517087437838152 ,  1464409447906517920 ,  1741422652248356911 ,  679426299902999159 ,  785713400970425684 ,  1962843114035744374 ,  1050502850413995552 ,  2284592765241997037 ,  1537562905716897981 ,  1326707882935230212 ,  569372729451052065 ,  1002205959702232293 ,  1018924333522719094 ,  1769437058944308355 ,  1254445892730425569 ,  1197306993248696332 ,  1081317226934663296 ,  897015730527998436 ,  1483609543290532308 ,  1204626161403030614 ,  1049118060470414877 ,  219145967593619242 ,  267369750322094453 ,  229008392775785798 ,  888816050688180247 ,  989017028242614122 ,  550570531808536888 ,  16307457260431689 ,  1982149492518013363 ,  1954852168204648531 ,  2036185397783886798 ,  1740644764030491710 ,  1574711101659080257 ,  641013708201269937 ,  83525837352737923 ,  1583756759174719851 ,  853080414695418560 ,  977355055045340305 ,  1329370793342035606 ,  1432371249552113674 ,  1133370071235423704 ,  2214038475150917538 ,  769697848196038707 ,  1462424634280471720 ,  1544786465999961749 ,  946277958645542021 ,  1392507076817190174 ,  1844641468446041509 ,  1562279631462669592 ,  1508198476228073380 ,  110629757710010813 ,  1638824389900137857 ,  990738751729519225 ,  1595798619875399025 ,  853782168960892908 ,  340634908802610962 ,  290595485149242559 ,  2043300026521846600 ,  1264724816987286933 ,  1262910297818193610 ,  1623577292746784506 ,  395167324200853457 ,  203245272143120670 ,  2174589597531236985 ,  1991188233451978535 ,  2140017487913701255 ,  1812419720345398835 ,  1256178100716145963 ,  1592950034491914127 ,  698179789376957714 ,  2078906006506290067 ,  490100081347777774 ,  1025267784125071947 ,  645881863598558292 ,  352907674252981717 ,  860214186840351246 ,  1002777819315754991 ,  1069557153134675305 ,  1067541835865053674 ,  1546129080456096642 ,  2106261608051140686 ,  2200343155187576532 ,  1376853440352940978 ,  1500294810817331549 ,  1912603586866658701 ,  930203765995654342 ,  754203136224119669 ,  1464020935559816441 ,  2115982867239249740 ,  775886814552231979 ,  1367578528886762288 ,  1412764192737871998 ,  386231646501744711 ,  62671937797660197 ,  1169915457045513219 ,  339605789527249770 ,  99584784501276826 ,  1847202512589673686 ,  2095552552273235956 ,  1242664185141460791 ,  2007555903683452135 ,  97454915745675830 ,  380979296654778318 }, // x^2^629

{ 333889957254028328 ,  561510714586057398 ,  1436830914867741569 ,  1746058790185212701 ,  2087364226011961036 ,  967931783818090586 ,  1594581620659562625 ,  1415686631057636013 ,  31103214555692374 ,  1236275280823657609 ,  1823188970669256032 ,  1433475802741026895 ,  1472790826183832779 ,  838212815472449472 ,  1369526927337825559 ,  1712133612204233521 ,  2165529597367666993 ,  1327349167925948611 ,  1929093917132682784 ,  1089586999816282259 ,  649122766141189069 ,  1763585647232450043 ,  902204269061394437 ,  354737824151048014 ,  1942312140323366818 ,  364142025748097801 ,  866529210538092179 ,  821645166842109725 ,  183761667585338273 ,  1150882420237693320 ,  977556911769801484 ,  960827858408010846 ,  679794088962778293 ,  2271079570216067691 ,  1345147018155450543 ,  1516209211477478604 ,  1600615132326106668 ,  115066393749727568 ,  150356999837357573 ,  759291341842708557 ,  1908683372595743380 ,  1615707633092785916 ,  406175858246733211 ,  176791780204991923 ,  806207547092001908 ,  1360167953441996253 ,  197287111561374683 ,  1190821597526471212 ,  1224691576667404269 ,  950968325708058691 ,  1540291794652556787 ,  1143709475639359930 ,  1503110107606096204 ,  152797011467473044 ,  1455430639268219055 ,  411336327471639464 ,  709499112840923364 ,  1213364200173056539 ,  765971749084115820 ,  1273227704775021851 ,  473614874153732733 ,  65606488924435700 ,  548690709214567977 ,  266992830675139216 ,  1915411498964498388 ,  860249378718519287 ,  1054542305049902448 ,  897134700305523778 ,  649032819506919598 ,  547937378063709754 ,  129501336622292522 ,  403791168580397681 ,  1749109207007702185 ,  1084808042145069055 ,  216727242266533648 ,  930549926152217829 ,  1095496407004779473 ,  783392421372128393 ,  1898041178147861374 ,  1476345359964885733 ,  1687059446051514272 ,  1463259911455518827 ,  175123832278263814 ,  506437529679717291 ,  877033765144737446 ,  605653200883417027 ,  879830095048984654 ,  1321775180466758815 ,  2283262341165296688 ,  1405214734463817972 ,  2093036161435770467 ,  1100502076193867196 ,  872395459740962037 ,  1705571188369967244 ,  1841467306317744551 ,  1637709033295982445 ,  2035528660832090040 ,  128210932888110732 ,  1176263228065642454 ,  1678978576883277601 ,  1570772130555509930 ,  686437082951524525 ,  665257010114601143 ,  874775970240030537 ,  887735213585954598 ,  953440390724157795 ,  839121252670076223 ,  2264523480344795080 ,  1407326538864079147 ,  494711140935172639 ,  2182840372218798420 ,  2174854509007176195 ,  914644044213577312 ,  1312982229837276430 ,  1281480293042952044 ,  1543925011590802804 ,  1237696796735287524 ,  517229866086636973 ,  1170581684125030945 ,  1262034337987310586 ,  966391378733790166 ,  1216444776299999500 ,  1137391553160909903 ,  1760875699094621186 ,  1711215605998409312 ,  57404278683380032 ,  1190921053043846534 ,  1372661110839273327 ,  1232999483358650679 ,  478236719473164272 ,  782829311499495939 ,  2179635621349857268 ,  1362077281534333938 ,  1649204604006063467 ,  797310471389355852 ,  830239926766886052 ,  1926845725169722682 ,  1343373163937908800 ,  105060831636930248 ,  1617445200937920757 ,  62100775477827895 ,  1527521016081092803 ,  1912284951656411817 ,  2171505940531121637 ,  861343599563191840 ,  1861674211714071939 ,  64788276032379464 ,  90258829312684942 ,  1280898890493323808 ,  2152646736643933324 ,  2114557392625801275 ,  1574779818979415732 ,  779825471471560057 ,  698283007329655527 ,  2212514772596141531 ,  1791776597932421958 ,  2100848903238795666 ,  600091583497359690 ,  1556692604517543055 ,  846827918329978408 ,  1461592029991944527 ,  1506564894828112788 ,  1509057434421020904 ,  43039490357194886 ,  199318105089487220 ,  1246459565603767999 ,  39072469020443915 ,  525813248056038977 ,  460493788861998015 ,  433874388987874566 ,  1441114775927528993 ,  1019228478045774293 ,  1785040543399097867 ,  1120278535938154404 ,  756864470196867809 ,  146209931692621633 ,  140071940918583458 ,  541756031315079011 ,  1964472759028947138 ,  1609108768645682419 ,  247404392690701285 ,  872794708316447982 ,  1631194696428765979 ,  1141787472739058205 ,  2154770723645779150 ,  1859024419902599524 ,  1170908609665034679 ,  1754344218130177472 ,  1243206138540771677 ,  1514303493419695979 ,  2152987273335854260 ,  595584858107259154 ,  586428581561373182 ,  1559729979378928111 ,  859093461313921317 ,  1402062145849088481 ,  2115965326354519993 ,  221418958478501843 ,  521076848642877445 ,  631602268973696069 ,  130468464487180715 ,  1679880494932885367 ,  1658566223732886009 ,  2266277210300440129 ,  1468936160766467696 ,  1459594730167199664 ,  1437599204955281988 ,  1693112951047025318 ,  713105335704337247 ,  1585849202041746341 ,  110591604078724791 ,  905046148621366 ,  167466384895003218 ,  1098992772735709402 ,  649383554854846051 ,  1556844038495692341 ,  723803383517592094 ,  1278319297922593033 ,  1940252698042154964 ,  1446665409737966678 ,  1348314133853984133 ,  770092987824482668 ,  1107479938259909205 ,  336251693732619634 ,  1890717485320185737 ,  820567685745539710 ,  1912424579404079842 ,  2133272013825497082 ,  784039491254031412 ,  1055601579221818516 ,  2303052576172956090 ,  703417967680918925 ,  736700435376255619 ,  1287917740780007502 ,  1317826000218379825 ,  1624731967283302788 ,  1404270405675200357 ,  835010898270115 ,  1666213581065179495 ,  2145665207760374914 }, // x^2^630

{ 1814891995529473711 ,  662843735907058743 ,  921950213712112602 ,  1725214878393785550 ,  675510138518359359 ,  1453232213880073150 ,  954035264143391428 ,  2040895223451834505 ,  2143699473764974681 ,  2165832589413485997 ,  235616173524660733 ,  405411961006132084 ,  1902007187518623443 ,  2132311353974395238 ,  944514109686214703 ,  560060685682203430 ,  1591584925429147437 ,  1148726223560300708 ,  1040865347768475657 ,  2283154181048858823 ,  693410021377140464 ,  1249405038643636546 ,  911594435898130320 ,  520123252905073829 ,  980363205716645292 ,  678033487307886664 ,  304024554604965227 ,  2278927245445422783 ,  482931153034093907 ,  249406665952054175 ,  1584768471925796123 ,  1850677006771697650 ,  544486874157793856 ,  207824755381519994 ,  519328467036620337 ,  1139356846920162005 ,  515464737752729301 ,  1026868219052963590 ,  482988746042548745 ,  1074429153133750235 ,  732145093128660944 ,  550335723370645775 ,  123517188373364579 ,  581407215320423368 ,  44824606005325799 ,  1480714806555783521 ,  2047947214823598193 ,  484389827933206993 ,  174543273606038452 ,  1460446489075264684 ,  390405593366500008 ,  1576792165127771715 ,  1865203038718039450 ,  652326965433833573 ,  797258529805209994 ,  206319316390342608 ,  693647898843523334 ,  1221336400612696648 ,  468327480918117328 ,  714087747969334151 ,  524076979637676662 ,  155467680003217156 ,  1009708475759545270 ,  2007832770509812547 ,  1511535041754540823 ,  587423186992030364 ,  2303663151623343061 ,  61747441843548756 ,  1063679555730194101 ,  993048005906373284 ,  1534957982156861821 ,  637481218531847361 ,  2250729464030474647 ,  2276145802219331703 ,  939791793001906254 ,  1957271050732633997 ,  1268725821136423179 ,  1742549361527826538 ,  227727828068517635 ,  1178788363289426984 ,  909094562419228121 ,  96412242086391257 ,  688259230483234751 ,  1057854870733075196 ,  1970175971187757465 ,  79541833929777707 ,  2066247608279832796 ,  1554110411289480519 ,  493244158410622492 ,  327826162922863057 ,  1046313477519631055 ,  903086943458104567 ,  1541081319915687964 ,  1631899614811086203 ,  225858175106456679 ,  1439370214688483001 ,  618900400839242777 ,  911298767456526659 ,  255145794396535096 ,  2269973785480346821 ,  769427199623010019 ,  2064791585375161877 ,  485578871736868259 ,  1921914178236940333 ,  509912326332741500 ,  1329955564064548125 ,  849435585096862459 ,  102496717599477422 ,  577043893209996011 ,  893987003429928604 ,  2221772578130039811 ,  348531354662992015 ,  956586383141287113 ,  1235125428566749310 ,  1045655093632098893 ,  388936604408016715 ,  975089950549178118 ,  430248278939673173 ,  411525920863139952 ,  967425350966009139 ,  1382886885167607539 ,  1458687999851831376 ,  775922045191567714 ,  1843543684457505422 ,  1668296566834534551 ,  1288228726280817680 ,  310380533369282987 ,  1067694248671408826 ,  1371338710293502084 ,  1971196069048662164 ,  25070176096215316 ,  1407749198651453086 ,  359558612003170215 ,  1164496098769384353 ,  737167796198799920 ,  1268248968412558316 ,  194506324517170506 ,  394128689302010021 ,  1693345635684801562 ,  844475813291009612 ,  1199245699457453520 ,  377652611940220923 ,  275969315161079489 ,  656764764415802782 ,  1469392469298423031 ,  635205084731720527 ,  2132532994215125400 ,  1712874133346872712 ,  241024696041154402 ,  509284563810849146 ,  832059628786333975 ,  508908238776212638 ,  2232655637745597290 ,  474779514545085457 ,  1360713669590934856 ,  1851968520052990411 ,  1320517043965493584 ,  520465750880648575 ,  2236981877838651499 ,  1976403592272916139 ,  562031360795990268 ,  695700262026702440 ,  549216247950897903 ,  884143076292115028 ,  837931894383739073 ,  1004722541645866318 ,  1009529072412395222 ,  1599106097735248274 ,  839406783027982369 ,  1724220955026690804 ,  1492423919193494654 ,  2096255319298524628 ,  1123597745826793730 ,  1261670514086721738 ,  2246970150101109549 ,  2092928615838392053 ,  1831879337125979036 ,  2180043053551169182 ,  464392011784583243 ,  1880117525671500026 ,  933789934104539338 ,  816869292593600476 ,  1373979382339984823 ,  88578710881359828 ,  1039780622962088991 ,  860295788296566646 ,  1858109315519447067 ,  1293948450411182096 ,  1011132372727393852 ,  1403166269332418927 ,  2281778747271167775 ,  874271764748321847 ,  1728428308778895788 ,  1776064586637982792 ,  1335122353293150398 ,  1622590613958312003 ,  1657202767717596888 ,  1694441049880502128 ,  44071887779799807 ,  1234628954559706225 ,  1139522753262334085 ,  785545828099004886 ,  2063650594424674763 ,  455425263575390244 ,  1192575445631740888 ,  680052117057104243 ,  947919619443151462 ,  348896961104049581 ,  1161660570895876099 ,  897944428747430277 ,  1237310019787887623 ,  1036691355329631264 ,  47649473320813625 ,  1743187892662152833 ,  525215245475515933 ,  1731863635596154383 ,  1788263806353126541 ,  648024433318449903 ,  1024059646303630254 ,  332612444014877722 ,  1501055138221545838 ,  2022803729870049495 ,  223751454281145203 ,  1910128284424901715 ,  784505750300966593 ,  1504778069911048229 ,  833798371850347049 ,  11285912972824457 ,  1450156093327156825 ,  1579171337497266130 ,  1047398563487148814 ,  702322793783578748 ,  545862989615129413 ,  1111067972086805809 ,  329762442154904580 ,  1436669458766818921 ,  495921956449990352 ,  1586405443286989844 ,  1026886544167146500 ,  512005559863024201 }, // x^2^631

{ 163509137524104514 ,  1095281823699505132 ,  1028489045737206912 ,  1563739688363335586 ,  92138882107306452 ,  1804166965680083525 ,  1474434778515832053 ,  538274609695390050 ,  1745418576957037636 ,  2203415306504722835 ,  1684457239691567727 ,  1601405207072592814 ,  530488959454008446 ,  706963232130448001 ,  2218677190868881540 ,  1060429361889100189 ,  1269194943603352349 ,  1076371642487114118 ,  2302583736871971889 ,  514169982578449655 ,  851884364952099767 ,  714589124666748348 ,  1504698492283705762 ,  308909996253757505 ,  1441558090950562865 ,  643393388285809386 ,  156021186287606532 ,  347965502887783427 ,  1997510494604844961 ,  2212981250663963123 ,  1828587783387430229 ,  400681435865065795 ,  385184281527219159 ,  1343789710181255189 ,  363134689695883060 ,  595645738243625998 ,  1352380243262948806 ,  2090274836117616199 ,  1816044533611452163 ,  573774960691151896 ,  345238615036308931 ,  1048525420089956610 ,  1479390174844383143 ,  2006448123257081520 ,  1154366238292815737 ,  1745898236709191880 ,  1128941050200441075 ,  1496157784618089172 ,  336312229499355226 ,  1065983386401789270 ,  1193329554643536553 ,  804121685162852373 ,  668202886405122158 ,  1802538902894846913 ,  987229432674992245 ,  516133598637948594 ,  1188086663970603134 ,  1068674240900945733 ,  812210503762832329 ,  339006486670414886 ,  1544681349305104170 ,  427184450232012247 ,  1628148217992910501 ,  841736504950209563 ,  1202661925985779129 ,  192771497099218378 ,  2103843749879024013 ,  1645958082043912151 ,  1284642969188739205 ,  1444955025482252715 ,  155852733681853639 ,  1101112134066063725 ,  896253036427465266 ,  142010285970430637 ,  565954599157166253 ,  416384178420876663 ,  1425881931307412965 ,  1410294141713514893 ,  362222305122269051 ,  1995775059003508695 ,  2171066343269379388 ,  399793014462586669 ,  466761063218690849 ,  1739218227075434236 ,  704842838653805607 ,  724871745039557249 ,  417303826845031174 ,  451675525970843543 ,  1473234838555233093 ,  104153339088491436 ,  2154369033719402996 ,  1703605392366811829 ,  971209365998276754 ,  1055293356333340148 ,  911770612394393018 ,  29778987750033082 ,  2254292646715648193 ,  1308059476099153685 ,  1320739337651283541 ,  480327257395522661 ,  35364790813831635 ,  342769850805114571 ,  1459648343716447305 ,  1715395164127737098 ,  448342844746920071 ,  45904085345380774 ,  38989523555567237 ,  329629040911606207 ,  1156700874640076178 ,  1384885968558547967 ,  987419774461819980 ,  1249749428150596565 ,  414058864179623329 ,  389845559275161317 ,  1859135179930690556 ,  1759907392976315884 ,  303234771400497088 ,  797645146874298905 ,  310731901232569880 ,  1639389144612176925 ,  2203817714464888384 ,  992022021779080885 ,  596572481947682450 ,  2201009084356534148 ,  1256622390864214511 ,  1571619510214061791 ,  798065805489470484 ,  445801172516382902 ,  1531381591956368085 ,  823657015341357470 ,  972627939154938512 ,  2169249432926976181 ,  1721031661910894451 ,  1859932210910382210 ,  2092473355279311674 ,  1983773758308807947 ,  1670174412300263907 ,  83303806062997144 ,  67709408713064586 ,  1921884286621049260 ,  467989833828144230 ,  2058595483408720581 ,  1581614327441967270 ,  1791071873944134610 ,  599452746480893310 ,  1769561157017947915 ,  816046963823363488 ,  1370175397664509087 ,  2217916664136648120 ,  946563352888959583 ,  63646373989456047 ,  1036080923184702839 ,  163733839793758569 ,  2026620323120739200 ,  2299635092538675642 ,  858804371101521494 ,  270545569824989284 ,  83061997774967298 ,  2079777960371743174 ,  1071055531282834531 ,  1606890212307953538 ,  776807783225966872 ,  935647450719870167 ,  1004386954187328229 ,  1646974777560590901 ,  1116578717717442797 ,  777868707187507246 ,  67397286270406132 ,  1808152427456380222 ,  239932697612901617 ,  2118761815426397587 ,  2149330885778677891 ,  1464465617118029247 ,  692085811228161054 ,  228225174694340261 ,  1114524335734784549 ,  1466006793497393131 ,  73314241582965018 ,  1540027540648067142 ,  482911809678548582 ,  991504724077590949 ,  2012831006956165037 ,  2030153927039837772 ,  232672857515501376 ,  583408600399914204 ,  325637190400361151 ,  1422942042857787795 ,  343813491880562163 ,  1020100841991270832 ,  637042977157204772 ,  76162362671885188 ,  557057482884777538 ,  1634369333076561659 ,  1522326792819516060 ,  1891222553230242531 ,  717712026676905422 ,  228276575922745673 ,  1168004589161889052 ,  1294090222337084169 ,  821001361173965486 ,  1893246829254717127 ,  1436970867485846742 ,  33784749874053646 ,  1199616440522506822 ,  904854440634152896 ,  837427898914897621 ,  266169399554907465 ,  33687310009242622 ,  668589599649627318 ,  2037278893877625806 ,  170975036034184865 ,  192979592484685872 ,  83616550132937087 ,  1473225924812444652 ,  1654067851462513058 ,  618221441569393412 ,  306348352426294776 ,  1868682088093518947 ,  1066937520962300942 ,  1263372412591022027 ,  268576609698529452 ,  451956710529665818 ,  105005319528065938 ,  858226125568379558 ,  1024298661030010956 ,  1683358398111976796 ,  1250497977912026000 ,  769177505116047111 ,  373201255823644772 ,  238121776267288527 ,  1582201549244771202 ,  1065003593446917730 ,  377603133752252140 ,  273519492328099278 ,  521013445691721426 ,  366099471145693348 ,  1230126824645959666 ,  583874287707148813 ,  167980414493403954 ,  2285119069668074182 }, // x^2^632

{ 824455843774958197 ,  31777242667554092 ,  1804059548901055121 ,  1153780515703501258 ,  475941361415355790 ,  1069710094133212974 ,  976352707609091844 ,  682259838906554121 ,  773931571197410093 ,  55488724651526682 ,  1539503366729273954 ,  1133371545116325018 ,  1466129505598621995 ,  248874312822335127 ,  1241961625367089475 ,  1120998866476703663 ,  706622909503814620 ,  472397676515014365 ,  1474786429716220469 ,  1704304343965579917 ,  1419402279357311275 ,  914756389568863978 ,  1214910999326977097 ,  277347777734728108 ,  541072151463822873 ,  1422257679070277508 ,  57208224795325897 ,  342838859071369545 ,  1781938823702177131 ,  2034366273654570009 ,  1354599286192009078 ,  1791842969152612152 ,  1142766911669896700 ,  34826142004280776 ,  1562275036672631025 ,  1364879135606064607 ,  199718155466993853 ,  1658068719645034860 ,  901876590913278216 ,  2117258939592247405 ,  1077737336567261762 ,  1275615652759895762 ,  1145893709484024322 ,  2112878983352958405 ,  1123046457965434303 ,  1383139874363615837 ,  723769063812650194 ,  521084037173881778 ,  421342306691105904 ,  1008397950514663409 ,  1505725523822699958 ,  364791742162430721 ,  1875317597351812503 ,  1259479708105941632 ,  399499584847061640 ,  900060482594569732 ,  1305599820504438032 ,  1189655060293840019 ,  1761418084933328550 ,  1054940815035820333 ,  118163588666590352 ,  860819863157240147 ,  835296547895239099 ,  1251803885449229981 ,  1408726797063699126 ,  2167269045836291284 ,  1888974276597697604 ,  508789861606290197 ,  1032778874470342763 ,  1408737612890413561 ,  1027092598717779312 ,  222378472041776609 ,  1213439163901860075 ,  1825071501776216446 ,  313319834616534032 ,  371751766163530131 ,  389724319006594815 ,  653276493191812559 ,  1658023663034093183 ,  408653212540238462 ,  1123037433799092215 ,  532078237518856034 ,  2022853025176284043 ,  1520396528057932989 ,  1664168365312445835 ,  1425183724135299994 ,  1866283190336010380 ,  826050357530848112 ,  1209570875577294520 ,  927287983662941245 ,  1736338982376232134 ,  446404003939747852 ,  2186667744203629224 ,  706421770335744533 ,  103996797051547572 ,  1193539885312568840 ,  919230972868785993 ,  1550589023225223736 ,  2251699731562774826 ,  1696474675604829918 ,  348507944589970743 ,  1190358005853467194 ,  2057127616837948911 ,  2277554821954721693 ,  305407795339144695 ,  1468423486068181 ,  49697813591920144 ,  590606572778854478 ,  87461856598375056 ,  420962455070917945 ,  1688189624436945191 ,  576468408958196404 ,  120160867583474492 ,  1975916513333576711 ,  1433552370073912378 ,  374307907094003273 ,  1230833825291906793 ,  2157860606832491112 ,  2106147143171381316 ,  1177203491761390801 ,  1146357992198087014 ,  470098140140885537 ,  846857008229990840 ,  94509274312676812 ,  66905197976197530 ,  1278798768290215695 ,  1626803234708061739 ,  1471130965593917277 ,  692174281825353982 ,  616005306735226264 ,  140895599620510068 ,  1184725366299464052 ,  1396746510827747280 ,  498455505953718581 ,  1577840596828173777 ,  253283662261461697 ,  473732874435709006 ,  1592394962532898389 ,  1412598253591286324 ,  2261972905705323409 ,  358647928548831447 ,  386147418978134960 ,  1946651922458701138 ,  1966931527771386070 ,  61220571185197132 ,  1910262278593618118 ,  1542836761334358466 ,  752413076259343920 ,  1818864080866492259 ,  1944942252100755553 ,  1101977025623942798 ,  1539601049949835769 ,  1680589769744798856 ,  1785314948237102708 ,  806198033429819377 ,  144438535161874275 ,  1851372216482486614 ,  833498931391761713 ,  2078677026192916303 ,  977005051769083685 ,  2110075913642319679 ,  1613637517427532139 ,  2139596763410999092 ,  1991294922101353566 ,  678918065134269868 ,  666464566879014845 ,  686960601814809335 ,  21616918011774337 ,  1979395997242618692 ,  1160758160481306380 ,  1806633338799950639 ,  1322899005549126693 ,  1414800068991783825 ,  371010987408113144 ,  1097792464641776003 ,  1597409805620054964 ,  1392242117135450799 ,  2273993322520020380 ,  944453271454937178 ,  1733729760158798414 ,  1904216609998076547 ,  828364220137891822 ,  661977423681845855 ,  1912036635852297134 ,  1781929145394159541 ,  370321072162477495 ,  468589648176246618 ,  118580660008853439 ,  133502571229869065 ,  924315600857503756 ,  532827752259393937 ,  1833267369332901796 ,  917926789264110715 ,  1388237019829312848 ,  198416053403747324 ,  1551702589547229386 ,  388304711834839650 ,  345595457589774146 ,  1125450342133650870 ,  1256761172753778137 ,  970878493906464289 ,  1499922424555516622 ,  1918535906683383035 ,  1727075223193686142 ,  1152390782874087968 ,  1012717793546098736 ,  1075089152692700639 ,  1718908560275014731 ,  1318801755247639177 ,  343191381327830582 ,  2199379892227832724 ,  2286572939072051688 ,  440294752155559069 ,  2143693620770106425 ,  1250646515878505308 ,  1245057861801249869 ,  1607245229515237531 ,  1524009230297154125 ,  602886548844094325 ,  1849542376556873156 ,  485206887077056035 ,  1543725921214695327 ,  381367613417057103 ,  1946780956699677388 ,  223949249367555103 ,  1258875177871806497 ,  551638863952320869 ,  895579821467219938 ,  2300002075951574689 ,  729544667952274188 ,  1834681105064391147 ,  1532730657706684465 ,  1449466914656023833 ,  1785988038644408069 ,  1669321060474670200 ,  1558758727129531528 ,  854058742275907941 ,  267405113651282518 ,  510524904663887199 ,  165660699537521506 }, // x^2^633

{ 490261382720065875 ,  1827529482174537068 ,  1461132466078424455 ,  2156246242419961841 ,  1548707886985484844 ,  27454751972071040 ,  2194157855278991951 ,  968892958405421545 ,  1383956988331496463 ,  154760272619135641 ,  1391638685496736021 ,  1930772310801402631 ,  1500927710891558983 ,  2136737790369395982 ,  1533858799894847737 ,  839866155190746183 ,  1722610622372218546 ,  1800048423562562592 ,  1523358278353270878 ,  1381042889666952512 ,  599740440581023887 ,  1785619090977379643 ,  1680094700202325154 ,  20744991825745914 ,  748126929908417904 ,  1855154633565530052 ,  1230773474803750384 ,  2228055787047708905 ,  1417173074338822681 ,  519504413304956435 ,  57177640426155745 ,  1831158709286295863 ,  2203590821004376471 ,  796497860485341415 ,  890671344171589558 ,  579855473506932577 ,  1926262135463406495 ,  2152816068674599347 ,  1244411932031600706 ,  1888369313054035944 ,  1107081850506647210 ,  766562057031675738 ,  280985951432249321 ,  2092617545582158615 ,  1401893836965517325 ,  530910821022181632 ,  1594720993831819115 ,  1144295008551562415 ,  1497747677612374448 ,  1715743208452958480 ,  2247882500653319728 ,  218597585015350215 ,  1098619604625796121 ,  2017151239382838317 ,  1232974476251902256 ,  1229353240873496876 ,  1959950329998530378 ,  2288868802145789247 ,  2285979137043359495 ,  791195069557313334 ,  1628190631348228548 ,  1353416395795260614 ,  851788740390279131 ,  1976745623288460158 ,  2031861078936066117 ,  454107950843699158 ,  617689443848719917 ,  1379752622023761036 ,  2151690398621732813 ,  1125860935864920620 ,  394906613514157477 ,  74586882035963034 ,  2025459502840030711 ,  419653857924997877 ,  2122692876972551892 ,  1941632862532564607 ,  1931829521828538631 ,  2081107894251957605 ,  1694549261485630266 ,  2005272677272213138 ,  413805844500106411 ,  1530944565970046903 ,  751281734129501625 ,  1298188509788265873 ,  2040926499772405680 ,  1656769648950101829 ,  2022583997678880331 ,  860071548909401837 ,  665384992381077641 ,  1758859703213869922 ,  161142790740697358 ,  1400319376102884073 ,  1807402301446638606 ,  1097139341266943358 ,  1088794222118913708 ,  1596940737963202630 ,  1888878180283844189 ,  1553409728437126451 ,  2152297644665750537 ,  2223600525327303330 ,  779278690690063106 ,  134207595957231149 ,  1574028904443805394 ,  2243383622370048242 ,  1258782964571811190 ,  905895431957360142 ,  1395607736007162685 ,  984874687441567962 ,  212186779583418713 ,  795120193034969177 ,  58279793034546044 ,  328000381983136918 ,  2192508040730418788 ,  1025375397073705540 ,  1593053647512746026 ,  130863952660221350 ,  217425672388449235 ,  2083289408922484891 ,  1284667052011087088 ,  864397776715454940 ,  67672738346591539 ,  983203917277128009 ,  1969620008872113484 ,  347279586407350294 ,  1690362525290731988 ,  2044140927835841567 ,  1525674298949571431 ,  1682222317863500131 ,  840035504595882013 ,  1182932488583095607 ,  1218327141068211643 ,  2141525619798894783 ,  413569771999929570 ,  1501732346440970643 ,  1226510597746172308 ,  167991412925362939 ,  589698926313523854 ,  375317686125336588 ,  324879322588263646 ,  2067441798134212919 ,  484098295631269000 ,  1116520593486726572 ,  260780613110697203 ,  1941577823221334596 ,  491759314282716843 ,  375280938898834417 ,  342730727451094002 ,  1405263100827059382 ,  1541430415614864549 ,  5999769136874908 ,  167703869004713600 ,  165856783482720712 ,  1124262296168905671 ,  254480458493372545 ,  1773865810734531612 ,  2041741825905889086 ,  2233165447274431301 ,  166037714821738450 ,  167893703951380422 ,  934208858273921486 ,  734940771717956917 ,  2288161267484564160 ,  1567895714279006649 ,  1769974528965639065 ,  1216907831499406921 ,  2294706705714291842 ,  1599970520427218980 ,  775497072579240273 ,  205032814230091878 ,  2223624191870917391 ,  2082737713633983380 ,  808568519687631044 ,  337700988803983772 ,  436794534046179897 ,  1677455531288567217 ,  1314892863698527275 ,  2047222599780237476 ,  828154982567426230 ,  809223636371438668 ,  1609031056763286297 ,  92866045904562228 ,  1422785356428690790 ,  1927652989588171621 ,  2298645651233275625 ,  1301360696664823138 ,  657746050549406011 ,  1546447475675594992 ,  541228836326921313 ,  231093403847215244 ,  1010463025190925042 ,  1250495097978220305 ,  495522824116711433 ,  1397392198762027283 ,  1900188179895263771 ,  299785412823959930 ,  594889293445312437 ,  1242931483964025437 ,  1342852319088685593 ,  1537161875738330421 ,  1181158325367054364 ,  1899484430586362972 ,  1539311983557280748 ,  1779963362305650875 ,  1866883277821609888 ,  1900114619237525565 ,  96903422265062075 ,  535893981548483682 ,  602594428874313133 ,  1404490794243986379 ,  839972847263183228 ,  1566082672047635358 ,  804178602990186446 ,  1190037051866731004 ,  1814412459716492231 ,  674569013742437379 ,  133878611495819407 ,  254823567049356584 ,  520936531814080806 ,  279667876400605658 ,  1272754575051289168 ,  1125643819072885734 ,  2061448932680814882 ,  1495126502272532868 ,  1433724618924942439 ,  2065207794728111237 ,  326481572346141206 ,  1795856089434026168 ,  430243008605794225 ,  2101179576163931237 ,  132537157716849822 ,  1288304444120537109 ,  516194076482717836 ,  1174953029692191925 ,  110930100329361285 ,  1092671278019628191 ,  1825461866090625468 ,  1798178602460615876 ,  540137087515460444 ,  460625015168176995 ,  154378340605092674 }, // x^2^634

{ 34927047164703426 ,  335088317514265326 ,  1458783103990552177 ,  1910130240598397088 ,  1819880496918954423 ,  2269745781829216169 ,  288982652256201904 ,  756496873117016024 ,  1992878755964987092 ,  1139841042133438864 ,  1996326403620908363 ,  721754774331754625 ,  513648344975516467 ,  1401490414490079231 ,  977369226071340900 ,  1680096537636547945 ,  2108345674711101876 ,  244081253944878344 ,  1461216636510509001 ,  2275322568882965774 ,  1569541266344307136 ,  1525050506636281007 ,  616359413562500070 ,  1947455094609204159 ,  1038298949907659789 ,  609642019695336423 ,  702947838763996713 ,  1833863093860537713 ,  1754086153933319944 ,  1693067357568786880 ,  313935833518508919 ,  1243359021062228044 ,  1994873891926300908 ,  1868741387604843630 ,  2219400292769556047 ,  643598795770201939 ,  1181374989440661896 ,  349747030936981845 ,  1976043139310317811 ,  818547419779097432 ,  1182962626418095022 ,  1569487596629335729 ,  191659766279752743 ,  1306497749778536434 ,  972314083464380614 ,  1176554740133502147 ,  601476924474628231 ,  860695945071041710 ,  1833002293391435191 ,  1915848379621834839 ,  536271064170401405 ,  1893028275124006378 ,  2066466709406680464 ,  810738906037313595 ,  790918213754416638 ,  1710009210793059138 ,  1133338820356184804 ,  211626470820429931 ,  1637729021206647757 ,  2164421265836234157 ,  156152661926393609 ,  597518249758481039 ,  1478371473114030855 ,  155998729152183020 ,  1019183058139435069 ,  71973000820944914 ,  1807370156167107647 ,  299160476906004380 ,  950065051148019641 ,  1607889411941187325 ,  733682773683101644 ,  126940563567629031 ,  1574467044838721018 ,  1837354869613940120 ,  929276560919761914 ,  303945677634867311 ,  1260209255531179241 ,  2000756964398397089 ,  981164070679058442 ,  790686689798734043 ,  1461355276435462449 ,  496674306227715719 ,  1162618560732048793 ,  747285934713114846 ,  173458921266484856 ,  1695671518865615878 ,  193612494001580585 ,  1664729643709631017 ,  558013631743021856 ,  1357914016594575314 ,  186802636462358210 ,  961826245178884645 ,  412774508959947913 ,  2244051277653537007 ,  954224785428905626 ,  831514348335198781 ,  1150079904770616481 ,  129116505741159485 ,  1880931997899516637 ,  1816422798057374619 ,  1185479960688346146 ,  1373449906232533128 ,  1743599519658363474 ,  1285126925561466218 ,  1837313748639803701 ,  2098658147440049614 ,  907289286854357835 ,  358216557831183435 ,  159273066894663122 ,  1045348957241662725 ,  658980882042715852 ,  1021074313268868815 ,  843911809878933937 ,  1654455316714763375 ,  75310491451818475 ,  1465862145596890196 ,  1823304072578854407 ,  1548756102018081058 ,  2254426919599042327 ,  1979040223874160654 ,  674501077233321508 ,  964940099278348641 ,  1745317825422212311 ,  635391107005638497 ,  2034277649499090275 ,  830208134148045962 ,  1183867768343920812 ,  52643466856546967 ,  1544774990438527361 ,  898665588033097928 ,  633185867035473525 ,  2292024162823630987 ,  420560234314544029 ,  168212782863424669 ,  1130099629738741312 ,  1925964465695367499 ,  480349741963935525 ,  66813699668247356 ,  968782193551007622 ,  177041234553616314 ,  85555711803764379 ,  1536495467780931831 ,  1578013887971548564 ,  1027129027107694247 ,  336557325676327410 ,  326841371260061058 ,  591516293281277920 ,  1545953515111629684 ,  2015557642702080689 ,  96742435561546327 ,  1651700659458369061 ,  1280583344446175534 ,  77735327820962817 ,  407752845586404050 ,  838468127479410492 ,  1705213125183042071 ,  1059674374098636640 ,  919541452229477945 ,  1607601767409766187 ,  2000426957728471207 ,  674778352334261593 ,  943134017672589101 ,  1209146329403496104 ,  1700284477179714722 ,  1441216362912765977 ,  1325289539824265313 ,  126237753258085464 ,  1105950453602395443 ,  1825735916484849836 ,  320662464018835058 ,  1809630187704062974 ,  735797807256570594 ,  1771275863011720896 ,  900114195650014755 ,  428467621403180069 ,  662766604161315242 ,  815077840409414289 ,  1134807924060082193 ,  1922683692451430872 ,  508686298209982566 ,  1639913635427304725 ,  430292875589608316 ,  310613235577338689 ,  2137918118123600908 ,  2005059483832863261 ,  97589133105242752 ,  609096172670141324 ,  1927029988812881237 ,  2120560648501855165 ,  2226412084330410985 ,  1997190431799255675 ,  236734967733396064 ,  2029404352519516569 ,  822044695969724591 ,  1500297201956823699 ,  1158195877277896337 ,  2071790039637544441 ,  796509748968206935 ,  24976118803443764 ,  2269078899483991078 ,  1367564311592000922 ,  1501112567534068264 ,  1476522758365124588 ,  1402824768328674021 ,  262422691501971966 ,  1486020746788885402 ,  1435742569594049697 ,  1048417442864746870 ,  1747224787189265758 ,  1611332795663128341 ,  1561442762105027359 ,  2007934780446586996 ,  767034073387431659 ,  1897358840592011580 ,  2231862012862203929 ,  323924288561618655 ,  2014601828476409994 ,  188403862959561388 ,  1657026594297608120 ,  1537361188393374331 ,  732794582007177821 ,  2021876239129094311 ,  1645604125353767391 ,  1384516074331145113 ,  2053047033269576271 ,  511166808997548268 ,  69342378943667256 ,  395860517111767862 ,  983647009130794334 ,  993674337367998808 ,  101600422212068222 ,  113675594374429356 ,  2275640469961673251 ,  1019280935283063335 ,  569152710610337798 ,  1156534458015640355 ,  1357350714555958201 ,  1629522874562878967 ,  2082897971929243147 ,  383802767803103844 }, // x^2^635

{ 1692539196410816312 ,  657150752899752227 ,  143308481529535864 ,  1978092132792493350 ,  129646044892914969 ,  1345071484071408159 ,  683470425156135852 ,  533723669677143773 ,  217914526216056662 ,  753013711762808464 ,  1915470578524901611 ,  169810523276119801 ,  1314055741989928495 ,  125314969345357260 ,  370228542804351698 ,  1667389390340748222 ,  2095174359743614352 ,  1702683611740383236 ,  1804959148670054672 ,  2256811318351005463 ,  1205101531319229665 ,  577217567908959127 ,  718768162063556846 ,  1401127285493370322 ,  1196006385191829157 ,  1932931586280389891 ,  252498446385411177 ,  941399994239625413 ,  2211076110109792980 ,  224928199325608781 ,  629721863449527664 ,  966513563639278475 ,  1845191731132402422 ,  2163477745891756026 ,  1256484117045664518 ,  2222831264622044257 ,  1664175481073832304 ,  136707450226268570 ,  747479143210972271 ,  2000503362406943479 ,  292497111905160158 ,  216010207296230562 ,  20237501928540386 ,  1359026439687122187 ,  963988589362442758 ,  234057162741226903 ,  1495816594479667339 ,  2123889860203165230 ,  1005367016361431304 ,  1846977965153271702 ,  426711820692856756 ,  459477512684100711 ,  1664287130811362510 ,  1339219684585996525 ,  579946202434949553 ,  2038976396388035239 ,  2171676965132059597 ,  1837659674343408427 ,  311400174457089050 ,  1624410590417137270 ,  2148678636119596286 ,  1596197101528214390 ,  2285644079616095391 ,  1128950774573347563 ,  1074120832132164467 ,  308333548472141987 ,  954324699443150084 ,  1223965702824449306 ,  1827266658038884017 ,  1118649805655800091 ,  233886532381784605 ,  604677607608655313 ,  1891985652476748330 ,  878891592858874265 ,  1888860267391837309 ,  1607428661909058350 ,  422448849182932903 ,  2096523128088154992 ,  696073060221131509 ,  1427610283795220613 ,  279474555311646844 ,  885842452332987893 ,  709824698680604407 ,  903773142981043589 ,  1238475948032727996 ,  1795810386762856514 ,  705071431006321826 ,  1681317594355257387 ,  544862848354732182 ,  1081284624759658192 ,  1899181253463069737 ,  228953559808659297 ,  1296033228897686723 ,  102135446007086237 ,  2141510814281824174 ,  1989487320117670529 ,  2218027891104911384 ,  40290881757828154 ,  115553587956126457 ,  285876182423532520 ,  318590282145522595 ,  2168100173824312683 ,  1660459872336832201 ,  2078226838087042298 ,  1634399918633520591 ,  1921101539724971492 ,  638164414035758648 ,  2220471589175014205 ,  459068182827105396 ,  679758847424270378 ,  223294904078202853 ,  266729237557956282 ,  234977433575099626 ,  1530915749412746254 ,  837670598236099861 ,  2200177255632041564 ,  1665129572262830441 ,  566146691990879232 ,  1802968220163520077 ,  403541699187879539 ,  1068482922509326678 ,  488876898696651159 ,  523427439639490694 ,  1652239797659562344 ,  386701173171585700 ,  866380648461249662 ,  2200206013650460365 ,  1103244191480914004 ,  317489454068130591 ,  420572204713591913 ,  1600297133162646420 ,  1073604756176684239 ,  1045358732180418294 ,  853012214510896569 ,  96057528539834484 ,  1266546418363659086 ,  1691142950416668793 ,  264377588632056847 ,  91143138448044247 ,  1204549019010492004 ,  2159710577152246197 ,  231219660224729552 ,  860474635117824632 ,  1779126515673596274 ,  2120089116286291140 ,  2018578127131037610 ,  1457679666119664668 ,  1239515629922181040 ,  483744046028314269 ,  1549875435356541475 ,  1603422105316481220 ,  548562157077285544 ,  497472990432813900 ,  1066320097696925764 ,  1361696528145026940 ,  1937657767442196967 ,  1340386688723647845 ,  724423245226124190 ,  1237535117269354580 ,  1738009409808638735 ,  1384011588788366589 ,  1608946341710114003 ,  2118912702835466765 ,  1887535010514164149 ,  1090955860085014509 ,  521418354448715870 ,  1897629488475531300 ,  1090848945062094089 ,  1658382266223731516 ,  1784590141822718167 ,  278879601282221294 ,  1961310203419523509 ,  994417526879463354 ,  417754550615694559 ,  2141375542034451214 ,  333139311277447916 ,  899947619144014741 ,  1654608026862065749 ,  366191396436961919 ,  1874393174742656463 ,  399244439592095469 ,  1918032945928306658 ,  536130522050496983 ,  986728906825364565 ,  2235382756808084603 ,  2068497576059514827 ,  2120486662957368922 ,  1298519887668006620 ,  1184907799217268471 ,  1379395395084465999 ,  1158522812605827844 ,  543131877809638875 ,  685028231772144472 ,  1575811649560882319 ,  1515048711862732716 ,  2282748186218134197 ,  2162701453633754642 ,  1412148032422195631 ,  900756347243996018 ,  651918483192081855 ,  234192359684715066 ,  1890860729669414490 ,  821100227887107318 ,  1655301462440189303 ,  263047224243352287 ,  354782417775005493 ,  1663293146466123121 ,  215048458665473723 ,  198366220665730767 ,  328133871233552477 ,  1834519078341190127 ,  1420003901129822876 ,  829511279361321261 ,  1727641418842542924 ,  483663854691434580 ,  1407515938454123654 ,  1261654577128811599 ,  778254628768975260 ,  680140095951545886 ,  2059093889736491878 ,  602018757937702654 ,  2179849731897544391 ,  1961669104009807620 ,  1897473648165399696 ,  29934368273521287 ,  739552033433168944 ,  2299760172387900293 ,  964743440105286983 ,  997794051411783484 ,  583967301525012475 ,  943944802688730043 ,  528123567421090421 ,  1694842665440667649 ,  1059243328285074171 ,  2178833948034430624 ,  1689839194126410749 ,  511503639347516276 ,  1570775137005390643 ,  1775582722356360109 ,  2014816128379650570 }, // x^2^636

{ 1737981352078886684 ,  172808937393312855 ,  32751860484369878 ,  176721505504450802 ,  461607831880528944 ,  91219146039160593 ,  1958955853677045759 ,  101916433542134534 ,  2113140816460247505 ,  154946626290569042 ,  706151234589008163 ,  822374518934611321 ,  1891399654020998406 ,  1472571076201733084 ,  69560535377121433 ,  695120819650416041 ,  492216063147224834 ,  1355390822516643440 ,  2138418821823390039 ,  1544918257190049630 ,  201967835243694480 ,  1745375116769124924 ,  2148061087496775163 ,  1426641303736026069 ,  1202358995900836591 ,  893060202916198950 ,  363853180466205031 ,  561405157066360438 ,  1264356347966931013 ,  871177251635851295 ,  2165634372672206547 ,  769911065182785676 ,  1365526879626033695 ,  1139083214363056603 ,  920033267322275513 ,  2217252112758029450 ,  809066765699361165 ,  1444873310597108050 ,  1772698981502283576 ,  1146566803941396711 ,  1864936057458309908 ,  75242619514471713 ,  40036678909254033 ,  1295793816176473472 ,  581698382321768535 ,  1343685504859962479 ,  810104899101006793 ,  1019384797231960714 ,  1237638247307878027 ,  1230015798279468964 ,  1780020378672973051 ,  2090715084501446256 ,  324759457847424515 ,  1141799855191490024 ,  1674509147478623506 ,  2126542539884368894 ,  1167345977355013202 ,  865880128260290685 ,  268606127275761136 ,  211118793472620537 ,  1001724670147569630 ,  465809370215861836 ,  1720653492635995878 ,  1029031171006301521 ,  319688053877195609 ,  796366861863235597 ,  231432903476307250 ,  637326730455166018 ,  273454240221611460 ,  2208247733826810943 ,  1678292287030093762 ,  1641465901078704587 ,  2168634978680523140 ,  435387726341122175 ,  1697079402023102377 ,  114562330261133300 ,  2077026551328541610 ,  1795955893682703526 ,  1382499507878647689 ,  1333398016312140822 ,  257554543934783759 ,  861715184885901491 ,  842442055333449762 ,  1508386646118691304 ,  153150343114833535 ,  648521866718124578 ,  1743638914548566267 ,  1625894317486480697 ,  4568473136180965 ,  1068842715303163710 ,  611966504428551546 ,  2081642182730530752 ,  1001970503592314399 ,  76325677657897601 ,  105534957091897180 ,  254754897400565382 ,  1895762976223701060 ,  185111415478057495 ,  2036930621716185580 ,  1167224672071124703 ,  1762392996615146315 ,  471181242813966962 ,  1632181844423661447 ,  1373084688446982523 ,  1407548758078666773 ,  16251582853012422 ,  735633034228210636 ,  1988093932740924254 ,  2265549889048663161 ,  995288503281470735 ,  1763035088126922471 ,  1308729517118291606 ,  1704643916461842728 ,  371815472147587770 ,  173014945532560993 ,  870744895406492664 ,  888424078332997720 ,  1336744757048339473 ,  2217519649970813771 ,  1365358948388313907 ,  397152822827398929 ,  210035674598385944 ,  1040287648884724756 ,  2200634852601987699 ,  252381476382843298 ,  519302923048735288 ,  1208264628405651266 ,  1087752442480409803 ,  1284217670629191424 ,  944569261828689659 ,  1871322931216292538 ,  2219581221931986799 ,  1333450675910339786 ,  1515100468129416826 ,  603541332011678448 ,  660824604060176511 ,  1883905255453263598 ,  2080986642734622449 ,  1875755182766017682 ,  1382892487709998484 ,  1285784167314779523 ,  1570390992153915426 ,  1373460467245199214 ,  671761421061082820 ,  1190546884864839039 ,  1836589583591386502 ,  1561921981047072068 ,  2107100138003568059 ,  1944017668632732477 ,  6168358336089469 ,  1102378944788452218 ,  962609344158244795 ,  1157721512703952076 ,  212585484737938288 ,  106818244193729661 ,  474784156040570420 ,  2230707577330349763 ,  805535144352388371 ,  717150037492106090 ,  2008643280039828389 ,  2167643020154314814 ,  1781961218129892110 ,  19187211496399485 ,  722715026752311114 ,  117663665818807278 ,  1199013195292386657 ,  874532053031281159 ,  1446038106044117019 ,  2023611202580319003 ,  1373705481548806912 ,  142240534181654710 ,  1373765712548451311 ,  311025031400045375 ,  952951612874037738 ,  1740182603957215115 ,  1231815258994735426 ,  2150990752509209603 ,  1952567497869907901 ,  1041907478562109148 ,  598667323217805139 ,  693681807710890209 ,  532566874089488949 ,  1409295666281491164 ,  1087549359601555198 ,  1922820120257311030 ,  1007033931160978041 ,  183937174806799675 ,  466167065515520779 ,  917306232556969675 ,  1216119031562575467 ,  73073456126253622 ,  577705910227423321 ,  377097851593181655 ,  2148424055624193691 ,  1037311223022944950 ,  1487850020860899032 ,  1858462938123015037 ,  451706594195229627 ,  1128143595768634131 ,  1106770276438476171 ,  175810300264275741 ,  1085171225578597133 ,  1135383737318584111 ,  1366553462284103877 ,  1984470578081606130 ,  1867512166117855493 ,  520261264648230474 ,  1899513469958118422 ,  1193959269171820161 ,  1184579536215345948 ,  2150881561854189803 ,  984457541536533044 ,  894265171801875229 ,  160446509657093612 ,  2183668651025668104 ,  2137361559385818496 ,  1823738562210826492 ,  1923266803894363487 ,  110201953856855845 ,  2177683235342733237 ,  1117236161289458259 ,  742645083791543109 ,  2049122814903486710 ,  1062704621104079790 ,  773974004136080579 ,  380964413545253155 ,  365903255581668115 ,  272202620657973087 ,  1336948021716310179 ,  2301432036157237436 ,  1993892807212624230 ,  476376629355315549 ,  2069377919070645228 ,  1416975407099609358 ,  267145024901082083 ,  1985100793344808529 ,  1030166317803078273 ,  2144826915804410574 ,  1997594120205631422 ,  1155558762054261722 }, // x^2^637

{ 2055161696490890670 ,  1176417825981907804 ,  1240672380826535666 ,  532058595661148706 ,  844424572530228886 ,  2028969959173945511 ,  1232213807542731153 ,  986086825491453794 ,  228224859637936014 ,  1558656070062820208 ,  1958414738327514019 ,  520979781230082570 ,  1398355913181979666 ,  1731098104265077782 ,  819520826753538974 ,  1385256611719398303 ,  48929257825670409 ,  998609663628355799 ,  602073672124163435 ,  1629249849516913966 ,  160479749940788471 ,  72952889182897717 ,  2207157362703769741 ,  1341196369658921755 ,  1033054617084066086 ,  900993172694037110 ,  1222705461048040634 ,  637705870306386433 ,  1237285918643191176 ,  1259403897053538390 ,  1877995691209711381 ,  955242716713602153 ,  1212329965187278206 ,  1925597838780052893 ,  683527602222670165 ,  2148007081637018443 ,  733054465927408081 ,  1079660389676793896 ,  423816626581790197 ,  2002587515034851143 ,  506148233310912018 ,  1618917149885880380 ,  1358237878032075786 ,  1090933013525880355 ,  13264226269324762 ,  2098405378435297666 ,  1083212462324759266 ,  436268460561862329 ,  1888820149272390592 ,  2025641208668137024 ,  1236325445655188476 ,  1729717499330993853 ,  1843747859661855422 ,  1849743786258453778 ,  1090100294645732767 ,  770449852520605883 ,  339703852802611915 ,  1398680315395436103 ,  1259655747348111247 ,  545622933711997467 ,  1102635135676067742 ,  911873447765822538 ,  551321529275597553 ,  1309607981774612772 ,  1380645596278156784 ,  1865933635769483982 ,  1509049918951461370 ,  1954567514866959794 ,  1807017002598686451 ,  881123491685115397 ,  682433141608787257 ,  747135519982932483 ,  1828650820940522283 ,  782477219654998893 ,  1278518048813616579 ,  1171384804730239823 ,  1080715032109402267 ,  53523269773992640 ,  183991617433563563 ,  1501661470390935664 ,  747631527030796371 ,  30509920027329797 ,  692663297091184078 ,  2207051879150191477 ,  266321661790928125 ,  1634881052687279095 ,  944632981277539392 ,  1363335317254747849 ,  706922355740878641 ,  2096015540930848935 ,  31517545581175340 ,  182218729996546438 ,  1693470686008408751 ,  999436114577018740 ,  1314489612044491455 ,  1937385580967113157 ,  1485580546491661024 ,  153818415735100754 ,  565062947481675419 ,  884228375514617512 ,  839540836879369110 ,  1923689121589383076 ,  196864613215912635 ,  1415068147837437382 ,  339545879910253847 ,  1828497041086887987 ,  2188463646175273366 ,  584375512363897494 ,  1981753466197574899 ,  1411123467512052155 ,  174019699292607646 ,  1289938935283963105 ,  863682735158785148 ,  481046760046356983 ,  2078658779823242479 ,  1041010935512371657 ,  1812185025013933910 ,  1457900666706905545 ,  172286815335337355 ,  1548053884787063254 ,  2232291147365120334 ,  2127892242329079483 ,  200607868080372459 ,  203980565539411412 ,  1335928479882538958 ,  396784325743775575 ,  1810704129174144899 ,  1701190292961949680 ,  1922305362218522734 ,  1907053398210035726 ,  1251536754516051189 ,  1174001091855699400 ,  757833568760780486 ,  109241615605980434 ,  370688732301417000 ,  931067118956558358 ,  624070951163192415 ,  986108686234972907 ,  478117671652356844 ,  873631721731906619 ,  1890158529733963181 ,  1211793866994732726 ,  155606582601718920 ,  1111763421775560820 ,  301577963895890160 ,  637796626545438415 ,  1963611359087581040 ,  527837967325334199 ,  391067430883731671 ,  1986074766851902715 ,  492009788752952190 ,  2008051489583264493 ,  1373042737314036301 ,  1466814226694725167 ,  1285264224202802717 ,  20620391834429832 ,  2249736683763935719 ,  1411095098066850740 ,  1408060566972570322 ,  1047750232995805706 ,  1565937035820328087 ,  168820733446512917 ,  2253765782135377655 ,  792837290036832343 ,  785708910417096612 ,  1949552779900766995 ,  1098615814297850779 ,  2173641630670424404 ,  174729119889540718 ,  315875858719379123 ,  338402122253265099 ,  2249223909027986152 ,  230478266975838589 ,  1479563353406533893 ,  1271105556351772052 ,  1124353373171526356 ,  1498116590260368830 ,  173049474872725767 ,  2094611014896041498 ,  2061555544998475895 ,  402735324809754770 ,  141012509774854520 ,  1868947340465292301 ,  1497434025083174871 ,  136504939541553049 ,  220728143070542229 ,  1483330333332418705 ,  1841934655108277223 ,  989686840455959705 ,  1688731468715266327 ,  1534250526195738653 ,  1706504050924090993 ,  480229365526026041 ,  1638082379813364375 ,  1307565018346124397 ,  647742245412772165 ,  749484436763016351 ,  1126742600121747901 ,  1212786387069103059 ,  2047155864944156677 ,  1881986168101983434 ,  1183125933417522196 ,  289960056778631843 ,  451431228319945873 ,  2075189260944874989 ,  1395337289154958028 ,  1029234358383733727 ,  1608967510167205731 ,  1069937209282349766 ,  53691196603137586 ,  1088646037533380903 ,  2006044229455463181 ,  1286584561089710258 ,  1613879081412908566 ,  1294695902531374648 ,  1994069215253538104 ,  292370789088904691 ,  189048945190357329 ,  1917933680311122086 ,  1264869898416257861 ,  2280010552121810686 ,  115055612869607670 ,  1614986458139563420 ,  919135566986974113 ,  2141020346912308171 ,  1335325991840665529 ,  2287852797347114545 ,  157529633439319799 ,  1147788061870033581 ,  1125912136110488582 ,  449163587096972184 ,  813768508032018547 ,  1951520428001391282 ,  384884793163048314 ,  1975185298974740606 ,  1855902724129168794 ,  2178861560507453111 ,  262033136230747420 ,  838245789821203401 ,  202180506557368058 }, // x^2^638

{ 2245460804731873101 ,  1817378424226792674 ,  1026171409275581664 ,  704429166957845419 ,  759617983192000418 ,  802463831003260053 ,  1928881113355550668 ,  451282503616060956 ,  602530477580463380 ,  1333036424388890167 ,  2151359775693581118 ,  1305788872713404224 ,  1889740231356395358 ,  1815003343548218178 ,  475043346682690478 ,  1552447280703615345 ,  773366894395317340 ,  644179951582227426 ,  971667490738713054 ,  122488897468136252 ,  1871290450453442454 ,  1067160281906152452 ,  825201081046835583 ,  505113830355003776 ,  2203321374424188016 ,  378821356245613786 ,  2012983115169716827 ,  2244502319010933175 ,  867765598678273142 ,  1640218777713327964 ,  1205242039726254185 ,  773119340644544778 ,  770557550256436315 ,  1215278975955843394 ,  1934574523931294257 ,  1082810994670109538 ,  1374173400898625498 ,  2144484112954066605 ,  1688298343423002756 ,  1812107311358899206 ,  2081574191257407617 ,  285014326939341255 ,  1867683926028721163 ,  2206893597368975875 ,  1621824029018969557 ,  438635520691708034 ,  265790302167451727 ,  442272424832907488 ,  2186375023021220028 ,  2201060466790239209 ,  2076995516422134670 ,  1943542059914616733 ,  1946909295324267068 ,  1362496997629036804 ,  51896551052880765 ,  203124502885974040 ,  1542910046488044863 ,  1984005745533399839 ,  1443084820960571618 ,  287102319238430265 ,  552911698153277641 ,  1527666912497226260 ,  930658732958951739 ,  156675856729117184 ,  542415220309584034 ,  746355122683087164 ,  532793598356324924 ,  1088182631831175287 ,  1238473627696762332 ,  1905613423871240732 ,  2192465368494412041 ,  805361950713932157 ,  1890257119030390739 ,  169560681491592809 ,  1797568871166139996 ,  148431529668577855 ,  872759218640060761 ,  1408195232811663317 ,  2052428302870410482 ,  1113643877081734269 ,  687233359989524550 ,  706338960766824272 ,  1664401319234916984 ,  2068445263610495865 ,  418869369376368326 ,  798667762065595697 ,  482051976044538203 ,  1597436223439092571 ,  1623757191067853546 ,  1761604026997462263 ,  1551776131129839035 ,  1667273805654088110 ,  2068808677449360215 ,  346746663592953566 ,  1823996055578423952 ,  1082035065708484641 ,  1007479028107704725 ,  68100044383573938 ,  490114456368782424 ,  1055301063259481207 ,  1757077853674068272 ,  2235856717198433474 ,  332023248266810576 ,  2159980616631525421 ,  615636754368925295 ,  934741603787935736 ,  1222020641312764525 ,  1109963473416601171 ,  1170368112447611328 ,  227017556754742246 ,  869638184198582757 ,  2259644708933288879 ,  565671543579519501 ,  989865884455563618 ,  2122153989331237955 ,  275471413197831329 ,  332958223008656939 ,  442988929272188118 ,  1557939648558109658 ,  1258271645621539135 ,  107764783199242845 ,  1286949298814373421 ,  2240710056274371841 ,  1004647512382092701 ,  339401352341039132 ,  1072052349457229233 ,  2255601973091025166 ,  1782504280170922543 ,  1507073370405294335 ,  1553591561280472153 ,  174353416239609050 ,  463579270209438524 ,  467321404619294258 ,  661263883013490371 ,  1224764454731725958 ,  588935734058745534 ,  1344695598725165658 ,  1777384087079316585 ,  1203322245906378253 ,  1844403793859023347 ,  1877197565029406183 ,  2162918400230404188 ,  702747583089621735 ,  1835496939437021739 ,  1820891139420854367 ,  521634642180702418 ,  976802986855517207 ,  736685163236130131 ,  547212098008375695 ,  476291845696656259 ,  1631193671341693969 ,  162335586917561076 ,  1528842295089585644 ,  1597229754205009301 ,  1938527597726981875 ,  1823419986424781981 ,  738366579237710340 ,  1711413025111638726 ,  1840519449584362560 ,  2099124465245653701 ,  383005862566029087 ,  762012999203688795 ,  1747167218828506754 ,  378123844131345312 ,  1820032296026666518 ,  1246627596396792236 ,  1235906200613602773 ,  658224779945930581 ,  736066745930379717 ,  2241367367674796408 ,  1173995963512068591 ,  1741182661968549734 ,  1492708075958732008 ,  1686517983833430904 ,  906250321736158713 ,  1339365686912470194 ,  1879085699961690118 ,  209304287567105483 ,  2075041167245300233 ,  1489343376436921989 ,  834725875758065376 ,  2156373337451410004 ,  696598773874239299 ,  35474008792765273 ,  533503827891689582 ,  1796659961806839303 ,  454845860214930642 ,  595687474064923980 ,  1672382229353141441 ,  439510534943114235 ,  2065593682644137046 ,  1598379997365010831 ,  1912991708289453652 ,  1001031520670479088 ,  2300722268973389402 ,  1254243778617459867 ,  815920652420227908 ,  1021632245762735028 ,  535853489945802352 ,  2248346316168353658 ,  2221443837372672300 ,  1128153655286212723 ,  1902519694957633044 ,  1952163748007069706 ,  591427807856890450 ,  488351242990329245 ,  2253709029242222514 ,  35860003077664540 ,  897546740696043680 ,  1376901702853189211 ,  1733727583658792648 ,  764001575896850775 ,  737234901454163148 ,  103017824253788800 ,  1115487395946711837 ,  377558825413175935 ,  1742416484251711124 ,  2201164526937101096 ,  1728200884225659218 ,  649131498183802884 ,  1372280392344625734 ,  1096786113678563201 ,  472922617366685899 ,  848558679373872061 ,  183099922842080058 ,  557064379589734762 ,  1579845886109509950 ,  1942440637073682641 ,  523518674475143609 ,  1438019049905441363 ,  2055266403766830020 ,  356204211397779686 ,  1135230809152067027 ,  1896526426927369272 ,  710802074587909850 ,  52710367160691927 ,  1851836649945433725 ,  153439342277705250 ,  391154822917528378 ,  1283748732135484512 } // x^2^639
};


