from hestia_earth.schema import EmissionMethodTier

from hestia_earth.models.log import logger
from hestia_earth.models.utils.product import get_animal_product_N_total
from hestia_earth.models.utils.emission import _new_emission
from . import MODEL
from .noxToAirAllOrigins import _should_run, _get_value

TERM_ID = 'noxToAirExcreta'


def _emission(value: float):
    logger.info('model=%s, term=%s, value=%s', MODEL, TERM_ID, value)
    emission = _new_emission(TERM_ID, MODEL)
    emission['value'] = [value]
    emission['methodTier'] = EmissionMethodTier.TIER_2.value
    return emission


def _run(cycle: dict, ecoClimateZone: str, nitrogenContent: float, N_total: float):
    noxToAirAllOrigins = _get_value(ecoClimateZone, nitrogenContent, N_total)
    value = get_animal_product_N_total(cycle)
    return [_emission(value * noxToAirAllOrigins / N_total)]


def run(cycle: dict):
    should_run, ecoClimateZone, nitrogenContent, N_total, *args = _should_run(cycle)
    return _run(cycle, ecoClimateZone, nitrogenContent, N_total) if should_run else []
